# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2013 Kristian Høgsberg
# Copyright © 2013      Rafael Antognolli
# Copyright © 2013      Jasper St. Pierre
# Copyright © 2010-2013 Intel Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)
from ..wayland import WlSeat
from ..wayland import WlSurface
from ..xdg_shell import XdgPopup
from ..xdg_shell import XdgSurface


class XdgShell(Interface):
    """Create desktop-style surfaces

    :class:`XdgShell` allows clients to turn a
    :class:`~pywayland.protocol.wayland.WlSurface` into a "real window" which
    can be dragged, resized, stacked, and moved around by the user. Everything
    about this interface is suited towards traditional desktop environments.
    """

    name = "xdg_shell"
    version = 1

    class version_(enum.IntEnum):
        current = 5

    class error(enum.IntEnum):
        role = 0
        defunct_surfaces = 1
        not_the_topmost_popup = 2
        invalid_popup_parent = 3


class XdgShellProxy(Proxy[XdgShell]):
    interface = XdgShell

    @XdgShell.request()
    def destroy(self) -> None:
        """Destroy :class:`XdgShell`

        Destroy this :class:`XdgShell` object.

        Destroying a bound :class:`XdgShell` object while there are surfaces
        still alive created by this :class:`XdgShell` object instance is
        illegal and will result in a protocol error.
        """
        self._marshal(0)
        self._destroy()

    @XdgShell.request(
        Argument(ArgumentType.Int),
    )
    def use_unstable_version(self, version: int) -> None:
        """Enable use of this unstable version

        Negotiate the unstable version of the interface.  This mechanism is in
        place to ensure client and server agree on the unstable versions of the
        protocol that they speak or exit cleanly if they don't agree.  This
        request will go away once the xdg-shell protocol is stable.

        :param version:
        :type version:
            `ArgumentType.Int`
        """
        self._marshal(1, version)

    @XdgShell.request(
        Argument(ArgumentType.NewId, interface=XdgSurface),
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def get_xdg_surface(self, surface: WlSurface) -> Proxy[XdgSurface]:
        """Create a shell surface from a surface

        This creates an :class:`~pywayland.protocol.xdg_shell.XdgSurface` for
        the given surface and gives it the
        :class:`~pywayland.protocol.xdg_shell.XdgSurface` role. A
        :class:`~pywayland.protocol.wayland.WlSurface` can only be given an
        :class:`~pywayland.protocol.xdg_shell.XdgSurface` role once. If
        get_xdg_surface is called with a
        :class:`~pywayland.protocol.wayland.WlSurface` that already has an
        active :class:`~pywayland.protocol.xdg_shell.XdgSurface` associated
        with it, or if it had any other role, an error is raised.

        See the documentation of
        :class:`~pywayland.protocol.xdg_shell.XdgSurface` for more details
        about what an :class:`~pywayland.protocol.xdg_shell.XdgSurface` is and
        how it is used.

        :param surface:
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :returns:
            :class:`~pywayland.protocol.xdg_shell.XdgSurface`
        """
        id = self._marshal_constructor(2, XdgSurface, surface)
        return id

    @XdgShell.request(
        Argument(ArgumentType.NewId, interface=XdgPopup),
        Argument(ArgumentType.Object, interface=WlSurface),
        Argument(ArgumentType.Object, interface=WlSurface),
        Argument(ArgumentType.Object, interface=WlSeat),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def get_xdg_popup(self, surface: WlSurface, parent: WlSurface, seat: WlSeat, serial: int, x: int, y: int) -> Proxy[XdgPopup]:
        """Create a popup for a surface

        This creates an :class:`~pywayland.protocol.xdg_shell.XdgPopup` for the
        given surface and gives it the
        :class:`~pywayland.protocol.xdg_shell.XdgPopup` role. A
        :class:`~pywayland.protocol.wayland.WlSurface` can only be given an
        :class:`~pywayland.protocol.xdg_shell.XdgPopup` role once. If
        get_xdg_popup is called with a
        :class:`~pywayland.protocol.wayland.WlSurface` that already has an
        active :class:`~pywayland.protocol.xdg_shell.XdgPopup` associated with
        it, or if it had any other role, an error is raised.

        This request must be used in response to some sort of user action like
        a button press, key press, or touch down event.

        See the documentation of
        :class:`~pywayland.protocol.xdg_shell.XdgPopup` for more details about
        what an :class:`~pywayland.protocol.xdg_shell.XdgPopup` is and how it
        is used.

        :param surface:
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :param parent:
        :type parent:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :param seat:
            the :class:`~pywayland.protocol.wayland.WlSeat` of the user event
        :type seat:
            :class:`~pywayland.protocol.wayland.WlSeat`
        :param serial:
            the serial of the user event
        :type serial:
            `ArgumentType.Uint`
        :param x:
        :type x:
            `ArgumentType.Int`
        :param y:
        :type y:
            `ArgumentType.Int`
        :returns:
            :class:`~pywayland.protocol.xdg_shell.XdgPopup`
        """
        id = self._marshal_constructor(3, XdgPopup, surface, parent, seat, serial, x, y)
        return id

    @XdgShell.request(
        Argument(ArgumentType.Uint),
    )
    def pong(self, serial: int) -> None:
        """Respond to a ping event

        A client must respond to a ping event with a pong request or the client
        may be deemed unresponsive.

        :param serial:
            serial of the ping event
        :type serial:
            `ArgumentType.Uint`
        """
        self._marshal(4, serial)


class XdgShellResource(Resource):
    interface = XdgShell

    @XdgShell.event(
        Argument(ArgumentType.Uint),
    )
    def ping(self, serial: int) -> None:
        """Check if the client is alive

        The ping event asks the client if it's still alive. Pass the serial
        specified in the event back to the compositor by sending a "pong"
        request back with the specified serial.

        Compositors can use this to determine if the client is still alive.
        It's unspecified what will happen if the client doesn't respond to the
        ping request, or in what timeframe. Clients should try to respond in a
        reasonable amount of time.

        A compositor is free to ping in any way it wants, but a client must
        always respond to any :class:`XdgShell` object it created.

        :param serial:
            pass this to the pong request
        :type serial:
            `ArgumentType.Uint`
        """
        self._post_event(0, serial)


class XdgShellGlobal(Global):
    interface = XdgShell


XdgShell._gen_c()
XdgShell.proxy_class = XdgShellProxy
XdgShell.resource_class = XdgShellResource
XdgShell.global_class = XdgShellGlobal
