// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from ATSAMD21E15CU.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

//go:build sam && atsamd21e15cu
// +build sam,atsamd21e15cu

// Microchip ATSAMD21E15CU device: Cortex-M0+ Microcontroller with 32KB Flash, 4KB SRAM, 35-pin package
//
//	Copyright (c) 2018 Microchip Technology Inc.
//
//	SPDX-License-Identifier: Apache-2.0
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//	See the License for the specific language governing permissions and
//	limitations under the License.
package sam

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ATSAMD21E15CU"
	CPU          = "CM0+"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// Power Manager
	IRQ_PM = 0

	// System Control
	IRQ_SYSCTRL = 1

	// Watchdog Timer
	IRQ_WDT = 2

	// Real-Time Counter
	IRQ_RTC = 3

	// External Interrupt Controller
	IRQ_EIC = 4

	// Non-Volatile Memory Controller
	IRQ_NVMCTRL = 5

	// Direct Memory Access Controller
	IRQ_DMAC = 6

	// Universal Serial Bus
	IRQ_USB = 7

	// Event System Interface
	IRQ_EVSYS = 8

	// Serial Communication Interface 0
	IRQ_SERCOM0 = 9

	// Serial Communication Interface 1
	IRQ_SERCOM1 = 10

	// Serial Communication Interface 2
	IRQ_SERCOM2 = 11

	// Serial Communication Interface 3
	IRQ_SERCOM3 = 12

	// Timer Counter Control 0
	IRQ_TCC0 = 15

	// Timer Counter Control 1
	IRQ_TCC1 = 16

	// Timer Counter Control 2
	IRQ_TCC2 = 17

	// Basic Timer Counter 3
	IRQ_TC3 = 18

	// Basic Timer Counter 4
	IRQ_TC4 = 19

	// Basic Timer Counter 5
	IRQ_TC5 = 20

	// Analog Digital Converter
	IRQ_ADC = 23

	// Analog Comparators
	IRQ_AC = 24

	// Digital Analog Converter
	IRQ_DAC = 25

	// Inter-IC Sound Interface
	IRQ_I2S = 27

	// Highest interrupt number on this device.
	IRQ_max = 27
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export PM_IRQHandler
func interruptPM() {
	callHandlers(IRQ_PM)
}

//export SYSCTRL_IRQHandler
func interruptSYSCTRL() {
	callHandlers(IRQ_SYSCTRL)
}

//export WDT_IRQHandler
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export RTC_IRQHandler
func interruptRTC() {
	callHandlers(IRQ_RTC)
}

//export EIC_IRQHandler
func interruptEIC() {
	callHandlers(IRQ_EIC)
}

//export NVMCTRL_IRQHandler
func interruptNVMCTRL() {
	callHandlers(IRQ_NVMCTRL)
}

//export DMAC_IRQHandler
func interruptDMAC() {
	callHandlers(IRQ_DMAC)
}

//export USB_IRQHandler
func interruptUSB() {
	callHandlers(IRQ_USB)
}

//export EVSYS_IRQHandler
func interruptEVSYS() {
	callHandlers(IRQ_EVSYS)
}

//export SERCOM0_IRQHandler
func interruptSERCOM0() {
	callHandlers(IRQ_SERCOM0)
}

//export SERCOM1_IRQHandler
func interruptSERCOM1() {
	callHandlers(IRQ_SERCOM1)
}

//export SERCOM2_IRQHandler
func interruptSERCOM2() {
	callHandlers(IRQ_SERCOM2)
}

//export SERCOM3_IRQHandler
func interruptSERCOM3() {
	callHandlers(IRQ_SERCOM3)
}

//export TCC0_IRQHandler
func interruptTCC0() {
	callHandlers(IRQ_TCC0)
}

//export TCC1_IRQHandler
func interruptTCC1() {
	callHandlers(IRQ_TCC1)
}

//export TCC2_IRQHandler
func interruptTCC2() {
	callHandlers(IRQ_TCC2)
}

//export TC3_IRQHandler
func interruptTC3() {
	callHandlers(IRQ_TC3)
}

//export TC4_IRQHandler
func interruptTC4() {
	callHandlers(IRQ_TC4)
}

//export TC5_IRQHandler
func interruptTC5() {
	callHandlers(IRQ_TC5)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export AC_IRQHandler
func interruptAC() {
	callHandlers(IRQ_AC)
}

//export DAC_IRQHandler
func interruptDAC() {
	callHandlers(IRQ_DAC)
}

//export I2S_IRQHandler
func interruptI2S() {
	callHandlers(IRQ_I2S)
}

// Peripherals.
var (
	// Analog Comparators
	AC = (*AC_Type)(unsafe.Pointer(uintptr(0x42004400)))

	// Analog Digital Converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x42004000)))

	// Digital Analog Converter
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x42004800)))

	// Direct Memory Access Controller
	DMAC = (*DMAC_Type)(unsafe.Pointer(uintptr(0x41004800)))

	// Device Service Unit
	DSU = (*DSU_Type)(unsafe.Pointer(uintptr(0x41002000)))

	// External Interrupt Controller
	EIC = (*EIC_Type)(unsafe.Pointer(uintptr(0x40001800)))

	// Event System Interface
	EVSYS = (*EVSYS_Type)(unsafe.Pointer(uintptr(0x42000400)))

	// Generic Clock Generator
	GCLK = (*GCLK_Type)(unsafe.Pointer(uintptr(0x40000c00)))

	// HSB Matrix
	HMATRIX = (*HMATRIXB_Type)(unsafe.Pointer(uintptr(0x41007000)))

	// Inter-IC Sound Interface
	I2S = (*I2S_Type)(unsafe.Pointer(uintptr(0x42005000)))

	// Cortex-M0+ Micro-Trace Buffer
	MTB = (*MTB_Type)(unsafe.Pointer(uintptr(0x41006000)))

	// Non-Volatile Memory Controller
	NVMCTRL = (*NVMCTRL_Type)(unsafe.Pointer(uintptr(0x41004000)))

	// Peripheral Access Controller 0
	PAC0 = (*PAC_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Power Manager
	PM = (*PM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// Port Module
	PORT = (*PORT_Type)(unsafe.Pointer(uintptr(0x41004400)))

	// Port Module (IOBUS)
	PORT_IOBUS = (*PORT_Type)(unsafe.Pointer(uintptr(0x60000000)))

	// Real-Time Counter
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// Real-Time Counter - MODE0
	RTC_MODE0 = (*RTC_MODE0_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// Real-Time Counter - MODE1
	RTC_MODE1 = (*RTC_MODE1_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// Real-Time Counter - MODE2
	RTC_MODE2 = (*RTC_MODE2_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// Serial Communication Interface 0
	SERCOM0 = (*SERCOM_Type)(unsafe.Pointer(uintptr(0x42000800)))

	// Serial Communication Interface 0 - I2CM
	SERCOM0_I2CM = (*SERCOM_I2CM_Type)(unsafe.Pointer(uintptr(0x42000800)))

	// Serial Communication Interface 0 - I2CS
	SERCOM0_I2CS = (*SERCOM_I2CS_Type)(unsafe.Pointer(uintptr(0x42000800)))

	// Serial Communication Interface 0 - SPI
	SERCOM0_SPI = (*SERCOM_SPI_Type)(unsafe.Pointer(uintptr(0x42000800)))

	// Serial Communication Interface 0 - USART
	SERCOM0_USART = (*SERCOM_USART_Type)(unsafe.Pointer(uintptr(0x42000800)))

	// System Control
	SYSCTRL = (*SYSCTRL_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// Basic Timer Counter 3
	TC3 = (*TC_Type)(unsafe.Pointer(uintptr(0x42002c00)))

	// Basic Timer Counter 3 - COUNT8
	TC3_COUNT8 = (*TC_COUNT8_Type)(unsafe.Pointer(uintptr(0x42002c00)))

	// Basic Timer Counter 3 - COUNT16
	TC3_COUNT16 = (*TC_COUNT16_Type)(unsafe.Pointer(uintptr(0x42002c00)))

	// Basic Timer Counter 3 - COUNT32
	TC3_COUNT32 = (*TC_COUNT32_Type)(unsafe.Pointer(uintptr(0x42002c00)))

	// Timer Counter Control 0
	TCC0 = (*TCC_Type)(unsafe.Pointer(uintptr(0x42002000)))

	// Universal Serial Bus
	USB = (*USB_Type)(unsafe.Pointer(uintptr(0x41005000)))

	// Universal Serial Bus - DEVICE
	USB_DEVICE = (*USB_DEVICE_Type)(unsafe.Pointer(uintptr(0x41005000)))

	// Universal Serial Bus - HOST
	USB_HOST = (*USB_HOST_Type)(unsafe.Pointer(uintptr(0x41005000)))

	// Watchdog Timer
	WDT = (*WDT_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// Peripheral Access Controller 1
	PAC1 = (*PAC_Type)(unsafe.Pointer(uintptr(0x41000000)))

	// Peripheral Access Controller 2
	PAC2 = (*PAC_Type)(unsafe.Pointer(uintptr(0x42000000)))

	// Serial Communication Interface 1
	SERCOM1 = (*SERCOM_Type)(unsafe.Pointer(uintptr(0x42000c00)))

	// Serial Communication Interface 0 - I2CM
	SERCOM1_I2CM = (*SERCOM_I2CM_Type)(unsafe.Pointer(uintptr(0x42000c00)))

	// Serial Communication Interface 0 - I2CS
	SERCOM1_I2CS = (*SERCOM_I2CS_Type)(unsafe.Pointer(uintptr(0x42000c00)))

	// Serial Communication Interface 0 - SPI
	SERCOM1_SPI = (*SERCOM_SPI_Type)(unsafe.Pointer(uintptr(0x42000c00)))

	// Serial Communication Interface 0 - USART
	SERCOM1_USART = (*SERCOM_USART_Type)(unsafe.Pointer(uintptr(0x42000c00)))

	// Serial Communication Interface 2
	SERCOM2 = (*SERCOM_Type)(unsafe.Pointer(uintptr(0x42001000)))

	// Serial Communication Interface 0 - I2CM
	SERCOM2_I2CM = (*SERCOM_I2CM_Type)(unsafe.Pointer(uintptr(0x42001000)))

	// Serial Communication Interface 0 - I2CS
	SERCOM2_I2CS = (*SERCOM_I2CS_Type)(unsafe.Pointer(uintptr(0x42001000)))

	// Serial Communication Interface 0 - SPI
	SERCOM2_SPI = (*SERCOM_SPI_Type)(unsafe.Pointer(uintptr(0x42001000)))

	// Serial Communication Interface 0 - USART
	SERCOM2_USART = (*SERCOM_USART_Type)(unsafe.Pointer(uintptr(0x42001000)))

	// Serial Communication Interface 3
	SERCOM3 = (*SERCOM_Type)(unsafe.Pointer(uintptr(0x42001400)))

	// Serial Communication Interface 0 - I2CM
	SERCOM3_I2CM = (*SERCOM_I2CM_Type)(unsafe.Pointer(uintptr(0x42001400)))

	// Serial Communication Interface 0 - I2CS
	SERCOM3_I2CS = (*SERCOM_I2CS_Type)(unsafe.Pointer(uintptr(0x42001400)))

	// Serial Communication Interface 0 - SPI
	SERCOM3_SPI = (*SERCOM_SPI_Type)(unsafe.Pointer(uintptr(0x42001400)))

	// Serial Communication Interface 0 - USART
	SERCOM3_USART = (*SERCOM_USART_Type)(unsafe.Pointer(uintptr(0x42001400)))

	// Basic Timer Counter 4
	TC4 = (*TC_Type)(unsafe.Pointer(uintptr(0x42003000)))

	// Basic Timer Counter 3 - COUNT8
	TC4_COUNT8 = (*TC_COUNT8_Type)(unsafe.Pointer(uintptr(0x42003000)))

	// Basic Timer Counter 3 - COUNT16
	TC4_COUNT16 = (*TC_COUNT16_Type)(unsafe.Pointer(uintptr(0x42003000)))

	// Basic Timer Counter 3 - COUNT32
	TC4_COUNT32 = (*TC_COUNT32_Type)(unsafe.Pointer(uintptr(0x42003000)))

	// Basic Timer Counter 5
	TC5 = (*TC_Type)(unsafe.Pointer(uintptr(0x42003400)))

	// Basic Timer Counter 3 - COUNT8
	TC5_COUNT8 = (*TC_COUNT8_Type)(unsafe.Pointer(uintptr(0x42003400)))

	// Basic Timer Counter 3 - COUNT16
	TC5_COUNT16 = (*TC_COUNT16_Type)(unsafe.Pointer(uintptr(0x42003400)))

	// Basic Timer Counter 3 - COUNT32
	TC5_COUNT32 = (*TC_COUNT32_Type)(unsafe.Pointer(uintptr(0x42003400)))

	// Timer Counter Control 1
	TCC1 = (*TCC_Type)(unsafe.Pointer(uintptr(0x42002400)))

	// Timer Counter Control 2
	TCC2 = (*TCC_Type)(unsafe.Pointer(uintptr(0x42002800)))
)

// Analog Comparators
type AC_Type struct {
	CTRLA     volatile.Register8  // 0x0
	CTRLB     volatile.Register8  // 0x1
	EVCTRL    volatile.Register16 // 0x2
	INTENCLR  volatile.Register8  // 0x4
	INTENSET  volatile.Register8  // 0x5
	INTFLAG   volatile.Register8  // 0x6
	_         byte
	STATUSA   volatile.Register8 // 0x8
	STATUSB   volatile.Register8 // 0x9
	STATUSC   volatile.Register8 // 0xA
	_         byte
	WINCTRL   volatile.Register8 // 0xC
	_         [3]byte
	COMPCTRL0 volatile.Register32 // 0x10
	COMPCTRL1 volatile.Register32 // 0x14
	_         [8]byte
	SCALER0   volatile.Register8 // 0x20
	SCALER1   volatile.Register8 // 0x21
}

// AC.CTRLA: Control A
func (o *AC_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}
func (o *AC_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetCTRLA_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x4)|value<<2)
}
func (o *AC_Type) GetCTRLA_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x4) >> 2
}
func (o *AC_Type) SetCTRLA_LPMUX(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *AC_Type) GetCTRLA_LPMUX() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x80) >> 7
}

// AC.CTRLB: Control B
func (o *AC_Type) SetCTRLB_START0(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetCTRLB_START0() uint8 {
	return volatile.LoadUint8(&o.CTRLB.Reg) & 0x1
}
func (o *AC_Type) SetCTRLB_START1(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetCTRLB_START1() uint8 {
	return (volatile.LoadUint8(&o.CTRLB.Reg) & 0x2) >> 1
}

// AC.EVCTRL: Event Control
func (o *AC_Type) SetEVCTRL_COMPEO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetEVCTRL_COMPEO0() uint16 {
	return volatile.LoadUint16(&o.EVCTRL.Reg) & 0x1
}
func (o *AC_Type) SetEVCTRL_COMPEO1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetEVCTRL_COMPEO1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetEVCTRL_WINEO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *AC_Type) GetEVCTRL_WINEO0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *AC_Type) SetEVCTRL_COMPEI0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *AC_Type) GetEVCTRL_COMPEI0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *AC_Type) SetEVCTRL_COMPEI1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x200)|value<<9)
}
func (o *AC_Type) GetEVCTRL_COMPEI1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x200) >> 9
}

// AC.INTENCLR: Interrupt Enable Clear
func (o *AC_Type) SetINTENCLR_COMP0(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetINTENCLR_COMP0() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *AC_Type) SetINTENCLR_COMP1(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetINTENCLR_COMP1() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetINTENCLR_WIN0(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *AC_Type) GetINTENCLR_WIN0() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x10) >> 4
}

// AC.INTENSET: Interrupt Enable Set
func (o *AC_Type) SetINTENSET_COMP0(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetINTENSET_COMP0() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *AC_Type) SetINTENSET_COMP1(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetINTENSET_COMP1() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetINTENSET_WIN0(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *AC_Type) GetINTENSET_WIN0() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x10) >> 4
}

// AC.INTFLAG: Interrupt Flag Status and Clear
func (o *AC_Type) SetINTFLAG_COMP0(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetINTFLAG_COMP0() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *AC_Type) SetINTFLAG_COMP1(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetINTFLAG_COMP1() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetINTFLAG_WIN0(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *AC_Type) GetINTFLAG_WIN0() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x10) >> 4
}

// AC.STATUSA: Status A
func (o *AC_Type) SetSTATUSA_STATE0(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetSTATUSA_STATE0() uint8 {
	return volatile.LoadUint8(&o.STATUSA.Reg) & 0x1
}
func (o *AC_Type) SetSTATUSA_STATE1(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetSTATUSA_STATE1() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetSTATUSA_WSTATE0(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x30)|value<<4)
}
func (o *AC_Type) GetSTATUSA_WSTATE0() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x30) >> 4
}

// AC.STATUSB: Status B
func (o *AC_Type) SetSTATUSB_READY0(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetSTATUSB_READY0() uint8 {
	return volatile.LoadUint8(&o.STATUSB.Reg) & 0x1
}
func (o *AC_Type) SetSTATUSB_READY1(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetSTATUSB_READY1() uint8 {
	return (volatile.LoadUint8(&o.STATUSB.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetSTATUSB_SYNCBUSY(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x80)|value<<7)
}
func (o *AC_Type) GetSTATUSB_SYNCBUSY() uint8 {
	return (volatile.LoadUint8(&o.STATUSB.Reg) & 0x80) >> 7
}

// AC.STATUSC: Status C
func (o *AC_Type) SetSTATUSC_STATE0(value uint8) {
	volatile.StoreUint8(&o.STATUSC.Reg, volatile.LoadUint8(&o.STATUSC.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetSTATUSC_STATE0() uint8 {
	return volatile.LoadUint8(&o.STATUSC.Reg) & 0x1
}
func (o *AC_Type) SetSTATUSC_STATE1(value uint8) {
	volatile.StoreUint8(&o.STATUSC.Reg, volatile.LoadUint8(&o.STATUSC.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetSTATUSC_STATE1() uint8 {
	return (volatile.LoadUint8(&o.STATUSC.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetSTATUSC_WSTATE0(value uint8) {
	volatile.StoreUint8(&o.STATUSC.Reg, volatile.LoadUint8(&o.STATUSC.Reg)&^(0x30)|value<<4)
}
func (o *AC_Type) GetSTATUSC_WSTATE0() uint8 {
	return (volatile.LoadUint8(&o.STATUSC.Reg) & 0x30) >> 4
}

// AC.WINCTRL: Window Control
func (o *AC_Type) SetWINCTRL_WEN0(value uint8) {
	volatile.StoreUint8(&o.WINCTRL.Reg, volatile.LoadUint8(&o.WINCTRL.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetWINCTRL_WEN0() uint8 {
	return volatile.LoadUint8(&o.WINCTRL.Reg) & 0x1
}
func (o *AC_Type) SetWINCTRL_WINTSEL0(value uint8) {
	volatile.StoreUint8(&o.WINCTRL.Reg, volatile.LoadUint8(&o.WINCTRL.Reg)&^(0x6)|value<<1)
}
func (o *AC_Type) GetWINCTRL_WINTSEL0() uint8 {
	return (volatile.LoadUint8(&o.WINCTRL.Reg) & 0x6) >> 1
}

// AC.COMPCTRL0: Comparator Control n
func (o *AC_Type) SetCOMPCTRL0_ENABLE(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetCOMPCTRL0_ENABLE() uint32 {
	return volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x1
}
func (o *AC_Type) SetCOMPCTRL0_SINGLE(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetCOMPCTRL0_SINGLE() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetCOMPCTRL0_SPEED(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0xc)|value<<2)
}
func (o *AC_Type) GetCOMPCTRL0_SPEED() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0xc) >> 2
}
func (o *AC_Type) SetCOMPCTRL0_INTSEL(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x60)|value<<5)
}
func (o *AC_Type) GetCOMPCTRL0_INTSEL() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x60) >> 5
}
func (o *AC_Type) SetCOMPCTRL0_MUXNEG(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x700)|value<<8)
}
func (o *AC_Type) GetCOMPCTRL0_MUXNEG() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x700) >> 8
}
func (o *AC_Type) SetCOMPCTRL0_MUXPOS(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x3000)|value<<12)
}
func (o *AC_Type) GetCOMPCTRL0_MUXPOS() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x3000) >> 12
}
func (o *AC_Type) SetCOMPCTRL0_SWAP(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x8000)|value<<15)
}
func (o *AC_Type) GetCOMPCTRL0_SWAP() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x8000) >> 15
}
func (o *AC_Type) SetCOMPCTRL0_OUT(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x30000)|value<<16)
}
func (o *AC_Type) GetCOMPCTRL0_OUT() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x30000) >> 16
}
func (o *AC_Type) SetCOMPCTRL0_HYST(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x80000)|value<<19)
}
func (o *AC_Type) GetCOMPCTRL0_HYST() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x80000) >> 19
}
func (o *AC_Type) SetCOMPCTRL0_FLEN(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x7000000)|value<<24)
}
func (o *AC_Type) GetCOMPCTRL0_FLEN() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x7000000) >> 24
}

// AC.COMPCTRL1: Comparator Control n
func (o *AC_Type) SetCOMPCTRL1_ENABLE(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetCOMPCTRL1_ENABLE() uint32 {
	return volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x1
}
func (o *AC_Type) SetCOMPCTRL1_SINGLE(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetCOMPCTRL1_SINGLE() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetCOMPCTRL1_SPEED(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0xc)|value<<2)
}
func (o *AC_Type) GetCOMPCTRL1_SPEED() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0xc) >> 2
}
func (o *AC_Type) SetCOMPCTRL1_INTSEL(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x60)|value<<5)
}
func (o *AC_Type) GetCOMPCTRL1_INTSEL() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x60) >> 5
}
func (o *AC_Type) SetCOMPCTRL1_MUXNEG(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x700)|value<<8)
}
func (o *AC_Type) GetCOMPCTRL1_MUXNEG() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x700) >> 8
}
func (o *AC_Type) SetCOMPCTRL1_MUXPOS(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x3000)|value<<12)
}
func (o *AC_Type) GetCOMPCTRL1_MUXPOS() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x3000) >> 12
}
func (o *AC_Type) SetCOMPCTRL1_SWAP(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x8000)|value<<15)
}
func (o *AC_Type) GetCOMPCTRL1_SWAP() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x8000) >> 15
}
func (o *AC_Type) SetCOMPCTRL1_OUT(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x30000)|value<<16)
}
func (o *AC_Type) GetCOMPCTRL1_OUT() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x30000) >> 16
}
func (o *AC_Type) SetCOMPCTRL1_HYST(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x80000)|value<<19)
}
func (o *AC_Type) GetCOMPCTRL1_HYST() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x80000) >> 19
}
func (o *AC_Type) SetCOMPCTRL1_FLEN(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x7000000)|value<<24)
}
func (o *AC_Type) GetCOMPCTRL1_FLEN() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x7000000) >> 24
}

// AC.SCALER0: Scaler n
func (o *AC_Type) SetSCALER0_VALUE(value uint8) {
	volatile.StoreUint8(&o.SCALER0.Reg, volatile.LoadUint8(&o.SCALER0.Reg)&^(0x3f)|value)
}
func (o *AC_Type) GetSCALER0_VALUE() uint8 {
	return volatile.LoadUint8(&o.SCALER0.Reg) & 0x3f
}

// AC.SCALER1: Scaler n
func (o *AC_Type) SetSCALER1_VALUE(value uint8) {
	volatile.StoreUint8(&o.SCALER1.Reg, volatile.LoadUint8(&o.SCALER1.Reg)&^(0x3f)|value)
}
func (o *AC_Type) GetSCALER1_VALUE() uint8 {
	return volatile.LoadUint8(&o.SCALER1.Reg) & 0x3f
}

// Analog Digital Converter
type ADC_Type struct {
	CTRLA      volatile.Register8  // 0x0
	REFCTRL    volatile.Register8  // 0x1
	AVGCTRL    volatile.Register8  // 0x2
	SAMPCTRL   volatile.Register8  // 0x3
	CTRLB      volatile.Register16 // 0x4
	_          [2]byte
	WINCTRL    volatile.Register8 // 0x8
	_          [3]byte
	SWTRIG     volatile.Register8 // 0xC
	_          [3]byte
	INPUTCTRL  volatile.Register32 // 0x10
	EVCTRL     volatile.Register8  // 0x14
	_          byte
	INTENCLR   volatile.Register8  // 0x16
	INTENSET   volatile.Register8  // 0x17
	INTFLAG    volatile.Register8  // 0x18
	STATUS     volatile.Register8  // 0x19
	RESULT     volatile.Register16 // 0x1A
	WINLT      volatile.Register16 // 0x1C
	_          [2]byte
	WINUT      volatile.Register16 // 0x20
	_          [2]byte
	GAINCORR   volatile.Register16 // 0x24
	OFFSETCORR volatile.Register16 // 0x26
	CALIB      volatile.Register16 // 0x28
	DBGCTRL    volatile.Register8  // 0x2A
}

// ADC.CTRLA: Control A
func (o *ADC_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}
func (o *ADC_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCTRLA_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCTRLA_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x4) >> 2
}

// ADC.REFCTRL: Reference Control
func (o *ADC_Type) SetREFCTRL_REFSEL(value uint8) {
	volatile.StoreUint8(&o.REFCTRL.Reg, volatile.LoadUint8(&o.REFCTRL.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetREFCTRL_REFSEL() uint8 {
	return volatile.LoadUint8(&o.REFCTRL.Reg) & 0xf
}
func (o *ADC_Type) SetREFCTRL_REFCOMP(value uint8) {
	volatile.StoreUint8(&o.REFCTRL.Reg, volatile.LoadUint8(&o.REFCTRL.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetREFCTRL_REFCOMP() uint8 {
	return (volatile.LoadUint8(&o.REFCTRL.Reg) & 0x80) >> 7
}

// ADC.AVGCTRL: Average Control
func (o *ADC_Type) SetAVGCTRL_SAMPLENUM(value uint8) {
	volatile.StoreUint8(&o.AVGCTRL.Reg, volatile.LoadUint8(&o.AVGCTRL.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetAVGCTRL_SAMPLENUM() uint8 {
	return volatile.LoadUint8(&o.AVGCTRL.Reg) & 0xf
}
func (o *ADC_Type) SetAVGCTRL_ADJRES(value uint8) {
	volatile.StoreUint8(&o.AVGCTRL.Reg, volatile.LoadUint8(&o.AVGCTRL.Reg)&^(0x70)|value<<4)
}
func (o *ADC_Type) GetAVGCTRL_ADJRES() uint8 {
	return (volatile.LoadUint8(&o.AVGCTRL.Reg) & 0x70) >> 4
}

// ADC.SAMPCTRL: Sampling Time Control
func (o *ADC_Type) SetSAMPCTRL_SAMPLEN(value uint8) {
	volatile.StoreUint8(&o.SAMPCTRL.Reg, volatile.LoadUint8(&o.SAMPCTRL.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetSAMPCTRL_SAMPLEN() uint8 {
	return volatile.LoadUint8(&o.SAMPCTRL.Reg) & 0x3f
}

// ADC.CTRLB: Control B
func (o *ADC_Type) SetCTRLB_DIFFMODE(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCTRLB_DIFFMODE() uint16 {
	return volatile.LoadUint16(&o.CTRLB.Reg) & 0x1
}
func (o *ADC_Type) SetCTRLB_LEFTADJ(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCTRLB_LEFTADJ() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCTRLB_FREERUN(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCTRLB_FREERUN() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCTRLB_CORREN(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCTRLB_CORREN() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCTRLB_RESSEL(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x30)|value<<4)
}
func (o *ADC_Type) GetCTRLB_RESSEL() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x30) >> 4
}
func (o *ADC_Type) SetCTRLB_PRESCALER(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x700)|value<<8)
}
func (o *ADC_Type) GetCTRLB_PRESCALER() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x700) >> 8
}

// ADC.WINCTRL: Window Monitor Control
func (o *ADC_Type) SetWINCTRL_WINMODE(value uint8) {
	volatile.StoreUint8(&o.WINCTRL.Reg, volatile.LoadUint8(&o.WINCTRL.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetWINCTRL_WINMODE() uint8 {
	return volatile.LoadUint8(&o.WINCTRL.Reg) & 0x7
}

// ADC.SWTRIG: Software Trigger
func (o *ADC_Type) SetSWTRIG_FLUSH(value uint8) {
	volatile.StoreUint8(&o.SWTRIG.Reg, volatile.LoadUint8(&o.SWTRIG.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetSWTRIG_FLUSH() uint8 {
	return volatile.LoadUint8(&o.SWTRIG.Reg) & 0x1
}
func (o *ADC_Type) SetSWTRIG_START(value uint8) {
	volatile.StoreUint8(&o.SWTRIG.Reg, volatile.LoadUint8(&o.SWTRIG.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetSWTRIG_START() uint8 {
	return (volatile.LoadUint8(&o.SWTRIG.Reg) & 0x2) >> 1
}

// ADC.INPUTCTRL: Input Control
func (o *ADC_Type) SetINPUTCTRL_MUXPOS(value uint32) {
	volatile.StoreUint32(&o.INPUTCTRL.Reg, volatile.LoadUint32(&o.INPUTCTRL.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetINPUTCTRL_MUXPOS() uint32 {
	return volatile.LoadUint32(&o.INPUTCTRL.Reg) & 0x1f
}
func (o *ADC_Type) SetINPUTCTRL_MUXNEG(value uint32) {
	volatile.StoreUint32(&o.INPUTCTRL.Reg, volatile.LoadUint32(&o.INPUTCTRL.Reg)&^(0x1f00)|value<<8)
}
func (o *ADC_Type) GetINPUTCTRL_MUXNEG() uint32 {
	return (volatile.LoadUint32(&o.INPUTCTRL.Reg) & 0x1f00) >> 8
}
func (o *ADC_Type) SetINPUTCTRL_INPUTSCAN(value uint32) {
	volatile.StoreUint32(&o.INPUTCTRL.Reg, volatile.LoadUint32(&o.INPUTCTRL.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetINPUTCTRL_INPUTSCAN() uint32 {
	return (volatile.LoadUint32(&o.INPUTCTRL.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetINPUTCTRL_INPUTOFFSET(value uint32) {
	volatile.StoreUint32(&o.INPUTCTRL.Reg, volatile.LoadUint32(&o.INPUTCTRL.Reg)&^(0xf00000)|value<<20)
}
func (o *ADC_Type) GetINPUTCTRL_INPUTOFFSET() uint32 {
	return (volatile.LoadUint32(&o.INPUTCTRL.Reg) & 0xf00000) >> 20
}
func (o *ADC_Type) SetINPUTCTRL_GAIN(value uint32) {
	volatile.StoreUint32(&o.INPUTCTRL.Reg, volatile.LoadUint32(&o.INPUTCTRL.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetINPUTCTRL_GAIN() uint32 {
	return (volatile.LoadUint32(&o.INPUTCTRL.Reg) & 0xf000000) >> 24
}

// ADC.EVCTRL: Event Control
func (o *ADC_Type) SetEVCTRL_STARTEI(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetEVCTRL_STARTEI() uint8 {
	return volatile.LoadUint8(&o.EVCTRL.Reg) & 0x1
}
func (o *ADC_Type) SetEVCTRL_SYNCEI(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetEVCTRL_SYNCEI() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetEVCTRL_RESRDYEO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetEVCTRL_RESRDYEO() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetEVCTRL_WINMONEO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetEVCTRL_WINMONEO() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x20) >> 5
}

// ADC.INTENCLR: Interrupt Enable Clear
func (o *ADC_Type) SetINTENCLR_RESRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetINTENCLR_RESRDY() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *ADC_Type) SetINTENCLR_OVERRUN(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetINTENCLR_OVERRUN() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetINTENCLR_WINMON(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetINTENCLR_WINMON() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetINTENCLR_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetINTENCLR_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x8) >> 3
}

// ADC.INTENSET: Interrupt Enable Set
func (o *ADC_Type) SetINTENSET_RESRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetINTENSET_RESRDY() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *ADC_Type) SetINTENSET_OVERRUN(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetINTENSET_OVERRUN() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetINTENSET_WINMON(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetINTENSET_WINMON() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetINTENSET_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetINTENSET_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x8) >> 3
}

// ADC.INTFLAG: Interrupt Flag Status and Clear
func (o *ADC_Type) SetINTFLAG_RESRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetINTFLAG_RESRDY() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *ADC_Type) SetINTFLAG_OVERRUN(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetINTFLAG_OVERRUN() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetINTFLAG_WINMON(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetINTFLAG_WINMON() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetINTFLAG_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetINTFLAG_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x8) >> 3
}

// ADC.STATUS: Status
func (o *ADC_Type) SetSTATUS_SYNCBUSY(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetSTATUS_SYNCBUSY() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x80) >> 7
}

// ADC.RESULT: Result
func (o *ADC_Type) SetRESULT(value uint16) {
	volatile.StoreUint16(&o.RESULT.Reg, value)
}
func (o *ADC_Type) GetRESULT() uint16 {
	return volatile.LoadUint16(&o.RESULT.Reg)
}

// ADC.WINLT: Window Monitor Lower Threshold
func (o *ADC_Type) SetWINLT(value uint16) {
	volatile.StoreUint16(&o.WINLT.Reg, value)
}
func (o *ADC_Type) GetWINLT() uint16 {
	return volatile.LoadUint16(&o.WINLT.Reg)
}

// ADC.WINUT: Window Monitor Upper Threshold
func (o *ADC_Type) SetWINUT(value uint16) {
	volatile.StoreUint16(&o.WINUT.Reg, value)
}
func (o *ADC_Type) GetWINUT() uint16 {
	return volatile.LoadUint16(&o.WINUT.Reg)
}

// ADC.GAINCORR: Gain Correction
func (o *ADC_Type) SetGAINCORR(value uint16) {
	volatile.StoreUint16(&o.GAINCORR.Reg, volatile.LoadUint16(&o.GAINCORR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetGAINCORR() uint16 {
	return volatile.LoadUint16(&o.GAINCORR.Reg) & 0xfff
}

// ADC.OFFSETCORR: Offset Correction
func (o *ADC_Type) SetOFFSETCORR(value uint16) {
	volatile.StoreUint16(&o.OFFSETCORR.Reg, volatile.LoadUint16(&o.OFFSETCORR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFFSETCORR() uint16 {
	return volatile.LoadUint16(&o.OFFSETCORR.Reg) & 0xfff
}

// ADC.CALIB: Calibration
func (o *ADC_Type) SetCALIB_LINEARITY_CAL(value uint16) {
	volatile.StoreUint16(&o.CALIB.Reg, volatile.LoadUint16(&o.CALIB.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetCALIB_LINEARITY_CAL() uint16 {
	return volatile.LoadUint16(&o.CALIB.Reg) & 0xff
}
func (o *ADC_Type) SetCALIB_BIAS_CAL(value uint16) {
	volatile.StoreUint16(&o.CALIB.Reg, volatile.LoadUint16(&o.CALIB.Reg)&^(0x700)|value<<8)
}
func (o *ADC_Type) GetCALIB_BIAS_CAL() uint16 {
	return (volatile.LoadUint16(&o.CALIB.Reg) & 0x700) >> 8
}

// ADC.DBGCTRL: Debug Control
func (o *ADC_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// Digital Analog Converter
type DAC_Type struct {
	CTRLA    volatile.Register8 // 0x0
	CTRLB    volatile.Register8 // 0x1
	EVCTRL   volatile.Register8 // 0x2
	_        byte
	INTENCLR volatile.Register8  // 0x4
	INTENSET volatile.Register8  // 0x5
	INTFLAG  volatile.Register8  // 0x6
	STATUS   volatile.Register8  // 0x7
	DATA     volatile.Register16 // 0x8
	_        [2]byte
	DATABUF  volatile.Register16 // 0xC
}

// DAC.CTRLA: Control A
func (o *DAC_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}
func (o *DAC_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetCTRLA_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x4)|value<<2)
}
func (o *DAC_Type) GetCTRLA_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x4) >> 2
}

// DAC.CTRLB: Control B
func (o *DAC_Type) SetCTRLB_EOEN(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetCTRLB_EOEN() uint8 {
	return volatile.LoadUint8(&o.CTRLB.Reg) & 0x1
}
func (o *DAC_Type) SetCTRLB_IOEN(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetCTRLB_IOEN() uint8 {
	return (volatile.LoadUint8(&o.CTRLB.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetCTRLB_LEFTADJ(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x4)|value<<2)
}
func (o *DAC_Type) GetCTRLB_LEFTADJ() uint8 {
	return (volatile.LoadUint8(&o.CTRLB.Reg) & 0x4) >> 2
}
func (o *DAC_Type) SetCTRLB_VPD(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x8)|value<<3)
}
func (o *DAC_Type) GetCTRLB_VPD() uint8 {
	return (volatile.LoadUint8(&o.CTRLB.Reg) & 0x8) >> 3
}
func (o *DAC_Type) SetCTRLB_BDWP(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x10)|value<<4)
}
func (o *DAC_Type) GetCTRLB_BDWP() uint8 {
	return (volatile.LoadUint8(&o.CTRLB.Reg) & 0x10) >> 4
}
func (o *DAC_Type) SetCTRLB_REFSEL(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0xc0)|value<<6)
}
func (o *DAC_Type) GetCTRLB_REFSEL() uint8 {
	return (volatile.LoadUint8(&o.CTRLB.Reg) & 0xc0) >> 6
}

// DAC.EVCTRL: Event Control
func (o *DAC_Type) SetEVCTRL_STARTEI(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetEVCTRL_STARTEI() uint8 {
	return volatile.LoadUint8(&o.EVCTRL.Reg) & 0x1
}
func (o *DAC_Type) SetEVCTRL_EMPTYEO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetEVCTRL_EMPTYEO() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x2) >> 1
}

// DAC.INTENCLR: Interrupt Enable Clear
func (o *DAC_Type) SetINTENCLR_UNDERRUN(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetINTENCLR_UNDERRUN() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *DAC_Type) SetINTENCLR_EMPTY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetINTENCLR_EMPTY() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetINTENCLR_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *DAC_Type) GetINTENCLR_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x4) >> 2
}

// DAC.INTENSET: Interrupt Enable Set
func (o *DAC_Type) SetINTENSET_UNDERRUN(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetINTENSET_UNDERRUN() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *DAC_Type) SetINTENSET_EMPTY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetINTENSET_EMPTY() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetINTENSET_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *DAC_Type) GetINTENSET_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x4) >> 2
}

// DAC.INTFLAG: Interrupt Flag Status and Clear
func (o *DAC_Type) SetINTFLAG_UNDERRUN(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetINTFLAG_UNDERRUN() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *DAC_Type) SetINTFLAG_EMPTY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetINTFLAG_EMPTY() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetINTFLAG_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *DAC_Type) GetINTFLAG_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x4) >> 2
}

// DAC.STATUS: Status
func (o *DAC_Type) SetSTATUS_SYNCBUSY(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *DAC_Type) GetSTATUS_SYNCBUSY() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x80) >> 7
}

// DAC.DATA: Data
func (o *DAC_Type) SetDATA(value uint16) {
	volatile.StoreUint16(&o.DATA.Reg, value)
}
func (o *DAC_Type) GetDATA() uint16 {
	return volatile.LoadUint16(&o.DATA.Reg)
}

// DAC.DATABUF: Data Buffer
func (o *DAC_Type) SetDATABUF(value uint16) {
	volatile.StoreUint16(&o.DATABUF.Reg, value)
}
func (o *DAC_Type) GetDATABUF() uint16 {
	return volatile.LoadUint16(&o.DATABUF.Reg)
}

// Direct Memory Access Controller
type DMAC_Type struct {
	CTRL       volatile.Register16 // 0x0
	CRCCTRL    volatile.Register16 // 0x2
	CRCDATAIN  volatile.Register32 // 0x4
	CRCCHKSUM  volatile.Register32 // 0x8
	CRCSTATUS  volatile.Register8  // 0xC
	DBGCTRL    volatile.Register8  // 0xD
	QOSCTRL    volatile.Register8  // 0xE
	_          byte
	SWTRIGCTRL volatile.Register32 // 0x10
	PRICTRL0   volatile.Register32 // 0x14
	_          [8]byte
	INTPEND    volatile.Register16 // 0x20
	_          [2]byte
	INTSTATUS  volatile.Register32 // 0x24
	BUSYCH     volatile.Register32 // 0x28
	PENDCH     volatile.Register32 // 0x2C
	ACTIVE     volatile.Register32 // 0x30
	BASEADDR   volatile.Register32 // 0x34
	WRBADDR    volatile.Register32 // 0x38
	_          [3]byte
	CHID       volatile.Register8 // 0x3F
	CHCTRLA    volatile.Register8 // 0x40
	_          [3]byte
	CHCTRLB    volatile.Register32 // 0x44
	_          [4]byte
	CHINTENCLR volatile.Register8 // 0x4C
	CHINTENSET volatile.Register8 // 0x4D
	CHINTFLAG  volatile.Register8 // 0x4E
	CHSTATUS   volatile.Register8 // 0x4F
}

// DMAC.CTRL: Control
func (o *DMAC_Type) SetCTRL_SWRST(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCTRL_SWRST() uint16 {
	return volatile.LoadUint16(&o.CTRL.Reg) & 0x1
}
func (o *DMAC_Type) SetCTRL_DMAENABLE(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCTRL_DMAENABLE() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCTRL_CRCENABLE(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCTRL_CRCENABLE() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCTRL_LVLEN0(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRL_LVLEN0() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRL_LVLEN1(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCTRL_LVLEN1() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCTRL_LVLEN2(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCTRL_LVLEN2() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCTRL_LVLEN3(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCTRL_LVLEN3() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x800) >> 11
}

// DMAC.CRCCTRL: CRC Control
func (o *DMAC_Type) SetCRCCTRL_CRCBEATSIZE(value uint16) {
	volatile.StoreUint16(&o.CRCCTRL.Reg, volatile.LoadUint16(&o.CRCCTRL.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCRCCTRL_CRCBEATSIZE() uint16 {
	return volatile.LoadUint16(&o.CRCCTRL.Reg) & 0x3
}
func (o *DMAC_Type) SetCRCCTRL_CRCPOLY(value uint16) {
	volatile.StoreUint16(&o.CRCCTRL.Reg, volatile.LoadUint16(&o.CRCCTRL.Reg)&^(0xc)|value<<2)
}
func (o *DMAC_Type) GetCRCCTRL_CRCPOLY() uint16 {
	return (volatile.LoadUint16(&o.CRCCTRL.Reg) & 0xc) >> 2
}
func (o *DMAC_Type) SetCRCCTRL_CRCSRC(value uint16) {
	volatile.StoreUint16(&o.CRCCTRL.Reg, volatile.LoadUint16(&o.CRCCTRL.Reg)&^(0x3f00)|value<<8)
}
func (o *DMAC_Type) GetCRCCTRL_CRCSRC() uint16 {
	return (volatile.LoadUint16(&o.CRCCTRL.Reg) & 0x3f00) >> 8
}

// DMAC.CRCDATAIN: CRC Data Input
func (o *DMAC_Type) SetCRCDATAIN(value uint32) {
	volatile.StoreUint32(&o.CRCDATAIN.Reg, value)
}
func (o *DMAC_Type) GetCRCDATAIN() uint32 {
	return volatile.LoadUint32(&o.CRCDATAIN.Reg)
}

// DMAC.CRCCHKSUM: CRC Checksum
func (o *DMAC_Type) SetCRCCHKSUM(value uint32) {
	volatile.StoreUint32(&o.CRCCHKSUM.Reg, value)
}
func (o *DMAC_Type) GetCRCCHKSUM() uint32 {
	return volatile.LoadUint32(&o.CRCCHKSUM.Reg)
}

// DMAC.CRCSTATUS: CRC Status
func (o *DMAC_Type) SetCRCSTATUS_CRCBUSY(value uint8) {
	volatile.StoreUint8(&o.CRCSTATUS.Reg, volatile.LoadUint8(&o.CRCSTATUS.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCRCSTATUS_CRCBUSY() uint8 {
	return volatile.LoadUint8(&o.CRCSTATUS.Reg) & 0x1
}
func (o *DMAC_Type) SetCRCSTATUS_CRCZERO(value uint8) {
	volatile.StoreUint8(&o.CRCSTATUS.Reg, volatile.LoadUint8(&o.CRCSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCRCSTATUS_CRCZERO() uint8 {
	return (volatile.LoadUint8(&o.CRCSTATUS.Reg) & 0x2) >> 1
}

// DMAC.DBGCTRL: Debug Control
func (o *DMAC_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// DMAC.QOSCTRL: QOS Control
func (o *DMAC_Type) SetQOSCTRL_WRBQOS(value uint8) {
	volatile.StoreUint8(&o.QOSCTRL.Reg, volatile.LoadUint8(&o.QOSCTRL.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetQOSCTRL_WRBQOS() uint8 {
	return volatile.LoadUint8(&o.QOSCTRL.Reg) & 0x3
}
func (o *DMAC_Type) SetQOSCTRL_FQOS(value uint8) {
	volatile.StoreUint8(&o.QOSCTRL.Reg, volatile.LoadUint8(&o.QOSCTRL.Reg)&^(0xc)|value<<2)
}
func (o *DMAC_Type) GetQOSCTRL_FQOS() uint8 {
	return (volatile.LoadUint8(&o.QOSCTRL.Reg) & 0xc) >> 2
}
func (o *DMAC_Type) SetQOSCTRL_DQOS(value uint8) {
	volatile.StoreUint8(&o.QOSCTRL.Reg, volatile.LoadUint8(&o.QOSCTRL.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetQOSCTRL_DQOS() uint8 {
	return (volatile.LoadUint8(&o.QOSCTRL.Reg) & 0x30) >> 4
}

// DMAC.SWTRIGCTRL: Software Trigger Control
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG0(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG0() uint32 {
	return volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x1
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG1(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG1() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG2(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG2() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG3(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG3() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG4(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG4() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG5(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG5() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG6(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG6() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG7(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG7() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG8(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG8() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG9(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG9() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG10(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG10() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG11(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG11() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x800) >> 11
}

// DMAC.PRICTRL0: Priority Control 0
func (o *DMAC_Type) SetPRICTRL0_LVLPRI0(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetPRICTRL0_LVLPRI0() uint32 {
	return volatile.LoadUint32(&o.PRICTRL0.Reg) & 0xf
}
func (o *DMAC_Type) SetPRICTRL0_RRLVLEN0(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetPRICTRL0_RRLVLEN0() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetPRICTRL0_LVLPRI1(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0xf00)|value<<8)
}
func (o *DMAC_Type) GetPRICTRL0_LVLPRI1() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0xf00) >> 8
}
func (o *DMAC_Type) SetPRICTRL0_RRLVLEN1(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetPRICTRL0_RRLVLEN1() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetPRICTRL0_LVLPRI2(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0xf0000)|value<<16)
}
func (o *DMAC_Type) GetPRICTRL0_LVLPRI2() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0xf0000) >> 16
}
func (o *DMAC_Type) SetPRICTRL0_RRLVLEN2(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0x800000)|value<<23)
}
func (o *DMAC_Type) GetPRICTRL0_RRLVLEN2() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0x800000) >> 23
}
func (o *DMAC_Type) SetPRICTRL0_LVLPRI3(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0xf000000)|value<<24)
}
func (o *DMAC_Type) GetPRICTRL0_LVLPRI3() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0xf000000) >> 24
}
func (o *DMAC_Type) SetPRICTRL0_RRLVLEN3(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetPRICTRL0_RRLVLEN3() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0x80000000) >> 31
}

// DMAC.INTPEND: Interrupt Pending
func (o *DMAC_Type) SetINTPEND_ID(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetINTPEND_ID() uint16 {
	return volatile.LoadUint16(&o.INTPEND.Reg) & 0xf
}
func (o *DMAC_Type) SetINTPEND_TERR(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetINTPEND_TERR() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetINTPEND_TCMPL(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetINTPEND_TCMPL() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetINTPEND_SUSP(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetINTPEND_SUSP() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetINTPEND_FERR(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetINTPEND_FERR() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetINTPEND_BUSY(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetINTPEND_BUSY() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetINTPEND_PEND(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetINTPEND_PEND() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x8000) >> 15
}

// DMAC.INTSTATUS: Interrupt Status
func (o *DMAC_Type) SetINTSTATUS_CHINT0(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT0() uint32 {
	return volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x1
}
func (o *DMAC_Type) SetINTSTATUS_CHINT1(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT1() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetINTSTATUS_CHINT2(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT2() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetINTSTATUS_CHINT3(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT3() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetINTSTATUS_CHINT4(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT4() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetINTSTATUS_CHINT5(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT5() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetINTSTATUS_CHINT6(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT6() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetINTSTATUS_CHINT7(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT7() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetINTSTATUS_CHINT8(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT8() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetINTSTATUS_CHINT9(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT9() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetINTSTATUS_CHINT10(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT10() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetINTSTATUS_CHINT11(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT11() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x800) >> 11
}

// DMAC.BUSYCH: Busy Channels
func (o *DMAC_Type) SetBUSYCH_BUSYCH0(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH0() uint32 {
	return volatile.LoadUint32(&o.BUSYCH.Reg) & 0x1
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH1(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH1() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH2(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH2() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH3(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH3() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH4(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH4() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH5(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH5() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH6(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH6() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH7(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH7() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH8(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH8() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH9(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH9() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH10(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH10() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH11(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH11() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x800) >> 11
}

// DMAC.PENDCH: Pending Channels
func (o *DMAC_Type) SetPENDCH_PENDCH0(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetPENDCH_PENDCH0() uint32 {
	return volatile.LoadUint32(&o.PENDCH.Reg) & 0x1
}
func (o *DMAC_Type) SetPENDCH_PENDCH1(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetPENDCH_PENDCH1() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetPENDCH_PENDCH2(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetPENDCH_PENDCH2() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetPENDCH_PENDCH3(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetPENDCH_PENDCH3() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetPENDCH_PENDCH4(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetPENDCH_PENDCH4() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetPENDCH_PENDCH5(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetPENDCH_PENDCH5() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetPENDCH_PENDCH6(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetPENDCH_PENDCH6() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetPENDCH_PENDCH7(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetPENDCH_PENDCH7() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetPENDCH_PENDCH8(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetPENDCH_PENDCH8() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetPENDCH_PENDCH9(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetPENDCH_PENDCH9() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetPENDCH_PENDCH10(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetPENDCH_PENDCH10() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetPENDCH_PENDCH11(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetPENDCH_PENDCH11() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x800) >> 11
}

// DMAC.ACTIVE: Active Channel and Levels
func (o *DMAC_Type) SetACTIVE_LVLEX0(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetACTIVE_LVLEX0() uint32 {
	return volatile.LoadUint32(&o.ACTIVE.Reg) & 0x1
}
func (o *DMAC_Type) SetACTIVE_LVLEX1(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetACTIVE_LVLEX1() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetACTIVE_LVLEX2(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetACTIVE_LVLEX2() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetACTIVE_LVLEX3(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetACTIVE_LVLEX3() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetACTIVE_ID(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0x1f00)|value<<8)
}
func (o *DMAC_Type) GetACTIVE_ID() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE.Reg) & 0x1f00) >> 8
}
func (o *DMAC_Type) SetACTIVE_ABUSY(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetACTIVE_ABUSY() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetACTIVE_BTCNT(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0xffff0000)|value<<16)
}
func (o *DMAC_Type) GetACTIVE_BTCNT() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE.Reg) & 0xffff0000) >> 16
}

// DMAC.BASEADDR: Descriptor Memory Section Base Address
func (o *DMAC_Type) SetBASEADDR(value uint32) {
	volatile.StoreUint32(&o.BASEADDR.Reg, value)
}
func (o *DMAC_Type) GetBASEADDR() uint32 {
	return volatile.LoadUint32(&o.BASEADDR.Reg)
}

// DMAC.WRBADDR: Write-Back Memory Section Base Address
func (o *DMAC_Type) SetWRBADDR(value uint32) {
	volatile.StoreUint32(&o.WRBADDR.Reg, value)
}
func (o *DMAC_Type) GetWRBADDR() uint32 {
	return volatile.LoadUint32(&o.WRBADDR.Reg)
}

// DMAC.CHID: Channel ID
func (o *DMAC_Type) SetCHID_ID(value uint8) {
	volatile.StoreUint8(&o.CHID.Reg, volatile.LoadUint8(&o.CHID.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCHID_ID() uint8 {
	return volatile.LoadUint8(&o.CHID.Reg) & 0xf
}

// DMAC.CHCTRLA: Channel Control A
func (o *DMAC_Type) SetCHCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CHCTRLA.Reg, volatile.LoadUint8(&o.CHCTRLA.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CHCTRLA.Reg) & 0x1
}
func (o *DMAC_Type) SetCHCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CHCTRLA.Reg, volatile.LoadUint8(&o.CHCTRLA.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CHCTRLA.Reg) & 0x2) >> 1
}

// DMAC.CHCTRLB: Channel Control B
func (o *DMAC_Type) SetCHCTRLB_EVACT(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0x7)|value)
}
func (o *DMAC_Type) GetCHCTRLB_EVACT() uint32 {
	return volatile.LoadUint32(&o.CHCTRLB.Reg) & 0x7
}
func (o *DMAC_Type) SetCHCTRLB_EVIE(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCHCTRLB_EVIE() uint32 {
	return (volatile.LoadUint32(&o.CHCTRLB.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCHCTRLB_EVOE(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCHCTRLB_EVOE() uint32 {
	return (volatile.LoadUint32(&o.CHCTRLB.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCHCTRLB_LVL(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0x60)|value<<5)
}
func (o *DMAC_Type) GetCHCTRLB_LVL() uint32 {
	return (volatile.LoadUint32(&o.CHCTRLB.Reg) & 0x60) >> 5
}
func (o *DMAC_Type) SetCHCTRLB_TRIGSRC(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0x3f00)|value<<8)
}
func (o *DMAC_Type) GetCHCTRLB_TRIGSRC() uint32 {
	return (volatile.LoadUint32(&o.CHCTRLB.Reg) & 0x3f00) >> 8
}
func (o *DMAC_Type) SetCHCTRLB_TRIGACT(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0xc00000)|value<<22)
}
func (o *DMAC_Type) GetCHCTRLB_TRIGACT() uint32 {
	return (volatile.LoadUint32(&o.CHCTRLB.Reg) & 0xc00000) >> 22
}
func (o *DMAC_Type) SetCHCTRLB_CMD(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCHCTRLB_CMD() uint32 {
	return (volatile.LoadUint32(&o.CHCTRLB.Reg) & 0x3000000) >> 24
}

// DMAC.CHINTENCLR: Channel Interrupt Enable Clear
func (o *DMAC_Type) SetCHINTENCLR_TERR(value uint8) {
	volatile.StoreUint8(&o.CHINTENCLR.Reg, volatile.LoadUint8(&o.CHINTENCLR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHINTENCLR_TERR() uint8 {
	return volatile.LoadUint8(&o.CHINTENCLR.Reg) & 0x1
}
func (o *DMAC_Type) SetCHINTENCLR_TCMPL(value uint8) {
	volatile.StoreUint8(&o.CHINTENCLR.Reg, volatile.LoadUint8(&o.CHINTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHINTENCLR_TCMPL() uint8 {
	return (volatile.LoadUint8(&o.CHINTENCLR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHINTENCLR_SUSP(value uint8) {
	volatile.StoreUint8(&o.CHINTENCLR.Reg, volatile.LoadUint8(&o.CHINTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHINTENCLR_SUSP() uint8 {
	return (volatile.LoadUint8(&o.CHINTENCLR.Reg) & 0x4) >> 2
}

// DMAC.CHINTENSET: Channel Interrupt Enable Set
func (o *DMAC_Type) SetCHINTENSET_TERR(value uint8) {
	volatile.StoreUint8(&o.CHINTENSET.Reg, volatile.LoadUint8(&o.CHINTENSET.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHINTENSET_TERR() uint8 {
	return volatile.LoadUint8(&o.CHINTENSET.Reg) & 0x1
}
func (o *DMAC_Type) SetCHINTENSET_TCMPL(value uint8) {
	volatile.StoreUint8(&o.CHINTENSET.Reg, volatile.LoadUint8(&o.CHINTENSET.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHINTENSET_TCMPL() uint8 {
	return (volatile.LoadUint8(&o.CHINTENSET.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHINTENSET_SUSP(value uint8) {
	volatile.StoreUint8(&o.CHINTENSET.Reg, volatile.LoadUint8(&o.CHINTENSET.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHINTENSET_SUSP() uint8 {
	return (volatile.LoadUint8(&o.CHINTENSET.Reg) & 0x4) >> 2
}

// DMAC.CHINTFLAG: Channel Interrupt Flag Status and Clear
func (o *DMAC_Type) SetCHINTFLAG_TERR(value uint8) {
	volatile.StoreUint8(&o.CHINTFLAG.Reg, volatile.LoadUint8(&o.CHINTFLAG.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHINTFLAG_TERR() uint8 {
	return volatile.LoadUint8(&o.CHINTFLAG.Reg) & 0x1
}
func (o *DMAC_Type) SetCHINTFLAG_TCMPL(value uint8) {
	volatile.StoreUint8(&o.CHINTFLAG.Reg, volatile.LoadUint8(&o.CHINTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHINTFLAG_TCMPL() uint8 {
	return (volatile.LoadUint8(&o.CHINTFLAG.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHINTFLAG_SUSP(value uint8) {
	volatile.StoreUint8(&o.CHINTFLAG.Reg, volatile.LoadUint8(&o.CHINTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHINTFLAG_SUSP() uint8 {
	return (volatile.LoadUint8(&o.CHINTFLAG.Reg) & 0x4) >> 2
}

// DMAC.CHSTATUS: Channel Status
func (o *DMAC_Type) SetCHSTATUS_PEND(value uint8) {
	volatile.StoreUint8(&o.CHSTATUS.Reg, volatile.LoadUint8(&o.CHSTATUS.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHSTATUS_PEND() uint8 {
	return volatile.LoadUint8(&o.CHSTATUS.Reg) & 0x1
}
func (o *DMAC_Type) SetCHSTATUS_BUSY(value uint8) {
	volatile.StoreUint8(&o.CHSTATUS.Reg, volatile.LoadUint8(&o.CHSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHSTATUS_BUSY() uint8 {
	return (volatile.LoadUint8(&o.CHSTATUS.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHSTATUS_FERR(value uint8) {
	volatile.StoreUint8(&o.CHSTATUS.Reg, volatile.LoadUint8(&o.CHSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHSTATUS_FERR() uint8 {
	return (volatile.LoadUint8(&o.CHSTATUS.Reg) & 0x4) >> 2
}

// Device Service Unit
type DSU_Type struct {
	CTRL    volatile.Register8 // 0x0
	STATUSA volatile.Register8 // 0x1
	STATUSB volatile.Register8 // 0x2
	_       byte
	ADDR    volatile.Register32 // 0x4
	LENGTH  volatile.Register32 // 0x8
	DATA    volatile.Register32 // 0xC
	DCC0    volatile.Register32 // 0x10
	DCC1    volatile.Register32 // 0x14
	DID     volatile.Register32 // 0x18
	_       [4068]byte
	ENTRY0  volatile.Register32 // 0x1000
	ENTRY1  volatile.Register32 // 0x1004
	END     volatile.Register32 // 0x1008
	_       [4032]byte
	MEMTYPE volatile.Register32 // 0x1FCC
	PID4    volatile.Register32 // 0x1FD0
	_       [12]byte
	PID0    volatile.Register32 // 0x1FE0
	PID1    volatile.Register32 // 0x1FE4
	PID2    volatile.Register32 // 0x1FE8
	PID3    volatile.Register32 // 0x1FEC
	CID0    volatile.Register32 // 0x1FF0
	CID1    volatile.Register32 // 0x1FF4
	CID2    volatile.Register32 // 0x1FF8
	CID3    volatile.Register32 // 0x1FFC
}

// DSU.CTRL: Control
func (o *DSU_Type) SetCTRL_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *DSU_Type) GetCTRL_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRL.Reg) & 0x1
}
func (o *DSU_Type) SetCTRL_CRC(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *DSU_Type) GetCTRL_CRC() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *DSU_Type) SetCTRL_MBIST(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *DSU_Type) GetCTRL_MBIST() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *DSU_Type) SetCTRL_CE(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *DSU_Type) GetCTRL_CE() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x10) >> 4
}

// DSU.STATUSA: Status A
func (o *DSU_Type) SetSTATUSA_DONE(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x1)|value)
}
func (o *DSU_Type) GetSTATUSA_DONE() uint8 {
	return volatile.LoadUint8(&o.STATUSA.Reg) & 0x1
}
func (o *DSU_Type) SetSTATUSA_CRSTEXT(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x2)|value<<1)
}
func (o *DSU_Type) GetSTATUSA_CRSTEXT() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x2) >> 1
}
func (o *DSU_Type) SetSTATUSA_BERR(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x4)|value<<2)
}
func (o *DSU_Type) GetSTATUSA_BERR() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x4) >> 2
}
func (o *DSU_Type) SetSTATUSA_FAIL(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x8)|value<<3)
}
func (o *DSU_Type) GetSTATUSA_FAIL() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x8) >> 3
}
func (o *DSU_Type) SetSTATUSA_PERR(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x10)|value<<4)
}
func (o *DSU_Type) GetSTATUSA_PERR() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x10) >> 4
}

// DSU.STATUSB: Status B
func (o *DSU_Type) SetSTATUSB_PROT(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x1)|value)
}
func (o *DSU_Type) GetSTATUSB_PROT() uint8 {
	return volatile.LoadUint8(&o.STATUSB.Reg) & 0x1
}
func (o *DSU_Type) SetSTATUSB_DBGPRES(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x2)|value<<1)
}
func (o *DSU_Type) GetSTATUSB_DBGPRES() uint8 {
	return (volatile.LoadUint8(&o.STATUSB.Reg) & 0x2) >> 1
}
func (o *DSU_Type) SetSTATUSB_DCCD0(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x4)|value<<2)
}
func (o *DSU_Type) GetSTATUSB_DCCD0() uint8 {
	return (volatile.LoadUint8(&o.STATUSB.Reg) & 0x4) >> 2
}
func (o *DSU_Type) SetSTATUSB_DCCD1(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x8)|value<<3)
}
func (o *DSU_Type) GetSTATUSB_DCCD1() uint8 {
	return (volatile.LoadUint8(&o.STATUSB.Reg) & 0x8) >> 3
}
func (o *DSU_Type) SetSTATUSB_HPE(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x10)|value<<4)
}
func (o *DSU_Type) GetSTATUSB_HPE() uint8 {
	return (volatile.LoadUint8(&o.STATUSB.Reg) & 0x10) >> 4
}

// DSU.ADDR: Address
func (o *DSU_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DSU_Type) GetADDR() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0xfffffffc) >> 2
}

// DSU.LENGTH: Length
func (o *DSU_Type) SetLENGTH(value uint32) {
	volatile.StoreUint32(&o.LENGTH.Reg, volatile.LoadUint32(&o.LENGTH.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DSU_Type) GetLENGTH() uint32 {
	return (volatile.LoadUint32(&o.LENGTH.Reg) & 0xfffffffc) >> 2
}

// DSU.DATA: Data
func (o *DSU_Type) SetDATA(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, value)
}
func (o *DSU_Type) GetDATA() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg)
}

// DSU.DCC0: Debug Communication Channel n
func (o *DSU_Type) SetDCC0(value uint32) {
	volatile.StoreUint32(&o.DCC0.Reg, value)
}
func (o *DSU_Type) GetDCC0() uint32 {
	return volatile.LoadUint32(&o.DCC0.Reg)
}

// DSU.DCC1: Debug Communication Channel n
func (o *DSU_Type) SetDCC1(value uint32) {
	volatile.StoreUint32(&o.DCC1.Reg, value)
}
func (o *DSU_Type) GetDCC1() uint32 {
	return volatile.LoadUint32(&o.DCC1.Reg)
}

// DSU.DID: Device Identification
func (o *DSU_Type) SetDID_DEVSEL(value uint32) {
	volatile.StoreUint32(&o.DID.Reg, volatile.LoadUint32(&o.DID.Reg)&^(0xff)|value)
}
func (o *DSU_Type) GetDID_DEVSEL() uint32 {
	return volatile.LoadUint32(&o.DID.Reg) & 0xff
}
func (o *DSU_Type) SetDID_REVISION(value uint32) {
	volatile.StoreUint32(&o.DID.Reg, volatile.LoadUint32(&o.DID.Reg)&^(0xf00)|value<<8)
}
func (o *DSU_Type) GetDID_REVISION() uint32 {
	return (volatile.LoadUint32(&o.DID.Reg) & 0xf00) >> 8
}
func (o *DSU_Type) SetDID_DIE(value uint32) {
	volatile.StoreUint32(&o.DID.Reg, volatile.LoadUint32(&o.DID.Reg)&^(0xf000)|value<<12)
}
func (o *DSU_Type) GetDID_DIE() uint32 {
	return (volatile.LoadUint32(&o.DID.Reg) & 0xf000) >> 12
}
func (o *DSU_Type) SetDID_SERIES(value uint32) {
	volatile.StoreUint32(&o.DID.Reg, volatile.LoadUint32(&o.DID.Reg)&^(0x3f0000)|value<<16)
}
func (o *DSU_Type) GetDID_SERIES() uint32 {
	return (volatile.LoadUint32(&o.DID.Reg) & 0x3f0000) >> 16
}
func (o *DSU_Type) SetDID_FAMILY(value uint32) {
	volatile.StoreUint32(&o.DID.Reg, volatile.LoadUint32(&o.DID.Reg)&^(0xf800000)|value<<23)
}
func (o *DSU_Type) GetDID_FAMILY() uint32 {
	return (volatile.LoadUint32(&o.DID.Reg) & 0xf800000) >> 23
}
func (o *DSU_Type) SetDID_PROCESSOR(value uint32) {
	volatile.StoreUint32(&o.DID.Reg, volatile.LoadUint32(&o.DID.Reg)&^(0xf0000000)|value<<28)
}
func (o *DSU_Type) GetDID_PROCESSOR() uint32 {
	return (volatile.LoadUint32(&o.DID.Reg) & 0xf0000000) >> 28
}

// DSU.ENTRY0: CoreSight ROM Table Entry 0
func (o *DSU_Type) SetENTRY0_EPRES(value uint32) {
	volatile.StoreUint32(&o.ENTRY0.Reg, volatile.LoadUint32(&o.ENTRY0.Reg)&^(0x1)|value)
}
func (o *DSU_Type) GetENTRY0_EPRES() uint32 {
	return volatile.LoadUint32(&o.ENTRY0.Reg) & 0x1
}
func (o *DSU_Type) SetENTRY0_FMT(value uint32) {
	volatile.StoreUint32(&o.ENTRY0.Reg, volatile.LoadUint32(&o.ENTRY0.Reg)&^(0x2)|value<<1)
}
func (o *DSU_Type) GetENTRY0_FMT() uint32 {
	return (volatile.LoadUint32(&o.ENTRY0.Reg) & 0x2) >> 1
}
func (o *DSU_Type) SetENTRY0_ADDOFF(value uint32) {
	volatile.StoreUint32(&o.ENTRY0.Reg, volatile.LoadUint32(&o.ENTRY0.Reg)&^(0xfffff000)|value<<12)
}
func (o *DSU_Type) GetENTRY0_ADDOFF() uint32 {
	return (volatile.LoadUint32(&o.ENTRY0.Reg) & 0xfffff000) >> 12
}

// DSU.END: CoreSight ROM Table End
func (o *DSU_Type) SetEND(value uint32) {
	volatile.StoreUint32(&o.END.Reg, value)
}
func (o *DSU_Type) GetEND() uint32 {
	return volatile.LoadUint32(&o.END.Reg)
}

// DSU.MEMTYPE: CoreSight ROM Table Memory Type
func (o *DSU_Type) SetMEMTYPE_SMEMP(value uint32) {
	volatile.StoreUint32(&o.MEMTYPE.Reg, volatile.LoadUint32(&o.MEMTYPE.Reg)&^(0x1)|value)
}
func (o *DSU_Type) GetMEMTYPE_SMEMP() uint32 {
	return volatile.LoadUint32(&o.MEMTYPE.Reg) & 0x1
}

// DSU.PID4: Peripheral Identification 4
func (o *DSU_Type) SetPID4_JEPCC(value uint32) {
	volatile.StoreUint32(&o.PID4.Reg, volatile.LoadUint32(&o.PID4.Reg)&^(0xf)|value)
}
func (o *DSU_Type) GetPID4_JEPCC() uint32 {
	return volatile.LoadUint32(&o.PID4.Reg) & 0xf
}
func (o *DSU_Type) SetPID4_FKBC(value uint32) {
	volatile.StoreUint32(&o.PID4.Reg, volatile.LoadUint32(&o.PID4.Reg)&^(0xf0)|value<<4)
}
func (o *DSU_Type) GetPID4_FKBC() uint32 {
	return (volatile.LoadUint32(&o.PID4.Reg) & 0xf0) >> 4
}

// DSU.PID0: Peripheral Identification 0
func (o *DSU_Type) SetPID0_PARTNBL(value uint32) {
	volatile.StoreUint32(&o.PID0.Reg, volatile.LoadUint32(&o.PID0.Reg)&^(0xff)|value)
}
func (o *DSU_Type) GetPID0_PARTNBL() uint32 {
	return volatile.LoadUint32(&o.PID0.Reg) & 0xff
}

// DSU.PID1: Peripheral Identification 1
func (o *DSU_Type) SetPID1_PARTNBH(value uint32) {
	volatile.StoreUint32(&o.PID1.Reg, volatile.LoadUint32(&o.PID1.Reg)&^(0xf)|value)
}
func (o *DSU_Type) GetPID1_PARTNBH() uint32 {
	return volatile.LoadUint32(&o.PID1.Reg) & 0xf
}
func (o *DSU_Type) SetPID1_JEPIDCL(value uint32) {
	volatile.StoreUint32(&o.PID1.Reg, volatile.LoadUint32(&o.PID1.Reg)&^(0xf0)|value<<4)
}
func (o *DSU_Type) GetPID1_JEPIDCL() uint32 {
	return (volatile.LoadUint32(&o.PID1.Reg) & 0xf0) >> 4
}

// DSU.PID2: Peripheral Identification 2
func (o *DSU_Type) SetPID2_JEPIDCH(value uint32) {
	volatile.StoreUint32(&o.PID2.Reg, volatile.LoadUint32(&o.PID2.Reg)&^(0x7)|value)
}
func (o *DSU_Type) GetPID2_JEPIDCH() uint32 {
	return volatile.LoadUint32(&o.PID2.Reg) & 0x7
}
func (o *DSU_Type) SetPID2_JEPU(value uint32) {
	volatile.StoreUint32(&o.PID2.Reg, volatile.LoadUint32(&o.PID2.Reg)&^(0x8)|value<<3)
}
func (o *DSU_Type) GetPID2_JEPU() uint32 {
	return (volatile.LoadUint32(&o.PID2.Reg) & 0x8) >> 3
}
func (o *DSU_Type) SetPID2_REVISION(value uint32) {
	volatile.StoreUint32(&o.PID2.Reg, volatile.LoadUint32(&o.PID2.Reg)&^(0xf0)|value<<4)
}
func (o *DSU_Type) GetPID2_REVISION() uint32 {
	return (volatile.LoadUint32(&o.PID2.Reg) & 0xf0) >> 4
}

// DSU.PID3: Peripheral Identification 3
func (o *DSU_Type) SetPID3_CUSMOD(value uint32) {
	volatile.StoreUint32(&o.PID3.Reg, volatile.LoadUint32(&o.PID3.Reg)&^(0xf)|value)
}
func (o *DSU_Type) GetPID3_CUSMOD() uint32 {
	return volatile.LoadUint32(&o.PID3.Reg) & 0xf
}
func (o *DSU_Type) SetPID3_REVAND(value uint32) {
	volatile.StoreUint32(&o.PID3.Reg, volatile.LoadUint32(&o.PID3.Reg)&^(0xf0)|value<<4)
}
func (o *DSU_Type) GetPID3_REVAND() uint32 {
	return (volatile.LoadUint32(&o.PID3.Reg) & 0xf0) >> 4
}

// DSU.CID0: Component Identification 0
func (o *DSU_Type) SetCID0_PREAMBLEB0(value uint32) {
	volatile.StoreUint32(&o.CID0.Reg, volatile.LoadUint32(&o.CID0.Reg)&^(0xff)|value)
}
func (o *DSU_Type) GetCID0_PREAMBLEB0() uint32 {
	return volatile.LoadUint32(&o.CID0.Reg) & 0xff
}

// DSU.CID1: Component Identification 1
func (o *DSU_Type) SetCID1_PREAMBLE(value uint32) {
	volatile.StoreUint32(&o.CID1.Reg, volatile.LoadUint32(&o.CID1.Reg)&^(0xf)|value)
}
func (o *DSU_Type) GetCID1_PREAMBLE() uint32 {
	return volatile.LoadUint32(&o.CID1.Reg) & 0xf
}
func (o *DSU_Type) SetCID1_CCLASS(value uint32) {
	volatile.StoreUint32(&o.CID1.Reg, volatile.LoadUint32(&o.CID1.Reg)&^(0xf0)|value<<4)
}
func (o *DSU_Type) GetCID1_CCLASS() uint32 {
	return (volatile.LoadUint32(&o.CID1.Reg) & 0xf0) >> 4
}

// DSU.CID2: Component Identification 2
func (o *DSU_Type) SetCID2_PREAMBLEB2(value uint32) {
	volatile.StoreUint32(&o.CID2.Reg, volatile.LoadUint32(&o.CID2.Reg)&^(0xff)|value)
}
func (o *DSU_Type) GetCID2_PREAMBLEB2() uint32 {
	return volatile.LoadUint32(&o.CID2.Reg) & 0xff
}

// DSU.CID3: Component Identification 3
func (o *DSU_Type) SetCID3_PREAMBLEB3(value uint32) {
	volatile.StoreUint32(&o.CID3.Reg, volatile.LoadUint32(&o.CID3.Reg)&^(0xff)|value)
}
func (o *DSU_Type) GetCID3_PREAMBLEB3() uint32 {
	return volatile.LoadUint32(&o.CID3.Reg) & 0xff
}

// External Interrupt Controller
type EIC_Type struct {
	CTRL     volatile.Register8  // 0x0
	STATUS   volatile.Register8  // 0x1
	NMICTRL  volatile.Register8  // 0x2
	NMIFLAG  volatile.Register8  // 0x3
	EVCTRL   volatile.Register32 // 0x4
	INTENCLR volatile.Register32 // 0x8
	INTENSET volatile.Register32 // 0xC
	INTFLAG  volatile.Register32 // 0x10
	WAKEUP   volatile.Register32 // 0x14
	CONFIG0  volatile.Register32 // 0x18
	CONFIG1  volatile.Register32 // 0x1C
}

// EIC.CTRL: Control
func (o *EIC_Type) SetCTRL_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *EIC_Type) GetCTRL_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRL.Reg) & 0x1
}
func (o *EIC_Type) SetCTRL_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EIC_Type) GetCTRL_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x2) >> 1
}

// EIC.STATUS: Status
func (o *EIC_Type) SetSTATUS_SYNCBUSY(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *EIC_Type) GetSTATUS_SYNCBUSY() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x80) >> 7
}

// EIC.NMICTRL: Non-Maskable Interrupt Control
func (o *EIC_Type) SetNMICTRL_NMISENSE(value uint8) {
	volatile.StoreUint8(&o.NMICTRL.Reg, volatile.LoadUint8(&o.NMICTRL.Reg)&^(0x7)|value)
}
func (o *EIC_Type) GetNMICTRL_NMISENSE() uint8 {
	return volatile.LoadUint8(&o.NMICTRL.Reg) & 0x7
}
func (o *EIC_Type) SetNMICTRL_NMIFILTEN(value uint8) {
	volatile.StoreUint8(&o.NMICTRL.Reg, volatile.LoadUint8(&o.NMICTRL.Reg)&^(0x8)|value<<3)
}
func (o *EIC_Type) GetNMICTRL_NMIFILTEN() uint8 {
	return (volatile.LoadUint8(&o.NMICTRL.Reg) & 0x8) >> 3
}

// EIC.NMIFLAG: Non-Maskable Interrupt Flag Status and Clear
func (o *EIC_Type) SetNMIFLAG_NMI(value uint8) {
	volatile.StoreUint8(&o.NMIFLAG.Reg, volatile.LoadUint8(&o.NMIFLAG.Reg)&^(0x1)|value)
}
func (o *EIC_Type) GetNMIFLAG_NMI() uint8 {
	return volatile.LoadUint8(&o.NMIFLAG.Reg) & 0x1
}

// EIC.EVCTRL: Event Control
func (o *EIC_Type) SetEVCTRL_EXTINTEO0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *EIC_Type) GetEVCTRL_EXTINTEO0() uint32 {
	return volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1
}
func (o *EIC_Type) SetEVCTRL_EXTINTEO1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *EIC_Type) GetEVCTRL_EXTINTEO1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *EIC_Type) SetEVCTRL_EXTINTEO2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *EIC_Type) GetEVCTRL_EXTINTEO2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x4) >> 2
}
func (o *EIC_Type) SetEVCTRL_EXTINTEO3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8)|value<<3)
}
func (o *EIC_Type) GetEVCTRL_EXTINTEO3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8) >> 3
}
func (o *EIC_Type) SetEVCTRL_EXTINTEO4(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *EIC_Type) GetEVCTRL_EXTINTEO4() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *EIC_Type) SetEVCTRL_EXTINTEO5(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *EIC_Type) GetEVCTRL_EXTINTEO5() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *EIC_Type) SetEVCTRL_EXTINTEO6(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x40)|value<<6)
}
func (o *EIC_Type) GetEVCTRL_EXTINTEO6() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x40) >> 6
}
func (o *EIC_Type) SetEVCTRL_EXTINTEO7(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x80)|value<<7)
}
func (o *EIC_Type) GetEVCTRL_EXTINTEO7() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x80) >> 7
}
func (o *EIC_Type) SetEVCTRL_EXTINTEO8(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *EIC_Type) GetEVCTRL_EXTINTEO8() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *EIC_Type) SetEVCTRL_EXTINTEO9(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x200)|value<<9)
}
func (o *EIC_Type) GetEVCTRL_EXTINTEO9() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x200) >> 9
}
func (o *EIC_Type) SetEVCTRL_EXTINTEO10(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x400)|value<<10)
}
func (o *EIC_Type) GetEVCTRL_EXTINTEO10() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x400) >> 10
}
func (o *EIC_Type) SetEVCTRL_EXTINTEO11(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x800)|value<<11)
}
func (o *EIC_Type) GetEVCTRL_EXTINTEO11() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x800) >> 11
}
func (o *EIC_Type) SetEVCTRL_EXTINTEO12(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *EIC_Type) GetEVCTRL_EXTINTEO12() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1000) >> 12
}
func (o *EIC_Type) SetEVCTRL_EXTINTEO13(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *EIC_Type) GetEVCTRL_EXTINTEO13() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x2000) >> 13
}
func (o *EIC_Type) SetEVCTRL_EXTINTEO14(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *EIC_Type) GetEVCTRL_EXTINTEO14() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x4000) >> 14
}
func (o *EIC_Type) SetEVCTRL_EXTINTEO15(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *EIC_Type) GetEVCTRL_EXTINTEO15() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8000) >> 15
}

// EIC.INTENCLR: Interrupt Enable Clear
func (o *EIC_Type) SetINTENCLR_EXTINT0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *EIC_Type) GetINTENCLR_EXTINT0() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *EIC_Type) SetINTENCLR_EXTINT1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *EIC_Type) GetINTENCLR_EXTINT1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *EIC_Type) SetINTENCLR_EXTINT2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *EIC_Type) GetINTENCLR_EXTINT2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *EIC_Type) SetINTENCLR_EXTINT3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *EIC_Type) GetINTENCLR_EXTINT3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *EIC_Type) SetINTENCLR_EXTINT4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *EIC_Type) GetINTENCLR_EXTINT4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *EIC_Type) SetINTENCLR_EXTINT5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *EIC_Type) GetINTENCLR_EXTINT5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *EIC_Type) SetINTENCLR_EXTINT6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *EIC_Type) GetINTENCLR_EXTINT6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *EIC_Type) SetINTENCLR_EXTINT7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *EIC_Type) GetINTENCLR_EXTINT7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *EIC_Type) SetINTENCLR_EXTINT8(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *EIC_Type) GetINTENCLR_EXTINT8() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *EIC_Type) SetINTENCLR_EXTINT9(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *EIC_Type) GetINTENCLR_EXTINT9() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *EIC_Type) SetINTENCLR_EXTINT10(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *EIC_Type) GetINTENCLR_EXTINT10() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *EIC_Type) SetINTENCLR_EXTINT11(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *EIC_Type) GetINTENCLR_EXTINT11() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *EIC_Type) SetINTENCLR_EXTINT12(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *EIC_Type) GetINTENCLR_EXTINT12() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *EIC_Type) SetINTENCLR_EXTINT13(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *EIC_Type) GetINTENCLR_EXTINT13() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *EIC_Type) SetINTENCLR_EXTINT14(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *EIC_Type) GetINTENCLR_EXTINT14() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *EIC_Type) SetINTENCLR_EXTINT15(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *EIC_Type) GetINTENCLR_EXTINT15() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}

// EIC.INTENSET: Interrupt Enable Set
func (o *EIC_Type) SetINTENSET_EXTINT0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *EIC_Type) GetINTENSET_EXTINT0() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *EIC_Type) SetINTENSET_EXTINT1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *EIC_Type) GetINTENSET_EXTINT1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *EIC_Type) SetINTENSET_EXTINT2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *EIC_Type) GetINTENSET_EXTINT2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *EIC_Type) SetINTENSET_EXTINT3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *EIC_Type) GetINTENSET_EXTINT3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *EIC_Type) SetINTENSET_EXTINT4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *EIC_Type) GetINTENSET_EXTINT4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *EIC_Type) SetINTENSET_EXTINT5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *EIC_Type) GetINTENSET_EXTINT5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *EIC_Type) SetINTENSET_EXTINT6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *EIC_Type) GetINTENSET_EXTINT6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *EIC_Type) SetINTENSET_EXTINT7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *EIC_Type) GetINTENSET_EXTINT7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *EIC_Type) SetINTENSET_EXTINT8(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *EIC_Type) GetINTENSET_EXTINT8() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *EIC_Type) SetINTENSET_EXTINT9(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *EIC_Type) GetINTENSET_EXTINT9() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *EIC_Type) SetINTENSET_EXTINT10(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *EIC_Type) GetINTENSET_EXTINT10() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *EIC_Type) SetINTENSET_EXTINT11(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *EIC_Type) GetINTENSET_EXTINT11() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *EIC_Type) SetINTENSET_EXTINT12(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *EIC_Type) GetINTENSET_EXTINT12() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *EIC_Type) SetINTENSET_EXTINT13(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *EIC_Type) GetINTENSET_EXTINT13() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *EIC_Type) SetINTENSET_EXTINT14(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *EIC_Type) GetINTENSET_EXTINT14() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *EIC_Type) SetINTENSET_EXTINT15(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *EIC_Type) GetINTENSET_EXTINT15() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}

// EIC.INTFLAG: Interrupt Flag Status and Clear
func (o *EIC_Type) SetINTFLAG_EXTINT0(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *EIC_Type) GetINTFLAG_EXTINT0() uint32 {
	return volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1
}
func (o *EIC_Type) SetINTFLAG_EXTINT1(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *EIC_Type) GetINTFLAG_EXTINT1() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *EIC_Type) SetINTFLAG_EXTINT2(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *EIC_Type) GetINTFLAG_EXTINT2() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *EIC_Type) SetINTFLAG_EXTINT3(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *EIC_Type) GetINTFLAG_EXTINT3() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *EIC_Type) SetINTFLAG_EXTINT4(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *EIC_Type) GetINTFLAG_EXTINT4() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *EIC_Type) SetINTFLAG_EXTINT5(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *EIC_Type) GetINTFLAG_EXTINT5() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *EIC_Type) SetINTFLAG_EXTINT6(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x40)|value<<6)
}
func (o *EIC_Type) GetINTFLAG_EXTINT6() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x40) >> 6
}
func (o *EIC_Type) SetINTFLAG_EXTINT7(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *EIC_Type) GetINTFLAG_EXTINT7() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x80) >> 7
}
func (o *EIC_Type) SetINTFLAG_EXTINT8(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x100)|value<<8)
}
func (o *EIC_Type) GetINTFLAG_EXTINT8() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x100) >> 8
}
func (o *EIC_Type) SetINTFLAG_EXTINT9(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x200)|value<<9)
}
func (o *EIC_Type) GetINTFLAG_EXTINT9() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x200) >> 9
}
func (o *EIC_Type) SetINTFLAG_EXTINT10(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x400)|value<<10)
}
func (o *EIC_Type) GetINTFLAG_EXTINT10() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x400) >> 10
}
func (o *EIC_Type) SetINTFLAG_EXTINT11(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x800)|value<<11)
}
func (o *EIC_Type) GetINTFLAG_EXTINT11() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x800) >> 11
}
func (o *EIC_Type) SetINTFLAG_EXTINT12(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1000)|value<<12)
}
func (o *EIC_Type) GetINTFLAG_EXTINT12() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1000) >> 12
}
func (o *EIC_Type) SetINTFLAG_EXTINT13(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x2000)|value<<13)
}
func (o *EIC_Type) GetINTFLAG_EXTINT13() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x2000) >> 13
}
func (o *EIC_Type) SetINTFLAG_EXTINT14(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x4000)|value<<14)
}
func (o *EIC_Type) GetINTFLAG_EXTINT14() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x4000) >> 14
}
func (o *EIC_Type) SetINTFLAG_EXTINT15(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x8000)|value<<15)
}
func (o *EIC_Type) GetINTFLAG_EXTINT15() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x8000) >> 15
}

// EIC.WAKEUP: Wake-Up Enable
func (o *EIC_Type) SetWAKEUP_WAKEUPEN0(value uint32) {
	volatile.StoreUint32(&o.WAKEUP.Reg, volatile.LoadUint32(&o.WAKEUP.Reg)&^(0x1)|value)
}
func (o *EIC_Type) GetWAKEUP_WAKEUPEN0() uint32 {
	return volatile.LoadUint32(&o.WAKEUP.Reg) & 0x1
}
func (o *EIC_Type) SetWAKEUP_WAKEUPEN1(value uint32) {
	volatile.StoreUint32(&o.WAKEUP.Reg, volatile.LoadUint32(&o.WAKEUP.Reg)&^(0x2)|value<<1)
}
func (o *EIC_Type) GetWAKEUP_WAKEUPEN1() uint32 {
	return (volatile.LoadUint32(&o.WAKEUP.Reg) & 0x2) >> 1
}
func (o *EIC_Type) SetWAKEUP_WAKEUPEN2(value uint32) {
	volatile.StoreUint32(&o.WAKEUP.Reg, volatile.LoadUint32(&o.WAKEUP.Reg)&^(0x4)|value<<2)
}
func (o *EIC_Type) GetWAKEUP_WAKEUPEN2() uint32 {
	return (volatile.LoadUint32(&o.WAKEUP.Reg) & 0x4) >> 2
}
func (o *EIC_Type) SetWAKEUP_WAKEUPEN3(value uint32) {
	volatile.StoreUint32(&o.WAKEUP.Reg, volatile.LoadUint32(&o.WAKEUP.Reg)&^(0x8)|value<<3)
}
func (o *EIC_Type) GetWAKEUP_WAKEUPEN3() uint32 {
	return (volatile.LoadUint32(&o.WAKEUP.Reg) & 0x8) >> 3
}
func (o *EIC_Type) SetWAKEUP_WAKEUPEN4(value uint32) {
	volatile.StoreUint32(&o.WAKEUP.Reg, volatile.LoadUint32(&o.WAKEUP.Reg)&^(0x10)|value<<4)
}
func (o *EIC_Type) GetWAKEUP_WAKEUPEN4() uint32 {
	return (volatile.LoadUint32(&o.WAKEUP.Reg) & 0x10) >> 4
}
func (o *EIC_Type) SetWAKEUP_WAKEUPEN5(value uint32) {
	volatile.StoreUint32(&o.WAKEUP.Reg, volatile.LoadUint32(&o.WAKEUP.Reg)&^(0x20)|value<<5)
}
func (o *EIC_Type) GetWAKEUP_WAKEUPEN5() uint32 {
	return (volatile.LoadUint32(&o.WAKEUP.Reg) & 0x20) >> 5
}
func (o *EIC_Type) SetWAKEUP_WAKEUPEN6(value uint32) {
	volatile.StoreUint32(&o.WAKEUP.Reg, volatile.LoadUint32(&o.WAKEUP.Reg)&^(0x40)|value<<6)
}
func (o *EIC_Type) GetWAKEUP_WAKEUPEN6() uint32 {
	return (volatile.LoadUint32(&o.WAKEUP.Reg) & 0x40) >> 6
}
func (o *EIC_Type) SetWAKEUP_WAKEUPEN7(value uint32) {
	volatile.StoreUint32(&o.WAKEUP.Reg, volatile.LoadUint32(&o.WAKEUP.Reg)&^(0x80)|value<<7)
}
func (o *EIC_Type) GetWAKEUP_WAKEUPEN7() uint32 {
	return (volatile.LoadUint32(&o.WAKEUP.Reg) & 0x80) >> 7
}
func (o *EIC_Type) SetWAKEUP_WAKEUPEN8(value uint32) {
	volatile.StoreUint32(&o.WAKEUP.Reg, volatile.LoadUint32(&o.WAKEUP.Reg)&^(0x100)|value<<8)
}
func (o *EIC_Type) GetWAKEUP_WAKEUPEN8() uint32 {
	return (volatile.LoadUint32(&o.WAKEUP.Reg) & 0x100) >> 8
}
func (o *EIC_Type) SetWAKEUP_WAKEUPEN9(value uint32) {
	volatile.StoreUint32(&o.WAKEUP.Reg, volatile.LoadUint32(&o.WAKEUP.Reg)&^(0x200)|value<<9)
}
func (o *EIC_Type) GetWAKEUP_WAKEUPEN9() uint32 {
	return (volatile.LoadUint32(&o.WAKEUP.Reg) & 0x200) >> 9
}
func (o *EIC_Type) SetWAKEUP_WAKEUPEN10(value uint32) {
	volatile.StoreUint32(&o.WAKEUP.Reg, volatile.LoadUint32(&o.WAKEUP.Reg)&^(0x400)|value<<10)
}
func (o *EIC_Type) GetWAKEUP_WAKEUPEN10() uint32 {
	return (volatile.LoadUint32(&o.WAKEUP.Reg) & 0x400) >> 10
}
func (o *EIC_Type) SetWAKEUP_WAKEUPEN11(value uint32) {
	volatile.StoreUint32(&o.WAKEUP.Reg, volatile.LoadUint32(&o.WAKEUP.Reg)&^(0x800)|value<<11)
}
func (o *EIC_Type) GetWAKEUP_WAKEUPEN11() uint32 {
	return (volatile.LoadUint32(&o.WAKEUP.Reg) & 0x800) >> 11
}
func (o *EIC_Type) SetWAKEUP_WAKEUPEN12(value uint32) {
	volatile.StoreUint32(&o.WAKEUP.Reg, volatile.LoadUint32(&o.WAKEUP.Reg)&^(0x1000)|value<<12)
}
func (o *EIC_Type) GetWAKEUP_WAKEUPEN12() uint32 {
	return (volatile.LoadUint32(&o.WAKEUP.Reg) & 0x1000) >> 12
}
func (o *EIC_Type) SetWAKEUP_WAKEUPEN13(value uint32) {
	volatile.StoreUint32(&o.WAKEUP.Reg, volatile.LoadUint32(&o.WAKEUP.Reg)&^(0x2000)|value<<13)
}
func (o *EIC_Type) GetWAKEUP_WAKEUPEN13() uint32 {
	return (volatile.LoadUint32(&o.WAKEUP.Reg) & 0x2000) >> 13
}
func (o *EIC_Type) SetWAKEUP_WAKEUPEN14(value uint32) {
	volatile.StoreUint32(&o.WAKEUP.Reg, volatile.LoadUint32(&o.WAKEUP.Reg)&^(0x4000)|value<<14)
}
func (o *EIC_Type) GetWAKEUP_WAKEUPEN14() uint32 {
	return (volatile.LoadUint32(&o.WAKEUP.Reg) & 0x4000) >> 14
}
func (o *EIC_Type) SetWAKEUP_WAKEUPEN15(value uint32) {
	volatile.StoreUint32(&o.WAKEUP.Reg, volatile.LoadUint32(&o.WAKEUP.Reg)&^(0x8000)|value<<15)
}
func (o *EIC_Type) GetWAKEUP_WAKEUPEN15() uint32 {
	return (volatile.LoadUint32(&o.WAKEUP.Reg) & 0x8000) >> 15
}

// EIC.CONFIG0: Configuration n
func (o *EIC_Type) SetCONFIG0_SENSE0(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x7)|value)
}
func (o *EIC_Type) GetCONFIG0_SENSE0() uint32 {
	return volatile.LoadUint32(&o.CONFIG0.Reg) & 0x7
}
func (o *EIC_Type) SetCONFIG0_FILTEN0(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x8)|value<<3)
}
func (o *EIC_Type) GetCONFIG0_FILTEN0() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x8) >> 3
}
func (o *EIC_Type) SetCONFIG0_SENSE1(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x70)|value<<4)
}
func (o *EIC_Type) GetCONFIG0_SENSE1() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x70) >> 4
}
func (o *EIC_Type) SetCONFIG0_FILTEN1(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x80)|value<<7)
}
func (o *EIC_Type) GetCONFIG0_FILTEN1() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x80) >> 7
}
func (o *EIC_Type) SetCONFIG0_SENSE2(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x700)|value<<8)
}
func (o *EIC_Type) GetCONFIG0_SENSE2() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x700) >> 8
}
func (o *EIC_Type) SetCONFIG0_FILTEN2(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x800)|value<<11)
}
func (o *EIC_Type) GetCONFIG0_FILTEN2() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x800) >> 11
}
func (o *EIC_Type) SetCONFIG0_SENSE3(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x7000)|value<<12)
}
func (o *EIC_Type) GetCONFIG0_SENSE3() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x7000) >> 12
}
func (o *EIC_Type) SetCONFIG0_FILTEN3(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x8000)|value<<15)
}
func (o *EIC_Type) GetCONFIG0_FILTEN3() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x8000) >> 15
}
func (o *EIC_Type) SetCONFIG0_SENSE4(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x70000)|value<<16)
}
func (o *EIC_Type) GetCONFIG0_SENSE4() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x70000) >> 16
}
func (o *EIC_Type) SetCONFIG0_FILTEN4(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x80000)|value<<19)
}
func (o *EIC_Type) GetCONFIG0_FILTEN4() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x80000) >> 19
}
func (o *EIC_Type) SetCONFIG0_SENSE5(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x700000)|value<<20)
}
func (o *EIC_Type) GetCONFIG0_SENSE5() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x700000) >> 20
}
func (o *EIC_Type) SetCONFIG0_FILTEN5(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x800000)|value<<23)
}
func (o *EIC_Type) GetCONFIG0_FILTEN5() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x800000) >> 23
}
func (o *EIC_Type) SetCONFIG0_SENSE6(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x7000000)|value<<24)
}
func (o *EIC_Type) GetCONFIG0_SENSE6() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x7000000) >> 24
}
func (o *EIC_Type) SetCONFIG0_FILTEN6(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x8000000)|value<<27)
}
func (o *EIC_Type) GetCONFIG0_FILTEN6() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x8000000) >> 27
}
func (o *EIC_Type) SetCONFIG0_SENSE7(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x70000000)|value<<28)
}
func (o *EIC_Type) GetCONFIG0_SENSE7() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x70000000) >> 28
}
func (o *EIC_Type) SetCONFIG0_FILTEN7(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x80000000)|value<<31)
}
func (o *EIC_Type) GetCONFIG0_FILTEN7() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x80000000) >> 31
}

// EIC.CONFIG1: Configuration n
func (o *EIC_Type) SetCONFIG1_SENSE0(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x7)|value)
}
func (o *EIC_Type) GetCONFIG1_SENSE0() uint32 {
	return volatile.LoadUint32(&o.CONFIG1.Reg) & 0x7
}
func (o *EIC_Type) SetCONFIG1_FILTEN0(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x8)|value<<3)
}
func (o *EIC_Type) GetCONFIG1_FILTEN0() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x8) >> 3
}
func (o *EIC_Type) SetCONFIG1_SENSE1(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x70)|value<<4)
}
func (o *EIC_Type) GetCONFIG1_SENSE1() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x70) >> 4
}
func (o *EIC_Type) SetCONFIG1_FILTEN1(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x80)|value<<7)
}
func (o *EIC_Type) GetCONFIG1_FILTEN1() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x80) >> 7
}
func (o *EIC_Type) SetCONFIG1_SENSE2(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x700)|value<<8)
}
func (o *EIC_Type) GetCONFIG1_SENSE2() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x700) >> 8
}
func (o *EIC_Type) SetCONFIG1_FILTEN2(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x800)|value<<11)
}
func (o *EIC_Type) GetCONFIG1_FILTEN2() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x800) >> 11
}
func (o *EIC_Type) SetCONFIG1_SENSE3(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x7000)|value<<12)
}
func (o *EIC_Type) GetCONFIG1_SENSE3() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x7000) >> 12
}
func (o *EIC_Type) SetCONFIG1_FILTEN3(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x8000)|value<<15)
}
func (o *EIC_Type) GetCONFIG1_FILTEN3() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x8000) >> 15
}
func (o *EIC_Type) SetCONFIG1_SENSE4(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x70000)|value<<16)
}
func (o *EIC_Type) GetCONFIG1_SENSE4() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x70000) >> 16
}
func (o *EIC_Type) SetCONFIG1_FILTEN4(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x80000)|value<<19)
}
func (o *EIC_Type) GetCONFIG1_FILTEN4() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x80000) >> 19
}
func (o *EIC_Type) SetCONFIG1_SENSE5(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x700000)|value<<20)
}
func (o *EIC_Type) GetCONFIG1_SENSE5() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x700000) >> 20
}
func (o *EIC_Type) SetCONFIG1_FILTEN5(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x800000)|value<<23)
}
func (o *EIC_Type) GetCONFIG1_FILTEN5() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x800000) >> 23
}
func (o *EIC_Type) SetCONFIG1_SENSE6(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x7000000)|value<<24)
}
func (o *EIC_Type) GetCONFIG1_SENSE6() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x7000000) >> 24
}
func (o *EIC_Type) SetCONFIG1_FILTEN6(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x8000000)|value<<27)
}
func (o *EIC_Type) GetCONFIG1_FILTEN6() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x8000000) >> 27
}
func (o *EIC_Type) SetCONFIG1_SENSE7(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x70000000)|value<<28)
}
func (o *EIC_Type) GetCONFIG1_SENSE7() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x70000000) >> 28
}
func (o *EIC_Type) SetCONFIG1_FILTEN7(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x80000000)|value<<31)
}
func (o *EIC_Type) GetCONFIG1_FILTEN7() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x80000000) >> 31
}

// Event System Interface
type EVSYS_Type struct {
	CTRL     volatile.Register8 // 0x0
	_        [3]byte
	CHANNEL  volatile.Register32 // 0x4
	USER     volatile.Register16 // 0x8
	_        [2]byte
	CHSTATUS volatile.Register32 // 0xC
	INTENCLR volatile.Register32 // 0x10
	INTENSET volatile.Register32 // 0x14
	INTFLAG  volatile.Register32 // 0x18
}

// EVSYS.CTRL: Control
func (o *EVSYS_Type) SetCTRL_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetCTRL_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRL.Reg) & 0x1
}
func (o *EVSYS_Type) SetCTRL_GCLKREQ(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EVSYS_Type) GetCTRL_GCLKREQ() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x10) >> 4
}

// EVSYS.CHANNEL: Channel
func (o *EVSYS_Type) SetCHANNEL(value uint32) {
	volatile.StoreUint32(&o.CHANNEL.Reg, volatile.LoadUint32(&o.CHANNEL.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetCHANNEL() uint32 {
	return volatile.LoadUint32(&o.CHANNEL.Reg) & 0xf
}
func (o *EVSYS_Type) SetCHANNEL_SWEVT(value uint32) {
	volatile.StoreUint32(&o.CHANNEL.Reg, volatile.LoadUint32(&o.CHANNEL.Reg)&^(0x100)|value<<8)
}
func (o *EVSYS_Type) GetCHANNEL_SWEVT() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL.Reg) & 0x100) >> 8
}
func (o *EVSYS_Type) SetCHANNEL_EVGEN(value uint32) {
	volatile.StoreUint32(&o.CHANNEL.Reg, volatile.LoadUint32(&o.CHANNEL.Reg)&^(0x7f0000)|value<<16)
}
func (o *EVSYS_Type) GetCHANNEL_EVGEN() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL.Reg) & 0x7f0000) >> 16
}
func (o *EVSYS_Type) SetCHANNEL_PATH(value uint32) {
	volatile.StoreUint32(&o.CHANNEL.Reg, volatile.LoadUint32(&o.CHANNEL.Reg)&^(0x3000000)|value<<24)
}
func (o *EVSYS_Type) GetCHANNEL_PATH() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL.Reg) & 0x3000000) >> 24
}
func (o *EVSYS_Type) SetCHANNEL_EDGSEL(value uint32) {
	volatile.StoreUint32(&o.CHANNEL.Reg, volatile.LoadUint32(&o.CHANNEL.Reg)&^(0xc000000)|value<<26)
}
func (o *EVSYS_Type) GetCHANNEL_EDGSEL() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL.Reg) & 0xc000000) >> 26
}

// EVSYS.USER: User Multiplexer
func (o *EVSYS_Type) SetUSER(value uint16) {
	volatile.StoreUint16(&o.USER.Reg, volatile.LoadUint16(&o.USER.Reg)&^(0x1f)|value)
}
func (o *EVSYS_Type) GetUSER() uint16 {
	return volatile.LoadUint16(&o.USER.Reg) & 0x1f
}
func (o *EVSYS_Type) SetUSER_CHANNEL(value uint16) {
	volatile.StoreUint16(&o.USER.Reg, volatile.LoadUint16(&o.USER.Reg)&^(0x1f00)|value<<8)
}
func (o *EVSYS_Type) GetUSER_CHANNEL() uint16 {
	return (volatile.LoadUint16(&o.USER.Reg) & 0x1f00) >> 8
}

// EVSYS.CHSTATUS: Channel Status
func (o *EVSYS_Type) SetCHSTATUS_USRRDY0(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY0() uint32 {
	return volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x1
}
func (o *EVSYS_Type) SetCHSTATUS_USRRDY1(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY1() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x2) >> 1
}
func (o *EVSYS_Type) SetCHSTATUS_USRRDY2(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY2() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x4) >> 2
}
func (o *EVSYS_Type) SetCHSTATUS_USRRDY3(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY3() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x8) >> 3
}
func (o *EVSYS_Type) SetCHSTATUS_USRRDY4(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY4() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x10) >> 4
}
func (o *EVSYS_Type) SetCHSTATUS_USRRDY5(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY5() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x20) >> 5
}
func (o *EVSYS_Type) SetCHSTATUS_USRRDY6(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY6() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x40) >> 6
}
func (o *EVSYS_Type) SetCHSTATUS_USRRDY7(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY7() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x80) >> 7
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY0(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x100)|value<<8)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY0() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x100) >> 8
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY1(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x200)|value<<9)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY1() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x200) >> 9
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY2(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x400)|value<<10)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY2() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x400) >> 10
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY3(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x800)|value<<11)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY3() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x800) >> 11
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY4(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x1000)|value<<12)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY4() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x1000) >> 12
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY5(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x2000)|value<<13)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY5() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x2000) >> 13
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY6(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x4000)|value<<14)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY6() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x4000) >> 14
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY7(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x8000)|value<<15)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY7() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x8000) >> 15
}
func (o *EVSYS_Type) SetCHSTATUS_USRRDY8(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x10000)|value<<16)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY8() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x10000) >> 16
}
func (o *EVSYS_Type) SetCHSTATUS_USRRDY9(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x20000)|value<<17)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY9() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x20000) >> 17
}
func (o *EVSYS_Type) SetCHSTATUS_USRRDY10(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x40000)|value<<18)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY10() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x40000) >> 18
}
func (o *EVSYS_Type) SetCHSTATUS_USRRDY11(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x80000)|value<<19)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY11() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x80000) >> 19
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY8(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY8() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x1000000) >> 24
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY9(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x2000000)|value<<25)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY9() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x2000000) >> 25
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY10(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY10() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x4000000) >> 26
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY11(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x8000000)|value<<27)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY11() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x8000000) >> 27
}

// EVSYS.INTENCLR: Interrupt Enable Clear
func (o *EVSYS_Type) SetINTENCLR_OVR0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetINTENCLR_OVR0() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *EVSYS_Type) SetINTENCLR_OVR1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_Type) GetINTENCLR_OVR1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *EVSYS_Type) SetINTENCLR_OVR2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *EVSYS_Type) GetINTENCLR_OVR2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *EVSYS_Type) SetINTENCLR_OVR3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *EVSYS_Type) GetINTENCLR_OVR3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *EVSYS_Type) SetINTENCLR_OVR4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *EVSYS_Type) GetINTENCLR_OVR4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *EVSYS_Type) SetINTENCLR_OVR5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *EVSYS_Type) GetINTENCLR_OVR5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *EVSYS_Type) SetINTENCLR_OVR6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *EVSYS_Type) GetINTENCLR_OVR6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *EVSYS_Type) SetINTENCLR_OVR7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *EVSYS_Type) GetINTENCLR_OVR7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *EVSYS_Type) SetINTENCLR_EVD0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *EVSYS_Type) GetINTENCLR_EVD0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *EVSYS_Type) SetINTENCLR_EVD1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *EVSYS_Type) GetINTENCLR_EVD1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *EVSYS_Type) SetINTENCLR_EVD2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *EVSYS_Type) GetINTENCLR_EVD2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *EVSYS_Type) SetINTENCLR_EVD3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *EVSYS_Type) GetINTENCLR_EVD3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *EVSYS_Type) SetINTENCLR_EVD4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *EVSYS_Type) GetINTENCLR_EVD4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *EVSYS_Type) SetINTENCLR_EVD5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *EVSYS_Type) GetINTENCLR_EVD5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *EVSYS_Type) SetINTENCLR_EVD6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *EVSYS_Type) GetINTENCLR_EVD6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *EVSYS_Type) SetINTENCLR_EVD7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *EVSYS_Type) GetINTENCLR_EVD7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}
func (o *EVSYS_Type) SetINTENCLR_OVR8(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *EVSYS_Type) GetINTENCLR_OVR8() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *EVSYS_Type) SetINTENCLR_OVR9(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *EVSYS_Type) GetINTENCLR_OVR9() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *EVSYS_Type) SetINTENCLR_OVR10(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *EVSYS_Type) GetINTENCLR_OVR10() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *EVSYS_Type) SetINTENCLR_OVR11(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *EVSYS_Type) GetINTENCLR_OVR11() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *EVSYS_Type) SetINTENCLR_EVD8(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *EVSYS_Type) GetINTENCLR_EVD8() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000000) >> 24
}
func (o *EVSYS_Type) SetINTENCLR_EVD9(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *EVSYS_Type) GetINTENCLR_EVD9() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000000) >> 25
}
func (o *EVSYS_Type) SetINTENCLR_EVD10(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *EVSYS_Type) GetINTENCLR_EVD10() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000000) >> 26
}
func (o *EVSYS_Type) SetINTENCLR_EVD11(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *EVSYS_Type) GetINTENCLR_EVD11() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000000) >> 27
}

// EVSYS.INTENSET: Interrupt Enable Set
func (o *EVSYS_Type) SetINTENSET_OVR0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetINTENSET_OVR0() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *EVSYS_Type) SetINTENSET_OVR1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_Type) GetINTENSET_OVR1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *EVSYS_Type) SetINTENSET_OVR2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *EVSYS_Type) GetINTENSET_OVR2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *EVSYS_Type) SetINTENSET_OVR3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *EVSYS_Type) GetINTENSET_OVR3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *EVSYS_Type) SetINTENSET_OVR4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *EVSYS_Type) GetINTENSET_OVR4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *EVSYS_Type) SetINTENSET_OVR5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *EVSYS_Type) GetINTENSET_OVR5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *EVSYS_Type) SetINTENSET_OVR6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *EVSYS_Type) GetINTENSET_OVR6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *EVSYS_Type) SetINTENSET_OVR7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *EVSYS_Type) GetINTENSET_OVR7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *EVSYS_Type) SetINTENSET_EVD0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *EVSYS_Type) GetINTENSET_EVD0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *EVSYS_Type) SetINTENSET_EVD1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *EVSYS_Type) GetINTENSET_EVD1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *EVSYS_Type) SetINTENSET_EVD2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *EVSYS_Type) GetINTENSET_EVD2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *EVSYS_Type) SetINTENSET_EVD3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *EVSYS_Type) GetINTENSET_EVD3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *EVSYS_Type) SetINTENSET_EVD4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *EVSYS_Type) GetINTENSET_EVD4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *EVSYS_Type) SetINTENSET_EVD5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *EVSYS_Type) GetINTENSET_EVD5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *EVSYS_Type) SetINTENSET_EVD6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *EVSYS_Type) GetINTENSET_EVD6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *EVSYS_Type) SetINTENSET_EVD7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *EVSYS_Type) GetINTENSET_EVD7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}
func (o *EVSYS_Type) SetINTENSET_OVR8(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *EVSYS_Type) GetINTENSET_OVR8() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *EVSYS_Type) SetINTENSET_OVR9(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *EVSYS_Type) GetINTENSET_OVR9() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *EVSYS_Type) SetINTENSET_OVR10(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *EVSYS_Type) GetINTENSET_OVR10() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *EVSYS_Type) SetINTENSET_OVR11(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *EVSYS_Type) GetINTENSET_OVR11() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *EVSYS_Type) SetINTENSET_EVD8(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000000)|value<<24)
}
func (o *EVSYS_Type) GetINTENSET_EVD8() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000000) >> 24
}
func (o *EVSYS_Type) SetINTENSET_EVD9(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000000)|value<<25)
}
func (o *EVSYS_Type) GetINTENSET_EVD9() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000000) >> 25
}
func (o *EVSYS_Type) SetINTENSET_EVD10(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000000)|value<<26)
}
func (o *EVSYS_Type) GetINTENSET_EVD10() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000000) >> 26
}
func (o *EVSYS_Type) SetINTENSET_EVD11(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000000)|value<<27)
}
func (o *EVSYS_Type) GetINTENSET_EVD11() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000000) >> 27
}

// EVSYS.INTFLAG: Interrupt Flag Status and Clear
func (o *EVSYS_Type) SetINTFLAG_OVR0(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetINTFLAG_OVR0() uint32 {
	return volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1
}
func (o *EVSYS_Type) SetINTFLAG_OVR1(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_Type) GetINTFLAG_OVR1() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *EVSYS_Type) SetINTFLAG_OVR2(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *EVSYS_Type) GetINTFLAG_OVR2() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *EVSYS_Type) SetINTFLAG_OVR3(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *EVSYS_Type) GetINTFLAG_OVR3() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *EVSYS_Type) SetINTFLAG_OVR4(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *EVSYS_Type) GetINTFLAG_OVR4() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *EVSYS_Type) SetINTFLAG_OVR5(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *EVSYS_Type) GetINTFLAG_OVR5() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *EVSYS_Type) SetINTFLAG_OVR6(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x40)|value<<6)
}
func (o *EVSYS_Type) GetINTFLAG_OVR6() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x40) >> 6
}
func (o *EVSYS_Type) SetINTFLAG_OVR7(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *EVSYS_Type) GetINTFLAG_OVR7() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x80) >> 7
}
func (o *EVSYS_Type) SetINTFLAG_EVD0(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x100)|value<<8)
}
func (o *EVSYS_Type) GetINTFLAG_EVD0() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x100) >> 8
}
func (o *EVSYS_Type) SetINTFLAG_EVD1(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x200)|value<<9)
}
func (o *EVSYS_Type) GetINTFLAG_EVD1() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x200) >> 9
}
func (o *EVSYS_Type) SetINTFLAG_EVD2(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x400)|value<<10)
}
func (o *EVSYS_Type) GetINTFLAG_EVD2() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x400) >> 10
}
func (o *EVSYS_Type) SetINTFLAG_EVD3(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x800)|value<<11)
}
func (o *EVSYS_Type) GetINTFLAG_EVD3() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x800) >> 11
}
func (o *EVSYS_Type) SetINTFLAG_EVD4(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1000)|value<<12)
}
func (o *EVSYS_Type) GetINTFLAG_EVD4() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1000) >> 12
}
func (o *EVSYS_Type) SetINTFLAG_EVD5(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x2000)|value<<13)
}
func (o *EVSYS_Type) GetINTFLAG_EVD5() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x2000) >> 13
}
func (o *EVSYS_Type) SetINTFLAG_EVD6(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x4000)|value<<14)
}
func (o *EVSYS_Type) GetINTFLAG_EVD6() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x4000) >> 14
}
func (o *EVSYS_Type) SetINTFLAG_EVD7(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x8000)|value<<15)
}
func (o *EVSYS_Type) GetINTFLAG_EVD7() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x8000) >> 15
}
func (o *EVSYS_Type) SetINTFLAG_OVR8(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x10000)|value<<16)
}
func (o *EVSYS_Type) GetINTFLAG_OVR8() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x10000) >> 16
}
func (o *EVSYS_Type) SetINTFLAG_OVR9(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x20000)|value<<17)
}
func (o *EVSYS_Type) GetINTFLAG_OVR9() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x20000) >> 17
}
func (o *EVSYS_Type) SetINTFLAG_OVR10(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x40000)|value<<18)
}
func (o *EVSYS_Type) GetINTFLAG_OVR10() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x40000) >> 18
}
func (o *EVSYS_Type) SetINTFLAG_OVR11(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x80000)|value<<19)
}
func (o *EVSYS_Type) GetINTFLAG_OVR11() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x80000) >> 19
}
func (o *EVSYS_Type) SetINTFLAG_EVD8(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1000000)|value<<24)
}
func (o *EVSYS_Type) GetINTFLAG_EVD8() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1000000) >> 24
}
func (o *EVSYS_Type) SetINTFLAG_EVD9(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x2000000)|value<<25)
}
func (o *EVSYS_Type) GetINTFLAG_EVD9() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x2000000) >> 25
}
func (o *EVSYS_Type) SetINTFLAG_EVD10(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x4000000)|value<<26)
}
func (o *EVSYS_Type) GetINTFLAG_EVD10() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x4000000) >> 26
}
func (o *EVSYS_Type) SetINTFLAG_EVD11(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x8000000)|value<<27)
}
func (o *EVSYS_Type) GetINTFLAG_EVD11() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x8000000) >> 27
}

// Generic Clock Generator
type GCLK_Type struct {
	CTRL    volatile.Register8  // 0x0
	STATUS  volatile.Register8  // 0x1
	CLKCTRL volatile.Register16 // 0x2
	GENCTRL volatile.Register32 // 0x4
	GENDIV  volatile.Register32 // 0x8
}

// GCLK.CTRL: Control
func (o *GCLK_Type) SetCTRL_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *GCLK_Type) GetCTRL_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRL.Reg) & 0x1
}

// GCLK.STATUS: Status
func (o *GCLK_Type) SetSTATUS_SYNCBUSY(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetSTATUS_SYNCBUSY() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x80) >> 7
}

// GCLK.CLKCTRL: Generic Clock Control
func (o *GCLK_Type) SetCLKCTRL_ID(value uint16) {
	volatile.StoreUint16(&o.CLKCTRL.Reg, volatile.LoadUint16(&o.CLKCTRL.Reg)&^(0x3f)|value)
}
func (o *GCLK_Type) GetCLKCTRL_ID() uint16 {
	return volatile.LoadUint16(&o.CLKCTRL.Reg) & 0x3f
}
func (o *GCLK_Type) SetCLKCTRL_GEN(value uint16) {
	volatile.StoreUint16(&o.CLKCTRL.Reg, volatile.LoadUint16(&o.CLKCTRL.Reg)&^(0xf00)|value<<8)
}
func (o *GCLK_Type) GetCLKCTRL_GEN() uint16 {
	return (volatile.LoadUint16(&o.CLKCTRL.Reg) & 0xf00) >> 8
}
func (o *GCLK_Type) SetCLKCTRL_CLKEN(value uint16) {
	volatile.StoreUint16(&o.CLKCTRL.Reg, volatile.LoadUint16(&o.CLKCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *GCLK_Type) GetCLKCTRL_CLKEN() uint16 {
	return (volatile.LoadUint16(&o.CLKCTRL.Reg) & 0x4000) >> 14
}
func (o *GCLK_Type) SetCLKCTRL_WRTLOCK(value uint16) {
	volatile.StoreUint16(&o.CLKCTRL.Reg, volatile.LoadUint16(&o.CLKCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *GCLK_Type) GetCLKCTRL_WRTLOCK() uint16 {
	return (volatile.LoadUint16(&o.CLKCTRL.Reg) & 0x8000) >> 15
}

// GCLK.GENCTRL: Generic Clock Generator Control
func (o *GCLK_Type) SetGENCTRL_ID(value uint32) {
	volatile.StoreUint32(&o.GENCTRL.Reg, volatile.LoadUint32(&o.GENCTRL.Reg)&^(0xf)|value)
}
func (o *GCLK_Type) GetGENCTRL_ID() uint32 {
	return volatile.LoadUint32(&o.GENCTRL.Reg) & 0xf
}
func (o *GCLK_Type) SetGENCTRL_SRC(value uint32) {
	volatile.StoreUint32(&o.GENCTRL.Reg, volatile.LoadUint32(&o.GENCTRL.Reg)&^(0x1f00)|value<<8)
}
func (o *GCLK_Type) GetGENCTRL_SRC() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL.Reg) & 0x1f00) >> 8
}
func (o *GCLK_Type) SetGENCTRL_GENEN(value uint32) {
	volatile.StoreUint32(&o.GENCTRL.Reg, volatile.LoadUint32(&o.GENCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *GCLK_Type) GetGENCTRL_GENEN() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL.Reg) & 0x10000) >> 16
}
func (o *GCLK_Type) SetGENCTRL_IDC(value uint32) {
	volatile.StoreUint32(&o.GENCTRL.Reg, volatile.LoadUint32(&o.GENCTRL.Reg)&^(0x20000)|value<<17)
}
func (o *GCLK_Type) GetGENCTRL_IDC() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL.Reg) & 0x20000) >> 17
}
func (o *GCLK_Type) SetGENCTRL_OOV(value uint32) {
	volatile.StoreUint32(&o.GENCTRL.Reg, volatile.LoadUint32(&o.GENCTRL.Reg)&^(0x40000)|value<<18)
}
func (o *GCLK_Type) GetGENCTRL_OOV() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL.Reg) & 0x40000) >> 18
}
func (o *GCLK_Type) SetGENCTRL_OE(value uint32) {
	volatile.StoreUint32(&o.GENCTRL.Reg, volatile.LoadUint32(&o.GENCTRL.Reg)&^(0x80000)|value<<19)
}
func (o *GCLK_Type) GetGENCTRL_OE() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL.Reg) & 0x80000) >> 19
}
func (o *GCLK_Type) SetGENCTRL_DIVSEL(value uint32) {
	volatile.StoreUint32(&o.GENCTRL.Reg, volatile.LoadUint32(&o.GENCTRL.Reg)&^(0x100000)|value<<20)
}
func (o *GCLK_Type) GetGENCTRL_DIVSEL() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL.Reg) & 0x100000) >> 20
}
func (o *GCLK_Type) SetGENCTRL_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.GENCTRL.Reg, volatile.LoadUint32(&o.GENCTRL.Reg)&^(0x200000)|value<<21)
}
func (o *GCLK_Type) GetGENCTRL_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL.Reg) & 0x200000) >> 21
}

// GCLK.GENDIV: Generic Clock Generator Division
func (o *GCLK_Type) SetGENDIV_ID(value uint32) {
	volatile.StoreUint32(&o.GENDIV.Reg, volatile.LoadUint32(&o.GENDIV.Reg)&^(0xf)|value)
}
func (o *GCLK_Type) GetGENDIV_ID() uint32 {
	return volatile.LoadUint32(&o.GENDIV.Reg) & 0xf
}
func (o *GCLK_Type) SetGENDIV_DIV(value uint32) {
	volatile.StoreUint32(&o.GENDIV.Reg, volatile.LoadUint32(&o.GENDIV.Reg)&^(0xffff00)|value<<8)
}
func (o *GCLK_Type) GetGENDIV_DIV() uint32 {
	return (volatile.LoadUint32(&o.GENDIV.Reg) & 0xffff00) >> 8
}

// HSB Matrix
type HMATRIXB_Type struct {
	_      [128]byte
	PRAS0  volatile.Register32 // 0x80
	PRBS0  volatile.Register32 // 0x84
	PRAS1  volatile.Register32 // 0x88
	PRBS1  volatile.Register32 // 0x8C
	PRAS2  volatile.Register32 // 0x90
	PRBS2  volatile.Register32 // 0x94
	PRAS3  volatile.Register32 // 0x98
	PRBS3  volatile.Register32 // 0x9C
	PRAS4  volatile.Register32 // 0xA0
	PRBS4  volatile.Register32 // 0xA4
	PRAS5  volatile.Register32 // 0xA8
	PRBS5  volatile.Register32 // 0xAC
	PRAS6  volatile.Register32 // 0xB0
	PRBS6  volatile.Register32 // 0xB4
	PRAS7  volatile.Register32 // 0xB8
	PRBS7  volatile.Register32 // 0xBC
	PRAS8  volatile.Register32 // 0xC0
	PRBS8  volatile.Register32 // 0xC4
	PRAS9  volatile.Register32 // 0xC8
	PRBS9  volatile.Register32 // 0xCC
	PRAS10 volatile.Register32 // 0xD0
	PRBS10 volatile.Register32 // 0xD4
	PRAS11 volatile.Register32 // 0xD8
	PRBS11 volatile.Register32 // 0xDC
	PRAS12 volatile.Register32 // 0xE0
	PRBS12 volatile.Register32 // 0xE4
	PRAS13 volatile.Register32 // 0xE8
	PRBS13 volatile.Register32 // 0xEC
	PRAS14 volatile.Register32 // 0xF0
	PRBS14 volatile.Register32 // 0xF4
	PRAS15 volatile.Register32 // 0xF8
	PRBS15 volatile.Register32 // 0xFC
	_      [16]byte
	SFR0   volatile.Register32 // 0x110
	SFR1   volatile.Register32 // 0x114
	SFR2   volatile.Register32 // 0x118
	SFR3   volatile.Register32 // 0x11C
	SFR4   volatile.Register32 // 0x120
	SFR5   volatile.Register32 // 0x124
	SFR6   volatile.Register32 // 0x128
	SFR7   volatile.Register32 // 0x12C
	SFR8   volatile.Register32 // 0x130
	SFR9   volatile.Register32 // 0x134
	SFR10  volatile.Register32 // 0x138
	SFR11  volatile.Register32 // 0x13C
	SFR12  volatile.Register32 // 0x140
	SFR13  volatile.Register32 // 0x144
	SFR14  volatile.Register32 // 0x148
	SFR15  volatile.Register32 // 0x14C
}

// HMATRIXB.SFR0: Special Function
func (o *HMATRIXB_Type) SetSFR0(value uint32) {
	volatile.StoreUint32(&o.SFR0.Reg, value)
}
func (o *HMATRIXB_Type) GetSFR0() uint32 {
	return volatile.LoadUint32(&o.SFR0.Reg)
}

// HMATRIXB.SFR1: Special Function
func (o *HMATRIXB_Type) SetSFR1(value uint32) {
	volatile.StoreUint32(&o.SFR1.Reg, value)
}
func (o *HMATRIXB_Type) GetSFR1() uint32 {
	return volatile.LoadUint32(&o.SFR1.Reg)
}

// HMATRIXB.SFR2: Special Function
func (o *HMATRIXB_Type) SetSFR2(value uint32) {
	volatile.StoreUint32(&o.SFR2.Reg, value)
}
func (o *HMATRIXB_Type) GetSFR2() uint32 {
	return volatile.LoadUint32(&o.SFR2.Reg)
}

// HMATRIXB.SFR3: Special Function
func (o *HMATRIXB_Type) SetSFR3(value uint32) {
	volatile.StoreUint32(&o.SFR3.Reg, value)
}
func (o *HMATRIXB_Type) GetSFR3() uint32 {
	return volatile.LoadUint32(&o.SFR3.Reg)
}

// HMATRIXB.SFR4: Special Function
func (o *HMATRIXB_Type) SetSFR4(value uint32) {
	volatile.StoreUint32(&o.SFR4.Reg, value)
}
func (o *HMATRIXB_Type) GetSFR4() uint32 {
	return volatile.LoadUint32(&o.SFR4.Reg)
}

// HMATRIXB.SFR5: Special Function
func (o *HMATRIXB_Type) SetSFR5(value uint32) {
	volatile.StoreUint32(&o.SFR5.Reg, value)
}
func (o *HMATRIXB_Type) GetSFR5() uint32 {
	return volatile.LoadUint32(&o.SFR5.Reg)
}

// HMATRIXB.SFR6: Special Function
func (o *HMATRIXB_Type) SetSFR6(value uint32) {
	volatile.StoreUint32(&o.SFR6.Reg, value)
}
func (o *HMATRIXB_Type) GetSFR6() uint32 {
	return volatile.LoadUint32(&o.SFR6.Reg)
}

// HMATRIXB.SFR7: Special Function
func (o *HMATRIXB_Type) SetSFR7(value uint32) {
	volatile.StoreUint32(&o.SFR7.Reg, value)
}
func (o *HMATRIXB_Type) GetSFR7() uint32 {
	return volatile.LoadUint32(&o.SFR7.Reg)
}

// HMATRIXB.SFR8: Special Function
func (o *HMATRIXB_Type) SetSFR8(value uint32) {
	volatile.StoreUint32(&o.SFR8.Reg, value)
}
func (o *HMATRIXB_Type) GetSFR8() uint32 {
	return volatile.LoadUint32(&o.SFR8.Reg)
}

// HMATRIXB.SFR9: Special Function
func (o *HMATRIXB_Type) SetSFR9(value uint32) {
	volatile.StoreUint32(&o.SFR9.Reg, value)
}
func (o *HMATRIXB_Type) GetSFR9() uint32 {
	return volatile.LoadUint32(&o.SFR9.Reg)
}

// HMATRIXB.SFR10: Special Function
func (o *HMATRIXB_Type) SetSFR10(value uint32) {
	volatile.StoreUint32(&o.SFR10.Reg, value)
}
func (o *HMATRIXB_Type) GetSFR10() uint32 {
	return volatile.LoadUint32(&o.SFR10.Reg)
}

// HMATRIXB.SFR11: Special Function
func (o *HMATRIXB_Type) SetSFR11(value uint32) {
	volatile.StoreUint32(&o.SFR11.Reg, value)
}
func (o *HMATRIXB_Type) GetSFR11() uint32 {
	return volatile.LoadUint32(&o.SFR11.Reg)
}

// HMATRIXB.SFR12: Special Function
func (o *HMATRIXB_Type) SetSFR12(value uint32) {
	volatile.StoreUint32(&o.SFR12.Reg, value)
}
func (o *HMATRIXB_Type) GetSFR12() uint32 {
	return volatile.LoadUint32(&o.SFR12.Reg)
}

// HMATRIXB.SFR13: Special Function
func (o *HMATRIXB_Type) SetSFR13(value uint32) {
	volatile.StoreUint32(&o.SFR13.Reg, value)
}
func (o *HMATRIXB_Type) GetSFR13() uint32 {
	return volatile.LoadUint32(&o.SFR13.Reg)
}

// HMATRIXB.SFR14: Special Function
func (o *HMATRIXB_Type) SetSFR14(value uint32) {
	volatile.StoreUint32(&o.SFR14.Reg, value)
}
func (o *HMATRIXB_Type) GetSFR14() uint32 {
	return volatile.LoadUint32(&o.SFR14.Reg)
}

// HMATRIXB.SFR15: Special Function
func (o *HMATRIXB_Type) SetSFR15(value uint32) {
	volatile.StoreUint32(&o.SFR15.Reg, value)
}
func (o *HMATRIXB_Type) GetSFR15() uint32 {
	return volatile.LoadUint32(&o.SFR15.Reg)
}

// Inter-IC Sound Interface
type I2S_Type struct {
	CTRLA    volatile.Register8 // 0x0
	_        [3]byte
	CLKCTRL0 volatile.Register32 // 0x4
	CLKCTRL1 volatile.Register32 // 0x8
	INTENCLR volatile.Register16 // 0xC
	_        [2]byte
	INTENSET volatile.Register16 // 0x10
	_        [2]byte
	INTFLAG  volatile.Register16 // 0x14
	_        [2]byte
	SYNCBUSY volatile.Register16 // 0x18
	_        [6]byte
	SERCTRL0 volatile.Register32 // 0x20
	SERCTRL1 volatile.Register32 // 0x24
	_        [8]byte
	DATA0    volatile.Register32 // 0x30
	DATA1    volatile.Register32 // 0x34
}

// I2S.CTRLA: Control A
func (o *I2S_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}
func (o *I2S_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetCTRLA_CKEN0(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetCTRLA_CKEN0() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetCTRLA_CKEN1(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetCTRLA_CKEN1() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetCTRLA_SEREN0(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetCTRLA_SEREN0() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetCTRLA_SEREN1(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetCTRLA_SEREN1() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x20) >> 5
}

// I2S.CLKCTRL0: Clock Unit n Control
func (o *I2S_Type) SetCLKCTRL0_SLOTSIZE(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL0.Reg, volatile.LoadUint32(&o.CLKCTRL0.Reg)&^(0x3)|value)
}
func (o *I2S_Type) GetCLKCTRL0_SLOTSIZE() uint32 {
	return volatile.LoadUint32(&o.CLKCTRL0.Reg) & 0x3
}
func (o *I2S_Type) SetCLKCTRL0_NBSLOTS(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL0.Reg, volatile.LoadUint32(&o.CLKCTRL0.Reg)&^(0x1c)|value<<2)
}
func (o *I2S_Type) GetCLKCTRL0_NBSLOTS() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL0.Reg) & 0x1c) >> 2
}
func (o *I2S_Type) SetCLKCTRL0_FSWIDTH(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL0.Reg, volatile.LoadUint32(&o.CLKCTRL0.Reg)&^(0x60)|value<<5)
}
func (o *I2S_Type) GetCLKCTRL0_FSWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL0.Reg) & 0x60) >> 5
}
func (o *I2S_Type) SetCLKCTRL0_BITDELAY(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL0.Reg, volatile.LoadUint32(&o.CLKCTRL0.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetCLKCTRL0_BITDELAY() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL0.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetCLKCTRL0_FSSEL(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL0.Reg, volatile.LoadUint32(&o.CLKCTRL0.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetCLKCTRL0_FSSEL() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL0.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetCLKCTRL0_FSINV(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL0.Reg, volatile.LoadUint32(&o.CLKCTRL0.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetCLKCTRL0_FSINV() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL0.Reg) & 0x800) >> 11
}
func (o *I2S_Type) SetCLKCTRL0_SCKSEL(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL0.Reg, volatile.LoadUint32(&o.CLKCTRL0.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetCLKCTRL0_SCKSEL() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL0.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetCLKCTRL0_MCKSEL(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL0.Reg, volatile.LoadUint32(&o.CLKCTRL0.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetCLKCTRL0_MCKSEL() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL0.Reg) & 0x10000) >> 16
}
func (o *I2S_Type) SetCLKCTRL0_MCKEN(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL0.Reg, volatile.LoadUint32(&o.CLKCTRL0.Reg)&^(0x40000)|value<<18)
}
func (o *I2S_Type) GetCLKCTRL0_MCKEN() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL0.Reg) & 0x40000) >> 18
}
func (o *I2S_Type) SetCLKCTRL0_MCKDIV(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL0.Reg, volatile.LoadUint32(&o.CLKCTRL0.Reg)&^(0xf80000)|value<<19)
}
func (o *I2S_Type) GetCLKCTRL0_MCKDIV() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL0.Reg) & 0xf80000) >> 19
}
func (o *I2S_Type) SetCLKCTRL0_MCKOUTDIV(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL0.Reg, volatile.LoadUint32(&o.CLKCTRL0.Reg)&^(0x1f000000)|value<<24)
}
func (o *I2S_Type) GetCLKCTRL0_MCKOUTDIV() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL0.Reg) & 0x1f000000) >> 24
}
func (o *I2S_Type) SetCLKCTRL0_FSOUTINV(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL0.Reg, volatile.LoadUint32(&o.CLKCTRL0.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S_Type) GetCLKCTRL0_FSOUTINV() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL0.Reg) & 0x20000000) >> 29
}
func (o *I2S_Type) SetCLKCTRL0_SCKOUTINV(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL0.Reg, volatile.LoadUint32(&o.CLKCTRL0.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S_Type) GetCLKCTRL0_SCKOUTINV() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL0.Reg) & 0x40000000) >> 30
}
func (o *I2S_Type) SetCLKCTRL0_MCKOUTINV(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL0.Reg, volatile.LoadUint32(&o.CLKCTRL0.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetCLKCTRL0_MCKOUTINV() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL0.Reg) & 0x80000000) >> 31
}

// I2S.CLKCTRL1: Clock Unit n Control
func (o *I2S_Type) SetCLKCTRL1_SLOTSIZE(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL1.Reg, volatile.LoadUint32(&o.CLKCTRL1.Reg)&^(0x3)|value)
}
func (o *I2S_Type) GetCLKCTRL1_SLOTSIZE() uint32 {
	return volatile.LoadUint32(&o.CLKCTRL1.Reg) & 0x3
}
func (o *I2S_Type) SetCLKCTRL1_NBSLOTS(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL1.Reg, volatile.LoadUint32(&o.CLKCTRL1.Reg)&^(0x1c)|value<<2)
}
func (o *I2S_Type) GetCLKCTRL1_NBSLOTS() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL1.Reg) & 0x1c) >> 2
}
func (o *I2S_Type) SetCLKCTRL1_FSWIDTH(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL1.Reg, volatile.LoadUint32(&o.CLKCTRL1.Reg)&^(0x60)|value<<5)
}
func (o *I2S_Type) GetCLKCTRL1_FSWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL1.Reg) & 0x60) >> 5
}
func (o *I2S_Type) SetCLKCTRL1_BITDELAY(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL1.Reg, volatile.LoadUint32(&o.CLKCTRL1.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetCLKCTRL1_BITDELAY() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL1.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetCLKCTRL1_FSSEL(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL1.Reg, volatile.LoadUint32(&o.CLKCTRL1.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetCLKCTRL1_FSSEL() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL1.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetCLKCTRL1_FSINV(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL1.Reg, volatile.LoadUint32(&o.CLKCTRL1.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetCLKCTRL1_FSINV() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL1.Reg) & 0x800) >> 11
}
func (o *I2S_Type) SetCLKCTRL1_SCKSEL(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL1.Reg, volatile.LoadUint32(&o.CLKCTRL1.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetCLKCTRL1_SCKSEL() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL1.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetCLKCTRL1_MCKSEL(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL1.Reg, volatile.LoadUint32(&o.CLKCTRL1.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetCLKCTRL1_MCKSEL() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL1.Reg) & 0x10000) >> 16
}
func (o *I2S_Type) SetCLKCTRL1_MCKEN(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL1.Reg, volatile.LoadUint32(&o.CLKCTRL1.Reg)&^(0x40000)|value<<18)
}
func (o *I2S_Type) GetCLKCTRL1_MCKEN() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL1.Reg) & 0x40000) >> 18
}
func (o *I2S_Type) SetCLKCTRL1_MCKDIV(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL1.Reg, volatile.LoadUint32(&o.CLKCTRL1.Reg)&^(0xf80000)|value<<19)
}
func (o *I2S_Type) GetCLKCTRL1_MCKDIV() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL1.Reg) & 0xf80000) >> 19
}
func (o *I2S_Type) SetCLKCTRL1_MCKOUTDIV(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL1.Reg, volatile.LoadUint32(&o.CLKCTRL1.Reg)&^(0x1f000000)|value<<24)
}
func (o *I2S_Type) GetCLKCTRL1_MCKOUTDIV() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL1.Reg) & 0x1f000000) >> 24
}
func (o *I2S_Type) SetCLKCTRL1_FSOUTINV(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL1.Reg, volatile.LoadUint32(&o.CLKCTRL1.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S_Type) GetCLKCTRL1_FSOUTINV() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL1.Reg) & 0x20000000) >> 29
}
func (o *I2S_Type) SetCLKCTRL1_SCKOUTINV(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL1.Reg, volatile.LoadUint32(&o.CLKCTRL1.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S_Type) GetCLKCTRL1_SCKOUTINV() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL1.Reg) & 0x40000000) >> 30
}
func (o *I2S_Type) SetCLKCTRL1_MCKOUTINV(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL1.Reg, volatile.LoadUint32(&o.CLKCTRL1.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetCLKCTRL1_MCKOUTINV() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL1.Reg) & 0x80000000) >> 31
}

// I2S.INTENCLR: Interrupt Enable Clear
func (o *I2S_Type) SetINTENCLR_RXRDY0(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetINTENCLR_RXRDY0() uint16 {
	return volatile.LoadUint16(&o.INTENCLR.Reg) & 0x1
}
func (o *I2S_Type) SetINTENCLR_RXRDY1(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINTENCLR_RXRDY1() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINTENCLR_RXOR0(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetINTENCLR_RXOR0() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetINTENCLR_RXOR1(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINTENCLR_RXOR1() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetINTENCLR_TXRDY0(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetINTENCLR_TXRDY0() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetINTENCLR_TXRDY1(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetINTENCLR_TXRDY1() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetINTENCLR_TXUR0(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetINTENCLR_TXUR0() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetINTENCLR_TXUR1(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *I2S_Type) GetINTENCLR_TXUR1() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x2000) >> 13
}

// I2S.INTENSET: Interrupt Enable Set
func (o *I2S_Type) SetINTENSET_RXRDY0(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetINTENSET_RXRDY0() uint16 {
	return volatile.LoadUint16(&o.INTENSET.Reg) & 0x1
}
func (o *I2S_Type) SetINTENSET_RXRDY1(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINTENSET_RXRDY1() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINTENSET_RXOR0(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetINTENSET_RXOR0() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetINTENSET_RXOR1(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINTENSET_RXOR1() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetINTENSET_TXRDY0(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetINTENSET_TXRDY0() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetINTENSET_TXRDY1(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetINTENSET_TXRDY1() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetINTENSET_TXUR0(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetINTENSET_TXUR0() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetINTENSET_TXUR1(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *I2S_Type) GetINTENSET_TXUR1() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x2000) >> 13
}

// I2S.INTFLAG: Interrupt Flag Status and Clear
func (o *I2S_Type) SetINTFLAG_RXRDY0(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetINTFLAG_RXRDY0() uint16 {
	return volatile.LoadUint16(&o.INTFLAG.Reg) & 0x1
}
func (o *I2S_Type) SetINTFLAG_RXRDY1(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINTFLAG_RXRDY1() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINTFLAG_RXOR0(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetINTFLAG_RXOR0() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetINTFLAG_RXOR1(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINTFLAG_RXOR1() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetINTFLAG_TXRDY0(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetINTFLAG_TXRDY0() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetINTFLAG_TXRDY1(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetINTFLAG_TXRDY1() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetINTFLAG_TXUR0(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetINTFLAG_TXUR0() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetINTFLAG_TXUR1(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x2000)|value<<13)
}
func (o *I2S_Type) GetINTFLAG_TXUR1() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x2000) >> 13
}

// I2S.SYNCBUSY: Synchronization Status
func (o *I2S_Type) SetSYNCBUSY_SWRST(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetSYNCBUSY_SWRST() uint16 {
	return volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x1
}
func (o *I2S_Type) SetSYNCBUSY_ENABLE(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetSYNCBUSY_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetSYNCBUSY_CKEN0(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetSYNCBUSY_CKEN0() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetSYNCBUSY_CKEN1(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetSYNCBUSY_CKEN1() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetSYNCBUSY_SEREN0(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetSYNCBUSY_SEREN0() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetSYNCBUSY_SEREN1(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetSYNCBUSY_SEREN1() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetSYNCBUSY_DATA0(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetSYNCBUSY_DATA0() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetSYNCBUSY_DATA1(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetSYNCBUSY_DATA1() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x200) >> 9
}

// I2S.SERCTRL0: Serializer n Control
func (o *I2S_Type) SetSERCTRL0_SERMODE(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x3)|value)
}
func (o *I2S_Type) GetSERCTRL0_SERMODE() uint32 {
	return volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x3
}
func (o *I2S_Type) SetSERCTRL0_TXDEFAULT(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0xc)|value<<2)
}
func (o *I2S_Type) GetSERCTRL0_TXDEFAULT() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0xc) >> 2
}
func (o *I2S_Type) SetSERCTRL0_TXSAME(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetSERCTRL0_TXSAME() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetSERCTRL0_CLKSEL(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetSERCTRL0_CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetSERCTRL0_SLOTADJ(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetSERCTRL0_SLOTADJ() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetSERCTRL0_DATASIZE(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x700)|value<<8)
}
func (o *I2S_Type) GetSERCTRL0_DATASIZE() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x700) >> 8
}
func (o *I2S_Type) SetSERCTRL0_WORDADJ(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetSERCTRL0_WORDADJ() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetSERCTRL0_EXTEND(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x6000)|value<<13)
}
func (o *I2S_Type) GetSERCTRL0_EXTEND() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x6000) >> 13
}
func (o *I2S_Type) SetSERCTRL0_BITREV(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x8000)|value<<15)
}
func (o *I2S_Type) GetSERCTRL0_BITREV() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x8000) >> 15
}
func (o *I2S_Type) SetSERCTRL0_SLOTDIS0(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetSERCTRL0_SLOTDIS0() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x10000) >> 16
}
func (o *I2S_Type) SetSERCTRL0_SLOTDIS1(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x20000)|value<<17)
}
func (o *I2S_Type) GetSERCTRL0_SLOTDIS1() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x20000) >> 17
}
func (o *I2S_Type) SetSERCTRL0_SLOTDIS2(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x40000)|value<<18)
}
func (o *I2S_Type) GetSERCTRL0_SLOTDIS2() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x40000) >> 18
}
func (o *I2S_Type) SetSERCTRL0_SLOTDIS3(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x80000)|value<<19)
}
func (o *I2S_Type) GetSERCTRL0_SLOTDIS3() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x80000) >> 19
}
func (o *I2S_Type) SetSERCTRL0_SLOTDIS4(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x100000)|value<<20)
}
func (o *I2S_Type) GetSERCTRL0_SLOTDIS4() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x100000) >> 20
}
func (o *I2S_Type) SetSERCTRL0_SLOTDIS5(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x200000)|value<<21)
}
func (o *I2S_Type) GetSERCTRL0_SLOTDIS5() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x200000) >> 21
}
func (o *I2S_Type) SetSERCTRL0_SLOTDIS6(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x400000)|value<<22)
}
func (o *I2S_Type) GetSERCTRL0_SLOTDIS6() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x400000) >> 22
}
func (o *I2S_Type) SetSERCTRL0_SLOTDIS7(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x800000)|value<<23)
}
func (o *I2S_Type) GetSERCTRL0_SLOTDIS7() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x800000) >> 23
}
func (o *I2S_Type) SetSERCTRL0_MONO(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S_Type) GetSERCTRL0_MONO() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x1000000) >> 24
}
func (o *I2S_Type) SetSERCTRL0_DMA(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S_Type) GetSERCTRL0_DMA() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x2000000) >> 25
}
func (o *I2S_Type) SetSERCTRL0_RXLOOP(value uint32) {
	volatile.StoreUint32(&o.SERCTRL0.Reg, volatile.LoadUint32(&o.SERCTRL0.Reg)&^(0x4000000)|value<<26)
}
func (o *I2S_Type) GetSERCTRL0_RXLOOP() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL0.Reg) & 0x4000000) >> 26
}

// I2S.SERCTRL1: Serializer n Control
func (o *I2S_Type) SetSERCTRL1_SERMODE(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x3)|value)
}
func (o *I2S_Type) GetSERCTRL1_SERMODE() uint32 {
	return volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x3
}
func (o *I2S_Type) SetSERCTRL1_TXDEFAULT(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0xc)|value<<2)
}
func (o *I2S_Type) GetSERCTRL1_TXDEFAULT() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0xc) >> 2
}
func (o *I2S_Type) SetSERCTRL1_TXSAME(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetSERCTRL1_TXSAME() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetSERCTRL1_CLKSEL(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetSERCTRL1_CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetSERCTRL1_SLOTADJ(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetSERCTRL1_SLOTADJ() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetSERCTRL1_DATASIZE(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x700)|value<<8)
}
func (o *I2S_Type) GetSERCTRL1_DATASIZE() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x700) >> 8
}
func (o *I2S_Type) SetSERCTRL1_WORDADJ(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetSERCTRL1_WORDADJ() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetSERCTRL1_EXTEND(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x6000)|value<<13)
}
func (o *I2S_Type) GetSERCTRL1_EXTEND() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x6000) >> 13
}
func (o *I2S_Type) SetSERCTRL1_BITREV(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x8000)|value<<15)
}
func (o *I2S_Type) GetSERCTRL1_BITREV() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x8000) >> 15
}
func (o *I2S_Type) SetSERCTRL1_SLOTDIS0(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetSERCTRL1_SLOTDIS0() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x10000) >> 16
}
func (o *I2S_Type) SetSERCTRL1_SLOTDIS1(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x20000)|value<<17)
}
func (o *I2S_Type) GetSERCTRL1_SLOTDIS1() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x20000) >> 17
}
func (o *I2S_Type) SetSERCTRL1_SLOTDIS2(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x40000)|value<<18)
}
func (o *I2S_Type) GetSERCTRL1_SLOTDIS2() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x40000) >> 18
}
func (o *I2S_Type) SetSERCTRL1_SLOTDIS3(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x80000)|value<<19)
}
func (o *I2S_Type) GetSERCTRL1_SLOTDIS3() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x80000) >> 19
}
func (o *I2S_Type) SetSERCTRL1_SLOTDIS4(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x100000)|value<<20)
}
func (o *I2S_Type) GetSERCTRL1_SLOTDIS4() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x100000) >> 20
}
func (o *I2S_Type) SetSERCTRL1_SLOTDIS5(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x200000)|value<<21)
}
func (o *I2S_Type) GetSERCTRL1_SLOTDIS5() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x200000) >> 21
}
func (o *I2S_Type) SetSERCTRL1_SLOTDIS6(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x400000)|value<<22)
}
func (o *I2S_Type) GetSERCTRL1_SLOTDIS6() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x400000) >> 22
}
func (o *I2S_Type) SetSERCTRL1_SLOTDIS7(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x800000)|value<<23)
}
func (o *I2S_Type) GetSERCTRL1_SLOTDIS7() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x800000) >> 23
}
func (o *I2S_Type) SetSERCTRL1_MONO(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S_Type) GetSERCTRL1_MONO() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x1000000) >> 24
}
func (o *I2S_Type) SetSERCTRL1_DMA(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S_Type) GetSERCTRL1_DMA() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x2000000) >> 25
}
func (o *I2S_Type) SetSERCTRL1_RXLOOP(value uint32) {
	volatile.StoreUint32(&o.SERCTRL1.Reg, volatile.LoadUint32(&o.SERCTRL1.Reg)&^(0x4000000)|value<<26)
}
func (o *I2S_Type) GetSERCTRL1_RXLOOP() uint32 {
	return (volatile.LoadUint32(&o.SERCTRL1.Reg) & 0x4000000) >> 26
}

// I2S.DATA0: Data n
func (o *I2S_Type) SetDATA0(value uint32) {
	volatile.StoreUint32(&o.DATA0.Reg, value)
}
func (o *I2S_Type) GetDATA0() uint32 {
	return volatile.LoadUint32(&o.DATA0.Reg)
}

// I2S.DATA1: Data n
func (o *I2S_Type) SetDATA1(value uint32) {
	volatile.StoreUint32(&o.DATA1.Reg, value)
}
func (o *I2S_Type) GetDATA1() uint32 {
	return volatile.LoadUint32(&o.DATA1.Reg)
}

// Cortex-M0+ Micro-Trace Buffer
type MTB_Type struct {
	POSITION   volatile.Register32 // 0x0
	MASTER     volatile.Register32 // 0x4
	FLOW       volatile.Register32 // 0x8
	BASE       volatile.Register32 // 0xC
	_          [3824]byte
	ITCTRL     volatile.Register32 // 0xF00
	_          [156]byte
	CLAIMSET   volatile.Register32 // 0xFA0
	CLAIMCLR   volatile.Register32 // 0xFA4
	_          [8]byte
	LOCKACCESS volatile.Register32 // 0xFB0
	LOCKSTATUS volatile.Register32 // 0xFB4
	AUTHSTATUS volatile.Register32 // 0xFB8
	DEVARCH    volatile.Register32 // 0xFBC
	_          [8]byte
	DEVID      volatile.Register32 // 0xFC8
	DEVTYPE    volatile.Register32 // 0xFCC
	PID4       volatile.Register32 // 0xFD0
	PID5       volatile.Register32 // 0xFD4
	PID6       volatile.Register32 // 0xFD8
	PID7       volatile.Register32 // 0xFDC
	PID0       volatile.Register32 // 0xFE0
	PID1       volatile.Register32 // 0xFE4
	PID2       volatile.Register32 // 0xFE8
	PID3       volatile.Register32 // 0xFEC
	CID0       volatile.Register32 // 0xFF0
	CID1       volatile.Register32 // 0xFF4
	CID2       volatile.Register32 // 0xFF8
	CID3       volatile.Register32 // 0xFFC
}

// MTB.POSITION: MTB Position
func (o *MTB_Type) SetPOSITION_WRAP(value uint32) {
	volatile.StoreUint32(&o.POSITION.Reg, volatile.LoadUint32(&o.POSITION.Reg)&^(0x4)|value<<2)
}
func (o *MTB_Type) GetPOSITION_WRAP() uint32 {
	return (volatile.LoadUint32(&o.POSITION.Reg) & 0x4) >> 2
}
func (o *MTB_Type) SetPOSITION_POINTER(value uint32) {
	volatile.StoreUint32(&o.POSITION.Reg, volatile.LoadUint32(&o.POSITION.Reg)&^(0xfffffff8)|value<<3)
}
func (o *MTB_Type) GetPOSITION_POINTER() uint32 {
	return (volatile.LoadUint32(&o.POSITION.Reg) & 0xfffffff8) >> 3
}

// MTB.MASTER: MTB Master
func (o *MTB_Type) SetMASTER_MASK(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x1f)|value)
}
func (o *MTB_Type) GetMASTER_MASK() uint32 {
	return volatile.LoadUint32(&o.MASTER.Reg) & 0x1f
}
func (o *MTB_Type) SetMASTER_TSTARTEN(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x20)|value<<5)
}
func (o *MTB_Type) GetMASTER_TSTARTEN() uint32 {
	return (volatile.LoadUint32(&o.MASTER.Reg) & 0x20) >> 5
}
func (o *MTB_Type) SetMASTER_TSTOPEN(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x40)|value<<6)
}
func (o *MTB_Type) GetMASTER_TSTOPEN() uint32 {
	return (volatile.LoadUint32(&o.MASTER.Reg) & 0x40) >> 6
}
func (o *MTB_Type) SetMASTER_SFRWPRIV(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x80)|value<<7)
}
func (o *MTB_Type) GetMASTER_SFRWPRIV() uint32 {
	return (volatile.LoadUint32(&o.MASTER.Reg) & 0x80) >> 7
}
func (o *MTB_Type) SetMASTER_RAMPRIV(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x100)|value<<8)
}
func (o *MTB_Type) GetMASTER_RAMPRIV() uint32 {
	return (volatile.LoadUint32(&o.MASTER.Reg) & 0x100) >> 8
}
func (o *MTB_Type) SetMASTER_HALTREQ(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x200)|value<<9)
}
func (o *MTB_Type) GetMASTER_HALTREQ() uint32 {
	return (volatile.LoadUint32(&o.MASTER.Reg) & 0x200) >> 9
}
func (o *MTB_Type) SetMASTER_EN(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x80000000)|value<<31)
}
func (o *MTB_Type) GetMASTER_EN() uint32 {
	return (volatile.LoadUint32(&o.MASTER.Reg) & 0x80000000) >> 31
}

// MTB.FLOW: MTB Flow
func (o *MTB_Type) SetFLOW_AUTOSTOP(value uint32) {
	volatile.StoreUint32(&o.FLOW.Reg, volatile.LoadUint32(&o.FLOW.Reg)&^(0x1)|value)
}
func (o *MTB_Type) GetFLOW_AUTOSTOP() uint32 {
	return volatile.LoadUint32(&o.FLOW.Reg) & 0x1
}
func (o *MTB_Type) SetFLOW_AUTOHALT(value uint32) {
	volatile.StoreUint32(&o.FLOW.Reg, volatile.LoadUint32(&o.FLOW.Reg)&^(0x2)|value<<1)
}
func (o *MTB_Type) GetFLOW_AUTOHALT() uint32 {
	return (volatile.LoadUint32(&o.FLOW.Reg) & 0x2) >> 1
}
func (o *MTB_Type) SetFLOW_WATERMARK(value uint32) {
	volatile.StoreUint32(&o.FLOW.Reg, volatile.LoadUint32(&o.FLOW.Reg)&^(0xfffffff8)|value<<3)
}
func (o *MTB_Type) GetFLOW_WATERMARK() uint32 {
	return (volatile.LoadUint32(&o.FLOW.Reg) & 0xfffffff8) >> 3
}

// Non-Volatile Memory Controller
type NVMCTRL_Type struct {
	CTRLA    volatile.Register16 // 0x0
	_        [2]byte
	CTRLB    volatile.Register32 // 0x4
	PARAM    volatile.Register32 // 0x8
	INTENCLR volatile.Register8  // 0xC
	_        [3]byte
	INTENSET volatile.Register8 // 0x10
	_        [3]byte
	INTFLAG  volatile.Register8 // 0x14
	_        [3]byte
	STATUS   volatile.Register16 // 0x18
	_        [2]byte
	ADDR     volatile.Register32 // 0x1C
	LOCK     volatile.Register16 // 0x20
}

// NVMCTRL.CTRLA: Control A
func (o *NVMCTRL_Type) SetCTRLA_CMD(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x7f)|value)
}
func (o *NVMCTRL_Type) GetCTRLA_CMD() uint16 {
	return volatile.LoadUint16(&o.CTRLA.Reg) & 0x7f
}
func (o *NVMCTRL_Type) SetCTRLA_CMDEX(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0xff00)|value<<8)
}
func (o *NVMCTRL_Type) GetCTRLA_CMDEX() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0xff00) >> 8
}

// NVMCTRL.CTRLB: Control B
func (o *NVMCTRL_Type) SetCTRLB_RWS(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x1e)|value<<1)
}
func (o *NVMCTRL_Type) GetCTRLB_RWS() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x1e) >> 1
}
func (o *NVMCTRL_Type) SetCTRLB_MANW(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x80)|value<<7)
}
func (o *NVMCTRL_Type) GetCTRLB_MANW() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x80) >> 7
}
func (o *NVMCTRL_Type) SetCTRLB_SLEEPPRM(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x300)|value<<8)
}
func (o *NVMCTRL_Type) GetCTRLB_SLEEPPRM() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x300) >> 8
}
func (o *NVMCTRL_Type) SetCTRLB_READMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x30000)|value<<16)
}
func (o *NVMCTRL_Type) GetCTRLB_READMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x30000) >> 16
}
func (o *NVMCTRL_Type) SetCTRLB_CACHEDIS(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x40000)|value<<18)
}
func (o *NVMCTRL_Type) GetCTRLB_CACHEDIS() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x40000) >> 18
}

// NVMCTRL.PARAM: NVM Parameter
func (o *NVMCTRL_Type) SetPARAM_NVMP(value uint32) {
	volatile.StoreUint32(&o.PARAM.Reg, volatile.LoadUint32(&o.PARAM.Reg)&^(0xffff)|value)
}
func (o *NVMCTRL_Type) GetPARAM_NVMP() uint32 {
	return volatile.LoadUint32(&o.PARAM.Reg) & 0xffff
}
func (o *NVMCTRL_Type) SetPARAM_PSZ(value uint32) {
	volatile.StoreUint32(&o.PARAM.Reg, volatile.LoadUint32(&o.PARAM.Reg)&^(0x70000)|value<<16)
}
func (o *NVMCTRL_Type) GetPARAM_PSZ() uint32 {
	return (volatile.LoadUint32(&o.PARAM.Reg) & 0x70000) >> 16
}
func (o *NVMCTRL_Type) SetPARAM_RWWEEP(value uint32) {
	volatile.StoreUint32(&o.PARAM.Reg, volatile.LoadUint32(&o.PARAM.Reg)&^(0xfff00000)|value<<20)
}
func (o *NVMCTRL_Type) GetPARAM_RWWEEP() uint32 {
	return (volatile.LoadUint32(&o.PARAM.Reg) & 0xfff00000) >> 20
}

// NVMCTRL.INTENCLR: Interrupt Enable Clear
func (o *NVMCTRL_Type) SetINTENCLR_READY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetINTENCLR_READY() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *NVMCTRL_Type) SetINTENCLR_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *NVMCTRL_Type) GetINTENCLR_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}

// NVMCTRL.INTENSET: Interrupt Enable Set
func (o *NVMCTRL_Type) SetINTENSET_READY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetINTENSET_READY() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *NVMCTRL_Type) SetINTENSET_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *NVMCTRL_Type) GetINTENSET_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}

// NVMCTRL.INTFLAG: Interrupt Flag Status and Clear
func (o *NVMCTRL_Type) SetINTFLAG_READY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetINTFLAG_READY() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *NVMCTRL_Type) SetINTFLAG_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *NVMCTRL_Type) GetINTFLAG_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}

// NVMCTRL.STATUS: Status
func (o *NVMCTRL_Type) SetSTATUS_PRM(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetSTATUS_PRM() uint16 {
	return volatile.LoadUint16(&o.STATUS.Reg) & 0x1
}
func (o *NVMCTRL_Type) SetSTATUS_LOAD(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *NVMCTRL_Type) GetSTATUS_LOAD() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *NVMCTRL_Type) SetSTATUS_PROGE(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *NVMCTRL_Type) GetSTATUS_PROGE() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *NVMCTRL_Type) SetSTATUS_LOCKE(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *NVMCTRL_Type) GetSTATUS_LOCKE() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *NVMCTRL_Type) SetSTATUS_NVME(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *NVMCTRL_Type) GetSTATUS_NVME() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *NVMCTRL_Type) SetSTATUS_SB(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *NVMCTRL_Type) GetSTATUS_SB() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x100) >> 8
}

// NVMCTRL.ADDR: Address
func (o *NVMCTRL_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x3fffff)|value)
}
func (o *NVMCTRL_Type) GetADDR() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg) & 0x3fffff
}

// NVMCTRL.LOCK: Lock Section
func (o *NVMCTRL_Type) SetLOCK(value uint16) {
	volatile.StoreUint16(&o.LOCK.Reg, value)
}
func (o *NVMCTRL_Type) GetLOCK() uint16 {
	return volatile.LoadUint16(&o.LOCK.Reg)
}

// Peripheral Access Controller 0
type PAC_Type struct {
	WPCLR volatile.Register32 // 0x0
	WPSET volatile.Register32 // 0x4
}

// PAC.WPCLR: Write Protection Clear
func (o *PAC_Type) SetWPCLR_WP(value uint32) {
	volatile.StoreUint32(&o.WPCLR.Reg, volatile.LoadUint32(&o.WPCLR.Reg)&^(0xfffffffe)|value<<1)
}
func (o *PAC_Type) GetWPCLR_WP() uint32 {
	return (volatile.LoadUint32(&o.WPCLR.Reg) & 0xfffffffe) >> 1
}

// PAC.WPSET: Write Protection Set
func (o *PAC_Type) SetWPSET_WP(value uint32) {
	volatile.StoreUint32(&o.WPSET.Reg, volatile.LoadUint32(&o.WPSET.Reg)&^(0xfffffffe)|value<<1)
}
func (o *PAC_Type) GetWPSET_WP() uint32 {
	return (volatile.LoadUint32(&o.WPSET.Reg) & 0xfffffffe) >> 1
}

// Power Manager
type PM_Type struct {
	CTRL     volatile.Register8 // 0x0
	SLEEP    volatile.Register8 // 0x1
	EXTCTRL  volatile.Register8 // 0x2
	_        [5]byte
	CPUSEL   volatile.Register8 // 0x8
	APBASEL  volatile.Register8 // 0x9
	APBBSEL  volatile.Register8 // 0xA
	APBCSEL  volatile.Register8 // 0xB
	_        [8]byte
	AHBMASK  volatile.Register32 // 0x14
	APBAMASK volatile.Register32 // 0x18
	APBBMASK volatile.Register32 // 0x1C
	APBCMASK volatile.Register32 // 0x20
	_        [16]byte
	INTENCLR volatile.Register8 // 0x34
	INTENSET volatile.Register8 // 0x35
	INTFLAG  volatile.Register8 // 0x36
	_        byte
	RCAUSE   volatile.Register8 // 0x38
}

// PM.SLEEP: Sleep Mode
func (o *PM_Type) SetSLEEP_IDLE(value uint8) {
	volatile.StoreUint8(&o.SLEEP.Reg, volatile.LoadUint8(&o.SLEEP.Reg)&^(0x3)|value)
}
func (o *PM_Type) GetSLEEP_IDLE() uint8 {
	return volatile.LoadUint8(&o.SLEEP.Reg) & 0x3
}

// PM.EXTCTRL: External Reset Controller
func (o *PM_Type) SetEXTCTRL_SETDIS(value uint8) {
	volatile.StoreUint8(&o.EXTCTRL.Reg, volatile.LoadUint8(&o.EXTCTRL.Reg)&^(0x1)|value)
}
func (o *PM_Type) GetEXTCTRL_SETDIS() uint8 {
	return volatile.LoadUint8(&o.EXTCTRL.Reg) & 0x1
}

// PM.CPUSEL: CPU Clock Select
func (o *PM_Type) SetCPUSEL_CPUDIV(value uint8) {
	volatile.StoreUint8(&o.CPUSEL.Reg, volatile.LoadUint8(&o.CPUSEL.Reg)&^(0x7)|value)
}
func (o *PM_Type) GetCPUSEL_CPUDIV() uint8 {
	return volatile.LoadUint8(&o.CPUSEL.Reg) & 0x7
}

// PM.APBASEL: APBA Clock Select
func (o *PM_Type) SetAPBASEL_APBADIV(value uint8) {
	volatile.StoreUint8(&o.APBASEL.Reg, volatile.LoadUint8(&o.APBASEL.Reg)&^(0x7)|value)
}
func (o *PM_Type) GetAPBASEL_APBADIV() uint8 {
	return volatile.LoadUint8(&o.APBASEL.Reg) & 0x7
}

// PM.APBBSEL: APBB Clock Select
func (o *PM_Type) SetAPBBSEL_APBBDIV(value uint8) {
	volatile.StoreUint8(&o.APBBSEL.Reg, volatile.LoadUint8(&o.APBBSEL.Reg)&^(0x7)|value)
}
func (o *PM_Type) GetAPBBSEL_APBBDIV() uint8 {
	return volatile.LoadUint8(&o.APBBSEL.Reg) & 0x7
}

// PM.APBCSEL: APBC Clock Select
func (o *PM_Type) SetAPBCSEL_APBCDIV(value uint8) {
	volatile.StoreUint8(&o.APBCSEL.Reg, volatile.LoadUint8(&o.APBCSEL.Reg)&^(0x7)|value)
}
func (o *PM_Type) GetAPBCSEL_APBCDIV() uint8 {
	return volatile.LoadUint8(&o.APBCSEL.Reg) & 0x7
}

// PM.AHBMASK: AHB Mask
func (o *PM_Type) SetAHBMASK_HPB0_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x1)|value)
}
func (o *PM_Type) GetAHBMASK_HPB0_() uint32 {
	return volatile.LoadUint32(&o.AHBMASK.Reg) & 0x1
}
func (o *PM_Type) SetAHBMASK_HPB1_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x2)|value<<1)
}
func (o *PM_Type) GetAHBMASK_HPB1_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x2) >> 1
}
func (o *PM_Type) SetAHBMASK_HPB2_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x4)|value<<2)
}
func (o *PM_Type) GetAHBMASK_HPB2_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x4) >> 2
}
func (o *PM_Type) SetAHBMASK_DSU_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x8)|value<<3)
}
func (o *PM_Type) GetAHBMASK_DSU_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x8) >> 3
}
func (o *PM_Type) SetAHBMASK_NVMCTRL_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x10)|value<<4)
}
func (o *PM_Type) GetAHBMASK_NVMCTRL_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x10) >> 4
}
func (o *PM_Type) SetAHBMASK_DMAC_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x20)|value<<5)
}
func (o *PM_Type) GetAHBMASK_DMAC_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x20) >> 5
}
func (o *PM_Type) SetAHBMASK_USB_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x40)|value<<6)
}
func (o *PM_Type) GetAHBMASK_USB_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x40) >> 6
}

// PM.APBAMASK: APBA Mask
func (o *PM_Type) SetAPBAMASK_PAC0_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x1)|value)
}
func (o *PM_Type) GetAPBAMASK_PAC0_() uint32 {
	return volatile.LoadUint32(&o.APBAMASK.Reg) & 0x1
}
func (o *PM_Type) SetAPBAMASK_PM_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x2)|value<<1)
}
func (o *PM_Type) GetAPBAMASK_PM_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x2) >> 1
}
func (o *PM_Type) SetAPBAMASK_SYSCTRL_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x4)|value<<2)
}
func (o *PM_Type) GetAPBAMASK_SYSCTRL_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x4) >> 2
}
func (o *PM_Type) SetAPBAMASK_GCLK_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x8)|value<<3)
}
func (o *PM_Type) GetAPBAMASK_GCLK_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x8) >> 3
}
func (o *PM_Type) SetAPBAMASK_WDT_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x10)|value<<4)
}
func (o *PM_Type) GetAPBAMASK_WDT_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x10) >> 4
}
func (o *PM_Type) SetAPBAMASK_RTC_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x20)|value<<5)
}
func (o *PM_Type) GetAPBAMASK_RTC_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x20) >> 5
}
func (o *PM_Type) SetAPBAMASK_EIC_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x40)|value<<6)
}
func (o *PM_Type) GetAPBAMASK_EIC_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x40) >> 6
}

// PM.APBBMASK: APBB Mask
func (o *PM_Type) SetAPBBMASK_PAC1_(value uint32) {
	volatile.StoreUint32(&o.APBBMASK.Reg, volatile.LoadUint32(&o.APBBMASK.Reg)&^(0x1)|value)
}
func (o *PM_Type) GetAPBBMASK_PAC1_() uint32 {
	return volatile.LoadUint32(&o.APBBMASK.Reg) & 0x1
}
func (o *PM_Type) SetAPBBMASK_DSU_(value uint32) {
	volatile.StoreUint32(&o.APBBMASK.Reg, volatile.LoadUint32(&o.APBBMASK.Reg)&^(0x2)|value<<1)
}
func (o *PM_Type) GetAPBBMASK_DSU_() uint32 {
	return (volatile.LoadUint32(&o.APBBMASK.Reg) & 0x2) >> 1
}
func (o *PM_Type) SetAPBBMASK_NVMCTRL_(value uint32) {
	volatile.StoreUint32(&o.APBBMASK.Reg, volatile.LoadUint32(&o.APBBMASK.Reg)&^(0x4)|value<<2)
}
func (o *PM_Type) GetAPBBMASK_NVMCTRL_() uint32 {
	return (volatile.LoadUint32(&o.APBBMASK.Reg) & 0x4) >> 2
}
func (o *PM_Type) SetAPBBMASK_PORT_(value uint32) {
	volatile.StoreUint32(&o.APBBMASK.Reg, volatile.LoadUint32(&o.APBBMASK.Reg)&^(0x8)|value<<3)
}
func (o *PM_Type) GetAPBBMASK_PORT_() uint32 {
	return (volatile.LoadUint32(&o.APBBMASK.Reg) & 0x8) >> 3
}
func (o *PM_Type) SetAPBBMASK_DMAC_(value uint32) {
	volatile.StoreUint32(&o.APBBMASK.Reg, volatile.LoadUint32(&o.APBBMASK.Reg)&^(0x10)|value<<4)
}
func (o *PM_Type) GetAPBBMASK_DMAC_() uint32 {
	return (volatile.LoadUint32(&o.APBBMASK.Reg) & 0x10) >> 4
}
func (o *PM_Type) SetAPBBMASK_USB_(value uint32) {
	volatile.StoreUint32(&o.APBBMASK.Reg, volatile.LoadUint32(&o.APBBMASK.Reg)&^(0x20)|value<<5)
}
func (o *PM_Type) GetAPBBMASK_USB_() uint32 {
	return (volatile.LoadUint32(&o.APBBMASK.Reg) & 0x20) >> 5
}
func (o *PM_Type) SetAPBBMASK_HMATRIX_(value uint32) {
	volatile.StoreUint32(&o.APBBMASK.Reg, volatile.LoadUint32(&o.APBBMASK.Reg)&^(0x40)|value<<6)
}
func (o *PM_Type) GetAPBBMASK_HMATRIX_() uint32 {
	return (volatile.LoadUint32(&o.APBBMASK.Reg) & 0x40) >> 6
}

// PM.APBCMASK: APBC Mask
func (o *PM_Type) SetAPBCMASK_PAC2_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x1)|value)
}
func (o *PM_Type) GetAPBCMASK_PAC2_() uint32 {
	return volatile.LoadUint32(&o.APBCMASK.Reg) & 0x1
}
func (o *PM_Type) SetAPBCMASK_EVSYS_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x2)|value<<1)
}
func (o *PM_Type) GetAPBCMASK_EVSYS_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x2) >> 1
}
func (o *PM_Type) SetAPBCMASK_SERCOM0_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x4)|value<<2)
}
func (o *PM_Type) GetAPBCMASK_SERCOM0_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x4) >> 2
}
func (o *PM_Type) SetAPBCMASK_SERCOM1_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x8)|value<<3)
}
func (o *PM_Type) GetAPBCMASK_SERCOM1_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x8) >> 3
}
func (o *PM_Type) SetAPBCMASK_SERCOM2_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x10)|value<<4)
}
func (o *PM_Type) GetAPBCMASK_SERCOM2_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x10) >> 4
}
func (o *PM_Type) SetAPBCMASK_SERCOM3_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x20)|value<<5)
}
func (o *PM_Type) GetAPBCMASK_SERCOM3_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x20) >> 5
}
func (o *PM_Type) SetAPBCMASK_TCC0_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x100)|value<<8)
}
func (o *PM_Type) GetAPBCMASK_TCC0_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x100) >> 8
}
func (o *PM_Type) SetAPBCMASK_TCC1_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x200)|value<<9)
}
func (o *PM_Type) GetAPBCMASK_TCC1_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x200) >> 9
}
func (o *PM_Type) SetAPBCMASK_TCC2_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x400)|value<<10)
}
func (o *PM_Type) GetAPBCMASK_TCC2_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x400) >> 10
}
func (o *PM_Type) SetAPBCMASK_TC3_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x800)|value<<11)
}
func (o *PM_Type) GetAPBCMASK_TC3_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x800) >> 11
}
func (o *PM_Type) SetAPBCMASK_TC4_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x1000)|value<<12)
}
func (o *PM_Type) GetAPBCMASK_TC4_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x1000) >> 12
}
func (o *PM_Type) SetAPBCMASK_TC5_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x2000)|value<<13)
}
func (o *PM_Type) GetAPBCMASK_TC5_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x2000) >> 13
}
func (o *PM_Type) SetAPBCMASK_ADC_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x10000)|value<<16)
}
func (o *PM_Type) GetAPBCMASK_ADC_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x10000) >> 16
}
func (o *PM_Type) SetAPBCMASK_AC_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x20000)|value<<17)
}
func (o *PM_Type) GetAPBCMASK_AC_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x20000) >> 17
}
func (o *PM_Type) SetAPBCMASK_DAC_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x40000)|value<<18)
}
func (o *PM_Type) GetAPBCMASK_DAC_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x40000) >> 18
}
func (o *PM_Type) SetAPBCMASK_PTC_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x80000)|value<<19)
}
func (o *PM_Type) GetAPBCMASK_PTC_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x80000) >> 19
}
func (o *PM_Type) SetAPBCMASK_I2S_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x100000)|value<<20)
}
func (o *PM_Type) GetAPBCMASK_I2S_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x100000) >> 20
}

// PM.INTENCLR: Interrupt Enable Clear
func (o *PM_Type) SetINTENCLR_CKRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *PM_Type) GetINTENCLR_CKRDY() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}

// PM.INTENSET: Interrupt Enable Set
func (o *PM_Type) SetINTENSET_CKRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *PM_Type) GetINTENSET_CKRDY() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}

// PM.INTFLAG: Interrupt Flag Status and Clear
func (o *PM_Type) SetINTFLAG_CKRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *PM_Type) GetINTFLAG_CKRDY() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}

// PM.RCAUSE: Reset Cause
func (o *PM_Type) SetRCAUSE_POR(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x1)|value)
}
func (o *PM_Type) GetRCAUSE_POR() uint8 {
	return volatile.LoadUint8(&o.RCAUSE.Reg) & 0x1
}
func (o *PM_Type) SetRCAUSE_BOD12(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x2)|value<<1)
}
func (o *PM_Type) GetRCAUSE_BOD12() uint8 {
	return (volatile.LoadUint8(&o.RCAUSE.Reg) & 0x2) >> 1
}
func (o *PM_Type) SetRCAUSE_BOD33(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x4)|value<<2)
}
func (o *PM_Type) GetRCAUSE_BOD33() uint8 {
	return (volatile.LoadUint8(&o.RCAUSE.Reg) & 0x4) >> 2
}
func (o *PM_Type) SetRCAUSE_EXT(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x10)|value<<4)
}
func (o *PM_Type) GetRCAUSE_EXT() uint8 {
	return (volatile.LoadUint8(&o.RCAUSE.Reg) & 0x10) >> 4
}
func (o *PM_Type) SetRCAUSE_WDT(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x20)|value<<5)
}
func (o *PM_Type) GetRCAUSE_WDT() uint8 {
	return (volatile.LoadUint8(&o.RCAUSE.Reg) & 0x20) >> 5
}
func (o *PM_Type) SetRCAUSE_SYST(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x40)|value<<6)
}
func (o *PM_Type) GetRCAUSE_SYST() uint8 {
	return (volatile.LoadUint8(&o.RCAUSE.Reg) & 0x40) >> 6
}

// Port Module
type PORT_Type struct {
	DIR0       volatile.Register32 // 0x0
	DIRCLR0    volatile.Register32 // 0x4
	DIRSET0    volatile.Register32 // 0x8
	DIRTGL0    volatile.Register32 // 0xC
	OUT0       volatile.Register32 // 0x10
	OUTCLR0    volatile.Register32 // 0x14
	OUTSET0    volatile.Register32 // 0x18
	OUTTGL0    volatile.Register32 // 0x1C
	IN0        volatile.Register32 // 0x20
	CTRL0      volatile.Register32 // 0x24
	WRCONFIG0  volatile.Register32 // 0x28
	_          [4]byte
	PMUX0_0    volatile.Register8 // 0x30
	PMUX0_1    volatile.Register8 // 0x31
	PMUX0_2    volatile.Register8 // 0x32
	PMUX0_3    volatile.Register8 // 0x33
	PMUX0_4    volatile.Register8 // 0x34
	PMUX0_5    volatile.Register8 // 0x35
	PMUX0_6    volatile.Register8 // 0x36
	PMUX0_7    volatile.Register8 // 0x37
	PMUX0_8    volatile.Register8 // 0x38
	PMUX0_9    volatile.Register8 // 0x39
	PMUX0_10   volatile.Register8 // 0x3A
	PMUX0_11   volatile.Register8 // 0x3B
	PMUX0_12   volatile.Register8 // 0x3C
	PMUX0_13   volatile.Register8 // 0x3D
	PMUX0_14   volatile.Register8 // 0x3E
	PMUX0_15   volatile.Register8 // 0x3F
	PINCFG0_0  volatile.Register8 // 0x40
	PINCFG0_1  volatile.Register8 // 0x41
	PINCFG0_2  volatile.Register8 // 0x42
	PINCFG0_3  volatile.Register8 // 0x43
	PINCFG0_4  volatile.Register8 // 0x44
	PINCFG0_5  volatile.Register8 // 0x45
	PINCFG0_6  volatile.Register8 // 0x46
	PINCFG0_7  volatile.Register8 // 0x47
	PINCFG0_8  volatile.Register8 // 0x48
	PINCFG0_9  volatile.Register8 // 0x49
	PINCFG0_10 volatile.Register8 // 0x4A
	PINCFG0_11 volatile.Register8 // 0x4B
	PINCFG0_12 volatile.Register8 // 0x4C
	PINCFG0_13 volatile.Register8 // 0x4D
	PINCFG0_14 volatile.Register8 // 0x4E
	PINCFG0_15 volatile.Register8 // 0x4F
	PINCFG0_16 volatile.Register8 // 0x50
	PINCFG0_17 volatile.Register8 // 0x51
	PINCFG0_18 volatile.Register8 // 0x52
	PINCFG0_19 volatile.Register8 // 0x53
	PINCFG0_20 volatile.Register8 // 0x54
	PINCFG0_21 volatile.Register8 // 0x55
	PINCFG0_22 volatile.Register8 // 0x56
	PINCFG0_23 volatile.Register8 // 0x57
	PINCFG0_24 volatile.Register8 // 0x58
	PINCFG0_25 volatile.Register8 // 0x59
	PINCFG0_26 volatile.Register8 // 0x5A
	PINCFG0_27 volatile.Register8 // 0x5B
	PINCFG0_28 volatile.Register8 // 0x5C
	PINCFG0_29 volatile.Register8 // 0x5D
	PINCFG0_30 volatile.Register8 // 0x5E
	PINCFG0_31 volatile.Register8 // 0x5F
}

// PORT.DIR0: Data Direction
func (o *PORT_Type) SetDIR0(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, value)
}
func (o *PORT_Type) GetDIR0() uint32 {
	return volatile.LoadUint32(&o.DIR0.Reg)
}

// PORT.DIRCLR0: Data Direction Clear
func (o *PORT_Type) SetDIRCLR0(value uint32) {
	volatile.StoreUint32(&o.DIRCLR0.Reg, value)
}
func (o *PORT_Type) GetDIRCLR0() uint32 {
	return volatile.LoadUint32(&o.DIRCLR0.Reg)
}

// PORT.DIRSET0: Data Direction Set
func (o *PORT_Type) SetDIRSET0(value uint32) {
	volatile.StoreUint32(&o.DIRSET0.Reg, value)
}
func (o *PORT_Type) GetDIRSET0() uint32 {
	return volatile.LoadUint32(&o.DIRSET0.Reg)
}

// PORT.DIRTGL0: Data Direction Toggle
func (o *PORT_Type) SetDIRTGL0(value uint32) {
	volatile.StoreUint32(&o.DIRTGL0.Reg, value)
}
func (o *PORT_Type) GetDIRTGL0() uint32 {
	return volatile.LoadUint32(&o.DIRTGL0.Reg)
}

// PORT.OUT0: Data Output Value
func (o *PORT_Type) SetOUT0(value uint32) {
	volatile.StoreUint32(&o.OUT0.Reg, value)
}
func (o *PORT_Type) GetOUT0() uint32 {
	return volatile.LoadUint32(&o.OUT0.Reg)
}

// PORT.OUTCLR0: Data Output Value Clear
func (o *PORT_Type) SetOUTCLR0(value uint32) {
	volatile.StoreUint32(&o.OUTCLR0.Reg, value)
}
func (o *PORT_Type) GetOUTCLR0() uint32 {
	return volatile.LoadUint32(&o.OUTCLR0.Reg)
}

// PORT.OUTSET0: Data Output Value Set
func (o *PORT_Type) SetOUTSET0(value uint32) {
	volatile.StoreUint32(&o.OUTSET0.Reg, value)
}
func (o *PORT_Type) GetOUTSET0() uint32 {
	return volatile.LoadUint32(&o.OUTSET0.Reg)
}

// PORT.OUTTGL0: Data Output Value Toggle
func (o *PORT_Type) SetOUTTGL0(value uint32) {
	volatile.StoreUint32(&o.OUTTGL0.Reg, value)
}
func (o *PORT_Type) GetOUTTGL0() uint32 {
	return volatile.LoadUint32(&o.OUTTGL0.Reg)
}

// PORT.IN0: Data Input Value
func (o *PORT_Type) SetIN0(value uint32) {
	volatile.StoreUint32(&o.IN0.Reg, value)
}
func (o *PORT_Type) GetIN0() uint32 {
	return volatile.LoadUint32(&o.IN0.Reg)
}

// PORT.CTRL0: Control
func (o *PORT_Type) SetCTRL0(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, value)
}
func (o *PORT_Type) GetCTRL0() uint32 {
	return volatile.LoadUint32(&o.CTRL0.Reg)
}

// PORT.WRCONFIG0: Write Configuration
func (o *PORT_Type) SetWRCONFIG0_PINMASK(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG0.Reg, volatile.LoadUint32(&o.WRCONFIG0.Reg)&^(0xffff)|value)
}
func (o *PORT_Type) GetWRCONFIG0_PINMASK() uint32 {
	return volatile.LoadUint32(&o.WRCONFIG0.Reg) & 0xffff
}
func (o *PORT_Type) SetWRCONFIG0_PMUXEN(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG0.Reg, volatile.LoadUint32(&o.WRCONFIG0.Reg)&^(0x10000)|value<<16)
}
func (o *PORT_Type) GetWRCONFIG0_PMUXEN() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG0.Reg) & 0x10000) >> 16
}
func (o *PORT_Type) SetWRCONFIG0_INEN(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG0.Reg, volatile.LoadUint32(&o.WRCONFIG0.Reg)&^(0x20000)|value<<17)
}
func (o *PORT_Type) GetWRCONFIG0_INEN() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG0.Reg) & 0x20000) >> 17
}
func (o *PORT_Type) SetWRCONFIG0_PULLEN(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG0.Reg, volatile.LoadUint32(&o.WRCONFIG0.Reg)&^(0x40000)|value<<18)
}
func (o *PORT_Type) GetWRCONFIG0_PULLEN() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG0.Reg) & 0x40000) >> 18
}
func (o *PORT_Type) SetWRCONFIG0_DRVSTR(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG0.Reg, volatile.LoadUint32(&o.WRCONFIG0.Reg)&^(0x400000)|value<<22)
}
func (o *PORT_Type) GetWRCONFIG0_DRVSTR() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG0.Reg) & 0x400000) >> 22
}
func (o *PORT_Type) SetWRCONFIG0_PMUX(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG0.Reg, volatile.LoadUint32(&o.WRCONFIG0.Reg)&^(0xf000000)|value<<24)
}
func (o *PORT_Type) GetWRCONFIG0_PMUX() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG0.Reg) & 0xf000000) >> 24
}
func (o *PORT_Type) SetWRCONFIG0_WRPMUX(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG0.Reg, volatile.LoadUint32(&o.WRCONFIG0.Reg)&^(0x10000000)|value<<28)
}
func (o *PORT_Type) GetWRCONFIG0_WRPMUX() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG0.Reg) & 0x10000000) >> 28
}
func (o *PORT_Type) SetWRCONFIG0_WRPINCFG(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG0.Reg, volatile.LoadUint32(&o.WRCONFIG0.Reg)&^(0x40000000)|value<<30)
}
func (o *PORT_Type) GetWRCONFIG0_WRPINCFG() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG0.Reg) & 0x40000000) >> 30
}
func (o *PORT_Type) SetWRCONFIG0_HWSEL(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG0.Reg, volatile.LoadUint32(&o.WRCONFIG0.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT_Type) GetWRCONFIG0_HWSEL() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG0.Reg) & 0x80000000) >> 31
}

// PORT.PMUX0_0: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_0_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_0.Reg, volatile.LoadUint8(&o.PMUX0_0.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_0_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_0.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_0_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_0.Reg, volatile.LoadUint8(&o.PMUX0_0.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_0_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_0.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_1: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_1_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_1.Reg, volatile.LoadUint8(&o.PMUX0_1.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_1_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_1.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_1_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_1.Reg, volatile.LoadUint8(&o.PMUX0_1.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_1_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_1.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_2: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_2_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_2.Reg, volatile.LoadUint8(&o.PMUX0_2.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_2_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_2.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_2_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_2.Reg, volatile.LoadUint8(&o.PMUX0_2.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_2_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_2.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_3: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_3_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_3.Reg, volatile.LoadUint8(&o.PMUX0_3.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_3_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_3.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_3_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_3.Reg, volatile.LoadUint8(&o.PMUX0_3.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_3_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_3.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_4: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_4_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_4.Reg, volatile.LoadUint8(&o.PMUX0_4.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_4_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_4.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_4_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_4.Reg, volatile.LoadUint8(&o.PMUX0_4.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_4_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_4.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_5: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_5_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_5.Reg, volatile.LoadUint8(&o.PMUX0_5.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_5_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_5.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_5_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_5.Reg, volatile.LoadUint8(&o.PMUX0_5.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_5_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_5.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_6: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_6_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_6.Reg, volatile.LoadUint8(&o.PMUX0_6.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_6_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_6.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_6_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_6.Reg, volatile.LoadUint8(&o.PMUX0_6.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_6_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_6.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_7: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_7_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_7.Reg, volatile.LoadUint8(&o.PMUX0_7.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_7_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_7.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_7_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_7.Reg, volatile.LoadUint8(&o.PMUX0_7.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_7_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_7.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_8: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_8_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_8.Reg, volatile.LoadUint8(&o.PMUX0_8.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_8_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_8.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_8_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_8.Reg, volatile.LoadUint8(&o.PMUX0_8.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_8_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_8.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_9: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_9_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_9.Reg, volatile.LoadUint8(&o.PMUX0_9.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_9_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_9.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_9_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_9.Reg, volatile.LoadUint8(&o.PMUX0_9.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_9_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_9.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_10: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_10_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_10.Reg, volatile.LoadUint8(&o.PMUX0_10.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_10_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_10.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_10_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_10.Reg, volatile.LoadUint8(&o.PMUX0_10.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_10_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_10.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_11: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_11_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_11.Reg, volatile.LoadUint8(&o.PMUX0_11.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_11_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_11.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_11_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_11.Reg, volatile.LoadUint8(&o.PMUX0_11.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_11_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_11.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_12: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_12_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_12.Reg, volatile.LoadUint8(&o.PMUX0_12.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_12_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_12.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_12_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_12.Reg, volatile.LoadUint8(&o.PMUX0_12.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_12_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_12.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_13: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_13_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_13.Reg, volatile.LoadUint8(&o.PMUX0_13.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_13_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_13.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_13_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_13.Reg, volatile.LoadUint8(&o.PMUX0_13.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_13_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_13.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_14: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_14_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_14.Reg, volatile.LoadUint8(&o.PMUX0_14.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_14_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_14.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_14_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_14.Reg, volatile.LoadUint8(&o.PMUX0_14.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_14_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_14.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_15: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_15_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_15.Reg, volatile.LoadUint8(&o.PMUX0_15.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_15_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_15.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_15_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_15.Reg, volatile.LoadUint8(&o.PMUX0_15.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_15_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_15.Reg) & 0xf0) >> 4
}

// PORT.PINCFG0_0: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_0_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_0.Reg, volatile.LoadUint8(&o.PINCFG0_0.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_0_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_0.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_0_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_0.Reg, volatile.LoadUint8(&o.PINCFG0_0.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_0_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_0.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_0_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_0.Reg, volatile.LoadUint8(&o.PINCFG0_0.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_0_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_0.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_0_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_0.Reg, volatile.LoadUint8(&o.PINCFG0_0.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_0_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_0.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_1: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_1_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_1.Reg, volatile.LoadUint8(&o.PINCFG0_1.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_1_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_1.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_1_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_1.Reg, volatile.LoadUint8(&o.PINCFG0_1.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_1_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_1.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_1_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_1.Reg, volatile.LoadUint8(&o.PINCFG0_1.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_1_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_1.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_1_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_1.Reg, volatile.LoadUint8(&o.PINCFG0_1.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_1_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_1.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_2: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_2_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_2.Reg, volatile.LoadUint8(&o.PINCFG0_2.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_2_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_2.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_2_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_2.Reg, volatile.LoadUint8(&o.PINCFG0_2.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_2_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_2.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_2_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_2.Reg, volatile.LoadUint8(&o.PINCFG0_2.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_2_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_2.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_2_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_2.Reg, volatile.LoadUint8(&o.PINCFG0_2.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_2_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_2.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_3: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_3_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_3.Reg, volatile.LoadUint8(&o.PINCFG0_3.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_3_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_3.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_3_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_3.Reg, volatile.LoadUint8(&o.PINCFG0_3.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_3_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_3.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_3_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_3.Reg, volatile.LoadUint8(&o.PINCFG0_3.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_3_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_3.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_3_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_3.Reg, volatile.LoadUint8(&o.PINCFG0_3.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_3_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_3.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_4: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_4_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_4.Reg, volatile.LoadUint8(&o.PINCFG0_4.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_4_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_4.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_4_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_4.Reg, volatile.LoadUint8(&o.PINCFG0_4.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_4_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_4.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_4_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_4.Reg, volatile.LoadUint8(&o.PINCFG0_4.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_4_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_4.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_4_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_4.Reg, volatile.LoadUint8(&o.PINCFG0_4.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_4_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_4.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_5: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_5_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_5.Reg, volatile.LoadUint8(&o.PINCFG0_5.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_5_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_5.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_5_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_5.Reg, volatile.LoadUint8(&o.PINCFG0_5.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_5_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_5.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_5_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_5.Reg, volatile.LoadUint8(&o.PINCFG0_5.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_5_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_5.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_5_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_5.Reg, volatile.LoadUint8(&o.PINCFG0_5.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_5_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_5.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_6: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_6_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_6.Reg, volatile.LoadUint8(&o.PINCFG0_6.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_6_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_6.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_6_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_6.Reg, volatile.LoadUint8(&o.PINCFG0_6.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_6_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_6.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_6_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_6.Reg, volatile.LoadUint8(&o.PINCFG0_6.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_6_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_6.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_6_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_6.Reg, volatile.LoadUint8(&o.PINCFG0_6.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_6_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_6.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_7: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_7_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_7.Reg, volatile.LoadUint8(&o.PINCFG0_7.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_7_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_7.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_7_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_7.Reg, volatile.LoadUint8(&o.PINCFG0_7.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_7_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_7.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_7_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_7.Reg, volatile.LoadUint8(&o.PINCFG0_7.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_7_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_7.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_7_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_7.Reg, volatile.LoadUint8(&o.PINCFG0_7.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_7_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_7.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_8: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_8_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_8.Reg, volatile.LoadUint8(&o.PINCFG0_8.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_8_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_8.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_8_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_8.Reg, volatile.LoadUint8(&o.PINCFG0_8.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_8_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_8.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_8_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_8.Reg, volatile.LoadUint8(&o.PINCFG0_8.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_8_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_8.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_8_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_8.Reg, volatile.LoadUint8(&o.PINCFG0_8.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_8_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_8.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_9: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_9_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_9.Reg, volatile.LoadUint8(&o.PINCFG0_9.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_9_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_9.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_9_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_9.Reg, volatile.LoadUint8(&o.PINCFG0_9.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_9_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_9.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_9_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_9.Reg, volatile.LoadUint8(&o.PINCFG0_9.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_9_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_9.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_9_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_9.Reg, volatile.LoadUint8(&o.PINCFG0_9.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_9_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_9.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_10: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_10_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_10.Reg, volatile.LoadUint8(&o.PINCFG0_10.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_10_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_10.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_10_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_10.Reg, volatile.LoadUint8(&o.PINCFG0_10.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_10_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_10.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_10_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_10.Reg, volatile.LoadUint8(&o.PINCFG0_10.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_10_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_10.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_10_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_10.Reg, volatile.LoadUint8(&o.PINCFG0_10.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_10_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_10.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_11: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_11_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_11.Reg, volatile.LoadUint8(&o.PINCFG0_11.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_11_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_11.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_11_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_11.Reg, volatile.LoadUint8(&o.PINCFG0_11.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_11_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_11.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_11_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_11.Reg, volatile.LoadUint8(&o.PINCFG0_11.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_11_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_11.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_11_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_11.Reg, volatile.LoadUint8(&o.PINCFG0_11.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_11_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_11.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_12: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_12_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_12.Reg, volatile.LoadUint8(&o.PINCFG0_12.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_12_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_12.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_12_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_12.Reg, volatile.LoadUint8(&o.PINCFG0_12.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_12_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_12.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_12_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_12.Reg, volatile.LoadUint8(&o.PINCFG0_12.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_12_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_12.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_12_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_12.Reg, volatile.LoadUint8(&o.PINCFG0_12.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_12_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_12.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_13: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_13_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_13.Reg, volatile.LoadUint8(&o.PINCFG0_13.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_13_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_13.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_13_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_13.Reg, volatile.LoadUint8(&o.PINCFG0_13.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_13_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_13.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_13_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_13.Reg, volatile.LoadUint8(&o.PINCFG0_13.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_13_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_13.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_13_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_13.Reg, volatile.LoadUint8(&o.PINCFG0_13.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_13_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_13.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_14: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_14_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_14.Reg, volatile.LoadUint8(&o.PINCFG0_14.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_14_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_14.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_14_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_14.Reg, volatile.LoadUint8(&o.PINCFG0_14.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_14_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_14.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_14_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_14.Reg, volatile.LoadUint8(&o.PINCFG0_14.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_14_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_14.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_14_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_14.Reg, volatile.LoadUint8(&o.PINCFG0_14.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_14_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_14.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_15: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_15_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_15.Reg, volatile.LoadUint8(&o.PINCFG0_15.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_15_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_15.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_15_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_15.Reg, volatile.LoadUint8(&o.PINCFG0_15.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_15_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_15.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_15_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_15.Reg, volatile.LoadUint8(&o.PINCFG0_15.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_15_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_15.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_15_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_15.Reg, volatile.LoadUint8(&o.PINCFG0_15.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_15_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_15.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_16: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_16_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_16.Reg, volatile.LoadUint8(&o.PINCFG0_16.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_16_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_16.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_16_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_16.Reg, volatile.LoadUint8(&o.PINCFG0_16.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_16_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_16.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_16_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_16.Reg, volatile.LoadUint8(&o.PINCFG0_16.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_16_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_16.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_16_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_16.Reg, volatile.LoadUint8(&o.PINCFG0_16.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_16_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_16.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_17: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_17_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_17.Reg, volatile.LoadUint8(&o.PINCFG0_17.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_17_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_17.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_17_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_17.Reg, volatile.LoadUint8(&o.PINCFG0_17.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_17_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_17.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_17_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_17.Reg, volatile.LoadUint8(&o.PINCFG0_17.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_17_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_17.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_17_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_17.Reg, volatile.LoadUint8(&o.PINCFG0_17.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_17_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_17.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_18: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_18_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_18.Reg, volatile.LoadUint8(&o.PINCFG0_18.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_18_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_18.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_18_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_18.Reg, volatile.LoadUint8(&o.PINCFG0_18.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_18_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_18.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_18_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_18.Reg, volatile.LoadUint8(&o.PINCFG0_18.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_18_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_18.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_18_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_18.Reg, volatile.LoadUint8(&o.PINCFG0_18.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_18_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_18.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_19: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_19_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_19.Reg, volatile.LoadUint8(&o.PINCFG0_19.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_19_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_19.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_19_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_19.Reg, volatile.LoadUint8(&o.PINCFG0_19.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_19_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_19.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_19_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_19.Reg, volatile.LoadUint8(&o.PINCFG0_19.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_19_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_19.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_19_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_19.Reg, volatile.LoadUint8(&o.PINCFG0_19.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_19_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_19.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_20: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_20_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_20.Reg, volatile.LoadUint8(&o.PINCFG0_20.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_20_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_20.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_20_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_20.Reg, volatile.LoadUint8(&o.PINCFG0_20.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_20_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_20.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_20_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_20.Reg, volatile.LoadUint8(&o.PINCFG0_20.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_20_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_20.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_20_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_20.Reg, volatile.LoadUint8(&o.PINCFG0_20.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_20_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_20.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_21: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_21_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_21.Reg, volatile.LoadUint8(&o.PINCFG0_21.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_21_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_21.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_21_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_21.Reg, volatile.LoadUint8(&o.PINCFG0_21.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_21_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_21.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_21_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_21.Reg, volatile.LoadUint8(&o.PINCFG0_21.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_21_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_21.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_21_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_21.Reg, volatile.LoadUint8(&o.PINCFG0_21.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_21_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_21.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_22: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_22_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_22.Reg, volatile.LoadUint8(&o.PINCFG0_22.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_22_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_22.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_22_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_22.Reg, volatile.LoadUint8(&o.PINCFG0_22.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_22_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_22.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_22_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_22.Reg, volatile.LoadUint8(&o.PINCFG0_22.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_22_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_22.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_22_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_22.Reg, volatile.LoadUint8(&o.PINCFG0_22.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_22_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_22.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_23: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_23_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_23.Reg, volatile.LoadUint8(&o.PINCFG0_23.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_23_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_23.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_23_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_23.Reg, volatile.LoadUint8(&o.PINCFG0_23.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_23_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_23.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_23_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_23.Reg, volatile.LoadUint8(&o.PINCFG0_23.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_23_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_23.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_23_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_23.Reg, volatile.LoadUint8(&o.PINCFG0_23.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_23_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_23.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_24: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_24_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_24.Reg, volatile.LoadUint8(&o.PINCFG0_24.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_24_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_24.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_24_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_24.Reg, volatile.LoadUint8(&o.PINCFG0_24.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_24_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_24.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_24_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_24.Reg, volatile.LoadUint8(&o.PINCFG0_24.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_24_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_24.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_24_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_24.Reg, volatile.LoadUint8(&o.PINCFG0_24.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_24_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_24.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_25: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_25_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_25.Reg, volatile.LoadUint8(&o.PINCFG0_25.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_25_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_25.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_25_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_25.Reg, volatile.LoadUint8(&o.PINCFG0_25.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_25_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_25.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_25_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_25.Reg, volatile.LoadUint8(&o.PINCFG0_25.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_25_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_25.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_25_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_25.Reg, volatile.LoadUint8(&o.PINCFG0_25.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_25_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_25.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_26: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_26_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_26.Reg, volatile.LoadUint8(&o.PINCFG0_26.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_26_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_26.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_26_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_26.Reg, volatile.LoadUint8(&o.PINCFG0_26.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_26_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_26.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_26_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_26.Reg, volatile.LoadUint8(&o.PINCFG0_26.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_26_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_26.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_26_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_26.Reg, volatile.LoadUint8(&o.PINCFG0_26.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_26_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_26.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_27: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_27_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_27.Reg, volatile.LoadUint8(&o.PINCFG0_27.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_27_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_27.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_27_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_27.Reg, volatile.LoadUint8(&o.PINCFG0_27.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_27_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_27.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_27_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_27.Reg, volatile.LoadUint8(&o.PINCFG0_27.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_27_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_27.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_27_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_27.Reg, volatile.LoadUint8(&o.PINCFG0_27.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_27_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_27.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_28: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_28_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_28.Reg, volatile.LoadUint8(&o.PINCFG0_28.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_28_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_28.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_28_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_28.Reg, volatile.LoadUint8(&o.PINCFG0_28.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_28_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_28.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_28_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_28.Reg, volatile.LoadUint8(&o.PINCFG0_28.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_28_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_28.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_28_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_28.Reg, volatile.LoadUint8(&o.PINCFG0_28.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_28_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_28.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_29: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_29_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_29.Reg, volatile.LoadUint8(&o.PINCFG0_29.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_29_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_29.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_29_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_29.Reg, volatile.LoadUint8(&o.PINCFG0_29.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_29_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_29.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_29_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_29.Reg, volatile.LoadUint8(&o.PINCFG0_29.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_29_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_29.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_29_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_29.Reg, volatile.LoadUint8(&o.PINCFG0_29.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_29_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_29.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_30: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_30_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_30.Reg, volatile.LoadUint8(&o.PINCFG0_30.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_30_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_30.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_30_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_30.Reg, volatile.LoadUint8(&o.PINCFG0_30.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_30_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_30.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_30_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_30.Reg, volatile.LoadUint8(&o.PINCFG0_30.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_30_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_30.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_30_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_30.Reg, volatile.LoadUint8(&o.PINCFG0_30.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_30_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_30.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_31: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_31_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_31.Reg, volatile.LoadUint8(&o.PINCFG0_31.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_31_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_31.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_31_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_31.Reg, volatile.LoadUint8(&o.PINCFG0_31.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_31_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_31.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_31_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_31.Reg, volatile.LoadUint8(&o.PINCFG0_31.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_31_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_31.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_31_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_31.Reg, volatile.LoadUint8(&o.PINCFG0_31.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_31_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_31.Reg) & 0x40) >> 6
}

// Real-Time Counter
type RTC_Type struct {
}

// Real-Time Counter - MODE0
type RTC_MODE0_Type struct {
	CTRL     volatile.Register16 // 0x0
	READREQ  volatile.Register16 // 0x2
	EVCTRL   volatile.Register16 // 0x4
	INTENCLR volatile.Register8  // 0x6
	INTENSET volatile.Register8  // 0x7
	INTFLAG  volatile.Register8  // 0x8
	_        byte
	STATUS   volatile.Register8 // 0xA
	DBGCTRL  volatile.Register8 // 0xB
	FREQCORR volatile.Register8 // 0xC
	_        [3]byte
	COUNT    volatile.Register32 // 0x10
	_        [4]byte
	COMP0    volatile.Register32 // 0x18
}

// RTC_MODE0.CTRL: MODE0 Control
func (o *RTC_MODE0_Type) SetCTRL_SWRST(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetCTRL_SWRST() uint16 {
	return volatile.LoadUint16(&o.CTRL.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetCTRL_ENABLE(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE0_Type) GetCTRL_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *RTC_MODE0_Type) SetCTRL_MODE(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0xc)|value<<2)
}
func (o *RTC_MODE0_Type) GetCTRL_MODE() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0xc) >> 2
}
func (o *RTC_MODE0_Type) SetCTRL_MATCHCLR(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetCTRL_MATCHCLR() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *RTC_MODE0_Type) SetCTRL_PRESCALER(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_MODE0_Type) GetCTRL_PRESCALER() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0xf00) >> 8
}

// RTC_MODE0.READREQ: Read Request
func (o *RTC_MODE0_Type) SetREADREQ_ADDR(value uint16) {
	volatile.StoreUint16(&o.READREQ.Reg, volatile.LoadUint16(&o.READREQ.Reg)&^(0x3f)|value)
}
func (o *RTC_MODE0_Type) GetREADREQ_ADDR() uint16 {
	return volatile.LoadUint16(&o.READREQ.Reg) & 0x3f
}
func (o *RTC_MODE0_Type) SetREADREQ_RCONT(value uint16) {
	volatile.StoreUint16(&o.READREQ.Reg, volatile.LoadUint16(&o.READREQ.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE0_Type) GetREADREQ_RCONT() uint16 {
	return (volatile.LoadUint16(&o.READREQ.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE0_Type) SetREADREQ_RREQ(value uint16) {
	volatile.StoreUint16(&o.READREQ.Reg, volatile.LoadUint16(&o.READREQ.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE0_Type) GetREADREQ_RREQ() uint16 {
	return (volatile.LoadUint16(&o.READREQ.Reg) & 0x8000) >> 15
}

// RTC_MODE0.EVCTRL: MODE0 Event Control
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO0() uint16 {
	return volatile.LoadUint16(&o.EVCTRL.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO2(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO2() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x4) >> 2
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO3(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO3() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x8) >> 3
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO4(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO4() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO5(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO5() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO6(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO6() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x40) >> 6
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO7(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO7() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x80) >> 7
}
func (o *RTC_MODE0_Type) SetEVCTRL_CMPEO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE0_Type) GetEVCTRL_CMPEO0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *RTC_MODE0_Type) SetEVCTRL_OVFEO(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE0_Type) GetEVCTRL_OVFEO() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x8000) >> 15
}

// RTC_MODE0.INTENCLR: MODE0 Interrupt Enable Clear
func (o *RTC_MODE0_Type) SetINTENCLR_CMP0(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetINTENCLR_CMP0() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetINTENCLR_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE0_Type) GetINTENCLR_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *RTC_MODE0_Type) SetINTENCLR_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetINTENCLR_OVF() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x80) >> 7
}

// RTC_MODE0.INTENSET: MODE0 Interrupt Enable Set
func (o *RTC_MODE0_Type) SetINTENSET_CMP0(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetINTENSET_CMP0() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetINTENSET_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE0_Type) GetINTENSET_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *RTC_MODE0_Type) SetINTENSET_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetINTENSET_OVF() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x80) >> 7
}

// RTC_MODE0.INTFLAG: MODE0 Interrupt Flag Status and Clear
func (o *RTC_MODE0_Type) SetINTFLAG_CMP0(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetINTFLAG_CMP0() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetINTFLAG_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE0_Type) GetINTFLAG_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x40) >> 6
}
func (o *RTC_MODE0_Type) SetINTFLAG_OVF(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetINTFLAG_OVF() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x80) >> 7
}

// RTC_MODE0.STATUS: Status
func (o *RTC_MODE0_Type) SetSTATUS_SYNCBUSY(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetSTATUS_SYNCBUSY() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x80) >> 7
}

// RTC_MODE0.DBGCTRL: Debug Control
func (o *RTC_MODE0_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// RTC_MODE0.FREQCORR: Frequency Correction
func (o *RTC_MODE0_Type) SetFREQCORR_VALUE(value uint8) {
	volatile.StoreUint8(&o.FREQCORR.Reg, volatile.LoadUint8(&o.FREQCORR.Reg)&^(0x7f)|value)
}
func (o *RTC_MODE0_Type) GetFREQCORR_VALUE() uint8 {
	return volatile.LoadUint8(&o.FREQCORR.Reg) & 0x7f
}
func (o *RTC_MODE0_Type) SetFREQCORR_SIGN(value uint8) {
	volatile.StoreUint8(&o.FREQCORR.Reg, volatile.LoadUint8(&o.FREQCORR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetFREQCORR_SIGN() uint8 {
	return (volatile.LoadUint8(&o.FREQCORR.Reg) & 0x80) >> 7
}

// RTC_MODE0.COUNT: MODE0 Counter Value
func (o *RTC_MODE0_Type) SetCOUNT(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, value)
}
func (o *RTC_MODE0_Type) GetCOUNT() uint32 {
	return volatile.LoadUint32(&o.COUNT.Reg)
}

// RTC_MODE0.COMP0: MODE0 Compare n Value
func (o *RTC_MODE0_Type) SetCOMP0(value uint32) {
	volatile.StoreUint32(&o.COMP0.Reg, value)
}
func (o *RTC_MODE0_Type) GetCOMP0() uint32 {
	return volatile.LoadUint32(&o.COMP0.Reg)
}

// Real-Time Counter - MODE1
type RTC_MODE1_Type struct {
	CTRL     volatile.Register16 // 0x0
	READREQ  volatile.Register16 // 0x2
	EVCTRL   volatile.Register16 // 0x4
	INTENCLR volatile.Register8  // 0x6
	INTENSET volatile.Register8  // 0x7
	INTFLAG  volatile.Register8  // 0x8
	_        byte
	STATUS   volatile.Register8 // 0xA
	DBGCTRL  volatile.Register8 // 0xB
	FREQCORR volatile.Register8 // 0xC
	_        [3]byte
	COUNT    volatile.Register16 // 0x10
	_        [2]byte
	PER      volatile.Register16 // 0x14
	_        [2]byte
	COMP0    volatile.Register16 // 0x18
	COMP1    volatile.Register16 // 0x1A
}

// RTC_MODE1.CTRL: MODE1 Control
func (o *RTC_MODE1_Type) SetCTRL_SWRST(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetCTRL_SWRST() uint16 {
	return volatile.LoadUint16(&o.CTRL.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetCTRL_ENABLE(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetCTRL_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetCTRL_MODE(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0xc)|value<<2)
}
func (o *RTC_MODE1_Type) GetCTRL_MODE() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0xc) >> 2
}
func (o *RTC_MODE1_Type) SetCTRL_PRESCALER(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_MODE1_Type) GetCTRL_PRESCALER() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0xf00) >> 8
}

// RTC_MODE1.READREQ: Read Request
func (o *RTC_MODE1_Type) SetREADREQ_ADDR(value uint16) {
	volatile.StoreUint16(&o.READREQ.Reg, volatile.LoadUint16(&o.READREQ.Reg)&^(0x3f)|value)
}
func (o *RTC_MODE1_Type) GetREADREQ_ADDR() uint16 {
	return volatile.LoadUint16(&o.READREQ.Reg) & 0x3f
}
func (o *RTC_MODE1_Type) SetREADREQ_RCONT(value uint16) {
	volatile.StoreUint16(&o.READREQ.Reg, volatile.LoadUint16(&o.READREQ.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE1_Type) GetREADREQ_RCONT() uint16 {
	return (volatile.LoadUint16(&o.READREQ.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE1_Type) SetREADREQ_RREQ(value uint16) {
	volatile.StoreUint16(&o.READREQ.Reg, volatile.LoadUint16(&o.READREQ.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE1_Type) GetREADREQ_RREQ() uint16 {
	return (volatile.LoadUint16(&o.READREQ.Reg) & 0x8000) >> 15
}

// RTC_MODE1.EVCTRL: MODE1 Event Control
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO0() uint16 {
	return volatile.LoadUint16(&o.EVCTRL.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO2(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO2() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x4) >> 2
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO3(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO3() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x8) >> 3
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO4(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO4() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO5(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO5() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO6(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO6() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x40) >> 6
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO7(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO7() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x80) >> 7
}
func (o *RTC_MODE1_Type) SetEVCTRL_CMPEO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE1_Type) GetEVCTRL_CMPEO0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *RTC_MODE1_Type) SetEVCTRL_CMPEO1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x200)|value<<9)
}
func (o *RTC_MODE1_Type) GetEVCTRL_CMPEO1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x200) >> 9
}
func (o *RTC_MODE1_Type) SetEVCTRL_OVFEO(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE1_Type) GetEVCTRL_OVFEO() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x8000) >> 15
}

// RTC_MODE1.INTENCLR: MODE1 Interrupt Enable Clear
func (o *RTC_MODE1_Type) SetINTENCLR_CMP0(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetINTENCLR_CMP0() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetINTENCLR_CMP1(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetINTENCLR_CMP1() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetINTENCLR_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE1_Type) GetINTENCLR_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *RTC_MODE1_Type) SetINTENCLR_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE1_Type) GetINTENCLR_OVF() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x80) >> 7
}

// RTC_MODE1.INTENSET: MODE1 Interrupt Enable Set
func (o *RTC_MODE1_Type) SetINTENSET_CMP0(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetINTENSET_CMP0() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetINTENSET_CMP1(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetINTENSET_CMP1() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetINTENSET_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE1_Type) GetINTENSET_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *RTC_MODE1_Type) SetINTENSET_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE1_Type) GetINTENSET_OVF() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x80) >> 7
}

// RTC_MODE1.INTFLAG: MODE1 Interrupt Flag Status and Clear
func (o *RTC_MODE1_Type) SetINTFLAG_CMP0(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetINTFLAG_CMP0() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetINTFLAG_CMP1(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetINTFLAG_CMP1() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetINTFLAG_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE1_Type) GetINTFLAG_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x40) >> 6
}
func (o *RTC_MODE1_Type) SetINTFLAG_OVF(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE1_Type) GetINTFLAG_OVF() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x80) >> 7
}

// RTC_MODE1.STATUS: Status
func (o *RTC_MODE1_Type) SetSTATUS_SYNCBUSY(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE1_Type) GetSTATUS_SYNCBUSY() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x80) >> 7
}

// RTC_MODE1.DBGCTRL: Debug Control
func (o *RTC_MODE1_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// RTC_MODE1.FREQCORR: Frequency Correction
func (o *RTC_MODE1_Type) SetFREQCORR_VALUE(value uint8) {
	volatile.StoreUint8(&o.FREQCORR.Reg, volatile.LoadUint8(&o.FREQCORR.Reg)&^(0x7f)|value)
}
func (o *RTC_MODE1_Type) GetFREQCORR_VALUE() uint8 {
	return volatile.LoadUint8(&o.FREQCORR.Reg) & 0x7f
}
func (o *RTC_MODE1_Type) SetFREQCORR_SIGN(value uint8) {
	volatile.StoreUint8(&o.FREQCORR.Reg, volatile.LoadUint8(&o.FREQCORR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE1_Type) GetFREQCORR_SIGN() uint8 {
	return (volatile.LoadUint8(&o.FREQCORR.Reg) & 0x80) >> 7
}

// RTC_MODE1.COUNT: MODE1 Counter Value
func (o *RTC_MODE1_Type) SetCOUNT(value uint16) {
	volatile.StoreUint16(&o.COUNT.Reg, value)
}
func (o *RTC_MODE1_Type) GetCOUNT() uint16 {
	return volatile.LoadUint16(&o.COUNT.Reg)
}

// RTC_MODE1.PER: MODE1 Counter Period
func (o *RTC_MODE1_Type) SetPER(value uint16) {
	volatile.StoreUint16(&o.PER.Reg, value)
}
func (o *RTC_MODE1_Type) GetPER() uint16 {
	return volatile.LoadUint16(&o.PER.Reg)
}

// RTC_MODE1.COMP0: MODE1 Compare n Value
func (o *RTC_MODE1_Type) SetCOMP0(value uint16) {
	volatile.StoreUint16(&o.COMP0.Reg, value)
}
func (o *RTC_MODE1_Type) GetCOMP0() uint16 {
	return volatile.LoadUint16(&o.COMP0.Reg)
}

// RTC_MODE1.COMP1: MODE1 Compare n Value
func (o *RTC_MODE1_Type) SetCOMP1(value uint16) {
	volatile.StoreUint16(&o.COMP1.Reg, value)
}
func (o *RTC_MODE1_Type) GetCOMP1() uint16 {
	return volatile.LoadUint16(&o.COMP1.Reg)
}

// Real-Time Counter - MODE2
type RTC_MODE2_Type struct {
	CTRL     volatile.Register16 // 0x0
	READREQ  volatile.Register16 // 0x2
	EVCTRL   volatile.Register16 // 0x4
	INTENCLR volatile.Register8  // 0x6
	INTENSET volatile.Register8  // 0x7
	INTFLAG  volatile.Register8  // 0x8
	_        byte
	STATUS   volatile.Register8 // 0xA
	DBGCTRL  volatile.Register8 // 0xB
	FREQCORR volatile.Register8 // 0xC
	_        [3]byte
	CLOCK    volatile.Register32 // 0x10
	_        [4]byte
	ALARM0   volatile.Register32 // 0x18
	MASK0    volatile.Register8  // 0x1C
}

// RTC_MODE2.CTRL: MODE2 Control
func (o *RTC_MODE2_Type) SetCTRL_SWRST(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetCTRL_SWRST() uint16 {
	return volatile.LoadUint16(&o.CTRL.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetCTRL_ENABLE(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE2_Type) GetCTRL_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *RTC_MODE2_Type) SetCTRL_MODE(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0xc)|value<<2)
}
func (o *RTC_MODE2_Type) GetCTRL_MODE() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0xc) >> 2
}
func (o *RTC_MODE2_Type) SetCTRL_CLKREP(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE2_Type) GetCTRL_CLKREP() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *RTC_MODE2_Type) SetCTRL_MATCHCLR(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetCTRL_MATCHCLR() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *RTC_MODE2_Type) SetCTRL_PRESCALER(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_MODE2_Type) GetCTRL_PRESCALER() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0xf00) >> 8
}

// RTC_MODE2.READREQ: Read Request
func (o *RTC_MODE2_Type) SetREADREQ_ADDR(value uint16) {
	volatile.StoreUint16(&o.READREQ.Reg, volatile.LoadUint16(&o.READREQ.Reg)&^(0x3f)|value)
}
func (o *RTC_MODE2_Type) GetREADREQ_ADDR() uint16 {
	return volatile.LoadUint16(&o.READREQ.Reg) & 0x3f
}
func (o *RTC_MODE2_Type) SetREADREQ_RCONT(value uint16) {
	volatile.StoreUint16(&o.READREQ.Reg, volatile.LoadUint16(&o.READREQ.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE2_Type) GetREADREQ_RCONT() uint16 {
	return (volatile.LoadUint16(&o.READREQ.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE2_Type) SetREADREQ_RREQ(value uint16) {
	volatile.StoreUint16(&o.READREQ.Reg, volatile.LoadUint16(&o.READREQ.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE2_Type) GetREADREQ_RREQ() uint16 {
	return (volatile.LoadUint16(&o.READREQ.Reg) & 0x8000) >> 15
}

// RTC_MODE2.EVCTRL: MODE2 Event Control
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO0() uint16 {
	return volatile.LoadUint16(&o.EVCTRL.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO2(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO2() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x4) >> 2
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO3(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO3() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x8) >> 3
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO4(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO4() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO5(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO5() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO6(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO6() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x40) >> 6
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO7(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO7() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x80) >> 7
}
func (o *RTC_MODE2_Type) SetEVCTRL_ALARMEO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE2_Type) GetEVCTRL_ALARMEO0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *RTC_MODE2_Type) SetEVCTRL_OVFEO(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE2_Type) GetEVCTRL_OVFEO() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x8000) >> 15
}

// RTC_MODE2.INTENCLR: MODE2 Interrupt Enable Clear
func (o *RTC_MODE2_Type) SetINTENCLR_ALARM0(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetINTENCLR_ALARM0() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetINTENCLR_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE2_Type) GetINTENCLR_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *RTC_MODE2_Type) SetINTENCLR_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetINTENCLR_OVF() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x80) >> 7
}

// RTC_MODE2.INTENSET: MODE2 Interrupt Enable Set
func (o *RTC_MODE2_Type) SetINTENSET_ALARM0(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetINTENSET_ALARM0() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetINTENSET_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE2_Type) GetINTENSET_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *RTC_MODE2_Type) SetINTENSET_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetINTENSET_OVF() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x80) >> 7
}

// RTC_MODE2.INTFLAG: MODE2 Interrupt Flag Status and Clear
func (o *RTC_MODE2_Type) SetINTFLAG_ALARM0(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetINTFLAG_ALARM0() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetINTFLAG_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE2_Type) GetINTFLAG_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x40) >> 6
}
func (o *RTC_MODE2_Type) SetINTFLAG_OVF(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetINTFLAG_OVF() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x80) >> 7
}

// RTC_MODE2.STATUS: Status
func (o *RTC_MODE2_Type) SetSTATUS_SYNCBUSY(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetSTATUS_SYNCBUSY() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x80) >> 7
}

// RTC_MODE2.DBGCTRL: Debug Control
func (o *RTC_MODE2_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// RTC_MODE2.FREQCORR: Frequency Correction
func (o *RTC_MODE2_Type) SetFREQCORR_VALUE(value uint8) {
	volatile.StoreUint8(&o.FREQCORR.Reg, volatile.LoadUint8(&o.FREQCORR.Reg)&^(0x7f)|value)
}
func (o *RTC_MODE2_Type) GetFREQCORR_VALUE() uint8 {
	return volatile.LoadUint8(&o.FREQCORR.Reg) & 0x7f
}
func (o *RTC_MODE2_Type) SetFREQCORR_SIGN(value uint8) {
	volatile.StoreUint8(&o.FREQCORR.Reg, volatile.LoadUint8(&o.FREQCORR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetFREQCORR_SIGN() uint8 {
	return (volatile.LoadUint8(&o.FREQCORR.Reg) & 0x80) >> 7
}

// RTC_MODE2.CLOCK: MODE2 Clock Value
func (o *RTC_MODE2_Type) SetCLOCK_SECOND(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x3f)|value)
}
func (o *RTC_MODE2_Type) GetCLOCK_SECOND() uint32 {
	return volatile.LoadUint32(&o.CLOCK.Reg) & 0x3f
}
func (o *RTC_MODE2_Type) SetCLOCK_MINUTE(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0xfc0)|value<<6)
}
func (o *RTC_MODE2_Type) GetCLOCK_MINUTE() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0xfc0) >> 6
}
func (o *RTC_MODE2_Type) SetCLOCK_HOUR(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x1f000)|value<<12)
}
func (o *RTC_MODE2_Type) GetCLOCK_HOUR() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0x1f000) >> 12
}
func (o *RTC_MODE2_Type) SetCLOCK_DAY(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x3e0000)|value<<17)
}
func (o *RTC_MODE2_Type) GetCLOCK_DAY() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0x3e0000) >> 17
}
func (o *RTC_MODE2_Type) SetCLOCK_MONTH(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x3c00000)|value<<22)
}
func (o *RTC_MODE2_Type) GetCLOCK_MONTH() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0x3c00000) >> 22
}
func (o *RTC_MODE2_Type) SetCLOCK_YEAR(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0xfc000000)|value<<26)
}
func (o *RTC_MODE2_Type) GetCLOCK_YEAR() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0xfc000000) >> 26
}

// RTC_MODE2.ALARM0: MODE2 Alarm n Value
func (o *RTC_MODE2_Type) SetALARM0_SECOND(value uint32) {
	volatile.StoreUint32(&o.ALARM0.Reg, volatile.LoadUint32(&o.ALARM0.Reg)&^(0x3f)|value)
}
func (o *RTC_MODE2_Type) GetALARM0_SECOND() uint32 {
	return volatile.LoadUint32(&o.ALARM0.Reg) & 0x3f
}
func (o *RTC_MODE2_Type) SetALARM0_MINUTE(value uint32) {
	volatile.StoreUint32(&o.ALARM0.Reg, volatile.LoadUint32(&o.ALARM0.Reg)&^(0xfc0)|value<<6)
}
func (o *RTC_MODE2_Type) GetALARM0_MINUTE() uint32 {
	return (volatile.LoadUint32(&o.ALARM0.Reg) & 0xfc0) >> 6
}
func (o *RTC_MODE2_Type) SetALARM0_HOUR(value uint32) {
	volatile.StoreUint32(&o.ALARM0.Reg, volatile.LoadUint32(&o.ALARM0.Reg)&^(0x1f000)|value<<12)
}
func (o *RTC_MODE2_Type) GetALARM0_HOUR() uint32 {
	return (volatile.LoadUint32(&o.ALARM0.Reg) & 0x1f000) >> 12
}
func (o *RTC_MODE2_Type) SetALARM0_DAY(value uint32) {
	volatile.StoreUint32(&o.ALARM0.Reg, volatile.LoadUint32(&o.ALARM0.Reg)&^(0x3e0000)|value<<17)
}
func (o *RTC_MODE2_Type) GetALARM0_DAY() uint32 {
	return (volatile.LoadUint32(&o.ALARM0.Reg) & 0x3e0000) >> 17
}
func (o *RTC_MODE2_Type) SetALARM0_MONTH(value uint32) {
	volatile.StoreUint32(&o.ALARM0.Reg, volatile.LoadUint32(&o.ALARM0.Reg)&^(0x3c00000)|value<<22)
}
func (o *RTC_MODE2_Type) GetALARM0_MONTH() uint32 {
	return (volatile.LoadUint32(&o.ALARM0.Reg) & 0x3c00000) >> 22
}
func (o *RTC_MODE2_Type) SetALARM0_YEAR(value uint32) {
	volatile.StoreUint32(&o.ALARM0.Reg, volatile.LoadUint32(&o.ALARM0.Reg)&^(0xfc000000)|value<<26)
}
func (o *RTC_MODE2_Type) GetALARM0_YEAR() uint32 {
	return (volatile.LoadUint32(&o.ALARM0.Reg) & 0xfc000000) >> 26
}

// RTC_MODE2.MASK0: MODE2 Alarm n Mask
func (o *RTC_MODE2_Type) SetMASK0_SEL(value uint8) {
	volatile.StoreUint8(&o.MASK0.Reg, volatile.LoadUint8(&o.MASK0.Reg)&^(0x7)|value)
}
func (o *RTC_MODE2_Type) GetMASK0_SEL() uint8 {
	return volatile.LoadUint8(&o.MASK0.Reg) & 0x7
}

// Serial Communication Interface 0
type SERCOM_Type struct {
}

// Serial Communication Interface 0 - I2CM
type SERCOM_I2CM_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	_        [4]byte
	BAUD     volatile.Register32 // 0xC
	_        [4]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	_        [4]byte
	ADDR     volatile.Register32 // 0x24
	DATA     volatile.Register8  // 0x28
	_        [7]byte
	DBGCTRL  volatile.Register8 // 0x30
}

// SERCOM_I2CM.CTRLA: I2CM Control A
func (o *SERCOM_I2CM_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *SERCOM_I2CM_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CM_Type) SetCTRLA_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1c)|value<<2)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x1c) >> 2
}
func (o *SERCOM_I2CM_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *SERCOM_I2CM_Type) SetCTRLA_PINOUT(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x10000)|value<<16)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_PINOUT() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x10000) >> 16
}
func (o *SERCOM_I2CM_Type) SetCTRLA_SDAHOLD(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x300000)|value<<20)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_SDAHOLD() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x300000) >> 20
}
func (o *SERCOM_I2CM_Type) SetCTRLA_MEXTTOEN(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x400000)|value<<22)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_MEXTTOEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x400000) >> 22
}
func (o *SERCOM_I2CM_Type) SetCTRLA_SEXTTOEN(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x800000)|value<<23)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_SEXTTOEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x800000) >> 23
}
func (o *SERCOM_I2CM_Type) SetCTRLA_SPEED(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x3000000)|value<<24)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_SPEED() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x3000000) >> 24
}
func (o *SERCOM_I2CM_Type) SetCTRLA_SCLSM(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x8000000)|value<<27)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_SCLSM() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x8000000) >> 27
}
func (o *SERCOM_I2CM_Type) SetCTRLA_INACTOUT(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x30000000)|value<<28)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_INACTOUT() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x30000000) >> 28
}
func (o *SERCOM_I2CM_Type) SetCTRLA_LOWTOUTEN(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40000000)|value<<30)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_LOWTOUTEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40000000) >> 30
}

// SERCOM_I2CM.CTRLB: I2CM Control B
func (o *SERCOM_I2CM_Type) SetCTRLB_SMEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x100)|value<<8)
}
func (o *SERCOM_I2CM_Type) GetCTRLB_SMEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x100) >> 8
}
func (o *SERCOM_I2CM_Type) SetCTRLB_QCEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_I2CM_Type) GetCTRLB_QCEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x200) >> 9
}
func (o *SERCOM_I2CM_Type) SetCTRLB_CMD(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x30000)|value<<16)
}
func (o *SERCOM_I2CM_Type) GetCTRLB_CMD() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x30000) >> 16
}
func (o *SERCOM_I2CM_Type) SetCTRLB_ACKACT(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x40000)|value<<18)
}
func (o *SERCOM_I2CM_Type) GetCTRLB_ACKACT() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x40000) >> 18
}

// SERCOM_I2CM.BAUD: I2CM Baud Rate
func (o *SERCOM_I2CM_Type) SetBAUD(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0xff)|value)
}
func (o *SERCOM_I2CM_Type) GetBAUD() uint32 {
	return volatile.LoadUint32(&o.BAUD.Reg) & 0xff
}
func (o *SERCOM_I2CM_Type) SetBAUD_BAUDLOW(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0xff00)|value<<8)
}
func (o *SERCOM_I2CM_Type) GetBAUD_BAUDLOW() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0xff00) >> 8
}
func (o *SERCOM_I2CM_Type) SetBAUD_HSBAUD(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0xff0000)|value<<16)
}
func (o *SERCOM_I2CM_Type) GetBAUD_HSBAUD() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0xff0000) >> 16
}
func (o *SERCOM_I2CM_Type) SetBAUD_HSBAUDLOW(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0xff000000)|value<<24)
}
func (o *SERCOM_I2CM_Type) GetBAUD_HSBAUDLOW() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0xff000000) >> 24
}

// SERCOM_I2CM.INTENCLR: I2CM Interrupt Enable Clear
func (o *SERCOM_I2CM_Type) SetINTENCLR_MB(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetINTENCLR_MB() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *SERCOM_I2CM_Type) SetINTENCLR_SB(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CM_Type) GetINTENCLR_SB() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CM_Type) SetINTENCLR_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CM_Type) GetINTENCLR_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x80) >> 7
}

// SERCOM_I2CM.INTENSET: I2CM Interrupt Enable Set
func (o *SERCOM_I2CM_Type) SetINTENSET_MB(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetINTENSET_MB() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *SERCOM_I2CM_Type) SetINTENSET_SB(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CM_Type) GetINTENSET_SB() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CM_Type) SetINTENSET_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CM_Type) GetINTENSET_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x80) >> 7
}

// SERCOM_I2CM.INTFLAG: I2CM Interrupt Flag Status and Clear
func (o *SERCOM_I2CM_Type) SetINTFLAG_MB(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetINTFLAG_MB() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *SERCOM_I2CM_Type) SetINTFLAG_SB(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CM_Type) GetINTFLAG_SB() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CM_Type) SetINTFLAG_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CM_Type) GetINTFLAG_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x80) >> 7
}

// SERCOM_I2CM.STATUS: I2CM Status
func (o *SERCOM_I2CM_Type) SetSTATUS_BUSERR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_BUSERR() uint16 {
	return volatile.LoadUint16(&o.STATUS.Reg) & 0x1
}
func (o *SERCOM_I2CM_Type) SetSTATUS_ARBLOST(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_ARBLOST() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CM_Type) SetSTATUS_RXNACK(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_RXNACK() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *SERCOM_I2CM_Type) SetSTATUS_BUSSTATE(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x30)|value<<4)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_BUSSTATE() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x30) >> 4
}
func (o *SERCOM_I2CM_Type) SetSTATUS_LOWTOUT(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_LOWTOUT() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x40) >> 6
}
func (o *SERCOM_I2CM_Type) SetSTATUS_CLKHOLD(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_CLKHOLD() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x80) >> 7
}
func (o *SERCOM_I2CM_Type) SetSTATUS_MEXTTOUT(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_MEXTTOUT() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x100) >> 8
}
func (o *SERCOM_I2CM_Type) SetSTATUS_SEXTTOUT(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_SEXTTOUT() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *SERCOM_I2CM_Type) SetSTATUS_LENERR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x400)|value<<10)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_LENERR() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x400) >> 10
}

// SERCOM_I2CM.SYNCBUSY: I2CM Synchronization Busy
func (o *SERCOM_I2CM_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *SERCOM_I2CM_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CM_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CM_Type) SetSYNCBUSY_SYSOP(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_I2CM_Type) GetSYNCBUSY_SYSOP() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}

// SERCOM_I2CM.ADDR: I2CM Address
func (o *SERCOM_I2CM_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x7ff)|value)
}
func (o *SERCOM_I2CM_Type) GetADDR() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg) & 0x7ff
}
func (o *SERCOM_I2CM_Type) SetADDR_LENEN(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x2000)|value<<13)
}
func (o *SERCOM_I2CM_Type) GetADDR_LENEN() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0x2000) >> 13
}
func (o *SERCOM_I2CM_Type) SetADDR_HS(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x4000)|value<<14)
}
func (o *SERCOM_I2CM_Type) GetADDR_HS() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0x4000) >> 14
}
func (o *SERCOM_I2CM_Type) SetADDR_TENBITEN(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x8000)|value<<15)
}
func (o *SERCOM_I2CM_Type) GetADDR_TENBITEN() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0x8000) >> 15
}
func (o *SERCOM_I2CM_Type) SetADDR_LEN(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xff0000)|value<<16)
}
func (o *SERCOM_I2CM_Type) GetADDR_LEN() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0xff0000) >> 16
}

// SERCOM_I2CM.DATA: I2CM Data
func (o *SERCOM_I2CM_Type) SetDATA(value uint8) {
	volatile.StoreUint8(&o.DATA.Reg, value)
}
func (o *SERCOM_I2CM_Type) GetDATA() uint8 {
	return volatile.LoadUint8(&o.DATA.Reg)
}

// SERCOM_I2CM.DBGCTRL: I2CM Debug Control
func (o *SERCOM_I2CM_Type) SetDBGCTRL_DBGSTOP(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetDBGCTRL_DBGSTOP() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// Serial Communication Interface 0 - I2CS
type SERCOM_I2CS_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	_        [12]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	_        [4]byte
	ADDR     volatile.Register32 // 0x24
	DATA     volatile.Register8  // 0x28
}

// SERCOM_I2CS.CTRLA: I2CS Control A
func (o *SERCOM_I2CS_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CS_Type) SetCTRLA_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1c)|value<<2)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x1c) >> 2
}
func (o *SERCOM_I2CS_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *SERCOM_I2CS_Type) SetCTRLA_PINOUT(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x10000)|value<<16)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_PINOUT() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x10000) >> 16
}
func (o *SERCOM_I2CS_Type) SetCTRLA_SDAHOLD(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x300000)|value<<20)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_SDAHOLD() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x300000) >> 20
}
func (o *SERCOM_I2CS_Type) SetCTRLA_SEXTTOEN(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x800000)|value<<23)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_SEXTTOEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x800000) >> 23
}
func (o *SERCOM_I2CS_Type) SetCTRLA_SPEED(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x3000000)|value<<24)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_SPEED() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x3000000) >> 24
}
func (o *SERCOM_I2CS_Type) SetCTRLA_SCLSM(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x8000000)|value<<27)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_SCLSM() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x8000000) >> 27
}
func (o *SERCOM_I2CS_Type) SetCTRLA_LOWTOUTEN(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40000000)|value<<30)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_LOWTOUTEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40000000) >> 30
}

// SERCOM_I2CS.CTRLB: I2CS Control B
func (o *SERCOM_I2CS_Type) SetCTRLB_SMEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x100)|value<<8)
}
func (o *SERCOM_I2CS_Type) GetCTRLB_SMEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x100) >> 8
}
func (o *SERCOM_I2CS_Type) SetCTRLB_GCMD(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_I2CS_Type) GetCTRLB_GCMD() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x200) >> 9
}
func (o *SERCOM_I2CS_Type) SetCTRLB_AACKEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x400)|value<<10)
}
func (o *SERCOM_I2CS_Type) GetCTRLB_AACKEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x400) >> 10
}
func (o *SERCOM_I2CS_Type) SetCTRLB_AMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0xc000)|value<<14)
}
func (o *SERCOM_I2CS_Type) GetCTRLB_AMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0xc000) >> 14
}
func (o *SERCOM_I2CS_Type) SetCTRLB_CMD(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x30000)|value<<16)
}
func (o *SERCOM_I2CS_Type) GetCTRLB_CMD() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x30000) >> 16
}
func (o *SERCOM_I2CS_Type) SetCTRLB_ACKACT(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x40000)|value<<18)
}
func (o *SERCOM_I2CS_Type) GetCTRLB_ACKACT() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x40000) >> 18
}

// SERCOM_I2CS.INTENCLR: I2CS Interrupt Enable Clear
func (o *SERCOM_I2CS_Type) SetINTENCLR_PREC(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetINTENCLR_PREC() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetINTENCLR_AMATCH(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetINTENCLR_AMATCH() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CS_Type) SetINTENCLR_DRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_I2CS_Type) GetINTENCLR_DRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *SERCOM_I2CS_Type) SetINTENCLR_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CS_Type) GetINTENCLR_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x80) >> 7
}

// SERCOM_I2CS.INTENSET: I2CS Interrupt Enable Set
func (o *SERCOM_I2CS_Type) SetINTENSET_PREC(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetINTENSET_PREC() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetINTENSET_AMATCH(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetINTENSET_AMATCH() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CS_Type) SetINTENSET_DRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_I2CS_Type) GetINTENSET_DRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *SERCOM_I2CS_Type) SetINTENSET_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CS_Type) GetINTENSET_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x80) >> 7
}

// SERCOM_I2CS.INTFLAG: I2CS Interrupt Flag Status and Clear
func (o *SERCOM_I2CS_Type) SetINTFLAG_PREC(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetINTFLAG_PREC() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetINTFLAG_AMATCH(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetINTFLAG_AMATCH() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CS_Type) SetINTFLAG_DRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_I2CS_Type) GetINTFLAG_DRDY() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *SERCOM_I2CS_Type) SetINTFLAG_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CS_Type) GetINTFLAG_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x80) >> 7
}

// SERCOM_I2CS.STATUS: I2CS Status
func (o *SERCOM_I2CS_Type) SetSTATUS_BUSERR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_BUSERR() uint16 {
	return volatile.LoadUint16(&o.STATUS.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetSTATUS_COLL(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_COLL() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CS_Type) SetSTATUS_RXNACK(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_RXNACK() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *SERCOM_I2CS_Type) SetSTATUS_DIR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_DIR() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *SERCOM_I2CS_Type) SetSTATUS_SR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_SR() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *SERCOM_I2CS_Type) SetSTATUS_LOWTOUT(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_LOWTOUT() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x40) >> 6
}
func (o *SERCOM_I2CS_Type) SetSTATUS_CLKHOLD(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_CLKHOLD() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x80) >> 7
}
func (o *SERCOM_I2CS_Type) SetSTATUS_SEXTTOUT(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_SEXTTOUT() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *SERCOM_I2CS_Type) SetSTATUS_HS(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x400)|value<<10)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_HS() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x400) >> 10
}

// SERCOM_I2CS.SYNCBUSY: I2CS Synchronization Busy
func (o *SERCOM_I2CS_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}

// SERCOM_I2CS.ADDR: I2CS Address
func (o *SERCOM_I2CS_Type) SetADDR_GENCEN(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetADDR_GENCEN() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x7fe)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetADDR() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0x7fe) >> 1
}
func (o *SERCOM_I2CS_Type) SetADDR_TENBITEN(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x8000)|value<<15)
}
func (o *SERCOM_I2CS_Type) GetADDR_TENBITEN() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0x8000) >> 15
}
func (o *SERCOM_I2CS_Type) SetADDR_ADDRMASK(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x7fe0000)|value<<17)
}
func (o *SERCOM_I2CS_Type) GetADDR_ADDRMASK() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0x7fe0000) >> 17
}

// SERCOM_I2CS.DATA: I2CS Data
func (o *SERCOM_I2CS_Type) SetDATA(value uint8) {
	volatile.StoreUint8(&o.DATA.Reg, value)
}
func (o *SERCOM_I2CS_Type) GetDATA() uint8 {
	return volatile.LoadUint8(&o.DATA.Reg)
}

// Serial Communication Interface 0 - SPI
type SERCOM_SPI_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	_        [4]byte
	BAUD     volatile.Register8 // 0xC
	_        [7]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	_        [4]byte
	ADDR     volatile.Register32 // 0x24
	DATA     volatile.Register32 // 0x28
	_        [4]byte
	DBGCTRL  volatile.Register8 // 0x30
}

// SERCOM_SPI.CTRLA: SPI Control A
func (o *SERCOM_SPI_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *SERCOM_SPI_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *SERCOM_SPI_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_SPI_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *SERCOM_SPI_Type) SetCTRLA_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1c)|value<<2)
}
func (o *SERCOM_SPI_Type) GetCTRLA_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x1c) >> 2
}
func (o *SERCOM_SPI_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_SPI_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *SERCOM_SPI_Type) SetCTRLA_IBON(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x100)|value<<8)
}
func (o *SERCOM_SPI_Type) GetCTRLA_IBON() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x100) >> 8
}
func (o *SERCOM_SPI_Type) SetCTRLA_DOPO(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x30000)|value<<16)
}
func (o *SERCOM_SPI_Type) GetCTRLA_DOPO() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x30000) >> 16
}
func (o *SERCOM_SPI_Type) SetCTRLA_DIPO(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x300000)|value<<20)
}
func (o *SERCOM_SPI_Type) GetCTRLA_DIPO() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x300000) >> 20
}
func (o *SERCOM_SPI_Type) SetCTRLA_FORM(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xf000000)|value<<24)
}
func (o *SERCOM_SPI_Type) GetCTRLA_FORM() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xf000000) >> 24
}
func (o *SERCOM_SPI_Type) SetCTRLA_CPHA(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x10000000)|value<<28)
}
func (o *SERCOM_SPI_Type) GetCTRLA_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x10000000) >> 28
}
func (o *SERCOM_SPI_Type) SetCTRLA_CPOL(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x20000000)|value<<29)
}
func (o *SERCOM_SPI_Type) GetCTRLA_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x20000000) >> 29
}
func (o *SERCOM_SPI_Type) SetCTRLA_DORD(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40000000)|value<<30)
}
func (o *SERCOM_SPI_Type) GetCTRLA_DORD() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40000000) >> 30
}

// SERCOM_SPI.CTRLB: SPI Control B
func (o *SERCOM_SPI_Type) SetCTRLB_CHSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x7)|value)
}
func (o *SERCOM_SPI_Type) GetCTRLB_CHSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLB.Reg) & 0x7
}
func (o *SERCOM_SPI_Type) SetCTRLB_PLOADEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x40)|value<<6)
}
func (o *SERCOM_SPI_Type) GetCTRLB_PLOADEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x40) >> 6
}
func (o *SERCOM_SPI_Type) SetCTRLB_SSDE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_SPI_Type) GetCTRLB_SSDE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x200) >> 9
}
func (o *SERCOM_SPI_Type) SetCTRLB_MSSEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x2000)|value<<13)
}
func (o *SERCOM_SPI_Type) GetCTRLB_MSSEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x2000) >> 13
}
func (o *SERCOM_SPI_Type) SetCTRLB_AMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0xc000)|value<<14)
}
func (o *SERCOM_SPI_Type) GetCTRLB_AMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0xc000) >> 14
}
func (o *SERCOM_SPI_Type) SetCTRLB_RXEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x20000)|value<<17)
}
func (o *SERCOM_SPI_Type) GetCTRLB_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x20000) >> 17
}

// SERCOM_SPI.BAUD: SPI Baud Rate
func (o *SERCOM_SPI_Type) SetBAUD(value uint8) {
	volatile.StoreUint8(&o.BAUD.Reg, value)
}
func (o *SERCOM_SPI_Type) GetBAUD() uint8 {
	return volatile.LoadUint8(&o.BAUD.Reg)
}

// SERCOM_SPI.INTENCLR: SPI Interrupt Enable Clear
func (o *SERCOM_SPI_Type) SetINTENCLR_DRE(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SERCOM_SPI_Type) GetINTENCLR_DRE() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *SERCOM_SPI_Type) SetINTENCLR_TXC(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_SPI_Type) GetINTENCLR_TXC() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SERCOM_SPI_Type) SetINTENCLR_RXC(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_SPI_Type) GetINTENCLR_RXC() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *SERCOM_SPI_Type) SetINTENCLR_SSL(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_SPI_Type) GetINTENCLR_SSL() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *SERCOM_SPI_Type) SetINTENCLR_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_SPI_Type) GetINTENCLR_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x80) >> 7
}

// SERCOM_SPI.INTENSET: SPI Interrupt Enable Set
func (o *SERCOM_SPI_Type) SetINTENSET_DRE(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SERCOM_SPI_Type) GetINTENSET_DRE() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *SERCOM_SPI_Type) SetINTENSET_TXC(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_SPI_Type) GetINTENSET_TXC() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SERCOM_SPI_Type) SetINTENSET_RXC(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_SPI_Type) GetINTENSET_RXC() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *SERCOM_SPI_Type) SetINTENSET_SSL(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_SPI_Type) GetINTENSET_SSL() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *SERCOM_SPI_Type) SetINTENSET_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_SPI_Type) GetINTENSET_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x80) >> 7
}

// SERCOM_SPI.INTFLAG: SPI Interrupt Flag Status and Clear
func (o *SERCOM_SPI_Type) SetINTFLAG_DRE(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *SERCOM_SPI_Type) GetINTFLAG_DRE() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *SERCOM_SPI_Type) SetINTFLAG_TXC(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_SPI_Type) GetINTFLAG_TXC() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *SERCOM_SPI_Type) SetINTFLAG_RXC(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_SPI_Type) GetINTFLAG_RXC() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *SERCOM_SPI_Type) SetINTFLAG_SSL(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_SPI_Type) GetINTFLAG_SSL() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *SERCOM_SPI_Type) SetINTFLAG_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_SPI_Type) GetINTFLAG_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x80) >> 7
}

// SERCOM_SPI.STATUS: SPI Status
func (o *SERCOM_SPI_Type) SetSTATUS_BUFOVF(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_SPI_Type) GetSTATUS_BUFOVF() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x4) >> 2
}

// SERCOM_SPI.SYNCBUSY: SPI Synchronization Busy
func (o *SERCOM_SPI_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *SERCOM_SPI_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *SERCOM_SPI_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_SPI_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *SERCOM_SPI_Type) SetSYNCBUSY_CTRLB(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_SPI_Type) GetSYNCBUSY_CTRLB() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}

// SERCOM_SPI.ADDR: SPI Address
func (o *SERCOM_SPI_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xff)|value)
}
func (o *SERCOM_SPI_Type) GetADDR() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg) & 0xff
}
func (o *SERCOM_SPI_Type) SetADDR_ADDRMASK(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xff0000)|value<<16)
}
func (o *SERCOM_SPI_Type) GetADDR_ADDRMASK() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0xff0000) >> 16
}

// SERCOM_SPI.DATA: SPI Data
func (o *SERCOM_SPI_Type) SetDATA(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x1ff)|value)
}
func (o *SERCOM_SPI_Type) GetDATA() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg) & 0x1ff
}

// SERCOM_SPI.DBGCTRL: SPI Debug Control
func (o *SERCOM_SPI_Type) SetDBGCTRL_DBGSTOP(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *SERCOM_SPI_Type) GetDBGCTRL_DBGSTOP() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// Serial Communication Interface 0 - USART
type SERCOM_USART_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	_        [4]byte
	BAUD     volatile.Register16 // 0xC
	RXPL     volatile.Register8  // 0xE
	_        [5]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	_        [8]byte
	DATA     volatile.Register16 // 0x28
	_        [6]byte
	DBGCTRL  volatile.Register8 // 0x30
}

// SERCOM_USART.CTRLA: USART Control A
func (o *SERCOM_USART_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *SERCOM_USART_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_USART_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *SERCOM_USART_Type) SetCTRLA_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1c)|value<<2)
}
func (o *SERCOM_USART_Type) GetCTRLA_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x1c) >> 2
}
func (o *SERCOM_USART_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_USART_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *SERCOM_USART_Type) SetCTRLA_IBON(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x100)|value<<8)
}
func (o *SERCOM_USART_Type) GetCTRLA_IBON() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x100) >> 8
}
func (o *SERCOM_USART_Type) SetCTRLA_SAMPR(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xe000)|value<<13)
}
func (o *SERCOM_USART_Type) GetCTRLA_SAMPR() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xe000) >> 13
}
func (o *SERCOM_USART_Type) SetCTRLA_TXPO(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x30000)|value<<16)
}
func (o *SERCOM_USART_Type) GetCTRLA_TXPO() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x30000) >> 16
}
func (o *SERCOM_USART_Type) SetCTRLA_RXPO(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x300000)|value<<20)
}
func (o *SERCOM_USART_Type) GetCTRLA_RXPO() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x300000) >> 20
}
func (o *SERCOM_USART_Type) SetCTRLA_SAMPA(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xc00000)|value<<22)
}
func (o *SERCOM_USART_Type) GetCTRLA_SAMPA() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xc00000) >> 22
}
func (o *SERCOM_USART_Type) SetCTRLA_FORM(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xf000000)|value<<24)
}
func (o *SERCOM_USART_Type) GetCTRLA_FORM() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xf000000) >> 24
}
func (o *SERCOM_USART_Type) SetCTRLA_CMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x10000000)|value<<28)
}
func (o *SERCOM_USART_Type) GetCTRLA_CMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x10000000) >> 28
}
func (o *SERCOM_USART_Type) SetCTRLA_CPOL(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x20000000)|value<<29)
}
func (o *SERCOM_USART_Type) GetCTRLA_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x20000000) >> 29
}
func (o *SERCOM_USART_Type) SetCTRLA_DORD(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40000000)|value<<30)
}
func (o *SERCOM_USART_Type) GetCTRLA_DORD() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40000000) >> 30
}

// SERCOM_USART.CTRLB: USART Control B
func (o *SERCOM_USART_Type) SetCTRLB_CHSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x7)|value)
}
func (o *SERCOM_USART_Type) GetCTRLB_CHSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLB.Reg) & 0x7
}
func (o *SERCOM_USART_Type) SetCTRLB_SBMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x40)|value<<6)
}
func (o *SERCOM_USART_Type) GetCTRLB_SBMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x40) >> 6
}
func (o *SERCOM_USART_Type) SetCTRLB_COLDEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x100)|value<<8)
}
func (o *SERCOM_USART_Type) GetCTRLB_COLDEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x100) >> 8
}
func (o *SERCOM_USART_Type) SetCTRLB_SFDE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_USART_Type) GetCTRLB_SFDE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x200) >> 9
}
func (o *SERCOM_USART_Type) SetCTRLB_ENC(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x400)|value<<10)
}
func (o *SERCOM_USART_Type) GetCTRLB_ENC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x400) >> 10
}
func (o *SERCOM_USART_Type) SetCTRLB_PMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x2000)|value<<13)
}
func (o *SERCOM_USART_Type) GetCTRLB_PMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x2000) >> 13
}
func (o *SERCOM_USART_Type) SetCTRLB_TXEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x10000)|value<<16)
}
func (o *SERCOM_USART_Type) GetCTRLB_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x10000) >> 16
}
func (o *SERCOM_USART_Type) SetCTRLB_RXEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x20000)|value<<17)
}
func (o *SERCOM_USART_Type) GetCTRLB_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x20000) >> 17
}

// SERCOM_USART.BAUD: USART Baud Rate
func (o *SERCOM_USART_Type) SetBAUD(value uint16) {
	volatile.StoreUint16(&o.BAUD.Reg, value)
}
func (o *SERCOM_USART_Type) GetBAUD() uint16 {
	return volatile.LoadUint16(&o.BAUD.Reg)
}

// SERCOM_USART.RXPL: USART Receive Pulse Length
func (o *SERCOM_USART_Type) SetRXPL(value uint8) {
	volatile.StoreUint8(&o.RXPL.Reg, value)
}
func (o *SERCOM_USART_Type) GetRXPL() uint8 {
	return volatile.LoadUint8(&o.RXPL.Reg)
}

// SERCOM_USART.INTENCLR: USART Interrupt Enable Clear
func (o *SERCOM_USART_Type) SetINTENCLR_DRE(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetINTENCLR_DRE() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *SERCOM_USART_Type) SetINTENCLR_TXC(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_USART_Type) GetINTENCLR_TXC() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SERCOM_USART_Type) SetINTENCLR_RXC(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_USART_Type) GetINTENCLR_RXC() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *SERCOM_USART_Type) SetINTENCLR_RXS(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_USART_Type) GetINTENCLR_RXS() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *SERCOM_USART_Type) SetINTENCLR_CTSIC(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SERCOM_USART_Type) GetINTENCLR_CTSIC() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SERCOM_USART_Type) SetINTENCLR_RXBRK(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *SERCOM_USART_Type) GetINTENCLR_RXBRK() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *SERCOM_USART_Type) SetINTENCLR_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_USART_Type) GetINTENCLR_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x80) >> 7
}

// SERCOM_USART.INTENSET: USART Interrupt Enable Set
func (o *SERCOM_USART_Type) SetINTENSET_DRE(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetINTENSET_DRE() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *SERCOM_USART_Type) SetINTENSET_TXC(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_USART_Type) GetINTENSET_TXC() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SERCOM_USART_Type) SetINTENSET_RXC(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_USART_Type) GetINTENSET_RXC() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *SERCOM_USART_Type) SetINTENSET_RXS(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_USART_Type) GetINTENSET_RXS() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *SERCOM_USART_Type) SetINTENSET_CTSIC(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SERCOM_USART_Type) GetINTENSET_CTSIC() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SERCOM_USART_Type) SetINTENSET_RXBRK(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *SERCOM_USART_Type) GetINTENSET_RXBRK() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *SERCOM_USART_Type) SetINTENSET_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_USART_Type) GetINTENSET_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x80) >> 7
}

// SERCOM_USART.INTFLAG: USART Interrupt Flag Status and Clear
func (o *SERCOM_USART_Type) SetINTFLAG_DRE(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetINTFLAG_DRE() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *SERCOM_USART_Type) SetINTFLAG_TXC(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_USART_Type) GetINTFLAG_TXC() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *SERCOM_USART_Type) SetINTFLAG_RXC(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_USART_Type) GetINTFLAG_RXC() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *SERCOM_USART_Type) SetINTFLAG_RXS(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_USART_Type) GetINTFLAG_RXS() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *SERCOM_USART_Type) SetINTFLAG_CTSIC(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *SERCOM_USART_Type) GetINTFLAG_CTSIC() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *SERCOM_USART_Type) SetINTFLAG_RXBRK(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *SERCOM_USART_Type) GetINTFLAG_RXBRK() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *SERCOM_USART_Type) SetINTFLAG_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_USART_Type) GetINTFLAG_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x80) >> 7
}

// SERCOM_USART.STATUS: USART Status
func (o *SERCOM_USART_Type) SetSTATUS_PERR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetSTATUS_PERR() uint16 {
	return volatile.LoadUint16(&o.STATUS.Reg) & 0x1
}
func (o *SERCOM_USART_Type) SetSTATUS_FERR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_USART_Type) GetSTATUS_FERR() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *SERCOM_USART_Type) SetSTATUS_BUFOVF(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_USART_Type) GetSTATUS_BUFOVF() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *SERCOM_USART_Type) SetSTATUS_CTS(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_USART_Type) GetSTATUS_CTS() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *SERCOM_USART_Type) SetSTATUS_ISF(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *SERCOM_USART_Type) GetSTATUS_ISF() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *SERCOM_USART_Type) SetSTATUS_COLL(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *SERCOM_USART_Type) GetSTATUS_COLL() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x20) >> 5
}

// SERCOM_USART.SYNCBUSY: USART Synchronization Busy
func (o *SERCOM_USART_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *SERCOM_USART_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_USART_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *SERCOM_USART_Type) SetSYNCBUSY_CTRLB(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_USART_Type) GetSYNCBUSY_CTRLB() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}

// SERCOM_USART.DATA: USART Data
func (o *SERCOM_USART_Type) SetDATA(value uint16) {
	volatile.StoreUint16(&o.DATA.Reg, volatile.LoadUint16(&o.DATA.Reg)&^(0x1ff)|value)
}
func (o *SERCOM_USART_Type) GetDATA() uint16 {
	return volatile.LoadUint16(&o.DATA.Reg) & 0x1ff
}

// SERCOM_USART.DBGCTRL: USART Debug Control
func (o *SERCOM_USART_Type) SetDBGCTRL_DBGSTOP(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetDBGCTRL_DBGSTOP() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// System Control
type SYSCTRL_Type struct {
	INTENCLR   volatile.Register32 // 0x0
	INTENSET   volatile.Register32 // 0x4
	INTFLAG    volatile.Register32 // 0x8
	PCLKSR     volatile.Register32 // 0xC
	XOSC       volatile.Register16 // 0x10
	_          [2]byte
	XOSC32K    volatile.Register16 // 0x14
	_          [2]byte
	OSC32K     volatile.Register32 // 0x18
	OSCULP32K  volatile.Register8  // 0x1C
	_          [3]byte
	OSC8M      volatile.Register32 // 0x20
	DFLLCTRL   volatile.Register16 // 0x24
	_          [2]byte
	DFLLVAL    volatile.Register32 // 0x28
	DFLLMUL    volatile.Register32 // 0x2C
	DFLLSYNC   volatile.Register8  // 0x30
	_          [3]byte
	BOD33      volatile.Register32 // 0x34
	_          [4]byte
	VREG       volatile.Register16 // 0x3C
	_          [2]byte
	VREF       volatile.Register32 // 0x40
	DPLLCTRLA  volatile.Register8  // 0x44
	_          [3]byte
	DPLLRATIO  volatile.Register32 // 0x48
	DPLLCTRLB  volatile.Register32 // 0x4C
	DPLLSTATUS volatile.Register8  // 0x50
}

// SYSCTRL.INTENCLR: Interrupt Enable Clear
func (o *SYSCTRL_Type) SetINTENCLR_XOSCRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SYSCTRL_Type) GetINTENCLR_XOSCRDY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *SYSCTRL_Type) SetINTENCLR_XOSC32KRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTRL_Type) GetINTENCLR_XOSC32KRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SYSCTRL_Type) SetINTENCLR_OSC32KRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTRL_Type) GetINTENCLR_OSC32KRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *SYSCTRL_Type) SetINTENCLR_OSC8MRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *SYSCTRL_Type) GetINTENCLR_OSC8MRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *SYSCTRL_Type) SetINTENCLR_DFLLRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SYSCTRL_Type) GetINTENCLR_DFLLRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SYSCTRL_Type) SetINTENCLR_DFLLOOB(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *SYSCTRL_Type) GetINTENCLR_DFLLOOB() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *SYSCTRL_Type) SetINTENCLR_DFLLLCKF(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *SYSCTRL_Type) GetINTENCLR_DFLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *SYSCTRL_Type) SetINTENCLR_DFLLLCKC(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *SYSCTRL_Type) GetINTENCLR_DFLLLCKC() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *SYSCTRL_Type) SetINTENCLR_DFLLRCS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *SYSCTRL_Type) GetINTENCLR_DFLLRCS() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *SYSCTRL_Type) SetINTENCLR_BOD33RDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *SYSCTRL_Type) GetINTENCLR_BOD33RDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *SYSCTRL_Type) SetINTENCLR_BOD33DET(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *SYSCTRL_Type) GetINTENCLR_BOD33DET() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *SYSCTRL_Type) SetINTENCLR_B33SRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *SYSCTRL_Type) GetINTENCLR_B33SRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *SYSCTRL_Type) SetINTENCLR_DPLLLCKR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCTRL_Type) GetINTENCLR_DPLLLCKR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}
func (o *SYSCTRL_Type) SetINTENCLR_DPLLLCKF(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCTRL_Type) GetINTENCLR_DPLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *SYSCTRL_Type) SetINTENCLR_DPLLLTO(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCTRL_Type) GetINTENCLR_DPLLLTO() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}

// SYSCTRL.INTENSET: Interrupt Enable Set
func (o *SYSCTRL_Type) SetINTENSET_XOSCRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SYSCTRL_Type) GetINTENSET_XOSCRDY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *SYSCTRL_Type) SetINTENSET_XOSC32KRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTRL_Type) GetINTENSET_XOSC32KRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SYSCTRL_Type) SetINTENSET_OSC32KRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTRL_Type) GetINTENSET_OSC32KRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *SYSCTRL_Type) SetINTENSET_OSC8MRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *SYSCTRL_Type) GetINTENSET_OSC8MRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *SYSCTRL_Type) SetINTENSET_DFLLRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SYSCTRL_Type) GetINTENSET_DFLLRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SYSCTRL_Type) SetINTENSET_DFLLOOB(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *SYSCTRL_Type) GetINTENSET_DFLLOOB() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *SYSCTRL_Type) SetINTENSET_DFLLLCKF(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *SYSCTRL_Type) GetINTENSET_DFLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *SYSCTRL_Type) SetINTENSET_DFLLLCKC(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *SYSCTRL_Type) GetINTENSET_DFLLLCKC() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *SYSCTRL_Type) SetINTENSET_DFLLRCS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *SYSCTRL_Type) GetINTENSET_DFLLRCS() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *SYSCTRL_Type) SetINTENSET_BOD33RDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *SYSCTRL_Type) GetINTENSET_BOD33RDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *SYSCTRL_Type) SetINTENSET_BOD33DET(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *SYSCTRL_Type) GetINTENSET_BOD33DET() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *SYSCTRL_Type) SetINTENSET_B33SRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *SYSCTRL_Type) GetINTENSET_B33SRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *SYSCTRL_Type) SetINTENSET_DPLLLCKR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCTRL_Type) GetINTENSET_DPLLLCKR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}
func (o *SYSCTRL_Type) SetINTENSET_DPLLLCKF(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCTRL_Type) GetINTENSET_DPLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *SYSCTRL_Type) SetINTENSET_DPLLLTO(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCTRL_Type) GetINTENSET_DPLLLTO() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}

// SYSCTRL.INTFLAG: Interrupt Flag Status and Clear
func (o *SYSCTRL_Type) SetINTFLAG_XOSCRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *SYSCTRL_Type) GetINTFLAG_XOSCRDY() uint32 {
	return volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1
}
func (o *SYSCTRL_Type) SetINTFLAG_XOSC32KRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTRL_Type) GetINTFLAG_XOSC32KRDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *SYSCTRL_Type) SetINTFLAG_OSC32KRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTRL_Type) GetINTFLAG_OSC32KRDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *SYSCTRL_Type) SetINTFLAG_OSC8MRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *SYSCTRL_Type) GetINTFLAG_OSC8MRDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *SYSCTRL_Type) SetINTFLAG_DFLLRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *SYSCTRL_Type) GetINTFLAG_DFLLRDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *SYSCTRL_Type) SetINTFLAG_DFLLOOB(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *SYSCTRL_Type) GetINTFLAG_DFLLOOB() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *SYSCTRL_Type) SetINTFLAG_DFLLLCKF(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x40)|value<<6)
}
func (o *SYSCTRL_Type) GetINTFLAG_DFLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x40) >> 6
}
func (o *SYSCTRL_Type) SetINTFLAG_DFLLLCKC(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *SYSCTRL_Type) GetINTFLAG_DFLLLCKC() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x80) >> 7
}
func (o *SYSCTRL_Type) SetINTFLAG_DFLLRCS(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x100)|value<<8)
}
func (o *SYSCTRL_Type) GetINTFLAG_DFLLRCS() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x100) >> 8
}
func (o *SYSCTRL_Type) SetINTFLAG_BOD33RDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x200)|value<<9)
}
func (o *SYSCTRL_Type) GetINTFLAG_BOD33RDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x200) >> 9
}
func (o *SYSCTRL_Type) SetINTFLAG_BOD33DET(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x400)|value<<10)
}
func (o *SYSCTRL_Type) GetINTFLAG_BOD33DET() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x400) >> 10
}
func (o *SYSCTRL_Type) SetINTFLAG_B33SRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x800)|value<<11)
}
func (o *SYSCTRL_Type) GetINTFLAG_B33SRDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x800) >> 11
}
func (o *SYSCTRL_Type) SetINTFLAG_DPLLLCKR(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCTRL_Type) GetINTFLAG_DPLLLCKR() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x8000) >> 15
}
func (o *SYSCTRL_Type) SetINTFLAG_DPLLLCKF(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCTRL_Type) GetINTFLAG_DPLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x10000) >> 16
}
func (o *SYSCTRL_Type) SetINTFLAG_DPLLLTO(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCTRL_Type) GetINTFLAG_DPLLLTO() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x20000) >> 17
}

// SYSCTRL.PCLKSR: Power and Clocks Status
func (o *SYSCTRL_Type) SetPCLKSR_XOSCRDY(value uint32) {
	volatile.StoreUint32(&o.PCLKSR.Reg, volatile.LoadUint32(&o.PCLKSR.Reg)&^(0x1)|value)
}
func (o *SYSCTRL_Type) GetPCLKSR_XOSCRDY() uint32 {
	return volatile.LoadUint32(&o.PCLKSR.Reg) & 0x1
}
func (o *SYSCTRL_Type) SetPCLKSR_XOSC32KRDY(value uint32) {
	volatile.StoreUint32(&o.PCLKSR.Reg, volatile.LoadUint32(&o.PCLKSR.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTRL_Type) GetPCLKSR_XOSC32KRDY() uint32 {
	return (volatile.LoadUint32(&o.PCLKSR.Reg) & 0x2) >> 1
}
func (o *SYSCTRL_Type) SetPCLKSR_OSC32KRDY(value uint32) {
	volatile.StoreUint32(&o.PCLKSR.Reg, volatile.LoadUint32(&o.PCLKSR.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTRL_Type) GetPCLKSR_OSC32KRDY() uint32 {
	return (volatile.LoadUint32(&o.PCLKSR.Reg) & 0x4) >> 2
}
func (o *SYSCTRL_Type) SetPCLKSR_OSC8MRDY(value uint32) {
	volatile.StoreUint32(&o.PCLKSR.Reg, volatile.LoadUint32(&o.PCLKSR.Reg)&^(0x8)|value<<3)
}
func (o *SYSCTRL_Type) GetPCLKSR_OSC8MRDY() uint32 {
	return (volatile.LoadUint32(&o.PCLKSR.Reg) & 0x8) >> 3
}
func (o *SYSCTRL_Type) SetPCLKSR_DFLLRDY(value uint32) {
	volatile.StoreUint32(&o.PCLKSR.Reg, volatile.LoadUint32(&o.PCLKSR.Reg)&^(0x10)|value<<4)
}
func (o *SYSCTRL_Type) GetPCLKSR_DFLLRDY() uint32 {
	return (volatile.LoadUint32(&o.PCLKSR.Reg) & 0x10) >> 4
}
func (o *SYSCTRL_Type) SetPCLKSR_DFLLOOB(value uint32) {
	volatile.StoreUint32(&o.PCLKSR.Reg, volatile.LoadUint32(&o.PCLKSR.Reg)&^(0x20)|value<<5)
}
func (o *SYSCTRL_Type) GetPCLKSR_DFLLOOB() uint32 {
	return (volatile.LoadUint32(&o.PCLKSR.Reg) & 0x20) >> 5
}
func (o *SYSCTRL_Type) SetPCLKSR_DFLLLCKF(value uint32) {
	volatile.StoreUint32(&o.PCLKSR.Reg, volatile.LoadUint32(&o.PCLKSR.Reg)&^(0x40)|value<<6)
}
func (o *SYSCTRL_Type) GetPCLKSR_DFLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.PCLKSR.Reg) & 0x40) >> 6
}
func (o *SYSCTRL_Type) SetPCLKSR_DFLLLCKC(value uint32) {
	volatile.StoreUint32(&o.PCLKSR.Reg, volatile.LoadUint32(&o.PCLKSR.Reg)&^(0x80)|value<<7)
}
func (o *SYSCTRL_Type) GetPCLKSR_DFLLLCKC() uint32 {
	return (volatile.LoadUint32(&o.PCLKSR.Reg) & 0x80) >> 7
}
func (o *SYSCTRL_Type) SetPCLKSR_DFLLRCS(value uint32) {
	volatile.StoreUint32(&o.PCLKSR.Reg, volatile.LoadUint32(&o.PCLKSR.Reg)&^(0x100)|value<<8)
}
func (o *SYSCTRL_Type) GetPCLKSR_DFLLRCS() uint32 {
	return (volatile.LoadUint32(&o.PCLKSR.Reg) & 0x100) >> 8
}
func (o *SYSCTRL_Type) SetPCLKSR_BOD33RDY(value uint32) {
	volatile.StoreUint32(&o.PCLKSR.Reg, volatile.LoadUint32(&o.PCLKSR.Reg)&^(0x200)|value<<9)
}
func (o *SYSCTRL_Type) GetPCLKSR_BOD33RDY() uint32 {
	return (volatile.LoadUint32(&o.PCLKSR.Reg) & 0x200) >> 9
}
func (o *SYSCTRL_Type) SetPCLKSR_BOD33DET(value uint32) {
	volatile.StoreUint32(&o.PCLKSR.Reg, volatile.LoadUint32(&o.PCLKSR.Reg)&^(0x400)|value<<10)
}
func (o *SYSCTRL_Type) GetPCLKSR_BOD33DET() uint32 {
	return (volatile.LoadUint32(&o.PCLKSR.Reg) & 0x400) >> 10
}
func (o *SYSCTRL_Type) SetPCLKSR_B33SRDY(value uint32) {
	volatile.StoreUint32(&o.PCLKSR.Reg, volatile.LoadUint32(&o.PCLKSR.Reg)&^(0x800)|value<<11)
}
func (o *SYSCTRL_Type) GetPCLKSR_B33SRDY() uint32 {
	return (volatile.LoadUint32(&o.PCLKSR.Reg) & 0x800) >> 11
}
func (o *SYSCTRL_Type) SetPCLKSR_DPLLLCKR(value uint32) {
	volatile.StoreUint32(&o.PCLKSR.Reg, volatile.LoadUint32(&o.PCLKSR.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCTRL_Type) GetPCLKSR_DPLLLCKR() uint32 {
	return (volatile.LoadUint32(&o.PCLKSR.Reg) & 0x8000) >> 15
}
func (o *SYSCTRL_Type) SetPCLKSR_DPLLLCKF(value uint32) {
	volatile.StoreUint32(&o.PCLKSR.Reg, volatile.LoadUint32(&o.PCLKSR.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCTRL_Type) GetPCLKSR_DPLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.PCLKSR.Reg) & 0x10000) >> 16
}
func (o *SYSCTRL_Type) SetPCLKSR_DPLLLTO(value uint32) {
	volatile.StoreUint32(&o.PCLKSR.Reg, volatile.LoadUint32(&o.PCLKSR.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCTRL_Type) GetPCLKSR_DPLLLTO() uint32 {
	return (volatile.LoadUint32(&o.PCLKSR.Reg) & 0x20000) >> 17
}

// SYSCTRL.XOSC: External Multipurpose Crystal Oscillator (XOSC) Control
func (o *SYSCTRL_Type) SetXOSC_ENABLE(value uint16) {
	volatile.StoreUint16(&o.XOSC.Reg, volatile.LoadUint16(&o.XOSC.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTRL_Type) GetXOSC_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.XOSC.Reg) & 0x2) >> 1
}
func (o *SYSCTRL_Type) SetXOSC_XTALEN(value uint16) {
	volatile.StoreUint16(&o.XOSC.Reg, volatile.LoadUint16(&o.XOSC.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTRL_Type) GetXOSC_XTALEN() uint16 {
	return (volatile.LoadUint16(&o.XOSC.Reg) & 0x4) >> 2
}
func (o *SYSCTRL_Type) SetXOSC_RUNSTDBY(value uint16) {
	volatile.StoreUint16(&o.XOSC.Reg, volatile.LoadUint16(&o.XOSC.Reg)&^(0x40)|value<<6)
}
func (o *SYSCTRL_Type) GetXOSC_RUNSTDBY() uint16 {
	return (volatile.LoadUint16(&o.XOSC.Reg) & 0x40) >> 6
}
func (o *SYSCTRL_Type) SetXOSC_ONDEMAND(value uint16) {
	volatile.StoreUint16(&o.XOSC.Reg, volatile.LoadUint16(&o.XOSC.Reg)&^(0x80)|value<<7)
}
func (o *SYSCTRL_Type) GetXOSC_ONDEMAND() uint16 {
	return (volatile.LoadUint16(&o.XOSC.Reg) & 0x80) >> 7
}
func (o *SYSCTRL_Type) SetXOSC_GAIN(value uint16) {
	volatile.StoreUint16(&o.XOSC.Reg, volatile.LoadUint16(&o.XOSC.Reg)&^(0x700)|value<<8)
}
func (o *SYSCTRL_Type) GetXOSC_GAIN() uint16 {
	return (volatile.LoadUint16(&o.XOSC.Reg) & 0x700) >> 8
}
func (o *SYSCTRL_Type) SetXOSC_AMPGC(value uint16) {
	volatile.StoreUint16(&o.XOSC.Reg, volatile.LoadUint16(&o.XOSC.Reg)&^(0x800)|value<<11)
}
func (o *SYSCTRL_Type) GetXOSC_AMPGC() uint16 {
	return (volatile.LoadUint16(&o.XOSC.Reg) & 0x800) >> 11
}
func (o *SYSCTRL_Type) SetXOSC_STARTUP(value uint16) {
	volatile.StoreUint16(&o.XOSC.Reg, volatile.LoadUint16(&o.XOSC.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCTRL_Type) GetXOSC_STARTUP() uint16 {
	return (volatile.LoadUint16(&o.XOSC.Reg) & 0xf000) >> 12
}

// SYSCTRL.XOSC32K: 32kHz External Crystal Oscillator (XOSC32K) Control
func (o *SYSCTRL_Type) SetXOSC32K_ENABLE(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTRL_Type) GetXOSC32K_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x2) >> 1
}
func (o *SYSCTRL_Type) SetXOSC32K_XTALEN(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTRL_Type) GetXOSC32K_XTALEN() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x4) >> 2
}
func (o *SYSCTRL_Type) SetXOSC32K_EN32K(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x8)|value<<3)
}
func (o *SYSCTRL_Type) GetXOSC32K_EN32K() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x8) >> 3
}
func (o *SYSCTRL_Type) SetXOSC32K_EN1K(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x10)|value<<4)
}
func (o *SYSCTRL_Type) GetXOSC32K_EN1K() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x10) >> 4
}
func (o *SYSCTRL_Type) SetXOSC32K_AAMPEN(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x20)|value<<5)
}
func (o *SYSCTRL_Type) GetXOSC32K_AAMPEN() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x20) >> 5
}
func (o *SYSCTRL_Type) SetXOSC32K_RUNSTDBY(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x40)|value<<6)
}
func (o *SYSCTRL_Type) GetXOSC32K_RUNSTDBY() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x40) >> 6
}
func (o *SYSCTRL_Type) SetXOSC32K_ONDEMAND(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x80)|value<<7)
}
func (o *SYSCTRL_Type) GetXOSC32K_ONDEMAND() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x80) >> 7
}
func (o *SYSCTRL_Type) SetXOSC32K_STARTUP(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x700)|value<<8)
}
func (o *SYSCTRL_Type) GetXOSC32K_STARTUP() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x700) >> 8
}
func (o *SYSCTRL_Type) SetXOSC32K_WRTLOCK(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCTRL_Type) GetXOSC32K_WRTLOCK() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x1000) >> 12
}

// SYSCTRL.OSC32K: 32kHz Internal Oscillator (OSC32K) Control
func (o *SYSCTRL_Type) SetOSC32K_ENABLE(value uint32) {
	volatile.StoreUint32(&o.OSC32K.Reg, volatile.LoadUint32(&o.OSC32K.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTRL_Type) GetOSC32K_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.OSC32K.Reg) & 0x2) >> 1
}
func (o *SYSCTRL_Type) SetOSC32K_EN32K(value uint32) {
	volatile.StoreUint32(&o.OSC32K.Reg, volatile.LoadUint32(&o.OSC32K.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTRL_Type) GetOSC32K_EN32K() uint32 {
	return (volatile.LoadUint32(&o.OSC32K.Reg) & 0x4) >> 2
}
func (o *SYSCTRL_Type) SetOSC32K_EN1K(value uint32) {
	volatile.StoreUint32(&o.OSC32K.Reg, volatile.LoadUint32(&o.OSC32K.Reg)&^(0x8)|value<<3)
}
func (o *SYSCTRL_Type) GetOSC32K_EN1K() uint32 {
	return (volatile.LoadUint32(&o.OSC32K.Reg) & 0x8) >> 3
}
func (o *SYSCTRL_Type) SetOSC32K_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.OSC32K.Reg, volatile.LoadUint32(&o.OSC32K.Reg)&^(0x40)|value<<6)
}
func (o *SYSCTRL_Type) GetOSC32K_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.OSC32K.Reg) & 0x40) >> 6
}
func (o *SYSCTRL_Type) SetOSC32K_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.OSC32K.Reg, volatile.LoadUint32(&o.OSC32K.Reg)&^(0x80)|value<<7)
}
func (o *SYSCTRL_Type) GetOSC32K_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.OSC32K.Reg) & 0x80) >> 7
}
func (o *SYSCTRL_Type) SetOSC32K_STARTUP(value uint32) {
	volatile.StoreUint32(&o.OSC32K.Reg, volatile.LoadUint32(&o.OSC32K.Reg)&^(0x700)|value<<8)
}
func (o *SYSCTRL_Type) GetOSC32K_STARTUP() uint32 {
	return (volatile.LoadUint32(&o.OSC32K.Reg) & 0x700) >> 8
}
func (o *SYSCTRL_Type) SetOSC32K_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.OSC32K.Reg, volatile.LoadUint32(&o.OSC32K.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCTRL_Type) GetOSC32K_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.OSC32K.Reg) & 0x1000) >> 12
}
func (o *SYSCTRL_Type) SetOSC32K_CALIB(value uint32) {
	volatile.StoreUint32(&o.OSC32K.Reg, volatile.LoadUint32(&o.OSC32K.Reg)&^(0x7f0000)|value<<16)
}
func (o *SYSCTRL_Type) GetOSC32K_CALIB() uint32 {
	return (volatile.LoadUint32(&o.OSC32K.Reg) & 0x7f0000) >> 16
}

// SYSCTRL.OSCULP32K: 32kHz Ultra Low Power Internal Oscillator (OSCULP32K) Control
func (o *SYSCTRL_Type) SetOSCULP32K_CALIB(value uint8) {
	volatile.StoreUint8(&o.OSCULP32K.Reg, volatile.LoadUint8(&o.OSCULP32K.Reg)&^(0x1f)|value)
}
func (o *SYSCTRL_Type) GetOSCULP32K_CALIB() uint8 {
	return volatile.LoadUint8(&o.OSCULP32K.Reg) & 0x1f
}
func (o *SYSCTRL_Type) SetOSCULP32K_WRTLOCK(value uint8) {
	volatile.StoreUint8(&o.OSCULP32K.Reg, volatile.LoadUint8(&o.OSCULP32K.Reg)&^(0x80)|value<<7)
}
func (o *SYSCTRL_Type) GetOSCULP32K_WRTLOCK() uint8 {
	return (volatile.LoadUint8(&o.OSCULP32K.Reg) & 0x80) >> 7
}

// SYSCTRL.OSC8M: 8MHz Internal Oscillator (OSC8M) Control
func (o *SYSCTRL_Type) SetOSC8M_ENABLE(value uint32) {
	volatile.StoreUint32(&o.OSC8M.Reg, volatile.LoadUint32(&o.OSC8M.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTRL_Type) GetOSC8M_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.OSC8M.Reg) & 0x2) >> 1
}
func (o *SYSCTRL_Type) SetOSC8M_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.OSC8M.Reg, volatile.LoadUint32(&o.OSC8M.Reg)&^(0x40)|value<<6)
}
func (o *SYSCTRL_Type) GetOSC8M_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.OSC8M.Reg) & 0x40) >> 6
}
func (o *SYSCTRL_Type) SetOSC8M_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.OSC8M.Reg, volatile.LoadUint32(&o.OSC8M.Reg)&^(0x80)|value<<7)
}
func (o *SYSCTRL_Type) GetOSC8M_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.OSC8M.Reg) & 0x80) >> 7
}
func (o *SYSCTRL_Type) SetOSC8M_PRESC(value uint32) {
	volatile.StoreUint32(&o.OSC8M.Reg, volatile.LoadUint32(&o.OSC8M.Reg)&^(0x300)|value<<8)
}
func (o *SYSCTRL_Type) GetOSC8M_PRESC() uint32 {
	return (volatile.LoadUint32(&o.OSC8M.Reg) & 0x300) >> 8
}
func (o *SYSCTRL_Type) SetOSC8M_CALIB(value uint32) {
	volatile.StoreUint32(&o.OSC8M.Reg, volatile.LoadUint32(&o.OSC8M.Reg)&^(0xfff0000)|value<<16)
}
func (o *SYSCTRL_Type) GetOSC8M_CALIB() uint32 {
	return (volatile.LoadUint32(&o.OSC8M.Reg) & 0xfff0000) >> 16
}
func (o *SYSCTRL_Type) SetOSC8M_FRANGE(value uint32) {
	volatile.StoreUint32(&o.OSC8M.Reg, volatile.LoadUint32(&o.OSC8M.Reg)&^(0xc0000000)|value<<30)
}
func (o *SYSCTRL_Type) GetOSC8M_FRANGE() uint32 {
	return (volatile.LoadUint32(&o.OSC8M.Reg) & 0xc0000000) >> 30
}

// SYSCTRL.DFLLCTRL: DFLL48M Control
func (o *SYSCTRL_Type) SetDFLLCTRL_ENABLE(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTRL_Type) GetDFLLCTRL_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x2) >> 1
}
func (o *SYSCTRL_Type) SetDFLLCTRL_MODE(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTRL_Type) GetDFLLCTRL_MODE() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x4) >> 2
}
func (o *SYSCTRL_Type) SetDFLLCTRL_STABLE(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x8)|value<<3)
}
func (o *SYSCTRL_Type) GetDFLLCTRL_STABLE() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x8) >> 3
}
func (o *SYSCTRL_Type) SetDFLLCTRL_LLAW(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x10)|value<<4)
}
func (o *SYSCTRL_Type) GetDFLLCTRL_LLAW() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x10) >> 4
}
func (o *SYSCTRL_Type) SetDFLLCTRL_USBCRM(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x20)|value<<5)
}
func (o *SYSCTRL_Type) GetDFLLCTRL_USBCRM() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x20) >> 5
}
func (o *SYSCTRL_Type) SetDFLLCTRL_RUNSTDBY(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x40)|value<<6)
}
func (o *SYSCTRL_Type) GetDFLLCTRL_RUNSTDBY() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x40) >> 6
}
func (o *SYSCTRL_Type) SetDFLLCTRL_ONDEMAND(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x80)|value<<7)
}
func (o *SYSCTRL_Type) GetDFLLCTRL_ONDEMAND() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x80) >> 7
}
func (o *SYSCTRL_Type) SetDFLLCTRL_CCDIS(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x100)|value<<8)
}
func (o *SYSCTRL_Type) GetDFLLCTRL_CCDIS() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x100) >> 8
}
func (o *SYSCTRL_Type) SetDFLLCTRL_QLDIS(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x200)|value<<9)
}
func (o *SYSCTRL_Type) GetDFLLCTRL_QLDIS() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x200) >> 9
}
func (o *SYSCTRL_Type) SetDFLLCTRL_BPLCKC(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x400)|value<<10)
}
func (o *SYSCTRL_Type) GetDFLLCTRL_BPLCKC() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x400) >> 10
}
func (o *SYSCTRL_Type) SetDFLLCTRL_WAITLOCK(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x800)|value<<11)
}
func (o *SYSCTRL_Type) GetDFLLCTRL_WAITLOCK() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x800) >> 11
}

// SYSCTRL.DFLLVAL: DFLL48M Value
func (o *SYSCTRL_Type) SetDFLLVAL_FINE(value uint32) {
	volatile.StoreUint32(&o.DFLLVAL.Reg, volatile.LoadUint32(&o.DFLLVAL.Reg)&^(0x3ff)|value)
}
func (o *SYSCTRL_Type) GetDFLLVAL_FINE() uint32 {
	return volatile.LoadUint32(&o.DFLLVAL.Reg) & 0x3ff
}
func (o *SYSCTRL_Type) SetDFLLVAL_COARSE(value uint32) {
	volatile.StoreUint32(&o.DFLLVAL.Reg, volatile.LoadUint32(&o.DFLLVAL.Reg)&^(0xfc00)|value<<10)
}
func (o *SYSCTRL_Type) GetDFLLVAL_COARSE() uint32 {
	return (volatile.LoadUint32(&o.DFLLVAL.Reg) & 0xfc00) >> 10
}
func (o *SYSCTRL_Type) SetDFLLVAL_DIFF(value uint32) {
	volatile.StoreUint32(&o.DFLLVAL.Reg, volatile.LoadUint32(&o.DFLLVAL.Reg)&^(0xffff0000)|value<<16)
}
func (o *SYSCTRL_Type) GetDFLLVAL_DIFF() uint32 {
	return (volatile.LoadUint32(&o.DFLLVAL.Reg) & 0xffff0000) >> 16
}

// SYSCTRL.DFLLMUL: DFLL48M Multiplier
func (o *SYSCTRL_Type) SetDFLLMUL_MUL(value uint32) {
	volatile.StoreUint32(&o.DFLLMUL.Reg, volatile.LoadUint32(&o.DFLLMUL.Reg)&^(0xffff)|value)
}
func (o *SYSCTRL_Type) GetDFLLMUL_MUL() uint32 {
	return volatile.LoadUint32(&o.DFLLMUL.Reg) & 0xffff
}
func (o *SYSCTRL_Type) SetDFLLMUL_FSTEP(value uint32) {
	volatile.StoreUint32(&o.DFLLMUL.Reg, volatile.LoadUint32(&o.DFLLMUL.Reg)&^(0x3ff0000)|value<<16)
}
func (o *SYSCTRL_Type) GetDFLLMUL_FSTEP() uint32 {
	return (volatile.LoadUint32(&o.DFLLMUL.Reg) & 0x3ff0000) >> 16
}
func (o *SYSCTRL_Type) SetDFLLMUL_CSTEP(value uint32) {
	volatile.StoreUint32(&o.DFLLMUL.Reg, volatile.LoadUint32(&o.DFLLMUL.Reg)&^(0xfc000000)|value<<26)
}
func (o *SYSCTRL_Type) GetDFLLMUL_CSTEP() uint32 {
	return (volatile.LoadUint32(&o.DFLLMUL.Reg) & 0xfc000000) >> 26
}

// SYSCTRL.DFLLSYNC: DFLL48M Synchronization
func (o *SYSCTRL_Type) SetDFLLSYNC_READREQ(value uint8) {
	volatile.StoreUint8(&o.DFLLSYNC.Reg, volatile.LoadUint8(&o.DFLLSYNC.Reg)&^(0x80)|value<<7)
}
func (o *SYSCTRL_Type) GetDFLLSYNC_READREQ() uint8 {
	return (volatile.LoadUint8(&o.DFLLSYNC.Reg) & 0x80) >> 7
}

// SYSCTRL.BOD33: 3.3V Brown-Out Detector (BOD33) Control
func (o *SYSCTRL_Type) SetBOD33_ENABLE(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTRL_Type) GetBOD33_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x2) >> 1
}
func (o *SYSCTRL_Type) SetBOD33_HYST(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTRL_Type) GetBOD33_HYST() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x4) >> 2
}
func (o *SYSCTRL_Type) SetBOD33_ACTION(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x18)|value<<3)
}
func (o *SYSCTRL_Type) GetBOD33_ACTION() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x18) >> 3
}
func (o *SYSCTRL_Type) SetBOD33_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x40)|value<<6)
}
func (o *SYSCTRL_Type) GetBOD33_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x40) >> 6
}
func (o *SYSCTRL_Type) SetBOD33_MODE(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x100)|value<<8)
}
func (o *SYSCTRL_Type) GetBOD33_MODE() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x100) >> 8
}
func (o *SYSCTRL_Type) SetBOD33_CEN(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x200)|value<<9)
}
func (o *SYSCTRL_Type) GetBOD33_CEN() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x200) >> 9
}
func (o *SYSCTRL_Type) SetBOD33_PSEL(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCTRL_Type) GetBOD33_PSEL() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0xf000) >> 12
}
func (o *SYSCTRL_Type) SetBOD33_LEVEL(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x3f0000)|value<<16)
}
func (o *SYSCTRL_Type) GetBOD33_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x3f0000) >> 16
}

// SYSCTRL.VREG: Voltage Regulator System (VREG) Control
func (o *SYSCTRL_Type) SetVREG_RUNSTDBY(value uint16) {
	volatile.StoreUint16(&o.VREG.Reg, volatile.LoadUint16(&o.VREG.Reg)&^(0x40)|value<<6)
}
func (o *SYSCTRL_Type) GetVREG_RUNSTDBY() uint16 {
	return (volatile.LoadUint16(&o.VREG.Reg) & 0x40) >> 6
}
func (o *SYSCTRL_Type) SetVREG_FORCELDO(value uint16) {
	volatile.StoreUint16(&o.VREG.Reg, volatile.LoadUint16(&o.VREG.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCTRL_Type) GetVREG_FORCELDO() uint16 {
	return (volatile.LoadUint16(&o.VREG.Reg) & 0x2000) >> 13
}

// SYSCTRL.VREF: Voltage References System (VREF) Control
func (o *SYSCTRL_Type) SetVREF_TSEN(value uint32) {
	volatile.StoreUint32(&o.VREF.Reg, volatile.LoadUint32(&o.VREF.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTRL_Type) GetVREF_TSEN() uint32 {
	return (volatile.LoadUint32(&o.VREF.Reg) & 0x2) >> 1
}
func (o *SYSCTRL_Type) SetVREF_BGOUTEN(value uint32) {
	volatile.StoreUint32(&o.VREF.Reg, volatile.LoadUint32(&o.VREF.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTRL_Type) GetVREF_BGOUTEN() uint32 {
	return (volatile.LoadUint32(&o.VREF.Reg) & 0x4) >> 2
}
func (o *SYSCTRL_Type) SetVREF_CALIB(value uint32) {
	volatile.StoreUint32(&o.VREF.Reg, volatile.LoadUint32(&o.VREF.Reg)&^(0x7ff0000)|value<<16)
}
func (o *SYSCTRL_Type) GetVREF_CALIB() uint32 {
	return (volatile.LoadUint32(&o.VREF.Reg) & 0x7ff0000) >> 16
}

// SYSCTRL.DPLLCTRLA: DPLL Control A
func (o *SYSCTRL_Type) SetDPLLCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.DPLLCTRLA.Reg, volatile.LoadUint8(&o.DPLLCTRLA.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTRL_Type) GetDPLLCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.DPLLCTRLA.Reg) & 0x2) >> 1
}
func (o *SYSCTRL_Type) SetDPLLCTRLA_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.DPLLCTRLA.Reg, volatile.LoadUint8(&o.DPLLCTRLA.Reg)&^(0x40)|value<<6)
}
func (o *SYSCTRL_Type) GetDPLLCTRLA_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.DPLLCTRLA.Reg) & 0x40) >> 6
}
func (o *SYSCTRL_Type) SetDPLLCTRLA_ONDEMAND(value uint8) {
	volatile.StoreUint8(&o.DPLLCTRLA.Reg, volatile.LoadUint8(&o.DPLLCTRLA.Reg)&^(0x80)|value<<7)
}
func (o *SYSCTRL_Type) GetDPLLCTRLA_ONDEMAND() uint8 {
	return (volatile.LoadUint8(&o.DPLLCTRLA.Reg) & 0x80) >> 7
}

// SYSCTRL.DPLLRATIO: DPLL Ratio Control
func (o *SYSCTRL_Type) SetDPLLRATIO_LDR(value uint32) {
	volatile.StoreUint32(&o.DPLLRATIO.Reg, volatile.LoadUint32(&o.DPLLRATIO.Reg)&^(0xfff)|value)
}
func (o *SYSCTRL_Type) GetDPLLRATIO_LDR() uint32 {
	return volatile.LoadUint32(&o.DPLLRATIO.Reg) & 0xfff
}
func (o *SYSCTRL_Type) SetDPLLRATIO_LDRFRAC(value uint32) {
	volatile.StoreUint32(&o.DPLLRATIO.Reg, volatile.LoadUint32(&o.DPLLRATIO.Reg)&^(0xf0000)|value<<16)
}
func (o *SYSCTRL_Type) GetDPLLRATIO_LDRFRAC() uint32 {
	return (volatile.LoadUint32(&o.DPLLRATIO.Reg) & 0xf0000) >> 16
}

// SYSCTRL.DPLLCTRLB: DPLL Control B
func (o *SYSCTRL_Type) SetDPLLCTRLB_FILTER(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x3)|value)
}
func (o *SYSCTRL_Type) GetDPLLCTRLB_FILTER() uint32 {
	return volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x3
}
func (o *SYSCTRL_Type) SetDPLLCTRLB_LPEN(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTRL_Type) GetDPLLCTRLB_LPEN() uint32 {
	return (volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x4) >> 2
}
func (o *SYSCTRL_Type) SetDPLLCTRLB_WUF(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x8)|value<<3)
}
func (o *SYSCTRL_Type) GetDPLLCTRLB_WUF() uint32 {
	return (volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x8) >> 3
}
func (o *SYSCTRL_Type) SetDPLLCTRLB_REFCLK(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x30)|value<<4)
}
func (o *SYSCTRL_Type) GetDPLLCTRLB_REFCLK() uint32 {
	return (volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x30) >> 4
}
func (o *SYSCTRL_Type) SetDPLLCTRLB_LTIME(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x700)|value<<8)
}
func (o *SYSCTRL_Type) GetDPLLCTRLB_LTIME() uint32 {
	return (volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x700) >> 8
}
func (o *SYSCTRL_Type) SetDPLLCTRLB_LBYPASS(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCTRL_Type) GetDPLLCTRLB_LBYPASS() uint32 {
	return (volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x1000) >> 12
}
func (o *SYSCTRL_Type) SetDPLLCTRLB_DIV(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x7ff0000)|value<<16)
}
func (o *SYSCTRL_Type) GetDPLLCTRLB_DIV() uint32 {
	return (volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x7ff0000) >> 16
}

// SYSCTRL.DPLLSTATUS: DPLL Status
func (o *SYSCTRL_Type) SetDPLLSTATUS_LOCK(value uint8) {
	volatile.StoreUint8(&o.DPLLSTATUS.Reg, volatile.LoadUint8(&o.DPLLSTATUS.Reg)&^(0x1)|value)
}
func (o *SYSCTRL_Type) GetDPLLSTATUS_LOCK() uint8 {
	return volatile.LoadUint8(&o.DPLLSTATUS.Reg) & 0x1
}
func (o *SYSCTRL_Type) SetDPLLSTATUS_CLKRDY(value uint8) {
	volatile.StoreUint8(&o.DPLLSTATUS.Reg, volatile.LoadUint8(&o.DPLLSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *SYSCTRL_Type) GetDPLLSTATUS_CLKRDY() uint8 {
	return (volatile.LoadUint8(&o.DPLLSTATUS.Reg) & 0x2) >> 1
}
func (o *SYSCTRL_Type) SetDPLLSTATUS_ENABLE(value uint8) {
	volatile.StoreUint8(&o.DPLLSTATUS.Reg, volatile.LoadUint8(&o.DPLLSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *SYSCTRL_Type) GetDPLLSTATUS_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.DPLLSTATUS.Reg) & 0x4) >> 2
}
func (o *SYSCTRL_Type) SetDPLLSTATUS_DIV(value uint8) {
	volatile.StoreUint8(&o.DPLLSTATUS.Reg, volatile.LoadUint8(&o.DPLLSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *SYSCTRL_Type) GetDPLLSTATUS_DIV() uint8 {
	return (volatile.LoadUint8(&o.DPLLSTATUS.Reg) & 0x8) >> 3
}

// Basic Timer Counter 3
type TC_Type struct {
}

// Basic Timer Counter 3 - COUNT8
type TC_COUNT8_Type struct {
	CTRLA    volatile.Register16 // 0x0
	READREQ  volatile.Register16 // 0x2
	CTRLBCLR volatile.Register8  // 0x4
	CTRLBSET volatile.Register8  // 0x5
	CTRLC    volatile.Register8  // 0x6
	_        byte
	DBGCTRL  volatile.Register8 // 0x8
	_        byte
	EVCTRL   volatile.Register16 // 0xA
	INTENCLR volatile.Register8  // 0xC
	INTENSET volatile.Register8  // 0xD
	INTFLAG  volatile.Register8  // 0xE
	STATUS   volatile.Register8  // 0xF
	COUNT    volatile.Register8  // 0x10
	_        [3]byte
	PER      volatile.Register8 // 0x14
	_        [3]byte
	CC0      volatile.Register8 // 0x18
	CC1      volatile.Register8 // 0x19
}

// TC_COUNT8.CTRLA: Control A
func (o *TC_COUNT8_Type) SetCTRLA_SWRST(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetCTRLA_SWRST() uint16 {
	return volatile.LoadUint16(&o.CTRLA.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetCTRLA_ENABLE(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetCTRLA_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetCTRLA_MODE(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0xc)|value<<2)
}
func (o *TC_COUNT8_Type) GetCTRLA_MODE() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0xc) >> 2
}
func (o *TC_COUNT8_Type) SetCTRLA_WAVEGEN(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x60)|value<<5)
}
func (o *TC_COUNT8_Type) GetCTRLA_WAVEGEN() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x60) >> 5
}
func (o *TC_COUNT8_Type) SetCTRLA_PRESCALER(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x700)|value<<8)
}
func (o *TC_COUNT8_Type) GetCTRLA_PRESCALER() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x700) >> 8
}
func (o *TC_COUNT8_Type) SetCTRLA_RUNSTDBY(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x800)|value<<11)
}
func (o *TC_COUNT8_Type) GetCTRLA_RUNSTDBY() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x800) >> 11
}
func (o *TC_COUNT8_Type) SetCTRLA_PRESCSYNC(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x3000)|value<<12)
}
func (o *TC_COUNT8_Type) GetCTRLA_PRESCSYNC() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x3000) >> 12
}

// TC_COUNT8.READREQ: Read Request
func (o *TC_COUNT8_Type) SetREADREQ_ADDR(value uint16) {
	volatile.StoreUint16(&o.READREQ.Reg, volatile.LoadUint16(&o.READREQ.Reg)&^(0x1f)|value)
}
func (o *TC_COUNT8_Type) GetREADREQ_ADDR() uint16 {
	return volatile.LoadUint16(&o.READREQ.Reg) & 0x1f
}
func (o *TC_COUNT8_Type) SetREADREQ_RCONT(value uint16) {
	volatile.StoreUint16(&o.READREQ.Reg, volatile.LoadUint16(&o.READREQ.Reg)&^(0x4000)|value<<14)
}
func (o *TC_COUNT8_Type) GetREADREQ_RCONT() uint16 {
	return (volatile.LoadUint16(&o.READREQ.Reg) & 0x4000) >> 14
}
func (o *TC_COUNT8_Type) SetREADREQ_RREQ(value uint16) {
	volatile.StoreUint16(&o.READREQ.Reg, volatile.LoadUint16(&o.READREQ.Reg)&^(0x8000)|value<<15)
}
func (o *TC_COUNT8_Type) GetREADREQ_RREQ() uint16 {
	return (volatile.LoadUint16(&o.READREQ.Reg) & 0x8000) >> 15
}

// TC_COUNT8.CTRLBCLR: Control B Clear
func (o *TC_COUNT8_Type) SetCTRLBCLR_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetCTRLBCLR_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetCTRLBCLR_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT8_Type) GetCTRLBCLR_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x4) >> 2
}
func (o *TC_COUNT8_Type) SetCTRLBCLR_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0xc0)|value<<6)
}
func (o *TC_COUNT8_Type) GetCTRLBCLR_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0xc0) >> 6
}

// TC_COUNT8.CTRLBSET: Control B Set
func (o *TC_COUNT8_Type) SetCTRLBSET_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetCTRLBSET_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetCTRLBSET_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT8_Type) GetCTRLBSET_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x4) >> 2
}
func (o *TC_COUNT8_Type) SetCTRLBSET_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0xc0)|value<<6)
}
func (o *TC_COUNT8_Type) GetCTRLBSET_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0xc0) >> 6
}

// TC_COUNT8.CTRLC: Control C
func (o *TC_COUNT8_Type) SetCTRLC_INVEN0(value uint8) {
	volatile.StoreUint8(&o.CTRLC.Reg, volatile.LoadUint8(&o.CTRLC.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetCTRLC_INVEN0() uint8 {
	return volatile.LoadUint8(&o.CTRLC.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetCTRLC_INVEN1(value uint8) {
	volatile.StoreUint8(&o.CTRLC.Reg, volatile.LoadUint8(&o.CTRLC.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetCTRLC_INVEN1() uint8 {
	return (volatile.LoadUint8(&o.CTRLC.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetCTRLC_CPTEN0(value uint8) {
	volatile.StoreUint8(&o.CTRLC.Reg, volatile.LoadUint8(&o.CTRLC.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT8_Type) GetCTRLC_CPTEN0() uint8 {
	return (volatile.LoadUint8(&o.CTRLC.Reg) & 0x10) >> 4
}
func (o *TC_COUNT8_Type) SetCTRLC_CPTEN1(value uint8) {
	volatile.StoreUint8(&o.CTRLC.Reg, volatile.LoadUint8(&o.CTRLC.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT8_Type) GetCTRLC_CPTEN1() uint8 {
	return (volatile.LoadUint8(&o.CTRLC.Reg) & 0x20) >> 5
}

// TC_COUNT8.DBGCTRL: Debug Control
func (o *TC_COUNT8_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// TC_COUNT8.EVCTRL: Event Control
func (o *TC_COUNT8_Type) SetEVCTRL_EVACT(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x7)|value)
}
func (o *TC_COUNT8_Type) GetEVCTRL_EVACT() uint16 {
	return volatile.LoadUint16(&o.EVCTRL.Reg) & 0x7
}
func (o *TC_COUNT8_Type) SetEVCTRL_TCINV(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT8_Type) GetEVCTRL_TCINV() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *TC_COUNT8_Type) SetEVCTRL_TCEI(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT8_Type) GetEVCTRL_TCEI() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *TC_COUNT8_Type) SetEVCTRL_OVFEO(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *TC_COUNT8_Type) GetEVCTRL_OVFEO() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *TC_COUNT8_Type) SetEVCTRL_MCEO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *TC_COUNT8_Type) GetEVCTRL_MCEO0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x1000) >> 12
}
func (o *TC_COUNT8_Type) SetEVCTRL_MCEO1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *TC_COUNT8_Type) GetEVCTRL_MCEO1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x2000) >> 13
}

// TC_COUNT8.INTENCLR: Interrupt Enable Clear
func (o *TC_COUNT8_Type) SetINTENCLR_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetINTENCLR_OVF() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetINTENCLR_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetINTENCLR_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetINTENCLR_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT8_Type) GetINTENCLR_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *TC_COUNT8_Type) SetINTENCLR_MC0(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT8_Type) GetINTENCLR_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *TC_COUNT8_Type) SetINTENCLR_MC1(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT8_Type) GetINTENCLR_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x20) >> 5
}

// TC_COUNT8.INTENSET: Interrupt Enable Set
func (o *TC_COUNT8_Type) SetINTENSET_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetINTENSET_OVF() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetINTENSET_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetINTENSET_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetINTENSET_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT8_Type) GetINTENSET_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *TC_COUNT8_Type) SetINTENSET_MC0(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT8_Type) GetINTENSET_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *TC_COUNT8_Type) SetINTENSET_MC1(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT8_Type) GetINTENSET_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x20) >> 5
}

// TC_COUNT8.INTFLAG: Interrupt Flag Status and Clear
func (o *TC_COUNT8_Type) SetINTFLAG_OVF(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetINTFLAG_OVF() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetINTFLAG_ERR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetINTFLAG_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetINTFLAG_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT8_Type) GetINTFLAG_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *TC_COUNT8_Type) SetINTFLAG_MC0(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT8_Type) GetINTFLAG_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *TC_COUNT8_Type) SetINTFLAG_MC1(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT8_Type) GetINTFLAG_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x20) >> 5
}

// TC_COUNT8.STATUS: Status
func (o *TC_COUNT8_Type) SetSTATUS_STOP(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT8_Type) GetSTATUS_STOP() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *TC_COUNT8_Type) SetSTATUS_SLAVE(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT8_Type) GetSTATUS_SLAVE() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *TC_COUNT8_Type) SetSTATUS_SYNCBUSY(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *TC_COUNT8_Type) GetSTATUS_SYNCBUSY() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x80) >> 7
}

// TC_COUNT8.COUNT: COUNT8 Counter Value
func (o *TC_COUNT8_Type) SetCOUNT(value uint8) {
	volatile.StoreUint8(&o.COUNT.Reg, value)
}
func (o *TC_COUNT8_Type) GetCOUNT() uint8 {
	return volatile.LoadUint8(&o.COUNT.Reg)
}

// TC_COUNT8.PER: COUNT8 Period Value
func (o *TC_COUNT8_Type) SetPER(value uint8) {
	volatile.StoreUint8(&o.PER.Reg, value)
}
func (o *TC_COUNT8_Type) GetPER() uint8 {
	return volatile.LoadUint8(&o.PER.Reg)
}

// TC_COUNT8.CC0: COUNT8 Compare/Capture
func (o *TC_COUNT8_Type) SetCC0(value uint8) {
	volatile.StoreUint8(&o.CC0.Reg, value)
}
func (o *TC_COUNT8_Type) GetCC0() uint8 {
	return volatile.LoadUint8(&o.CC0.Reg)
}

// TC_COUNT8.CC1: COUNT8 Compare/Capture
func (o *TC_COUNT8_Type) SetCC1(value uint8) {
	volatile.StoreUint8(&o.CC1.Reg, value)
}
func (o *TC_COUNT8_Type) GetCC1() uint8 {
	return volatile.LoadUint8(&o.CC1.Reg)
}

// Basic Timer Counter 3 - COUNT16
type TC_COUNT16_Type struct {
	CTRLA    volatile.Register16 // 0x0
	READREQ  volatile.Register16 // 0x2
	CTRLBCLR volatile.Register8  // 0x4
	CTRLBSET volatile.Register8  // 0x5
	CTRLC    volatile.Register8  // 0x6
	_        byte
	DBGCTRL  volatile.Register8 // 0x8
	_        byte
	EVCTRL   volatile.Register16 // 0xA
	INTENCLR volatile.Register8  // 0xC
	INTENSET volatile.Register8  // 0xD
	INTFLAG  volatile.Register8  // 0xE
	STATUS   volatile.Register8  // 0xF
	COUNT    volatile.Register16 // 0x10
	_        [6]byte
	CC0      volatile.Register16 // 0x18
	CC1      volatile.Register16 // 0x1A
}

// TC_COUNT16.CTRLA: Control A
func (o *TC_COUNT16_Type) SetCTRLA_SWRST(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetCTRLA_SWRST() uint16 {
	return volatile.LoadUint16(&o.CTRLA.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetCTRLA_ENABLE(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetCTRLA_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetCTRLA_MODE(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0xc)|value<<2)
}
func (o *TC_COUNT16_Type) GetCTRLA_MODE() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0xc) >> 2
}
func (o *TC_COUNT16_Type) SetCTRLA_WAVEGEN(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x60)|value<<5)
}
func (o *TC_COUNT16_Type) GetCTRLA_WAVEGEN() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x60) >> 5
}
func (o *TC_COUNT16_Type) SetCTRLA_PRESCALER(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x700)|value<<8)
}
func (o *TC_COUNT16_Type) GetCTRLA_PRESCALER() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x700) >> 8
}
func (o *TC_COUNT16_Type) SetCTRLA_RUNSTDBY(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x800)|value<<11)
}
func (o *TC_COUNT16_Type) GetCTRLA_RUNSTDBY() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x800) >> 11
}
func (o *TC_COUNT16_Type) SetCTRLA_PRESCSYNC(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x3000)|value<<12)
}
func (o *TC_COUNT16_Type) GetCTRLA_PRESCSYNC() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x3000) >> 12
}

// TC_COUNT16.READREQ: Read Request
func (o *TC_COUNT16_Type) SetREADREQ_ADDR(value uint16) {
	volatile.StoreUint16(&o.READREQ.Reg, volatile.LoadUint16(&o.READREQ.Reg)&^(0x1f)|value)
}
func (o *TC_COUNT16_Type) GetREADREQ_ADDR() uint16 {
	return volatile.LoadUint16(&o.READREQ.Reg) & 0x1f
}
func (o *TC_COUNT16_Type) SetREADREQ_RCONT(value uint16) {
	volatile.StoreUint16(&o.READREQ.Reg, volatile.LoadUint16(&o.READREQ.Reg)&^(0x4000)|value<<14)
}
func (o *TC_COUNT16_Type) GetREADREQ_RCONT() uint16 {
	return (volatile.LoadUint16(&o.READREQ.Reg) & 0x4000) >> 14
}
func (o *TC_COUNT16_Type) SetREADREQ_RREQ(value uint16) {
	volatile.StoreUint16(&o.READREQ.Reg, volatile.LoadUint16(&o.READREQ.Reg)&^(0x8000)|value<<15)
}
func (o *TC_COUNT16_Type) GetREADREQ_RREQ() uint16 {
	return (volatile.LoadUint16(&o.READREQ.Reg) & 0x8000) >> 15
}

// TC_COUNT16.CTRLBCLR: Control B Clear
func (o *TC_COUNT16_Type) SetCTRLBCLR_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetCTRLBCLR_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetCTRLBCLR_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT16_Type) GetCTRLBCLR_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x4) >> 2
}
func (o *TC_COUNT16_Type) SetCTRLBCLR_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0xc0)|value<<6)
}
func (o *TC_COUNT16_Type) GetCTRLBCLR_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0xc0) >> 6
}

// TC_COUNT16.CTRLBSET: Control B Set
func (o *TC_COUNT16_Type) SetCTRLBSET_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetCTRLBSET_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetCTRLBSET_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT16_Type) GetCTRLBSET_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x4) >> 2
}
func (o *TC_COUNT16_Type) SetCTRLBSET_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0xc0)|value<<6)
}
func (o *TC_COUNT16_Type) GetCTRLBSET_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0xc0) >> 6
}

// TC_COUNT16.CTRLC: Control C
func (o *TC_COUNT16_Type) SetCTRLC_INVEN0(value uint8) {
	volatile.StoreUint8(&o.CTRLC.Reg, volatile.LoadUint8(&o.CTRLC.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetCTRLC_INVEN0() uint8 {
	return volatile.LoadUint8(&o.CTRLC.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetCTRLC_INVEN1(value uint8) {
	volatile.StoreUint8(&o.CTRLC.Reg, volatile.LoadUint8(&o.CTRLC.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetCTRLC_INVEN1() uint8 {
	return (volatile.LoadUint8(&o.CTRLC.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetCTRLC_CPTEN0(value uint8) {
	volatile.StoreUint8(&o.CTRLC.Reg, volatile.LoadUint8(&o.CTRLC.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT16_Type) GetCTRLC_CPTEN0() uint8 {
	return (volatile.LoadUint8(&o.CTRLC.Reg) & 0x10) >> 4
}
func (o *TC_COUNT16_Type) SetCTRLC_CPTEN1(value uint8) {
	volatile.StoreUint8(&o.CTRLC.Reg, volatile.LoadUint8(&o.CTRLC.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT16_Type) GetCTRLC_CPTEN1() uint8 {
	return (volatile.LoadUint8(&o.CTRLC.Reg) & 0x20) >> 5
}

// TC_COUNT16.DBGCTRL: Debug Control
func (o *TC_COUNT16_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// TC_COUNT16.EVCTRL: Event Control
func (o *TC_COUNT16_Type) SetEVCTRL_EVACT(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x7)|value)
}
func (o *TC_COUNT16_Type) GetEVCTRL_EVACT() uint16 {
	return volatile.LoadUint16(&o.EVCTRL.Reg) & 0x7
}
func (o *TC_COUNT16_Type) SetEVCTRL_TCINV(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT16_Type) GetEVCTRL_TCINV() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *TC_COUNT16_Type) SetEVCTRL_TCEI(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT16_Type) GetEVCTRL_TCEI() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *TC_COUNT16_Type) SetEVCTRL_OVFEO(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *TC_COUNT16_Type) GetEVCTRL_OVFEO() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *TC_COUNT16_Type) SetEVCTRL_MCEO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *TC_COUNT16_Type) GetEVCTRL_MCEO0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x1000) >> 12
}
func (o *TC_COUNT16_Type) SetEVCTRL_MCEO1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *TC_COUNT16_Type) GetEVCTRL_MCEO1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x2000) >> 13
}

// TC_COUNT16.INTENCLR: Interrupt Enable Clear
func (o *TC_COUNT16_Type) SetINTENCLR_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetINTENCLR_OVF() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetINTENCLR_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetINTENCLR_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetINTENCLR_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT16_Type) GetINTENCLR_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *TC_COUNT16_Type) SetINTENCLR_MC0(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT16_Type) GetINTENCLR_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *TC_COUNT16_Type) SetINTENCLR_MC1(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT16_Type) GetINTENCLR_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x20) >> 5
}

// TC_COUNT16.INTENSET: Interrupt Enable Set
func (o *TC_COUNT16_Type) SetINTENSET_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetINTENSET_OVF() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetINTENSET_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetINTENSET_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetINTENSET_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT16_Type) GetINTENSET_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *TC_COUNT16_Type) SetINTENSET_MC0(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT16_Type) GetINTENSET_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *TC_COUNT16_Type) SetINTENSET_MC1(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT16_Type) GetINTENSET_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x20) >> 5
}

// TC_COUNT16.INTFLAG: Interrupt Flag Status and Clear
func (o *TC_COUNT16_Type) SetINTFLAG_OVF(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetINTFLAG_OVF() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetINTFLAG_ERR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetINTFLAG_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetINTFLAG_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT16_Type) GetINTFLAG_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *TC_COUNT16_Type) SetINTFLAG_MC0(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT16_Type) GetINTFLAG_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *TC_COUNT16_Type) SetINTFLAG_MC1(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT16_Type) GetINTFLAG_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x20) >> 5
}

// TC_COUNT16.STATUS: Status
func (o *TC_COUNT16_Type) SetSTATUS_STOP(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT16_Type) GetSTATUS_STOP() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *TC_COUNT16_Type) SetSTATUS_SLAVE(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT16_Type) GetSTATUS_SLAVE() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *TC_COUNT16_Type) SetSTATUS_SYNCBUSY(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *TC_COUNT16_Type) GetSTATUS_SYNCBUSY() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x80) >> 7
}

// TC_COUNT16.COUNT: COUNT16 Counter Value
func (o *TC_COUNT16_Type) SetCOUNT(value uint16) {
	volatile.StoreUint16(&o.COUNT.Reg, value)
}
func (o *TC_COUNT16_Type) GetCOUNT() uint16 {
	return volatile.LoadUint16(&o.COUNT.Reg)
}

// TC_COUNT16.CC0: COUNT16 Compare/Capture
func (o *TC_COUNT16_Type) SetCC0(value uint16) {
	volatile.StoreUint16(&o.CC0.Reg, value)
}
func (o *TC_COUNT16_Type) GetCC0() uint16 {
	return volatile.LoadUint16(&o.CC0.Reg)
}

// TC_COUNT16.CC1: COUNT16 Compare/Capture
func (o *TC_COUNT16_Type) SetCC1(value uint16) {
	volatile.StoreUint16(&o.CC1.Reg, value)
}
func (o *TC_COUNT16_Type) GetCC1() uint16 {
	return volatile.LoadUint16(&o.CC1.Reg)
}

// Basic Timer Counter 3 - COUNT32
type TC_COUNT32_Type struct {
	CTRLA    volatile.Register16 // 0x0
	READREQ  volatile.Register16 // 0x2
	CTRLBCLR volatile.Register8  // 0x4
	CTRLBSET volatile.Register8  // 0x5
	CTRLC    volatile.Register8  // 0x6
	_        byte
	DBGCTRL  volatile.Register8 // 0x8
	_        byte
	EVCTRL   volatile.Register16 // 0xA
	INTENCLR volatile.Register8  // 0xC
	INTENSET volatile.Register8  // 0xD
	INTFLAG  volatile.Register8  // 0xE
	STATUS   volatile.Register8  // 0xF
	COUNT    volatile.Register32 // 0x10
	_        [4]byte
	CC0      volatile.Register32 // 0x18
	CC1      volatile.Register32 // 0x1C
}

// TC_COUNT32.CTRLA: Control A
func (o *TC_COUNT32_Type) SetCTRLA_SWRST(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetCTRLA_SWRST() uint16 {
	return volatile.LoadUint16(&o.CTRLA.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetCTRLA_ENABLE(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetCTRLA_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetCTRLA_MODE(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0xc)|value<<2)
}
func (o *TC_COUNT32_Type) GetCTRLA_MODE() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0xc) >> 2
}
func (o *TC_COUNT32_Type) SetCTRLA_WAVEGEN(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x60)|value<<5)
}
func (o *TC_COUNT32_Type) GetCTRLA_WAVEGEN() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x60) >> 5
}
func (o *TC_COUNT32_Type) SetCTRLA_PRESCALER(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x700)|value<<8)
}
func (o *TC_COUNT32_Type) GetCTRLA_PRESCALER() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x700) >> 8
}
func (o *TC_COUNT32_Type) SetCTRLA_RUNSTDBY(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x800)|value<<11)
}
func (o *TC_COUNT32_Type) GetCTRLA_RUNSTDBY() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x800) >> 11
}
func (o *TC_COUNT32_Type) SetCTRLA_PRESCSYNC(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x3000)|value<<12)
}
func (o *TC_COUNT32_Type) GetCTRLA_PRESCSYNC() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x3000) >> 12
}

// TC_COUNT32.READREQ: Read Request
func (o *TC_COUNT32_Type) SetREADREQ_ADDR(value uint16) {
	volatile.StoreUint16(&o.READREQ.Reg, volatile.LoadUint16(&o.READREQ.Reg)&^(0x1f)|value)
}
func (o *TC_COUNT32_Type) GetREADREQ_ADDR() uint16 {
	return volatile.LoadUint16(&o.READREQ.Reg) & 0x1f
}
func (o *TC_COUNT32_Type) SetREADREQ_RCONT(value uint16) {
	volatile.StoreUint16(&o.READREQ.Reg, volatile.LoadUint16(&o.READREQ.Reg)&^(0x4000)|value<<14)
}
func (o *TC_COUNT32_Type) GetREADREQ_RCONT() uint16 {
	return (volatile.LoadUint16(&o.READREQ.Reg) & 0x4000) >> 14
}
func (o *TC_COUNT32_Type) SetREADREQ_RREQ(value uint16) {
	volatile.StoreUint16(&o.READREQ.Reg, volatile.LoadUint16(&o.READREQ.Reg)&^(0x8000)|value<<15)
}
func (o *TC_COUNT32_Type) GetREADREQ_RREQ() uint16 {
	return (volatile.LoadUint16(&o.READREQ.Reg) & 0x8000) >> 15
}

// TC_COUNT32.CTRLBCLR: Control B Clear
func (o *TC_COUNT32_Type) SetCTRLBCLR_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetCTRLBCLR_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetCTRLBCLR_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT32_Type) GetCTRLBCLR_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x4) >> 2
}
func (o *TC_COUNT32_Type) SetCTRLBCLR_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0xc0)|value<<6)
}
func (o *TC_COUNT32_Type) GetCTRLBCLR_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0xc0) >> 6
}

// TC_COUNT32.CTRLBSET: Control B Set
func (o *TC_COUNT32_Type) SetCTRLBSET_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetCTRLBSET_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetCTRLBSET_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT32_Type) GetCTRLBSET_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x4) >> 2
}
func (o *TC_COUNT32_Type) SetCTRLBSET_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0xc0)|value<<6)
}
func (o *TC_COUNT32_Type) GetCTRLBSET_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0xc0) >> 6
}

// TC_COUNT32.CTRLC: Control C
func (o *TC_COUNT32_Type) SetCTRLC_INVEN0(value uint8) {
	volatile.StoreUint8(&o.CTRLC.Reg, volatile.LoadUint8(&o.CTRLC.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetCTRLC_INVEN0() uint8 {
	return volatile.LoadUint8(&o.CTRLC.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetCTRLC_INVEN1(value uint8) {
	volatile.StoreUint8(&o.CTRLC.Reg, volatile.LoadUint8(&o.CTRLC.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetCTRLC_INVEN1() uint8 {
	return (volatile.LoadUint8(&o.CTRLC.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetCTRLC_CPTEN0(value uint8) {
	volatile.StoreUint8(&o.CTRLC.Reg, volatile.LoadUint8(&o.CTRLC.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT32_Type) GetCTRLC_CPTEN0() uint8 {
	return (volatile.LoadUint8(&o.CTRLC.Reg) & 0x10) >> 4
}
func (o *TC_COUNT32_Type) SetCTRLC_CPTEN1(value uint8) {
	volatile.StoreUint8(&o.CTRLC.Reg, volatile.LoadUint8(&o.CTRLC.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT32_Type) GetCTRLC_CPTEN1() uint8 {
	return (volatile.LoadUint8(&o.CTRLC.Reg) & 0x20) >> 5
}

// TC_COUNT32.DBGCTRL: Debug Control
func (o *TC_COUNT32_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// TC_COUNT32.EVCTRL: Event Control
func (o *TC_COUNT32_Type) SetEVCTRL_EVACT(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x7)|value)
}
func (o *TC_COUNT32_Type) GetEVCTRL_EVACT() uint16 {
	return volatile.LoadUint16(&o.EVCTRL.Reg) & 0x7
}
func (o *TC_COUNT32_Type) SetEVCTRL_TCINV(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT32_Type) GetEVCTRL_TCINV() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *TC_COUNT32_Type) SetEVCTRL_TCEI(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT32_Type) GetEVCTRL_TCEI() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *TC_COUNT32_Type) SetEVCTRL_OVFEO(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *TC_COUNT32_Type) GetEVCTRL_OVFEO() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *TC_COUNT32_Type) SetEVCTRL_MCEO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *TC_COUNT32_Type) GetEVCTRL_MCEO0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x1000) >> 12
}
func (o *TC_COUNT32_Type) SetEVCTRL_MCEO1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *TC_COUNT32_Type) GetEVCTRL_MCEO1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x2000) >> 13
}

// TC_COUNT32.INTENCLR: Interrupt Enable Clear
func (o *TC_COUNT32_Type) SetINTENCLR_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetINTENCLR_OVF() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetINTENCLR_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetINTENCLR_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetINTENCLR_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT32_Type) GetINTENCLR_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *TC_COUNT32_Type) SetINTENCLR_MC0(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT32_Type) GetINTENCLR_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *TC_COUNT32_Type) SetINTENCLR_MC1(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT32_Type) GetINTENCLR_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x20) >> 5
}

// TC_COUNT32.INTENSET: Interrupt Enable Set
func (o *TC_COUNT32_Type) SetINTENSET_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetINTENSET_OVF() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetINTENSET_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetINTENSET_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetINTENSET_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT32_Type) GetINTENSET_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *TC_COUNT32_Type) SetINTENSET_MC0(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT32_Type) GetINTENSET_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *TC_COUNT32_Type) SetINTENSET_MC1(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT32_Type) GetINTENSET_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x20) >> 5
}

// TC_COUNT32.INTFLAG: Interrupt Flag Status and Clear
func (o *TC_COUNT32_Type) SetINTFLAG_OVF(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetINTFLAG_OVF() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetINTFLAG_ERR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetINTFLAG_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetINTFLAG_SYNCRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT32_Type) GetINTFLAG_SYNCRDY() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *TC_COUNT32_Type) SetINTFLAG_MC0(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT32_Type) GetINTFLAG_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *TC_COUNT32_Type) SetINTFLAG_MC1(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT32_Type) GetINTFLAG_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x20) >> 5
}

// TC_COUNT32.STATUS: Status
func (o *TC_COUNT32_Type) SetSTATUS_STOP(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT32_Type) GetSTATUS_STOP() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *TC_COUNT32_Type) SetSTATUS_SLAVE(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT32_Type) GetSTATUS_SLAVE() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *TC_COUNT32_Type) SetSTATUS_SYNCBUSY(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *TC_COUNT32_Type) GetSTATUS_SYNCBUSY() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x80) >> 7
}

// TC_COUNT32.COUNT: COUNT32 Counter Value
func (o *TC_COUNT32_Type) SetCOUNT(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, value)
}
func (o *TC_COUNT32_Type) GetCOUNT() uint32 {
	return volatile.LoadUint32(&o.COUNT.Reg)
}

// TC_COUNT32.CC0: COUNT32 Compare/Capture
func (o *TC_COUNT32_Type) SetCC0(value uint32) {
	volatile.StoreUint32(&o.CC0.Reg, value)
}
func (o *TC_COUNT32_Type) GetCC0() uint32 {
	return volatile.LoadUint32(&o.CC0.Reg)
}

// TC_COUNT32.CC1: COUNT32 Compare/Capture
func (o *TC_COUNT32_Type) SetCC1(value uint32) {
	volatile.StoreUint32(&o.CC1.Reg, value)
}
func (o *TC_COUNT32_Type) GetCC1() uint32 {
	return volatile.LoadUint32(&o.CC1.Reg)
}

// Timer Counter Control 0
type TCC_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLBCLR volatile.Register8  // 0x4
	CTRLBSET volatile.Register8  // 0x5
	_        [2]byte
	SYNCBUSY volatile.Register32 // 0x8
	FCTRLA   volatile.Register32 // 0xC
	FCTRLB   volatile.Register32 // 0x10
	WEXCTRL  volatile.Register32 // 0x14
	DRVCTRL  volatile.Register32 // 0x18
	_        [2]byte
	DBGCTRL  volatile.Register8 // 0x1E
	_        byte
	EVCTRL   volatile.Register32 // 0x20
	INTENCLR volatile.Register32 // 0x24
	INTENSET volatile.Register32 // 0x28
	INTFLAG  volatile.Register32 // 0x2C
	STATUS   volatile.Register32 // 0x30
	COUNT    volatile.Register32 // 0x34
	PATT     volatile.Register16 // 0x38
	_        [2]byte
	WAVE     volatile.Register32 // 0x3C
	PER      volatile.Register32 // 0x40
	CC0      volatile.Register32 // 0x44
	CC1      volatile.Register32 // 0x48
	CC2      volatile.Register32 // 0x4C
	CC3      volatile.Register32 // 0x50
	_        [16]byte
	PATTB    volatile.Register16 // 0x64
	_        [2]byte
	WAVEB    volatile.Register32 // 0x68
	PERB     volatile.Register32 // 0x6C
	CCB0     volatile.Register32 // 0x70
	CCB1     volatile.Register32 // 0x74
	CCB2     volatile.Register32 // 0x78
	CCB3     volatile.Register32 // 0x7C
}

// TCC.CTRLA: Control A
func (o *TCC_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *TCC_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetCTRLA_RESOLUTION(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x60)|value<<5)
}
func (o *TCC_Type) GetCTRLA_RESOLUTION() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x60) >> 5
}
func (o *TCC_Type) SetCTRLA_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x700)|value<<8)
}
func (o *TCC_Type) GetCTRLA_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x700) >> 8
}
func (o *TCC_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetCTRLA_PRESCSYNC(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x3000)|value<<12)
}
func (o *TCC_Type) GetCTRLA_PRESCSYNC() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x3000) >> 12
}
func (o *TCC_Type) SetCTRLA_ALOCK(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x4000)|value<<14)
}
func (o *TCC_Type) GetCTRLA_ALOCK() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x4000) >> 14
}
func (o *TCC_Type) SetCTRLA_CPTEN0(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1000000)|value<<24)
}
func (o *TCC_Type) GetCTRLA_CPTEN0() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x1000000) >> 24
}
func (o *TCC_Type) SetCTRLA_CPTEN1(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2000000)|value<<25)
}
func (o *TCC_Type) GetCTRLA_CPTEN1() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2000000) >> 25
}
func (o *TCC_Type) SetCTRLA_CPTEN2(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x4000000)|value<<26)
}
func (o *TCC_Type) GetCTRLA_CPTEN2() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x4000000) >> 26
}
func (o *TCC_Type) SetCTRLA_CPTEN3(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x8000000)|value<<27)
}
func (o *TCC_Type) GetCTRLA_CPTEN3() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x8000000) >> 27
}

// TCC.CTRLBCLR: Control B Clear
func (o *TCC_Type) SetCTRLBCLR_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetCTRLBCLR_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x1
}
func (o *TCC_Type) SetCTRLBCLR_LUPD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetCTRLBCLR_LUPD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetCTRLBCLR_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetCTRLBCLR_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetCTRLBCLR_IDXCMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x18)|value<<3)
}
func (o *TCC_Type) GetCTRLBCLR_IDXCMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x18) >> 3
}
func (o *TCC_Type) SetCTRLBCLR_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0xe0)|value<<5)
}
func (o *TCC_Type) GetCTRLBCLR_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0xe0) >> 5
}

// TCC.CTRLBSET: Control B Set
func (o *TCC_Type) SetCTRLBSET_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetCTRLBSET_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x1
}
func (o *TCC_Type) SetCTRLBSET_LUPD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetCTRLBSET_LUPD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetCTRLBSET_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetCTRLBSET_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetCTRLBSET_IDXCMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x18)|value<<3)
}
func (o *TCC_Type) GetCTRLBSET_IDXCMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x18) >> 3
}
func (o *TCC_Type) SetCTRLBSET_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0xe0)|value<<5)
}
func (o *TCC_Type) GetCTRLBSET_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0xe0) >> 5
}

// TCC.SYNCBUSY: Synchronization Busy
func (o *TCC_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *TCC_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetSYNCBUSY_CTRLB(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetSYNCBUSY_CTRLB() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetSYNCBUSY_STATUS(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetSYNCBUSY_STATUS() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetSYNCBUSY_COUNT(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *TCC_Type) GetSYNCBUSY_COUNT() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10) >> 4
}
func (o *TCC_Type) SetSYNCBUSY_PATT(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *TCC_Type) GetSYNCBUSY_PATT() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *TCC_Type) SetSYNCBUSY_WAVE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x40)|value<<6)
}
func (o *TCC_Type) GetSYNCBUSY_WAVE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x40) >> 6
}
func (o *TCC_Type) SetSYNCBUSY_PER(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x80)|value<<7)
}
func (o *TCC_Type) GetSYNCBUSY_PER() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x80) >> 7
}
func (o *TCC_Type) SetSYNCBUSY_CC0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x100)|value<<8)
}
func (o *TCC_Type) GetSYNCBUSY_CC0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x100) >> 8
}
func (o *TCC_Type) SetSYNCBUSY_CC1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x200)|value<<9)
}
func (o *TCC_Type) GetSYNCBUSY_CC1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x200) >> 9
}
func (o *TCC_Type) SetSYNCBUSY_CC2(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetSYNCBUSY_CC2() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetSYNCBUSY_CC3(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetSYNCBUSY_CC3() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetSYNCBUSY_PATTB(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10000)|value<<16)
}
func (o *TCC_Type) GetSYNCBUSY_PATTB() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10000) >> 16
}
func (o *TCC_Type) SetSYNCBUSY_WAVEB(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20000)|value<<17)
}
func (o *TCC_Type) GetSYNCBUSY_WAVEB() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20000) >> 17
}
func (o *TCC_Type) SetSYNCBUSY_PERB(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x40000)|value<<18)
}
func (o *TCC_Type) GetSYNCBUSY_PERB() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x40000) >> 18
}
func (o *TCC_Type) SetSYNCBUSY_CCB0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x80000)|value<<19)
}
func (o *TCC_Type) GetSYNCBUSY_CCB0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x80000) >> 19
}
func (o *TCC_Type) SetSYNCBUSY_CCB1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x100000)|value<<20)
}
func (o *TCC_Type) GetSYNCBUSY_CCB1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x100000) >> 20
}
func (o *TCC_Type) SetSYNCBUSY_CCB2(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x200000)|value<<21)
}
func (o *TCC_Type) GetSYNCBUSY_CCB2() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x200000) >> 21
}
func (o *TCC_Type) SetSYNCBUSY_CCB3(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x400000)|value<<22)
}
func (o *TCC_Type) GetSYNCBUSY_CCB3() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x400000) >> 22
}

// TCC.FCTRLA: Recoverable Fault A Configuration
func (o *TCC_Type) SetFCTRLA_SRC(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0x3)|value)
}
func (o *TCC_Type) GetFCTRLA_SRC() uint32 {
	return volatile.LoadUint32(&o.FCTRLA.Reg) & 0x3
}
func (o *TCC_Type) SetFCTRLA_KEEP(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetFCTRLA_KEEP() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetFCTRLA_QUAL(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0x10)|value<<4)
}
func (o *TCC_Type) GetFCTRLA_QUAL() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0x10) >> 4
}
func (o *TCC_Type) SetFCTRLA_BLANK(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0x60)|value<<5)
}
func (o *TCC_Type) GetFCTRLA_BLANK() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0x60) >> 5
}
func (o *TCC_Type) SetFCTRLA_RESTART(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0x80)|value<<7)
}
func (o *TCC_Type) GetFCTRLA_RESTART() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0x80) >> 7
}
func (o *TCC_Type) SetFCTRLA_HALT(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0x300)|value<<8)
}
func (o *TCC_Type) GetFCTRLA_HALT() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0x300) >> 8
}
func (o *TCC_Type) SetFCTRLA_CHSEL(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0xc00)|value<<10)
}
func (o *TCC_Type) GetFCTRLA_CHSEL() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0xc00) >> 10
}
func (o *TCC_Type) SetFCTRLA_CAPTURE(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0x7000)|value<<12)
}
func (o *TCC_Type) GetFCTRLA_CAPTURE() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0x7000) >> 12
}
func (o *TCC_Type) SetFCTRLA_BLANKVAL(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0xff0000)|value<<16)
}
func (o *TCC_Type) GetFCTRLA_BLANKVAL() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0xff0000) >> 16
}
func (o *TCC_Type) SetFCTRLA_FILTERVAL(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0xf000000)|value<<24)
}
func (o *TCC_Type) GetFCTRLA_FILTERVAL() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0xf000000) >> 24
}

// TCC.FCTRLB: Recoverable Fault B Configuration
func (o *TCC_Type) SetFCTRLB_SRC(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0x3)|value)
}
func (o *TCC_Type) GetFCTRLB_SRC() uint32 {
	return volatile.LoadUint32(&o.FCTRLB.Reg) & 0x3
}
func (o *TCC_Type) SetFCTRLB_KEEP(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetFCTRLB_KEEP() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetFCTRLB_QUAL(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0x10)|value<<4)
}
func (o *TCC_Type) GetFCTRLB_QUAL() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0x10) >> 4
}
func (o *TCC_Type) SetFCTRLB_BLANK(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0x60)|value<<5)
}
func (o *TCC_Type) GetFCTRLB_BLANK() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0x60) >> 5
}
func (o *TCC_Type) SetFCTRLB_RESTART(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0x80)|value<<7)
}
func (o *TCC_Type) GetFCTRLB_RESTART() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0x80) >> 7
}
func (o *TCC_Type) SetFCTRLB_HALT(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0x300)|value<<8)
}
func (o *TCC_Type) GetFCTRLB_HALT() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0x300) >> 8
}
func (o *TCC_Type) SetFCTRLB_CHSEL(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0xc00)|value<<10)
}
func (o *TCC_Type) GetFCTRLB_CHSEL() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0xc00) >> 10
}
func (o *TCC_Type) SetFCTRLB_CAPTURE(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0x7000)|value<<12)
}
func (o *TCC_Type) GetFCTRLB_CAPTURE() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0x7000) >> 12
}
func (o *TCC_Type) SetFCTRLB_BLANKVAL(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0xff0000)|value<<16)
}
func (o *TCC_Type) GetFCTRLB_BLANKVAL() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0xff0000) >> 16
}
func (o *TCC_Type) SetFCTRLB_FILTERVAL(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0xf000000)|value<<24)
}
func (o *TCC_Type) GetFCTRLB_FILTERVAL() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0xf000000) >> 24
}

// TCC.WEXCTRL: Waveform Extension Configuration
func (o *TCC_Type) SetWEXCTRL_OTMX(value uint32) {
	volatile.StoreUint32(&o.WEXCTRL.Reg, volatile.LoadUint32(&o.WEXCTRL.Reg)&^(0x3)|value)
}
func (o *TCC_Type) GetWEXCTRL_OTMX() uint32 {
	return volatile.LoadUint32(&o.WEXCTRL.Reg) & 0x3
}
func (o *TCC_Type) SetWEXCTRL_DTIEN0(value uint32) {
	volatile.StoreUint32(&o.WEXCTRL.Reg, volatile.LoadUint32(&o.WEXCTRL.Reg)&^(0x100)|value<<8)
}
func (o *TCC_Type) GetWEXCTRL_DTIEN0() uint32 {
	return (volatile.LoadUint32(&o.WEXCTRL.Reg) & 0x100) >> 8
}
func (o *TCC_Type) SetWEXCTRL_DTIEN1(value uint32) {
	volatile.StoreUint32(&o.WEXCTRL.Reg, volatile.LoadUint32(&o.WEXCTRL.Reg)&^(0x200)|value<<9)
}
func (o *TCC_Type) GetWEXCTRL_DTIEN1() uint32 {
	return (volatile.LoadUint32(&o.WEXCTRL.Reg) & 0x200) >> 9
}
func (o *TCC_Type) SetWEXCTRL_DTIEN2(value uint32) {
	volatile.StoreUint32(&o.WEXCTRL.Reg, volatile.LoadUint32(&o.WEXCTRL.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetWEXCTRL_DTIEN2() uint32 {
	return (volatile.LoadUint32(&o.WEXCTRL.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetWEXCTRL_DTIEN3(value uint32) {
	volatile.StoreUint32(&o.WEXCTRL.Reg, volatile.LoadUint32(&o.WEXCTRL.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetWEXCTRL_DTIEN3() uint32 {
	return (volatile.LoadUint32(&o.WEXCTRL.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetWEXCTRL_DTLS(value uint32) {
	volatile.StoreUint32(&o.WEXCTRL.Reg, volatile.LoadUint32(&o.WEXCTRL.Reg)&^(0xff0000)|value<<16)
}
func (o *TCC_Type) GetWEXCTRL_DTLS() uint32 {
	return (volatile.LoadUint32(&o.WEXCTRL.Reg) & 0xff0000) >> 16
}
func (o *TCC_Type) SetWEXCTRL_DTHS(value uint32) {
	volatile.StoreUint32(&o.WEXCTRL.Reg, volatile.LoadUint32(&o.WEXCTRL.Reg)&^(0xff000000)|value<<24)
}
func (o *TCC_Type) GetWEXCTRL_DTHS() uint32 {
	return (volatile.LoadUint32(&o.WEXCTRL.Reg) & 0xff000000) >> 24
}

// TCC.DRVCTRL: Driver Control
func (o *TCC_Type) SetDRVCTRL_NRE0(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetDRVCTRL_NRE0() uint32 {
	return volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x1
}
func (o *TCC_Type) SetDRVCTRL_NRE1(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetDRVCTRL_NRE1() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetDRVCTRL_NRE2(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetDRVCTRL_NRE2() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetDRVCTRL_NRE3(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetDRVCTRL_NRE3() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetDRVCTRL_NRE4(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *TCC_Type) GetDRVCTRL_NRE4() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x10) >> 4
}
func (o *TCC_Type) SetDRVCTRL_NRE5(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *TCC_Type) GetDRVCTRL_NRE5() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x20) >> 5
}
func (o *TCC_Type) SetDRVCTRL_NRE6(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x40)|value<<6)
}
func (o *TCC_Type) GetDRVCTRL_NRE6() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x40) >> 6
}
func (o *TCC_Type) SetDRVCTRL_NRE7(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x80)|value<<7)
}
func (o *TCC_Type) GetDRVCTRL_NRE7() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x80) >> 7
}
func (o *TCC_Type) SetDRVCTRL_NRV0(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *TCC_Type) GetDRVCTRL_NRV0() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x100) >> 8
}
func (o *TCC_Type) SetDRVCTRL_NRV1(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x200)|value<<9)
}
func (o *TCC_Type) GetDRVCTRL_NRV1() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x200) >> 9
}
func (o *TCC_Type) SetDRVCTRL_NRV2(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetDRVCTRL_NRV2() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetDRVCTRL_NRV3(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetDRVCTRL_NRV3() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetDRVCTRL_NRV4(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *TCC_Type) GetDRVCTRL_NRV4() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x1000) >> 12
}
func (o *TCC_Type) SetDRVCTRL_NRV5(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *TCC_Type) GetDRVCTRL_NRV5() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x2000) >> 13
}
func (o *TCC_Type) SetDRVCTRL_NRV6(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *TCC_Type) GetDRVCTRL_NRV6() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x4000) >> 14
}
func (o *TCC_Type) SetDRVCTRL_NRV7(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetDRVCTRL_NRV7() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x8000) >> 15
}
func (o *TCC_Type) SetDRVCTRL_INVEN0(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *TCC_Type) GetDRVCTRL_INVEN0() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x10000) >> 16
}
func (o *TCC_Type) SetDRVCTRL_INVEN1(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x20000)|value<<17)
}
func (o *TCC_Type) GetDRVCTRL_INVEN1() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x20000) >> 17
}
func (o *TCC_Type) SetDRVCTRL_INVEN2(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x40000)|value<<18)
}
func (o *TCC_Type) GetDRVCTRL_INVEN2() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x40000) >> 18
}
func (o *TCC_Type) SetDRVCTRL_INVEN3(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x80000)|value<<19)
}
func (o *TCC_Type) GetDRVCTRL_INVEN3() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x80000) >> 19
}
func (o *TCC_Type) SetDRVCTRL_INVEN4(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x100000)|value<<20)
}
func (o *TCC_Type) GetDRVCTRL_INVEN4() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x100000) >> 20
}
func (o *TCC_Type) SetDRVCTRL_INVEN5(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x200000)|value<<21)
}
func (o *TCC_Type) GetDRVCTRL_INVEN5() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x200000) >> 21
}
func (o *TCC_Type) SetDRVCTRL_INVEN6(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x400000)|value<<22)
}
func (o *TCC_Type) GetDRVCTRL_INVEN6() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x400000) >> 22
}
func (o *TCC_Type) SetDRVCTRL_INVEN7(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x800000)|value<<23)
}
func (o *TCC_Type) GetDRVCTRL_INVEN7() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x800000) >> 23
}
func (o *TCC_Type) SetDRVCTRL_FILTERVAL0(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0xf000000)|value<<24)
}
func (o *TCC_Type) GetDRVCTRL_FILTERVAL0() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0xf000000) >> 24
}
func (o *TCC_Type) SetDRVCTRL_FILTERVAL1(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *TCC_Type) GetDRVCTRL_FILTERVAL1() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0xf0000000) >> 28
}

// TCC.DBGCTRL: Debug Control
func (o *TCC_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}
func (o *TCC_Type) SetDBGCTRL_FDDBD(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetDBGCTRL_FDDBD() uint8 {
	return (volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x4) >> 2
}

// TCC.EVCTRL: Event Control
func (o *TCC_Type) SetEVCTRL_EVACT0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x7)|value)
}
func (o *TCC_Type) GetEVCTRL_EVACT0() uint32 {
	return volatile.LoadUint32(&o.EVCTRL.Reg) & 0x7
}
func (o *TCC_Type) SetEVCTRL_EVACT1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x38)|value<<3)
}
func (o *TCC_Type) GetEVCTRL_EVACT1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x38) >> 3
}
func (o *TCC_Type) SetEVCTRL_CNTSEL(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *TCC_Type) GetEVCTRL_CNTSEL() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0xc0) >> 6
}
func (o *TCC_Type) SetEVCTRL_OVFEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *TCC_Type) GetEVCTRL_OVFEO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *TCC_Type) SetEVCTRL_TRGEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x200)|value<<9)
}
func (o *TCC_Type) GetEVCTRL_TRGEO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x200) >> 9
}
func (o *TCC_Type) SetEVCTRL_CNTEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetEVCTRL_CNTEO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetEVCTRL_TCINV0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *TCC_Type) GetEVCTRL_TCINV0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1000) >> 12
}
func (o *TCC_Type) SetEVCTRL_TCINV1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *TCC_Type) GetEVCTRL_TCINV1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x2000) >> 13
}
func (o *TCC_Type) SetEVCTRL_TCEI0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *TCC_Type) GetEVCTRL_TCEI0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x4000) >> 14
}
func (o *TCC_Type) SetEVCTRL_TCEI1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetEVCTRL_TCEI1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8000) >> 15
}
func (o *TCC_Type) SetEVCTRL_MCEI0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *TCC_Type) GetEVCTRL_MCEI0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x10000) >> 16
}
func (o *TCC_Type) SetEVCTRL_MCEI1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x20000)|value<<17)
}
func (o *TCC_Type) GetEVCTRL_MCEI1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x20000) >> 17
}
func (o *TCC_Type) SetEVCTRL_MCEI2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x40000)|value<<18)
}
func (o *TCC_Type) GetEVCTRL_MCEI2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x40000) >> 18
}
func (o *TCC_Type) SetEVCTRL_MCEI3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x80000)|value<<19)
}
func (o *TCC_Type) GetEVCTRL_MCEI3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x80000) >> 19
}
func (o *TCC_Type) SetEVCTRL_MCEO0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *TCC_Type) GetEVCTRL_MCEO0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1000000) >> 24
}
func (o *TCC_Type) SetEVCTRL_MCEO1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *TCC_Type) GetEVCTRL_MCEO1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x2000000) >> 25
}
func (o *TCC_Type) SetEVCTRL_MCEO2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *TCC_Type) GetEVCTRL_MCEO2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x4000000) >> 26
}
func (o *TCC_Type) SetEVCTRL_MCEO3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *TCC_Type) GetEVCTRL_MCEO3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8000000) >> 27
}

// TCC.INTENCLR: Interrupt Enable Clear
func (o *TCC_Type) SetINTENCLR_OVF(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetINTENCLR_OVF() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *TCC_Type) SetINTENCLR_TRG(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetINTENCLR_TRG() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetINTENCLR_CNT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetINTENCLR_CNT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetINTENCLR_ERR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetINTENCLR_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetINTENCLR_DFS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetINTENCLR_DFS() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetINTENCLR_FAULTA(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *TCC_Type) GetINTENCLR_FAULTA() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *TCC_Type) SetINTENCLR_FAULTB(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *TCC_Type) GetINTENCLR_FAULTB() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *TCC_Type) SetINTENCLR_FAULT0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *TCC_Type) GetINTENCLR_FAULT0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *TCC_Type) SetINTENCLR_FAULT1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetINTENCLR_FAULT1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}
func (o *TCC_Type) SetINTENCLR_MC0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *TCC_Type) GetINTENCLR_MC0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *TCC_Type) SetINTENCLR_MC1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *TCC_Type) GetINTENCLR_MC1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *TCC_Type) SetINTENCLR_MC2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *TCC_Type) GetINTENCLR_MC2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *TCC_Type) SetINTENCLR_MC3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *TCC_Type) GetINTENCLR_MC3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}

// TCC.INTENSET: Interrupt Enable Set
func (o *TCC_Type) SetINTENSET_OVF(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetINTENSET_OVF() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *TCC_Type) SetINTENSET_TRG(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetINTENSET_TRG() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetINTENSET_CNT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetINTENSET_CNT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetINTENSET_ERR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetINTENSET_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetINTENSET_DFS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetINTENSET_DFS() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetINTENSET_FAULTA(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *TCC_Type) GetINTENSET_FAULTA() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *TCC_Type) SetINTENSET_FAULTB(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *TCC_Type) GetINTENSET_FAULTB() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *TCC_Type) SetINTENSET_FAULT0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *TCC_Type) GetINTENSET_FAULT0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *TCC_Type) SetINTENSET_FAULT1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetINTENSET_FAULT1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}
func (o *TCC_Type) SetINTENSET_MC0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *TCC_Type) GetINTENSET_MC0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *TCC_Type) SetINTENSET_MC1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *TCC_Type) GetINTENSET_MC1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *TCC_Type) SetINTENSET_MC2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *TCC_Type) GetINTENSET_MC2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *TCC_Type) SetINTENSET_MC3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *TCC_Type) GetINTENSET_MC3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}

// TCC.INTFLAG: Interrupt Flag Status and Clear
func (o *TCC_Type) SetINTFLAG_OVF(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetINTFLAG_OVF() uint32 {
	return volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1
}
func (o *TCC_Type) SetINTFLAG_TRG(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetINTFLAG_TRG() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetINTFLAG_CNT(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetINTFLAG_CNT() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetINTFLAG_ERR(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetINTFLAG_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetINTFLAG_DFS(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetINTFLAG_DFS() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetINTFLAG_FAULTA(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1000)|value<<12)
}
func (o *TCC_Type) GetINTFLAG_FAULTA() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1000) >> 12
}
func (o *TCC_Type) SetINTFLAG_FAULTB(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x2000)|value<<13)
}
func (o *TCC_Type) GetINTFLAG_FAULTB() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x2000) >> 13
}
func (o *TCC_Type) SetINTFLAG_FAULT0(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x4000)|value<<14)
}
func (o *TCC_Type) GetINTFLAG_FAULT0() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x4000) >> 14
}
func (o *TCC_Type) SetINTFLAG_FAULT1(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetINTFLAG_FAULT1() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x8000) >> 15
}
func (o *TCC_Type) SetINTFLAG_MC0(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x10000)|value<<16)
}
func (o *TCC_Type) GetINTFLAG_MC0() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x10000) >> 16
}
func (o *TCC_Type) SetINTFLAG_MC1(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x20000)|value<<17)
}
func (o *TCC_Type) GetINTFLAG_MC1() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x20000) >> 17
}
func (o *TCC_Type) SetINTFLAG_MC2(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x40000)|value<<18)
}
func (o *TCC_Type) GetINTFLAG_MC2() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x40000) >> 18
}
func (o *TCC_Type) SetINTFLAG_MC3(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x80000)|value<<19)
}
func (o *TCC_Type) GetINTFLAG_MC3() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x80000) >> 19
}

// TCC.STATUS: Status
func (o *TCC_Type) SetSTATUS_STOP(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetSTATUS_STOP() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *TCC_Type) SetSTATUS_IDX(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetSTATUS_IDX() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetSTATUS_DFS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetSTATUS_DFS() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetSTATUS_SLAVE(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *TCC_Type) GetSTATUS_SLAVE() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *TCC_Type) SetSTATUS_PATTBV(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *TCC_Type) GetSTATUS_PATTBV() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20) >> 5
}
func (o *TCC_Type) SetSTATUS_WAVEBV(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *TCC_Type) GetSTATUS_WAVEBV() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x40) >> 6
}
func (o *TCC_Type) SetSTATUS_PERBV(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *TCC_Type) GetSTATUS_PERBV() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80) >> 7
}
func (o *TCC_Type) SetSTATUS_FAULTAIN(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *TCC_Type) GetSTATUS_FAULTAIN() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x100) >> 8
}
func (o *TCC_Type) SetSTATUS_FAULTBIN(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *TCC_Type) GetSTATUS_FAULTBIN() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *TCC_Type) SetSTATUS_FAULT0IN(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetSTATUS_FAULT0IN() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetSTATUS_FAULT1IN(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetSTATUS_FAULT1IN() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetSTATUS_FAULTA(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *TCC_Type) GetSTATUS_FAULTA() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x1000) >> 12
}
func (o *TCC_Type) SetSTATUS_FAULTB(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *TCC_Type) GetSTATUS_FAULTB() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2000) >> 13
}
func (o *TCC_Type) SetSTATUS_FAULT0(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4000)|value<<14)
}
func (o *TCC_Type) GetSTATUS_FAULT0() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4000) >> 14
}
func (o *TCC_Type) SetSTATUS_FAULT1(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetSTATUS_FAULT1() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8000) >> 15
}
func (o *TCC_Type) SetSTATUS_CCBV0(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10000)|value<<16)
}
func (o *TCC_Type) GetSTATUS_CCBV0() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10000) >> 16
}
func (o *TCC_Type) SetSTATUS_CCBV1(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *TCC_Type) GetSTATUS_CCBV1() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20000) >> 17
}
func (o *TCC_Type) SetSTATUS_CCBV2(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x40000)|value<<18)
}
func (o *TCC_Type) GetSTATUS_CCBV2() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x40000) >> 18
}
func (o *TCC_Type) SetSTATUS_CCBV3(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *TCC_Type) GetSTATUS_CCBV3() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80000) >> 19
}
func (o *TCC_Type) SetSTATUS_CMP0(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *TCC_Type) GetSTATUS_CMP0() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x1000000) >> 24
}
func (o *TCC_Type) SetSTATUS_CMP1(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2000000)|value<<25)
}
func (o *TCC_Type) GetSTATUS_CMP1() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2000000) >> 25
}
func (o *TCC_Type) SetSTATUS_CMP2(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *TCC_Type) GetSTATUS_CMP2() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4000000) >> 26
}
func (o *TCC_Type) SetSTATUS_CMP3(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8000000)|value<<27)
}
func (o *TCC_Type) GetSTATUS_CMP3() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8000000) >> 27
}

// TCC.COUNT: Count
func (o *TCC_Type) SetCOUNT(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, volatile.LoadUint32(&o.COUNT.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetCOUNT() uint32 {
	return volatile.LoadUint32(&o.COUNT.Reg) & 0xffffff
}

// TCC.PATT: Pattern
func (o *TCC_Type) SetPATT_PGE0(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetPATT_PGE0() uint16 {
	return volatile.LoadUint16(&o.PATT.Reg) & 0x1
}
func (o *TCC_Type) SetPATT_PGE1(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetPATT_PGE1() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetPATT_PGE2(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetPATT_PGE2() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetPATT_PGE3(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetPATT_PGE3() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetPATT_PGE4(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x10)|value<<4)
}
func (o *TCC_Type) GetPATT_PGE4() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x10) >> 4
}
func (o *TCC_Type) SetPATT_PGE5(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x20)|value<<5)
}
func (o *TCC_Type) GetPATT_PGE5() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x20) >> 5
}
func (o *TCC_Type) SetPATT_PGE6(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x40)|value<<6)
}
func (o *TCC_Type) GetPATT_PGE6() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x40) >> 6
}
func (o *TCC_Type) SetPATT_PGE7(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x80)|value<<7)
}
func (o *TCC_Type) GetPATT_PGE7() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x80) >> 7
}
func (o *TCC_Type) SetPATT_PGV0(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x100)|value<<8)
}
func (o *TCC_Type) GetPATT_PGV0() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x100) >> 8
}
func (o *TCC_Type) SetPATT_PGV1(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x200)|value<<9)
}
func (o *TCC_Type) GetPATT_PGV1() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x200) >> 9
}
func (o *TCC_Type) SetPATT_PGV2(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetPATT_PGV2() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetPATT_PGV3(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetPATT_PGV3() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetPATT_PGV4(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x1000)|value<<12)
}
func (o *TCC_Type) GetPATT_PGV4() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x1000) >> 12
}
func (o *TCC_Type) SetPATT_PGV5(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x2000)|value<<13)
}
func (o *TCC_Type) GetPATT_PGV5() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x2000) >> 13
}
func (o *TCC_Type) SetPATT_PGV6(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x4000)|value<<14)
}
func (o *TCC_Type) GetPATT_PGV6() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x4000) >> 14
}
func (o *TCC_Type) SetPATT_PGV7(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetPATT_PGV7() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x8000) >> 15
}

// TCC.WAVE: Waveform Control
func (o *TCC_Type) SetWAVE_WAVEGEN(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x7)|value)
}
func (o *TCC_Type) GetWAVE_WAVEGEN() uint32 {
	return volatile.LoadUint32(&o.WAVE.Reg) & 0x7
}
func (o *TCC_Type) SetWAVE_RAMP(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x30)|value<<4)
}
func (o *TCC_Type) GetWAVE_RAMP() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x30) >> 4
}
func (o *TCC_Type) SetWAVE_CIPEREN(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x80)|value<<7)
}
func (o *TCC_Type) GetWAVE_CIPEREN() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x80) >> 7
}
func (o *TCC_Type) SetWAVE_CICCEN0(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x100)|value<<8)
}
func (o *TCC_Type) GetWAVE_CICCEN0() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x100) >> 8
}
func (o *TCC_Type) SetWAVE_CICCEN1(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x200)|value<<9)
}
func (o *TCC_Type) GetWAVE_CICCEN1() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x200) >> 9
}
func (o *TCC_Type) SetWAVE_CICCEN2(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetWAVE_CICCEN2() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetWAVE_CICCEN3(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetWAVE_CICCEN3() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetWAVE_POL0(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x10000)|value<<16)
}
func (o *TCC_Type) GetWAVE_POL0() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x10000) >> 16
}
func (o *TCC_Type) SetWAVE_POL1(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x20000)|value<<17)
}
func (o *TCC_Type) GetWAVE_POL1() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x20000) >> 17
}
func (o *TCC_Type) SetWAVE_POL2(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x40000)|value<<18)
}
func (o *TCC_Type) GetWAVE_POL2() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x40000) >> 18
}
func (o *TCC_Type) SetWAVE_POL3(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x80000)|value<<19)
}
func (o *TCC_Type) GetWAVE_POL3() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x80000) >> 19
}
func (o *TCC_Type) SetWAVE_SWAP0(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x1000000)|value<<24)
}
func (o *TCC_Type) GetWAVE_SWAP0() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x1000000) >> 24
}
func (o *TCC_Type) SetWAVE_SWAP1(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x2000000)|value<<25)
}
func (o *TCC_Type) GetWAVE_SWAP1() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x2000000) >> 25
}
func (o *TCC_Type) SetWAVE_SWAP2(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x4000000)|value<<26)
}
func (o *TCC_Type) GetWAVE_SWAP2() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x4000000) >> 26
}
func (o *TCC_Type) SetWAVE_SWAP3(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x8000000)|value<<27)
}
func (o *TCC_Type) GetWAVE_SWAP3() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x8000000) >> 27
}

// TCC.PER: Period
func (o *TCC_Type) SetPER(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetPER() uint32 {
	return volatile.LoadUint32(&o.PER.Reg) & 0xffffff
}

// TCC.CC0: Compare and Capture
func (o *TCC_Type) SetCC0_CC(value uint32) {
	volatile.StoreUint32(&o.CC0.Reg, volatile.LoadUint32(&o.CC0.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetCC0_CC() uint32 {
	return volatile.LoadUint32(&o.CC0.Reg) & 0xffffff
}

// TCC.CC1: Compare and Capture
func (o *TCC_Type) SetCC1_CC(value uint32) {
	volatile.StoreUint32(&o.CC1.Reg, volatile.LoadUint32(&o.CC1.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetCC1_CC() uint32 {
	return volatile.LoadUint32(&o.CC1.Reg) & 0xffffff
}

// TCC.CC2: Compare and Capture
func (o *TCC_Type) SetCC2_CC(value uint32) {
	volatile.StoreUint32(&o.CC2.Reg, volatile.LoadUint32(&o.CC2.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetCC2_CC() uint32 {
	return volatile.LoadUint32(&o.CC2.Reg) & 0xffffff
}

// TCC.CC3: Compare and Capture
func (o *TCC_Type) SetCC3_CC(value uint32) {
	volatile.StoreUint32(&o.CC3.Reg, volatile.LoadUint32(&o.CC3.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetCC3_CC() uint32 {
	return volatile.LoadUint32(&o.CC3.Reg) & 0xffffff
}

// TCC.PATTB: Pattern Buffer
func (o *TCC_Type) SetPATTB_PGEB0(value uint16) {
	volatile.StoreUint16(&o.PATTB.Reg, volatile.LoadUint16(&o.PATTB.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetPATTB_PGEB0() uint16 {
	return volatile.LoadUint16(&o.PATTB.Reg) & 0x1
}
func (o *TCC_Type) SetPATTB_PGEB1(value uint16) {
	volatile.StoreUint16(&o.PATTB.Reg, volatile.LoadUint16(&o.PATTB.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetPATTB_PGEB1() uint16 {
	return (volatile.LoadUint16(&o.PATTB.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetPATTB_PGEB2(value uint16) {
	volatile.StoreUint16(&o.PATTB.Reg, volatile.LoadUint16(&o.PATTB.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetPATTB_PGEB2() uint16 {
	return (volatile.LoadUint16(&o.PATTB.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetPATTB_PGEB3(value uint16) {
	volatile.StoreUint16(&o.PATTB.Reg, volatile.LoadUint16(&o.PATTB.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetPATTB_PGEB3() uint16 {
	return (volatile.LoadUint16(&o.PATTB.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetPATTB_PGEB4(value uint16) {
	volatile.StoreUint16(&o.PATTB.Reg, volatile.LoadUint16(&o.PATTB.Reg)&^(0x10)|value<<4)
}
func (o *TCC_Type) GetPATTB_PGEB4() uint16 {
	return (volatile.LoadUint16(&o.PATTB.Reg) & 0x10) >> 4
}
func (o *TCC_Type) SetPATTB_PGEB5(value uint16) {
	volatile.StoreUint16(&o.PATTB.Reg, volatile.LoadUint16(&o.PATTB.Reg)&^(0x20)|value<<5)
}
func (o *TCC_Type) GetPATTB_PGEB5() uint16 {
	return (volatile.LoadUint16(&o.PATTB.Reg) & 0x20) >> 5
}
func (o *TCC_Type) SetPATTB_PGEB6(value uint16) {
	volatile.StoreUint16(&o.PATTB.Reg, volatile.LoadUint16(&o.PATTB.Reg)&^(0x40)|value<<6)
}
func (o *TCC_Type) GetPATTB_PGEB6() uint16 {
	return (volatile.LoadUint16(&o.PATTB.Reg) & 0x40) >> 6
}
func (o *TCC_Type) SetPATTB_PGEB7(value uint16) {
	volatile.StoreUint16(&o.PATTB.Reg, volatile.LoadUint16(&o.PATTB.Reg)&^(0x80)|value<<7)
}
func (o *TCC_Type) GetPATTB_PGEB7() uint16 {
	return (volatile.LoadUint16(&o.PATTB.Reg) & 0x80) >> 7
}
func (o *TCC_Type) SetPATTB_PGVB0(value uint16) {
	volatile.StoreUint16(&o.PATTB.Reg, volatile.LoadUint16(&o.PATTB.Reg)&^(0x100)|value<<8)
}
func (o *TCC_Type) GetPATTB_PGVB0() uint16 {
	return (volatile.LoadUint16(&o.PATTB.Reg) & 0x100) >> 8
}
func (o *TCC_Type) SetPATTB_PGVB1(value uint16) {
	volatile.StoreUint16(&o.PATTB.Reg, volatile.LoadUint16(&o.PATTB.Reg)&^(0x200)|value<<9)
}
func (o *TCC_Type) GetPATTB_PGVB1() uint16 {
	return (volatile.LoadUint16(&o.PATTB.Reg) & 0x200) >> 9
}
func (o *TCC_Type) SetPATTB_PGVB2(value uint16) {
	volatile.StoreUint16(&o.PATTB.Reg, volatile.LoadUint16(&o.PATTB.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetPATTB_PGVB2() uint16 {
	return (volatile.LoadUint16(&o.PATTB.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetPATTB_PGVB3(value uint16) {
	volatile.StoreUint16(&o.PATTB.Reg, volatile.LoadUint16(&o.PATTB.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetPATTB_PGVB3() uint16 {
	return (volatile.LoadUint16(&o.PATTB.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetPATTB_PGVB4(value uint16) {
	volatile.StoreUint16(&o.PATTB.Reg, volatile.LoadUint16(&o.PATTB.Reg)&^(0x1000)|value<<12)
}
func (o *TCC_Type) GetPATTB_PGVB4() uint16 {
	return (volatile.LoadUint16(&o.PATTB.Reg) & 0x1000) >> 12
}
func (o *TCC_Type) SetPATTB_PGVB5(value uint16) {
	volatile.StoreUint16(&o.PATTB.Reg, volatile.LoadUint16(&o.PATTB.Reg)&^(0x2000)|value<<13)
}
func (o *TCC_Type) GetPATTB_PGVB5() uint16 {
	return (volatile.LoadUint16(&o.PATTB.Reg) & 0x2000) >> 13
}
func (o *TCC_Type) SetPATTB_PGVB6(value uint16) {
	volatile.StoreUint16(&o.PATTB.Reg, volatile.LoadUint16(&o.PATTB.Reg)&^(0x4000)|value<<14)
}
func (o *TCC_Type) GetPATTB_PGVB6() uint16 {
	return (volatile.LoadUint16(&o.PATTB.Reg) & 0x4000) >> 14
}
func (o *TCC_Type) SetPATTB_PGVB7(value uint16) {
	volatile.StoreUint16(&o.PATTB.Reg, volatile.LoadUint16(&o.PATTB.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetPATTB_PGVB7() uint16 {
	return (volatile.LoadUint16(&o.PATTB.Reg) & 0x8000) >> 15
}

// TCC.WAVEB: Waveform Control Buffer
func (o *TCC_Type) SetWAVEB_WAVEGENB(value uint32) {
	volatile.StoreUint32(&o.WAVEB.Reg, volatile.LoadUint32(&o.WAVEB.Reg)&^(0x7)|value)
}
func (o *TCC_Type) GetWAVEB_WAVEGENB() uint32 {
	return volatile.LoadUint32(&o.WAVEB.Reg) & 0x7
}
func (o *TCC_Type) SetWAVEB_RAMPB(value uint32) {
	volatile.StoreUint32(&o.WAVEB.Reg, volatile.LoadUint32(&o.WAVEB.Reg)&^(0x30)|value<<4)
}
func (o *TCC_Type) GetWAVEB_RAMPB() uint32 {
	return (volatile.LoadUint32(&o.WAVEB.Reg) & 0x30) >> 4
}
func (o *TCC_Type) SetWAVEB_CIPERENB(value uint32) {
	volatile.StoreUint32(&o.WAVEB.Reg, volatile.LoadUint32(&o.WAVEB.Reg)&^(0x80)|value<<7)
}
func (o *TCC_Type) GetWAVEB_CIPERENB() uint32 {
	return (volatile.LoadUint32(&o.WAVEB.Reg) & 0x80) >> 7
}
func (o *TCC_Type) SetWAVEB_CICCENB0(value uint32) {
	volatile.StoreUint32(&o.WAVEB.Reg, volatile.LoadUint32(&o.WAVEB.Reg)&^(0x100)|value<<8)
}
func (o *TCC_Type) GetWAVEB_CICCENB0() uint32 {
	return (volatile.LoadUint32(&o.WAVEB.Reg) & 0x100) >> 8
}
func (o *TCC_Type) SetWAVEB_CICCENB1(value uint32) {
	volatile.StoreUint32(&o.WAVEB.Reg, volatile.LoadUint32(&o.WAVEB.Reg)&^(0x200)|value<<9)
}
func (o *TCC_Type) GetWAVEB_CICCENB1() uint32 {
	return (volatile.LoadUint32(&o.WAVEB.Reg) & 0x200) >> 9
}
func (o *TCC_Type) SetWAVEB_CICCENB2(value uint32) {
	volatile.StoreUint32(&o.WAVEB.Reg, volatile.LoadUint32(&o.WAVEB.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetWAVEB_CICCENB2() uint32 {
	return (volatile.LoadUint32(&o.WAVEB.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetWAVEB_CICCENB3(value uint32) {
	volatile.StoreUint32(&o.WAVEB.Reg, volatile.LoadUint32(&o.WAVEB.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetWAVEB_CICCENB3() uint32 {
	return (volatile.LoadUint32(&o.WAVEB.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetWAVEB_POLB0(value uint32) {
	volatile.StoreUint32(&o.WAVEB.Reg, volatile.LoadUint32(&o.WAVEB.Reg)&^(0x10000)|value<<16)
}
func (o *TCC_Type) GetWAVEB_POLB0() uint32 {
	return (volatile.LoadUint32(&o.WAVEB.Reg) & 0x10000) >> 16
}
func (o *TCC_Type) SetWAVEB_POLB1(value uint32) {
	volatile.StoreUint32(&o.WAVEB.Reg, volatile.LoadUint32(&o.WAVEB.Reg)&^(0x20000)|value<<17)
}
func (o *TCC_Type) GetWAVEB_POLB1() uint32 {
	return (volatile.LoadUint32(&o.WAVEB.Reg) & 0x20000) >> 17
}
func (o *TCC_Type) SetWAVEB_POLB2(value uint32) {
	volatile.StoreUint32(&o.WAVEB.Reg, volatile.LoadUint32(&o.WAVEB.Reg)&^(0x40000)|value<<18)
}
func (o *TCC_Type) GetWAVEB_POLB2() uint32 {
	return (volatile.LoadUint32(&o.WAVEB.Reg) & 0x40000) >> 18
}
func (o *TCC_Type) SetWAVEB_POLB3(value uint32) {
	volatile.StoreUint32(&o.WAVEB.Reg, volatile.LoadUint32(&o.WAVEB.Reg)&^(0x80000)|value<<19)
}
func (o *TCC_Type) GetWAVEB_POLB3() uint32 {
	return (volatile.LoadUint32(&o.WAVEB.Reg) & 0x80000) >> 19
}
func (o *TCC_Type) SetWAVEB_SWAPB0(value uint32) {
	volatile.StoreUint32(&o.WAVEB.Reg, volatile.LoadUint32(&o.WAVEB.Reg)&^(0x1000000)|value<<24)
}
func (o *TCC_Type) GetWAVEB_SWAPB0() uint32 {
	return (volatile.LoadUint32(&o.WAVEB.Reg) & 0x1000000) >> 24
}
func (o *TCC_Type) SetWAVEB_SWAPB1(value uint32) {
	volatile.StoreUint32(&o.WAVEB.Reg, volatile.LoadUint32(&o.WAVEB.Reg)&^(0x2000000)|value<<25)
}
func (o *TCC_Type) GetWAVEB_SWAPB1() uint32 {
	return (volatile.LoadUint32(&o.WAVEB.Reg) & 0x2000000) >> 25
}
func (o *TCC_Type) SetWAVEB_SWAPB2(value uint32) {
	volatile.StoreUint32(&o.WAVEB.Reg, volatile.LoadUint32(&o.WAVEB.Reg)&^(0x4000000)|value<<26)
}
func (o *TCC_Type) GetWAVEB_SWAPB2() uint32 {
	return (volatile.LoadUint32(&o.WAVEB.Reg) & 0x4000000) >> 26
}
func (o *TCC_Type) SetWAVEB_SWAPB3(value uint32) {
	volatile.StoreUint32(&o.WAVEB.Reg, volatile.LoadUint32(&o.WAVEB.Reg)&^(0x8000000)|value<<27)
}
func (o *TCC_Type) GetWAVEB_SWAPB3() uint32 {
	return (volatile.LoadUint32(&o.WAVEB.Reg) & 0x8000000) >> 27
}

// TCC.PERB: Period Buffer
func (o *TCC_Type) SetPERB(value uint32) {
	volatile.StoreUint32(&o.PERB.Reg, volatile.LoadUint32(&o.PERB.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetPERB() uint32 {
	return volatile.LoadUint32(&o.PERB.Reg) & 0xffffff
}

// TCC.CCB0: Compare and Capture Buffer
func (o *TCC_Type) SetCCB0_CCB(value uint32) {
	volatile.StoreUint32(&o.CCB0.Reg, volatile.LoadUint32(&o.CCB0.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetCCB0_CCB() uint32 {
	return volatile.LoadUint32(&o.CCB0.Reg) & 0xffffff
}

// TCC.CCB1: Compare and Capture Buffer
func (o *TCC_Type) SetCCB1_CCB(value uint32) {
	volatile.StoreUint32(&o.CCB1.Reg, volatile.LoadUint32(&o.CCB1.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetCCB1_CCB() uint32 {
	return volatile.LoadUint32(&o.CCB1.Reg) & 0xffffff
}

// TCC.CCB2: Compare and Capture Buffer
func (o *TCC_Type) SetCCB2_CCB(value uint32) {
	volatile.StoreUint32(&o.CCB2.Reg, volatile.LoadUint32(&o.CCB2.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetCCB2_CCB() uint32 {
	return volatile.LoadUint32(&o.CCB2.Reg) & 0xffffff
}

// TCC.CCB3: Compare and Capture Buffer
func (o *TCC_Type) SetCCB3_CCB(value uint32) {
	volatile.StoreUint32(&o.CCB3.Reg, volatile.LoadUint32(&o.CCB3.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetCCB3_CCB() uint32 {
	return volatile.LoadUint32(&o.CCB3.Reg) & 0xffffff
}

// Universal Serial Bus
type USB_Type struct {
}

// Universal Serial Bus - DEVICE
type USB_DEVICE_Type struct {
	CTRLA        volatile.Register8 // 0x0
	_            byte
	SYNCBUSY     volatile.Register8 // 0x2
	QOSCTRL      volatile.Register8 // 0x3
	_            [4]byte
	CTRLB        volatile.Register16 // 0x8
	DADD         volatile.Register8  // 0xA
	_            byte
	STATUS       volatile.Register8 // 0xC
	FSMSTATUS    volatile.Register8 // 0xD
	_            [2]byte
	FNUM         volatile.Register16 // 0x10
	_            [2]byte
	INTENCLR     volatile.Register16 // 0x14
	_            [2]byte
	INTENSET     volatile.Register16 // 0x18
	_            [2]byte
	INTFLAG      volatile.Register16 // 0x1C
	_            [2]byte
	EPINTSMRY    volatile.Register16 // 0x20
	_            [2]byte
	DESCADD      volatile.Register32 // 0x24
	PADCAL       volatile.Register16 // 0x28
	_            [214]byte
	EPCFG0       volatile.Register8 // 0x100
	_            [3]byte
	EPSTATUSCLR0 volatile.Register8 // 0x104
	EPSTATUSSET0 volatile.Register8 // 0x105
	EPSTATUS0    volatile.Register8 // 0x106
	EPINTFLAG0   volatile.Register8 // 0x107
	EPINTENCLR0  volatile.Register8 // 0x108
	EPINTENSET0  volatile.Register8 // 0x109
	_            [22]byte
	EPCFG1       volatile.Register8 // 0x120
	_            [3]byte
	EPSTATUSCLR1 volatile.Register8 // 0x124
	EPSTATUSSET1 volatile.Register8 // 0x125
	EPSTATUS1    volatile.Register8 // 0x126
	EPINTFLAG1   volatile.Register8 // 0x127
	EPINTENCLR1  volatile.Register8 // 0x128
	EPINTENSET1  volatile.Register8 // 0x129
	_            [22]byte
	EPCFG2       volatile.Register8 // 0x140
	_            [3]byte
	EPSTATUSCLR2 volatile.Register8 // 0x144
	EPSTATUSSET2 volatile.Register8 // 0x145
	EPSTATUS2    volatile.Register8 // 0x146
	EPINTFLAG2   volatile.Register8 // 0x147
	EPINTENCLR2  volatile.Register8 // 0x148
	EPINTENSET2  volatile.Register8 // 0x149
	_            [22]byte
	EPCFG3       volatile.Register8 // 0x160
	_            [3]byte
	EPSTATUSCLR3 volatile.Register8 // 0x164
	EPSTATUSSET3 volatile.Register8 // 0x165
	EPSTATUS3    volatile.Register8 // 0x166
	EPINTFLAG3   volatile.Register8 // 0x167
	EPINTENCLR3  volatile.Register8 // 0x168
	EPINTENSET3  volatile.Register8 // 0x169
	_            [22]byte
	EPCFG4       volatile.Register8 // 0x180
	_            [3]byte
	EPSTATUSCLR4 volatile.Register8 // 0x184
	EPSTATUSSET4 volatile.Register8 // 0x185
	EPSTATUS4    volatile.Register8 // 0x186
	EPINTFLAG4   volatile.Register8 // 0x187
	EPINTENCLR4  volatile.Register8 // 0x188
	EPINTENSET4  volatile.Register8 // 0x189
	_            [22]byte
	EPCFG5       volatile.Register8 // 0x1A0
	_            [3]byte
	EPSTATUSCLR5 volatile.Register8 // 0x1A4
	EPSTATUSSET5 volatile.Register8 // 0x1A5
	EPSTATUS5    volatile.Register8 // 0x1A6
	EPINTFLAG5   volatile.Register8 // 0x1A7
	EPINTENCLR5  volatile.Register8 // 0x1A8
	EPINTENSET5  volatile.Register8 // 0x1A9
	_            [22]byte
	EPCFG6       volatile.Register8 // 0x1C0
	_            [3]byte
	EPSTATUSCLR6 volatile.Register8 // 0x1C4
	EPSTATUSSET6 volatile.Register8 // 0x1C5
	EPSTATUS6    volatile.Register8 // 0x1C6
	EPINTFLAG6   volatile.Register8 // 0x1C7
	EPINTENCLR6  volatile.Register8 // 0x1C8
	EPINTENSET6  volatile.Register8 // 0x1C9
	_            [22]byte
	EPCFG7       volatile.Register8 // 0x1E0
	_            [3]byte
	EPSTATUSCLR7 volatile.Register8 // 0x1E4
	EPSTATUSSET7 volatile.Register8 // 0x1E5
	EPSTATUS7    volatile.Register8 // 0x1E6
	EPINTFLAG7   volatile.Register8 // 0x1E7
	EPINTENCLR7  volatile.Register8 // 0x1E8
	EPINTENSET7  volatile.Register8 // 0x1E9
}

// USB_DEVICE.CTRLA: Control A
func (o *USB_DEVICE_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetCTRLA_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetCTRLA_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetCTRLA_MODE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetCTRLA_MODE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x80) >> 7
}

// USB_DEVICE.SYNCBUSY: Synchronization Busy
func (o *USB_DEVICE_Type) SetSYNCBUSY_SWRST(value uint8) {
	volatile.StoreUint8(&o.SYNCBUSY.Reg, volatile.LoadUint8(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetSYNCBUSY_SWRST() uint8 {
	return volatile.LoadUint8(&o.SYNCBUSY.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetSYNCBUSY_ENABLE(value uint8) {
	volatile.StoreUint8(&o.SYNCBUSY.Reg, volatile.LoadUint8(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetSYNCBUSY_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.SYNCBUSY.Reg) & 0x2) >> 1
}

// USB_DEVICE.QOSCTRL: USB Quality Of Service
func (o *USB_DEVICE_Type) SetQOSCTRL_CQOS(value uint8) {
	volatile.StoreUint8(&o.QOSCTRL.Reg, volatile.LoadUint8(&o.QOSCTRL.Reg)&^(0x3)|value)
}
func (o *USB_DEVICE_Type) GetQOSCTRL_CQOS() uint8 {
	return volatile.LoadUint8(&o.QOSCTRL.Reg) & 0x3
}
func (o *USB_DEVICE_Type) SetQOSCTRL_DQOS(value uint8) {
	volatile.StoreUint8(&o.QOSCTRL.Reg, volatile.LoadUint8(&o.QOSCTRL.Reg)&^(0xc)|value<<2)
}
func (o *USB_DEVICE_Type) GetQOSCTRL_DQOS() uint8 {
	return (volatile.LoadUint8(&o.QOSCTRL.Reg) & 0xc) >> 2
}

// USB_DEVICE.CTRLB: DEVICE Control B
func (o *USB_DEVICE_Type) SetCTRLB_DETACH(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetCTRLB_DETACH() uint16 {
	return volatile.LoadUint16(&o.CTRLB.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetCTRLB_UPRSM(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetCTRLB_UPRSM() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetCTRLB_SPDCONF(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0xc)|value<<2)
}
func (o *USB_DEVICE_Type) GetCTRLB_SPDCONF() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0xc) >> 2
}
func (o *USB_DEVICE_Type) SetCTRLB_NREPLY(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetCTRLB_NREPLY() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetCTRLB_TSTJ(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetCTRLB_TSTJ() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetCTRLB_TSTK(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetCTRLB_TSTK() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetCTRLB_TSTPCKT(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetCTRLB_TSTPCKT() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x80) >> 7
}
func (o *USB_DEVICE_Type) SetCTRLB_OPMODE2(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x100)|value<<8)
}
func (o *USB_DEVICE_Type) GetCTRLB_OPMODE2() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x100) >> 8
}
func (o *USB_DEVICE_Type) SetCTRLB_GNAK(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x200)|value<<9)
}
func (o *USB_DEVICE_Type) GetCTRLB_GNAK() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x200) >> 9
}
func (o *USB_DEVICE_Type) SetCTRLB_LPMHDSK(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0xc00)|value<<10)
}
func (o *USB_DEVICE_Type) GetCTRLB_LPMHDSK() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0xc00) >> 10
}

// USB_DEVICE.DADD: DEVICE Device Address
func (o *USB_DEVICE_Type) SetDADD(value uint8) {
	volatile.StoreUint8(&o.DADD.Reg, volatile.LoadUint8(&o.DADD.Reg)&^(0x7f)|value)
}
func (o *USB_DEVICE_Type) GetDADD() uint8 {
	return volatile.LoadUint8(&o.DADD.Reg) & 0x7f
}
func (o *USB_DEVICE_Type) SetDADD_ADDEN(value uint8) {
	volatile.StoreUint8(&o.DADD.Reg, volatile.LoadUint8(&o.DADD.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetDADD_ADDEN() uint8 {
	return (volatile.LoadUint8(&o.DADD.Reg) & 0x80) >> 7
}

// USB_DEVICE.STATUS: DEVICE Status
func (o *USB_DEVICE_Type) SetSTATUS_SPEED(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0xc)|value<<2)
}
func (o *USB_DEVICE_Type) GetSTATUS_SPEED() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0xc) >> 2
}
func (o *USB_DEVICE_Type) SetSTATUS_LINESTATE(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0xc0)|value<<6)
}
func (o *USB_DEVICE_Type) GetSTATUS_LINESTATE() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0xc0) >> 6
}

// USB_DEVICE.FSMSTATUS: Finite State Machine Status
func (o *USB_DEVICE_Type) SetFSMSTATUS_FSMSTATE(value uint8) {
	volatile.StoreUint8(&o.FSMSTATUS.Reg, volatile.LoadUint8(&o.FSMSTATUS.Reg)&^(0x7f)|value)
}
func (o *USB_DEVICE_Type) GetFSMSTATUS_FSMSTATE() uint8 {
	return volatile.LoadUint8(&o.FSMSTATUS.Reg) & 0x7f
}

// USB_DEVICE.FNUM: DEVICE Device Frame Number
func (o *USB_DEVICE_Type) SetFNUM_MFNUM(value uint16) {
	volatile.StoreUint16(&o.FNUM.Reg, volatile.LoadUint16(&o.FNUM.Reg)&^(0x7)|value)
}
func (o *USB_DEVICE_Type) GetFNUM_MFNUM() uint16 {
	return volatile.LoadUint16(&o.FNUM.Reg) & 0x7
}
func (o *USB_DEVICE_Type) SetFNUM(value uint16) {
	volatile.StoreUint16(&o.FNUM.Reg, volatile.LoadUint16(&o.FNUM.Reg)&^(0x3ff8)|value<<3)
}
func (o *USB_DEVICE_Type) GetFNUM() uint16 {
	return (volatile.LoadUint16(&o.FNUM.Reg) & 0x3ff8) >> 3
}
func (o *USB_DEVICE_Type) SetFNUM_FNCERR(value uint16) {
	volatile.StoreUint16(&o.FNUM.Reg, volatile.LoadUint16(&o.FNUM.Reg)&^(0x8000)|value<<15)
}
func (o *USB_DEVICE_Type) GetFNUM_FNCERR() uint16 {
	return (volatile.LoadUint16(&o.FNUM.Reg) & 0x8000) >> 15
}

// USB_DEVICE.INTENCLR: DEVICE Device Interrupt Enable Clear
func (o *USB_DEVICE_Type) SetINTENCLR_SUSPEND(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetINTENCLR_SUSPEND() uint16 {
	return volatile.LoadUint16(&o.INTENCLR.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetINTENCLR_MSOF(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetINTENCLR_MSOF() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetINTENCLR_SOF(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetINTENCLR_SOF() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetINTENCLR_EORST(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetINTENCLR_EORST() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetINTENCLR_WAKEUP(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetINTENCLR_WAKEUP() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetINTENCLR_EORSM(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetINTENCLR_EORSM() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetINTENCLR_UPRSM(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetINTENCLR_UPRSM() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetINTENCLR_RAMACER(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetINTENCLR_RAMACER() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *USB_DEVICE_Type) SetINTENCLR_LPMNYET(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *USB_DEVICE_Type) GetINTENCLR_LPMNYET() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *USB_DEVICE_Type) SetINTENCLR_LPMSUSP(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *USB_DEVICE_Type) GetINTENCLR_LPMSUSP() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x200) >> 9
}

// USB_DEVICE.INTENSET: DEVICE Device Interrupt Enable Set
func (o *USB_DEVICE_Type) SetINTENSET_SUSPEND(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetINTENSET_SUSPEND() uint16 {
	return volatile.LoadUint16(&o.INTENSET.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetINTENSET_MSOF(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetINTENSET_MSOF() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetINTENSET_SOF(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetINTENSET_SOF() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetINTENSET_EORST(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetINTENSET_EORST() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetINTENSET_WAKEUP(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetINTENSET_WAKEUP() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetINTENSET_EORSM(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetINTENSET_EORSM() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetINTENSET_UPRSM(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetINTENSET_UPRSM() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetINTENSET_RAMACER(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetINTENSET_RAMACER() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *USB_DEVICE_Type) SetINTENSET_LPMNYET(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *USB_DEVICE_Type) GetINTENSET_LPMNYET() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *USB_DEVICE_Type) SetINTENSET_LPMSUSP(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *USB_DEVICE_Type) GetINTENSET_LPMSUSP() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x200) >> 9
}

// USB_DEVICE.INTFLAG: DEVICE Device Interrupt Flag
func (o *USB_DEVICE_Type) SetINTFLAG_SUSPEND(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetINTFLAG_SUSPEND() uint16 {
	return volatile.LoadUint16(&o.INTFLAG.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetINTFLAG_MSOF(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetINTFLAG_MSOF() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetINTFLAG_SOF(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetINTFLAG_SOF() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetINTFLAG_EORST(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetINTFLAG_EORST() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetINTFLAG_WAKEUP(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetINTFLAG_WAKEUP() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetINTFLAG_EORSM(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetINTFLAG_EORSM() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetINTFLAG_UPRSM(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetINTFLAG_UPRSM() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetINTFLAG_RAMACER(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetINTFLAG_RAMACER() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x80) >> 7
}
func (o *USB_DEVICE_Type) SetINTFLAG_LPMNYET(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x100)|value<<8)
}
func (o *USB_DEVICE_Type) GetINTFLAG_LPMNYET() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x100) >> 8
}
func (o *USB_DEVICE_Type) SetINTFLAG_LPMSUSP(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x200)|value<<9)
}
func (o *USB_DEVICE_Type) GetINTFLAG_LPMSUSP() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x200) >> 9
}

// USB_DEVICE.EPINTSMRY: DEVICE End Point Interrupt Summary
func (o *USB_DEVICE_Type) SetEPINTSMRY_EPINT0(value uint16) {
	volatile.StoreUint16(&o.EPINTSMRY.Reg, volatile.LoadUint16(&o.EPINTSMRY.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTSMRY_EPINT0() uint16 {
	return volatile.LoadUint16(&o.EPINTSMRY.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTSMRY_EPINT1(value uint16) {
	volatile.StoreUint16(&o.EPINTSMRY.Reg, volatile.LoadUint16(&o.EPINTSMRY.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTSMRY_EPINT1() uint16 {
	return (volatile.LoadUint16(&o.EPINTSMRY.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTSMRY_EPINT2(value uint16) {
	volatile.StoreUint16(&o.EPINTSMRY.Reg, volatile.LoadUint16(&o.EPINTSMRY.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTSMRY_EPINT2() uint16 {
	return (volatile.LoadUint16(&o.EPINTSMRY.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTSMRY_EPINT3(value uint16) {
	volatile.StoreUint16(&o.EPINTSMRY.Reg, volatile.LoadUint16(&o.EPINTSMRY.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTSMRY_EPINT3() uint16 {
	return (volatile.LoadUint16(&o.EPINTSMRY.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTSMRY_EPINT4(value uint16) {
	volatile.StoreUint16(&o.EPINTSMRY.Reg, volatile.LoadUint16(&o.EPINTSMRY.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTSMRY_EPINT4() uint16 {
	return (volatile.LoadUint16(&o.EPINTSMRY.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTSMRY_EPINT5(value uint16) {
	volatile.StoreUint16(&o.EPINTSMRY.Reg, volatile.LoadUint16(&o.EPINTSMRY.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTSMRY_EPINT5() uint16 {
	return (volatile.LoadUint16(&o.EPINTSMRY.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTSMRY_EPINT6(value uint16) {
	volatile.StoreUint16(&o.EPINTSMRY.Reg, volatile.LoadUint16(&o.EPINTSMRY.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTSMRY_EPINT6() uint16 {
	return (volatile.LoadUint16(&o.EPINTSMRY.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPINTSMRY_EPINT7(value uint16) {
	volatile.StoreUint16(&o.EPINTSMRY.Reg, volatile.LoadUint16(&o.EPINTSMRY.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPINTSMRY_EPINT7() uint16 {
	return (volatile.LoadUint16(&o.EPINTSMRY.Reg) & 0x80) >> 7
}

// USB_DEVICE.DESCADD: Descriptor Address
func (o *USB_DEVICE_Type) SetDESCADD(value uint32) {
	volatile.StoreUint32(&o.DESCADD.Reg, value)
}
func (o *USB_DEVICE_Type) GetDESCADD() uint32 {
	return volatile.LoadUint32(&o.DESCADD.Reg)
}

// USB_DEVICE.PADCAL: USB PAD Calibration
func (o *USB_DEVICE_Type) SetPADCAL_TRANSP(value uint16) {
	volatile.StoreUint16(&o.PADCAL.Reg, volatile.LoadUint16(&o.PADCAL.Reg)&^(0x1f)|value)
}
func (o *USB_DEVICE_Type) GetPADCAL_TRANSP() uint16 {
	return volatile.LoadUint16(&o.PADCAL.Reg) & 0x1f
}
func (o *USB_DEVICE_Type) SetPADCAL_TRANSN(value uint16) {
	volatile.StoreUint16(&o.PADCAL.Reg, volatile.LoadUint16(&o.PADCAL.Reg)&^(0x7c0)|value<<6)
}
func (o *USB_DEVICE_Type) GetPADCAL_TRANSN() uint16 {
	return (volatile.LoadUint16(&o.PADCAL.Reg) & 0x7c0) >> 6
}
func (o *USB_DEVICE_Type) SetPADCAL_TRIM(value uint16) {
	volatile.StoreUint16(&o.PADCAL.Reg, volatile.LoadUint16(&o.PADCAL.Reg)&^(0x7000)|value<<12)
}
func (o *USB_DEVICE_Type) GetPADCAL_TRIM() uint16 {
	return (volatile.LoadUint16(&o.PADCAL.Reg) & 0x7000) >> 12
}

// USB_DEVICE.EPCFG0: DEVICE End Point Configuration
func (o *USB_DEVICE_Type) SetEPCFG0_EPTYPE0(value uint8) {
	volatile.StoreUint8(&o.EPCFG0.Reg, volatile.LoadUint8(&o.EPCFG0.Reg)&^(0x7)|value)
}
func (o *USB_DEVICE_Type) GetEPCFG0_EPTYPE0() uint8 {
	return volatile.LoadUint8(&o.EPCFG0.Reg) & 0x7
}
func (o *USB_DEVICE_Type) SetEPCFG0_EPTYPE1(value uint8) {
	volatile.StoreUint8(&o.EPCFG0.Reg, volatile.LoadUint8(&o.EPCFG0.Reg)&^(0x70)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPCFG0_EPTYPE1() uint8 {
	return (volatile.LoadUint8(&o.EPCFG0.Reg) & 0x70) >> 4
}
func (o *USB_DEVICE_Type) SetEPCFG0_NYETDIS(value uint8) {
	volatile.StoreUint8(&o.EPCFG0.Reg, volatile.LoadUint8(&o.EPCFG0.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPCFG0_NYETDIS() uint8 {
	return (volatile.LoadUint8(&o.EPCFG0.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSCLR0: DEVICE End Point Pipe Status Clear
func (o *USB_DEVICE_Type) SetEPSTATUSCLR0_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR0.Reg, volatile.LoadUint8(&o.EPSTATUSCLR0.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR0_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSCLR0.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR0_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR0.Reg, volatile.LoadUint8(&o.EPSTATUSCLR0.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR0_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR0.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR0_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR0.Reg, volatile.LoadUint8(&o.EPSTATUSCLR0.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR0_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR0.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR0_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR0.Reg, volatile.LoadUint8(&o.EPSTATUSCLR0.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR0_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR0.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR0_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR0.Reg, volatile.LoadUint8(&o.EPSTATUSCLR0.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR0_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR0.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR0_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR0.Reg, volatile.LoadUint8(&o.EPSTATUSCLR0.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR0_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR0.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR0_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR0.Reg, volatile.LoadUint8(&o.EPSTATUSCLR0.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR0_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR0.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSSET0: DEVICE End Point Pipe Status Set
func (o *USB_DEVICE_Type) SetEPSTATUSSET0_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET0.Reg, volatile.LoadUint8(&o.EPSTATUSSET0.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET0_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSSET0.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET0_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET0.Reg, volatile.LoadUint8(&o.EPSTATUSSET0.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET0_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET0.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET0_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET0.Reg, volatile.LoadUint8(&o.EPSTATUSSET0.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET0_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET0.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET0_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET0.Reg, volatile.LoadUint8(&o.EPSTATUSSET0.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET0_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET0.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET0_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET0.Reg, volatile.LoadUint8(&o.EPSTATUSSET0.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET0_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET0.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET0_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET0.Reg, volatile.LoadUint8(&o.EPSTATUSSET0.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET0_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET0.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET0_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET0.Reg, volatile.LoadUint8(&o.EPSTATUSSET0.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET0_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET0.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUS0: DEVICE End Point Pipe Status
func (o *USB_DEVICE_Type) SetEPSTATUS0_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS0.Reg, volatile.LoadUint8(&o.EPSTATUS0.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUS0_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUS0.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUS0_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS0.Reg, volatile.LoadUint8(&o.EPSTATUS0.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUS0_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS0.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUS0_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS0.Reg, volatile.LoadUint8(&o.EPSTATUS0.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUS0_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS0.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUS0_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS0.Reg, volatile.LoadUint8(&o.EPSTATUS0.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUS0_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS0.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUS0_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS0.Reg, volatile.LoadUint8(&o.EPSTATUS0.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUS0_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS0.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUS0_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS0.Reg, volatile.LoadUint8(&o.EPSTATUS0.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUS0_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS0.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUS0_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS0.Reg, volatile.LoadUint8(&o.EPSTATUS0.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUS0_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS0.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPINTFLAG0: DEVICE End Point Interrupt Flag
func (o *USB_DEVICE_Type) SetEPINTFLAG0_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG0.Reg, volatile.LoadUint8(&o.EPINTFLAG0.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG0_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTFLAG0.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG0_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG0.Reg, volatile.LoadUint8(&o.EPINTFLAG0.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG0_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG0.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG0_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG0.Reg, volatile.LoadUint8(&o.EPINTFLAG0.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG0_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG0.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTFLAG0_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG0.Reg, volatile.LoadUint8(&o.EPINTFLAG0.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG0_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG0.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTFLAG0_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG0.Reg, volatile.LoadUint8(&o.EPINTFLAG0.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG0_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG0.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTFLAG0_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG0.Reg, volatile.LoadUint8(&o.EPINTFLAG0.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG0_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG0.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTFLAG0_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG0.Reg, volatile.LoadUint8(&o.EPINTFLAG0.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG0_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG0.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENCLR0: DEVICE End Point Interrupt Clear Flag
func (o *USB_DEVICE_Type) SetEPINTENCLR0_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR0.Reg, volatile.LoadUint8(&o.EPINTENCLR0.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR0_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENCLR0.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR0_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR0.Reg, volatile.LoadUint8(&o.EPINTENCLR0.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR0_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR0.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR0_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR0.Reg, volatile.LoadUint8(&o.EPINTENCLR0.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR0_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR0.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENCLR0_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR0.Reg, volatile.LoadUint8(&o.EPINTENCLR0.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR0_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR0.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENCLR0_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR0.Reg, volatile.LoadUint8(&o.EPINTENCLR0.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR0_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR0.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENCLR0_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR0.Reg, volatile.LoadUint8(&o.EPINTENCLR0.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR0_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR0.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENCLR0_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR0.Reg, volatile.LoadUint8(&o.EPINTENCLR0.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR0_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR0.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENSET0: DEVICE End Point Interrupt Set Flag
func (o *USB_DEVICE_Type) SetEPINTENSET0_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET0.Reg, volatile.LoadUint8(&o.EPINTENSET0.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENSET0_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENSET0.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENSET0_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET0.Reg, volatile.LoadUint8(&o.EPINTENSET0.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENSET0_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET0.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENSET0_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET0.Reg, volatile.LoadUint8(&o.EPINTENSET0.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENSET0_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET0.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENSET0_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET0.Reg, volatile.LoadUint8(&o.EPINTENSET0.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENSET0_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET0.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENSET0_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET0.Reg, volatile.LoadUint8(&o.EPINTENSET0.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENSET0_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET0.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENSET0_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET0.Reg, volatile.LoadUint8(&o.EPINTENSET0.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENSET0_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET0.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENSET0_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET0.Reg, volatile.LoadUint8(&o.EPINTENSET0.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENSET0_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET0.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPCFG1: DEVICE End Point Configuration
func (o *USB_DEVICE_Type) SetEPCFG1_EPTYPE0(value uint8) {
	volatile.StoreUint8(&o.EPCFG1.Reg, volatile.LoadUint8(&o.EPCFG1.Reg)&^(0x7)|value)
}
func (o *USB_DEVICE_Type) GetEPCFG1_EPTYPE0() uint8 {
	return volatile.LoadUint8(&o.EPCFG1.Reg) & 0x7
}
func (o *USB_DEVICE_Type) SetEPCFG1_EPTYPE1(value uint8) {
	volatile.StoreUint8(&o.EPCFG1.Reg, volatile.LoadUint8(&o.EPCFG1.Reg)&^(0x70)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPCFG1_EPTYPE1() uint8 {
	return (volatile.LoadUint8(&o.EPCFG1.Reg) & 0x70) >> 4
}
func (o *USB_DEVICE_Type) SetEPCFG1_NYETDIS(value uint8) {
	volatile.StoreUint8(&o.EPCFG1.Reg, volatile.LoadUint8(&o.EPCFG1.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPCFG1_NYETDIS() uint8 {
	return (volatile.LoadUint8(&o.EPCFG1.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSCLR1: DEVICE End Point Pipe Status Clear
func (o *USB_DEVICE_Type) SetEPSTATUSCLR1_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR1.Reg, volatile.LoadUint8(&o.EPSTATUSCLR1.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR1_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSCLR1.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR1_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR1.Reg, volatile.LoadUint8(&o.EPSTATUSCLR1.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR1_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR1.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR1_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR1.Reg, volatile.LoadUint8(&o.EPSTATUSCLR1.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR1_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR1.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR1_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR1.Reg, volatile.LoadUint8(&o.EPSTATUSCLR1.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR1_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR1.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR1_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR1.Reg, volatile.LoadUint8(&o.EPSTATUSCLR1.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR1_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR1.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR1_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR1.Reg, volatile.LoadUint8(&o.EPSTATUSCLR1.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR1_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR1.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR1_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR1.Reg, volatile.LoadUint8(&o.EPSTATUSCLR1.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR1_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR1.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSSET1: DEVICE End Point Pipe Status Set
func (o *USB_DEVICE_Type) SetEPSTATUSSET1_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET1.Reg, volatile.LoadUint8(&o.EPSTATUSSET1.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET1_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSSET1.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET1_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET1.Reg, volatile.LoadUint8(&o.EPSTATUSSET1.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET1_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET1.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET1_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET1.Reg, volatile.LoadUint8(&o.EPSTATUSSET1.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET1_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET1.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET1_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET1.Reg, volatile.LoadUint8(&o.EPSTATUSSET1.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET1_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET1.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET1_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET1.Reg, volatile.LoadUint8(&o.EPSTATUSSET1.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET1_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET1.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET1_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET1.Reg, volatile.LoadUint8(&o.EPSTATUSSET1.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET1_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET1.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET1_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET1.Reg, volatile.LoadUint8(&o.EPSTATUSSET1.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET1_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET1.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUS1: DEVICE End Point Pipe Status
func (o *USB_DEVICE_Type) SetEPSTATUS1_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS1.Reg, volatile.LoadUint8(&o.EPSTATUS1.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUS1_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUS1.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUS1_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS1.Reg, volatile.LoadUint8(&o.EPSTATUS1.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUS1_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS1.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUS1_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS1.Reg, volatile.LoadUint8(&o.EPSTATUS1.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUS1_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS1.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUS1_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS1.Reg, volatile.LoadUint8(&o.EPSTATUS1.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUS1_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS1.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUS1_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS1.Reg, volatile.LoadUint8(&o.EPSTATUS1.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUS1_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS1.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUS1_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS1.Reg, volatile.LoadUint8(&o.EPSTATUS1.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUS1_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS1.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUS1_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS1.Reg, volatile.LoadUint8(&o.EPSTATUS1.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUS1_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS1.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPINTFLAG1: DEVICE End Point Interrupt Flag
func (o *USB_DEVICE_Type) SetEPINTFLAG1_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG1.Reg, volatile.LoadUint8(&o.EPINTFLAG1.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG1_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTFLAG1.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG1_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG1.Reg, volatile.LoadUint8(&o.EPINTFLAG1.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG1_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG1.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG1_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG1.Reg, volatile.LoadUint8(&o.EPINTFLAG1.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG1_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG1.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTFLAG1_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG1.Reg, volatile.LoadUint8(&o.EPINTFLAG1.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG1_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG1.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTFLAG1_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG1.Reg, volatile.LoadUint8(&o.EPINTFLAG1.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG1_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG1.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTFLAG1_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG1.Reg, volatile.LoadUint8(&o.EPINTFLAG1.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG1_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG1.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTFLAG1_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG1.Reg, volatile.LoadUint8(&o.EPINTFLAG1.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG1_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG1.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENCLR1: DEVICE End Point Interrupt Clear Flag
func (o *USB_DEVICE_Type) SetEPINTENCLR1_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR1.Reg, volatile.LoadUint8(&o.EPINTENCLR1.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR1_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENCLR1.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR1_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR1.Reg, volatile.LoadUint8(&o.EPINTENCLR1.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR1_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR1.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR1_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR1.Reg, volatile.LoadUint8(&o.EPINTENCLR1.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR1_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR1.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENCLR1_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR1.Reg, volatile.LoadUint8(&o.EPINTENCLR1.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR1_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR1.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENCLR1_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR1.Reg, volatile.LoadUint8(&o.EPINTENCLR1.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR1_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR1.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENCLR1_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR1.Reg, volatile.LoadUint8(&o.EPINTENCLR1.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR1_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR1.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENCLR1_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR1.Reg, volatile.LoadUint8(&o.EPINTENCLR1.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR1_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR1.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENSET1: DEVICE End Point Interrupt Set Flag
func (o *USB_DEVICE_Type) SetEPINTENSET1_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET1.Reg, volatile.LoadUint8(&o.EPINTENSET1.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENSET1_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENSET1.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENSET1_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET1.Reg, volatile.LoadUint8(&o.EPINTENSET1.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENSET1_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET1.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENSET1_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET1.Reg, volatile.LoadUint8(&o.EPINTENSET1.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENSET1_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET1.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENSET1_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET1.Reg, volatile.LoadUint8(&o.EPINTENSET1.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENSET1_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET1.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENSET1_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET1.Reg, volatile.LoadUint8(&o.EPINTENSET1.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENSET1_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET1.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENSET1_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET1.Reg, volatile.LoadUint8(&o.EPINTENSET1.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENSET1_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET1.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENSET1_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET1.Reg, volatile.LoadUint8(&o.EPINTENSET1.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENSET1_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET1.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPCFG2: DEVICE End Point Configuration
func (o *USB_DEVICE_Type) SetEPCFG2_EPTYPE0(value uint8) {
	volatile.StoreUint8(&o.EPCFG2.Reg, volatile.LoadUint8(&o.EPCFG2.Reg)&^(0x7)|value)
}
func (o *USB_DEVICE_Type) GetEPCFG2_EPTYPE0() uint8 {
	return volatile.LoadUint8(&o.EPCFG2.Reg) & 0x7
}
func (o *USB_DEVICE_Type) SetEPCFG2_EPTYPE1(value uint8) {
	volatile.StoreUint8(&o.EPCFG2.Reg, volatile.LoadUint8(&o.EPCFG2.Reg)&^(0x70)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPCFG2_EPTYPE1() uint8 {
	return (volatile.LoadUint8(&o.EPCFG2.Reg) & 0x70) >> 4
}
func (o *USB_DEVICE_Type) SetEPCFG2_NYETDIS(value uint8) {
	volatile.StoreUint8(&o.EPCFG2.Reg, volatile.LoadUint8(&o.EPCFG2.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPCFG2_NYETDIS() uint8 {
	return (volatile.LoadUint8(&o.EPCFG2.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSCLR2: DEVICE End Point Pipe Status Clear
func (o *USB_DEVICE_Type) SetEPSTATUSCLR2_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR2.Reg, volatile.LoadUint8(&o.EPSTATUSCLR2.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR2_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSCLR2.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR2_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR2.Reg, volatile.LoadUint8(&o.EPSTATUSCLR2.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR2_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR2.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR2_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR2.Reg, volatile.LoadUint8(&o.EPSTATUSCLR2.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR2_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR2.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR2_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR2.Reg, volatile.LoadUint8(&o.EPSTATUSCLR2.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR2_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR2.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR2_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR2.Reg, volatile.LoadUint8(&o.EPSTATUSCLR2.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR2_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR2.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR2_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR2.Reg, volatile.LoadUint8(&o.EPSTATUSCLR2.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR2_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR2.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR2_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR2.Reg, volatile.LoadUint8(&o.EPSTATUSCLR2.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR2_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR2.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSSET2: DEVICE End Point Pipe Status Set
func (o *USB_DEVICE_Type) SetEPSTATUSSET2_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET2.Reg, volatile.LoadUint8(&o.EPSTATUSSET2.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET2_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSSET2.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET2_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET2.Reg, volatile.LoadUint8(&o.EPSTATUSSET2.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET2_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET2.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET2_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET2.Reg, volatile.LoadUint8(&o.EPSTATUSSET2.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET2_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET2.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET2_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET2.Reg, volatile.LoadUint8(&o.EPSTATUSSET2.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET2_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET2.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET2_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET2.Reg, volatile.LoadUint8(&o.EPSTATUSSET2.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET2_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET2.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET2_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET2.Reg, volatile.LoadUint8(&o.EPSTATUSSET2.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET2_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET2.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET2_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET2.Reg, volatile.LoadUint8(&o.EPSTATUSSET2.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET2_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET2.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUS2: DEVICE End Point Pipe Status
func (o *USB_DEVICE_Type) SetEPSTATUS2_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS2.Reg, volatile.LoadUint8(&o.EPSTATUS2.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUS2_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUS2.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUS2_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS2.Reg, volatile.LoadUint8(&o.EPSTATUS2.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUS2_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS2.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUS2_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS2.Reg, volatile.LoadUint8(&o.EPSTATUS2.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUS2_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS2.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUS2_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS2.Reg, volatile.LoadUint8(&o.EPSTATUS2.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUS2_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS2.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUS2_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS2.Reg, volatile.LoadUint8(&o.EPSTATUS2.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUS2_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS2.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUS2_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS2.Reg, volatile.LoadUint8(&o.EPSTATUS2.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUS2_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS2.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUS2_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS2.Reg, volatile.LoadUint8(&o.EPSTATUS2.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUS2_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS2.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPINTFLAG2: DEVICE End Point Interrupt Flag
func (o *USB_DEVICE_Type) SetEPINTFLAG2_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG2.Reg, volatile.LoadUint8(&o.EPINTFLAG2.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG2_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTFLAG2.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG2_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG2.Reg, volatile.LoadUint8(&o.EPINTFLAG2.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG2_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG2.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG2_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG2.Reg, volatile.LoadUint8(&o.EPINTFLAG2.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG2_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG2.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTFLAG2_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG2.Reg, volatile.LoadUint8(&o.EPINTFLAG2.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG2_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG2.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTFLAG2_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG2.Reg, volatile.LoadUint8(&o.EPINTFLAG2.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG2_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG2.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTFLAG2_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG2.Reg, volatile.LoadUint8(&o.EPINTFLAG2.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG2_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG2.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTFLAG2_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG2.Reg, volatile.LoadUint8(&o.EPINTFLAG2.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG2_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG2.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENCLR2: DEVICE End Point Interrupt Clear Flag
func (o *USB_DEVICE_Type) SetEPINTENCLR2_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR2.Reg, volatile.LoadUint8(&o.EPINTENCLR2.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR2_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENCLR2.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR2_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR2.Reg, volatile.LoadUint8(&o.EPINTENCLR2.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR2_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR2.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR2_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR2.Reg, volatile.LoadUint8(&o.EPINTENCLR2.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR2_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR2.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENCLR2_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR2.Reg, volatile.LoadUint8(&o.EPINTENCLR2.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR2_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR2.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENCLR2_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR2.Reg, volatile.LoadUint8(&o.EPINTENCLR2.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR2_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR2.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENCLR2_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR2.Reg, volatile.LoadUint8(&o.EPINTENCLR2.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR2_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR2.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENCLR2_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR2.Reg, volatile.LoadUint8(&o.EPINTENCLR2.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR2_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR2.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENSET2: DEVICE End Point Interrupt Set Flag
func (o *USB_DEVICE_Type) SetEPINTENSET2_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET2.Reg, volatile.LoadUint8(&o.EPINTENSET2.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENSET2_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENSET2.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENSET2_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET2.Reg, volatile.LoadUint8(&o.EPINTENSET2.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENSET2_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET2.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENSET2_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET2.Reg, volatile.LoadUint8(&o.EPINTENSET2.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENSET2_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET2.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENSET2_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET2.Reg, volatile.LoadUint8(&o.EPINTENSET2.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENSET2_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET2.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENSET2_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET2.Reg, volatile.LoadUint8(&o.EPINTENSET2.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENSET2_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET2.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENSET2_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET2.Reg, volatile.LoadUint8(&o.EPINTENSET2.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENSET2_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET2.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENSET2_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET2.Reg, volatile.LoadUint8(&o.EPINTENSET2.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENSET2_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET2.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPCFG3: DEVICE End Point Configuration
func (o *USB_DEVICE_Type) SetEPCFG3_EPTYPE0(value uint8) {
	volatile.StoreUint8(&o.EPCFG3.Reg, volatile.LoadUint8(&o.EPCFG3.Reg)&^(0x7)|value)
}
func (o *USB_DEVICE_Type) GetEPCFG3_EPTYPE0() uint8 {
	return volatile.LoadUint8(&o.EPCFG3.Reg) & 0x7
}
func (o *USB_DEVICE_Type) SetEPCFG3_EPTYPE1(value uint8) {
	volatile.StoreUint8(&o.EPCFG3.Reg, volatile.LoadUint8(&o.EPCFG3.Reg)&^(0x70)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPCFG3_EPTYPE1() uint8 {
	return (volatile.LoadUint8(&o.EPCFG3.Reg) & 0x70) >> 4
}
func (o *USB_DEVICE_Type) SetEPCFG3_NYETDIS(value uint8) {
	volatile.StoreUint8(&o.EPCFG3.Reg, volatile.LoadUint8(&o.EPCFG3.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPCFG3_NYETDIS() uint8 {
	return (volatile.LoadUint8(&o.EPCFG3.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSCLR3: DEVICE End Point Pipe Status Clear
func (o *USB_DEVICE_Type) SetEPSTATUSCLR3_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR3.Reg, volatile.LoadUint8(&o.EPSTATUSCLR3.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR3_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSCLR3.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR3_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR3.Reg, volatile.LoadUint8(&o.EPSTATUSCLR3.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR3_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR3.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR3_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR3.Reg, volatile.LoadUint8(&o.EPSTATUSCLR3.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR3_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR3.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR3_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR3.Reg, volatile.LoadUint8(&o.EPSTATUSCLR3.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR3_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR3.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR3_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR3.Reg, volatile.LoadUint8(&o.EPSTATUSCLR3.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR3_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR3.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR3_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR3.Reg, volatile.LoadUint8(&o.EPSTATUSCLR3.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR3_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR3.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR3_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR3.Reg, volatile.LoadUint8(&o.EPSTATUSCLR3.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR3_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR3.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSSET3: DEVICE End Point Pipe Status Set
func (o *USB_DEVICE_Type) SetEPSTATUSSET3_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET3.Reg, volatile.LoadUint8(&o.EPSTATUSSET3.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET3_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSSET3.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET3_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET3.Reg, volatile.LoadUint8(&o.EPSTATUSSET3.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET3_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET3.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET3_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET3.Reg, volatile.LoadUint8(&o.EPSTATUSSET3.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET3_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET3.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET3_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET3.Reg, volatile.LoadUint8(&o.EPSTATUSSET3.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET3_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET3.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET3_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET3.Reg, volatile.LoadUint8(&o.EPSTATUSSET3.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET3_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET3.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET3_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET3.Reg, volatile.LoadUint8(&o.EPSTATUSSET3.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET3_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET3.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET3_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET3.Reg, volatile.LoadUint8(&o.EPSTATUSSET3.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET3_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET3.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUS3: DEVICE End Point Pipe Status
func (o *USB_DEVICE_Type) SetEPSTATUS3_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS3.Reg, volatile.LoadUint8(&o.EPSTATUS3.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUS3_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUS3.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUS3_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS3.Reg, volatile.LoadUint8(&o.EPSTATUS3.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUS3_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS3.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUS3_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS3.Reg, volatile.LoadUint8(&o.EPSTATUS3.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUS3_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS3.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUS3_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS3.Reg, volatile.LoadUint8(&o.EPSTATUS3.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUS3_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS3.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUS3_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS3.Reg, volatile.LoadUint8(&o.EPSTATUS3.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUS3_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS3.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUS3_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS3.Reg, volatile.LoadUint8(&o.EPSTATUS3.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUS3_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS3.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUS3_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS3.Reg, volatile.LoadUint8(&o.EPSTATUS3.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUS3_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS3.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPINTFLAG3: DEVICE End Point Interrupt Flag
func (o *USB_DEVICE_Type) SetEPINTFLAG3_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG3.Reg, volatile.LoadUint8(&o.EPINTFLAG3.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG3_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTFLAG3.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG3_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG3.Reg, volatile.LoadUint8(&o.EPINTFLAG3.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG3_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG3.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG3_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG3.Reg, volatile.LoadUint8(&o.EPINTFLAG3.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG3_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG3.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTFLAG3_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG3.Reg, volatile.LoadUint8(&o.EPINTFLAG3.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG3_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG3.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTFLAG3_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG3.Reg, volatile.LoadUint8(&o.EPINTFLAG3.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG3_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG3.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTFLAG3_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG3.Reg, volatile.LoadUint8(&o.EPINTFLAG3.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG3_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG3.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTFLAG3_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG3.Reg, volatile.LoadUint8(&o.EPINTFLAG3.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG3_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG3.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENCLR3: DEVICE End Point Interrupt Clear Flag
func (o *USB_DEVICE_Type) SetEPINTENCLR3_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR3.Reg, volatile.LoadUint8(&o.EPINTENCLR3.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR3_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENCLR3.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR3_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR3.Reg, volatile.LoadUint8(&o.EPINTENCLR3.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR3_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR3.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR3_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR3.Reg, volatile.LoadUint8(&o.EPINTENCLR3.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR3_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR3.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENCLR3_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR3.Reg, volatile.LoadUint8(&o.EPINTENCLR3.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR3_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR3.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENCLR3_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR3.Reg, volatile.LoadUint8(&o.EPINTENCLR3.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR3_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR3.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENCLR3_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR3.Reg, volatile.LoadUint8(&o.EPINTENCLR3.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR3_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR3.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENCLR3_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR3.Reg, volatile.LoadUint8(&o.EPINTENCLR3.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR3_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR3.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENSET3: DEVICE End Point Interrupt Set Flag
func (o *USB_DEVICE_Type) SetEPINTENSET3_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET3.Reg, volatile.LoadUint8(&o.EPINTENSET3.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENSET3_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENSET3.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENSET3_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET3.Reg, volatile.LoadUint8(&o.EPINTENSET3.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENSET3_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET3.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENSET3_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET3.Reg, volatile.LoadUint8(&o.EPINTENSET3.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENSET3_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET3.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENSET3_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET3.Reg, volatile.LoadUint8(&o.EPINTENSET3.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENSET3_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET3.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENSET3_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET3.Reg, volatile.LoadUint8(&o.EPINTENSET3.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENSET3_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET3.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENSET3_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET3.Reg, volatile.LoadUint8(&o.EPINTENSET3.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENSET3_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET3.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENSET3_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET3.Reg, volatile.LoadUint8(&o.EPINTENSET3.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENSET3_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET3.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPCFG4: DEVICE End Point Configuration
func (o *USB_DEVICE_Type) SetEPCFG4_EPTYPE0(value uint8) {
	volatile.StoreUint8(&o.EPCFG4.Reg, volatile.LoadUint8(&o.EPCFG4.Reg)&^(0x7)|value)
}
func (o *USB_DEVICE_Type) GetEPCFG4_EPTYPE0() uint8 {
	return volatile.LoadUint8(&o.EPCFG4.Reg) & 0x7
}
func (o *USB_DEVICE_Type) SetEPCFG4_EPTYPE1(value uint8) {
	volatile.StoreUint8(&o.EPCFG4.Reg, volatile.LoadUint8(&o.EPCFG4.Reg)&^(0x70)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPCFG4_EPTYPE1() uint8 {
	return (volatile.LoadUint8(&o.EPCFG4.Reg) & 0x70) >> 4
}
func (o *USB_DEVICE_Type) SetEPCFG4_NYETDIS(value uint8) {
	volatile.StoreUint8(&o.EPCFG4.Reg, volatile.LoadUint8(&o.EPCFG4.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPCFG4_NYETDIS() uint8 {
	return (volatile.LoadUint8(&o.EPCFG4.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSCLR4: DEVICE End Point Pipe Status Clear
func (o *USB_DEVICE_Type) SetEPSTATUSCLR4_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR4.Reg, volatile.LoadUint8(&o.EPSTATUSCLR4.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR4_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSCLR4.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR4_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR4.Reg, volatile.LoadUint8(&o.EPSTATUSCLR4.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR4_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR4.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR4_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR4.Reg, volatile.LoadUint8(&o.EPSTATUSCLR4.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR4_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR4.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR4_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR4.Reg, volatile.LoadUint8(&o.EPSTATUSCLR4.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR4_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR4.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR4_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR4.Reg, volatile.LoadUint8(&o.EPSTATUSCLR4.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR4_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR4.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR4_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR4.Reg, volatile.LoadUint8(&o.EPSTATUSCLR4.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR4_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR4.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR4_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR4.Reg, volatile.LoadUint8(&o.EPSTATUSCLR4.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR4_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR4.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSSET4: DEVICE End Point Pipe Status Set
func (o *USB_DEVICE_Type) SetEPSTATUSSET4_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET4.Reg, volatile.LoadUint8(&o.EPSTATUSSET4.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET4_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSSET4.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET4_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET4.Reg, volatile.LoadUint8(&o.EPSTATUSSET4.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET4_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET4.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET4_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET4.Reg, volatile.LoadUint8(&o.EPSTATUSSET4.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET4_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET4.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET4_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET4.Reg, volatile.LoadUint8(&o.EPSTATUSSET4.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET4_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET4.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET4_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET4.Reg, volatile.LoadUint8(&o.EPSTATUSSET4.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET4_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET4.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET4_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET4.Reg, volatile.LoadUint8(&o.EPSTATUSSET4.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET4_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET4.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET4_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET4.Reg, volatile.LoadUint8(&o.EPSTATUSSET4.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET4_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET4.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUS4: DEVICE End Point Pipe Status
func (o *USB_DEVICE_Type) SetEPSTATUS4_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS4.Reg, volatile.LoadUint8(&o.EPSTATUS4.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUS4_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUS4.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUS4_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS4.Reg, volatile.LoadUint8(&o.EPSTATUS4.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUS4_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS4.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUS4_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS4.Reg, volatile.LoadUint8(&o.EPSTATUS4.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUS4_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS4.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUS4_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS4.Reg, volatile.LoadUint8(&o.EPSTATUS4.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUS4_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS4.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUS4_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS4.Reg, volatile.LoadUint8(&o.EPSTATUS4.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUS4_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS4.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUS4_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS4.Reg, volatile.LoadUint8(&o.EPSTATUS4.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUS4_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS4.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUS4_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS4.Reg, volatile.LoadUint8(&o.EPSTATUS4.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUS4_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS4.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPINTFLAG4: DEVICE End Point Interrupt Flag
func (o *USB_DEVICE_Type) SetEPINTFLAG4_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG4.Reg, volatile.LoadUint8(&o.EPINTFLAG4.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG4_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTFLAG4.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG4_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG4.Reg, volatile.LoadUint8(&o.EPINTFLAG4.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG4_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG4.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG4_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG4.Reg, volatile.LoadUint8(&o.EPINTFLAG4.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG4_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG4.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTFLAG4_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG4.Reg, volatile.LoadUint8(&o.EPINTFLAG4.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG4_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG4.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTFLAG4_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG4.Reg, volatile.LoadUint8(&o.EPINTFLAG4.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG4_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG4.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTFLAG4_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG4.Reg, volatile.LoadUint8(&o.EPINTFLAG4.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG4_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG4.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTFLAG4_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG4.Reg, volatile.LoadUint8(&o.EPINTFLAG4.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG4_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG4.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENCLR4: DEVICE End Point Interrupt Clear Flag
func (o *USB_DEVICE_Type) SetEPINTENCLR4_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR4.Reg, volatile.LoadUint8(&o.EPINTENCLR4.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR4_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENCLR4.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR4_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR4.Reg, volatile.LoadUint8(&o.EPINTENCLR4.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR4_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR4.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR4_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR4.Reg, volatile.LoadUint8(&o.EPINTENCLR4.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR4_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR4.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENCLR4_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR4.Reg, volatile.LoadUint8(&o.EPINTENCLR4.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR4_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR4.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENCLR4_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR4.Reg, volatile.LoadUint8(&o.EPINTENCLR4.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR4_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR4.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENCLR4_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR4.Reg, volatile.LoadUint8(&o.EPINTENCLR4.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR4_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR4.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENCLR4_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR4.Reg, volatile.LoadUint8(&o.EPINTENCLR4.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR4_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR4.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENSET4: DEVICE End Point Interrupt Set Flag
func (o *USB_DEVICE_Type) SetEPINTENSET4_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET4.Reg, volatile.LoadUint8(&o.EPINTENSET4.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENSET4_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENSET4.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENSET4_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET4.Reg, volatile.LoadUint8(&o.EPINTENSET4.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENSET4_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET4.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENSET4_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET4.Reg, volatile.LoadUint8(&o.EPINTENSET4.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENSET4_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET4.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENSET4_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET4.Reg, volatile.LoadUint8(&o.EPINTENSET4.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENSET4_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET4.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENSET4_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET4.Reg, volatile.LoadUint8(&o.EPINTENSET4.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENSET4_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET4.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENSET4_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET4.Reg, volatile.LoadUint8(&o.EPINTENSET4.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENSET4_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET4.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENSET4_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET4.Reg, volatile.LoadUint8(&o.EPINTENSET4.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENSET4_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET4.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPCFG5: DEVICE End Point Configuration
func (o *USB_DEVICE_Type) SetEPCFG5_EPTYPE0(value uint8) {
	volatile.StoreUint8(&o.EPCFG5.Reg, volatile.LoadUint8(&o.EPCFG5.Reg)&^(0x7)|value)
}
func (o *USB_DEVICE_Type) GetEPCFG5_EPTYPE0() uint8 {
	return volatile.LoadUint8(&o.EPCFG5.Reg) & 0x7
}
func (o *USB_DEVICE_Type) SetEPCFG5_EPTYPE1(value uint8) {
	volatile.StoreUint8(&o.EPCFG5.Reg, volatile.LoadUint8(&o.EPCFG5.Reg)&^(0x70)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPCFG5_EPTYPE1() uint8 {
	return (volatile.LoadUint8(&o.EPCFG5.Reg) & 0x70) >> 4
}
func (o *USB_DEVICE_Type) SetEPCFG5_NYETDIS(value uint8) {
	volatile.StoreUint8(&o.EPCFG5.Reg, volatile.LoadUint8(&o.EPCFG5.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPCFG5_NYETDIS() uint8 {
	return (volatile.LoadUint8(&o.EPCFG5.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSCLR5: DEVICE End Point Pipe Status Clear
func (o *USB_DEVICE_Type) SetEPSTATUSCLR5_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR5.Reg, volatile.LoadUint8(&o.EPSTATUSCLR5.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR5_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSCLR5.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR5_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR5.Reg, volatile.LoadUint8(&o.EPSTATUSCLR5.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR5_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR5.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR5_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR5.Reg, volatile.LoadUint8(&o.EPSTATUSCLR5.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR5_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR5.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR5_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR5.Reg, volatile.LoadUint8(&o.EPSTATUSCLR5.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR5_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR5.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR5_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR5.Reg, volatile.LoadUint8(&o.EPSTATUSCLR5.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR5_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR5.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR5_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR5.Reg, volatile.LoadUint8(&o.EPSTATUSCLR5.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR5_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR5.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR5_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR5.Reg, volatile.LoadUint8(&o.EPSTATUSCLR5.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR5_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR5.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSSET5: DEVICE End Point Pipe Status Set
func (o *USB_DEVICE_Type) SetEPSTATUSSET5_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET5.Reg, volatile.LoadUint8(&o.EPSTATUSSET5.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET5_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSSET5.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET5_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET5.Reg, volatile.LoadUint8(&o.EPSTATUSSET5.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET5_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET5.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET5_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET5.Reg, volatile.LoadUint8(&o.EPSTATUSSET5.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET5_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET5.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET5_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET5.Reg, volatile.LoadUint8(&o.EPSTATUSSET5.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET5_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET5.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET5_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET5.Reg, volatile.LoadUint8(&o.EPSTATUSSET5.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET5_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET5.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET5_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET5.Reg, volatile.LoadUint8(&o.EPSTATUSSET5.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET5_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET5.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET5_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET5.Reg, volatile.LoadUint8(&o.EPSTATUSSET5.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET5_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET5.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUS5: DEVICE End Point Pipe Status
func (o *USB_DEVICE_Type) SetEPSTATUS5_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS5.Reg, volatile.LoadUint8(&o.EPSTATUS5.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUS5_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUS5.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUS5_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS5.Reg, volatile.LoadUint8(&o.EPSTATUS5.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUS5_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS5.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUS5_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS5.Reg, volatile.LoadUint8(&o.EPSTATUS5.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUS5_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS5.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUS5_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS5.Reg, volatile.LoadUint8(&o.EPSTATUS5.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUS5_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS5.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUS5_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS5.Reg, volatile.LoadUint8(&o.EPSTATUS5.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUS5_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS5.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUS5_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS5.Reg, volatile.LoadUint8(&o.EPSTATUS5.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUS5_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS5.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUS5_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS5.Reg, volatile.LoadUint8(&o.EPSTATUS5.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUS5_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS5.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPINTFLAG5: DEVICE End Point Interrupt Flag
func (o *USB_DEVICE_Type) SetEPINTFLAG5_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG5.Reg, volatile.LoadUint8(&o.EPINTFLAG5.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG5_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTFLAG5.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG5_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG5.Reg, volatile.LoadUint8(&o.EPINTFLAG5.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG5_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG5.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG5_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG5.Reg, volatile.LoadUint8(&o.EPINTFLAG5.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG5_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG5.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTFLAG5_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG5.Reg, volatile.LoadUint8(&o.EPINTFLAG5.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG5_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG5.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTFLAG5_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG5.Reg, volatile.LoadUint8(&o.EPINTFLAG5.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG5_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG5.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTFLAG5_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG5.Reg, volatile.LoadUint8(&o.EPINTFLAG5.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG5_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG5.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTFLAG5_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG5.Reg, volatile.LoadUint8(&o.EPINTFLAG5.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG5_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG5.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENCLR5: DEVICE End Point Interrupt Clear Flag
func (o *USB_DEVICE_Type) SetEPINTENCLR5_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR5.Reg, volatile.LoadUint8(&o.EPINTENCLR5.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR5_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENCLR5.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR5_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR5.Reg, volatile.LoadUint8(&o.EPINTENCLR5.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR5_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR5.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR5_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR5.Reg, volatile.LoadUint8(&o.EPINTENCLR5.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR5_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR5.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENCLR5_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR5.Reg, volatile.LoadUint8(&o.EPINTENCLR5.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR5_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR5.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENCLR5_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR5.Reg, volatile.LoadUint8(&o.EPINTENCLR5.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR5_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR5.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENCLR5_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR5.Reg, volatile.LoadUint8(&o.EPINTENCLR5.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR5_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR5.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENCLR5_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR5.Reg, volatile.LoadUint8(&o.EPINTENCLR5.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR5_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR5.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENSET5: DEVICE End Point Interrupt Set Flag
func (o *USB_DEVICE_Type) SetEPINTENSET5_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET5.Reg, volatile.LoadUint8(&o.EPINTENSET5.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENSET5_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENSET5.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENSET5_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET5.Reg, volatile.LoadUint8(&o.EPINTENSET5.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENSET5_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET5.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENSET5_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET5.Reg, volatile.LoadUint8(&o.EPINTENSET5.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENSET5_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET5.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENSET5_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET5.Reg, volatile.LoadUint8(&o.EPINTENSET5.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENSET5_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET5.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENSET5_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET5.Reg, volatile.LoadUint8(&o.EPINTENSET5.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENSET5_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET5.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENSET5_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET5.Reg, volatile.LoadUint8(&o.EPINTENSET5.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENSET5_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET5.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENSET5_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET5.Reg, volatile.LoadUint8(&o.EPINTENSET5.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENSET5_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET5.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPCFG6: DEVICE End Point Configuration
func (o *USB_DEVICE_Type) SetEPCFG6_EPTYPE0(value uint8) {
	volatile.StoreUint8(&o.EPCFG6.Reg, volatile.LoadUint8(&o.EPCFG6.Reg)&^(0x7)|value)
}
func (o *USB_DEVICE_Type) GetEPCFG6_EPTYPE0() uint8 {
	return volatile.LoadUint8(&o.EPCFG6.Reg) & 0x7
}
func (o *USB_DEVICE_Type) SetEPCFG6_EPTYPE1(value uint8) {
	volatile.StoreUint8(&o.EPCFG6.Reg, volatile.LoadUint8(&o.EPCFG6.Reg)&^(0x70)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPCFG6_EPTYPE1() uint8 {
	return (volatile.LoadUint8(&o.EPCFG6.Reg) & 0x70) >> 4
}
func (o *USB_DEVICE_Type) SetEPCFG6_NYETDIS(value uint8) {
	volatile.StoreUint8(&o.EPCFG6.Reg, volatile.LoadUint8(&o.EPCFG6.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPCFG6_NYETDIS() uint8 {
	return (volatile.LoadUint8(&o.EPCFG6.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSCLR6: DEVICE End Point Pipe Status Clear
func (o *USB_DEVICE_Type) SetEPSTATUSCLR6_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR6.Reg, volatile.LoadUint8(&o.EPSTATUSCLR6.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR6_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSCLR6.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR6_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR6.Reg, volatile.LoadUint8(&o.EPSTATUSCLR6.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR6_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR6.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR6_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR6.Reg, volatile.LoadUint8(&o.EPSTATUSCLR6.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR6_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR6.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR6_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR6.Reg, volatile.LoadUint8(&o.EPSTATUSCLR6.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR6_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR6.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR6_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR6.Reg, volatile.LoadUint8(&o.EPSTATUSCLR6.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR6_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR6.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR6_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR6.Reg, volatile.LoadUint8(&o.EPSTATUSCLR6.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR6_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR6.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR6_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR6.Reg, volatile.LoadUint8(&o.EPSTATUSCLR6.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR6_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR6.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSSET6: DEVICE End Point Pipe Status Set
func (o *USB_DEVICE_Type) SetEPSTATUSSET6_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET6.Reg, volatile.LoadUint8(&o.EPSTATUSSET6.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET6_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSSET6.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET6_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET6.Reg, volatile.LoadUint8(&o.EPSTATUSSET6.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET6_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET6.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET6_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET6.Reg, volatile.LoadUint8(&o.EPSTATUSSET6.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET6_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET6.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET6_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET6.Reg, volatile.LoadUint8(&o.EPSTATUSSET6.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET6_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET6.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET6_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET6.Reg, volatile.LoadUint8(&o.EPSTATUSSET6.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET6_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET6.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET6_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET6.Reg, volatile.LoadUint8(&o.EPSTATUSSET6.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET6_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET6.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET6_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET6.Reg, volatile.LoadUint8(&o.EPSTATUSSET6.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET6_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET6.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUS6: DEVICE End Point Pipe Status
func (o *USB_DEVICE_Type) SetEPSTATUS6_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS6.Reg, volatile.LoadUint8(&o.EPSTATUS6.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUS6_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUS6.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUS6_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS6.Reg, volatile.LoadUint8(&o.EPSTATUS6.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUS6_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS6.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUS6_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS6.Reg, volatile.LoadUint8(&o.EPSTATUS6.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUS6_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS6.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUS6_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS6.Reg, volatile.LoadUint8(&o.EPSTATUS6.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUS6_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS6.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUS6_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS6.Reg, volatile.LoadUint8(&o.EPSTATUS6.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUS6_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS6.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUS6_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS6.Reg, volatile.LoadUint8(&o.EPSTATUS6.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUS6_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS6.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUS6_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS6.Reg, volatile.LoadUint8(&o.EPSTATUS6.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUS6_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS6.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPINTFLAG6: DEVICE End Point Interrupt Flag
func (o *USB_DEVICE_Type) SetEPINTFLAG6_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG6.Reg, volatile.LoadUint8(&o.EPINTFLAG6.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG6_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTFLAG6.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG6_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG6.Reg, volatile.LoadUint8(&o.EPINTFLAG6.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG6_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG6.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG6_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG6.Reg, volatile.LoadUint8(&o.EPINTFLAG6.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG6_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG6.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTFLAG6_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG6.Reg, volatile.LoadUint8(&o.EPINTFLAG6.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG6_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG6.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTFLAG6_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG6.Reg, volatile.LoadUint8(&o.EPINTFLAG6.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG6_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG6.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTFLAG6_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG6.Reg, volatile.LoadUint8(&o.EPINTFLAG6.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG6_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG6.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTFLAG6_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG6.Reg, volatile.LoadUint8(&o.EPINTFLAG6.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG6_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG6.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENCLR6: DEVICE End Point Interrupt Clear Flag
func (o *USB_DEVICE_Type) SetEPINTENCLR6_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR6.Reg, volatile.LoadUint8(&o.EPINTENCLR6.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR6_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENCLR6.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR6_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR6.Reg, volatile.LoadUint8(&o.EPINTENCLR6.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR6_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR6.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR6_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR6.Reg, volatile.LoadUint8(&o.EPINTENCLR6.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR6_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR6.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENCLR6_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR6.Reg, volatile.LoadUint8(&o.EPINTENCLR6.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR6_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR6.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENCLR6_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR6.Reg, volatile.LoadUint8(&o.EPINTENCLR6.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR6_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR6.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENCLR6_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR6.Reg, volatile.LoadUint8(&o.EPINTENCLR6.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR6_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR6.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENCLR6_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR6.Reg, volatile.LoadUint8(&o.EPINTENCLR6.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR6_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR6.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENSET6: DEVICE End Point Interrupt Set Flag
func (o *USB_DEVICE_Type) SetEPINTENSET6_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET6.Reg, volatile.LoadUint8(&o.EPINTENSET6.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENSET6_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENSET6.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENSET6_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET6.Reg, volatile.LoadUint8(&o.EPINTENSET6.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENSET6_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET6.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENSET6_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET6.Reg, volatile.LoadUint8(&o.EPINTENSET6.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENSET6_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET6.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENSET6_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET6.Reg, volatile.LoadUint8(&o.EPINTENSET6.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENSET6_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET6.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENSET6_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET6.Reg, volatile.LoadUint8(&o.EPINTENSET6.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENSET6_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET6.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENSET6_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET6.Reg, volatile.LoadUint8(&o.EPINTENSET6.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENSET6_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET6.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENSET6_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET6.Reg, volatile.LoadUint8(&o.EPINTENSET6.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENSET6_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET6.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPCFG7: DEVICE End Point Configuration
func (o *USB_DEVICE_Type) SetEPCFG7_EPTYPE0(value uint8) {
	volatile.StoreUint8(&o.EPCFG7.Reg, volatile.LoadUint8(&o.EPCFG7.Reg)&^(0x7)|value)
}
func (o *USB_DEVICE_Type) GetEPCFG7_EPTYPE0() uint8 {
	return volatile.LoadUint8(&o.EPCFG7.Reg) & 0x7
}
func (o *USB_DEVICE_Type) SetEPCFG7_EPTYPE1(value uint8) {
	volatile.StoreUint8(&o.EPCFG7.Reg, volatile.LoadUint8(&o.EPCFG7.Reg)&^(0x70)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPCFG7_EPTYPE1() uint8 {
	return (volatile.LoadUint8(&o.EPCFG7.Reg) & 0x70) >> 4
}
func (o *USB_DEVICE_Type) SetEPCFG7_NYETDIS(value uint8) {
	volatile.StoreUint8(&o.EPCFG7.Reg, volatile.LoadUint8(&o.EPCFG7.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPCFG7_NYETDIS() uint8 {
	return (volatile.LoadUint8(&o.EPCFG7.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSCLR7: DEVICE End Point Pipe Status Clear
func (o *USB_DEVICE_Type) SetEPSTATUSCLR7_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR7.Reg, volatile.LoadUint8(&o.EPSTATUSCLR7.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR7_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSCLR7.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR7_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR7.Reg, volatile.LoadUint8(&o.EPSTATUSCLR7.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR7_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR7.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR7_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR7.Reg, volatile.LoadUint8(&o.EPSTATUSCLR7.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR7_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR7.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR7_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR7.Reg, volatile.LoadUint8(&o.EPSTATUSCLR7.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR7_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR7.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR7_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR7.Reg, volatile.LoadUint8(&o.EPSTATUSCLR7.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR7_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR7.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR7_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR7.Reg, volatile.LoadUint8(&o.EPSTATUSCLR7.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR7_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR7.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR7_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR7.Reg, volatile.LoadUint8(&o.EPSTATUSCLR7.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR7_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR7.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSSET7: DEVICE End Point Pipe Status Set
func (o *USB_DEVICE_Type) SetEPSTATUSSET7_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET7.Reg, volatile.LoadUint8(&o.EPSTATUSSET7.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET7_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSSET7.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET7_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET7.Reg, volatile.LoadUint8(&o.EPSTATUSSET7.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET7_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET7.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET7_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET7.Reg, volatile.LoadUint8(&o.EPSTATUSSET7.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET7_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET7.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET7_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET7.Reg, volatile.LoadUint8(&o.EPSTATUSSET7.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET7_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET7.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET7_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET7.Reg, volatile.LoadUint8(&o.EPSTATUSSET7.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET7_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET7.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET7_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET7.Reg, volatile.LoadUint8(&o.EPSTATUSSET7.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET7_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET7.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET7_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET7.Reg, volatile.LoadUint8(&o.EPSTATUSSET7.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET7_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET7.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUS7: DEVICE End Point Pipe Status
func (o *USB_DEVICE_Type) SetEPSTATUS7_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS7.Reg, volatile.LoadUint8(&o.EPSTATUS7.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUS7_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUS7.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUS7_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS7.Reg, volatile.LoadUint8(&o.EPSTATUS7.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUS7_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS7.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUS7_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS7.Reg, volatile.LoadUint8(&o.EPSTATUS7.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUS7_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS7.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUS7_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS7.Reg, volatile.LoadUint8(&o.EPSTATUS7.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUS7_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS7.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUS7_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS7.Reg, volatile.LoadUint8(&o.EPSTATUS7.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUS7_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS7.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUS7_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS7.Reg, volatile.LoadUint8(&o.EPSTATUS7.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUS7_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS7.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUS7_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS7.Reg, volatile.LoadUint8(&o.EPSTATUS7.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUS7_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS7.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPINTFLAG7: DEVICE End Point Interrupt Flag
func (o *USB_DEVICE_Type) SetEPINTFLAG7_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG7.Reg, volatile.LoadUint8(&o.EPINTFLAG7.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG7_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTFLAG7.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG7_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG7.Reg, volatile.LoadUint8(&o.EPINTFLAG7.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG7_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG7.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG7_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG7.Reg, volatile.LoadUint8(&o.EPINTFLAG7.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG7_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG7.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTFLAG7_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG7.Reg, volatile.LoadUint8(&o.EPINTFLAG7.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG7_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG7.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTFLAG7_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG7.Reg, volatile.LoadUint8(&o.EPINTFLAG7.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG7_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG7.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTFLAG7_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG7.Reg, volatile.LoadUint8(&o.EPINTFLAG7.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG7_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG7.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTFLAG7_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG7.Reg, volatile.LoadUint8(&o.EPINTFLAG7.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG7_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG7.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENCLR7: DEVICE End Point Interrupt Clear Flag
func (o *USB_DEVICE_Type) SetEPINTENCLR7_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR7.Reg, volatile.LoadUint8(&o.EPINTENCLR7.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR7_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENCLR7.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR7_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR7.Reg, volatile.LoadUint8(&o.EPINTENCLR7.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR7_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR7.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR7_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR7.Reg, volatile.LoadUint8(&o.EPINTENCLR7.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR7_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR7.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENCLR7_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR7.Reg, volatile.LoadUint8(&o.EPINTENCLR7.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR7_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR7.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENCLR7_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR7.Reg, volatile.LoadUint8(&o.EPINTENCLR7.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR7_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR7.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENCLR7_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR7.Reg, volatile.LoadUint8(&o.EPINTENCLR7.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR7_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR7.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENCLR7_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR7.Reg, volatile.LoadUint8(&o.EPINTENCLR7.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR7_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR7.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENSET7: DEVICE End Point Interrupt Set Flag
func (o *USB_DEVICE_Type) SetEPINTENSET7_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET7.Reg, volatile.LoadUint8(&o.EPINTENSET7.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENSET7_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENSET7.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENSET7_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET7.Reg, volatile.LoadUint8(&o.EPINTENSET7.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENSET7_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET7.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENSET7_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET7.Reg, volatile.LoadUint8(&o.EPINTENSET7.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENSET7_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET7.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENSET7_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET7.Reg, volatile.LoadUint8(&o.EPINTENSET7.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENSET7_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET7.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENSET7_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET7.Reg, volatile.LoadUint8(&o.EPINTENSET7.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENSET7_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET7.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENSET7_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET7.Reg, volatile.LoadUint8(&o.EPINTENSET7.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENSET7_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET7.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENSET7_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET7.Reg, volatile.LoadUint8(&o.EPINTENSET7.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENSET7_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET7.Reg) & 0x40) >> 6
}

// Universal Serial Bus - HOST
type USB_HOST_Type struct {
	CTRLA       volatile.Register8 // 0x0
	_           byte
	SYNCBUSY    volatile.Register8 // 0x2
	QOSCTRL     volatile.Register8 // 0x3
	_           [4]byte
	CTRLB       volatile.Register16 // 0x8
	HSOFC       volatile.Register8  // 0xA
	_           byte
	STATUS      volatile.Register8 // 0xC
	FSMSTATUS   volatile.Register8 // 0xD
	_           [2]byte
	FNUM        volatile.Register16 // 0x10
	FLENHIGH    volatile.Register8  // 0x12
	_           byte
	INTENCLR    volatile.Register16 // 0x14
	_           [2]byte
	INTENSET    volatile.Register16 // 0x18
	_           [2]byte
	INTFLAG     volatile.Register16 // 0x1C
	_           [2]byte
	PINTSMRY    volatile.Register16 // 0x20
	_           [2]byte
	DESCADD     volatile.Register32 // 0x24
	PADCAL      volatile.Register16 // 0x28
	_           [214]byte
	PCFG0       volatile.Register8 // 0x100
	_           [2]byte
	BINTERVAL0  volatile.Register8 // 0x103
	PSTATUSCLR0 volatile.Register8 // 0x104
	PSTATUSSET0 volatile.Register8 // 0x105
	PSTATUS0    volatile.Register8 // 0x106
	PINTFLAG0   volatile.Register8 // 0x107
	PINTENCLR0  volatile.Register8 // 0x108
	PINTENSET0  volatile.Register8 // 0x109
	_           [22]byte
	PCFG1       volatile.Register8 // 0x120
	_           [2]byte
	BINTERVAL1  volatile.Register8 // 0x123
	PSTATUSCLR1 volatile.Register8 // 0x124
	PSTATUSSET1 volatile.Register8 // 0x125
	PSTATUS1    volatile.Register8 // 0x126
	PINTFLAG1   volatile.Register8 // 0x127
	PINTENCLR1  volatile.Register8 // 0x128
	PINTENSET1  volatile.Register8 // 0x129
	_           [22]byte
	PCFG2       volatile.Register8 // 0x140
	_           [2]byte
	BINTERVAL2  volatile.Register8 // 0x143
	PSTATUSCLR2 volatile.Register8 // 0x144
	PSTATUSSET2 volatile.Register8 // 0x145
	PSTATUS2    volatile.Register8 // 0x146
	PINTFLAG2   volatile.Register8 // 0x147
	PINTENCLR2  volatile.Register8 // 0x148
	PINTENSET2  volatile.Register8 // 0x149
	_           [22]byte
	PCFG3       volatile.Register8 // 0x160
	_           [2]byte
	BINTERVAL3  volatile.Register8 // 0x163
	PSTATUSCLR3 volatile.Register8 // 0x164
	PSTATUSSET3 volatile.Register8 // 0x165
	PSTATUS3    volatile.Register8 // 0x166
	PINTFLAG3   volatile.Register8 // 0x167
	PINTENCLR3  volatile.Register8 // 0x168
	PINTENSET3  volatile.Register8 // 0x169
	_           [22]byte
	PCFG4       volatile.Register8 // 0x180
	_           [2]byte
	BINTERVAL4  volatile.Register8 // 0x183
	PSTATUSCLR4 volatile.Register8 // 0x184
	PSTATUSSET4 volatile.Register8 // 0x185
	PSTATUS4    volatile.Register8 // 0x186
	PINTFLAG4   volatile.Register8 // 0x187
	PINTENCLR4  volatile.Register8 // 0x188
	PINTENSET4  volatile.Register8 // 0x189
	_           [22]byte
	PCFG5       volatile.Register8 // 0x1A0
	_           [2]byte
	BINTERVAL5  volatile.Register8 // 0x1A3
	PSTATUSCLR5 volatile.Register8 // 0x1A4
	PSTATUSSET5 volatile.Register8 // 0x1A5
	PSTATUS5    volatile.Register8 // 0x1A6
	PINTFLAG5   volatile.Register8 // 0x1A7
	PINTENCLR5  volatile.Register8 // 0x1A8
	PINTENSET5  volatile.Register8 // 0x1A9
	_           [22]byte
	PCFG6       volatile.Register8 // 0x1C0
	_           [2]byte
	BINTERVAL6  volatile.Register8 // 0x1C3
	PSTATUSCLR6 volatile.Register8 // 0x1C4
	PSTATUSSET6 volatile.Register8 // 0x1C5
	PSTATUS6    volatile.Register8 // 0x1C6
	PINTFLAG6   volatile.Register8 // 0x1C7
	PINTENCLR6  volatile.Register8 // 0x1C8
	PINTENSET6  volatile.Register8 // 0x1C9
	_           [22]byte
	PCFG7       volatile.Register8 // 0x1E0
	_           [2]byte
	BINTERVAL7  volatile.Register8 // 0x1E3
	PSTATUSCLR7 volatile.Register8 // 0x1E4
	PSTATUSSET7 volatile.Register8 // 0x1E5
	PSTATUS7    volatile.Register8 // 0x1E6
	PINTFLAG7   volatile.Register8 // 0x1E7
	PINTENCLR7  volatile.Register8 // 0x1E8
	PINTENSET7  volatile.Register8 // 0x1E9
}

// USB_HOST.CTRLA: Control A
func (o *USB_HOST_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}
func (o *USB_HOST_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetCTRLA_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetCTRLA_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetCTRLA_MODE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetCTRLA_MODE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x80) >> 7
}

// USB_HOST.SYNCBUSY: Synchronization Busy
func (o *USB_HOST_Type) SetSYNCBUSY_SWRST(value uint8) {
	volatile.StoreUint8(&o.SYNCBUSY.Reg, volatile.LoadUint8(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetSYNCBUSY_SWRST() uint8 {
	return volatile.LoadUint8(&o.SYNCBUSY.Reg) & 0x1
}
func (o *USB_HOST_Type) SetSYNCBUSY_ENABLE(value uint8) {
	volatile.StoreUint8(&o.SYNCBUSY.Reg, volatile.LoadUint8(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetSYNCBUSY_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.SYNCBUSY.Reg) & 0x2) >> 1
}

// USB_HOST.QOSCTRL: USB Quality Of Service
func (o *USB_HOST_Type) SetQOSCTRL_CQOS(value uint8) {
	volatile.StoreUint8(&o.QOSCTRL.Reg, volatile.LoadUint8(&o.QOSCTRL.Reg)&^(0x3)|value)
}
func (o *USB_HOST_Type) GetQOSCTRL_CQOS() uint8 {
	return volatile.LoadUint8(&o.QOSCTRL.Reg) & 0x3
}
func (o *USB_HOST_Type) SetQOSCTRL_DQOS(value uint8) {
	volatile.StoreUint8(&o.QOSCTRL.Reg, volatile.LoadUint8(&o.QOSCTRL.Reg)&^(0xc)|value<<2)
}
func (o *USB_HOST_Type) GetQOSCTRL_DQOS() uint8 {
	return (volatile.LoadUint8(&o.QOSCTRL.Reg) & 0xc) >> 2
}

// USB_HOST.CTRLB: HOST Control B
func (o *USB_HOST_Type) SetCTRLB_RESUME(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetCTRLB_RESUME() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetCTRLB_SPDCONF(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0xc)|value<<2)
}
func (o *USB_HOST_Type) GetCTRLB_SPDCONF() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0xc) >> 2
}
func (o *USB_HOST_Type) SetCTRLB_TSTJ(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetCTRLB_TSTJ() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x20) >> 5
}
func (o *USB_HOST_Type) SetCTRLB_TSTK(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetCTRLB_TSTK() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetCTRLB_SOFE(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x100)|value<<8)
}
func (o *USB_HOST_Type) GetCTRLB_SOFE() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x100) >> 8
}
func (o *USB_HOST_Type) SetCTRLB_BUSRESET(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x200)|value<<9)
}
func (o *USB_HOST_Type) GetCTRLB_BUSRESET() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x200) >> 9
}
func (o *USB_HOST_Type) SetCTRLB_VBUSOK(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x400)|value<<10)
}
func (o *USB_HOST_Type) GetCTRLB_VBUSOK() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x400) >> 10
}
func (o *USB_HOST_Type) SetCTRLB_L1RESUME(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x800)|value<<11)
}
func (o *USB_HOST_Type) GetCTRLB_L1RESUME() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x800) >> 11
}

// USB_HOST.HSOFC: HOST Host Start Of Frame Control
func (o *USB_HOST_Type) SetHSOFC_FLENC(value uint8) {
	volatile.StoreUint8(&o.HSOFC.Reg, volatile.LoadUint8(&o.HSOFC.Reg)&^(0xf)|value)
}
func (o *USB_HOST_Type) GetHSOFC_FLENC() uint8 {
	return volatile.LoadUint8(&o.HSOFC.Reg) & 0xf
}
func (o *USB_HOST_Type) SetHSOFC_FLENCE(value uint8) {
	volatile.StoreUint8(&o.HSOFC.Reg, volatile.LoadUint8(&o.HSOFC.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetHSOFC_FLENCE() uint8 {
	return (volatile.LoadUint8(&o.HSOFC.Reg) & 0x80) >> 7
}

// USB_HOST.STATUS: HOST Status
func (o *USB_HOST_Type) SetSTATUS_SPEED(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0xc)|value<<2)
}
func (o *USB_HOST_Type) GetSTATUS_SPEED() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0xc) >> 2
}
func (o *USB_HOST_Type) SetSTATUS_LINESTATE(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0xc0)|value<<6)
}
func (o *USB_HOST_Type) GetSTATUS_LINESTATE() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0xc0) >> 6
}

// USB_HOST.FSMSTATUS: Finite State Machine Status
func (o *USB_HOST_Type) SetFSMSTATUS_FSMSTATE(value uint8) {
	volatile.StoreUint8(&o.FSMSTATUS.Reg, volatile.LoadUint8(&o.FSMSTATUS.Reg)&^(0x7f)|value)
}
func (o *USB_HOST_Type) GetFSMSTATUS_FSMSTATE() uint8 {
	return volatile.LoadUint8(&o.FSMSTATUS.Reg) & 0x7f
}

// USB_HOST.FNUM: HOST Host Frame Number
func (o *USB_HOST_Type) SetFNUM_MFNUM(value uint16) {
	volatile.StoreUint16(&o.FNUM.Reg, volatile.LoadUint16(&o.FNUM.Reg)&^(0x7)|value)
}
func (o *USB_HOST_Type) GetFNUM_MFNUM() uint16 {
	return volatile.LoadUint16(&o.FNUM.Reg) & 0x7
}
func (o *USB_HOST_Type) SetFNUM(value uint16) {
	volatile.StoreUint16(&o.FNUM.Reg, volatile.LoadUint16(&o.FNUM.Reg)&^(0x3ff8)|value<<3)
}
func (o *USB_HOST_Type) GetFNUM() uint16 {
	return (volatile.LoadUint16(&o.FNUM.Reg) & 0x3ff8) >> 3
}

// USB_HOST.FLENHIGH: HOST Host Frame Length
func (o *USB_HOST_Type) SetFLENHIGH(value uint8) {
	volatile.StoreUint8(&o.FLENHIGH.Reg, value)
}
func (o *USB_HOST_Type) GetFLENHIGH() uint8 {
	return volatile.LoadUint8(&o.FLENHIGH.Reg)
}

// USB_HOST.INTENCLR: HOST Host Interrupt Enable Clear
func (o *USB_HOST_Type) SetINTENCLR_HSOF(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetINTENCLR_HSOF() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetINTENCLR_RST(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetINTENCLR_RST() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetINTENCLR_WAKEUP(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetINTENCLR_WAKEUP() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetINTENCLR_DNRSM(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetINTENCLR_DNRSM() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *USB_HOST_Type) SetINTENCLR_UPRSM(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetINTENCLR_UPRSM() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetINTENCLR_RAMACER(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetINTENCLR_RAMACER() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *USB_HOST_Type) SetINTENCLR_DCONN(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *USB_HOST_Type) GetINTENCLR_DCONN() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *USB_HOST_Type) SetINTENCLR_DDISC(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *USB_HOST_Type) GetINTENCLR_DDISC() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x200) >> 9
}

// USB_HOST.INTENSET: HOST Host Interrupt Enable Set
func (o *USB_HOST_Type) SetINTENSET_HSOF(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetINTENSET_HSOF() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetINTENSET_RST(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetINTENSET_RST() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetINTENSET_WAKEUP(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetINTENSET_WAKEUP() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetINTENSET_DNRSM(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetINTENSET_DNRSM() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *USB_HOST_Type) SetINTENSET_UPRSM(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetINTENSET_UPRSM() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetINTENSET_RAMACER(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetINTENSET_RAMACER() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *USB_HOST_Type) SetINTENSET_DCONN(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *USB_HOST_Type) GetINTENSET_DCONN() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *USB_HOST_Type) SetINTENSET_DDISC(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *USB_HOST_Type) GetINTENSET_DDISC() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x200) >> 9
}

// USB_HOST.INTFLAG: HOST Host Interrupt Flag
func (o *USB_HOST_Type) SetINTFLAG_HSOF(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetINTFLAG_HSOF() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetINTFLAG_RST(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetINTFLAG_RST() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetINTFLAG_WAKEUP(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetINTFLAG_WAKEUP() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetINTFLAG_DNRSM(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetINTFLAG_DNRSM() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *USB_HOST_Type) SetINTFLAG_UPRSM(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetINTFLAG_UPRSM() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetINTFLAG_RAMACER(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetINTFLAG_RAMACER() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x80) >> 7
}
func (o *USB_HOST_Type) SetINTFLAG_DCONN(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x100)|value<<8)
}
func (o *USB_HOST_Type) GetINTFLAG_DCONN() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x100) >> 8
}
func (o *USB_HOST_Type) SetINTFLAG_DDISC(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x200)|value<<9)
}
func (o *USB_HOST_Type) GetINTFLAG_DDISC() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x200) >> 9
}

// USB_HOST.PINTSMRY: HOST Pipe Interrupt Summary
func (o *USB_HOST_Type) SetPINTSMRY_EPINT0(value uint16) {
	volatile.StoreUint16(&o.PINTSMRY.Reg, volatile.LoadUint16(&o.PINTSMRY.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTSMRY_EPINT0() uint16 {
	return volatile.LoadUint16(&o.PINTSMRY.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTSMRY_EPINT1(value uint16) {
	volatile.StoreUint16(&o.PINTSMRY.Reg, volatile.LoadUint16(&o.PINTSMRY.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTSMRY_EPINT1() uint16 {
	return (volatile.LoadUint16(&o.PINTSMRY.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTSMRY_EPINT2(value uint16) {
	volatile.StoreUint16(&o.PINTSMRY.Reg, volatile.LoadUint16(&o.PINTSMRY.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTSMRY_EPINT2() uint16 {
	return (volatile.LoadUint16(&o.PINTSMRY.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTSMRY_EPINT3(value uint16) {
	volatile.StoreUint16(&o.PINTSMRY.Reg, volatile.LoadUint16(&o.PINTSMRY.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTSMRY_EPINT3() uint16 {
	return (volatile.LoadUint16(&o.PINTSMRY.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTSMRY_EPINT4(value uint16) {
	volatile.StoreUint16(&o.PINTSMRY.Reg, volatile.LoadUint16(&o.PINTSMRY.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTSMRY_EPINT4() uint16 {
	return (volatile.LoadUint16(&o.PINTSMRY.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTSMRY_EPINT5(value uint16) {
	volatile.StoreUint16(&o.PINTSMRY.Reg, volatile.LoadUint16(&o.PINTSMRY.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTSMRY_EPINT5() uint16 {
	return (volatile.LoadUint16(&o.PINTSMRY.Reg) & 0x20) >> 5
}
func (o *USB_HOST_Type) SetPINTSMRY_EPINT6(value uint16) {
	volatile.StoreUint16(&o.PINTSMRY.Reg, volatile.LoadUint16(&o.PINTSMRY.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPINTSMRY_EPINT6() uint16 {
	return (volatile.LoadUint16(&o.PINTSMRY.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPINTSMRY_EPINT7(value uint16) {
	volatile.StoreUint16(&o.PINTSMRY.Reg, volatile.LoadUint16(&o.PINTSMRY.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPINTSMRY_EPINT7() uint16 {
	return (volatile.LoadUint16(&o.PINTSMRY.Reg) & 0x80) >> 7
}

// USB_HOST.DESCADD: Descriptor Address
func (o *USB_HOST_Type) SetDESCADD(value uint32) {
	volatile.StoreUint32(&o.DESCADD.Reg, value)
}
func (o *USB_HOST_Type) GetDESCADD() uint32 {
	return volatile.LoadUint32(&o.DESCADD.Reg)
}

// USB_HOST.PADCAL: USB PAD Calibration
func (o *USB_HOST_Type) SetPADCAL_TRANSP(value uint16) {
	volatile.StoreUint16(&o.PADCAL.Reg, volatile.LoadUint16(&o.PADCAL.Reg)&^(0x1f)|value)
}
func (o *USB_HOST_Type) GetPADCAL_TRANSP() uint16 {
	return volatile.LoadUint16(&o.PADCAL.Reg) & 0x1f
}
func (o *USB_HOST_Type) SetPADCAL_TRANSN(value uint16) {
	volatile.StoreUint16(&o.PADCAL.Reg, volatile.LoadUint16(&o.PADCAL.Reg)&^(0x7c0)|value<<6)
}
func (o *USB_HOST_Type) GetPADCAL_TRANSN() uint16 {
	return (volatile.LoadUint16(&o.PADCAL.Reg) & 0x7c0) >> 6
}
func (o *USB_HOST_Type) SetPADCAL_TRIM(value uint16) {
	volatile.StoreUint16(&o.PADCAL.Reg, volatile.LoadUint16(&o.PADCAL.Reg)&^(0x7000)|value<<12)
}
func (o *USB_HOST_Type) GetPADCAL_TRIM() uint16 {
	return (volatile.LoadUint16(&o.PADCAL.Reg) & 0x7000) >> 12
}

// USB_HOST.PCFG0: HOST End Point Configuration
func (o *USB_HOST_Type) SetPCFG0_PTOKEN(value uint8) {
	volatile.StoreUint8(&o.PCFG0.Reg, volatile.LoadUint8(&o.PCFG0.Reg)&^(0x3)|value)
}
func (o *USB_HOST_Type) GetPCFG0_PTOKEN() uint8 {
	return volatile.LoadUint8(&o.PCFG0.Reg) & 0x3
}
func (o *USB_HOST_Type) SetPCFG0_BK(value uint8) {
	volatile.StoreUint8(&o.PCFG0.Reg, volatile.LoadUint8(&o.PCFG0.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPCFG0_BK() uint8 {
	return (volatile.LoadUint8(&o.PCFG0.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPCFG0_PTYPE(value uint8) {
	volatile.StoreUint8(&o.PCFG0.Reg, volatile.LoadUint8(&o.PCFG0.Reg)&^(0x38)|value<<3)
}
func (o *USB_HOST_Type) GetPCFG0_PTYPE() uint8 {
	return (volatile.LoadUint8(&o.PCFG0.Reg) & 0x38) >> 3
}

// USB_HOST.BINTERVAL0: HOST Bus Access Period of Pipe
func (o *USB_HOST_Type) SetBINTERVAL0(value uint8) {
	volatile.StoreUint8(&o.BINTERVAL0.Reg, value)
}
func (o *USB_HOST_Type) GetBINTERVAL0() uint8 {
	return volatile.LoadUint8(&o.BINTERVAL0.Reg)
}

// USB_HOST.PSTATUSCLR0: HOST End Point Pipe Status Clear
func (o *USB_HOST_Type) SetPSTATUSCLR0_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR0.Reg, volatile.LoadUint8(&o.PSTATUSCLR0.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUSCLR0_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUSCLR0.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUSCLR0_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR0.Reg, volatile.LoadUint8(&o.PSTATUSCLR0.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUSCLR0_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR0.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUSCLR0_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR0.Reg, volatile.LoadUint8(&o.PSTATUSCLR0.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUSCLR0_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR0.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUSCLR0_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR0.Reg, volatile.LoadUint8(&o.PSTATUSCLR0.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUSCLR0_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR0.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUSCLR0_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR0.Reg, volatile.LoadUint8(&o.PSTATUSCLR0.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUSCLR0_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR0.Reg) & 0x80) >> 7
}

// USB_HOST.PSTATUSSET0: HOST End Point Pipe Status Set
func (o *USB_HOST_Type) SetPSTATUSSET0_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET0.Reg, volatile.LoadUint8(&o.PSTATUSSET0.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUSSET0_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUSSET0.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUSSET0_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET0.Reg, volatile.LoadUint8(&o.PSTATUSSET0.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUSSET0_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET0.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUSSET0_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET0.Reg, volatile.LoadUint8(&o.PSTATUSSET0.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUSSET0_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET0.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUSSET0_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET0.Reg, volatile.LoadUint8(&o.PSTATUSSET0.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUSSET0_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET0.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUSSET0_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET0.Reg, volatile.LoadUint8(&o.PSTATUSSET0.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUSSET0_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET0.Reg) & 0x80) >> 7
}

// USB_HOST.PSTATUS0: HOST End Point Pipe Status
func (o *USB_HOST_Type) SetPSTATUS0_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUS0.Reg, volatile.LoadUint8(&o.PSTATUS0.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUS0_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUS0.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUS0_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUS0.Reg, volatile.LoadUint8(&o.PSTATUS0.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUS0_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS0.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUS0_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUS0.Reg, volatile.LoadUint8(&o.PSTATUS0.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUS0_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS0.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUS0_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUS0.Reg, volatile.LoadUint8(&o.PSTATUS0.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUS0_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS0.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUS0_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUS0.Reg, volatile.LoadUint8(&o.PSTATUS0.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUS0_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS0.Reg) & 0x80) >> 7
}

// USB_HOST.PINTFLAG0: HOST Pipe Interrupt Flag
func (o *USB_HOST_Type) SetPINTFLAG0_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG0.Reg, volatile.LoadUint8(&o.PINTFLAG0.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTFLAG0_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTFLAG0.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTFLAG0_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG0.Reg, volatile.LoadUint8(&o.PINTFLAG0.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTFLAG0_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG0.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTFLAG0_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG0.Reg, volatile.LoadUint8(&o.PINTFLAG0.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTFLAG0_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG0.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTFLAG0_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG0.Reg, volatile.LoadUint8(&o.PINTFLAG0.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTFLAG0_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG0.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTFLAG0_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG0.Reg, volatile.LoadUint8(&o.PINTFLAG0.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTFLAG0_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG0.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTFLAG0_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG0.Reg, volatile.LoadUint8(&o.PINTFLAG0.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTFLAG0_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG0.Reg) & 0x20) >> 5
}

// USB_HOST.PINTENCLR0: HOST Pipe Interrupt Flag Clear
func (o *USB_HOST_Type) SetPINTENCLR0_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR0.Reg, volatile.LoadUint8(&o.PINTENCLR0.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTENCLR0_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTENCLR0.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTENCLR0_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR0.Reg, volatile.LoadUint8(&o.PINTENCLR0.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTENCLR0_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR0.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTENCLR0_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR0.Reg, volatile.LoadUint8(&o.PINTENCLR0.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTENCLR0_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR0.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTENCLR0_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR0.Reg, volatile.LoadUint8(&o.PINTENCLR0.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTENCLR0_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR0.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTENCLR0_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR0.Reg, volatile.LoadUint8(&o.PINTENCLR0.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTENCLR0_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR0.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTENCLR0_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR0.Reg, volatile.LoadUint8(&o.PINTENCLR0.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTENCLR0_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR0.Reg) & 0x20) >> 5
}

// USB_HOST.PINTENSET0: HOST Pipe Interrupt Flag Set
func (o *USB_HOST_Type) SetPINTENSET0_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTENSET0.Reg, volatile.LoadUint8(&o.PINTENSET0.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTENSET0_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTENSET0.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTENSET0_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTENSET0.Reg, volatile.LoadUint8(&o.PINTENSET0.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTENSET0_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET0.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTENSET0_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTENSET0.Reg, volatile.LoadUint8(&o.PINTENSET0.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTENSET0_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET0.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTENSET0_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTENSET0.Reg, volatile.LoadUint8(&o.PINTENSET0.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTENSET0_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET0.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTENSET0_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTENSET0.Reg, volatile.LoadUint8(&o.PINTENSET0.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTENSET0_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET0.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTENSET0_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTENSET0.Reg, volatile.LoadUint8(&o.PINTENSET0.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTENSET0_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET0.Reg) & 0x20) >> 5
}

// USB_HOST.PCFG1: HOST End Point Configuration
func (o *USB_HOST_Type) SetPCFG1_PTOKEN(value uint8) {
	volatile.StoreUint8(&o.PCFG1.Reg, volatile.LoadUint8(&o.PCFG1.Reg)&^(0x3)|value)
}
func (o *USB_HOST_Type) GetPCFG1_PTOKEN() uint8 {
	return volatile.LoadUint8(&o.PCFG1.Reg) & 0x3
}
func (o *USB_HOST_Type) SetPCFG1_BK(value uint8) {
	volatile.StoreUint8(&o.PCFG1.Reg, volatile.LoadUint8(&o.PCFG1.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPCFG1_BK() uint8 {
	return (volatile.LoadUint8(&o.PCFG1.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPCFG1_PTYPE(value uint8) {
	volatile.StoreUint8(&o.PCFG1.Reg, volatile.LoadUint8(&o.PCFG1.Reg)&^(0x38)|value<<3)
}
func (o *USB_HOST_Type) GetPCFG1_PTYPE() uint8 {
	return (volatile.LoadUint8(&o.PCFG1.Reg) & 0x38) >> 3
}

// USB_HOST.BINTERVAL1: HOST Bus Access Period of Pipe
func (o *USB_HOST_Type) SetBINTERVAL1(value uint8) {
	volatile.StoreUint8(&o.BINTERVAL1.Reg, value)
}
func (o *USB_HOST_Type) GetBINTERVAL1() uint8 {
	return volatile.LoadUint8(&o.BINTERVAL1.Reg)
}

// USB_HOST.PSTATUSCLR1: HOST End Point Pipe Status Clear
func (o *USB_HOST_Type) SetPSTATUSCLR1_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR1.Reg, volatile.LoadUint8(&o.PSTATUSCLR1.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUSCLR1_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUSCLR1.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUSCLR1_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR1.Reg, volatile.LoadUint8(&o.PSTATUSCLR1.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUSCLR1_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR1.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUSCLR1_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR1.Reg, volatile.LoadUint8(&o.PSTATUSCLR1.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUSCLR1_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR1.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUSCLR1_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR1.Reg, volatile.LoadUint8(&o.PSTATUSCLR1.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUSCLR1_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR1.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUSCLR1_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR1.Reg, volatile.LoadUint8(&o.PSTATUSCLR1.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUSCLR1_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR1.Reg) & 0x80) >> 7
}

// USB_HOST.PSTATUSSET1: HOST End Point Pipe Status Set
func (o *USB_HOST_Type) SetPSTATUSSET1_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET1.Reg, volatile.LoadUint8(&o.PSTATUSSET1.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUSSET1_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUSSET1.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUSSET1_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET1.Reg, volatile.LoadUint8(&o.PSTATUSSET1.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUSSET1_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET1.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUSSET1_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET1.Reg, volatile.LoadUint8(&o.PSTATUSSET1.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUSSET1_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET1.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUSSET1_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET1.Reg, volatile.LoadUint8(&o.PSTATUSSET1.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUSSET1_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET1.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUSSET1_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET1.Reg, volatile.LoadUint8(&o.PSTATUSSET1.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUSSET1_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET1.Reg) & 0x80) >> 7
}

// USB_HOST.PSTATUS1: HOST End Point Pipe Status
func (o *USB_HOST_Type) SetPSTATUS1_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUS1.Reg, volatile.LoadUint8(&o.PSTATUS1.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUS1_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUS1.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUS1_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUS1.Reg, volatile.LoadUint8(&o.PSTATUS1.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUS1_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS1.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUS1_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUS1.Reg, volatile.LoadUint8(&o.PSTATUS1.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUS1_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS1.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUS1_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUS1.Reg, volatile.LoadUint8(&o.PSTATUS1.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUS1_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS1.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUS1_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUS1.Reg, volatile.LoadUint8(&o.PSTATUS1.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUS1_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS1.Reg) & 0x80) >> 7
}

// USB_HOST.PINTFLAG1: HOST Pipe Interrupt Flag
func (o *USB_HOST_Type) SetPINTFLAG1_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG1.Reg, volatile.LoadUint8(&o.PINTFLAG1.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTFLAG1_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTFLAG1.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTFLAG1_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG1.Reg, volatile.LoadUint8(&o.PINTFLAG1.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTFLAG1_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG1.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTFLAG1_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG1.Reg, volatile.LoadUint8(&o.PINTFLAG1.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTFLAG1_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG1.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTFLAG1_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG1.Reg, volatile.LoadUint8(&o.PINTFLAG1.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTFLAG1_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG1.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTFLAG1_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG1.Reg, volatile.LoadUint8(&o.PINTFLAG1.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTFLAG1_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG1.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTFLAG1_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG1.Reg, volatile.LoadUint8(&o.PINTFLAG1.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTFLAG1_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG1.Reg) & 0x20) >> 5
}

// USB_HOST.PINTENCLR1: HOST Pipe Interrupt Flag Clear
func (o *USB_HOST_Type) SetPINTENCLR1_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR1.Reg, volatile.LoadUint8(&o.PINTENCLR1.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTENCLR1_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTENCLR1.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTENCLR1_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR1.Reg, volatile.LoadUint8(&o.PINTENCLR1.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTENCLR1_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR1.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTENCLR1_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR1.Reg, volatile.LoadUint8(&o.PINTENCLR1.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTENCLR1_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR1.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTENCLR1_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR1.Reg, volatile.LoadUint8(&o.PINTENCLR1.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTENCLR1_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR1.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTENCLR1_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR1.Reg, volatile.LoadUint8(&o.PINTENCLR1.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTENCLR1_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR1.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTENCLR1_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR1.Reg, volatile.LoadUint8(&o.PINTENCLR1.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTENCLR1_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR1.Reg) & 0x20) >> 5
}

// USB_HOST.PINTENSET1: HOST Pipe Interrupt Flag Set
func (o *USB_HOST_Type) SetPINTENSET1_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTENSET1.Reg, volatile.LoadUint8(&o.PINTENSET1.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTENSET1_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTENSET1.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTENSET1_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTENSET1.Reg, volatile.LoadUint8(&o.PINTENSET1.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTENSET1_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET1.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTENSET1_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTENSET1.Reg, volatile.LoadUint8(&o.PINTENSET1.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTENSET1_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET1.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTENSET1_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTENSET1.Reg, volatile.LoadUint8(&o.PINTENSET1.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTENSET1_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET1.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTENSET1_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTENSET1.Reg, volatile.LoadUint8(&o.PINTENSET1.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTENSET1_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET1.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTENSET1_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTENSET1.Reg, volatile.LoadUint8(&o.PINTENSET1.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTENSET1_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET1.Reg) & 0x20) >> 5
}

// USB_HOST.PCFG2: HOST End Point Configuration
func (o *USB_HOST_Type) SetPCFG2_PTOKEN(value uint8) {
	volatile.StoreUint8(&o.PCFG2.Reg, volatile.LoadUint8(&o.PCFG2.Reg)&^(0x3)|value)
}
func (o *USB_HOST_Type) GetPCFG2_PTOKEN() uint8 {
	return volatile.LoadUint8(&o.PCFG2.Reg) & 0x3
}
func (o *USB_HOST_Type) SetPCFG2_BK(value uint8) {
	volatile.StoreUint8(&o.PCFG2.Reg, volatile.LoadUint8(&o.PCFG2.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPCFG2_BK() uint8 {
	return (volatile.LoadUint8(&o.PCFG2.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPCFG2_PTYPE(value uint8) {
	volatile.StoreUint8(&o.PCFG2.Reg, volatile.LoadUint8(&o.PCFG2.Reg)&^(0x38)|value<<3)
}
func (o *USB_HOST_Type) GetPCFG2_PTYPE() uint8 {
	return (volatile.LoadUint8(&o.PCFG2.Reg) & 0x38) >> 3
}

// USB_HOST.BINTERVAL2: HOST Bus Access Period of Pipe
func (o *USB_HOST_Type) SetBINTERVAL2(value uint8) {
	volatile.StoreUint8(&o.BINTERVAL2.Reg, value)
}
func (o *USB_HOST_Type) GetBINTERVAL2() uint8 {
	return volatile.LoadUint8(&o.BINTERVAL2.Reg)
}

// USB_HOST.PSTATUSCLR2: HOST End Point Pipe Status Clear
func (o *USB_HOST_Type) SetPSTATUSCLR2_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR2.Reg, volatile.LoadUint8(&o.PSTATUSCLR2.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUSCLR2_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUSCLR2.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUSCLR2_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR2.Reg, volatile.LoadUint8(&o.PSTATUSCLR2.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUSCLR2_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR2.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUSCLR2_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR2.Reg, volatile.LoadUint8(&o.PSTATUSCLR2.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUSCLR2_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR2.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUSCLR2_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR2.Reg, volatile.LoadUint8(&o.PSTATUSCLR2.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUSCLR2_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR2.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUSCLR2_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR2.Reg, volatile.LoadUint8(&o.PSTATUSCLR2.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUSCLR2_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR2.Reg) & 0x80) >> 7
}

// USB_HOST.PSTATUSSET2: HOST End Point Pipe Status Set
func (o *USB_HOST_Type) SetPSTATUSSET2_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET2.Reg, volatile.LoadUint8(&o.PSTATUSSET2.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUSSET2_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUSSET2.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUSSET2_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET2.Reg, volatile.LoadUint8(&o.PSTATUSSET2.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUSSET2_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET2.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUSSET2_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET2.Reg, volatile.LoadUint8(&o.PSTATUSSET2.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUSSET2_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET2.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUSSET2_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET2.Reg, volatile.LoadUint8(&o.PSTATUSSET2.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUSSET2_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET2.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUSSET2_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET2.Reg, volatile.LoadUint8(&o.PSTATUSSET2.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUSSET2_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET2.Reg) & 0x80) >> 7
}

// USB_HOST.PSTATUS2: HOST End Point Pipe Status
func (o *USB_HOST_Type) SetPSTATUS2_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUS2.Reg, volatile.LoadUint8(&o.PSTATUS2.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUS2_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUS2.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUS2_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUS2.Reg, volatile.LoadUint8(&o.PSTATUS2.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUS2_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS2.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUS2_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUS2.Reg, volatile.LoadUint8(&o.PSTATUS2.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUS2_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS2.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUS2_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUS2.Reg, volatile.LoadUint8(&o.PSTATUS2.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUS2_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS2.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUS2_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUS2.Reg, volatile.LoadUint8(&o.PSTATUS2.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUS2_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS2.Reg) & 0x80) >> 7
}

// USB_HOST.PINTFLAG2: HOST Pipe Interrupt Flag
func (o *USB_HOST_Type) SetPINTFLAG2_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG2.Reg, volatile.LoadUint8(&o.PINTFLAG2.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTFLAG2_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTFLAG2.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTFLAG2_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG2.Reg, volatile.LoadUint8(&o.PINTFLAG2.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTFLAG2_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG2.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTFLAG2_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG2.Reg, volatile.LoadUint8(&o.PINTFLAG2.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTFLAG2_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG2.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTFLAG2_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG2.Reg, volatile.LoadUint8(&o.PINTFLAG2.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTFLAG2_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG2.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTFLAG2_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG2.Reg, volatile.LoadUint8(&o.PINTFLAG2.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTFLAG2_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG2.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTFLAG2_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG2.Reg, volatile.LoadUint8(&o.PINTFLAG2.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTFLAG2_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG2.Reg) & 0x20) >> 5
}

// USB_HOST.PINTENCLR2: HOST Pipe Interrupt Flag Clear
func (o *USB_HOST_Type) SetPINTENCLR2_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR2.Reg, volatile.LoadUint8(&o.PINTENCLR2.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTENCLR2_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTENCLR2.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTENCLR2_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR2.Reg, volatile.LoadUint8(&o.PINTENCLR2.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTENCLR2_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR2.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTENCLR2_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR2.Reg, volatile.LoadUint8(&o.PINTENCLR2.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTENCLR2_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR2.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTENCLR2_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR2.Reg, volatile.LoadUint8(&o.PINTENCLR2.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTENCLR2_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR2.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTENCLR2_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR2.Reg, volatile.LoadUint8(&o.PINTENCLR2.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTENCLR2_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR2.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTENCLR2_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR2.Reg, volatile.LoadUint8(&o.PINTENCLR2.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTENCLR2_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR2.Reg) & 0x20) >> 5
}

// USB_HOST.PINTENSET2: HOST Pipe Interrupt Flag Set
func (o *USB_HOST_Type) SetPINTENSET2_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTENSET2.Reg, volatile.LoadUint8(&o.PINTENSET2.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTENSET2_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTENSET2.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTENSET2_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTENSET2.Reg, volatile.LoadUint8(&o.PINTENSET2.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTENSET2_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET2.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTENSET2_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTENSET2.Reg, volatile.LoadUint8(&o.PINTENSET2.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTENSET2_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET2.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTENSET2_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTENSET2.Reg, volatile.LoadUint8(&o.PINTENSET2.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTENSET2_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET2.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTENSET2_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTENSET2.Reg, volatile.LoadUint8(&o.PINTENSET2.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTENSET2_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET2.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTENSET2_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTENSET2.Reg, volatile.LoadUint8(&o.PINTENSET2.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTENSET2_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET2.Reg) & 0x20) >> 5
}

// USB_HOST.PCFG3: HOST End Point Configuration
func (o *USB_HOST_Type) SetPCFG3_PTOKEN(value uint8) {
	volatile.StoreUint8(&o.PCFG3.Reg, volatile.LoadUint8(&o.PCFG3.Reg)&^(0x3)|value)
}
func (o *USB_HOST_Type) GetPCFG3_PTOKEN() uint8 {
	return volatile.LoadUint8(&o.PCFG3.Reg) & 0x3
}
func (o *USB_HOST_Type) SetPCFG3_BK(value uint8) {
	volatile.StoreUint8(&o.PCFG3.Reg, volatile.LoadUint8(&o.PCFG3.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPCFG3_BK() uint8 {
	return (volatile.LoadUint8(&o.PCFG3.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPCFG3_PTYPE(value uint8) {
	volatile.StoreUint8(&o.PCFG3.Reg, volatile.LoadUint8(&o.PCFG3.Reg)&^(0x38)|value<<3)
}
func (o *USB_HOST_Type) GetPCFG3_PTYPE() uint8 {
	return (volatile.LoadUint8(&o.PCFG3.Reg) & 0x38) >> 3
}

// USB_HOST.BINTERVAL3: HOST Bus Access Period of Pipe
func (o *USB_HOST_Type) SetBINTERVAL3(value uint8) {
	volatile.StoreUint8(&o.BINTERVAL3.Reg, value)
}
func (o *USB_HOST_Type) GetBINTERVAL3() uint8 {
	return volatile.LoadUint8(&o.BINTERVAL3.Reg)
}

// USB_HOST.PSTATUSCLR3: HOST End Point Pipe Status Clear
func (o *USB_HOST_Type) SetPSTATUSCLR3_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR3.Reg, volatile.LoadUint8(&o.PSTATUSCLR3.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUSCLR3_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUSCLR3.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUSCLR3_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR3.Reg, volatile.LoadUint8(&o.PSTATUSCLR3.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUSCLR3_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR3.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUSCLR3_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR3.Reg, volatile.LoadUint8(&o.PSTATUSCLR3.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUSCLR3_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR3.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUSCLR3_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR3.Reg, volatile.LoadUint8(&o.PSTATUSCLR3.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUSCLR3_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR3.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUSCLR3_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR3.Reg, volatile.LoadUint8(&o.PSTATUSCLR3.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUSCLR3_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR3.Reg) & 0x80) >> 7
}

// USB_HOST.PSTATUSSET3: HOST End Point Pipe Status Set
func (o *USB_HOST_Type) SetPSTATUSSET3_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET3.Reg, volatile.LoadUint8(&o.PSTATUSSET3.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUSSET3_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUSSET3.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUSSET3_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET3.Reg, volatile.LoadUint8(&o.PSTATUSSET3.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUSSET3_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET3.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUSSET3_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET3.Reg, volatile.LoadUint8(&o.PSTATUSSET3.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUSSET3_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET3.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUSSET3_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET3.Reg, volatile.LoadUint8(&o.PSTATUSSET3.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUSSET3_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET3.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUSSET3_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET3.Reg, volatile.LoadUint8(&o.PSTATUSSET3.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUSSET3_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET3.Reg) & 0x80) >> 7
}

// USB_HOST.PSTATUS3: HOST End Point Pipe Status
func (o *USB_HOST_Type) SetPSTATUS3_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUS3.Reg, volatile.LoadUint8(&o.PSTATUS3.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUS3_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUS3.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUS3_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUS3.Reg, volatile.LoadUint8(&o.PSTATUS3.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUS3_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS3.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUS3_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUS3.Reg, volatile.LoadUint8(&o.PSTATUS3.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUS3_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS3.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUS3_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUS3.Reg, volatile.LoadUint8(&o.PSTATUS3.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUS3_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS3.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUS3_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUS3.Reg, volatile.LoadUint8(&o.PSTATUS3.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUS3_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS3.Reg) & 0x80) >> 7
}

// USB_HOST.PINTFLAG3: HOST Pipe Interrupt Flag
func (o *USB_HOST_Type) SetPINTFLAG3_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG3.Reg, volatile.LoadUint8(&o.PINTFLAG3.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTFLAG3_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTFLAG3.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTFLAG3_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG3.Reg, volatile.LoadUint8(&o.PINTFLAG3.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTFLAG3_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG3.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTFLAG3_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG3.Reg, volatile.LoadUint8(&o.PINTFLAG3.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTFLAG3_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG3.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTFLAG3_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG3.Reg, volatile.LoadUint8(&o.PINTFLAG3.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTFLAG3_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG3.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTFLAG3_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG3.Reg, volatile.LoadUint8(&o.PINTFLAG3.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTFLAG3_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG3.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTFLAG3_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG3.Reg, volatile.LoadUint8(&o.PINTFLAG3.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTFLAG3_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG3.Reg) & 0x20) >> 5
}

// USB_HOST.PINTENCLR3: HOST Pipe Interrupt Flag Clear
func (o *USB_HOST_Type) SetPINTENCLR3_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR3.Reg, volatile.LoadUint8(&o.PINTENCLR3.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTENCLR3_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTENCLR3.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTENCLR3_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR3.Reg, volatile.LoadUint8(&o.PINTENCLR3.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTENCLR3_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR3.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTENCLR3_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR3.Reg, volatile.LoadUint8(&o.PINTENCLR3.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTENCLR3_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR3.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTENCLR3_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR3.Reg, volatile.LoadUint8(&o.PINTENCLR3.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTENCLR3_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR3.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTENCLR3_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR3.Reg, volatile.LoadUint8(&o.PINTENCLR3.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTENCLR3_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR3.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTENCLR3_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR3.Reg, volatile.LoadUint8(&o.PINTENCLR3.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTENCLR3_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR3.Reg) & 0x20) >> 5
}

// USB_HOST.PINTENSET3: HOST Pipe Interrupt Flag Set
func (o *USB_HOST_Type) SetPINTENSET3_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTENSET3.Reg, volatile.LoadUint8(&o.PINTENSET3.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTENSET3_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTENSET3.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTENSET3_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTENSET3.Reg, volatile.LoadUint8(&o.PINTENSET3.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTENSET3_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET3.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTENSET3_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTENSET3.Reg, volatile.LoadUint8(&o.PINTENSET3.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTENSET3_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET3.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTENSET3_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTENSET3.Reg, volatile.LoadUint8(&o.PINTENSET3.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTENSET3_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET3.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTENSET3_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTENSET3.Reg, volatile.LoadUint8(&o.PINTENSET3.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTENSET3_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET3.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTENSET3_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTENSET3.Reg, volatile.LoadUint8(&o.PINTENSET3.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTENSET3_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET3.Reg) & 0x20) >> 5
}

// USB_HOST.PCFG4: HOST End Point Configuration
func (o *USB_HOST_Type) SetPCFG4_PTOKEN(value uint8) {
	volatile.StoreUint8(&o.PCFG4.Reg, volatile.LoadUint8(&o.PCFG4.Reg)&^(0x3)|value)
}
func (o *USB_HOST_Type) GetPCFG4_PTOKEN() uint8 {
	return volatile.LoadUint8(&o.PCFG4.Reg) & 0x3
}
func (o *USB_HOST_Type) SetPCFG4_BK(value uint8) {
	volatile.StoreUint8(&o.PCFG4.Reg, volatile.LoadUint8(&o.PCFG4.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPCFG4_BK() uint8 {
	return (volatile.LoadUint8(&o.PCFG4.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPCFG4_PTYPE(value uint8) {
	volatile.StoreUint8(&o.PCFG4.Reg, volatile.LoadUint8(&o.PCFG4.Reg)&^(0x38)|value<<3)
}
func (o *USB_HOST_Type) GetPCFG4_PTYPE() uint8 {
	return (volatile.LoadUint8(&o.PCFG4.Reg) & 0x38) >> 3
}

// USB_HOST.BINTERVAL4: HOST Bus Access Period of Pipe
func (o *USB_HOST_Type) SetBINTERVAL4(value uint8) {
	volatile.StoreUint8(&o.BINTERVAL4.Reg, value)
}
func (o *USB_HOST_Type) GetBINTERVAL4() uint8 {
	return volatile.LoadUint8(&o.BINTERVAL4.Reg)
}

// USB_HOST.PSTATUSCLR4: HOST End Point Pipe Status Clear
func (o *USB_HOST_Type) SetPSTATUSCLR4_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR4.Reg, volatile.LoadUint8(&o.PSTATUSCLR4.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUSCLR4_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUSCLR4.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUSCLR4_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR4.Reg, volatile.LoadUint8(&o.PSTATUSCLR4.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUSCLR4_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR4.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUSCLR4_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR4.Reg, volatile.LoadUint8(&o.PSTATUSCLR4.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUSCLR4_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR4.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUSCLR4_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR4.Reg, volatile.LoadUint8(&o.PSTATUSCLR4.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUSCLR4_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR4.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUSCLR4_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR4.Reg, volatile.LoadUint8(&o.PSTATUSCLR4.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUSCLR4_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR4.Reg) & 0x80) >> 7
}

// USB_HOST.PSTATUSSET4: HOST End Point Pipe Status Set
func (o *USB_HOST_Type) SetPSTATUSSET4_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET4.Reg, volatile.LoadUint8(&o.PSTATUSSET4.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUSSET4_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUSSET4.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUSSET4_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET4.Reg, volatile.LoadUint8(&o.PSTATUSSET4.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUSSET4_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET4.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUSSET4_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET4.Reg, volatile.LoadUint8(&o.PSTATUSSET4.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUSSET4_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET4.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUSSET4_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET4.Reg, volatile.LoadUint8(&o.PSTATUSSET4.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUSSET4_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET4.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUSSET4_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET4.Reg, volatile.LoadUint8(&o.PSTATUSSET4.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUSSET4_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET4.Reg) & 0x80) >> 7
}

// USB_HOST.PSTATUS4: HOST End Point Pipe Status
func (o *USB_HOST_Type) SetPSTATUS4_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUS4.Reg, volatile.LoadUint8(&o.PSTATUS4.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUS4_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUS4.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUS4_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUS4.Reg, volatile.LoadUint8(&o.PSTATUS4.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUS4_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS4.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUS4_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUS4.Reg, volatile.LoadUint8(&o.PSTATUS4.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUS4_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS4.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUS4_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUS4.Reg, volatile.LoadUint8(&o.PSTATUS4.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUS4_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS4.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUS4_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUS4.Reg, volatile.LoadUint8(&o.PSTATUS4.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUS4_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS4.Reg) & 0x80) >> 7
}

// USB_HOST.PINTFLAG4: HOST Pipe Interrupt Flag
func (o *USB_HOST_Type) SetPINTFLAG4_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG4.Reg, volatile.LoadUint8(&o.PINTFLAG4.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTFLAG4_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTFLAG4.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTFLAG4_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG4.Reg, volatile.LoadUint8(&o.PINTFLAG4.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTFLAG4_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG4.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTFLAG4_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG4.Reg, volatile.LoadUint8(&o.PINTFLAG4.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTFLAG4_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG4.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTFLAG4_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG4.Reg, volatile.LoadUint8(&o.PINTFLAG4.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTFLAG4_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG4.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTFLAG4_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG4.Reg, volatile.LoadUint8(&o.PINTFLAG4.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTFLAG4_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG4.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTFLAG4_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG4.Reg, volatile.LoadUint8(&o.PINTFLAG4.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTFLAG4_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG4.Reg) & 0x20) >> 5
}

// USB_HOST.PINTENCLR4: HOST Pipe Interrupt Flag Clear
func (o *USB_HOST_Type) SetPINTENCLR4_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR4.Reg, volatile.LoadUint8(&o.PINTENCLR4.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTENCLR4_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTENCLR4.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTENCLR4_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR4.Reg, volatile.LoadUint8(&o.PINTENCLR4.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTENCLR4_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR4.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTENCLR4_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR4.Reg, volatile.LoadUint8(&o.PINTENCLR4.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTENCLR4_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR4.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTENCLR4_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR4.Reg, volatile.LoadUint8(&o.PINTENCLR4.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTENCLR4_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR4.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTENCLR4_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR4.Reg, volatile.LoadUint8(&o.PINTENCLR4.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTENCLR4_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR4.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTENCLR4_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR4.Reg, volatile.LoadUint8(&o.PINTENCLR4.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTENCLR4_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR4.Reg) & 0x20) >> 5
}

// USB_HOST.PINTENSET4: HOST Pipe Interrupt Flag Set
func (o *USB_HOST_Type) SetPINTENSET4_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTENSET4.Reg, volatile.LoadUint8(&o.PINTENSET4.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTENSET4_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTENSET4.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTENSET4_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTENSET4.Reg, volatile.LoadUint8(&o.PINTENSET4.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTENSET4_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET4.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTENSET4_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTENSET4.Reg, volatile.LoadUint8(&o.PINTENSET4.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTENSET4_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET4.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTENSET4_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTENSET4.Reg, volatile.LoadUint8(&o.PINTENSET4.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTENSET4_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET4.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTENSET4_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTENSET4.Reg, volatile.LoadUint8(&o.PINTENSET4.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTENSET4_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET4.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTENSET4_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTENSET4.Reg, volatile.LoadUint8(&o.PINTENSET4.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTENSET4_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET4.Reg) & 0x20) >> 5
}

// USB_HOST.PCFG5: HOST End Point Configuration
func (o *USB_HOST_Type) SetPCFG5_PTOKEN(value uint8) {
	volatile.StoreUint8(&o.PCFG5.Reg, volatile.LoadUint8(&o.PCFG5.Reg)&^(0x3)|value)
}
func (o *USB_HOST_Type) GetPCFG5_PTOKEN() uint8 {
	return volatile.LoadUint8(&o.PCFG5.Reg) & 0x3
}
func (o *USB_HOST_Type) SetPCFG5_BK(value uint8) {
	volatile.StoreUint8(&o.PCFG5.Reg, volatile.LoadUint8(&o.PCFG5.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPCFG5_BK() uint8 {
	return (volatile.LoadUint8(&o.PCFG5.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPCFG5_PTYPE(value uint8) {
	volatile.StoreUint8(&o.PCFG5.Reg, volatile.LoadUint8(&o.PCFG5.Reg)&^(0x38)|value<<3)
}
func (o *USB_HOST_Type) GetPCFG5_PTYPE() uint8 {
	return (volatile.LoadUint8(&o.PCFG5.Reg) & 0x38) >> 3
}

// USB_HOST.BINTERVAL5: HOST Bus Access Period of Pipe
func (o *USB_HOST_Type) SetBINTERVAL5(value uint8) {
	volatile.StoreUint8(&o.BINTERVAL5.Reg, value)
}
func (o *USB_HOST_Type) GetBINTERVAL5() uint8 {
	return volatile.LoadUint8(&o.BINTERVAL5.Reg)
}

// USB_HOST.PSTATUSCLR5: HOST End Point Pipe Status Clear
func (o *USB_HOST_Type) SetPSTATUSCLR5_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR5.Reg, volatile.LoadUint8(&o.PSTATUSCLR5.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUSCLR5_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUSCLR5.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUSCLR5_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR5.Reg, volatile.LoadUint8(&o.PSTATUSCLR5.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUSCLR5_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR5.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUSCLR5_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR5.Reg, volatile.LoadUint8(&o.PSTATUSCLR5.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUSCLR5_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR5.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUSCLR5_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR5.Reg, volatile.LoadUint8(&o.PSTATUSCLR5.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUSCLR5_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR5.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUSCLR5_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR5.Reg, volatile.LoadUint8(&o.PSTATUSCLR5.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUSCLR5_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR5.Reg) & 0x80) >> 7
}

// USB_HOST.PSTATUSSET5: HOST End Point Pipe Status Set
func (o *USB_HOST_Type) SetPSTATUSSET5_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET5.Reg, volatile.LoadUint8(&o.PSTATUSSET5.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUSSET5_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUSSET5.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUSSET5_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET5.Reg, volatile.LoadUint8(&o.PSTATUSSET5.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUSSET5_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET5.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUSSET5_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET5.Reg, volatile.LoadUint8(&o.PSTATUSSET5.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUSSET5_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET5.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUSSET5_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET5.Reg, volatile.LoadUint8(&o.PSTATUSSET5.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUSSET5_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET5.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUSSET5_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET5.Reg, volatile.LoadUint8(&o.PSTATUSSET5.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUSSET5_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET5.Reg) & 0x80) >> 7
}

// USB_HOST.PSTATUS5: HOST End Point Pipe Status
func (o *USB_HOST_Type) SetPSTATUS5_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUS5.Reg, volatile.LoadUint8(&o.PSTATUS5.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUS5_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUS5.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUS5_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUS5.Reg, volatile.LoadUint8(&o.PSTATUS5.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUS5_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS5.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUS5_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUS5.Reg, volatile.LoadUint8(&o.PSTATUS5.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUS5_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS5.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUS5_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUS5.Reg, volatile.LoadUint8(&o.PSTATUS5.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUS5_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS5.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUS5_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUS5.Reg, volatile.LoadUint8(&o.PSTATUS5.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUS5_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS5.Reg) & 0x80) >> 7
}

// USB_HOST.PINTFLAG5: HOST Pipe Interrupt Flag
func (o *USB_HOST_Type) SetPINTFLAG5_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG5.Reg, volatile.LoadUint8(&o.PINTFLAG5.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTFLAG5_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTFLAG5.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTFLAG5_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG5.Reg, volatile.LoadUint8(&o.PINTFLAG5.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTFLAG5_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG5.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTFLAG5_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG5.Reg, volatile.LoadUint8(&o.PINTFLAG5.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTFLAG5_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG5.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTFLAG5_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG5.Reg, volatile.LoadUint8(&o.PINTFLAG5.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTFLAG5_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG5.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTFLAG5_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG5.Reg, volatile.LoadUint8(&o.PINTFLAG5.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTFLAG5_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG5.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTFLAG5_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG5.Reg, volatile.LoadUint8(&o.PINTFLAG5.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTFLAG5_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG5.Reg) & 0x20) >> 5
}

// USB_HOST.PINTENCLR5: HOST Pipe Interrupt Flag Clear
func (o *USB_HOST_Type) SetPINTENCLR5_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR5.Reg, volatile.LoadUint8(&o.PINTENCLR5.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTENCLR5_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTENCLR5.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTENCLR5_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR5.Reg, volatile.LoadUint8(&o.PINTENCLR5.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTENCLR5_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR5.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTENCLR5_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR5.Reg, volatile.LoadUint8(&o.PINTENCLR5.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTENCLR5_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR5.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTENCLR5_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR5.Reg, volatile.LoadUint8(&o.PINTENCLR5.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTENCLR5_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR5.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTENCLR5_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR5.Reg, volatile.LoadUint8(&o.PINTENCLR5.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTENCLR5_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR5.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTENCLR5_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR5.Reg, volatile.LoadUint8(&o.PINTENCLR5.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTENCLR5_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR5.Reg) & 0x20) >> 5
}

// USB_HOST.PINTENSET5: HOST Pipe Interrupt Flag Set
func (o *USB_HOST_Type) SetPINTENSET5_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTENSET5.Reg, volatile.LoadUint8(&o.PINTENSET5.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTENSET5_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTENSET5.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTENSET5_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTENSET5.Reg, volatile.LoadUint8(&o.PINTENSET5.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTENSET5_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET5.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTENSET5_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTENSET5.Reg, volatile.LoadUint8(&o.PINTENSET5.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTENSET5_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET5.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTENSET5_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTENSET5.Reg, volatile.LoadUint8(&o.PINTENSET5.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTENSET5_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET5.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTENSET5_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTENSET5.Reg, volatile.LoadUint8(&o.PINTENSET5.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTENSET5_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET5.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTENSET5_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTENSET5.Reg, volatile.LoadUint8(&o.PINTENSET5.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTENSET5_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET5.Reg) & 0x20) >> 5
}

// USB_HOST.PCFG6: HOST End Point Configuration
func (o *USB_HOST_Type) SetPCFG6_PTOKEN(value uint8) {
	volatile.StoreUint8(&o.PCFG6.Reg, volatile.LoadUint8(&o.PCFG6.Reg)&^(0x3)|value)
}
func (o *USB_HOST_Type) GetPCFG6_PTOKEN() uint8 {
	return volatile.LoadUint8(&o.PCFG6.Reg) & 0x3
}
func (o *USB_HOST_Type) SetPCFG6_BK(value uint8) {
	volatile.StoreUint8(&o.PCFG6.Reg, volatile.LoadUint8(&o.PCFG6.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPCFG6_BK() uint8 {
	return (volatile.LoadUint8(&o.PCFG6.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPCFG6_PTYPE(value uint8) {
	volatile.StoreUint8(&o.PCFG6.Reg, volatile.LoadUint8(&o.PCFG6.Reg)&^(0x38)|value<<3)
}
func (o *USB_HOST_Type) GetPCFG6_PTYPE() uint8 {
	return (volatile.LoadUint8(&o.PCFG6.Reg) & 0x38) >> 3
}

// USB_HOST.BINTERVAL6: HOST Bus Access Period of Pipe
func (o *USB_HOST_Type) SetBINTERVAL6(value uint8) {
	volatile.StoreUint8(&o.BINTERVAL6.Reg, value)
}
func (o *USB_HOST_Type) GetBINTERVAL6() uint8 {
	return volatile.LoadUint8(&o.BINTERVAL6.Reg)
}

// USB_HOST.PSTATUSCLR6: HOST End Point Pipe Status Clear
func (o *USB_HOST_Type) SetPSTATUSCLR6_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR6.Reg, volatile.LoadUint8(&o.PSTATUSCLR6.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUSCLR6_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUSCLR6.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUSCLR6_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR6.Reg, volatile.LoadUint8(&o.PSTATUSCLR6.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUSCLR6_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR6.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUSCLR6_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR6.Reg, volatile.LoadUint8(&o.PSTATUSCLR6.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUSCLR6_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR6.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUSCLR6_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR6.Reg, volatile.LoadUint8(&o.PSTATUSCLR6.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUSCLR6_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR6.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUSCLR6_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR6.Reg, volatile.LoadUint8(&o.PSTATUSCLR6.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUSCLR6_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR6.Reg) & 0x80) >> 7
}

// USB_HOST.PSTATUSSET6: HOST End Point Pipe Status Set
func (o *USB_HOST_Type) SetPSTATUSSET6_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET6.Reg, volatile.LoadUint8(&o.PSTATUSSET6.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUSSET6_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUSSET6.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUSSET6_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET6.Reg, volatile.LoadUint8(&o.PSTATUSSET6.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUSSET6_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET6.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUSSET6_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET6.Reg, volatile.LoadUint8(&o.PSTATUSSET6.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUSSET6_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET6.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUSSET6_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET6.Reg, volatile.LoadUint8(&o.PSTATUSSET6.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUSSET6_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET6.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUSSET6_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET6.Reg, volatile.LoadUint8(&o.PSTATUSSET6.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUSSET6_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET6.Reg) & 0x80) >> 7
}

// USB_HOST.PSTATUS6: HOST End Point Pipe Status
func (o *USB_HOST_Type) SetPSTATUS6_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUS6.Reg, volatile.LoadUint8(&o.PSTATUS6.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUS6_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUS6.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUS6_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUS6.Reg, volatile.LoadUint8(&o.PSTATUS6.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUS6_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS6.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUS6_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUS6.Reg, volatile.LoadUint8(&o.PSTATUS6.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUS6_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS6.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUS6_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUS6.Reg, volatile.LoadUint8(&o.PSTATUS6.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUS6_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS6.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUS6_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUS6.Reg, volatile.LoadUint8(&o.PSTATUS6.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUS6_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS6.Reg) & 0x80) >> 7
}

// USB_HOST.PINTFLAG6: HOST Pipe Interrupt Flag
func (o *USB_HOST_Type) SetPINTFLAG6_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG6.Reg, volatile.LoadUint8(&o.PINTFLAG6.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTFLAG6_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTFLAG6.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTFLAG6_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG6.Reg, volatile.LoadUint8(&o.PINTFLAG6.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTFLAG6_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG6.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTFLAG6_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG6.Reg, volatile.LoadUint8(&o.PINTFLAG6.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTFLAG6_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG6.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTFLAG6_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG6.Reg, volatile.LoadUint8(&o.PINTFLAG6.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTFLAG6_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG6.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTFLAG6_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG6.Reg, volatile.LoadUint8(&o.PINTFLAG6.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTFLAG6_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG6.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTFLAG6_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG6.Reg, volatile.LoadUint8(&o.PINTFLAG6.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTFLAG6_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG6.Reg) & 0x20) >> 5
}

// USB_HOST.PINTENCLR6: HOST Pipe Interrupt Flag Clear
func (o *USB_HOST_Type) SetPINTENCLR6_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR6.Reg, volatile.LoadUint8(&o.PINTENCLR6.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTENCLR6_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTENCLR6.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTENCLR6_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR6.Reg, volatile.LoadUint8(&o.PINTENCLR6.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTENCLR6_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR6.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTENCLR6_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR6.Reg, volatile.LoadUint8(&o.PINTENCLR6.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTENCLR6_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR6.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTENCLR6_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR6.Reg, volatile.LoadUint8(&o.PINTENCLR6.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTENCLR6_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR6.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTENCLR6_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR6.Reg, volatile.LoadUint8(&o.PINTENCLR6.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTENCLR6_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR6.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTENCLR6_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR6.Reg, volatile.LoadUint8(&o.PINTENCLR6.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTENCLR6_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR6.Reg) & 0x20) >> 5
}

// USB_HOST.PINTENSET6: HOST Pipe Interrupt Flag Set
func (o *USB_HOST_Type) SetPINTENSET6_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTENSET6.Reg, volatile.LoadUint8(&o.PINTENSET6.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTENSET6_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTENSET6.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTENSET6_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTENSET6.Reg, volatile.LoadUint8(&o.PINTENSET6.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTENSET6_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET6.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTENSET6_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTENSET6.Reg, volatile.LoadUint8(&o.PINTENSET6.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTENSET6_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET6.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTENSET6_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTENSET6.Reg, volatile.LoadUint8(&o.PINTENSET6.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTENSET6_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET6.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTENSET6_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTENSET6.Reg, volatile.LoadUint8(&o.PINTENSET6.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTENSET6_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET6.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTENSET6_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTENSET6.Reg, volatile.LoadUint8(&o.PINTENSET6.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTENSET6_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET6.Reg) & 0x20) >> 5
}

// USB_HOST.PCFG7: HOST End Point Configuration
func (o *USB_HOST_Type) SetPCFG7_PTOKEN(value uint8) {
	volatile.StoreUint8(&o.PCFG7.Reg, volatile.LoadUint8(&o.PCFG7.Reg)&^(0x3)|value)
}
func (o *USB_HOST_Type) GetPCFG7_PTOKEN() uint8 {
	return volatile.LoadUint8(&o.PCFG7.Reg) & 0x3
}
func (o *USB_HOST_Type) SetPCFG7_BK(value uint8) {
	volatile.StoreUint8(&o.PCFG7.Reg, volatile.LoadUint8(&o.PCFG7.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPCFG7_BK() uint8 {
	return (volatile.LoadUint8(&o.PCFG7.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPCFG7_PTYPE(value uint8) {
	volatile.StoreUint8(&o.PCFG7.Reg, volatile.LoadUint8(&o.PCFG7.Reg)&^(0x38)|value<<3)
}
func (o *USB_HOST_Type) GetPCFG7_PTYPE() uint8 {
	return (volatile.LoadUint8(&o.PCFG7.Reg) & 0x38) >> 3
}

// USB_HOST.BINTERVAL7: HOST Bus Access Period of Pipe
func (o *USB_HOST_Type) SetBINTERVAL7(value uint8) {
	volatile.StoreUint8(&o.BINTERVAL7.Reg, value)
}
func (o *USB_HOST_Type) GetBINTERVAL7() uint8 {
	return volatile.LoadUint8(&o.BINTERVAL7.Reg)
}

// USB_HOST.PSTATUSCLR7: HOST End Point Pipe Status Clear
func (o *USB_HOST_Type) SetPSTATUSCLR7_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR7.Reg, volatile.LoadUint8(&o.PSTATUSCLR7.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUSCLR7_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUSCLR7.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUSCLR7_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR7.Reg, volatile.LoadUint8(&o.PSTATUSCLR7.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUSCLR7_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR7.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUSCLR7_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR7.Reg, volatile.LoadUint8(&o.PSTATUSCLR7.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUSCLR7_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR7.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUSCLR7_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR7.Reg, volatile.LoadUint8(&o.PSTATUSCLR7.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUSCLR7_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR7.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUSCLR7_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSCLR7.Reg, volatile.LoadUint8(&o.PSTATUSCLR7.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUSCLR7_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSCLR7.Reg) & 0x80) >> 7
}

// USB_HOST.PSTATUSSET7: HOST End Point Pipe Status Set
func (o *USB_HOST_Type) SetPSTATUSSET7_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET7.Reg, volatile.LoadUint8(&o.PSTATUSSET7.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUSSET7_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUSSET7.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUSSET7_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET7.Reg, volatile.LoadUint8(&o.PSTATUSSET7.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUSSET7_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET7.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUSSET7_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET7.Reg, volatile.LoadUint8(&o.PSTATUSSET7.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUSSET7_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET7.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUSSET7_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET7.Reg, volatile.LoadUint8(&o.PSTATUSSET7.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUSSET7_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET7.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUSSET7_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUSSET7.Reg, volatile.LoadUint8(&o.PSTATUSSET7.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUSSET7_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUSSET7.Reg) & 0x80) >> 7
}

// USB_HOST.PSTATUS7: HOST End Point Pipe Status
func (o *USB_HOST_Type) SetPSTATUS7_DTGL(value uint8) {
	volatile.StoreUint8(&o.PSTATUS7.Reg, volatile.LoadUint8(&o.PSTATUS7.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPSTATUS7_DTGL() uint8 {
	return volatile.LoadUint8(&o.PSTATUS7.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPSTATUS7_CURBK(value uint8) {
	volatile.StoreUint8(&o.PSTATUS7.Reg, volatile.LoadUint8(&o.PSTATUS7.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPSTATUS7_CURBK() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS7.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPSTATUS7_PFREEZE(value uint8) {
	volatile.StoreUint8(&o.PSTATUS7.Reg, volatile.LoadUint8(&o.PSTATUS7.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPSTATUS7_PFREEZE() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS7.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPSTATUS7_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUS7.Reg, volatile.LoadUint8(&o.PSTATUS7.Reg)&^(0x40)|value<<6)
}
func (o *USB_HOST_Type) GetPSTATUS7_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS7.Reg) & 0x40) >> 6
}
func (o *USB_HOST_Type) SetPSTATUS7_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.PSTATUS7.Reg, volatile.LoadUint8(&o.PSTATUS7.Reg)&^(0x80)|value<<7)
}
func (o *USB_HOST_Type) GetPSTATUS7_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.PSTATUS7.Reg) & 0x80) >> 7
}

// USB_HOST.PINTFLAG7: HOST Pipe Interrupt Flag
func (o *USB_HOST_Type) SetPINTFLAG7_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG7.Reg, volatile.LoadUint8(&o.PINTFLAG7.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTFLAG7_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTFLAG7.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTFLAG7_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG7.Reg, volatile.LoadUint8(&o.PINTFLAG7.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTFLAG7_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG7.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTFLAG7_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG7.Reg, volatile.LoadUint8(&o.PINTFLAG7.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTFLAG7_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG7.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTFLAG7_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG7.Reg, volatile.LoadUint8(&o.PINTFLAG7.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTFLAG7_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG7.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTFLAG7_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG7.Reg, volatile.LoadUint8(&o.PINTFLAG7.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTFLAG7_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG7.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTFLAG7_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTFLAG7.Reg, volatile.LoadUint8(&o.PINTFLAG7.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTFLAG7_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTFLAG7.Reg) & 0x20) >> 5
}

// USB_HOST.PINTENCLR7: HOST Pipe Interrupt Flag Clear
func (o *USB_HOST_Type) SetPINTENCLR7_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR7.Reg, volatile.LoadUint8(&o.PINTENCLR7.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTENCLR7_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTENCLR7.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTENCLR7_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR7.Reg, volatile.LoadUint8(&o.PINTENCLR7.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTENCLR7_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR7.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTENCLR7_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR7.Reg, volatile.LoadUint8(&o.PINTENCLR7.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTENCLR7_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR7.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTENCLR7_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR7.Reg, volatile.LoadUint8(&o.PINTENCLR7.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTENCLR7_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR7.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTENCLR7_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR7.Reg, volatile.LoadUint8(&o.PINTENCLR7.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTENCLR7_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR7.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTENCLR7_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTENCLR7.Reg, volatile.LoadUint8(&o.PINTENCLR7.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTENCLR7_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTENCLR7.Reg) & 0x20) >> 5
}

// USB_HOST.PINTENSET7: HOST Pipe Interrupt Flag Set
func (o *USB_HOST_Type) SetPINTENSET7_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.PINTENSET7.Reg, volatile.LoadUint8(&o.PINTENSET7.Reg)&^(0x1)|value)
}
func (o *USB_HOST_Type) GetPINTENSET7_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.PINTENSET7.Reg) & 0x1
}
func (o *USB_HOST_Type) SetPINTENSET7_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.PINTENSET7.Reg, volatile.LoadUint8(&o.PINTENSET7.Reg)&^(0x2)|value<<1)
}
func (o *USB_HOST_Type) GetPINTENSET7_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET7.Reg) & 0x2) >> 1
}
func (o *USB_HOST_Type) SetPINTENSET7_TRFAIL(value uint8) {
	volatile.StoreUint8(&o.PINTENSET7.Reg, volatile.LoadUint8(&o.PINTENSET7.Reg)&^(0x4)|value<<2)
}
func (o *USB_HOST_Type) GetPINTENSET7_TRFAIL() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET7.Reg) & 0x4) >> 2
}
func (o *USB_HOST_Type) SetPINTENSET7_PERR(value uint8) {
	volatile.StoreUint8(&o.PINTENSET7.Reg, volatile.LoadUint8(&o.PINTENSET7.Reg)&^(0x8)|value<<3)
}
func (o *USB_HOST_Type) GetPINTENSET7_PERR() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET7.Reg) & 0x8) >> 3
}
func (o *USB_HOST_Type) SetPINTENSET7_TXSTP(value uint8) {
	volatile.StoreUint8(&o.PINTENSET7.Reg, volatile.LoadUint8(&o.PINTENSET7.Reg)&^(0x10)|value<<4)
}
func (o *USB_HOST_Type) GetPINTENSET7_TXSTP() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET7.Reg) & 0x10) >> 4
}
func (o *USB_HOST_Type) SetPINTENSET7_STALL(value uint8) {
	volatile.StoreUint8(&o.PINTENSET7.Reg, volatile.LoadUint8(&o.PINTENSET7.Reg)&^(0x20)|value<<5)
}
func (o *USB_HOST_Type) GetPINTENSET7_STALL() uint8 {
	return (volatile.LoadUint8(&o.PINTENSET7.Reg) & 0x20) >> 5
}

// Watchdog Timer
type WDT_Type struct {
	CTRL     volatile.Register8 // 0x0
	CONFIG   volatile.Register8 // 0x1
	EWCTRL   volatile.Register8 // 0x2
	_        byte
	INTENCLR volatile.Register8 // 0x4
	INTENSET volatile.Register8 // 0x5
	INTFLAG  volatile.Register8 // 0x6
	STATUS   volatile.Register8 // 0x7
	CLEAR    volatile.Register8 // 0x8
}

// WDT.CTRL: Control
func (o *WDT_Type) SetCTRL_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetCTRL_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *WDT_Type) SetCTRL_WEN(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *WDT_Type) GetCTRL_WEN() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *WDT_Type) SetCTRL_ALWAYSON(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *WDT_Type) GetCTRL_ALWAYSON() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x80) >> 7
}

// WDT.CONFIG: Configuration
func (o *WDT_Type) SetCONFIG_PER(value uint8) {
	volatile.StoreUint8(&o.CONFIG.Reg, volatile.LoadUint8(&o.CONFIG.Reg)&^(0xf)|value)
}
func (o *WDT_Type) GetCONFIG_PER() uint8 {
	return volatile.LoadUint8(&o.CONFIG.Reg) & 0xf
}
func (o *WDT_Type) SetCONFIG_WINDOW(value uint8) {
	volatile.StoreUint8(&o.CONFIG.Reg, volatile.LoadUint8(&o.CONFIG.Reg)&^(0xf0)|value<<4)
}
func (o *WDT_Type) GetCONFIG_WINDOW() uint8 {
	return (volatile.LoadUint8(&o.CONFIG.Reg) & 0xf0) >> 4
}

// WDT.EWCTRL: Early Warning Interrupt Control
func (o *WDT_Type) SetEWCTRL_EWOFFSET(value uint8) {
	volatile.StoreUint8(&o.EWCTRL.Reg, volatile.LoadUint8(&o.EWCTRL.Reg)&^(0xf)|value)
}
func (o *WDT_Type) GetEWCTRL_EWOFFSET() uint8 {
	return volatile.LoadUint8(&o.EWCTRL.Reg) & 0xf
}

// WDT.INTENCLR: Interrupt Enable Clear
func (o *WDT_Type) SetINTENCLR_EW(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetINTENCLR_EW() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}

// WDT.INTENSET: Interrupt Enable Set
func (o *WDT_Type) SetINTENSET_EW(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetINTENSET_EW() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}

// WDT.INTFLAG: Interrupt Flag Status and Clear
func (o *WDT_Type) SetINTFLAG_EW(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetINTFLAG_EW() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}

// WDT.STATUS: Status
func (o *WDT_Type) SetSTATUS_SYNCBUSY(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *WDT_Type) GetSTATUS_SYNCBUSY() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x80) >> 7
}

// WDT.CLEAR: Clear
func (o *WDT_Type) SetCLEAR(value uint8) {
	volatile.StoreUint8(&o.CLEAR.Reg, value)
}
func (o *WDT_Type) GetCLEAR() uint8 {
	return volatile.LoadUint8(&o.CLEAR.Reg)
}

// Constants for AC: Analog Comparators
const (
	// CTRLA: Control A
	// Position of SWRST field.
	AC_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	AC_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	AC_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	AC_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	AC_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	AC_CTRLA_ENABLE = 0x2
	// Position of RUNSTDBY field.
	AC_CTRLA_RUNSTDBY_Pos = 0x2
	// Bit mask of RUNSTDBY field.
	AC_CTRLA_RUNSTDBY_Msk = 0x4
	// Bit RUNSTDBY.
	AC_CTRLA_RUNSTDBY = 0x4
	// Position of LPMUX field.
	AC_CTRLA_LPMUX_Pos = 0x7
	// Bit mask of LPMUX field.
	AC_CTRLA_LPMUX_Msk = 0x80
	// Bit LPMUX.
	AC_CTRLA_LPMUX = 0x80

	// CTRLB: Control B
	// Position of START0 field.
	AC_CTRLB_START0_Pos = 0x0
	// Bit mask of START0 field.
	AC_CTRLB_START0_Msk = 0x1
	// Bit START0.
	AC_CTRLB_START0 = 0x1
	// Position of START1 field.
	AC_CTRLB_START1_Pos = 0x1
	// Bit mask of START1 field.
	AC_CTRLB_START1_Msk = 0x2
	// Bit START1.
	AC_CTRLB_START1 = 0x2

	// EVCTRL: Event Control
	// Position of COMPEO0 field.
	AC_EVCTRL_COMPEO0_Pos = 0x0
	// Bit mask of COMPEO0 field.
	AC_EVCTRL_COMPEO0_Msk = 0x1
	// Bit COMPEO0.
	AC_EVCTRL_COMPEO0 = 0x1
	// Position of COMPEO1 field.
	AC_EVCTRL_COMPEO1_Pos = 0x1
	// Bit mask of COMPEO1 field.
	AC_EVCTRL_COMPEO1_Msk = 0x2
	// Bit COMPEO1.
	AC_EVCTRL_COMPEO1 = 0x2
	// Position of WINEO0 field.
	AC_EVCTRL_WINEO0_Pos = 0x4
	// Bit mask of WINEO0 field.
	AC_EVCTRL_WINEO0_Msk = 0x10
	// Bit WINEO0.
	AC_EVCTRL_WINEO0 = 0x10
	// Position of COMPEI0 field.
	AC_EVCTRL_COMPEI0_Pos = 0x8
	// Bit mask of COMPEI0 field.
	AC_EVCTRL_COMPEI0_Msk = 0x100
	// Bit COMPEI0.
	AC_EVCTRL_COMPEI0 = 0x100
	// Position of COMPEI1 field.
	AC_EVCTRL_COMPEI1_Pos = 0x9
	// Bit mask of COMPEI1 field.
	AC_EVCTRL_COMPEI1_Msk = 0x200
	// Bit COMPEI1.
	AC_EVCTRL_COMPEI1 = 0x200

	// INTENCLR: Interrupt Enable Clear
	// Position of COMP0 field.
	AC_INTENCLR_COMP0_Pos = 0x0
	// Bit mask of COMP0 field.
	AC_INTENCLR_COMP0_Msk = 0x1
	// Bit COMP0.
	AC_INTENCLR_COMP0 = 0x1
	// Position of COMP1 field.
	AC_INTENCLR_COMP1_Pos = 0x1
	// Bit mask of COMP1 field.
	AC_INTENCLR_COMP1_Msk = 0x2
	// Bit COMP1.
	AC_INTENCLR_COMP1 = 0x2
	// Position of WIN0 field.
	AC_INTENCLR_WIN0_Pos = 0x4
	// Bit mask of WIN0 field.
	AC_INTENCLR_WIN0_Msk = 0x10
	// Bit WIN0.
	AC_INTENCLR_WIN0 = 0x10

	// INTENSET: Interrupt Enable Set
	// Position of COMP0 field.
	AC_INTENSET_COMP0_Pos = 0x0
	// Bit mask of COMP0 field.
	AC_INTENSET_COMP0_Msk = 0x1
	// Bit COMP0.
	AC_INTENSET_COMP0 = 0x1
	// Position of COMP1 field.
	AC_INTENSET_COMP1_Pos = 0x1
	// Bit mask of COMP1 field.
	AC_INTENSET_COMP1_Msk = 0x2
	// Bit COMP1.
	AC_INTENSET_COMP1 = 0x2
	// Position of WIN0 field.
	AC_INTENSET_WIN0_Pos = 0x4
	// Bit mask of WIN0 field.
	AC_INTENSET_WIN0_Msk = 0x10
	// Bit WIN0.
	AC_INTENSET_WIN0 = 0x10

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of COMP0 field.
	AC_INTFLAG_COMP0_Pos = 0x0
	// Bit mask of COMP0 field.
	AC_INTFLAG_COMP0_Msk = 0x1
	// Bit COMP0.
	AC_INTFLAG_COMP0 = 0x1
	// Position of COMP1 field.
	AC_INTFLAG_COMP1_Pos = 0x1
	// Bit mask of COMP1 field.
	AC_INTFLAG_COMP1_Msk = 0x2
	// Bit COMP1.
	AC_INTFLAG_COMP1 = 0x2
	// Position of WIN0 field.
	AC_INTFLAG_WIN0_Pos = 0x4
	// Bit mask of WIN0 field.
	AC_INTFLAG_WIN0_Msk = 0x10
	// Bit WIN0.
	AC_INTFLAG_WIN0 = 0x10

	// STATUSA: Status A
	// Position of STATE0 field.
	AC_STATUSA_STATE0_Pos = 0x0
	// Bit mask of STATE0 field.
	AC_STATUSA_STATE0_Msk = 0x1
	// Bit STATE0.
	AC_STATUSA_STATE0 = 0x1
	// Position of STATE1 field.
	AC_STATUSA_STATE1_Pos = 0x1
	// Bit mask of STATE1 field.
	AC_STATUSA_STATE1_Msk = 0x2
	// Bit STATE1.
	AC_STATUSA_STATE1 = 0x2
	// Position of WSTATE0 field.
	AC_STATUSA_WSTATE0_Pos = 0x4
	// Bit mask of WSTATE0 field.
	AC_STATUSA_WSTATE0_Msk = 0x30
	// Signal is above window
	AC_STATUSA_WSTATE0_ABOVE = 0x0
	// Signal is inside window
	AC_STATUSA_WSTATE0_INSIDE = 0x1
	// Signal is below window
	AC_STATUSA_WSTATE0_BELOW = 0x2

	// STATUSB: Status B
	// Position of READY0 field.
	AC_STATUSB_READY0_Pos = 0x0
	// Bit mask of READY0 field.
	AC_STATUSB_READY0_Msk = 0x1
	// Bit READY0.
	AC_STATUSB_READY0 = 0x1
	// Position of READY1 field.
	AC_STATUSB_READY1_Pos = 0x1
	// Bit mask of READY1 field.
	AC_STATUSB_READY1_Msk = 0x2
	// Bit READY1.
	AC_STATUSB_READY1 = 0x2
	// Position of SYNCBUSY field.
	AC_STATUSB_SYNCBUSY_Pos = 0x7
	// Bit mask of SYNCBUSY field.
	AC_STATUSB_SYNCBUSY_Msk = 0x80
	// Bit SYNCBUSY.
	AC_STATUSB_SYNCBUSY = 0x80

	// STATUSC: Status C
	// Position of STATE0 field.
	AC_STATUSC_STATE0_Pos = 0x0
	// Bit mask of STATE0 field.
	AC_STATUSC_STATE0_Msk = 0x1
	// Bit STATE0.
	AC_STATUSC_STATE0 = 0x1
	// Position of STATE1 field.
	AC_STATUSC_STATE1_Pos = 0x1
	// Bit mask of STATE1 field.
	AC_STATUSC_STATE1_Msk = 0x2
	// Bit STATE1.
	AC_STATUSC_STATE1 = 0x2
	// Position of WSTATE0 field.
	AC_STATUSC_WSTATE0_Pos = 0x4
	// Bit mask of WSTATE0 field.
	AC_STATUSC_WSTATE0_Msk = 0x30
	// Signal is above window
	AC_STATUSC_WSTATE0_ABOVE = 0x0
	// Signal is inside window
	AC_STATUSC_WSTATE0_INSIDE = 0x1
	// Signal is below window
	AC_STATUSC_WSTATE0_BELOW = 0x2

	// WINCTRL: Window Control
	// Position of WEN0 field.
	AC_WINCTRL_WEN0_Pos = 0x0
	// Bit mask of WEN0 field.
	AC_WINCTRL_WEN0_Msk = 0x1
	// Bit WEN0.
	AC_WINCTRL_WEN0 = 0x1
	// Position of WINTSEL0 field.
	AC_WINCTRL_WINTSEL0_Pos = 0x1
	// Bit mask of WINTSEL0 field.
	AC_WINCTRL_WINTSEL0_Msk = 0x6
	// Interrupt on signal above window
	AC_WINCTRL_WINTSEL0_ABOVE = 0x0
	// Interrupt on signal inside window
	AC_WINCTRL_WINTSEL0_INSIDE = 0x1
	// Interrupt on signal below window
	AC_WINCTRL_WINTSEL0_BELOW = 0x2
	// Interrupt on signal outside window
	AC_WINCTRL_WINTSEL0_OUTSIDE = 0x3

	// COMPCTRL0: Comparator Control n
	// Position of ENABLE field.
	AC_COMPCTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	AC_COMPCTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	AC_COMPCTRL_ENABLE = 0x1
	// Position of SINGLE field.
	AC_COMPCTRL_SINGLE_Pos = 0x1
	// Bit mask of SINGLE field.
	AC_COMPCTRL_SINGLE_Msk = 0x2
	// Bit SINGLE.
	AC_COMPCTRL_SINGLE = 0x2
	// Position of SPEED field.
	AC_COMPCTRL_SPEED_Pos = 0x2
	// Bit mask of SPEED field.
	AC_COMPCTRL_SPEED_Msk = 0xc
	// Low speed
	AC_COMPCTRL_SPEED_LOW = 0x0
	// High speed
	AC_COMPCTRL_SPEED_HIGH = 0x1
	// Position of INTSEL field.
	AC_COMPCTRL_INTSEL_Pos = 0x5
	// Bit mask of INTSEL field.
	AC_COMPCTRL_INTSEL_Msk = 0x60
	// Interrupt on comparator output toggle
	AC_COMPCTRL_INTSEL_TOGGLE = 0x0
	// Interrupt on comparator output rising
	AC_COMPCTRL_INTSEL_RISING = 0x1
	// Interrupt on comparator output falling
	AC_COMPCTRL_INTSEL_FALLING = 0x2
	// Interrupt on end of comparison (single-shot mode only)
	AC_COMPCTRL_INTSEL_EOC = 0x3
	// Position of MUXNEG field.
	AC_COMPCTRL_MUXNEG_Pos = 0x8
	// Bit mask of MUXNEG field.
	AC_COMPCTRL_MUXNEG_Msk = 0x700
	// I/O pin 0
	AC_COMPCTRL_MUXNEG_PIN0 = 0x0
	// I/O pin 1
	AC_COMPCTRL_MUXNEG_PIN1 = 0x1
	// I/O pin 2
	AC_COMPCTRL_MUXNEG_PIN2 = 0x2
	// I/O pin 3
	AC_COMPCTRL_MUXNEG_PIN3 = 0x3
	// Ground
	AC_COMPCTRL_MUXNEG_GND = 0x4
	// VDD scaler
	AC_COMPCTRL_MUXNEG_VSCALE = 0x5
	// Internal bandgap voltage
	AC_COMPCTRL_MUXNEG_BANDGAP = 0x6
	// DAC output
	AC_COMPCTRL_MUXNEG_DAC = 0x7
	// Position of MUXPOS field.
	AC_COMPCTRL_MUXPOS_Pos = 0xc
	// Bit mask of MUXPOS field.
	AC_COMPCTRL_MUXPOS_Msk = 0x3000
	// I/O pin 0
	AC_COMPCTRL_MUXPOS_PIN0 = 0x0
	// I/O pin 1
	AC_COMPCTRL_MUXPOS_PIN1 = 0x1
	// I/O pin 2
	AC_COMPCTRL_MUXPOS_PIN2 = 0x2
	// I/O pin 3
	AC_COMPCTRL_MUXPOS_PIN3 = 0x3
	// Position of SWAP field.
	AC_COMPCTRL_SWAP_Pos = 0xf
	// Bit mask of SWAP field.
	AC_COMPCTRL_SWAP_Msk = 0x8000
	// Bit SWAP.
	AC_COMPCTRL_SWAP = 0x8000
	// Position of OUT field.
	AC_COMPCTRL_OUT_Pos = 0x10
	// Bit mask of OUT field.
	AC_COMPCTRL_OUT_Msk = 0x30000
	// The output of COMPn is not routed to the COMPn I/O port
	AC_COMPCTRL_OUT_OFF = 0x0
	// The asynchronous output of COMPn is routed to the COMPn I/O port
	AC_COMPCTRL_OUT_ASYNC = 0x1
	// The synchronous output (including filtering) of COMPn is routed to the COMPn I/O port
	AC_COMPCTRL_OUT_SYNC = 0x2
	// Position of HYST field.
	AC_COMPCTRL_HYST_Pos = 0x13
	// Bit mask of HYST field.
	AC_COMPCTRL_HYST_Msk = 0x80000
	// Bit HYST.
	AC_COMPCTRL_HYST = 0x80000
	// Position of FLEN field.
	AC_COMPCTRL_FLEN_Pos = 0x18
	// Bit mask of FLEN field.
	AC_COMPCTRL_FLEN_Msk = 0x7000000
	// No filtering
	AC_COMPCTRL_FLEN_OFF = 0x0
	// 3-bit majority function (2 of 3)
	AC_COMPCTRL_FLEN_MAJ3 = 0x1
	// 5-bit majority function (3 of 5)
	AC_COMPCTRL_FLEN_MAJ5 = 0x2

	// SCALER0: Scaler n
	// Position of VALUE field.
	AC_SCALER_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	AC_SCALER_VALUE_Msk = 0x3f
)

// Constants for ADC: Analog Digital Converter
const (
	// CTRLA: Control A
	// Position of SWRST field.
	ADC_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	ADC_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	ADC_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	ADC_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	ADC_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	ADC_CTRLA_ENABLE = 0x2
	// Position of RUNSTDBY field.
	ADC_CTRLA_RUNSTDBY_Pos = 0x2
	// Bit mask of RUNSTDBY field.
	ADC_CTRLA_RUNSTDBY_Msk = 0x4
	// Bit RUNSTDBY.
	ADC_CTRLA_RUNSTDBY = 0x4

	// REFCTRL: Reference Control
	// Position of REFSEL field.
	ADC_REFCTRL_REFSEL_Pos = 0x0
	// Bit mask of REFSEL field.
	ADC_REFCTRL_REFSEL_Msk = 0xf
	// 1.0V voltage reference
	ADC_REFCTRL_REFSEL_INT1V = 0x0
	// 1/1.48 VDDANA
	ADC_REFCTRL_REFSEL_INTVCC0 = 0x1
	// 1/2 VDDANA (only for VDDANA > 2.0V)
	ADC_REFCTRL_REFSEL_INTVCC1 = 0x2
	// External reference
	ADC_REFCTRL_REFSEL_AREFA = 0x3
	// External reference
	ADC_REFCTRL_REFSEL_AREFB = 0x4
	// Position of REFCOMP field.
	ADC_REFCTRL_REFCOMP_Pos = 0x7
	// Bit mask of REFCOMP field.
	ADC_REFCTRL_REFCOMP_Msk = 0x80
	// Bit REFCOMP.
	ADC_REFCTRL_REFCOMP = 0x80

	// AVGCTRL: Average Control
	// Position of SAMPLENUM field.
	ADC_AVGCTRL_SAMPLENUM_Pos = 0x0
	// Bit mask of SAMPLENUM field.
	ADC_AVGCTRL_SAMPLENUM_Msk = 0xf
	// 1 sample
	ADC_AVGCTRL_SAMPLENUM_1 = 0x0
	// 2 samples
	ADC_AVGCTRL_SAMPLENUM_2 = 0x1
	// 4 samples
	ADC_AVGCTRL_SAMPLENUM_4 = 0x2
	// 8 samples
	ADC_AVGCTRL_SAMPLENUM_8 = 0x3
	// 16 samples
	ADC_AVGCTRL_SAMPLENUM_16 = 0x4
	// 32 samples
	ADC_AVGCTRL_SAMPLENUM_32 = 0x5
	// 64 samples
	ADC_AVGCTRL_SAMPLENUM_64 = 0x6
	// 128 samples
	ADC_AVGCTRL_SAMPLENUM_128 = 0x7
	// 256 samples
	ADC_AVGCTRL_SAMPLENUM_256 = 0x8
	// 512 samples
	ADC_AVGCTRL_SAMPLENUM_512 = 0x9
	// 1024 samples
	ADC_AVGCTRL_SAMPLENUM_1024 = 0xa
	// Position of ADJRES field.
	ADC_AVGCTRL_ADJRES_Pos = 0x4
	// Bit mask of ADJRES field.
	ADC_AVGCTRL_ADJRES_Msk = 0x70

	// SAMPCTRL: Sampling Time Control
	// Position of SAMPLEN field.
	ADC_SAMPCTRL_SAMPLEN_Pos = 0x0
	// Bit mask of SAMPLEN field.
	ADC_SAMPCTRL_SAMPLEN_Msk = 0x3f

	// CTRLB: Control B
	// Position of DIFFMODE field.
	ADC_CTRLB_DIFFMODE_Pos = 0x0
	// Bit mask of DIFFMODE field.
	ADC_CTRLB_DIFFMODE_Msk = 0x1
	// Bit DIFFMODE.
	ADC_CTRLB_DIFFMODE = 0x1
	// Position of LEFTADJ field.
	ADC_CTRLB_LEFTADJ_Pos = 0x1
	// Bit mask of LEFTADJ field.
	ADC_CTRLB_LEFTADJ_Msk = 0x2
	// Bit LEFTADJ.
	ADC_CTRLB_LEFTADJ = 0x2
	// Position of FREERUN field.
	ADC_CTRLB_FREERUN_Pos = 0x2
	// Bit mask of FREERUN field.
	ADC_CTRLB_FREERUN_Msk = 0x4
	// Bit FREERUN.
	ADC_CTRLB_FREERUN = 0x4
	// Position of CORREN field.
	ADC_CTRLB_CORREN_Pos = 0x3
	// Bit mask of CORREN field.
	ADC_CTRLB_CORREN_Msk = 0x8
	// Bit CORREN.
	ADC_CTRLB_CORREN = 0x8
	// Position of RESSEL field.
	ADC_CTRLB_RESSEL_Pos = 0x4
	// Bit mask of RESSEL field.
	ADC_CTRLB_RESSEL_Msk = 0x30
	// 12-bit result
	ADC_CTRLB_RESSEL_12BIT = 0x0
	// For averaging mode output
	ADC_CTRLB_RESSEL_16BIT = 0x1
	// 10-bit result
	ADC_CTRLB_RESSEL_10BIT = 0x2
	// 8-bit result
	ADC_CTRLB_RESSEL_8BIT = 0x3
	// Position of PRESCALER field.
	ADC_CTRLB_PRESCALER_Pos = 0x8
	// Bit mask of PRESCALER field.
	ADC_CTRLB_PRESCALER_Msk = 0x700
	// Peripheral clock divided by 4
	ADC_CTRLB_PRESCALER_DIV4 = 0x0
	// Peripheral clock divided by 8
	ADC_CTRLB_PRESCALER_DIV8 = 0x1
	// Peripheral clock divided by 16
	ADC_CTRLB_PRESCALER_DIV16 = 0x2
	// Peripheral clock divided by 32
	ADC_CTRLB_PRESCALER_DIV32 = 0x3
	// Peripheral clock divided by 64
	ADC_CTRLB_PRESCALER_DIV64 = 0x4
	// Peripheral clock divided by 128
	ADC_CTRLB_PRESCALER_DIV128 = 0x5
	// Peripheral clock divided by 256
	ADC_CTRLB_PRESCALER_DIV256 = 0x6
	// Peripheral clock divided by 512
	ADC_CTRLB_PRESCALER_DIV512 = 0x7

	// WINCTRL: Window Monitor Control
	// Position of WINMODE field.
	ADC_WINCTRL_WINMODE_Pos = 0x0
	// Bit mask of WINMODE field.
	ADC_WINCTRL_WINMODE_Msk = 0x7
	// No window mode (default)
	ADC_WINCTRL_WINMODE_DISABLE = 0x0
	// Mode 1: RESULT > WINLT
	ADC_WINCTRL_WINMODE_MODE1 = 0x1
	// Mode 2: RESULT < WINUT
	ADC_WINCTRL_WINMODE_MODE2 = 0x2
	// Mode 3: WINLT < RESULT < WINUT
	ADC_WINCTRL_WINMODE_MODE3 = 0x3
	// Mode 4: !(WINLT < RESULT < WINUT)
	ADC_WINCTRL_WINMODE_MODE4 = 0x4

	// SWTRIG: Software Trigger
	// Position of FLUSH field.
	ADC_SWTRIG_FLUSH_Pos = 0x0
	// Bit mask of FLUSH field.
	ADC_SWTRIG_FLUSH_Msk = 0x1
	// Bit FLUSH.
	ADC_SWTRIG_FLUSH = 0x1
	// Position of START field.
	ADC_SWTRIG_START_Pos = 0x1
	// Bit mask of START field.
	ADC_SWTRIG_START_Msk = 0x2
	// Bit START.
	ADC_SWTRIG_START = 0x2

	// INPUTCTRL: Input Control
	// Position of MUXPOS field.
	ADC_INPUTCTRL_MUXPOS_Pos = 0x0
	// Bit mask of MUXPOS field.
	ADC_INPUTCTRL_MUXPOS_Msk = 0x1f
	// ADC AIN0 Pin
	ADC_INPUTCTRL_MUXPOS_PIN0 = 0x0
	// ADC AIN1 Pin
	ADC_INPUTCTRL_MUXPOS_PIN1 = 0x1
	// ADC AIN2 Pin
	ADC_INPUTCTRL_MUXPOS_PIN2 = 0x2
	// ADC AIN3 Pin
	ADC_INPUTCTRL_MUXPOS_PIN3 = 0x3
	// ADC AIN4 Pin
	ADC_INPUTCTRL_MUXPOS_PIN4 = 0x4
	// ADC AIN5 Pin
	ADC_INPUTCTRL_MUXPOS_PIN5 = 0x5
	// ADC AIN6 Pin
	ADC_INPUTCTRL_MUXPOS_PIN6 = 0x6
	// ADC AIN7 Pin
	ADC_INPUTCTRL_MUXPOS_PIN7 = 0x7
	// ADC AIN8 Pin
	ADC_INPUTCTRL_MUXPOS_PIN8 = 0x8
	// ADC AIN9 Pin
	ADC_INPUTCTRL_MUXPOS_PIN9 = 0x9
	// ADC AIN10 Pin
	ADC_INPUTCTRL_MUXPOS_PIN10 = 0xa
	// ADC AIN11 Pin
	ADC_INPUTCTRL_MUXPOS_PIN11 = 0xb
	// ADC AIN12 Pin
	ADC_INPUTCTRL_MUXPOS_PIN12 = 0xc
	// ADC AIN13 Pin
	ADC_INPUTCTRL_MUXPOS_PIN13 = 0xd
	// ADC AIN14 Pin
	ADC_INPUTCTRL_MUXPOS_PIN14 = 0xe
	// ADC AIN15 Pin
	ADC_INPUTCTRL_MUXPOS_PIN15 = 0xf
	// ADC AIN16 Pin
	ADC_INPUTCTRL_MUXPOS_PIN16 = 0x10
	// ADC AIN17 Pin
	ADC_INPUTCTRL_MUXPOS_PIN17 = 0x11
	// ADC AIN18 Pin
	ADC_INPUTCTRL_MUXPOS_PIN18 = 0x12
	// ADC AIN19 Pin
	ADC_INPUTCTRL_MUXPOS_PIN19 = 0x13
	// Temperature Reference
	ADC_INPUTCTRL_MUXPOS_TEMP = 0x18
	// Bandgap Voltage
	ADC_INPUTCTRL_MUXPOS_BANDGAP = 0x19
	// 1/4 Scaled Core Supply
	ADC_INPUTCTRL_MUXPOS_SCALEDCOREVCC = 0x1a
	// 1/4 Scaled I/O Supply
	ADC_INPUTCTRL_MUXPOS_SCALEDIOVCC = 0x1b
	// DAC Output
	ADC_INPUTCTRL_MUXPOS_DAC = 0x1c
	// Position of MUXNEG field.
	ADC_INPUTCTRL_MUXNEG_Pos = 0x8
	// Bit mask of MUXNEG field.
	ADC_INPUTCTRL_MUXNEG_Msk = 0x1f00
	// ADC AIN0 Pin
	ADC_INPUTCTRL_MUXNEG_PIN0 = 0x0
	// ADC AIN1 Pin
	ADC_INPUTCTRL_MUXNEG_PIN1 = 0x1
	// ADC AIN2 Pin
	ADC_INPUTCTRL_MUXNEG_PIN2 = 0x2
	// ADC AIN3 Pin
	ADC_INPUTCTRL_MUXNEG_PIN3 = 0x3
	// ADC AIN4 Pin
	ADC_INPUTCTRL_MUXNEG_PIN4 = 0x4
	// ADC AIN5 Pin
	ADC_INPUTCTRL_MUXNEG_PIN5 = 0x5
	// ADC AIN6 Pin
	ADC_INPUTCTRL_MUXNEG_PIN6 = 0x6
	// ADC AIN7 Pin
	ADC_INPUTCTRL_MUXNEG_PIN7 = 0x7
	// Internal Ground
	ADC_INPUTCTRL_MUXNEG_GND = 0x18
	// I/O Ground
	ADC_INPUTCTRL_MUXNEG_IOGND = 0x19
	// Position of INPUTSCAN field.
	ADC_INPUTCTRL_INPUTSCAN_Pos = 0x10
	// Bit mask of INPUTSCAN field.
	ADC_INPUTCTRL_INPUTSCAN_Msk = 0xf0000
	// Position of INPUTOFFSET field.
	ADC_INPUTCTRL_INPUTOFFSET_Pos = 0x14
	// Bit mask of INPUTOFFSET field.
	ADC_INPUTCTRL_INPUTOFFSET_Msk = 0xf00000
	// Position of GAIN field.
	ADC_INPUTCTRL_GAIN_Pos = 0x18
	// Bit mask of GAIN field.
	ADC_INPUTCTRL_GAIN_Msk = 0xf000000
	// 1x
	ADC_INPUTCTRL_GAIN_1X = 0x0
	// 2x
	ADC_INPUTCTRL_GAIN_2X = 0x1
	// 4x
	ADC_INPUTCTRL_GAIN_4X = 0x2
	// 8x
	ADC_INPUTCTRL_GAIN_8X = 0x3
	// 16x
	ADC_INPUTCTRL_GAIN_16X = 0x4
	// 1/2x
	ADC_INPUTCTRL_GAIN_DIV2 = 0xf

	// EVCTRL: Event Control
	// Position of STARTEI field.
	ADC_EVCTRL_STARTEI_Pos = 0x0
	// Bit mask of STARTEI field.
	ADC_EVCTRL_STARTEI_Msk = 0x1
	// Bit STARTEI.
	ADC_EVCTRL_STARTEI = 0x1
	// Position of SYNCEI field.
	ADC_EVCTRL_SYNCEI_Pos = 0x1
	// Bit mask of SYNCEI field.
	ADC_EVCTRL_SYNCEI_Msk = 0x2
	// Bit SYNCEI.
	ADC_EVCTRL_SYNCEI = 0x2
	// Position of RESRDYEO field.
	ADC_EVCTRL_RESRDYEO_Pos = 0x4
	// Bit mask of RESRDYEO field.
	ADC_EVCTRL_RESRDYEO_Msk = 0x10
	// Bit RESRDYEO.
	ADC_EVCTRL_RESRDYEO = 0x10
	// Position of WINMONEO field.
	ADC_EVCTRL_WINMONEO_Pos = 0x5
	// Bit mask of WINMONEO field.
	ADC_EVCTRL_WINMONEO_Msk = 0x20
	// Bit WINMONEO.
	ADC_EVCTRL_WINMONEO = 0x20

	// INTENCLR: Interrupt Enable Clear
	// Position of RESRDY field.
	ADC_INTENCLR_RESRDY_Pos = 0x0
	// Bit mask of RESRDY field.
	ADC_INTENCLR_RESRDY_Msk = 0x1
	// Bit RESRDY.
	ADC_INTENCLR_RESRDY = 0x1
	// Position of OVERRUN field.
	ADC_INTENCLR_OVERRUN_Pos = 0x1
	// Bit mask of OVERRUN field.
	ADC_INTENCLR_OVERRUN_Msk = 0x2
	// Bit OVERRUN.
	ADC_INTENCLR_OVERRUN = 0x2
	// Position of WINMON field.
	ADC_INTENCLR_WINMON_Pos = 0x2
	// Bit mask of WINMON field.
	ADC_INTENCLR_WINMON_Msk = 0x4
	// Bit WINMON.
	ADC_INTENCLR_WINMON = 0x4
	// Position of SYNCRDY field.
	ADC_INTENCLR_SYNCRDY_Pos = 0x3
	// Bit mask of SYNCRDY field.
	ADC_INTENCLR_SYNCRDY_Msk = 0x8
	// Bit SYNCRDY.
	ADC_INTENCLR_SYNCRDY = 0x8

	// INTENSET: Interrupt Enable Set
	// Position of RESRDY field.
	ADC_INTENSET_RESRDY_Pos = 0x0
	// Bit mask of RESRDY field.
	ADC_INTENSET_RESRDY_Msk = 0x1
	// Bit RESRDY.
	ADC_INTENSET_RESRDY = 0x1
	// Position of OVERRUN field.
	ADC_INTENSET_OVERRUN_Pos = 0x1
	// Bit mask of OVERRUN field.
	ADC_INTENSET_OVERRUN_Msk = 0x2
	// Bit OVERRUN.
	ADC_INTENSET_OVERRUN = 0x2
	// Position of WINMON field.
	ADC_INTENSET_WINMON_Pos = 0x2
	// Bit mask of WINMON field.
	ADC_INTENSET_WINMON_Msk = 0x4
	// Bit WINMON.
	ADC_INTENSET_WINMON = 0x4
	// Position of SYNCRDY field.
	ADC_INTENSET_SYNCRDY_Pos = 0x3
	// Bit mask of SYNCRDY field.
	ADC_INTENSET_SYNCRDY_Msk = 0x8
	// Bit SYNCRDY.
	ADC_INTENSET_SYNCRDY = 0x8

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of RESRDY field.
	ADC_INTFLAG_RESRDY_Pos = 0x0
	// Bit mask of RESRDY field.
	ADC_INTFLAG_RESRDY_Msk = 0x1
	// Bit RESRDY.
	ADC_INTFLAG_RESRDY = 0x1
	// Position of OVERRUN field.
	ADC_INTFLAG_OVERRUN_Pos = 0x1
	// Bit mask of OVERRUN field.
	ADC_INTFLAG_OVERRUN_Msk = 0x2
	// Bit OVERRUN.
	ADC_INTFLAG_OVERRUN = 0x2
	// Position of WINMON field.
	ADC_INTFLAG_WINMON_Pos = 0x2
	// Bit mask of WINMON field.
	ADC_INTFLAG_WINMON_Msk = 0x4
	// Bit WINMON.
	ADC_INTFLAG_WINMON = 0x4
	// Position of SYNCRDY field.
	ADC_INTFLAG_SYNCRDY_Pos = 0x3
	// Bit mask of SYNCRDY field.
	ADC_INTFLAG_SYNCRDY_Msk = 0x8
	// Bit SYNCRDY.
	ADC_INTFLAG_SYNCRDY = 0x8

	// STATUS: Status
	// Position of SYNCBUSY field.
	ADC_STATUS_SYNCBUSY_Pos = 0x7
	// Bit mask of SYNCBUSY field.
	ADC_STATUS_SYNCBUSY_Msk = 0x80
	// Bit SYNCBUSY.
	ADC_STATUS_SYNCBUSY = 0x80

	// RESULT: Result
	// Position of RESULT field.
	ADC_RESULT_RESULT_Pos = 0x0
	// Bit mask of RESULT field.
	ADC_RESULT_RESULT_Msk = 0xffff

	// WINLT: Window Monitor Lower Threshold
	// Position of WINLT field.
	ADC_WINLT_WINLT_Pos = 0x0
	// Bit mask of WINLT field.
	ADC_WINLT_WINLT_Msk = 0xffff

	// WINUT: Window Monitor Upper Threshold
	// Position of WINUT field.
	ADC_WINUT_WINUT_Pos = 0x0
	// Bit mask of WINUT field.
	ADC_WINUT_WINUT_Msk = 0xffff

	// GAINCORR: Gain Correction
	// Position of GAINCORR field.
	ADC_GAINCORR_GAINCORR_Pos = 0x0
	// Bit mask of GAINCORR field.
	ADC_GAINCORR_GAINCORR_Msk = 0xfff

	// OFFSETCORR: Offset Correction
	// Position of OFFSETCORR field.
	ADC_OFFSETCORR_OFFSETCORR_Pos = 0x0
	// Bit mask of OFFSETCORR field.
	ADC_OFFSETCORR_OFFSETCORR_Msk = 0xfff

	// CALIB: Calibration
	// Position of LINEARITY_CAL field.
	ADC_CALIB_LINEARITY_CAL_Pos = 0x0
	// Bit mask of LINEARITY_CAL field.
	ADC_CALIB_LINEARITY_CAL_Msk = 0xff
	// Position of BIAS_CAL field.
	ADC_CALIB_BIAS_CAL_Pos = 0x8
	// Bit mask of BIAS_CAL field.
	ADC_CALIB_BIAS_CAL_Msk = 0x700

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	ADC_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	ADC_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	ADC_DBGCTRL_DBGRUN = 0x1
)

// Constants for DAC: Digital Analog Converter
const (
	// CTRLA: Control A
	// Position of SWRST field.
	DAC_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	DAC_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	DAC_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	DAC_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	DAC_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	DAC_CTRLA_ENABLE = 0x2
	// Position of RUNSTDBY field.
	DAC_CTRLA_RUNSTDBY_Pos = 0x2
	// Bit mask of RUNSTDBY field.
	DAC_CTRLA_RUNSTDBY_Msk = 0x4
	// Bit RUNSTDBY.
	DAC_CTRLA_RUNSTDBY = 0x4

	// CTRLB: Control B
	// Position of EOEN field.
	DAC_CTRLB_EOEN_Pos = 0x0
	// Bit mask of EOEN field.
	DAC_CTRLB_EOEN_Msk = 0x1
	// Bit EOEN.
	DAC_CTRLB_EOEN = 0x1
	// Position of IOEN field.
	DAC_CTRLB_IOEN_Pos = 0x1
	// Bit mask of IOEN field.
	DAC_CTRLB_IOEN_Msk = 0x2
	// Bit IOEN.
	DAC_CTRLB_IOEN = 0x2
	// Position of LEFTADJ field.
	DAC_CTRLB_LEFTADJ_Pos = 0x2
	// Bit mask of LEFTADJ field.
	DAC_CTRLB_LEFTADJ_Msk = 0x4
	// Bit LEFTADJ.
	DAC_CTRLB_LEFTADJ = 0x4
	// Position of VPD field.
	DAC_CTRLB_VPD_Pos = 0x3
	// Bit mask of VPD field.
	DAC_CTRLB_VPD_Msk = 0x8
	// Bit VPD.
	DAC_CTRLB_VPD = 0x8
	// Position of BDWP field.
	DAC_CTRLB_BDWP_Pos = 0x4
	// Bit mask of BDWP field.
	DAC_CTRLB_BDWP_Msk = 0x10
	// Bit BDWP.
	DAC_CTRLB_BDWP = 0x10
	// Position of REFSEL field.
	DAC_CTRLB_REFSEL_Pos = 0x6
	// Bit mask of REFSEL field.
	DAC_CTRLB_REFSEL_Msk = 0xc0
	// Internal 1.0V reference
	DAC_CTRLB_REFSEL_INT1V = 0x0
	// AVCC
	DAC_CTRLB_REFSEL_AVCC = 0x1
	// External reference
	DAC_CTRLB_REFSEL_VREFP = 0x2

	// EVCTRL: Event Control
	// Position of STARTEI field.
	DAC_EVCTRL_STARTEI_Pos = 0x0
	// Bit mask of STARTEI field.
	DAC_EVCTRL_STARTEI_Msk = 0x1
	// Bit STARTEI.
	DAC_EVCTRL_STARTEI = 0x1
	// Position of EMPTYEO field.
	DAC_EVCTRL_EMPTYEO_Pos = 0x1
	// Bit mask of EMPTYEO field.
	DAC_EVCTRL_EMPTYEO_Msk = 0x2
	// Bit EMPTYEO.
	DAC_EVCTRL_EMPTYEO = 0x2

	// INTENCLR: Interrupt Enable Clear
	// Position of UNDERRUN field.
	DAC_INTENCLR_UNDERRUN_Pos = 0x0
	// Bit mask of UNDERRUN field.
	DAC_INTENCLR_UNDERRUN_Msk = 0x1
	// Bit UNDERRUN.
	DAC_INTENCLR_UNDERRUN = 0x1
	// Position of EMPTY field.
	DAC_INTENCLR_EMPTY_Pos = 0x1
	// Bit mask of EMPTY field.
	DAC_INTENCLR_EMPTY_Msk = 0x2
	// Bit EMPTY.
	DAC_INTENCLR_EMPTY = 0x2
	// Position of SYNCRDY field.
	DAC_INTENCLR_SYNCRDY_Pos = 0x2
	// Bit mask of SYNCRDY field.
	DAC_INTENCLR_SYNCRDY_Msk = 0x4
	// Bit SYNCRDY.
	DAC_INTENCLR_SYNCRDY = 0x4

	// INTENSET: Interrupt Enable Set
	// Position of UNDERRUN field.
	DAC_INTENSET_UNDERRUN_Pos = 0x0
	// Bit mask of UNDERRUN field.
	DAC_INTENSET_UNDERRUN_Msk = 0x1
	// Bit UNDERRUN.
	DAC_INTENSET_UNDERRUN = 0x1
	// Position of EMPTY field.
	DAC_INTENSET_EMPTY_Pos = 0x1
	// Bit mask of EMPTY field.
	DAC_INTENSET_EMPTY_Msk = 0x2
	// Bit EMPTY.
	DAC_INTENSET_EMPTY = 0x2
	// Position of SYNCRDY field.
	DAC_INTENSET_SYNCRDY_Pos = 0x2
	// Bit mask of SYNCRDY field.
	DAC_INTENSET_SYNCRDY_Msk = 0x4
	// Bit SYNCRDY.
	DAC_INTENSET_SYNCRDY = 0x4

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of UNDERRUN field.
	DAC_INTFLAG_UNDERRUN_Pos = 0x0
	// Bit mask of UNDERRUN field.
	DAC_INTFLAG_UNDERRUN_Msk = 0x1
	// Bit UNDERRUN.
	DAC_INTFLAG_UNDERRUN = 0x1
	// Position of EMPTY field.
	DAC_INTFLAG_EMPTY_Pos = 0x1
	// Bit mask of EMPTY field.
	DAC_INTFLAG_EMPTY_Msk = 0x2
	// Bit EMPTY.
	DAC_INTFLAG_EMPTY = 0x2
	// Position of SYNCRDY field.
	DAC_INTFLAG_SYNCRDY_Pos = 0x2
	// Bit mask of SYNCRDY field.
	DAC_INTFLAG_SYNCRDY_Msk = 0x4
	// Bit SYNCRDY.
	DAC_INTFLAG_SYNCRDY = 0x4

	// STATUS: Status
	// Position of SYNCBUSY field.
	DAC_STATUS_SYNCBUSY_Pos = 0x7
	// Bit mask of SYNCBUSY field.
	DAC_STATUS_SYNCBUSY_Msk = 0x80
	// Bit SYNCBUSY.
	DAC_STATUS_SYNCBUSY = 0x80

	// DATA: Data
	// Position of DATA field.
	DAC_DATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	DAC_DATA_DATA_Msk = 0xffff

	// DATABUF: Data Buffer
	// Position of DATABUF field.
	DAC_DATABUF_DATABUF_Pos = 0x0
	// Bit mask of DATABUF field.
	DAC_DATABUF_DATABUF_Msk = 0xffff
)

// Constants for DMAC: Direct Memory Access Controller
const (
	// CTRL: Control
	// Position of SWRST field.
	DMAC_CTRL_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	DMAC_CTRL_SWRST_Msk = 0x1
	// Bit SWRST.
	DMAC_CTRL_SWRST = 0x1
	// Position of DMAENABLE field.
	DMAC_CTRL_DMAENABLE_Pos = 0x1
	// Bit mask of DMAENABLE field.
	DMAC_CTRL_DMAENABLE_Msk = 0x2
	// Bit DMAENABLE.
	DMAC_CTRL_DMAENABLE = 0x2
	// Position of CRCENABLE field.
	DMAC_CTRL_CRCENABLE_Pos = 0x2
	// Bit mask of CRCENABLE field.
	DMAC_CTRL_CRCENABLE_Msk = 0x4
	// Bit CRCENABLE.
	DMAC_CTRL_CRCENABLE = 0x4
	// Position of LVLEN0 field.
	DMAC_CTRL_LVLEN0_Pos = 0x8
	// Bit mask of LVLEN0 field.
	DMAC_CTRL_LVLEN0_Msk = 0x100
	// Bit LVLEN0.
	DMAC_CTRL_LVLEN0 = 0x100
	// Position of LVLEN1 field.
	DMAC_CTRL_LVLEN1_Pos = 0x9
	// Bit mask of LVLEN1 field.
	DMAC_CTRL_LVLEN1_Msk = 0x200
	// Bit LVLEN1.
	DMAC_CTRL_LVLEN1 = 0x200
	// Position of LVLEN2 field.
	DMAC_CTRL_LVLEN2_Pos = 0xa
	// Bit mask of LVLEN2 field.
	DMAC_CTRL_LVLEN2_Msk = 0x400
	// Bit LVLEN2.
	DMAC_CTRL_LVLEN2 = 0x400
	// Position of LVLEN3 field.
	DMAC_CTRL_LVLEN3_Pos = 0xb
	// Bit mask of LVLEN3 field.
	DMAC_CTRL_LVLEN3_Msk = 0x800
	// Bit LVLEN3.
	DMAC_CTRL_LVLEN3 = 0x800

	// CRCCTRL: CRC Control
	// Position of CRCBEATSIZE field.
	DMAC_CRCCTRL_CRCBEATSIZE_Pos = 0x0
	// Bit mask of CRCBEATSIZE field.
	DMAC_CRCCTRL_CRCBEATSIZE_Msk = 0x3
	// Byte bus access
	DMAC_CRCCTRL_CRCBEATSIZE_BYTE = 0x0
	// Half-word bus access
	DMAC_CRCCTRL_CRCBEATSIZE_HWORD = 0x1
	// Word bus access
	DMAC_CRCCTRL_CRCBEATSIZE_WORD = 0x2
	// Position of CRCPOLY field.
	DMAC_CRCCTRL_CRCPOLY_Pos = 0x2
	// Bit mask of CRCPOLY field.
	DMAC_CRCCTRL_CRCPOLY_Msk = 0xc
	// CRC-16 (CRC-CCITT)
	DMAC_CRCCTRL_CRCPOLY_CRC16 = 0x0
	// CRC32 (IEEE 802.3)
	DMAC_CRCCTRL_CRCPOLY_CRC32 = 0x1
	// Position of CRCSRC field.
	DMAC_CRCCTRL_CRCSRC_Pos = 0x8
	// Bit mask of CRCSRC field.
	DMAC_CRCCTRL_CRCSRC_Msk = 0x3f00
	// No action
	DMAC_CRCCTRL_CRCSRC_NOACT = 0x0
	// I/O interface
	DMAC_CRCCTRL_CRCSRC_IO = 0x1

	// CRCDATAIN: CRC Data Input
	// Position of CRCDATAIN field.
	DMAC_CRCDATAIN_CRCDATAIN_Pos = 0x0
	// Bit mask of CRCDATAIN field.
	DMAC_CRCDATAIN_CRCDATAIN_Msk = 0xffffffff

	// CRCCHKSUM: CRC Checksum
	// Position of CRCCHKSUM field.
	DMAC_CRCCHKSUM_CRCCHKSUM_Pos = 0x0
	// Bit mask of CRCCHKSUM field.
	DMAC_CRCCHKSUM_CRCCHKSUM_Msk = 0xffffffff

	// CRCSTATUS: CRC Status
	// Position of CRCBUSY field.
	DMAC_CRCSTATUS_CRCBUSY_Pos = 0x0
	// Bit mask of CRCBUSY field.
	DMAC_CRCSTATUS_CRCBUSY_Msk = 0x1
	// Bit CRCBUSY.
	DMAC_CRCSTATUS_CRCBUSY = 0x1
	// Position of CRCZERO field.
	DMAC_CRCSTATUS_CRCZERO_Pos = 0x1
	// Bit mask of CRCZERO field.
	DMAC_CRCSTATUS_CRCZERO_Msk = 0x2
	// Bit CRCZERO.
	DMAC_CRCSTATUS_CRCZERO = 0x2

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	DMAC_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	DMAC_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	DMAC_DBGCTRL_DBGRUN = 0x1

	// QOSCTRL: QOS Control
	// Position of WRBQOS field.
	DMAC_QOSCTRL_WRBQOS_Pos = 0x0
	// Bit mask of WRBQOS field.
	DMAC_QOSCTRL_WRBQOS_Msk = 0x3
	// Background (no sensitive operation)
	DMAC_QOSCTRL_WRBQOS_DISABLE = 0x0
	// Sensitive Bandwidth
	DMAC_QOSCTRL_WRBQOS_LOW = 0x1
	// Sensitive Latency
	DMAC_QOSCTRL_WRBQOS_MEDIUM = 0x2
	// Critical Latency
	DMAC_QOSCTRL_WRBQOS_HIGH = 0x3
	// Position of FQOS field.
	DMAC_QOSCTRL_FQOS_Pos = 0x2
	// Bit mask of FQOS field.
	DMAC_QOSCTRL_FQOS_Msk = 0xc
	// Background (no sensitive operation)
	DMAC_QOSCTRL_FQOS_DISABLE = 0x0
	// Sensitive Bandwidth
	DMAC_QOSCTRL_FQOS_LOW = 0x1
	// Sensitive Latency
	DMAC_QOSCTRL_FQOS_MEDIUM = 0x2
	// Critical Latency
	DMAC_QOSCTRL_FQOS_HIGH = 0x3
	// Position of DQOS field.
	DMAC_QOSCTRL_DQOS_Pos = 0x4
	// Bit mask of DQOS field.
	DMAC_QOSCTRL_DQOS_Msk = 0x30
	// Background (no sensitive operation)
	DMAC_QOSCTRL_DQOS_DISABLE = 0x0
	// Sensitive Bandwidth
	DMAC_QOSCTRL_DQOS_LOW = 0x1
	// Sensitive Latency
	DMAC_QOSCTRL_DQOS_MEDIUM = 0x2
	// Critical Latency
	DMAC_QOSCTRL_DQOS_HIGH = 0x3

	// SWTRIGCTRL: Software Trigger Control
	// Position of SWTRIG0 field.
	DMAC_SWTRIGCTRL_SWTRIG0_Pos = 0x0
	// Bit mask of SWTRIG0 field.
	DMAC_SWTRIGCTRL_SWTRIG0_Msk = 0x1
	// Bit SWTRIG0.
	DMAC_SWTRIGCTRL_SWTRIG0 = 0x1
	// Position of SWTRIG1 field.
	DMAC_SWTRIGCTRL_SWTRIG1_Pos = 0x1
	// Bit mask of SWTRIG1 field.
	DMAC_SWTRIGCTRL_SWTRIG1_Msk = 0x2
	// Bit SWTRIG1.
	DMAC_SWTRIGCTRL_SWTRIG1 = 0x2
	// Position of SWTRIG2 field.
	DMAC_SWTRIGCTRL_SWTRIG2_Pos = 0x2
	// Bit mask of SWTRIG2 field.
	DMAC_SWTRIGCTRL_SWTRIG2_Msk = 0x4
	// Bit SWTRIG2.
	DMAC_SWTRIGCTRL_SWTRIG2 = 0x4
	// Position of SWTRIG3 field.
	DMAC_SWTRIGCTRL_SWTRIG3_Pos = 0x3
	// Bit mask of SWTRIG3 field.
	DMAC_SWTRIGCTRL_SWTRIG3_Msk = 0x8
	// Bit SWTRIG3.
	DMAC_SWTRIGCTRL_SWTRIG3 = 0x8
	// Position of SWTRIG4 field.
	DMAC_SWTRIGCTRL_SWTRIG4_Pos = 0x4
	// Bit mask of SWTRIG4 field.
	DMAC_SWTRIGCTRL_SWTRIG4_Msk = 0x10
	// Bit SWTRIG4.
	DMAC_SWTRIGCTRL_SWTRIG4 = 0x10
	// Position of SWTRIG5 field.
	DMAC_SWTRIGCTRL_SWTRIG5_Pos = 0x5
	// Bit mask of SWTRIG5 field.
	DMAC_SWTRIGCTRL_SWTRIG5_Msk = 0x20
	// Bit SWTRIG5.
	DMAC_SWTRIGCTRL_SWTRIG5 = 0x20
	// Position of SWTRIG6 field.
	DMAC_SWTRIGCTRL_SWTRIG6_Pos = 0x6
	// Bit mask of SWTRIG6 field.
	DMAC_SWTRIGCTRL_SWTRIG6_Msk = 0x40
	// Bit SWTRIG6.
	DMAC_SWTRIGCTRL_SWTRIG6 = 0x40
	// Position of SWTRIG7 field.
	DMAC_SWTRIGCTRL_SWTRIG7_Pos = 0x7
	// Bit mask of SWTRIG7 field.
	DMAC_SWTRIGCTRL_SWTRIG7_Msk = 0x80
	// Bit SWTRIG7.
	DMAC_SWTRIGCTRL_SWTRIG7 = 0x80
	// Position of SWTRIG8 field.
	DMAC_SWTRIGCTRL_SWTRIG8_Pos = 0x8
	// Bit mask of SWTRIG8 field.
	DMAC_SWTRIGCTRL_SWTRIG8_Msk = 0x100
	// Bit SWTRIG8.
	DMAC_SWTRIGCTRL_SWTRIG8 = 0x100
	// Position of SWTRIG9 field.
	DMAC_SWTRIGCTRL_SWTRIG9_Pos = 0x9
	// Bit mask of SWTRIG9 field.
	DMAC_SWTRIGCTRL_SWTRIG9_Msk = 0x200
	// Bit SWTRIG9.
	DMAC_SWTRIGCTRL_SWTRIG9 = 0x200
	// Position of SWTRIG10 field.
	DMAC_SWTRIGCTRL_SWTRIG10_Pos = 0xa
	// Bit mask of SWTRIG10 field.
	DMAC_SWTRIGCTRL_SWTRIG10_Msk = 0x400
	// Bit SWTRIG10.
	DMAC_SWTRIGCTRL_SWTRIG10 = 0x400
	// Position of SWTRIG11 field.
	DMAC_SWTRIGCTRL_SWTRIG11_Pos = 0xb
	// Bit mask of SWTRIG11 field.
	DMAC_SWTRIGCTRL_SWTRIG11_Msk = 0x800
	// Bit SWTRIG11.
	DMAC_SWTRIGCTRL_SWTRIG11 = 0x800

	// PRICTRL0: Priority Control 0
	// Position of LVLPRI0 field.
	DMAC_PRICTRL0_LVLPRI0_Pos = 0x0
	// Bit mask of LVLPRI0 field.
	DMAC_PRICTRL0_LVLPRI0_Msk = 0xf
	// Position of RRLVLEN0 field.
	DMAC_PRICTRL0_RRLVLEN0_Pos = 0x7
	// Bit mask of RRLVLEN0 field.
	DMAC_PRICTRL0_RRLVLEN0_Msk = 0x80
	// Bit RRLVLEN0.
	DMAC_PRICTRL0_RRLVLEN0 = 0x80
	// Position of LVLPRI1 field.
	DMAC_PRICTRL0_LVLPRI1_Pos = 0x8
	// Bit mask of LVLPRI1 field.
	DMAC_PRICTRL0_LVLPRI1_Msk = 0xf00
	// Position of RRLVLEN1 field.
	DMAC_PRICTRL0_RRLVLEN1_Pos = 0xf
	// Bit mask of RRLVLEN1 field.
	DMAC_PRICTRL0_RRLVLEN1_Msk = 0x8000
	// Bit RRLVLEN1.
	DMAC_PRICTRL0_RRLVLEN1 = 0x8000
	// Position of LVLPRI2 field.
	DMAC_PRICTRL0_LVLPRI2_Pos = 0x10
	// Bit mask of LVLPRI2 field.
	DMAC_PRICTRL0_LVLPRI2_Msk = 0xf0000
	// Position of RRLVLEN2 field.
	DMAC_PRICTRL0_RRLVLEN2_Pos = 0x17
	// Bit mask of RRLVLEN2 field.
	DMAC_PRICTRL0_RRLVLEN2_Msk = 0x800000
	// Bit RRLVLEN2.
	DMAC_PRICTRL0_RRLVLEN2 = 0x800000
	// Position of LVLPRI3 field.
	DMAC_PRICTRL0_LVLPRI3_Pos = 0x18
	// Bit mask of LVLPRI3 field.
	DMAC_PRICTRL0_LVLPRI3_Msk = 0xf000000
	// Position of RRLVLEN3 field.
	DMAC_PRICTRL0_RRLVLEN3_Pos = 0x1f
	// Bit mask of RRLVLEN3 field.
	DMAC_PRICTRL0_RRLVLEN3_Msk = 0x80000000
	// Bit RRLVLEN3.
	DMAC_PRICTRL0_RRLVLEN3 = 0x80000000

	// INTPEND: Interrupt Pending
	// Position of ID field.
	DMAC_INTPEND_ID_Pos = 0x0
	// Bit mask of ID field.
	DMAC_INTPEND_ID_Msk = 0xf
	// Position of TERR field.
	DMAC_INTPEND_TERR_Pos = 0x8
	// Bit mask of TERR field.
	DMAC_INTPEND_TERR_Msk = 0x100
	// Bit TERR.
	DMAC_INTPEND_TERR = 0x100
	// Position of TCMPL field.
	DMAC_INTPEND_TCMPL_Pos = 0x9
	// Bit mask of TCMPL field.
	DMAC_INTPEND_TCMPL_Msk = 0x200
	// Bit TCMPL.
	DMAC_INTPEND_TCMPL = 0x200
	// Position of SUSP field.
	DMAC_INTPEND_SUSP_Pos = 0xa
	// Bit mask of SUSP field.
	DMAC_INTPEND_SUSP_Msk = 0x400
	// Bit SUSP.
	DMAC_INTPEND_SUSP = 0x400
	// Position of FERR field.
	DMAC_INTPEND_FERR_Pos = 0xd
	// Bit mask of FERR field.
	DMAC_INTPEND_FERR_Msk = 0x2000
	// Bit FERR.
	DMAC_INTPEND_FERR = 0x2000
	// Position of BUSY field.
	DMAC_INTPEND_BUSY_Pos = 0xe
	// Bit mask of BUSY field.
	DMAC_INTPEND_BUSY_Msk = 0x4000
	// Bit BUSY.
	DMAC_INTPEND_BUSY = 0x4000
	// Position of PEND field.
	DMAC_INTPEND_PEND_Pos = 0xf
	// Bit mask of PEND field.
	DMAC_INTPEND_PEND_Msk = 0x8000
	// Bit PEND.
	DMAC_INTPEND_PEND = 0x8000

	// INTSTATUS: Interrupt Status
	// Position of CHINT0 field.
	DMAC_INTSTATUS_CHINT0_Pos = 0x0
	// Bit mask of CHINT0 field.
	DMAC_INTSTATUS_CHINT0_Msk = 0x1
	// Bit CHINT0.
	DMAC_INTSTATUS_CHINT0 = 0x1
	// Position of CHINT1 field.
	DMAC_INTSTATUS_CHINT1_Pos = 0x1
	// Bit mask of CHINT1 field.
	DMAC_INTSTATUS_CHINT1_Msk = 0x2
	// Bit CHINT1.
	DMAC_INTSTATUS_CHINT1 = 0x2
	// Position of CHINT2 field.
	DMAC_INTSTATUS_CHINT2_Pos = 0x2
	// Bit mask of CHINT2 field.
	DMAC_INTSTATUS_CHINT2_Msk = 0x4
	// Bit CHINT2.
	DMAC_INTSTATUS_CHINT2 = 0x4
	// Position of CHINT3 field.
	DMAC_INTSTATUS_CHINT3_Pos = 0x3
	// Bit mask of CHINT3 field.
	DMAC_INTSTATUS_CHINT3_Msk = 0x8
	// Bit CHINT3.
	DMAC_INTSTATUS_CHINT3 = 0x8
	// Position of CHINT4 field.
	DMAC_INTSTATUS_CHINT4_Pos = 0x4
	// Bit mask of CHINT4 field.
	DMAC_INTSTATUS_CHINT4_Msk = 0x10
	// Bit CHINT4.
	DMAC_INTSTATUS_CHINT4 = 0x10
	// Position of CHINT5 field.
	DMAC_INTSTATUS_CHINT5_Pos = 0x5
	// Bit mask of CHINT5 field.
	DMAC_INTSTATUS_CHINT5_Msk = 0x20
	// Bit CHINT5.
	DMAC_INTSTATUS_CHINT5 = 0x20
	// Position of CHINT6 field.
	DMAC_INTSTATUS_CHINT6_Pos = 0x6
	// Bit mask of CHINT6 field.
	DMAC_INTSTATUS_CHINT6_Msk = 0x40
	// Bit CHINT6.
	DMAC_INTSTATUS_CHINT6 = 0x40
	// Position of CHINT7 field.
	DMAC_INTSTATUS_CHINT7_Pos = 0x7
	// Bit mask of CHINT7 field.
	DMAC_INTSTATUS_CHINT7_Msk = 0x80
	// Bit CHINT7.
	DMAC_INTSTATUS_CHINT7 = 0x80
	// Position of CHINT8 field.
	DMAC_INTSTATUS_CHINT8_Pos = 0x8
	// Bit mask of CHINT8 field.
	DMAC_INTSTATUS_CHINT8_Msk = 0x100
	// Bit CHINT8.
	DMAC_INTSTATUS_CHINT8 = 0x100
	// Position of CHINT9 field.
	DMAC_INTSTATUS_CHINT9_Pos = 0x9
	// Bit mask of CHINT9 field.
	DMAC_INTSTATUS_CHINT9_Msk = 0x200
	// Bit CHINT9.
	DMAC_INTSTATUS_CHINT9 = 0x200
	// Position of CHINT10 field.
	DMAC_INTSTATUS_CHINT10_Pos = 0xa
	// Bit mask of CHINT10 field.
	DMAC_INTSTATUS_CHINT10_Msk = 0x400
	// Bit CHINT10.
	DMAC_INTSTATUS_CHINT10 = 0x400
	// Position of CHINT11 field.
	DMAC_INTSTATUS_CHINT11_Pos = 0xb
	// Bit mask of CHINT11 field.
	DMAC_INTSTATUS_CHINT11_Msk = 0x800
	// Bit CHINT11.
	DMAC_INTSTATUS_CHINT11 = 0x800

	// BUSYCH: Busy Channels
	// Position of BUSYCH0 field.
	DMAC_BUSYCH_BUSYCH0_Pos = 0x0
	// Bit mask of BUSYCH0 field.
	DMAC_BUSYCH_BUSYCH0_Msk = 0x1
	// Bit BUSYCH0.
	DMAC_BUSYCH_BUSYCH0 = 0x1
	// Position of BUSYCH1 field.
	DMAC_BUSYCH_BUSYCH1_Pos = 0x1
	// Bit mask of BUSYCH1 field.
	DMAC_BUSYCH_BUSYCH1_Msk = 0x2
	// Bit BUSYCH1.
	DMAC_BUSYCH_BUSYCH1 = 0x2
	// Position of BUSYCH2 field.
	DMAC_BUSYCH_BUSYCH2_Pos = 0x2
	// Bit mask of BUSYCH2 field.
	DMAC_BUSYCH_BUSYCH2_Msk = 0x4
	// Bit BUSYCH2.
	DMAC_BUSYCH_BUSYCH2 = 0x4
	// Position of BUSYCH3 field.
	DMAC_BUSYCH_BUSYCH3_Pos = 0x3
	// Bit mask of BUSYCH3 field.
	DMAC_BUSYCH_BUSYCH3_Msk = 0x8
	// Bit BUSYCH3.
	DMAC_BUSYCH_BUSYCH3 = 0x8
	// Position of BUSYCH4 field.
	DMAC_BUSYCH_BUSYCH4_Pos = 0x4
	// Bit mask of BUSYCH4 field.
	DMAC_BUSYCH_BUSYCH4_Msk = 0x10
	// Bit BUSYCH4.
	DMAC_BUSYCH_BUSYCH4 = 0x10
	// Position of BUSYCH5 field.
	DMAC_BUSYCH_BUSYCH5_Pos = 0x5
	// Bit mask of BUSYCH5 field.
	DMAC_BUSYCH_BUSYCH5_Msk = 0x20
	// Bit BUSYCH5.
	DMAC_BUSYCH_BUSYCH5 = 0x20
	// Position of BUSYCH6 field.
	DMAC_BUSYCH_BUSYCH6_Pos = 0x6
	// Bit mask of BUSYCH6 field.
	DMAC_BUSYCH_BUSYCH6_Msk = 0x40
	// Bit BUSYCH6.
	DMAC_BUSYCH_BUSYCH6 = 0x40
	// Position of BUSYCH7 field.
	DMAC_BUSYCH_BUSYCH7_Pos = 0x7
	// Bit mask of BUSYCH7 field.
	DMAC_BUSYCH_BUSYCH7_Msk = 0x80
	// Bit BUSYCH7.
	DMAC_BUSYCH_BUSYCH7 = 0x80
	// Position of BUSYCH8 field.
	DMAC_BUSYCH_BUSYCH8_Pos = 0x8
	// Bit mask of BUSYCH8 field.
	DMAC_BUSYCH_BUSYCH8_Msk = 0x100
	// Bit BUSYCH8.
	DMAC_BUSYCH_BUSYCH8 = 0x100
	// Position of BUSYCH9 field.
	DMAC_BUSYCH_BUSYCH9_Pos = 0x9
	// Bit mask of BUSYCH9 field.
	DMAC_BUSYCH_BUSYCH9_Msk = 0x200
	// Bit BUSYCH9.
	DMAC_BUSYCH_BUSYCH9 = 0x200
	// Position of BUSYCH10 field.
	DMAC_BUSYCH_BUSYCH10_Pos = 0xa
	// Bit mask of BUSYCH10 field.
	DMAC_BUSYCH_BUSYCH10_Msk = 0x400
	// Bit BUSYCH10.
	DMAC_BUSYCH_BUSYCH10 = 0x400
	// Position of BUSYCH11 field.
	DMAC_BUSYCH_BUSYCH11_Pos = 0xb
	// Bit mask of BUSYCH11 field.
	DMAC_BUSYCH_BUSYCH11_Msk = 0x800
	// Bit BUSYCH11.
	DMAC_BUSYCH_BUSYCH11 = 0x800

	// PENDCH: Pending Channels
	// Position of PENDCH0 field.
	DMAC_PENDCH_PENDCH0_Pos = 0x0
	// Bit mask of PENDCH0 field.
	DMAC_PENDCH_PENDCH0_Msk = 0x1
	// Bit PENDCH0.
	DMAC_PENDCH_PENDCH0 = 0x1
	// Position of PENDCH1 field.
	DMAC_PENDCH_PENDCH1_Pos = 0x1
	// Bit mask of PENDCH1 field.
	DMAC_PENDCH_PENDCH1_Msk = 0x2
	// Bit PENDCH1.
	DMAC_PENDCH_PENDCH1 = 0x2
	// Position of PENDCH2 field.
	DMAC_PENDCH_PENDCH2_Pos = 0x2
	// Bit mask of PENDCH2 field.
	DMAC_PENDCH_PENDCH2_Msk = 0x4
	// Bit PENDCH2.
	DMAC_PENDCH_PENDCH2 = 0x4
	// Position of PENDCH3 field.
	DMAC_PENDCH_PENDCH3_Pos = 0x3
	// Bit mask of PENDCH3 field.
	DMAC_PENDCH_PENDCH3_Msk = 0x8
	// Bit PENDCH3.
	DMAC_PENDCH_PENDCH3 = 0x8
	// Position of PENDCH4 field.
	DMAC_PENDCH_PENDCH4_Pos = 0x4
	// Bit mask of PENDCH4 field.
	DMAC_PENDCH_PENDCH4_Msk = 0x10
	// Bit PENDCH4.
	DMAC_PENDCH_PENDCH4 = 0x10
	// Position of PENDCH5 field.
	DMAC_PENDCH_PENDCH5_Pos = 0x5
	// Bit mask of PENDCH5 field.
	DMAC_PENDCH_PENDCH5_Msk = 0x20
	// Bit PENDCH5.
	DMAC_PENDCH_PENDCH5 = 0x20
	// Position of PENDCH6 field.
	DMAC_PENDCH_PENDCH6_Pos = 0x6
	// Bit mask of PENDCH6 field.
	DMAC_PENDCH_PENDCH6_Msk = 0x40
	// Bit PENDCH6.
	DMAC_PENDCH_PENDCH6 = 0x40
	// Position of PENDCH7 field.
	DMAC_PENDCH_PENDCH7_Pos = 0x7
	// Bit mask of PENDCH7 field.
	DMAC_PENDCH_PENDCH7_Msk = 0x80
	// Bit PENDCH7.
	DMAC_PENDCH_PENDCH7 = 0x80
	// Position of PENDCH8 field.
	DMAC_PENDCH_PENDCH8_Pos = 0x8
	// Bit mask of PENDCH8 field.
	DMAC_PENDCH_PENDCH8_Msk = 0x100
	// Bit PENDCH8.
	DMAC_PENDCH_PENDCH8 = 0x100
	// Position of PENDCH9 field.
	DMAC_PENDCH_PENDCH9_Pos = 0x9
	// Bit mask of PENDCH9 field.
	DMAC_PENDCH_PENDCH9_Msk = 0x200
	// Bit PENDCH9.
	DMAC_PENDCH_PENDCH9 = 0x200
	// Position of PENDCH10 field.
	DMAC_PENDCH_PENDCH10_Pos = 0xa
	// Bit mask of PENDCH10 field.
	DMAC_PENDCH_PENDCH10_Msk = 0x400
	// Bit PENDCH10.
	DMAC_PENDCH_PENDCH10 = 0x400
	// Position of PENDCH11 field.
	DMAC_PENDCH_PENDCH11_Pos = 0xb
	// Bit mask of PENDCH11 field.
	DMAC_PENDCH_PENDCH11_Msk = 0x800
	// Bit PENDCH11.
	DMAC_PENDCH_PENDCH11 = 0x800

	// ACTIVE: Active Channel and Levels
	// Position of LVLEX0 field.
	DMAC_ACTIVE_LVLEX0_Pos = 0x0
	// Bit mask of LVLEX0 field.
	DMAC_ACTIVE_LVLEX0_Msk = 0x1
	// Bit LVLEX0.
	DMAC_ACTIVE_LVLEX0 = 0x1
	// Position of LVLEX1 field.
	DMAC_ACTIVE_LVLEX1_Pos = 0x1
	// Bit mask of LVLEX1 field.
	DMAC_ACTIVE_LVLEX1_Msk = 0x2
	// Bit LVLEX1.
	DMAC_ACTIVE_LVLEX1 = 0x2
	// Position of LVLEX2 field.
	DMAC_ACTIVE_LVLEX2_Pos = 0x2
	// Bit mask of LVLEX2 field.
	DMAC_ACTIVE_LVLEX2_Msk = 0x4
	// Bit LVLEX2.
	DMAC_ACTIVE_LVLEX2 = 0x4
	// Position of LVLEX3 field.
	DMAC_ACTIVE_LVLEX3_Pos = 0x3
	// Bit mask of LVLEX3 field.
	DMAC_ACTIVE_LVLEX3_Msk = 0x8
	// Bit LVLEX3.
	DMAC_ACTIVE_LVLEX3 = 0x8
	// Position of ID field.
	DMAC_ACTIVE_ID_Pos = 0x8
	// Bit mask of ID field.
	DMAC_ACTIVE_ID_Msk = 0x1f00
	// Position of ABUSY field.
	DMAC_ACTIVE_ABUSY_Pos = 0xf
	// Bit mask of ABUSY field.
	DMAC_ACTIVE_ABUSY_Msk = 0x8000
	// Bit ABUSY.
	DMAC_ACTIVE_ABUSY = 0x8000
	// Position of BTCNT field.
	DMAC_ACTIVE_BTCNT_Pos = 0x10
	// Bit mask of BTCNT field.
	DMAC_ACTIVE_BTCNT_Msk = 0xffff0000

	// BASEADDR: Descriptor Memory Section Base Address
	// Position of BASEADDR field.
	DMAC_BASEADDR_BASEADDR_Pos = 0x0
	// Bit mask of BASEADDR field.
	DMAC_BASEADDR_BASEADDR_Msk = 0xffffffff

	// WRBADDR: Write-Back Memory Section Base Address
	// Position of WRBADDR field.
	DMAC_WRBADDR_WRBADDR_Pos = 0x0
	// Bit mask of WRBADDR field.
	DMAC_WRBADDR_WRBADDR_Msk = 0xffffffff

	// CHID: Channel ID
	// Position of ID field.
	DMAC_CHID_ID_Pos = 0x0
	// Bit mask of ID field.
	DMAC_CHID_ID_Msk = 0xf

	// CHCTRLA: Channel Control A
	// Position of SWRST field.
	DMAC_CHCTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	DMAC_CHCTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	DMAC_CHCTRLA_SWRST = 0x1
	// Position of ENABLE field.
	DMAC_CHCTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	DMAC_CHCTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	DMAC_CHCTRLA_ENABLE = 0x2

	// CHCTRLB: Channel Control B
	// Position of EVACT field.
	DMAC_CHCTRLB_EVACT_Pos = 0x0
	// Bit mask of EVACT field.
	DMAC_CHCTRLB_EVACT_Msk = 0x7
	// No action
	DMAC_CHCTRLB_EVACT_NOACT = 0x0
	// Transfer and periodic transfer trigger
	DMAC_CHCTRLB_EVACT_TRIG = 0x1
	// Conditional transfer trigger
	DMAC_CHCTRLB_EVACT_CTRIG = 0x2
	// Conditional block transfer
	DMAC_CHCTRLB_EVACT_CBLOCK = 0x3
	// Channel suspend operation
	DMAC_CHCTRLB_EVACT_SUSPEND = 0x4
	// Channel resume operation
	DMAC_CHCTRLB_EVACT_RESUME = 0x5
	// Skip next block suspend action
	DMAC_CHCTRLB_EVACT_SSKIP = 0x6
	// Position of EVIE field.
	DMAC_CHCTRLB_EVIE_Pos = 0x3
	// Bit mask of EVIE field.
	DMAC_CHCTRLB_EVIE_Msk = 0x8
	// Bit EVIE.
	DMAC_CHCTRLB_EVIE = 0x8
	// Position of EVOE field.
	DMAC_CHCTRLB_EVOE_Pos = 0x4
	// Bit mask of EVOE field.
	DMAC_CHCTRLB_EVOE_Msk = 0x10
	// Bit EVOE.
	DMAC_CHCTRLB_EVOE = 0x10
	// Position of LVL field.
	DMAC_CHCTRLB_LVL_Pos = 0x5
	// Bit mask of LVL field.
	DMAC_CHCTRLB_LVL_Msk = 0x60
	// Channel Priority Level 0
	DMAC_CHCTRLB_LVL_LVL0 = 0x0
	// Channel Priority Level 1
	DMAC_CHCTRLB_LVL_LVL1 = 0x1
	// Channel Priority Level 2
	DMAC_CHCTRLB_LVL_LVL2 = 0x2
	// Channel Priority Level 3
	DMAC_CHCTRLB_LVL_LVL3 = 0x3
	// Position of TRIGSRC field.
	DMAC_CHCTRLB_TRIGSRC_Pos = 0x8
	// Bit mask of TRIGSRC field.
	DMAC_CHCTRLB_TRIGSRC_Msk = 0x3f00
	// Only software/event triggers
	DMAC_CHCTRLB_TRIGSRC_DISABLE = 0x0
	// Position of TRIGACT field.
	DMAC_CHCTRLB_TRIGACT_Pos = 0x16
	// Bit mask of TRIGACT field.
	DMAC_CHCTRLB_TRIGACT_Msk = 0xc00000
	// One trigger required for each block transfer
	DMAC_CHCTRLB_TRIGACT_BLOCK = 0x0
	// One trigger required for each beat transfer
	DMAC_CHCTRLB_TRIGACT_BEAT = 0x2
	// One trigger required for each transaction
	DMAC_CHCTRLB_TRIGACT_TRANSACTION = 0x3
	// Position of CMD field.
	DMAC_CHCTRLB_CMD_Pos = 0x18
	// Bit mask of CMD field.
	DMAC_CHCTRLB_CMD_Msk = 0x3000000
	// No action
	DMAC_CHCTRLB_CMD_NOACT = 0x0
	// Channel suspend operation
	DMAC_CHCTRLB_CMD_SUSPEND = 0x1
	// Channel resume operation
	DMAC_CHCTRLB_CMD_RESUME = 0x2

	// CHINTENCLR: Channel Interrupt Enable Clear
	// Position of TERR field.
	DMAC_CHINTENCLR_TERR_Pos = 0x0
	// Bit mask of TERR field.
	DMAC_CHINTENCLR_TERR_Msk = 0x1
	// Bit TERR.
	DMAC_CHINTENCLR_TERR = 0x1
	// Position of TCMPL field.
	DMAC_CHINTENCLR_TCMPL_Pos = 0x1
	// Bit mask of TCMPL field.
	DMAC_CHINTENCLR_TCMPL_Msk = 0x2
	// Bit TCMPL.
	DMAC_CHINTENCLR_TCMPL = 0x2
	// Position of SUSP field.
	DMAC_CHINTENCLR_SUSP_Pos = 0x2
	// Bit mask of SUSP field.
	DMAC_CHINTENCLR_SUSP_Msk = 0x4
	// Bit SUSP.
	DMAC_CHINTENCLR_SUSP = 0x4

	// CHINTENSET: Channel Interrupt Enable Set
	// Position of TERR field.
	DMAC_CHINTENSET_TERR_Pos = 0x0
	// Bit mask of TERR field.
	DMAC_CHINTENSET_TERR_Msk = 0x1
	// Bit TERR.
	DMAC_CHINTENSET_TERR = 0x1
	// Position of TCMPL field.
	DMAC_CHINTENSET_TCMPL_Pos = 0x1
	// Bit mask of TCMPL field.
	DMAC_CHINTENSET_TCMPL_Msk = 0x2
	// Bit TCMPL.
	DMAC_CHINTENSET_TCMPL = 0x2
	// Position of SUSP field.
	DMAC_CHINTENSET_SUSP_Pos = 0x2
	// Bit mask of SUSP field.
	DMAC_CHINTENSET_SUSP_Msk = 0x4
	// Bit SUSP.
	DMAC_CHINTENSET_SUSP = 0x4

	// CHINTFLAG: Channel Interrupt Flag Status and Clear
	// Position of TERR field.
	DMAC_CHINTFLAG_TERR_Pos = 0x0
	// Bit mask of TERR field.
	DMAC_CHINTFLAG_TERR_Msk = 0x1
	// Bit TERR.
	DMAC_CHINTFLAG_TERR = 0x1
	// Position of TCMPL field.
	DMAC_CHINTFLAG_TCMPL_Pos = 0x1
	// Bit mask of TCMPL field.
	DMAC_CHINTFLAG_TCMPL_Msk = 0x2
	// Bit TCMPL.
	DMAC_CHINTFLAG_TCMPL = 0x2
	// Position of SUSP field.
	DMAC_CHINTFLAG_SUSP_Pos = 0x2
	// Bit mask of SUSP field.
	DMAC_CHINTFLAG_SUSP_Msk = 0x4
	// Bit SUSP.
	DMAC_CHINTFLAG_SUSP = 0x4

	// CHSTATUS: Channel Status
	// Position of PEND field.
	DMAC_CHSTATUS_PEND_Pos = 0x0
	// Bit mask of PEND field.
	DMAC_CHSTATUS_PEND_Msk = 0x1
	// Bit PEND.
	DMAC_CHSTATUS_PEND = 0x1
	// Position of BUSY field.
	DMAC_CHSTATUS_BUSY_Pos = 0x1
	// Bit mask of BUSY field.
	DMAC_CHSTATUS_BUSY_Msk = 0x2
	// Bit BUSY.
	DMAC_CHSTATUS_BUSY = 0x2
	// Position of FERR field.
	DMAC_CHSTATUS_FERR_Pos = 0x2
	// Bit mask of FERR field.
	DMAC_CHSTATUS_FERR_Msk = 0x4
	// Bit FERR.
	DMAC_CHSTATUS_FERR = 0x4
)

// Constants for DSU: Device Service Unit
const (
	// CTRL: Control
	// Position of SWRST field.
	DSU_CTRL_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	DSU_CTRL_SWRST_Msk = 0x1
	// Bit SWRST.
	DSU_CTRL_SWRST = 0x1
	// Position of CRC field.
	DSU_CTRL_CRC_Pos = 0x2
	// Bit mask of CRC field.
	DSU_CTRL_CRC_Msk = 0x4
	// Bit CRC.
	DSU_CTRL_CRC = 0x4
	// Position of MBIST field.
	DSU_CTRL_MBIST_Pos = 0x3
	// Bit mask of MBIST field.
	DSU_CTRL_MBIST_Msk = 0x8
	// Bit MBIST.
	DSU_CTRL_MBIST = 0x8
	// Position of CE field.
	DSU_CTRL_CE_Pos = 0x4
	// Bit mask of CE field.
	DSU_CTRL_CE_Msk = 0x10
	// Bit CE.
	DSU_CTRL_CE = 0x10

	// STATUSA: Status A
	// Position of DONE field.
	DSU_STATUSA_DONE_Pos = 0x0
	// Bit mask of DONE field.
	DSU_STATUSA_DONE_Msk = 0x1
	// Bit DONE.
	DSU_STATUSA_DONE = 0x1
	// Position of CRSTEXT field.
	DSU_STATUSA_CRSTEXT_Pos = 0x1
	// Bit mask of CRSTEXT field.
	DSU_STATUSA_CRSTEXT_Msk = 0x2
	// Bit CRSTEXT.
	DSU_STATUSA_CRSTEXT = 0x2
	// Position of BERR field.
	DSU_STATUSA_BERR_Pos = 0x2
	// Bit mask of BERR field.
	DSU_STATUSA_BERR_Msk = 0x4
	// Bit BERR.
	DSU_STATUSA_BERR = 0x4
	// Position of FAIL field.
	DSU_STATUSA_FAIL_Pos = 0x3
	// Bit mask of FAIL field.
	DSU_STATUSA_FAIL_Msk = 0x8
	// Bit FAIL.
	DSU_STATUSA_FAIL = 0x8
	// Position of PERR field.
	DSU_STATUSA_PERR_Pos = 0x4
	// Bit mask of PERR field.
	DSU_STATUSA_PERR_Msk = 0x10
	// Bit PERR.
	DSU_STATUSA_PERR = 0x10

	// STATUSB: Status B
	// Position of PROT field.
	DSU_STATUSB_PROT_Pos = 0x0
	// Bit mask of PROT field.
	DSU_STATUSB_PROT_Msk = 0x1
	// Bit PROT.
	DSU_STATUSB_PROT = 0x1
	// Position of DBGPRES field.
	DSU_STATUSB_DBGPRES_Pos = 0x1
	// Bit mask of DBGPRES field.
	DSU_STATUSB_DBGPRES_Msk = 0x2
	// Bit DBGPRES.
	DSU_STATUSB_DBGPRES = 0x2
	// Position of DCCD0 field.
	DSU_STATUSB_DCCD0_Pos = 0x2
	// Bit mask of DCCD0 field.
	DSU_STATUSB_DCCD0_Msk = 0x4
	// Bit DCCD0.
	DSU_STATUSB_DCCD0 = 0x4
	// Position of DCCD1 field.
	DSU_STATUSB_DCCD1_Pos = 0x3
	// Bit mask of DCCD1 field.
	DSU_STATUSB_DCCD1_Msk = 0x8
	// Bit DCCD1.
	DSU_STATUSB_DCCD1 = 0x8
	// Position of HPE field.
	DSU_STATUSB_HPE_Pos = 0x4
	// Bit mask of HPE field.
	DSU_STATUSB_HPE_Msk = 0x10
	// Bit HPE.
	DSU_STATUSB_HPE = 0x10

	// ADDR: Address
	// Position of ADDR field.
	DSU_ADDR_ADDR_Pos = 0x2
	// Bit mask of ADDR field.
	DSU_ADDR_ADDR_Msk = 0xfffffffc

	// LENGTH: Length
	// Position of LENGTH field.
	DSU_LENGTH_LENGTH_Pos = 0x2
	// Bit mask of LENGTH field.
	DSU_LENGTH_LENGTH_Msk = 0xfffffffc

	// DATA: Data
	// Position of DATA field.
	DSU_DATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	DSU_DATA_DATA_Msk = 0xffffffff

	// DCC0: Debug Communication Channel n
	// Position of DATA field.
	DSU_DCC_DATA_Pos = 0x0
	// Bit mask of DATA field.
	DSU_DCC_DATA_Msk = 0xffffffff

	// DID: Device Identification
	// Position of DEVSEL field.
	DSU_DID_DEVSEL_Pos = 0x0
	// Bit mask of DEVSEL field.
	DSU_DID_DEVSEL_Msk = 0xff
	// Position of REVISION field.
	DSU_DID_REVISION_Pos = 0x8
	// Bit mask of REVISION field.
	DSU_DID_REVISION_Msk = 0xf00
	// Position of DIE field.
	DSU_DID_DIE_Pos = 0xc
	// Bit mask of DIE field.
	DSU_DID_DIE_Msk = 0xf000
	// Position of SERIES field.
	DSU_DID_SERIES_Pos = 0x10
	// Bit mask of SERIES field.
	DSU_DID_SERIES_Msk = 0x3f0000
	// Position of FAMILY field.
	DSU_DID_FAMILY_Pos = 0x17
	// Bit mask of FAMILY field.
	DSU_DID_FAMILY_Msk = 0xf800000
	// Position of PROCESSOR field.
	DSU_DID_PROCESSOR_Pos = 0x1c
	// Bit mask of PROCESSOR field.
	DSU_DID_PROCESSOR_Msk = 0xf0000000

	// ENTRY0: CoreSight ROM Table Entry 0
	// Position of EPRES field.
	DSU_ENTRY0_EPRES_Pos = 0x0
	// Bit mask of EPRES field.
	DSU_ENTRY0_EPRES_Msk = 0x1
	// Bit EPRES.
	DSU_ENTRY0_EPRES = 0x1
	// Position of FMT field.
	DSU_ENTRY0_FMT_Pos = 0x1
	// Bit mask of FMT field.
	DSU_ENTRY0_FMT_Msk = 0x2
	// Bit FMT.
	DSU_ENTRY0_FMT = 0x2
	// Position of ADDOFF field.
	DSU_ENTRY0_ADDOFF_Pos = 0xc
	// Bit mask of ADDOFF field.
	DSU_ENTRY0_ADDOFF_Msk = 0xfffff000

	// END: CoreSight ROM Table End
	// Position of END field.
	DSU_END_END_Pos = 0x0
	// Bit mask of END field.
	DSU_END_END_Msk = 0xffffffff

	// MEMTYPE: CoreSight ROM Table Memory Type
	// Position of SMEMP field.
	DSU_MEMTYPE_SMEMP_Pos = 0x0
	// Bit mask of SMEMP field.
	DSU_MEMTYPE_SMEMP_Msk = 0x1
	// Bit SMEMP.
	DSU_MEMTYPE_SMEMP = 0x1

	// PID4: Peripheral Identification 4
	// Position of JEPCC field.
	DSU_PID4_JEPCC_Pos = 0x0
	// Bit mask of JEPCC field.
	DSU_PID4_JEPCC_Msk = 0xf
	// Position of FKBC field.
	DSU_PID4_FKBC_Pos = 0x4
	// Bit mask of FKBC field.
	DSU_PID4_FKBC_Msk = 0xf0

	// PID0: Peripheral Identification 0
	// Position of PARTNBL field.
	DSU_PID0_PARTNBL_Pos = 0x0
	// Bit mask of PARTNBL field.
	DSU_PID0_PARTNBL_Msk = 0xff

	// PID1: Peripheral Identification 1
	// Position of PARTNBH field.
	DSU_PID1_PARTNBH_Pos = 0x0
	// Bit mask of PARTNBH field.
	DSU_PID1_PARTNBH_Msk = 0xf
	// Position of JEPIDCL field.
	DSU_PID1_JEPIDCL_Pos = 0x4
	// Bit mask of JEPIDCL field.
	DSU_PID1_JEPIDCL_Msk = 0xf0

	// PID2: Peripheral Identification 2
	// Position of JEPIDCH field.
	DSU_PID2_JEPIDCH_Pos = 0x0
	// Bit mask of JEPIDCH field.
	DSU_PID2_JEPIDCH_Msk = 0x7
	// Position of JEPU field.
	DSU_PID2_JEPU_Pos = 0x3
	// Bit mask of JEPU field.
	DSU_PID2_JEPU_Msk = 0x8
	// Bit JEPU.
	DSU_PID2_JEPU = 0x8
	// Position of REVISION field.
	DSU_PID2_REVISION_Pos = 0x4
	// Bit mask of REVISION field.
	DSU_PID2_REVISION_Msk = 0xf0

	// PID3: Peripheral Identification 3
	// Position of CUSMOD field.
	DSU_PID3_CUSMOD_Pos = 0x0
	// Bit mask of CUSMOD field.
	DSU_PID3_CUSMOD_Msk = 0xf
	// Position of REVAND field.
	DSU_PID3_REVAND_Pos = 0x4
	// Bit mask of REVAND field.
	DSU_PID3_REVAND_Msk = 0xf0

	// CID0: Component Identification 0
	// Position of PREAMBLEB0 field.
	DSU_CID0_PREAMBLEB0_Pos = 0x0
	// Bit mask of PREAMBLEB0 field.
	DSU_CID0_PREAMBLEB0_Msk = 0xff

	// CID1: Component Identification 1
	// Position of PREAMBLE field.
	DSU_CID1_PREAMBLE_Pos = 0x0
	// Bit mask of PREAMBLE field.
	DSU_CID1_PREAMBLE_Msk = 0xf
	// Position of CCLASS field.
	DSU_CID1_CCLASS_Pos = 0x4
	// Bit mask of CCLASS field.
	DSU_CID1_CCLASS_Msk = 0xf0

	// CID2: Component Identification 2
	// Position of PREAMBLEB2 field.
	DSU_CID2_PREAMBLEB2_Pos = 0x0
	// Bit mask of PREAMBLEB2 field.
	DSU_CID2_PREAMBLEB2_Msk = 0xff

	// CID3: Component Identification 3
	// Position of PREAMBLEB3 field.
	DSU_CID3_PREAMBLEB3_Pos = 0x0
	// Bit mask of PREAMBLEB3 field.
	DSU_CID3_PREAMBLEB3_Msk = 0xff
)

// Constants for EIC: External Interrupt Controller
const (
	// CTRL: Control
	// Position of SWRST field.
	EIC_CTRL_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	EIC_CTRL_SWRST_Msk = 0x1
	// Bit SWRST.
	EIC_CTRL_SWRST = 0x1
	// Position of ENABLE field.
	EIC_CTRL_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	EIC_CTRL_ENABLE_Msk = 0x2
	// Bit ENABLE.
	EIC_CTRL_ENABLE = 0x2

	// STATUS: Status
	// Position of SYNCBUSY field.
	EIC_STATUS_SYNCBUSY_Pos = 0x7
	// Bit mask of SYNCBUSY field.
	EIC_STATUS_SYNCBUSY_Msk = 0x80
	// Bit SYNCBUSY.
	EIC_STATUS_SYNCBUSY = 0x80

	// NMICTRL: Non-Maskable Interrupt Control
	// Position of NMISENSE field.
	EIC_NMICTRL_NMISENSE_Pos = 0x0
	// Bit mask of NMISENSE field.
	EIC_NMICTRL_NMISENSE_Msk = 0x7
	// No detection
	EIC_NMICTRL_NMISENSE_NONE = 0x0
	// Rising-edge detection
	EIC_NMICTRL_NMISENSE_RISE = 0x1
	// Falling-edge detection
	EIC_NMICTRL_NMISENSE_FALL = 0x2
	// Both-edges detection
	EIC_NMICTRL_NMISENSE_BOTH = 0x3
	// High-level detection
	EIC_NMICTRL_NMISENSE_HIGH = 0x4
	// Low-level detection
	EIC_NMICTRL_NMISENSE_LOW = 0x5
	// Position of NMIFILTEN field.
	EIC_NMICTRL_NMIFILTEN_Pos = 0x3
	// Bit mask of NMIFILTEN field.
	EIC_NMICTRL_NMIFILTEN_Msk = 0x8
	// Bit NMIFILTEN.
	EIC_NMICTRL_NMIFILTEN = 0x8

	// NMIFLAG: Non-Maskable Interrupt Flag Status and Clear
	// Position of NMI field.
	EIC_NMIFLAG_NMI_Pos = 0x0
	// Bit mask of NMI field.
	EIC_NMIFLAG_NMI_Msk = 0x1
	// Bit NMI.
	EIC_NMIFLAG_NMI = 0x1

	// EVCTRL: Event Control
	// Position of EXTINTEO0 field.
	EIC_EVCTRL_EXTINTEO0_Pos = 0x0
	// Bit mask of EXTINTEO0 field.
	EIC_EVCTRL_EXTINTEO0_Msk = 0x1
	// Bit EXTINTEO0.
	EIC_EVCTRL_EXTINTEO0 = 0x1
	// Position of EXTINTEO1 field.
	EIC_EVCTRL_EXTINTEO1_Pos = 0x1
	// Bit mask of EXTINTEO1 field.
	EIC_EVCTRL_EXTINTEO1_Msk = 0x2
	// Bit EXTINTEO1.
	EIC_EVCTRL_EXTINTEO1 = 0x2
	// Position of EXTINTEO2 field.
	EIC_EVCTRL_EXTINTEO2_Pos = 0x2
	// Bit mask of EXTINTEO2 field.
	EIC_EVCTRL_EXTINTEO2_Msk = 0x4
	// Bit EXTINTEO2.
	EIC_EVCTRL_EXTINTEO2 = 0x4
	// Position of EXTINTEO3 field.
	EIC_EVCTRL_EXTINTEO3_Pos = 0x3
	// Bit mask of EXTINTEO3 field.
	EIC_EVCTRL_EXTINTEO3_Msk = 0x8
	// Bit EXTINTEO3.
	EIC_EVCTRL_EXTINTEO3 = 0x8
	// Position of EXTINTEO4 field.
	EIC_EVCTRL_EXTINTEO4_Pos = 0x4
	// Bit mask of EXTINTEO4 field.
	EIC_EVCTRL_EXTINTEO4_Msk = 0x10
	// Bit EXTINTEO4.
	EIC_EVCTRL_EXTINTEO4 = 0x10
	// Position of EXTINTEO5 field.
	EIC_EVCTRL_EXTINTEO5_Pos = 0x5
	// Bit mask of EXTINTEO5 field.
	EIC_EVCTRL_EXTINTEO5_Msk = 0x20
	// Bit EXTINTEO5.
	EIC_EVCTRL_EXTINTEO5 = 0x20
	// Position of EXTINTEO6 field.
	EIC_EVCTRL_EXTINTEO6_Pos = 0x6
	// Bit mask of EXTINTEO6 field.
	EIC_EVCTRL_EXTINTEO6_Msk = 0x40
	// Bit EXTINTEO6.
	EIC_EVCTRL_EXTINTEO6 = 0x40
	// Position of EXTINTEO7 field.
	EIC_EVCTRL_EXTINTEO7_Pos = 0x7
	// Bit mask of EXTINTEO7 field.
	EIC_EVCTRL_EXTINTEO7_Msk = 0x80
	// Bit EXTINTEO7.
	EIC_EVCTRL_EXTINTEO7 = 0x80
	// Position of EXTINTEO8 field.
	EIC_EVCTRL_EXTINTEO8_Pos = 0x8
	// Bit mask of EXTINTEO8 field.
	EIC_EVCTRL_EXTINTEO8_Msk = 0x100
	// Bit EXTINTEO8.
	EIC_EVCTRL_EXTINTEO8 = 0x100
	// Position of EXTINTEO9 field.
	EIC_EVCTRL_EXTINTEO9_Pos = 0x9
	// Bit mask of EXTINTEO9 field.
	EIC_EVCTRL_EXTINTEO9_Msk = 0x200
	// Bit EXTINTEO9.
	EIC_EVCTRL_EXTINTEO9 = 0x200
	// Position of EXTINTEO10 field.
	EIC_EVCTRL_EXTINTEO10_Pos = 0xa
	// Bit mask of EXTINTEO10 field.
	EIC_EVCTRL_EXTINTEO10_Msk = 0x400
	// Bit EXTINTEO10.
	EIC_EVCTRL_EXTINTEO10 = 0x400
	// Position of EXTINTEO11 field.
	EIC_EVCTRL_EXTINTEO11_Pos = 0xb
	// Bit mask of EXTINTEO11 field.
	EIC_EVCTRL_EXTINTEO11_Msk = 0x800
	// Bit EXTINTEO11.
	EIC_EVCTRL_EXTINTEO11 = 0x800
	// Position of EXTINTEO12 field.
	EIC_EVCTRL_EXTINTEO12_Pos = 0xc
	// Bit mask of EXTINTEO12 field.
	EIC_EVCTRL_EXTINTEO12_Msk = 0x1000
	// Bit EXTINTEO12.
	EIC_EVCTRL_EXTINTEO12 = 0x1000
	// Position of EXTINTEO13 field.
	EIC_EVCTRL_EXTINTEO13_Pos = 0xd
	// Bit mask of EXTINTEO13 field.
	EIC_EVCTRL_EXTINTEO13_Msk = 0x2000
	// Bit EXTINTEO13.
	EIC_EVCTRL_EXTINTEO13 = 0x2000
	// Position of EXTINTEO14 field.
	EIC_EVCTRL_EXTINTEO14_Pos = 0xe
	// Bit mask of EXTINTEO14 field.
	EIC_EVCTRL_EXTINTEO14_Msk = 0x4000
	// Bit EXTINTEO14.
	EIC_EVCTRL_EXTINTEO14 = 0x4000
	// Position of EXTINTEO15 field.
	EIC_EVCTRL_EXTINTEO15_Pos = 0xf
	// Bit mask of EXTINTEO15 field.
	EIC_EVCTRL_EXTINTEO15_Msk = 0x8000
	// Bit EXTINTEO15.
	EIC_EVCTRL_EXTINTEO15 = 0x8000

	// INTENCLR: Interrupt Enable Clear
	// Position of EXTINT0 field.
	EIC_INTENCLR_EXTINT0_Pos = 0x0
	// Bit mask of EXTINT0 field.
	EIC_INTENCLR_EXTINT0_Msk = 0x1
	// Bit EXTINT0.
	EIC_INTENCLR_EXTINT0 = 0x1
	// Position of EXTINT1 field.
	EIC_INTENCLR_EXTINT1_Pos = 0x1
	// Bit mask of EXTINT1 field.
	EIC_INTENCLR_EXTINT1_Msk = 0x2
	// Bit EXTINT1.
	EIC_INTENCLR_EXTINT1 = 0x2
	// Position of EXTINT2 field.
	EIC_INTENCLR_EXTINT2_Pos = 0x2
	// Bit mask of EXTINT2 field.
	EIC_INTENCLR_EXTINT2_Msk = 0x4
	// Bit EXTINT2.
	EIC_INTENCLR_EXTINT2 = 0x4
	// Position of EXTINT3 field.
	EIC_INTENCLR_EXTINT3_Pos = 0x3
	// Bit mask of EXTINT3 field.
	EIC_INTENCLR_EXTINT3_Msk = 0x8
	// Bit EXTINT3.
	EIC_INTENCLR_EXTINT3 = 0x8
	// Position of EXTINT4 field.
	EIC_INTENCLR_EXTINT4_Pos = 0x4
	// Bit mask of EXTINT4 field.
	EIC_INTENCLR_EXTINT4_Msk = 0x10
	// Bit EXTINT4.
	EIC_INTENCLR_EXTINT4 = 0x10
	// Position of EXTINT5 field.
	EIC_INTENCLR_EXTINT5_Pos = 0x5
	// Bit mask of EXTINT5 field.
	EIC_INTENCLR_EXTINT5_Msk = 0x20
	// Bit EXTINT5.
	EIC_INTENCLR_EXTINT5 = 0x20
	// Position of EXTINT6 field.
	EIC_INTENCLR_EXTINT6_Pos = 0x6
	// Bit mask of EXTINT6 field.
	EIC_INTENCLR_EXTINT6_Msk = 0x40
	// Bit EXTINT6.
	EIC_INTENCLR_EXTINT6 = 0x40
	// Position of EXTINT7 field.
	EIC_INTENCLR_EXTINT7_Pos = 0x7
	// Bit mask of EXTINT7 field.
	EIC_INTENCLR_EXTINT7_Msk = 0x80
	// Bit EXTINT7.
	EIC_INTENCLR_EXTINT7 = 0x80
	// Position of EXTINT8 field.
	EIC_INTENCLR_EXTINT8_Pos = 0x8
	// Bit mask of EXTINT8 field.
	EIC_INTENCLR_EXTINT8_Msk = 0x100
	// Bit EXTINT8.
	EIC_INTENCLR_EXTINT8 = 0x100
	// Position of EXTINT9 field.
	EIC_INTENCLR_EXTINT9_Pos = 0x9
	// Bit mask of EXTINT9 field.
	EIC_INTENCLR_EXTINT9_Msk = 0x200
	// Bit EXTINT9.
	EIC_INTENCLR_EXTINT9 = 0x200
	// Position of EXTINT10 field.
	EIC_INTENCLR_EXTINT10_Pos = 0xa
	// Bit mask of EXTINT10 field.
	EIC_INTENCLR_EXTINT10_Msk = 0x400
	// Bit EXTINT10.
	EIC_INTENCLR_EXTINT10 = 0x400
	// Position of EXTINT11 field.
	EIC_INTENCLR_EXTINT11_Pos = 0xb
	// Bit mask of EXTINT11 field.
	EIC_INTENCLR_EXTINT11_Msk = 0x800
	// Bit EXTINT11.
	EIC_INTENCLR_EXTINT11 = 0x800
	// Position of EXTINT12 field.
	EIC_INTENCLR_EXTINT12_Pos = 0xc
	// Bit mask of EXTINT12 field.
	EIC_INTENCLR_EXTINT12_Msk = 0x1000
	// Bit EXTINT12.
	EIC_INTENCLR_EXTINT12 = 0x1000
	// Position of EXTINT13 field.
	EIC_INTENCLR_EXTINT13_Pos = 0xd
	// Bit mask of EXTINT13 field.
	EIC_INTENCLR_EXTINT13_Msk = 0x2000
	// Bit EXTINT13.
	EIC_INTENCLR_EXTINT13 = 0x2000
	// Position of EXTINT14 field.
	EIC_INTENCLR_EXTINT14_Pos = 0xe
	// Bit mask of EXTINT14 field.
	EIC_INTENCLR_EXTINT14_Msk = 0x4000
	// Bit EXTINT14.
	EIC_INTENCLR_EXTINT14 = 0x4000
	// Position of EXTINT15 field.
	EIC_INTENCLR_EXTINT15_Pos = 0xf
	// Bit mask of EXTINT15 field.
	EIC_INTENCLR_EXTINT15_Msk = 0x8000
	// Bit EXTINT15.
	EIC_INTENCLR_EXTINT15 = 0x8000

	// INTENSET: Interrupt Enable Set
	// Position of EXTINT0 field.
	EIC_INTENSET_EXTINT0_Pos = 0x0
	// Bit mask of EXTINT0 field.
	EIC_INTENSET_EXTINT0_Msk = 0x1
	// Bit EXTINT0.
	EIC_INTENSET_EXTINT0 = 0x1
	// Position of EXTINT1 field.
	EIC_INTENSET_EXTINT1_Pos = 0x1
	// Bit mask of EXTINT1 field.
	EIC_INTENSET_EXTINT1_Msk = 0x2
	// Bit EXTINT1.
	EIC_INTENSET_EXTINT1 = 0x2
	// Position of EXTINT2 field.
	EIC_INTENSET_EXTINT2_Pos = 0x2
	// Bit mask of EXTINT2 field.
	EIC_INTENSET_EXTINT2_Msk = 0x4
	// Bit EXTINT2.
	EIC_INTENSET_EXTINT2 = 0x4
	// Position of EXTINT3 field.
	EIC_INTENSET_EXTINT3_Pos = 0x3
	// Bit mask of EXTINT3 field.
	EIC_INTENSET_EXTINT3_Msk = 0x8
	// Bit EXTINT3.
	EIC_INTENSET_EXTINT3 = 0x8
	// Position of EXTINT4 field.
	EIC_INTENSET_EXTINT4_Pos = 0x4
	// Bit mask of EXTINT4 field.
	EIC_INTENSET_EXTINT4_Msk = 0x10
	// Bit EXTINT4.
	EIC_INTENSET_EXTINT4 = 0x10
	// Position of EXTINT5 field.
	EIC_INTENSET_EXTINT5_Pos = 0x5
	// Bit mask of EXTINT5 field.
	EIC_INTENSET_EXTINT5_Msk = 0x20
	// Bit EXTINT5.
	EIC_INTENSET_EXTINT5 = 0x20
	// Position of EXTINT6 field.
	EIC_INTENSET_EXTINT6_Pos = 0x6
	// Bit mask of EXTINT6 field.
	EIC_INTENSET_EXTINT6_Msk = 0x40
	// Bit EXTINT6.
	EIC_INTENSET_EXTINT6 = 0x40
	// Position of EXTINT7 field.
	EIC_INTENSET_EXTINT7_Pos = 0x7
	// Bit mask of EXTINT7 field.
	EIC_INTENSET_EXTINT7_Msk = 0x80
	// Bit EXTINT7.
	EIC_INTENSET_EXTINT7 = 0x80
	// Position of EXTINT8 field.
	EIC_INTENSET_EXTINT8_Pos = 0x8
	// Bit mask of EXTINT8 field.
	EIC_INTENSET_EXTINT8_Msk = 0x100
	// Bit EXTINT8.
	EIC_INTENSET_EXTINT8 = 0x100
	// Position of EXTINT9 field.
	EIC_INTENSET_EXTINT9_Pos = 0x9
	// Bit mask of EXTINT9 field.
	EIC_INTENSET_EXTINT9_Msk = 0x200
	// Bit EXTINT9.
	EIC_INTENSET_EXTINT9 = 0x200
	// Position of EXTINT10 field.
	EIC_INTENSET_EXTINT10_Pos = 0xa
	// Bit mask of EXTINT10 field.
	EIC_INTENSET_EXTINT10_Msk = 0x400
	// Bit EXTINT10.
	EIC_INTENSET_EXTINT10 = 0x400
	// Position of EXTINT11 field.
	EIC_INTENSET_EXTINT11_Pos = 0xb
	// Bit mask of EXTINT11 field.
	EIC_INTENSET_EXTINT11_Msk = 0x800
	// Bit EXTINT11.
	EIC_INTENSET_EXTINT11 = 0x800
	// Position of EXTINT12 field.
	EIC_INTENSET_EXTINT12_Pos = 0xc
	// Bit mask of EXTINT12 field.
	EIC_INTENSET_EXTINT12_Msk = 0x1000
	// Bit EXTINT12.
	EIC_INTENSET_EXTINT12 = 0x1000
	// Position of EXTINT13 field.
	EIC_INTENSET_EXTINT13_Pos = 0xd
	// Bit mask of EXTINT13 field.
	EIC_INTENSET_EXTINT13_Msk = 0x2000
	// Bit EXTINT13.
	EIC_INTENSET_EXTINT13 = 0x2000
	// Position of EXTINT14 field.
	EIC_INTENSET_EXTINT14_Pos = 0xe
	// Bit mask of EXTINT14 field.
	EIC_INTENSET_EXTINT14_Msk = 0x4000
	// Bit EXTINT14.
	EIC_INTENSET_EXTINT14 = 0x4000
	// Position of EXTINT15 field.
	EIC_INTENSET_EXTINT15_Pos = 0xf
	// Bit mask of EXTINT15 field.
	EIC_INTENSET_EXTINT15_Msk = 0x8000
	// Bit EXTINT15.
	EIC_INTENSET_EXTINT15 = 0x8000

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of EXTINT0 field.
	EIC_INTFLAG_EXTINT0_Pos = 0x0
	// Bit mask of EXTINT0 field.
	EIC_INTFLAG_EXTINT0_Msk = 0x1
	// Bit EXTINT0.
	EIC_INTFLAG_EXTINT0 = 0x1
	// Position of EXTINT1 field.
	EIC_INTFLAG_EXTINT1_Pos = 0x1
	// Bit mask of EXTINT1 field.
	EIC_INTFLAG_EXTINT1_Msk = 0x2
	// Bit EXTINT1.
	EIC_INTFLAG_EXTINT1 = 0x2
	// Position of EXTINT2 field.
	EIC_INTFLAG_EXTINT2_Pos = 0x2
	// Bit mask of EXTINT2 field.
	EIC_INTFLAG_EXTINT2_Msk = 0x4
	// Bit EXTINT2.
	EIC_INTFLAG_EXTINT2 = 0x4
	// Position of EXTINT3 field.
	EIC_INTFLAG_EXTINT3_Pos = 0x3
	// Bit mask of EXTINT3 field.
	EIC_INTFLAG_EXTINT3_Msk = 0x8
	// Bit EXTINT3.
	EIC_INTFLAG_EXTINT3 = 0x8
	// Position of EXTINT4 field.
	EIC_INTFLAG_EXTINT4_Pos = 0x4
	// Bit mask of EXTINT4 field.
	EIC_INTFLAG_EXTINT4_Msk = 0x10
	// Bit EXTINT4.
	EIC_INTFLAG_EXTINT4 = 0x10
	// Position of EXTINT5 field.
	EIC_INTFLAG_EXTINT5_Pos = 0x5
	// Bit mask of EXTINT5 field.
	EIC_INTFLAG_EXTINT5_Msk = 0x20
	// Bit EXTINT5.
	EIC_INTFLAG_EXTINT5 = 0x20
	// Position of EXTINT6 field.
	EIC_INTFLAG_EXTINT6_Pos = 0x6
	// Bit mask of EXTINT6 field.
	EIC_INTFLAG_EXTINT6_Msk = 0x40
	// Bit EXTINT6.
	EIC_INTFLAG_EXTINT6 = 0x40
	// Position of EXTINT7 field.
	EIC_INTFLAG_EXTINT7_Pos = 0x7
	// Bit mask of EXTINT7 field.
	EIC_INTFLAG_EXTINT7_Msk = 0x80
	// Bit EXTINT7.
	EIC_INTFLAG_EXTINT7 = 0x80
	// Position of EXTINT8 field.
	EIC_INTFLAG_EXTINT8_Pos = 0x8
	// Bit mask of EXTINT8 field.
	EIC_INTFLAG_EXTINT8_Msk = 0x100
	// Bit EXTINT8.
	EIC_INTFLAG_EXTINT8 = 0x100
	// Position of EXTINT9 field.
	EIC_INTFLAG_EXTINT9_Pos = 0x9
	// Bit mask of EXTINT9 field.
	EIC_INTFLAG_EXTINT9_Msk = 0x200
	// Bit EXTINT9.
	EIC_INTFLAG_EXTINT9 = 0x200
	// Position of EXTINT10 field.
	EIC_INTFLAG_EXTINT10_Pos = 0xa
	// Bit mask of EXTINT10 field.
	EIC_INTFLAG_EXTINT10_Msk = 0x400
	// Bit EXTINT10.
	EIC_INTFLAG_EXTINT10 = 0x400
	// Position of EXTINT11 field.
	EIC_INTFLAG_EXTINT11_Pos = 0xb
	// Bit mask of EXTINT11 field.
	EIC_INTFLAG_EXTINT11_Msk = 0x800
	// Bit EXTINT11.
	EIC_INTFLAG_EXTINT11 = 0x800
	// Position of EXTINT12 field.
	EIC_INTFLAG_EXTINT12_Pos = 0xc
	// Bit mask of EXTINT12 field.
	EIC_INTFLAG_EXTINT12_Msk = 0x1000
	// Bit EXTINT12.
	EIC_INTFLAG_EXTINT12 = 0x1000
	// Position of EXTINT13 field.
	EIC_INTFLAG_EXTINT13_Pos = 0xd
	// Bit mask of EXTINT13 field.
	EIC_INTFLAG_EXTINT13_Msk = 0x2000
	// Bit EXTINT13.
	EIC_INTFLAG_EXTINT13 = 0x2000
	// Position of EXTINT14 field.
	EIC_INTFLAG_EXTINT14_Pos = 0xe
	// Bit mask of EXTINT14 field.
	EIC_INTFLAG_EXTINT14_Msk = 0x4000
	// Bit EXTINT14.
	EIC_INTFLAG_EXTINT14 = 0x4000
	// Position of EXTINT15 field.
	EIC_INTFLAG_EXTINT15_Pos = 0xf
	// Bit mask of EXTINT15 field.
	EIC_INTFLAG_EXTINT15_Msk = 0x8000
	// Bit EXTINT15.
	EIC_INTFLAG_EXTINT15 = 0x8000

	// WAKEUP: Wake-Up Enable
	// Position of WAKEUPEN0 field.
	EIC_WAKEUP_WAKEUPEN0_Pos = 0x0
	// Bit mask of WAKEUPEN0 field.
	EIC_WAKEUP_WAKEUPEN0_Msk = 0x1
	// Bit WAKEUPEN0.
	EIC_WAKEUP_WAKEUPEN0 = 0x1
	// Position of WAKEUPEN1 field.
	EIC_WAKEUP_WAKEUPEN1_Pos = 0x1
	// Bit mask of WAKEUPEN1 field.
	EIC_WAKEUP_WAKEUPEN1_Msk = 0x2
	// Bit WAKEUPEN1.
	EIC_WAKEUP_WAKEUPEN1 = 0x2
	// Position of WAKEUPEN2 field.
	EIC_WAKEUP_WAKEUPEN2_Pos = 0x2
	// Bit mask of WAKEUPEN2 field.
	EIC_WAKEUP_WAKEUPEN2_Msk = 0x4
	// Bit WAKEUPEN2.
	EIC_WAKEUP_WAKEUPEN2 = 0x4
	// Position of WAKEUPEN3 field.
	EIC_WAKEUP_WAKEUPEN3_Pos = 0x3
	// Bit mask of WAKEUPEN3 field.
	EIC_WAKEUP_WAKEUPEN3_Msk = 0x8
	// Bit WAKEUPEN3.
	EIC_WAKEUP_WAKEUPEN3 = 0x8
	// Position of WAKEUPEN4 field.
	EIC_WAKEUP_WAKEUPEN4_Pos = 0x4
	// Bit mask of WAKEUPEN4 field.
	EIC_WAKEUP_WAKEUPEN4_Msk = 0x10
	// Bit WAKEUPEN4.
	EIC_WAKEUP_WAKEUPEN4 = 0x10
	// Position of WAKEUPEN5 field.
	EIC_WAKEUP_WAKEUPEN5_Pos = 0x5
	// Bit mask of WAKEUPEN5 field.
	EIC_WAKEUP_WAKEUPEN5_Msk = 0x20
	// Bit WAKEUPEN5.
	EIC_WAKEUP_WAKEUPEN5 = 0x20
	// Position of WAKEUPEN6 field.
	EIC_WAKEUP_WAKEUPEN6_Pos = 0x6
	// Bit mask of WAKEUPEN6 field.
	EIC_WAKEUP_WAKEUPEN6_Msk = 0x40
	// Bit WAKEUPEN6.
	EIC_WAKEUP_WAKEUPEN6 = 0x40
	// Position of WAKEUPEN7 field.
	EIC_WAKEUP_WAKEUPEN7_Pos = 0x7
	// Bit mask of WAKEUPEN7 field.
	EIC_WAKEUP_WAKEUPEN7_Msk = 0x80
	// Bit WAKEUPEN7.
	EIC_WAKEUP_WAKEUPEN7 = 0x80
	// Position of WAKEUPEN8 field.
	EIC_WAKEUP_WAKEUPEN8_Pos = 0x8
	// Bit mask of WAKEUPEN8 field.
	EIC_WAKEUP_WAKEUPEN8_Msk = 0x100
	// Bit WAKEUPEN8.
	EIC_WAKEUP_WAKEUPEN8 = 0x100
	// Position of WAKEUPEN9 field.
	EIC_WAKEUP_WAKEUPEN9_Pos = 0x9
	// Bit mask of WAKEUPEN9 field.
	EIC_WAKEUP_WAKEUPEN9_Msk = 0x200
	// Bit WAKEUPEN9.
	EIC_WAKEUP_WAKEUPEN9 = 0x200
	// Position of WAKEUPEN10 field.
	EIC_WAKEUP_WAKEUPEN10_Pos = 0xa
	// Bit mask of WAKEUPEN10 field.
	EIC_WAKEUP_WAKEUPEN10_Msk = 0x400
	// Bit WAKEUPEN10.
	EIC_WAKEUP_WAKEUPEN10 = 0x400
	// Position of WAKEUPEN11 field.
	EIC_WAKEUP_WAKEUPEN11_Pos = 0xb
	// Bit mask of WAKEUPEN11 field.
	EIC_WAKEUP_WAKEUPEN11_Msk = 0x800
	// Bit WAKEUPEN11.
	EIC_WAKEUP_WAKEUPEN11 = 0x800
	// Position of WAKEUPEN12 field.
	EIC_WAKEUP_WAKEUPEN12_Pos = 0xc
	// Bit mask of WAKEUPEN12 field.
	EIC_WAKEUP_WAKEUPEN12_Msk = 0x1000
	// Bit WAKEUPEN12.
	EIC_WAKEUP_WAKEUPEN12 = 0x1000
	// Position of WAKEUPEN13 field.
	EIC_WAKEUP_WAKEUPEN13_Pos = 0xd
	// Bit mask of WAKEUPEN13 field.
	EIC_WAKEUP_WAKEUPEN13_Msk = 0x2000
	// Bit WAKEUPEN13.
	EIC_WAKEUP_WAKEUPEN13 = 0x2000
	// Position of WAKEUPEN14 field.
	EIC_WAKEUP_WAKEUPEN14_Pos = 0xe
	// Bit mask of WAKEUPEN14 field.
	EIC_WAKEUP_WAKEUPEN14_Msk = 0x4000
	// Bit WAKEUPEN14.
	EIC_WAKEUP_WAKEUPEN14 = 0x4000
	// Position of WAKEUPEN15 field.
	EIC_WAKEUP_WAKEUPEN15_Pos = 0xf
	// Bit mask of WAKEUPEN15 field.
	EIC_WAKEUP_WAKEUPEN15_Msk = 0x8000
	// Bit WAKEUPEN15.
	EIC_WAKEUP_WAKEUPEN15 = 0x8000

	// CONFIG0: Configuration n
	// Position of SENSE0 field.
	EIC_CONFIG_SENSE0_Pos = 0x0
	// Bit mask of SENSE0 field.
	EIC_CONFIG_SENSE0_Msk = 0x7
	// No detection
	EIC_CONFIG_SENSE0_NONE = 0x0
	// Rising-edge detection
	EIC_CONFIG_SENSE0_RISE = 0x1
	// Falling-edge detection
	EIC_CONFIG_SENSE0_FALL = 0x2
	// Both-edges detection
	EIC_CONFIG_SENSE0_BOTH = 0x3
	// High-level detection
	EIC_CONFIG_SENSE0_HIGH = 0x4
	// Low-level detection
	EIC_CONFIG_SENSE0_LOW = 0x5
	// Position of FILTEN0 field.
	EIC_CONFIG_FILTEN0_Pos = 0x3
	// Bit mask of FILTEN0 field.
	EIC_CONFIG_FILTEN0_Msk = 0x8
	// Bit FILTEN0.
	EIC_CONFIG_FILTEN0 = 0x8
	// Position of SENSE1 field.
	EIC_CONFIG_SENSE1_Pos = 0x4
	// Bit mask of SENSE1 field.
	EIC_CONFIG_SENSE1_Msk = 0x70
	// No detection
	EIC_CONFIG_SENSE1_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE1_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE1_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE1_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE1_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE1_LOW = 0x5
	// Position of FILTEN1 field.
	EIC_CONFIG_FILTEN1_Pos = 0x7
	// Bit mask of FILTEN1 field.
	EIC_CONFIG_FILTEN1_Msk = 0x80
	// Bit FILTEN1.
	EIC_CONFIG_FILTEN1 = 0x80
	// Position of SENSE2 field.
	EIC_CONFIG_SENSE2_Pos = 0x8
	// Bit mask of SENSE2 field.
	EIC_CONFIG_SENSE2_Msk = 0x700
	// No detection
	EIC_CONFIG_SENSE2_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE2_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE2_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE2_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE2_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE2_LOW = 0x5
	// Position of FILTEN2 field.
	EIC_CONFIG_FILTEN2_Pos = 0xb
	// Bit mask of FILTEN2 field.
	EIC_CONFIG_FILTEN2_Msk = 0x800
	// Bit FILTEN2.
	EIC_CONFIG_FILTEN2 = 0x800
	// Position of SENSE3 field.
	EIC_CONFIG_SENSE3_Pos = 0xc
	// Bit mask of SENSE3 field.
	EIC_CONFIG_SENSE3_Msk = 0x7000
	// No detection
	EIC_CONFIG_SENSE3_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE3_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE3_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE3_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE3_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE3_LOW = 0x5
	// Position of FILTEN3 field.
	EIC_CONFIG_FILTEN3_Pos = 0xf
	// Bit mask of FILTEN3 field.
	EIC_CONFIG_FILTEN3_Msk = 0x8000
	// Bit FILTEN3.
	EIC_CONFIG_FILTEN3 = 0x8000
	// Position of SENSE4 field.
	EIC_CONFIG_SENSE4_Pos = 0x10
	// Bit mask of SENSE4 field.
	EIC_CONFIG_SENSE4_Msk = 0x70000
	// No detection
	EIC_CONFIG_SENSE4_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE4_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE4_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE4_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE4_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE4_LOW = 0x5
	// Position of FILTEN4 field.
	EIC_CONFIG_FILTEN4_Pos = 0x13
	// Bit mask of FILTEN4 field.
	EIC_CONFIG_FILTEN4_Msk = 0x80000
	// Bit FILTEN4.
	EIC_CONFIG_FILTEN4 = 0x80000
	// Position of SENSE5 field.
	EIC_CONFIG_SENSE5_Pos = 0x14
	// Bit mask of SENSE5 field.
	EIC_CONFIG_SENSE5_Msk = 0x700000
	// No detection
	EIC_CONFIG_SENSE5_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE5_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE5_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE5_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE5_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE5_LOW = 0x5
	// Position of FILTEN5 field.
	EIC_CONFIG_FILTEN5_Pos = 0x17
	// Bit mask of FILTEN5 field.
	EIC_CONFIG_FILTEN5_Msk = 0x800000
	// Bit FILTEN5.
	EIC_CONFIG_FILTEN5 = 0x800000
	// Position of SENSE6 field.
	EIC_CONFIG_SENSE6_Pos = 0x18
	// Bit mask of SENSE6 field.
	EIC_CONFIG_SENSE6_Msk = 0x7000000
	// No detection
	EIC_CONFIG_SENSE6_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE6_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE6_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE6_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE6_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE6_LOW = 0x5
	// Position of FILTEN6 field.
	EIC_CONFIG_FILTEN6_Pos = 0x1b
	// Bit mask of FILTEN6 field.
	EIC_CONFIG_FILTEN6_Msk = 0x8000000
	// Bit FILTEN6.
	EIC_CONFIG_FILTEN6 = 0x8000000
	// Position of SENSE7 field.
	EIC_CONFIG_SENSE7_Pos = 0x1c
	// Bit mask of SENSE7 field.
	EIC_CONFIG_SENSE7_Msk = 0x70000000
	// No detection
	EIC_CONFIG_SENSE7_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE7_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE7_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE7_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE7_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE7_LOW = 0x5
	// Position of FILTEN7 field.
	EIC_CONFIG_FILTEN7_Pos = 0x1f
	// Bit mask of FILTEN7 field.
	EIC_CONFIG_FILTEN7_Msk = 0x80000000
	// Bit FILTEN7.
	EIC_CONFIG_FILTEN7 = 0x80000000
)

// Constants for EVSYS: Event System Interface
const (
	// CTRL: Control
	// Position of SWRST field.
	EVSYS_CTRL_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	EVSYS_CTRL_SWRST_Msk = 0x1
	// Bit SWRST.
	EVSYS_CTRL_SWRST = 0x1
	// Position of GCLKREQ field.
	EVSYS_CTRL_GCLKREQ_Pos = 0x4
	// Bit mask of GCLKREQ field.
	EVSYS_CTRL_GCLKREQ_Msk = 0x10
	// Bit GCLKREQ.
	EVSYS_CTRL_GCLKREQ = 0x10

	// CHANNEL: Channel
	// Position of CHANNEL field.
	EVSYS_CHANNEL_CHANNEL_Pos = 0x0
	// Bit mask of CHANNEL field.
	EVSYS_CHANNEL_CHANNEL_Msk = 0xf
	// Position of SWEVT field.
	EVSYS_CHANNEL_SWEVT_Pos = 0x8
	// Bit mask of SWEVT field.
	EVSYS_CHANNEL_SWEVT_Msk = 0x100
	// Bit SWEVT.
	EVSYS_CHANNEL_SWEVT = 0x100
	// Position of EVGEN field.
	EVSYS_CHANNEL_EVGEN_Pos = 0x10
	// Bit mask of EVGEN field.
	EVSYS_CHANNEL_EVGEN_Msk = 0x7f0000
	// Position of PATH field.
	EVSYS_CHANNEL_PATH_Pos = 0x18
	// Bit mask of PATH field.
	EVSYS_CHANNEL_PATH_Msk = 0x3000000
	// Synchronous path
	EVSYS_CHANNEL_PATH_SYNCHRONOUS = 0x0
	// Resynchronized path
	EVSYS_CHANNEL_PATH_RESYNCHRONIZED = 0x1
	// Asynchronous path
	EVSYS_CHANNEL_PATH_ASYNCHRONOUS = 0x2
	// Position of EDGSEL field.
	EVSYS_CHANNEL_EDGSEL_Pos = 0x1a
	// Bit mask of EDGSEL field.
	EVSYS_CHANNEL_EDGSEL_Msk = 0xc000000
	// No event output when using the resynchronized or synchronous path
	EVSYS_CHANNEL_EDGSEL_NO_EVT_OUTPUT = 0x0
	// Event detection only on the rising edge of the signal from the event generator when using the resynchronized or synchronous path
	EVSYS_CHANNEL_EDGSEL_RISING_EDGE = 0x1
	// Event detection only on the falling edge of the signal from the event generator when using the resynchronized or synchronous path
	EVSYS_CHANNEL_EDGSEL_FALLING_EDGE = 0x2
	// Event detection on rising and falling edges of the signal from the event generator when using the resynchronized or synchronous path
	EVSYS_CHANNEL_EDGSEL_BOTH_EDGES = 0x3

	// USER: User Multiplexer
	// Position of USER field.
	EVSYS_USER_USER_Pos = 0x0
	// Bit mask of USER field.
	EVSYS_USER_USER_Msk = 0x1f
	// Position of CHANNEL field.
	EVSYS_USER_CHANNEL_Pos = 0x8
	// Bit mask of CHANNEL field.
	EVSYS_USER_CHANNEL_Msk = 0x1f00
	// No Channel Output Selected
	EVSYS_USER_CHANNEL_0 = 0x0

	// CHSTATUS: Channel Status
	// Position of USRRDY0 field.
	EVSYS_CHSTATUS_USRRDY0_Pos = 0x0
	// Bit mask of USRRDY0 field.
	EVSYS_CHSTATUS_USRRDY0_Msk = 0x1
	// Bit USRRDY0.
	EVSYS_CHSTATUS_USRRDY0 = 0x1
	// Position of USRRDY1 field.
	EVSYS_CHSTATUS_USRRDY1_Pos = 0x1
	// Bit mask of USRRDY1 field.
	EVSYS_CHSTATUS_USRRDY1_Msk = 0x2
	// Bit USRRDY1.
	EVSYS_CHSTATUS_USRRDY1 = 0x2
	// Position of USRRDY2 field.
	EVSYS_CHSTATUS_USRRDY2_Pos = 0x2
	// Bit mask of USRRDY2 field.
	EVSYS_CHSTATUS_USRRDY2_Msk = 0x4
	// Bit USRRDY2.
	EVSYS_CHSTATUS_USRRDY2 = 0x4
	// Position of USRRDY3 field.
	EVSYS_CHSTATUS_USRRDY3_Pos = 0x3
	// Bit mask of USRRDY3 field.
	EVSYS_CHSTATUS_USRRDY3_Msk = 0x8
	// Bit USRRDY3.
	EVSYS_CHSTATUS_USRRDY3 = 0x8
	// Position of USRRDY4 field.
	EVSYS_CHSTATUS_USRRDY4_Pos = 0x4
	// Bit mask of USRRDY4 field.
	EVSYS_CHSTATUS_USRRDY4_Msk = 0x10
	// Bit USRRDY4.
	EVSYS_CHSTATUS_USRRDY4 = 0x10
	// Position of USRRDY5 field.
	EVSYS_CHSTATUS_USRRDY5_Pos = 0x5
	// Bit mask of USRRDY5 field.
	EVSYS_CHSTATUS_USRRDY5_Msk = 0x20
	// Bit USRRDY5.
	EVSYS_CHSTATUS_USRRDY5 = 0x20
	// Position of USRRDY6 field.
	EVSYS_CHSTATUS_USRRDY6_Pos = 0x6
	// Bit mask of USRRDY6 field.
	EVSYS_CHSTATUS_USRRDY6_Msk = 0x40
	// Bit USRRDY6.
	EVSYS_CHSTATUS_USRRDY6 = 0x40
	// Position of USRRDY7 field.
	EVSYS_CHSTATUS_USRRDY7_Pos = 0x7
	// Bit mask of USRRDY7 field.
	EVSYS_CHSTATUS_USRRDY7_Msk = 0x80
	// Bit USRRDY7.
	EVSYS_CHSTATUS_USRRDY7 = 0x80
	// Position of CHBUSY0 field.
	EVSYS_CHSTATUS_CHBUSY0_Pos = 0x8
	// Bit mask of CHBUSY0 field.
	EVSYS_CHSTATUS_CHBUSY0_Msk = 0x100
	// Bit CHBUSY0.
	EVSYS_CHSTATUS_CHBUSY0 = 0x100
	// Position of CHBUSY1 field.
	EVSYS_CHSTATUS_CHBUSY1_Pos = 0x9
	// Bit mask of CHBUSY1 field.
	EVSYS_CHSTATUS_CHBUSY1_Msk = 0x200
	// Bit CHBUSY1.
	EVSYS_CHSTATUS_CHBUSY1 = 0x200
	// Position of CHBUSY2 field.
	EVSYS_CHSTATUS_CHBUSY2_Pos = 0xa
	// Bit mask of CHBUSY2 field.
	EVSYS_CHSTATUS_CHBUSY2_Msk = 0x400
	// Bit CHBUSY2.
	EVSYS_CHSTATUS_CHBUSY2 = 0x400
	// Position of CHBUSY3 field.
	EVSYS_CHSTATUS_CHBUSY3_Pos = 0xb
	// Bit mask of CHBUSY3 field.
	EVSYS_CHSTATUS_CHBUSY3_Msk = 0x800
	// Bit CHBUSY3.
	EVSYS_CHSTATUS_CHBUSY3 = 0x800
	// Position of CHBUSY4 field.
	EVSYS_CHSTATUS_CHBUSY4_Pos = 0xc
	// Bit mask of CHBUSY4 field.
	EVSYS_CHSTATUS_CHBUSY4_Msk = 0x1000
	// Bit CHBUSY4.
	EVSYS_CHSTATUS_CHBUSY4 = 0x1000
	// Position of CHBUSY5 field.
	EVSYS_CHSTATUS_CHBUSY5_Pos = 0xd
	// Bit mask of CHBUSY5 field.
	EVSYS_CHSTATUS_CHBUSY5_Msk = 0x2000
	// Bit CHBUSY5.
	EVSYS_CHSTATUS_CHBUSY5 = 0x2000
	// Position of CHBUSY6 field.
	EVSYS_CHSTATUS_CHBUSY6_Pos = 0xe
	// Bit mask of CHBUSY6 field.
	EVSYS_CHSTATUS_CHBUSY6_Msk = 0x4000
	// Bit CHBUSY6.
	EVSYS_CHSTATUS_CHBUSY6 = 0x4000
	// Position of CHBUSY7 field.
	EVSYS_CHSTATUS_CHBUSY7_Pos = 0xf
	// Bit mask of CHBUSY7 field.
	EVSYS_CHSTATUS_CHBUSY7_Msk = 0x8000
	// Bit CHBUSY7.
	EVSYS_CHSTATUS_CHBUSY7 = 0x8000
	// Position of USRRDY8 field.
	EVSYS_CHSTATUS_USRRDY8_Pos = 0x10
	// Bit mask of USRRDY8 field.
	EVSYS_CHSTATUS_USRRDY8_Msk = 0x10000
	// Bit USRRDY8.
	EVSYS_CHSTATUS_USRRDY8 = 0x10000
	// Position of USRRDY9 field.
	EVSYS_CHSTATUS_USRRDY9_Pos = 0x11
	// Bit mask of USRRDY9 field.
	EVSYS_CHSTATUS_USRRDY9_Msk = 0x20000
	// Bit USRRDY9.
	EVSYS_CHSTATUS_USRRDY9 = 0x20000
	// Position of USRRDY10 field.
	EVSYS_CHSTATUS_USRRDY10_Pos = 0x12
	// Bit mask of USRRDY10 field.
	EVSYS_CHSTATUS_USRRDY10_Msk = 0x40000
	// Bit USRRDY10.
	EVSYS_CHSTATUS_USRRDY10 = 0x40000
	// Position of USRRDY11 field.
	EVSYS_CHSTATUS_USRRDY11_Pos = 0x13
	// Bit mask of USRRDY11 field.
	EVSYS_CHSTATUS_USRRDY11_Msk = 0x80000
	// Bit USRRDY11.
	EVSYS_CHSTATUS_USRRDY11 = 0x80000
	// Position of CHBUSY8 field.
	EVSYS_CHSTATUS_CHBUSY8_Pos = 0x18
	// Bit mask of CHBUSY8 field.
	EVSYS_CHSTATUS_CHBUSY8_Msk = 0x1000000
	// Bit CHBUSY8.
	EVSYS_CHSTATUS_CHBUSY8 = 0x1000000
	// Position of CHBUSY9 field.
	EVSYS_CHSTATUS_CHBUSY9_Pos = 0x19
	// Bit mask of CHBUSY9 field.
	EVSYS_CHSTATUS_CHBUSY9_Msk = 0x2000000
	// Bit CHBUSY9.
	EVSYS_CHSTATUS_CHBUSY9 = 0x2000000
	// Position of CHBUSY10 field.
	EVSYS_CHSTATUS_CHBUSY10_Pos = 0x1a
	// Bit mask of CHBUSY10 field.
	EVSYS_CHSTATUS_CHBUSY10_Msk = 0x4000000
	// Bit CHBUSY10.
	EVSYS_CHSTATUS_CHBUSY10 = 0x4000000
	// Position of CHBUSY11 field.
	EVSYS_CHSTATUS_CHBUSY11_Pos = 0x1b
	// Bit mask of CHBUSY11 field.
	EVSYS_CHSTATUS_CHBUSY11_Msk = 0x8000000
	// Bit CHBUSY11.
	EVSYS_CHSTATUS_CHBUSY11 = 0x8000000

	// INTENCLR: Interrupt Enable Clear
	// Position of OVR0 field.
	EVSYS_INTENCLR_OVR0_Pos = 0x0
	// Bit mask of OVR0 field.
	EVSYS_INTENCLR_OVR0_Msk = 0x1
	// Bit OVR0.
	EVSYS_INTENCLR_OVR0 = 0x1
	// Position of OVR1 field.
	EVSYS_INTENCLR_OVR1_Pos = 0x1
	// Bit mask of OVR1 field.
	EVSYS_INTENCLR_OVR1_Msk = 0x2
	// Bit OVR1.
	EVSYS_INTENCLR_OVR1 = 0x2
	// Position of OVR2 field.
	EVSYS_INTENCLR_OVR2_Pos = 0x2
	// Bit mask of OVR2 field.
	EVSYS_INTENCLR_OVR2_Msk = 0x4
	// Bit OVR2.
	EVSYS_INTENCLR_OVR2 = 0x4
	// Position of OVR3 field.
	EVSYS_INTENCLR_OVR3_Pos = 0x3
	// Bit mask of OVR3 field.
	EVSYS_INTENCLR_OVR3_Msk = 0x8
	// Bit OVR3.
	EVSYS_INTENCLR_OVR3 = 0x8
	// Position of OVR4 field.
	EVSYS_INTENCLR_OVR4_Pos = 0x4
	// Bit mask of OVR4 field.
	EVSYS_INTENCLR_OVR4_Msk = 0x10
	// Bit OVR4.
	EVSYS_INTENCLR_OVR4 = 0x10
	// Position of OVR5 field.
	EVSYS_INTENCLR_OVR5_Pos = 0x5
	// Bit mask of OVR5 field.
	EVSYS_INTENCLR_OVR5_Msk = 0x20
	// Bit OVR5.
	EVSYS_INTENCLR_OVR5 = 0x20
	// Position of OVR6 field.
	EVSYS_INTENCLR_OVR6_Pos = 0x6
	// Bit mask of OVR6 field.
	EVSYS_INTENCLR_OVR6_Msk = 0x40
	// Bit OVR6.
	EVSYS_INTENCLR_OVR6 = 0x40
	// Position of OVR7 field.
	EVSYS_INTENCLR_OVR7_Pos = 0x7
	// Bit mask of OVR7 field.
	EVSYS_INTENCLR_OVR7_Msk = 0x80
	// Bit OVR7.
	EVSYS_INTENCLR_OVR7 = 0x80
	// Position of EVD0 field.
	EVSYS_INTENCLR_EVD0_Pos = 0x8
	// Bit mask of EVD0 field.
	EVSYS_INTENCLR_EVD0_Msk = 0x100
	// Bit EVD0.
	EVSYS_INTENCLR_EVD0 = 0x100
	// Position of EVD1 field.
	EVSYS_INTENCLR_EVD1_Pos = 0x9
	// Bit mask of EVD1 field.
	EVSYS_INTENCLR_EVD1_Msk = 0x200
	// Bit EVD1.
	EVSYS_INTENCLR_EVD1 = 0x200
	// Position of EVD2 field.
	EVSYS_INTENCLR_EVD2_Pos = 0xa
	// Bit mask of EVD2 field.
	EVSYS_INTENCLR_EVD2_Msk = 0x400
	// Bit EVD2.
	EVSYS_INTENCLR_EVD2 = 0x400
	// Position of EVD3 field.
	EVSYS_INTENCLR_EVD3_Pos = 0xb
	// Bit mask of EVD3 field.
	EVSYS_INTENCLR_EVD3_Msk = 0x800
	// Bit EVD3.
	EVSYS_INTENCLR_EVD3 = 0x800
	// Position of EVD4 field.
	EVSYS_INTENCLR_EVD4_Pos = 0xc
	// Bit mask of EVD4 field.
	EVSYS_INTENCLR_EVD4_Msk = 0x1000
	// Bit EVD4.
	EVSYS_INTENCLR_EVD4 = 0x1000
	// Position of EVD5 field.
	EVSYS_INTENCLR_EVD5_Pos = 0xd
	// Bit mask of EVD5 field.
	EVSYS_INTENCLR_EVD5_Msk = 0x2000
	// Bit EVD5.
	EVSYS_INTENCLR_EVD5 = 0x2000
	// Position of EVD6 field.
	EVSYS_INTENCLR_EVD6_Pos = 0xe
	// Bit mask of EVD6 field.
	EVSYS_INTENCLR_EVD6_Msk = 0x4000
	// Bit EVD6.
	EVSYS_INTENCLR_EVD6 = 0x4000
	// Position of EVD7 field.
	EVSYS_INTENCLR_EVD7_Pos = 0xf
	// Bit mask of EVD7 field.
	EVSYS_INTENCLR_EVD7_Msk = 0x8000
	// Bit EVD7.
	EVSYS_INTENCLR_EVD7 = 0x8000
	// Position of OVR8 field.
	EVSYS_INTENCLR_OVR8_Pos = 0x10
	// Bit mask of OVR8 field.
	EVSYS_INTENCLR_OVR8_Msk = 0x10000
	// Bit OVR8.
	EVSYS_INTENCLR_OVR8 = 0x10000
	// Position of OVR9 field.
	EVSYS_INTENCLR_OVR9_Pos = 0x11
	// Bit mask of OVR9 field.
	EVSYS_INTENCLR_OVR9_Msk = 0x20000
	// Bit OVR9.
	EVSYS_INTENCLR_OVR9 = 0x20000
	// Position of OVR10 field.
	EVSYS_INTENCLR_OVR10_Pos = 0x12
	// Bit mask of OVR10 field.
	EVSYS_INTENCLR_OVR10_Msk = 0x40000
	// Bit OVR10.
	EVSYS_INTENCLR_OVR10 = 0x40000
	// Position of OVR11 field.
	EVSYS_INTENCLR_OVR11_Pos = 0x13
	// Bit mask of OVR11 field.
	EVSYS_INTENCLR_OVR11_Msk = 0x80000
	// Bit OVR11.
	EVSYS_INTENCLR_OVR11 = 0x80000
	// Position of EVD8 field.
	EVSYS_INTENCLR_EVD8_Pos = 0x18
	// Bit mask of EVD8 field.
	EVSYS_INTENCLR_EVD8_Msk = 0x1000000
	// Bit EVD8.
	EVSYS_INTENCLR_EVD8 = 0x1000000
	// Position of EVD9 field.
	EVSYS_INTENCLR_EVD9_Pos = 0x19
	// Bit mask of EVD9 field.
	EVSYS_INTENCLR_EVD9_Msk = 0x2000000
	// Bit EVD9.
	EVSYS_INTENCLR_EVD9 = 0x2000000
	// Position of EVD10 field.
	EVSYS_INTENCLR_EVD10_Pos = 0x1a
	// Bit mask of EVD10 field.
	EVSYS_INTENCLR_EVD10_Msk = 0x4000000
	// Bit EVD10.
	EVSYS_INTENCLR_EVD10 = 0x4000000
	// Position of EVD11 field.
	EVSYS_INTENCLR_EVD11_Pos = 0x1b
	// Bit mask of EVD11 field.
	EVSYS_INTENCLR_EVD11_Msk = 0x8000000
	// Bit EVD11.
	EVSYS_INTENCLR_EVD11 = 0x8000000

	// INTENSET: Interrupt Enable Set
	// Position of OVR0 field.
	EVSYS_INTENSET_OVR0_Pos = 0x0
	// Bit mask of OVR0 field.
	EVSYS_INTENSET_OVR0_Msk = 0x1
	// Bit OVR0.
	EVSYS_INTENSET_OVR0 = 0x1
	// Position of OVR1 field.
	EVSYS_INTENSET_OVR1_Pos = 0x1
	// Bit mask of OVR1 field.
	EVSYS_INTENSET_OVR1_Msk = 0x2
	// Bit OVR1.
	EVSYS_INTENSET_OVR1 = 0x2
	// Position of OVR2 field.
	EVSYS_INTENSET_OVR2_Pos = 0x2
	// Bit mask of OVR2 field.
	EVSYS_INTENSET_OVR2_Msk = 0x4
	// Bit OVR2.
	EVSYS_INTENSET_OVR2 = 0x4
	// Position of OVR3 field.
	EVSYS_INTENSET_OVR3_Pos = 0x3
	// Bit mask of OVR3 field.
	EVSYS_INTENSET_OVR3_Msk = 0x8
	// Bit OVR3.
	EVSYS_INTENSET_OVR3 = 0x8
	// Position of OVR4 field.
	EVSYS_INTENSET_OVR4_Pos = 0x4
	// Bit mask of OVR4 field.
	EVSYS_INTENSET_OVR4_Msk = 0x10
	// Bit OVR4.
	EVSYS_INTENSET_OVR4 = 0x10
	// Position of OVR5 field.
	EVSYS_INTENSET_OVR5_Pos = 0x5
	// Bit mask of OVR5 field.
	EVSYS_INTENSET_OVR5_Msk = 0x20
	// Bit OVR5.
	EVSYS_INTENSET_OVR5 = 0x20
	// Position of OVR6 field.
	EVSYS_INTENSET_OVR6_Pos = 0x6
	// Bit mask of OVR6 field.
	EVSYS_INTENSET_OVR6_Msk = 0x40
	// Bit OVR6.
	EVSYS_INTENSET_OVR6 = 0x40
	// Position of OVR7 field.
	EVSYS_INTENSET_OVR7_Pos = 0x7
	// Bit mask of OVR7 field.
	EVSYS_INTENSET_OVR7_Msk = 0x80
	// Bit OVR7.
	EVSYS_INTENSET_OVR7 = 0x80
	// Position of EVD0 field.
	EVSYS_INTENSET_EVD0_Pos = 0x8
	// Bit mask of EVD0 field.
	EVSYS_INTENSET_EVD0_Msk = 0x100
	// Bit EVD0.
	EVSYS_INTENSET_EVD0 = 0x100
	// Position of EVD1 field.
	EVSYS_INTENSET_EVD1_Pos = 0x9
	// Bit mask of EVD1 field.
	EVSYS_INTENSET_EVD1_Msk = 0x200
	// Bit EVD1.
	EVSYS_INTENSET_EVD1 = 0x200
	// Position of EVD2 field.
	EVSYS_INTENSET_EVD2_Pos = 0xa
	// Bit mask of EVD2 field.
	EVSYS_INTENSET_EVD2_Msk = 0x400
	// Bit EVD2.
	EVSYS_INTENSET_EVD2 = 0x400
	// Position of EVD3 field.
	EVSYS_INTENSET_EVD3_Pos = 0xb
	// Bit mask of EVD3 field.
	EVSYS_INTENSET_EVD3_Msk = 0x800
	// Bit EVD3.
	EVSYS_INTENSET_EVD3 = 0x800
	// Position of EVD4 field.
	EVSYS_INTENSET_EVD4_Pos = 0xc
	// Bit mask of EVD4 field.
	EVSYS_INTENSET_EVD4_Msk = 0x1000
	// Bit EVD4.
	EVSYS_INTENSET_EVD4 = 0x1000
	// Position of EVD5 field.
	EVSYS_INTENSET_EVD5_Pos = 0xd
	// Bit mask of EVD5 field.
	EVSYS_INTENSET_EVD5_Msk = 0x2000
	// Bit EVD5.
	EVSYS_INTENSET_EVD5 = 0x2000
	// Position of EVD6 field.
	EVSYS_INTENSET_EVD6_Pos = 0xe
	// Bit mask of EVD6 field.
	EVSYS_INTENSET_EVD6_Msk = 0x4000
	// Bit EVD6.
	EVSYS_INTENSET_EVD6 = 0x4000
	// Position of EVD7 field.
	EVSYS_INTENSET_EVD7_Pos = 0xf
	// Bit mask of EVD7 field.
	EVSYS_INTENSET_EVD7_Msk = 0x8000
	// Bit EVD7.
	EVSYS_INTENSET_EVD7 = 0x8000
	// Position of OVR8 field.
	EVSYS_INTENSET_OVR8_Pos = 0x10
	// Bit mask of OVR8 field.
	EVSYS_INTENSET_OVR8_Msk = 0x10000
	// Bit OVR8.
	EVSYS_INTENSET_OVR8 = 0x10000
	// Position of OVR9 field.
	EVSYS_INTENSET_OVR9_Pos = 0x11
	// Bit mask of OVR9 field.
	EVSYS_INTENSET_OVR9_Msk = 0x20000
	// Bit OVR9.
	EVSYS_INTENSET_OVR9 = 0x20000
	// Position of OVR10 field.
	EVSYS_INTENSET_OVR10_Pos = 0x12
	// Bit mask of OVR10 field.
	EVSYS_INTENSET_OVR10_Msk = 0x40000
	// Bit OVR10.
	EVSYS_INTENSET_OVR10 = 0x40000
	// Position of OVR11 field.
	EVSYS_INTENSET_OVR11_Pos = 0x13
	// Bit mask of OVR11 field.
	EVSYS_INTENSET_OVR11_Msk = 0x80000
	// Bit OVR11.
	EVSYS_INTENSET_OVR11 = 0x80000
	// Position of EVD8 field.
	EVSYS_INTENSET_EVD8_Pos = 0x18
	// Bit mask of EVD8 field.
	EVSYS_INTENSET_EVD8_Msk = 0x1000000
	// Bit EVD8.
	EVSYS_INTENSET_EVD8 = 0x1000000
	// Position of EVD9 field.
	EVSYS_INTENSET_EVD9_Pos = 0x19
	// Bit mask of EVD9 field.
	EVSYS_INTENSET_EVD9_Msk = 0x2000000
	// Bit EVD9.
	EVSYS_INTENSET_EVD9 = 0x2000000
	// Position of EVD10 field.
	EVSYS_INTENSET_EVD10_Pos = 0x1a
	// Bit mask of EVD10 field.
	EVSYS_INTENSET_EVD10_Msk = 0x4000000
	// Bit EVD10.
	EVSYS_INTENSET_EVD10 = 0x4000000
	// Position of EVD11 field.
	EVSYS_INTENSET_EVD11_Pos = 0x1b
	// Bit mask of EVD11 field.
	EVSYS_INTENSET_EVD11_Msk = 0x8000000
	// Bit EVD11.
	EVSYS_INTENSET_EVD11 = 0x8000000

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of OVR0 field.
	EVSYS_INTFLAG_OVR0_Pos = 0x0
	// Bit mask of OVR0 field.
	EVSYS_INTFLAG_OVR0_Msk = 0x1
	// Bit OVR0.
	EVSYS_INTFLAG_OVR0 = 0x1
	// Position of OVR1 field.
	EVSYS_INTFLAG_OVR1_Pos = 0x1
	// Bit mask of OVR1 field.
	EVSYS_INTFLAG_OVR1_Msk = 0x2
	// Bit OVR1.
	EVSYS_INTFLAG_OVR1 = 0x2
	// Position of OVR2 field.
	EVSYS_INTFLAG_OVR2_Pos = 0x2
	// Bit mask of OVR2 field.
	EVSYS_INTFLAG_OVR2_Msk = 0x4
	// Bit OVR2.
	EVSYS_INTFLAG_OVR2 = 0x4
	// Position of OVR3 field.
	EVSYS_INTFLAG_OVR3_Pos = 0x3
	// Bit mask of OVR3 field.
	EVSYS_INTFLAG_OVR3_Msk = 0x8
	// Bit OVR3.
	EVSYS_INTFLAG_OVR3 = 0x8
	// Position of OVR4 field.
	EVSYS_INTFLAG_OVR4_Pos = 0x4
	// Bit mask of OVR4 field.
	EVSYS_INTFLAG_OVR4_Msk = 0x10
	// Bit OVR4.
	EVSYS_INTFLAG_OVR4 = 0x10
	// Position of OVR5 field.
	EVSYS_INTFLAG_OVR5_Pos = 0x5
	// Bit mask of OVR5 field.
	EVSYS_INTFLAG_OVR5_Msk = 0x20
	// Bit OVR5.
	EVSYS_INTFLAG_OVR5 = 0x20
	// Position of OVR6 field.
	EVSYS_INTFLAG_OVR6_Pos = 0x6
	// Bit mask of OVR6 field.
	EVSYS_INTFLAG_OVR6_Msk = 0x40
	// Bit OVR6.
	EVSYS_INTFLAG_OVR6 = 0x40
	// Position of OVR7 field.
	EVSYS_INTFLAG_OVR7_Pos = 0x7
	// Bit mask of OVR7 field.
	EVSYS_INTFLAG_OVR7_Msk = 0x80
	// Bit OVR7.
	EVSYS_INTFLAG_OVR7 = 0x80
	// Position of EVD0 field.
	EVSYS_INTFLAG_EVD0_Pos = 0x8
	// Bit mask of EVD0 field.
	EVSYS_INTFLAG_EVD0_Msk = 0x100
	// Bit EVD0.
	EVSYS_INTFLAG_EVD0 = 0x100
	// Position of EVD1 field.
	EVSYS_INTFLAG_EVD1_Pos = 0x9
	// Bit mask of EVD1 field.
	EVSYS_INTFLAG_EVD1_Msk = 0x200
	// Bit EVD1.
	EVSYS_INTFLAG_EVD1 = 0x200
	// Position of EVD2 field.
	EVSYS_INTFLAG_EVD2_Pos = 0xa
	// Bit mask of EVD2 field.
	EVSYS_INTFLAG_EVD2_Msk = 0x400
	// Bit EVD2.
	EVSYS_INTFLAG_EVD2 = 0x400
	// Position of EVD3 field.
	EVSYS_INTFLAG_EVD3_Pos = 0xb
	// Bit mask of EVD3 field.
	EVSYS_INTFLAG_EVD3_Msk = 0x800
	// Bit EVD3.
	EVSYS_INTFLAG_EVD3 = 0x800
	// Position of EVD4 field.
	EVSYS_INTFLAG_EVD4_Pos = 0xc
	// Bit mask of EVD4 field.
	EVSYS_INTFLAG_EVD4_Msk = 0x1000
	// Bit EVD4.
	EVSYS_INTFLAG_EVD4 = 0x1000
	// Position of EVD5 field.
	EVSYS_INTFLAG_EVD5_Pos = 0xd
	// Bit mask of EVD5 field.
	EVSYS_INTFLAG_EVD5_Msk = 0x2000
	// Bit EVD5.
	EVSYS_INTFLAG_EVD5 = 0x2000
	// Position of EVD6 field.
	EVSYS_INTFLAG_EVD6_Pos = 0xe
	// Bit mask of EVD6 field.
	EVSYS_INTFLAG_EVD6_Msk = 0x4000
	// Bit EVD6.
	EVSYS_INTFLAG_EVD6 = 0x4000
	// Position of EVD7 field.
	EVSYS_INTFLAG_EVD7_Pos = 0xf
	// Bit mask of EVD7 field.
	EVSYS_INTFLAG_EVD7_Msk = 0x8000
	// Bit EVD7.
	EVSYS_INTFLAG_EVD7 = 0x8000
	// Position of OVR8 field.
	EVSYS_INTFLAG_OVR8_Pos = 0x10
	// Bit mask of OVR8 field.
	EVSYS_INTFLAG_OVR8_Msk = 0x10000
	// Bit OVR8.
	EVSYS_INTFLAG_OVR8 = 0x10000
	// Position of OVR9 field.
	EVSYS_INTFLAG_OVR9_Pos = 0x11
	// Bit mask of OVR9 field.
	EVSYS_INTFLAG_OVR9_Msk = 0x20000
	// Bit OVR9.
	EVSYS_INTFLAG_OVR9 = 0x20000
	// Position of OVR10 field.
	EVSYS_INTFLAG_OVR10_Pos = 0x12
	// Bit mask of OVR10 field.
	EVSYS_INTFLAG_OVR10_Msk = 0x40000
	// Bit OVR10.
	EVSYS_INTFLAG_OVR10 = 0x40000
	// Position of OVR11 field.
	EVSYS_INTFLAG_OVR11_Pos = 0x13
	// Bit mask of OVR11 field.
	EVSYS_INTFLAG_OVR11_Msk = 0x80000
	// Bit OVR11.
	EVSYS_INTFLAG_OVR11 = 0x80000
	// Position of EVD8 field.
	EVSYS_INTFLAG_EVD8_Pos = 0x18
	// Bit mask of EVD8 field.
	EVSYS_INTFLAG_EVD8_Msk = 0x1000000
	// Bit EVD8.
	EVSYS_INTFLAG_EVD8 = 0x1000000
	// Position of EVD9 field.
	EVSYS_INTFLAG_EVD9_Pos = 0x19
	// Bit mask of EVD9 field.
	EVSYS_INTFLAG_EVD9_Msk = 0x2000000
	// Bit EVD9.
	EVSYS_INTFLAG_EVD9 = 0x2000000
	// Position of EVD10 field.
	EVSYS_INTFLAG_EVD10_Pos = 0x1a
	// Bit mask of EVD10 field.
	EVSYS_INTFLAG_EVD10_Msk = 0x4000000
	// Bit EVD10.
	EVSYS_INTFLAG_EVD10 = 0x4000000
	// Position of EVD11 field.
	EVSYS_INTFLAG_EVD11_Pos = 0x1b
	// Bit mask of EVD11 field.
	EVSYS_INTFLAG_EVD11_Msk = 0x8000000
	// Bit EVD11.
	EVSYS_INTFLAG_EVD11 = 0x8000000
)

// Constants for GCLK: Generic Clock Generator
const (
	// CTRL: Control
	// Position of SWRST field.
	GCLK_CTRL_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	GCLK_CTRL_SWRST_Msk = 0x1
	// Bit SWRST.
	GCLK_CTRL_SWRST = 0x1

	// STATUS: Status
	// Position of SYNCBUSY field.
	GCLK_STATUS_SYNCBUSY_Pos = 0x7
	// Bit mask of SYNCBUSY field.
	GCLK_STATUS_SYNCBUSY_Msk = 0x80
	// Bit SYNCBUSY.
	GCLK_STATUS_SYNCBUSY = 0x80

	// CLKCTRL: Generic Clock Control
	// Position of ID field.
	GCLK_CLKCTRL_ID_Pos = 0x0
	// Bit mask of ID field.
	GCLK_CLKCTRL_ID_Msk = 0x3f
	// DFLL48
	GCLK_CLKCTRL_ID_DFLL48 = 0x0
	// FDPLL
	GCLK_CLKCTRL_ID_FDPLL = 0x1
	// FDPLL32K
	GCLK_CLKCTRL_ID_FDPLL32K = 0x2
	// WDT
	GCLK_CLKCTRL_ID_WDT = 0x3
	// RTC
	GCLK_CLKCTRL_ID_RTC = 0x4
	// EIC
	GCLK_CLKCTRL_ID_EIC = 0x5
	// USB
	GCLK_CLKCTRL_ID_USB = 0x6
	// EVSYS_0
	GCLK_CLKCTRL_ID_EVSYS_0 = 0x7
	// EVSYS_1
	GCLK_CLKCTRL_ID_EVSYS_1 = 0x8
	// EVSYS_2
	GCLK_CLKCTRL_ID_EVSYS_2 = 0x9
	// EVSYS_3
	GCLK_CLKCTRL_ID_EVSYS_3 = 0xa
	// EVSYS_4
	GCLK_CLKCTRL_ID_EVSYS_4 = 0xb
	// EVSYS_5
	GCLK_CLKCTRL_ID_EVSYS_5 = 0xc
	// EVSYS_6
	GCLK_CLKCTRL_ID_EVSYS_6 = 0xd
	// EVSYS_7
	GCLK_CLKCTRL_ID_EVSYS_7 = 0xe
	// EVSYS_8
	GCLK_CLKCTRL_ID_EVSYS_8 = 0xf
	// EVSYS_9
	GCLK_CLKCTRL_ID_EVSYS_9 = 0x10
	// EVSYS_10
	GCLK_CLKCTRL_ID_EVSYS_10 = 0x11
	// EVSYS_11
	GCLK_CLKCTRL_ID_EVSYS_11 = 0x12
	// SERCOMX_SLOW
	GCLK_CLKCTRL_ID_SERCOMX_SLOW = 0x13
	// SERCOM0_CORE
	GCLK_CLKCTRL_ID_SERCOM0_CORE = 0x14
	// SERCOM1_CORE
	GCLK_CLKCTRL_ID_SERCOM1_CORE = 0x15
	// SERCOM2_CORE
	GCLK_CLKCTRL_ID_SERCOM2_CORE = 0x16
	// SERCOM3_CORE
	GCLK_CLKCTRL_ID_SERCOM3_CORE = 0x17
	// SERCOM4_CORE
	GCLK_CLKCTRL_ID_SERCOM4_CORE = 0x18
	// SERCOM5_CORE
	GCLK_CLKCTRL_ID_SERCOM5_CORE = 0x19
	// TCC0_TCC1
	GCLK_CLKCTRL_ID_TCC0_TCC1 = 0x1a
	// TCC2_TC3
	GCLK_CLKCTRL_ID_TCC2_TC3 = 0x1b
	// TC4_TC5
	GCLK_CLKCTRL_ID_TC4_TC5 = 0x1c
	// TC6_TC7
	GCLK_CLKCTRL_ID_TC6_TC7 = 0x1d
	// ADC
	GCLK_CLKCTRL_ID_ADC = 0x1e
	// AC_DIG
	GCLK_CLKCTRL_ID_AC_DIG = 0x1f
	// AC_ANA
	GCLK_CLKCTRL_ID_AC_ANA = 0x20
	// DAC
	GCLK_CLKCTRL_ID_DAC = 0x21
	// I2S_0
	GCLK_CLKCTRL_ID_I2S_0 = 0x23
	// I2S_1
	GCLK_CLKCTRL_ID_I2S_1 = 0x24
	// Position of GEN field.
	GCLK_CLKCTRL_GEN_Pos = 0x8
	// Bit mask of GEN field.
	GCLK_CLKCTRL_GEN_Msk = 0xf00
	// Generic clock generator 0
	GCLK_CLKCTRL_GEN_GCLK0 = 0x0
	// Generic clock generator 1
	GCLK_CLKCTRL_GEN_GCLK1 = 0x1
	// Generic clock generator 2
	GCLK_CLKCTRL_GEN_GCLK2 = 0x2
	// Generic clock generator 3
	GCLK_CLKCTRL_GEN_GCLK3 = 0x3
	// Generic clock generator 4
	GCLK_CLKCTRL_GEN_GCLK4 = 0x4
	// Generic clock generator 5
	GCLK_CLKCTRL_GEN_GCLK5 = 0x5
	// Generic clock generator 6
	GCLK_CLKCTRL_GEN_GCLK6 = 0x6
	// Generic clock generator 7
	GCLK_CLKCTRL_GEN_GCLK7 = 0x7
	// Generic clock generator 8
	GCLK_CLKCTRL_GEN_GCLK8 = 0x8
	// Position of CLKEN field.
	GCLK_CLKCTRL_CLKEN_Pos = 0xe
	// Bit mask of CLKEN field.
	GCLK_CLKCTRL_CLKEN_Msk = 0x4000
	// Bit CLKEN.
	GCLK_CLKCTRL_CLKEN = 0x4000
	// Position of WRTLOCK field.
	GCLK_CLKCTRL_WRTLOCK_Pos = 0xf
	// Bit mask of WRTLOCK field.
	GCLK_CLKCTRL_WRTLOCK_Msk = 0x8000
	// Bit WRTLOCK.
	GCLK_CLKCTRL_WRTLOCK = 0x8000

	// GENCTRL: Generic Clock Generator Control
	// Position of ID field.
	GCLK_GENCTRL_ID_Pos = 0x0
	// Bit mask of ID field.
	GCLK_GENCTRL_ID_Msk = 0xf
	// Position of SRC field.
	GCLK_GENCTRL_SRC_Pos = 0x8
	// Bit mask of SRC field.
	GCLK_GENCTRL_SRC_Msk = 0x1f00
	// XOSC oscillator output
	GCLK_GENCTRL_SRC_XOSC = 0x0
	// Generator input pad
	GCLK_GENCTRL_SRC_GCLKIN = 0x1
	// Generic clock generator 1 output
	GCLK_GENCTRL_SRC_GCLKGEN1 = 0x2
	// OSCULP32K oscillator output
	GCLK_GENCTRL_SRC_OSCULP32K = 0x3
	// OSC32K oscillator output
	GCLK_GENCTRL_SRC_OSC32K = 0x4
	// XOSC32K oscillator output
	GCLK_GENCTRL_SRC_XOSC32K = 0x5
	// OSC8M oscillator output
	GCLK_GENCTRL_SRC_OSC8M = 0x6
	// DFLL48M output
	GCLK_GENCTRL_SRC_DFLL48M = 0x7
	// DPLL96M output
	GCLK_GENCTRL_SRC_DPLL96M = 0x8
	// Position of GENEN field.
	GCLK_GENCTRL_GENEN_Pos = 0x10
	// Bit mask of GENEN field.
	GCLK_GENCTRL_GENEN_Msk = 0x10000
	// Bit GENEN.
	GCLK_GENCTRL_GENEN = 0x10000
	// Position of IDC field.
	GCLK_GENCTRL_IDC_Pos = 0x11
	// Bit mask of IDC field.
	GCLK_GENCTRL_IDC_Msk = 0x20000
	// Bit IDC.
	GCLK_GENCTRL_IDC = 0x20000
	// Position of OOV field.
	GCLK_GENCTRL_OOV_Pos = 0x12
	// Bit mask of OOV field.
	GCLK_GENCTRL_OOV_Msk = 0x40000
	// Bit OOV.
	GCLK_GENCTRL_OOV = 0x40000
	// Position of OE field.
	GCLK_GENCTRL_OE_Pos = 0x13
	// Bit mask of OE field.
	GCLK_GENCTRL_OE_Msk = 0x80000
	// Bit OE.
	GCLK_GENCTRL_OE = 0x80000
	// Position of DIVSEL field.
	GCLK_GENCTRL_DIVSEL_Pos = 0x14
	// Bit mask of DIVSEL field.
	GCLK_GENCTRL_DIVSEL_Msk = 0x100000
	// Bit DIVSEL.
	GCLK_GENCTRL_DIVSEL = 0x100000
	// Position of RUNSTDBY field.
	GCLK_GENCTRL_RUNSTDBY_Pos = 0x15
	// Bit mask of RUNSTDBY field.
	GCLK_GENCTRL_RUNSTDBY_Msk = 0x200000
	// Bit RUNSTDBY.
	GCLK_GENCTRL_RUNSTDBY = 0x200000

	// GENDIV: Generic Clock Generator Division
	// Position of ID field.
	GCLK_GENDIV_ID_Pos = 0x0
	// Bit mask of ID field.
	GCLK_GENDIV_ID_Msk = 0xf
	// Position of DIV field.
	GCLK_GENDIV_DIV_Pos = 0x8
	// Bit mask of DIV field.
	GCLK_GENDIV_DIV_Msk = 0xffff00
)

// Constants for HMATRIX: HSB Matrix
const (
	// SFR0: Special Function
	// Position of SFR field.
	HMATRIXB_SFR_SFR_Pos = 0x0
	// Bit mask of SFR field.
	HMATRIXB_SFR_SFR_Msk = 0xffffffff
)

// Constants for I2S: Inter-IC Sound Interface
const (
	// CTRLA: Control A
	// Position of SWRST field.
	I2S_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	I2S_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	I2S_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	I2S_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	I2S_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	I2S_CTRLA_ENABLE = 0x2
	// Position of CKEN0 field.
	I2S_CTRLA_CKEN0_Pos = 0x2
	// Bit mask of CKEN0 field.
	I2S_CTRLA_CKEN0_Msk = 0x4
	// Bit CKEN0.
	I2S_CTRLA_CKEN0 = 0x4
	// Position of CKEN1 field.
	I2S_CTRLA_CKEN1_Pos = 0x3
	// Bit mask of CKEN1 field.
	I2S_CTRLA_CKEN1_Msk = 0x8
	// Bit CKEN1.
	I2S_CTRLA_CKEN1 = 0x8
	// Position of SEREN0 field.
	I2S_CTRLA_SEREN0_Pos = 0x4
	// Bit mask of SEREN0 field.
	I2S_CTRLA_SEREN0_Msk = 0x10
	// Bit SEREN0.
	I2S_CTRLA_SEREN0 = 0x10
	// Position of SEREN1 field.
	I2S_CTRLA_SEREN1_Pos = 0x5
	// Bit mask of SEREN1 field.
	I2S_CTRLA_SEREN1_Msk = 0x20
	// Bit SEREN1.
	I2S_CTRLA_SEREN1 = 0x20

	// CLKCTRL0: Clock Unit n Control
	// Position of SLOTSIZE field.
	I2S_CLKCTRL_SLOTSIZE_Pos = 0x0
	// Bit mask of SLOTSIZE field.
	I2S_CLKCTRL_SLOTSIZE_Msk = 0x3
	// 8-bit Slot for Clock Unit n
	I2S_CLKCTRL_SLOTSIZE_8 = 0x0
	// 16-bit Slot for Clock Unit n
	I2S_CLKCTRL_SLOTSIZE_16 = 0x1
	// 24-bit Slot for Clock Unit n
	I2S_CLKCTRL_SLOTSIZE_24 = 0x2
	// 32-bit Slot for Clock Unit n
	I2S_CLKCTRL_SLOTSIZE_32 = 0x3
	// Position of NBSLOTS field.
	I2S_CLKCTRL_NBSLOTS_Pos = 0x2
	// Bit mask of NBSLOTS field.
	I2S_CLKCTRL_NBSLOTS_Msk = 0x1c
	// Position of FSWIDTH field.
	I2S_CLKCTRL_FSWIDTH_Pos = 0x5
	// Bit mask of FSWIDTH field.
	I2S_CLKCTRL_FSWIDTH_Msk = 0x60
	// Frame Sync Pulse is 1 Slot wide (default for I2S protocol)
	I2S_CLKCTRL_FSWIDTH_SLOT = 0x0
	// Frame Sync Pulse is half a Frame wide
	I2S_CLKCTRL_FSWIDTH_HALF = 0x1
	// Frame Sync Pulse is 1 Bit wide
	I2S_CLKCTRL_FSWIDTH_BIT = 0x2
	// Clock Unit n operates in Burst mode, with a 1-bit wide Frame Sync pulse per Data sample, only when Data transfer is requested
	I2S_CLKCTRL_FSWIDTH_BURST = 0x3
	// Position of BITDELAY field.
	I2S_CLKCTRL_BITDELAY_Pos = 0x7
	// Bit mask of BITDELAY field.
	I2S_CLKCTRL_BITDELAY_Msk = 0x80
	// Bit BITDELAY.
	I2S_CLKCTRL_BITDELAY = 0x80
	// Left Justified (0 Bit Delay)
	I2S_CLKCTRL_BITDELAY_LJ = 0x0
	// I2S (1 Bit Delay)
	I2S_CLKCTRL_BITDELAY_I2S = 0x1
	// Position of FSSEL field.
	I2S_CLKCTRL_FSSEL_Pos = 0x8
	// Bit mask of FSSEL field.
	I2S_CLKCTRL_FSSEL_Msk = 0x100
	// Bit FSSEL.
	I2S_CLKCTRL_FSSEL = 0x100
	// Divided Serial Clock n is used as Frame Sync n source
	I2S_CLKCTRL_FSSEL_SCKDIV = 0x0
	// FSn input pin is used as Frame Sync n source
	I2S_CLKCTRL_FSSEL_FSPIN = 0x1
	// Position of FSINV field.
	I2S_CLKCTRL_FSINV_Pos = 0xb
	// Bit mask of FSINV field.
	I2S_CLKCTRL_FSINV_Msk = 0x800
	// Bit FSINV.
	I2S_CLKCTRL_FSINV = 0x800
	// Position of SCKSEL field.
	I2S_CLKCTRL_SCKSEL_Pos = 0xc
	// Bit mask of SCKSEL field.
	I2S_CLKCTRL_SCKSEL_Msk = 0x1000
	// Bit SCKSEL.
	I2S_CLKCTRL_SCKSEL = 0x1000
	// Divided Master Clock n is used as Serial Clock n source
	I2S_CLKCTRL_SCKSEL_MCKDIV = 0x0
	// SCKn input pin is used as Serial Clock n source
	I2S_CLKCTRL_SCKSEL_SCKPIN = 0x1
	// Position of MCKSEL field.
	I2S_CLKCTRL_MCKSEL_Pos = 0x10
	// Bit mask of MCKSEL field.
	I2S_CLKCTRL_MCKSEL_Msk = 0x10000
	// Bit MCKSEL.
	I2S_CLKCTRL_MCKSEL = 0x10000
	// GCLK_I2S_n is used as Master Clock n source
	I2S_CLKCTRL_MCKSEL_GCLK = 0x0
	// MCKn input pin is used as Master Clock n source
	I2S_CLKCTRL_MCKSEL_MCKPIN = 0x1
	// Position of MCKEN field.
	I2S_CLKCTRL_MCKEN_Pos = 0x12
	// Bit mask of MCKEN field.
	I2S_CLKCTRL_MCKEN_Msk = 0x40000
	// Bit MCKEN.
	I2S_CLKCTRL_MCKEN = 0x40000
	// Position of MCKDIV field.
	I2S_CLKCTRL_MCKDIV_Pos = 0x13
	// Bit mask of MCKDIV field.
	I2S_CLKCTRL_MCKDIV_Msk = 0xf80000
	// Position of MCKOUTDIV field.
	I2S_CLKCTRL_MCKOUTDIV_Pos = 0x18
	// Bit mask of MCKOUTDIV field.
	I2S_CLKCTRL_MCKOUTDIV_Msk = 0x1f000000
	// Position of FSOUTINV field.
	I2S_CLKCTRL_FSOUTINV_Pos = 0x1d
	// Bit mask of FSOUTINV field.
	I2S_CLKCTRL_FSOUTINV_Msk = 0x20000000
	// Bit FSOUTINV.
	I2S_CLKCTRL_FSOUTINV = 0x20000000
	// Position of SCKOUTINV field.
	I2S_CLKCTRL_SCKOUTINV_Pos = 0x1e
	// Bit mask of SCKOUTINV field.
	I2S_CLKCTRL_SCKOUTINV_Msk = 0x40000000
	// Bit SCKOUTINV.
	I2S_CLKCTRL_SCKOUTINV = 0x40000000
	// Position of MCKOUTINV field.
	I2S_CLKCTRL_MCKOUTINV_Pos = 0x1f
	// Bit mask of MCKOUTINV field.
	I2S_CLKCTRL_MCKOUTINV_Msk = 0x80000000
	// Bit MCKOUTINV.
	I2S_CLKCTRL_MCKOUTINV = 0x80000000

	// INTENCLR: Interrupt Enable Clear
	// Position of RXRDY0 field.
	I2S_INTENCLR_RXRDY0_Pos = 0x0
	// Bit mask of RXRDY0 field.
	I2S_INTENCLR_RXRDY0_Msk = 0x1
	// Bit RXRDY0.
	I2S_INTENCLR_RXRDY0 = 0x1
	// Position of RXRDY1 field.
	I2S_INTENCLR_RXRDY1_Pos = 0x1
	// Bit mask of RXRDY1 field.
	I2S_INTENCLR_RXRDY1_Msk = 0x2
	// Bit RXRDY1.
	I2S_INTENCLR_RXRDY1 = 0x2
	// Position of RXOR0 field.
	I2S_INTENCLR_RXOR0_Pos = 0x4
	// Bit mask of RXOR0 field.
	I2S_INTENCLR_RXOR0_Msk = 0x10
	// Bit RXOR0.
	I2S_INTENCLR_RXOR0 = 0x10
	// Position of RXOR1 field.
	I2S_INTENCLR_RXOR1_Pos = 0x5
	// Bit mask of RXOR1 field.
	I2S_INTENCLR_RXOR1_Msk = 0x20
	// Bit RXOR1.
	I2S_INTENCLR_RXOR1 = 0x20
	// Position of TXRDY0 field.
	I2S_INTENCLR_TXRDY0_Pos = 0x8
	// Bit mask of TXRDY0 field.
	I2S_INTENCLR_TXRDY0_Msk = 0x100
	// Bit TXRDY0.
	I2S_INTENCLR_TXRDY0 = 0x100
	// Position of TXRDY1 field.
	I2S_INTENCLR_TXRDY1_Pos = 0x9
	// Bit mask of TXRDY1 field.
	I2S_INTENCLR_TXRDY1_Msk = 0x200
	// Bit TXRDY1.
	I2S_INTENCLR_TXRDY1 = 0x200
	// Position of TXUR0 field.
	I2S_INTENCLR_TXUR0_Pos = 0xc
	// Bit mask of TXUR0 field.
	I2S_INTENCLR_TXUR0_Msk = 0x1000
	// Bit TXUR0.
	I2S_INTENCLR_TXUR0 = 0x1000
	// Position of TXUR1 field.
	I2S_INTENCLR_TXUR1_Pos = 0xd
	// Bit mask of TXUR1 field.
	I2S_INTENCLR_TXUR1_Msk = 0x2000
	// Bit TXUR1.
	I2S_INTENCLR_TXUR1 = 0x2000

	// INTENSET: Interrupt Enable Set
	// Position of RXRDY0 field.
	I2S_INTENSET_RXRDY0_Pos = 0x0
	// Bit mask of RXRDY0 field.
	I2S_INTENSET_RXRDY0_Msk = 0x1
	// Bit RXRDY0.
	I2S_INTENSET_RXRDY0 = 0x1
	// Position of RXRDY1 field.
	I2S_INTENSET_RXRDY1_Pos = 0x1
	// Bit mask of RXRDY1 field.
	I2S_INTENSET_RXRDY1_Msk = 0x2
	// Bit RXRDY1.
	I2S_INTENSET_RXRDY1 = 0x2
	// Position of RXOR0 field.
	I2S_INTENSET_RXOR0_Pos = 0x4
	// Bit mask of RXOR0 field.
	I2S_INTENSET_RXOR0_Msk = 0x10
	// Bit RXOR0.
	I2S_INTENSET_RXOR0 = 0x10
	// Position of RXOR1 field.
	I2S_INTENSET_RXOR1_Pos = 0x5
	// Bit mask of RXOR1 field.
	I2S_INTENSET_RXOR1_Msk = 0x20
	// Bit RXOR1.
	I2S_INTENSET_RXOR1 = 0x20
	// Position of TXRDY0 field.
	I2S_INTENSET_TXRDY0_Pos = 0x8
	// Bit mask of TXRDY0 field.
	I2S_INTENSET_TXRDY0_Msk = 0x100
	// Bit TXRDY0.
	I2S_INTENSET_TXRDY0 = 0x100
	// Position of TXRDY1 field.
	I2S_INTENSET_TXRDY1_Pos = 0x9
	// Bit mask of TXRDY1 field.
	I2S_INTENSET_TXRDY1_Msk = 0x200
	// Bit TXRDY1.
	I2S_INTENSET_TXRDY1 = 0x200
	// Position of TXUR0 field.
	I2S_INTENSET_TXUR0_Pos = 0xc
	// Bit mask of TXUR0 field.
	I2S_INTENSET_TXUR0_Msk = 0x1000
	// Bit TXUR0.
	I2S_INTENSET_TXUR0 = 0x1000
	// Position of TXUR1 field.
	I2S_INTENSET_TXUR1_Pos = 0xd
	// Bit mask of TXUR1 field.
	I2S_INTENSET_TXUR1_Msk = 0x2000
	// Bit TXUR1.
	I2S_INTENSET_TXUR1 = 0x2000

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of RXRDY0 field.
	I2S_INTFLAG_RXRDY0_Pos = 0x0
	// Bit mask of RXRDY0 field.
	I2S_INTFLAG_RXRDY0_Msk = 0x1
	// Bit RXRDY0.
	I2S_INTFLAG_RXRDY0 = 0x1
	// Position of RXRDY1 field.
	I2S_INTFLAG_RXRDY1_Pos = 0x1
	// Bit mask of RXRDY1 field.
	I2S_INTFLAG_RXRDY1_Msk = 0x2
	// Bit RXRDY1.
	I2S_INTFLAG_RXRDY1 = 0x2
	// Position of RXOR0 field.
	I2S_INTFLAG_RXOR0_Pos = 0x4
	// Bit mask of RXOR0 field.
	I2S_INTFLAG_RXOR0_Msk = 0x10
	// Bit RXOR0.
	I2S_INTFLAG_RXOR0 = 0x10
	// Position of RXOR1 field.
	I2S_INTFLAG_RXOR1_Pos = 0x5
	// Bit mask of RXOR1 field.
	I2S_INTFLAG_RXOR1_Msk = 0x20
	// Bit RXOR1.
	I2S_INTFLAG_RXOR1 = 0x20
	// Position of TXRDY0 field.
	I2S_INTFLAG_TXRDY0_Pos = 0x8
	// Bit mask of TXRDY0 field.
	I2S_INTFLAG_TXRDY0_Msk = 0x100
	// Bit TXRDY0.
	I2S_INTFLAG_TXRDY0 = 0x100
	// Position of TXRDY1 field.
	I2S_INTFLAG_TXRDY1_Pos = 0x9
	// Bit mask of TXRDY1 field.
	I2S_INTFLAG_TXRDY1_Msk = 0x200
	// Bit TXRDY1.
	I2S_INTFLAG_TXRDY1 = 0x200
	// Position of TXUR0 field.
	I2S_INTFLAG_TXUR0_Pos = 0xc
	// Bit mask of TXUR0 field.
	I2S_INTFLAG_TXUR0_Msk = 0x1000
	// Bit TXUR0.
	I2S_INTFLAG_TXUR0 = 0x1000
	// Position of TXUR1 field.
	I2S_INTFLAG_TXUR1_Pos = 0xd
	// Bit mask of TXUR1 field.
	I2S_INTFLAG_TXUR1_Msk = 0x2000
	// Bit TXUR1.
	I2S_INTFLAG_TXUR1 = 0x2000

	// SYNCBUSY: Synchronization Status
	// Position of SWRST field.
	I2S_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	I2S_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	I2S_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	I2S_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	I2S_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	I2S_SYNCBUSY_ENABLE = 0x2
	// Position of CKEN0 field.
	I2S_SYNCBUSY_CKEN0_Pos = 0x2
	// Bit mask of CKEN0 field.
	I2S_SYNCBUSY_CKEN0_Msk = 0x4
	// Bit CKEN0.
	I2S_SYNCBUSY_CKEN0 = 0x4
	// Position of CKEN1 field.
	I2S_SYNCBUSY_CKEN1_Pos = 0x3
	// Bit mask of CKEN1 field.
	I2S_SYNCBUSY_CKEN1_Msk = 0x8
	// Bit CKEN1.
	I2S_SYNCBUSY_CKEN1 = 0x8
	// Position of SEREN0 field.
	I2S_SYNCBUSY_SEREN0_Pos = 0x4
	// Bit mask of SEREN0 field.
	I2S_SYNCBUSY_SEREN0_Msk = 0x10
	// Bit SEREN0.
	I2S_SYNCBUSY_SEREN0 = 0x10
	// Position of SEREN1 field.
	I2S_SYNCBUSY_SEREN1_Pos = 0x5
	// Bit mask of SEREN1 field.
	I2S_SYNCBUSY_SEREN1_Msk = 0x20
	// Bit SEREN1.
	I2S_SYNCBUSY_SEREN1 = 0x20
	// Position of DATA0 field.
	I2S_SYNCBUSY_DATA0_Pos = 0x8
	// Bit mask of DATA0 field.
	I2S_SYNCBUSY_DATA0_Msk = 0x100
	// Bit DATA0.
	I2S_SYNCBUSY_DATA0 = 0x100
	// Position of DATA1 field.
	I2S_SYNCBUSY_DATA1_Pos = 0x9
	// Bit mask of DATA1 field.
	I2S_SYNCBUSY_DATA1_Msk = 0x200
	// Bit DATA1.
	I2S_SYNCBUSY_DATA1 = 0x200

	// SERCTRL0: Serializer n Control
	// Position of SERMODE field.
	I2S_SERCTRL_SERMODE_Pos = 0x0
	// Bit mask of SERMODE field.
	I2S_SERCTRL_SERMODE_Msk = 0x3
	// Receive
	I2S_SERCTRL_SERMODE_RX = 0x0
	// Transmit
	I2S_SERCTRL_SERMODE_TX = 0x1
	// Receive one PDM data on each serial clock edge
	I2S_SERCTRL_SERMODE_PDM2 = 0x2
	// Position of TXDEFAULT field.
	I2S_SERCTRL_TXDEFAULT_Pos = 0x2
	// Bit mask of TXDEFAULT field.
	I2S_SERCTRL_TXDEFAULT_Msk = 0xc
	// Output Default Value is 0
	I2S_SERCTRL_TXDEFAULT_ZERO = 0x0
	// Output Default Value is 1
	I2S_SERCTRL_TXDEFAULT_ONE = 0x1
	// Output Default Value is high impedance
	I2S_SERCTRL_TXDEFAULT_HIZ = 0x3
	// Position of TXSAME field.
	I2S_SERCTRL_TXSAME_Pos = 0x4
	// Bit mask of TXSAME field.
	I2S_SERCTRL_TXSAME_Msk = 0x10
	// Bit TXSAME.
	I2S_SERCTRL_TXSAME = 0x10
	// Zero data transmitted in case of underrun
	I2S_SERCTRL_TXSAME_ZERO = 0x0
	// Last data transmitted in case of underrun
	I2S_SERCTRL_TXSAME_SAME = 0x1
	// Position of CLKSEL field.
	I2S_SERCTRL_CLKSEL_Pos = 0x5
	// Bit mask of CLKSEL field.
	I2S_SERCTRL_CLKSEL_Msk = 0x20
	// Bit CLKSEL.
	I2S_SERCTRL_CLKSEL = 0x20
	// Use Clock Unit 0
	I2S_SERCTRL_CLKSEL_CLK0 = 0x0
	// Use Clock Unit 1
	I2S_SERCTRL_CLKSEL_CLK1 = 0x1
	// Position of SLOTADJ field.
	I2S_SERCTRL_SLOTADJ_Pos = 0x7
	// Bit mask of SLOTADJ field.
	I2S_SERCTRL_SLOTADJ_Msk = 0x80
	// Bit SLOTADJ.
	I2S_SERCTRL_SLOTADJ = 0x80
	// Data is right adjusted in slot
	I2S_SERCTRL_SLOTADJ_RIGHT = 0x0
	// Data is left adjusted in slot
	I2S_SERCTRL_SLOTADJ_LEFT = 0x1
	// Position of DATASIZE field.
	I2S_SERCTRL_DATASIZE_Pos = 0x8
	// Bit mask of DATASIZE field.
	I2S_SERCTRL_DATASIZE_Msk = 0x700
	// 32 bits
	I2S_SERCTRL_DATASIZE_32 = 0x0
	// 24 bits
	I2S_SERCTRL_DATASIZE_24 = 0x1
	// 20 bits
	I2S_SERCTRL_DATASIZE_20 = 0x2
	// 18 bits
	I2S_SERCTRL_DATASIZE_18 = 0x3
	// 16 bits
	I2S_SERCTRL_DATASIZE_16 = 0x4
	// 16 bits compact stereo
	I2S_SERCTRL_DATASIZE_16C = 0x5
	// 8 bits
	I2S_SERCTRL_DATASIZE_8 = 0x6
	// 8 bits compact stereo
	I2S_SERCTRL_DATASIZE_8C = 0x7
	// Position of WORDADJ field.
	I2S_SERCTRL_WORDADJ_Pos = 0xc
	// Bit mask of WORDADJ field.
	I2S_SERCTRL_WORDADJ_Msk = 0x1000
	// Bit WORDADJ.
	I2S_SERCTRL_WORDADJ = 0x1000
	// Data is right adjusted in word
	I2S_SERCTRL_WORDADJ_RIGHT = 0x0
	// Data is left adjusted in word
	I2S_SERCTRL_WORDADJ_LEFT = 0x1
	// Position of EXTEND field.
	I2S_SERCTRL_EXTEND_Pos = 0xd
	// Bit mask of EXTEND field.
	I2S_SERCTRL_EXTEND_Msk = 0x6000
	// Extend with zeroes
	I2S_SERCTRL_EXTEND_ZERO = 0x0
	// Extend with ones
	I2S_SERCTRL_EXTEND_ONE = 0x1
	// Extend with Most Significant Bit
	I2S_SERCTRL_EXTEND_MSBIT = 0x2
	// Extend with Least Significant Bit
	I2S_SERCTRL_EXTEND_LSBIT = 0x3
	// Position of BITREV field.
	I2S_SERCTRL_BITREV_Pos = 0xf
	// Bit mask of BITREV field.
	I2S_SERCTRL_BITREV_Msk = 0x8000
	// Bit BITREV.
	I2S_SERCTRL_BITREV = 0x8000
	// Transfer Data Most Significant Bit (MSB) first (default for I2S protocol)
	I2S_SERCTRL_BITREV_MSBIT = 0x0
	// Transfer Data Least Significant Bit (LSB) first
	I2S_SERCTRL_BITREV_LSBIT = 0x1
	// Position of SLOTDIS0 field.
	I2S_SERCTRL_SLOTDIS0_Pos = 0x10
	// Bit mask of SLOTDIS0 field.
	I2S_SERCTRL_SLOTDIS0_Msk = 0x10000
	// Bit SLOTDIS0.
	I2S_SERCTRL_SLOTDIS0 = 0x10000
	// Position of SLOTDIS1 field.
	I2S_SERCTRL_SLOTDIS1_Pos = 0x11
	// Bit mask of SLOTDIS1 field.
	I2S_SERCTRL_SLOTDIS1_Msk = 0x20000
	// Bit SLOTDIS1.
	I2S_SERCTRL_SLOTDIS1 = 0x20000
	// Position of SLOTDIS2 field.
	I2S_SERCTRL_SLOTDIS2_Pos = 0x12
	// Bit mask of SLOTDIS2 field.
	I2S_SERCTRL_SLOTDIS2_Msk = 0x40000
	// Bit SLOTDIS2.
	I2S_SERCTRL_SLOTDIS2 = 0x40000
	// Position of SLOTDIS3 field.
	I2S_SERCTRL_SLOTDIS3_Pos = 0x13
	// Bit mask of SLOTDIS3 field.
	I2S_SERCTRL_SLOTDIS3_Msk = 0x80000
	// Bit SLOTDIS3.
	I2S_SERCTRL_SLOTDIS3 = 0x80000
	// Position of SLOTDIS4 field.
	I2S_SERCTRL_SLOTDIS4_Pos = 0x14
	// Bit mask of SLOTDIS4 field.
	I2S_SERCTRL_SLOTDIS4_Msk = 0x100000
	// Bit SLOTDIS4.
	I2S_SERCTRL_SLOTDIS4 = 0x100000
	// Position of SLOTDIS5 field.
	I2S_SERCTRL_SLOTDIS5_Pos = 0x15
	// Bit mask of SLOTDIS5 field.
	I2S_SERCTRL_SLOTDIS5_Msk = 0x200000
	// Bit SLOTDIS5.
	I2S_SERCTRL_SLOTDIS5 = 0x200000
	// Position of SLOTDIS6 field.
	I2S_SERCTRL_SLOTDIS6_Pos = 0x16
	// Bit mask of SLOTDIS6 field.
	I2S_SERCTRL_SLOTDIS6_Msk = 0x400000
	// Bit SLOTDIS6.
	I2S_SERCTRL_SLOTDIS6 = 0x400000
	// Position of SLOTDIS7 field.
	I2S_SERCTRL_SLOTDIS7_Pos = 0x17
	// Bit mask of SLOTDIS7 field.
	I2S_SERCTRL_SLOTDIS7_Msk = 0x800000
	// Bit SLOTDIS7.
	I2S_SERCTRL_SLOTDIS7 = 0x800000
	// Position of MONO field.
	I2S_SERCTRL_MONO_Pos = 0x18
	// Bit mask of MONO field.
	I2S_SERCTRL_MONO_Msk = 0x1000000
	// Bit MONO.
	I2S_SERCTRL_MONO = 0x1000000
	// Normal mode
	I2S_SERCTRL_MONO_STEREO = 0x0
	// Left channel data is duplicated to right channel
	I2S_SERCTRL_MONO_MONO = 0x1
	// Position of DMA field.
	I2S_SERCTRL_DMA_Pos = 0x19
	// Bit mask of DMA field.
	I2S_SERCTRL_DMA_Msk = 0x2000000
	// Bit DMA.
	I2S_SERCTRL_DMA = 0x2000000
	// Single DMA channel
	I2S_SERCTRL_DMA_SINGLE = 0x0
	// One DMA channel per data channel
	I2S_SERCTRL_DMA_MULTIPLE = 0x1
	// Position of RXLOOP field.
	I2S_SERCTRL_RXLOOP_Pos = 0x1a
	// Bit mask of RXLOOP field.
	I2S_SERCTRL_RXLOOP_Msk = 0x4000000
	// Bit RXLOOP.
	I2S_SERCTRL_RXLOOP = 0x4000000

	// DATA0: Data n
	// Position of DATA field.
	I2S_DATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	I2S_DATA_DATA_Msk = 0xffffffff
)

// Constants for MTB: Cortex-M0+ Micro-Trace Buffer
const (
	// POSITION: MTB Position
	// Position of WRAP field.
	MTB_POSITION_WRAP_Pos = 0x2
	// Bit mask of WRAP field.
	MTB_POSITION_WRAP_Msk = 0x4
	// Bit WRAP.
	MTB_POSITION_WRAP = 0x4
	// Position of POINTER field.
	MTB_POSITION_POINTER_Pos = 0x3
	// Bit mask of POINTER field.
	MTB_POSITION_POINTER_Msk = 0xfffffff8

	// MASTER: MTB Master
	// Position of MASK field.
	MTB_MASTER_MASK_Pos = 0x0
	// Bit mask of MASK field.
	MTB_MASTER_MASK_Msk = 0x1f
	// Position of TSTARTEN field.
	MTB_MASTER_TSTARTEN_Pos = 0x5
	// Bit mask of TSTARTEN field.
	MTB_MASTER_TSTARTEN_Msk = 0x20
	// Bit TSTARTEN.
	MTB_MASTER_TSTARTEN = 0x20
	// Position of TSTOPEN field.
	MTB_MASTER_TSTOPEN_Pos = 0x6
	// Bit mask of TSTOPEN field.
	MTB_MASTER_TSTOPEN_Msk = 0x40
	// Bit TSTOPEN.
	MTB_MASTER_TSTOPEN = 0x40
	// Position of SFRWPRIV field.
	MTB_MASTER_SFRWPRIV_Pos = 0x7
	// Bit mask of SFRWPRIV field.
	MTB_MASTER_SFRWPRIV_Msk = 0x80
	// Bit SFRWPRIV.
	MTB_MASTER_SFRWPRIV = 0x80
	// Position of RAMPRIV field.
	MTB_MASTER_RAMPRIV_Pos = 0x8
	// Bit mask of RAMPRIV field.
	MTB_MASTER_RAMPRIV_Msk = 0x100
	// Bit RAMPRIV.
	MTB_MASTER_RAMPRIV = 0x100
	// Position of HALTREQ field.
	MTB_MASTER_HALTREQ_Pos = 0x9
	// Bit mask of HALTREQ field.
	MTB_MASTER_HALTREQ_Msk = 0x200
	// Bit HALTREQ.
	MTB_MASTER_HALTREQ = 0x200
	// Position of EN field.
	MTB_MASTER_EN_Pos = 0x1f
	// Bit mask of EN field.
	MTB_MASTER_EN_Msk = 0x80000000
	// Bit EN.
	MTB_MASTER_EN = 0x80000000

	// FLOW: MTB Flow
	// Position of AUTOSTOP field.
	MTB_FLOW_AUTOSTOP_Pos = 0x0
	// Bit mask of AUTOSTOP field.
	MTB_FLOW_AUTOSTOP_Msk = 0x1
	// Bit AUTOSTOP.
	MTB_FLOW_AUTOSTOP = 0x1
	// Position of AUTOHALT field.
	MTB_FLOW_AUTOHALT_Pos = 0x1
	// Bit mask of AUTOHALT field.
	MTB_FLOW_AUTOHALT_Msk = 0x2
	// Bit AUTOHALT.
	MTB_FLOW_AUTOHALT = 0x2
	// Position of WATERMARK field.
	MTB_FLOW_WATERMARK_Pos = 0x3
	// Bit mask of WATERMARK field.
	MTB_FLOW_WATERMARK_Msk = 0xfffffff8
)

// Constants for NVMCTRL: Non-Volatile Memory Controller
const (
	// CTRLA: Control A
	// Position of CMD field.
	NVMCTRL_CTRLA_CMD_Pos = 0x0
	// Bit mask of CMD field.
	NVMCTRL_CTRLA_CMD_Msk = 0x7f
	// Erase Row - Erases the row addressed by the ADDR register.
	NVMCTRL_CTRLA_CMD_ER = 0x2
	// Write Page - Writes the contents of the page buffer to the page addressed by the ADDR register.
	NVMCTRL_CTRLA_CMD_WP = 0x4
	// Erase Auxiliary Row - Erases the auxiliary row addressed by the ADDR register. This command can be given only when the security bit is not set and only to the user configuration row.
	NVMCTRL_CTRLA_CMD_EAR = 0x5
	// Write Auxiliary Page - Writes the contents of the page buffer to the page addressed by the ADDR register. This command can be given only when the security bit is not set and only to the user configuration row.
	NVMCTRL_CTRLA_CMD_WAP = 0x6
	// Security Flow Command
	NVMCTRL_CTRLA_CMD_SF = 0xa
	// Write lockbits
	NVMCTRL_CTRLA_CMD_WL = 0xf
	// RWW EEPROM area Erase Row - Erases the row addressed by the ADDR register.
	NVMCTRL_CTRLA_CMD_RWWEEER = 0x1a
	// RWW EEPROM Write Page - Writes the contents of the page buffer to the page addressed by the ADDR register.
	NVMCTRL_CTRLA_CMD_RWWEEWP = 0x1c
	// Lock Region - Locks the region containing the address location in the ADDR register.
	NVMCTRL_CTRLA_CMD_LR = 0x40
	// Unlock Region - Unlocks the region containing the address location in the ADDR register.
	NVMCTRL_CTRLA_CMD_UR = 0x41
	// Sets the power reduction mode.
	NVMCTRL_CTRLA_CMD_SPRM = 0x42
	// Clears the power reduction mode.
	NVMCTRL_CTRLA_CMD_CPRM = 0x43
	// Page Buffer Clear - Clears the page buffer.
	NVMCTRL_CTRLA_CMD_PBC = 0x44
	// Set Security Bit - Sets the security bit by writing 0x00 to the first byte in the lockbit row.
	NVMCTRL_CTRLA_CMD_SSB = 0x45
	// Invalidate all cache lines.
	NVMCTRL_CTRLA_CMD_INVALL = 0x46
	// Position of CMDEX field.
	NVMCTRL_CTRLA_CMDEX_Pos = 0x8
	// Bit mask of CMDEX field.
	NVMCTRL_CTRLA_CMDEX_Msk = 0xff00
	// Execution Key
	NVMCTRL_CTRLA_CMDEX_KEY = 0xa5

	// CTRLB: Control B
	// Position of RWS field.
	NVMCTRL_CTRLB_RWS_Pos = 0x1
	// Bit mask of RWS field.
	NVMCTRL_CTRLB_RWS_Msk = 0x1e
	// Single Auto Wait State
	NVMCTRL_CTRLB_RWS_SINGLE = 0x0
	// Half Auto Wait State
	NVMCTRL_CTRLB_RWS_HALF = 0x1
	// Dual Auto Wait State
	NVMCTRL_CTRLB_RWS_DUAL = 0x2
	// Position of MANW field.
	NVMCTRL_CTRLB_MANW_Pos = 0x7
	// Bit mask of MANW field.
	NVMCTRL_CTRLB_MANW_Msk = 0x80
	// Bit MANW.
	NVMCTRL_CTRLB_MANW = 0x80
	// Position of SLEEPPRM field.
	NVMCTRL_CTRLB_SLEEPPRM_Pos = 0x8
	// Bit mask of SLEEPPRM field.
	NVMCTRL_CTRLB_SLEEPPRM_Msk = 0x300
	// NVM block enters low-power mode when entering sleep.NVM block exits low-power mode upon first access.
	NVMCTRL_CTRLB_SLEEPPRM_WAKEONACCESS = 0x0
	// NVM block enters low-power mode when entering sleep.NVM block exits low-power mode when exiting sleep.
	NVMCTRL_CTRLB_SLEEPPRM_WAKEUPINSTANT = 0x1
	// Auto power reduction disabled.
	NVMCTRL_CTRLB_SLEEPPRM_DISABLED = 0x3
	// Position of READMODE field.
	NVMCTRL_CTRLB_READMODE_Pos = 0x10
	// Bit mask of READMODE field.
	NVMCTRL_CTRLB_READMODE_Msk = 0x30000
	// The NVM Controller (cache system) does not insert wait states on a cache miss. Gives the best system performance.
	NVMCTRL_CTRLB_READMODE_NO_MISS_PENALTY = 0x0
	// Reduces power consumption of the cache system, but inserts a wait state each time there is a cache miss. This mode may not be relevant if CPU performance is required, as the application will be stalled and may lead to increase run time.
	NVMCTRL_CTRLB_READMODE_LOW_POWER = 0x1
	// The cache system ensures that a cache hit or miss takes the same amount of time, determined by the number of programmed flash wait states. This mode can be used for real-time applications that require deterministic execution timings.
	NVMCTRL_CTRLB_READMODE_DETERMINISTIC = 0x2
	// Position of CACHEDIS field.
	NVMCTRL_CTRLB_CACHEDIS_Pos = 0x12
	// Bit mask of CACHEDIS field.
	NVMCTRL_CTRLB_CACHEDIS_Msk = 0x40000
	// Bit CACHEDIS.
	NVMCTRL_CTRLB_CACHEDIS = 0x40000

	// PARAM: NVM Parameter
	// Position of NVMP field.
	NVMCTRL_PARAM_NVMP_Pos = 0x0
	// Bit mask of NVMP field.
	NVMCTRL_PARAM_NVMP_Msk = 0xffff
	// Position of PSZ field.
	NVMCTRL_PARAM_PSZ_Pos = 0x10
	// Bit mask of PSZ field.
	NVMCTRL_PARAM_PSZ_Msk = 0x70000
	// 8 bytes
	NVMCTRL_PARAM_PSZ_8 = 0x0
	// 16 bytes
	NVMCTRL_PARAM_PSZ_16 = 0x1
	// 32 bytes
	NVMCTRL_PARAM_PSZ_32 = 0x2
	// 64 bytes
	NVMCTRL_PARAM_PSZ_64 = 0x3
	// 128 bytes
	NVMCTRL_PARAM_PSZ_128 = 0x4
	// 256 bytes
	NVMCTRL_PARAM_PSZ_256 = 0x5
	// 512 bytes
	NVMCTRL_PARAM_PSZ_512 = 0x6
	// 1024 bytes
	NVMCTRL_PARAM_PSZ_1024 = 0x7
	// Position of RWWEEP field.
	NVMCTRL_PARAM_RWWEEP_Pos = 0x14
	// Bit mask of RWWEEP field.
	NVMCTRL_PARAM_RWWEEP_Msk = 0xfff00000

	// INTENCLR: Interrupt Enable Clear
	// Position of READY field.
	NVMCTRL_INTENCLR_READY_Pos = 0x0
	// Bit mask of READY field.
	NVMCTRL_INTENCLR_READY_Msk = 0x1
	// Bit READY.
	NVMCTRL_INTENCLR_READY = 0x1
	// Position of ERROR field.
	NVMCTRL_INTENCLR_ERROR_Pos = 0x1
	// Bit mask of ERROR field.
	NVMCTRL_INTENCLR_ERROR_Msk = 0x2
	// Bit ERROR.
	NVMCTRL_INTENCLR_ERROR = 0x2

	// INTENSET: Interrupt Enable Set
	// Position of READY field.
	NVMCTRL_INTENSET_READY_Pos = 0x0
	// Bit mask of READY field.
	NVMCTRL_INTENSET_READY_Msk = 0x1
	// Bit READY.
	NVMCTRL_INTENSET_READY = 0x1
	// Position of ERROR field.
	NVMCTRL_INTENSET_ERROR_Pos = 0x1
	// Bit mask of ERROR field.
	NVMCTRL_INTENSET_ERROR_Msk = 0x2
	// Bit ERROR.
	NVMCTRL_INTENSET_ERROR = 0x2

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of READY field.
	NVMCTRL_INTFLAG_READY_Pos = 0x0
	// Bit mask of READY field.
	NVMCTRL_INTFLAG_READY_Msk = 0x1
	// Bit READY.
	NVMCTRL_INTFLAG_READY = 0x1
	// Position of ERROR field.
	NVMCTRL_INTFLAG_ERROR_Pos = 0x1
	// Bit mask of ERROR field.
	NVMCTRL_INTFLAG_ERROR_Msk = 0x2
	// Bit ERROR.
	NVMCTRL_INTFLAG_ERROR = 0x2

	// STATUS: Status
	// Position of PRM field.
	NVMCTRL_STATUS_PRM_Pos = 0x0
	// Bit mask of PRM field.
	NVMCTRL_STATUS_PRM_Msk = 0x1
	// Bit PRM.
	NVMCTRL_STATUS_PRM = 0x1
	// Position of LOAD field.
	NVMCTRL_STATUS_LOAD_Pos = 0x1
	// Bit mask of LOAD field.
	NVMCTRL_STATUS_LOAD_Msk = 0x2
	// Bit LOAD.
	NVMCTRL_STATUS_LOAD = 0x2
	// Position of PROGE field.
	NVMCTRL_STATUS_PROGE_Pos = 0x2
	// Bit mask of PROGE field.
	NVMCTRL_STATUS_PROGE_Msk = 0x4
	// Bit PROGE.
	NVMCTRL_STATUS_PROGE = 0x4
	// Position of LOCKE field.
	NVMCTRL_STATUS_LOCKE_Pos = 0x3
	// Bit mask of LOCKE field.
	NVMCTRL_STATUS_LOCKE_Msk = 0x8
	// Bit LOCKE.
	NVMCTRL_STATUS_LOCKE = 0x8
	// Position of NVME field.
	NVMCTRL_STATUS_NVME_Pos = 0x4
	// Bit mask of NVME field.
	NVMCTRL_STATUS_NVME_Msk = 0x10
	// Bit NVME.
	NVMCTRL_STATUS_NVME = 0x10
	// Position of SB field.
	NVMCTRL_STATUS_SB_Pos = 0x8
	// Bit mask of SB field.
	NVMCTRL_STATUS_SB_Msk = 0x100
	// Bit SB.
	NVMCTRL_STATUS_SB = 0x100

	// ADDR: Address
	// Position of ADDR field.
	NVMCTRL_ADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	NVMCTRL_ADDR_ADDR_Msk = 0x3fffff

	// LOCK: Lock Section
	// Position of LOCK field.
	NVMCTRL_LOCK_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	NVMCTRL_LOCK_LOCK_Msk = 0xffff
)

// Constants for PAC0: Peripheral Access Controller 0
const (
	// WPCLR: Write Protection Clear
	// Position of WP field.
	PAC_WPCLR_WP_Pos = 0x1
	// Bit mask of WP field.
	PAC_WPCLR_WP_Msk = 0xfffffffe

	// WPSET: Write Protection Set
	// Position of WP field.
	PAC_WPSET_WP_Pos = 0x1
	// Bit mask of WP field.
	PAC_WPSET_WP_Msk = 0xfffffffe
)

// Constants for PM: Power Manager
const (
	// SLEEP: Sleep Mode
	// Position of IDLE field.
	PM_SLEEP_IDLE_Pos = 0x0
	// Bit mask of IDLE field.
	PM_SLEEP_IDLE_Msk = 0x3
	// The CPU clock domain is stopped
	PM_SLEEP_IDLE_CPU = 0x0
	// The CPU and AHB clock domains are stopped
	PM_SLEEP_IDLE_AHB = 0x1
	// The CPU, AHB and APB clock domains are stopped
	PM_SLEEP_IDLE_APB = 0x2

	// EXTCTRL: External Reset Controller
	// Position of SETDIS field.
	PM_EXTCTRL_SETDIS_Pos = 0x0
	// Bit mask of SETDIS field.
	PM_EXTCTRL_SETDIS_Msk = 0x1
	// Bit SETDIS.
	PM_EXTCTRL_SETDIS = 0x1

	// CPUSEL: CPU Clock Select
	// Position of CPUDIV field.
	PM_CPUSEL_CPUDIV_Pos = 0x0
	// Bit mask of CPUDIV field.
	PM_CPUSEL_CPUDIV_Msk = 0x7
	// Divide by 1
	PM_CPUSEL_CPUDIV_DIV1 = 0x0
	// Divide by 2
	PM_CPUSEL_CPUDIV_DIV2 = 0x1
	// Divide by 4
	PM_CPUSEL_CPUDIV_DIV4 = 0x2
	// Divide by 8
	PM_CPUSEL_CPUDIV_DIV8 = 0x3
	// Divide by 16
	PM_CPUSEL_CPUDIV_DIV16 = 0x4
	// Divide by 32
	PM_CPUSEL_CPUDIV_DIV32 = 0x5
	// Divide by 64
	PM_CPUSEL_CPUDIV_DIV64 = 0x6
	// Divide by 128
	PM_CPUSEL_CPUDIV_DIV128 = 0x7

	// APBASEL: APBA Clock Select
	// Position of APBADIV field.
	PM_APBASEL_APBADIV_Pos = 0x0
	// Bit mask of APBADIV field.
	PM_APBASEL_APBADIV_Msk = 0x7
	// Divide by 1
	PM_APBASEL_APBADIV_DIV1 = 0x0
	// Divide by 2
	PM_APBASEL_APBADIV_DIV2 = 0x1
	// Divide by 4
	PM_APBASEL_APBADIV_DIV4 = 0x2
	// Divide by 8
	PM_APBASEL_APBADIV_DIV8 = 0x3
	// Divide by 16
	PM_APBASEL_APBADIV_DIV16 = 0x4
	// Divide by 32
	PM_APBASEL_APBADIV_DIV32 = 0x5
	// Divide by 64
	PM_APBASEL_APBADIV_DIV64 = 0x6
	// Divide by 128
	PM_APBASEL_APBADIV_DIV128 = 0x7

	// APBBSEL: APBB Clock Select
	// Position of APBBDIV field.
	PM_APBBSEL_APBBDIV_Pos = 0x0
	// Bit mask of APBBDIV field.
	PM_APBBSEL_APBBDIV_Msk = 0x7
	// Divide by 1
	PM_APBBSEL_APBBDIV_DIV1 = 0x0
	// Divide by 2
	PM_APBBSEL_APBBDIV_DIV2 = 0x1
	// Divide by 4
	PM_APBBSEL_APBBDIV_DIV4 = 0x2
	// Divide by 8
	PM_APBBSEL_APBBDIV_DIV8 = 0x3
	// Divide by 16
	PM_APBBSEL_APBBDIV_DIV16 = 0x4
	// Divide by 32
	PM_APBBSEL_APBBDIV_DIV32 = 0x5
	// Divide by 64
	PM_APBBSEL_APBBDIV_DIV64 = 0x6
	// Divide by 128
	PM_APBBSEL_APBBDIV_DIV128 = 0x7

	// APBCSEL: APBC Clock Select
	// Position of APBCDIV field.
	PM_APBCSEL_APBCDIV_Pos = 0x0
	// Bit mask of APBCDIV field.
	PM_APBCSEL_APBCDIV_Msk = 0x7
	// Divide by 1
	PM_APBCSEL_APBCDIV_DIV1 = 0x0
	// Divide by 2
	PM_APBCSEL_APBCDIV_DIV2 = 0x1
	// Divide by 4
	PM_APBCSEL_APBCDIV_DIV4 = 0x2
	// Divide by 8
	PM_APBCSEL_APBCDIV_DIV8 = 0x3
	// Divide by 16
	PM_APBCSEL_APBCDIV_DIV16 = 0x4
	// Divide by 32
	PM_APBCSEL_APBCDIV_DIV32 = 0x5
	// Divide by 64
	PM_APBCSEL_APBCDIV_DIV64 = 0x6
	// Divide by 128
	PM_APBCSEL_APBCDIV_DIV128 = 0x7

	// AHBMASK: AHB Mask
	// Position of HPB0_ field.
	PM_AHBMASK_HPB0__Pos = 0x0
	// Bit mask of HPB0_ field.
	PM_AHBMASK_HPB0__Msk = 0x1
	// Bit HPB0_.
	PM_AHBMASK_HPB0_ = 0x1
	// Position of HPB1_ field.
	PM_AHBMASK_HPB1__Pos = 0x1
	// Bit mask of HPB1_ field.
	PM_AHBMASK_HPB1__Msk = 0x2
	// Bit HPB1_.
	PM_AHBMASK_HPB1_ = 0x2
	// Position of HPB2_ field.
	PM_AHBMASK_HPB2__Pos = 0x2
	// Bit mask of HPB2_ field.
	PM_AHBMASK_HPB2__Msk = 0x4
	// Bit HPB2_.
	PM_AHBMASK_HPB2_ = 0x4
	// Position of DSU_ field.
	PM_AHBMASK_DSU__Pos = 0x3
	// Bit mask of DSU_ field.
	PM_AHBMASK_DSU__Msk = 0x8
	// Bit DSU_.
	PM_AHBMASK_DSU_ = 0x8
	// Position of NVMCTRL_ field.
	PM_AHBMASK_NVMCTRL__Pos = 0x4
	// Bit mask of NVMCTRL_ field.
	PM_AHBMASK_NVMCTRL__Msk = 0x10
	// Bit NVMCTRL_.
	PM_AHBMASK_NVMCTRL_ = 0x10
	// Position of DMAC_ field.
	PM_AHBMASK_DMAC__Pos = 0x5
	// Bit mask of DMAC_ field.
	PM_AHBMASK_DMAC__Msk = 0x20
	// Bit DMAC_.
	PM_AHBMASK_DMAC_ = 0x20
	// Position of USB_ field.
	PM_AHBMASK_USB__Pos = 0x6
	// Bit mask of USB_ field.
	PM_AHBMASK_USB__Msk = 0x40
	// Bit USB_.
	PM_AHBMASK_USB_ = 0x40

	// APBAMASK: APBA Mask
	// Position of PAC0_ field.
	PM_APBAMASK_PAC0__Pos = 0x0
	// Bit mask of PAC0_ field.
	PM_APBAMASK_PAC0__Msk = 0x1
	// Bit PAC0_.
	PM_APBAMASK_PAC0_ = 0x1
	// Position of PM_ field.
	PM_APBAMASK_PM__Pos = 0x1
	// Bit mask of PM_ field.
	PM_APBAMASK_PM__Msk = 0x2
	// Bit PM_.
	PM_APBAMASK_PM_ = 0x2
	// Position of SYSCTRL_ field.
	PM_APBAMASK_SYSCTRL__Pos = 0x2
	// Bit mask of SYSCTRL_ field.
	PM_APBAMASK_SYSCTRL__Msk = 0x4
	// Bit SYSCTRL_.
	PM_APBAMASK_SYSCTRL_ = 0x4
	// Position of GCLK_ field.
	PM_APBAMASK_GCLK__Pos = 0x3
	// Bit mask of GCLK_ field.
	PM_APBAMASK_GCLK__Msk = 0x8
	// Bit GCLK_.
	PM_APBAMASK_GCLK_ = 0x8
	// Position of WDT_ field.
	PM_APBAMASK_WDT__Pos = 0x4
	// Bit mask of WDT_ field.
	PM_APBAMASK_WDT__Msk = 0x10
	// Bit WDT_.
	PM_APBAMASK_WDT_ = 0x10
	// Position of RTC_ field.
	PM_APBAMASK_RTC__Pos = 0x5
	// Bit mask of RTC_ field.
	PM_APBAMASK_RTC__Msk = 0x20
	// Bit RTC_.
	PM_APBAMASK_RTC_ = 0x20
	// Position of EIC_ field.
	PM_APBAMASK_EIC__Pos = 0x6
	// Bit mask of EIC_ field.
	PM_APBAMASK_EIC__Msk = 0x40
	// Bit EIC_.
	PM_APBAMASK_EIC_ = 0x40

	// APBBMASK: APBB Mask
	// Position of PAC1_ field.
	PM_APBBMASK_PAC1__Pos = 0x0
	// Bit mask of PAC1_ field.
	PM_APBBMASK_PAC1__Msk = 0x1
	// Bit PAC1_.
	PM_APBBMASK_PAC1_ = 0x1
	// Position of DSU_ field.
	PM_APBBMASK_DSU__Pos = 0x1
	// Bit mask of DSU_ field.
	PM_APBBMASK_DSU__Msk = 0x2
	// Bit DSU_.
	PM_APBBMASK_DSU_ = 0x2
	// Position of NVMCTRL_ field.
	PM_APBBMASK_NVMCTRL__Pos = 0x2
	// Bit mask of NVMCTRL_ field.
	PM_APBBMASK_NVMCTRL__Msk = 0x4
	// Bit NVMCTRL_.
	PM_APBBMASK_NVMCTRL_ = 0x4
	// Position of PORT_ field.
	PM_APBBMASK_PORT__Pos = 0x3
	// Bit mask of PORT_ field.
	PM_APBBMASK_PORT__Msk = 0x8
	// Bit PORT_.
	PM_APBBMASK_PORT_ = 0x8
	// Position of DMAC_ field.
	PM_APBBMASK_DMAC__Pos = 0x4
	// Bit mask of DMAC_ field.
	PM_APBBMASK_DMAC__Msk = 0x10
	// Bit DMAC_.
	PM_APBBMASK_DMAC_ = 0x10
	// Position of USB_ field.
	PM_APBBMASK_USB__Pos = 0x5
	// Bit mask of USB_ field.
	PM_APBBMASK_USB__Msk = 0x20
	// Bit USB_.
	PM_APBBMASK_USB_ = 0x20
	// Position of HMATRIX_ field.
	PM_APBBMASK_HMATRIX__Pos = 0x6
	// Bit mask of HMATRIX_ field.
	PM_APBBMASK_HMATRIX__Msk = 0x40
	// Bit HMATRIX_.
	PM_APBBMASK_HMATRIX_ = 0x40

	// APBCMASK: APBC Mask
	// Position of PAC2_ field.
	PM_APBCMASK_PAC2__Pos = 0x0
	// Bit mask of PAC2_ field.
	PM_APBCMASK_PAC2__Msk = 0x1
	// Bit PAC2_.
	PM_APBCMASK_PAC2_ = 0x1
	// Position of EVSYS_ field.
	PM_APBCMASK_EVSYS__Pos = 0x1
	// Bit mask of EVSYS_ field.
	PM_APBCMASK_EVSYS__Msk = 0x2
	// Bit EVSYS_.
	PM_APBCMASK_EVSYS_ = 0x2
	// Position of SERCOM0_ field.
	PM_APBCMASK_SERCOM0__Pos = 0x2
	// Bit mask of SERCOM0_ field.
	PM_APBCMASK_SERCOM0__Msk = 0x4
	// Bit SERCOM0_.
	PM_APBCMASK_SERCOM0_ = 0x4
	// Position of SERCOM1_ field.
	PM_APBCMASK_SERCOM1__Pos = 0x3
	// Bit mask of SERCOM1_ field.
	PM_APBCMASK_SERCOM1__Msk = 0x8
	// Bit SERCOM1_.
	PM_APBCMASK_SERCOM1_ = 0x8
	// Position of SERCOM2_ field.
	PM_APBCMASK_SERCOM2__Pos = 0x4
	// Bit mask of SERCOM2_ field.
	PM_APBCMASK_SERCOM2__Msk = 0x10
	// Bit SERCOM2_.
	PM_APBCMASK_SERCOM2_ = 0x10
	// Position of SERCOM3_ field.
	PM_APBCMASK_SERCOM3__Pos = 0x5
	// Bit mask of SERCOM3_ field.
	PM_APBCMASK_SERCOM3__Msk = 0x20
	// Bit SERCOM3_.
	PM_APBCMASK_SERCOM3_ = 0x20
	// Position of TCC0_ field.
	PM_APBCMASK_TCC0__Pos = 0x8
	// Bit mask of TCC0_ field.
	PM_APBCMASK_TCC0__Msk = 0x100
	// Bit TCC0_.
	PM_APBCMASK_TCC0_ = 0x100
	// Position of TCC1_ field.
	PM_APBCMASK_TCC1__Pos = 0x9
	// Bit mask of TCC1_ field.
	PM_APBCMASK_TCC1__Msk = 0x200
	// Bit TCC1_.
	PM_APBCMASK_TCC1_ = 0x200
	// Position of TCC2_ field.
	PM_APBCMASK_TCC2__Pos = 0xa
	// Bit mask of TCC2_ field.
	PM_APBCMASK_TCC2__Msk = 0x400
	// Bit TCC2_.
	PM_APBCMASK_TCC2_ = 0x400
	// Position of TC3_ field.
	PM_APBCMASK_TC3__Pos = 0xb
	// Bit mask of TC3_ field.
	PM_APBCMASK_TC3__Msk = 0x800
	// Bit TC3_.
	PM_APBCMASK_TC3_ = 0x800
	// Position of TC4_ field.
	PM_APBCMASK_TC4__Pos = 0xc
	// Bit mask of TC4_ field.
	PM_APBCMASK_TC4__Msk = 0x1000
	// Bit TC4_.
	PM_APBCMASK_TC4_ = 0x1000
	// Position of TC5_ field.
	PM_APBCMASK_TC5__Pos = 0xd
	// Bit mask of TC5_ field.
	PM_APBCMASK_TC5__Msk = 0x2000
	// Bit TC5_.
	PM_APBCMASK_TC5_ = 0x2000
	// Position of ADC_ field.
	PM_APBCMASK_ADC__Pos = 0x10
	// Bit mask of ADC_ field.
	PM_APBCMASK_ADC__Msk = 0x10000
	// Bit ADC_.
	PM_APBCMASK_ADC_ = 0x10000
	// Position of AC_ field.
	PM_APBCMASK_AC__Pos = 0x11
	// Bit mask of AC_ field.
	PM_APBCMASK_AC__Msk = 0x20000
	// Bit AC_.
	PM_APBCMASK_AC_ = 0x20000
	// Position of DAC_ field.
	PM_APBCMASK_DAC__Pos = 0x12
	// Bit mask of DAC_ field.
	PM_APBCMASK_DAC__Msk = 0x40000
	// Bit DAC_.
	PM_APBCMASK_DAC_ = 0x40000
	// Position of PTC_ field.
	PM_APBCMASK_PTC__Pos = 0x13
	// Bit mask of PTC_ field.
	PM_APBCMASK_PTC__Msk = 0x80000
	// Bit PTC_.
	PM_APBCMASK_PTC_ = 0x80000
	// Position of I2S_ field.
	PM_APBCMASK_I2S__Pos = 0x14
	// Bit mask of I2S_ field.
	PM_APBCMASK_I2S__Msk = 0x100000
	// Bit I2S_.
	PM_APBCMASK_I2S_ = 0x100000

	// INTENCLR: Interrupt Enable Clear
	// Position of CKRDY field.
	PM_INTENCLR_CKRDY_Pos = 0x0
	// Bit mask of CKRDY field.
	PM_INTENCLR_CKRDY_Msk = 0x1
	// Bit CKRDY.
	PM_INTENCLR_CKRDY = 0x1

	// INTENSET: Interrupt Enable Set
	// Position of CKRDY field.
	PM_INTENSET_CKRDY_Pos = 0x0
	// Bit mask of CKRDY field.
	PM_INTENSET_CKRDY_Msk = 0x1
	// Bit CKRDY.
	PM_INTENSET_CKRDY = 0x1

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of CKRDY field.
	PM_INTFLAG_CKRDY_Pos = 0x0
	// Bit mask of CKRDY field.
	PM_INTFLAG_CKRDY_Msk = 0x1
	// Bit CKRDY.
	PM_INTFLAG_CKRDY = 0x1

	// RCAUSE: Reset Cause
	// Position of POR field.
	PM_RCAUSE_POR_Pos = 0x0
	// Bit mask of POR field.
	PM_RCAUSE_POR_Msk = 0x1
	// Bit POR.
	PM_RCAUSE_POR = 0x1
	// Position of BOD12 field.
	PM_RCAUSE_BOD12_Pos = 0x1
	// Bit mask of BOD12 field.
	PM_RCAUSE_BOD12_Msk = 0x2
	// Bit BOD12.
	PM_RCAUSE_BOD12 = 0x2
	// Position of BOD33 field.
	PM_RCAUSE_BOD33_Pos = 0x2
	// Bit mask of BOD33 field.
	PM_RCAUSE_BOD33_Msk = 0x4
	// Bit BOD33.
	PM_RCAUSE_BOD33 = 0x4
	// Position of EXT field.
	PM_RCAUSE_EXT_Pos = 0x4
	// Bit mask of EXT field.
	PM_RCAUSE_EXT_Msk = 0x10
	// Bit EXT.
	PM_RCAUSE_EXT = 0x10
	// Position of WDT field.
	PM_RCAUSE_WDT_Pos = 0x5
	// Bit mask of WDT field.
	PM_RCAUSE_WDT_Msk = 0x20
	// Bit WDT.
	PM_RCAUSE_WDT = 0x20
	// Position of SYST field.
	PM_RCAUSE_SYST_Pos = 0x6
	// Bit mask of SYST field.
	PM_RCAUSE_SYST_Msk = 0x40
	// Bit SYST.
	PM_RCAUSE_SYST = 0x40
)

// Constants for PORT: Port Module
const (
	// DIR0: Data Direction
	// Position of DIR field.
	PORT_DIR_DIR_Pos = 0x0
	// Bit mask of DIR field.
	PORT_DIR_DIR_Msk = 0xffffffff

	// DIRCLR0: Data Direction Clear
	// Position of DIRCLR field.
	PORT_DIRCLR_DIRCLR_Pos = 0x0
	// Bit mask of DIRCLR field.
	PORT_DIRCLR_DIRCLR_Msk = 0xffffffff

	// DIRSET0: Data Direction Set
	// Position of DIRSET field.
	PORT_DIRSET_DIRSET_Pos = 0x0
	// Bit mask of DIRSET field.
	PORT_DIRSET_DIRSET_Msk = 0xffffffff

	// DIRTGL0: Data Direction Toggle
	// Position of DIRTGL field.
	PORT_DIRTGL_DIRTGL_Pos = 0x0
	// Bit mask of DIRTGL field.
	PORT_DIRTGL_DIRTGL_Msk = 0xffffffff

	// OUT0: Data Output Value
	// Position of OUT field.
	PORT_OUT_OUT_Pos = 0x0
	// Bit mask of OUT field.
	PORT_OUT_OUT_Msk = 0xffffffff

	// OUTCLR0: Data Output Value Clear
	// Position of OUTCLR field.
	PORT_OUTCLR_OUTCLR_Pos = 0x0
	// Bit mask of OUTCLR field.
	PORT_OUTCLR_OUTCLR_Msk = 0xffffffff

	// OUTSET0: Data Output Value Set
	// Position of OUTSET field.
	PORT_OUTSET_OUTSET_Pos = 0x0
	// Bit mask of OUTSET field.
	PORT_OUTSET_OUTSET_Msk = 0xffffffff

	// OUTTGL0: Data Output Value Toggle
	// Position of OUTTGL field.
	PORT_OUTTGL_OUTTGL_Pos = 0x0
	// Bit mask of OUTTGL field.
	PORT_OUTTGL_OUTTGL_Msk = 0xffffffff

	// IN0: Data Input Value
	// Position of IN field.
	PORT_IN_IN_Pos = 0x0
	// Bit mask of IN field.
	PORT_IN_IN_Msk = 0xffffffff

	// CTRL0: Control
	// Position of SAMPLING field.
	PORT_CTRL_SAMPLING_Pos = 0x0
	// Bit mask of SAMPLING field.
	PORT_CTRL_SAMPLING_Msk = 0xffffffff

	// WRCONFIG0: Write Configuration
	// Position of PINMASK field.
	PORT_WRCONFIG_PINMASK_Pos = 0x0
	// Bit mask of PINMASK field.
	PORT_WRCONFIG_PINMASK_Msk = 0xffff
	// Position of PMUXEN field.
	PORT_WRCONFIG_PMUXEN_Pos = 0x10
	// Bit mask of PMUXEN field.
	PORT_WRCONFIG_PMUXEN_Msk = 0x10000
	// Bit PMUXEN.
	PORT_WRCONFIG_PMUXEN = 0x10000
	// Position of INEN field.
	PORT_WRCONFIG_INEN_Pos = 0x11
	// Bit mask of INEN field.
	PORT_WRCONFIG_INEN_Msk = 0x20000
	// Bit INEN.
	PORT_WRCONFIG_INEN = 0x20000
	// Position of PULLEN field.
	PORT_WRCONFIG_PULLEN_Pos = 0x12
	// Bit mask of PULLEN field.
	PORT_WRCONFIG_PULLEN_Msk = 0x40000
	// Bit PULLEN.
	PORT_WRCONFIG_PULLEN = 0x40000
	// Position of DRVSTR field.
	PORT_WRCONFIG_DRVSTR_Pos = 0x16
	// Bit mask of DRVSTR field.
	PORT_WRCONFIG_DRVSTR_Msk = 0x400000
	// Bit DRVSTR.
	PORT_WRCONFIG_DRVSTR = 0x400000
	// Position of PMUX field.
	PORT_WRCONFIG_PMUX_Pos = 0x18
	// Bit mask of PMUX field.
	PORT_WRCONFIG_PMUX_Msk = 0xf000000
	// Position of WRPMUX field.
	PORT_WRCONFIG_WRPMUX_Pos = 0x1c
	// Bit mask of WRPMUX field.
	PORT_WRCONFIG_WRPMUX_Msk = 0x10000000
	// Bit WRPMUX.
	PORT_WRCONFIG_WRPMUX = 0x10000000
	// Position of WRPINCFG field.
	PORT_WRCONFIG_WRPINCFG_Pos = 0x1e
	// Bit mask of WRPINCFG field.
	PORT_WRCONFIG_WRPINCFG_Msk = 0x40000000
	// Bit WRPINCFG.
	PORT_WRCONFIG_WRPINCFG = 0x40000000
	// Position of HWSEL field.
	PORT_WRCONFIG_HWSEL_Pos = 0x1f
	// Bit mask of HWSEL field.
	PORT_WRCONFIG_HWSEL_Msk = 0x80000000
	// Bit HWSEL.
	PORT_WRCONFIG_HWSEL = 0x80000000

	// PMUX0_0: Peripheral Multiplexing n - Group 0
	// Position of PMUXE field.
	PORT_PMUX0_PMUXE_Pos = 0x0
	// Bit mask of PMUXE field.
	PORT_PMUX0_PMUXE_Msk = 0xf
	// Peripheral function A selected
	PORT_PMUX0_PMUXE_A = 0x0
	// Peripheral function B selected
	PORT_PMUX0_PMUXE_B = 0x1
	// Peripheral function C selected
	PORT_PMUX0_PMUXE_C = 0x2
	// Peripheral function D selected
	PORT_PMUX0_PMUXE_D = 0x3
	// Peripheral function E selected
	PORT_PMUX0_PMUXE_E = 0x4
	// Peripheral function F selected
	PORT_PMUX0_PMUXE_F = 0x5
	// Peripheral function G selected
	PORT_PMUX0_PMUXE_G = 0x6
	// Peripheral function H selected
	PORT_PMUX0_PMUXE_H = 0x7
	// Position of PMUXO field.
	PORT_PMUX0_PMUXO_Pos = 0x4
	// Bit mask of PMUXO field.
	PORT_PMUX0_PMUXO_Msk = 0xf0
	// Peripheral function A selected
	PORT_PMUX0_PMUXO_A = 0x0
	// Peripheral function B selected
	PORT_PMUX0_PMUXO_B = 0x1
	// Peripheral function C selected
	PORT_PMUX0_PMUXO_C = 0x2
	// Peripheral function D selected
	PORT_PMUX0_PMUXO_D = 0x3
	// Peripheral function E selected
	PORT_PMUX0_PMUXO_E = 0x4
	// Peripheral function F selected
	PORT_PMUX0_PMUXO_F = 0x5
	// Peripheral function G selected
	PORT_PMUX0_PMUXO_G = 0x6
	// Peripheral function H selected
	PORT_PMUX0_PMUXO_H = 0x7

	// PINCFG0_0: Pin Configuration n - Group 0
	// Position of PMUXEN field.
	PORT_PINCFG0_PMUXEN_Pos = 0x0
	// Bit mask of PMUXEN field.
	PORT_PINCFG0_PMUXEN_Msk = 0x1
	// Bit PMUXEN.
	PORT_PINCFG0_PMUXEN = 0x1
	// Position of INEN field.
	PORT_PINCFG0_INEN_Pos = 0x1
	// Bit mask of INEN field.
	PORT_PINCFG0_INEN_Msk = 0x2
	// Bit INEN.
	PORT_PINCFG0_INEN = 0x2
	// Position of PULLEN field.
	PORT_PINCFG0_PULLEN_Pos = 0x2
	// Bit mask of PULLEN field.
	PORT_PINCFG0_PULLEN_Msk = 0x4
	// Bit PULLEN.
	PORT_PINCFG0_PULLEN = 0x4
	// Position of DRVSTR field.
	PORT_PINCFG0_DRVSTR_Pos = 0x6
	// Bit mask of DRVSTR field.
	PORT_PINCFG0_DRVSTR_Msk = 0x40
	// Bit DRVSTR.
	PORT_PINCFG0_DRVSTR = 0x40
)

// Constants for RTC: Real-Time Counter
const ()

// Constants for RTC_MODE0: Real-Time Counter - MODE0
const (
	// CTRL: MODE0 Control
	// Position of SWRST field.
	RTC_MODE0_CTRL_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	RTC_MODE0_CTRL_SWRST_Msk = 0x1
	// Bit SWRST.
	RTC_MODE0_CTRL_SWRST = 0x1
	// Position of ENABLE field.
	RTC_MODE0_CTRL_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	RTC_MODE0_CTRL_ENABLE_Msk = 0x2
	// Bit ENABLE.
	RTC_MODE0_CTRL_ENABLE = 0x2
	// Position of MODE field.
	RTC_MODE0_CTRL_MODE_Pos = 0x2
	// Bit mask of MODE field.
	RTC_MODE0_CTRL_MODE_Msk = 0xc
	// Mode 0: 32-bit Counter
	RTC_MODE0_CTRL_MODE_COUNT32 = 0x0
	// Mode 1: 16-bit Counter
	RTC_MODE0_CTRL_MODE_COUNT16 = 0x1
	// Mode 2: Clock/Calendar
	RTC_MODE0_CTRL_MODE_CLOCK = 0x2
	// Position of MATCHCLR field.
	RTC_MODE0_CTRL_MATCHCLR_Pos = 0x7
	// Bit mask of MATCHCLR field.
	RTC_MODE0_CTRL_MATCHCLR_Msk = 0x80
	// Bit MATCHCLR.
	RTC_MODE0_CTRL_MATCHCLR = 0x80
	// Position of PRESCALER field.
	RTC_MODE0_CTRL_PRESCALER_Pos = 0x8
	// Bit mask of PRESCALER field.
	RTC_MODE0_CTRL_PRESCALER_Msk = 0xf00
	// CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE0_CTRL_PRESCALER_DIV1 = 0x0
	// CLK_RTC_CNT = GCLK_RTC/2
	RTC_MODE0_CTRL_PRESCALER_DIV2 = 0x1
	// CLK_RTC_CNT = GCLK_RTC/4
	RTC_MODE0_CTRL_PRESCALER_DIV4 = 0x2
	// CLK_RTC_CNT = GCLK_RTC/8
	RTC_MODE0_CTRL_PRESCALER_DIV8 = 0x3
	// CLK_RTC_CNT = GCLK_RTC/16
	RTC_MODE0_CTRL_PRESCALER_DIV16 = 0x4
	// CLK_RTC_CNT = GCLK_RTC/32
	RTC_MODE0_CTRL_PRESCALER_DIV32 = 0x5
	// CLK_RTC_CNT = GCLK_RTC/64
	RTC_MODE0_CTRL_PRESCALER_DIV64 = 0x6
	// CLK_RTC_CNT = GCLK_RTC/128
	RTC_MODE0_CTRL_PRESCALER_DIV128 = 0x7
	// CLK_RTC_CNT = GCLK_RTC/256
	RTC_MODE0_CTRL_PRESCALER_DIV256 = 0x8
	// CLK_RTC_CNT = GCLK_RTC/512
	RTC_MODE0_CTRL_PRESCALER_DIV512 = 0x9
	// CLK_RTC_CNT = GCLK_RTC/1024
	RTC_MODE0_CTRL_PRESCALER_DIV1024 = 0xa

	// READREQ: Read Request
	// Position of ADDR field.
	RTC_MODE0_READREQ_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	RTC_MODE0_READREQ_ADDR_Msk = 0x3f
	// Position of RCONT field.
	RTC_MODE0_READREQ_RCONT_Pos = 0xe
	// Bit mask of RCONT field.
	RTC_MODE0_READREQ_RCONT_Msk = 0x4000
	// Bit RCONT.
	RTC_MODE0_READREQ_RCONT = 0x4000
	// Position of RREQ field.
	RTC_MODE0_READREQ_RREQ_Pos = 0xf
	// Bit mask of RREQ field.
	RTC_MODE0_READREQ_RREQ_Msk = 0x8000
	// Bit RREQ.
	RTC_MODE0_READREQ_RREQ = 0x8000

	// EVCTRL: MODE0 Event Control
	// Position of PEREO0 field.
	RTC_MODE0_EVCTRL_PEREO0_Pos = 0x0
	// Bit mask of PEREO0 field.
	RTC_MODE0_EVCTRL_PEREO0_Msk = 0x1
	// Bit PEREO0.
	RTC_MODE0_EVCTRL_PEREO0 = 0x1
	// Position of PEREO1 field.
	RTC_MODE0_EVCTRL_PEREO1_Pos = 0x1
	// Bit mask of PEREO1 field.
	RTC_MODE0_EVCTRL_PEREO1_Msk = 0x2
	// Bit PEREO1.
	RTC_MODE0_EVCTRL_PEREO1 = 0x2
	// Position of PEREO2 field.
	RTC_MODE0_EVCTRL_PEREO2_Pos = 0x2
	// Bit mask of PEREO2 field.
	RTC_MODE0_EVCTRL_PEREO2_Msk = 0x4
	// Bit PEREO2.
	RTC_MODE0_EVCTRL_PEREO2 = 0x4
	// Position of PEREO3 field.
	RTC_MODE0_EVCTRL_PEREO3_Pos = 0x3
	// Bit mask of PEREO3 field.
	RTC_MODE0_EVCTRL_PEREO3_Msk = 0x8
	// Bit PEREO3.
	RTC_MODE0_EVCTRL_PEREO3 = 0x8
	// Position of PEREO4 field.
	RTC_MODE0_EVCTRL_PEREO4_Pos = 0x4
	// Bit mask of PEREO4 field.
	RTC_MODE0_EVCTRL_PEREO4_Msk = 0x10
	// Bit PEREO4.
	RTC_MODE0_EVCTRL_PEREO4 = 0x10
	// Position of PEREO5 field.
	RTC_MODE0_EVCTRL_PEREO5_Pos = 0x5
	// Bit mask of PEREO5 field.
	RTC_MODE0_EVCTRL_PEREO5_Msk = 0x20
	// Bit PEREO5.
	RTC_MODE0_EVCTRL_PEREO5 = 0x20
	// Position of PEREO6 field.
	RTC_MODE0_EVCTRL_PEREO6_Pos = 0x6
	// Bit mask of PEREO6 field.
	RTC_MODE0_EVCTRL_PEREO6_Msk = 0x40
	// Bit PEREO6.
	RTC_MODE0_EVCTRL_PEREO6 = 0x40
	// Position of PEREO7 field.
	RTC_MODE0_EVCTRL_PEREO7_Pos = 0x7
	// Bit mask of PEREO7 field.
	RTC_MODE0_EVCTRL_PEREO7_Msk = 0x80
	// Bit PEREO7.
	RTC_MODE0_EVCTRL_PEREO7 = 0x80
	// Position of CMPEO0 field.
	RTC_MODE0_EVCTRL_CMPEO0_Pos = 0x8
	// Bit mask of CMPEO0 field.
	RTC_MODE0_EVCTRL_CMPEO0_Msk = 0x100
	// Bit CMPEO0.
	RTC_MODE0_EVCTRL_CMPEO0 = 0x100
	// Position of OVFEO field.
	RTC_MODE0_EVCTRL_OVFEO_Pos = 0xf
	// Bit mask of OVFEO field.
	RTC_MODE0_EVCTRL_OVFEO_Msk = 0x8000
	// Bit OVFEO.
	RTC_MODE0_EVCTRL_OVFEO = 0x8000

	// INTENCLR: MODE0 Interrupt Enable Clear
	// Position of CMP0 field.
	RTC_MODE0_INTENCLR_CMP0_Pos = 0x0
	// Bit mask of CMP0 field.
	RTC_MODE0_INTENCLR_CMP0_Msk = 0x1
	// Bit CMP0.
	RTC_MODE0_INTENCLR_CMP0 = 0x1
	// Position of SYNCRDY field.
	RTC_MODE0_INTENCLR_SYNCRDY_Pos = 0x6
	// Bit mask of SYNCRDY field.
	RTC_MODE0_INTENCLR_SYNCRDY_Msk = 0x40
	// Bit SYNCRDY.
	RTC_MODE0_INTENCLR_SYNCRDY = 0x40
	// Position of OVF field.
	RTC_MODE0_INTENCLR_OVF_Pos = 0x7
	// Bit mask of OVF field.
	RTC_MODE0_INTENCLR_OVF_Msk = 0x80
	// Bit OVF.
	RTC_MODE0_INTENCLR_OVF = 0x80

	// INTENSET: MODE0 Interrupt Enable Set
	// Position of CMP0 field.
	RTC_MODE0_INTENSET_CMP0_Pos = 0x0
	// Bit mask of CMP0 field.
	RTC_MODE0_INTENSET_CMP0_Msk = 0x1
	// Bit CMP0.
	RTC_MODE0_INTENSET_CMP0 = 0x1
	// Position of SYNCRDY field.
	RTC_MODE0_INTENSET_SYNCRDY_Pos = 0x6
	// Bit mask of SYNCRDY field.
	RTC_MODE0_INTENSET_SYNCRDY_Msk = 0x40
	// Bit SYNCRDY.
	RTC_MODE0_INTENSET_SYNCRDY = 0x40
	// Position of OVF field.
	RTC_MODE0_INTENSET_OVF_Pos = 0x7
	// Bit mask of OVF field.
	RTC_MODE0_INTENSET_OVF_Msk = 0x80
	// Bit OVF.
	RTC_MODE0_INTENSET_OVF = 0x80

	// INTFLAG: MODE0 Interrupt Flag Status and Clear
	// Position of CMP0 field.
	RTC_MODE0_INTFLAG_CMP0_Pos = 0x0
	// Bit mask of CMP0 field.
	RTC_MODE0_INTFLAG_CMP0_Msk = 0x1
	// Bit CMP0.
	RTC_MODE0_INTFLAG_CMP0 = 0x1
	// Position of SYNCRDY field.
	RTC_MODE0_INTFLAG_SYNCRDY_Pos = 0x6
	// Bit mask of SYNCRDY field.
	RTC_MODE0_INTFLAG_SYNCRDY_Msk = 0x40
	// Bit SYNCRDY.
	RTC_MODE0_INTFLAG_SYNCRDY = 0x40
	// Position of OVF field.
	RTC_MODE0_INTFLAG_OVF_Pos = 0x7
	// Bit mask of OVF field.
	RTC_MODE0_INTFLAG_OVF_Msk = 0x80
	// Bit OVF.
	RTC_MODE0_INTFLAG_OVF = 0x80

	// STATUS: Status
	// Position of SYNCBUSY field.
	RTC_MODE0_STATUS_SYNCBUSY_Pos = 0x7
	// Bit mask of SYNCBUSY field.
	RTC_MODE0_STATUS_SYNCBUSY_Msk = 0x80
	// Bit SYNCBUSY.
	RTC_MODE0_STATUS_SYNCBUSY = 0x80

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	RTC_MODE0_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	RTC_MODE0_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	RTC_MODE0_DBGCTRL_DBGRUN = 0x1

	// FREQCORR: Frequency Correction
	// Position of VALUE field.
	RTC_MODE0_FREQCORR_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	RTC_MODE0_FREQCORR_VALUE_Msk = 0x7f
	// Position of SIGN field.
	RTC_MODE0_FREQCORR_SIGN_Pos = 0x7
	// Bit mask of SIGN field.
	RTC_MODE0_FREQCORR_SIGN_Msk = 0x80
	// Bit SIGN.
	RTC_MODE0_FREQCORR_SIGN = 0x80

	// COUNT: MODE0 Counter Value
	// Position of COUNT field.
	RTC_MODE0_COUNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	RTC_MODE0_COUNT_COUNT_Msk = 0xffffffff

	// COMP0: MODE0 Compare n Value
	// Position of COMP field.
	RTC_MODE0_COMP_COMP_Pos = 0x0
	// Bit mask of COMP field.
	RTC_MODE0_COMP_COMP_Msk = 0xffffffff
)

// Constants for RTC_MODE1: Real-Time Counter - MODE1
const (
	// CTRL: MODE1 Control
	// Position of SWRST field.
	RTC_MODE1_CTRL_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	RTC_MODE1_CTRL_SWRST_Msk = 0x1
	// Bit SWRST.
	RTC_MODE1_CTRL_SWRST = 0x1
	// Position of ENABLE field.
	RTC_MODE1_CTRL_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	RTC_MODE1_CTRL_ENABLE_Msk = 0x2
	// Bit ENABLE.
	RTC_MODE1_CTRL_ENABLE = 0x2
	// Position of MODE field.
	RTC_MODE1_CTRL_MODE_Pos = 0x2
	// Bit mask of MODE field.
	RTC_MODE1_CTRL_MODE_Msk = 0xc
	// Mode 0: 32-bit Counter
	RTC_MODE1_CTRL_MODE_COUNT32 = 0x0
	// Mode 1: 16-bit Counter
	RTC_MODE1_CTRL_MODE_COUNT16 = 0x1
	// Mode 2: Clock/Calendar
	RTC_MODE1_CTRL_MODE_CLOCK = 0x2
	// Position of PRESCALER field.
	RTC_MODE1_CTRL_PRESCALER_Pos = 0x8
	// Bit mask of PRESCALER field.
	RTC_MODE1_CTRL_PRESCALER_Msk = 0xf00
	// CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE1_CTRL_PRESCALER_DIV1 = 0x0
	// CLK_RTC_CNT = GCLK_RTC/2
	RTC_MODE1_CTRL_PRESCALER_DIV2 = 0x1
	// CLK_RTC_CNT = GCLK_RTC/4
	RTC_MODE1_CTRL_PRESCALER_DIV4 = 0x2
	// CLK_RTC_CNT = GCLK_RTC/8
	RTC_MODE1_CTRL_PRESCALER_DIV8 = 0x3
	// CLK_RTC_CNT = GCLK_RTC/16
	RTC_MODE1_CTRL_PRESCALER_DIV16 = 0x4
	// CLK_RTC_CNT = GCLK_RTC/32
	RTC_MODE1_CTRL_PRESCALER_DIV32 = 0x5
	// CLK_RTC_CNT = GCLK_RTC/64
	RTC_MODE1_CTRL_PRESCALER_DIV64 = 0x6
	// CLK_RTC_CNT = GCLK_RTC/128
	RTC_MODE1_CTRL_PRESCALER_DIV128 = 0x7
	// CLK_RTC_CNT = GCLK_RTC/256
	RTC_MODE1_CTRL_PRESCALER_DIV256 = 0x8
	// CLK_RTC_CNT = GCLK_RTC/512
	RTC_MODE1_CTRL_PRESCALER_DIV512 = 0x9
	// CLK_RTC_CNT = GCLK_RTC/1024
	RTC_MODE1_CTRL_PRESCALER_DIV1024 = 0xa

	// READREQ: Read Request
	// Position of ADDR field.
	RTC_MODE1_READREQ_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	RTC_MODE1_READREQ_ADDR_Msk = 0x3f
	// Position of RCONT field.
	RTC_MODE1_READREQ_RCONT_Pos = 0xe
	// Bit mask of RCONT field.
	RTC_MODE1_READREQ_RCONT_Msk = 0x4000
	// Bit RCONT.
	RTC_MODE1_READREQ_RCONT = 0x4000
	// Position of RREQ field.
	RTC_MODE1_READREQ_RREQ_Pos = 0xf
	// Bit mask of RREQ field.
	RTC_MODE1_READREQ_RREQ_Msk = 0x8000
	// Bit RREQ.
	RTC_MODE1_READREQ_RREQ = 0x8000

	// EVCTRL: MODE1 Event Control
	// Position of PEREO0 field.
	RTC_MODE1_EVCTRL_PEREO0_Pos = 0x0
	// Bit mask of PEREO0 field.
	RTC_MODE1_EVCTRL_PEREO0_Msk = 0x1
	// Bit PEREO0.
	RTC_MODE1_EVCTRL_PEREO0 = 0x1
	// Position of PEREO1 field.
	RTC_MODE1_EVCTRL_PEREO1_Pos = 0x1
	// Bit mask of PEREO1 field.
	RTC_MODE1_EVCTRL_PEREO1_Msk = 0x2
	// Bit PEREO1.
	RTC_MODE1_EVCTRL_PEREO1 = 0x2
	// Position of PEREO2 field.
	RTC_MODE1_EVCTRL_PEREO2_Pos = 0x2
	// Bit mask of PEREO2 field.
	RTC_MODE1_EVCTRL_PEREO2_Msk = 0x4
	// Bit PEREO2.
	RTC_MODE1_EVCTRL_PEREO2 = 0x4
	// Position of PEREO3 field.
	RTC_MODE1_EVCTRL_PEREO3_Pos = 0x3
	// Bit mask of PEREO3 field.
	RTC_MODE1_EVCTRL_PEREO3_Msk = 0x8
	// Bit PEREO3.
	RTC_MODE1_EVCTRL_PEREO3 = 0x8
	// Position of PEREO4 field.
	RTC_MODE1_EVCTRL_PEREO4_Pos = 0x4
	// Bit mask of PEREO4 field.
	RTC_MODE1_EVCTRL_PEREO4_Msk = 0x10
	// Bit PEREO4.
	RTC_MODE1_EVCTRL_PEREO4 = 0x10
	// Position of PEREO5 field.
	RTC_MODE1_EVCTRL_PEREO5_Pos = 0x5
	// Bit mask of PEREO5 field.
	RTC_MODE1_EVCTRL_PEREO5_Msk = 0x20
	// Bit PEREO5.
	RTC_MODE1_EVCTRL_PEREO5 = 0x20
	// Position of PEREO6 field.
	RTC_MODE1_EVCTRL_PEREO6_Pos = 0x6
	// Bit mask of PEREO6 field.
	RTC_MODE1_EVCTRL_PEREO6_Msk = 0x40
	// Bit PEREO6.
	RTC_MODE1_EVCTRL_PEREO6 = 0x40
	// Position of PEREO7 field.
	RTC_MODE1_EVCTRL_PEREO7_Pos = 0x7
	// Bit mask of PEREO7 field.
	RTC_MODE1_EVCTRL_PEREO7_Msk = 0x80
	// Bit PEREO7.
	RTC_MODE1_EVCTRL_PEREO7 = 0x80
	// Position of CMPEO0 field.
	RTC_MODE1_EVCTRL_CMPEO0_Pos = 0x8
	// Bit mask of CMPEO0 field.
	RTC_MODE1_EVCTRL_CMPEO0_Msk = 0x100
	// Bit CMPEO0.
	RTC_MODE1_EVCTRL_CMPEO0 = 0x100
	// Position of CMPEO1 field.
	RTC_MODE1_EVCTRL_CMPEO1_Pos = 0x9
	// Bit mask of CMPEO1 field.
	RTC_MODE1_EVCTRL_CMPEO1_Msk = 0x200
	// Bit CMPEO1.
	RTC_MODE1_EVCTRL_CMPEO1 = 0x200
	// Position of OVFEO field.
	RTC_MODE1_EVCTRL_OVFEO_Pos = 0xf
	// Bit mask of OVFEO field.
	RTC_MODE1_EVCTRL_OVFEO_Msk = 0x8000
	// Bit OVFEO.
	RTC_MODE1_EVCTRL_OVFEO = 0x8000

	// INTENCLR: MODE1 Interrupt Enable Clear
	// Position of CMP0 field.
	RTC_MODE1_INTENCLR_CMP0_Pos = 0x0
	// Bit mask of CMP0 field.
	RTC_MODE1_INTENCLR_CMP0_Msk = 0x1
	// Bit CMP0.
	RTC_MODE1_INTENCLR_CMP0 = 0x1
	// Position of CMP1 field.
	RTC_MODE1_INTENCLR_CMP1_Pos = 0x1
	// Bit mask of CMP1 field.
	RTC_MODE1_INTENCLR_CMP1_Msk = 0x2
	// Bit CMP1.
	RTC_MODE1_INTENCLR_CMP1 = 0x2
	// Position of SYNCRDY field.
	RTC_MODE1_INTENCLR_SYNCRDY_Pos = 0x6
	// Bit mask of SYNCRDY field.
	RTC_MODE1_INTENCLR_SYNCRDY_Msk = 0x40
	// Bit SYNCRDY.
	RTC_MODE1_INTENCLR_SYNCRDY = 0x40
	// Position of OVF field.
	RTC_MODE1_INTENCLR_OVF_Pos = 0x7
	// Bit mask of OVF field.
	RTC_MODE1_INTENCLR_OVF_Msk = 0x80
	// Bit OVF.
	RTC_MODE1_INTENCLR_OVF = 0x80

	// INTENSET: MODE1 Interrupt Enable Set
	// Position of CMP0 field.
	RTC_MODE1_INTENSET_CMP0_Pos = 0x0
	// Bit mask of CMP0 field.
	RTC_MODE1_INTENSET_CMP0_Msk = 0x1
	// Bit CMP0.
	RTC_MODE1_INTENSET_CMP0 = 0x1
	// Position of CMP1 field.
	RTC_MODE1_INTENSET_CMP1_Pos = 0x1
	// Bit mask of CMP1 field.
	RTC_MODE1_INTENSET_CMP1_Msk = 0x2
	// Bit CMP1.
	RTC_MODE1_INTENSET_CMP1 = 0x2
	// Position of SYNCRDY field.
	RTC_MODE1_INTENSET_SYNCRDY_Pos = 0x6
	// Bit mask of SYNCRDY field.
	RTC_MODE1_INTENSET_SYNCRDY_Msk = 0x40
	// Bit SYNCRDY.
	RTC_MODE1_INTENSET_SYNCRDY = 0x40
	// Position of OVF field.
	RTC_MODE1_INTENSET_OVF_Pos = 0x7
	// Bit mask of OVF field.
	RTC_MODE1_INTENSET_OVF_Msk = 0x80
	// Bit OVF.
	RTC_MODE1_INTENSET_OVF = 0x80

	// INTFLAG: MODE1 Interrupt Flag Status and Clear
	// Position of CMP0 field.
	RTC_MODE1_INTFLAG_CMP0_Pos = 0x0
	// Bit mask of CMP0 field.
	RTC_MODE1_INTFLAG_CMP0_Msk = 0x1
	// Bit CMP0.
	RTC_MODE1_INTFLAG_CMP0 = 0x1
	// Position of CMP1 field.
	RTC_MODE1_INTFLAG_CMP1_Pos = 0x1
	// Bit mask of CMP1 field.
	RTC_MODE1_INTFLAG_CMP1_Msk = 0x2
	// Bit CMP1.
	RTC_MODE1_INTFLAG_CMP1 = 0x2
	// Position of SYNCRDY field.
	RTC_MODE1_INTFLAG_SYNCRDY_Pos = 0x6
	// Bit mask of SYNCRDY field.
	RTC_MODE1_INTFLAG_SYNCRDY_Msk = 0x40
	// Bit SYNCRDY.
	RTC_MODE1_INTFLAG_SYNCRDY = 0x40
	// Position of OVF field.
	RTC_MODE1_INTFLAG_OVF_Pos = 0x7
	// Bit mask of OVF field.
	RTC_MODE1_INTFLAG_OVF_Msk = 0x80
	// Bit OVF.
	RTC_MODE1_INTFLAG_OVF = 0x80

	// STATUS: Status
	// Position of SYNCBUSY field.
	RTC_MODE1_STATUS_SYNCBUSY_Pos = 0x7
	// Bit mask of SYNCBUSY field.
	RTC_MODE1_STATUS_SYNCBUSY_Msk = 0x80
	// Bit SYNCBUSY.
	RTC_MODE1_STATUS_SYNCBUSY = 0x80

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	RTC_MODE1_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	RTC_MODE1_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	RTC_MODE1_DBGCTRL_DBGRUN = 0x1

	// FREQCORR: Frequency Correction
	// Position of VALUE field.
	RTC_MODE1_FREQCORR_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	RTC_MODE1_FREQCORR_VALUE_Msk = 0x7f
	// Position of SIGN field.
	RTC_MODE1_FREQCORR_SIGN_Pos = 0x7
	// Bit mask of SIGN field.
	RTC_MODE1_FREQCORR_SIGN_Msk = 0x80
	// Bit SIGN.
	RTC_MODE1_FREQCORR_SIGN = 0x80

	// COUNT: MODE1 Counter Value
	// Position of COUNT field.
	RTC_MODE1_COUNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	RTC_MODE1_COUNT_COUNT_Msk = 0xffff

	// PER: MODE1 Counter Period
	// Position of PER field.
	RTC_MODE1_PER_PER_Pos = 0x0
	// Bit mask of PER field.
	RTC_MODE1_PER_PER_Msk = 0xffff

	// COMP0: MODE1 Compare n Value
	// Position of COMP field.
	RTC_MODE1_COMP_COMP_Pos = 0x0
	// Bit mask of COMP field.
	RTC_MODE1_COMP_COMP_Msk = 0xffff
)

// Constants for RTC_MODE2: Real-Time Counter - MODE2
const (
	// CTRL: MODE2 Control
	// Position of SWRST field.
	RTC_MODE2_CTRL_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	RTC_MODE2_CTRL_SWRST_Msk = 0x1
	// Bit SWRST.
	RTC_MODE2_CTRL_SWRST = 0x1
	// Position of ENABLE field.
	RTC_MODE2_CTRL_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	RTC_MODE2_CTRL_ENABLE_Msk = 0x2
	// Bit ENABLE.
	RTC_MODE2_CTRL_ENABLE = 0x2
	// Position of MODE field.
	RTC_MODE2_CTRL_MODE_Pos = 0x2
	// Bit mask of MODE field.
	RTC_MODE2_CTRL_MODE_Msk = 0xc
	// Mode 0: 32-bit Counter
	RTC_MODE2_CTRL_MODE_COUNT32 = 0x0
	// Mode 1: 16-bit Counter
	RTC_MODE2_CTRL_MODE_COUNT16 = 0x1
	// Mode 2: Clock/Calendar
	RTC_MODE2_CTRL_MODE_CLOCK = 0x2
	// Position of CLKREP field.
	RTC_MODE2_CTRL_CLKREP_Pos = 0x6
	// Bit mask of CLKREP field.
	RTC_MODE2_CTRL_CLKREP_Msk = 0x40
	// Bit CLKREP.
	RTC_MODE2_CTRL_CLKREP = 0x40
	// Position of MATCHCLR field.
	RTC_MODE2_CTRL_MATCHCLR_Pos = 0x7
	// Bit mask of MATCHCLR field.
	RTC_MODE2_CTRL_MATCHCLR_Msk = 0x80
	// Bit MATCHCLR.
	RTC_MODE2_CTRL_MATCHCLR = 0x80
	// Position of PRESCALER field.
	RTC_MODE2_CTRL_PRESCALER_Pos = 0x8
	// Bit mask of PRESCALER field.
	RTC_MODE2_CTRL_PRESCALER_Msk = 0xf00
	// CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE2_CTRL_PRESCALER_DIV1 = 0x0
	// CLK_RTC_CNT = GCLK_RTC/2
	RTC_MODE2_CTRL_PRESCALER_DIV2 = 0x1
	// CLK_RTC_CNT = GCLK_RTC/4
	RTC_MODE2_CTRL_PRESCALER_DIV4 = 0x2
	// CLK_RTC_CNT = GCLK_RTC/8
	RTC_MODE2_CTRL_PRESCALER_DIV8 = 0x3
	// CLK_RTC_CNT = GCLK_RTC/16
	RTC_MODE2_CTRL_PRESCALER_DIV16 = 0x4
	// CLK_RTC_CNT = GCLK_RTC/32
	RTC_MODE2_CTRL_PRESCALER_DIV32 = 0x5
	// CLK_RTC_CNT = GCLK_RTC/64
	RTC_MODE2_CTRL_PRESCALER_DIV64 = 0x6
	// CLK_RTC_CNT = GCLK_RTC/128
	RTC_MODE2_CTRL_PRESCALER_DIV128 = 0x7
	// CLK_RTC_CNT = GCLK_RTC/256
	RTC_MODE2_CTRL_PRESCALER_DIV256 = 0x8
	// CLK_RTC_CNT = GCLK_RTC/512
	RTC_MODE2_CTRL_PRESCALER_DIV512 = 0x9
	// CLK_RTC_CNT = GCLK_RTC/1024
	RTC_MODE2_CTRL_PRESCALER_DIV1024 = 0xa

	// READREQ: Read Request
	// Position of ADDR field.
	RTC_MODE2_READREQ_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	RTC_MODE2_READREQ_ADDR_Msk = 0x3f
	// Position of RCONT field.
	RTC_MODE2_READREQ_RCONT_Pos = 0xe
	// Bit mask of RCONT field.
	RTC_MODE2_READREQ_RCONT_Msk = 0x4000
	// Bit RCONT.
	RTC_MODE2_READREQ_RCONT = 0x4000
	// Position of RREQ field.
	RTC_MODE2_READREQ_RREQ_Pos = 0xf
	// Bit mask of RREQ field.
	RTC_MODE2_READREQ_RREQ_Msk = 0x8000
	// Bit RREQ.
	RTC_MODE2_READREQ_RREQ = 0x8000

	// EVCTRL: MODE2 Event Control
	// Position of PEREO0 field.
	RTC_MODE2_EVCTRL_PEREO0_Pos = 0x0
	// Bit mask of PEREO0 field.
	RTC_MODE2_EVCTRL_PEREO0_Msk = 0x1
	// Bit PEREO0.
	RTC_MODE2_EVCTRL_PEREO0 = 0x1
	// Position of PEREO1 field.
	RTC_MODE2_EVCTRL_PEREO1_Pos = 0x1
	// Bit mask of PEREO1 field.
	RTC_MODE2_EVCTRL_PEREO1_Msk = 0x2
	// Bit PEREO1.
	RTC_MODE2_EVCTRL_PEREO1 = 0x2
	// Position of PEREO2 field.
	RTC_MODE2_EVCTRL_PEREO2_Pos = 0x2
	// Bit mask of PEREO2 field.
	RTC_MODE2_EVCTRL_PEREO2_Msk = 0x4
	// Bit PEREO2.
	RTC_MODE2_EVCTRL_PEREO2 = 0x4
	// Position of PEREO3 field.
	RTC_MODE2_EVCTRL_PEREO3_Pos = 0x3
	// Bit mask of PEREO3 field.
	RTC_MODE2_EVCTRL_PEREO3_Msk = 0x8
	// Bit PEREO3.
	RTC_MODE2_EVCTRL_PEREO3 = 0x8
	// Position of PEREO4 field.
	RTC_MODE2_EVCTRL_PEREO4_Pos = 0x4
	// Bit mask of PEREO4 field.
	RTC_MODE2_EVCTRL_PEREO4_Msk = 0x10
	// Bit PEREO4.
	RTC_MODE2_EVCTRL_PEREO4 = 0x10
	// Position of PEREO5 field.
	RTC_MODE2_EVCTRL_PEREO5_Pos = 0x5
	// Bit mask of PEREO5 field.
	RTC_MODE2_EVCTRL_PEREO5_Msk = 0x20
	// Bit PEREO5.
	RTC_MODE2_EVCTRL_PEREO5 = 0x20
	// Position of PEREO6 field.
	RTC_MODE2_EVCTRL_PEREO6_Pos = 0x6
	// Bit mask of PEREO6 field.
	RTC_MODE2_EVCTRL_PEREO6_Msk = 0x40
	// Bit PEREO6.
	RTC_MODE2_EVCTRL_PEREO6 = 0x40
	// Position of PEREO7 field.
	RTC_MODE2_EVCTRL_PEREO7_Pos = 0x7
	// Bit mask of PEREO7 field.
	RTC_MODE2_EVCTRL_PEREO7_Msk = 0x80
	// Bit PEREO7.
	RTC_MODE2_EVCTRL_PEREO7 = 0x80
	// Position of ALARMEO0 field.
	RTC_MODE2_EVCTRL_ALARMEO0_Pos = 0x8
	// Bit mask of ALARMEO0 field.
	RTC_MODE2_EVCTRL_ALARMEO0_Msk = 0x100
	// Bit ALARMEO0.
	RTC_MODE2_EVCTRL_ALARMEO0 = 0x100
	// Position of OVFEO field.
	RTC_MODE2_EVCTRL_OVFEO_Pos = 0xf
	// Bit mask of OVFEO field.
	RTC_MODE2_EVCTRL_OVFEO_Msk = 0x8000
	// Bit OVFEO.
	RTC_MODE2_EVCTRL_OVFEO = 0x8000

	// INTENCLR: MODE2 Interrupt Enable Clear
	// Position of ALARM0 field.
	RTC_MODE2_INTENCLR_ALARM0_Pos = 0x0
	// Bit mask of ALARM0 field.
	RTC_MODE2_INTENCLR_ALARM0_Msk = 0x1
	// Bit ALARM0.
	RTC_MODE2_INTENCLR_ALARM0 = 0x1
	// Position of SYNCRDY field.
	RTC_MODE2_INTENCLR_SYNCRDY_Pos = 0x6
	// Bit mask of SYNCRDY field.
	RTC_MODE2_INTENCLR_SYNCRDY_Msk = 0x40
	// Bit SYNCRDY.
	RTC_MODE2_INTENCLR_SYNCRDY = 0x40
	// Position of OVF field.
	RTC_MODE2_INTENCLR_OVF_Pos = 0x7
	// Bit mask of OVF field.
	RTC_MODE2_INTENCLR_OVF_Msk = 0x80
	// Bit OVF.
	RTC_MODE2_INTENCLR_OVF = 0x80

	// INTENSET: MODE2 Interrupt Enable Set
	// Position of ALARM0 field.
	RTC_MODE2_INTENSET_ALARM0_Pos = 0x0
	// Bit mask of ALARM0 field.
	RTC_MODE2_INTENSET_ALARM0_Msk = 0x1
	// Bit ALARM0.
	RTC_MODE2_INTENSET_ALARM0 = 0x1
	// Position of SYNCRDY field.
	RTC_MODE2_INTENSET_SYNCRDY_Pos = 0x6
	// Bit mask of SYNCRDY field.
	RTC_MODE2_INTENSET_SYNCRDY_Msk = 0x40
	// Bit SYNCRDY.
	RTC_MODE2_INTENSET_SYNCRDY = 0x40
	// Position of OVF field.
	RTC_MODE2_INTENSET_OVF_Pos = 0x7
	// Bit mask of OVF field.
	RTC_MODE2_INTENSET_OVF_Msk = 0x80
	// Bit OVF.
	RTC_MODE2_INTENSET_OVF = 0x80

	// INTFLAG: MODE2 Interrupt Flag Status and Clear
	// Position of ALARM0 field.
	RTC_MODE2_INTFLAG_ALARM0_Pos = 0x0
	// Bit mask of ALARM0 field.
	RTC_MODE2_INTFLAG_ALARM0_Msk = 0x1
	// Bit ALARM0.
	RTC_MODE2_INTFLAG_ALARM0 = 0x1
	// Position of SYNCRDY field.
	RTC_MODE2_INTFLAG_SYNCRDY_Pos = 0x6
	// Bit mask of SYNCRDY field.
	RTC_MODE2_INTFLAG_SYNCRDY_Msk = 0x40
	// Bit SYNCRDY.
	RTC_MODE2_INTFLAG_SYNCRDY = 0x40
	// Position of OVF field.
	RTC_MODE2_INTFLAG_OVF_Pos = 0x7
	// Bit mask of OVF field.
	RTC_MODE2_INTFLAG_OVF_Msk = 0x80
	// Bit OVF.
	RTC_MODE2_INTFLAG_OVF = 0x80

	// STATUS: Status
	// Position of SYNCBUSY field.
	RTC_MODE2_STATUS_SYNCBUSY_Pos = 0x7
	// Bit mask of SYNCBUSY field.
	RTC_MODE2_STATUS_SYNCBUSY_Msk = 0x80
	// Bit SYNCBUSY.
	RTC_MODE2_STATUS_SYNCBUSY = 0x80

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	RTC_MODE2_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	RTC_MODE2_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	RTC_MODE2_DBGCTRL_DBGRUN = 0x1

	// FREQCORR: Frequency Correction
	// Position of VALUE field.
	RTC_MODE2_FREQCORR_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	RTC_MODE2_FREQCORR_VALUE_Msk = 0x7f
	// Position of SIGN field.
	RTC_MODE2_FREQCORR_SIGN_Pos = 0x7
	// Bit mask of SIGN field.
	RTC_MODE2_FREQCORR_SIGN_Msk = 0x80
	// Bit SIGN.
	RTC_MODE2_FREQCORR_SIGN = 0x80

	// CLOCK: MODE2 Clock Value
	// Position of SECOND field.
	RTC_MODE2_CLOCK_SECOND_Pos = 0x0
	// Bit mask of SECOND field.
	RTC_MODE2_CLOCK_SECOND_Msk = 0x3f
	// Position of MINUTE field.
	RTC_MODE2_CLOCK_MINUTE_Pos = 0x6
	// Bit mask of MINUTE field.
	RTC_MODE2_CLOCK_MINUTE_Msk = 0xfc0
	// Position of HOUR field.
	RTC_MODE2_CLOCK_HOUR_Pos = 0xc
	// Bit mask of HOUR field.
	RTC_MODE2_CLOCK_HOUR_Msk = 0x1f000
	// AM when CLKREP in 12-hour
	RTC_MODE2_CLOCK_HOUR_AM = 0x0
	// PM when CLKREP in 12-hour
	RTC_MODE2_CLOCK_HOUR_PM = 0x10
	// Position of DAY field.
	RTC_MODE2_CLOCK_DAY_Pos = 0x11
	// Bit mask of DAY field.
	RTC_MODE2_CLOCK_DAY_Msk = 0x3e0000
	// Position of MONTH field.
	RTC_MODE2_CLOCK_MONTH_Pos = 0x16
	// Bit mask of MONTH field.
	RTC_MODE2_CLOCK_MONTH_Msk = 0x3c00000
	// Position of YEAR field.
	RTC_MODE2_CLOCK_YEAR_Pos = 0x1a
	// Bit mask of YEAR field.
	RTC_MODE2_CLOCK_YEAR_Msk = 0xfc000000

	// ALARM0: MODE2 Alarm n Value
	// Position of SECOND field.
	RTC_MODE2_ALARM_SECOND_Pos = 0x0
	// Bit mask of SECOND field.
	RTC_MODE2_ALARM_SECOND_Msk = 0x3f
	// Position of MINUTE field.
	RTC_MODE2_ALARM_MINUTE_Pos = 0x6
	// Bit mask of MINUTE field.
	RTC_MODE2_ALARM_MINUTE_Msk = 0xfc0
	// Position of HOUR field.
	RTC_MODE2_ALARM_HOUR_Pos = 0xc
	// Bit mask of HOUR field.
	RTC_MODE2_ALARM_HOUR_Msk = 0x1f000
	// Morning hour
	RTC_MODE2_ALARM_HOUR_AM = 0x0
	// Afternoon hour
	RTC_MODE2_ALARM_HOUR_PM = 0x10
	// Position of DAY field.
	RTC_MODE2_ALARM_DAY_Pos = 0x11
	// Bit mask of DAY field.
	RTC_MODE2_ALARM_DAY_Msk = 0x3e0000
	// Position of MONTH field.
	RTC_MODE2_ALARM_MONTH_Pos = 0x16
	// Bit mask of MONTH field.
	RTC_MODE2_ALARM_MONTH_Msk = 0x3c00000
	// Position of YEAR field.
	RTC_MODE2_ALARM_YEAR_Pos = 0x1a
	// Bit mask of YEAR field.
	RTC_MODE2_ALARM_YEAR_Msk = 0xfc000000

	// MASK0: MODE2 Alarm n Mask
	// Position of SEL field.
	RTC_MODE2_MASK_SEL_Pos = 0x0
	// Bit mask of SEL field.
	RTC_MODE2_MASK_SEL_Msk = 0x7
	// Alarm Disabled
	RTC_MODE2_MASK_SEL_OFF = 0x0
	// Match seconds only
	RTC_MODE2_MASK_SEL_SS = 0x1
	// Match seconds and minutes only
	RTC_MODE2_MASK_SEL_MMSS = 0x2
	// Match seconds, minutes, and hours only
	RTC_MODE2_MASK_SEL_HHMMSS = 0x3
	// Match seconds, minutes, hours, and days only
	RTC_MODE2_MASK_SEL_DDHHMMSS = 0x4
	// Match seconds, minutes, hours, days, and months only
	RTC_MODE2_MASK_SEL_MMDDHHMMSS = 0x5
	// Match seconds, minutes, hours, days, months, and years
	RTC_MODE2_MASK_SEL_YYMMDDHHMMSS = 0x6
)

// Constants for SERCOM0: Serial Communication Interface 0
const ()

// Constants for SERCOM0_I2CM: Serial Communication Interface 0 - I2CM
const (
	// CTRLA: I2CM Control A
	// Position of SWRST field.
	SERCOM_I2CM_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	SERCOM_I2CM_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	SERCOM_I2CM_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	SERCOM_I2CM_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SERCOM_I2CM_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SERCOM_I2CM_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	SERCOM_I2CM_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	SERCOM_I2CM_CTRLA_MODE_Msk = 0x1c
	// USART mode with external clock
	SERCOM_I2CM_CTRLA_MODE_USART_EXT_CLK = 0x0
	// USART mode with internal clock
	SERCOM_I2CM_CTRLA_MODE_USART_INT_CLK = 0x1
	// SPI mode with external clock
	SERCOM_I2CM_CTRLA_MODE_SPI_SLAVE = 0x2
	// SPI mode with internal clock
	SERCOM_I2CM_CTRLA_MODE_SPI_MASTER = 0x3
	// I2C mode with external clock
	SERCOM_I2CM_CTRLA_MODE_I2C_SLAVE = 0x4
	// I2C mode with internal clock
	SERCOM_I2CM_CTRLA_MODE_I2C_MASTER = 0x5
	// Position of RUNSTDBY field.
	SERCOM_I2CM_CTRLA_RUNSTDBY_Pos = 0x7
	// Bit mask of RUNSTDBY field.
	SERCOM_I2CM_CTRLA_RUNSTDBY_Msk = 0x80
	// Bit RUNSTDBY.
	SERCOM_I2CM_CTRLA_RUNSTDBY = 0x80
	// Position of PINOUT field.
	SERCOM_I2CM_CTRLA_PINOUT_Pos = 0x10
	// Bit mask of PINOUT field.
	SERCOM_I2CM_CTRLA_PINOUT_Msk = 0x10000
	// Bit PINOUT.
	SERCOM_I2CM_CTRLA_PINOUT = 0x10000
	// Position of SDAHOLD field.
	SERCOM_I2CM_CTRLA_SDAHOLD_Pos = 0x14
	// Bit mask of SDAHOLD field.
	SERCOM_I2CM_CTRLA_SDAHOLD_Msk = 0x300000
	// Position of MEXTTOEN field.
	SERCOM_I2CM_CTRLA_MEXTTOEN_Pos = 0x16
	// Bit mask of MEXTTOEN field.
	SERCOM_I2CM_CTRLA_MEXTTOEN_Msk = 0x400000
	// Bit MEXTTOEN.
	SERCOM_I2CM_CTRLA_MEXTTOEN = 0x400000
	// Position of SEXTTOEN field.
	SERCOM_I2CM_CTRLA_SEXTTOEN_Pos = 0x17
	// Bit mask of SEXTTOEN field.
	SERCOM_I2CM_CTRLA_SEXTTOEN_Msk = 0x800000
	// Bit SEXTTOEN.
	SERCOM_I2CM_CTRLA_SEXTTOEN = 0x800000
	// Position of SPEED field.
	SERCOM_I2CM_CTRLA_SPEED_Pos = 0x18
	// Bit mask of SPEED field.
	SERCOM_I2CM_CTRLA_SPEED_Msk = 0x3000000
	// Position of SCLSM field.
	SERCOM_I2CM_CTRLA_SCLSM_Pos = 0x1b
	// Bit mask of SCLSM field.
	SERCOM_I2CM_CTRLA_SCLSM_Msk = 0x8000000
	// Bit SCLSM.
	SERCOM_I2CM_CTRLA_SCLSM = 0x8000000
	// Position of INACTOUT field.
	SERCOM_I2CM_CTRLA_INACTOUT_Pos = 0x1c
	// Bit mask of INACTOUT field.
	SERCOM_I2CM_CTRLA_INACTOUT_Msk = 0x30000000
	// Position of LOWTOUTEN field.
	SERCOM_I2CM_CTRLA_LOWTOUTEN_Pos = 0x1e
	// Bit mask of LOWTOUTEN field.
	SERCOM_I2CM_CTRLA_LOWTOUTEN_Msk = 0x40000000
	// Bit LOWTOUTEN.
	SERCOM_I2CM_CTRLA_LOWTOUTEN = 0x40000000

	// CTRLB: I2CM Control B
	// Position of SMEN field.
	SERCOM_I2CM_CTRLB_SMEN_Pos = 0x8
	// Bit mask of SMEN field.
	SERCOM_I2CM_CTRLB_SMEN_Msk = 0x100
	// Bit SMEN.
	SERCOM_I2CM_CTRLB_SMEN = 0x100
	// Position of QCEN field.
	SERCOM_I2CM_CTRLB_QCEN_Pos = 0x9
	// Bit mask of QCEN field.
	SERCOM_I2CM_CTRLB_QCEN_Msk = 0x200
	// Bit QCEN.
	SERCOM_I2CM_CTRLB_QCEN = 0x200
	// Position of CMD field.
	SERCOM_I2CM_CTRLB_CMD_Pos = 0x10
	// Bit mask of CMD field.
	SERCOM_I2CM_CTRLB_CMD_Msk = 0x30000
	// Position of ACKACT field.
	SERCOM_I2CM_CTRLB_ACKACT_Pos = 0x12
	// Bit mask of ACKACT field.
	SERCOM_I2CM_CTRLB_ACKACT_Msk = 0x40000
	// Bit ACKACT.
	SERCOM_I2CM_CTRLB_ACKACT = 0x40000

	// BAUD: I2CM Baud Rate
	// Position of BAUD field.
	SERCOM_I2CM_BAUD_BAUD_Pos = 0x0
	// Bit mask of BAUD field.
	SERCOM_I2CM_BAUD_BAUD_Msk = 0xff
	// Position of BAUDLOW field.
	SERCOM_I2CM_BAUD_BAUDLOW_Pos = 0x8
	// Bit mask of BAUDLOW field.
	SERCOM_I2CM_BAUD_BAUDLOW_Msk = 0xff00
	// Position of HSBAUD field.
	SERCOM_I2CM_BAUD_HSBAUD_Pos = 0x10
	// Bit mask of HSBAUD field.
	SERCOM_I2CM_BAUD_HSBAUD_Msk = 0xff0000
	// Position of HSBAUDLOW field.
	SERCOM_I2CM_BAUD_HSBAUDLOW_Pos = 0x18
	// Bit mask of HSBAUDLOW field.
	SERCOM_I2CM_BAUD_HSBAUDLOW_Msk = 0xff000000

	// INTENCLR: I2CM Interrupt Enable Clear
	// Position of MB field.
	SERCOM_I2CM_INTENCLR_MB_Pos = 0x0
	// Bit mask of MB field.
	SERCOM_I2CM_INTENCLR_MB_Msk = 0x1
	// Bit MB.
	SERCOM_I2CM_INTENCLR_MB = 0x1
	// Position of SB field.
	SERCOM_I2CM_INTENCLR_SB_Pos = 0x1
	// Bit mask of SB field.
	SERCOM_I2CM_INTENCLR_SB_Msk = 0x2
	// Bit SB.
	SERCOM_I2CM_INTENCLR_SB = 0x2
	// Position of ERROR field.
	SERCOM_I2CM_INTENCLR_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_I2CM_INTENCLR_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_I2CM_INTENCLR_ERROR = 0x80

	// INTENSET: I2CM Interrupt Enable Set
	// Position of MB field.
	SERCOM_I2CM_INTENSET_MB_Pos = 0x0
	// Bit mask of MB field.
	SERCOM_I2CM_INTENSET_MB_Msk = 0x1
	// Bit MB.
	SERCOM_I2CM_INTENSET_MB = 0x1
	// Position of SB field.
	SERCOM_I2CM_INTENSET_SB_Pos = 0x1
	// Bit mask of SB field.
	SERCOM_I2CM_INTENSET_SB_Msk = 0x2
	// Bit SB.
	SERCOM_I2CM_INTENSET_SB = 0x2
	// Position of ERROR field.
	SERCOM_I2CM_INTENSET_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_I2CM_INTENSET_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_I2CM_INTENSET_ERROR = 0x80

	// INTFLAG: I2CM Interrupt Flag Status and Clear
	// Position of MB field.
	SERCOM_I2CM_INTFLAG_MB_Pos = 0x0
	// Bit mask of MB field.
	SERCOM_I2CM_INTFLAG_MB_Msk = 0x1
	// Bit MB.
	SERCOM_I2CM_INTFLAG_MB = 0x1
	// Position of SB field.
	SERCOM_I2CM_INTFLAG_SB_Pos = 0x1
	// Bit mask of SB field.
	SERCOM_I2CM_INTFLAG_SB_Msk = 0x2
	// Bit SB.
	SERCOM_I2CM_INTFLAG_SB = 0x2
	// Position of ERROR field.
	SERCOM_I2CM_INTFLAG_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_I2CM_INTFLAG_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_I2CM_INTFLAG_ERROR = 0x80

	// STATUS: I2CM Status
	// Position of BUSERR field.
	SERCOM_I2CM_STATUS_BUSERR_Pos = 0x0
	// Bit mask of BUSERR field.
	SERCOM_I2CM_STATUS_BUSERR_Msk = 0x1
	// Bit BUSERR.
	SERCOM_I2CM_STATUS_BUSERR = 0x1
	// Position of ARBLOST field.
	SERCOM_I2CM_STATUS_ARBLOST_Pos = 0x1
	// Bit mask of ARBLOST field.
	SERCOM_I2CM_STATUS_ARBLOST_Msk = 0x2
	// Bit ARBLOST.
	SERCOM_I2CM_STATUS_ARBLOST = 0x2
	// Position of RXNACK field.
	SERCOM_I2CM_STATUS_RXNACK_Pos = 0x2
	// Bit mask of RXNACK field.
	SERCOM_I2CM_STATUS_RXNACK_Msk = 0x4
	// Bit RXNACK.
	SERCOM_I2CM_STATUS_RXNACK = 0x4
	// Position of BUSSTATE field.
	SERCOM_I2CM_STATUS_BUSSTATE_Pos = 0x4
	// Bit mask of BUSSTATE field.
	SERCOM_I2CM_STATUS_BUSSTATE_Msk = 0x30
	// Position of LOWTOUT field.
	SERCOM_I2CM_STATUS_LOWTOUT_Pos = 0x6
	// Bit mask of LOWTOUT field.
	SERCOM_I2CM_STATUS_LOWTOUT_Msk = 0x40
	// Bit LOWTOUT.
	SERCOM_I2CM_STATUS_LOWTOUT = 0x40
	// Position of CLKHOLD field.
	SERCOM_I2CM_STATUS_CLKHOLD_Pos = 0x7
	// Bit mask of CLKHOLD field.
	SERCOM_I2CM_STATUS_CLKHOLD_Msk = 0x80
	// Bit CLKHOLD.
	SERCOM_I2CM_STATUS_CLKHOLD = 0x80
	// Position of MEXTTOUT field.
	SERCOM_I2CM_STATUS_MEXTTOUT_Pos = 0x8
	// Bit mask of MEXTTOUT field.
	SERCOM_I2CM_STATUS_MEXTTOUT_Msk = 0x100
	// Bit MEXTTOUT.
	SERCOM_I2CM_STATUS_MEXTTOUT = 0x100
	// Position of SEXTTOUT field.
	SERCOM_I2CM_STATUS_SEXTTOUT_Pos = 0x9
	// Bit mask of SEXTTOUT field.
	SERCOM_I2CM_STATUS_SEXTTOUT_Msk = 0x200
	// Bit SEXTTOUT.
	SERCOM_I2CM_STATUS_SEXTTOUT = 0x200
	// Position of LENERR field.
	SERCOM_I2CM_STATUS_LENERR_Pos = 0xa
	// Bit mask of LENERR field.
	SERCOM_I2CM_STATUS_LENERR_Msk = 0x400
	// Bit LENERR.
	SERCOM_I2CM_STATUS_LENERR = 0x400

	// SYNCBUSY: I2CM Synchronization Busy
	// Position of SWRST field.
	SERCOM_I2CM_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	SERCOM_I2CM_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	SERCOM_I2CM_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	SERCOM_I2CM_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SERCOM_I2CM_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SERCOM_I2CM_SYNCBUSY_ENABLE = 0x2
	// Position of SYSOP field.
	SERCOM_I2CM_SYNCBUSY_SYSOP_Pos = 0x2
	// Bit mask of SYSOP field.
	SERCOM_I2CM_SYNCBUSY_SYSOP_Msk = 0x4
	// Bit SYSOP.
	SERCOM_I2CM_SYNCBUSY_SYSOP = 0x4

	// ADDR: I2CM Address
	// Position of ADDR field.
	SERCOM_I2CM_ADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	SERCOM_I2CM_ADDR_ADDR_Msk = 0x7ff
	// Position of LENEN field.
	SERCOM_I2CM_ADDR_LENEN_Pos = 0xd
	// Bit mask of LENEN field.
	SERCOM_I2CM_ADDR_LENEN_Msk = 0x2000
	// Bit LENEN.
	SERCOM_I2CM_ADDR_LENEN = 0x2000
	// Position of HS field.
	SERCOM_I2CM_ADDR_HS_Pos = 0xe
	// Bit mask of HS field.
	SERCOM_I2CM_ADDR_HS_Msk = 0x4000
	// Bit HS.
	SERCOM_I2CM_ADDR_HS = 0x4000
	// Position of TENBITEN field.
	SERCOM_I2CM_ADDR_TENBITEN_Pos = 0xf
	// Bit mask of TENBITEN field.
	SERCOM_I2CM_ADDR_TENBITEN_Msk = 0x8000
	// Bit TENBITEN.
	SERCOM_I2CM_ADDR_TENBITEN = 0x8000
	// Position of LEN field.
	SERCOM_I2CM_ADDR_LEN_Pos = 0x10
	// Bit mask of LEN field.
	SERCOM_I2CM_ADDR_LEN_Msk = 0xff0000

	// DATA: I2CM Data
	// Position of DATA field.
	SERCOM_I2CM_DATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SERCOM_I2CM_DATA_DATA_Msk = 0xff

	// DBGCTRL: I2CM Debug Control
	// Position of DBGSTOP field.
	SERCOM_I2CM_DBGCTRL_DBGSTOP_Pos = 0x0
	// Bit mask of DBGSTOP field.
	SERCOM_I2CM_DBGCTRL_DBGSTOP_Msk = 0x1
	// Bit DBGSTOP.
	SERCOM_I2CM_DBGCTRL_DBGSTOP = 0x1
)

// Constants for SERCOM0_I2CS: Serial Communication Interface 0 - I2CS
const (
	// CTRLA: I2CS Control A
	// Position of SWRST field.
	SERCOM_I2CS_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	SERCOM_I2CS_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	SERCOM_I2CS_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	SERCOM_I2CS_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SERCOM_I2CS_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SERCOM_I2CS_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	SERCOM_I2CS_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	SERCOM_I2CS_CTRLA_MODE_Msk = 0x1c
	// USART mode with external clock
	SERCOM_I2CS_CTRLA_MODE_USART_EXT_CLK = 0x0
	// USART mode with internal clock
	SERCOM_I2CS_CTRLA_MODE_USART_INT_CLK = 0x1
	// SPI mode with external clock
	SERCOM_I2CS_CTRLA_MODE_SPI_SLAVE = 0x2
	// SPI mode with internal clock
	SERCOM_I2CS_CTRLA_MODE_SPI_MASTER = 0x3
	// I2C mode with external clock
	SERCOM_I2CS_CTRLA_MODE_I2C_SLAVE = 0x4
	// I2C mode with internal clock
	SERCOM_I2CS_CTRLA_MODE_I2C_MASTER = 0x5
	// Position of RUNSTDBY field.
	SERCOM_I2CS_CTRLA_RUNSTDBY_Pos = 0x7
	// Bit mask of RUNSTDBY field.
	SERCOM_I2CS_CTRLA_RUNSTDBY_Msk = 0x80
	// Bit RUNSTDBY.
	SERCOM_I2CS_CTRLA_RUNSTDBY = 0x80
	// Position of PINOUT field.
	SERCOM_I2CS_CTRLA_PINOUT_Pos = 0x10
	// Bit mask of PINOUT field.
	SERCOM_I2CS_CTRLA_PINOUT_Msk = 0x10000
	// Bit PINOUT.
	SERCOM_I2CS_CTRLA_PINOUT = 0x10000
	// Position of SDAHOLD field.
	SERCOM_I2CS_CTRLA_SDAHOLD_Pos = 0x14
	// Bit mask of SDAHOLD field.
	SERCOM_I2CS_CTRLA_SDAHOLD_Msk = 0x300000
	// Position of SEXTTOEN field.
	SERCOM_I2CS_CTRLA_SEXTTOEN_Pos = 0x17
	// Bit mask of SEXTTOEN field.
	SERCOM_I2CS_CTRLA_SEXTTOEN_Msk = 0x800000
	// Bit SEXTTOEN.
	SERCOM_I2CS_CTRLA_SEXTTOEN = 0x800000
	// Position of SPEED field.
	SERCOM_I2CS_CTRLA_SPEED_Pos = 0x18
	// Bit mask of SPEED field.
	SERCOM_I2CS_CTRLA_SPEED_Msk = 0x3000000
	// Position of SCLSM field.
	SERCOM_I2CS_CTRLA_SCLSM_Pos = 0x1b
	// Bit mask of SCLSM field.
	SERCOM_I2CS_CTRLA_SCLSM_Msk = 0x8000000
	// Bit SCLSM.
	SERCOM_I2CS_CTRLA_SCLSM = 0x8000000
	// Position of LOWTOUTEN field.
	SERCOM_I2CS_CTRLA_LOWTOUTEN_Pos = 0x1e
	// Bit mask of LOWTOUTEN field.
	SERCOM_I2CS_CTRLA_LOWTOUTEN_Msk = 0x40000000
	// Bit LOWTOUTEN.
	SERCOM_I2CS_CTRLA_LOWTOUTEN = 0x40000000

	// CTRLB: I2CS Control B
	// Position of SMEN field.
	SERCOM_I2CS_CTRLB_SMEN_Pos = 0x8
	// Bit mask of SMEN field.
	SERCOM_I2CS_CTRLB_SMEN_Msk = 0x100
	// Bit SMEN.
	SERCOM_I2CS_CTRLB_SMEN = 0x100
	// Position of GCMD field.
	SERCOM_I2CS_CTRLB_GCMD_Pos = 0x9
	// Bit mask of GCMD field.
	SERCOM_I2CS_CTRLB_GCMD_Msk = 0x200
	// Bit GCMD.
	SERCOM_I2CS_CTRLB_GCMD = 0x200
	// Position of AACKEN field.
	SERCOM_I2CS_CTRLB_AACKEN_Pos = 0xa
	// Bit mask of AACKEN field.
	SERCOM_I2CS_CTRLB_AACKEN_Msk = 0x400
	// Bit AACKEN.
	SERCOM_I2CS_CTRLB_AACKEN = 0x400
	// Position of AMODE field.
	SERCOM_I2CS_CTRLB_AMODE_Pos = 0xe
	// Bit mask of AMODE field.
	SERCOM_I2CS_CTRLB_AMODE_Msk = 0xc000
	// Position of CMD field.
	SERCOM_I2CS_CTRLB_CMD_Pos = 0x10
	// Bit mask of CMD field.
	SERCOM_I2CS_CTRLB_CMD_Msk = 0x30000
	// Position of ACKACT field.
	SERCOM_I2CS_CTRLB_ACKACT_Pos = 0x12
	// Bit mask of ACKACT field.
	SERCOM_I2CS_CTRLB_ACKACT_Msk = 0x40000
	// Bit ACKACT.
	SERCOM_I2CS_CTRLB_ACKACT = 0x40000

	// INTENCLR: I2CS Interrupt Enable Clear
	// Position of PREC field.
	SERCOM_I2CS_INTENCLR_PREC_Pos = 0x0
	// Bit mask of PREC field.
	SERCOM_I2CS_INTENCLR_PREC_Msk = 0x1
	// Bit PREC.
	SERCOM_I2CS_INTENCLR_PREC = 0x1
	// Position of AMATCH field.
	SERCOM_I2CS_INTENCLR_AMATCH_Pos = 0x1
	// Bit mask of AMATCH field.
	SERCOM_I2CS_INTENCLR_AMATCH_Msk = 0x2
	// Bit AMATCH.
	SERCOM_I2CS_INTENCLR_AMATCH = 0x2
	// Position of DRDY field.
	SERCOM_I2CS_INTENCLR_DRDY_Pos = 0x2
	// Bit mask of DRDY field.
	SERCOM_I2CS_INTENCLR_DRDY_Msk = 0x4
	// Bit DRDY.
	SERCOM_I2CS_INTENCLR_DRDY = 0x4
	// Position of ERROR field.
	SERCOM_I2CS_INTENCLR_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_I2CS_INTENCLR_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_I2CS_INTENCLR_ERROR = 0x80

	// INTENSET: I2CS Interrupt Enable Set
	// Position of PREC field.
	SERCOM_I2CS_INTENSET_PREC_Pos = 0x0
	// Bit mask of PREC field.
	SERCOM_I2CS_INTENSET_PREC_Msk = 0x1
	// Bit PREC.
	SERCOM_I2CS_INTENSET_PREC = 0x1
	// Position of AMATCH field.
	SERCOM_I2CS_INTENSET_AMATCH_Pos = 0x1
	// Bit mask of AMATCH field.
	SERCOM_I2CS_INTENSET_AMATCH_Msk = 0x2
	// Bit AMATCH.
	SERCOM_I2CS_INTENSET_AMATCH = 0x2
	// Position of DRDY field.
	SERCOM_I2CS_INTENSET_DRDY_Pos = 0x2
	// Bit mask of DRDY field.
	SERCOM_I2CS_INTENSET_DRDY_Msk = 0x4
	// Bit DRDY.
	SERCOM_I2CS_INTENSET_DRDY = 0x4
	// Position of ERROR field.
	SERCOM_I2CS_INTENSET_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_I2CS_INTENSET_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_I2CS_INTENSET_ERROR = 0x80

	// INTFLAG: I2CS Interrupt Flag Status and Clear
	// Position of PREC field.
	SERCOM_I2CS_INTFLAG_PREC_Pos = 0x0
	// Bit mask of PREC field.
	SERCOM_I2CS_INTFLAG_PREC_Msk = 0x1
	// Bit PREC.
	SERCOM_I2CS_INTFLAG_PREC = 0x1
	// Position of AMATCH field.
	SERCOM_I2CS_INTFLAG_AMATCH_Pos = 0x1
	// Bit mask of AMATCH field.
	SERCOM_I2CS_INTFLAG_AMATCH_Msk = 0x2
	// Bit AMATCH.
	SERCOM_I2CS_INTFLAG_AMATCH = 0x2
	// Position of DRDY field.
	SERCOM_I2CS_INTFLAG_DRDY_Pos = 0x2
	// Bit mask of DRDY field.
	SERCOM_I2CS_INTFLAG_DRDY_Msk = 0x4
	// Bit DRDY.
	SERCOM_I2CS_INTFLAG_DRDY = 0x4
	// Position of ERROR field.
	SERCOM_I2CS_INTFLAG_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_I2CS_INTFLAG_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_I2CS_INTFLAG_ERROR = 0x80

	// STATUS: I2CS Status
	// Position of BUSERR field.
	SERCOM_I2CS_STATUS_BUSERR_Pos = 0x0
	// Bit mask of BUSERR field.
	SERCOM_I2CS_STATUS_BUSERR_Msk = 0x1
	// Bit BUSERR.
	SERCOM_I2CS_STATUS_BUSERR = 0x1
	// Position of COLL field.
	SERCOM_I2CS_STATUS_COLL_Pos = 0x1
	// Bit mask of COLL field.
	SERCOM_I2CS_STATUS_COLL_Msk = 0x2
	// Bit COLL.
	SERCOM_I2CS_STATUS_COLL = 0x2
	// Position of RXNACK field.
	SERCOM_I2CS_STATUS_RXNACK_Pos = 0x2
	// Bit mask of RXNACK field.
	SERCOM_I2CS_STATUS_RXNACK_Msk = 0x4
	// Bit RXNACK.
	SERCOM_I2CS_STATUS_RXNACK = 0x4
	// Position of DIR field.
	SERCOM_I2CS_STATUS_DIR_Pos = 0x3
	// Bit mask of DIR field.
	SERCOM_I2CS_STATUS_DIR_Msk = 0x8
	// Bit DIR.
	SERCOM_I2CS_STATUS_DIR = 0x8
	// Position of SR field.
	SERCOM_I2CS_STATUS_SR_Pos = 0x4
	// Bit mask of SR field.
	SERCOM_I2CS_STATUS_SR_Msk = 0x10
	// Bit SR.
	SERCOM_I2CS_STATUS_SR = 0x10
	// Position of LOWTOUT field.
	SERCOM_I2CS_STATUS_LOWTOUT_Pos = 0x6
	// Bit mask of LOWTOUT field.
	SERCOM_I2CS_STATUS_LOWTOUT_Msk = 0x40
	// Bit LOWTOUT.
	SERCOM_I2CS_STATUS_LOWTOUT = 0x40
	// Position of CLKHOLD field.
	SERCOM_I2CS_STATUS_CLKHOLD_Pos = 0x7
	// Bit mask of CLKHOLD field.
	SERCOM_I2CS_STATUS_CLKHOLD_Msk = 0x80
	// Bit CLKHOLD.
	SERCOM_I2CS_STATUS_CLKHOLD = 0x80
	// Position of SEXTTOUT field.
	SERCOM_I2CS_STATUS_SEXTTOUT_Pos = 0x9
	// Bit mask of SEXTTOUT field.
	SERCOM_I2CS_STATUS_SEXTTOUT_Msk = 0x200
	// Bit SEXTTOUT.
	SERCOM_I2CS_STATUS_SEXTTOUT = 0x200
	// Position of HS field.
	SERCOM_I2CS_STATUS_HS_Pos = 0xa
	// Bit mask of HS field.
	SERCOM_I2CS_STATUS_HS_Msk = 0x400
	// Bit HS.
	SERCOM_I2CS_STATUS_HS = 0x400

	// SYNCBUSY: I2CS Synchronization Busy
	// Position of SWRST field.
	SERCOM_I2CS_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	SERCOM_I2CS_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	SERCOM_I2CS_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	SERCOM_I2CS_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SERCOM_I2CS_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SERCOM_I2CS_SYNCBUSY_ENABLE = 0x2

	// ADDR: I2CS Address
	// Position of GENCEN field.
	SERCOM_I2CS_ADDR_GENCEN_Pos = 0x0
	// Bit mask of GENCEN field.
	SERCOM_I2CS_ADDR_GENCEN_Msk = 0x1
	// Bit GENCEN.
	SERCOM_I2CS_ADDR_GENCEN = 0x1
	// Position of ADDR field.
	SERCOM_I2CS_ADDR_ADDR_Pos = 0x1
	// Bit mask of ADDR field.
	SERCOM_I2CS_ADDR_ADDR_Msk = 0x7fe
	// Position of TENBITEN field.
	SERCOM_I2CS_ADDR_TENBITEN_Pos = 0xf
	// Bit mask of TENBITEN field.
	SERCOM_I2CS_ADDR_TENBITEN_Msk = 0x8000
	// Bit TENBITEN.
	SERCOM_I2CS_ADDR_TENBITEN = 0x8000
	// Position of ADDRMASK field.
	SERCOM_I2CS_ADDR_ADDRMASK_Pos = 0x11
	// Bit mask of ADDRMASK field.
	SERCOM_I2CS_ADDR_ADDRMASK_Msk = 0x7fe0000

	// DATA: I2CS Data
	// Position of DATA field.
	SERCOM_I2CS_DATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SERCOM_I2CS_DATA_DATA_Msk = 0xff
)

// Constants for SERCOM0_SPI: Serial Communication Interface 0 - SPI
const (
	// CTRLA: SPI Control A
	// Position of SWRST field.
	SERCOM_SPI_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	SERCOM_SPI_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	SERCOM_SPI_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	SERCOM_SPI_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SERCOM_SPI_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SERCOM_SPI_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	SERCOM_SPI_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	SERCOM_SPI_CTRLA_MODE_Msk = 0x1c
	// USART mode with external clock
	SERCOM_SPI_CTRLA_MODE_USART_EXT_CLK = 0x0
	// USART mode with internal clock
	SERCOM_SPI_CTRLA_MODE_USART_INT_CLK = 0x1
	// SPI mode with external clock
	SERCOM_SPI_CTRLA_MODE_SPI_SLAVE = 0x2
	// SPI mode with internal clock
	SERCOM_SPI_CTRLA_MODE_SPI_MASTER = 0x3
	// I2C mode with external clock
	SERCOM_SPI_CTRLA_MODE_I2C_SLAVE = 0x4
	// I2C mode with internal clock
	SERCOM_SPI_CTRLA_MODE_I2C_MASTER = 0x5
	// Position of RUNSTDBY field.
	SERCOM_SPI_CTRLA_RUNSTDBY_Pos = 0x7
	// Bit mask of RUNSTDBY field.
	SERCOM_SPI_CTRLA_RUNSTDBY_Msk = 0x80
	// Bit RUNSTDBY.
	SERCOM_SPI_CTRLA_RUNSTDBY = 0x80
	// Position of IBON field.
	SERCOM_SPI_CTRLA_IBON_Pos = 0x8
	// Bit mask of IBON field.
	SERCOM_SPI_CTRLA_IBON_Msk = 0x100
	// Bit IBON.
	SERCOM_SPI_CTRLA_IBON = 0x100
	// Position of DOPO field.
	SERCOM_SPI_CTRLA_DOPO_Pos = 0x10
	// Bit mask of DOPO field.
	SERCOM_SPI_CTRLA_DOPO_Msk = 0x30000
	// Position of DIPO field.
	SERCOM_SPI_CTRLA_DIPO_Pos = 0x14
	// Bit mask of DIPO field.
	SERCOM_SPI_CTRLA_DIPO_Msk = 0x300000
	// Position of FORM field.
	SERCOM_SPI_CTRLA_FORM_Pos = 0x18
	// Bit mask of FORM field.
	SERCOM_SPI_CTRLA_FORM_Msk = 0xf000000
	// Position of CPHA field.
	SERCOM_SPI_CTRLA_CPHA_Pos = 0x1c
	// Bit mask of CPHA field.
	SERCOM_SPI_CTRLA_CPHA_Msk = 0x10000000
	// Bit CPHA.
	SERCOM_SPI_CTRLA_CPHA = 0x10000000
	// Position of CPOL field.
	SERCOM_SPI_CTRLA_CPOL_Pos = 0x1d
	// Bit mask of CPOL field.
	SERCOM_SPI_CTRLA_CPOL_Msk = 0x20000000
	// Bit CPOL.
	SERCOM_SPI_CTRLA_CPOL = 0x20000000
	// Position of DORD field.
	SERCOM_SPI_CTRLA_DORD_Pos = 0x1e
	// Bit mask of DORD field.
	SERCOM_SPI_CTRLA_DORD_Msk = 0x40000000
	// Bit DORD.
	SERCOM_SPI_CTRLA_DORD = 0x40000000

	// CTRLB: SPI Control B
	// Position of CHSIZE field.
	SERCOM_SPI_CTRLB_CHSIZE_Pos = 0x0
	// Bit mask of CHSIZE field.
	SERCOM_SPI_CTRLB_CHSIZE_Msk = 0x7
	// Position of PLOADEN field.
	SERCOM_SPI_CTRLB_PLOADEN_Pos = 0x6
	// Bit mask of PLOADEN field.
	SERCOM_SPI_CTRLB_PLOADEN_Msk = 0x40
	// Bit PLOADEN.
	SERCOM_SPI_CTRLB_PLOADEN = 0x40
	// Position of SSDE field.
	SERCOM_SPI_CTRLB_SSDE_Pos = 0x9
	// Bit mask of SSDE field.
	SERCOM_SPI_CTRLB_SSDE_Msk = 0x200
	// Bit SSDE.
	SERCOM_SPI_CTRLB_SSDE = 0x200
	// Position of MSSEN field.
	SERCOM_SPI_CTRLB_MSSEN_Pos = 0xd
	// Bit mask of MSSEN field.
	SERCOM_SPI_CTRLB_MSSEN_Msk = 0x2000
	// Bit MSSEN.
	SERCOM_SPI_CTRLB_MSSEN = 0x2000
	// Position of AMODE field.
	SERCOM_SPI_CTRLB_AMODE_Pos = 0xe
	// Bit mask of AMODE field.
	SERCOM_SPI_CTRLB_AMODE_Msk = 0xc000
	// Position of RXEN field.
	SERCOM_SPI_CTRLB_RXEN_Pos = 0x11
	// Bit mask of RXEN field.
	SERCOM_SPI_CTRLB_RXEN_Msk = 0x20000
	// Bit RXEN.
	SERCOM_SPI_CTRLB_RXEN = 0x20000

	// BAUD: SPI Baud Rate
	// Position of BAUD field.
	SERCOM_SPI_BAUD_BAUD_Pos = 0x0
	// Bit mask of BAUD field.
	SERCOM_SPI_BAUD_BAUD_Msk = 0xff

	// INTENCLR: SPI Interrupt Enable Clear
	// Position of DRE field.
	SERCOM_SPI_INTENCLR_DRE_Pos = 0x0
	// Bit mask of DRE field.
	SERCOM_SPI_INTENCLR_DRE_Msk = 0x1
	// Bit DRE.
	SERCOM_SPI_INTENCLR_DRE = 0x1
	// Position of TXC field.
	SERCOM_SPI_INTENCLR_TXC_Pos = 0x1
	// Bit mask of TXC field.
	SERCOM_SPI_INTENCLR_TXC_Msk = 0x2
	// Bit TXC.
	SERCOM_SPI_INTENCLR_TXC = 0x2
	// Position of RXC field.
	SERCOM_SPI_INTENCLR_RXC_Pos = 0x2
	// Bit mask of RXC field.
	SERCOM_SPI_INTENCLR_RXC_Msk = 0x4
	// Bit RXC.
	SERCOM_SPI_INTENCLR_RXC = 0x4
	// Position of SSL field.
	SERCOM_SPI_INTENCLR_SSL_Pos = 0x3
	// Bit mask of SSL field.
	SERCOM_SPI_INTENCLR_SSL_Msk = 0x8
	// Bit SSL.
	SERCOM_SPI_INTENCLR_SSL = 0x8
	// Position of ERROR field.
	SERCOM_SPI_INTENCLR_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_SPI_INTENCLR_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_SPI_INTENCLR_ERROR = 0x80

	// INTENSET: SPI Interrupt Enable Set
	// Position of DRE field.
	SERCOM_SPI_INTENSET_DRE_Pos = 0x0
	// Bit mask of DRE field.
	SERCOM_SPI_INTENSET_DRE_Msk = 0x1
	// Bit DRE.
	SERCOM_SPI_INTENSET_DRE = 0x1
	// Position of TXC field.
	SERCOM_SPI_INTENSET_TXC_Pos = 0x1
	// Bit mask of TXC field.
	SERCOM_SPI_INTENSET_TXC_Msk = 0x2
	// Bit TXC.
	SERCOM_SPI_INTENSET_TXC = 0x2
	// Position of RXC field.
	SERCOM_SPI_INTENSET_RXC_Pos = 0x2
	// Bit mask of RXC field.
	SERCOM_SPI_INTENSET_RXC_Msk = 0x4
	// Bit RXC.
	SERCOM_SPI_INTENSET_RXC = 0x4
	// Position of SSL field.
	SERCOM_SPI_INTENSET_SSL_Pos = 0x3
	// Bit mask of SSL field.
	SERCOM_SPI_INTENSET_SSL_Msk = 0x8
	// Bit SSL.
	SERCOM_SPI_INTENSET_SSL = 0x8
	// Position of ERROR field.
	SERCOM_SPI_INTENSET_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_SPI_INTENSET_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_SPI_INTENSET_ERROR = 0x80

	// INTFLAG: SPI Interrupt Flag Status and Clear
	// Position of DRE field.
	SERCOM_SPI_INTFLAG_DRE_Pos = 0x0
	// Bit mask of DRE field.
	SERCOM_SPI_INTFLAG_DRE_Msk = 0x1
	// Bit DRE.
	SERCOM_SPI_INTFLAG_DRE = 0x1
	// Position of TXC field.
	SERCOM_SPI_INTFLAG_TXC_Pos = 0x1
	// Bit mask of TXC field.
	SERCOM_SPI_INTFLAG_TXC_Msk = 0x2
	// Bit TXC.
	SERCOM_SPI_INTFLAG_TXC = 0x2
	// Position of RXC field.
	SERCOM_SPI_INTFLAG_RXC_Pos = 0x2
	// Bit mask of RXC field.
	SERCOM_SPI_INTFLAG_RXC_Msk = 0x4
	// Bit RXC.
	SERCOM_SPI_INTFLAG_RXC = 0x4
	// Position of SSL field.
	SERCOM_SPI_INTFLAG_SSL_Pos = 0x3
	// Bit mask of SSL field.
	SERCOM_SPI_INTFLAG_SSL_Msk = 0x8
	// Bit SSL.
	SERCOM_SPI_INTFLAG_SSL = 0x8
	// Position of ERROR field.
	SERCOM_SPI_INTFLAG_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_SPI_INTFLAG_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_SPI_INTFLAG_ERROR = 0x80

	// STATUS: SPI Status
	// Position of BUFOVF field.
	SERCOM_SPI_STATUS_BUFOVF_Pos = 0x2
	// Bit mask of BUFOVF field.
	SERCOM_SPI_STATUS_BUFOVF_Msk = 0x4
	// Bit BUFOVF.
	SERCOM_SPI_STATUS_BUFOVF = 0x4

	// SYNCBUSY: SPI Synchronization Busy
	// Position of SWRST field.
	SERCOM_SPI_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	SERCOM_SPI_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	SERCOM_SPI_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	SERCOM_SPI_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SERCOM_SPI_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SERCOM_SPI_SYNCBUSY_ENABLE = 0x2
	// Position of CTRLB field.
	SERCOM_SPI_SYNCBUSY_CTRLB_Pos = 0x2
	// Bit mask of CTRLB field.
	SERCOM_SPI_SYNCBUSY_CTRLB_Msk = 0x4
	// Bit CTRLB.
	SERCOM_SPI_SYNCBUSY_CTRLB = 0x4

	// ADDR: SPI Address
	// Position of ADDR field.
	SERCOM_SPI_ADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	SERCOM_SPI_ADDR_ADDR_Msk = 0xff
	// Position of ADDRMASK field.
	SERCOM_SPI_ADDR_ADDRMASK_Pos = 0x10
	// Bit mask of ADDRMASK field.
	SERCOM_SPI_ADDR_ADDRMASK_Msk = 0xff0000

	// DATA: SPI Data
	// Position of DATA field.
	SERCOM_SPI_DATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SERCOM_SPI_DATA_DATA_Msk = 0x1ff

	// DBGCTRL: SPI Debug Control
	// Position of DBGSTOP field.
	SERCOM_SPI_DBGCTRL_DBGSTOP_Pos = 0x0
	// Bit mask of DBGSTOP field.
	SERCOM_SPI_DBGCTRL_DBGSTOP_Msk = 0x1
	// Bit DBGSTOP.
	SERCOM_SPI_DBGCTRL_DBGSTOP = 0x1
)

// Constants for SERCOM0_USART: Serial Communication Interface 0 - USART
const (
	// CTRLA: USART Control A
	// Position of SWRST field.
	SERCOM_USART_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	SERCOM_USART_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	SERCOM_USART_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	SERCOM_USART_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SERCOM_USART_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SERCOM_USART_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	SERCOM_USART_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	SERCOM_USART_CTRLA_MODE_Msk = 0x1c
	// USART mode with external clock
	SERCOM_USART_CTRLA_MODE_USART_EXT_CLK = 0x0
	// USART mode with internal clock
	SERCOM_USART_CTRLA_MODE_USART_INT_CLK = 0x1
	// SPI mode with external clock
	SERCOM_USART_CTRLA_MODE_SPI_SLAVE = 0x2
	// SPI mode with internal clock
	SERCOM_USART_CTRLA_MODE_SPI_MASTER = 0x3
	// I2C mode with external clock
	SERCOM_USART_CTRLA_MODE_I2C_SLAVE = 0x4
	// I2C mode with internal clock
	SERCOM_USART_CTRLA_MODE_I2C_MASTER = 0x5
	// Position of RUNSTDBY field.
	SERCOM_USART_CTRLA_RUNSTDBY_Pos = 0x7
	// Bit mask of RUNSTDBY field.
	SERCOM_USART_CTRLA_RUNSTDBY_Msk = 0x80
	// Bit RUNSTDBY.
	SERCOM_USART_CTRLA_RUNSTDBY = 0x80
	// Position of IBON field.
	SERCOM_USART_CTRLA_IBON_Pos = 0x8
	// Bit mask of IBON field.
	SERCOM_USART_CTRLA_IBON_Msk = 0x100
	// Bit IBON.
	SERCOM_USART_CTRLA_IBON = 0x100
	// Position of SAMPR field.
	SERCOM_USART_CTRLA_SAMPR_Pos = 0xd
	// Bit mask of SAMPR field.
	SERCOM_USART_CTRLA_SAMPR_Msk = 0xe000
	// Position of TXPO field.
	SERCOM_USART_CTRLA_TXPO_Pos = 0x10
	// Bit mask of TXPO field.
	SERCOM_USART_CTRLA_TXPO_Msk = 0x30000
	// Position of RXPO field.
	SERCOM_USART_CTRLA_RXPO_Pos = 0x14
	// Bit mask of RXPO field.
	SERCOM_USART_CTRLA_RXPO_Msk = 0x300000
	// Position of SAMPA field.
	SERCOM_USART_CTRLA_SAMPA_Pos = 0x16
	// Bit mask of SAMPA field.
	SERCOM_USART_CTRLA_SAMPA_Msk = 0xc00000
	// Position of FORM field.
	SERCOM_USART_CTRLA_FORM_Pos = 0x18
	// Bit mask of FORM field.
	SERCOM_USART_CTRLA_FORM_Msk = 0xf000000
	// Position of CMODE field.
	SERCOM_USART_CTRLA_CMODE_Pos = 0x1c
	// Bit mask of CMODE field.
	SERCOM_USART_CTRLA_CMODE_Msk = 0x10000000
	// Bit CMODE.
	SERCOM_USART_CTRLA_CMODE = 0x10000000
	// Position of CPOL field.
	SERCOM_USART_CTRLA_CPOL_Pos = 0x1d
	// Bit mask of CPOL field.
	SERCOM_USART_CTRLA_CPOL_Msk = 0x20000000
	// Bit CPOL.
	SERCOM_USART_CTRLA_CPOL = 0x20000000
	// Position of DORD field.
	SERCOM_USART_CTRLA_DORD_Pos = 0x1e
	// Bit mask of DORD field.
	SERCOM_USART_CTRLA_DORD_Msk = 0x40000000
	// Bit DORD.
	SERCOM_USART_CTRLA_DORD = 0x40000000

	// CTRLB: USART Control B
	// Position of CHSIZE field.
	SERCOM_USART_CTRLB_CHSIZE_Pos = 0x0
	// Bit mask of CHSIZE field.
	SERCOM_USART_CTRLB_CHSIZE_Msk = 0x7
	// Position of SBMODE field.
	SERCOM_USART_CTRLB_SBMODE_Pos = 0x6
	// Bit mask of SBMODE field.
	SERCOM_USART_CTRLB_SBMODE_Msk = 0x40
	// Bit SBMODE.
	SERCOM_USART_CTRLB_SBMODE = 0x40
	// Position of COLDEN field.
	SERCOM_USART_CTRLB_COLDEN_Pos = 0x8
	// Bit mask of COLDEN field.
	SERCOM_USART_CTRLB_COLDEN_Msk = 0x100
	// Bit COLDEN.
	SERCOM_USART_CTRLB_COLDEN = 0x100
	// Position of SFDE field.
	SERCOM_USART_CTRLB_SFDE_Pos = 0x9
	// Bit mask of SFDE field.
	SERCOM_USART_CTRLB_SFDE_Msk = 0x200
	// Bit SFDE.
	SERCOM_USART_CTRLB_SFDE = 0x200
	// Position of ENC field.
	SERCOM_USART_CTRLB_ENC_Pos = 0xa
	// Bit mask of ENC field.
	SERCOM_USART_CTRLB_ENC_Msk = 0x400
	// Bit ENC.
	SERCOM_USART_CTRLB_ENC = 0x400
	// Position of PMODE field.
	SERCOM_USART_CTRLB_PMODE_Pos = 0xd
	// Bit mask of PMODE field.
	SERCOM_USART_CTRLB_PMODE_Msk = 0x2000
	// Bit PMODE.
	SERCOM_USART_CTRLB_PMODE = 0x2000
	// Position of TXEN field.
	SERCOM_USART_CTRLB_TXEN_Pos = 0x10
	// Bit mask of TXEN field.
	SERCOM_USART_CTRLB_TXEN_Msk = 0x10000
	// Bit TXEN.
	SERCOM_USART_CTRLB_TXEN = 0x10000
	// Position of RXEN field.
	SERCOM_USART_CTRLB_RXEN_Pos = 0x11
	// Bit mask of RXEN field.
	SERCOM_USART_CTRLB_RXEN_Msk = 0x20000
	// Bit RXEN.
	SERCOM_USART_CTRLB_RXEN = 0x20000

	// BAUD: USART Baud Rate
	// Position of BAUD field.
	SERCOM_USART_BAUD_BAUD_Pos = 0x0
	// Bit mask of BAUD field.
	SERCOM_USART_BAUD_BAUD_Msk = 0xffff

	// BAUD_FRAC_MODE: USART Baud Rate
	// Position of BAUD field.
	SERCOM_USART_BAUD_FRAC_MODE_BAUD_Pos = 0x0
	// Bit mask of BAUD field.
	SERCOM_USART_BAUD_FRAC_MODE_BAUD_Msk = 0x1fff
	// Position of FP field.
	SERCOM_USART_BAUD_FRAC_MODE_FP_Pos = 0xd
	// Bit mask of FP field.
	SERCOM_USART_BAUD_FRAC_MODE_FP_Msk = 0xe000

	// BAUD_FRACFP_MODE: USART Baud Rate
	// Position of BAUD field.
	SERCOM_USART_BAUD_FRACFP_MODE_BAUD_Pos = 0x0
	// Bit mask of BAUD field.
	SERCOM_USART_BAUD_FRACFP_MODE_BAUD_Msk = 0x1fff
	// Position of FP field.
	SERCOM_USART_BAUD_FRACFP_MODE_FP_Pos = 0xd
	// Bit mask of FP field.
	SERCOM_USART_BAUD_FRACFP_MODE_FP_Msk = 0xe000

	// BAUD_USARTFP_MODE: USART Baud Rate
	// Position of BAUD field.
	SERCOM_USART_BAUD_USARTFP_MODE_BAUD_Pos = 0x0
	// Bit mask of BAUD field.
	SERCOM_USART_BAUD_USARTFP_MODE_BAUD_Msk = 0xffff

	// RXPL: USART Receive Pulse Length
	// Position of RXPL field.
	SERCOM_USART_RXPL_RXPL_Pos = 0x0
	// Bit mask of RXPL field.
	SERCOM_USART_RXPL_RXPL_Msk = 0xff

	// INTENCLR: USART Interrupt Enable Clear
	// Position of DRE field.
	SERCOM_USART_INTENCLR_DRE_Pos = 0x0
	// Bit mask of DRE field.
	SERCOM_USART_INTENCLR_DRE_Msk = 0x1
	// Bit DRE.
	SERCOM_USART_INTENCLR_DRE = 0x1
	// Position of TXC field.
	SERCOM_USART_INTENCLR_TXC_Pos = 0x1
	// Bit mask of TXC field.
	SERCOM_USART_INTENCLR_TXC_Msk = 0x2
	// Bit TXC.
	SERCOM_USART_INTENCLR_TXC = 0x2
	// Position of RXC field.
	SERCOM_USART_INTENCLR_RXC_Pos = 0x2
	// Bit mask of RXC field.
	SERCOM_USART_INTENCLR_RXC_Msk = 0x4
	// Bit RXC.
	SERCOM_USART_INTENCLR_RXC = 0x4
	// Position of RXS field.
	SERCOM_USART_INTENCLR_RXS_Pos = 0x3
	// Bit mask of RXS field.
	SERCOM_USART_INTENCLR_RXS_Msk = 0x8
	// Bit RXS.
	SERCOM_USART_INTENCLR_RXS = 0x8
	// Position of CTSIC field.
	SERCOM_USART_INTENCLR_CTSIC_Pos = 0x4
	// Bit mask of CTSIC field.
	SERCOM_USART_INTENCLR_CTSIC_Msk = 0x10
	// Bit CTSIC.
	SERCOM_USART_INTENCLR_CTSIC = 0x10
	// Position of RXBRK field.
	SERCOM_USART_INTENCLR_RXBRK_Pos = 0x5
	// Bit mask of RXBRK field.
	SERCOM_USART_INTENCLR_RXBRK_Msk = 0x20
	// Bit RXBRK.
	SERCOM_USART_INTENCLR_RXBRK = 0x20
	// Position of ERROR field.
	SERCOM_USART_INTENCLR_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_USART_INTENCLR_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_USART_INTENCLR_ERROR = 0x80

	// INTENSET: USART Interrupt Enable Set
	// Position of DRE field.
	SERCOM_USART_INTENSET_DRE_Pos = 0x0
	// Bit mask of DRE field.
	SERCOM_USART_INTENSET_DRE_Msk = 0x1
	// Bit DRE.
	SERCOM_USART_INTENSET_DRE = 0x1
	// Position of TXC field.
	SERCOM_USART_INTENSET_TXC_Pos = 0x1
	// Bit mask of TXC field.
	SERCOM_USART_INTENSET_TXC_Msk = 0x2
	// Bit TXC.
	SERCOM_USART_INTENSET_TXC = 0x2
	// Position of RXC field.
	SERCOM_USART_INTENSET_RXC_Pos = 0x2
	// Bit mask of RXC field.
	SERCOM_USART_INTENSET_RXC_Msk = 0x4
	// Bit RXC.
	SERCOM_USART_INTENSET_RXC = 0x4
	// Position of RXS field.
	SERCOM_USART_INTENSET_RXS_Pos = 0x3
	// Bit mask of RXS field.
	SERCOM_USART_INTENSET_RXS_Msk = 0x8
	// Bit RXS.
	SERCOM_USART_INTENSET_RXS = 0x8
	// Position of CTSIC field.
	SERCOM_USART_INTENSET_CTSIC_Pos = 0x4
	// Bit mask of CTSIC field.
	SERCOM_USART_INTENSET_CTSIC_Msk = 0x10
	// Bit CTSIC.
	SERCOM_USART_INTENSET_CTSIC = 0x10
	// Position of RXBRK field.
	SERCOM_USART_INTENSET_RXBRK_Pos = 0x5
	// Bit mask of RXBRK field.
	SERCOM_USART_INTENSET_RXBRK_Msk = 0x20
	// Bit RXBRK.
	SERCOM_USART_INTENSET_RXBRK = 0x20
	// Position of ERROR field.
	SERCOM_USART_INTENSET_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_USART_INTENSET_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_USART_INTENSET_ERROR = 0x80

	// INTFLAG: USART Interrupt Flag Status and Clear
	// Position of DRE field.
	SERCOM_USART_INTFLAG_DRE_Pos = 0x0
	// Bit mask of DRE field.
	SERCOM_USART_INTFLAG_DRE_Msk = 0x1
	// Bit DRE.
	SERCOM_USART_INTFLAG_DRE = 0x1
	// Position of TXC field.
	SERCOM_USART_INTFLAG_TXC_Pos = 0x1
	// Bit mask of TXC field.
	SERCOM_USART_INTFLAG_TXC_Msk = 0x2
	// Bit TXC.
	SERCOM_USART_INTFLAG_TXC = 0x2
	// Position of RXC field.
	SERCOM_USART_INTFLAG_RXC_Pos = 0x2
	// Bit mask of RXC field.
	SERCOM_USART_INTFLAG_RXC_Msk = 0x4
	// Bit RXC.
	SERCOM_USART_INTFLAG_RXC = 0x4
	// Position of RXS field.
	SERCOM_USART_INTFLAG_RXS_Pos = 0x3
	// Bit mask of RXS field.
	SERCOM_USART_INTFLAG_RXS_Msk = 0x8
	// Bit RXS.
	SERCOM_USART_INTFLAG_RXS = 0x8
	// Position of CTSIC field.
	SERCOM_USART_INTFLAG_CTSIC_Pos = 0x4
	// Bit mask of CTSIC field.
	SERCOM_USART_INTFLAG_CTSIC_Msk = 0x10
	// Bit CTSIC.
	SERCOM_USART_INTFLAG_CTSIC = 0x10
	// Position of RXBRK field.
	SERCOM_USART_INTFLAG_RXBRK_Pos = 0x5
	// Bit mask of RXBRK field.
	SERCOM_USART_INTFLAG_RXBRK_Msk = 0x20
	// Bit RXBRK.
	SERCOM_USART_INTFLAG_RXBRK = 0x20
	// Position of ERROR field.
	SERCOM_USART_INTFLAG_ERROR_Pos = 0x7
	// Bit mask of ERROR field.
	SERCOM_USART_INTFLAG_ERROR_Msk = 0x80
	// Bit ERROR.
	SERCOM_USART_INTFLAG_ERROR = 0x80

	// STATUS: USART Status
	// Position of PERR field.
	SERCOM_USART_STATUS_PERR_Pos = 0x0
	// Bit mask of PERR field.
	SERCOM_USART_STATUS_PERR_Msk = 0x1
	// Bit PERR.
	SERCOM_USART_STATUS_PERR = 0x1
	// Position of FERR field.
	SERCOM_USART_STATUS_FERR_Pos = 0x1
	// Bit mask of FERR field.
	SERCOM_USART_STATUS_FERR_Msk = 0x2
	// Bit FERR.
	SERCOM_USART_STATUS_FERR = 0x2
	// Position of BUFOVF field.
	SERCOM_USART_STATUS_BUFOVF_Pos = 0x2
	// Bit mask of BUFOVF field.
	SERCOM_USART_STATUS_BUFOVF_Msk = 0x4
	// Bit BUFOVF.
	SERCOM_USART_STATUS_BUFOVF = 0x4
	// Position of CTS field.
	SERCOM_USART_STATUS_CTS_Pos = 0x3
	// Bit mask of CTS field.
	SERCOM_USART_STATUS_CTS_Msk = 0x8
	// Bit CTS.
	SERCOM_USART_STATUS_CTS = 0x8
	// Position of ISF field.
	SERCOM_USART_STATUS_ISF_Pos = 0x4
	// Bit mask of ISF field.
	SERCOM_USART_STATUS_ISF_Msk = 0x10
	// Bit ISF.
	SERCOM_USART_STATUS_ISF = 0x10
	// Position of COLL field.
	SERCOM_USART_STATUS_COLL_Pos = 0x5
	// Bit mask of COLL field.
	SERCOM_USART_STATUS_COLL_Msk = 0x20
	// Bit COLL.
	SERCOM_USART_STATUS_COLL = 0x20

	// SYNCBUSY: USART Synchronization Busy
	// Position of SWRST field.
	SERCOM_USART_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	SERCOM_USART_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	SERCOM_USART_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	SERCOM_USART_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SERCOM_USART_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SERCOM_USART_SYNCBUSY_ENABLE = 0x2
	// Position of CTRLB field.
	SERCOM_USART_SYNCBUSY_CTRLB_Pos = 0x2
	// Bit mask of CTRLB field.
	SERCOM_USART_SYNCBUSY_CTRLB_Msk = 0x4
	// Bit CTRLB.
	SERCOM_USART_SYNCBUSY_CTRLB = 0x4

	// DATA: USART Data
	// Position of DATA field.
	SERCOM_USART_DATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	SERCOM_USART_DATA_DATA_Msk = 0x1ff

	// DBGCTRL: USART Debug Control
	// Position of DBGSTOP field.
	SERCOM_USART_DBGCTRL_DBGSTOP_Pos = 0x0
	// Bit mask of DBGSTOP field.
	SERCOM_USART_DBGCTRL_DBGSTOP_Msk = 0x1
	// Bit DBGSTOP.
	SERCOM_USART_DBGCTRL_DBGSTOP = 0x1
)

// Constants for SYSCTRL: System Control
const (
	// INTENCLR: Interrupt Enable Clear
	// Position of XOSCRDY field.
	SYSCTRL_INTENCLR_XOSCRDY_Pos = 0x0
	// Bit mask of XOSCRDY field.
	SYSCTRL_INTENCLR_XOSCRDY_Msk = 0x1
	// Bit XOSCRDY.
	SYSCTRL_INTENCLR_XOSCRDY = 0x1
	// Position of XOSC32KRDY field.
	SYSCTRL_INTENCLR_XOSC32KRDY_Pos = 0x1
	// Bit mask of XOSC32KRDY field.
	SYSCTRL_INTENCLR_XOSC32KRDY_Msk = 0x2
	// Bit XOSC32KRDY.
	SYSCTRL_INTENCLR_XOSC32KRDY = 0x2
	// Position of OSC32KRDY field.
	SYSCTRL_INTENCLR_OSC32KRDY_Pos = 0x2
	// Bit mask of OSC32KRDY field.
	SYSCTRL_INTENCLR_OSC32KRDY_Msk = 0x4
	// Bit OSC32KRDY.
	SYSCTRL_INTENCLR_OSC32KRDY = 0x4
	// Position of OSC8MRDY field.
	SYSCTRL_INTENCLR_OSC8MRDY_Pos = 0x3
	// Bit mask of OSC8MRDY field.
	SYSCTRL_INTENCLR_OSC8MRDY_Msk = 0x8
	// Bit OSC8MRDY.
	SYSCTRL_INTENCLR_OSC8MRDY = 0x8
	// Position of DFLLRDY field.
	SYSCTRL_INTENCLR_DFLLRDY_Pos = 0x4
	// Bit mask of DFLLRDY field.
	SYSCTRL_INTENCLR_DFLLRDY_Msk = 0x10
	// Bit DFLLRDY.
	SYSCTRL_INTENCLR_DFLLRDY = 0x10
	// Position of DFLLOOB field.
	SYSCTRL_INTENCLR_DFLLOOB_Pos = 0x5
	// Bit mask of DFLLOOB field.
	SYSCTRL_INTENCLR_DFLLOOB_Msk = 0x20
	// Bit DFLLOOB.
	SYSCTRL_INTENCLR_DFLLOOB = 0x20
	// Position of DFLLLCKF field.
	SYSCTRL_INTENCLR_DFLLLCKF_Pos = 0x6
	// Bit mask of DFLLLCKF field.
	SYSCTRL_INTENCLR_DFLLLCKF_Msk = 0x40
	// Bit DFLLLCKF.
	SYSCTRL_INTENCLR_DFLLLCKF = 0x40
	// Position of DFLLLCKC field.
	SYSCTRL_INTENCLR_DFLLLCKC_Pos = 0x7
	// Bit mask of DFLLLCKC field.
	SYSCTRL_INTENCLR_DFLLLCKC_Msk = 0x80
	// Bit DFLLLCKC.
	SYSCTRL_INTENCLR_DFLLLCKC = 0x80
	// Position of DFLLRCS field.
	SYSCTRL_INTENCLR_DFLLRCS_Pos = 0x8
	// Bit mask of DFLLRCS field.
	SYSCTRL_INTENCLR_DFLLRCS_Msk = 0x100
	// Bit DFLLRCS.
	SYSCTRL_INTENCLR_DFLLRCS = 0x100
	// Position of BOD33RDY field.
	SYSCTRL_INTENCLR_BOD33RDY_Pos = 0x9
	// Bit mask of BOD33RDY field.
	SYSCTRL_INTENCLR_BOD33RDY_Msk = 0x200
	// Bit BOD33RDY.
	SYSCTRL_INTENCLR_BOD33RDY = 0x200
	// Position of BOD33DET field.
	SYSCTRL_INTENCLR_BOD33DET_Pos = 0xa
	// Bit mask of BOD33DET field.
	SYSCTRL_INTENCLR_BOD33DET_Msk = 0x400
	// Bit BOD33DET.
	SYSCTRL_INTENCLR_BOD33DET = 0x400
	// Position of B33SRDY field.
	SYSCTRL_INTENCLR_B33SRDY_Pos = 0xb
	// Bit mask of B33SRDY field.
	SYSCTRL_INTENCLR_B33SRDY_Msk = 0x800
	// Bit B33SRDY.
	SYSCTRL_INTENCLR_B33SRDY = 0x800
	// Position of DPLLLCKR field.
	SYSCTRL_INTENCLR_DPLLLCKR_Pos = 0xf
	// Bit mask of DPLLLCKR field.
	SYSCTRL_INTENCLR_DPLLLCKR_Msk = 0x8000
	// Bit DPLLLCKR.
	SYSCTRL_INTENCLR_DPLLLCKR = 0x8000
	// Position of DPLLLCKF field.
	SYSCTRL_INTENCLR_DPLLLCKF_Pos = 0x10
	// Bit mask of DPLLLCKF field.
	SYSCTRL_INTENCLR_DPLLLCKF_Msk = 0x10000
	// Bit DPLLLCKF.
	SYSCTRL_INTENCLR_DPLLLCKF = 0x10000
	// Position of DPLLLTO field.
	SYSCTRL_INTENCLR_DPLLLTO_Pos = 0x11
	// Bit mask of DPLLLTO field.
	SYSCTRL_INTENCLR_DPLLLTO_Msk = 0x20000
	// Bit DPLLLTO.
	SYSCTRL_INTENCLR_DPLLLTO = 0x20000

	// INTENSET: Interrupt Enable Set
	// Position of XOSCRDY field.
	SYSCTRL_INTENSET_XOSCRDY_Pos = 0x0
	// Bit mask of XOSCRDY field.
	SYSCTRL_INTENSET_XOSCRDY_Msk = 0x1
	// Bit XOSCRDY.
	SYSCTRL_INTENSET_XOSCRDY = 0x1
	// Position of XOSC32KRDY field.
	SYSCTRL_INTENSET_XOSC32KRDY_Pos = 0x1
	// Bit mask of XOSC32KRDY field.
	SYSCTRL_INTENSET_XOSC32KRDY_Msk = 0x2
	// Bit XOSC32KRDY.
	SYSCTRL_INTENSET_XOSC32KRDY = 0x2
	// Position of OSC32KRDY field.
	SYSCTRL_INTENSET_OSC32KRDY_Pos = 0x2
	// Bit mask of OSC32KRDY field.
	SYSCTRL_INTENSET_OSC32KRDY_Msk = 0x4
	// Bit OSC32KRDY.
	SYSCTRL_INTENSET_OSC32KRDY = 0x4
	// Position of OSC8MRDY field.
	SYSCTRL_INTENSET_OSC8MRDY_Pos = 0x3
	// Bit mask of OSC8MRDY field.
	SYSCTRL_INTENSET_OSC8MRDY_Msk = 0x8
	// Bit OSC8MRDY.
	SYSCTRL_INTENSET_OSC8MRDY = 0x8
	// Position of DFLLRDY field.
	SYSCTRL_INTENSET_DFLLRDY_Pos = 0x4
	// Bit mask of DFLLRDY field.
	SYSCTRL_INTENSET_DFLLRDY_Msk = 0x10
	// Bit DFLLRDY.
	SYSCTRL_INTENSET_DFLLRDY = 0x10
	// Position of DFLLOOB field.
	SYSCTRL_INTENSET_DFLLOOB_Pos = 0x5
	// Bit mask of DFLLOOB field.
	SYSCTRL_INTENSET_DFLLOOB_Msk = 0x20
	// Bit DFLLOOB.
	SYSCTRL_INTENSET_DFLLOOB = 0x20
	// Position of DFLLLCKF field.
	SYSCTRL_INTENSET_DFLLLCKF_Pos = 0x6
	// Bit mask of DFLLLCKF field.
	SYSCTRL_INTENSET_DFLLLCKF_Msk = 0x40
	// Bit DFLLLCKF.
	SYSCTRL_INTENSET_DFLLLCKF = 0x40
	// Position of DFLLLCKC field.
	SYSCTRL_INTENSET_DFLLLCKC_Pos = 0x7
	// Bit mask of DFLLLCKC field.
	SYSCTRL_INTENSET_DFLLLCKC_Msk = 0x80
	// Bit DFLLLCKC.
	SYSCTRL_INTENSET_DFLLLCKC = 0x80
	// Position of DFLLRCS field.
	SYSCTRL_INTENSET_DFLLRCS_Pos = 0x8
	// Bit mask of DFLLRCS field.
	SYSCTRL_INTENSET_DFLLRCS_Msk = 0x100
	// Bit DFLLRCS.
	SYSCTRL_INTENSET_DFLLRCS = 0x100
	// Position of BOD33RDY field.
	SYSCTRL_INTENSET_BOD33RDY_Pos = 0x9
	// Bit mask of BOD33RDY field.
	SYSCTRL_INTENSET_BOD33RDY_Msk = 0x200
	// Bit BOD33RDY.
	SYSCTRL_INTENSET_BOD33RDY = 0x200
	// Position of BOD33DET field.
	SYSCTRL_INTENSET_BOD33DET_Pos = 0xa
	// Bit mask of BOD33DET field.
	SYSCTRL_INTENSET_BOD33DET_Msk = 0x400
	// Bit BOD33DET.
	SYSCTRL_INTENSET_BOD33DET = 0x400
	// Position of B33SRDY field.
	SYSCTRL_INTENSET_B33SRDY_Pos = 0xb
	// Bit mask of B33SRDY field.
	SYSCTRL_INTENSET_B33SRDY_Msk = 0x800
	// Bit B33SRDY.
	SYSCTRL_INTENSET_B33SRDY = 0x800
	// Position of DPLLLCKR field.
	SYSCTRL_INTENSET_DPLLLCKR_Pos = 0xf
	// Bit mask of DPLLLCKR field.
	SYSCTRL_INTENSET_DPLLLCKR_Msk = 0x8000
	// Bit DPLLLCKR.
	SYSCTRL_INTENSET_DPLLLCKR = 0x8000
	// Position of DPLLLCKF field.
	SYSCTRL_INTENSET_DPLLLCKF_Pos = 0x10
	// Bit mask of DPLLLCKF field.
	SYSCTRL_INTENSET_DPLLLCKF_Msk = 0x10000
	// Bit DPLLLCKF.
	SYSCTRL_INTENSET_DPLLLCKF = 0x10000
	// Position of DPLLLTO field.
	SYSCTRL_INTENSET_DPLLLTO_Pos = 0x11
	// Bit mask of DPLLLTO field.
	SYSCTRL_INTENSET_DPLLLTO_Msk = 0x20000
	// Bit DPLLLTO.
	SYSCTRL_INTENSET_DPLLLTO = 0x20000

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of XOSCRDY field.
	SYSCTRL_INTFLAG_XOSCRDY_Pos = 0x0
	// Bit mask of XOSCRDY field.
	SYSCTRL_INTFLAG_XOSCRDY_Msk = 0x1
	// Bit XOSCRDY.
	SYSCTRL_INTFLAG_XOSCRDY = 0x1
	// Position of XOSC32KRDY field.
	SYSCTRL_INTFLAG_XOSC32KRDY_Pos = 0x1
	// Bit mask of XOSC32KRDY field.
	SYSCTRL_INTFLAG_XOSC32KRDY_Msk = 0x2
	// Bit XOSC32KRDY.
	SYSCTRL_INTFLAG_XOSC32KRDY = 0x2
	// Position of OSC32KRDY field.
	SYSCTRL_INTFLAG_OSC32KRDY_Pos = 0x2
	// Bit mask of OSC32KRDY field.
	SYSCTRL_INTFLAG_OSC32KRDY_Msk = 0x4
	// Bit OSC32KRDY.
	SYSCTRL_INTFLAG_OSC32KRDY = 0x4
	// Position of OSC8MRDY field.
	SYSCTRL_INTFLAG_OSC8MRDY_Pos = 0x3
	// Bit mask of OSC8MRDY field.
	SYSCTRL_INTFLAG_OSC8MRDY_Msk = 0x8
	// Bit OSC8MRDY.
	SYSCTRL_INTFLAG_OSC8MRDY = 0x8
	// Position of DFLLRDY field.
	SYSCTRL_INTFLAG_DFLLRDY_Pos = 0x4
	// Bit mask of DFLLRDY field.
	SYSCTRL_INTFLAG_DFLLRDY_Msk = 0x10
	// Bit DFLLRDY.
	SYSCTRL_INTFLAG_DFLLRDY = 0x10
	// Position of DFLLOOB field.
	SYSCTRL_INTFLAG_DFLLOOB_Pos = 0x5
	// Bit mask of DFLLOOB field.
	SYSCTRL_INTFLAG_DFLLOOB_Msk = 0x20
	// Bit DFLLOOB.
	SYSCTRL_INTFLAG_DFLLOOB = 0x20
	// Position of DFLLLCKF field.
	SYSCTRL_INTFLAG_DFLLLCKF_Pos = 0x6
	// Bit mask of DFLLLCKF field.
	SYSCTRL_INTFLAG_DFLLLCKF_Msk = 0x40
	// Bit DFLLLCKF.
	SYSCTRL_INTFLAG_DFLLLCKF = 0x40
	// Position of DFLLLCKC field.
	SYSCTRL_INTFLAG_DFLLLCKC_Pos = 0x7
	// Bit mask of DFLLLCKC field.
	SYSCTRL_INTFLAG_DFLLLCKC_Msk = 0x80
	// Bit DFLLLCKC.
	SYSCTRL_INTFLAG_DFLLLCKC = 0x80
	// Position of DFLLRCS field.
	SYSCTRL_INTFLAG_DFLLRCS_Pos = 0x8
	// Bit mask of DFLLRCS field.
	SYSCTRL_INTFLAG_DFLLRCS_Msk = 0x100
	// Bit DFLLRCS.
	SYSCTRL_INTFLAG_DFLLRCS = 0x100
	// Position of BOD33RDY field.
	SYSCTRL_INTFLAG_BOD33RDY_Pos = 0x9
	// Bit mask of BOD33RDY field.
	SYSCTRL_INTFLAG_BOD33RDY_Msk = 0x200
	// Bit BOD33RDY.
	SYSCTRL_INTFLAG_BOD33RDY = 0x200
	// Position of BOD33DET field.
	SYSCTRL_INTFLAG_BOD33DET_Pos = 0xa
	// Bit mask of BOD33DET field.
	SYSCTRL_INTFLAG_BOD33DET_Msk = 0x400
	// Bit BOD33DET.
	SYSCTRL_INTFLAG_BOD33DET = 0x400
	// Position of B33SRDY field.
	SYSCTRL_INTFLAG_B33SRDY_Pos = 0xb
	// Bit mask of B33SRDY field.
	SYSCTRL_INTFLAG_B33SRDY_Msk = 0x800
	// Bit B33SRDY.
	SYSCTRL_INTFLAG_B33SRDY = 0x800
	// Position of DPLLLCKR field.
	SYSCTRL_INTFLAG_DPLLLCKR_Pos = 0xf
	// Bit mask of DPLLLCKR field.
	SYSCTRL_INTFLAG_DPLLLCKR_Msk = 0x8000
	// Bit DPLLLCKR.
	SYSCTRL_INTFLAG_DPLLLCKR = 0x8000
	// Position of DPLLLCKF field.
	SYSCTRL_INTFLAG_DPLLLCKF_Pos = 0x10
	// Bit mask of DPLLLCKF field.
	SYSCTRL_INTFLAG_DPLLLCKF_Msk = 0x10000
	// Bit DPLLLCKF.
	SYSCTRL_INTFLAG_DPLLLCKF = 0x10000
	// Position of DPLLLTO field.
	SYSCTRL_INTFLAG_DPLLLTO_Pos = 0x11
	// Bit mask of DPLLLTO field.
	SYSCTRL_INTFLAG_DPLLLTO_Msk = 0x20000
	// Bit DPLLLTO.
	SYSCTRL_INTFLAG_DPLLLTO = 0x20000

	// PCLKSR: Power and Clocks Status
	// Position of XOSCRDY field.
	SYSCTRL_PCLKSR_XOSCRDY_Pos = 0x0
	// Bit mask of XOSCRDY field.
	SYSCTRL_PCLKSR_XOSCRDY_Msk = 0x1
	// Bit XOSCRDY.
	SYSCTRL_PCLKSR_XOSCRDY = 0x1
	// Position of XOSC32KRDY field.
	SYSCTRL_PCLKSR_XOSC32KRDY_Pos = 0x1
	// Bit mask of XOSC32KRDY field.
	SYSCTRL_PCLKSR_XOSC32KRDY_Msk = 0x2
	// Bit XOSC32KRDY.
	SYSCTRL_PCLKSR_XOSC32KRDY = 0x2
	// Position of OSC32KRDY field.
	SYSCTRL_PCLKSR_OSC32KRDY_Pos = 0x2
	// Bit mask of OSC32KRDY field.
	SYSCTRL_PCLKSR_OSC32KRDY_Msk = 0x4
	// Bit OSC32KRDY.
	SYSCTRL_PCLKSR_OSC32KRDY = 0x4
	// Position of OSC8MRDY field.
	SYSCTRL_PCLKSR_OSC8MRDY_Pos = 0x3
	// Bit mask of OSC8MRDY field.
	SYSCTRL_PCLKSR_OSC8MRDY_Msk = 0x8
	// Bit OSC8MRDY.
	SYSCTRL_PCLKSR_OSC8MRDY = 0x8
	// Position of DFLLRDY field.
	SYSCTRL_PCLKSR_DFLLRDY_Pos = 0x4
	// Bit mask of DFLLRDY field.
	SYSCTRL_PCLKSR_DFLLRDY_Msk = 0x10
	// Bit DFLLRDY.
	SYSCTRL_PCLKSR_DFLLRDY = 0x10
	// Position of DFLLOOB field.
	SYSCTRL_PCLKSR_DFLLOOB_Pos = 0x5
	// Bit mask of DFLLOOB field.
	SYSCTRL_PCLKSR_DFLLOOB_Msk = 0x20
	// Bit DFLLOOB.
	SYSCTRL_PCLKSR_DFLLOOB = 0x20
	// Position of DFLLLCKF field.
	SYSCTRL_PCLKSR_DFLLLCKF_Pos = 0x6
	// Bit mask of DFLLLCKF field.
	SYSCTRL_PCLKSR_DFLLLCKF_Msk = 0x40
	// Bit DFLLLCKF.
	SYSCTRL_PCLKSR_DFLLLCKF = 0x40
	// Position of DFLLLCKC field.
	SYSCTRL_PCLKSR_DFLLLCKC_Pos = 0x7
	// Bit mask of DFLLLCKC field.
	SYSCTRL_PCLKSR_DFLLLCKC_Msk = 0x80
	// Bit DFLLLCKC.
	SYSCTRL_PCLKSR_DFLLLCKC = 0x80
	// Position of DFLLRCS field.
	SYSCTRL_PCLKSR_DFLLRCS_Pos = 0x8
	// Bit mask of DFLLRCS field.
	SYSCTRL_PCLKSR_DFLLRCS_Msk = 0x100
	// Bit DFLLRCS.
	SYSCTRL_PCLKSR_DFLLRCS = 0x100
	// Position of BOD33RDY field.
	SYSCTRL_PCLKSR_BOD33RDY_Pos = 0x9
	// Bit mask of BOD33RDY field.
	SYSCTRL_PCLKSR_BOD33RDY_Msk = 0x200
	// Bit BOD33RDY.
	SYSCTRL_PCLKSR_BOD33RDY = 0x200
	// Position of BOD33DET field.
	SYSCTRL_PCLKSR_BOD33DET_Pos = 0xa
	// Bit mask of BOD33DET field.
	SYSCTRL_PCLKSR_BOD33DET_Msk = 0x400
	// Bit BOD33DET.
	SYSCTRL_PCLKSR_BOD33DET = 0x400
	// Position of B33SRDY field.
	SYSCTRL_PCLKSR_B33SRDY_Pos = 0xb
	// Bit mask of B33SRDY field.
	SYSCTRL_PCLKSR_B33SRDY_Msk = 0x800
	// Bit B33SRDY.
	SYSCTRL_PCLKSR_B33SRDY = 0x800
	// Position of DPLLLCKR field.
	SYSCTRL_PCLKSR_DPLLLCKR_Pos = 0xf
	// Bit mask of DPLLLCKR field.
	SYSCTRL_PCLKSR_DPLLLCKR_Msk = 0x8000
	// Bit DPLLLCKR.
	SYSCTRL_PCLKSR_DPLLLCKR = 0x8000
	// Position of DPLLLCKF field.
	SYSCTRL_PCLKSR_DPLLLCKF_Pos = 0x10
	// Bit mask of DPLLLCKF field.
	SYSCTRL_PCLKSR_DPLLLCKF_Msk = 0x10000
	// Bit DPLLLCKF.
	SYSCTRL_PCLKSR_DPLLLCKF = 0x10000
	// Position of DPLLLTO field.
	SYSCTRL_PCLKSR_DPLLLTO_Pos = 0x11
	// Bit mask of DPLLLTO field.
	SYSCTRL_PCLKSR_DPLLLTO_Msk = 0x20000
	// Bit DPLLLTO.
	SYSCTRL_PCLKSR_DPLLLTO = 0x20000

	// XOSC: External Multipurpose Crystal Oscillator (XOSC) Control
	// Position of ENABLE field.
	SYSCTRL_XOSC_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SYSCTRL_XOSC_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SYSCTRL_XOSC_ENABLE = 0x2
	// Position of XTALEN field.
	SYSCTRL_XOSC_XTALEN_Pos = 0x2
	// Bit mask of XTALEN field.
	SYSCTRL_XOSC_XTALEN_Msk = 0x4
	// Bit XTALEN.
	SYSCTRL_XOSC_XTALEN = 0x4
	// Position of RUNSTDBY field.
	SYSCTRL_XOSC_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	SYSCTRL_XOSC_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	SYSCTRL_XOSC_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	SYSCTRL_XOSC_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	SYSCTRL_XOSC_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	SYSCTRL_XOSC_ONDEMAND = 0x80
	// Position of GAIN field.
	SYSCTRL_XOSC_GAIN_Pos = 0x8
	// Bit mask of GAIN field.
	SYSCTRL_XOSC_GAIN_Msk = 0x700
	// 2MHz
	SYSCTRL_XOSC_GAIN_0 = 0x0
	// 4MHz
	SYSCTRL_XOSC_GAIN_1 = 0x1
	// 8MHz
	SYSCTRL_XOSC_GAIN_2 = 0x2
	// 16MHz
	SYSCTRL_XOSC_GAIN_3 = 0x3
	// 30MHz
	SYSCTRL_XOSC_GAIN_4 = 0x4
	// Position of AMPGC field.
	SYSCTRL_XOSC_AMPGC_Pos = 0xb
	// Bit mask of AMPGC field.
	SYSCTRL_XOSC_AMPGC_Msk = 0x800
	// Bit AMPGC.
	SYSCTRL_XOSC_AMPGC = 0x800
	// Position of STARTUP field.
	SYSCTRL_XOSC_STARTUP_Pos = 0xc
	// Bit mask of STARTUP field.
	SYSCTRL_XOSC_STARTUP_Msk = 0xf000

	// XOSC32K: 32kHz External Crystal Oscillator (XOSC32K) Control
	// Position of ENABLE field.
	SYSCTRL_XOSC32K_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SYSCTRL_XOSC32K_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SYSCTRL_XOSC32K_ENABLE = 0x2
	// Position of XTALEN field.
	SYSCTRL_XOSC32K_XTALEN_Pos = 0x2
	// Bit mask of XTALEN field.
	SYSCTRL_XOSC32K_XTALEN_Msk = 0x4
	// Bit XTALEN.
	SYSCTRL_XOSC32K_XTALEN = 0x4
	// Position of EN32K field.
	SYSCTRL_XOSC32K_EN32K_Pos = 0x3
	// Bit mask of EN32K field.
	SYSCTRL_XOSC32K_EN32K_Msk = 0x8
	// Bit EN32K.
	SYSCTRL_XOSC32K_EN32K = 0x8
	// Position of EN1K field.
	SYSCTRL_XOSC32K_EN1K_Pos = 0x4
	// Bit mask of EN1K field.
	SYSCTRL_XOSC32K_EN1K_Msk = 0x10
	// Bit EN1K.
	SYSCTRL_XOSC32K_EN1K = 0x10
	// Position of AAMPEN field.
	SYSCTRL_XOSC32K_AAMPEN_Pos = 0x5
	// Bit mask of AAMPEN field.
	SYSCTRL_XOSC32K_AAMPEN_Msk = 0x20
	// Bit AAMPEN.
	SYSCTRL_XOSC32K_AAMPEN = 0x20
	// Position of RUNSTDBY field.
	SYSCTRL_XOSC32K_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	SYSCTRL_XOSC32K_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	SYSCTRL_XOSC32K_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	SYSCTRL_XOSC32K_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	SYSCTRL_XOSC32K_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	SYSCTRL_XOSC32K_ONDEMAND = 0x80
	// Position of STARTUP field.
	SYSCTRL_XOSC32K_STARTUP_Pos = 0x8
	// Bit mask of STARTUP field.
	SYSCTRL_XOSC32K_STARTUP_Msk = 0x700
	// Position of WRTLOCK field.
	SYSCTRL_XOSC32K_WRTLOCK_Pos = 0xc
	// Bit mask of WRTLOCK field.
	SYSCTRL_XOSC32K_WRTLOCK_Msk = 0x1000
	// Bit WRTLOCK.
	SYSCTRL_XOSC32K_WRTLOCK = 0x1000

	// OSC32K: 32kHz Internal Oscillator (OSC32K) Control
	// Position of ENABLE field.
	SYSCTRL_OSC32K_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SYSCTRL_OSC32K_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SYSCTRL_OSC32K_ENABLE = 0x2
	// Position of EN32K field.
	SYSCTRL_OSC32K_EN32K_Pos = 0x2
	// Bit mask of EN32K field.
	SYSCTRL_OSC32K_EN32K_Msk = 0x4
	// Bit EN32K.
	SYSCTRL_OSC32K_EN32K = 0x4
	// Position of EN1K field.
	SYSCTRL_OSC32K_EN1K_Pos = 0x3
	// Bit mask of EN1K field.
	SYSCTRL_OSC32K_EN1K_Msk = 0x8
	// Bit EN1K.
	SYSCTRL_OSC32K_EN1K = 0x8
	// Position of RUNSTDBY field.
	SYSCTRL_OSC32K_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	SYSCTRL_OSC32K_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	SYSCTRL_OSC32K_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	SYSCTRL_OSC32K_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	SYSCTRL_OSC32K_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	SYSCTRL_OSC32K_ONDEMAND = 0x80
	// Position of STARTUP field.
	SYSCTRL_OSC32K_STARTUP_Pos = 0x8
	// Bit mask of STARTUP field.
	SYSCTRL_OSC32K_STARTUP_Msk = 0x700
	// Position of WRTLOCK field.
	SYSCTRL_OSC32K_WRTLOCK_Pos = 0xc
	// Bit mask of WRTLOCK field.
	SYSCTRL_OSC32K_WRTLOCK_Msk = 0x1000
	// Bit WRTLOCK.
	SYSCTRL_OSC32K_WRTLOCK = 0x1000
	// Position of CALIB field.
	SYSCTRL_OSC32K_CALIB_Pos = 0x10
	// Bit mask of CALIB field.
	SYSCTRL_OSC32K_CALIB_Msk = 0x7f0000

	// OSCULP32K: 32kHz Ultra Low Power Internal Oscillator (OSCULP32K) Control
	// Position of CALIB field.
	SYSCTRL_OSCULP32K_CALIB_Pos = 0x0
	// Bit mask of CALIB field.
	SYSCTRL_OSCULP32K_CALIB_Msk = 0x1f
	// Position of WRTLOCK field.
	SYSCTRL_OSCULP32K_WRTLOCK_Pos = 0x7
	// Bit mask of WRTLOCK field.
	SYSCTRL_OSCULP32K_WRTLOCK_Msk = 0x80
	// Bit WRTLOCK.
	SYSCTRL_OSCULP32K_WRTLOCK = 0x80

	// OSC8M: 8MHz Internal Oscillator (OSC8M) Control
	// Position of ENABLE field.
	SYSCTRL_OSC8M_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SYSCTRL_OSC8M_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SYSCTRL_OSC8M_ENABLE = 0x2
	// Position of RUNSTDBY field.
	SYSCTRL_OSC8M_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	SYSCTRL_OSC8M_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	SYSCTRL_OSC8M_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	SYSCTRL_OSC8M_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	SYSCTRL_OSC8M_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	SYSCTRL_OSC8M_ONDEMAND = 0x80
	// Position of PRESC field.
	SYSCTRL_OSC8M_PRESC_Pos = 0x8
	// Bit mask of PRESC field.
	SYSCTRL_OSC8M_PRESC_Msk = 0x300
	// 1
	SYSCTRL_OSC8M_PRESC_0 = 0x0
	// 2
	SYSCTRL_OSC8M_PRESC_1 = 0x1
	// 4
	SYSCTRL_OSC8M_PRESC_2 = 0x2
	// 8
	SYSCTRL_OSC8M_PRESC_3 = 0x3
	// Position of CALIB field.
	SYSCTRL_OSC8M_CALIB_Pos = 0x10
	// Bit mask of CALIB field.
	SYSCTRL_OSC8M_CALIB_Msk = 0xfff0000
	// Position of FRANGE field.
	SYSCTRL_OSC8M_FRANGE_Pos = 0x1e
	// Bit mask of FRANGE field.
	SYSCTRL_OSC8M_FRANGE_Msk = 0xc0000000
	// 4 to 6MHz
	SYSCTRL_OSC8M_FRANGE_0 = 0x0
	// 6 to 8MHz
	SYSCTRL_OSC8M_FRANGE_1 = 0x1
	// 8 to 11MHz
	SYSCTRL_OSC8M_FRANGE_2 = 0x2
	// 11 to 15MHz
	SYSCTRL_OSC8M_FRANGE_3 = 0x3

	// DFLLCTRL: DFLL48M Control
	// Position of ENABLE field.
	SYSCTRL_DFLLCTRL_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SYSCTRL_DFLLCTRL_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SYSCTRL_DFLLCTRL_ENABLE = 0x2
	// Position of MODE field.
	SYSCTRL_DFLLCTRL_MODE_Pos = 0x2
	// Bit mask of MODE field.
	SYSCTRL_DFLLCTRL_MODE_Msk = 0x4
	// Bit MODE.
	SYSCTRL_DFLLCTRL_MODE = 0x4
	// Position of STABLE field.
	SYSCTRL_DFLLCTRL_STABLE_Pos = 0x3
	// Bit mask of STABLE field.
	SYSCTRL_DFLLCTRL_STABLE_Msk = 0x8
	// Bit STABLE.
	SYSCTRL_DFLLCTRL_STABLE = 0x8
	// Position of LLAW field.
	SYSCTRL_DFLLCTRL_LLAW_Pos = 0x4
	// Bit mask of LLAW field.
	SYSCTRL_DFLLCTRL_LLAW_Msk = 0x10
	// Bit LLAW.
	SYSCTRL_DFLLCTRL_LLAW = 0x10
	// Position of USBCRM field.
	SYSCTRL_DFLLCTRL_USBCRM_Pos = 0x5
	// Bit mask of USBCRM field.
	SYSCTRL_DFLLCTRL_USBCRM_Msk = 0x20
	// Bit USBCRM.
	SYSCTRL_DFLLCTRL_USBCRM = 0x20
	// Position of RUNSTDBY field.
	SYSCTRL_DFLLCTRL_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	SYSCTRL_DFLLCTRL_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	SYSCTRL_DFLLCTRL_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	SYSCTRL_DFLLCTRL_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	SYSCTRL_DFLLCTRL_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	SYSCTRL_DFLLCTRL_ONDEMAND = 0x80
	// Position of CCDIS field.
	SYSCTRL_DFLLCTRL_CCDIS_Pos = 0x8
	// Bit mask of CCDIS field.
	SYSCTRL_DFLLCTRL_CCDIS_Msk = 0x100
	// Bit CCDIS.
	SYSCTRL_DFLLCTRL_CCDIS = 0x100
	// Position of QLDIS field.
	SYSCTRL_DFLLCTRL_QLDIS_Pos = 0x9
	// Bit mask of QLDIS field.
	SYSCTRL_DFLLCTRL_QLDIS_Msk = 0x200
	// Bit QLDIS.
	SYSCTRL_DFLLCTRL_QLDIS = 0x200
	// Position of BPLCKC field.
	SYSCTRL_DFLLCTRL_BPLCKC_Pos = 0xa
	// Bit mask of BPLCKC field.
	SYSCTRL_DFLLCTRL_BPLCKC_Msk = 0x400
	// Bit BPLCKC.
	SYSCTRL_DFLLCTRL_BPLCKC = 0x400
	// Position of WAITLOCK field.
	SYSCTRL_DFLLCTRL_WAITLOCK_Pos = 0xb
	// Bit mask of WAITLOCK field.
	SYSCTRL_DFLLCTRL_WAITLOCK_Msk = 0x800
	// Bit WAITLOCK.
	SYSCTRL_DFLLCTRL_WAITLOCK = 0x800

	// DFLLVAL: DFLL48M Value
	// Position of FINE field.
	SYSCTRL_DFLLVAL_FINE_Pos = 0x0
	// Bit mask of FINE field.
	SYSCTRL_DFLLVAL_FINE_Msk = 0x3ff
	// Position of COARSE field.
	SYSCTRL_DFLLVAL_COARSE_Pos = 0xa
	// Bit mask of COARSE field.
	SYSCTRL_DFLLVAL_COARSE_Msk = 0xfc00
	// Position of DIFF field.
	SYSCTRL_DFLLVAL_DIFF_Pos = 0x10
	// Bit mask of DIFF field.
	SYSCTRL_DFLLVAL_DIFF_Msk = 0xffff0000

	// DFLLMUL: DFLL48M Multiplier
	// Position of MUL field.
	SYSCTRL_DFLLMUL_MUL_Pos = 0x0
	// Bit mask of MUL field.
	SYSCTRL_DFLLMUL_MUL_Msk = 0xffff
	// Position of FSTEP field.
	SYSCTRL_DFLLMUL_FSTEP_Pos = 0x10
	// Bit mask of FSTEP field.
	SYSCTRL_DFLLMUL_FSTEP_Msk = 0x3ff0000
	// Position of CSTEP field.
	SYSCTRL_DFLLMUL_CSTEP_Pos = 0x1a
	// Bit mask of CSTEP field.
	SYSCTRL_DFLLMUL_CSTEP_Msk = 0xfc000000

	// DFLLSYNC: DFLL48M Synchronization
	// Position of READREQ field.
	SYSCTRL_DFLLSYNC_READREQ_Pos = 0x7
	// Bit mask of READREQ field.
	SYSCTRL_DFLLSYNC_READREQ_Msk = 0x80
	// Bit READREQ.
	SYSCTRL_DFLLSYNC_READREQ = 0x80

	// BOD33: 3.3V Brown-Out Detector (BOD33) Control
	// Position of ENABLE field.
	SYSCTRL_BOD33_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SYSCTRL_BOD33_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SYSCTRL_BOD33_ENABLE = 0x2
	// Position of HYST field.
	SYSCTRL_BOD33_HYST_Pos = 0x2
	// Bit mask of HYST field.
	SYSCTRL_BOD33_HYST_Msk = 0x4
	// Bit HYST.
	SYSCTRL_BOD33_HYST = 0x4
	// Position of ACTION field.
	SYSCTRL_BOD33_ACTION_Pos = 0x3
	// Bit mask of ACTION field.
	SYSCTRL_BOD33_ACTION_Msk = 0x18
	// No action
	SYSCTRL_BOD33_ACTION_NONE = 0x0
	// The BOD33 generates a reset
	SYSCTRL_BOD33_ACTION_RESET = 0x1
	// The BOD33 generates an interrupt
	SYSCTRL_BOD33_ACTION_INTERRUPT = 0x2
	// Position of RUNSTDBY field.
	SYSCTRL_BOD33_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	SYSCTRL_BOD33_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	SYSCTRL_BOD33_RUNSTDBY = 0x40
	// Position of MODE field.
	SYSCTRL_BOD33_MODE_Pos = 0x8
	// Bit mask of MODE field.
	SYSCTRL_BOD33_MODE_Msk = 0x100
	// Bit MODE.
	SYSCTRL_BOD33_MODE = 0x100
	// Position of CEN field.
	SYSCTRL_BOD33_CEN_Pos = 0x9
	// Bit mask of CEN field.
	SYSCTRL_BOD33_CEN_Msk = 0x200
	// Bit CEN.
	SYSCTRL_BOD33_CEN = 0x200
	// Position of PSEL field.
	SYSCTRL_BOD33_PSEL_Pos = 0xc
	// Bit mask of PSEL field.
	SYSCTRL_BOD33_PSEL_Msk = 0xf000
	// Divide clock by 2
	SYSCTRL_BOD33_PSEL_DIV2 = 0x0
	// Divide clock by 4
	SYSCTRL_BOD33_PSEL_DIV4 = 0x1
	// Divide clock by 8
	SYSCTRL_BOD33_PSEL_DIV8 = 0x2
	// Divide clock by 16
	SYSCTRL_BOD33_PSEL_DIV16 = 0x3
	// Divide clock by 32
	SYSCTRL_BOD33_PSEL_DIV32 = 0x4
	// Divide clock by 64
	SYSCTRL_BOD33_PSEL_DIV64 = 0x5
	// Divide clock by 128
	SYSCTRL_BOD33_PSEL_DIV128 = 0x6
	// Divide clock by 256
	SYSCTRL_BOD33_PSEL_DIV256 = 0x7
	// Divide clock by 512
	SYSCTRL_BOD33_PSEL_DIV512 = 0x8
	// Divide clock by 1024
	SYSCTRL_BOD33_PSEL_DIV1K = 0x9
	// Divide clock by 2048
	SYSCTRL_BOD33_PSEL_DIV2K = 0xa
	// Divide clock by 4096
	SYSCTRL_BOD33_PSEL_DIV4K = 0xb
	// Divide clock by 8192
	SYSCTRL_BOD33_PSEL_DIV8K = 0xc
	// Divide clock by 16384
	SYSCTRL_BOD33_PSEL_DIV16K = 0xd
	// Divide clock by 32768
	SYSCTRL_BOD33_PSEL_DIV32K = 0xe
	// Divide clock by 65536
	SYSCTRL_BOD33_PSEL_DIV64K = 0xf
	// Position of LEVEL field.
	SYSCTRL_BOD33_LEVEL_Pos = 0x10
	// Bit mask of LEVEL field.
	SYSCTRL_BOD33_LEVEL_Msk = 0x3f0000

	// VREG: Voltage Regulator System (VREG) Control
	// Position of RUNSTDBY field.
	SYSCTRL_VREG_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	SYSCTRL_VREG_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	SYSCTRL_VREG_RUNSTDBY = 0x40
	// Position of FORCELDO field.
	SYSCTRL_VREG_FORCELDO_Pos = 0xd
	// Bit mask of FORCELDO field.
	SYSCTRL_VREG_FORCELDO_Msk = 0x2000
	// Bit FORCELDO.
	SYSCTRL_VREG_FORCELDO = 0x2000

	// VREF: Voltage References System (VREF) Control
	// Position of TSEN field.
	SYSCTRL_VREF_TSEN_Pos = 0x1
	// Bit mask of TSEN field.
	SYSCTRL_VREF_TSEN_Msk = 0x2
	// Bit TSEN.
	SYSCTRL_VREF_TSEN = 0x2
	// Position of BGOUTEN field.
	SYSCTRL_VREF_BGOUTEN_Pos = 0x2
	// Bit mask of BGOUTEN field.
	SYSCTRL_VREF_BGOUTEN_Msk = 0x4
	// Bit BGOUTEN.
	SYSCTRL_VREF_BGOUTEN = 0x4
	// Position of CALIB field.
	SYSCTRL_VREF_CALIB_Pos = 0x10
	// Bit mask of CALIB field.
	SYSCTRL_VREF_CALIB_Msk = 0x7ff0000

	// DPLLCTRLA: DPLL Control A
	// Position of ENABLE field.
	SYSCTRL_DPLLCTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	SYSCTRL_DPLLCTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	SYSCTRL_DPLLCTRLA_ENABLE = 0x2
	// Position of RUNSTDBY field.
	SYSCTRL_DPLLCTRLA_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	SYSCTRL_DPLLCTRLA_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	SYSCTRL_DPLLCTRLA_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	SYSCTRL_DPLLCTRLA_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	SYSCTRL_DPLLCTRLA_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	SYSCTRL_DPLLCTRLA_ONDEMAND = 0x80

	// DPLLRATIO: DPLL Ratio Control
	// Position of LDR field.
	SYSCTRL_DPLLRATIO_LDR_Pos = 0x0
	// Bit mask of LDR field.
	SYSCTRL_DPLLRATIO_LDR_Msk = 0xfff
	// Position of LDRFRAC field.
	SYSCTRL_DPLLRATIO_LDRFRAC_Pos = 0x10
	// Bit mask of LDRFRAC field.
	SYSCTRL_DPLLRATIO_LDRFRAC_Msk = 0xf0000

	// DPLLCTRLB: DPLL Control B
	// Position of FILTER field.
	SYSCTRL_DPLLCTRLB_FILTER_Pos = 0x0
	// Bit mask of FILTER field.
	SYSCTRL_DPLLCTRLB_FILTER_Msk = 0x3
	// Default filter mode
	SYSCTRL_DPLLCTRLB_FILTER_DEFAULT = 0x0
	// Low bandwidth filter
	SYSCTRL_DPLLCTRLB_FILTER_LBFILT = 0x1
	// High bandwidth filter
	SYSCTRL_DPLLCTRLB_FILTER_HBFILT = 0x2
	// High damping filter
	SYSCTRL_DPLLCTRLB_FILTER_HDFILT = 0x3
	// Position of LPEN field.
	SYSCTRL_DPLLCTRLB_LPEN_Pos = 0x2
	// Bit mask of LPEN field.
	SYSCTRL_DPLLCTRLB_LPEN_Msk = 0x4
	// Bit LPEN.
	SYSCTRL_DPLLCTRLB_LPEN = 0x4
	// Position of WUF field.
	SYSCTRL_DPLLCTRLB_WUF_Pos = 0x3
	// Bit mask of WUF field.
	SYSCTRL_DPLLCTRLB_WUF_Msk = 0x8
	// Bit WUF.
	SYSCTRL_DPLLCTRLB_WUF = 0x8
	// Position of REFCLK field.
	SYSCTRL_DPLLCTRLB_REFCLK_Pos = 0x4
	// Bit mask of REFCLK field.
	SYSCTRL_DPLLCTRLB_REFCLK_Msk = 0x30
	// CLK_DPLL_REF0 clock reference
	SYSCTRL_DPLLCTRLB_REFCLK_REF0 = 0x0
	// CLK_DPLL_REF1 clock reference
	SYSCTRL_DPLLCTRLB_REFCLK_REF1 = 0x1
	// GCLK_DPLL clock reference
	SYSCTRL_DPLLCTRLB_REFCLK_GCLK = 0x2
	// Position of LTIME field.
	SYSCTRL_DPLLCTRLB_LTIME_Pos = 0x8
	// Bit mask of LTIME field.
	SYSCTRL_DPLLCTRLB_LTIME_Msk = 0x700
	// No time-out
	SYSCTRL_DPLLCTRLB_LTIME_DEFAULT = 0x0
	// Time-out if no lock within 8 ms
	SYSCTRL_DPLLCTRLB_LTIME_8MS = 0x4
	// Time-out if no lock within 9 ms
	SYSCTRL_DPLLCTRLB_LTIME_9MS = 0x5
	// Time-out if no lock within 10 ms
	SYSCTRL_DPLLCTRLB_LTIME_10MS = 0x6
	// Time-out if no lock within 11 ms
	SYSCTRL_DPLLCTRLB_LTIME_11MS = 0x7
	// Position of LBYPASS field.
	SYSCTRL_DPLLCTRLB_LBYPASS_Pos = 0xc
	// Bit mask of LBYPASS field.
	SYSCTRL_DPLLCTRLB_LBYPASS_Msk = 0x1000
	// Bit LBYPASS.
	SYSCTRL_DPLLCTRLB_LBYPASS = 0x1000
	// Position of DIV field.
	SYSCTRL_DPLLCTRLB_DIV_Pos = 0x10
	// Bit mask of DIV field.
	SYSCTRL_DPLLCTRLB_DIV_Msk = 0x7ff0000

	// DPLLSTATUS: DPLL Status
	// Position of LOCK field.
	SYSCTRL_DPLLSTATUS_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	SYSCTRL_DPLLSTATUS_LOCK_Msk = 0x1
	// Bit LOCK.
	SYSCTRL_DPLLSTATUS_LOCK = 0x1
	// Position of CLKRDY field.
	SYSCTRL_DPLLSTATUS_CLKRDY_Pos = 0x1
	// Bit mask of CLKRDY field.
	SYSCTRL_DPLLSTATUS_CLKRDY_Msk = 0x2
	// Bit CLKRDY.
	SYSCTRL_DPLLSTATUS_CLKRDY = 0x2
	// Position of ENABLE field.
	SYSCTRL_DPLLSTATUS_ENABLE_Pos = 0x2
	// Bit mask of ENABLE field.
	SYSCTRL_DPLLSTATUS_ENABLE_Msk = 0x4
	// Bit ENABLE.
	SYSCTRL_DPLLSTATUS_ENABLE = 0x4
	// Position of DIV field.
	SYSCTRL_DPLLSTATUS_DIV_Pos = 0x3
	// Bit mask of DIV field.
	SYSCTRL_DPLLSTATUS_DIV_Msk = 0x8
	// Bit DIV.
	SYSCTRL_DPLLSTATUS_DIV = 0x8
)

// Constants for TC3: Basic Timer Counter 3
const ()

// Constants for TC3_COUNT8: Basic Timer Counter 3 - COUNT8
const (
	// CTRLA: Control A
	// Position of SWRST field.
	TC_COUNT8_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	TC_COUNT8_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	TC_COUNT8_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	TC_COUNT8_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	TC_COUNT8_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	TC_COUNT8_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	TC_COUNT8_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	TC_COUNT8_CTRLA_MODE_Msk = 0xc
	// Counter in 16-bit mode
	TC_COUNT8_CTRLA_MODE_COUNT16 = 0x0
	// Counter in 8-bit mode
	TC_COUNT8_CTRLA_MODE_COUNT8 = 0x1
	// Counter in 32-bit mode
	TC_COUNT8_CTRLA_MODE_COUNT32 = 0x2
	// Position of WAVEGEN field.
	TC_COUNT8_CTRLA_WAVEGEN_Pos = 0x5
	// Bit mask of WAVEGEN field.
	TC_COUNT8_CTRLA_WAVEGEN_Msk  = 0x60
	TC_COUNT8_CTRLA_WAVEGEN_NFRQ = 0x0
	TC_COUNT8_CTRLA_WAVEGEN_MFRQ = 0x1
	TC_COUNT8_CTRLA_WAVEGEN_NPWM = 0x2
	TC_COUNT8_CTRLA_WAVEGEN_MPWM = 0x3
	// Position of PRESCALER field.
	TC_COUNT8_CTRLA_PRESCALER_Pos = 0x8
	// Bit mask of PRESCALER field.
	TC_COUNT8_CTRLA_PRESCALER_Msk = 0x700
	// Prescaler: GCLK_TC
	TC_COUNT8_CTRLA_PRESCALER_DIV1 = 0x0
	// Prescaler: GCLK_TC/2
	TC_COUNT8_CTRLA_PRESCALER_DIV2 = 0x1
	// Prescaler: GCLK_TC/4
	TC_COUNT8_CTRLA_PRESCALER_DIV4 = 0x2
	// Prescaler: GCLK_TC/8
	TC_COUNT8_CTRLA_PRESCALER_DIV8 = 0x3
	// Prescaler: GCLK_TC/16
	TC_COUNT8_CTRLA_PRESCALER_DIV16 = 0x4
	// Prescaler: GCLK_TC/64
	TC_COUNT8_CTRLA_PRESCALER_DIV64 = 0x5
	// Prescaler: GCLK_TC/256
	TC_COUNT8_CTRLA_PRESCALER_DIV256 = 0x6
	// Prescaler: GCLK_TC/1024
	TC_COUNT8_CTRLA_PRESCALER_DIV1024 = 0x7
	// Position of RUNSTDBY field.
	TC_COUNT8_CTRLA_RUNSTDBY_Pos = 0xb
	// Bit mask of RUNSTDBY field.
	TC_COUNT8_CTRLA_RUNSTDBY_Msk = 0x800
	// Bit RUNSTDBY.
	TC_COUNT8_CTRLA_RUNSTDBY = 0x800
	// Position of PRESCSYNC field.
	TC_COUNT8_CTRLA_PRESCSYNC_Pos = 0xc
	// Bit mask of PRESCSYNC field.
	TC_COUNT8_CTRLA_PRESCSYNC_Msk = 0x3000
	// Reload or reset the counter on next generic clock
	TC_COUNT8_CTRLA_PRESCSYNC_GCLK = 0x0
	// Reload or reset the counter on next prescaler clock
	TC_COUNT8_CTRLA_PRESCSYNC_PRESC = 0x1
	// Reload or reset the counter on next generic clock. Reset the prescaler counter
	TC_COUNT8_CTRLA_PRESCSYNC_RESYNC = 0x2

	// READREQ: Read Request
	// Position of ADDR field.
	TC_COUNT8_READREQ_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	TC_COUNT8_READREQ_ADDR_Msk = 0x1f
	// Position of RCONT field.
	TC_COUNT8_READREQ_RCONT_Pos = 0xe
	// Bit mask of RCONT field.
	TC_COUNT8_READREQ_RCONT_Msk = 0x4000
	// Bit RCONT.
	TC_COUNT8_READREQ_RCONT = 0x4000
	// Position of RREQ field.
	TC_COUNT8_READREQ_RREQ_Pos = 0xf
	// Bit mask of RREQ field.
	TC_COUNT8_READREQ_RREQ_Msk = 0x8000
	// Bit RREQ.
	TC_COUNT8_READREQ_RREQ = 0x8000

	// CTRLBCLR: Control B Clear
	// Position of DIR field.
	TC_COUNT8_CTRLBCLR_DIR_Pos = 0x0
	// Bit mask of DIR field.
	TC_COUNT8_CTRLBCLR_DIR_Msk = 0x1
	// Bit DIR.
	TC_COUNT8_CTRLBCLR_DIR = 0x1
	// Position of ONESHOT field.
	TC_COUNT8_CTRLBCLR_ONESHOT_Pos = 0x2
	// Bit mask of ONESHOT field.
	TC_COUNT8_CTRLBCLR_ONESHOT_Msk = 0x4
	// Bit ONESHOT.
	TC_COUNT8_CTRLBCLR_ONESHOT = 0x4
	// Position of CMD field.
	TC_COUNT8_CTRLBCLR_CMD_Pos = 0x6
	// Bit mask of CMD field.
	TC_COUNT8_CTRLBCLR_CMD_Msk = 0xc0
	// No action
	TC_COUNT8_CTRLBCLR_CMD_NONE = 0x0
	// Force a start, restart or retrigger
	TC_COUNT8_CTRLBCLR_CMD_RETRIGGER = 0x1
	// Force a stop
	TC_COUNT8_CTRLBCLR_CMD_STOP = 0x2

	// CTRLBSET: Control B Set
	// Position of DIR field.
	TC_COUNT8_CTRLBSET_DIR_Pos = 0x0
	// Bit mask of DIR field.
	TC_COUNT8_CTRLBSET_DIR_Msk = 0x1
	// Bit DIR.
	TC_COUNT8_CTRLBSET_DIR = 0x1
	// Position of ONESHOT field.
	TC_COUNT8_CTRLBSET_ONESHOT_Pos = 0x2
	// Bit mask of ONESHOT field.
	TC_COUNT8_CTRLBSET_ONESHOT_Msk = 0x4
	// Bit ONESHOT.
	TC_COUNT8_CTRLBSET_ONESHOT = 0x4
	// Position of CMD field.
	TC_COUNT8_CTRLBSET_CMD_Pos = 0x6
	// Bit mask of CMD field.
	TC_COUNT8_CTRLBSET_CMD_Msk = 0xc0
	// No action
	TC_COUNT8_CTRLBSET_CMD_NONE = 0x0
	// Force a start, restart or retrigger
	TC_COUNT8_CTRLBSET_CMD_RETRIGGER = 0x1
	// Force a stop
	TC_COUNT8_CTRLBSET_CMD_STOP = 0x2

	// CTRLC: Control C
	// Position of INVEN0 field.
	TC_COUNT8_CTRLC_INVEN0_Pos = 0x0
	// Bit mask of INVEN0 field.
	TC_COUNT8_CTRLC_INVEN0_Msk = 0x1
	// Bit INVEN0.
	TC_COUNT8_CTRLC_INVEN0 = 0x1
	// Position of INVEN1 field.
	TC_COUNT8_CTRLC_INVEN1_Pos = 0x1
	// Bit mask of INVEN1 field.
	TC_COUNT8_CTRLC_INVEN1_Msk = 0x2
	// Bit INVEN1.
	TC_COUNT8_CTRLC_INVEN1 = 0x2
	// Position of CPTEN0 field.
	TC_COUNT8_CTRLC_CPTEN0_Pos = 0x4
	// Bit mask of CPTEN0 field.
	TC_COUNT8_CTRLC_CPTEN0_Msk = 0x10
	// Bit CPTEN0.
	TC_COUNT8_CTRLC_CPTEN0 = 0x10
	// Position of CPTEN1 field.
	TC_COUNT8_CTRLC_CPTEN1_Pos = 0x5
	// Bit mask of CPTEN1 field.
	TC_COUNT8_CTRLC_CPTEN1_Msk = 0x20
	// Bit CPTEN1.
	TC_COUNT8_CTRLC_CPTEN1 = 0x20

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	TC_COUNT8_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	TC_COUNT8_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	TC_COUNT8_DBGCTRL_DBGRUN = 0x1

	// EVCTRL: Event Control
	// Position of EVACT field.
	TC_COUNT8_EVCTRL_EVACT_Pos = 0x0
	// Bit mask of EVACT field.
	TC_COUNT8_EVCTRL_EVACT_Msk = 0x7
	// Event action disabled
	TC_COUNT8_EVCTRL_EVACT_OFF = 0x0
	// Start, restart or retrigger TC on event
	TC_COUNT8_EVCTRL_EVACT_RETRIGGER = 0x1
	// Count on event
	TC_COUNT8_EVCTRL_EVACT_COUNT = 0x2
	// Start TC on event
	TC_COUNT8_EVCTRL_EVACT_START = 0x3
	// Period captured in CC0, pulse width in CC1
	TC_COUNT8_EVCTRL_EVACT_PPW = 0x5
	// Period captured in CC1, pulse width in CC0
	TC_COUNT8_EVCTRL_EVACT_PWP = 0x6
	// Position of TCINV field.
	TC_COUNT8_EVCTRL_TCINV_Pos = 0x4
	// Bit mask of TCINV field.
	TC_COUNT8_EVCTRL_TCINV_Msk = 0x10
	// Bit TCINV.
	TC_COUNT8_EVCTRL_TCINV = 0x10
	// Position of TCEI field.
	TC_COUNT8_EVCTRL_TCEI_Pos = 0x5
	// Bit mask of TCEI field.
	TC_COUNT8_EVCTRL_TCEI_Msk = 0x20
	// Bit TCEI.
	TC_COUNT8_EVCTRL_TCEI = 0x20
	// Position of OVFEO field.
	TC_COUNT8_EVCTRL_OVFEO_Pos = 0x8
	// Bit mask of OVFEO field.
	TC_COUNT8_EVCTRL_OVFEO_Msk = 0x100
	// Bit OVFEO.
	TC_COUNT8_EVCTRL_OVFEO = 0x100
	// Position of MCEO0 field.
	TC_COUNT8_EVCTRL_MCEO0_Pos = 0xc
	// Bit mask of MCEO0 field.
	TC_COUNT8_EVCTRL_MCEO0_Msk = 0x1000
	// Bit MCEO0.
	TC_COUNT8_EVCTRL_MCEO0 = 0x1000
	// Position of MCEO1 field.
	TC_COUNT8_EVCTRL_MCEO1_Pos = 0xd
	// Bit mask of MCEO1 field.
	TC_COUNT8_EVCTRL_MCEO1_Msk = 0x2000
	// Bit MCEO1.
	TC_COUNT8_EVCTRL_MCEO1 = 0x2000

	// INTENCLR: Interrupt Enable Clear
	// Position of OVF field.
	TC_COUNT8_INTENCLR_OVF_Pos = 0x0
	// Bit mask of OVF field.
	TC_COUNT8_INTENCLR_OVF_Msk = 0x1
	// Bit OVF.
	TC_COUNT8_INTENCLR_OVF = 0x1
	// Position of ERR field.
	TC_COUNT8_INTENCLR_ERR_Pos = 0x1
	// Bit mask of ERR field.
	TC_COUNT8_INTENCLR_ERR_Msk = 0x2
	// Bit ERR.
	TC_COUNT8_INTENCLR_ERR = 0x2
	// Position of SYNCRDY field.
	TC_COUNT8_INTENCLR_SYNCRDY_Pos = 0x3
	// Bit mask of SYNCRDY field.
	TC_COUNT8_INTENCLR_SYNCRDY_Msk = 0x8
	// Bit SYNCRDY.
	TC_COUNT8_INTENCLR_SYNCRDY = 0x8
	// Position of MC0 field.
	TC_COUNT8_INTENCLR_MC0_Pos = 0x4
	// Bit mask of MC0 field.
	TC_COUNT8_INTENCLR_MC0_Msk = 0x10
	// Bit MC0.
	TC_COUNT8_INTENCLR_MC0 = 0x10
	// Position of MC1 field.
	TC_COUNT8_INTENCLR_MC1_Pos = 0x5
	// Bit mask of MC1 field.
	TC_COUNT8_INTENCLR_MC1_Msk = 0x20
	// Bit MC1.
	TC_COUNT8_INTENCLR_MC1 = 0x20

	// INTENSET: Interrupt Enable Set
	// Position of OVF field.
	TC_COUNT8_INTENSET_OVF_Pos = 0x0
	// Bit mask of OVF field.
	TC_COUNT8_INTENSET_OVF_Msk = 0x1
	// Bit OVF.
	TC_COUNT8_INTENSET_OVF = 0x1
	// Position of ERR field.
	TC_COUNT8_INTENSET_ERR_Pos = 0x1
	// Bit mask of ERR field.
	TC_COUNT8_INTENSET_ERR_Msk = 0x2
	// Bit ERR.
	TC_COUNT8_INTENSET_ERR = 0x2
	// Position of SYNCRDY field.
	TC_COUNT8_INTENSET_SYNCRDY_Pos = 0x3
	// Bit mask of SYNCRDY field.
	TC_COUNT8_INTENSET_SYNCRDY_Msk = 0x8
	// Bit SYNCRDY.
	TC_COUNT8_INTENSET_SYNCRDY = 0x8
	// Position of MC0 field.
	TC_COUNT8_INTENSET_MC0_Pos = 0x4
	// Bit mask of MC0 field.
	TC_COUNT8_INTENSET_MC0_Msk = 0x10
	// Bit MC0.
	TC_COUNT8_INTENSET_MC0 = 0x10
	// Position of MC1 field.
	TC_COUNT8_INTENSET_MC1_Pos = 0x5
	// Bit mask of MC1 field.
	TC_COUNT8_INTENSET_MC1_Msk = 0x20
	// Bit MC1.
	TC_COUNT8_INTENSET_MC1 = 0x20

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of OVF field.
	TC_COUNT8_INTFLAG_OVF_Pos = 0x0
	// Bit mask of OVF field.
	TC_COUNT8_INTFLAG_OVF_Msk = 0x1
	// Bit OVF.
	TC_COUNT8_INTFLAG_OVF = 0x1
	// Position of ERR field.
	TC_COUNT8_INTFLAG_ERR_Pos = 0x1
	// Bit mask of ERR field.
	TC_COUNT8_INTFLAG_ERR_Msk = 0x2
	// Bit ERR.
	TC_COUNT8_INTFLAG_ERR = 0x2
	// Position of SYNCRDY field.
	TC_COUNT8_INTFLAG_SYNCRDY_Pos = 0x3
	// Bit mask of SYNCRDY field.
	TC_COUNT8_INTFLAG_SYNCRDY_Msk = 0x8
	// Bit SYNCRDY.
	TC_COUNT8_INTFLAG_SYNCRDY = 0x8
	// Position of MC0 field.
	TC_COUNT8_INTFLAG_MC0_Pos = 0x4
	// Bit mask of MC0 field.
	TC_COUNT8_INTFLAG_MC0_Msk = 0x10
	// Bit MC0.
	TC_COUNT8_INTFLAG_MC0 = 0x10
	// Position of MC1 field.
	TC_COUNT8_INTFLAG_MC1_Pos = 0x5
	// Bit mask of MC1 field.
	TC_COUNT8_INTFLAG_MC1_Msk = 0x20
	// Bit MC1.
	TC_COUNT8_INTFLAG_MC1 = 0x20

	// STATUS: Status
	// Position of STOP field.
	TC_COUNT8_STATUS_STOP_Pos = 0x3
	// Bit mask of STOP field.
	TC_COUNT8_STATUS_STOP_Msk = 0x8
	// Bit STOP.
	TC_COUNT8_STATUS_STOP = 0x8
	// Position of SLAVE field.
	TC_COUNT8_STATUS_SLAVE_Pos = 0x4
	// Bit mask of SLAVE field.
	TC_COUNT8_STATUS_SLAVE_Msk = 0x10
	// Bit SLAVE.
	TC_COUNT8_STATUS_SLAVE = 0x10
	// Position of SYNCBUSY field.
	TC_COUNT8_STATUS_SYNCBUSY_Pos = 0x7
	// Bit mask of SYNCBUSY field.
	TC_COUNT8_STATUS_SYNCBUSY_Msk = 0x80
	// Bit SYNCBUSY.
	TC_COUNT8_STATUS_SYNCBUSY = 0x80

	// COUNT: COUNT8 Counter Value
	// Position of COUNT field.
	TC_COUNT8_COUNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	TC_COUNT8_COUNT_COUNT_Msk = 0xff

	// PER: COUNT8 Period Value
	// Position of PER field.
	TC_COUNT8_PER_PER_Pos = 0x0
	// Bit mask of PER field.
	TC_COUNT8_PER_PER_Msk = 0xff

	// CC0: COUNT8 Compare/Capture
	// Position of CC field.
	TC_COUNT8_CC_CC_Pos = 0x0
	// Bit mask of CC field.
	TC_COUNT8_CC_CC_Msk = 0xff
)

// Constants for TC3_COUNT16: Basic Timer Counter 3 - COUNT16
const (
	// CTRLA: Control A
	// Position of SWRST field.
	TC_COUNT16_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	TC_COUNT16_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	TC_COUNT16_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	TC_COUNT16_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	TC_COUNT16_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	TC_COUNT16_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	TC_COUNT16_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	TC_COUNT16_CTRLA_MODE_Msk = 0xc
	// Counter in 16-bit mode
	TC_COUNT16_CTRLA_MODE_COUNT16 = 0x0
	// Counter in 8-bit mode
	TC_COUNT16_CTRLA_MODE_COUNT8 = 0x1
	// Counter in 32-bit mode
	TC_COUNT16_CTRLA_MODE_COUNT32 = 0x2
	// Position of WAVEGEN field.
	TC_COUNT16_CTRLA_WAVEGEN_Pos = 0x5
	// Bit mask of WAVEGEN field.
	TC_COUNT16_CTRLA_WAVEGEN_Msk  = 0x60
	TC_COUNT16_CTRLA_WAVEGEN_NFRQ = 0x0
	TC_COUNT16_CTRLA_WAVEGEN_MFRQ = 0x1
	TC_COUNT16_CTRLA_WAVEGEN_NPWM = 0x2
	TC_COUNT16_CTRLA_WAVEGEN_MPWM = 0x3
	// Position of PRESCALER field.
	TC_COUNT16_CTRLA_PRESCALER_Pos = 0x8
	// Bit mask of PRESCALER field.
	TC_COUNT16_CTRLA_PRESCALER_Msk = 0x700
	// Prescaler: GCLK_TC
	TC_COUNT16_CTRLA_PRESCALER_DIV1 = 0x0
	// Prescaler: GCLK_TC/2
	TC_COUNT16_CTRLA_PRESCALER_DIV2 = 0x1
	// Prescaler: GCLK_TC/4
	TC_COUNT16_CTRLA_PRESCALER_DIV4 = 0x2
	// Prescaler: GCLK_TC/8
	TC_COUNT16_CTRLA_PRESCALER_DIV8 = 0x3
	// Prescaler: GCLK_TC/16
	TC_COUNT16_CTRLA_PRESCALER_DIV16 = 0x4
	// Prescaler: GCLK_TC/64
	TC_COUNT16_CTRLA_PRESCALER_DIV64 = 0x5
	// Prescaler: GCLK_TC/256
	TC_COUNT16_CTRLA_PRESCALER_DIV256 = 0x6
	// Prescaler: GCLK_TC/1024
	TC_COUNT16_CTRLA_PRESCALER_DIV1024 = 0x7
	// Position of RUNSTDBY field.
	TC_COUNT16_CTRLA_RUNSTDBY_Pos = 0xb
	// Bit mask of RUNSTDBY field.
	TC_COUNT16_CTRLA_RUNSTDBY_Msk = 0x800
	// Bit RUNSTDBY.
	TC_COUNT16_CTRLA_RUNSTDBY = 0x800
	// Position of PRESCSYNC field.
	TC_COUNT16_CTRLA_PRESCSYNC_Pos = 0xc
	// Bit mask of PRESCSYNC field.
	TC_COUNT16_CTRLA_PRESCSYNC_Msk = 0x3000
	// Reload or reset the counter on next generic clock
	TC_COUNT16_CTRLA_PRESCSYNC_GCLK = 0x0
	// Reload or reset the counter on next prescaler clock
	TC_COUNT16_CTRLA_PRESCSYNC_PRESC = 0x1
	// Reload or reset the counter on next generic clock. Reset the prescaler counter
	TC_COUNT16_CTRLA_PRESCSYNC_RESYNC = 0x2

	// READREQ: Read Request
	// Position of ADDR field.
	TC_COUNT16_READREQ_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	TC_COUNT16_READREQ_ADDR_Msk = 0x1f
	// Position of RCONT field.
	TC_COUNT16_READREQ_RCONT_Pos = 0xe
	// Bit mask of RCONT field.
	TC_COUNT16_READREQ_RCONT_Msk = 0x4000
	// Bit RCONT.
	TC_COUNT16_READREQ_RCONT = 0x4000
	// Position of RREQ field.
	TC_COUNT16_READREQ_RREQ_Pos = 0xf
	// Bit mask of RREQ field.
	TC_COUNT16_READREQ_RREQ_Msk = 0x8000
	// Bit RREQ.
	TC_COUNT16_READREQ_RREQ = 0x8000

	// CTRLBCLR: Control B Clear
	// Position of DIR field.
	TC_COUNT16_CTRLBCLR_DIR_Pos = 0x0
	// Bit mask of DIR field.
	TC_COUNT16_CTRLBCLR_DIR_Msk = 0x1
	// Bit DIR.
	TC_COUNT16_CTRLBCLR_DIR = 0x1
	// Position of ONESHOT field.
	TC_COUNT16_CTRLBCLR_ONESHOT_Pos = 0x2
	// Bit mask of ONESHOT field.
	TC_COUNT16_CTRLBCLR_ONESHOT_Msk = 0x4
	// Bit ONESHOT.
	TC_COUNT16_CTRLBCLR_ONESHOT = 0x4
	// Position of CMD field.
	TC_COUNT16_CTRLBCLR_CMD_Pos = 0x6
	// Bit mask of CMD field.
	TC_COUNT16_CTRLBCLR_CMD_Msk = 0xc0
	// No action
	TC_COUNT16_CTRLBCLR_CMD_NONE = 0x0
	// Force a start, restart or retrigger
	TC_COUNT16_CTRLBCLR_CMD_RETRIGGER = 0x1
	// Force a stop
	TC_COUNT16_CTRLBCLR_CMD_STOP = 0x2

	// CTRLBSET: Control B Set
	// Position of DIR field.
	TC_COUNT16_CTRLBSET_DIR_Pos = 0x0
	// Bit mask of DIR field.
	TC_COUNT16_CTRLBSET_DIR_Msk = 0x1
	// Bit DIR.
	TC_COUNT16_CTRLBSET_DIR = 0x1
	// Position of ONESHOT field.
	TC_COUNT16_CTRLBSET_ONESHOT_Pos = 0x2
	// Bit mask of ONESHOT field.
	TC_COUNT16_CTRLBSET_ONESHOT_Msk = 0x4
	// Bit ONESHOT.
	TC_COUNT16_CTRLBSET_ONESHOT = 0x4
	// Position of CMD field.
	TC_COUNT16_CTRLBSET_CMD_Pos = 0x6
	// Bit mask of CMD field.
	TC_COUNT16_CTRLBSET_CMD_Msk = 0xc0
	// No action
	TC_COUNT16_CTRLBSET_CMD_NONE = 0x0
	// Force a start, restart or retrigger
	TC_COUNT16_CTRLBSET_CMD_RETRIGGER = 0x1
	// Force a stop
	TC_COUNT16_CTRLBSET_CMD_STOP = 0x2

	// CTRLC: Control C
	// Position of INVEN0 field.
	TC_COUNT16_CTRLC_INVEN0_Pos = 0x0
	// Bit mask of INVEN0 field.
	TC_COUNT16_CTRLC_INVEN0_Msk = 0x1
	// Bit INVEN0.
	TC_COUNT16_CTRLC_INVEN0 = 0x1
	// Position of INVEN1 field.
	TC_COUNT16_CTRLC_INVEN1_Pos = 0x1
	// Bit mask of INVEN1 field.
	TC_COUNT16_CTRLC_INVEN1_Msk = 0x2
	// Bit INVEN1.
	TC_COUNT16_CTRLC_INVEN1 = 0x2
	// Position of CPTEN0 field.
	TC_COUNT16_CTRLC_CPTEN0_Pos = 0x4
	// Bit mask of CPTEN0 field.
	TC_COUNT16_CTRLC_CPTEN0_Msk = 0x10
	// Bit CPTEN0.
	TC_COUNT16_CTRLC_CPTEN0 = 0x10
	// Position of CPTEN1 field.
	TC_COUNT16_CTRLC_CPTEN1_Pos = 0x5
	// Bit mask of CPTEN1 field.
	TC_COUNT16_CTRLC_CPTEN1_Msk = 0x20
	// Bit CPTEN1.
	TC_COUNT16_CTRLC_CPTEN1 = 0x20

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	TC_COUNT16_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	TC_COUNT16_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	TC_COUNT16_DBGCTRL_DBGRUN = 0x1

	// EVCTRL: Event Control
	// Position of EVACT field.
	TC_COUNT16_EVCTRL_EVACT_Pos = 0x0
	// Bit mask of EVACT field.
	TC_COUNT16_EVCTRL_EVACT_Msk = 0x7
	// Event action disabled
	TC_COUNT16_EVCTRL_EVACT_OFF = 0x0
	// Start, restart or retrigger TC on event
	TC_COUNT16_EVCTRL_EVACT_RETRIGGER = 0x1
	// Count on event
	TC_COUNT16_EVCTRL_EVACT_COUNT = 0x2
	// Start TC on event
	TC_COUNT16_EVCTRL_EVACT_START = 0x3
	// Period captured in CC0, pulse width in CC1
	TC_COUNT16_EVCTRL_EVACT_PPW = 0x5
	// Period captured in CC1, pulse width in CC0
	TC_COUNT16_EVCTRL_EVACT_PWP = 0x6
	// Position of TCINV field.
	TC_COUNT16_EVCTRL_TCINV_Pos = 0x4
	// Bit mask of TCINV field.
	TC_COUNT16_EVCTRL_TCINV_Msk = 0x10
	// Bit TCINV.
	TC_COUNT16_EVCTRL_TCINV = 0x10
	// Position of TCEI field.
	TC_COUNT16_EVCTRL_TCEI_Pos = 0x5
	// Bit mask of TCEI field.
	TC_COUNT16_EVCTRL_TCEI_Msk = 0x20
	// Bit TCEI.
	TC_COUNT16_EVCTRL_TCEI = 0x20
	// Position of OVFEO field.
	TC_COUNT16_EVCTRL_OVFEO_Pos = 0x8
	// Bit mask of OVFEO field.
	TC_COUNT16_EVCTRL_OVFEO_Msk = 0x100
	// Bit OVFEO.
	TC_COUNT16_EVCTRL_OVFEO = 0x100
	// Position of MCEO0 field.
	TC_COUNT16_EVCTRL_MCEO0_Pos = 0xc
	// Bit mask of MCEO0 field.
	TC_COUNT16_EVCTRL_MCEO0_Msk = 0x1000
	// Bit MCEO0.
	TC_COUNT16_EVCTRL_MCEO0 = 0x1000
	// Position of MCEO1 field.
	TC_COUNT16_EVCTRL_MCEO1_Pos = 0xd
	// Bit mask of MCEO1 field.
	TC_COUNT16_EVCTRL_MCEO1_Msk = 0x2000
	// Bit MCEO1.
	TC_COUNT16_EVCTRL_MCEO1 = 0x2000

	// INTENCLR: Interrupt Enable Clear
	// Position of OVF field.
	TC_COUNT16_INTENCLR_OVF_Pos = 0x0
	// Bit mask of OVF field.
	TC_COUNT16_INTENCLR_OVF_Msk = 0x1
	// Bit OVF.
	TC_COUNT16_INTENCLR_OVF = 0x1
	// Position of ERR field.
	TC_COUNT16_INTENCLR_ERR_Pos = 0x1
	// Bit mask of ERR field.
	TC_COUNT16_INTENCLR_ERR_Msk = 0x2
	// Bit ERR.
	TC_COUNT16_INTENCLR_ERR = 0x2
	// Position of SYNCRDY field.
	TC_COUNT16_INTENCLR_SYNCRDY_Pos = 0x3
	// Bit mask of SYNCRDY field.
	TC_COUNT16_INTENCLR_SYNCRDY_Msk = 0x8
	// Bit SYNCRDY.
	TC_COUNT16_INTENCLR_SYNCRDY = 0x8
	// Position of MC0 field.
	TC_COUNT16_INTENCLR_MC0_Pos = 0x4
	// Bit mask of MC0 field.
	TC_COUNT16_INTENCLR_MC0_Msk = 0x10
	// Bit MC0.
	TC_COUNT16_INTENCLR_MC0 = 0x10
	// Position of MC1 field.
	TC_COUNT16_INTENCLR_MC1_Pos = 0x5
	// Bit mask of MC1 field.
	TC_COUNT16_INTENCLR_MC1_Msk = 0x20
	// Bit MC1.
	TC_COUNT16_INTENCLR_MC1 = 0x20

	// INTENSET: Interrupt Enable Set
	// Position of OVF field.
	TC_COUNT16_INTENSET_OVF_Pos = 0x0
	// Bit mask of OVF field.
	TC_COUNT16_INTENSET_OVF_Msk = 0x1
	// Bit OVF.
	TC_COUNT16_INTENSET_OVF = 0x1
	// Position of ERR field.
	TC_COUNT16_INTENSET_ERR_Pos = 0x1
	// Bit mask of ERR field.
	TC_COUNT16_INTENSET_ERR_Msk = 0x2
	// Bit ERR.
	TC_COUNT16_INTENSET_ERR = 0x2
	// Position of SYNCRDY field.
	TC_COUNT16_INTENSET_SYNCRDY_Pos = 0x3
	// Bit mask of SYNCRDY field.
	TC_COUNT16_INTENSET_SYNCRDY_Msk = 0x8
	// Bit SYNCRDY.
	TC_COUNT16_INTENSET_SYNCRDY = 0x8
	// Position of MC0 field.
	TC_COUNT16_INTENSET_MC0_Pos = 0x4
	// Bit mask of MC0 field.
	TC_COUNT16_INTENSET_MC0_Msk = 0x10
	// Bit MC0.
	TC_COUNT16_INTENSET_MC0 = 0x10
	// Position of MC1 field.
	TC_COUNT16_INTENSET_MC1_Pos = 0x5
	// Bit mask of MC1 field.
	TC_COUNT16_INTENSET_MC1_Msk = 0x20
	// Bit MC1.
	TC_COUNT16_INTENSET_MC1 = 0x20

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of OVF field.
	TC_COUNT16_INTFLAG_OVF_Pos = 0x0
	// Bit mask of OVF field.
	TC_COUNT16_INTFLAG_OVF_Msk = 0x1
	// Bit OVF.
	TC_COUNT16_INTFLAG_OVF = 0x1
	// Position of ERR field.
	TC_COUNT16_INTFLAG_ERR_Pos = 0x1
	// Bit mask of ERR field.
	TC_COUNT16_INTFLAG_ERR_Msk = 0x2
	// Bit ERR.
	TC_COUNT16_INTFLAG_ERR = 0x2
	// Position of SYNCRDY field.
	TC_COUNT16_INTFLAG_SYNCRDY_Pos = 0x3
	// Bit mask of SYNCRDY field.
	TC_COUNT16_INTFLAG_SYNCRDY_Msk = 0x8
	// Bit SYNCRDY.
	TC_COUNT16_INTFLAG_SYNCRDY = 0x8
	// Position of MC0 field.
	TC_COUNT16_INTFLAG_MC0_Pos = 0x4
	// Bit mask of MC0 field.
	TC_COUNT16_INTFLAG_MC0_Msk = 0x10
	// Bit MC0.
	TC_COUNT16_INTFLAG_MC0 = 0x10
	// Position of MC1 field.
	TC_COUNT16_INTFLAG_MC1_Pos = 0x5
	// Bit mask of MC1 field.
	TC_COUNT16_INTFLAG_MC1_Msk = 0x20
	// Bit MC1.
	TC_COUNT16_INTFLAG_MC1 = 0x20

	// STATUS: Status
	// Position of STOP field.
	TC_COUNT16_STATUS_STOP_Pos = 0x3
	// Bit mask of STOP field.
	TC_COUNT16_STATUS_STOP_Msk = 0x8
	// Bit STOP.
	TC_COUNT16_STATUS_STOP = 0x8
	// Position of SLAVE field.
	TC_COUNT16_STATUS_SLAVE_Pos = 0x4
	// Bit mask of SLAVE field.
	TC_COUNT16_STATUS_SLAVE_Msk = 0x10
	// Bit SLAVE.
	TC_COUNT16_STATUS_SLAVE = 0x10
	// Position of SYNCBUSY field.
	TC_COUNT16_STATUS_SYNCBUSY_Pos = 0x7
	// Bit mask of SYNCBUSY field.
	TC_COUNT16_STATUS_SYNCBUSY_Msk = 0x80
	// Bit SYNCBUSY.
	TC_COUNT16_STATUS_SYNCBUSY = 0x80

	// COUNT: COUNT16 Counter Value
	// Position of COUNT field.
	TC_COUNT16_COUNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	TC_COUNT16_COUNT_COUNT_Msk = 0xffff

	// CC0: COUNT16 Compare/Capture
	// Position of CC field.
	TC_COUNT16_CC_CC_Pos = 0x0
	// Bit mask of CC field.
	TC_COUNT16_CC_CC_Msk = 0xffff
)

// Constants for TC3_COUNT32: Basic Timer Counter 3 - COUNT32
const (
	// CTRLA: Control A
	// Position of SWRST field.
	TC_COUNT32_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	TC_COUNT32_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	TC_COUNT32_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	TC_COUNT32_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	TC_COUNT32_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	TC_COUNT32_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	TC_COUNT32_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	TC_COUNT32_CTRLA_MODE_Msk = 0xc
	// Counter in 16-bit mode
	TC_COUNT32_CTRLA_MODE_COUNT16 = 0x0
	// Counter in 8-bit mode
	TC_COUNT32_CTRLA_MODE_COUNT8 = 0x1
	// Counter in 32-bit mode
	TC_COUNT32_CTRLA_MODE_COUNT32 = 0x2
	// Position of WAVEGEN field.
	TC_COUNT32_CTRLA_WAVEGEN_Pos = 0x5
	// Bit mask of WAVEGEN field.
	TC_COUNT32_CTRLA_WAVEGEN_Msk  = 0x60
	TC_COUNT32_CTRLA_WAVEGEN_NFRQ = 0x0
	TC_COUNT32_CTRLA_WAVEGEN_MFRQ = 0x1
	TC_COUNT32_CTRLA_WAVEGEN_NPWM = 0x2
	TC_COUNT32_CTRLA_WAVEGEN_MPWM = 0x3
	// Position of PRESCALER field.
	TC_COUNT32_CTRLA_PRESCALER_Pos = 0x8
	// Bit mask of PRESCALER field.
	TC_COUNT32_CTRLA_PRESCALER_Msk = 0x700
	// Prescaler: GCLK_TC
	TC_COUNT32_CTRLA_PRESCALER_DIV1 = 0x0
	// Prescaler: GCLK_TC/2
	TC_COUNT32_CTRLA_PRESCALER_DIV2 = 0x1
	// Prescaler: GCLK_TC/4
	TC_COUNT32_CTRLA_PRESCALER_DIV4 = 0x2
	// Prescaler: GCLK_TC/8
	TC_COUNT32_CTRLA_PRESCALER_DIV8 = 0x3
	// Prescaler: GCLK_TC/16
	TC_COUNT32_CTRLA_PRESCALER_DIV16 = 0x4
	// Prescaler: GCLK_TC/64
	TC_COUNT32_CTRLA_PRESCALER_DIV64 = 0x5
	// Prescaler: GCLK_TC/256
	TC_COUNT32_CTRLA_PRESCALER_DIV256 = 0x6
	// Prescaler: GCLK_TC/1024
	TC_COUNT32_CTRLA_PRESCALER_DIV1024 = 0x7
	// Position of RUNSTDBY field.
	TC_COUNT32_CTRLA_RUNSTDBY_Pos = 0xb
	// Bit mask of RUNSTDBY field.
	TC_COUNT32_CTRLA_RUNSTDBY_Msk = 0x800
	// Bit RUNSTDBY.
	TC_COUNT32_CTRLA_RUNSTDBY = 0x800
	// Position of PRESCSYNC field.
	TC_COUNT32_CTRLA_PRESCSYNC_Pos = 0xc
	// Bit mask of PRESCSYNC field.
	TC_COUNT32_CTRLA_PRESCSYNC_Msk = 0x3000
	// Reload or reset the counter on next generic clock
	TC_COUNT32_CTRLA_PRESCSYNC_GCLK = 0x0
	// Reload or reset the counter on next prescaler clock
	TC_COUNT32_CTRLA_PRESCSYNC_PRESC = 0x1
	// Reload or reset the counter on next generic clock. Reset the prescaler counter
	TC_COUNT32_CTRLA_PRESCSYNC_RESYNC = 0x2

	// READREQ: Read Request
	// Position of ADDR field.
	TC_COUNT32_READREQ_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	TC_COUNT32_READREQ_ADDR_Msk = 0x1f
	// Position of RCONT field.
	TC_COUNT32_READREQ_RCONT_Pos = 0xe
	// Bit mask of RCONT field.
	TC_COUNT32_READREQ_RCONT_Msk = 0x4000
	// Bit RCONT.
	TC_COUNT32_READREQ_RCONT = 0x4000
	// Position of RREQ field.
	TC_COUNT32_READREQ_RREQ_Pos = 0xf
	// Bit mask of RREQ field.
	TC_COUNT32_READREQ_RREQ_Msk = 0x8000
	// Bit RREQ.
	TC_COUNT32_READREQ_RREQ = 0x8000

	// CTRLBCLR: Control B Clear
	// Position of DIR field.
	TC_COUNT32_CTRLBCLR_DIR_Pos = 0x0
	// Bit mask of DIR field.
	TC_COUNT32_CTRLBCLR_DIR_Msk = 0x1
	// Bit DIR.
	TC_COUNT32_CTRLBCLR_DIR = 0x1
	// Position of ONESHOT field.
	TC_COUNT32_CTRLBCLR_ONESHOT_Pos = 0x2
	// Bit mask of ONESHOT field.
	TC_COUNT32_CTRLBCLR_ONESHOT_Msk = 0x4
	// Bit ONESHOT.
	TC_COUNT32_CTRLBCLR_ONESHOT = 0x4
	// Position of CMD field.
	TC_COUNT32_CTRLBCLR_CMD_Pos = 0x6
	// Bit mask of CMD field.
	TC_COUNT32_CTRLBCLR_CMD_Msk = 0xc0
	// No action
	TC_COUNT32_CTRLBCLR_CMD_NONE = 0x0
	// Force a start, restart or retrigger
	TC_COUNT32_CTRLBCLR_CMD_RETRIGGER = 0x1
	// Force a stop
	TC_COUNT32_CTRLBCLR_CMD_STOP = 0x2

	// CTRLBSET: Control B Set
	// Position of DIR field.
	TC_COUNT32_CTRLBSET_DIR_Pos = 0x0
	// Bit mask of DIR field.
	TC_COUNT32_CTRLBSET_DIR_Msk = 0x1
	// Bit DIR.
	TC_COUNT32_CTRLBSET_DIR = 0x1
	// Position of ONESHOT field.
	TC_COUNT32_CTRLBSET_ONESHOT_Pos = 0x2
	// Bit mask of ONESHOT field.
	TC_COUNT32_CTRLBSET_ONESHOT_Msk = 0x4
	// Bit ONESHOT.
	TC_COUNT32_CTRLBSET_ONESHOT = 0x4
	// Position of CMD field.
	TC_COUNT32_CTRLBSET_CMD_Pos = 0x6
	// Bit mask of CMD field.
	TC_COUNT32_CTRLBSET_CMD_Msk = 0xc0
	// No action
	TC_COUNT32_CTRLBSET_CMD_NONE = 0x0
	// Force a start, restart or retrigger
	TC_COUNT32_CTRLBSET_CMD_RETRIGGER = 0x1
	// Force a stop
	TC_COUNT32_CTRLBSET_CMD_STOP = 0x2

	// CTRLC: Control C
	// Position of INVEN0 field.
	TC_COUNT32_CTRLC_INVEN0_Pos = 0x0
	// Bit mask of INVEN0 field.
	TC_COUNT32_CTRLC_INVEN0_Msk = 0x1
	// Bit INVEN0.
	TC_COUNT32_CTRLC_INVEN0 = 0x1
	// Position of INVEN1 field.
	TC_COUNT32_CTRLC_INVEN1_Pos = 0x1
	// Bit mask of INVEN1 field.
	TC_COUNT32_CTRLC_INVEN1_Msk = 0x2
	// Bit INVEN1.
	TC_COUNT32_CTRLC_INVEN1 = 0x2
	// Position of CPTEN0 field.
	TC_COUNT32_CTRLC_CPTEN0_Pos = 0x4
	// Bit mask of CPTEN0 field.
	TC_COUNT32_CTRLC_CPTEN0_Msk = 0x10
	// Bit CPTEN0.
	TC_COUNT32_CTRLC_CPTEN0 = 0x10
	// Position of CPTEN1 field.
	TC_COUNT32_CTRLC_CPTEN1_Pos = 0x5
	// Bit mask of CPTEN1 field.
	TC_COUNT32_CTRLC_CPTEN1_Msk = 0x20
	// Bit CPTEN1.
	TC_COUNT32_CTRLC_CPTEN1 = 0x20

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	TC_COUNT32_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	TC_COUNT32_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	TC_COUNT32_DBGCTRL_DBGRUN = 0x1

	// EVCTRL: Event Control
	// Position of EVACT field.
	TC_COUNT32_EVCTRL_EVACT_Pos = 0x0
	// Bit mask of EVACT field.
	TC_COUNT32_EVCTRL_EVACT_Msk = 0x7
	// Event action disabled
	TC_COUNT32_EVCTRL_EVACT_OFF = 0x0
	// Start, restart or retrigger TC on event
	TC_COUNT32_EVCTRL_EVACT_RETRIGGER = 0x1
	// Count on event
	TC_COUNT32_EVCTRL_EVACT_COUNT = 0x2
	// Start TC on event
	TC_COUNT32_EVCTRL_EVACT_START = 0x3
	// Period captured in CC0, pulse width in CC1
	TC_COUNT32_EVCTRL_EVACT_PPW = 0x5
	// Period captured in CC1, pulse width in CC0
	TC_COUNT32_EVCTRL_EVACT_PWP = 0x6
	// Position of TCINV field.
	TC_COUNT32_EVCTRL_TCINV_Pos = 0x4
	// Bit mask of TCINV field.
	TC_COUNT32_EVCTRL_TCINV_Msk = 0x10
	// Bit TCINV.
	TC_COUNT32_EVCTRL_TCINV = 0x10
	// Position of TCEI field.
	TC_COUNT32_EVCTRL_TCEI_Pos = 0x5
	// Bit mask of TCEI field.
	TC_COUNT32_EVCTRL_TCEI_Msk = 0x20
	// Bit TCEI.
	TC_COUNT32_EVCTRL_TCEI = 0x20
	// Position of OVFEO field.
	TC_COUNT32_EVCTRL_OVFEO_Pos = 0x8
	// Bit mask of OVFEO field.
	TC_COUNT32_EVCTRL_OVFEO_Msk = 0x100
	// Bit OVFEO.
	TC_COUNT32_EVCTRL_OVFEO = 0x100
	// Position of MCEO0 field.
	TC_COUNT32_EVCTRL_MCEO0_Pos = 0xc
	// Bit mask of MCEO0 field.
	TC_COUNT32_EVCTRL_MCEO0_Msk = 0x1000
	// Bit MCEO0.
	TC_COUNT32_EVCTRL_MCEO0 = 0x1000
	// Position of MCEO1 field.
	TC_COUNT32_EVCTRL_MCEO1_Pos = 0xd
	// Bit mask of MCEO1 field.
	TC_COUNT32_EVCTRL_MCEO1_Msk = 0x2000
	// Bit MCEO1.
	TC_COUNT32_EVCTRL_MCEO1 = 0x2000

	// INTENCLR: Interrupt Enable Clear
	// Position of OVF field.
	TC_COUNT32_INTENCLR_OVF_Pos = 0x0
	// Bit mask of OVF field.
	TC_COUNT32_INTENCLR_OVF_Msk = 0x1
	// Bit OVF.
	TC_COUNT32_INTENCLR_OVF = 0x1
	// Position of ERR field.
	TC_COUNT32_INTENCLR_ERR_Pos = 0x1
	// Bit mask of ERR field.
	TC_COUNT32_INTENCLR_ERR_Msk = 0x2
	// Bit ERR.
	TC_COUNT32_INTENCLR_ERR = 0x2
	// Position of SYNCRDY field.
	TC_COUNT32_INTENCLR_SYNCRDY_Pos = 0x3
	// Bit mask of SYNCRDY field.
	TC_COUNT32_INTENCLR_SYNCRDY_Msk = 0x8
	// Bit SYNCRDY.
	TC_COUNT32_INTENCLR_SYNCRDY = 0x8
	// Position of MC0 field.
	TC_COUNT32_INTENCLR_MC0_Pos = 0x4
	// Bit mask of MC0 field.
	TC_COUNT32_INTENCLR_MC0_Msk = 0x10
	// Bit MC0.
	TC_COUNT32_INTENCLR_MC0 = 0x10
	// Position of MC1 field.
	TC_COUNT32_INTENCLR_MC1_Pos = 0x5
	// Bit mask of MC1 field.
	TC_COUNT32_INTENCLR_MC1_Msk = 0x20
	// Bit MC1.
	TC_COUNT32_INTENCLR_MC1 = 0x20

	// INTENSET: Interrupt Enable Set
	// Position of OVF field.
	TC_COUNT32_INTENSET_OVF_Pos = 0x0
	// Bit mask of OVF field.
	TC_COUNT32_INTENSET_OVF_Msk = 0x1
	// Bit OVF.
	TC_COUNT32_INTENSET_OVF = 0x1
	// Position of ERR field.
	TC_COUNT32_INTENSET_ERR_Pos = 0x1
	// Bit mask of ERR field.
	TC_COUNT32_INTENSET_ERR_Msk = 0x2
	// Bit ERR.
	TC_COUNT32_INTENSET_ERR = 0x2
	// Position of SYNCRDY field.
	TC_COUNT32_INTENSET_SYNCRDY_Pos = 0x3
	// Bit mask of SYNCRDY field.
	TC_COUNT32_INTENSET_SYNCRDY_Msk = 0x8
	// Bit SYNCRDY.
	TC_COUNT32_INTENSET_SYNCRDY = 0x8
	// Position of MC0 field.
	TC_COUNT32_INTENSET_MC0_Pos = 0x4
	// Bit mask of MC0 field.
	TC_COUNT32_INTENSET_MC0_Msk = 0x10
	// Bit MC0.
	TC_COUNT32_INTENSET_MC0 = 0x10
	// Position of MC1 field.
	TC_COUNT32_INTENSET_MC1_Pos = 0x5
	// Bit mask of MC1 field.
	TC_COUNT32_INTENSET_MC1_Msk = 0x20
	// Bit MC1.
	TC_COUNT32_INTENSET_MC1 = 0x20

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of OVF field.
	TC_COUNT32_INTFLAG_OVF_Pos = 0x0
	// Bit mask of OVF field.
	TC_COUNT32_INTFLAG_OVF_Msk = 0x1
	// Bit OVF.
	TC_COUNT32_INTFLAG_OVF = 0x1
	// Position of ERR field.
	TC_COUNT32_INTFLAG_ERR_Pos = 0x1
	// Bit mask of ERR field.
	TC_COUNT32_INTFLAG_ERR_Msk = 0x2
	// Bit ERR.
	TC_COUNT32_INTFLAG_ERR = 0x2
	// Position of SYNCRDY field.
	TC_COUNT32_INTFLAG_SYNCRDY_Pos = 0x3
	// Bit mask of SYNCRDY field.
	TC_COUNT32_INTFLAG_SYNCRDY_Msk = 0x8
	// Bit SYNCRDY.
	TC_COUNT32_INTFLAG_SYNCRDY = 0x8
	// Position of MC0 field.
	TC_COUNT32_INTFLAG_MC0_Pos = 0x4
	// Bit mask of MC0 field.
	TC_COUNT32_INTFLAG_MC0_Msk = 0x10
	// Bit MC0.
	TC_COUNT32_INTFLAG_MC0 = 0x10
	// Position of MC1 field.
	TC_COUNT32_INTFLAG_MC1_Pos = 0x5
	// Bit mask of MC1 field.
	TC_COUNT32_INTFLAG_MC1_Msk = 0x20
	// Bit MC1.
	TC_COUNT32_INTFLAG_MC1 = 0x20

	// STATUS: Status
	// Position of STOP field.
	TC_COUNT32_STATUS_STOP_Pos = 0x3
	// Bit mask of STOP field.
	TC_COUNT32_STATUS_STOP_Msk = 0x8
	// Bit STOP.
	TC_COUNT32_STATUS_STOP = 0x8
	// Position of SLAVE field.
	TC_COUNT32_STATUS_SLAVE_Pos = 0x4
	// Bit mask of SLAVE field.
	TC_COUNT32_STATUS_SLAVE_Msk = 0x10
	// Bit SLAVE.
	TC_COUNT32_STATUS_SLAVE = 0x10
	// Position of SYNCBUSY field.
	TC_COUNT32_STATUS_SYNCBUSY_Pos = 0x7
	// Bit mask of SYNCBUSY field.
	TC_COUNT32_STATUS_SYNCBUSY_Msk = 0x80
	// Bit SYNCBUSY.
	TC_COUNT32_STATUS_SYNCBUSY = 0x80

	// COUNT: COUNT32 Counter Value
	// Position of COUNT field.
	TC_COUNT32_COUNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	TC_COUNT32_COUNT_COUNT_Msk = 0xffffffff

	// CC0: COUNT32 Compare/Capture
	// Position of CC field.
	TC_COUNT32_CC_CC_Pos = 0x0
	// Bit mask of CC field.
	TC_COUNT32_CC_CC_Msk = 0xffffffff
)

// Constants for TCC0: Timer Counter Control 0
const (
	// CTRLA: Control A
	// Position of SWRST field.
	TCC_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	TCC_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	TCC_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	TCC_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	TCC_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	TCC_CTRLA_ENABLE = 0x2
	// Position of RESOLUTION field.
	TCC_CTRLA_RESOLUTION_Pos = 0x5
	// Bit mask of RESOLUTION field.
	TCC_CTRLA_RESOLUTION_Msk = 0x60
	// Dithering is disabled
	TCC_CTRLA_RESOLUTION_NONE = 0x0
	// Dithering is done every 16 PWM frames
	TCC_CTRLA_RESOLUTION_DITH4 = 0x1
	// Dithering is done every 32 PWM frames
	TCC_CTRLA_RESOLUTION_DITH5 = 0x2
	// Dithering is done every 64 PWM frames
	TCC_CTRLA_RESOLUTION_DITH6 = 0x3
	// Position of PRESCALER field.
	TCC_CTRLA_PRESCALER_Pos = 0x8
	// Bit mask of PRESCALER field.
	TCC_CTRLA_PRESCALER_Msk = 0x700
	// No division
	TCC_CTRLA_PRESCALER_DIV1 = 0x0
	// Divide by 2
	TCC_CTRLA_PRESCALER_DIV2 = 0x1
	// Divide by 4
	TCC_CTRLA_PRESCALER_DIV4 = 0x2
	// Divide by 8
	TCC_CTRLA_PRESCALER_DIV8 = 0x3
	// Divide by 16
	TCC_CTRLA_PRESCALER_DIV16 = 0x4
	// Divide by 64
	TCC_CTRLA_PRESCALER_DIV64 = 0x5
	// Divide by 256
	TCC_CTRLA_PRESCALER_DIV256 = 0x6
	// Divide by 1024
	TCC_CTRLA_PRESCALER_DIV1024 = 0x7
	// Position of RUNSTDBY field.
	TCC_CTRLA_RUNSTDBY_Pos = 0xb
	// Bit mask of RUNSTDBY field.
	TCC_CTRLA_RUNSTDBY_Msk = 0x800
	// Bit RUNSTDBY.
	TCC_CTRLA_RUNSTDBY = 0x800
	// Position of PRESCSYNC field.
	TCC_CTRLA_PRESCSYNC_Pos = 0xc
	// Bit mask of PRESCSYNC field.
	TCC_CTRLA_PRESCSYNC_Msk = 0x3000
	// Reload or reset counter on next GCLK
	TCC_CTRLA_PRESCSYNC_GCLK = 0x0
	// Reload or reset counter on next prescaler clock
	TCC_CTRLA_PRESCSYNC_PRESC = 0x1
	// Reload or reset counter on next GCLK and reset prescaler counter
	TCC_CTRLA_PRESCSYNC_RESYNC = 0x2
	// Position of ALOCK field.
	TCC_CTRLA_ALOCK_Pos = 0xe
	// Bit mask of ALOCK field.
	TCC_CTRLA_ALOCK_Msk = 0x4000
	// Bit ALOCK.
	TCC_CTRLA_ALOCK = 0x4000
	// Position of CPTEN0 field.
	TCC_CTRLA_CPTEN0_Pos = 0x18
	// Bit mask of CPTEN0 field.
	TCC_CTRLA_CPTEN0_Msk = 0x1000000
	// Bit CPTEN0.
	TCC_CTRLA_CPTEN0 = 0x1000000
	// Position of CPTEN1 field.
	TCC_CTRLA_CPTEN1_Pos = 0x19
	// Bit mask of CPTEN1 field.
	TCC_CTRLA_CPTEN1_Msk = 0x2000000
	// Bit CPTEN1.
	TCC_CTRLA_CPTEN1 = 0x2000000
	// Position of CPTEN2 field.
	TCC_CTRLA_CPTEN2_Pos = 0x1a
	// Bit mask of CPTEN2 field.
	TCC_CTRLA_CPTEN2_Msk = 0x4000000
	// Bit CPTEN2.
	TCC_CTRLA_CPTEN2 = 0x4000000
	// Position of CPTEN3 field.
	TCC_CTRLA_CPTEN3_Pos = 0x1b
	// Bit mask of CPTEN3 field.
	TCC_CTRLA_CPTEN3_Msk = 0x8000000
	// Bit CPTEN3.
	TCC_CTRLA_CPTEN3 = 0x8000000

	// CTRLBCLR: Control B Clear
	// Position of DIR field.
	TCC_CTRLBCLR_DIR_Pos = 0x0
	// Bit mask of DIR field.
	TCC_CTRLBCLR_DIR_Msk = 0x1
	// Bit DIR.
	TCC_CTRLBCLR_DIR = 0x1
	// Position of LUPD field.
	TCC_CTRLBCLR_LUPD_Pos = 0x1
	// Bit mask of LUPD field.
	TCC_CTRLBCLR_LUPD_Msk = 0x2
	// Bit LUPD.
	TCC_CTRLBCLR_LUPD = 0x2
	// Position of ONESHOT field.
	TCC_CTRLBCLR_ONESHOT_Pos = 0x2
	// Bit mask of ONESHOT field.
	TCC_CTRLBCLR_ONESHOT_Msk = 0x4
	// Bit ONESHOT.
	TCC_CTRLBCLR_ONESHOT = 0x4
	// Position of IDXCMD field.
	TCC_CTRLBCLR_IDXCMD_Pos = 0x3
	// Bit mask of IDXCMD field.
	TCC_CTRLBCLR_IDXCMD_Msk = 0x18
	// Command disabled: Index toggles between cycles A and B
	TCC_CTRLBCLR_IDXCMD_DISABLE = 0x0
	// Set index: cycle B will be forced in the next cycle
	TCC_CTRLBCLR_IDXCMD_SET = 0x1
	// Clear index: cycle A will be forced in the next cycle
	TCC_CTRLBCLR_IDXCMD_CLEAR = 0x2
	// Hold index: the next cycle will be the same as the current cycle
	TCC_CTRLBCLR_IDXCMD_HOLD = 0x3
	// Position of CMD field.
	TCC_CTRLBCLR_CMD_Pos = 0x5
	// Bit mask of CMD field.
	TCC_CTRLBCLR_CMD_Msk = 0xe0
	// No action
	TCC_CTRLBCLR_CMD_NONE = 0x0
	// Clear start, restart or retrigger
	TCC_CTRLBCLR_CMD_RETRIGGER = 0x1
	// Force stop
	TCC_CTRLBCLR_CMD_STOP = 0x2
	// Force update of double buffered registers
	TCC_CTRLBCLR_CMD_UPDATE = 0x3
	// Force COUNT read synchronization
	TCC_CTRLBCLR_CMD_READSYNC = 0x4

	// CTRLBSET: Control B Set
	// Position of DIR field.
	TCC_CTRLBSET_DIR_Pos = 0x0
	// Bit mask of DIR field.
	TCC_CTRLBSET_DIR_Msk = 0x1
	// Bit DIR.
	TCC_CTRLBSET_DIR = 0x1
	// Position of LUPD field.
	TCC_CTRLBSET_LUPD_Pos = 0x1
	// Bit mask of LUPD field.
	TCC_CTRLBSET_LUPD_Msk = 0x2
	// Bit LUPD.
	TCC_CTRLBSET_LUPD = 0x2
	// Position of ONESHOT field.
	TCC_CTRLBSET_ONESHOT_Pos = 0x2
	// Bit mask of ONESHOT field.
	TCC_CTRLBSET_ONESHOT_Msk = 0x4
	// Bit ONESHOT.
	TCC_CTRLBSET_ONESHOT = 0x4
	// Position of IDXCMD field.
	TCC_CTRLBSET_IDXCMD_Pos = 0x3
	// Bit mask of IDXCMD field.
	TCC_CTRLBSET_IDXCMD_Msk = 0x18
	// Command disabled: Index toggles between cycles A and B
	TCC_CTRLBSET_IDXCMD_DISABLE = 0x0
	// Set index: cycle B will be forced in the next cycle
	TCC_CTRLBSET_IDXCMD_SET = 0x1
	// Clear index: cycle A will be forced in the next cycle
	TCC_CTRLBSET_IDXCMD_CLEAR = 0x2
	// Hold index: the next cycle will be the same as the current cycle
	TCC_CTRLBSET_IDXCMD_HOLD = 0x3
	// Position of CMD field.
	TCC_CTRLBSET_CMD_Pos = 0x5
	// Bit mask of CMD field.
	TCC_CTRLBSET_CMD_Msk = 0xe0
	// No action
	TCC_CTRLBSET_CMD_NONE = 0x0
	// Clear start, restart or retrigger
	TCC_CTRLBSET_CMD_RETRIGGER = 0x1
	// Force stop
	TCC_CTRLBSET_CMD_STOP = 0x2
	// Force update of double buffered registers
	TCC_CTRLBSET_CMD_UPDATE = 0x3
	// Force COUNT read synchronization
	TCC_CTRLBSET_CMD_READSYNC = 0x4

	// SYNCBUSY: Synchronization Busy
	// Position of SWRST field.
	TCC_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	TCC_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	TCC_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	TCC_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	TCC_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	TCC_SYNCBUSY_ENABLE = 0x2
	// Position of CTRLB field.
	TCC_SYNCBUSY_CTRLB_Pos = 0x2
	// Bit mask of CTRLB field.
	TCC_SYNCBUSY_CTRLB_Msk = 0x4
	// Bit CTRLB.
	TCC_SYNCBUSY_CTRLB = 0x4
	// Position of STATUS field.
	TCC_SYNCBUSY_STATUS_Pos = 0x3
	// Bit mask of STATUS field.
	TCC_SYNCBUSY_STATUS_Msk = 0x8
	// Bit STATUS.
	TCC_SYNCBUSY_STATUS = 0x8
	// Position of COUNT field.
	TCC_SYNCBUSY_COUNT_Pos = 0x4
	// Bit mask of COUNT field.
	TCC_SYNCBUSY_COUNT_Msk = 0x10
	// Bit COUNT.
	TCC_SYNCBUSY_COUNT = 0x10
	// Position of PATT field.
	TCC_SYNCBUSY_PATT_Pos = 0x5
	// Bit mask of PATT field.
	TCC_SYNCBUSY_PATT_Msk = 0x20
	// Bit PATT.
	TCC_SYNCBUSY_PATT = 0x20
	// Position of WAVE field.
	TCC_SYNCBUSY_WAVE_Pos = 0x6
	// Bit mask of WAVE field.
	TCC_SYNCBUSY_WAVE_Msk = 0x40
	// Bit WAVE.
	TCC_SYNCBUSY_WAVE = 0x40
	// Position of PER field.
	TCC_SYNCBUSY_PER_Pos = 0x7
	// Bit mask of PER field.
	TCC_SYNCBUSY_PER_Msk = 0x80
	// Bit PER.
	TCC_SYNCBUSY_PER = 0x80
	// Position of CC0 field.
	TCC_SYNCBUSY_CC0_Pos = 0x8
	// Bit mask of CC0 field.
	TCC_SYNCBUSY_CC0_Msk = 0x100
	// Bit CC0.
	TCC_SYNCBUSY_CC0 = 0x100
	// Position of CC1 field.
	TCC_SYNCBUSY_CC1_Pos = 0x9
	// Bit mask of CC1 field.
	TCC_SYNCBUSY_CC1_Msk = 0x200
	// Bit CC1.
	TCC_SYNCBUSY_CC1 = 0x200
	// Position of CC2 field.
	TCC_SYNCBUSY_CC2_Pos = 0xa
	// Bit mask of CC2 field.
	TCC_SYNCBUSY_CC2_Msk = 0x400
	// Bit CC2.
	TCC_SYNCBUSY_CC2 = 0x400
	// Position of CC3 field.
	TCC_SYNCBUSY_CC3_Pos = 0xb
	// Bit mask of CC3 field.
	TCC_SYNCBUSY_CC3_Msk = 0x800
	// Bit CC3.
	TCC_SYNCBUSY_CC3 = 0x800
	// Position of PATTB field.
	TCC_SYNCBUSY_PATTB_Pos = 0x10
	// Bit mask of PATTB field.
	TCC_SYNCBUSY_PATTB_Msk = 0x10000
	// Bit PATTB.
	TCC_SYNCBUSY_PATTB = 0x10000
	// Position of WAVEB field.
	TCC_SYNCBUSY_WAVEB_Pos = 0x11
	// Bit mask of WAVEB field.
	TCC_SYNCBUSY_WAVEB_Msk = 0x20000
	// Bit WAVEB.
	TCC_SYNCBUSY_WAVEB = 0x20000
	// Position of PERB field.
	TCC_SYNCBUSY_PERB_Pos = 0x12
	// Bit mask of PERB field.
	TCC_SYNCBUSY_PERB_Msk = 0x40000
	// Bit PERB.
	TCC_SYNCBUSY_PERB = 0x40000
	// Position of CCB0 field.
	TCC_SYNCBUSY_CCB0_Pos = 0x13
	// Bit mask of CCB0 field.
	TCC_SYNCBUSY_CCB0_Msk = 0x80000
	// Bit CCB0.
	TCC_SYNCBUSY_CCB0 = 0x80000
	// Position of CCB1 field.
	TCC_SYNCBUSY_CCB1_Pos = 0x14
	// Bit mask of CCB1 field.
	TCC_SYNCBUSY_CCB1_Msk = 0x100000
	// Bit CCB1.
	TCC_SYNCBUSY_CCB1 = 0x100000
	// Position of CCB2 field.
	TCC_SYNCBUSY_CCB2_Pos = 0x15
	// Bit mask of CCB2 field.
	TCC_SYNCBUSY_CCB2_Msk = 0x200000
	// Bit CCB2.
	TCC_SYNCBUSY_CCB2 = 0x200000
	// Position of CCB3 field.
	TCC_SYNCBUSY_CCB3_Pos = 0x16
	// Bit mask of CCB3 field.
	TCC_SYNCBUSY_CCB3_Msk = 0x400000
	// Bit CCB3.
	TCC_SYNCBUSY_CCB3 = 0x400000

	// FCTRLA: Recoverable Fault A Configuration
	// Position of SRC field.
	TCC_FCTRLA_SRC_Pos = 0x0
	// Bit mask of SRC field.
	TCC_FCTRLA_SRC_Msk = 0x3
	// Fault input disabled
	TCC_FCTRLA_SRC_DISABLE = 0x0
	// MCEx (x=0,1) event input
	TCC_FCTRLA_SRC_ENABLE = 0x1
	// Inverted MCEx (x=0,1) event input
	TCC_FCTRLA_SRC_INVERT = 0x2
	// Alternate fault (A or B) state at the end of the previous period
	TCC_FCTRLA_SRC_ALTFAULT = 0x3
	// Position of KEEP field.
	TCC_FCTRLA_KEEP_Pos = 0x3
	// Bit mask of KEEP field.
	TCC_FCTRLA_KEEP_Msk = 0x8
	// Bit KEEP.
	TCC_FCTRLA_KEEP = 0x8
	// Position of QUAL field.
	TCC_FCTRLA_QUAL_Pos = 0x4
	// Bit mask of QUAL field.
	TCC_FCTRLA_QUAL_Msk = 0x10
	// Bit QUAL.
	TCC_FCTRLA_QUAL = 0x10
	// Position of BLANK field.
	TCC_FCTRLA_BLANK_Pos = 0x5
	// Bit mask of BLANK field.
	TCC_FCTRLA_BLANK_Msk = 0x60
	// No blanking applied
	TCC_FCTRLA_BLANK_NONE = 0x0
	// Blanking applied from rising edge of the output waveform
	TCC_FCTRLA_BLANK_RISE = 0x1
	// Blanking applied from falling edge of the output waveform
	TCC_FCTRLA_BLANK_FALL = 0x2
	// Blanking applied from each toggle of the output waveform
	TCC_FCTRLA_BLANK_BOTH = 0x3
	// Position of RESTART field.
	TCC_FCTRLA_RESTART_Pos = 0x7
	// Bit mask of RESTART field.
	TCC_FCTRLA_RESTART_Msk = 0x80
	// Bit RESTART.
	TCC_FCTRLA_RESTART = 0x80
	// Position of HALT field.
	TCC_FCTRLA_HALT_Pos = 0x8
	// Bit mask of HALT field.
	TCC_FCTRLA_HALT_Msk = 0x300
	// Halt action disabled
	TCC_FCTRLA_HALT_DISABLE = 0x0
	// Hardware halt action
	TCC_FCTRLA_HALT_HW = 0x1
	// Software halt action
	TCC_FCTRLA_HALT_SW = 0x2
	// Non-recoverable fault
	TCC_FCTRLA_HALT_NR = 0x3
	// Position of CHSEL field.
	TCC_FCTRLA_CHSEL_Pos = 0xa
	// Bit mask of CHSEL field.
	TCC_FCTRLA_CHSEL_Msk = 0xc00
	// Capture value stored in channel 0
	TCC_FCTRLA_CHSEL_CC0 = 0x0
	// Capture value stored in channel 1
	TCC_FCTRLA_CHSEL_CC1 = 0x1
	// Capture value stored in channel 2
	TCC_FCTRLA_CHSEL_CC2 = 0x2
	// Capture value stored in channel 3
	TCC_FCTRLA_CHSEL_CC3 = 0x3
	// Position of CAPTURE field.
	TCC_FCTRLA_CAPTURE_Pos = 0xc
	// Bit mask of CAPTURE field.
	TCC_FCTRLA_CAPTURE_Msk = 0x7000
	// No capture
	TCC_FCTRLA_CAPTURE_DISABLE = 0x0
	// Capture on fault
	TCC_FCTRLA_CAPTURE_CAPT = 0x1
	// Minimum capture
	TCC_FCTRLA_CAPTURE_CAPTMIN = 0x2
	// Maximum capture
	TCC_FCTRLA_CAPTURE_CAPTMAX = 0x3
	// Minimum local detection
	TCC_FCTRLA_CAPTURE_LOCMIN = 0x4
	// Maximum local detection
	TCC_FCTRLA_CAPTURE_LOCMAX = 0x5
	// Minimum and maximum local detection
	TCC_FCTRLA_CAPTURE_DERIV0 = 0x6
	// Position of BLANKVAL field.
	TCC_FCTRLA_BLANKVAL_Pos = 0x10
	// Bit mask of BLANKVAL field.
	TCC_FCTRLA_BLANKVAL_Msk = 0xff0000
	// Position of FILTERVAL field.
	TCC_FCTRLA_FILTERVAL_Pos = 0x18
	// Bit mask of FILTERVAL field.
	TCC_FCTRLA_FILTERVAL_Msk = 0xf000000

	// FCTRLB: Recoverable Fault B Configuration
	// Position of SRC field.
	TCC_FCTRLB_SRC_Pos = 0x0
	// Bit mask of SRC field.
	TCC_FCTRLB_SRC_Msk = 0x3
	// Fault input disabled
	TCC_FCTRLB_SRC_DISABLE = 0x0
	// MCEx (x=0,1) event input
	TCC_FCTRLB_SRC_ENABLE = 0x1
	// Inverted MCEx (x=0,1) event input
	TCC_FCTRLB_SRC_INVERT = 0x2
	// Alternate fault (A or B) state at the end of the previous period
	TCC_FCTRLB_SRC_ALTFAULT = 0x3
	// Position of KEEP field.
	TCC_FCTRLB_KEEP_Pos = 0x3
	// Bit mask of KEEP field.
	TCC_FCTRLB_KEEP_Msk = 0x8
	// Bit KEEP.
	TCC_FCTRLB_KEEP = 0x8
	// Position of QUAL field.
	TCC_FCTRLB_QUAL_Pos = 0x4
	// Bit mask of QUAL field.
	TCC_FCTRLB_QUAL_Msk = 0x10
	// Bit QUAL.
	TCC_FCTRLB_QUAL = 0x10
	// Position of BLANK field.
	TCC_FCTRLB_BLANK_Pos = 0x5
	// Bit mask of BLANK field.
	TCC_FCTRLB_BLANK_Msk = 0x60
	// No blanking applied
	TCC_FCTRLB_BLANK_NONE = 0x0
	// Blanking applied from rising edge of the output waveform
	TCC_FCTRLB_BLANK_RISE = 0x1
	// Blanking applied from falling edge of the output waveform
	TCC_FCTRLB_BLANK_FALL = 0x2
	// Blanking applied from each toggle of the output waveform
	TCC_FCTRLB_BLANK_BOTH = 0x3
	// Position of RESTART field.
	TCC_FCTRLB_RESTART_Pos = 0x7
	// Bit mask of RESTART field.
	TCC_FCTRLB_RESTART_Msk = 0x80
	// Bit RESTART.
	TCC_FCTRLB_RESTART = 0x80
	// Position of HALT field.
	TCC_FCTRLB_HALT_Pos = 0x8
	// Bit mask of HALT field.
	TCC_FCTRLB_HALT_Msk = 0x300
	// Halt action disabled
	TCC_FCTRLB_HALT_DISABLE = 0x0
	// Hardware halt action
	TCC_FCTRLB_HALT_HW = 0x1
	// Software halt action
	TCC_FCTRLB_HALT_SW = 0x2
	// Non-recoverable fault
	TCC_FCTRLB_HALT_NR = 0x3
	// Position of CHSEL field.
	TCC_FCTRLB_CHSEL_Pos = 0xa
	// Bit mask of CHSEL field.
	TCC_FCTRLB_CHSEL_Msk = 0xc00
	// Capture value stored in channel 0
	TCC_FCTRLB_CHSEL_CC0 = 0x0
	// Capture value stored in channel 1
	TCC_FCTRLB_CHSEL_CC1 = 0x1
	// Capture value stored in channel 2
	TCC_FCTRLB_CHSEL_CC2 = 0x2
	// Capture value stored in channel 3
	TCC_FCTRLB_CHSEL_CC3 = 0x3
	// Position of CAPTURE field.
	TCC_FCTRLB_CAPTURE_Pos = 0xc
	// Bit mask of CAPTURE field.
	TCC_FCTRLB_CAPTURE_Msk = 0x7000
	// No capture
	TCC_FCTRLB_CAPTURE_DISABLE = 0x0
	// Capture on fault
	TCC_FCTRLB_CAPTURE_CAPT = 0x1
	// Minimum capture
	TCC_FCTRLB_CAPTURE_CAPTMIN = 0x2
	// Maximum capture
	TCC_FCTRLB_CAPTURE_CAPTMAX = 0x3
	// Minimum local detection
	TCC_FCTRLB_CAPTURE_LOCMIN = 0x4
	// Maximum local detection
	TCC_FCTRLB_CAPTURE_LOCMAX = 0x5
	// Minimum and maximum local detection
	TCC_FCTRLB_CAPTURE_DERIV0 = 0x6
	// Position of BLANKVAL field.
	TCC_FCTRLB_BLANKVAL_Pos = 0x10
	// Bit mask of BLANKVAL field.
	TCC_FCTRLB_BLANKVAL_Msk = 0xff0000
	// Position of FILTERVAL field.
	TCC_FCTRLB_FILTERVAL_Pos = 0x18
	// Bit mask of FILTERVAL field.
	TCC_FCTRLB_FILTERVAL_Msk = 0xf000000

	// WEXCTRL: Waveform Extension Configuration
	// Position of OTMX field.
	TCC_WEXCTRL_OTMX_Pos = 0x0
	// Bit mask of OTMX field.
	TCC_WEXCTRL_OTMX_Msk = 0x3
	// Position of DTIEN0 field.
	TCC_WEXCTRL_DTIEN0_Pos = 0x8
	// Bit mask of DTIEN0 field.
	TCC_WEXCTRL_DTIEN0_Msk = 0x100
	// Bit DTIEN0.
	TCC_WEXCTRL_DTIEN0 = 0x100
	// Position of DTIEN1 field.
	TCC_WEXCTRL_DTIEN1_Pos = 0x9
	// Bit mask of DTIEN1 field.
	TCC_WEXCTRL_DTIEN1_Msk = 0x200
	// Bit DTIEN1.
	TCC_WEXCTRL_DTIEN1 = 0x200
	// Position of DTIEN2 field.
	TCC_WEXCTRL_DTIEN2_Pos = 0xa
	// Bit mask of DTIEN2 field.
	TCC_WEXCTRL_DTIEN2_Msk = 0x400
	// Bit DTIEN2.
	TCC_WEXCTRL_DTIEN2 = 0x400
	// Position of DTIEN3 field.
	TCC_WEXCTRL_DTIEN3_Pos = 0xb
	// Bit mask of DTIEN3 field.
	TCC_WEXCTRL_DTIEN3_Msk = 0x800
	// Bit DTIEN3.
	TCC_WEXCTRL_DTIEN3 = 0x800
	// Position of DTLS field.
	TCC_WEXCTRL_DTLS_Pos = 0x10
	// Bit mask of DTLS field.
	TCC_WEXCTRL_DTLS_Msk = 0xff0000
	// Position of DTHS field.
	TCC_WEXCTRL_DTHS_Pos = 0x18
	// Bit mask of DTHS field.
	TCC_WEXCTRL_DTHS_Msk = 0xff000000

	// DRVCTRL: Driver Control
	// Position of NRE0 field.
	TCC_DRVCTRL_NRE0_Pos = 0x0
	// Bit mask of NRE0 field.
	TCC_DRVCTRL_NRE0_Msk = 0x1
	// Bit NRE0.
	TCC_DRVCTRL_NRE0 = 0x1
	// Position of NRE1 field.
	TCC_DRVCTRL_NRE1_Pos = 0x1
	// Bit mask of NRE1 field.
	TCC_DRVCTRL_NRE1_Msk = 0x2
	// Bit NRE1.
	TCC_DRVCTRL_NRE1 = 0x2
	// Position of NRE2 field.
	TCC_DRVCTRL_NRE2_Pos = 0x2
	// Bit mask of NRE2 field.
	TCC_DRVCTRL_NRE2_Msk = 0x4
	// Bit NRE2.
	TCC_DRVCTRL_NRE2 = 0x4
	// Position of NRE3 field.
	TCC_DRVCTRL_NRE3_Pos = 0x3
	// Bit mask of NRE3 field.
	TCC_DRVCTRL_NRE3_Msk = 0x8
	// Bit NRE3.
	TCC_DRVCTRL_NRE3 = 0x8
	// Position of NRE4 field.
	TCC_DRVCTRL_NRE4_Pos = 0x4
	// Bit mask of NRE4 field.
	TCC_DRVCTRL_NRE4_Msk = 0x10
	// Bit NRE4.
	TCC_DRVCTRL_NRE4 = 0x10
	// Position of NRE5 field.
	TCC_DRVCTRL_NRE5_Pos = 0x5
	// Bit mask of NRE5 field.
	TCC_DRVCTRL_NRE5_Msk = 0x20
	// Bit NRE5.
	TCC_DRVCTRL_NRE5 = 0x20
	// Position of NRE6 field.
	TCC_DRVCTRL_NRE6_Pos = 0x6
	// Bit mask of NRE6 field.
	TCC_DRVCTRL_NRE6_Msk = 0x40
	// Bit NRE6.
	TCC_DRVCTRL_NRE6 = 0x40
	// Position of NRE7 field.
	TCC_DRVCTRL_NRE7_Pos = 0x7
	// Bit mask of NRE7 field.
	TCC_DRVCTRL_NRE7_Msk = 0x80
	// Bit NRE7.
	TCC_DRVCTRL_NRE7 = 0x80
	// Position of NRV0 field.
	TCC_DRVCTRL_NRV0_Pos = 0x8
	// Bit mask of NRV0 field.
	TCC_DRVCTRL_NRV0_Msk = 0x100
	// Bit NRV0.
	TCC_DRVCTRL_NRV0 = 0x100
	// Position of NRV1 field.
	TCC_DRVCTRL_NRV1_Pos = 0x9
	// Bit mask of NRV1 field.
	TCC_DRVCTRL_NRV1_Msk = 0x200
	// Bit NRV1.
	TCC_DRVCTRL_NRV1 = 0x200
	// Position of NRV2 field.
	TCC_DRVCTRL_NRV2_Pos = 0xa
	// Bit mask of NRV2 field.
	TCC_DRVCTRL_NRV2_Msk = 0x400
	// Bit NRV2.
	TCC_DRVCTRL_NRV2 = 0x400
	// Position of NRV3 field.
	TCC_DRVCTRL_NRV3_Pos = 0xb
	// Bit mask of NRV3 field.
	TCC_DRVCTRL_NRV3_Msk = 0x800
	// Bit NRV3.
	TCC_DRVCTRL_NRV3 = 0x800
	// Position of NRV4 field.
	TCC_DRVCTRL_NRV4_Pos = 0xc
	// Bit mask of NRV4 field.
	TCC_DRVCTRL_NRV4_Msk = 0x1000
	// Bit NRV4.
	TCC_DRVCTRL_NRV4 = 0x1000
	// Position of NRV5 field.
	TCC_DRVCTRL_NRV5_Pos = 0xd
	// Bit mask of NRV5 field.
	TCC_DRVCTRL_NRV5_Msk = 0x2000
	// Bit NRV5.
	TCC_DRVCTRL_NRV5 = 0x2000
	// Position of NRV6 field.
	TCC_DRVCTRL_NRV6_Pos = 0xe
	// Bit mask of NRV6 field.
	TCC_DRVCTRL_NRV6_Msk = 0x4000
	// Bit NRV6.
	TCC_DRVCTRL_NRV6 = 0x4000
	// Position of NRV7 field.
	TCC_DRVCTRL_NRV7_Pos = 0xf
	// Bit mask of NRV7 field.
	TCC_DRVCTRL_NRV7_Msk = 0x8000
	// Bit NRV7.
	TCC_DRVCTRL_NRV7 = 0x8000
	// Position of INVEN0 field.
	TCC_DRVCTRL_INVEN0_Pos = 0x10
	// Bit mask of INVEN0 field.
	TCC_DRVCTRL_INVEN0_Msk = 0x10000
	// Bit INVEN0.
	TCC_DRVCTRL_INVEN0 = 0x10000
	// Position of INVEN1 field.
	TCC_DRVCTRL_INVEN1_Pos = 0x11
	// Bit mask of INVEN1 field.
	TCC_DRVCTRL_INVEN1_Msk = 0x20000
	// Bit INVEN1.
	TCC_DRVCTRL_INVEN1 = 0x20000
	// Position of INVEN2 field.
	TCC_DRVCTRL_INVEN2_Pos = 0x12
	// Bit mask of INVEN2 field.
	TCC_DRVCTRL_INVEN2_Msk = 0x40000
	// Bit INVEN2.
	TCC_DRVCTRL_INVEN2 = 0x40000
	// Position of INVEN3 field.
	TCC_DRVCTRL_INVEN3_Pos = 0x13
	// Bit mask of INVEN3 field.
	TCC_DRVCTRL_INVEN3_Msk = 0x80000
	// Bit INVEN3.
	TCC_DRVCTRL_INVEN3 = 0x80000
	// Position of INVEN4 field.
	TCC_DRVCTRL_INVEN4_Pos = 0x14
	// Bit mask of INVEN4 field.
	TCC_DRVCTRL_INVEN4_Msk = 0x100000
	// Bit INVEN4.
	TCC_DRVCTRL_INVEN4 = 0x100000
	// Position of INVEN5 field.
	TCC_DRVCTRL_INVEN5_Pos = 0x15
	// Bit mask of INVEN5 field.
	TCC_DRVCTRL_INVEN5_Msk = 0x200000
	// Bit INVEN5.
	TCC_DRVCTRL_INVEN5 = 0x200000
	// Position of INVEN6 field.
	TCC_DRVCTRL_INVEN6_Pos = 0x16
	// Bit mask of INVEN6 field.
	TCC_DRVCTRL_INVEN6_Msk = 0x400000
	// Bit INVEN6.
	TCC_DRVCTRL_INVEN6 = 0x400000
	// Position of INVEN7 field.
	TCC_DRVCTRL_INVEN7_Pos = 0x17
	// Bit mask of INVEN7 field.
	TCC_DRVCTRL_INVEN7_Msk = 0x800000
	// Bit INVEN7.
	TCC_DRVCTRL_INVEN7 = 0x800000
	// Position of FILTERVAL0 field.
	TCC_DRVCTRL_FILTERVAL0_Pos = 0x18
	// Bit mask of FILTERVAL0 field.
	TCC_DRVCTRL_FILTERVAL0_Msk = 0xf000000
	// Position of FILTERVAL1 field.
	TCC_DRVCTRL_FILTERVAL1_Pos = 0x1c
	// Bit mask of FILTERVAL1 field.
	TCC_DRVCTRL_FILTERVAL1_Msk = 0xf0000000

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	TCC_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	TCC_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	TCC_DBGCTRL_DBGRUN = 0x1
	// Position of FDDBD field.
	TCC_DBGCTRL_FDDBD_Pos = 0x2
	// Bit mask of FDDBD field.
	TCC_DBGCTRL_FDDBD_Msk = 0x4
	// Bit FDDBD.
	TCC_DBGCTRL_FDDBD = 0x4

	// EVCTRL: Event Control
	// Position of EVACT0 field.
	TCC_EVCTRL_EVACT0_Pos = 0x0
	// Bit mask of EVACT0 field.
	TCC_EVCTRL_EVACT0_Msk = 0x7
	// Event action disabled
	TCC_EVCTRL_EVACT0_OFF = 0x0
	// Start, restart or re-trigger counter on event
	TCC_EVCTRL_EVACT0_RETRIGGER = 0x1
	// Count on event
	TCC_EVCTRL_EVACT0_COUNTEV = 0x2
	// Start counter on event
	TCC_EVCTRL_EVACT0_START = 0x3
	// Increment counter on event
	TCC_EVCTRL_EVACT0_INC = 0x4
	// Count on active state of asynchronous event
	TCC_EVCTRL_EVACT0_COUNT = 0x5
	// Non-recoverable fault
	TCC_EVCTRL_EVACT0_FAULT = 0x7
	// Position of EVACT1 field.
	TCC_EVCTRL_EVACT1_Pos = 0x3
	// Bit mask of EVACT1 field.
	TCC_EVCTRL_EVACT1_Msk = 0x38
	// Event action disabled
	TCC_EVCTRL_EVACT1_OFF = 0x0
	// Re-trigger counter on event
	TCC_EVCTRL_EVACT1_RETRIGGER = 0x1
	// Direction control
	TCC_EVCTRL_EVACT1_DIR = 0x2
	// Stop counter on event
	TCC_EVCTRL_EVACT1_STOP = 0x3
	// Decrement counter on event
	TCC_EVCTRL_EVACT1_DEC = 0x4
	// Period capture value in CC0 register, pulse width capture value in