// generated by Fast Light User Interface Designer (fluid) version 1.0308

#include "PresetsUI.h"
// PresetsUI.cc
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2010, Alan Calvert
// Copyright 2017-2020, Will Godfrey

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is a derivative of the ZynAddSubFX original.


#include "MasterUI.h"

void PresetsUI_::refresh() {
  ;
}

PresetsUI_::~PresetsUI_() {
  ;
}

void PresetsUI::cb_copywin_i(Fl_Double_Window* o, void*) {
  saveWin(synth, o->w(), o->h(), o->x(), o->y(), false,"PresetWin");
o->hide();
}
void PresetsUI::cb_copywin(Fl_Double_Window* o, void* v) {
  ((PresetsUI*)(o->user_data()))->cb_copywin_i(o,v);
}

void PresetsUI::cb_copybrowse_i(Fl_Browser* o, void*) {
  int val = o->value();
    if (val)
    {
      presetname->cut(0, presetname->maximum_size());
      presetname->insert(o->text(val));
    };
}
void PresetsUI::cb_copybrowse(Fl_Browser* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_copybrowse_i(o,v);
}

void PresetsUI::cb_copypbutton_i(Fl_Button*, void*) {
  //
        const char *tmp = presetname->value();
        if (tmp != NULL)
        {
        if (strlen(tmp) > 0)
        {
            p->copy(tmp);
            copywin->hide();
        }
        };
}
void PresetsUI::cb_copypbutton(Fl_Button* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_copypbutton_i(o,v);
}

void PresetsUI::cb_copybutton_i(Fl_Button*, void*) {
  //
        p->copy(NULL);
        copywin->hide();
}
void PresetsUI::cb_copybutton(Fl_Button* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_copybutton_i(o,v);
}

void PresetsUI::cb_copycancel_i(Fl_Button*, void*) {
  //
        copywin->hide();
        saveWin(synth, copywin->w(), copywin->h(), copywin->x(), copywin->y(), false,"PresetWin");
}
void PresetsUI::cb_copycancel(Fl_Button* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_copycancel_i(o,v);
}

void PresetsUI::cb_presetname_i(Fl_Input* o, void*) {
  //
        const char *tmp = o->value();
        if (tmp == NULL)
        tmp = "";
        if (strlen(tmp) > 0)
        {
            copybutton->deactivate();
            copypbutton->activate();
        }
        else
        {
            copybutton->activate();
            copypbutton->deactivate();
        };
}
void PresetsUI::cb_presetname(Fl_Input* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_presetname_i(o,v);
}

void PresetsUI::cb_pastewin_i(Fl_Double_Window* o, void*) {
  saveWin(synth, o->w(), o->h(), o->x(), o->y(), false,"PresetWin");
o->hide();
}
void PresetsUI::cb_pastewin(Fl_Double_Window* o, void* v) {
  ((PresetsUI*)(o->user_data()))->cb_pastewin_i(o,v);
}

void PresetsUI::cb_pastebrowse_i(Fl_Browser* o, void*) {
  //
        if (o->value() == 0)
        {
            pastepbutton->deactivate();
            deletepbutton->deactivate();
        }
        else
        {
            pastepbutton->activate();
            deletepbutton->activate();
        };
}
void PresetsUI::cb_pastebrowse(Fl_Browser* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_pastebrowse_i(o,v);
}

void PresetsUI::cb_pastepbutton_i(Fl_Button*, void*) {
  //
        int n = pastebrowse->value();
        if (n == 0)
        {
            pastewin->hide();
            return;
        }
        synth->audioOut.store(_SYS_::mute::Request);
        while (synth->audioOut.load() == _SYS_::mute::Request)
            usleep (1000); // wait for full mute
        p->paste(n);
        pastewin->hide();
        pui->refresh();
        if (!synth->fileCompatible)
        {
            synth->getGuiMaster()->setmessage(UNUSED, true, "File from ZynAddSubFX 3.0 or later has parameter types changed incompatibly with earlier versions, and with Yoshimi. It may not perform correctly.");
            synth->fileCompatible = true;
            // this may not be necessary and anyway shouldn't
            // be done directly - trying to get rid of these!
        }
        if (synth->audioOut.load() == _SYS_::mute::Immediate)
            synth->audioOut.store(_SYS_::mute::Complete);
}
void PresetsUI::cb_pastepbutton(Fl_Button* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_pastepbutton_i(o,v);
}

void PresetsUI::cb_pastebutton_i(Fl_Button*, void*) {
  //
        synth->audioOut.store(_SYS_::mute::Request);
        while (synth->audioOut.load() == _SYS_::mute::Request)
            usleep (1000); // wait for full mute
        p->paste(0);
        pastewin->hide();
        pui->refresh();
        if (synth->audioOut.load() == _SYS_::mute::Immediate)
            synth->audioOut.store(_SYS_::mute::Complete);
}
void PresetsUI::cb_pastebutton(Fl_Button* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_pastebutton_i(o,v);
}

void PresetsUI::cb_pastecancel_i(Fl_Button*, void*) {
  //
        pastewin->hide();
        saveWin(synth, pastewin->w(), pastewin->h(), pastewin->x(), pastewin->y(), false,"PresetWin");
}
void PresetsUI::cb_pastecancel(Fl_Button* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_pastecancel_i(o,v);
}

void PresetsUI::cb_deletepbutton_i(Fl_Button*, void*) {
  //
        int n = pastebrowse->value();
        if (n != 0)
            p->deletepreset(n);
        rescan();
}
void PresetsUI::cb_deletepbutton(Fl_Button* o, void* v) {
  ((PresetsUI*)(o->parent()->user_data()))->cb_deletepbutton_i(o,v);
}

PresetsUI::PresetsUI(SynthEngine *_synth) {
  //
      synth = _synth;
      p = NULL;
      make_window();
      copyW = 0;
      pasteW = 0;
      presetsDW = 265; // these are shared between both
      presetsDH = 430;
}

PresetsUI::~PresetsUI() {
  //
      copywin->hide();
      delete(copywin);
      pastewin->hide();
      delete(pastewin);
}

Fl_Double_Window* PresetsUI::make_window() {
  { Fl_Double_Window* o = copywin = new Fl_Double_Window(265, 430, "Copy to Clipboard/Preset");
    copywin->box(FL_PLASTIC_THIN_UP_BOX);
    copywin->color((Fl_Color)238);
    copywin->callback((Fl_Callback*)cb_copywin, (void*)(this));
    { copybrowse = new Fl_Browser(10, 25, 245, 320);
      copybrowse->type(1);
      copybrowse->callback((Fl_Callback*)cb_copybrowse);
    } // Fl_Browser* copybrowse
    { copypbutton = new Fl_Button(145, 355, 110, 20, "Copy to Preset");
      copypbutton->box(FL_THIN_UP_BOX);
      copypbutton->callback((Fl_Callback*)cb_copypbutton);
    } // Fl_Button* copypbutton
    { copybutton = new Fl_Button(25, 385, 90, 35, "Copy to Clipboard");
      copybutton->box(FL_THIN_UP_BOX);
      copybutton->callback((Fl_Callback*)cb_copybutton);
      copybutton->align(Fl_Align(192));
    } // Fl_Button* copybutton
    { copycancel = new Fl_Button(160, 385, 80, 35, "Cancel");
      copycancel->box(FL_THIN_UP_BOX);
      copycancel->callback((Fl_Callback*)cb_copycancel);
      copycancel->align(Fl_Align(192));
    } // Fl_Button* copycancel
    { copytype = new Fl_Box(10, 5, 40, 15, "Type:");
      copytype->labelsize(11);
      copytype->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
    } // Fl_Box* copytype
    { copytypetext = new Fl_Box(50, 5, 205, 15);
      copytypetext->box(FL_FLAT_BOX);
      copytypetext->color((Fl_Color)238);
      copytypetext->labelfont(1);
      copytypetext->labelsize(11);
      copytypetext->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
    } // Fl_Box* copytypetext
    { presetname = new Fl_Input(10, 355, 130, 20);
      presetname->callback((Fl_Callback*)cb_presetname);
      presetname->when(FL_WHEN_CHANGED);
    } // Fl_Input* presetname
    o->size_range(265, 430, 0, 0, 0, 0, 1);
    copywin->set_modal();
    copywin->end();
    copywin->resizable(copywin);
  } // Fl_Double_Window* copywin
  { Fl_Double_Window* o = pastewin = new Fl_Double_Window(265, 430, "Paste from Clipboard/Preset");
    pastewin->box(FL_PLASTIC_THIN_UP_BOX);
    pastewin->color((Fl_Color)238);
    pastewin->callback((Fl_Callback*)cb_pastewin, (void*)(this));
    { pastebrowse = new Fl_Browser(10, 25, 245, 320);
      pastebrowse->type(2);
      pastebrowse->callback((Fl_Callback*)cb_pastebrowse);
    } // Fl_Browser* pastebrowse
    { pastepbutton = new Fl_Button(10, 355, 160, 20, "Paste from Preset");
      pastepbutton->box(FL_THIN_UP_BOX);
      pastepbutton->callback((Fl_Callback*)cb_pastepbutton);
    } // Fl_Button* pastepbutton
    { pastebutton = new Fl_Button(25, 385, 90, 35, "Paste from Clipboard");
      pastebutton->box(FL_THIN_UP_BOX);
      pastebutton->callback((Fl_Callback*)cb_pastebutton);
      pastebutton->align(Fl_Align(192));
    } // Fl_Button* pastebutton
    { pastecancel = new Fl_Button(160, 385, 80, 35, "Cancel");
      pastecancel->box(FL_THIN_UP_BOX);
      pastecancel->callback((Fl_Callback*)cb_pastecancel);
      pastecancel->align(Fl_Align(192));
    } // Fl_Button* pastecancel
    { pastetypetext = new Fl_Box(55, 5, 200, 15);
      pastetypetext->box(FL_FLAT_BOX);
      pastetypetext->color((Fl_Color)238);
      pastetypetext->labelfont(1);
      pastetypetext->labelsize(11);
      pastetypetext->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
    } // Fl_Box* pastetypetext
    { pastetype = new Fl_Box(15, 5, 40, 15, "Type:");
      pastetype->labelsize(11);
      pastetype->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
    } // Fl_Box* pastetype
    { deletepbutton = new Fl_Button(180, 355, 75, 20, "Delete");
      deletepbutton->box(FL_THIN_UP_BOX);
      deletepbutton->callback((Fl_Callback*)cb_deletepbutton);
    } // Fl_Button* deletepbutton
    o->size_range(265, 430, 0, 0, 0, 0, 1);
    pastewin->set_modal();
    pastewin->end();
    pastewin->resizable(pastewin);
  } // Fl_Double_Window* pastewin
  return pastewin;
}

void PresetsUI::copy(Presets *p) {
  //
      copybutton->activate();
      copypbutton->deactivate();
      this->p = p;
      this->pui = NULL;
      bool but = (Fl::event_button() != FL_LEFT_MOUSE);
      presetname->cut(0, presetname->maximum_size());
      if (but)
          p->copy(NULL);
      else
      {
          rescan();
          copytypetext->label(&p->type[1]); // remove leading P
          copywin->show();
      }
}

void PresetsUI::paste(Presets *p,PresetsUI_ *pui) {
  //
      this->p = p;
      this->pui = pui;
      bool but = (Fl::event_button() != FL_LEFT_MOUSE);
      pastepbutton->deactivate();
      deletepbutton->deactivate();
      if (but)
      {
          p->paste(0);
          pui->refresh();
      }
      else
      {
          rescan();
          pastetypetext->label(&p->type[1]); // remove leading P
          if (p->checkclipboardtype())
              pastebutton->activate();
          else
              pastebutton->deactivate();
          pastewin->show();
      }
}

void PresetsUI::copy(Presets *p,int n) {
  //
      p->setelement(n);
      copy(p);
}

void PresetsUI::paste(Presets *p,PresetsUI_ *pui,int n) {
  //
      p->setelement(n);
      paste(p, pui);
}

void PresetsUI::rescan() {
  //
      copybrowse->clear();
      pastebrowse->clear();
      p->rescanforpresets(synth->getRuntime().currentPreset);
      for (int i = 0; i < MAX_PRESETS; ++i)
      {
          string name = firstSynth->getPresetsStore().presets[i].name;
          if (name.empty())
              break;
          copybrowse->add(name.c_str());
          pastebrowse->add(name.c_str());
      }
      int  W, H, X, Y, O;
      loadWin(synth, W, H, X, Y, O, "PresetWin");
      if (W < presetsDW || H < presetsDH)
      {
          W = presetsDW;
          H = presetsDH;
      }
      checkSane(X, Y, W, H, presetsDW, presetsDH, true);
  
      copywin->resize(X, Y, W, H);
      pastewin->resize(X, Y, W, H);
      presetsRtext();
}

void PresetsUI::Hide() {
  copywin->hide();
}

void PresetsUI::presetsRtext() {
  //
      if (copywin->visible())
      {
          if (copyW != copywin->w())
          {
              copyW = copywin->w();
              pasteW = 0;
  
              float dScale = copywin->w() / float(presetsDW);
  
              int size14 = int(14 * dScale);
              int size11 = int(11 * dScale);
  
              copybrowse->textsize(size14);
              copypbutton->labelsize(size14);
              copybutton->labelsize(size14);
              copycancel->labelsize(size14);
              presetname->textsize(size14);
              copytype->labelsize(size11);
              copytypetext->labelsize(size11);
  
              copywin->redraw();
          }
      }
      else if (pastewin->visible())
      {
          if (pasteW != pastewin->w())
          {
              pasteW = pastewin->w();
              copyW = 0;
  
              float dScale = pastewin->w() / float(presetsDW);
  
              int size14 = int(14 * dScale);
              int size11 = int(11 * dScale);
  
              pastebrowse->textsize(size14);
              pastepbutton->labelsize(size14);
              pastebutton->labelsize(size14);
              pastecancel->labelsize(size14);
              deletepbutton->labelsize(size14);
              pastetype->labelsize(size11);
              pastetypetext->labelsize(size11);
  
              pastewin->redraw();
          }
      }
}
