/* baobab-location.c generated by valac 0.56.3, the Vala compiler
 * generated from baobab-location.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2012  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include "baobab.h"
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gobject/gvaluecollector.h>

#define BAOBAB_LOCATION_FS_ATTRIBUTES G_FILE_ATTRIBUTE_FILESYSTEM_SIZE "," G_FILE_ATTRIBUTE_FILESYSTEM_USED

#define BAOBAB_TYPE_HOSTNAME_IFACE (baobab_hostname_iface_get_type ())
#define BAOBAB_HOSTNAME_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_HOSTNAME_IFACE, BaobabHostnameIface))
#define BAOBAB_IS_HOSTNAME_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_HOSTNAME_IFACE))
#define BAOBAB_HOSTNAME_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BAOBAB_TYPE_HOSTNAME_IFACE, BaobabHostnameIfaceIface))

typedef struct _BaobabHostnameIface BaobabHostnameIface;
typedef struct _BaobabHostnameIfaceIface BaobabHostnameIfaceIface;

#define BAOBAB_TYPE_HOSTNAME_IFACE_PROXY (baobab_hostname_iface_proxy_get_type ())
typedef GDBusProxy BaobabHostnameIfaceProxy;
typedef GDBusProxyClass BaobabHostnameIfaceProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _baobab_location_unref0(var) ((var == NULL) ? NULL : (var = (baobab_location_unref (var), NULL)))
typedef struct _BaobabLocationMountVolumeData BaobabLocationMountVolumeData;
typedef struct _BaobabParamSpecLocation BaobabParamSpecLocation;
enum  {
	BAOBAB_LOCATION_CHANGED_SIGNAL,
	BAOBAB_LOCATION_PROGRESS_SIGNAL,
	BAOBAB_LOCATION_NUM_SIGNALS
};
static guint baobab_location_signals[BAOBAB_LOCATION_NUM_SIGNALS] = {0};

struct _BaobabHostnameIfaceIface {
	GTypeInterface parent_iface;
	gchar* (*get_pretty_hostname) (BaobabHostnameIface* self);
	void (*set_pretty_hostname) (BaobabHostnameIface* self, const gchar* value);
	gchar* (*get_hostname) (BaobabHostnameIface* self);
	void (*set_hostname) (BaobabHostnameIface* self, const gchar* value);
};

struct _BaobabLocationPrivate {
	gchar* _name;
	GFile* _file;
	guint64* _size;
	guint64* _used;
	guint64* _reserved;
	GIcon* _icon;
	GIcon* _symbolic_icon;
	GVolume* _volume;
	GMount* _mount;
	gboolean _is_main_volume;
	gboolean _is_remote;
	gboolean _is_recent;
	BaobabScanner* _scanner;
	gboolean querying_fs;
};

struct _BaobabLocationMountVolumeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BaobabLocation* self;
	gboolean _tmp0_;
	GMount* _tmp1_;
	GVolume* _tmp2_;
	GtkMountOperation* mount_op;
	GtkMountOperation* _tmp3_;
	GVolume* _tmp4_;
	GtkMountOperation* _tmp5_;
	GError* _inner_error0_;
};

struct _BaobabParamSpecLocation {
	GParamSpec parent_instance;
};

static gint BaobabLocation_private_offset;
static gpointer baobab_location_parent_class = NULL;

VALA_EXTERN GType baobab_hostname_iface_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType baobab_hostname_iface_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint baobab_hostname_iface_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
VALA_EXTERN gchar* baobab_hostname_iface_get_pretty_hostname (BaobabHostnameIface* self);
VALA_EXTERN void baobab_hostname_iface_set_pretty_hostname (BaobabHostnameIface* self,
                                                const gchar* value);
VALA_EXTERN gchar* baobab_hostname_iface_get_hostname (BaobabHostnameIface* self);
VALA_EXTERN void baobab_hostname_iface_set_hostname (BaobabHostnameIface* self,
                                         const gchar* value);
static GType baobab_hostname_iface_get_type_once (void);
static void baobab_hostname_iface_proxy_g_signal (GDBusProxy* proxy,
                                           const gchar* sender_name,
                                           const gchar* signal_name,
                                           GVariant* parameters);
static gchar* baobab_hostname_iface_dbus_proxy_get_pretty_hostname (BaobabHostnameIface* self);
static void baobab_hostname_iface_dbus_proxy_set_pretty_hostname (BaobabHostnameIface* self,
                                                           const gchar* value);
static gchar* baobab_hostname_iface_dbus_proxy_get_hostname (BaobabHostnameIface* self);
static void baobab_hostname_iface_dbus_proxy_set_hostname (BaobabHostnameIface* self,
                                                    const gchar* value);
static void baobab_hostname_iface_proxy_baobab_hostname_iface_interface_init (BaobabHostnameIfaceIface* iface);
static void baobab_hostname_iface_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data);
static GVariant* baobab_hostname_iface_dbus_interface_get_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GError** error,
                                                             gpointer user_data);
static GVariant* _dbus_baobab_hostname_iface_get_pretty_hostname (BaobabHostnameIface* self);
static GVariant* _dbus_baobab_hostname_iface_get_hostname (BaobabHostnameIface* self);
static gboolean baobab_hostname_iface_dbus_interface_set_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GVariant* value,
                                                            GError** error,
                                                            gpointer user_data);
static void _dbus_baobab_hostname_iface_set_pretty_hostname (BaobabHostnameIface* self,
                                                      GVariant* _value);
static void _dbus_baobab_hostname_iface_set_hostname (BaobabHostnameIface* self,
                                               GVariant* _value);
static void _baobab_hostname_iface_unregister_object (gpointer user_data);
static gchar* baobab_location_get_hostname (BaobabLocation* self,
                                     GError** error);
static void baobab_location_make_this_home_location (BaobabLocation* self);
static void baobab_location_set_name (BaobabLocation* self,
                               const gchar* value);
static void baobab_location_set_icon (BaobabLocation* self,
                               GIcon* value);
static void baobab_location_set_symbolic_icon (BaobabLocation* self,
                                        GIcon* value);
static void baobab_location_set_file (BaobabLocation* self,
                               GFile* value);
static void baobab_location_set_scanner (BaobabLocation* self,
                                  BaobabScanner* value);
static void baobab_location_set_volume (BaobabLocation* self,
                                 GVolume* value);
static void baobab_location_set_mount (BaobabLocation* self,
                                GMount* value);
static void baobab_location_fill_from_mount (BaobabLocation* self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void baobab_location_set_is_remote (BaobabLocation* self,
                                    gboolean value);
static void baobab_location_set_is_main_volume (BaobabLocation* self,
                                         gboolean value);
static void baobab_location_set_is_recent (BaobabLocation* self,
                                    gboolean value);
static void baobab_location_set_size (BaobabLocation* self,
                               guint64* value);
static void baobab_location_set_used (BaobabLocation* self,
                               guint64* value);
static void __lambda5_ (BaobabLocation* self,
                 GObject* obj,
                 GAsyncResult* res);
static void baobab_location_set_reserved (BaobabLocation* self,
                                   guint64* value);
static void ___lambda5__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void baobab_location_mount_volume_data_free (gpointer _data);
static gboolean baobab_location_mount_volume_co (BaobabLocationMountVolumeData* _data_);
static void baobab_location_mount_volume_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static guint64* _uint64_dup (guint64* self);
static void baobab_location_finalize (BaobabLocation * obj);
static GType baobab_location_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusMethodInfo * const _baobab_hostname_iface_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _baobab_hostname_iface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _baobab_hostname_iface_dbus_property_info_pretty_hostname = {-1, "PrettyHostname", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _baobab_hostname_iface_dbus_property_info_hostname = {-1, "Hostname", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _baobab_hostname_iface_dbus_property_info[] = {&_baobab_hostname_iface_dbus_property_info_pretty_hostname, &_baobab_hostname_iface_dbus_property_info_hostname, NULL};
static const GDBusInterfaceInfo _baobab_hostname_iface_dbus_interface_info = {-1, "org.freedesktop.hostname1", (GDBusMethodInfo **) (&_baobab_hostname_iface_dbus_method_info), (GDBusSignalInfo **) (&_baobab_hostname_iface_dbus_signal_info), (GDBusPropertyInfo **) (&_baobab_hostname_iface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _baobab_hostname_iface_dbus_interface_vtable = {baobab_hostname_iface_dbus_interface_method_call, baobab_hostname_iface_dbus_interface_get_property, baobab_hostname_iface_dbus_interface_set_property};

gchar*
baobab_hostname_iface_get_pretty_hostname (BaobabHostnameIface* self)
{
	BaobabHostnameIfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BAOBAB_HOSTNAME_IFACE_GET_INTERFACE (self);
	if (_iface_->get_pretty_hostname) {
		return _iface_->get_pretty_hostname (self);
	}
	return NULL;
}

void
baobab_hostname_iface_set_pretty_hostname (BaobabHostnameIface* self,
                                           const gchar* value)
{
	BaobabHostnameIfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BAOBAB_HOSTNAME_IFACE_GET_INTERFACE (self);
	if (_iface_->set_pretty_hostname) {
		_iface_->set_pretty_hostname (self, value);
	}
}

gchar*
baobab_hostname_iface_get_hostname (BaobabHostnameIface* self)
{
	BaobabHostnameIfaceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BAOBAB_HOSTNAME_IFACE_GET_INTERFACE (self);
	if (_iface_->get_hostname) {
		return _iface_->get_hostname (self);
	}
	return NULL;
}

void
baobab_hostname_iface_set_hostname (BaobabHostnameIface* self,
                                    const gchar* value)
{
	BaobabHostnameIfaceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BAOBAB_HOSTNAME_IFACE_GET_INTERFACE (self);
	if (_iface_->set_hostname) {
		_iface_->set_hostname (self, value);
	}
}

static void
baobab_hostname_iface_default_init (BaobabHostnameIfaceIface * iface,
                                    gpointer iface_data)
{
}

static GType
baobab_hostname_iface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabHostnameIfaceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_hostname_iface_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType baobab_hostname_iface_type_id;
	baobab_hostname_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "BaobabHostnameIface", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (baobab_hostname_iface_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (baobab_hostname_iface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) baobab_hostname_iface_proxy_get_type);
	g_type_set_qdata (baobab_hostname_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.hostname1");
	g_type_set_qdata (baobab_hostname_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_baobab_hostname_iface_dbus_interface_info));
	g_type_set_qdata (baobab_hostname_iface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) baobab_hostname_iface_register_object);
	return baobab_hostname_iface_type_id;
}

GType
baobab_hostname_iface_get_type (void)
{
	static volatile gsize baobab_hostname_iface_type_id__once = 0;
	if (g_once_init_enter (&baobab_hostname_iface_type_id__once)) {
		GType baobab_hostname_iface_type_id;
		baobab_hostname_iface_type_id = baobab_hostname_iface_get_type_once ();
		g_once_init_leave (&baobab_hostname_iface_type_id__once, baobab_hostname_iface_type_id);
	}
	return baobab_hostname_iface_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BaobabHostnameIfaceProxy, baobab_hostname_iface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BAOBAB_TYPE_HOSTNAME_IFACE, baobab_hostname_iface_proxy_baobab_hostname_iface_interface_init) )
static void
baobab_hostname_iface_proxy_class_init (BaobabHostnameIfaceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = baobab_hostname_iface_proxy_g_signal;
}

static void
baobab_hostname_iface_proxy_g_signal (GDBusProxy* proxy,
                                      const gchar* sender_name,
                                      const gchar* signal_name,
                                      GVariant* parameters)
{
}

static void
baobab_hostname_iface_proxy_init (BaobabHostnameIfaceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_baobab_hostname_iface_dbus_interface_info));
}

static gchar*
baobab_hostname_iface_dbus_proxy_get_pretty_hostname (BaobabHostnameIface* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "PrettyHostname");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.hostname1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PrettyHostname"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
baobab_hostname_iface_dbus_proxy_set_pretty_hostname (BaobabHostnameIface* self,
                                                      const gchar* value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.hostname1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PrettyHostname"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static gchar*
baobab_hostname_iface_dbus_proxy_get_hostname (BaobabHostnameIface* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Hostname");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.hostname1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Hostname"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
baobab_hostname_iface_dbus_proxy_set_hostname (BaobabHostnameIface* self,
                                               const gchar* value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.hostname1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Hostname"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
baobab_hostname_iface_proxy_baobab_hostname_iface_interface_init (BaobabHostnameIfaceIface* iface)
{
	iface->get_pretty_hostname = baobab_hostname_iface_dbus_proxy_get_pretty_hostname;
	iface->set_pretty_hostname = baobab_hostname_iface_dbus_proxy_set_pretty_hostname;
	iface->get_hostname = baobab_hostname_iface_dbus_proxy_get_hostname;
	iface->set_hostname = baobab_hostname_iface_dbus_proxy_set_hostname;
}

static void
baobab_hostname_iface_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_baobab_hostname_iface_get_pretty_hostname (BaobabHostnameIface* self)
{
	gchar* result;
	GVariant* _reply;
	result = baobab_hostname_iface_get_pretty_hostname (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_baobab_hostname_iface_get_hostname (BaobabHostnameIface* self)
{
	gchar* result;
	GVariant* _reply;
	result = baobab_hostname_iface_get_hostname (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
baobab_hostname_iface_dbus_interface_get_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "PrettyHostname") == 0) {
		return _dbus_baobab_hostname_iface_get_pretty_hostname (object);
	} else if (strcmp (property_name, "Hostname") == 0) {
		return _dbus_baobab_hostname_iface_get_hostname (object);
	}
	return NULL;
}

static void
_dbus_baobab_hostname_iface_set_pretty_hostname (BaobabHostnameIface* self,
                                                 GVariant* _value)
{
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	baobab_hostname_iface_set_pretty_hostname (self, value);
	_g_free0 (value);
}

static void
_dbus_baobab_hostname_iface_set_hostname (BaobabHostnameIface* self,
                                          GVariant* _value)
{
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	baobab_hostname_iface_set_hostname (self, value);
	_g_free0 (value);
}

static gboolean
baobab_hostname_iface_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "PrettyHostname") == 0) {
		_dbus_baobab_hostname_iface_set_pretty_hostname (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Hostname") == 0) {
		_dbus_baobab_hostname_iface_set_hostname (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
baobab_hostname_iface_register_object (gpointer object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_baobab_hostname_iface_dbus_interface_info), &_baobab_hostname_iface_dbus_interface_vtable, data, _baobab_hostname_iface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_baobab_hostname_iface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
baobab_location_get_instance_private (BaobabLocation* self)
{
	return G_STRUCT_MEMBER_P (self, BaobabLocation_private_offset);
}

static gchar*
baobab_location_get_hostname (BaobabLocation* self,
                              GError** error)
{
	BaobabHostnameIface* hostname_iface = NULL;
	BaobabHostnameIface* _tmp0_ = NULL;
	BaobabHostnameIface* _tmp1_;
	BaobabHostnameIface* _tmp2_;
	gchar* pretty_name = NULL;
	BaobabHostnameIface* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = (BaobabHostnameIface*) g_initable_new (BAOBAB_TYPE_HOSTNAME_IFACE_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.hostname1", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/hostname1", "g-interface-name", "org.freedesktop.hostname1", NULL);
	_tmp0_ = (BaobabHostnameIface*) _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (hostname_iface);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (hostname_iface);
	hostname_iface = _tmp2_;
	_tmp3_ = hostname_iface;
	_tmp4_ = baobab_hostname_iface_get_pretty_hostname (_tmp3_);
	_tmp5_ = _tmp4_;
	pretty_name = _tmp5_;
	_tmp6_ = pretty_name;
	if (g_strcmp0 (_tmp6_, "") != 0) {
		result = pretty_name;
		_g_object_unref0 (_tmp0_);
		_g_object_unref0 (hostname_iface);
		return result;
	} else {
		BaobabHostnameIface* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = hostname_iface;
		_tmp8_ = baobab_hostname_iface_get_hostname (_tmp7_);
		_tmp9_ = _tmp8_;
		result = _tmp9_;
		_g_free0 (pretty_name);
		_g_object_unref0 (_tmp0_);
		_g_object_unref0 (hostname_iface);
		return result;
	}
}

static void
baobab_location_make_this_home_location (BaobabLocation* self)
{
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	GThemedIcon* _tmp2_;
	GThemedIcon* _tmp3_;
	g_return_if_fail (self != NULL);
	baobab_location_set_name (self, _ ("Home Folder"));
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("user-home");
	_tmp1_ = _tmp0_;
	baobab_location_set_icon (self, (GIcon*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = (GThemedIcon*) g_themed_icon_new ("user-home-symbolic");
	_tmp3_ = _tmp2_;
	baobab_location_set_symbolic_icon (self, (GIcon*) _tmp3_);
	_g_object_unref0 (_tmp3_);
}

BaobabLocation*
baobab_location_construct_for_home_folder (GType object_type)
{
	BaobabLocation* self = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	BaobabScanner* _tmp4_;
	BaobabScanner* _tmp5_;
	self = (BaobabLocation*) g_type_create_instance (object_type);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	baobab_location_set_file (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	baobab_location_make_this_home_location (self);
	_tmp3_ = self->priv->_file;
	_tmp4_ = baobab_scanner_new (_tmp3_, BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS);
	_tmp5_ = _tmp4_;
	baobab_location_set_scanner (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	return self;
}

BaobabLocation*
baobab_location_new_for_home_folder (void)
{
	return baobab_location_construct_for_home_folder (BAOBAB_TYPE_LOCATION);
}

BaobabLocation*
baobab_location_construct_from_volume (GType object_type,
                                       GVolume* volume_)
{
	BaobabLocation* self = NULL;
	g_return_val_if_fail (volume_ != NULL, NULL);
	self = (BaobabLocation*) g_type_create_instance (object_type);
	baobab_location_set_volume (self, volume_);
	baobab_location_update_volume_info (self);
	return self;
}

BaobabLocation*
baobab_location_new_from_volume (GVolume* volume_)
{
	return baobab_location_construct_from_volume (BAOBAB_TYPE_LOCATION, volume_);
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

BaobabLocation*
baobab_location_construct_from_mount (GType object_type,
                                      GMount* mount_)
{
	BaobabLocation* self = NULL;
	gchar* uri_scheme = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** remote_schemes = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gint remote_schemes_length1;
	gint _remote_schemes_size_;
	g_return_val_if_fail (mount_ != NULL, NULL);
	self = (BaobabLocation*) g_type_create_instance (object_type);
	baobab_location_set_mount (self, mount_);
	baobab_location_fill_from_mount (self);
	_tmp0_ = self->priv->_file;
	_tmp1_ = g_file_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_uri_parse_scheme (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	uri_scheme = _tmp4_;
	_tmp5_ = g_strdup ("ftp");
	_tmp6_ = g_strdup ("sftp");
	_tmp7_ = g_strdup ("ssh");
	_tmp8_ = g_strdup ("smb");
	_tmp9_ = g_strdup ("google-drive");
	_tmp10_ = g_strdup ("afp");
	_tmp11_ = g_new0 (gchar*, 6 + 1);
	_tmp11_[0] = _tmp5_;
	_tmp11_[1] = _tmp6_;
	_tmp11_[2] = _tmp7_;
	_tmp11_[3] = _tmp8_;
	_tmp11_[4] = _tmp9_;
	_tmp11_[5] = _tmp10_;
	remote_schemes = _tmp11_;
	remote_schemes_length1 = 6;
	_remote_schemes_size_ = remote_schemes_length1;
	baobab_location_set_is_remote (self, _vala_string_array_contains (remote_schemes, remote_schemes_length1, uri_scheme));
	remote_schemes = (_vala_array_free (remote_schemes, remote_schemes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (uri_scheme);
	return self;
}

BaobabLocation*
baobab_location_new_from_mount (GMount* mount_)
{
	return baobab_location_construct_from_mount (BAOBAB_TYPE_LOCATION, mount_);
}

BaobabLocation*
baobab_location_construct_for_main_volume (GType object_type)
{
	BaobabLocation* self = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GThemedIcon* _tmp5_;
	GThemedIcon* _tmp6_;
	GThemedIcon* _tmp7_;
	GThemedIcon* _tmp8_;
	GFile* _tmp9_;
	BaobabScanner* _tmp10_;
	BaobabScanner* _tmp11_;
	GError* _inner_error0_ = NULL;
	self = (BaobabLocation*) g_type_create_instance (object_type);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp1_ = baobab_location_get_hostname (self, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		baobab_location_set_name (self, _tmp0_);
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		baobab_location_set_name (self, NULL);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp2_ = self->priv->_name;
	if (_tmp2_ == NULL) {
		baobab_location_set_name (self, _ ("Computer"));
	}
	_tmp3_ = g_file_new_for_path ("/");
	_tmp4_ = _tmp3_;
	baobab_location_set_file (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("drive-harddisk-system");
	_tmp6_ = _tmp5_;
	baobab_location_set_icon (self, (GIcon*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("drive-harddisk-system-symbolic");
	_tmp8_ = _tmp7_;
	baobab_location_set_symbolic_icon (self, (GIcon*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	baobab_location_set_is_main_volume (self, TRUE);
	_tmp9_ = self->priv->_file;
	_tmp10_ = baobab_scanner_new (_tmp9_, BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS);
	_tmp11_ = _tmp10_;
	baobab_location_set_scanner (self, _tmp11_);
	_g_object_unref0 (_tmp11_);
	return self;
}

BaobabLocation*
baobab_location_new_for_main_volume (void)
{
	return baobab_location_construct_for_main_volume (BAOBAB_TYPE_LOCATION);
}

BaobabLocation*
baobab_location_construct_for_recent_info (GType object_type,
                                           GtkRecentInfo* recent_info)
{
	BaobabLocation* self = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	const gchar* _tmp3_;
	GIcon* _tmp4_;
	GIcon* _tmp5_;
	GThemedIcon* _tmp6_;
	GThemedIcon* _tmp7_;
	GFile* _tmp8_;
	BaobabScanner* _tmp9_;
	BaobabScanner* _tmp10_;
	g_return_val_if_fail (recent_info != NULL, NULL);
	self = (BaobabLocation*) g_type_create_instance (object_type);
	baobab_location_set_is_recent (self, TRUE);
	_tmp0_ = gtk_recent_info_get_uri (recent_info);
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	baobab_location_set_file (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = gtk_recent_info_get_display_name (recent_info);
	baobab_location_set_name (self, _tmp3_);
	_tmp4_ = gtk_recent_info_get_gicon (recent_info);
	_tmp5_ = _tmp4_;
	baobab_location_set_icon (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = (GThemedIcon*) g_themed_icon_new ("folder-symbolic");
	_tmp7_ = _tmp6_;
	baobab_location_set_symbolic_icon (self, (GIcon*) _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = self->priv->_file;
	_tmp9_ = baobab_scanner_new (_tmp8_, BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS);
	_tmp10_ = _tmp9_;
	baobab_location_set_scanner (self, _tmp10_);
	_g_object_unref0 (_tmp10_);
	return self;
}

BaobabLocation*
baobab_location_new_for_recent_info (GtkRecentInfo* recent_info)
{
	return baobab_location_construct_for_recent_info (BAOBAB_TYPE_LOCATION, recent_info);
}

BaobabLocation*
baobab_location_construct_for_file (GType object_type,
                                    GFile* file_,
                                    BaobabScanFlags flags)
{
	BaobabLocation* self = NULL;
	GFile* _tmp8_;
	BaobabScanner* _tmp9_;
	BaobabScanner* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (file_ != NULL, NULL);
	self = (BaobabLocation*) g_type_create_instance (object_type);
	baobab_location_set_file (self, file_);
	{
		GFileInfo* info = NULL;
		GFile* _tmp0_;
		GFileInfo* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = self->priv->_file;
		_tmp1_ = g_file_query_info (_tmp0_, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = g_file_info_get_display_name (info);
		baobab_location_set_name (self, _tmp2_);
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		g_clear_error (&_inner_error0_);
		_tmp3_ = self->priv->_file;
		_tmp4_ = g_file_get_parse_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_filename_display_name (_tmp5_);
		_tmp7_ = _tmp6_;
		baobab_location_set_name (self, _tmp7_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp8_ = self->priv->_file;
	_tmp9_ = baobab_scanner_new (_tmp8_, flags);
	_tmp10_ = _tmp9_;
	baobab_location_set_scanner (self, _tmp10_);
	_g_object_unref0 (_tmp10_);
	return self;
}

BaobabLocation*
baobab_location_new_for_file (GFile* file_,
                              BaobabScanFlags flags)
{
	return baobab_location_construct_for_file (BAOBAB_TYPE_LOCATION, file_, flags);
}

void
baobab_location_update_volume_info (BaobabLocation* self)
{
	GVolume* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GMount* new_mount = NULL;
	GVolume* _tmp3_;
	GMount* _tmp4_;
	GMount* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_volume;
	_tmp1_ = g_volume_get_identifier (_tmp0_, G_VOLUME_IDENTIFIER_KIND_CLASS);
	_tmp2_ = _tmp1_;
	baobab_location_set_is_remote (self, g_strcmp0 (_tmp2_, "network") == 0);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->_volume;
	_tmp4_ = g_volume_get_mount (_tmp3_);
	new_mount = _tmp4_;
	_tmp5_ = new_mount;
	if (_tmp5_ != NULL) {
		GMount* _tmp6_;
		GMount* _tmp7_;
		_tmp6_ = new_mount;
		_tmp7_ = self->priv->_mount;
		if (_tmp6_ != _tmp7_) {
			GMount* _tmp8_;
			_tmp8_ = new_mount;
			baobab_location_set_mount (self, _tmp8_);
			baobab_location_fill_from_mount (self);
		}
	} else {
		GVolume* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GVolume* _tmp12_;
		GIcon* _tmp13_;
		GIcon* _tmp14_;
		GVolume* _tmp15_;
		GIcon* _tmp16_;
		GIcon* _tmp17_;
		_tmp9_ = self->priv->_volume;
		_tmp10_ = g_volume_get_name (_tmp9_);
		_tmp11_ = _tmp10_;
		baobab_location_set_name (self, _tmp11_);
		_g_free0 (_tmp11_);
		_tmp12_ = self->priv->_volume;
		_tmp13_ = g_volume_get_icon (_tmp12_);
		_tmp14_ = _tmp13_;
		baobab_location_set_icon (self, _tmp14_);
		_g_object_unref0 (_tmp14_);
		_tmp15_ = self->priv->_volume;
		_tmp16_ = g_volume_get_symbolic_icon (_tmp15_);
		_tmp17_ = _tmp16_;
		baobab_location_set_symbolic_icon (self, _tmp17_);
		_g_object_unref0 (_tmp17_);
		baobab_location_set_mount (self, NULL);
		baobab_location_set_file (self, NULL);
		baobab_location_set_size (self, NULL);
		baobab_location_set_used (self, NULL);
		baobab_location_set_scanner (self, NULL);
	}
	g_signal_emit (self, baobab_location_signals[BAOBAB_LOCATION_CHANGED_SIGNAL], 0);
	_g_object_unref0 (new_mount);
}

static void
baobab_location_fill_from_mount (BaobabLocation* self)
{
	GMount* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GMount* _tmp3_;
	GIcon* _tmp4_;
	GIcon* _tmp5_;
	GMount* _tmp6_;
	GIcon* _tmp7_;
	GIcon* _tmp8_;
	GMount* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gboolean _tmp12_ = FALSE;
	GFile* _tmp13_;
	GFile* _tmp18_;
	BaobabScanner* _tmp19_;
	BaobabScanner* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_mount;
	_tmp1_ = g_mount_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	baobab_location_set_name (self, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->_mount;
	_tmp4_ = g_mount_get_icon (_tmp3_);
	_tmp5_ = _tmp4_;
	baobab_location_set_icon (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->_mount;
	_tmp7_ = g_mount_get_symbolic_icon (_tmp6_);
	_tmp8_ = _tmp7_;
	baobab_location_set_symbolic_icon (self, _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = self->priv->_mount;
	_tmp10_ = g_mount_get_root (_tmp9_);
	_tmp11_ = _tmp10_;
	baobab_location_set_file (self, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp13_ = self->priv->_file;
	if (_tmp13_ != NULL) {
		GFile* _tmp14_;
		const gchar* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
		_tmp14_ = self->priv->_file;
		_tmp15_ = g_get_home_dir ();
		_tmp16_ = g_file_new_for_path (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp12_ = g_file_equal (_tmp14_, _tmp17_);
		_g_object_unref0 (_tmp17_);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		baobab_location_make_this_home_location (self);
	}
	_tmp18_ = self->priv->_file;
	_tmp19_ = baobab_scanner_new (_tmp18_, BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS);
	_tmp20_ = _tmp19_;
	baobab_location_set_scanner (self, _tmp20_);
	_g_object_unref0 (_tmp20_);
}

static void
__lambda5_ (BaobabLocation* self,
            GObject* obj,
            GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	self->priv->querying_fs = FALSE;
	baobab_location_set_size (self, NULL);
	baobab_location_set_used (self, NULL);
	baobab_location_set_reserved (self, NULL);
	{
		GFileInfo* info = NULL;
		GFile* _tmp0_;
		GFileInfo* _tmp1_;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		guint64* _tmp6_;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		guint64* _tmp13_;
		_tmp0_ = self->priv->_file;
		_tmp1_ = g_file_query_filesystem_info_finish (_tmp0_, res, &_inner_error0_);
		info = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (g_file_info_has_attribute (info, G_FILE_ATTRIBUTE_FILESYSTEM_SIZE)) {
			guint64 _tmp2_;
			_tmp2_ = g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_FILESYSTEM_SIZE);
			baobab_location_set_size (self, &_tmp2_);
		}
		if (g_file_info_has_attribute (info, G_FILE_ATTRIBUTE_FILESYSTEM_USED)) {
			guint64 _tmp3_;
			_tmp3_ = g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_FILESYSTEM_USED);
			baobab_location_set_used (self, &_tmp3_);
		}
		_tmp6_ = self->priv->_size;
		if (_tmp6_ != NULL) {
			guint64* _tmp7_;
			_tmp7_ = self->priv->_used;
			_tmp5_ = _tmp7_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			_tmp4_ = g_file_info_has_attribute (info, G_FILE_ATTRIBUTE_FILESYSTEM_FREE);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			guint64 free = 0ULL;
			guint64* _tmp8_;
			guint64* _tmp9_;
			guint64 _tmp10_;
			free = g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_FILESYSTEM_FREE);
			_tmp8_ = self->priv->_size;
			_tmp9_ = self->priv->_used;
			_tmp10_ = ((*_tmp8_) - free) - (*_tmp9_);
			baobab_location_set_reserved (self, &_tmp10_);
		}
		_tmp13_ = self->priv->_size;
		if (_tmp13_ != NULL) {
			guint64* _tmp14_;
			_tmp14_ = self->priv->_used;
			_tmp12_ = _tmp14_ != NULL;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			guint64* _tmp15_;
			guint64* _tmp16_;
			_tmp15_ = self->priv->_used;
			_tmp16_ = self->priv->_size;
			_tmp11_ = (*_tmp15_) > (*_tmp16_);
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			baobab_location_set_size (self, NULL);
		}
		g_signal_emit (self, baobab_location_signals[BAOBAB_LOCATION_CHANGED_SIGNAL], 0);
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda5__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda5_ ((BaobabLocation*) self, source_object, res);
	baobab_location_unref (self);
}

void
baobab_location_queue_query_fs_usage (BaobabLocation* self)
{
	gboolean _tmp0_ = FALSE;
	GFile* _tmp2_;
	g_return_if_fail (self != NULL);
	if (self->priv->querying_fs) {
		_tmp0_ = TRUE;
	} else {
		GFile* _tmp1_;
		_tmp1_ = self->priv->_file;
		_tmp0_ = _tmp1_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	self->priv->querying_fs = TRUE;
	_tmp2_ = self->priv->_file;
	g_file_query_filesystem_info_async (_tmp2_, BAOBAB_LOCATION_FS_ATTRIBUTES, G_PRIORITY_DEFAULT, NULL, ___lambda5__gasync_ready_callback, baobab_location_ref (self));
}

static void
baobab_location_mount_volume_data_free (gpointer _data)
{
	BaobabLocationMountVolumeData* _data_;
	_data_ = _data;
	_baobab_location_unref0 (_data_->self);
	g_slice_free (BaobabLocationMountVolumeData, _data_);
}

static gpointer
_baobab_location_ref0 (gpointer self)
{
	return self ? baobab_location_ref (self) : NULL;
}

void
baobab_location_mount_volume (BaobabLocation* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	BaobabLocationMountVolumeData* _data_;
	BaobabLocation* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BaobabLocationMountVolumeData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, baobab_location_mount_volume_data_free);
	_tmp0_ = _baobab_location_ref0 (self);
	_data_->self = _tmp0_;
	baobab_location_mount_volume_co (_data_);
}

void
baobab_location_mount_volume_finish (BaobabLocation* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	BaobabLocationMountVolumeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
baobab_location_mount_volume_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	BaobabLocationMountVolumeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	baobab_location_mount_volume_co (_data_);
}

static gboolean
baobab_location_mount_volume_co (BaobabLocationMountVolumeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->_mount;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->_volume;
		_data_->_tmp0_ = _data_->_tmp2_ == NULL;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = (GtkMountOperation*) gtk_mount_operation_new (NULL);
	_data_->mount_op = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->self->priv->_volume;
	_data_->_tmp5_ = _data_->mount_op;
	_data_->_state_ = 1;
	g_volume_mount (_data_->_tmp4_, G_MOUNT_MOUNT_NONE, (GMountOperation*) _data_->_tmp5_, NULL, baobab_location_mount_volume_ready, _data_);
	return FALSE;
	_state_1:
	g_volume_mount_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->mount_op);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	baobab_location_update_volume_info (_data_->self);
	_g_object_unref0 (_data_->mount_op);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

BaobabLocation*
baobab_location_construct (GType object_type)
{
	BaobabLocation* self = NULL;
	self = (BaobabLocation*) g_type_create_instance (object_type);
	return self;
}

BaobabLocation*
baobab_location_new (void)
{
	return baobab_location_construct (BAOBAB_TYPE_LOCATION);
}

const gchar*
baobab_location_get_name (BaobabLocation* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
baobab_location_set_name (BaobabLocation* self,
                          const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}

GFile*
baobab_location_get_file (BaobabLocation* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
baobab_location_set_file (BaobabLocation* self,
                          GFile* value)
{
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_file);
	self->priv->_file = _tmp0_;
}

guint64*
baobab_location_get_size (BaobabLocation* self)
{
	guint64* result;
	guint64* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_size;
	result = _tmp0_;
	return result;
}

static guint64*
_uint64_dup (guint64* self)
{
	guint64* dup;
	dup = g_new0 (guint64, 1);
	memcpy (dup, self, sizeof (guint64));
	return dup;
}

static gpointer
__uint64_dup0 (gpointer self)
{
	return self ? _uint64_dup (self) : NULL;
}

static void
baobab_location_set_size (BaobabLocation* self,
                          guint64* value)
{
	guint64* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __uint64_dup0 (value);
	_g_free0 (self->priv->_size);
	self->priv->_size = _tmp0_;
}

guint64*
baobab_location_get_used (BaobabLocation* self)
{
	guint64* result;
	guint64* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_used;
	result = _tmp0_;
	return result;
}

static void
baobab_location_set_used (BaobabLocation* self,
                          guint64* value)
{
	guint64* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __uint64_dup0 (value);
	_g_free0 (self->priv->_used);
	self->priv->_used = _tmp0_;
}

guint64*
baobab_location_get_reserved (BaobabLocation* self)
{
	guint64* result;
	guint64* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_reserved;
	result = _tmp0_;
	return result;
}

static void
baobab_location_set_reserved (BaobabLocation* self,
                              guint64* value)
{
	guint64* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __uint64_dup0 (value);
	_g_free0 (self->priv->_reserved);
	self->priv->_reserved = _tmp0_;
}

GIcon*
baobab_location_get_icon (BaobabLocation* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

static void
baobab_location_set_icon (BaobabLocation* self,
                          GIcon* value)
{
	GIcon* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_icon);
	self->priv->_icon = _tmp0_;
}

GIcon*
baobab_location_get_symbolic_icon (BaobabLocation* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_symbolic_icon;
	result = _tmp0_;
	return result;
}

static void
baobab_location_set_symbolic_icon (BaobabLocation* self,
                                   GIcon* value)
{
	GIcon* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_symbolic_icon);
	self->priv->_symbolic_icon = _tmp0_;
}

GVolume*
baobab_location_get_volume (BaobabLocation* self)
{
	GVolume* result;
	GVolume* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_volume;
	result = _tmp0_;
	return result;
}

static void
baobab_location_set_volume (BaobabLocation* self,
                            GVolume* value)
{
	GVolume* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_volume);
	self->priv->_volume = _tmp0_;
}

GMount*
baobab_location_get_mount (BaobabLocation* self)
{
	GMount* result;
	GMount* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mount;
	result = _tmp0_;
	return result;
}

static void
baobab_location_set_mount (BaobabLocation* self,
                           GMount* value)
{
	GMount* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_mount);
	self->priv->_mount = _tmp0_;
}

gboolean
baobab_location_get_is_main_volume (BaobabLocation* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_main_volume;
	return result;
}

static void
baobab_location_set_is_main_volume (BaobabLocation* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_main_volume = value;
}

gboolean
baobab_location_get_is_remote (BaobabLocation* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_remote;
	return result;
}

static void
baobab_location_set_is_remote (BaobabLocation* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_remote = value;
}

gboolean
baobab_location_get_is_recent (BaobabLocation* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_recent;
	return result;
}

static void
baobab_location_set_is_recent (BaobabLocation* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_recent = value;
}

BaobabScanner*
baobab_location_get_scanner (BaobabLocation* self)
{
	BaobabScanner* result;
	BaobabScanner* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_scanner;
	result = _tmp0_;
	return result;
}

static void
baobab_location_set_scanner (BaobabLocation* self,
                             BaobabScanner* value)
{
	BaobabScanner* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_scanner);
	self->priv->_scanner = _tmp0_;
}

static void
baobab_value_location_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
baobab_value_location_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		baobab_location_unref (value->data[0].v_pointer);
	}
}

static void
baobab_value_location_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = baobab_location_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
baobab_value_location_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
baobab_value_location_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BaobabLocation * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = baobab_location_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
baobab_value_location_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	BaobabLocation ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = baobab_location_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
baobab_param_spec_location (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	BaobabParamSpecLocation* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BAOBAB_TYPE_LOCATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
baobab_value_get_location (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BAOBAB_TYPE_LOCATION), NULL);
	return value->data[0].v_pointer;
}

void
baobab_value_set_location (GValue* value,
                           gpointer v_object)
{
	BaobabLocation * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BAOBAB_TYPE_LOCATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BAOBAB_TYPE_LOCATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		baobab_location_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		baobab_location_unref (old);
	}
}

void
baobab_value_take_location (GValue* value,
                            gpointer v_object)
{
	BaobabLocation * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BAOBAB_TYPE_LOCATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BAOBAB_TYPE_LOCATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		baobab_location_unref (old);
	}
}

static void
baobab_location_class_init (BaobabLocationClass * klass,
                            gpointer klass_data)
{
	baobab_location_parent_class = g_type_class_peek_parent (klass);
	((BaobabLocationClass *) klass)->finalize = baobab_location_finalize;
	g_type_class_adjust_private_offset (klass, &BaobabLocation_private_offset);
	baobab_location_signals[BAOBAB_LOCATION_CHANGED_SIGNAL] = g_signal_new ("changed", BAOBAB_TYPE_LOCATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	baobab_location_signals[BAOBAB_LOCATION_PROGRESS_SIGNAL] = g_signal_new ("progress", BAOBAB_TYPE_LOCATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
baobab_location_instance_init (BaobabLocation * self,
                               gpointer klass)
{
	self->priv = baobab_location_get_instance_private (self);
	self->priv->_is_main_volume = FALSE;
	self->priv->_is_remote = FALSE;
	self->priv->_is_recent = FALSE;
	self->priv->querying_fs = FALSE;
	self->ref_count = 1;
}

static void
baobab_location_finalize (BaobabLocation * obj)
{
	BaobabLocation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_LOCATION, BaobabLocation);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->priv->_file);
	_g_free0 (self->priv->_size);
	_g_free0 (self->priv->_used);
	_g_free0 (self->priv->_reserved);
	_g_object_unref0 (self->priv->_icon);
	_g_object_unref0 (self->priv->_symbolic_icon);
	_g_object_unref0 (self->priv->_volume);
	_g_object_unref0 (self->priv->_mount);
	_g_object_unref0 (self->priv->_scanner);
}

static GType
baobab_location_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { baobab_value_location_init, baobab_value_location_free_value, baobab_value_location_copy_value, baobab_value_location_peek_pointer, "p", baobab_value_location_collect_value, "p", baobab_value_location_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BaobabLocationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_location_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabLocation), 0, (GInstanceInitFunc) baobab_location_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType baobab_location_type_id;
	baobab_location_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BaobabLocation", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BaobabLocation_private_offset = g_type_add_instance_private (baobab_location_type_id, sizeof (BaobabLocationPrivate));
	return baobab_location_type_id;
}

GType
baobab_location_get_type (void)
{
	static volatile gsize baobab_location_type_id__once = 0;
	if (g_once_init_enter (&baobab_location_type_id__once)) {
		GType baobab_location_type_id;
		baobab_location_type_id = baobab_location_get_type_once ();
		g_once_init_leave (&baobab_location_type_id__once, baobab_location_type_id);
	}
	return baobab_location_type_id__once;
}

gpointer
baobab_location_ref (gpointer instance)
{
	BaobabLocation * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
baobab_location_unref (gpointer instance)
{
	BaobabLocation * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BAOBAB_LOCATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

