/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public class ArrayQualifiedTypeReference
extends QualifiedTypeReference {
    int dimensions;
    private Annotation[][] annotationsOnDimensions;
    public int extendedDimensions;

    public ArrayQualifiedTypeReference(char[][] cArray, int n, long[] lArray) {
        super(cArray, lArray);
        this.dimensions = n;
        this.annotationsOnDimensions = null;
    }

    public ArrayQualifiedTypeReference(char[][] cArray, int n, Annotation[][] annotationArray, long[] lArray) {
        this(cArray, n, lArray);
        this.annotationsOnDimensions = annotationArray;
        if (annotationArray != null) {
            this.bits |= 0x100000;
        }
    }

    @Override
    public int dimensions() {
        return this.dimensions;
    }

    @Override
    public int extraDimensions() {
        return this.extendedDimensions;
    }

    @Override
    public Annotation[][] getAnnotationsOnDimensions(boolean bl) {
        if (bl || this.annotationsOnDimensions == null || this.annotationsOnDimensions.length == 0 || this.extendedDimensions == 0 || this.extendedDimensions == this.dimensions) {
            return this.annotationsOnDimensions;
        }
        Annotation[][] annotationArray = new Annotation[this.dimensions][];
        int n = this.dimensions - this.extendedDimensions;
        System.arraycopy(this.annotationsOnDimensions, n, annotationArray, 0, this.extendedDimensions);
        System.arraycopy(this.annotationsOnDimensions, 0, annotationArray, this.extendedDimensions, n);
        return annotationArray;
    }

    @Override
    public void setAnnotationsOnDimensions(Annotation[][] annotationArray) {
        this.annotationsOnDimensions = annotationArray;
    }

    @Override
    public char[][] getParameterizedTypeName() {
        int n;
        int n2 = this.dimensions;
        char[] cArray = new char[n2 * 2];
        for (n = 0; n < n2; ++n) {
            int n3 = n * 2;
            cArray[n3] = 91;
            cArray[n3 + 1] = 93;
        }
        n = this.tokens.length;
        char[][] cArrayArray = new char[n][];
        System.arraycopy(this.tokens, 0, cArrayArray, 0, n - 1);
        cArrayArray[n - 1] = CharOperation.concat(this.tokens[n - 1], cArray);
        return cArrayArray;
    }

    @Override
    protected TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        if (this.dimensions > 255) {
            scope.problemReporter().tooManyDimensions(this);
        }
        LookupEnvironment lookupEnvironment = scope.environment();
        try {
            lookupEnvironment.missingClassFileLocation = this;
            TypeBinding typeBinding = super.getTypeBinding(scope);
            if (typeBinding != null) {
                this.resolvedType = scope.createArrayType(typeBinding, this.dimensions);
                ArrayBinding arrayBinding = this.resolvedType;
                return arrayBinding;
            }
            TypeBinding typeBinding2 = null;
            return typeBinding2;
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(this, scope.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
        }
    }

    @Override
    protected TypeBinding internalResolveType(Scope scope, int n) {
        TypeBinding typeBinding = super.internalResolveType(scope, n);
        typeBinding = ArrayTypeReference.maybeMarkArrayContentsNonNull(scope, typeBinding, this.sourceStart, this.dimensions, null);
        return typeBinding;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        super.printExpression(n, stringBuffer);
        if ((this.bits & 0x4000) != 0) {
            for (int i = 0; i < this.dimensions - 1; ++i) {
                if (this.annotationsOnDimensions != null && this.annotationsOnDimensions[i] != null) {
                    stringBuffer.append(' ');
                    ArrayQualifiedTypeReference.printAnnotations(this.annotationsOnDimensions[i], stringBuffer);
                    stringBuffer.append(' ');
                }
                stringBuffer.append("[]");
            }
            if (this.annotationsOnDimensions != null && this.annotationsOnDimensions[this.dimensions - 1] != null) {
                stringBuffer.append(' ');
                ArrayQualifiedTypeReference.printAnnotations(this.annotationsOnDimensions[this.dimensions - 1], stringBuffer);
                stringBuffer.append(' ');
            }
            stringBuffer.append("...");
        } else {
            for (int i = 0; i < this.dimensions; ++i) {
                if (this.annotationsOnDimensions != null && this.annotationsOnDimensions[i] != null) {
                    stringBuffer.append(" ");
                    ArrayQualifiedTypeReference.printAnnotations(this.annotationsOnDimensions[i], stringBuffer);
                    stringBuffer.append(" ");
                }
                stringBuffer.append("[]");
            }
        }
        return stringBuffer;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            if (this.annotations != null) {
                int n2 = this.annotations.length;
                for (int i = 0; i < n2; ++i) {
                    int n3 = this.annotations[i] == null ? 0 : this.annotations[i].length;
                    for (n = 0; n < n3; ++n) {
                        this.annotations[i][n].traverse(aSTVisitor, blockScope);
                    }
                }
            }
            if (this.annotationsOnDimensions != null) {
                for (Annotation[] annotationArray : this.annotationsOnDimensions) {
                    int n4;
                    int n5 = n4 = annotationArray == null ? 0 : annotationArray.length;
                    for (n = 0; n < n4; ++n) {
                        Annotation annotation = annotationArray[n];
                        annotation.traverse(aSTVisitor, blockScope);
                    }
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n;
            if (this.annotations != null) {
                int n2 = this.annotations.length;
                for (int i = 0; i < n2; ++i) {
                    int n3 = this.annotations[i] == null ? 0 : this.annotations[i].length;
                    for (n = 0; n < n3; ++n) {
                        this.annotations[i][n].traverse(aSTVisitor, classScope);
                    }
                }
            }
            if (this.annotationsOnDimensions != null) {
                for (Annotation[] annotationArray : this.annotationsOnDimensions) {
                    int n4;
                    int n5 = n4 = annotationArray == null ? 0 : annotationArray.length;
                    for (n = 0; n < n4; ++n) {
                        Annotation annotation = annotationArray[n];
                        annotation.traverse(aSTVisitor, classScope);
                    }
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

