/* contacts-contact.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-contact.vala, do not modify */

/*
 * Copyright (C) 2022 Niels De Graef <nielsdegraef@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "contactscore.h"
#include <glib.h>
#include <folks/folks.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

enum  {
	CONTACTS_CONTACT_0_PROPERTY,
	CONTACTS_CONTACT_INDIVIDUAL_PROPERTY,
	CONTACTS_CONTACT_DISPLAY_NAME_PROPERTY,
	CONTACTS_CONTACT_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_properties[CONTACTS_CONTACT_NUM_PROPERTIES];
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _ContactsContactApplyChangesData ContactsContactApplyChangesData;

struct _ContactsContactPrivate {
	GPtrArray* chunks;
	FolksIndividual* _individual;
};

struct _ContactsContactApplyChangesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsContact* self;
	FolksPersonaStore* store;
	guint i;
	gboolean _tmp0_;
	guint _tmp1_;
	GPtrArray* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	ContactsChunk* chunk;
	GPtrArray* _tmp5_;
	gconstpointer _tmp6_;
	ContactsChunk* _tmp7_;
	FolksPersona* _tmp8_;
	FolksPersona* _tmp9_;
	ContactsChunk* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	ContactsChunk* _tmp13_;
	FolksPersona* _tmp14_;
	FolksPersona* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	ContactsChunk* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	ContactsChunk* _tmp22_;
	FolksPersona* _tmp23_;
	FolksPersona* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	ContactsChunk* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	ContactsChunk* _tmp30_;
	FolksPersona* _tmp31_;
	FolksPersona* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	ContactsChunk* _tmp35_;
	ContactsChunk* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	ContactsChunk* _tmp39_;
	FolksPersona* _tmp40_;
	FolksPersona* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	GHashTable* new_details;
	GHashFunc _tmp44_;
	GEqualFunc _tmp45_;
	GHashTable* _tmp46_;
	guint _vala1_i;
	gboolean _tmp47_;
	guint _tmp48_;
	GPtrArray* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	ContactsChunk* _vala1_chunk;
	GPtrArray* _tmp52_;
	gconstpointer _tmp53_;
	ContactsChunk* _tmp54_;
	FolksPersona* _tmp55_;
	FolksPersona* _tmp56_;
	GValue* value;
	ContactsChunk* _tmp57_;
	GValue* _tmp58_;
	gboolean _tmp59_;
	GValue* _tmp60_;
	GValue* _tmp61_;
	void* _tmp62_;
	GHashTable* _tmp63_;
	ContactsChunk* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	ContactsChunk* _tmp67_;
	const gchar* _tmp68_;
	const gchar* _tmp69_;
	GHashTable* _tmp70_;
	ContactsChunk* _tmp71_;
	const gchar* _tmp72_;
	const gchar* _tmp73_;
	gchar* _tmp74_;
	GValue* _tmp75_;
	GHashTable* _tmp76_;
	GHashTable* _tmp77_;
	FolksPersona* persona;
	GHashTable* _tmp78_;
	FolksPersona* _tmp79_;
	FolksPersona* _tmp80_;
	GError* _inner_error0_;
};

static gint ContactsContact_private_offset;
static gpointer contacts_contact_parent_class = NULL;
static GListModelInterface * contacts_contact_g_list_model_parent_iface = NULL;

static void _g_object_unref0_ (gpointer var);
static void contacts_contact_on_individual_personas_changed (ContactsContact* self,
                                                      FolksIndividual* individual,
                                                      GeeSet* added,
                                                      GeeSet* removed);
static void contacts_contact_add_persona (ContactsContact* self,
                                   FolksPersona* persona);
static gint contacts_contact_create_chunk_internal (ContactsContact* self,
                                             const gchar* property_name,
                                             FolksPersona* persona);
static GType contacts_contact_chunk_gtype_for_property (ContactsContact* self,
                                                 const gchar* property_name);
static GObject* contacts_contact_real_get_item (GListModel* base,
                                         guint i);
static guint contacts_contact_real_get_n_items (GListModel* base);
static GType contacts_contact_real_get_item_type (GListModel* base);
static void contacts_contact_apply_changes_data_free (gpointer _data);
static gboolean contacts_contact_apply_changes_co (ContactsContactApplyChangesData* _data_);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void contacts_contact_apply_changes_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static GObject * contacts_contact_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void _contacts_contact_on_individual_personas_changed_folks_individual_personas_changed (FolksIndividual* _sender,
                                                                                         GeeSet* added,
                                                                                         GeeSet* removed,
                                                                                         gpointer self);
static void contacts_contact_finalize (GObject * obj);
static GType contacts_contact_get_type_once (void);
static void _vala_contacts_contact_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_contacts_contact_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
contacts_contact_get_instance_private (ContactsContact* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsContact_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

/** Creates a Contact that acts as a wrapper around an Individual */
ContactsContact*
contacts_contact_construct_for_individual (GType object_type,
                                           FolksIndividual* individual)
{
	ContactsContact * self = NULL;
	g_return_val_if_fail (individual != NULL, NULL);
	self = (ContactsContact*) g_object_new (object_type, "individual", individual, NULL);
	return self;
}

ContactsContact*
contacts_contact_new_for_individual (FolksIndividual* individual)
{
	return contacts_contact_construct_for_individual (CONTACTS_TYPE_CONTACT, individual);
}

/** Creates a new empty contact */
ContactsContact*
contacts_contact_construct_empty (GType object_type)
{
	ContactsContact * self = NULL;
	self = (ContactsContact*) g_object_new (object_type, "individual", NULL, NULL);
	return self;
}

ContactsContact*
contacts_contact_new_empty (void)
{
	return contacts_contact_construct_empty (CONTACTS_TYPE_CONTACT);
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
contacts_contact_on_individual_personas_changed (ContactsContact* self,
                                                 FolksIndividual* individual,
                                                 GeeSet* added,
                                                 GeeSet* removed)
{
	guint old_size = 0U;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GPtrArray* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	_tmp0_ = self->priv->chunks;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	old_size = (guint) _tmp2_;
	{
		GeeIterator* _persona_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) added);
		_persona_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			FolksPersona* persona = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			FolksPersona* _tmp7_;
			_tmp4_ = _persona_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _persona_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			persona = (FolksPersona*) _tmp6_;
			_tmp7_ = persona;
			contacts_contact_add_persona (self, _tmp7_);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	_tmp8_ = self->priv->chunks;
	_tmp9_ = vala_g_ptr_array_get_length (_tmp8_);
	_tmp10_ = _tmp9_;
	g_list_model_items_changed ((GListModel*) self, old_size - 1, (guint) 0, _tmp10_ - old_size);
	{
		GeeIterator* _persona_it = NULL;
		GeeIterator* _tmp11_;
		_tmp11_ = gee_iterable_iterator ((GeeIterable*) removed);
		_persona_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			FolksPersona* persona = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			_tmp12_ = _persona_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _persona_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			persona = (FolksPersona*) _tmp14_;
			{
				guint i = 0U;
				i = (guint) 0;
				{
					gboolean _tmp15_ = FALSE;
					_tmp15_ = TRUE;
					while (TRUE) {
						GPtrArray* _tmp17_;
						gint _tmp18_;
						gint _tmp19_;
						GPtrArray* _tmp20_;
						gconstpointer _tmp21_;
						FolksPersona* _tmp22_;
						FolksPersona* _tmp23_;
						FolksPersona* _tmp24_;
						if (!_tmp15_) {
							guint _tmp16_;
							_tmp16_ = i;
							i = _tmp16_ + 1;
						}
						_tmp15_ = FALSE;
						_tmp17_ = self->priv->chunks;
						_tmp18_ = vala_g_ptr_array_get_length (_tmp17_);
						_tmp19_ = _tmp18_;
						if (!(i < ((guint) _tmp19_))) {
							break;
						}
						_tmp20_ = self->priv->chunks;
						_tmp21_ = g_ptr_array_index (_tmp20_, i);
						_tmp22_ = contacts_chunk_get_persona ((ContactsChunk*) _tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = persona;
						if (_tmp23_ == _tmp24_) {
							GPtrArray* _tmp25_;
							guint _tmp26_;
							_tmp25_ = self->priv->chunks;
							g_ptr_array_remove_index (_tmp25_, i);
							g_list_model_items_changed ((GListModel*) self, i, (guint) 1, (guint) 0);
							_tmp26_ = i;
							i = _tmp26_ - 1;
						}
					}
				}
			}
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
}

static void
contacts_contact_add_persona (ContactsContact* self,
                              FolksPersona* persona)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_ALIAS_DETAILS)) {
		contacts_contact_create_chunk_internal (self, "alias", persona);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_AVATAR_DETAILS)) {
		contacts_contact_create_chunk_internal (self, "avatar", persona);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_BIRTHDAY_DETAILS)) {
		contacts_contact_create_chunk_internal (self, "birthday", persona);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_EMAIL_DETAILS)) {
		contacts_contact_create_chunk_internal (self, "email-addresses", persona);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_IM_DETAILS)) {
		contacts_contact_create_chunk_internal (self, "im-addresses", persona);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_NAME_DETAILS)) {
		contacts_contact_create_chunk_internal (self, "full-name", persona);
		contacts_contact_create_chunk_internal (self, "structured-name", persona);
		contacts_contact_create_chunk_internal (self, "nickname", persona);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_NOTE_DETAILS)) {
		contacts_contact_create_chunk_internal (self, "notes", persona);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_PHONE_DETAILS)) {
		contacts_contact_create_chunk_internal (self, "phone-numbers", persona);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS)) {
		contacts_contact_create_chunk_internal (self, "postal-addresses", persona);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_ROLE_DETAILS)) {
		contacts_contact_create_chunk_internal (self, "roles", persona);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (persona, FOLKS_TYPE_URL_DETAILS)) {
		contacts_contact_create_chunk_internal (self, "urls", persona);
	}
}

ContactsChunk*
contacts_contact_create_chunk (ContactsContact* self,
                               const gchar* property_name,
                               FolksPersona* persona)
{
	gint pos = 0;
	GPtrArray* _tmp0_;
	gconstpointer _tmp1_;
	ContactsChunk* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (property_name != NULL, NULL);
	pos = contacts_contact_create_chunk_internal (self, property_name, persona);
	if (pos == -1) {
		result = NULL;
		return result;
	}
	g_list_model_items_changed ((GListModel*) self, (guint) pos, (guint) 0, (guint) 1);
	_tmp0_ = self->priv->chunks;
	_tmp1_ = g_ptr_array_index (_tmp0_, (guint) pos);
	result = (ContactsChunk*) _tmp1_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
contacts_contact_create_chunk_internal (ContactsContact* self,
                                        const gchar* property_name,
                                        FolksPersona* persona)
{
	GType chunk_gtype = 0UL;
	ContactsChunk* chunk = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	GPtrArray* _tmp2_;
	ContactsChunk* _tmp3_;
	ContactsChunk* _tmp4_;
	GPtrArray* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (property_name != NULL, 0);
	chunk_gtype = contacts_contact_chunk_gtype_for_property (self, property_name);
	if (chunk_gtype == G_TYPE_NONE) {
		g_debug ("contacts-contact.vala:122: unsupported property '%s', ignoring", property_name);
		result = -1;
		return result;
	}
	_tmp0_ = g_object_new (chunk_gtype, "persona", persona, NULL, NULL);
	_tmp1_ = G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_;
	chunk = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CONTACTS_TYPE_CHUNK, ContactsChunk);
	_tmp2_ = self->priv->chunks;
	_tmp3_ = chunk;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	g_ptr_array_add (_tmp2_, _tmp4_);
	_tmp5_ = self->priv->chunks;
	_tmp6_ = vala_g_ptr_array_get_length (_tmp5_);
	_tmp7_ = _tmp6_;
	result = _tmp7_ - 1;
	_g_object_unref0 (chunk);
	return result;
}

static GType
contacts_contact_chunk_gtype_for_property (ContactsContact* self,
                                           const gchar* property_name)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	static GQuark _tmp1_label9 = 0;
	static GQuark _tmp1_label10 = 0;
	static GQuark _tmp1_label11 = 0;
	static GQuark _tmp1_label12 = 0;
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	g_return_val_if_fail (property_name != NULL, 0UL);
	_tmp0_ = property_name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("alias")))) {
		switch (0) {
			default:
			{
				result = CONTACTS_TYPE_ALIAS_CHUNK;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("avatar")))) {
		switch (0) {
			default:
			{
				result = CONTACTS_TYPE_AVATAR_CHUNK;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("birthday")))) {
		switch (0) {
			default:
			{
				result = CONTACTS_TYPE_BIRTHDAY_CHUNK;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("email-addresses")))) {
		switch (0) {
			default:
			{
				result = CONTACTS_TYPE_EMAIL_ADDRESSES_CHUNK;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("full-name")))) {
		switch (0) {
			default:
			{
				result = CONTACTS_TYPE_FULL_NAME_CHUNK;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("im-addresses")))) {
		switch (0) {
			default:
			{
				result = CONTACTS_TYPE_IM_ADDRESSES_CHUNK;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("nickname")))) {
		switch (0) {
			default:
			{
				result = CONTACTS_TYPE_NICKNAME_CHUNK;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("notes")))) {
		switch (0) {
			default:
			{
				result = CONTACTS_TYPE_NOTES_CHUNK;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("phone-numbers")))) {
		switch (0) {
			default:
			{
				result = CONTACTS_TYPE_PHONES_CHUNK;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string ("postal-addresses")))) {
		switch (0) {
			default:
			{
				result = CONTACTS_TYPE_ADDRESSES_CHUNK;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string ("roles")))) {
		switch (0) {
			default:
			{
				result = CONTACTS_TYPE_ROLES_CHUNK;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label11) ? _tmp1_label11 : (_tmp1_label11 = g_quark_from_static_string ("structured-name")))) {
		switch (0) {
			default:
			{
				result = CONTACTS_TYPE_STRUCTURED_NAME_CHUNK;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label12) ? _tmp1_label12 : (_tmp1_label12 = g_quark_from_static_string ("urls")))) {
		switch (0) {
			default:
			{
				result = CONTACTS_TYPE_URLS_CHUNK;
				return result;
			}
		}
	}
	result = G_TYPE_NONE;
	return result;
}

/**
   * Tries to get the name for the contact by iterating over the chunks that
   * represent some form of name. If none is found, it returns null.
   */
gchar*
contacts_contact_fetch_name (ContactsContact* self)
{
	ContactsChunk* alias_chunk = NULL;
	ContactsChunk* _tmp0_;
	ContactsChunk* _tmp1_;
	ContactsChunk* fn_chunk = NULL;
	ContactsChunk* _tmp6_;
	ContactsChunk* _tmp7_;
	ContactsChunk* sn_chunk = NULL;
	ContactsChunk* _tmp12_;
	ContactsChunk* _tmp13_;
	ContactsChunk* nick_chunk = NULL;
	ContactsChunk* _tmp18_;
	ContactsChunk* _tmp19_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = contacts_contact_get_most_relevant_chunk (self, "alias", FALSE);
	alias_chunk = _tmp0_;
	_tmp1_ = alias_chunk;
	if (_tmp1_ != NULL) {
		ContactsChunk* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = alias_chunk;
		_tmp3_ = contacts_alias_chunk_get_alias (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CONTACTS_TYPE_ALIAS_CHUNK, ContactsAliasChunk));
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = contacts_contact_get_most_relevant_chunk (self, "full-name", FALSE);
	fn_chunk = _tmp6_;
	_tmp7_ = fn_chunk;
	if (_tmp7_ != NULL) {
		ContactsChunk* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = fn_chunk;
		_tmp9_ = contacts_full_name_chunk_get_full_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, CONTACTS_TYPE_FULL_NAME_CHUNK, ContactsFullNameChunk));
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup (_tmp10_);
		result = _tmp11_;
		return result;
	}
	_tmp12_ = contacts_contact_get_most_relevant_chunk (self, "structured-name", FALSE);
	sn_chunk = _tmp12_;
	_tmp13_ = sn_chunk;
	if (_tmp13_ != NULL) {
		ContactsChunk* _tmp14_;
		FolksStructuredName* _tmp15_;
		FolksStructuredName* _tmp16_;
		gchar* _tmp17_;
		_tmp14_ = sn_chunk;
		_tmp15_ = contacts_structured_name_chunk_get_structured_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, CONTACTS_TYPE_STRUCTURED_NAME_CHUNK, ContactsStructuredNameChunk));
		_tmp16_ = _tmp15_;
		_tmp17_ = folks_structured_name_to_string (_tmp16_);
		result = _tmp17_;
		return result;
	}
	_tmp18_ = contacts_contact_get_most_relevant_chunk (self, "nickname", FALSE);
	nick_chunk = _tmp18_;
	_tmp19_ = nick_chunk;
	if (_tmp19_ != NULL) {
		ContactsChunk* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp20_ = nick_chunk;
		_tmp21_ = contacts_nickname_chunk_get_nickname (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, CONTACTS_TYPE_NICKNAME_CHUNK, ContactsNicknameChunk));
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strdup (_tmp22_);
		result = _tmp23_;
		return result;
	}
	result = NULL;
	return result;
}

/**
   * Tries to get the displayable name for the contact. Similar to fetch_name,
   * but also checks for fields that are not a name, but might still represent
   * a contact (for example an email address)
   */
gchar*
contacts_contact_fetch_display_name (ContactsContact* self)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	ContactsChunk* emails_chunk = NULL;
	ContactsChunk* _tmp2_;
	ContactsChunk* _tmp3_;
	ContactsChunk* _tmp4_;
	ContactsChunk* phones_chunk = NULL;
	ContactsChunk* _tmp11_;
	ContactsChunk* _tmp12_;
	ContactsChunk* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = contacts_contact_fetch_name (self);
	name = _tmp0_;
	_tmp1_ = name;
	if (_tmp1_ != NULL) {
		result = name;
		return result;
	}
	_tmp2_ = contacts_contact_get_most_relevant_chunk (self, "email-addresses", FALSE);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	emails_chunk = _tmp3_;
	_tmp4_ = emails_chunk;
	if (_tmp4_ != NULL) {
		GObject* email = NULL;
		ContactsChunk* _tmp5_;
		GObject* _tmp6_;
		GObject* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp5_ = emails_chunk;
		_tmp6_ = g_list_model_get_item ((GListModel*) G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, CONTACTS_TYPE_EMAIL_ADDRESSES_CHUNK, ContactsEmailAddressesChunk), (guint) 0);
		email = _tmp6_;
		_tmp7_ = email;
		_tmp8_ = contacts_email_address_get_raw_address (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, CONTACTS_TYPE_EMAIL_ADDRESS, ContactsEmailAddress));
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		_g_object_unref0 (email);
		_g_object_unref0 (emails_chunk);
		_g_free0 (name);
		return result;
	}
	_tmp11_ = contacts_contact_get_most_relevant_chunk (self, "phone-numbers", FALSE);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	phones_chunk = _tmp12_;
	_tmp13_ = phones_chunk;
	if (_tmp13_ != NULL) {
		GObject* phone = NULL;
		ContactsChunk* _tmp14_;
		GObject* _tmp15_;
		GObject* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp14_ = phones_chunk;
		_tmp15_ = g_list_model_get_item ((GListModel*) G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, CONTACTS_TYPE_PHONES_CHUNK, ContactsPhonesChunk), (guint) 0);
		phone = _tmp15_;
		_tmp16_ = phone;
		_tmp17_ = contacts_phone_get_raw_number (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, CONTACTS_TYPE_PHONE, ContactsPhone));
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strdup (_tmp18_);
		result = _tmp19_;
		_g_object_unref0 (phone);
		_g_object_unref0 (phones_chunk);
		_g_object_unref0 (emails_chunk);
		_g_free0 (name);
		return result;
	}
	result = NULL;
	_g_object_unref0 (phones_chunk);
	_g_object_unref0 (emails_chunk);
	_g_free0 (name);
	return result;
}

/**
   * A helper function to return the {@link Chunk} that best represents the
   * property of the contact (or null if none).
   */
ContactsChunk*
contacts_contact_get_most_relevant_chunk (ContactsContact* self,
                                          const gchar* property_name,
                                          gboolean allow_empty)
{
	ContactsChunk* _result_ = NULL;
	ContactsChunk* _tmp28_;
	ContactsChunk* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (property_name != NULL, NULL);
	_result_ = NULL;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ContactsChunk* chunk = NULL;
				GPtrArray* _tmp5_;
				gconstpointer _tmp6_;
				ContactsChunk* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp14_ = FALSE;
				ContactsChunk* _tmp15_;
				FolksPersona* _tmp16_;
				FolksPersona* _tmp17_;
				ContactsChunk* _tmp26_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->chunks;
				_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < ((guint) _tmp4_))) {
					break;
				}
				_tmp5_ = self->priv->chunks;
				_tmp6_ = g_ptr_array_index (_tmp5_, i);
				chunk = (ContactsChunk*) _tmp6_;
				_tmp7_ = chunk;
				_tmp8_ = contacts_chunk_get_property_name (_tmp7_);
				_tmp9_ = _tmp8_;
				if (g_strcmp0 (_tmp9_, property_name) != 0) {
					continue;
				}
				if (!allow_empty) {
					ContactsChunk* _tmp11_;
					gboolean _tmp12_;
					gboolean _tmp13_;
					_tmp11_ = chunk;
					_tmp12_ = contacts_chunk_get_is_empty (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp10_ = _tmp13_;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					continue;
				}
				_tmp15_ = chunk;
				_tmp16_ = contacts_chunk_get_persona (_tmp15_);
				_tmp17_ = _tmp16_;
				if (_tmp17_ != NULL) {
					ContactsChunk* _tmp18_;
					FolksPersona* _tmp19_;
					FolksPersona* _tmp20_;
					FolksPersonaStore* _tmp21_;
					FolksPersonaStore* _tmp22_;
					gboolean _tmp23_;
					gboolean _tmp24_;
					_tmp18_ = chunk;
					_tmp19_ = contacts_chunk_get_persona (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = folks_persona_get_store (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = folks_persona_store_get_is_primary_store (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp14_ = _tmp24_;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					ContactsChunk* _tmp25_;
					_tmp25_ = chunk;
					result = _tmp25_;
					return result;
				}
				_tmp26_ = _result_;
				if (_tmp26_ == NULL) {
					ContactsChunk* _tmp27_;
					_tmp27_ = chunk;
					_result_ = _tmp27_;
				}
			}
		}
	}
	_tmp28_ = _result_;
	result = _tmp28_;
	return result;
}

static GObject*
contacts_contact_real_get_item (GListModel* base,
                                guint i)
{
	ContactsContact * self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GPtrArray* _tmp3_;
	gconstpointer _tmp4_;
	GObject* _tmp5_;
	GObject* result;
	self = (ContactsContact*) base;
	_tmp0_ = self->priv->chunks;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (i > ((guint) _tmp2_)) {
		result = NULL;
		return result;
	}
	_tmp3_ = self->priv->chunks;
	_tmp4_ = g_ptr_array_index (_tmp3_, i);
	_tmp5_ = _g_object_ref0 ((GObject*) ((ContactsChunk*) _tmp4_));
	result = _tmp5_;
	return result;
}

static guint
contacts_contact_real_get_n_items (GListModel* base)
{
	ContactsContact * self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint result;
	self = (ContactsContact*) base;
	_tmp0_ = self->priv->chunks;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

static GType
contacts_contact_real_get_item_type (GListModel* base)
{
	ContactsContact * self;
	GType result;
	self = (ContactsContact*) base;
	result = CONTACTS_TYPE_CHUNK;
	return result;
}

static void
contacts_contact_apply_changes_data_free (gpointer _data)
{
	ContactsContactApplyChangesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->store);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsContactApplyChangesData, _data_);
}

void
contacts_contact_apply_changes (ContactsContact* self,
                                FolksPersonaStore* store,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	ContactsContactApplyChangesData* _data_;
	ContactsContact* _tmp0_;
	FolksPersonaStore* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_data_ = g_slice_new0 (ContactsContactApplyChangesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_contact_apply_changes_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (store);
	_g_object_unref0 (_data_->store);
	_data_->store = _tmp1_;
	contacts_contact_apply_changes_co (_data_);
}

void
contacts_contact_apply_changes_finish (ContactsContact* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	ContactsContactApplyChangesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Applies any pending changes to all chunks. This can mean either a new
   * persona is made, or it is saved in the chunk's referenced persona.
   * When a new persona is made, it will be added to @store.
   */
static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
contacts_contact_apply_changes_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	ContactsContactApplyChangesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_contact_apply_changes_co (_data_);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

static void
__vala_GValue_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}

static gboolean
contacts_contact_apply_changes_co (ContactsContactApplyChangesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->i = (guint) 0;
		{
			_data_->_tmp0_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp0_) {
					_data_->_tmp1_ = _data_->i;
					_data_->i = _data_->_tmp1_ + 1;
				}
				_data_->_tmp0_ = FALSE;
				_data_->_tmp2_ = _data_->self->priv->chunks;
				_data_->_tmp3_ = vala_g_ptr_array_get_length (_data_->_tmp2_);
				_data_->_tmp4_ = _data_->_tmp3_;
				if (!(_data_->i < ((guint) _data_->_tmp4_))) {
					break;
				}
				_data_->_tmp5_ = _data_->self->priv->chunks;
				_data_->_tmp6_ = g_ptr_array_index (_data_->_tmp5_, _data_->i);
				_data_->chunk = (ContactsChunk*) _data_->_tmp6_;
				_data_->_tmp7_ = _data_->chunk;
				_data_->_tmp8_ = contacts_chunk_get_persona (_data_->_tmp7_);
				_data_->_tmp9_ = _data_->_tmp8_;
				if (_data_->_tmp9_ == NULL) {
					continue;
				}
				_data_->_tmp10_ = _data_->chunk;
				_data_->_tmp11_ = contacts_chunk_get_property_name (_data_->_tmp10_);
				_data_->_tmp12_ = _data_->_tmp11_;
				_data_->_tmp13_ = _data_->chunk;
				_data_->_tmp14_ = contacts_chunk_get_persona (_data_->_tmp13_);
				_data_->_tmp15_ = _data_->_tmp14_;
				_data_->_tmp17_ = 0;
				_data_->_tmp16_ = folks_persona_get_writeable_properties (_data_->_tmp15_, &_data_->_tmp17_);
				_data_->_tmp16__length1 = _data_->_tmp17_;
				_data_->_tmp18_ = _data_->_tmp16_;
				_data_->_tmp18__length1 = _data_->_tmp16__length1;
				if (!_vala_string_array_contains (_data_->_tmp18_, _data_->_tmp18__length1, _data_->_tmp12_)) {
					_data_->_tmp19_ = _data_->chunk;
					_data_->_tmp20_ = contacts_chunk_get_property_name (_data_->_tmp19_);
					_data_->_tmp21_ = _data_->_tmp20_;
					_data_->_tmp22_ = _data_->chunk;
					_data_->_tmp23_ = contacts_chunk_get_persona (_data_->_tmp22_);
					_data_->_tmp24_ = _data_->_tmp23_;
					_data_->_tmp25_ = folks_persona_get_uid (_data_->_tmp24_);
					_data_->_tmp26_ = _data_->_tmp25_;
					g_warning ("contacts-contact.vala:270: Can't save to unwriteable property '%s' to " \
"persona %s", _data_->_tmp21_, _data_->_tmp26_);
					continue;
				}
				_data_->_tmp27_ = _data_->chunk;
				_data_->_tmp28_ = contacts_chunk_get_property_name (_data_->_tmp27_);
				_data_->_tmp29_ = _data_->_tmp28_;
				_data_->_tmp30_ = _data_->chunk;
				_data_->_tmp31_ = contacts_chunk_get_persona (_data_->_tmp30_);
				_data_->_tmp32_ = _data_->_tmp31_;
				_data_->_tmp33_ = folks_persona_get_uid (_data_->_tmp32_);
				_data_->_tmp34_ = _data_->_tmp33_;
				g_debug ("contacts-contact.vala:278: Saving property '%s' to persona %s", _data_->_tmp29_, _data_->_tmp34_);
				_data_->_tmp35_ = _data_->chunk;
				_data_->_state_ = 1;
				contacts_chunk_save_to_persona (_data_->_tmp35_, contacts_contact_apply_changes_ready, _data_);
				return FALSE;
				_state_1:
				contacts_chunk_save_to_persona_finish (_data_->_tmp35_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp36_ = _data_->chunk;
				_data_->_tmp37_ = contacts_chunk_get_property_name (_data_->_tmp36_);
				_data_->_tmp38_ = _data_->_tmp37_;
				_data_->_tmp39_ = _data_->chunk;
				_data_->_tmp40_ = contacts_chunk_get_persona (_data_->_tmp39_);
				_data_->_tmp41_ = _data_->_tmp40_;
				_data_->_tmp42_ = folks_persona_get_uid (_data_->_tmp41_);
				_data_->_tmp43_ = _data_->_tmp42_;
				g_debug ("contacts-contact.vala:281: Saved property '%s' to persona %s", _data_->_tmp38_, _data_->_tmp43_);
			}
		}
	}
	_data_->_tmp44_ = g_str_hash;
	_data_->_tmp45_ = g_str_equal;
	_data_->_tmp46_ = g_hash_table_new_full (_data_->_tmp44_, _data_->_tmp45_, _g_free0_, __vala_GValue_free0_);
	_data_->new_details = _data_->_tmp46_;
	{
		_data_->_vala1_i = (guint) 0;
		{
			_data_->_tmp47_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp47_) {
					_data_->_tmp48_ = _data_->_vala1_i;
					_data_->_vala1_i = _data_->_tmp48_ + 1;
				}
				_data_->_tmp47_ = FALSE;
				_data_->_tmp49_ = _data_->self->priv->chunks;
				_data_->_tmp50_ = vala_g_ptr_array_get_length (_data_->_tmp49_);
				_data_->_tmp51_ = _data_->_tmp50_;
				if (!(_data_->_vala1_i < ((guint) _data_->_tmp51_))) {
					break;
				}
				_data_->_tmp52_ = _data_->self->priv->chunks;
				_data_->_tmp53_ = g_ptr_array_index (_data_->_tmp52_, _data_->_vala1_i);
				_data_->_vala1_chunk = (ContactsChunk*) _data_->_tmp53_;
				_data_->_tmp54_ = _data_->_vala1_chunk;
				_data_->_tmp55_ = contacts_chunk_get_persona (_data_->_tmp54_);
				_data_->_tmp56_ = _data_->_tmp55_;
				if (_data_->_tmp56_ != NULL) {
					continue;
				}
				_data_->_tmp57_ = _data_->_vala1_chunk;
				_data_->_tmp58_ = contacts_chunk_to_value (_data_->_tmp57_);
				_data_->value = _data_->_tmp58_;
				_data_->_tmp60_ = _data_->value;
				if (((gpointer) _data_->_tmp60_) == NULL) {
					_data_->_tmp59_ = TRUE;
				} else {
					_data_->_tmp61_ = _data_->value;
					_data_->_tmp62_ = g_value_peek_pointer (_data_->_tmp61_);
					_data_->_tmp59_ = _data_->_tmp62_ == NULL;
				}
				if (_data_->_tmp59_) {
					__vala_GValue_free0 (_data_->value);
					continue;
				}
				_data_->_tmp63_ = _data_->new_details;
				_data_->_tmp64_ = _data_->_vala1_chunk;
				_data_->_tmp65_ = contacts_chunk_get_property_name (_data_->_tmp64_);
				_data_->_tmp66_ = _data_->_tmp65_;
				if (g_hash_table_contains (_data_->_tmp63_, _data_->_tmp66_)) {
					_data_->_tmp67_ = _data_->_vala1_chunk;
					_data_->_tmp68_ = contacts_chunk_get_property_name (_data_->_tmp67_);
					_data_->_tmp69_ = _data_->_tmp68_;
					g_warning ("contacts-contact.vala:298: Got multiple chunks for property '%s'", _data_->_tmp69_);
				}
				_data_->_tmp70_ = _data_->new_details;
				_data_->_tmp71_ = _data_->_vala1_chunk;
				_data_->_tmp72_ = contacts_chunk_get_property_name (_data_->_tmp71_);
				_data_->_tmp73_ = _data_->_tmp72_;
				_data_->_tmp74_ = g_strdup (_data_->_tmp73_);
				_data_->_tmp75_ = _data_->value;
				_data_->value = NULL;
				g_hash_table_insert (_data_->_tmp70_, _data_->_tmp74_, _data_->_tmp75_);
				__vala_GValue_free0 (_data_->value);
			}
		}
	}
	_data_->_tmp76_ = _data_->new_details;
	if (g_hash_table_size (_data_->_tmp76_) != ((guint) 0)) {
		_data_->_tmp77_ = _data_->new_details;
		g_debug ("contacts-contact.vala:302: Creating new persona with %u properties", g_hash_table_size (_data_->_tmp77_));
		_data_->_tmp78_ = _data_->new_details;
		_data_->_state_ = 2;
		folks_persona_store_add_persona_from_details (_data_->store, _data_->_tmp78_, contacts_contact_apply_changes_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp79_ = folks_persona_store_add_persona_from_details_finish (_data_->store, _data_->_res_, &_data_->_inner_error0_);
		_data_->persona = _data_->_tmp79_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_hash_table_unref0 (_data_->new_details);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp80_ = _data_->persona;
		g_debug ("contacts-contact.vala:304: Successfully created new persona %p", _data_->_tmp80_);
		_g_object_unref0 (_data_->persona);
	}
	_g_hash_table_unref0 (_data_->new_details);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

ContactsContact*
contacts_contact_construct (GType object_type)
{
	ContactsContact * self = NULL;
	self = (ContactsContact*) g_object_new (object_type, NULL);
	return self;
}

ContactsContact*
contacts_contact_new (void)
{
	return contacts_contact_construct (CONTACTS_TYPE_CONTACT);
}

FolksIndividual*
contacts_contact_get_individual (ContactsContact* self)
{
	FolksIndividual* result;
	FolksIndividual* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_individual;
	result = _tmp0_;
	return result;
}

void
contacts_contact_set_individual (ContactsContact* self,
                                 FolksIndividual* value)
{
	FolksIndividual* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_contact_get_individual (self);
	if (old_value != value) {
		self->priv->_individual = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_contact_properties[CONTACTS_CONTACT_INDIVIDUAL_PROPERTY]);
	}
}

gchar*
contacts_contact_get_display_name (ContactsContact* self)
{
	gchar* result;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = contacts_contact_fetch_display_name (self);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (_ ("Unnamed Person"));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_free0 (_tmp0_);
	return result;
}

static void
_contacts_contact_on_individual_personas_changed_folks_individual_personas_changed (FolksIndividual* _sender,
                                                                                    GeeSet* added,
                                                                                    GeeSet* removed,
                                                                                    gpointer self)
{
	contacts_contact_on_individual_personas_changed ((ContactsContact*) self, _sender, added, removed);
}

static GObject *
contacts_contact_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsContact * self;
	FolksIndividual* _tmp0_;
	parent_class = G_OBJECT_CLASS (contacts_contact_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT, ContactsContact);
	_tmp0_ = self->priv->_individual;
	if (_tmp0_ != NULL) {
		FolksIndividual* _tmp1_;
		FolksIndividual* _tmp2_;
		FolksIndividual* _tmp3_;
		GeeSet* _tmp4_;
		GeeSet* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		_tmp1_ = self->priv->_individual;
		g_signal_connect_object (_tmp1_, "personas-changed", (GCallback) _contacts_contact_on_individual_personas_changed_folks_individual_personas_changed, self, 0);
		_tmp2_ = self->priv->_individual;
		_tmp3_ = self->priv->_individual;
		_tmp4_ = folks_individual_get_personas (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_set_empty (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref);
		_tmp7_ = _tmp6_;
		contacts_contact_on_individual_personas_changed (self, _tmp2_, _tmp5_, _tmp7_);
		_g_object_unref0 (_tmp7_);
	} else {
		contacts_contact_create_chunk (self, "full-name", NULL);
	}
	return obj;
}

static void
contacts_contact_class_init (ContactsContactClass * klass,
                             gpointer klass_data)
{
	contacts_contact_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsContact_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_contact_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_contact_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_contact_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_finalize;
	/** The underlying individual, if any */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_INDIVIDUAL_PROPERTY, contacts_contact_properties[CONTACTS_CONTACT_INDIVIDUAL_PROPERTY] = g_param_spec_object ("individual", "individual", "individual", FOLKS_TYPE_INDIVIDUAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/** Similar to fetch_display_name(), but never returns null */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_DISPLAY_NAME_PROPERTY, contacts_contact_properties[CONTACTS_CONTACT_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_contact_g_list_model_interface_init (GListModelInterface * iface,
                                              gpointer iface_data)
{
	contacts_contact_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item = (GObject* (*) (GListModel*, guint)) contacts_contact_real_get_item;
	iface->get_n_items = (guint (*) (GListModel*)) contacts_contact_real_get_n_items;
	iface->get_item_type = (GType (*) (GListModel*)) contacts_contact_real_get_item_type;
}

static void
contacts_contact_instance_init (ContactsContact * self,
                                gpointer klass)
{
	GPtrArray* _tmp0_;
	self->priv = contacts_contact_get_instance_private (self);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	self->priv->chunks = _tmp0_;
	self->priv->_individual = NULL;
}

static void
contacts_contact_finalize (GObject * obj)
{
	ContactsContact * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT, ContactsContact);
	_g_ptr_array_unref0 (self->priv->chunks);
	G_OBJECT_CLASS (contacts_contact_parent_class)->finalize (obj);
}

/**
 * A Contact is an object that represents a data model around a set of
 * contact properties. This can either come from a {@link Folks.Individual}, an
 * empty set (when creating contacts) or a different data source (like a vCard).
 *
 * Since the classes Folks provides assume valid data, we can't/shouldn't
 * really use them (for example, a PostalAddresFieldDetails does not allow
 * empty addresses), so that is another easy use for this separate class.
 */
 G_GNUC_NO_INLINE static GType
contacts_contact_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContact), 0, (GInstanceInitFunc) contacts_contact_instance_init, NULL };
	static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) contacts_contact_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType contacts_contact_type_id;
	contacts_contact_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsContact", &g_define_type_info, 0);
	g_type_add_interface_static (contacts_contact_type_id, g_list_model_get_type (), &g_list_model_info);
	ContactsContact_private_offset = g_type_add_instance_private (contacts_contact_type_id, sizeof (ContactsContactPrivate));
	return contacts_contact_type_id;
}

GType
contacts_contact_get_type (void)
{
	static volatile gsize contacts_contact_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_type_id__once)) {
		GType contacts_contact_type_id;
		contacts_contact_type_id = contacts_contact_get_type_once ();
		g_once_init_leave (&contacts_contact_type_id__once, contacts_contact_type_id);
	}
	return contacts_contact_type_id__once;
}

static void
_vala_contacts_contact_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	ContactsContact * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT, ContactsContact);
	switch (property_id) {
		case CONTACTS_CONTACT_INDIVIDUAL_PROPERTY:
		g_value_set_object (value, contacts_contact_get_individual (self));
		break;
		case CONTACTS_CONTACT_DISPLAY_NAME_PROPERTY:
		g_value_take_string (value, contacts_contact_get_display_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_contact_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	ContactsContact * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT, ContactsContact);
	switch (property_id) {
		case CONTACTS_CONTACT_INDIVIDUAL_PROPERTY:
		contacts_contact_set_individual (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

