/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;

public class RequestUtil {
    private RequestUtil() {
    }

    public static String normalize(String string) {
        return RequestUtil.normalize(string, true);
    }

    public static String normalize(String string, boolean bl) {
        int n;
        if (string == null) {
            return null;
        }
        Object object = string;
        if (bl && ((String)object).indexOf(92) >= 0) {
            object = ((String)object).replace('\\', '/');
        }
        if (!((String)object).startsWith("/")) {
            object = "/" + (String)object;
        }
        boolean bl2 = false;
        if (((String)object).endsWith("/.") || ((String)object).endsWith("/..")) {
            object = (String)object + "/";
            bl2 = true;
        }
        while ((n = ((String)object).indexOf("//")) >= 0) {
            object = ((String)object).substring(0, n) + ((String)object).substring(n + 1);
        }
        while ((n = ((String)object).indexOf("/./")) >= 0) {
            object = ((String)object).substring(0, n) + ((String)object).substring(n + 2);
        }
        while ((n = ((String)object).indexOf("/../")) >= 0) {
            if (n == 0) {
                return null;
            }
            int n2 = ((String)object).lastIndexOf(47, n - 1);
            object = ((String)object).substring(0, n2) + ((String)object).substring(n + 3);
        }
        if (((String)object).length() > 1 && bl2) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        return object;
    }

    public static boolean isSameOrigin(HttpServletRequest httpServletRequest, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = httpServletRequest.getScheme();
        if (string2 == null) {
            return false;
        }
        string2 = string2.toLowerCase(Locale.ENGLISH);
        stringBuilder.append(string2);
        stringBuilder.append("://");
        String string3 = httpServletRequest.getServerName();
        if (string3 == null) {
            return false;
        }
        stringBuilder.append(string3);
        int n = httpServletRequest.getServerPort();
        if (stringBuilder.length() == string.length()) {
            if (("http".equals(string2) || "ws".equals(string2)) && n != 80 || ("https".equals(string2) || "wss".equals(string2)) && n != 443) {
                stringBuilder.append(':');
                stringBuilder.append(n);
            }
        } else {
            stringBuilder.append(':');
            stringBuilder.append(n);
        }
        return string.equals(stringBuilder.toString());
    }

    public static boolean isValidOrigin(String string) {
        URI uRI;
        if (string.contains("%")) {
            return false;
        }
        if ("null".equals(string)) {
            return true;
        }
        if (string.startsWith("file://")) {
            return true;
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
        return uRI.getScheme() != null;
    }
}

