/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.XReflectionIntrospectionUtils;
import org.apache.tomcat.util.res.StringManager;

public final class IntrospectionUtils {
    private static final Log log = LogFactory.getLog(IntrospectionUtils.class);
    private static final StringManager sm = StringManager.getManager(IntrospectionUtils.class);
    private static final Map<Class<?>, Method[]> objectMethods = new ConcurrentHashMap();

    public static boolean setProperty(Object object, String string, String string2) {
        return IntrospectionUtils.setProperty(object, string, string2, true, null);
    }

    public static boolean setProperty(Object object, String string, String string2, boolean bl) {
        return IntrospectionUtils.setProperty(object, string, string2, bl, null);
    }

    public static boolean setProperty(Object object, String string, String string2, boolean bl, StringBuilder stringBuilder) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("IntrospectionUtils: setProperty(" + object.getClass() + " " + string + "=" + string2 + ")"));
        }
        if (stringBuilder == null && XReflectionIntrospectionUtils.isEnabled()) {
            return XReflectionIntrospectionUtils.setPropertyInternal(object, string, string2, bl);
        }
        String string3 = "set" + IntrospectionUtils.capitalize(string);
        try {
            Method[] methodArray = IntrospectionUtils.findMethods(object.getClass());
            Method method = null;
            Method method2 = null;
            for (Method method3 : methodArray) {
                Class<?>[] classArray = method3.getParameterTypes();
                if (!string3.equals(method3.getName()) || classArray.length != 1 || !"java.lang.String".equals(classArray[0].getName())) continue;
                method3.invoke(object, string2);
                if (stringBuilder != null) {
                    stringBuilder.append(method3.getName()).append("(\"").append(IntrospectionUtils.escape(string2)).append("\")");
                }
                return true;
            }
            for (Method method3 : methodArray) {
                boolean bl2 = true;
                if (string3.equals(method3.getName()) && method3.getParameterTypes().length == 1) {
                    Class<?> clazz = method3.getParameterTypes()[0];
                    Object[] objectArray = new Object[1];
                    if ("java.lang.Integer".equals(clazz.getName()) || "int".equals(clazz.getName())) {
                        try {
                            objectArray[0] = Integer.valueOf(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl2 = false;
                        }
                        if (stringBuilder != null) {
                            stringBuilder.append(method3.getName()).append("(Integer.valueOf(\"").append(string2).append("\"))");
                        }
                    } else if ("java.lang.Long".equals(clazz.getName()) || "long".equals(clazz.getName())) {
                        try {
                            objectArray[0] = Long.valueOf(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl2 = false;
                        }
                        if (stringBuilder != null) {
                            stringBuilder.append(method3.getName()).append("(Long.valueOf(\"").append(string2).append("\"))");
                        }
                    } else if ("java.lang.Boolean".equals(clazz.getName()) || "boolean".equals(clazz.getName())) {
                        objectArray[0] = Boolean.valueOf(string2);
                        if (stringBuilder != null) {
                            stringBuilder.append(method3.getName()).append("(Boolean.valueOf(\"").append(string2).append("\"))");
                        }
                    } else if ("java.net.InetAddress".equals(clazz.getName())) {
                        try {
                            objectArray[0] = InetAddress.getByName(string2);
                        }
                        catch (UnknownHostException unknownHostException) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("IntrospectionUtils: Unable to resolve host name:" + string2));
                            }
                            bl2 = false;
                        }
                        if (stringBuilder != null) {
                            stringBuilder.append(method3.getName()).append("(InetAddress.getByName(\"").append(string2).append("\"))");
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("IntrospectionUtils: Unknown type " + clazz.getName()));
                    }
                    if (bl2) {
                        method3.invoke(object, objectArray);
                        return true;
                    }
                }
                if (!"setProperty".equals(method3.getName())) continue;
                if (method3.getReturnType() == Boolean.TYPE) {
                    method2 = method3;
                    continue;
                }
                method = method3;
            }
            if (bl && (method2 != null || method != null)) {
                if (stringBuilder != null) {
                    stringBuilder.append("setProperty(\"").append(string).append("\", \"").append(IntrospectionUtils.escape(string2)).append("\")");
                }
                Object[] objectArray = new Object[]{string, string2};
                if (method2 != null) {
                    try {
                        return (Boolean)method2.invoke(object, objectArray);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (method != null) {
                            method.invoke(object, objectArray);
                            return true;
                        }
                        throw illegalArgumentException;
                    }
                }
                method.invoke(object, objectArray);
                return true;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {
            log.warn((Object)sm.getString("introspectionUtils.setPropertyError", string, string2, object.getClass()), (Throwable)exception);
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionUtils.handleThrowable(invocationTargetException.getCause());
            log.warn((Object)sm.getString("introspectionUtils.setPropertyError", string, string2, object.getClass()), (Throwable)invocationTargetException);
        }
        return false;
    }

    public static String escape(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuilder.append('\\').append('\"');
                continue;
            }
            if (c == '\\') {
                stringBuilder.append('\\').append('\\');
                continue;
            }
            if (c == '\n') {
                stringBuilder.append('\\').append('n');
                continue;
            }
            if (c == '\r') {
                stringBuilder.append('\\').append('r');
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static Object getProperty(Object object, String string) {
        if (XReflectionIntrospectionUtils.isEnabled()) {
            return XReflectionIntrospectionUtils.getPropertyInternal(object, string);
        }
        String string2 = "get" + IntrospectionUtils.capitalize(string);
        String string3 = "is" + IntrospectionUtils.capitalize(string);
        try {
            Method[] methodArray = IntrospectionUtils.findMethods(object.getClass());
            Method method = null;
            for (Method method2 : methodArray) {
                Class<?>[] classArray = method2.getParameterTypes();
                if (string2.equals(method2.getName()) && classArray.length == 0) {
                    return method2.invoke(object, (Object[])null);
                }
                if (string3.equals(method2.getName()) && classArray.length == 0) {
                    return method2.invoke(object, (Object[])null);
                }
                if (!"getProperty".equals(method2.getName())) continue;
                method = method2;
            }
            if (method != null) {
                Object[] objectArray = new Object[]{string};
                return method.invoke(object, objectArray);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException exception) {
            log.warn((Object)sm.getString("introspectionUtils.getPropertyError", string, object.getClass()), (Throwable)exception);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof NullPointerException) {
                return null;
            }
            ExceptionUtils.handleThrowable(invocationTargetException.getCause());
            log.warn((Object)sm.getString("introspectionUtils.getPropertyError", string, object.getClass()), (Throwable)invocationTargetException);
        }
        return null;
    }

    @Deprecated
    public static String replaceProperties(String string, Hashtable<Object, Object> hashtable, PropertySource[] propertySourceArray) {
        return IntrospectionUtils.replaceProperties(string, hashtable, propertySourceArray, null);
    }

    public static String replaceProperties(String string, Hashtable<Object, Object> hashtable, PropertySource[] propertySourceArray, ClassLoader classLoader) {
        int n;
        if (string == null || string.indexOf(36) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while ((n = string.indexOf(36, n2)) >= 0) {
            if (n > 0) {
                stringBuilder.append(string.substring(n2, n));
            }
            if (n == string.length() - 1) {
                stringBuilder.append('$');
                n2 = n + 1;
                continue;
            }
            if (string.charAt(n + 1) != '{') {
                stringBuilder.append('$');
                n2 = n + 1;
                continue;
            }
            int n3 = string.indexOf(125, n);
            if (n3 < 0) {
                stringBuilder.append(string.substring(n));
                n2 = string.length();
                continue;
            }
            String string2 = string.substring(n + 2, n3);
            String string3 = IntrospectionUtils.getProperty(string2, hashtable, propertySourceArray, classLoader);
            if (string3 == null) {
                int n4 = string2.indexOf(":-");
                if (n4 != -1) {
                    String string4 = string2.substring(n4 + 2);
                    string3 = IntrospectionUtils.getProperty(string2 = string2.substring(0, n4), hashtable, propertySourceArray, classLoader);
                    if (string3 == null) {
                        string3 = string4;
                    }
                } else {
                    string3 = "${" + string2 + "}";
                }
            }
            stringBuilder.append(string3);
            n2 = n3 + 1;
        }
        if (n2 < string.length()) {
            stringBuilder.append(string.substring(n2));
        }
        return stringBuilder.toString();
    }

    private static String getProperty(String string, Hashtable<Object, Object> hashtable, PropertySource[] propertySourceArray, ClassLoader classLoader) {
        String string2 = null;
        if (hashtable != null) {
            string2 = (String)hashtable.get(string);
        }
        if (string2 == null && propertySourceArray != null) {
            PropertySource propertySource;
            PropertySource[] propertySourceArray2 = propertySourceArray;
            int n = propertySourceArray2.length;
            for (int i = 0; i < n && (string2 = (propertySource = propertySourceArray2[i]) instanceof SecurePropertySource ? ((SecurePropertySource)propertySource).getProperty(string, classLoader) : propertySource.getProperty(string)) == null; ++i) {
            }
        }
        return string2;
    }

    public static String capitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }

    public static void clear() {
        objectMethods.clear();
    }

    public static Method[] findMethods(Class<?> clazz) {
        Method[] methodArray = objectMethods.get(clazz);
        if (methodArray != null) {
            return methodArray;
        }
        methodArray = clazz.getMethods();
        objectMethods.put(clazz, methodArray);
        return methodArray;
    }

    public static Method findMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        Method[] methodArray;
        for (Method method : methodArray = IntrospectionUtils.findMethods(clazz)) {
            if (!method.getName().equals(string)) continue;
            Class<?>[] classArray2 = method.getParameterTypes();
            if (classArray == null && classArray2.length == 0) {
                return method;
            }
            if (classArray.length != classArray2.length) continue;
            boolean bl = true;
            for (int i = 0; i < classArray.length; ++i) {
                if (classArray[i] == classArray2[i]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return method;
        }
        return null;
    }

    public static Object callMethod1(Object object, String string, Object object2, String string2, ClassLoader classLoader) throws Exception {
        if (object == null || string == null || object2 == null) {
            throw new IllegalArgumentException(sm.getString("introspectionUtils.nullParameter"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("IntrospectionUtils: callMethod1 " + object.getClass().getName() + " " + object2.getClass().getName() + " " + string2));
        }
        Class[] classArray = new Class[]{string2 == null ? object2.getClass() : classLoader.loadClass(string2)};
        Method method = IntrospectionUtils.findMethod(object.getClass(), string, classArray);
        if (method == null) {
            throw new NoSuchMethodException(object.getClass().getName() + " " + string);
        }
        try {
            return method.invoke(object, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionUtils.handleThrowable(invocationTargetException.getCause());
            throw invocationTargetException;
        }
    }

    public static Object callMethodN(Object object, String string, Object[] objectArray, Class<?>[] classArray) throws Exception {
        Method method = null;
        method = IntrospectionUtils.findMethod(object.getClass(), string, classArray);
        if (method == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("IntrospectionUtils: Can't find method " + string + " in " + object + " CLASS " + object.getClass()));
            }
            return null;
        }
        try {
            Object object2 = method.invoke(object, objectArray);
            if (log.isDebugEnabled()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(object.getClass().getName()).append('.').append(string).append("( ");
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(objectArray[i]);
                }
                stringBuilder.append(")");
                log.debug((Object)("IntrospectionUtils:" + stringBuilder.toString()));
            }
            return object2;
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionUtils.handleThrowable(invocationTargetException.getCause());
            throw invocationTargetException;
        }
    }

    public static Object convert(String string, Class<?> clazz) {
        Object object = null;
        if ("java.lang.String".equals(clazz.getName())) {
            object = string;
        } else if ("java.lang.Integer".equals(clazz.getName()) || "int".equals(clazz.getName())) {
            try {
                object = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("java.lang.Boolean".equals(clazz.getName()) || "boolean".equals(clazz.getName())) {
            object = Boolean.valueOf(string);
        } else if ("java.net.InetAddress".equals(clazz.getName())) {
            try {
                object = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("IntrospectionUtils: Unable to resolve host name:" + string));
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("IntrospectionUtils: Unknown type " + clazz.getName()));
        }
        if (object == null) {
            throw new IllegalArgumentException(sm.getString("introspectionUtils.conversionError", string, clazz.getName()));
        }
        return object;
    }

    public static boolean isInstance(Class<?> clazz, String string) {
        Class<?>[] classArray;
        if (string.equals(clazz.getName())) {
            return true;
        }
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            if (!IntrospectionUtils.isInstance(clazz2, string)) continue;
            return true;
        }
        Class<?> clazz3 = clazz.getSuperclass();
        if (clazz3 == null) {
            return false;
        }
        return IntrospectionUtils.isInstance(clazz3, string);
    }

    public static interface SecurePropertySource
    extends PropertySource {
        public String getProperty(String var1, ClassLoader var2);
    }

    public static interface PropertySource {
        public String getProperty(String var1);
    }
}

