/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.openide.awt.GraphicsUtils;
import org.openide.awt.HtmlRenderer;
import org.openide.explorer.propertysheet.Boolean3WayEditor;
import org.openide.explorer.propertysheet.ButtonPanel;
import org.openide.explorer.propertysheet.CheckboxInplaceEditor;
import org.openide.explorer.propertysheet.ComboInplaceEditor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.IconPanel;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.NodePropertyModel;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.RadioInplaceEditor;
import org.openide.explorer.propertysheet.ReusablePropertyEnv;
import org.openide.explorer.propertysheet.ReusablePropertyModel;
import org.openide.explorer.propertysheet.StringInplaceEditor;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;

final class RendererFactory {
    private static final int MAX_HTML_LENGTH = 0x100000;
    private StringRenderer stringRenderer;
    private CheckboxRenderer checkboxRenderer;
    private ComboboxRenderer comboboxRenderer;
    private RadioRenderer radioRenderer;
    private TextFieldRenderer textFieldRenderer;
    private ButtonPanel buttonPanel;
    private IconPanel iconPanel;
    private final ReusablePropertyModel mdl;
    private final ReusablePropertyEnv env;
    private PropertyChangeListener activeThemeListener;
    private boolean tableUI;
    private boolean suppressButton;
    private int radioButtonMax = -1;
    private boolean useRadioBoolean = PropUtils.forceRadioButtons;
    private boolean useLabels;

    public RendererFactory(boolean bl, ReusablePropertyEnv reusablePropertyEnv, ReusablePropertyModel reusablePropertyModel) {
        this.tableUI = bl;
        this.env = reusablePropertyEnv;
        this.mdl = reusablePropertyModel;
        assert (reusablePropertyModel != null && reusablePropertyEnv != null);
        ToolkitPropertyChangeListenerProxy toolkitPropertyChangeListenerProxy = new ToolkitPropertyChangeListenerProxy();
        this.activeThemeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RendererFactory.this.stringRenderer = null;
                RendererFactory.this.checkboxRenderer = null;
                RendererFactory.this.comboboxRenderer = null;
                RendererFactory.this.radioRenderer = null;
                RendererFactory.this.textFieldRenderer = null;
                RendererFactory.this.buttonPanel = null;
                RendererFactory.this.iconPanel = null;
            }
        };
        toolkitPropertyChangeListenerProxy.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.activeThemeListener, (Object)toolkitPropertyChangeListenerProxy));
    }

    public void setRadioButtonMax(int n) {
        this.radioButtonMax = n;
    }

    public void setSuppressButton(boolean bl) {
        this.suppressButton = bl;
    }

    void setUseRadioBoolean(boolean bl) {
        this.useRadioBoolean = bl;
    }

    void setUseLabels(boolean bl) {
        this.useLabels = bl;
    }

    public JComponent getRenderer(Node.Property property) {
        this.mdl.setProperty(property);
        this.env.reset();
        PropertyEditor propertyEditor = this.preparePropertyEditor(this.mdl, this.env);
        if (propertyEditor instanceof ExceptionPropertyEditor) {
            return this.getExceptionRenderer((Exception)propertyEditor.getValue());
        }
        JComponent jComponent = null;
        try {
            if (propertyEditor.isPaintable()) {
                jComponent = this.prepareString(propertyEditor, this.env);
            } else {
                Class clazz = this.mdl.getPropertyType();
                if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                    boolean bl;
                    boolean bl2 = bl = this.useRadioBoolean || this.env.getFeatureDescriptor().getValue("stringValues") != null;
                    jComponent = bl ? this.prepareRadioButtons(propertyEditor, this.env) : this.prepareCheckbox(propertyEditor, this.env);
                } else if (propertyEditor.getTags() != null) {
                    String[] stringArray = propertyEditor.getTags();
                    boolean bl = Boolean.TRUE.equals(property.getValue("canEditAsText"));
                    jComponent = stringArray.length <= this.radioButtonMax && !bl ? this.prepareRadioButtons(propertyEditor, this.env) : this.prepareCombobox(propertyEditor, this.env);
                } else {
                    jComponent = this.prepareString(propertyEditor, this.env);
                }
            }
            if (jComponent != this.radioRenderer && jComponent != this.textFieldRenderer) {
                if (jComponent != this.checkboxRenderer && this.tableUI && !(jComponent instanceof JComboBox)) {
                    jComponent.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
                } else if (jComponent instanceof JComboBox && this.tableUI) {
                    jComponent.setBorder(BorderFactory.createEmptyBorder());
                } else if (!(jComponent instanceof JComboBox) && !(jComponent instanceof JCheckBox)) {
                    jComponent.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
                }
            }
        }
        catch (Exception exception) {
            jComponent = this.getExceptionRenderer(exception);
            Logger.getLogger(RendererFactory.class.getName()).log(Level.WARNING, null, exception);
        }
        jComponent.setEnabled(property.canWrite());
        boolean bl = Boolean.TRUE.equals(property.getValue("suppressCustomEditor"));
        if (!(jComponent instanceof JLabel || this.env.getState() != ReusablePropertyEnv.STATE_INVALID && property.getValue("valueIcon") == null)) {
            jComponent = this.prepareIconPanel(propertyEditor, this.env, (InplaceEditor)((Object)jComponent));
        }
        if (propertyEditor.supportsCustomEditor() && !PropUtils.noCustomButtons && !this.suppressButton && !bl) {
            ButtonPanel buttonPanel = this.buttonPanel();
            buttonPanel.setInplaceEditor((InplaceEditor)((Object)jComponent));
            jComponent = buttonPanel;
        }
        return jComponent;
    }

    private IconPanel prepareIconPanel(PropertyEditor propertyEditor, PropertyEnv propertyEnv, InplaceEditor inplaceEditor) {
        IconPanel iconPanel = this.iconPanel();
        iconPanel.setInplaceEditor(inplaceEditor);
        iconPanel.connect(propertyEditor, propertyEnv);
        return iconPanel;
    }

    private PropertyEditor preparePropertyEditor(PropertyModel propertyModel, PropertyEnv propertyEnv) {
        PropertyEditor propertyEditor;
        block11: {
            try {
                if (propertyModel instanceof NodePropertyModel) {
                    propertyEditor = ((NodePropertyModel)propertyModel).getPropertyEditor();
                    break block11;
                }
                if (propertyModel instanceof ReusablePropertyModel) {
                    propertyEditor = ((ReusablePropertyModel)propertyModel).getPropertyEditor();
                    break block11;
                }
                Class clazz = propertyModel.getPropertyEditorClass();
                if (clazz != null) {
                    try {
                        propertyEditor = (PropertyEditor)clazz.newInstance();
                        Object object = propertyModel.getValue();
                        Object object2 = propertyEditor.getValue();
                        if (object2 != object) {
                            propertyEditor.setValue(propertyModel.getValue());
                        }
                        break block11;
                    }
                    catch (Exception exception) {
                        propertyEditor = new ExceptionPropertyEditor(exception);
                    }
                    break block11;
                }
                propertyEditor = PropUtils.getPropertyEditor(propertyModel.getPropertyType());
                try {
                    propertyEditor.setValue(propertyModel.getValue());
                }
                catch (InvocationTargetException invocationTargetException) {
                    propertyEditor = new ExceptionPropertyEditor(invocationTargetException);
                }
            }
            catch (Exception exception) {
                propertyEditor = new ExceptionPropertyEditor(exception);
            }
        }
        if (propertyEditor instanceof ExPropertyEditor) {
            ((ExPropertyEditor)propertyEditor).attachEnv(propertyEnv);
        }
        return propertyEditor;
    }

    private JComponent getExceptionRenderer(Exception exception) {
        ExceptionRenderer exceptionRenderer = new ExceptionRenderer();
        exceptionRenderer.setForeground(PropUtils.getErrorColor());
        exceptionRenderer.setText(exception.getMessage());
        return exceptionRenderer;
    }

    public JComponent getStringRenderer() {
        StringRenderer stringRenderer = this.stringRenderer();
        stringRenderer.clear();
        stringRenderer.setEnabled(true);
        return stringRenderer;
    }

    private JComponent prepareRadioButtons(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        RadioRenderer radioRenderer = this.radioRenderer();
        radioRenderer.clear();
        radioRenderer.setUseTitle(this.useLabels);
        radioRenderer.connect(propertyEditor, propertyEnv);
        return radioRenderer.getComponent();
    }

    private JComponent prepareCombobox(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        ComboboxRenderer comboboxRenderer = this.comboboxRenderer();
        comboboxRenderer.clear();
        comboboxRenderer.setEnabled(true);
        comboboxRenderer.connect(propertyEditor, propertyEnv);
        return comboboxRenderer.getComponent();
    }

    private JComponent prepareString(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        StringRenderer stringRenderer = this.tableUI || propertyEditor.isPaintable() ? this.stringRenderer() : this.textFieldRenderer();
        stringRenderer.clear();
        stringRenderer.getComponent().setEnabled(true);
        stringRenderer.connect(propertyEditor, propertyEnv);
        return stringRenderer.getComponent();
    }

    private JComponent prepareCheckbox(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        CheckboxRenderer checkboxRenderer = this.checkboxRenderer();
        checkboxRenderer.setUseTitle(this.useLabels);
        checkboxRenderer.clear();
        checkboxRenderer.setEnabled(true);
        checkboxRenderer.connect(propertyEditor, propertyEnv);
        return checkboxRenderer.getComponent();
    }

    private ButtonPanel buttonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new ButtonPanel();
        }
        this.buttonPanel.setEnabled(true);
        return this.buttonPanel;
    }

    private IconPanel iconPanel() {
        if (this.iconPanel == null) {
            this.iconPanel = new IconPanel();
        }
        this.iconPanel.setEnabled(true);
        return this.iconPanel;
    }

    private ComboboxRenderer comboboxRenderer() {
        if (this.comboboxRenderer == null) {
            this.comboboxRenderer = new ComboboxRenderer(this.tableUI);
            this.comboboxRenderer.setName("ComboboxRenderer for " + this.getClass().getName() + "@" + System.identityHashCode(this));
        }
        return this.comboboxRenderer;
    }

    private StringRenderer stringRenderer() {
        if (this.stringRenderer == null) {
            this.stringRenderer = new StringRenderer(this.tableUI);
            this.stringRenderer.setName("StringRenderer for " + this.getClass().getName() + "@" + System.identityHashCode(this));
        }
        return this.stringRenderer;
    }

    private CheckboxRenderer checkboxRenderer() {
        if (this.checkboxRenderer == null) {
            this.checkboxRenderer = new CheckboxRenderer();
            this.checkboxRenderer.setName("CheckboxRenderer for " + this.getClass().getName() + "@" + System.identityHashCode(this));
        }
        return this.checkboxRenderer;
    }

    private RadioRenderer radioRenderer() {
        if (this.radioRenderer == null) {
            this.radioRenderer = new RadioRenderer(this.tableUI);
            this.radioRenderer.setName("RadioRenderer for " + this.getClass().getName() + "@" + System.identityHashCode(this));
        }
        return this.radioRenderer;
    }

    private TextFieldRenderer textFieldRenderer() {
        if (this.textFieldRenderer == null) {
            this.textFieldRenderer = new TextFieldRenderer();
        }
        return this.textFieldRenderer;
    }

    private static String makeDisplayble(String string, Font font) {
        if (null == string) {
            return string;
        }
        if (null == font) {
            font = new JLabel().getFont();
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 6);
        char[] cArray = string.toCharArray();
        block7: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\t': {
                    stringBuffer.append("        ");
                    continue block7;
                }
                case '\n': {
                    continue block7;
                }
                case '\r': {
                    continue block7;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block7;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block7;
                }
                default: {
                    if (null == font || font.canDisplay(c)) {
                        stringBuffer.append(c);
                        continue block7;
                    }
                    stringBuffer.append("\\u");
                    String string2 = Integer.toHexString(c);
                    for (int j = 0; j < 4 - string2.length(); ++j) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(string2);
                }
            }
        }
        return stringBuffer.toString();
    }

    private class ExceptionRenderer
    extends JLabel
    implements InplaceEditor {
        private ExceptionRenderer() {
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
        }

        @Override
        public Color getForeground() {
            return PropUtils.getErrorColor();
        }

        @Override
        public void clear() {
        }

        @Override
        public void connect(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public KeyStroke[] getKeyStrokes() {
            return null;
        }

        @Override
        public PropertyEditor getPropertyEditor() {
            return null;
        }

        @Override
        public PropertyModel getPropertyModel() {
            return null;
        }

        @Override
        public Object getValue() {
            return this.getText();
        }

        @Override
        public boolean isKnownComponent(Component component) {
            return component == this;
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
        }

        @Override
        public void reset() {
        }

        @Override
        public void setPropertyModel(PropertyModel propertyModel) {
        }

        @Override
        public void setValue(Object object) {
        }

        @Override
        public boolean supportsTextEntry() {
            return false;
        }
    }

    private static final class ExceptionPropertyEditor
    implements PropertyEditor {
        Exception e;

        public ExceptionPropertyEditor(Exception exception) {
            this.e = exception;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        @Override
        public String getAsText() {
            return this.e.getMessage();
        }

        @Override
        public Component getCustomEditor() {
            return null;
        }

        @Override
        public String getJavaInitializationString() {
            return null;
        }

        @Override
        public String[] getTags() {
            return null;
        }

        @Override
        public Object getValue() {
            return this.e;
        }

        @Override
        public boolean isPaintable() {
            return false;
        }

        @Override
        public void paintValue(Graphics graphics, Rectangle rectangle) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        @Override
        public void setAsText(String string) throws IllegalArgumentException {
        }

        @Override
        public void setValue(Object object) {
        }

        @Override
        public boolean supportsCustomEditor() {
            return false;
        }
    }

    private static final class RadioRenderer
    extends RadioInplaceEditor {
        private boolean needLayout = true;

        public RadioRenderer(boolean bl) {
            super(bl);
        }

        @Override
        public void connect(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
            super.connect(propertyEditor, propertyEnv);
            this.needLayout = true;
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.needLayout) {
                this.getLayout().layoutContainer(this);
                this.needLayout = false;
            }
            super.paint(graphics);
            this.clear();
        }

        @Override
        protected RadioInplaceEditor.InvRadioButton createButton() {
            return new NoEventsInvRadioButton();
        }

        @Override
        protected void configureButton(RadioInplaceEditor.InvRadioButton invRadioButton, String string) {
            if (this.editor.getTags().length == 1) {
                invRadioButton.setEnabled(false);
            } else {
                invRadioButton.setEnabled(this.isEnabled());
            }
            invRadioButton.setText(string);
            invRadioButton.setForeground(this.getForeground());
            invRadioButton.setBackground(this.getBackground());
            invRadioButton.setFont(this.getFont());
            if (string.equals(this.editor.getAsText())) {
                invRadioButton.setSelected(true);
            } else {
                invRadioButton.setSelected(false);
            }
        }

        @Override
        public void addContainerListener(ContainerListener containerListener) {
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void addComponentListener(ComponentListener componentListener) {
        }

        @Override
        public void addHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
        }

        @Override
        public void addHierarchyListener(HierarchyListener hierarchyListener) {
        }

        @Override
        protected void firePropertyChange(String string, Object object, Object object2) {
        }

        @Override
        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }

        @Override
        public void firePropertyChange(String string, int n, int n2) {
        }

        @Override
        public void firePropertyChange(String string, byte by, byte by2) {
        }

        @Override
        public void firePropertyChange(String string, char c, char c2) {
        }

        @Override
        public void firePropertyChange(String string, double d, double d2) {
        }

        @Override
        public void firePropertyChange(String string, float f, float f2) {
        }

        @Override
        public void firePropertyChange(String string, short s, short s2) {
        }

        private class NoEventsInvRadioButton
        extends RadioInplaceEditor.InvRadioButton {
            private NoEventsInvRadioButton() {
            }

            @Override
            public void addActionListener(ActionListener actionListener) {
            }

            @Override
            public void addContainerListener(ContainerListener containerListener) {
            }

            @Override
            public void addChangeListener(ChangeListener changeListener) {
            }

            @Override
            public void addComponentListener(ComponentListener componentListener) {
            }

            @Override
            public void addHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
            }

            @Override
            public void addHierarchyListener(HierarchyListener hierarchyListener) {
            }

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
            }

            @Override
            protected void fireStateChanged() {
            }

            @Override
            protected void firePropertyChange(String string, Object object, Object object2) {
            }

            @Override
            public void firePropertyChange(String string, boolean bl, boolean bl2) {
            }

            @Override
            public void firePropertyChange(String string, int n, int n2) {
            }

            @Override
            public void firePropertyChange(String string, byte by, byte by2) {
            }

            @Override
            public void firePropertyChange(String string, char c, char c2) {
            }

            @Override
            public void firePropertyChange(String string, double d, double d2) {
            }

            @Override
            public void firePropertyChange(String string, float f, float f2) {
            }

            @Override
            public void firePropertyChange(String string, short s, short s2) {
            }
        }
    }

    private static final class TextFieldRenderer
    extends StringInplaceEditor {
        private TextFieldRenderer() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            this.setEnabled(PropUtils.checkEnabled(this, this.editor, this.env));
            super.paintComponent(graphics);
            this.clear();
        }

        protected void fireActionPerformed(ActionEvent actionEvent) {
        }

        protected void fireStateChanged() {
        }

        @Override
        protected void firePropertyChange(String string, Object object, Object object2) {
            boolean bl;
            boolean bl2 = bl = "locale".equals(string) || "document".equals(string);
            if (bl) {
                super.firePropertyChange(string, object, object2);
            }
        }
    }

    private static final class StringRenderer
    extends JLabel
    implements InplaceEditor {
        private PropertyEditor editor = null;
        private PropertyEnv env = null;
        private boolean tableUI = false;
        private boolean enabled = true;
        private JLabel htmlLabel = HtmlRenderer.createLabel();
        private JLabel noHtmlLabel = new JLabel();
        private Object value = null;
        private static final boolean isGTK = "GTK".equals(UIManager.getLookAndFeel().getID());
        private static Insets paintViewInsets = new Insets(0, 0, 0, 0);
        private static Rectangle paintIconR = new Rectangle();
        private static Rectangle paintTextR = new Rectangle();
        private static Rectangle paintViewR = new Rectangle();

        public StringRenderer(boolean bl) {
            this.tableUI = bl;
            this.setOpaque(true);
            ((HtmlRenderer.Renderer)this.htmlLabel).setRenderStyle(1);
        }

        @Override
        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        @Override
        public void setText(String string) {
            if (string != null) {
                if (string.length() > 512) {
                    super.setText(RendererFactory.makeDisplayble(string.substring(0, 512), this.getFont()));
                } else {
                    super.setText(RendererFactory.makeDisplayble(string, this.getFont()));
                }
            } else {
                super.setText("");
            }
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        protected void firePropertyChange(String string, Object object, Object object2) {
        }

        @Override
        public void validate() {
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint() {
        }

        @Override
        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.getText().length() > 1024) {
                return new Dimension(4196, PropUtils.getMinimumPropPanelHeight());
            }
            Dimension dimension = super.getPreferredSize();
            dimension.width = Math.max(dimension.width, PropUtils.getMinimumPropPanelWidth());
            dimension.height = Math.max(dimension.height, PropUtils.getMinimumPropPanelHeight());
            return dimension;
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.editor != null) {
                this.setEnabled(PropUtils.checkEnabled(this, this.editor, this.env));
            }
            if (this.editor instanceof ExceptionPropertyEditor) {
                this.setForeground(PropUtils.getErrorColor());
            }
            if (this.editor != null && this.editor.isPaintable()) {
                this.delegatedPaint(graphics);
            } else {
                String string = this.env == null ? null : (String)this.env.getFeatureDescriptor().getValue("htmlDisplayValue");
                boolean bl = string != null;
                JLabel jLabel = bl ? this.htmlLabel : this.noHtmlLabel;
                String string2 = bl ? string : this.getText();
                string2 = string2 == null ? "" : RendererFactory.makeDisplayble(string2, this.getFont());
                if (bl) {
                    ((HtmlRenderer.Renderer)jLabel).setHtml(string2.length() <= 0x100000);
                }
                jLabel.setFont(this.getFont());
                jLabel.setEnabled(this.isEnabled());
                jLabel.setText(string2);
                if (!bl) {
                    jLabel.putClientProperty("html", null);
                }
                jLabel.setIcon(this.getIcon());
                jLabel.setIconTextGap(this.getIconTextGap());
                jLabel.setBounds(this.getBounds());
                jLabel.setOpaque(true);
                jLabel.setBackground(this.getBackground());
                jLabel.setForeground(this.getForeground());
                jLabel.setBorder(this.getBorder());
                if ((isGTK || "com.sun.java.swing.plaf.windows.WindowsLabelUI".equals(jLabel.getUI().getClass().getName())) && !this.isEnabled() && !bl) {
                    GraphicsUtils.configureDefaultRenderingHints((Graphics)graphics);
                    graphics.setColor(jLabel.getBackground());
                    graphics.fillRect(0, 0, jLabel.getWidth(), jLabel.getHeight());
                    graphics.setColor(jLabel.getForeground());
                    Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    Insets insets = jLabel.getInsets(paintViewInsets);
                    StringRenderer.paintViewR.x = insets.left;
                    StringRenderer.paintViewR.y = insets.top;
                    StringRenderer.paintViewR.width = jLabel.getWidth() - (insets.left + insets.right);
                    StringRenderer.paintViewR.height = jLabel.getHeight() - (insets.top + insets.bottom);
                    StringRenderer.paintIconR.height = 0;
                    StringRenderer.paintIconR.width = 0;
                    StringRenderer.paintIconR.y = 0;
                    StringRenderer.paintIconR.x = 0;
                    StringRenderer.paintTextR.height = 0;
                    StringRenderer.paintTextR.width = 0;
                    StringRenderer.paintTextR.y = 0;
                    StringRenderer.paintTextR.x = 0;
                    String string3 = SwingUtilities.layoutCompoundLabel(jLabel, fontMetrics, string2, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), paintViewR, paintIconR, paintTextR, jLabel.getIconTextGap());
                    if (icon != null) {
                        icon.paintIcon(jLabel, graphics, StringRenderer.paintIconR.x, StringRenderer.paintIconR.y);
                    }
                    int n = StringRenderer.paintTextR.x;
                    int n2 = StringRenderer.paintTextR.y + fontMetrics.getAscent();
                    int n3 = jLabel.getDisplayedMnemonicIndex();
                    Color color = jLabel.getForeground();
                    if (isGTK && null == (color = UIManager.getColor("Tree.textForeground"))) {
                        color = Color.BLACK;
                    }
                    Color color2 = color.brighter();
                    if (Color.BLACK.equals(color)) {
                        color2 = Color.GRAY;
                    }
                    graphics.setColor(color2);
                    BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string3, n3, n, n2);
                } else {
                    jLabel.paint(graphics);
                }
            }
            this.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void delegatedPaint(Graphics graphics) {
            Color color = graphics.getColor();
            try {
                Object object;
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics.setColor(this.getForeground());
                if (!this.tableUI) {
                    object = BorderFactory.createBevelBorder(1);
                    object.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
                }
                object = this.getBounds();
                ((Rectangle)object).x = this.getWidth() > 16 ? (this.editor instanceof Boolean3WayEditor ? 0 : 3) : 0;
                ((Rectangle)object).width = ((Rectangle)object).width - (this.getWidth() > 16 ? (this.editor instanceof Boolean3WayEditor ? 0 : 3) : 0);
                ((Rectangle)object).y = 0;
                this.editor.paintValue(graphics, (Rectangle)object);
            }
            finally {
                graphics.setColor(color);
            }
        }

        @Override
        public void clear() {
            this.editor = null;
            this.env = null;
            this.setIcon(null);
            this.setOpaque(true);
        }

        @Override
        public void setValue(Object object) {
            this.value = object;
            this.setText(this.value instanceof String ? (String)this.value : (this.value != null ? this.value.toString() : null));
        }

        @Override
        public void connect(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
            this.editor = propertyEditor;
            this.env = propertyEnv;
            this.reset();
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public KeyStroke[] getKeyStrokes() {
            return null;
        }

        @Override
        public PropertyEditor getPropertyEditor() {
            return this.editor;
        }

        @Override
        public PropertyModel getPropertyModel() {
            return null;
        }

        @Override
        public Object getValue() {
            return this.getText();
        }

        public void handleInitialInputEvent(InputEvent inputEvent) {
        }

        @Override
        public boolean isKnownComponent(Component component) {
            return false;
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
        }

        @Override
        public void reset() {
            this.setText(this.editor.getAsText());
            Image image = null;
            if (this.env != null) {
                if (this.env.getState() == PropertyEnv.STATE_INVALID) {
                    this.setForeground(PropUtils.getErrorColor());
                    image = ImageUtilities.loadImage((String)"org/openide/resources/propertysheet/invalid.gif");
                } else {
                    Object object;
                    FeatureDescriptor featureDescriptor = this.env.getFeatureDescriptor();
                    Object object2 = object = featureDescriptor == null ? null : featureDescriptor.getValue("valueIcon");
                    if (object instanceof Icon) {
                        this.setIcon((Icon)object);
                    } else if (object instanceof Image) {
                        image = (Image)object;
                    }
                }
            }
            if (image != null) {
                this.setIcon(new ImageIcon(image));
            }
        }

        @Override
        public void setPropertyModel(PropertyModel propertyModel) {
        }

        @Override
        public boolean supportsTextEntry() {
            return false;
        }

        protected void fireActionPerformed(ActionEvent actionEvent) {
        }

        protected void fireStateChanged() {
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
        }
    }

    private static final class CheckboxRenderer
    extends CheckboxInplaceEditor {
        private CheckboxRenderer() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            this.setEnabled(PropUtils.checkEnabled(this, this.editor, this.env));
            super.paintComponent(graphics);
            this.clear();
        }

        @Override
        protected void fireActionPerformed(ActionEvent actionEvent) {
        }

        @Override
        protected void fireStateChanged() {
        }

        @Override
        protected void firePropertyChange(String string, Object object, Object object2) {
            if ("foreground".equals(string) || "background".equals(string) || "font".equals(string)) {
                super.firePropertyChange(string, object, object2);
            }
        }

        @Override
        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }

        @Override
        public void firePropertyChange(String string, int n, int n2) {
        }

        @Override
        public void firePropertyChange(String string, byte by, byte by2) {
        }

        @Override
        public void firePropertyChange(String string, char c, char c2) {
        }

        @Override
        public void firePropertyChange(String string, double d, double d2) {
        }

        @Override
        public void firePropertyChange(String string, float f, float f2) {
        }

        @Override
        public void firePropertyChange(String string, short s, short s2) {
        }
    }

    static final class ComboboxRenderer
    extends ComboInplaceEditor {
        private Object item = null;
        boolean editable = false;

        public ComboboxRenderer(boolean bl) {
            super(bl);
        }

        @Override
        public boolean isEditable() {
            return false;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            this.setEnabled(this.isEnabled() && this.env.isEditable());
            this.doLayout();
            super.paintComponent(graphics);
            this.clear();
        }

        @Override
        public void clear() {
            super.clear();
            this.item = null;
        }

        @Override
        public void setSelectedItem(Object object) {
            this.item = object;
            if (this.item == null && this.editor != null && this.editor.getTags().length > 0) {
                this.item = this.editor.getTags()[0];
            }
            if (this.editable) {
                this.getEditor().setItem(this.getSelectedItem());
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.item;
        }

        @Override
        public void installAncestorListener() {
        }

        @Override
        public void processFocusEvent(FocusEvent focusEvent) {
        }

        @Override
        public void processMouseEvent(MouseEvent mouseEvent) {
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
        }

        protected void fireActionPerformed(ActionEvent actionEvent) {
        }

        protected void fireStateChanged() {
        }

        @Override
        protected void firePropertyChange(String string, Object object, Object object2) {
            super.firePropertyChange(string, object, object2);
        }
    }

    private static class ToolkitPropertyChangeListenerProxy
    implements PropertyChangeListener {
        private PropertyChangeListener l;

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.l = propertyChangeListener;
            Toolkit.getDefaultToolkit().addPropertyChangeListener("win.xpstyle.themeActive", this);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.l == propertyChangeListener) {
                Toolkit.getDefaultToolkit().removePropertyChangeListener("win.xpstyle.themeActive", this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.l.propertyChange(propertyChangeEvent);
        }
    }
}

