/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.writers;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.Stack;
import javajs.api.GenericBinaryDocument;
import javajs.util.BS;
import javajs.util.BinaryDocument;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.writers.CMLWriter;
import org.jmol.viewer.Viewer;

public class CDXMLWriter
extends CMLWriter {
    private GenericBinaryDocument doc;
    private Stack<String> objects = new Stack();
    private SB sb = new SB();
    private int sbpt;
    private static final int kCDXProp_ChemicalWarning = 16;
    private static final int kCDXProp_2DPosition = 512;
    private static final int kCDXProp_Node_Type = 1024;
    private static final int kCDXProp_Node_Element = 1026;
    private static final int kCDXProp_Atom_Isotope = 1056;
    private static final int kCDXProp_Atom_Charge = 1057;
    private static final int kCDXProp_Node_Attachments = 1074;
    private static final int kCDXProp_Atom_GenericNickname = 1075;
    private static final int kCDXProp_Bond_Order = 1536;
    private static final int kCDXProp_Bond_Display = 1537;
    private static final int kCDXProp_Bond_Display2 = 1538;
    private static final int kCDXProp_Bond_Begin = 1540;
    private static final int kCDXProp_Bond_End = 1541;
    private static final int kCDXProp_Bond_BeginAttach = 1544;
    private static final int kCDXProp_Bond_EndAttach = 1545;
    private static final int kCDXProp_Text = 1792;
    private static final int kCDXObj_Document = 32768;
    private static final int kCDXObj_Page = 32769;
    private static final int kCDXObj_Group = 32770;
    private static final int kCDXObj_Fragment = 32771;
    private static final int kCDXObj_Node = 32772;
    private static final int kCDXObj_Bond = 32773;
    private static final int kCDXObj_Text = 32774;
    private static final int kCDXNodeType_Unspecified = 0;
    private static final int kCDXNodeType_Element = 1;
    private static final int kCDXNodeType_ElementList = 2;
    private static final int kCDXNodeType_ElementListNickname = 3;
    private static final int kCDXNodeType_Nickname = 4;
    private static final int kCDXNodeType_Fragment = 5;
    private static final int kCDXNodeType_Formula = 6;
    private static final int kCDXNodeType_GenericNickname = 7;
    private static final int kCDXNodeType_AnonymousAlternativeGroup = 8;
    private static final int kCDXNodeType_NamedAlternativeGroup = 9;
    private static final int kCDXNodeType_MultiAttachment = 10;
    private static final int kCDXNodeType_VariableAttachment = 11;
    private static final int kCDXNodeType_ExternalConnectionPoint = 12;
    private static final int kCDXNodeType_LinkNode = 13;
    private static final int kCDXBondOrder_Single = 1;
    private static final int kCDXBondOrder_Double = 2;
    private static final int kCDXBondOrder_Triple = 4;
    private static final int kCDXBondOrder_Quadruple = 8;
    private static final int kCDXBondOrder_Quintuple = 16;
    private static final int kCDXBondOrder_Sextuple = 32;
    private static final int kCDXBondOrder_Half = 64;
    private static final int kCDXBondOrder_OneHalf = 128;
    private static final int kCDXBondOrder_TwoHalf = 256;
    private static final int kCDXBondOrder_ThreeHalf = 512;
    private static final int kCDXBondOrder_FourHalf = 1024;
    private static final int kCDXBondOrder_FiveHalf = 2048;
    private static final int kCDXBondOrder_Dative = 4096;
    private static final int kCDXBondOrder_Ionic = 8192;
    private static final int kCDXBondOrder_Hydrogen = 16384;
    private static final int kCDXBondOrder_ThreeCenter = 32768;
    private static final int kCDXBondDisplay_Solid = 0;
    private static final int kCDXBondDisplay_Dash = 1;
    private static final int kCDXBondDisplay_Hash = 2;
    private static final int kCDXBondDisplay_WedgedHashBegin = 3;
    private static final int kCDXBondDisplay_WedgedHashEnd = 4;
    private static final int kCDXBondDisplay_Bold = 5;
    private static final int kCDXBondDisplay_WedgeBegin = 6;
    private static final int kCDXBondDisplay_WedgeEnd = 7;
    private static final int kCDXBondDisplay_Wavy = 8;
    private static final int kCDXBondDisplay_HollowWedgeBegin = 9;
    private static final int kCDXBondDisplay_HollowWedgeEnd = 10;
    private static final int kCDXBondDisplay_WavyWedgeBegin = 11;
    private static final int kCDXBondDisplay_WavyWedgeEnd = 12;
    private static final int kCDXBondDisplay_Dot = 13;
    private static final int kCDXBondDisplay_DashDot = 14;

    @Override
    public void set(Viewer viewer, OC out, Object[] data) {
        throw new NullPointerException("CDXMLWriter is not implemented for writing");
    }

    @Override
    public String write(BS bs) {
        throw new NullPointerException("CDXMLWriter is not implemented for writing");
    }

    public static String fromCDX(GenericBinaryDocument binaryDoc) throws Exception {
        return new CDXMLWriter().cdxToCdxml(binaryDoc);
    }

    private String cdxToCdxml(GenericBinaryDocument doc) throws Exception {
        this.doc = doc;
        try {
            CDXMLWriter.openDocument(this.sb);
            this.sb.append("<!DOCTYPE CDXML SYSTEM \"http://www.cambridgesoft.com/xml/cdxml.dtd\" >\n");
            this.sb.append("<CDXML BondLength=\"14.40\">\n");
            doc.setStreamData(null, false);
            doc.seek(22L);
            this.processObject(doc.readShort());
            this.sb.append("</CDXML>\n");
        }
        catch (Exception e) {
            System.out.println(this.sb + "\n" + this.objects);
            e.printStackTrace();
            return null;
        }
        return this.sb.toString();
    }

    private void processObject(int type) throws Exception {
        short prop;
        int id = this.doc.readInt();
        boolean terminated = false;
        String name = null;
        switch (type &= 0xFFFF) {
            default: {
                id = Integer.MIN_VALUE;
                terminated = true;
                break;
            }
            case 32769: {
                name = "page";
                id = Integer.MIN_VALUE;
                break;
            }
            case 32771: {
                name = "fragment";
                break;
            }
            case 32772: {
                name = "n";
                break;
            }
            case 32773: {
                name = "b";
                break;
            }
            case 32774: {
                name = "t";
                id = Integer.MIN_VALUE;
            }
        }
        this.sbpt = this.sb.length();
        this.objects.push(name);
        if (name != null) {
            CDXMLWriter.startOpenTag(this.sb, name);
            if (id != Integer.MIN_VALUE) {
                CDXMLWriter.addAttribute(this.sb, "id", "" + id);
            }
        }
        block12: while ((prop = this.doc.readShort()) != 0) {
            if ((prop & 0x8000) != 0) {
                if (!terminated) {
                    CDXMLWriter.terminateTag(this.sb);
                    terminated = true;
                }
                this.processObject(prop);
                continue;
            }
            int len = this.readLength();
            switch (type) {
                case 32772: {
                    this.writeNodeProperties(prop, len);
                    continue block12;
                }
                case 32774: {
                    if (!terminated) {
                        CDXMLWriter.terminateTag(this.sb);
                        terminated = true;
                    }
                    this.writeTextProperty(prop, len);
                    continue block12;
                }
                case 32773: {
                    this.writeBondProperties(prop, len);
                    continue block12;
                }
            }
            this.skip(len);
        }
        if (name != null) {
            if (!terminated) {
                CDXMLWriter.terminateEmptyTag(this.sb);
            } else {
                CDXMLWriter.closeTag(this.sb, name);
            }
        }
    }

    private void writeNodeProperties(int prop, int len) throws Exception {
        switch (prop) {
            case 512: {
                double y = CDXMLWriter.toPoint(this.readInt(len >> 1));
                double x = CDXMLWriter.toPoint(this.readInt(len >> 1));
                CDXMLWriter.addAttribute(this.sb, "p", x + " " + y);
                break;
            }
            case 1024: {
                String nodeType = CDXMLWriter.getNodeType(this.readInt(len));
                CDXMLWriter.addAttribute(this.sb, "NodeType", nodeType);
                break;
            }
            case 1026: {
                CDXMLWriter.addAttribute(this.sb, "Element", "" + this.readInt(len));
                break;
            }
            case 1056: {
                CDXMLWriter.addAttribute(this.sb, "Isotope", "" + this.readInt(len));
                break;
            }
            case 1057: {
                CDXMLWriter.addAttribute(this.sb, "Charge", "" + this.readInt(len));
                break;
            }
            case 16: {
                CDXMLWriter.addAttribute(this.sb, "Warning", this.readString(len));
                break;
            }
            case 1074: {
                CDXMLWriter.addAttribute(this.sb, "Attachments", this.readArray());
                break;
            }
            case 1075: {
                CDXMLWriter.addAttribute(this.sb, "GenericNickname", this.readString(len));
                break;
            }
            default: {
                this.skip(len);
            }
        }
    }

    private void writeBondProperties(int prop, int len) throws Exception {
        switch (prop) {
            case 1536: {
                String order = CDXMLWriter.getBondOrder(this.readInt(len));
                if (order == null) {
                    this.removeObject();
                    return;
                }
                CDXMLWriter.addAttribute(this.sb, "Order", order);
                break;
            }
            case 1537: {
                String d = CDXMLWriter.getBondDisplay(this.readInt(len));
                if (d == null) {
                    this.removeObject();
                    return;
                }
                CDXMLWriter.addAttribute(this.sb, "Display", d);
                break;
            }
            case 1538: {
                String d2 = CDXMLWriter.getBondDisplay(this.readInt(len));
                if (d2 == null) break;
                CDXMLWriter.addAttribute(this.sb, "Display2", d2);
                break;
            }
            case 1540: {
                CDXMLWriter.addAttribute(this.sb, "B", "" + this.readInt(len));
                break;
            }
            case 1541: {
                CDXMLWriter.addAttribute(this.sb, "E", "" + this.readInt(len));
                break;
            }
            case 1544: {
                CDXMLWriter.addAttribute(this.sb, "BeginAttach", "" + this.readInt(len));
                break;
            }
            case 1545: {
                CDXMLWriter.addAttribute(this.sb, "EndAttach", "" + this.readInt(len));
                break;
            }
            default: {
                this.skip(len);
            }
        }
    }

    private void writeTextProperty(int prop, int len) throws Exception {
        switch (prop) {
            case 1792: {
                String text = this.readString(len);
                System.out.println("CDXMLW text=" + text);
                CDXMLWriter.openTag(this.sb, "s");
                this.sb.setLength(this.sb.length() - 1);
                this.sb.append(CDXMLWriter.wrapCData(text));
                CDXMLWriter.closeTag(this.sb, "s");
                break;
            }
            default: {
                this.skip(len);
            }
        }
    }

    public static String wrapCData(String s) {
        return s.indexOf("&") < 0 && s.indexOf("<") < 0 ? s : "<![CDATA[" + PT.rep(s, "]]>", "]]]]><![CDATA[>") + "]]>";
    }

    private static String getNodeType(int n) {
        String name = null;
        switch (n) {
            case 0: {
                return "Unspecified";
            }
            case 1: {
                return "Element";
            }
            case 4: {
                return "Nickname";
            }
            case 5: {
                return "Fragment";
            }
            case 7: {
                return "GenericNickname";
            }
            case 10: {
                return "MultiAttachment";
            }
            case 11: {
                return "VariableAttachment";
            }
            case 12: {
                return "ExternalConnectionPoint";
            }
            case 2: {
                name = "ElementList";
                break;
            }
            case 3: {
                name = "ElementListNickname";
                break;
            }
            case 6: {
                name = "Formula";
                break;
            }
            case 8: {
                name = "AnonymousAlternativeGroup";
                break;
            }
            case 9: {
                name = "NamedAnonymousGroup";
                break;
            }
            case 13: {
                name = "LinkNode";
            }
        }
        System.err.println("CDXMLWriter Node type " + name + " not identified");
        return "_";
    }

    private static String getBondDisplay(int i) {
        switch (i) {
            case 0: {
                return "Solid";
            }
            case 1: {
                return "Dash";
            }
            case 2: {
                return "Hash";
            }
            case 3: {
                return "WedgedHashBegin";
            }
            case 4: {
                return "WedgedHashEnd";
            }
            case 5: {
                return "Bold";
            }
            case 6: {
                return "WedgeBegin";
            }
            case 7: {
                return "WedgeEnd";
            }
            case 8: {
                return "Wavy";
            }
            case 9: {
                return "HollowWedgeBegin";
            }
            case 10: {
                return "HollowWedgeEnd";
            }
            case 11: {
                return "WavyWedgeBegin";
            }
            case 12: {
                return "WavyWedgeEnd";
            }
            case 13: {
                return "Dot";
            }
            case 14: {
                return "DashDot";
            }
        }
        return null;
    }

    private static String getBondOrder(int i) {
        switch (i) {
            case 1: {
                return "1";
            }
            case 2: {
                return "2";
            }
            case 4: {
                return "3";
            }
            case 8: {
                return "4";
            }
            case 16: {
                return "5";
            }
            case 32: {
                return "6";
            }
            case 64: {
                return "0.5";
            }
            case 128: {
                return "1.5";
            }
            case 256: {
                return "2.5";
            }
            case 512: {
                return "3.5";
            }
            case 1024: {
                return "4.5";
            }
            case 2048: {
                return "5.5";
            }
            case 4096: {
                return "dative";
            }
            case 8192: {
                return "ionic";
            }
            case 16384: {
                return "hydrogen";
            }
            case 32768: {
                return "threecenter";
            }
        }
        return null;
    }

    private void removeObject() {
        this.sb.setLength(this.sbpt);
    }

    private void skip(int len) {
        this.doc.seek(this.doc.getPosition() + (long)len);
    }

    private int readInt(int len) throws Exception {
        switch (len) {
            case 1: {
                return (256 + this.doc.readByte()) % 256;
            }
            case 2: {
                return this.doc.readShort();
            }
            case 4: {
                return this.doc.readInt();
            }
            case 8: {
                return (int)this.doc.readLong();
            }
        }
        System.err.println("CDXMLWriter.readInt len " + len);
        return 0;
    }

    private String readString(int len) throws Exception {
        short nStyles = this.doc.readShort();
        len -= 2;
        switch (nStyles) {
            case 0: {
                break;
            }
            default: {
                this.skip(nStyles * 10);
                len -= nStyles * 10;
            }
        }
        return this.doc.readString(len);
    }

    private String readArray() throws Exception {
        String s = "";
        int i = this.doc.readShort();
        while (--i >= 0) {
            s = s + " " + this.doc.readInt();
        }
        return s.trim();
    }

    private int readLength() throws Exception {
        int len = this.doc.readShort();
        if (len == -1) {
            len = this.doc.readInt();
        }
        return len;
    }

    private static double toPoint(int i) {
        return (double)Math.round((double)i / 655.36) / 100.0;
    }

    public static void main(String[] args) {
        try {
            FileInputStream fis = new FileInputStream("c:/temp/t2.cdx");
            BinaryDocument doc = new BinaryDocument();
            doc.setStream(new BufferedInputStream(fis), false);
            System.out.println(CDXMLWriter.fromCDX(doc));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

