/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import javajs.util.JSJSONParser;
import javajs.util.PT;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.jmol.api.Interface;
import org.jmol.api.JmolAbstractButton;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolStatusListener;
import org.jmol.awt.FileDropper;
import org.jmol.awt.Platform;
import org.jmol.console.JmolButton;
import org.jmol.console.JmolToggleButton;
import org.jmol.dialog.Dialog;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.HistoryFile;
import org.openscience.jmol.app.Jmol;
import org.openscience.jmol.app.JmolApp;
import org.openscience.jmol.app.JmolPlugin;
import org.openscience.jmol.app.SplashInterface;
import org.openscience.jmol.app.jmolpanel.AboutDialog;
import org.openscience.jmol.app.jmolpanel.AtomSetChooser;
import org.openscience.jmol.app.jmolpanel.CreditsDialog;
import org.openscience.jmol.app.jmolpanel.DisplayPanel;
import org.openscience.jmol.app.jmolpanel.GaussianDialog;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;
import org.openscience.jmol.app.jmolpanel.MeasurementTable;
import org.openscience.jmol.app.jmolpanel.PovrayDialog;
import org.openscience.jmol.app.jmolpanel.PreferencesDialog;
import org.openscience.jmol.app.jmolpanel.RecentFilesDialog;
import org.openscience.jmol.app.jmolpanel.Splash;
import org.openscience.jmol.app.jmolpanel.StatusBar;
import org.openscience.jmol.app.jmolpanel.StatusListener;
import org.openscience.jmol.app.jmolpanel.WhatsNewDialog;
import org.openscience.jmol.app.jmolpanel.console.AppConsole;
import org.openscience.jmol.app.jmolpanel.console.ConsoleTextArea;
import org.openscience.jmol.app.jsonkiosk.BannerFrame;
import org.openscience.jmol.app.jsonkiosk.JsonNioClient;
import org.openscience.jmol.app.jsonkiosk.JsonNioServer;
import org.openscience.jmol.app.jsonkiosk.JsonNioService;
import org.openscience.jmol.app.jsonkiosk.KioskFrame;
import org.openscience.jmol.app.surfacetool.SurfaceTool;
import org.openscience.jmol.app.webexport.WebExport;

public class JmolPanel
extends JPanel
implements SplashInterface,
JsonNioClient {
    public static HistoryFile historyFile;
    public static HistoryFile pluginFile;
    private static final boolean addPreferencesDialog;
    private static final boolean addMacrosMenu;
    private static final boolean allowRecentFiles;
    private static final boolean addAtomChooser;
    private static final boolean allowPreferences;
    private static final boolean allowGaussian;
    public Viewer vwr;
    protected JmolAdapter modelAdapter;
    public JmolApp jmolApp;
    protected StatusBar status;
    protected int startupWidth;
    protected int startupHeight;
    private JsonNioServer serverService;
    protected String appletContext;
    public PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public DisplayPanel display;
    protected GaussianDialog gaussianDialog;
    protected RecentFilesDialog recentFiles;
    public AtomSetChooser atomSetChooser;
    public JFrame frame;
    public SplashInterface splash;
    protected JFrame consoleframe;
    protected JsonNioServer clientService;
    protected int qualityJPG = -1;
    protected int qualityPNG = -1;
    protected String imageType;
    public GuiMap guimap;
    protected ExecuteScriptAction executeScriptAction;
    protected PreferencesDialog preferencesDialog;
    protected StatusListener myStatusListener;
    protected SurfaceTool surfaceTool;
    protected MeasurementTable measurementTable;
    protected Map<String, Action> commands;
    protected Map<String, JMenuItem> menuItems;
    protected JToolBar toolbar;
    protected ExportAction exportAction = new ExportAction();
    protected PovrayAction povrayAction = new PovrayAction();
    protected ToWebAction toWebAction = new ToWebAction();
    protected WriteAction writeAction = new WriteAction();
    protected PrintAction printAction = new PrintAction();
    protected CopyImageAction copyImageAction = new CopyImageAction();
    protected CopyScriptAction copyScriptAction = new CopyScriptAction();
    protected SurfaceToolAction surfaceToolAction = new SurfaceToolAction();
    protected PasteClipboardAction pasteClipboardAction = new PasteClipboardAction();
    protected ViewMeasurementTableAction viewMeasurementTableAction = new ViewMeasurementTableAction();
    protected Map<String, Object> vwrOptions;
    protected String windowName;
    protected boolean isPlugin;
    private JMenuBar menubar;
    protected static int numWindows;
    protected static KioskFrame kioskFrame;
    protected static BannerFrame bannerFrame;
    protected static boolean allowJavaConsole;
    protected static final String EDITOR_WINDOW_NAME = "ScriptEditor";
    protected static final String SCRIPT_WINDOW_NAME = "ScriptWindow";
    protected static final String FILE_OPEN_WINDOW_NAME = "FileOpen";
    protected static final String WEB_MAKER_WINDOW_NAME = "JmolWebPageMaker";
    protected static final String SURFACETOOL_WINDOW_NAME = "SurfaceToolWindow";
    protected static final Dimension screenSize;
    protected static final String newwinAction = "newwin";
    protected static final String openAction = "open";
    protected static final String openurlAction = "openurl";
    protected static final String openpdbAction = "openpdb";
    protected static final String openmolAction = "openmol";
    protected static final String newAction = "new";
    protected static final String exportActionProperty = "export";
    protected static final String closeAction = "close";
    protected static final String exitAction = "exit";
    protected static final String aboutAction = "about";
    protected static final String whatsnewAction = "whatsnew";
    protected static final String creditsAction = "credits";
    protected static final String uguideAction = "uguide";
    protected static final String printActionProperty = "print";
    protected static final String recentFilesAction = "recentFiles";
    protected static final String povrayActionProperty = "povray";
    protected static final String writeActionProperty = "write";
    protected static final String editorAction = "editor";
    protected static final String consoleAction = "console";
    protected static final String toWebActionProperty = "toweb";
    protected static final String atomsetchooserAction = "atomsetchooser";
    protected static final String copyImageActionProperty = "copyImage";
    protected static final String copyScriptActionProperty = "copyScript";
    protected static final String surfaceToolActionProperty = "surfaceTool";
    protected static final String pasteClipboardActionProperty = "pasteClipboard";
    protected static final String gaussianAction = "gauss";
    protected static final String resizeAction = "resize";
    Map<String, JmolPlugin> plugins = new Hashtable<String, JmolPlugin>();
    JMenu pluginMenu;
    boolean pluginsSet = false;
    static final String[] imageChoices;
    static final String[] imageExtensions;
    WebExport webExport;
    private JsonNioClient.TouchHandler touchHandler;
    static final String chemFileProperty = "chemFile";
    public static final int OUTSOCKET = 2;

    public JmolPanel(JmolApp jmolApp, Splash splash, JFrame frame, JmolPanel parent, int startupWidth, int startupHeight, Map<String, Object> vwrOptions, Point loc) {
        super(true);
        if (vwrOptions == null) {
            vwrOptions = new Hashtable<String, Object>();
        }
        this.vwrOptions = vwrOptions;
        this.splash = splash;
        this.jmolApp = jmolApp;
        this.frame = frame;
        if (frame != null && frame.getName() == null) {
            frame.setName("JmolApp");
        }
        this.startupWidth = startupWidth;
        this.startupHeight = startupHeight;
        historyFile = jmolApp.historyFile;
        pluginFile = jmolApp.pluginFile;
        ++numWindows;
        try {
            if (historyFile != null) {
                this.say("history file is " + historyFile.getFile().getAbsolutePath());
            }
            if (jmolApp.userPropsFile != null) {
                this.say("user properties file is " + jmolApp.userPropsFile.getAbsolutePath());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.windowName = this.getWindowName();
        this.guimap = this.createGuiMap();
        this.executeScriptAction = new ExecuteScriptAction();
        this.createDisplayAndAddStatusListener();
        this.setupModelAdapterAndViewer();
        this.getDialogs();
        this.getMeasurementTable();
        this.setCommandHooks();
        this.status = this.createStatusBar();
        this.toolbar = this.createToolBar();
        if (!jmolApp.haveDisplay) {
            return;
        }
        this.setupDisplay();
        this.setFrameLocation(loc, parent);
        this.setIntoFrame();
        this.setupConsole();
        this.setupDnD();
        this.setAtomChooser();
        this.launchMainFrame();
    }

    protected List<Action> getFrameActions() {
        Action[] defaultActions = new Action[]{new NewAction(), new NewwinAction(), new OpenAction(), new OpenUrlAction(), new OpenPdbAction(), new OpenMolAction(), this.printAction, this.exportAction, new CloseAction(), new ExitAction(), this.copyImageAction, this.copyScriptAction, this.pasteClipboardAction, new AboutAction(), new WhatsNewAction(), new CreditsAction(), new UguideAction(), new ConsoleAction(), allowRecentFiles ? new RecentFilesAction() : null, this.povrayAction, this.writeAction, this.toWebAction, new ScriptWindowAction(), new ScriptEditorAction(), addAtomChooser ? new AtomSetChooserAction() : null, this.viewMeasurementTableAction, allowGaussian ? new GaussianAction() : null, new ResizeAction(), this.surfaceToolAction};
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(Arrays.asList(defaultActions));
        this.display.addActions(actions);
        if (addPreferencesDialog) {
            this.preferencesDialog.addActions(actions);
        }
        return actions;
    }

    protected String getStringX(String cmd) {
        return JmolResourceHandler.getStringX(cmd);
    }

    protected ImageIcon getIconX(String img) {
        return JmolResourceHandler.getIconX(img);
    }

    protected String getWindowName() {
        return "Jmol";
    }

    protected GuiMap createGuiMap() {
        return new GuiMap();
    }

    protected StatusBar createStatusBar() {
        return new StatusBar(this.startupWidth);
    }

    protected JToolBar createToolBar() {
        JToolBar toolbar = this.newToolbar(PT.getTokens(this.setMenuKeys("toolbar", JmolResourceHandler.getStringX("toolbar"))));
        toolbar.setPreferredSize(new Dimension(this.display.getPreferredSize().width, 25));
        toolbar.add(Box.createHorizontalGlue());
        return toolbar;
    }

    protected JToolBar newToolbar(String[] keys) {
        JToolBar toolbar = new JToolBar();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].equals("-")) {
                toolbar.addSeparator();
                continue;
            }
            toolbar.add(this.createToolbarButton(keys[i]));
        }
        return toolbar;
    }

    protected void createDisplayAndAddStatusListener() {
        this.say(GT.$("Initializing 3D display..."));
        this.display = new DisplayPanel(this);
        this.vwrOptions.put("display", this.display);
        JmolStatusListener userStatusListener = (JmolStatusListener)this.vwrOptions.get("statusListener");
        if (userStatusListener != null && userStatusListener.getClass() == StatusListener.class) {
            userStatusListener = null;
        }
        this.myStatusListener = new StatusListener(this, this.display);
        this.myStatusListener.userStatusListener = userStatusListener;
        this.vwrOptions.put("statusListener", this.myStatusListener);
    }

    protected void setupModelAdapterAndViewer() {
        if (JmolResourceHandler.codePath != null) {
            this.vwrOptions.put("codePath", JmolResourceHandler.codePath);
        }
        if (this.modelAdapter != null) {
            this.vwrOptions.put("modelAdapter", this.modelAdapter);
        }
        this.say(GT.$("Initializing 3D display...4"));
        this.vwr = new Viewer(this.vwrOptions);
        this.say(GT.$("Initializing 3D display...5"));
        this.display.setViewer(this.vwr);
        this.myStatusListener.setViewer(this.vwr);
    }

    protected void getDialogs() {
        if (allowPreferences) {
            this.say(GT.$("Initializing Preferences..."));
            this.preferencesDialog = new PreferencesDialog(this, this.frame, this.guimap, this.vwr);
        }
        if (allowRecentFiles) {
            this.say(GT.$("Initializing Recent Files..."));
            this.recentFiles = new RecentFilesDialog(this.frame);
        }
    }

    protected void getMeasurementTable() {
        if (this.jmolApp.haveDisplay) {
            if (this.measurementTable != null) {
                this.measurementTable.dispose();
            }
            this.measurementTable = new MeasurementTable(this.vwr, this.frame);
        }
    }

    protected void setCommandHooks() {
        if (this.display != null) {
            List<Action> actions = this.getFrameActions();
            this.say(GT.$("Building Command Hooks..."));
            this.commands = new Hashtable<String, Action>();
            for (int i = 0; i < actions.size(); ++i) {
                Action a = actions.get(i);
                if (a == null) continue;
                this.commands.put(a.getValue("Name").toString(), a);
            }
        }
    }

    protected void setupDisplay() {
        if (this.jmolApp.isKiosk) {
            this.add("Center", this.display);
        } else {
            JPanel panel = new JPanel();
            this.menuItems = new Hashtable<String, JMenuItem>();
            this.say(GT.$("Building Menubar..."));
            this.menubar = this.createMenubar();
            this.add("North", this.menubar);
            panel.setLayout(new BorderLayout());
            if (this.toolbar != null) {
                panel.add("North", this.toolbar);
            }
            JPanel ip = new JPanel();
            ip.setLayout(new BorderLayout());
            ip.add("Center", this.display);
            panel.add("Center", ip);
            this.add("Center", panel);
            if (this.status != null) {
                this.add("South", this.status);
            }
        }
        this.say(GT.$("Starting display..."));
        this.display.start();
    }

    protected void setFrameLocation(Point loc, JmolPanel parent) {
        if (this.jmolApp.isKiosk) {
            bannerFrame = new BannerFrame(this.jmolApp.startupWidth, 75);
        } else {
            if (loc == null) {
                if (parent != null) {
                    loc = parent.frame.getLocationOnScreen();
                    int maxX = JmolPanel.screenSize.width - 50;
                    int maxY = JmolPanel.screenSize.height - 50;
                    loc.x += 40;
                    loc.y += 40;
                    if (loc.x > maxX || loc.y > maxY) {
                        loc.setLocation(0, 0);
                    }
                } else if (historyFile == null || (loc = historyFile.getWindowPosition(this.windowName)) == null) {
                    return;
                }
            }
            this.frame.setLocation(loc);
        }
    }

    protected void setIntoFrame() {
        this.frame.setTitle(this.windowName);
        this.frame.setDefaultCloseOperation(0);
        this.frame.setBackground(Color.lightGray);
        this.frame.setLayout(new BorderLayout());
        this.frame.add("Center", this);
        this.frame.pack();
        ImageIcon jmolIcon = JmolResourceHandler.getIconX("icon");
        Image iconImage = jmolIcon.getImage();
        this.frame.setIconImage(iconImage);
        if (!this.isPlugin) {
            this.frame.addWindowListener(new AppCloser());
        }
    }

    protected void setupConsole() {
        this.say(GT.$("Initializing Script Window..."));
        this.vwr.getProperty("DATA_API", "getAppConsole", Boolean.TRUE);
        AppConsole console = this.getConsole();
        if (console != null) {
            if (console.jcd != null && historyFile != null) {
                historyFile.repositionWindow(SCRIPT_WINDOW_NAME, console.jcd, 200, 100, !this.jmolApp.isKiosk);
            }
            console.setStatusListener(this.myStatusListener);
        }
    }

    protected void setupDnD() {
        this.say(GT.$("Setting up Drag-and-Drop..."));
        new FileDropper(this.myStatusListener, this.vwr, null);
    }

    protected void setAtomChooser() {
        this.atomSetChooser = new AtomSetChooser(this.vwr, this.frame);
        this.pcs.addPropertyChangeListener(chemFileProperty, this.atomSetChooser);
    }

    protected void launchMainFrame() {
        this.say(GT.$("Launching main frame..."));
    }

    @Deprecated
    protected static void getJavaConsole(Jmol jmol) {
        jmol.getJavaConsole();
    }

    public void getJavaConsole() {
        if (!this.jmolApp.haveConsole || !allowJavaConsole) {
            return;
        }
        this.consoleframe = new JFrame(GT.$("Jmol Java Console"));
        this.consoleframe.setIconImage(this.frame.getIconImage());
        try {
            final ConsoleTextArea consoleTextArea = new ConsoleTextArea(true);
            consoleTextArea.setFont(Font.decode("monospaced"));
            this.consoleframe.getContentPane().add((Component)new JScrollPane(consoleTextArea), "Center");
            JButton buttonClear = this.guimap.newJButton("JavaConsole.Clear");
            buttonClear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    consoleTextArea.setText("");
                }
            });
            this.consoleframe.getContentPane().add((Component)buttonClear, "South");
        }
        catch (IOException e) {
            JTextArea errorTextArea = new JTextArea();
            errorTextArea.setFont(Font.decode("monospaced"));
            this.consoleframe.getContentPane().add((Component)new JScrollPane(errorTextArea), "Center");
            errorTextArea.append(GT.$("Could not create ConsoleTextArea: ") + e);
        }
        Point location = this.frame.getLocation();
        Dimension size = this.frame.getSize();
        location.y += size.height;
        size.height = 200;
        if (size.height < 200 || size.height > 800) {
            size.height = 200;
        }
        if (size.width < 300 || size.width > 800) {
            size.width = 300;
        }
        if (location.y < 0 || location.y + size.height > JmolPanel.screenSize.height) {
            location.y = JmolPanel.screenSize.height - size.height;
        }
        if (location.x < 0 || location.x + size.width > JmolPanel.screenSize.width) {
            location.x = 0;
        }
        this.consoleframe.setBounds(location.x, location.y, size.width, size.height);
    }

    @Override
    public void showStatus(String message) {
        this.splash.showStatus(message);
    }

    protected void report(String str) {
        if (this.jmolApp.isSilent) {
            return;
        }
        Logger.info(str);
    }

    protected void say(String message) {
        if (this.jmolApp.haveDisplay) {
            if (this.splash == null) {
                this.report(message);
            } else {
                this.splash.showStatus(message);
            }
        }
    }

    protected boolean doClose(boolean saveSize) {
        if (numWindows == 1 && this.vwr.ms.ac > 0 && JOptionPane.showConfirmDialog(this.frame, GT.$("Exit Jmol?"), "Exit", 0, 3) != 0) {
            return false;
        }
        this.dispose(this.frame, saveSize);
        return true;
    }

    void dispose(JFrame f, boolean saveSize) {
        if (this.webExport != null) {
            WebExport.cleanUp();
        }
        if (saveSize) {
            this.saveWindowSizes();
        }
        if (this.clientService != null) {
            this.clientService.close();
            this.clientService = null;
        }
        if (this.serverService != null) {
            this.serverService.close();
            this.serverService = null;
        }
        for (Map.Entry<String, JmolPlugin> e : this.plugins.entrySet()) {
            try {
                e.getValue().destroy();
            }
            catch (Throwable throwable) {}
        }
        this.plugins.clear();
        if (numWindows <= 1) {
            this.report(GT.$("Closing Jmol..."));
            System.exit(0);
        } else {
            --numWindows;
            this.vwr.dispose();
            try {
                f.dispose();
            }
            catch (Exception e) {
                Logger.error("frame disposal exception");
            }
        }
    }

    protected void saveWindowSizes() {
        Component c;
        AppConsole console;
        if (historyFile == null) {
            return;
        }
        if (this.frame != null) {
            historyFile.addWindowInfo(this.windowName, this.frame, null, this.display.dimSize);
        }
        if ((console = this.getConsole()) != null && console.jcd != null) {
            historyFile.addWindowInfo(SCRIPT_WINDOW_NAME, console.jcd, null);
        }
        if ((c = (Component)this.vwr.getProperty("DATA_API", "getScriptEditor", null)) != null) {
            historyFile.addWindowInfo(EDITOR_WINDOW_NAME, c, null);
        }
        if (historyFile.getProperty("clearHistory", "false").equals("true")) {
            historyFile.clear();
        }
    }

    public JMenuItem createMenuItem(String cmd) {
        JMenuItem mi = cmd.endsWith("Check") ? this.guimap.newJCheckBoxMenuItem(cmd, false) : this.guimap.newJMenuItem(cmd);
        ImageIcon f = this.getIconX(cmd + "Image");
        if (f != null) {
            mi.setHorizontalTextPosition(4);
            mi.setIcon(f);
        }
        if (cmd.endsWith("Script")) {
            mi.setActionCommand(this.getStringX(cmd));
            mi.addActionListener(this.executeScriptAction);
        } else {
            mi.setActionCommand(cmd);
            Action a = this.getAction(cmd);
            if (a != null) {
                mi.addActionListener(a);
                a.addPropertyChangeListener(new ActionChangedListener(mi));
                mi.setEnabled(a.isEnabled());
            } else {
                mi.setEnabled(false);
            }
        }
        this.menuItems.put(cmd, mi);
        return mi;
    }

    protected JMenuItem getMenuItem(String cmd) {
        return this.menuItems.get(cmd);
    }

    protected Action getAction(String cmd) {
        return this.commands.get(cmd);
    }

    protected AbstractButton createToolbarButton(String key) {
        boolean isToggle;
        ImageIcon ii = JmolResourceHandler.getIconX(key + "Image");
        boolean isHoldButton = key.startsWith("animatePrev") || key.startsWith("animateNext");
        AbstractButton b = isHoldButton ? new AnimButton(ii, JmolResourceHandler.getStringX(key)) : new JmolButton(ii);
        String isToggleString = JmolResourceHandler.getStringX(key + "Toggle");
        if (isToggleString != null && (isToggle = Boolean.valueOf(isToggleString).booleanValue())) {
            b = new JmolToggleButton(ii);
            if (key.equals("rotateScript")) {
                this.display.buttonRotate = b;
            }
            if (key.equals("modelkitScript")) {
                this.display.buttonModelkit = b;
            }
            this.display.toolbarButtonGroup.add(b);
            String isSelectedString = JmolResourceHandler.getStringX(key + "ToggleSelected");
            if (isSelectedString != null) {
                boolean isSelected = Boolean.valueOf(isSelectedString);
                b.setSelected(isSelected);
            }
        }
        b.setRequestFocusEnabled(false);
        b.setMargin(new Insets(1, 1, 1, 1));
        Action a = null;
        String actionCommand = null;
        if (!isHoldButton) {
            if (key.endsWith("Script")) {
                actionCommand = JmolResourceHandler.getStringX(key);
                a = this.executeScriptAction;
            } else {
                actionCommand = key;
                a = this.getAction(key);
            }
        }
        if (a != null) {
            b.setActionCommand(actionCommand);
            b.addActionListener(a);
            a.addPropertyChangeListener(new ActionChangedListener(b));
            b.setEnabled(a.isEnabled());
        } else {
            b.setEnabled(isHoldButton);
        }
        String tip = this.guimap.getLabel(key + "Tip");
        if (tip != null) {
            this.guimap.map.put(key + "Tip", b);
            b.setToolTipText(tip);
        }
        return b;
    }

    protected JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        this.addNormalMenuBar(mb);
        this.addPluginMenu(mb);
        if (addMacrosMenu) {
            this.addMacrosMenu(mb);
        }
        this.addHelpMenuBar(mb);
        return mb;
    }

    protected void addPluginMenu(JMenuBar mb) {
        this.pluginMenu = this.guimap.newJMenu("plugins");
        mb.add(this.pluginMenu);
        boolean isOK = false;
        try {
            PropertyResourceBundle bundle = new PropertyResourceBundle(this.getClass().getResourceAsStream("/org/openscience/jmol/app/plugins/plugin.properties"));
            isOK = bundle.getKeys().hasMoreElements();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (isOK) {
            this.pluginMenu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    JmolPanel.this.setPlugins();
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
        }
        this.pluginMenu.setEnabled(isOK);
    }

    void setPlugins() {
        if (this.pluginsSet) {
            return;
        }
        this.pluginsSet = true;
        try {
            PropertyResourceBundle bundle = new PropertyResourceBundle(this.getClass().getResourceAsStream("/org/openscience/jmol/app/plugins/plugin.properties"));
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String path;
                final String key = keys.nextElement();
                JmolPlugin p = this.plugins.get(key);
                if (p != null || (path = bundle.getString(key)) == null | path.length() == 0 || path.indexOf("disabled") >= 0) continue;
                try {
                    p = this.getAndRegisterPlugin(key, path);
                    if (p == null) continue;
                    String text = p.getMenuText();
                    ImageIcon icon = p.getMenuIcon();
                    if (text == null) {
                        text = key;
                    }
                    JMenuItem item = new JMenuItem(text);
                    if (icon != null) {
                        item.setHorizontalTextPosition(4);
                        item.setIcon(icon);
                    }
                    this.pluginMenu.add(item);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            JmolPanel.this.showPlugin(key, null, null);
                        }
                    });
                }
                catch (Exception e) {
                    System.out.println("Cannot create plugin " + key + " " + path);
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
        this.pluginMenu.setEnabled(this.pluginMenu.getPopupMenu().getComponentCount() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMacrosMenu(JMenuBar menuBar) {
        JMenu macroMenu = this.guimap.newJMenu("macros");
        File macroDir = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jmol" + System.getProperty("file.separator") + "macros");
        this.report("User macros dir: " + macroDir);
        this.report("       exists: " + macroDir.exists());
        this.report("  isDirectory: " + macroDir.isDirectory());
        if (macroDir.exists() && macroDir.isDirectory()) {
            File[] macros = macroDir.listFiles();
            for (int i = 0; i < macros.length; ++i) {
                String macroName = macros[i].getName();
                if (!macroName.endsWith(".macro")) continue;
                if (Logger.debugging) {
                    Logger.debug("Possible macro found: " + macroName);
                }
                FileInputStream macro = null;
                try {
                    macro = new FileInputStream(macros[i]);
                    Properties macroProps = new Properties();
                    macroProps.load(macro);
                    String macroTitle = macroProps.getProperty("Title");
                    String macroScript = macroProps.getProperty("Script");
                    JMenuItem mi = new JMenuItem(macroTitle);
                    mi.setActionCommand(macroScript);
                    mi.addActionListener(this.executeScriptAction);
                    macroMenu.add(mi);
                    continue;
                }
                catch (IOException exception) {
                    System.err.println("Could not load macro file: ");
                    System.err.println(exception);
                    continue;
                }
                finally {
                    if (macro != null) {
                        try {
                            macro.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        menuBar.add(macroMenu);
    }

    protected void addNormalMenuBar(JMenuBar menuBar) {
        String[] menuKeys = PT.getTokens(this.setMenuKeys("menubar", JmolResourceHandler.getStringX("menubar")));
        for (int i = 0; i < menuKeys.length; ++i) {
            if (menuKeys[i].equals("-")) {
                menuBar.add(Box.createHorizontalGlue());
                continue;
            }
            JMenu m = this.createMenu(menuKeys[i]);
            if (m == null) continue;
            menuBar.add(m);
        }
    }

    protected void addHelpMenuBar(JMenuBar menuBar) {
        JMenu m = this.createMenu("help");
        if (m != null) {
            menuBar.add(m);
        }
    }

    public JMenu createMenu(String key) {
        String[] itemKeys = PT.getTokens(this.setMenuKeys(key, JmolResourceHandler.getStringX(key)));
        JMenu menu = this.guimap.newJMenu(key);
        ImageIcon f = JmolResourceHandler.getIconX(key + "Image");
        if (f != null) {
            menu.setHorizontalTextPosition(4);
            menu.setIcon(f);
        }
        for (int i = 0; i < itemKeys.length; ++i) {
            String item = itemKeys[i];
            if (item.equals("-")) {
                menu.addSeparator();
                continue;
            }
            if (item.endsWith("Menu")) {
                menu.add(this.createMenu(item));
                continue;
            }
            JMenuItem mi = this.createMenuItem(item);
            menu.add(mi);
        }
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                String menuKey = ((JmolAbstractButton)e.getSource()).getKey();
                if (menuKey.equals("display") || menuKey.equals("tools")) {
                    JmolPanel.this.setMenuState();
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        return menu;
    }

    protected String setMenuKeys(String key, String tokens) {
        return tokens;
    }

    protected void setMenuState() {
        this.guimap.setSelected("perspectiveCheck", this.vwr.tm.perspectiveDepth);
        this.guimap.setSelected("hydrogensCheck", this.vwr.getBoolean(603979922));
        this.guimap.setSelected("measurementsCheck", this.vwr.getBoolean(603979926));
        this.guimap.setSelected("axesCheck", this.vwr.getShowAxes());
        this.guimap.setSelected("boundboxCheck", this.vwr.getShowBbcage());
        this.guimap.setEnabled("openJSpecViewScript", !this.vwr.getBoolean(1073742086));
        this.guimap.setEnabled("simulate1HSpectrumScript", !this.vwr.getBoolean(1073742086));
        this.guimap.setEnabled("simulate13CSpectrumScript", !this.vwr.getBoolean(1073742086));
    }

    void doNew() {
        JFrame newFrame = new JFrame();
        new Jmol(this.jmolApp, null, newFrame, (Jmol)this, this.startupWidth, this.startupHeight, this.vwrOptions, null);
        newFrame.setVisible(true);
    }

    void setMenuNBO(JMenu item) {
    }

    void startNBO(Map<String, Object> jmolOptions) {
        this.showPlugin("NBO", "org.gennbo.NBOPlugin", jmolOptions);
    }

    void showPlugin(String name, String path, Map<String, Object> jmolOptions) {
        try {
            JmolPlugin p = this.getAndRegisterPlugin(name, path);
            if (!p.isStarted()) {
                p.start(this.frame, this.vwr, jmolOptions);
            }
            p.setVisible(true);
        }
        catch (Throwable e) {
            System.out.println("Error creating plugin " + name);
            e.printStackTrace();
        }
    }

    protected JmolPlugin getAndRegisterPlugin(String name, String path) {
        JmolPlugin p = this.plugins.get(name);
        if (p == null) {
            p = (JmolPlugin)Interface.getInterface(path, this.vwr, "plugin");
            this.plugins.put(name, p);
        }
        return p;
    }

    public static Object getInstanceWithParams(String name, Class<?>[] classes, Object ... params) {
        try {
            Class<?> cl = Class.forName(name);
            return cl.getConstructor(classes).newInstance(params);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void print() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this.display);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException e) {
                Logger.errorEx("Error while printing", e);
            }
        }
    }

    String createImageStatus(String fileName, String type, Object text_or_bytes, int quality) {
        if (fileName != null && text_or_bytes != null) {
            return null;
        }
        String msg = fileName;
        if (msg != null && !msg.startsWith("OK") && this.status != null) {
            this.setStatus(1, GT.$("IO Exception:"));
            this.setStatus(2, msg);
        }
        return msg;
    }

    void createWebExport() {
        this.webExport = WebExport.createAndShowGUI(this.vwr, historyFile, WEB_MAKER_WINDOW_NAME);
    }

    void createSurfaceTool() {
        if (this.surfaceTool != null) {
            this.surfaceTool.toFront();
        } else {
            this.surfaceTool = new SurfaceTool(this.vwr, historyFile, SURFACETOOL_WINDOW_NAME, true);
        }
    }

    public static File getUserDirectory() {
        String dir = System.getProperty("user.dir");
        return dir == null ? null : new File(System.getProperty("user.dir"));
    }

    void openFile() {
        int flags0 = 9;
        String fileName = new Dialog().getOpenFileNameFromDialog(this.vwrOptions, this.vwr, null, this.jmolApp, FILE_OPEN_WINDOW_NAME, true);
        if (fileName == null) {
            return;
        }
        int flags = flags0;
        if (fileName.startsWith("#NOCARTOONS#;")) {
            flags &= 0xFFFFFFFE;
            fileName = fileName.substring(13);
        }
        if (fileName.startsWith("#APPEND#;")) {
            fileName = fileName.substring(9);
            flags |= 4;
        }
        this.vwr.openFileAsyncSpecial(fileName, flags);
    }

    void notifyFileOpen(String fullPathName, String title) {
        if (fullPathName == null || !fullPathName.equals("String[]")) {
            int pt;
            int n = pt = fullPathName == null ? -1 : fullPathName.lastIndexOf("|");
            if (pt > 0) {
                fullPathName = fullPathName.substring(0, pt);
            }
            if (this.recentFiles != null) {
                this.recentFiles.notifyFileOpen(fullPathName);
            }
            this.frame.setTitle(title);
        }
        if (this.atomSetChooser == null && addAtomChooser) {
            this.atomSetChooser = new AtomSetChooser(this.vwr, this.frame);
            this.pcs.addPropertyChangeListener(chemFileProperty, this.atomSetChooser);
        }
        this.pcs.firePropertyChange(chemFileProperty, null, null);
    }

    int[] resizeInnerPanel(String data) {
        int width = this.vwr.getScreenWidth();
        int height = this.vwr.getScreenHeight();
        String info = width + " " + height;
        if (data == null) {
            data = info;
        } else {
            int pt = data.indexOf("preferredWidthHeight ");
            int pt2 = data.indexOf(";", pt + 1);
            if (pt >= 0 && pt2 > pt) {
                data = data.substring(pt + 21, pt2).trim();
            }
            if (data.equals(info)) {
                return new int[]{width, height};
            }
        }
        info = JOptionPane.showInputDialog(GT.$("width height?"), (Object)data);
        if (info == null) {
            return new int[]{width, height};
        }
        float[] dims = new float[2];
        int n = Parser.parseStringInfestedFloatArray(info.replace(',', ' '), null, dims);
        if (n < 2) {
            return new int[]{width, height};
        }
        this.resizeDisplay((int)dims[0], (int)dims[1]);
        return new int[]{(int)dims[0], (int)dims[1]};
    }

    void resizeDisplay(int width, int height) {
        Dimension d = new Dimension(width, height);
        this.display.setJmolSize(d);
        d = new Dimension(width, 30);
        if (this.status != null) {
            this.status.setPreferredSize(d);
        }
        if (this.toolbar != null) {
            this.toolbar.setPreferredSize(d);
        }
        this.menubar.setPreferredSize(new Dimension(width, this.menubar.getHeight()));
        Platform.getWindow(this).pack();
        System.out.println("resizeDisplay " + this.display.getSize());
    }

    void updateLabels() {
        if (this.atomSetChooser != null) {
            this.atomSetChooser.dispose();
            this.atomSetChooser = null;
        }
        if (this.gaussianDialog != null) {
            this.gaussianDialog.dispose();
            this.gaussianDialog = null;
        }
        boolean doTranslate = GT.setDoTranslate(true);
        this.getDialogs();
        this.getMeasurementTable();
        GT.setDoTranslate(doTranslate);
        this.guimap.updateLabels();
    }

    @Override
    public void nioClosed(JsonNioServer jns) {
        if (bannerFrame != null) {
            this.vwr.scriptWait("delay 2");
            bannerFrame.dispose();
            this.vwr.dispose();
            System.exit(0);
        }
        if (jns.equals(this.clientService)) {
            this.clientService = null;
        } else if (jns.equals(this.serverService)) {
            this.serverService = null;
        }
    }

    void sendNioSyncRequest(Object data, int port, String strInfo) {
        if (this.serverService == null && port == 2) {
            return;
        }
        try {
            if (port < 0) {
                if (this.serverService != null && "STOP".equalsIgnoreCase(strInfo)) {
                    this.serverService.close();
                } else if (this.serverService == null) {
                    this.serverService = JmolPanel.getJsonNioServer();
                    if (this.serverService != null) {
                        this.serverService.startService(port, this, this.vwr, "-JmolNioServer", 1);
                    }
                }
                if (this.serverService != null && this.serverService.getPort() == -port && strInfo != null) {
                    if (this.clientService == null) {
                        this.clientService = JmolPanel.getJsonNioServer();
                        if (this.clientService != null) {
                            this.clientService.startService(-port, this, this.vwr, "-JmolNioClient(self)", 1);
                        }
                    }
                    if (this.clientService != null) {
                        this.clientService.sendToJmol(-port, strInfo);
                    }
                }
                return;
            }
            if ("STOP".equalsIgnoreCase(strInfo)) {
                strInfo = "{\"type\":\"quit\"}";
            }
            if (this.clientService == null && this.serverService != null) {
                if (data != null) {
                    this.serverService.reply(port, data);
                } else if (port == 2) {
                    this.serverService.reply(port, strInfo);
                } else if (this.serverService.getPort() == port) {
                    this.serverService.sendToJmol(port, strInfo);
                }
                return;
            }
            if (this.clientService == null) {
                this.clientService = JmolPanel.getJsonNioServer();
                if (this.clientService != null) {
                    this.clientService.startService(port, this, this.vwr, "-JmolNioClient", 1);
                }
            }
            if (this.clientService != null) {
                if (data == null) {
                    this.clientService.sendToJmol(port, strInfo);
                } else {
                    this.clientService.reply(port, data);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static JsonNioServer getJsonNioServer() {
        return (JsonNioServer)Interface.getInterface("org.openscience.jmol.app.jsonkiosk.JsonNioService", null, null);
    }

    public void updateConsoleFont() {
        AppConsole console = this.getConsole();
        if (console != null) {
            console.updateFontSize();
        }
    }

    public Object getPreference(String key) {
        return this.preferencesDialog == null ? null : this.preferencesDialog.currentProperties.get(key);
    }

    public AppConsole getConsole() {
        return (AppConsole)this.vwr.getProperty("DATA_API", "getAppConsole", null);
    }

    public static String getJmolProperty(String key, String defaultValue) {
        return historyFile == null ? defaultValue : historyFile.getProperty(key, defaultValue);
    }

    public static void setPluginOption(String pluginName, String key, String value) {
        if (pluginFile == null) {
            return;
        }
        pluginFile.addProperty(pluginName + "_" + key, value);
        pluginFile.save();
    }

    public static String getPluginOption(String pluginName, String key, String defaultValue) {
        return pluginFile == null ? defaultValue : pluginFile.getProperty(pluginName + "_" + key, defaultValue);
    }

    public static void addJmolProperties(Properties props) {
        if (historyFile != null) {
            historyFile.addProperties(props);
        }
    }

    public static void addJmolProperty(String key, String value) {
        if (historyFile != null) {
            historyFile.addProperty(key, value);
        }
    }

    public void setStatus(int pos, String msg) {
        if (this.status != null) {
            this.status.setStatus(pos, msg);
        }
    }

    @Deprecated
    public static void addJmolWindowInfo(String name, Component window, Point border) {
        if (historyFile != null) {
            historyFile.addWindowInfo(name, window, border, null);
        }
    }

    public static void addJmolWindowInnerInfo(String name, Component window, Dimension inner) {
        if (historyFile != null) {
            historyFile.addWindowInnerInfo(name, window, inner);
        }
    }

    @Override
    public synchronized void processNioMessage(byte[] packet) throws Exception {
        String msg = new String(packet);
        if (Logger.debugging) {
            Logger.debug(msg);
        }
        Map<String, Object> json = new JSJSONParser().parseMap(msg, false);
        switch ("reply.....quit......command...move......rotate....translate.zoom......sync......touch.....".indexOf("" + json.get("type"))) {
            case 0: {
                break;
            }
            case 10: {
                this.vwr.evalString("exitjmol");
                break;
            }
            case 20: {
                this.vwr.evalString((String)json.get("command"));
                break;
            }
            case 30: {
                switch ("reply.....quit......command...move......rotate....translate.zoom......sync......touch.....".indexOf(JsonNioService.getString(json, "style"))) {
                    case 40: {
                        break;
                    }
                }
            }
            case 70: 
            case 80: {
                if (this.touchHandler == null) {
                    this.touchHandler = new JsonNioClient.TouchHandler();
                }
                this.touchHandler.nioSync(this.vwr, json);
            }
        }
    }

    @Override
    public void serverCycle() {
        if (this.touchHandler == null) {
            return;
        }
        this.touchHandler.checkPaused(this.vwr);
    }

    public boolean isServer() {
        return this.serverService != null;
    }

    static {
        addPreferencesDialog = !Viewer.isSwingJS;
        addMacrosMenu = !Viewer.isSwingJS;
        allowRecentFiles = !Viewer.isSwingJS;
        addAtomChooser = !Viewer.isSwingJS;
        allowPreferences = !Viewer.isSwingJS;
        allowGaussian = !Viewer.isSwingJS;
        numWindows = 0;
        allowJavaConsole = true;
        screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        imageChoices = new String[]{"JPEG", "PNG", "GIF", "PPM", "PDF"};
        imageExtensions = new String[]{"jpg", "png", "gif", "ppm", "pdf"};
    }

    public class AnimButton
    extends JmolButton
    implements MouseListener {
        protected String script;
        protected long lastPressTime;

        public AnimButton(ImageIcon ii, String script) {
            super(ii);
            this.script = script;
            this.addMouseListener(this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JmolPanel.this.vwr.evalStringQuiet(this.script);
            long t = System.currentTimeMillis();
            if ((float)(t - this.lastPressTime) > JmolPanel.this.jmolApp.autoAnimationDelay * 2000.0f && JmolPanel.this.jmolApp.autoAnimationDelay > 0.0f) {
                JmolPanel.this.vwr.evalStringQuiet("timeout '__animBtn' OFF;animation_running = true; delay " + JmolPanel.this.jmolApp.autoAnimationDelay + "; if(animation_running){timeout '__animBtn' -200 \"" + this.script + "\"}");
            }
            this.lastPressTime = t;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (JmolPanel.this.jmolApp.autoAnimationDelay > 0.0f) {
                JmolPanel.this.vwr.evalStringQuiet("animation_running = false; timeout '__animBtn' OFF");
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    public class ResizeAction
    extends AbstractAction {
        public ResizeAction() {
            super(JmolPanel.resizeAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.resizeInnerPanel(null);
        }
    }

    public class ExecuteScriptAction
    extends AbstractAction {
        public ExecuteScriptAction() {
            super("executeScriptAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String script = e.getActionCommand();
            if (script.indexOf("#showMeasurementTable") >= 0) {
                JmolPanel.this.measurementTable.activate();
            }
            JmolPanel.this.vwr.evalStringQuiet(script);
        }
    }

    public class SurfaceToolAction
    extends AbstractAction {
        public SurfaceToolAction() {
            super(JmolPanel.surfaceToolActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JmolPanel.this.createSurfaceTool();
                }
            });
        }
    }

    public class ViewMeasurementTableAction
    extends AbstractAction {
        public ViewMeasurementTableAction() {
            super("viewMeasurementTable");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.measurementTable.activate();
        }
    }

    public class ToWebAction
    extends AbstractAction {
        public ToWebAction() {
            super(JmolPanel.toWebActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JmolPanel.this.createWebExport();
                }
            });
        }
    }

    public class WriteAction
    extends AbstractAction {
        public WriteAction() {
            super(JmolPanel.writeActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String fileName = new Dialog().getSaveFileNameFromDialog(JmolPanel.this.vwr, null, "SPT");
            if (fileName != null) {
                Hashtable<String, Object> params = new Hashtable<String, Object>();
                params.put("fileName", fileName);
                params.put("type", "SPT");
                params.put("text", JmolPanel.this.vwr.getStateInfo());
                String msg = JmolPanel.this.vwr.outputToFile(params);
                Logger.info(msg);
            }
        }
    }

    public class PovrayAction
    extends AbstractAction {
        public PovrayAction() {
            super(JmolPanel.povrayActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new PovrayDialog(JmolPanel.this.frame, JmolPanel.this.vwr);
        }
    }

    public class AtomSetChooserAction
    extends AbstractAction {
        public AtomSetChooserAction() {
            super(JmolPanel.atomsetchooserAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.atomSetChooser.setVisible(true);
        }
    }

    public class ScriptEditorAction
    extends AbstractAction {
        public ScriptEditorAction() {
            super(JmolPanel.editorAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component c = (Component)JmolPanel.this.vwr.getProperty("DATA_API", "getScriptEditor", null);
            if (c != null) {
                c.setVisible(true);
            }
        }
    }

    public class ScriptWindowAction
    extends AbstractAction {
        public ScriptWindowAction() {
            super(JmolPanel.consoleAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AppConsole console = JmolPanel.this.getConsole();
            if (console != null) {
                console.setVisible(true);
            }
        }
    }

    public class RecentFilesAction
    extends AbstractAction {
        public RecentFilesAction() {
            super(JmolPanel.recentFilesAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.recentFiles.setVisible(true);
            String selection = JmolPanel.this.recentFiles.getFile();
            if (selection == null || selection.length() == 0) {
                return;
            }
            if (selection.endsWith(" (*)")) {
                JmolPanel.this.vwr.openFileAsyncSpecial(selection.substring(0, selection.length() - 4), 9);
            } else {
                JmolPanel.this.vwr.openFileAsyncSpecial(selection, 8);
            }
        }
    }

    public class ExportAction
    extends AbstractAction {
        public ExportAction() {
            super(JmolPanel.exportActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Dialog sd = new Dialog();
            String fileName = sd.getImageFileNameFromDialog(JmolPanel.this.vwr, null, JmolPanel.this.imageType, imageChoices, imageExtensions, JmolPanel.this.qualityJPG, JmolPanel.this.qualityPNG);
            if (fileName == null) {
                return;
            }
            JmolPanel.this.qualityJPG = sd.getQuality("JPG");
            JmolPanel.this.qualityPNG = sd.getQuality("PNG");
            JmolPanel.this.imageType = sd.getType();
            String sType = JmolPanel.this.imageType;
            if (sType == null) {
                sType = fileName;
                int i = sType.lastIndexOf(".");
                if (i < 0) {
                    return;
                }
                sType = sType.substring(i + 1).toUpperCase();
            }
            if (fileName.indexOf(".") < 0) {
                fileName = fileName + "." + (sType.equalsIgnoreCase("JPEG") ? "jpg" : sType.toLowerCase());
            }
            Hashtable<String, Object> params = new Hashtable<String, Object>();
            params.put("fileName", fileName);
            params.put("type", sType);
            params.put("quality", sd.getQuality(sType));
            String msg = JmolPanel.this.vwr.outputToFile(params);
            Logger.info(msg);
        }
    }

    public class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super(JmolPanel.exitAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.saveWindowSizes();
            System.exit(0);
        }
    }

    public class NewAction
    extends AbstractAction {
        protected String script;

        public NewAction() {
            super(JmolPanel.newAction);
        }

        public NewAction(String nm) {
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.script == null) {
                JmolPanel.this.revalidate();
            } else {
                JmolPanel.this.vwr.script(this.script);
            }
        }
    }

    public class OpenMolAction
    extends NewAction {
        public OpenMolAction() {
            super(JmolPanel.openmolAction);
            this.script = "var x__id__ = _smilesString; if (!x__id__) { x__id__ = 'tylenol'};x__id__ = prompt('" + GT.$("Enter the name or identifier (SMILES, InChI, CAS) of a compound. Preface with \":\" to load from PubChem; otherwise Jmol will use the NCI/NIH Resolver.") + "',x__id__);if (!x__id__) { quit }; load @{(x__id__[1]==':' ? x__id__ : '$' + x__id__)}";
        }
    }

    public class OpenPdbAction
    extends NewAction {
        public OpenPdbAction() {
            super(JmolPanel.openpdbAction);
            this.script = "var x__id__ = _modelTitle; if (x__id__.length != 4) { x__id__ = '1crn'};x__id__ = prompt('" + GT.$("Enter a four-digit PDB model ID or \"=\" and a three-digit ligand ID") + "',x__id__);if (!x__id__) { quit }; load @{'=' + x__id__}";
        }
    }

    public class OpenUrlAction
    extends NewAction {
        String title;
        String prompt;

        public OpenUrlAction() {
            super(JmolPanel.openurlAction);
            this.title = GT.$("Open URL");
            this.prompt = GT.$("Enter URL of molecular model");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String url = JOptionPane.showInputDialog(JmolPanel.this.frame, this.prompt, this.title, -1);
            if (url != null) {
                if (url.indexOf("://") < 0) {
                    if (url.length() == 4 && url.indexOf(".") < 0) {
                        url = "=" + url;
                    }
                    if (!url.startsWith("=")) {
                        url = "http://" + url;
                    }
                }
                JmolPanel.this.vwr.openFileAsync(url);
            }
        }
    }

    public class OpenAction
    extends NewAction {
        public OpenAction() {
            super(JmolPanel.openAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.openFile();
        }
    }

    public class PrintAction
    extends AbstractAction {
        public PrintAction() {
            super(JmolPanel.printActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.print();
        }
    }

    public class CopyScriptAction
    extends AbstractAction {
        public CopyScriptAction() {
            super(JmolPanel.copyScriptActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.vwr.clipImageOrPasteText((String)JmolPanel.this.vwr.getProperty("string", "stateInfo", null));
        }
    }

    public class CopyImageAction
    extends AbstractAction {
        public CopyImageAction() {
            super(JmolPanel.copyImageActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.vwr.clipImageOrPasteText(null);
        }
    }

    public class PasteClipboardAction
    extends AbstractAction {
        public PasteClipboardAction() {
            super(JmolPanel.pasteClipboardActionProperty);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.vwr.loadInlineAppend(JmolPanel.this.vwr.getClipboardText(), false);
        }
    }

    public class UguideAction
    extends AbstractAction {
        public UguideAction() {
            super(JmolPanel.uguideAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.vwr.showUrl(JmolResourceHandler.getStringX("UGuide.wikiURL"));
        }
    }

    public class NewwinAction
    extends AbstractAction {
        public NewwinAction() {
            super(JmolPanel.newwinAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JmolPanel.this.doNew();
        }
    }

    public class GaussianAction
    extends AbstractAction {
        public GaussianAction() {
            super(JmolPanel.gaussianAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JmolPanel.this.gaussianDialog == null) {
                JmolPanel.this.gaussianDialog = new GaussianDialog(JmolPanel.this.frame, JmolPanel.this.vwr);
            }
            JmolPanel.this.gaussianDialog.setVisible(true);
        }
    }

    public class CreditsAction
    extends AbstractAction {
        public CreditsAction() {
            super(JmolPanel.creditsAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new CreditsDialog(JmolPanel.this.frame).setVisible(true);
        }
    }

    public class WhatsNewAction
    extends AbstractAction {
        public WhatsNewAction() {
            super(JmolPanel.whatsnewAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WhatsNewDialog wnd = new WhatsNewDialog(JmolPanel.this.frame);
            wnd.setVisible(true);
        }
    }

    public class AboutAction
    extends AbstractAction {
        public AboutAction() {
            super(JmolPanel.aboutAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AboutDialog ad = new AboutDialog(JmolPanel.this.frame, JmolPanel.this.vwr);
                ad.setVisible(true);
            }
            catch (Exception ee) {
                Logger.error(ee.getMessage());
            }
        }
    }

    public class ConsoleAction
    extends AbstractAction {
        public ConsoleAction() {
            super("jconsole");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JmolPanel.this.consoleframe != null) {
                JmolPanel.this.consoleframe.setVisible(true);
            }
        }
    }

    public class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(JmolPanel.closeAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!JmolPanel.this.doClose(true)) {
                JmolPanel.this.vwr.script("zap");
            }
        }
    }

    protected static class ActionChangedListener
    implements PropertyChangeListener {
        AbstractButton button;

        public ActionChangedListener(AbstractButton button) {
            this.button = button;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                if (this.button.getText() != null) {
                    this.button.setText(text);
                }
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.button.setEnabled(enabledState);
            }
        }
    }

    protected class AppCloser
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent e) {
            JmolPanel.this.doClose(false);
        }
    }
}

