/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionItem;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionPriority;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.mappaint.mapcss.CSSColors;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompComboBoxEditor;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompComboBoxModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompTextField;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItemGuiSupport;
import org.openstreetmap.josm.gui.tagging.presets.items.ComboMultiSelect;
import org.openstreetmap.josm.gui.tagging.presets.items.PresetListEntry;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmComboBoxModel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.OrientationAction;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class Combo
extends ComboMultiSelect {
    public boolean editable = true;
    public int length;
    protected JosmComboBox<PresetListEntry> combobox;
    protected AutoCompComboBoxModel<PresetListEntry> dropDownModel;
    protected AutoCompComboBoxModel<AutoCompletionItem> autoCompModel;

    public Combo() {
        this.delimiter = (char)44;
    }

    private void addEntry(PresetListEntry entry) {
        if (!this.seenValues.containsKey(entry.value)) {
            this.dropDownModel.addElement(entry);
            this.seenValues.put(entry.value, entry);
        }
    }

    @Override
    protected boolean addToPanel(JPanel p, TaggingPresetItemGuiSupport support) {
        this.initializeLocaleText(null);
        this.usage = Combo.determineTextUsage(support.getSelected(), this.key);
        this.seenValues.clear();
        this.initListEntries();
        this.dropDownModel = new AutoCompComboBoxModel(Comparator.naturalOrder());
        if (!this.usage.hasUniqueValue() && !this.usage.unused()) {
            this.addEntry(PresetListEntry.ENTRY_DIFFERENT);
        }
        this.presetListEntries.forEach(this::addEntry);
        if (this.default_ != null) {
            this.addEntry(new PresetListEntry(this.default_, this));
        }
        this.addEntry(PresetListEntry.ENTRY_EMPTY);
        this.usage.map.forEach((value, count) -> this.addEntry(new PresetListEntry((String)value, this)));
        this.combobox = new JosmComboBox<PresetListEntry>((JosmComboBoxModel<PresetListEntry>)this.dropDownModel);
        AutoCompComboBoxEditor editor = new AutoCompComboBoxEditor();
        this.combobox.setEditor(editor);
        this.combobox.setPreferredHeight(this.combobox.getPreferredSize().height);
        this.combobox.setRenderer(new ComboMultiSelect.ComboMultiSelectListCellRenderer(this.combobox, this.combobox.getRenderer(), 200, this.key));
        this.combobox.setEditable(this.editable);
        this.autoCompModel = new AutoCompComboBoxModel(Comparator.naturalOrder());
        this.getAllForKeys(Arrays.asList(this.key)).forEach(this.autoCompModel::addElement);
        this.getDisplayValues().forEach(s -> this.autoCompModel.addElement(new AutoCompletionItem((String)s, AutoCompletionPriority.IS_IN_STANDARD)));
        JosmTextField tf = editor.getEditorComponent();
        ((AutoCompTextField)tf).setModel(this.autoCompModel);
        if (TaggingPresetItem.DISPLAY_KEYS_AS_HINT.get().booleanValue()) {
            this.combobox.setHint(this.key);
        }
        if (this.length > 0) {
            ((AutoCompTextField)tf).setMaxTextLength(this.length);
        }
        JLabel label = this.addLabel(p);
        if (this.key != null && ("colour".equals(this.key) || this.key.startsWith("colour:") || this.key.endsWith(":colour"))) {
            p.add(this.combobox, GBC.std().fill(2));
            JButton button = new JButton(new ChooseColorAction());
            button.setOpaque(true);
            button.setBorderPainted(false);
            button.setCursor(Cursor.getPredefinedCursor(12));
            p.add((Component)button, GBC.eol().fill(3));
            ActionListener updateColor = ignore -> button.setBackground(this.getColor());
            updateColor.actionPerformed(null);
            this.combobox.addActionListener(updateColor);
        } else {
            p.add(this.combobox, GBC.eol().fill(2));
        }
        String initialValue = this.getInitialValue(this.usage, support);
        PresetListEntry selItem = this.find(initialValue);
        if (selItem != null) {
            this.combobox.setSelectedItem(selItem);
        } else {
            this.combobox.setText(initialValue);
        }
        this.combobox.addActionListener(l -> support.fireItemValueModified(this, this.key, this.getSelectedItem().value));
        this.combobox.addComponentListener(new ComponentListener());
        label.setLabelFor(this.combobox);
        this.combobox.setToolTipText(this.getKeyTooltipText());
        this.combobox.applyComponentOrientation(OrientationAction.getValueOrientation(this.key));
        return true;
    }

    private PresetListEntry find(String value) {
        return this.dropDownModel.asCollection().stream().filter(o -> o.value.equals(value)).findAny().orElse(null);
    }

    protected void setColor(Color color) {
        if (color != null) {
            this.combobox.setSelectedItem(ColorHelper.color2html(color));
        }
    }

    protected Color getColor() {
        String colorString = this.getSelectedItem().value;
        return colorString.startsWith("#") ? ColorHelper.html2color(colorString) : CSSColors.get(colorString);
    }

    @Override
    protected PresetListEntry getSelectedItem() {
        Object sel = this.combobox.getSelectedItem();
        if (sel instanceof PresetListEntry) {
            return (PresetListEntry)sel;
        }
        if (sel instanceof String) {
            PresetListEntry selItem = (PresetListEntry)this.dropDownModel.find((String)sel);
            if (selItem != null) {
                return selItem;
            }
            return new PresetListEntry((String)sel, this);
        }
        return PresetListEntry.ENTRY_EMPTY;
    }

    class ChooseColorAction
    extends AbstractAction {
        ChooseColorAction() {
            this.putValue("ShortDescription", I18n.tr("Choose a color", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color color = Combo.this.getColor();
            color = JColorChooser.showDialog(MainApplication.getMainPanel(), I18n.tr("Choose a color", new Object[0]), color);
            Combo.this.setColor(color);
        }
    }

    class ComponentListener
    extends ComponentAdapter {
        ComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            JComponent component = (JComponent)e.getSource();
            int width = component.getWidth();
            if (width == 0) {
                width = 200;
            }
            Insets insets = component.getInsets();
            ComboMultiSelect.ComboMultiSelectListCellRenderer renderer = (ComboMultiSelect.ComboMultiSelectListCellRenderer)Combo.this.combobox.getRenderer();
            renderer.setWidth(width -= insets.left + insets.right + 10);
            Combo.this.combobox.setRenderer(null);
            Combo.this.combobox.setRenderer(renderer);
        }
    }
}

