/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.gtile.GAbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.gtile.GPoint;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GConnectionVerticalDownThenBack
extends GAbstractConnection {
    private final TextBlock textBlock;
    private final UTranslate pos1;
    private final UTranslate pos2;
    private final double xpos;

    public GConnectionVerticalDownThenBack(UTranslate pos1, GPoint gpoint1, UTranslate pos2, GPoint gpoint2, TextBlock textBlock, double xpos) {
        super(gpoint1, gpoint2);
        this.textBlock = textBlock;
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.xpos = xpos;
    }

    @Override
    public void drawU(UGraphic ug) {
        XPoint2D p1 = this.pos1.getTranslated(this.gpoint1.getPoint2D());
        XPoint2D p2 = this.pos2.getTranslated(this.gpoint2.getPoint2D());
        UPolygon arrow = this.skinParam().arrows().asToLeft();
        Snake snake = Snake.create(this.skinParam(), this.getInLinkRenderingColor(), arrow).withLabel(this.textBlock, HorizontalAlignment.LEFT).emphasizeDirection(Direction.UP);
        snake.addPoint(p1);
        XPoint2D p1bis = UTranslate.dy(10.0).getTranslated(p1);
        snake.addPoint(p1bis);
        double border = this.xpos;
        snake.addPoint(new XPoint2D(border, p1bis.getY()));
        snake.addPoint(new XPoint2D(border, p2.getY()));
        snake.addPoint(p2);
        ug.draw(snake);
    }

    @Override
    public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
        XPoint2D p1 = this.pos1.getTranslated(this.gpoint1.getPoint2D());
        XPoint2D p2 = this.pos2.getTranslated(this.gpoint2.getPoint2D());
        p1 = translate1.getTranslated(p1);
        p2 = translate2.getTranslated(p2);
        UPolygon arrow = this.skinParam().arrows().asToLeft();
        Snake snake = Snake.create(this.skinParam(), this.getInLinkRenderingColor(), arrow).withLabel(this.textBlock, HorizontalAlignment.LEFT).emphasizeDirection(Direction.UP);
        snake.addPoint(p1);
        XPoint2D p1bis = UTranslate.dy(10.0).getTranslated(p1);
        snake.addPoint(p1bis);
        snake.addPoint(new XPoint2D(p2.getX() + 20.0, p1bis.getY()));
        snake.addPoint(new XPoint2D(p2.getX() + 20.0, p2.getY()));
        snake.addPoint(p2);
        ug.draw(snake);
    }
}

