/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project.TimeHeaderParameters;
import net.sourceforge.plantuml.project.draw.TimeHeaderCalendar;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.MonthYear;
import net.sourceforge.plantuml.project.timescale.TimeScaleCompressed;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TimeHeaderQuarterly
extends TimeHeaderCalendar {
    @Override
    public double getTimeHeaderHeight() {
        return 29.0;
    }

    @Override
    public double getTimeFooterHeight() {
        return 28.0;
    }

    public TimeHeaderQuarterly(TimeHeaderParameters thParam) {
        super(thParam, new TimeScaleCompressed(thParam.getStartingDay(), thParam.getScale()));
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        this.drawTextsBackground(ug, totalHeightWithoutFooter);
        this.drawYears(ug);
        this.drawQuarters(ug.apply(UTranslate.dy(16.0)));
        this.drawHline(ug, 0.0);
        this.drawHline(ug, 16.0);
        this.drawHline(ug, this.getFullHeaderHeight());
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        ug = ug.apply(UTranslate.dy(3.0));
        this.drawQuarters(ug);
        this.drawYears(ug.apply(UTranslate.dy(13.0)));
        this.drawHline(ug, 0.0);
        this.drawHline(ug, 13.0);
        this.drawHline(ug, this.getTimeFooterHeight());
    }

    private void drawYears(UGraphic ug) {
        MonthYear last = null;
        double lastChange = -1.0;
        Day wink = this.min;
        while (wink.compareTo(this.max) < 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            if (last == null || wink.monthYear().year() != last.year()) {
                this.drawVbar(ug, x1, 0.0, 15.0, false);
                if (last != null) {
                    this.printYear(ug, last, lastChange, x1);
                }
                lastChange = x1;
                last = wink.monthYear();
            }
            wink = wink.increment();
        }
        double x1 = this.getTimeScale().getStartingPosition(this.max.increment());
        if (x1 > lastChange) {
            this.printYear(ug, last, lastChange, x1);
        }
        this.drawVbar(ug, this.getTimeScale().getEndingPosition(this.max), 0.0, 15.0, false);
    }

    private void drawQuarters(UGraphic ug) {
        String last = null;
        double lastChange = -1.0;
        Day wink = this.min;
        while (wink.compareTo(this.max) < 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            if (!this.quarter(wink).equals(last)) {
                this.drawVbar(ug, x1, 0.0, 12.0, false);
                if (last != null) {
                    this.printQuarter(ug, last, lastChange, x1);
                }
                lastChange = x1;
                last = this.quarter(wink);
            }
            wink = wink.increment();
        }
        double x1 = this.getTimeScale().getStartingPosition(this.max.increment());
        if (x1 > lastChange) {
            this.printQuarter(ug, last, lastChange, x1);
        }
        this.drawVbar(ug, this.getTimeScale().getEndingPosition(this.max), 0.0, 12.0, false);
    }

    private String quarter(Day day) {
        return "Q" + (day.month().ordinal() + 3) / 3;
    }

    private void printYear(UGraphic ug, MonthYear monthYear, double start, double end) {
        TextBlock small = this.getTextBlock("" + monthYear.year(), 12, true, this.openFontColor());
        this.printCentered(ug, false, start, end, small);
    }

    private void printQuarter(UGraphic ug, String quarter, double start, double end) {
        TextBlock small = this.getTextBlock(quarter, 10, false, this.openFontColor());
        this.printCentered(ug, false, start, end, small);
    }

    private void printLeft(UGraphic ug, TextBlock text, double start) {
        text.drawU(ug.apply(UTranslate.dx(start)));
    }

    @Override
    public double getFullHeaderHeight() {
        return this.getTimeHeaderHeight();
    }
}

