/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.AbstractExtremityFactory;
import net.sourceforge.plantuml.svek.Side;
import net.sourceforge.plantuml.svek.extremity.ExtremityExtendsLike;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactory;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class ExtremityFactoryExtendsLike
extends AbstractExtremityFactory
implements ExtremityFactory {
    private final HColor backgroundColor;
    private final boolean definedBy;

    public ExtremityFactoryExtendsLike(HColor backgroundColor, boolean definedBy) {
        this.backgroundColor = backgroundColor;
        this.definedBy = definedBy;
    }

    @Override
    public UDrawable createUDrawable(XPoint2D p0, double angle, Side side) {
        if (this.definedBy) {
            return new ExtremityExtendsLike.DefinedBy(p0, angle, this.backgroundColor);
        }
        return new ExtremityExtendsLike.Redefines(p0, angle, this.backgroundColor);
    }

    @Override
    public UDrawable createUDrawable(XPoint2D p0, XPoint2D p1, XPoint2D p2, Side side) {
        double ortho = this.atan2(p0, p2) + 1.5707963267948966;
        if (this.definedBy) {
            return new ExtremityExtendsLike.DefinedBy(p1, ortho, this.backgroundColor);
        }
        return new ExtremityExtendsLike.Redefines(p1, ortho, this.backgroundColor);
    }
}

