# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
ShapeBuild module, see official documentation at
https://www.opencascade.com/doc/occt-7.6.0/refman/html/package_shapebuild.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _ShapeBuild
else:
    import _ShapeBuild

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ShapeBuild.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _ShapeBuild.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _ShapeBuild.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _ShapeBuild.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _ShapeBuild.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _ShapeBuild.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _ShapeBuild.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _ShapeBuild.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _ShapeBuild.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _ShapeBuild.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _ShapeBuild.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _ShapeBuild.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _ShapeBuild.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _ShapeBuild.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _ShapeBuild.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _ShapeBuild.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _ShapeBuild.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _ShapeBuild:
_ShapeBuild.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _ShapeBuild.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.Geom
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.OSD
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.Geom2d
import OCC.Core.BRepTools
import OCC.Core.Bnd
import OCC.Core.BVH
import OCC.Core.TopTools
import OCC.Core.BRep
import OCC.Core.Poly
import OCC.Core.TShort
import OCC.Core.ShapeExtend
import OCC.Core.TColGeom

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_ShapeBuild_ReShape_Create() -> "opencascade::handle< ShapeBuild_ReShape >":
    return _ShapeBuild.Handle_ShapeBuild_ReShape_Create()

def Handle_ShapeBuild_ReShape_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< ShapeBuild_ReShape >":
    return _ShapeBuild.Handle_ShapeBuild_ReShape_DownCast(t)

def Handle_ShapeBuild_ReShape_IsNull(t: "opencascade::handle< ShapeBuild_ReShape > const &") -> "bool":
    return _ShapeBuild.Handle_ShapeBuild_ReShape_IsNull(t)
class shapebuild(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def PlaneXOY(*args) -> "opencascade::handle< Geom_Plane >":
        r"""
        Rebuilds a shape with substitution of some components returns a geom_surface which is the plane xoy (z positive) this allows to consider an uv space homologous to a 3d space, with this support surface.

        Returns
        -------
        opencascade::handle<Geom_Plane>

        """
        return _ShapeBuild.shapebuild_PlaneXOY(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _ShapeBuild.shapebuild_swiginit(self, _ShapeBuild.new_shapebuild())
    __swig_destroy__ = _ShapeBuild.delete_shapebuild

# Register shapebuild in _ShapeBuild:
_ShapeBuild.shapebuild_swigregister(shapebuild)

def shapebuild_PlaneXOY(*args) -> "opencascade::handle< Geom_Plane >":
    r"""
    Rebuilds a shape with substitution of some components returns a geom_surface which is the plane xoy (z positive) this allows to consider an uv space homologous to a 3d space, with this support surface.

    Returns
    -------
    opencascade::handle<Geom_Plane>

    """
    return _ShapeBuild.shapebuild_PlaneXOY(*args)

class ShapeBuild_Edge(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def BuildCurve3d(self, *args) -> "Standard_Boolean":
        r"""
        Calls breptools::buildcurve3d.

        Parameters
        ----------
        edge: TopoDS_Edge

        Returns
        -------
        bool

        """
        return _ShapeBuild.ShapeBuild_Edge_BuildCurve3d(self, *args)

    def Copy(self, *args) -> "TopoDS_Edge":
        r"""
        Make a copy of <edge> by call to copyreplacevertices() (i.e. construct new tedge with the same pcurves and vertices). if <sharepcurves> is false, pcurves are also replaced by their copies with help of method copypcurves.

        Parameters
        ----------
        edge: TopoDS_Edge
        sharepcurves: bool,optional
        	default value is Standard_True

        Returns
        -------
        TopoDS_Edge

        """
        return _ShapeBuild.ShapeBuild_Edge_Copy(self, *args)

    def CopyPCurves(self, *args) -> "void":
        r"""
        Makes a copy of pcurves from edge <fromedge> into edge <toedge>. pcurves which are already present in <toedge>, are replaced by copies, other are copied. ranges are also copied.

        Parameters
        ----------
        toedge: TopoDS_Edge
        fromedge: TopoDS_Edge

        Returns
        -------
        None

        """
        return _ShapeBuild.ShapeBuild_Edge_CopyPCurves(self, *args)

    def CopyRanges(self, *args) -> "void":
        r"""
        Copies ranges for curve3d and all common pcurves from edge <fromedge> into edge <toedge>.

        Parameters
        ----------
        toedge: TopoDS_Edge
        fromedge: TopoDS_Edge
        alpha: float,optional
        	default value is 0
        beta: float,optional
        	default value is 1

        Returns
        -------
        None

        """
        return _ShapeBuild.ShapeBuild_Edge_CopyRanges(self, *args)

    def CopyReplaceVertices(self, *args) -> "TopoDS_Edge":
        r"""
        Copy edge and replace one or both its vertices to a given one(s). vertex v1 replaces forward vertex, and v2 - reversed, as they are found by topods_iterator. if v1 or v2 is null, the original vertex is taken.

        Parameters
        ----------
        edge: TopoDS_Edge
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex

        Returns
        -------
        TopoDS_Edge

        """
        return _ShapeBuild.ShapeBuild_Edge_CopyReplaceVertices(self, *args)

    def MakeEdge(self, *args) -> "void":
        r"""
        Makes edge with curve and location.

        Parameters
        ----------
        edge: TopoDS_Edge
        curve: Geom_Curve
        L: TopLoc_Location

        Returns
        -------
        None
        Makes edge with curve, location and range [p1, p2].

        Parameters
        ----------
        edge: TopoDS_Edge
        curve: Geom_Curve
        L: TopLoc_Location
        p1: float
        p2: float

        Returns
        -------
        None
        Makes edge with pcurve and face.

        Parameters
        ----------
        edge: TopoDS_Edge
        pcurve: Geom2d_Curve
        face: TopoDS_Face

        Returns
        -------
        None
        Makes edge with pcurve, face and range [p1, p2].

        Parameters
        ----------
        edge: TopoDS_Edge
        pcurve: Geom2d_Curve
        face: TopoDS_Face
        p1: float
        p2: float

        Returns
        -------
        None
        Makes edge with pcurve, surface and location.

        Parameters
        ----------
        edge: TopoDS_Edge
        pcurve: Geom2d_Curve
        S: Geom_Surface
        L: TopLoc_Location

        Returns
        -------
        None
        Makes edge with pcurve, surface, location and range [p1, p2].

        Parameters
        ----------
        edge: TopoDS_Edge
        pcurve: Geom2d_Curve
        S: Geom_Surface
        L: TopLoc_Location
        p1: float
        p2: float

        Returns
        -------
        None

        """
        return _ShapeBuild.ShapeBuild_Edge_MakeEdge(self, *args)

    def ReassignPCurve(self, *args) -> "Standard_Boolean":
        r"""
        Reassign edge pcurve lying on face <old> to another face <sub>. if edge has two pcurves on <old> face, only one of them will be reassigned, and other will left alone. similarly, if edge already had a pcurve on face <sub>, it will have two pcurves on it. returns true if succeeded, false if no pcurve lying on <old> found.

        Parameters
        ----------
        edge: TopoDS_Edge
        old: TopoDS_Face
        sub: TopoDS_Face

        Returns
        -------
        bool

        """
        return _ShapeBuild.ShapeBuild_Edge_ReassignPCurve(self, *args)

    def RemoveCurve3d(self, *args) -> "void":
        r"""
        Removes the curve3d recorded in an edge.

        Parameters
        ----------
        edge: TopoDS_Edge

        Returns
        -------
        None

        """
        return _ShapeBuild.ShapeBuild_Edge_RemoveCurve3d(self, *args)

    def RemovePCurve(self, *args) -> "void":
        r"""
        Removes the pcurve(s) which could be recorded in an edge for the given face.

        Parameters
        ----------
        edge: TopoDS_Edge
        face: TopoDS_Face

        Returns
        -------
        None
        Removes the pcurve(s) which could be recorded in an edge for the given surface.

        Parameters
        ----------
        edge: TopoDS_Edge
        surf: Geom_Surface

        Returns
        -------
        None
        Removes the pcurve(s) which could be recorded in an edge for the given surface, with given location.

        Parameters
        ----------
        edge: TopoDS_Edge
        surf: Geom_Surface
        loc: TopLoc_Location

        Returns
        -------
        None

        """
        return _ShapeBuild.ShapeBuild_Edge_RemovePCurve(self, *args)

    def ReplacePCurve(self, *args) -> "void":
        r"""
        Replace the pcurve in an edge for the given face in case if edge is seam, i.e. has 2 pcurves on that face, only pcurve corresponding to the orientation of the edge is replaced.

        Parameters
        ----------
        edge: TopoDS_Edge
        pcurve: Geom2d_Curve
        face: TopoDS_Face

        Returns
        -------
        None

        """
        return _ShapeBuild.ShapeBuild_Edge_ReplacePCurve(self, *args)

    def SetRange3d(self, *args) -> "void":
        r"""
        Sets range on 3d curve only.

        Parameters
        ----------
        edge: TopoDS_Edge
        first: float
        last: float

        Returns
        -------
        None

        """
        return _ShapeBuild.ShapeBuild_Edge_SetRange3d(self, *args)

    def TransformPCurve(self, *args) -> "opencascade::handle< Geom2d_Curve >":
        r"""
        Transforms the pcurve with given matrix and affinity u factor.

        Parameters
        ----------
        pcurve: Geom2d_Curve
        trans: gp_Trsf2d
        uFact: float

        Returns
        -------
        aFirst: float
        aLast: float

        """
        return _ShapeBuild.ShapeBuild_Edge_TransformPCurve(self, *args)

    __repr__ = _dumps_object


    def __init__(self):
        _ShapeBuild.ShapeBuild_Edge_swiginit(self, _ShapeBuild.new_ShapeBuild_Edge())
    __swig_destroy__ = _ShapeBuild.delete_ShapeBuild_Edge

# Register ShapeBuild_Edge in _ShapeBuild:
_ShapeBuild.ShapeBuild_Edge_swigregister(ShapeBuild_Edge)

class ShapeBuild_ReShape(OCC.Core.BRepTools.BRepTools_ReShape):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Returns an empty reshape.

        Returns
        -------
        None

        """
        _ShapeBuild.ShapeBuild_ReShape_swiginit(self, _ShapeBuild.new_ShapeBuild_ReShape(*args))

    def Apply(self, *args) -> "TopoDS_Shape":
        r"""
        Applies the substitutions requests to a shape //! <until> gives the level of type until which requests are taken into account. for subshapes of the type <until> no rebuild and further exploring are done. actually, not implemented below topabs_face //! <buildmode> says how to do on a solid,shell ... if one of its sub-shapes has been changed: 0: at least one replace or remove -> compound, else as such 1: at least one remove (replace are ignored) -> compound 2: replace and remove are both ignored if replace/remove are ignored or absent, the result as same type as the starting shape.

        Parameters
        ----------
        shape: TopoDS_Shape
        until: TopAbs_ShapeEnum
        buildmode: int

        Returns
        -------
        TopoDS_Shape
        Applies the substitutions requests to a shape. //! <until> gives the level of type until which requests are taken into account. for subshapes of the type <until> no rebuild and further exploring are done. //! note: each subshape can be replaced by shape of the same type or by shape containing only shapes of that type (for example, topods_edge can be replaced by topods_edge, topods_wire or topods_compound containing topods_edges). if incompatible shape type is encountered, it is ignored and flag fail1 is set in status.

        Parameters
        ----------
        shape: TopoDS_Shape
        until: TopAbs_ShapeEnum,optional
        	default value is TopAbs_SHAPE

        Returns
        -------
        TopoDS_Shape

        """
        return _ShapeBuild.ShapeBuild_ReShape_Apply(self, *args)

    def Status(self, *args) -> "Standard_Boolean":
        r"""
        Returns a complete substitution status for a shape 0 : not recorded, <newsh> = original <shape> < 0: to be removed, <newsh> is null > 0: to be replaced, <newsh> is a new item if <last> is false, returns status and new shape recorded in the map directly for the shape, if true and status > 0 then recursively searches for the last status and new shape.

        Parameters
        ----------
        shape: TopoDS_Shape
        newsh: TopoDS_Shape
        last: bool,optional
        	default value is Standard_False

        Returns
        -------
        int
        Queries the status of last call to apply(shape,enum) ok : no (sub)shapes replaced or removed done1: source (starting) shape replaced done2: source (starting) shape removed done3: some subshapes replaced done4: some subshapes removed fail1: some replacements not done because of bad type of subshape.

        Parameters
        ----------
        status: ShapeExtend_Status

        Returns
        -------
        bool

        """
        return _ShapeBuild.ShapeBuild_ReShape_Status(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_ShapeBuild_ReShape_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _ShapeBuild.delete_ShapeBuild_ReShape

# Register ShapeBuild_ReShape in _ShapeBuild:
_ShapeBuild.ShapeBuild_ReShape_swigregister(ShapeBuild_ReShape)

class ShapeBuild_Vertex(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def CombineVertex(self, *args) -> "TopoDS_Vertex":
        r"""
        Combines new vertex from two others. this new one is the smallest vertex which comprises both of the source vertices. the function takes into account the positions and tolerances of the source vertices. the tolerance of the new vertex will be equal to the minimal tolerance that is required to comprise source vertices multiplied by tolfactor (in order to avoid errors because of discreteness of calculations).

        Parameters
        ----------
        V1: TopoDS_Vertex
        V2: TopoDS_Vertex
        tolFactor: float,optional
        	default value is 1.0001

        Returns
        -------
        TopoDS_Vertex
        The same function as above, except that it accepts two points and two tolerances instead of vertices.

        Parameters
        ----------
        pnt1: gp_Pnt
        pnt2: gp_Pnt
        tol1: float
        tol2: float
        tolFactor: float,optional
        	default value is 1.0001

        Returns
        -------
        TopoDS_Vertex

        """
        return _ShapeBuild.ShapeBuild_Vertex_CombineVertex(self, *args)

    __repr__ = _dumps_object


    def __init__(self):
        _ShapeBuild.ShapeBuild_Vertex_swiginit(self, _ShapeBuild.new_ShapeBuild_Vertex())
    __swig_destroy__ = _ShapeBuild.delete_ShapeBuild_Vertex

# Register ShapeBuild_Vertex in _ShapeBuild:
_ShapeBuild.ShapeBuild_Vertex_swigregister(ShapeBuild_Vertex)





