/* object-cache.c generated by valac 0.56.0, the Vala compiler
 * generated from object-cache.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include "folks/folks.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>

#define FOLKS_OBJECT_CACHE__FILE_FORMAT_VERSION ((guint8) 1)
#define FOLKS_OBJECT_CACHE__HEADER_WIDTH ((gsize) 8)

enum  {
	FOLKS_OBJECT_CACHE_0_PROPERTY,
	FOLKS_OBJECT_CACHE_T_TYPE,
	FOLKS_OBJECT_CACHE_T_DUP_FUNC,
	FOLKS_OBJECT_CACHE_T_DESTROY_FUNC,
	FOLKS_OBJECT_CACHE_TYPE_ID_PROPERTY,
	FOLKS_OBJECT_CACHE_ID_PROPERTY,
	FOLKS_OBJECT_CACHE_NUM_PROPERTIES
};
static GParamSpec* folks_object_cache_properties[FOLKS_OBJECT_CACHE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _FolksObjectCacheLoadObjectsData FolksObjectCacheLoadObjectsData;
typedef struct _FolksObjectCacheStoreObjectsData FolksObjectCacheStoreObjectsData;
typedef struct _FolksObjectCacheClearCacheData FolksObjectCacheClearCacheData;
typedef struct _FolksObjectCacheCreateCacheDirectoryData FolksObjectCacheCreateCacheDirectoryData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolksObjectCachePrivate {
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	GFile* _cache_directory;
	GFile* _cache_file;
	gchar* _cache_file_path;
	gchar* _type_id;
	gchar* _id;
};

struct _FolksObjectCacheLoadObjectsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksObjectCache* self;
	GCancellable* cancellable;
	GeeSet* result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	GFile* _tmp3_;
	guint8* _tmp4_;
	gsize _tmp5_;
	GError* e;
	GError* _tmp6_;
	GError* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GError* _tmp12_;
	const gchar* _tmp13_;
	guint8* _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	guint8 wrapper_version;
	guint8* _tmp16_;
	gint _tmp16__length1;
	guint8 _tmp17_;
	guint8 object_version;
	guint8* _tmp18_;
	gint _tmp18__length1;
	guint8 _tmp19_;
	const gchar* _tmp20_;
	guint8* variant_data;
	guint8* _tmp21_;
	gint _tmp21__length1;
	guint8* _tmp22_;
	gint _tmp22__length1;
	gint variant_data_length1;
	gint _variant_data_size_;
	GVariantType* _variant_type;
	GVariantType* _tmp23_;
	const GVariantType* _tmp24_;
	const gchar* _tmp25_;
	GVariantType* variant_type;
	const GVariantType* _tmp26_;
	GVariantType* _tmp27_;
	GVariant* variant;
	const GVariantType* _tmp28_;
	guint8* _tmp29_;
	gint _tmp29__length1;
	guint8* _tmp30_;
	gint _tmp30__length1;
	guint8* _tmp31_;
	gint _tmp31__length1;
	GVariant* _tmp32_;
	GVariant* _tmp33_;
	const gchar* _tmp34_;
	gchar* type_id;
	GVariant* _tmp35_;
	GVariant* _tmp36_;
	GVariant* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	gchar* id;
	GVariant* _tmp46_;
	GVariant* _tmp47_;
	GVariant* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	GVariant* objects_variant;
	GVariant* _tmp57_;
	GVariant* _tmp58_;
	GeeHashSet* objects;
	GeeHashSet* _tmp59_;
	guint i;
	gboolean _tmp60_;
	guint _tmp61_;
	GVariant* _tmp62_;
	GVariant* object_variant;
	GVariant* _tmp63_;
	GVariant* _tmp64_;
	gpointer object;
	GVariant* _tmp65_;
	gpointer _tmp66_;
	GeeHashSet* _tmp67_;
	gconstpointer _tmp68_;
	GError* _inner_error0_;
};

struct _FolksObjectCacheStoreObjectsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksObjectCache* self;
	GeeSet* objects;
	GCancellable* cancellable;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GVariantType* child_type;
	GVariantType* _tmp3_;
	const GVariantType* _tmp4_;
	GVariant** children;
	gint _tmp5_;
	gint _tmp6_;
	GVariant** _tmp7_;
	gint children_length1;
	gint _children_size_;
	guint i;
	GeeIterator* _object_it;
	GeeIterator* _tmp8_;
	GeeIterator* _tmp9_;
	gpointer object;
	GeeIterator* _tmp10_;
	gpointer _tmp11_;
	GVariant** _tmp12_;
	gint _tmp12__length1;
	guint _tmp13_;
	gconstpointer _tmp14_;
	GVariant* _tmp15_;
	guint8 wrapper_version;
	guint8 object_version;
	GVariant* variant;
	const gchar* _tmp16_;
	GVariant* _tmp17_;
	const gchar* _tmp18_;
	GVariant* _tmp19_;
	const GVariantType* _tmp20_;
	GVariant** _tmp21_;
	gint _tmp21__length1;
	GVariant* _tmp22_;
	GVariant** _tmp23_;
	GVariant** _tmp24_;
	gint _tmp24__length1;
	GVariant* _tmp25_;
	GVariant* _tmp26_;
	GVariantType* desired_variant_type;
	GVariantType* _tmp27_;
	gboolean _tmp28_;
	const GVariantType* _tmp29_;
	GVariant* _tmp30_;
	const GVariantType* _tmp31_;
	const GVariantType* _tmp32_;
	guint8* data;
	GVariant* _tmp33_;
	guint8* _tmp34_;
	gint data_length1;
	gint _data_size_;
	guint8* _tmp35_;
	gint _tmp35__length1;
	guint8* _tmp36_;
	gint _tmp36__length1;
	GVariant* _tmp37_;
	guint8* _tmp38_;
	gint _tmp38__length1;
	guint8* _tmp39_;
	gint _tmp39__length1;
	GFile* _tmp40_;
	guint8* _tmp41_;
	gint _tmp41__length1;
	GError* e;
	GError* _tmp42_;
	GFile* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	GError* _tmp46_;
	const gchar* _tmp47_;
	GError* _tmp48_;
	const gchar* _tmp49_;
	GError* _tmp50_;
	const gchar* _tmp51_;
	GError* _inner_error0_;
};

struct _FolksObjectCacheClearCacheData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksObjectCache* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_;
};

struct _FolksObjectCacheCreateCacheDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksObjectCache* self;
	GFile* _tmp0_;
	GError* e;
	GError* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	GError* _inner_error0_;
};

static gint FolksObjectCache_private_offset;
static gpointer folks_object_cache_parent_class = NULL;

static GVariantType* folks_object_cache_real_get_serialised_object_type (FolksObjectCache* self,
                                                                  guint8 object_version);
static guint8 folks_object_cache_real_get_serialised_object_version (FolksObjectCache* self);
static GVariant* folks_object_cache_real_serialise_object (FolksObjectCache* self,
                                                    gconstpointer object);
static gpointer folks_object_cache_real_deserialise_object (FolksObjectCache* self,
                                                     GVariant* variant,
                                                     guint8 object_version);
static void folks_object_cache_load_objects_data_free (gpointer _data);
static gboolean folks_object_cache_load_objects_co (FolksObjectCacheLoadObjectsData* _data_);
static void folks_object_cache_load_objects_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static GVariantType* _folks_object_cache_get_cache_file_variant_type (FolksObjectCache* self,
                                                               guint8 wrapper_version,
                                                               guint8 object_version);
static guint8* _vala_array_dup3 (guint8* self,
                          gssize length);
static void folks_object_cache_store_objects_data_free (gpointer _data);
static gboolean folks_object_cache_store_objects_co (FolksObjectCacheStoreObjectsData* _data_);
static void folks_object_cache_store_objects_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void _folks_object_cache_create_cache_directory (FolksObjectCache* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void _folks_object_cache_create_cache_directory_finish (FolksObjectCache* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static void folks_object_cache_clear_cache_data_free (gpointer _data);
static gboolean folks_object_cache_clear_cache_co (FolksObjectCacheClearCacheData* _data_);
static void _folks_object_cache_create_cache_directory_data_free (gpointer _data);
static gboolean _folks_object_cache_create_cache_directory_co (FolksObjectCacheCreateCacheDirectoryData* _data_);
static GObject * folks_object_cache_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void folks_object_cache_finalize (GObject * obj);
static GType folks_object_cache_get_type_once (void);
static void _vala_folks_object_cache_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_folks_object_cache_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
folks_object_cache_get_instance_private (FolksObjectCache* self)
{
	return G_STRUCT_MEMBER_P (self, FolksObjectCache_private_offset);
}

/**
   * Get the {@link GLib.VariantType} of the serialised form of an object stored
   * in this cache.
   *
   * If a smooth upgrade path is needed in future due to cache file format
   * changes, this may be modified to take a version parameter.
   *
   * @param object_version the version of the object format to use, or
   * ``uint8.MAX`` for the latest version
   * @return variant type for that object version, or ``null`` if the version is
   * unsupported
   * @since 0.6.0
   */
static GVariantType*
folks_object_cache_real_get_serialised_object_type (FolksObjectCache* self,
                                                    guint8 object_version)
{
	g_critical ("Type `%s' does not implement abstract method `folks_object_cache_get_serialised_object_type'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GVariantType*
folks_object_cache_get_serialised_object_type (FolksObjectCache* self,
                                               guint8 object_version)
{
	FolksObjectCacheClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FOLKS_OBJECT_CACHE_GET_CLASS (self);
	if (_klass_->get_serialised_object_type) {
		return _klass_->get_serialised_object_type (self, object_version);
	}
	return NULL;
}

/**
   * Get the version of the variant type returned by
   * {@link ObjectCache.get_serialised_object_type}. This must be incremented
   * every time the variant type changes so that old cache files aren't
   * misinterpreted.
   *
   * @since 0.6.0
   */
static guint8
folks_object_cache_real_get_serialised_object_version (FolksObjectCache* self)
{
	guint8 _tmp0_ = 0U;
	g_critical ("Type `%s' does not implement abstract method `folks_object_cache_get_serialised_object_version'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

guint8
folks_object_cache_get_serialised_object_version (FolksObjectCache* self)
{
	FolksObjectCacheClass* _klass_;
	g_return_val_if_fail (self != NULL, 0U);
	_klass_ = FOLKS_OBJECT_CACHE_GET_CLASS (self);
	if (_klass_->get_serialised_object_version) {
		return _klass_->get_serialised_object_version (self);
	}
	return 0U;
}

/**
   * Serialise the given ``object`` to a {@link GLib.Variant} and return the
   * variant. The variant must be of the type returned by
   * {@link ObjectCache.get_serialised_object_type}.
   *
   * @param object the object to serialise
   * @return serialised form of ``object``
   *
   * @since 0.6.0
   */
static GVariant*
folks_object_cache_real_serialise_object (FolksObjectCache* self,
                                          gconstpointer object)
{
	g_critical ("Type `%s' does not implement abstract method `folks_object_cache_serialise_object'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GVariant*
folks_object_cache_serialise_object (FolksObjectCache* self,
                                     gconstpointer object)
{
	FolksObjectCacheClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FOLKS_OBJECT_CACHE_GET_CLASS (self);
	if (_klass_->serialise_object) {
		return _klass_->serialise_object (self, object);
	}
	return NULL;
}

/**
   * Deserialise the given ``variant`` to a new instance of an object. The
   * variant is guaranteed to have the type returned by
   * {@link ObjectCache.get_serialised_object_type}.
   *
   * @param variant the serialised form to deserialise
   * @param object_version the version of the object format to deserialise from
   * @return the deserialised object
   *
   * @since 0.6.0
   */
static gpointer
folks_object_cache_real_deserialise_object (FolksObjectCache* self,
                                            GVariant* variant,
                                            guint8 object_version)
{
	g_critical ("Type `%s' does not implement abstract method `folks_object_cache_deserialise_object'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gpointer
folks_object_cache_deserialise_object (FolksObjectCache* self,
                                       GVariant* variant,
                                       guint8 object_version)
{
	FolksObjectCacheClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = FOLKS_OBJECT_CACHE_GET_CLASS (self);
	if (_klass_->deserialise_object) {
		return _klass_->deserialise_object (self, variant, object_version);
	}
	return NULL;
}

/**
   * Create a new cache instance using the given type ID and ID. This is
   * protected as the ``type_id`` will typically be set statically by
   * subclasses.
   *
   * @param type_id A string identifying the type of object being cached. This
   * has to be suitable for use as a directory name; i.e. lower case,
   * hyphen-separated.
   * @param id A string identifying the particular cache instance. This will
   * form the file name of the cache file, but will be escaped beforehand, so
   * can be an arbitrary non-empty string.
   * @return A new cache instance
   *
   * @since 0.6.0
   */
FolksObjectCache*
folks_object_cache_construct (GType object_type,
                              GType t_type,
                              GBoxedCopyFunc t_dup_func,
                              GDestroyNotify t_destroy_func,
                              const gchar* type_id,
                              const gchar* id)
{
	FolksObjectCache * self = NULL;
	g_return_val_if_fail (type_id != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	self = (FolksObjectCache*) g_object_new (object_type, "t-type", t_type, "t-dup-func", t_dup_func, "t-destroy-func", t_destroy_func, "type-id", type_id, "id", id, NULL);
	self->priv->t_type = t_type;
	self->priv->t_dup_func = t_dup_func;
	self->priv->t_destroy_func = t_destroy_func;
	return self;
}

static void
folks_object_cache_load_objects_data_free (gpointer _data)
{
	FolksObjectCacheLoadObjectsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksObjectCacheLoadObjectsData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
folks_object_cache_load_objects (FolksObjectCache* self,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	FolksObjectCacheLoadObjectsData* _data_;
	FolksObjectCache* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FolksObjectCacheLoadObjectsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_object_cache_load_objects_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	folks_object_cache_load_objects_co (_data_);
}

GeeSet*
folks_object_cache_load_objects_finish (FolksObjectCache* self,
                                        GAsyncResult* _res_)
{
	GeeSet* result;
	FolksObjectCacheLoadObjectsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
   * Load a set of objects from the cache and return them as a new set. If the
   * cache file doesn't exist, ``null`` will be returned. An empty set will be
   * returned if the cache file existed but was empty (i.e. was stored with
   * an empty set originally).
   *
   * Loading the objects can be cancelled using ``cancellable``. If it is,
   * ``null`` will be returned.
   *
   * If any errors are encountered while loading the objects, warnings will be
   * logged as appropriate and ``null`` will be returned.
   *
   * This method is safe to call multiple times concurrently.
   *
   * @param cancellable A {@link GLib.Cancellable} for the operation, or
   * ``null``.
   * @return A set of objects from the cache, or ``null``.
   *
   * @since 0.6.0
   */
static void
folks_object_cache_load_objects_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	FolksObjectCacheLoadObjectsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_object_cache_load_objects_co (_data_);
}

static gpointer
_g_variant_type_copy0 (gpointer self)
{
	return self ? g_variant_type_copy (self) : NULL;
}

static guint8*
_vala_array_dup3 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static gboolean
folks_object_cache_load_objects_co (FolksObjectCacheLoadObjectsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_type_id;
	_data_->_tmp1_ = _data_->self->priv->_id;
	_data_->_tmp2_ = _data_->self->priv->_cache_file_path;
	g_debug ("object-cache.vala:193: Loading cache (type ID '%s', ID '%s') from file" \
" '%s'.", _data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_);
	_data_->data_length1 = 0;
	_data_->_data_size_ = 0;
	{
		_data_->_tmp3_ = _data_->self->priv->_cache_file;
		_data_->_tmp4_ = NULL;
		_data_->_tmp5_ = 0;
		_data_->_state_ = 1;
		g_file_load_contents_async (_data_->_tmp3_, _data_->cancellable, folks_object_cache_load_objects_ready, _data_);
		return FALSE;
		_state_1:
		g_file_load_contents_finish (_data_->_tmp3_, _data_->_res_, &_data_->_tmp4_, &_data_->_tmp5_, NULL, &_data_->_inner_error0_);
		_data_->data = (g_free (_data_->data), NULL);
		_data_->data = _data_->_tmp4_;
		_data_->data_length1 = _data_->_tmp5_;
		_data_->_data_size_ = _data_->data_length1;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->e;
		if (g_error_matches (_data_->_tmp6_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
		} else {
			_data_->_tmp7_ = _data_->e;
			if (g_error_matches (_data_->_tmp7_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				_data_->_tmp8_ = _data_->self->priv->_cache_file_path;
				_data_->_tmp9_ = _data_->e;
				_data_->_tmp10_ = _data_->_tmp9_->message;
				g_debug ("object-cache.vala:211: Couldn't load cache file '%s': %s", _data_->_tmp8_, _data_->_tmp10_);
			} else {
				_data_->_tmp11_ = _data_->self->priv->_cache_file_path;
				_data_->_tmp12_ = _data_->e;
				_data_->_tmp13_ = _data_->_tmp12_->message;
				g_warning ("object-cache.vala:216: Couldn't load cache file '%s': %s", _data_->_tmp11_, _data_->_tmp13_);
			}
		}
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		_data_->data = (g_free (_data_->data), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_data_->data = (g_free (_data_->data), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = _data_->data;
	_data_->_tmp14__length1 = _data_->data_length1;
	if (((gsize) _data_->_tmp14__length1) < FOLKS_OBJECT_CACHE__HEADER_WIDTH) {
		_data_->_tmp15_ = _data_->self->priv->_cache_file_path;
		g_warning ("object-cache.vala:226: Cache file '%s' was too small. The file was del" \
"eted.", _data_->_tmp15_);
		_data_->_state_ = 2;
		folks_object_cache_clear_cache (_data_->self, folks_object_cache_load_objects_ready, _data_);
		return FALSE;
		_state_2:
		folks_object_cache_clear_cache_finish (_data_->self, _data_->_res_);
		_data_->result = NULL;
		_data_->data = (g_free (_data_->data), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp16_ = _data_->data;
	_data_->_tmp16__length1 = _data_->data_length1;
	_data_->_tmp17_ = _data_->_tmp16_[0];
	_data_->wrapper_version = _data_->_tmp17_;
	_data_->_tmp18_ = _data_->data;
	_data_->_tmp18__length1 = _data_->data_length1;
	_data_->_tmp19_ = _data_->_tmp18_[1];
	_data_->object_version = _data_->_tmp19_;
	if (_data_->wrapper_version != FOLKS_OBJECT_CACHE__FILE_FORMAT_VERSION) {
		_data_->_tmp20_ = _data_->self->priv->_cache_file_path;
		g_warning ("Cache file '%s' was version %u of the file format, " "but only version %u is supported. The file was deleted.", _data_->_tmp20_, _data_->wrapper_version, FOLKS_OBJECT_CACHE__FILE_FORMAT_VERSION);
		_data_->_state_ = 3;
		folks_object_cache_clear_cache (_data_->self, folks_object_cache_load_objects_ready, _data_);
		return FALSE;
		_state_3:
		folks_object_cache_clear_cache_finish (_data_->self, _data_->_res_);
		_data_->result = NULL;
		_data_->data = (g_free (_data_->data), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = _data_->data;
	_data_->_tmp21__length1 = _data_->data_length1;
	_data_->_tmp22_ = _data_->data;
	_data_->_tmp22__length1 = _data_->data_length1;
	_data_->variant_data = _data_->_tmp21_ + ((gint) FOLKS_OBJECT_CACHE__HEADER_WIDTH);
	_data_->variant_data_length1 = _data_->_tmp22__length1 - ((gint) FOLKS_OBJECT_CACHE__HEADER_WIDTH);
	_data_->_variant_data_size_ = _data_->variant_data_length1;
	_data_->_tmp23_ = _folks_object_cache_get_cache_file_variant_type (_data_->self, _data_->wrapper_version, _data_->object_version);
	_data_->_variant_type = _data_->_tmp23_;
	_data_->_tmp24_ = _data_->_variant_type;
	if (_data_->_tmp24_ == NULL) {
		_data_->_tmp25_ = _data_->self->priv->_cache_file_path;
		g_warning ("Cache file '%s' was version %u of the object file " "format, which is not supported. The file was deleted.", _data_->_tmp25_, _data_->object_version);
		_data_->_state_ = 4;
		folks_object_cache_clear_cache (_data_->self, folks_object_cache_load_objects_ready, _data_);
		return FALSE;
		_state_4:
		folks_object_cache_clear_cache_finish (_data_->self, _data_->_res_);
		_data_->result = NULL;
		_g_variant_type_free0 (_data_->_variant_type);
		_data_->data = (g_free (_data_->data), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp26_ = _data_->_variant_type;
	_data_->_tmp27_ = _g_variant_type_copy0 ((const GVariantType*) _data_->_tmp26_);
	_data_->variant_type = _data_->_tmp27_;
	_data_->_tmp28_ = _data_->variant_type;
	_data_->_tmp29_ = _data_->variant_data;
	_data_->_tmp29__length1 = _data_->variant_data_length1;
	_data_->_tmp30_ = _data_->data;
	_data_->_tmp30__length1 = _data_->data_length1;
	_data_->_tmp31_ = (_data_->_tmp30_ != NULL) ? _vala_array_dup3 (_data_->_tmp30_, _data_->_tmp30__length1) : _data_->_tmp30_;
	_data_->_tmp31__length1 = _data_->_tmp30__length1;
	_data_->_tmp32_ = g_variant_new_from_data (_data_->_tmp28_, _data_->_tmp29_, (gint) _data_->_tmp29__length1, FALSE, g_free, _data_->_tmp31_);
	g_variant_ref_sink (_data_->_tmp32_);
	_data_->variant = _data_->_tmp32_;
	_data_->_tmp33_ = _data_->variant;
	if (g_variant_is_normal_form (_data_->_tmp33_) == FALSE) {
		_data_->_tmp34_ = _data_->self->priv->_cache_file_path;
		g_warning ("object-cache.vala:272: Cache file '%s' was corrupt and was deleted.", _data_->_tmp34_);
		_data_->_state_ = 5;
		folks_object_cache_clear_cache (_data_->self, folks_object_cache_load_objects_ready, _data_);
		return FALSE;
		_state_5:
		folks_object_cache_clear_cache_finish (_data_->self, _data_->_res_);
		_data_->result = NULL;
		_g_variant_unref0 (_data_->variant);
		_g_variant_type_free0 (_data_->variant_type);
		_g_variant_type_free0 (_data_->_variant_type);
		_data_->data = (g_free (_data_->data), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp35_ = _data_->variant;
	_data_->_tmp36_ = g_variant_get_child_value (_data_->_tmp35_, (gsize) 0);
	_data_->_tmp37_ = _data_->_tmp36_;
	_data_->_tmp38_ = g_variant_get_string (_data_->_tmp37_, NULL);
	_data_->_tmp39_ = g_strdup (_data_->_tmp38_);
	_data_->_tmp40_ = _data_->_tmp39_;
	_g_variant_unref0 (_data_->_tmp37_);
	_data_->type_id = _data_->_tmp40_;
	_data_->_tmp41_ = _data_->type_id;
	_data_->_tmp42_ = _data_->self->priv->_type_id;
	if (g_strcmp0 (_data_->_tmp41_, _data_->_tmp42_) != 0) {
		_data_->_tmp43_ = _data_->self->priv->_cache_file_path;
		_data_->_tmp44_ = _data_->type_id;
		_data_->_tmp45_ = _data_->self->priv->_type_id;
		g_warning ("Cache file '%s' had type ID '%s', but '%s' was expected." "The file was deleted.", _data_->_tmp43_, _data_->_tmp44_, _data_->_tmp45_);
		_data_->_state_ = 6;
		folks_object_cache_clear_cache (_data_->self, folks_object_cache_load_objects_ready, _data_);
		return FALSE;
		_state_6:
		folks_object_cache_clear_cache_finish (_data_->self, _data_->_res_);
		_data_->result = NULL;
		_g_free0 (_data_->type_id);
		_g_variant_unref0 (_data_->variant);
		_g_variant_type_free0 (_data_->variant_type);
		_g_variant_type_free0 (_data_->_variant_type);
		_data_->data = (g_free (_data_->data), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp46_ = _data_->variant;
	_data_->_tmp47_ = g_variant_get_child_value (_data_->_tmp46_, (gsize) 1);
	_data_->_tmp48_ = _data_->_tmp47_;
	_data_->_tmp49_ = g_variant_get_string (_data_->_tmp48_, NULL);
	_data_->_tmp50_ = g_strdup (_data_->_tmp49_);
	_data_->_tmp51_ = _data_->_tmp50_;
	_g_variant_unref0 (_data_->_tmp48_);
	_data_->id = _data_->_tmp51_;
	_data_->_tmp52_ = _data_->id;
	_data_->_tmp53_ = _data_->self->priv->_id;
	if (g_strcmp0 (_data_->_tmp52_, _data_->_tmp53_) != 0) {
		_data_->_tmp54_ = _data_->self->priv->_cache_file_path;
		_data_->_tmp55_ = _data_->id;
		_data_->_tmp56_ = _data_->self->priv->_id;
		g_warning ("Cache file '%s' had ID '%s', but '%s' was expected." "The file was deleted.", _data_->_tmp54_, _data_->_tmp55_, _data_->_tmp56_);
		_data_->_state_ = 7;
		folks_object_cache_clear_cache (_data_->self, folks_object_cache_load_objects_ready, _data_);
		return FALSE;
		_state_7:
		folks_object_cache_clear_cache_finish (_data_->self, _data_->_res_);
		_data_->result = NULL;
		_g_free0 (_data_->id);
		_g_free0 (_data_->type_id);
		_g_variant_unref0 (_data_->variant);
		_g_variant_type_free0 (_data_->variant_type);
		_g_variant_type_free0 (_data_->_variant_type);
		_data_->data = (g_free (_data_->data), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp57_ = _data_->variant;
	_data_->_tmp58_ = g_variant_get_child_value (_data_->_tmp57_, (gsize) 2);
	_data_->objects_variant = _data_->_tmp58_;
	_data_->_tmp59_ = gee_hash_set_new (_data_->self->priv->t_type, (GBoxedCopyFunc) _data_->self->priv->t_dup_func, (GDestroyNotify) _data_->self->priv->t_destroy_func, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->objects = _data_->_tmp59_;
	{
		_data_->i = (guint) 0;
		{
			_data_->_tmp60_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp60_) {
					_data_->_tmp61_ = _data_->i;
					_data_->i = _data_->_tmp61_ + 1;
				}
				_data_->_tmp60_ = FALSE;
				_data_->_tmp62_ = _data_->objects_variant;
				if (!(((gsize) _data_->i) < g_variant_n_children (_data_->_tmp62_))) {
					break;
				}
				_data_->_tmp63_ = _data_->objects_variant;
				_data_->_tmp64_ = g_variant_get_child_value (_data_->_tmp63_, (gsize) _data_->i);
				_data_->object_variant = _data_->_tmp64_;
				_data_->_tmp65_ = _data_->object_variant;
				_data_->_tmp66_ = folks_object_cache_deserialise_object (_data_->self, _data_->_tmp65_, _data_->object_version);
				_data_->object = _data_->_tmp66_;
				_data_->_tmp67_ = _data_->objects;
				_data_->_tmp68_ = _data_->object;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp67_, _data_->_tmp68_);
				((_data_->object == NULL) || (_data_->self->priv->t_destroy_func == NULL)) ? NULL : (_data_->object = (_data_->self->priv->t_destroy_func (_data_->object), NULL));
				_g_variant_unref0 (_data_->object_variant);
			}
		}
	}
	_data_->result = (GeeSet*) _data_->objects;
	_g_variant_unref0 (_data_->objects_variant);
	_g_free0 (_data_->id);
	_g_free0 (_data_->type_id);
	_g_variant_unref0 (_data_->variant);
	_g_variant_type_free0 (_data_->variant_type);
	_g_variant_type_free0 (_data_->_variant_type);
	_data_->data = (g_free (_data_->data), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_object_cache_store_objects_data_free (gpointer _data)
{
	FolksObjectCacheStoreObjectsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->objects);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksObjectCacheStoreObjectsData, _data_);
}

void
folks_object_cache_store_objects (FolksObjectCache* self,
                                  GeeSet* objects,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	FolksObjectCacheStoreObjectsData* _data_;
	FolksObjectCache* _tmp0_;
	GeeSet* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (objects != NULL);
	_data_ = g_slice_new0 (FolksObjectCacheStoreObjectsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_object_cache_store_objects_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (objects);
	_g_object_unref0 (_data_->objects);
	_data_->objects = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	folks_object_cache_store_objects_co (_data_);
}

void
folks_object_cache_store_objects_finish (FolksObjectCache* self,
                                         GAsyncResult* _res_)
{
	FolksObjectCacheStoreObjectsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

/**
   * Store a set of objects to the cache file, overwriting any existing set of
   * objects in the cache, or creating the cache file from scratch if it didn't
   * previously exist.
   *
   * Storing the objects can be cancelled using ``cancellable``. If it is, the
   * cache will be left in a consistent state, but may be storing the old set
   * of objects or the new set.
   *
   * This method is safe to call multiple times concurrently.
   *
   * @param objects A set of objects to store. This may be empty, but may not
   * be ``null``.
   * @param cancellable A {@link GLib.Cancellable} for the operation, or
   * ``null``.
   *
   * @since 0.6.0
   */
static void
folks_object_cache_store_objects_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	FolksObjectCacheStoreObjectsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_object_cache_store_objects_co (_data_);
}

static gboolean
folks_object_cache_store_objects_co (FolksObjectCacheStoreObjectsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_type_id;
	_data_->_tmp1_ = _data_->self->priv->_id;
	_data_->_tmp2_ = _data_->self->priv->_cache_file_path;
	g_debug ("object-cache.vala:340: Storing cache (type ID '%s', ID '%s') to file '" \
"%s'.", _data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_);
	_data_->_tmp3_ = folks_object_cache_get_serialised_object_type (_data_->self, G_MAXUINT8);
	_data_->child_type = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->child_type;
	_vala_assert (_data_->_tmp4_ != NULL, "child_type != null");
	_data_->_tmp5_ = gee_collection_get_size ((GeeCollection*) _data_->objects);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_new0 (GVariant*, _data_->_tmp6_ + 1);
	_data_->children = _data_->_tmp7_;
	_data_->children_length1 = _data_->_tmp6_;
	_data_->_children_size_ = _data_->children_length1;
	_data_->i = (guint) 0;
	{
		_data_->_tmp8_ = gee_iterable_iterator ((GeeIterable*) _data_->objects);
		_data_->_object_it = _data_->_tmp8_;
		while (TRUE) {
			_data_->_tmp9_ = _data_->_object_it;
			if (!gee_iterator_next (_data_->_tmp9_)) {
				break;
			}
			_data_->_tmp10_ = _data_->_object_it;
			_data_->_tmp11_ = gee_iterator_get (_data_->_tmp10_);
			_data_->object = _data_->_tmp11_;
			_data_->_tmp12_ = _data_->children;
			_data_->_tmp12__length1 = _data_->children_length1;
			_data_->_tmp13_ = _data_->i;
			_data_->i = _data_->_tmp13_ + 1;
			_data_->_tmp14_ = _data_->object;
			_data_->_tmp15_ = folks_object_cache_serialise_object (_data_->self, _data_->_tmp14_);
			_g_variant_unref0 (_data_->_tmp12_[_data_->_tmp13_]);
			_data_->_tmp12_[_data_->_tmp13_] = _data_->_tmp15_;
			((_data_->object == NULL) || (_data_->self->priv->t_destroy_func == NULL)) ? NULL : (_data_->object = (_data_->self->priv->t_destroy_func (_data_->object), NULL));
		}
		_g_object_unref0 (_data_->_object_it);
	}
	_data_->wrapper_version = FOLKS_OBJECT_CACHE__FILE_FORMAT_VERSION;
	_data_->object_version = folks_object_cache_get_serialised_object_version (_data_->self);
	_data_->_tmp16_ = _data_->self->priv->_type_id;
	_data_->_tmp17_ = g_variant_new_string (_data_->_tmp16_);
	g_variant_ref_sink (_data_->_tmp17_);
	_data_->_tmp18_ = _data_->self->priv->_id;
	_data_->_tmp19_ = g_variant_new_string (_data_->_tmp18_);
	g_variant_ref_sink (_data_->_tmp19_);
	_data_->_tmp20_ = _data_->child_type;
	_data_->_tmp21_ = _data_->children;
	_data_->_tmp21__length1 = _data_->children_length1;
	_data_->_tmp22_ = g_variant_new_array (_data_->_tmp20_, _data_->_tmp21_, _data_->_tmp21__length1);
	g_variant_ref_sink (_data_->_tmp22_);
	_data_->_tmp23_ = g_new0 (GVariant*, 3 + 1);
	_data_->_tmp23_[0] = _data_->_tmp17_;
	_data_->_tmp23_[1] = _data_->_tmp19_;
	_data_->_tmp23_[2] = _data_->_tmp22_;
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp24__length1 = 3;
	_data_->_tmp25_ = g_variant_new_tuple (_data_->_tmp24_, 3);
	g_variant_ref_sink (_data_->_tmp25_);
	_data_->_tmp26_ = _data_->_tmp25_;
	_data_->_tmp24_ = (_vala_array_free (_data_->_tmp24_, _data_->_tmp24__length1, (GDestroyNotify) g_variant_unref), NULL);
	_data_->variant = _data_->_tmp26_;
	_data_->_tmp27_ = _folks_object_cache_get_cache_file_variant_type (_data_->self, _data_->wrapper_version, _data_->object_version);
	_data_->desired_variant_type = _data_->_tmp27_;
	_data_->_tmp29_ = _data_->desired_variant_type;
	if (_data_->_tmp29_ != NULL) {
		_data_->_tmp30_ = _data_->variant;
		_data_->_tmp31_ = g_variant_get_type (_data_->_tmp30_);
		_data_->_tmp32_ = _data_->desired_variant_type;
		_data_->_tmp28_ = g_variant_type_equal (_data_->_tmp31_, (const GVariantType*) _data_->_tmp32_);
	} else {
		_data_->_tmp28_ = FALSE;
	}
	_vala_assert (_data_->_tmp28_, "desired_variant_type != null &&           variant.get_type ().equal ((!) desired_variant_type)");
	_data_->_tmp33_ = _data_->variant;
	_data_->_tmp34_ = g_new0 (guint8, FOLKS_OBJECT_CACHE__HEADER_WIDTH + g_variant_get_size (_data_->_tmp33_));
	_data_->data = _data_->_tmp34_;
	_data_->data_length1 = FOLKS_OBJECT_CACHE__HEADER_WIDTH + g_variant_get_size (_data_->_tmp33_);
	_data_->_data_size_ = _data_->data_length1;
	_data_->_tmp35_ = _data_->data;
	_data_->_tmp35__length1 = _data_->data_length1;
	_data_->_tmp35_[0] = _data_->wrapper_version;
	_data_->_tmp36_ = _data_->data;
	_data_->_tmp36__length1 = _data_->data_length1;
	_data_->_tmp36_[1] = _data_->object_version;
	_data_->_tmp37_ = _data_->variant;
	_data_->_tmp38_ = _data_->data;
	_data_->_tmp38__length1 = _data_->data_length1;
	_data_->_tmp39_ = _data_->data;
	_data_->_tmp39__length1 = _data_->data_length1;
	g_variant_store (_data_->_tmp37_, _data_->_tmp38_ + ((gint) FOLKS_OBJECT_CACHE__HEADER_WIDTH));
	while (TRUE) {
		{
			_data_->_tmp40_ = _data_->self->priv->_cache_file;
			_data_->_tmp41_ = _data_->data;
			_data_->_tmp41__length1 = _data_->data_length1;
			_data_->_state_ = 1;
			g_file_replace_contents_async (_data_->_tmp40_, _data_->_tmp41_, (gsize) _data_->_tmp41__length1, NULL, FALSE, G_FILE_CREATE_PRIVATE, _data_->cancellable, folks_object_cache_store_objects_ready, _data_);
			return FALSE;
			_state_1:
			g_file_replace_contents_finish (_data_->_tmp40_, _data_->_res_, NULL, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			break;
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp42_ = _data_->e;
			if (g_error_matches (_data_->_tmp42_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				{
					_data_->_state_ = 2;
					_folks_object_cache_create_cache_directory (_data_->self, folks_object_cache_store_objects_ready, _data_);
					return FALSE;
					_state_2:
					_folks_object_cache_create_cache_directory_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
					_g_error_free0 (_data_->e);
					continue;
				}
				goto __finally1;
				__catch1_g_error:
				{
					g_clear_error (&_data_->_inner_error0_);
					_data_->_tmp43_ = _data_->self->priv->_cache_directory;
					_data_->_tmp44_ = g_file_get_path (_data_->_tmp43_);
					_data_->_tmp45_ = _data_->_tmp44_;
					_data_->_tmp46_ = _data_->e;
					_data_->_tmp47_ = _data_->_tmp46_->message;
					g_warning ("object-cache.vala:397: Couldn't create cache directory '%s': %s", _data_->_tmp45_, _data_->_tmp47_);
					_g_free0 (_data_->_tmp45_);
					_g_error_free0 (_data_->e);
					_data_->data = (g_free (_data_->data), NULL);
					_g_variant_type_free0 (_data_->desired_variant_type);
					_g_variant_unref0 (_data_->variant);
					_data_->children = (_vala_array_free (_data_->children, _data_->children_length1, (GDestroyNotify) g_variant_unref), NULL);
					_g_variant_type_free0 (_data_->child_type);
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				__finally1:
				_g_error_free0 (_data_->e);
				_data_->data = (g_free (_data_->data), NULL);
				_g_variant_type_free0 (_data_->desired_variant_type);
				_g_variant_unref0 (_data_->variant);
				_data_->children = (_vala_array_free (_data_->children, _data_->children_length1, (GDestroyNotify) g_variant_unref), NULL);
				_g_variant_type_free0 (_data_->child_type);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_data_->_tmp48_ = _data_->e;
				if (g_error_matches (_data_->_tmp48_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
					_g_error_free0 (_data_->e);
					_data_->data = (g_free (_data_->data), NULL);
					_g_variant_type_free0 (_data_->desired_variant_type);
					_g_variant_unref0 (_data_->variant);
					_data_->children = (_vala_array_free (_data_->children, _data_->children_length1, (GDestroyNotify) g_variant_unref), NULL);
					_g_variant_type_free0 (_data_->child_type);
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_data_->_tmp49_ = _data_->self->priv->_cache_file_path;
			_data_->_tmp50_ = _data_->e;
			_data_->_tmp51_ = _data_->_tmp50_->message;
			g_warning ("object-cache.vala:411: Couldn't write to cache file '%s', so deleting " \
"it: %s", _data_->_tmp49_, _data_->_tmp51_);
			_data_->_state_ = 3;
			folks_object_cache_clear_cache (_data_->self, folks_object_cache_store_objects_ready, _data_);
			return FALSE;
			_state_3:
			folks_object_cache_clear_cache_finish (_data_->self, _data_->_res_);
			_g_error_free0 (_data_->e);
			_data_->data = (g_free (_data_->data), NULL);
			_g_variant_type_free0 (_data_->desired_variant_type);
			_g_variant_unref0 (_data_->variant);
			_data_->children = (_vala_array_free (_data_->children, _data_->children_length1, (GDestroyNotify) g_variant_unref), NULL);
			_g_variant_type_free0 (_data_->child_type);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally0:
		_data_->data = (g_free (_data_->data), NULL);
		_g_variant_type_free0 (_data_->desired_variant_type);
		_g_variant_unref0 (_data_->variant);
		_data_->children = (_vala_array_free (_data_->children, _data_->children_length1, (GDestroyNotify) g_variant_unref), NULL);
		_g_variant_type_free0 (_data_->child_type);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->data = (g_free (_data_->data), NULL);
	_g_variant_type_free0 (_data_->desired_variant_type);
	_g_variant_unref0 (_data_->variant);
	_data_->children = (_vala_array_free (_data_->children, _data_->children_length1, (GDestroyNotify) g_variant_unref), NULL);
	_g_variant_type_free0 (_data_->child_type);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
folks_object_cache_clear_cache_data_free (gpointer _data)
{
	FolksObjectCacheClearCacheData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksObjectCacheClearCacheData, _data_);
}

void
folks_object_cache_clear_cache (FolksObjectCache* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	FolksObjectCacheClearCacheData* _data_;
	FolksObjectCache* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FolksObjectCacheClearCacheData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, folks_object_cache_clear_cache_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_object_cache_clear_cache_co (_data_);
}

void
folks_object_cache_clear_cache_finish (FolksObjectCache* self,
                                       GAsyncResult* _res_)
{
	FolksObjectCacheClearCacheData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
   * Clear this cache object, deleting its backing file.
   *
   * @since 0.6.0
   */
static gboolean
folks_object_cache_clear_cache_co (FolksObjectCacheClearCacheData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_type_id;
	_data_->_tmp1_ = _data_->self->priv->_id;
	_data_->_tmp2_ = _data_->self->priv->_cache_file_path;
	g_debug ("object-cache.vala:427: Clearing cache (type ID '%s', ID '%s'); deletin" \
"g file '%s'.", _data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_);
	{
		_data_->_tmp3_ = _data_->self->priv->_cache_file;
		g_file_delete (_data_->_tmp3_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GVariantType*
_folks_object_cache_get_cache_file_variant_type (FolksObjectCache* self,
                                                 guint8 wrapper_version,
                                                 guint8 object_version)
{
	GVariantType* _object_type = NULL;
	GVariantType* _tmp0_;
	const GVariantType* _tmp1_;
	GVariantType* object_type = NULL;
	const GVariantType* _tmp2_;
	GVariantType* _tmp3_;
	const GVariantType* _tmp4_;
	GVariantType* _tmp5_;
	const GVariantType* _tmp6_;
	GVariantType* _tmp7_;
	const GVariantType* _tmp8_;
	GVariantType* _tmp9_;
	GVariantType** _tmp10_;
	GVariantType** _tmp11_;
	gint _tmp11__length1;
	GVariantType* _tmp12_;
	GVariantType* _tmp13_;
	GVariantType* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = folks_object_cache_get_serialised_object_type (self, object_version);
	_object_type = _tmp0_;
	_tmp1_ = _object_type;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_variant_type_free0 (_object_type);
		return result;
	}
	_tmp2_ = _object_type;
	_tmp3_ = _g_variant_type_copy0 ((const GVariantType*) _tmp2_);
	object_type = _tmp3_;
	_tmp4_ = G_VARIANT_TYPE_STRING;
	_tmp5_ = _g_variant_type_copy0 (_tmp4_);
	_tmp6_ = G_VARIANT_TYPE_STRING;
	_tmp7_ = _g_variant_type_copy0 (_tmp6_);
	_tmp8_ = object_type;
	_tmp9_ = g_variant_type_new_array (_tmp8_);
	_tmp10_ = g_new0 (GVariantType*, 3 + 1);
	_tmp10_[0] = _tmp5_;
	_tmp10_[1] = _tmp7_;
	_tmp10_[2] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 3;
	_tmp12_ = g_variant_type_new_tuple (_tmp11_, 3);
	_tmp13_ = _tmp12_;
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_variant_type_free), NULL);
	result = _tmp13_;
	_g_variant_type_free0 (object_type);
	_g_variant_type_free0 (_object_type);
	return result;
}

static void
_folks_object_cache_create_cache_directory_data_free (gpointer _data)
{
	FolksObjectCacheCreateCacheDirectoryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksObjectCacheCreateCacheDirectoryData, _data_);
}

static void
_folks_object_cache_create_cache_directory (FolksObjectCache* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	FolksObjectCacheCreateCacheDirectoryData* _data_;
	FolksObjectCache* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FolksObjectCacheCreateCacheDirectoryData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, _folks_object_cache_create_cache_directory_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_folks_object_cache_create_cache_directory_co (_data_);
}

static void
_folks_object_cache_create_cache_directory_finish (FolksObjectCache* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	FolksObjectCacheCreateCacheDirectoryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
_folks_object_cache_create_cache_directory_co (FolksObjectCacheCreateCacheDirectoryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_cache_directory;
		g_file_make_directory_with_parents (_data_->_tmp0_, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp1_ = _data_->e;
		if (!g_error_matches (_data_->_tmp1_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			_data_->_tmp2_ = _data_->e;
			_data_->_tmp3_ = _g_error_copy0 (_data_->_tmp2_);
			_data_->_inner_error0_ = _data_->_tmp3_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

const gchar*
folks_object_cache_get_type_id (FolksObjectCache* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_type_id;
	result = _tmp0_;
	return result;
}

static void
folks_object_cache_set_type_id (FolksObjectCache* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = folks_object_cache_get_type_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_type_id);
		self->priv->_type_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, folks_object_cache_properties[FOLKS_OBJECT_CACHE_TYPE_ID_PROPERTY]);
	}
}

const gchar*
folks_object_cache_get_id (FolksObjectCache* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
folks_object_cache_set_id (FolksObjectCache* self,
                           const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_vala_assert (g_strcmp0 (value, "") != 0, "value != \"\"");
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, folks_object_cache_properties[FOLKS_OBJECT_CACHE_ID_PROPERTY]);
}

static GObject *
folks_object_cache_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FolksObjectCache * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	const gchar* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GFile* _tmp15_;
	gchar* path = NULL;
	GFile* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_;
	gchar* _tmp21_;
	parent_class = G_OBJECT_CLASS (folks_object_cache_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_OBJECT_CACHE, FolksObjectCache);
	_tmp0_ = self->priv->_type_id;
	_tmp1_ = folks_object_cache_get_id (self);
	_tmp2_ = _tmp1_;
	g_debug ("object-cache.vala:157: Creating object cache for type ID '%s' with ID " \
"'%s'.", _tmp0_, _tmp2_);
	_tmp3_ = g_get_user_cache_dir ();
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_get_child (_tmp5_, "folks");
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->_type_id;
	_tmp9_ = g_file_get_child (_tmp7_, _tmp8_);
	_g_object_unref0 (self->priv->_cache_directory);
	self->priv->_cache_directory = _tmp9_;
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	_tmp10_ = self->priv->_cache_directory;
	_tmp11_ = folks_object_cache_get_id (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_uri_escape_string (_tmp12_, "", FALSE);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_file_get_child (_tmp10_, _tmp14_);
	_g_object_unref0 (self->priv->_cache_file);
	self->priv->_cache_file = _tmp15_;
	_g_free0 (_tmp14_);
	_tmp16_ = self->priv->_cache_file;
	_tmp17_ = g_file_get_path (_tmp16_);
	path = _tmp17_;
	_tmp19_ = path;
	if (_tmp19_ != NULL) {
		const gchar* _tmp20_;
		_tmp20_ = path;
		_tmp18_ = (const gchar*) _tmp20_;
	} else {
		_tmp18_ = "(null)";
	}
	_tmp21_ = g_strdup (_tmp18_);
	_g_free0 (self->priv->_cache_file_path);
	self->priv->_cache_file_path = _tmp21_;
	_g_free0 (path);
	return obj;
}

static void
folks_object_cache_class_init (FolksObjectCacheClass * klass,
                               gpointer klass_data)
{
	folks_object_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksObjectCache_private_offset);
	((FolksObjectCacheClass *) klass)->get_serialised_object_type = (GVariantType* (*) (FolksObjectCache*, guint8)) folks_object_cache_real_get_serialised_object_type;
	((FolksObjectCacheClass *) klass)->get_serialised_object_version = (guint8 (*) (FolksObjectCache*)) folks_object_cache_real_get_serialised_object_version;
	((FolksObjectCacheClass *) klass)->serialise_object = (GVariant* (*) (FolksObjectCache*, gconstpointer)) folks_object_cache_real_serialise_object;
	((FolksObjectCacheClass *) klass)->deserialise_object = (gpointer (*) (FolksObjectCache*, GVariant*, guint8)) folks_object_cache_real_deserialise_object;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_object_cache_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_object_cache_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_object_cache_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_object_cache_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_OBJECT_CACHE_T_TYPE, g_param_spec_gtype ("t-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_OBJECT_CACHE_T_DUP_FUNC, g_param_spec_pointer ("t-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_OBJECT_CACHE_T_DESTROY_FUNC, g_param_spec_pointer ("t-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * A string identifying the type of object being cached.
	   *
	   * This has to be suitable for use as a directory name; i.e. lower case,
	   * hyphen-separated tokens.
	   *
	   * @since 0.6.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_OBJECT_CACHE_TYPE_ID_PROPERTY, folks_object_cache_properties[FOLKS_OBJECT_CACHE_TYPE_ID_PROPERTY] = g_param_spec_string ("type-id", "type-id", "type-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * A string identifying the particular cache instance.
	   *
	   * This will form the file name of the cache file, but will be escaped
	   * beforehand, so can be an arbitrary non-empty string.
	   *
	   * @since 0.6.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_OBJECT_CACHE_ID_PROPERTY, folks_object_cache_properties[FOLKS_OBJECT_CACHE_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
folks_object_cache_instance_init (FolksObjectCache * self,
                                  gpointer klass)
{
	self->priv = folks_object_cache_get_instance_private (self);
}

static void
folks_object_cache_finalize (GObject * obj)
{
	FolksObjectCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_OBJECT_CACHE, FolksObjectCache);
	_g_object_unref0 (self->priv->_cache_directory);
	_g_object_unref0 (self->priv->_cache_file);
	_g_free0 (self->priv->_cache_file_path);
	_g_free0 (self->priv->_type_id);
	_g_free0 (self->priv->_id);
	G_OBJECT_CLASS (folks_object_cache_parent_class)->finalize (obj);
}

/**
 * A generic abstract cache for sets of objects. This can be used by subclasses
 * to implement caching of homogeneous sets of objects. Subclasses simply have
 * to implement serialisation and deserialisation of the objects to and from
 * {@link GLib.Variant}s.
 *
 * It's intended that this class be used for providing caching layers for
 * {@link PersonaStore}s, for example.
 *
 * @since 0.6.0
 */
static GType
folks_object_cache_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksObjectCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_object_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksObjectCache), 0, (GInstanceInitFunc) folks_object_cache_instance_init, NULL };
	GType folks_object_cache_type_id;
	folks_object_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksObjectCache", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	FolksObjectCache_private_offset = g_type_add_instance_private (folks_object_cache_type_id, sizeof (FolksObjectCachePrivate));
	return folks_object_cache_type_id;
}

GType
folks_object_cache_get_type (void)
{
	static volatile gsize folks_object_cache_type_id__once = 0;
	if (g_once_init_enter (&folks_object_cache_type_id__once)) {
		GType folks_object_cache_type_id;
		folks_object_cache_type_id = folks_object_cache_get_type_once ();
		g_once_init_leave (&folks_object_cache_type_id__once, folks_object_cache_type_id);
	}
	return folks_object_cache_type_id__once;
}

static void
_vala_folks_object_cache_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	FolksObjectCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_OBJECT_CACHE, FolksObjectCache);
	switch (property_id) {
		case FOLKS_OBJECT_CACHE_TYPE_ID_PROPERTY:
		g_value_set_string (value, folks_object_cache_get_type_id (self));
		break;
		case FOLKS_OBJECT_CACHE_ID_PROPERTY:
		g_value_set_string (value, folks_object_cache_get_id (self));
		break;
		case FOLKS_OBJECT_CACHE_T_TYPE:
		g_value_set_gtype (value, self->priv->t_type);
		break;
		case FOLKS_OBJECT_CACHE_T_DUP_FUNC:
		g_value_set_pointer (value, self->priv->t_dup_func);
		break;
		case FOLKS_OBJECT_CACHE_T_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->t_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_object_cache_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	FolksObjectCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_OBJECT_CACHE, FolksObjectCache);
	switch (property_id) {
		case FOLKS_OBJECT_CACHE_TYPE_ID_PROPERTY:
		folks_object_cache_set_type_id (self, g_value_get_string (value));
		break;
		case FOLKS_OBJECT_CACHE_ID_PROPERTY:
		folks_object_cache_set_id (self, g_value_get_string (value));
		break;
		case FOLKS_OBJECT_CACHE_T_TYPE:
		self->priv->t_type = g_value_get_gtype (value);
		break;
		case FOLKS_OBJECT_CACHE_T_DUP_FUNC:
		self->priv->t_dup_func = g_value_get_pointer (value);
		break;
		case FOLKS_OBJECT_CACHE_T_DESTROY_FUNC:
		self->priv->t_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

