/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.spi.model.destination;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.Strings;
import org.opensearch.notifications.core.repackage.com.amazonaws.regions.Regions;
import org.opensearch.notifications.spi.model.destination.BaseDestination;
import org.opensearch.notifications.spi.model.destination.DestinationType;
import org.opensearch.notifications.spi.utils.ValidationHelpersKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/opensearch/notifications/spi/model/destination/SesDestination;", "Lorg/opensearch/notifications/spi/model/destination/BaseDestination;", "accountName", "", "awsRegion", "roleArn", "fromAddress", "recipient", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAccountName", "()Ljava/lang/String;", "getAwsRegion", "getFromAddress", "getRecipient", "getRoleArn", "opensearch-notifications-core-spi"})
public final class SesDestination
extends BaseDestination {
    @NotNull
    private final String accountName;
    @NotNull
    private final String awsRegion;
    @Nullable
    private final String roleArn;
    @NotNull
    private final String fromAddress;
    @NotNull
    private final String recipient;

    public SesDestination(@NotNull String accountName, @NotNull String awsRegion, @Nullable String roleArn, @NotNull String fromAddress, @NotNull String recipient) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)accountName, (String)"accountName");
            Intrinsics.checkNotNullParameter((Object)awsRegion, (String)"awsRegion");
            Intrinsics.checkNotNullParameter((Object)fromAddress, (String)"fromAddress");
            Intrinsics.checkNotNullParameter((Object)recipient, (String)"recipient");
            super(DestinationType.SES);
            this.accountName = accountName;
            this.awsRegion = awsRegion;
            this.roleArn = roleArn;
            this.fromAddress = fromAddress;
            this.recipient = recipient;
            if (!(!Strings.isNullOrEmpty((String)this.awsRegion))) {
                boolean $i$a$-require-SesDestination$22 = false;
                String $i$a$-require-SesDestination$22 = "aws region should be provided";
                throw new IllegalArgumentException($i$a$-require-SesDestination$22.toString());
            }
            Regions[] $this$any$iv = Regions.values();
            boolean $i$f$any = false;
            for (Regions element$iv : $this$any$iv) {
                Regions it = element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.getAwsRegion())) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "aws region is not valid";
            throw new IllegalArgumentException(string.toString());
        }
        ValidationHelpersKt.validateEmail(this.fromAddress);
        ValidationHelpersKt.validateEmail(this.recipient);
    }

    @NotNull
    public final String getAccountName() {
        return this.accountName;
    }

    @NotNull
    public final String getAwsRegion() {
        return this.awsRegion;
    }

    @Nullable
    public final String getRoleArn() {
        return this.roleArn;
    }

    @NotNull
    public final String getFromAddress() {
        return this.fromAddress;
    }

    @NotNull
    public final String getRecipient() {
        return this.recipient;
    }
}

