/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.freehep.util.io.ByteOrderOutputStream;

public class ByteCountOutputStream
extends ByteOrderOutputStream {
    private int currentBuffer = -1;
    private List<Buffer> bufferList = new ArrayList<Buffer>();

    public ByteCountOutputStream(OutputStream out, boolean littleEndian) {
        super(out, littleEndian);
    }

    protected final void writeSingleByte(int b) throws IOException {
        if (this.currentBuffer == -1) {
            super.writeSingleByte(b);
            return;
        }
        Buffer buffer = this.bufferList.get(this.currentBuffer);
        buffer.add((byte)b);
    }

    protected void writeByteArray(byte[] bytes, int offset, int length) throws IOException {
        if (this.currentBuffer == -1) {
            super.writeByteArray(bytes, offset, length);
            return;
        }
        Buffer buffer = this.bufferList.get(this.currentBuffer);
        buffer.add(bytes, offset, length);
    }

    public void pushBuffer() throws IOException {
        this.append();
        this.bufferList.add(new Buffer());
        ++this.currentBuffer;
    }

    public int popBuffer() throws IOException {
        if (this.currentBuffer >= 0) {
            this.append();
            int len = this.getBufferLength();
            --this.currentBuffer;
            return len;
        }
        return -1;
    }

    public byte[] popBufferBytes() throws IOException {
        int len = this.popBuffer();
        if (len >= 0) {
            Buffer buffer = this.bufferList.remove(this.currentBuffer + 1);
            return buffer.getBytes();
        }
        return new byte[0];
    }

    public int getBufferLength() {
        return this.currentBuffer >= 0 ? this.bufferList.get(this.currentBuffer).getLength() : -1;
    }

    public int getLength() {
        int length = 0;
        int i = 0;
        while (i < this.bufferList.size()) {
            length += this.bufferList.get(i).getLength();
            ++i;
        }
        return this.currentBuffer >= 0 ? length : -1;
    }

    public void append() throws IOException {
        super.byteAlign();
        if (this.currentBuffer + 1 >= this.bufferList.size()) {
            return;
        }
        Buffer append = this.bufferList.get(this.currentBuffer + 1);
        if (append.getLength() > 0) {
            if (this.currentBuffer >= 0) {
                this.bufferList.get(this.currentBuffer).add(append);
            } else {
                super.write(append.getBytes(), 0, append.getLength());
            }
        }
        this.bufferList.remove(this.currentBuffer + 1);
    }

    public void close() throws IOException {
        this.append();
        super.close();
    }

    static class Buffer {
        byte[] buffer = new byte[256];
        int len = 0;

        Buffer() {
        }

        void add(byte b) {
            if (this.len + 1 > this.buffer.length) {
                byte[] newBuffer = new byte[this.buffer.length << 1];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.len);
                this.buffer = newBuffer;
            }
            this.buffer[this.len] = b;
            ++this.len;
        }

        void add(byte[] bytes, int offset, int appendLength) {
            int needed = this.len + appendLength;
            if (needed > this.buffer.length) {
                byte[] newBuffer = new byte[needed];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.len);
                this.buffer = newBuffer;
            }
            System.arraycopy(bytes, offset, this.buffer, this.len, appendLength);
            this.len += appendLength;
        }

        void add(Buffer append) {
            int appendLength = append.getLength();
            int needed = this.len + appendLength;
            if (needed > this.buffer.length) {
                byte[] newBuffer = new byte[needed];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.len);
                this.buffer = newBuffer;
            }
            System.arraycopy(append.getBytes(), 0, this.buffer, this.len, appendLength);
            this.len += appendLength;
        }

        int getLength() {
            return this.len;
        }

        byte[] getBytes() {
            return this.buffer;
        }
    }
}

