/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class SetNationTypeMessage
extends AttributeMessage {
    public static final String TAG = "setNationType";
    private static final String PLAYER_TAG = "player";
    private static final String VALUE_TAG = "value";

    public SetNationTypeMessage(Player player, NationType nationType) {
        super(TAG, PLAYER_TAG, player == null ? null : player.getId(), VALUE_TAG, nationType.getId());
    }

    public SetNationTypeMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, PLAYER_TAG, VALUE_TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        NationType nationType = this.getValue(game.getSpecification());
        this.pgc(freeColClient).setNationTypeHandler(nationType);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        boolean ok;
        if (serverPlayer == null) {
            logger.warning("setNationType from unknown connection.");
            return null;
        }
        ServerGame game = freeColServer.getGame();
        Specification spec = game.getSpecification();
        NationType fixedNationType = spec.getNation(serverPlayer.getNationId()).getType();
        NationType nationType = this.getValue(spec);
        switch (game.getNationOptions().getNationalAdvantages()) {
            case SELECTABLE: {
                ok = true;
                break;
            }
            case FIXED: {
                ok = nationType.equals(fixedNationType);
                break;
            }
            case NONE: {
                ok = nationType == spec.getDefaultNationType();
                break;
            }
            default: {
                ok = false;
            }
        }
        if (!ok) {
            return serverPlayer.clientError((StringTemplate)StringTemplate.template("server.badNationType").addName("%nationType%", String.valueOf(nationType)));
        }
        return this.pgc(freeColServer).setNationType(serverPlayer, nationType);
    }

    public Player getPlayer(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(PLAYER_TAG), Player.class);
    }

    public NationType getValue(Specification spec) {
        return spec.getNationType(this.getStringAttribute(VALUE_TAG));
    }
}

