/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.Arrays;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Configuration;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.DirectedSubgraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphBridge;
import org.gephi.graph.api.GraphFactory;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphObserver;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Index;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Origin;
import org.gephi.graph.api.SpatialIndex;
import org.gephi.graph.api.Subgraph;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.TimeIndex;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.UndirectedGraph;
import org.gephi.graph.api.UndirectedSubgraph;
import org.gephi.graph.api.types.IntervalDoubleMap;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.TimestampDoubleMap;
import org.gephi.graph.api.types.TimestampSet;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.GraphBridgeImpl;
import org.gephi.graph.impl.GraphObserverImpl;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.GraphViewImpl;
import org.gephi.graph.impl.IndexStore;
import org.gephi.graph.impl.TableImpl;
import org.gephi.graph.impl.TimeIndexStore;
import org.gephi.graph.impl.TimeStore;
import org.joda.time.DateTimeZone;

public class GraphModelImpl
implements GraphModel {
    protected final Configuration configuration;
    protected final GraphStore store;
    protected final GraphBridgeImpl graphBridge;

    public GraphModelImpl() {
        this(new Configuration());
    }

    public GraphModelImpl(Configuration config) {
        this.checkValidConfiguration(config);
        this.configuration = config.copy();
        this.store = new GraphStore(this);
        this.graphBridge = new GraphBridgeImpl(this.store);
    }

    @Override
    public GraphFactory factory() {
        return this.store.factory;
    }

    @Override
    public GraphBridge bridge() {
        return this.graphBridge;
    }

    @Override
    public Graph getGraph() {
        return this.store;
    }

    @Override
    public Graph getGraphVisible() {
        return this.getGraph(this.store.viewStore.visibleView);
    }

    @Override
    public Subgraph getGraph(GraphView view) {
        if (this.store.isUndirected()) {
            return this.store.viewStore.getUndirectedGraph(view);
        }
        return this.store.viewStore.getDirectedGraph(view);
    }

    @Override
    public DirectedGraph getDirectedGraph() {
        return this.store;
    }

    @Override
    public DirectedGraph getDirectedGraphVisible() {
        return this.getDirectedGraph(this.store.viewStore.visibleView);
    }

    @Override
    public UndirectedGraph getUndirectedGraph() {
        return this.store.undirectedDecorator;
    }

    @Override
    public UndirectedGraph getUndirectedGraphVisible() {
        return this.getUndirectedGraph(this.store.viewStore.visibleView);
    }

    @Override
    public DirectedSubgraph getDirectedGraph(GraphView view) {
        return this.store.viewStore.getDirectedGraph(view);
    }

    @Override
    public UndirectedSubgraph getUndirectedGraph(GraphView view) {
        return this.store.viewStore.getUndirectedGraph(view);
    }

    @Override
    public GraphView getVisibleView() {
        return this.store.viewStore.getVisibleView();
    }

    @Override
    public void setVisibleView(GraphView view) {
        this.store.autoWriteLock();
        try {
            this.store.viewStore.setVisibleView(view);
        }
        finally {
            this.store.autoWriteUnlock();
        }
    }

    @Override
    public GraphModel.DefaultColumns defaultColumns() {
        return this.store.defaultColumns;
    }

    @Override
    public int addEdgeType(Object label) {
        this.store.autoWriteLock();
        try {
            int n = this.store.edgeTypeStore.addType(label);
            return n;
        }
        finally {
            this.store.autoWriteUnlock();
        }
    }

    @Override
    public int getEdgeType(Object label) {
        this.store.autoReadLock();
        try {
            int n = this.store.edgeTypeStore.getId(label);
            return n;
        }
        finally {
            this.store.autoReadUnlock();
        }
    }

    @Override
    public Object getEdgeTypeLabel(int id) {
        this.store.autoReadLock();
        try {
            Object object = this.store.edgeTypeStore.getLabel(id);
            return object;
        }
        finally {
            this.store.autoReadUnlock();
        }
    }

    @Override
    public int getEdgeTypeCount() {
        this.store.autoReadLock();
        try {
            int n = this.store.edgeTypeStore.size();
            return n;
        }
        finally {
            this.store.autoReadUnlock();
        }
    }

    @Override
    public Object[] getEdgeTypeLabels() {
        this.store.autoReadLock();
        try {
            Object[] objectArray = this.store.edgeTypeStore.getLabels();
            return objectArray;
        }
        finally {
            this.store.autoReadUnlock();
        }
    }

    @Override
    public Object[] getEdgeTypeLabels(boolean includeEmpty) {
        if (includeEmpty) {
            return this.getEdgeTypeLabels();
        }
        this.store.autoReadLock();
        try {
            Object[] objectArray = Arrays.stream(this.store.edgeTypeStore.getLabels()).filter(l -> this.store.getEdgeCount(this.store.edgeTypeStore.getId(l)) > 0).toArray();
            return objectArray;
        }
        finally {
            this.store.autoReadUnlock();
        }
    }

    @Override
    public int[] getEdgeTypes() {
        this.store.autoReadLock();
        try {
            int[] nArray = this.store.edgeTypeStore.getIdsAsInts();
            return nArray;
        }
        finally {
            this.store.autoReadUnlock();
        }
    }

    @Override
    public boolean isMultiGraph() {
        this.store.autoReadLock();
        try {
            boolean bl = this.store.edgeTypeStore.size() > 1;
            return bl;
        }
        finally {
            this.store.autoReadUnlock();
        }
    }

    @Override
    public boolean isDynamic() {
        this.store.autoReadLock();
        try {
            boolean bl = !this.store.timeStore.isEmpty();
            return bl;
        }
        finally {
            this.store.autoReadUnlock();
        }
    }

    @Override
    public boolean isDirected() {
        return this.store.isDirected();
    }

    @Override
    public boolean isUndirected() {
        return this.store.isUndirected();
    }

    @Override
    public boolean isMixed() {
        return this.store.isMixed();
    }

    @Override
    public GraphView createView() {
        return this.store.viewStore.createView();
    }

    @Override
    public GraphView createView(boolean node, boolean edge) {
        return this.store.viewStore.createView(node, edge);
    }

    @Override
    public GraphView copyView(GraphView view) {
        return this.store.viewStore.createView(view);
    }

    @Override
    public GraphView copyView(GraphView view, boolean node, boolean edge) {
        return this.store.viewStore.createView(view, node, edge);
    }

    @Override
    public void destroyView(GraphView view) {
        this.store.viewStore.destroyView(view);
    }

    @Override
    public void setTimeInterval(GraphView view, Interval interval) {
        this.store.viewStore.setTimeInterval(view, interval);
    }

    @Override
    public Table getNodeTable() {
        return this.store.nodeTable;
    }

    @Override
    public Table getEdgeTable() {
        return this.store.edgeTable;
    }

    public Index getNodeIndex() {
        return this.getNodeIndex(this.store.mainGraphView);
    }

    public Index getNodeIndex(GraphView view) {
        IndexStore indexStore = this.store.nodeTable.store.indexStore;
        if (indexStore != null) {
            if (view.isMainView()) {
                return indexStore.getIndex(this.store);
            }
            return indexStore.getIndex(((GraphViewImpl)view).directedDecorator);
        }
        return null;
    }

    @Override
    public Index<Element> getElementIndex(Table table) {
        return this.getElementIndex(table, this.store.mainGraphView);
    }

    @Override
    public Index<Element> getElementIndex(Table table, GraphView view) {
        if (table.isNodeTable()) {
            return this.getNodeIndex(view);
        }
        if (table.isEdgeTable()) {
            return this.getEdgeIndex(view);
        }
        return null;
    }

    public Index getEdgeIndex() {
        return this.getEdgeIndex(this.store.mainGraphView);
    }

    public Index getEdgeIndex(GraphView view) {
        IndexStore indexStore = this.store.edgeTable.store.indexStore;
        if (indexStore != null) {
            if (view.isMainView()) {
                return indexStore.getIndex(this.store);
            }
            return indexStore.getIndex(((GraphViewImpl)view).directedDecorator);
        }
        return null;
    }

    @Override
    public TimeIndex<Node> getNodeTimeIndex() {
        return this.getNodeTimeIndex(this.store.mainGraphView);
    }

    @Override
    public TimeIndex<Node> getNodeTimeIndex(GraphView view) {
        TimeIndexStore timeIndexStore = this.store.timeStore.nodeIndexStore;
        if (timeIndexStore != null) {
            if (view.isMainView()) {
                return timeIndexStore.getIndex(this.store);
            }
            return timeIndexStore.getIndex(((GraphViewImpl)view).directedDecorator);
        }
        return null;
    }

    @Override
    public TimeIndex<Edge> getEdgeTimeIndex() {
        return this.getEdgeTimeIndex(this.store.mainGraphView);
    }

    @Override
    public TimeIndex<Edge> getEdgeTimeIndex(GraphView view) {
        TimeIndexStore timeIndexStore = this.store.timeStore.edgeIndexStore;
        if (timeIndexStore != null) {
            if (view.isMainView()) {
                return timeIndexStore.getIndex(this.store);
            }
            return timeIndexStore.getIndex(((GraphViewImpl)view).directedDecorator);
        }
        return null;
    }

    @Override
    public SpatialIndex getSpatialIndex() {
        return this.store.spatialIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphObserver createGraphObserver(Graph graph, boolean withGraphDiff) {
        this.store.autoWriteLock();
        try {
            if (graph.getView().isMainView()) {
                GraphObserverImpl graphObserverImpl = this.store.createGraphObserver(graph, withGraphDiff);
                return graphObserverImpl;
            }
            GraphObserverImpl graphObserverImpl = this.store.viewStore.createGraphObserver(graph, withGraphDiff);
            return graphObserverImpl;
        }
        finally {
            this.store.autoWriteUnlock();
        }
    }

    @Override
    public TimeFormat getTimeFormat() {
        return this.store.timeFormat;
    }

    @Override
    public void setTimeFormat(TimeFormat timeFormat) {
        this.store.timeFormat = timeFormat;
    }

    @Override
    public DateTimeZone getTimeZone() {
        return this.store.timeZone;
    }

    @Override
    public void setTimeZone(DateTimeZone timeZone) {
        this.store.timeZone = timeZone;
    }

    @Override
    public Interval getTimeBounds() {
        return this.getTimeBounds(this.store.getView());
    }

    @Override
    public Interval getTimeBoundsVisible() {
        return this.getTimeBounds(this.getGraphVisible().getView());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Interval getTimeBounds(GraphView view) {
        TimeStore timeStore = this.store.timeStore;
        this.store.autoReadLock();
        try {
            double min = timeStore.getMin(this.getGraph(view));
            double max = timeStore.getMax(this.getGraph(view));
            Interval interval = new Interval(min, max);
            return interval;
        }
        finally {
            this.store.autoReadUnlock();
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConfiguration(Configuration config) {
        this.checkValidConfiguration(config);
        this.store.autoWriteLock();
        try {
            TableImpl<Edge> edgeTable;
            TableImpl<Node> nodeTable;
            if (this.store.getNodeCount() > 0 || !this.store.attributes.isEmpty() || this.store.nodeTable.countColumns() != 3 || this.store.edgeTable.countColumns() != 4 || this.store.edgeTypeStore.size() > 1) {
                throw new IllegalStateException("The store should be empty when modifying the configuration");
            }
            if (!config.getNodeIdType().equals(this.configuration.getNodeIdType())) {
                nodeTable = this.store.nodeTable;
                nodeTable.store.removeColumn("id");
                nodeTable.store.addColumn(new ColumnImpl(nodeTable, "id", config.getNodeIdType(), "Id", null, Origin.PROPERTY, false, true));
                this.configuration.setNodeIdType(config.getNodeIdType());
            }
            if (!config.getEdgeIdType().equals(this.configuration.getEdgeIdType())) {
                TableImpl<Edge> edgeTable2 = this.store.edgeTable;
                edgeTable2.store.removeColumn("id");
                edgeTable2.store.addColumn(new ColumnImpl(edgeTable2, "id", config.getEdgeIdType(), "Id", null, Origin.PROPERTY, false, true));
                this.configuration.setEdgeIdType(config.getEdgeIdType());
            }
            if (!config.getEdgeLabelType().equals(this.configuration.getEdgeLabelType())) {
                this.configuration.setEdgeLabelType(config.getEdgeLabelType());
            }
            if (!config.getTimeRepresentation().equals((Object)this.configuration.getTimeRepresentation())) {
                nodeTable = this.store.nodeTable;
                nodeTable.removeColumn("timeset");
                edgeTable = this.store.edgeTable;
                edgeTable.removeColumn("timeset");
                if (config.getTimeRepresentation().equals((Object)TimeRepresentation.TIMESTAMP)) {
                    nodeTable.store.addColumn(new ColumnImpl(nodeTable, "timeset", TimestampSet.class, "Timestamp", null, Origin.PROPERTY, false, false));
                    edgeTable.store.addColumn(new ColumnImpl(nodeTable, "timeset", TimestampSet.class, "Timestamp", null, Origin.PROPERTY, false, false));
                } else {
                    nodeTable.store.addColumn(new ColumnImpl(nodeTable, "timeset", IntervalSet.class, "Interval", null, Origin.PROPERTY, false, false));
                    edgeTable.store.addColumn(new ColumnImpl(nodeTable, "timeset", IntervalSet.class, "Interval", null, Origin.PROPERTY, false, false));
                }
                this.configuration.setTimeRepresentation(config.getTimeRepresentation());
                this.store.timeStore.resetConfiguration();
            }
            boolean edgeWeightIndexed = AttributeUtils.isSimpleType(config.getEdgeWeightType());
            if (!config.getEdgeWeightColumn().equals(this.configuration.getEdgeWeightColumn())) {
                edgeTable = this.store.edgeTable;
                if (config.getEdgeWeightColumn().booleanValue()) {
                    edgeTable.store.garbageQueue.add(edgeTable.store.intToShort(3));
                    edgeTable.store.addColumn(new ColumnImpl(edgeTable, "weight", config.getEdgeWeightType(), "Weight", null, Origin.PROPERTY, edgeWeightIndexed, false));
                } else {
                    edgeTable.removeColumn("weight");
                    edgeTable.store.garbageQueue.remove(edgeTable.store.intToShort(3));
                }
            }
            if (!config.getEdgeWeightType().equals(this.configuration.getEdgeWeightType())) {
                edgeTable = this.store.edgeTable;
                Class newWeightType = config.getEdgeWeightType();
                if (config.getEdgeWeightColumn().booleanValue()) {
                    edgeTable.removeColumn("weight");
                    edgeTable.store.addColumn(new ColumnImpl(edgeTable, "weight", newWeightType, "Weight", null, Origin.PROPERTY, edgeWeightIndexed, false));
                }
                this.configuration.setEdgeWeightType(newWeightType);
            }
            this.store.factory.resetConfiguration();
            this.store.defaultColumns.resetConfiguration();
        }
        finally {
            this.store.autoWriteUnlock();
        }
    }

    @Override
    public int getMaxEdgeStoreId() {
        return this.store.edgeStore.maxStoreId();
    }

    @Override
    public int getMaxNodeStoreId() {
        return this.store.nodeStore.maxStoreId();
    }

    public void destroyGraphObserver(GraphObserver observer) {
        this.checkGraphObserver(observer);
        this.store.autoWriteLock();
        try {
            if (observer.getGraph().getView().isMainView()) {
                this.store.destroyGraphObserver((GraphObserverImpl)observer);
            } else {
                this.store.viewStore.destroyGraphObserver((GraphObserverImpl)observer);
            }
        }
        finally {
            this.store.autoWriteUnlock();
        }
    }

    public GraphStore getStore() {
        return this.store;
    }

    public boolean deepEquals(GraphModelImpl obj) {
        if (obj == null) {
            return false;
        }
        if (!(this.store == obj.store || this.store != null && this.store.deepEquals(obj.store))) {
            return false;
        }
        return this.configuration == obj.configuration || this.configuration != null && this.configuration.equals(obj.configuration);
    }

    private void checkGraphObserver(GraphObserver observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        if (!(observer instanceof GraphObserverImpl)) {
            throw new ClassCastException("The observer should be a GraphObserverImpl instance");
        }
        if (((GraphObserverImpl)observer).graphStore != this.store) {
            throw new RuntimeException("The observer doesn't belong to this store");
        }
    }

    private void checkValidConfiguration(Configuration config) {
        Class edgeWeightType = config.getEdgeWeightType();
        if (edgeWeightType.equals(Double.class)) {
            return;
        }
        switch (config.getTimeRepresentation()) {
            case INTERVAL: {
                if (edgeWeightType.equals(IntervalDoubleMap.class)) break;
                throw new IllegalArgumentException("Edge weight type should be Double or IntervalDoubleMap for INTERVAL TimeRepresentation");
            }
            case TIMESTAMP: {
                if (edgeWeightType.equals(TimestampDoubleMap.class)) break;
                throw new IllegalArgumentException("Edge weight type should be Double or TimestampDoubleMap for TIMESTAMP TimeRepresentation");
            }
        }
    }
}

