/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ArrayableClassElement;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.WildcardElement;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@Internal
final class GroovyWildcardElement
extends GroovyClassElement
implements WildcardElement {
    private final List<GroovyClassElement> upperBounds;
    private final List<GroovyClassElement> lowerBounds;

    GroovyWildcardElement(@NonNull List<GroovyClassElement> upperBounds, @NonNull List<GroovyClassElement> lowerBounds) {
        super(upperBounds.get((int)0).visitorContext, upperBounds.get((int)0).classNode, upperBounds.get(0).getAnnotationMetadata(), upperBounds.get(0).getGenericTypeInfo(), 0);
        this.upperBounds = upperBounds;
        this.lowerBounds = lowerBounds;
    }

    @NonNull
    public List<? extends ClassElement> getUpperBounds() {
        return this.upperBounds;
    }

    @NonNull
    public List<? extends ClassElement> getLowerBounds() {
        return this.lowerBounds;
    }

    @Override
    public ClassElement withArrayDimensions(int arrayDimensions) {
        if (arrayDimensions != 0) {
            throw new UnsupportedOperationException("Can't create array of wildcard");
        }
        return this;
    }

    public ClassElement foldBoundGenericTypes(@NonNull Function<ClassElement, ClassElement> fold) {
        List<GroovyClassElement> upperBounds = this.upperBounds.stream().map(ele -> this.toGroovyClassElement(ele.foldBoundGenericTypes(fold))).collect(Collectors.toList());
        List<GroovyClassElement> lowerBounds = this.lowerBounds.stream().map(ele -> this.toGroovyClassElement(ele.foldBoundGenericTypes(fold))).collect(Collectors.toList());
        return fold.apply((ClassElement)(upperBounds.contains(null) || lowerBounds.contains(null) ? null : new GroovyWildcardElement(upperBounds, lowerBounds)));
    }

    private GroovyClassElement toGroovyClassElement(ClassElement element) {
        if (element == null || element instanceof GroovyClassElement) {
            return (GroovyClassElement)element;
        }
        if (element.isWildcard() || element.isGenericPlaceholder()) {
            throw new UnsupportedOperationException("Cannot convert wildcard / free type variable to GroovyClassElement");
        }
        return (GroovyClassElement)((ArrayableClassElement)this.visitorContext.getClassElement(element.getName()).orElseThrow(() -> new UnsupportedOperationException("Cannot convert ClassElement to GroovyClassElement, class was not found on the visitor context"))).withArrayDimensions(element.getArrayDimensions()).withBoundGenericTypes(element.getBoundGenericTypes());
    }
}

