/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.c.PAL;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class ColorEncoder {
    private Viewer vwr;
    private static final int GRAY = -8355712;
    public static final String BYELEMENT_PREFIX = "byelement";
    public static final String BYRESIDUE_PREFIX = "byresidue";
    private static final String BYELEMENT_JMOL = "byelement_jmol";
    private static final String BYELEMENT_RASMOL = "byelement_rasmol";
    private static final String BYRESIDUE_SHAPELY = "byresidue_shapely";
    private static final String BYRESIDUE_AMINO = "byresidue_amino";
    private static final String BYRESIDUE_NUCLEIC = "byresidue_nucleic";
    public static final int CUSTOM = -1;
    public static final int ROYGB = 0;
    public static final int BGYOR = 1;
    public static final int JMOL = 2;
    public static final int RASMOL = 3;
    public static final int SHAPELY = 4;
    public static final int AMINO = 5;
    public static final int RWB = 6;
    public static final int BWR = 7;
    public static final int LOW = 8;
    public static final int HIGH = 9;
    public static final int BW = 10;
    public static final int WB = 11;
    public static final int FRIENDLY = 12;
    public static final int USER = -13;
    public static final int RESU = -14;
    public static final int INHERIT = 15;
    public static final int ALT = 16;
    public static final int NUCLEIC = 17;
    private static final String[] colorSchemes = new String[]{"roygb", "bgyor", "byelement_jmol", "byelement_rasmol", "byresidue_shapely", "byresidue_amino", "rwb", "bwr", "low", "high", "bw", "wb", "friendly", "user", "resu", "inherit", "rgb", "bgr", "jmol", "rasmol", "byresidue", "byresidue_nucleic"};
    private int[] paletteBW;
    private int[] paletteWB;
    private int[] paletteFriendly;
    private int[] argbsCpk;
    private int[] argbsRoygb;
    private int[] argbsRwb;
    private int[] argbsShapely;
    private int[] argbsAmino;
    private int[] argbsNucleic;
    private int ihalf;
    private static int[] rasmolScale;
    public Map<String, int[]> schemes;
    public int currentPalette = 0;
    public int currentSegmentCount = 1;
    public boolean isTranslucent = false;
    public float lo;
    public float hi;
    public boolean isReversed;
    int[] userScale = new int[]{-8355712};
    int[] thisScale = new int[]{-8355712};
    String thisName = "scheme";
    boolean isColorIndex;
    ColorEncoder ce;
    public static int[] argbsChainAtom;
    public static int[] argbsChainHetero;

    public ColorEncoder(ColorEncoder ce, Viewer vwr) {
        if (ce == null) {
            this.vwr = vwr;
            this.schemes = new Hashtable<String, int[]>();
            this.argbsCpk = PAL.argbsCpk;
            this.argbsRoygb = JC.argbsRoygbScale;
            this.argbsRwb = JC.argbsRwbScale;
            this.argbsShapely = null;
            this.argbsNucleic = null;
            this.argbsAmino = null;
            this.ihalf = JC.argbsRoygbScale.length / 3;
            this.ce = this;
        } else {
            this.ce = ce;
            this.vwr = ce.vwr;
            this.schemes = ce.schemes;
        }
    }

    public void clearCache() {
        this.schemes.clear();
    }

    private static final int getSchemeIndex(String colorScheme) {
        for (int i = 0; i < colorSchemes.length; ++i) {
            if (!colorSchemes[i].equalsIgnoreCase(colorScheme)) continue;
            return i >= 16 ? i - 16 : (i < 13 ? i : -i);
        }
        return -1;
    }

    private static final String fixName(String name) {
        if (name.equalsIgnoreCase(BYELEMENT_PREFIX)) {
            return BYELEMENT_JMOL;
        }
        int ipt = ColorEncoder.getSchemeIndex(name);
        return ipt >= 0 ? colorSchemes[ipt] : (name.indexOf("/") >= 0 ? name : name.toLowerCase());
    }

    private synchronized int makeColorScheme(String name, int[] scale, boolean isOverloaded) {
        name = ColorEncoder.fixName(name);
        if (scale == null) {
            this.schemes.remove(name);
            int iScheme = this.createColorScheme(name, false, isOverloaded);
            if (isOverloaded) {
                switch (iScheme) {
                    case 0x7FFFFFFF: {
                        return 0;
                    }
                    case 12: {
                        this.paletteFriendly = this.getPaletteAC();
                        break;
                    }
                    case 10: {
                        this.paletteBW = this.getPaletteBW();
                        break;
                    }
                    case 11: {
                        this.paletteWB = this.getPaletteWB();
                        break;
                    }
                    case 0: 
                    case 1: {
                        this.argbsRoygb = JC.argbsRoygbScale;
                        break;
                    }
                    case 6: 
                    case 7: {
                        this.argbsRwb = JC.argbsRwbScale;
                        break;
                    }
                    case 2: {
                        this.argbsCpk = PAL.argbsCpk;
                        break;
                    }
                    case 3: {
                        ColorEncoder.getRasmolScale();
                        break;
                    }
                    case 17: {
                        this.getNucleic();
                        break;
                    }
                    case 5: {
                        this.getAmino();
                        break;
                    }
                    case 4: {
                        this.getShapely();
                    }
                }
            }
            return iScheme;
        }
        this.schemes.put(name, scale);
        this.setThisScheme(name, scale);
        int iScheme = this.createColorScheme(name, false, isOverloaded);
        if (isOverloaded) {
            switch (iScheme) {
                case 10: {
                    this.paletteBW = this.thisScale;
                    break;
                }
                case 11: {
                    this.paletteWB = this.thisScale;
                    break;
                }
                case 0: 
                case 1: {
                    this.argbsRoygb = this.thisScale;
                    this.ihalf = this.argbsRoygb.length / 3;
                    break;
                }
                case 6: 
                case 7: {
                    this.argbsRwb = this.thisScale;
                    break;
                }
                case 2: {
                    this.argbsCpk = this.thisScale;
                    break;
                }
                case 3: {
                    break;
                }
                case 5: {
                    this.argbsAmino = this.thisScale;
                    break;
                }
                case 17: {
                    this.argbsNucleic = this.thisScale;
                    break;
                }
                case 4: {
                    this.argbsShapely = this.thisScale;
                }
            }
        }
        return -1;
    }

    private int[] getShapely() {
        return this.argbsShapely == null ? (this.argbsShapely = this.vwr.getJBR().getArgbs(0x40000140)) : this.argbsShapely;
    }

    private int[] getAmino() {
        return this.argbsAmino == null ? (this.argbsAmino = this.vwr.getJBR().getArgbs(0x200002)) : this.argbsAmino;
    }

    private int[] getNucleic() {
        return this.argbsNucleic == null ? (this.argbsNucleic = this.vwr.getJBR().getArgbs(0x20000E)) : this.argbsNucleic;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int createColorScheme(String colorScheme, boolean defaultToRoygb, boolean isOverloaded) {
        int n;
        if (colorScheme.equalsIgnoreCase("inherit")) {
            return 15;
        }
        int pte = colorScheme.lastIndexOf("=");
        int pts = colorScheme.indexOf("/");
        int pt = Math.max(pte, colorScheme.indexOf("["));
        String name = ColorEncoder.fixName(colorScheme);
        int ipt = ColorEncoder.getSchemeIndex(name);
        if (ipt == -1 && (pt < 0 || pts > 0)) {
            int[] scale;
            block35: {
                String s = colorScheme;
                scale = this.schemes.get(name);
                if (scale == null) {
                    try {
                        int n2;
                        int i;
                        boolean isNot;
                        boolean bl = isNot = s.charAt(1) == '~';
                        if (isNot) {
                            s = s.substring(1);
                        }
                        byte[] b = null;
                        if (s.indexOf("/") < 0) {
                            if (s.indexOf(".") < 0) {
                                s = s + ".lut.txt";
                            }
                            String[] data = new String[1];
                            try {
                                Logger.info("ColorEncoder opening colorschemes/" + s);
                                Rdr.readAllAsString(FileManager.getBufferedReaderForResource(this.vwr, new C(), "org/jmol/util/", "colorschemes/" + s), -1, false, data, 0);
                            }
                            catch (IOException e) {
                                Logger.info("ColorEncoder " + e);
                                break block35;
                            }
                            s = data[0];
                        } else {
                            s = PT.rep(s, " ", "%20");
                            Logger.info("ColorEncoder opening " + s);
                            Object o = this.vwr.fm.getFileAsBytes(s, null);
                            if (o instanceof String) {
                                Logger.info("ColorEncoder " + o);
                                break block35;
                            }
                            b = (byte[])o;
                            Logger.info("ColorEncoder read " + b.length + " bytes");
                            int i0 = 0;
                            int n3 = b.length;
                            if (n3 == 800 || n3 == 802) {
                                i0 = 32;
                            }
                            if (n3 - i0 == 768 || n3 - i0 == 770) {
                                scale = new int[256];
                                n3 = 256 + i0;
                                for (i = 0; i < 256; ++i) {
                                    scale[i] = CU.rgb(b[i + i0] & 0xFF, b[i + i0 + 256] & 0xFF, b[i + i0 + 512] & 0xFF);
                                }
                            } else {
                                s = new String(b);
                            }
                        }
                        if (scale == null) {
                            String[] lines = PT.split(s.trim(), "\n");
                            n2 = lines.length;
                            scale = new int[n2];
                            boolean isInt = n2 > 0 && lines[0].indexOf(".") < 0;
                            for (i = 0; i < n2; ++i) {
                                String[] tokens = PT.getTokens(lines[i]);
                                if (tokens.length < 3) {
                                    scale = null;
                                    break;
                                }
                                int len = tokens.length;
                                scale[i] = isInt ? CU.rgb(PT.parseInt(tokens[len - 3]), PT.parseInt(tokens[len - 2]), PT.parseInt(tokens[len - 1])) : CU.colorTriadToFFRGB(PT.parseFloat(tokens[len - 3]), PT.parseFloat(tokens[len - 2]), PT.parseFloat(tokens[len - 1]));
                            }
                        }
                        if (scale != null && isNot) {
                            n2 = scale.length - 1;
                            int n22 = n2 + 1 >> 1;
                            for (int i2 = 0; i2 < n22; ++i2) {
                                int v = scale[i2];
                                scale[i2] = scale[n2 - i2];
                                scale[n2 - i2] = v;
                            }
                        }
                    }
                    catch (Exception e) {
                        Logger.info("ColorEncoder " + e);
                        scale = null;
                    }
                }
            }
            if (scale == null) {
                scale = new int[]{-1};
            }
            this.schemes.put(colorScheme, scale);
            this.setThisScheme(colorScheme, scale);
            return -1;
        }
        if (pt >= 0) {
            name = PT.replaceAllCharacters((colorScheme = colorScheme.toLowerCase()).substring(0, pt), " =", "");
            if (name.length() > 0) {
                isOverloaded = true;
            }
            n = 0;
            if (colorScheme.length() > pt + 1 && !colorScheme.contains("[")) {
                colorScheme = "[" + colorScheme.substring(pt + 1).trim() + "]";
                colorScheme = PT.rep(colorScheme.replace('\n', ' '), "  ", " ");
                colorScheme = PT.rep(colorScheme, ", ", ",").replace(' ', ',');
                colorScheme = PT.rep(colorScheme, ",", "][");
            }
            pt = -1;
            while ((pt = colorScheme.indexOf("[", pt + 1)) >= 0) {
                ++n;
            }
            if (n == 0) {
                return this.makeColorScheme(name, null, isOverloaded);
            }
        } else {
            int[] scale = this.schemes.get(name);
            if (scale != null) {
                this.setThisScheme(name, scale);
                return ipt;
            }
            if (ipt != -1) {
                int n4 = ipt;
                return n4;
            }
            if (!defaultToRoygb) return Integer.MAX_VALUE;
            return 0;
        }
        int[] scale = new int[n];
        n = 0;
        while (true) {
            int c;
            if ((pt = colorScheme.indexOf("[", pt + 1)) < 0) {
                if (!name.equals("user")) return this.makeColorScheme(name, scale, isOverloaded);
                this.setUserScale(scale);
                return -13;
            }
            int pt2 = colorScheme.indexOf("]", pt);
            if (pt2 < 0) {
                pt2 = colorScheme.length() - 1;
            }
            if ((c = CU.getArgbFromString(colorScheme.substring(pt, pt2 + 1))) == 0) {
                c = CU.getArgbFromString(colorScheme.substring(pt + 1, pt2).trim());
            }
            if (c == 0) {
                Logger.error("error in color value: " + colorScheme.substring(pt, pt2 + 1));
                return 0;
            }
            scale[n++] = c;
        }
    }

    public void setUserScale(int[] scale) {
        this.ce.userScale = scale;
        this.makeColorScheme("user", scale, false);
    }

    public int[] getColorSchemeArray(int palette) {
        switch (palette) {
            case -1: {
                return this.thisScale;
            }
            case 0: {
                return this.ce.argbsRoygb;
            }
            case 1: {
                return AU.arrayCopyRangeRevI(this.ce.argbsRoygb, 0, -1);
            }
            case 8: {
                return AU.arrayCopyRangeI(this.ce.argbsRoygb, 0, this.ce.ihalf);
            }
            case 9: {
                int[] a = AU.arrayCopyRangeI(this.ce.argbsRoygb, this.ce.argbsRoygb.length - 2 * this.ce.ihalf, -1);
                int[] b = new int[this.ce.ihalf];
                int i = b.length;
                int j = a.length;
                while (--i >= 0 && --j >= 0) {
                    b[i] = a[j--];
                }
                return b;
            }
            case 12: {
                return this.getPaletteAC();
            }
            case 10: {
                return this.getPaletteBW();
            }
            case 11: {
                return this.getPaletteWB();
            }
            case 6: {
                return this.ce.argbsRwb;
            }
            case 7: {
                return AU.arrayCopyRangeRevI(this.ce.argbsRwb, 0, -1);
            }
            case 2: {
                return this.ce.argbsCpk;
            }
            case 3: {
                return ColorEncoder.getRasmolScale();
            }
            case 4: {
                return this.ce.getShapely();
            }
            case 17: {
                return this.ce.getNucleic();
            }
            case 5: {
                return this.ce.getAmino();
            }
            case -13: {
                return this.ce.userScale;
            }
            case -14: {
                return AU.arrayCopyRangeRevI(this.ce.userScale, 0, -1);
            }
        }
        return null;
    }

    public short getColorIndexFromPalette(float val, float lo, float hi, int palette, boolean isTranslucent) {
        short colix = C.getColix(this.getArgbFromPalette(val, lo, hi, palette));
        if (isTranslucent) {
            float f = (hi - val) / (hi - lo);
            if (f > 1.0f) {
                f = 1.0f;
            } else if (f < 0.125f) {
                f = 0.125f;
            }
            colix = C.getColixTranslucent3(colix, true, f);
        }
        return colix;
    }

    private int getPaletteColorCount(int palette) {
        switch (palette) {
            case -1: {
                return this.thisScale.length;
            }
            case 10: 
            case 11: {
                return this.getPaletteBW().length;
            }
            case 0: 
            case 1: {
                return this.ce.argbsRoygb.length;
            }
            case 8: 
            case 9: {
                return this.ce.ihalf;
            }
            case 6: 
            case 7: {
                return this.ce.argbsRwb.length;
            }
            case -14: 
            case -13: {
                return this.ce.userScale.length;
            }
            case 2: {
                return this.ce.argbsCpk.length;
            }
            case 3: {
                return ColorEncoder.getRasmolScale().length;
            }
            case 4: {
                return this.ce.getShapely().length;
            }
            case 17: {
                return this.ce.getNucleic().length;
            }
            case 5: {
                return this.ce.getAmino().length;
            }
            case 12: {
                return this.getPaletteAC().length;
            }
        }
        return 0;
    }

    public int getArgbFromPalette(float val, float lo, float hi, int palette) {
        if (Float.isNaN(val)) {
            return -8355712;
        }
        int n = this.getPaletteColorCount(palette);
        switch (palette) {
            case -1: {
                if (this.isColorIndex) {
                    lo = 0.0f;
                    hi = this.thisScale.length;
                }
                return this.thisScale[ColorEncoder.quantize4(val, lo, hi, n)];
            }
            case 10: {
                return this.getPaletteBW()[ColorEncoder.quantize4(val, lo, hi, n)];
            }
            case 11: {
                return this.getPaletteWB()[ColorEncoder.quantize4(val, lo, hi, n)];
            }
            case 0: {
                return this.ce.argbsRoygb[ColorEncoder.quantize4(val, lo, hi, n)];
            }
            case 1: {
                return this.ce.argbsRoygb[ColorEncoder.quantize4(-val, -hi, -lo, n)];
            }
            case 8: {
                return this.ce.argbsRoygb[ColorEncoder.quantize4(val, lo, hi, n)];
            }
            case 9: {
                return this.ce.argbsRoygb[this.ce.ihalf + ColorEncoder.quantize4(val, lo, hi, n) * 2];
            }
            case 6: {
                return this.ce.argbsRwb[ColorEncoder.quantize4(val, lo, hi, n)];
            }
            case 7: {
                return this.ce.argbsRwb[ColorEncoder.quantize4(-val, -hi, -lo, n)];
            }
            case -13: {
                return this.ce.userScale.length == 0 ? -8355712 : this.ce.userScale[ColorEncoder.quantize4(val, lo, hi, n)];
            }
            case -14: {
                return this.ce.userScale.length == 0 ? -8355712 : this.ce.userScale[ColorEncoder.quantize4(-val, -hi, -lo, n)];
            }
            case 2: {
                return this.ce.argbsCpk[ColorEncoder.colorIndex(val, n)];
            }
            case 3: {
                return ColorEncoder.getRasmolScale()[ColorEncoder.colorIndex(val, n)];
            }
            case 4: {
                return this.ce.getShapely()[ColorEncoder.colorIndex(val, n)];
            }
            case 5: {
                return this.ce.getAmino()[ColorEncoder.colorIndex(val, n)];
            }
            case 17: {
                return this.ce.getNucleic()[ColorEncoder.colorIndex(val - 24.0f + 2.0f, n)];
            }
            case 12: {
                return this.getPaletteAC()[ColorEncoder.colorIndexRepeat(val, n)];
            }
        }
        return -8355712;
    }

    private void setThisScheme(String name, int[] scale) {
        this.thisName = name;
        this.thisScale = scale;
        if (name.equals("user")) {
            this.userScale = scale;
        }
        this.isColorIndex = name.indexOf(BYELEMENT_PREFIX) == 0 || name.indexOf(BYRESIDUE_PREFIX) == 0;
    }

    public int getArgb(float val) {
        return this.isReversed ? this.getArgbFromPalette(-val, -this.hi, -this.lo, this.currentPalette) : this.getArgbFromPalette(val, this.lo, this.hi, this.currentPalette);
    }

    public int getArgbMinMax(float val, float min, float max) {
        return this.isReversed ? this.getArgbFromPalette(-val, -max, -min, this.currentPalette) : this.getArgbFromPalette(val, min, max, this.currentPalette);
    }

    public short getColorIndex(float val) {
        return this.isReversed ? this.getColorIndexFromPalette(-val, -this.hi, -this.lo, this.currentPalette, this.isTranslucent) : this.getColorIndexFromPalette(val, this.lo, this.hi, this.currentPalette, this.isTranslucent);
    }

    public Map<String, Object> getColorKey() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        int segmentCount = this.getPaletteColorCount(this.currentPalette);
        Lst<P3> colors = new Lst<P3>();
        float[] values = new float[segmentCount + 1];
        float quantum = (this.hi - this.lo) / (float)segmentCount;
        float f = quantum * (this.isReversed ? -0.5f : 0.5f);
        for (int i = 0; i < segmentCount; ++i) {
            values[i] = this.isReversed ? this.hi - (float)i * quantum : this.lo + (float)i * quantum;
            colors.addLast(CU.colorPtFromInt(this.getArgb(values[i] + f), null));
        }
        values[segmentCount] = this.isReversed ? this.lo : this.hi;
        info.put("values", values);
        info.put("colors", colors);
        info.put("min", Float.valueOf(this.lo));
        info.put("max", Float.valueOf(this.hi));
        info.put("reversed", this.isReversed);
        info.put("name", this.getCurrentColorSchemeName());
        return info;
    }

    public String getColorScheme() {
        return (this.isTranslucent ? "translucent " : "") + (this.currentPalette < 0 ? ColorEncoder.getColorSchemeList(this.getColorSchemeArray(this.currentPalette)) : this.getColorSchemeName(this.currentPalette));
    }

    public void setColorScheme(String colorScheme, boolean isTranslucent) {
        this.isTranslucent = isTranslucent;
        if (colorScheme != null) {
            this.currentPalette = this.createColorScheme(colorScheme, true, false);
        }
    }

    public void setRange(float lo, float hi, boolean isReversed) {
        if (hi == Float.MAX_VALUE) {
            lo = 1.0f;
            hi = this.getPaletteColorCount(this.currentPalette) + 1;
        }
        this.lo = Math.min(lo, hi);
        this.hi = Math.max(lo, hi);
        this.isReversed = isReversed;
    }

    public String getCurrentColorSchemeName() {
        return this.getColorSchemeName(this.currentPalette);
    }

    public String getColorSchemeName(int i) {
        int absi = Math.abs(i);
        return i == -1 ? this.thisName : (absi < colorSchemes.length && absi >= 0 ? colorSchemes[absi] : null);
    }

    public static final String getColorSchemeList(int[] scheme) {
        if (scheme == null) {
            return "";
        }
        String colors = "";
        for (int i = 0; i < scheme.length; ++i) {
            colors = colors + (i == 0 ? "" : " ") + Escape.escapeColor(scheme[i]);
        }
        return colors;
    }

    public static final synchronized int[] getRasmolScale() {
        if (rasmolScale != null) {
            return rasmolScale;
        }
        rasmolScale = new int[PAL.argbsCpk.length];
        int argb = PAL.argbsCpkRasmol[0] | 0xFF000000;
        int i = rasmolScale.length;
        while (--i >= 0) {
            ColorEncoder.rasmolScale[i] = argb;
        }
        i = PAL.argbsCpkRasmol.length;
        while (--i >= 0) {
            argb = PAL.argbsCpkRasmol[i];
            ColorEncoder.rasmolScale[argb >> 24] = argb | 0xFF000000;
        }
        return rasmolScale;
    }

    private int[] getPaletteAC() {
        return this.ce.paletteFriendly == null ? (this.ce.paletteFriendly = new int[]{0x808080, 1067945, 0xAA00A2, 13235712, 16753152, 2640510, 8331387, 10467374, 12553008, 339310, 7209065, 8626176, 0xA66A00, 4488148, 13907405, 14219839, 16759360, 6984660, 13918415, 14809713, 16764019}) : this.ce.paletteFriendly;
    }

    private int[] getPaletteWB() {
        if (this.ce.paletteWB != null) {
            return this.ce.paletteWB;
        }
        int[] b = new int[JC.argbsRoygbScale.length];
        for (int i = 0; i < b.length; ++i) {
            float xff = 1.0f / (float)b.length * (float)(b.length - i);
            b[i] = CU.colorTriadToFFRGB(xff, xff, xff);
        }
        this.ce.paletteWB = b;
        return b;
    }

    public static int[] getPaletteAtoB(int color1, int color2, int n) {
        if (n < 2) {
            n = JC.argbsRoygbScale.length;
        }
        int[] b = new int[n];
        float[] rgb1 = new float[3];
        float[] rgb2 = new float[3];
        CU.toRGB3f(color1, rgb1);
        CU.toRGB3f(color2, rgb2);
        float dr = (rgb2[0] - rgb1[0]) / (float)(n - 1);
        float dg = (rgb2[1] - rgb1[1]) / (float)(n - 1);
        float db = (rgb2[2] - rgb1[2]) / (float)(n - 1);
        for (int i = 0; i < n; ++i) {
            b[i] = CU.colorTriadToFFRGB(rgb1[0] + dr * (float)i, rgb1[1] + dg * (float)i, rgb1[2] + db * (float)i);
        }
        return b;
    }

    private int[] getPaletteBW() {
        if (this.ce.paletteBW != null) {
            return this.ce.paletteBW;
        }
        int[] b = new int[JC.argbsRoygbScale.length];
        for (int i = 0; i < b.length; ++i) {
            float xff = 1.0f / (float)b.length * (float)i;
            b[i] = CU.colorTriadToFFRGB(xff, xff, xff);
        }
        this.ce.paletteBW = b;
        return b;
    }

    public float quantize(float x, boolean isLowEnd) {
        int n = this.getPaletteColorCount(this.currentPalette);
        return (x = ((float)((int)(x * (float)n)) + (isLowEnd ? 0.0f : 1.0f)) / (float)n) <= 0.0f ? this.lo : (x >= 1.0f ? this.hi : this.lo + (this.hi - this.lo) * x);
    }

    public static final int quantize4(float val, float lo, float hi, int segmentCount) {
        float range = hi - lo;
        if (range <= 0.0f || Float.isNaN(val)) {
            return segmentCount / 2;
        }
        float t = val - lo;
        if (t <= 0.0f) {
            return 0;
        }
        float quanta = range / (float)segmentCount;
        int q = (int)(t / quanta + 1.0E-4f);
        if (q >= segmentCount) {
            q = segmentCount - 1;
        }
        return q;
    }

    private static final int colorIndex(float q, int segmentCount) {
        return (int)Math.floor(q <= 0.0f || q >= (float)segmentCount ? 0.0 : (double)q);
    }

    private static final int colorIndexRepeat(float q, int segmentCount) {
        int i = (int)Math.floor(q <= 0.0f ? 0.0 : (double)q);
        return i % segmentCount;
    }
}

