/*
 * Decompiled with CFR 0.152.
 */
package ome.jxrlib;

import java.util.AbstractList;
import java.util.RandomAccess;
import ome.jxrlib.JXRJNI;

public class ImageData
extends AbstractList<Character>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected ImageData(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ImageData obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                JXRJNI.delete_ImageData(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public ImageData(char[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (char element : initialElements) {
            this.add(Character.valueOf(element));
        }
    }

    public ImageData(Iterable<Character> initialElements) {
        this();
        for (char element : initialElements) {
            this.add(Character.valueOf(element));
        }
    }

    @Override
    public Character get(int index) {
        return Character.valueOf(this.doGet(index));
    }

    @Override
    public Character set(int index, Character e) {
        return Character.valueOf(this.doSet(index, e.charValue()));
    }

    @Override
    public boolean add(Character e) {
        ++this.modCount;
        this.doAdd(e.charValue());
        return true;
    }

    @Override
    public void add(int index, Character e) {
        ++this.modCount;
        this.doAdd(index, e.charValue());
    }

    @Override
    public Character remove(int index) {
        ++this.modCount;
        return Character.valueOf(this.doRemove(index));
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public ImageData() {
        this(JXRJNI.new_ImageData__SWIG_0(), true);
    }

    public ImageData(ImageData other) {
        this(JXRJNI.new_ImageData__SWIG_1(ImageData.getCPtr(other), other), true);
    }

    public long capacity() {
        return JXRJNI.ImageData_capacity(this.swigCPtr, this);
    }

    public void reserve(long n) {
        JXRJNI.ImageData_reserve(this.swigCPtr, this, n);
    }

    @Override
    public boolean isEmpty() {
        return JXRJNI.ImageData_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        JXRJNI.ImageData_clear(this.swigCPtr, this);
    }

    public ImageData(int count, char value) {
        this(JXRJNI.new_ImageData__SWIG_2(count, value), true);
    }

    private int doSize() {
        return JXRJNI.ImageData_doSize(this.swigCPtr, this);
    }

    private void doAdd(char x) {
        JXRJNI.ImageData_doAdd__SWIG_0(this.swigCPtr, this, x);
    }

    private void doAdd(int index, char x) {
        JXRJNI.ImageData_doAdd__SWIG_1(this.swigCPtr, this, index, x);
    }

    private char doRemove(int index) {
        return JXRJNI.ImageData_doRemove(this.swigCPtr, this, index);
    }

    private char doGet(int index) {
        return JXRJNI.ImageData_doGet(this.swigCPtr, this, index);
    }

    private char doSet(int index, char val) {
        return JXRJNI.ImageData_doSet(this.swigCPtr, this, index, val);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        JXRJNI.ImageData_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

