/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ImmutableCollection;
import kotlinx.collections.immutable.ImmutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PathAwarePropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.util.TraverseDirection;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.QualifiedAccessNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JT\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirPropertyInitializationAnalyzer;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "()V", "analyze", "", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwarePropertyInitializationInfo;", "properties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "capturedWrites", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "PropertyReporter", "checkers"})
public final class FirPropertyInitializationAnalyzer
extends AbstractFirPropertyInitializationChecker {
    @NotNull
    public static final FirPropertyInitializationAnalyzer INSTANCE = new FirPropertyInitializationAnalyzer();

    private FirPropertyInitializationAnalyzer() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void analyze(@NotNull ControlFlowGraph graph2, @NotNull DiagnosticReporter reporter, @NotNull Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data, @NotNull Set<? extends FirPropertySymbol> properties2, @NotNull Set<? extends FirVariableAssignment> capturedWrites, @NotNull CheckerContext context) {
        void destination$iv;
        void $this$filterTo$iv;
        Collection $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(graph2, "graph");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(properties2, "properties");
        Intrinsics.checkNotNullParameter(capturedWrites, "capturedWrites");
        Intrinsics.checkNotNullParameter(context, "context");
        Map<CFGNode<?>, PathAwarePropertyInitializationInfo> $this$filter$iv = data;
        boolean $i$f$filter22 = false;
        Map<CFGNode<?>, PathAwarePropertyInitializationInfo> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            Object e = ((CFGNode)it.getKey()).getFir();
            FirVariableSymbol firVariableSymbol = e instanceof FirVariableSymbol ? (FirVariableSymbol)e : null;
            FirVariable symbolFir = firVariableSymbol != null ? (FirVariable)firVariableSymbol.getFir() : null;
            if (!(symbolFir == null || symbolFir.getInitializer() == null && symbolFir.getDelegate() == null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map localData = destination$iv$iv;
        Iterable $i$f$filter22 = properties2;
        $this$filterTo$iv$iv = new LinkedHashSet();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv : $this$filterTo$iv) {
            FirPropertySymbol it = (FirPropertySymbol)element$iv;
            boolean bl = false;
            if (!(((FirProperty)it.getFir()).getInitializer() == null && ((FirProperty)it.getFir()).getDelegate() == null)) continue;
            destination$iv.add(element$iv);
        }
        Set localProperties = (Set)destination$iv;
        PropertyReporter reporterVisitor = new PropertyReporter(localData, localProperties, capturedWrites, reporter, context);
        CfgTraverserKt.traverse(graph2, TraverseDirection.Forward, reporterVisitor);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001BI\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0019\u001a\u0004\u0018\u00010\b2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020 H\u0002J \u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\"H\u0002J\u0014\u0010#\u001a\u00020$2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J\u0010\u0010%\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020 H\u0016J\u0010\u0010&\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\"H\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirPropertyInitializationAnalyzer$PropertyReporter;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwarePropertyInitializationInfo;", "localProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "capturedWrites", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "(Ljava/util/Map;Ljava/util/Set;Ljava/util/Set;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "getCapturedWrites", "()Ljava/util/Set;", "getContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getData", "()Ljava/util/Map;", "getLocalProperties", "getReporter", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getPropertySymbol", "node", "investigateVariableAccess", "", "info", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfo;", "symbol", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;", "investigateVariableAssignment", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitNode", "", "visitQualifiedAccessNode", "visitVariableAssignmentNode", "checkers"})
    private static final class PropertyReporter
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data;
        @NotNull
        private final Set<FirPropertySymbol> localProperties;
        @NotNull
        private final Set<FirVariableAssignment> capturedWrites;
        @NotNull
        private final DiagnosticReporter reporter;
        @NotNull
        private final CheckerContext context;

        public PropertyReporter(@NotNull Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data, @NotNull Set<? extends FirPropertySymbol> localProperties, @NotNull Set<? extends FirVariableAssignment> capturedWrites, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context) {
            Intrinsics.checkNotNullParameter(data, "data");
            Intrinsics.checkNotNullParameter(localProperties, "localProperties");
            Intrinsics.checkNotNullParameter(capturedWrites, "capturedWrites");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(context, "context");
            this.data = data;
            this.localProperties = localProperties;
            this.capturedWrites = capturedWrites;
            this.reporter = reporter;
            this.context = context;
        }

        @NotNull
        public final Map<CFGNode<?>, PathAwarePropertyInitializationInfo> getData() {
            return this.data;
        }

        @NotNull
        public final Set<FirPropertySymbol> getLocalProperties() {
            return this.localProperties;
        }

        @NotNull
        public final Set<FirVariableAssignment> getCapturedWrites() {
            return this.capturedWrites;
        }

        @NotNull
        public final DiagnosticReporter getReporter() {
            return this.reporter;
        }

        @NotNull
        public final CheckerContext getContext() {
            return this.context;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, "node");
        }

        private final FirPropertySymbol getPropertySymbol(CFGNode<?> node) {
            Object obj = node.getFir();
            FirQualifiedAccess firQualifiedAccess = obj instanceof FirQualifiedAccess ? (FirQualifiedAccess)obj : null;
            return firQualifiedAccess != null ? FirDeclarationUtilKt.getReferredPropertySymbol(firQualifiedAccess) : null;
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            Intrinsics.checkNotNullParameter(node, "node");
            FirPropertySymbol firPropertySymbol = this.getPropertySymbol(node);
            if (firPropertySymbol == null) {
                return;
            }
            FirPropertySymbol symbol2 = firPropertySymbol;
            PathAwarePropertyInitializationInfo pathAwareInfo = MapsKt.getValue(this.data, node);
            for (EdgeLabel label : (ImmutableSet)pathAwareInfo.keySet()) {
                Object object = pathAwareInfo.get((Object)label);
                Intrinsics.checkNotNull(object);
                if (!this.investigateVariableAssignment((PropertyInitializationInfo)object, symbol2, node)) continue;
                break;
            }
        }

        private final boolean investigateVariableAssignment(PropertyInitializationInfo info, FirPropertySymbol symbol2, VariableAssignmentNode node) {
            EventOccurrencesRange kind;
            if (((FirProperty)symbol2.getFir()).isVal() && this.capturedWrites.contains(node.getFir())) {
                if (((FirProperty)symbol2.getFir()).isLocal()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)node.getFir().getLValue().getSource(), FirErrors.INSTANCE.getCAPTURED_VAL_INITIALIZATION(), (Object)symbol2, (DiagnosticContext)this.context, null, 16, null);
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)node.getFir().getLValue().getSource(), FirErrors.INSTANCE.getCAPTURED_MEMBER_VAL_INITIALIZATION(), (Object)symbol2, (DiagnosticContext)this.context, null, 16, null);
                }
                return true;
            }
            EventOccurrencesRange eventOccurrencesRange = (EventOccurrencesRange)((Object)info.get(symbol2));
            if (eventOccurrencesRange == null) {
                eventOccurrencesRange = kind = EventOccurrencesRange.ZERO;
            }
            if (((FirProperty)symbol2.getFir()).isVal() && (symbol2 instanceof FirSyntheticPropertySymbol || EventOccurrencesRangeKt.canBeRevisited(kind))) {
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)node.getFir().getLValue().getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT(), (Object)symbol2, (DiagnosticContext)this.context, null, 16, null);
                return true;
            }
            return false;
        }

        @Override
        public void visitQualifiedAccessNode(@NotNull QualifiedAccessNode node) {
            PropertyInitializationInfo info;
            Intrinsics.checkNotNullParameter(node, "node");
            FirPropertySymbol firPropertySymbol = this.getPropertySymbol(node);
            if (firPropertySymbol == null) {
                return;
            }
            FirPropertySymbol symbol2 = firPropertySymbol;
            if (!this.localProperties.contains(symbol2)) {
                return;
            }
            FirMemberDeclaration $this$isLateInit$iv = (FirMemberDeclaration)symbol2.getFir();
            boolean $i$f$isLateInit = false;
            if ($this$isLateInit$iv.getStatus().isLateInit()) {
                return;
            }
            PathAwarePropertyInitializationInfo pathAwareInfo = MapsKt.getValue(this.data, node);
            Iterator iterator2 = ((ImmutableCollection)pathAwareInfo.values()).iterator();
            while (iterator2.hasNext() && !this.investigateVariableAccess(info = (PropertyInitializationInfo)iterator2.next(), symbol2, node)) {
            }
        }

        private final boolean investigateVariableAccess(PropertyInitializationInfo info, FirPropertySymbol symbol2, QualifiedAccessNode node) {
            EventOccurrencesRange kind;
            EventOccurrencesRange eventOccurrencesRange = (EventOccurrencesRange)((Object)info.get(symbol2));
            if (eventOccurrencesRange == null) {
                eventOccurrencesRange = kind = EventOccurrencesRange.ZERO;
            }
            if (!(symbol2 instanceof FirSyntheticPropertySymbol) && !EventOccurrencesRangeKt.isDefinitelyVisited(kind)) {
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)node.getFir().getSource(), FirErrors.INSTANCE.getUNINITIALIZED_VARIABLE(), (Object)symbol2, (DiagnosticContext)this.context, null, 16, null);
                return true;
            }
            return false;
        }
    }
}

