/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.backend.Fir2IrScopeCache;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ1\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\u0004\b\u0000\u0010\u001f2\u0019\u0010 \u001a\u0015\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u0001H\u001f0!\u00a2\u0006\u0002\b\"H\u0082\b\u00a2\u0006\u0002\u0010#J\u0006\u0010$\u001a\u00020\u000bJ\u0016\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\rJ\u0016\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\tJ\u0016\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u0013J\u0016\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u0017J\u0016\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u001d2\u0006\u00103\u001a\u00020\u001bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrLocalStorage;", "", "()V", "cacheStack", "", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrScopeCache;", "localClassCache", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "enterCallable", "", "getDelegatedProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrLocalDelegatedProperty;", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getLocalClass", "localClass", "getLocalFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "localFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "getParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "last", "T", "getter", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "leaveCallable", "putDelegatedProperty", "firProperty", "irProperty", "putLocalClass", "firClass", "irClass", "putLocalFunction", "firFunction", "irFunction", "putParameter", "firParameter", "irParameter", "putVariable", "firVariable", "irVariable", "fir2ir"})
public final class Fir2IrLocalStorage {
    @NotNull
    private final List<Fir2IrScopeCache> cacheStack = new ArrayList();
    @NotNull
    private final Map<FirClass, IrClass> localClassCache = new LinkedHashMap();

    public final void enterCallable() {
        ((Collection)this.cacheStack).add(new Fir2IrScopeCache());
    }

    public final void leaveCallable() {
        CollectionsKt.last(this.cacheStack).clear();
        this.cacheStack.remove(this.cacheStack.size() - 1);
    }

    @Nullable
    public final IrValueParameter getParameter(@NotNull FirValueParameter parameter) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        for (Fir2IrScopeCache cache2 : CollectionsKt.asReversedMutable(this.cacheStack)) {
            IrValueParameter local = cache2.getParameter(parameter);
            if (local == null) continue;
            return local;
        }
        return null;
    }

    @Nullable
    public final IrVariable getVariable(@NotNull FirVariable variable2) {
        IrVariable irVariable2;
        block1: {
            Intrinsics.checkNotNullParameter(variable2, "variable");
            Fir2IrLocalStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator<Fir2IrScopeCache> iterator2 = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getVariable_u24lambda_u240 = cache$iv = iterator2.next();
                boolean bl = false;
                IrVariable irVariable3 = $this$getVariable_u24lambda_u240.getVariable(variable2);
                if (irVariable3 == null) continue;
                IrVariable it$iv = irVariable3;
                boolean bl2 = false;
                irVariable2 = it$iv;
                break block1;
            }
            irVariable2 = null;
        }
        return irVariable2;
    }

    @Nullable
    public final IrClass getLocalClass(@NotNull FirClass localClass) {
        Intrinsics.checkNotNullParameter(localClass, "localClass");
        return this.localClassCache.get(localClass);
    }

    @Nullable
    public final IrSimpleFunction getLocalFunction(@NotNull FirFunction localFunction) {
        IrSimpleFunction irSimpleFunction;
        block1: {
            Intrinsics.checkNotNullParameter(localFunction, "localFunction");
            Fir2IrLocalStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator<Fir2IrScopeCache> iterator2 = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getLocalFunction_u24lambda_u241 = cache$iv = iterator2.next();
                boolean bl = false;
                IrSimpleFunction irSimpleFunction2 = $this$getLocalFunction_u24lambda_u241.getLocalFunction(localFunction);
                if (irSimpleFunction2 == null) continue;
                IrSimpleFunction it$iv = irSimpleFunction2;
                boolean bl2 = false;
                irSimpleFunction = it$iv;
                break block1;
            }
            irSimpleFunction = null;
        }
        return irSimpleFunction;
    }

    @Nullable
    public final IrLocalDelegatedProperty getDelegatedProperty(@NotNull FirProperty property2) {
        IrLocalDelegatedProperty irLocalDelegatedProperty;
        block1: {
            Intrinsics.checkNotNullParameter(property2, "property");
            Fir2IrLocalStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator<Fir2IrScopeCache> iterator2 = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getDelegatedProperty_u24lambda_u242 = cache$iv = iterator2.next();
                boolean bl = false;
                IrLocalDelegatedProperty irLocalDelegatedProperty2 = $this$getDelegatedProperty_u24lambda_u242.getDelegatedProperty(property2);
                if (irLocalDelegatedProperty2 == null) continue;
                IrLocalDelegatedProperty it$iv = irLocalDelegatedProperty2;
                boolean bl2 = false;
                irLocalDelegatedProperty = it$iv;
                break block1;
            }
            irLocalDelegatedProperty = null;
        }
        return irLocalDelegatedProperty;
    }

    public final void putParameter(@NotNull FirValueParameter firParameter, @NotNull IrValueParameter irParameter2) {
        Intrinsics.checkNotNullParameter(firParameter, "firParameter");
        Intrinsics.checkNotNullParameter(irParameter2, "irParameter");
        CollectionsKt.last(this.cacheStack).putParameter(firParameter, irParameter2);
    }

    public final void putVariable(@NotNull FirVariable firVariable, @NotNull IrVariable irVariable2) {
        Intrinsics.checkNotNullParameter(firVariable, "firVariable");
        Intrinsics.checkNotNullParameter(irVariable2, "irVariable");
        CollectionsKt.last(this.cacheStack).putVariable(firVariable, irVariable2);
    }

    public final void putLocalClass(@NotNull FirClass firClass, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(firClass, "firClass");
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        this.localClassCache.put(firClass, irClass2);
    }

    public final void putLocalFunction(@NotNull FirFunction firFunction, @NotNull IrSimpleFunction irFunction2) {
        Intrinsics.checkNotNullParameter(firFunction, "firFunction");
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        CollectionsKt.last(this.cacheStack).putLocalFunction(firFunction, irFunction2);
    }

    public final void putDelegatedProperty(@NotNull FirProperty firProperty, @NotNull IrLocalDelegatedProperty irProperty2) {
        Intrinsics.checkNotNullParameter(firProperty, "firProperty");
        Intrinsics.checkNotNullParameter(irProperty2, "irProperty");
        CollectionsKt.last(this.cacheStack).putDelegatedProperty(firProperty, irProperty2);
    }
}

