/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.incremental.AbstractIncrementalCache;
import org.jetbrains.kotlin.incremental.InputsCache;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.incremental.storage.IncrementalFileToPathConverter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003:\u0001*B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\b\u0010%\u001a\u00020&H\u0016J\u001b\u0010'\u001a\u00020&\"\b\b\u0001\u0010(*\u00020\u000f*\u0002H(H\u0004\u00a2\u0006\u0002\u0010)R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0012\u0010 \u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager;", "PlatformCache", "Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache;", "Ljava/io/Closeable;", "cachesRootDir", "Ljava/io/File;", "rootProjectDir", "reporter", "Lorg/jetbrains/kotlin/build/report/ICReporter;", "storeFullFqNamesInLookupCache", "", "trackChangesInLookupCache", "(Ljava/io/File;Ljava/io/File;Lorg/jetbrains/kotlin/build/report/ICReporter;ZZ)V", "caches", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "Lkotlin/collections/ArrayList;", "inputSnapshotsCacheDir", "inputsCache", "Lorg/jetbrains/kotlin/incremental/InputsCache;", "getInputsCache", "()Lorg/jetbrains/kotlin/incremental/InputsCache;", "isClosed", "lookupCache", "Lorg/jetbrains/kotlin/incremental/LookupStorage;", "getLookupCache", "()Lorg/jetbrains/kotlin/incremental/LookupStorage;", "lookupCacheDir", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/IncrementalFileToPathConverter;", "getPathConverter", "()Lorg/jetbrains/kotlin/incremental/storage/IncrementalFileToPathConverter;", "platformCache", "getPlatformCache", "()Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache;", "getReporter", "()Lorg/jetbrains/kotlin/build/report/ICReporter;", "close", "", "registerCache", "T", "(Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;)V", "CacheCloser", "incremental-compilation-impl"})
public abstract class IncrementalCachesManager<PlatformCache extends AbstractIncrementalCache<?>>
implements Closeable {
    @NotNull
    private final ICReporter reporter;
    @NotNull
    private final IncrementalFileToPathConverter pathConverter;
    @NotNull
    private final ArrayList<BasicMapsOwner> caches;
    private boolean isClosed;
    @NotNull
    private final File inputSnapshotsCacheDir;
    @NotNull
    private final File lookupCacheDir;
    @NotNull
    private final InputsCache inputsCache;
    @NotNull
    private final LookupStorage lookupCache;

    /*
     * WARNING - void declaration
     */
    public IncrementalCachesManager(@NotNull File cachesRootDir, @Nullable File rootProjectDir, @NotNull ICReporter reporter, boolean storeFullFqNamesInLookupCache, boolean trackChangesInLookupCache) {
        void $this$lookupCache_u24lambda_u244;
        Object $this$inputsCache_u24lambda_u243;
        Object $this$lookupCacheDir_u24lambda_u242;
        File $this$inputSnapshotsCacheDir_u24lambda_u241;
        Intrinsics.checkNotNullParameter(cachesRootDir, "cachesRootDir");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        this.reporter = reporter;
        this.pathConverter = new IncrementalFileToPathConverter(rootProjectDir);
        this.caches = new ArrayList();
        Object object = new File(cachesRootDir, "inputs");
        File file2 = object;
        IncrementalCachesManager incrementalCachesManager = this;
        boolean bl = false;
        $this$inputSnapshotsCacheDir_u24lambda_u241.mkdirs();
        incrementalCachesManager.inputSnapshotsCacheDir = object;
        object = new File(cachesRootDir, "lookups");
        $this$inputSnapshotsCacheDir_u24lambda_u241 = object;
        incrementalCachesManager = this;
        boolean bl2 = false;
        ((File)$this$lookupCacheDir_u24lambda_u242).mkdirs();
        incrementalCachesManager.lookupCacheDir = object;
        $this$lookupCacheDir_u24lambda_u242 = object = new InputsCache(this.inputSnapshotsCacheDir, this.reporter, this.pathConverter);
        incrementalCachesManager = this;
        boolean bl3 = false;
        this.registerCache((BasicMapsOwner)$this$inputsCache_u24lambda_u243);
        incrementalCachesManager.inputsCache = object;
        $this$inputsCache_u24lambda_u243 = object = new LookupStorage(this.lookupCacheDir, this.pathConverter, storeFullFqNamesInLookupCache, trackChangesInLookupCache);
        incrementalCachesManager = this;
        boolean bl4 = false;
        this.registerCache((BasicMapsOwner)$this$lookupCache_u24lambda_u244);
        incrementalCachesManager.lookupCache = object;
    }

    public /* synthetic */ IncrementalCachesManager(File file2, File file3, ICReporter iCReporter, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(file2, file3, iCReporter, bl, bl2);
    }

    @NotNull
    protected final ICReporter getReporter() {
        return this.reporter;
    }

    @NotNull
    public final IncrementalFileToPathConverter getPathConverter() {
        return this.pathConverter;
    }

    protected final synchronized <T extends BasicMapsOwner> void registerCache(@NotNull T $this$registerCache) {
        Intrinsics.checkNotNullParameter($this$registerCache, "<this>");
        if (!(!this.isClosed)) {
            boolean bl = false;
            String string2 = "This cache storage has already been closed";
            throw new IllegalStateException(string2.toString());
        }
        this.caches.add($this$registerCache);
    }

    @NotNull
    public final InputsCache getInputsCache() {
        return this.inputsCache;
    }

    @NotNull
    public final LookupStorage getLookupCache() {
        return this.lookupCache;
    }

    @NotNull
    public abstract PlatformCache getPlatformCache();

    @Override
    public synchronized void close() {
        if (!(!this.isClosed)) {
            boolean $i$a$-check-IncrementalCachesManager$close$22 = false;
            String $i$a$-check-IncrementalCachesManager$close$22 = "This cache storage has already been closed";
            throw new IllegalStateException($i$a$-check-IncrementalCachesManager$close$22.toString());
        }
        Closer closer = Closer.create();
        Iterable $this$forEach$iv = this.caches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicMapsOwner it = (BasicMapsOwner)element$iv;
            boolean bl = false;
            closer.register((Closeable)new CacheCloser(it));
        }
        closer.close();
        this.isClosed = true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalCachesManager$CacheCloser;", "Ljava/io/Closeable;", "cache", "Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;", "(Lorg/jetbrains/kotlin/incremental/storage/BasicMapsOwner;)V", "close", "", "incremental-compilation-impl"})
    private static final class CacheCloser
    implements Closeable {
        @NotNull
        private final BasicMapsOwner cache;

        public CacheCloser(@NotNull BasicMapsOwner cache2) {
            Intrinsics.checkNotNullParameter(cache2, "cache");
            this.cache = cache2;
        }

        @Override
        public void close() {
            this.cache.flush(false);
            this.cache.close();
        }
    }
}

