/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.coroutines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.coroutines.IrDispatchPoint;
import org.jetbrains.kotlin.ir.backend.js.lower.coroutines.LoopBounds;
import org.jetbrains.kotlin.ir.backend.js.lower.coroutines.SuspendState;
import org.jetbrains.kotlin.ir.backend.js.lower.coroutines.TryState;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrBranchImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrElseBranchImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSpreadElementImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrStringConcatenationImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0083\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u0012\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00180\u0014\u00a2\u0006\u0002\u0010\u0019J\b\u0010K\u001a\u00020LH\u0002J\u0010\u0010M\u001a\u00020L2\u0006\u0010N\u001a\u00020\u0018H\u0002J\u0010\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020\u001fH\u0002J\b\u0010R\u001a\u00020\u001fH\u0002J\b\u0010S\u001a\u00020,H\u0002J\u0018\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u00162\u0006\u0010W\u001a\u00020\u0015H\u0002J\b\u0010X\u001a\u00020EH\u0002J \u0010Y\u001a\u00020L2\u0006\u0010Z\u001a\u00020\u001f2\u0006\u0010[\u001a\u00020\u001f2\u0006\u0010\\\u001a\u00020\u0015H\u0002J\u0012\u0010]\u001a\u00020L2\b\b\u0002\u0010^\u001a\u00020#H\u0002J\u001a\u0010_\u001a\u00020L2\u0006\u0010Q\u001a\u00020\u001f2\b\b\u0002\u0010`\u001a\u000204H\u0002J \u0010a\u001a\u00020L2\u0006\u0010Q\u001a\u00020\u001f2\u0006\u0010^\u001a\u00020#2\u0006\u0010`\u001a\u000204H\u0002J\b\u0010b\u001a\u00020cH\u0002J\u0006\u0010d\u001a\u00020LJ\u0010\u0010e\u001a\u0002042\u0006\u0010f\u001a\u00020\u0016H\u0002J\u0018\u0010g\u001a\u00020U2\u0006\u0010V\u001a\u00020\u00162\u0006\u0010W\u001a\u00020\u0015H\u0002J\b\u0010h\u001a\u000204H\u0002J\b\u0010i\u001a\u00020\u0016H\u0002J\u0010\u0010j\u001a\u00020L2\u0006\u0010Q\u001a\u00020\u001fH\u0002J\b\u0010k\u001a\u00020LH\u0002J\b\u0010l\u001a\u00020cH\u0002J\u0010\u0010m\u001a\u00020L2\u0006\u0010n\u001a\u00020\nH\u0002J\u0010\u0010o\u001a\u00020L2\u0006\u0010Q\u001a\u00020\u001fH\u0002J\u001a\u0010p\u001a\u0002022\u0006\u0010q\u001a\u00020\u00152\b\b\u0002\u0010r\u001a\u00020sH\u0002J%\u0010t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160u2\u000e\u0010v\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160uH\u0002\u00a2\u0006\u0002\u0010wJ\u001c\u0010x\u001a\u00020L2\u0012\u0010y\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00180\u0014H\u0002J0\u0010z\u001a\u00020L2\u0006\u0010n\u001a\u00020\n2\u001e\u0010y\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020L0{H\u0002J\u0010\u0010|\u001a\u00020L2\u0006\u0010k\u001a\u00020\u001fH\u0002J\u0010\u0010}\u001a\u00020L2\u0006\u0010~\u001a\u00020\u007fH\u0016J\u0011\u0010\u0080\u0001\u001a\u00020L2\u0006\u0010f\u001a\u00020cH\u0016J\u0012\u0010\u0081\u0001\u001a\u00020L2\u0007\u0010~\u001a\u00030\u0082\u0001H\u0016J\u0012\u0010\u0083\u0001\u001a\u00020L2\u0007\u0010n\u001a\u00030\u0084\u0001H\u0016J\u0012\u0010\u0085\u0001\u001a\u00020L2\u0007\u0010\u0086\u0001\u001a\u00020\u0004H\u0016J\u0012\u0010\u0087\u0001\u001a\u00020L2\u0007\u0010f\u001a\u00030\u0088\u0001H\u0016J\u0012\u0010\u0089\u0001\u001a\u00020L2\u0007\u0010f\u001a\u00030\u008a\u0001H\u0016J\u0016\u0010\u008b\u0001\u001a\u00020L2\u000b\u0010f\u001a\u0007\u0012\u0002\b\u00030\u008c\u0001H\u0016J\u0012\u0010\u008d\u0001\u001a\u00020L2\u0007\u0010f\u001a\u00030\u008e\u0001H\u0016J\u0012\u0010\u008f\u0001\u001a\u00020L2\u0007\u0010f\u001a\u00030\u0090\u0001H\u0016J\u0012\u0010\u0091\u0001\u001a\u00020L2\u0007\u0010f\u001a\u00030\u0092\u0001H\u0016J\u0012\u0010\u0093\u0001\u001a\u00020L2\u0007\u0010f\u001a\u00030\u0094\u0001H\u0016J\u0012\u0010\u0095\u0001\u001a\u00020L2\u0007\u0010f\u001a\u00030\u0096\u0001H\u0016J\u0013\u0010\u0097\u0001\u001a\u00020L2\b\u0010\u0098\u0001\u001a\u00030\u0099\u0001H\u0016J\u0012\u0010\u009a\u0001\u001a\u00020L2\u0007\u0010f\u001a\u00030\u009b\u0001H\u0016J\u0012\u0010\u009c\u0001\u001a\u00020L2\u0007\u0010f\u001a\u00030\u009d\u0001H\u0016J\u0012\u0010\u009e\u0001\u001a\u00020L2\u0007\u0010\u009f\u0001\u001a\u000202H\u0016J\u0012\u0010\u00a0\u0001\u001a\u00020L2\u0007\u0010f\u001a\u00030\u00a1\u0001H\u0016J\u0012\u0010\u00a2\u0001\u001a\u00020L2\u0007\u0010n\u001a\u00030\u00a3\u0001H\u0016J\u001b\u0010\u00a4\u0001\u001a\u00030\u00a5\u00012\u0006\u0010f\u001a\u00020\u00162\u0007\u0010\u00a6\u0001\u001a\u00020<H\u0002J\u0014\u0010M\u001a\u00020L*\u00020#2\u0006\u0010N\u001a\u00020\u0018H\u0002R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u00020,X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020706X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u00109\u001a\u001c\u0012\u0004\u0012\u00020:\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0006\u0012\u0004\u0018\u00010<0;06X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010=\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010'R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00180\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010?\u001a\u00020@8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020E06X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010G\u001a\u00020H8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010J\u00a8\u0006\u00a7\u0001"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/coroutines/StateMachineBuilder;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "suspendableNodes", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "function", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "rootLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "exceptionSymbolGetter", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "exceptionSymbolSetter", "exStateSymbolGetter", "exStateSymbolSetter", "stateSymbolSetter", "thisSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "getSuspendResultAsType", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "setSuspendResultValue", "Lorg/jetbrains/kotlin/ir/IrStatement;", "(Ljava/util/Set;Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;Lorg/jetbrains/kotlin/ir/expressions/IrLoop;Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "anyN", "booleanNotSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "catchBlockStack", "", "Lorg/jetbrains/kotlin/ir/backend/js/lower/coroutines/SuspendState;", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "currentBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "currentState", "entryState", "getEntryState", "()Lorg/jetbrains/kotlin/ir/backend/js/lower/coroutines/SuspendState;", "eqeqeqSymbol", "getFunction", "()Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "globalCatch", "Lorg/jetbrains/kotlin/ir/expressions/IrCatch;", "getGlobalCatch", "()Lorg/jetbrains/kotlin/ir/expressions/IrCatch;", "setGlobalCatch", "(Lorg/jetbrains/kotlin/ir/expressions/IrCatch;)V", "globalExceptionVar", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "hasExceptions", "", "loopMap", "", "Lorg/jetbrains/kotlin/ir/backend/js/lower/coroutines/LoopBounds;", "nothing", "returnableBlockMap", "Lorg/jetbrains/kotlin/ir/symbols/IrReturnableBlockSymbol;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/symbols/IrVariableSymbol;", "rootExceptionTrap", "getRootExceptionTrap", "thisReceiver", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetValueImpl;", "getThisReceiver", "()Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetValueImpl;", "tryLoopStack", "tryStateMap", "Lorg/jetbrains/kotlin/ir/backend/js/lower/coroutines/TryState;", "unit", "unitValue", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetObjectValueImpl;", "getUnitValue", "()Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetObjectValueImpl;", "addExceptionEdge", "", "addStatement", "statement", "buildDispatchBlock", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCompositeImpl;", "target", "buildExceptionTrapState", "buildGlobalCatch", "buildIsCheck", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrTypeOperatorCallImpl;", "value", "toType", "buildTryState", "buildUnboxingState", "unboxState", "continueState", "expectedType", "doContinue", "block", "doDispatch", "andContinue", "doDispatchImpl", "exceptionState", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "finalizeStateMachine", "hasResultingValue", "expression", "implicitCast", "isBlockEnded", "lastExpression", "maybeDoDispatch", "newState", "pendingException", "resetExceptionStateIfNeeded", "loop", "setupExceptionState", "tempVar", "type", "name", "", "transformArguments", "", "arguments", "([Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)[Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "transformLastExpression", "transformer", "transformLoop", "Lkotlin/Function3;", "updateState", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitCall", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "visitDoWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "visitElement", "element", "visitGetClass", "Lorg/jetbrains/kotlin/ir/expressions/IrGetClass;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitMemberAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "visitVariable", "declaration", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "wrap", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrSetValueImpl;", "variable", "backend.js"})
public final class StateMachineBuilder
implements IrElementVisitorVoid {
    @NotNull
    private final Set<IrElement> suspendableNodes;
    @NotNull
    private final JsCommonBackendContext context;
    @NotNull
    private final IrFunctionSymbol function;
    @NotNull
    private final IrLoop rootLoop;
    @NotNull
    private final IrSimpleFunction exceptionSymbolGetter;
    @NotNull
    private final IrSimpleFunction exceptionSymbolSetter;
    @NotNull
    private final IrSimpleFunction exStateSymbolGetter;
    @NotNull
    private final IrSimpleFunction exStateSymbolSetter;
    @NotNull
    private final IrSimpleFunction stateSymbolSetter;
    @NotNull
    private final IrValueParameterSymbol thisSymbol;
    @NotNull
    private final Function1<IrType, IrExpression> getSuspendResultAsType;
    @NotNull
    private final Function1<IrExpression, IrStatement> setSuspendResultValue;
    @NotNull
    private final Map<IrLoop, LoopBounds> loopMap;
    @NotNull
    private final IrType unit;
    @NotNull
    private final IrType anyN;
    @NotNull
    private final IrType nothing;
    @NotNull
    private final IrSimpleFunctionSymbol booleanNotSymbol;
    @NotNull
    private final IrSimpleFunctionSymbol eqeqeqSymbol;
    private boolean hasExceptions;
    @NotNull
    private final SuspendState entryState;
    @NotNull
    private final SuspendState rootExceptionTrap;
    @NotNull
    private final IrVariable globalExceptionVar;
    public IrCatch globalCatch;
    @NotNull
    private SuspendState currentState;
    @NotNull
    private IrContainerExpression currentBlock;
    @NotNull
    private final Map<IrReturnableBlockSymbol, Pair<SuspendState, IrVariableSymbol>> returnableBlockMap;
    @NotNull
    private final List<SuspendState> catchBlockStack;
    @NotNull
    private final Map<IrExpression, TryState> tryStateMap;
    @NotNull
    private final List<IrExpression> tryLoopStack;

    public StateMachineBuilder(@NotNull Set<IrElement> suspendableNodes, @NotNull JsCommonBackendContext context, @NotNull IrFunctionSymbol function2, @NotNull IrLoop rootLoop, @NotNull IrSimpleFunction exceptionSymbolGetter, @NotNull IrSimpleFunction exceptionSymbolSetter, @NotNull IrSimpleFunction exStateSymbolGetter, @NotNull IrSimpleFunction exStateSymbolSetter, @NotNull IrSimpleFunction stateSymbolSetter, @NotNull IrValueParameterSymbol thisSymbol, @NotNull Function1<? super IrType, ? extends IrExpression> getSuspendResultAsType, @NotNull Function1<? super IrExpression, ? extends IrStatement> setSuspendResultValue) {
        Intrinsics.checkNotNullParameter(suspendableNodes, "suspendableNodes");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(rootLoop, "rootLoop");
        Intrinsics.checkNotNullParameter(exceptionSymbolGetter, "exceptionSymbolGetter");
        Intrinsics.checkNotNullParameter(exceptionSymbolSetter, "exceptionSymbolSetter");
        Intrinsics.checkNotNullParameter(exStateSymbolGetter, "exStateSymbolGetter");
        Intrinsics.checkNotNullParameter(exStateSymbolSetter, "exStateSymbolSetter");
        Intrinsics.checkNotNullParameter(stateSymbolSetter, "stateSymbolSetter");
        Intrinsics.checkNotNullParameter(thisSymbol, "thisSymbol");
        Intrinsics.checkNotNullParameter(getSuspendResultAsType, "getSuspendResultAsType");
        Intrinsics.checkNotNullParameter(setSuspendResultValue, "setSuspendResultValue");
        this.suspendableNodes = suspendableNodes;
        this.context = context;
        this.function = function2;
        this.rootLoop = rootLoop;
        this.exceptionSymbolGetter = exceptionSymbolGetter;
        this.exceptionSymbolSetter = exceptionSymbolSetter;
        this.exStateSymbolGetter = exStateSymbolGetter;
        this.exStateSymbolSetter = exStateSymbolSetter;
        this.stateSymbolSetter = stateSymbolSetter;
        this.thisSymbol = thisSymbol;
        this.getSuspendResultAsType = getSuspendResultAsType;
        this.setSuspendResultValue = setSuspendResultValue;
        this.loopMap = new LinkedHashMap();
        this.unit = this.context.getIrBuiltIns().getUnitType();
        this.anyN = this.context.getIrBuiltIns().getAnyNType();
        this.nothing = this.context.getIrBuiltIns().getNothingType();
        this.booleanNotSymbol = this.context.getIrBuiltIns().getBooleanNotSymbol();
        this.eqeqeqSymbol = this.context.getIrBuiltIns().getEqeqeqSymbol();
        this.entryState = new SuspendState(this.unit);
        this.rootExceptionTrap = this.buildExceptionTrapState();
        this.globalExceptionVar = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, this.exceptionSymbolGetter.getReturnType(), this.function.getOwner(), "e", false, false, false, null, 120, null);
        this.currentState = this.entryState;
        this.currentBlock = this.entryState.getEntryBlock();
        this.returnableBlockMap = new LinkedHashMap();
        SuspendState[] suspendStateArray = new SuspendState[]{this.rootExceptionTrap};
        this.catchBlockStack = CollectionsKt.mutableListOf(suspendStateArray);
        this.tryStateMap = new LinkedHashMap();
        this.tryLoopStack = new ArrayList();
    }

    @NotNull
    public final JsCommonBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrFunctionSymbol getFunction() {
        return this.function;
    }

    private final IrGetValueImpl getThisReceiver() {
        return JsIrBuilder.INSTANCE.buildGetValue(this.thisSymbol);
    }

    @NotNull
    public final SuspendState getEntryState() {
        return this.entryState;
    }

    @NotNull
    public final SuspendState getRootExceptionTrap() {
        return this.rootExceptionTrap;
    }

    @NotNull
    public final IrCatch getGlobalCatch() {
        IrCatch irCatch = this.globalCatch;
        if (irCatch != null) {
            return irCatch;
        }
        Intrinsics.throwUninitializedPropertyAccessException("globalCatch");
        return null;
    }

    public final void setGlobalCatch(@NotNull IrCatch irCatch) {
        Intrinsics.checkNotNullParameter(irCatch, "<set-?>");
        this.globalCatch = irCatch;
    }

    public final void finalizeStateMachine() {
        this.setGlobalCatch(this.buildGlobalCatch());
        if (!(CollectionsKt.lastOrNull(this.currentBlock.getStatements()) instanceof IrReturn)) {
            this.addStatement(JsIrBuilder.INSTANCE.buildReturn(this.function, this.getUnitValue(), this.nothing));
        }
        if (!this.hasExceptions) {
            ((Collection)this.entryState.getSuccessors()).add(this.rootExceptionTrap);
        }
    }

    private final IrCatch buildGlobalCatch() {
        IrVariable catchVariable = this.globalExceptionVar;
        IrVariableSymbol globalExceptionSymbol = this.globalExceptionVar.getSymbol();
        IrBlockImpl block = JsIrBuilder.INSTANCE.buildBlock(this.unit);
        if (this.hasExceptions) {
            IrCall irCall;
            IrBlockImpl thenBlock = JsIrBuilder.INSTANCE.buildBlock(this.unit);
            IrBlockImpl elseBlock = JsIrBuilder.INSTANCE.buildBlock(this.unit);
            Object object = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.eqeqeqSymbol, null, null, null, 14, null);
            IrCall $this$buildGlobalCatch_u24lambda_u240 = object;
            boolean bl = false;
            $this$buildGlobalCatch_u24lambda_u240.putValueArgument(0, this.exceptionState());
            $this$buildGlobalCatch_u24lambda_u240.putValueArgument(1, new IrDispatchPoint(this.rootExceptionTrap));
            IrCall check2 = object;
            ((Collection)block.getStatements()).add(JsIrBuilder.INSTANCE.buildIfElse(this.unit, check2, thenBlock, elseBlock));
            ((Collection)thenBlock.getStatements()).add(JsIrBuilder.INSTANCE.buildThrow(this.nothing, JsIrBuilder.INSTANCE.buildGetValue(globalExceptionSymbol)));
            object = elseBlock.getStatements();
            IrCall $this$buildGlobalCatch_u24lambda_u241 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.stateSymbolSetter.getSymbol(), this.unit, null, null, 12, null);
            boolean bl2 = false;
            $this$buildGlobalCatch_u24lambda_u241.setDispatchReceiver(this.getThisReceiver());
            $this$buildGlobalCatch_u24lambda_u241.putValueArgument(0, this.exceptionState());
            object.add(irCall);
            object = elseBlock.getStatements();
            IrCall $this$buildGlobalCatch_u24lambda_u242 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.exceptionSymbolSetter.getSymbol(), this.unit, null, null, 12, null);
            boolean bl3 = false;
            $this$buildGlobalCatch_u24lambda_u242.setDispatchReceiver(this.getThisReceiver());
            $this$buildGlobalCatch_u24lambda_u242.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(globalExceptionSymbol));
            object.add(irCall);
        } else {
            ((Collection)block.getStatements()).add(JsIrBuilder.INSTANCE.buildThrow(this.nothing, JsIrBuilder.INSTANCE.buildGetValue(globalExceptionSymbol)));
        }
        return JsIrBuilder.INSTANCE.buildCatch(catchVariable, block);
    }

    private final SuspendState buildExceptionTrapState() {
        SuspendState state = new SuspendState(this.unit);
        ((Collection)state.getEntryBlock().getStatements()).add(JsIrBuilder.INSTANCE.buildThrow(this.nothing, this.pendingException()));
        return state;
    }

    private final void newState() {
        SuspendState newState = new SuspendState(this.unit);
        StateMachineBuilder.doDispatch$default(this, newState, false, 2, null);
        this.updateState(newState);
    }

    private final void updateState(SuspendState newState) {
        this.currentState = newState;
        this.currentBlock = newState.getEntryBlock();
    }

    private final IrExpression lastExpression() {
        IrStatement irStatement = CollectionsKt.lastOrNull(this.currentBlock.getStatements());
        IrExpression irExpression = irStatement instanceof IrExpression ? (IrExpression)irStatement : null;
        if (irExpression == null) {
            irExpression = this.getUnitValue();
        }
        return irExpression;
    }

    private final void addStatement(IrContainerExpression $this$addStatement, IrStatement statement2) {
        $this$addStatement.getStatements().add(statement2);
    }

    private final void addStatement(IrStatement statement2) {
        this.addStatement(this.currentBlock, statement2);
    }

    private final boolean isBlockEnded() {
        IrStatement irStatement = CollectionsKt.lastOrNull(this.currentBlock.getStatements());
        IrExpression irExpression = irStatement instanceof IrExpression ? (IrExpression)irStatement : null;
        if (irExpression == null) {
            return false;
        }
        IrExpression lastExpression = irExpression;
        return IrTypePredicatesKt.isNothing(lastExpression.getType());
    }

    private final void maybeDoDispatch(SuspendState target) {
        if (!this.isBlockEnded()) {
            StateMachineBuilder.doDispatch$default(this, target, false, 2, null);
        }
    }

    private final void doDispatch(SuspendState target, boolean andContinue) {
        this.doDispatchImpl(target, this.currentBlock, andContinue);
    }

    static /* synthetic */ void doDispatch$default(StateMachineBuilder stateMachineBuilder2, SuspendState suspendState, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        stateMachineBuilder2.doDispatch(suspendState, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void doDispatchImpl(SuspendState target, IrContainerExpression block, boolean andContinue) {
        void $this$doDispatchImpl_u24lambda_u243;
        IrCall irCall;
        IrDispatchPoint irDispatch = new IrDispatchPoint(target);
        this.currentState.getSuccessors().add(target);
        IrCall irCall2 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.stateSymbolSetter.getSymbol(), this.unit, null, null, 12, null);
        IrContainerExpression irContainerExpression = block;
        StateMachineBuilder stateMachineBuilder2 = this;
        boolean bl = false;
        $this$doDispatchImpl_u24lambda_u243.setDispatchReceiver(this.getThisReceiver());
        $this$doDispatchImpl_u24lambda_u243.putValueArgument(0, irDispatch);
        Unit unit2 = Unit.INSTANCE;
        stateMachineBuilder2.addStatement(irContainerExpression, irCall);
        if (andContinue) {
            this.doContinue(block);
        }
    }

    private final void doContinue(IrContainerExpression block) {
        this.addStatement(block, JsIrBuilder.INSTANCE.buildContinue(this.nothing, this.rootLoop));
    }

    static /* synthetic */ void doContinue$default(StateMachineBuilder stateMachineBuilder2, IrContainerExpression irContainerExpression, int n, Object object) {
        if ((n & 1) != 0) {
            irContainerExpression = stateMachineBuilder2.currentBlock;
        }
        stateMachineBuilder2.doContinue(irContainerExpression);
    }

    private final void transformLastExpression(Function1<? super IrExpression, ? extends IrStatement> transformer2) {
        IrExpression expression2 = this.lastExpression();
        IrStatement newStatement = transformer2.invoke(expression2);
        List<IrStatement> it = this.currentBlock.getStatements();
        boolean bl = false;
        if (!((Collection)it).isEmpty()) {
            it.set(CollectionsKt.getLastIndex(it), newStatement);
        } else {
            ((Collection)it).add(newStatement);
        }
    }

    private final IrCompositeImpl buildDispatchBlock(SuspendState target) {
        IrCompositeImpl irCompositeImpl;
        IrCompositeImpl it = irCompositeImpl = JsIrBuilder.buildComposite$default(JsIrBuilder.INSTANCE, this.unit, null, 2, null);
        boolean bl = false;
        this.doDispatchImpl(target, it, true);
        return irCompositeImpl;
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        if (this.suspendableNodes.contains(element)) {
            IrVisitorsKt.acceptChildrenVoid(element, this);
        } else {
            this.addStatement((IrStatement)element);
        }
    }

    private final void transformLoop(IrLoop loop2, Function3<? super IrLoop, ? super SuspendState, ? super SuspendState, Unit> transformer2) {
        boolean bl;
        IrExpression irExpression;
        if (!this.suspendableNodes.contains(loop2)) {
            this.addStatement(loop2);
            return;
        }
        this.newState();
        SuspendState loopHeadState = this.currentState;
        SuspendState loopExitState = new SuspendState(this.unit);
        this.loopMap.put(loop2, new LoopBounds(loopHeadState, loopExitState));
        UtilsKt.push(this.tryLoopStack, loop2);
        transformer2.invoke(loop2, loopHeadState, loopExitState);
        IrExpression it = irExpression = UtilsKt.pop(this.tryLoopStack);
        boolean bl2 = false;
        boolean bl3 = bl = it == loop2;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.loopMap.remove(loop2);
        this.updateState(loopExitState);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
        Intrinsics.checkNotNullParameter(loop2, "loop");
        this.transformLoop(loop2, (Function3<? super IrLoop, ? super SuspendState, ? super SuspendState, Unit>)new Function3<IrLoop, SuspendState, SuspendState, Unit>(this){
            final /* synthetic */ StateMachineBuilder this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(@NotNull IrLoop l, @NotNull SuspendState head, @NotNull SuspendState exit) {
                Intrinsics.checkNotNullParameter(l, "l");
                Intrinsics.checkNotNullParameter(head, "head");
                Intrinsics.checkNotNullParameter(exit, "exit");
                IrVisitorsKt.acceptVoid(l.getCondition(), this.this$0);
                StateMachineBuilder.access$transformLastExpression(this.this$0, new Function1<IrExpression, IrStatement>(this.this$0, exit){
                    final /* synthetic */ StateMachineBuilder this$0;
                    final /* synthetic */ SuspendState $exit;
                    {
                        this.this$0 = $receiver;
                        this.$exit = $exit;
                        super(1);
                    }

                    @NotNull
                    public final IrStatement invoke(@NotNull IrExpression it) {
                        IrCall irCall;
                        Intrinsics.checkNotNullParameter(it, "it");
                        IrCall $this$invoke_u24lambda_u240 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, StateMachineBuilder.access$getBooleanNotSymbol$p(this.this$0), null, null, null, 14, null);
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.setDispatchReceiver(it);
                        IrCall exitCond = irCall;
                        IrCompositeImpl irBreak = StateMachineBuilder.access$buildDispatchBlock(this.this$0, this.$exit);
                        return JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, StateMachineBuilder.access$getUnit$p(this.this$0), exitCond, irBreak, null, 8, null);
                    }
                });
                IrExpression irExpression = l.getBody();
                if (irExpression != null) {
                    IrVisitorsKt.acceptVoid(irExpression, this.this$0);
                }
                StateMachineBuilder.doDispatch$default(this.this$0, head, false, 2, null);
            }
        });
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
        Intrinsics.checkNotNullParameter(loop2, "loop");
        this.transformLoop(loop2, (Function3<? super IrLoop, ? super SuspendState, ? super SuspendState, Unit>)new Function3<IrLoop, SuspendState, SuspendState, Unit>(this){
            final /* synthetic */ StateMachineBuilder this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(@NotNull IrLoop l, @NotNull SuspendState head, @NotNull SuspendState exit) {
                Intrinsics.checkNotNullParameter(l, "l");
                Intrinsics.checkNotNullParameter(head, "head");
                Intrinsics.checkNotNullParameter(exit, "exit");
                IrExpression irExpression = l.getBody();
                if (irExpression != null) {
                    IrVisitorsKt.acceptVoid(irExpression, this.this$0);
                }
                IrVisitorsKt.acceptVoid(l.getCondition(), this.this$0);
                StateMachineBuilder.access$transformLastExpression(this.this$0, new Function1<IrExpression, IrStatement>(this.this$0, head){
                    final /* synthetic */ StateMachineBuilder this$0;
                    final /* synthetic */ SuspendState $head;
                    {
                        this.this$0 = $receiver;
                        this.$head = $head;
                        super(1);
                    }

                    @NotNull
                    public final IrStatement invoke(@NotNull IrExpression it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        IrCompositeImpl irContinue = StateMachineBuilder.access$buildDispatchBlock(this.this$0, this.$head);
                        return JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, StateMachineBuilder.access$getUnit$p(this.this$0), it, irContinue, null, 8, null);
                    }
                });
                StateMachineBuilder.doDispatch$default(this.this$0, exit, false, 2, null);
            }
        });
    }

    private final IrTypeOperatorCallImpl implicitCast(IrExpression value2, IrType toType) {
        return JsIrBuilder.INSTANCE.buildImplicitCast(value2, toType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
        if (IrUtilsKt.isSuspend(expression2)) {
            IrCall irCall;
            IrExpression result2 = this.lastExpression();
            IrType expectedType = ((IrSimpleFunction)expression2.getSymbol().getOwner()).getReturnType();
            boolean isInlineClassExpected = this.context.getInlineClassesUtils().getInlinedClass(expectedType) != null;
            SuspendState continueState = new SuspendState(this.unit);
            SuspendState unboxState = isInlineClassExpected ? new SuspendState(this.unit) : null;
            SuspendState suspendState = unboxState;
            if (suspendState == null) {
                suspendState = continueState;
            }
            IrDispatchPoint dispatch = new IrDispatchPoint(suspendState);
            if (unboxState != null) {
                ((Collection)this.currentState.getSuccessors()).add(unboxState);
            }
            ((Collection)this.currentState.getSuccessors()).add(continueState);
            this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)new Function1<IrExpression, IrStatement>(this, dispatch){
                final /* synthetic */ StateMachineBuilder this$0;
                final /* synthetic */ IrDispatchPoint $dispatch;
                {
                    this.this$0 = $receiver;
                    this.$dispatch = $dispatch;
                    super(1);
                }

                @NotNull
                public final IrStatement invoke(@NotNull IrExpression it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, StateMachineBuilder.access$getStateSymbolSetter$p(this.this$0).getSymbol(), StateMachineBuilder.access$getUnit$p(this.this$0), null, null, 12, null);
                    StateMachineBuilder stateMachineBuilder2 = this.this$0;
                    IrDispatchPoint irDispatchPoint = this.$dispatch;
                    IrCall $this$invoke_u24lambda_u240 = irCall;
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.setDispatchReceiver(StateMachineBuilder.access$getThisReceiver(stateMachineBuilder2));
                    $this$invoke_u24lambda_u240.putValueArgument(0, irDispatchPoint);
                    return irCall;
                }
            });
            this.addStatement(this.setSuspendResultValue.invoke(result2));
            IrReturnImpl irReturn = JsIrBuilder.INSTANCE.buildReturn(this.function, this.getSuspendResultAsType.invoke(this.anyN), this.nothing);
            IrCall $this$visitCall_u24lambda_u247 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.eqeqeqSymbol, null, null, null, 14, null);
            boolean bl2 = false;
            $this$visitCall_u24lambda_u247.putValueArgument(0, this.getSuspendResultAsType.invoke(this.anyN));
            $this$visitCall_u24lambda_u247.putValueArgument(1, JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.context.getIr().getSymbols().getCoroutineSuspendedGetter(), null, null, null, 14, null));
            IrCall check2 = irCall;
            IrBlockImpl suspensionBlock = JsIrBuilder.INSTANCE.buildBlock(this.unit, CollectionsKt.listOf(irReturn));
            this.addStatement(JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, this.unit, check2, suspensionBlock, null, 8, null));
            if (isInlineClassExpected) {
                void $this$visitCall_u24lambda_u248;
                IrCall irCall2;
                IrCall bl2 = irCall2 = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.stateSymbolSetter.getSymbol(), this.unit, null, null, 12, null);
                StateMachineBuilder stateMachineBuilder2 = this;
                boolean bl3 = false;
                $this$visitCall_u24lambda_u248.setDispatchReceiver(this.getThisReceiver());
                $this$visitCall_u24lambda_u248.putValueArgument(0, new IrDispatchPoint(continueState));
                stateMachineBuilder2.addStatement(irCall2);
            }
            StateMachineBuilder.doContinue$default(this, null, 1, null);
            SuspendState suspendState2 = unboxState;
            if (suspendState2 != null) {
                SuspendState it = suspendState2;
                boolean bl4 = false;
                this.buildUnboxingState(it, continueState, expectedType);
            }
            this.updateState(continueState);
            this.addStatement(this.getSuspendResultAsType.invoke(expression2.getType()));
        }
    }

    private final void buildUnboxingState(SuspendState unboxState, SuspendState continueState, IrType expectedType) {
        ((Collection)unboxState.getSuccessors()).add(continueState);
        this.updateState(unboxState);
        IrExpression result2 = this.getSuspendResultAsType.invoke(this.anyN);
        IrVariable tmp = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, expectedType, this.function.getOwner(), "unboxed", false, false, false, result2, 56, null);
        this.addStatement(tmp);
        this.addStatement(this.setSuspendResultValue.invoke(JsIrBuilder.INSTANCE.buildGetValue(tmp.getSymbol())));
        StateMachineBuilder.doDispatch$default(this, continueState, false, 2, null);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump) {
        Intrinsics.checkNotNullParameter(jump, "jump");
        LoopBounds loopBounds = this.loopMap.get(jump.getLoop());
        Intrinsics.checkNotNull(loopBounds);
        SuspendState exitState = loopBounds.getExitState();
        this.resetExceptionStateIfNeeded(jump.getLoop());
        StateMachineBuilder.doDispatch$default(this, exitState, false, 2, null);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump) {
        Intrinsics.checkNotNullParameter(jump, "jump");
        LoopBounds loopBounds = this.loopMap.get(jump.getLoop());
        Intrinsics.checkNotNull(loopBounds);
        SuspendState headState = loopBounds.getHeadState();
        this.resetExceptionStateIfNeeded(jump.getLoop());
        StateMachineBuilder.doDispatch$default(this, headState, false, 2, null);
    }

    private final void resetExceptionStateIfNeeded(IrLoop loop2) {
        IrExpression nearestTry = null;
        boolean found = false;
        boolean needReset = false;
        for (IrExpression e : CollectionsKt.asReversedMutable(this.tryLoopStack)) {
            if (e instanceof IrTry) {
                boolean bl = needReset = !found;
            }
            if (e == loop2) {
                found = true;
            }
            if (!found || !(e instanceof IrTry)) continue;
            nearestTry = e;
            break;
        }
        if (needReset) {
            Object object = this.tryStateMap.get(nearestTry);
            if (object == null || (object = ((TryState)object).getCatchState()) == null) {
                object = this.rootExceptionTrap;
            }
            Object tryState = object;
            this.setupExceptionState((SuspendState)tryState);
        }
    }

    private final IrSetValueImpl wrap(IrExpression expression2, IrVariableSymbol variable2) {
        return JsIrBuilder.INSTANCE.buildSetVariable(variable2, expression2, this.unit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitWhen(@NotNull IrWhen expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addStatement(expression2);
            return;
        }
        SuspendState exitState = new SuspendState(expression2.getType());
        IrVariableSymbol varSymbol = null;
        List branches = null;
        if (this.hasResultingValue(expression2)) {
            void $this$mapTo$iv$iv;
            IrVariable irVar = this.tempVar(expression2.getType(), "WHEN_RESULT");
            varSymbol = irVar.getSymbol();
            this.addStatement(irVar);
            Iterable $this$map$iv = expression2.getBranches();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrBranch irBranch = (IrBranch)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                IrSetValueImpl wrapped = this.wrap(it.getResult(), varSymbol);
                if (this.suspendableNodes.contains(it.getResult())) {
                    ((Collection)this.suspendableNodes).add(wrapped);
                }
                collection.add(IrUtilsKt.isElseBranch((IrBranch)it) ? (IrBranch)new IrElseBranchImpl(it.getStartOffset(), it.getEndOffset(), it.getCondition(), wrapped) : (IrBranch)new IrBranchImpl(it.getStartOffset(), it.getEndOffset(), it.getCondition(), wrapped));
            }
            branches = (List)destination$iv$iv;
        } else {
            varSymbol = null;
            branches = expression2.getBranches();
        }
        for (IrBranch branch : branches) {
            if (!IrUtilsKt.isElseBranch(branch)) {
                IrVisitorsKt.acceptVoid(branch.getCondition(), this);
                IrCompositeImpl branchBlock = JsIrBuilder.buildComposite$default(JsIrBuilder.INSTANCE, branch.getResult().getType(), null, 2, null);
                IrCompositeImpl elseBlock = JsIrBuilder.buildComposite$default(JsIrBuilder.INSTANCE, expression2.getType(), null, 2, null);
                SuspendState dispatchState = this.currentState;
                this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)new Function1<IrExpression, IrStatement>(this, branchBlock, elseBlock){
                    final /* synthetic */ StateMachineBuilder this$0;
                    final /* synthetic */ IrCompositeImpl $branchBlock;
                    final /* synthetic */ IrCompositeImpl $elseBlock;
                    {
                        this.this$0 = $receiver;
                        this.$branchBlock = $branchBlock;
                        this.$elseBlock = $elseBlock;
                        super(1);
                    }

                    @NotNull
                    public final IrStatement invoke(@NotNull IrExpression it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return JsIrBuilder.INSTANCE.buildIfElse(StateMachineBuilder.access$getUnit$p(this.this$0), it, this.$branchBlock, this.$elseBlock);
                    }
                });
                this.currentBlock = branchBlock;
                IrVisitorsKt.acceptVoid(branch.getResult(), this);
                if (!this.isBlockEnded()) {
                    StateMachineBuilder.doDispatch$default(this, exitState, false, 2, null);
                }
                this.currentState = dispatchState;
                this.currentBlock = elseBlock;
                continue;
            }
            IrVisitorsKt.acceptVoid(branch.getResult(), this);
            if (this.isBlockEnded()) break;
            StateMachineBuilder.doDispatch$default(this, exitState, false, 2, null);
            break;
        }
        this.maybeDoDispatch(exitState);
        this.updateState(exitState);
        if (varSymbol != null) {
            this.addStatement(JsIrBuilder.INSTANCE.buildGetValue(varSymbol));
        }
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addStatement(expression2);
            return;
        }
        IrVisitorsKt.acceptChildrenVoid(expression2, this);
        this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)new Function1<IrExpression, IrStatement>(expression2){
            final /* synthetic */ IrSetValue $expression;
            {
                this.$expression = $expression;
                super(1);
            }

            @NotNull
            public final IrStatement invoke(@NotNull IrExpression it) {
                IrSetValue irSetValue;
                Intrinsics.checkNotNullParameter(it, "it");
                IrSetValue $this$invoke_u24lambda_u240 = irSetValue = this.$expression;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setValue(it);
                return irSetValue;
            }
        });
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addStatement(expression2);
            return;
        }
        IrVisitorsKt.acceptChildrenVoid(expression2, this);
        this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)new Function1<IrExpression, IrStatement>(expression2){
            final /* synthetic */ IrTypeOperatorCall $expression;
            {
                this.$expression = $expression;
                super(1);
            }

            @NotNull
            public final IrStatement invoke(@NotNull IrExpression it) {
                IrTypeOperatorCall irTypeOperatorCall;
                Intrinsics.checkNotNullParameter(it, "it");
                IrTypeOperatorCall $this$invoke_u24lambda_u240 = irTypeOperatorCall = this.$expression;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setArgument(it);
                return irTypeOperatorCall;
            }
        });
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (!this.suspendableNodes.contains(declaration)) {
            this.addStatement(declaration);
            return;
        }
        IrVisitorsKt.acceptChildrenVoid(declaration, this);
        this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)new Function1<IrExpression, IrStatement>(declaration){
            final /* synthetic */ IrVariable $declaration;
            {
                this.$declaration = $declaration;
                super(1);
            }

            @NotNull
            public final IrStatement invoke(@NotNull IrExpression it) {
                IrVariable irVariable2;
                Intrinsics.checkNotNullParameter(it, "it");
                IrVariable $this$invoke_u24lambda_u240 = irVariable2 = this.$declaration;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setInitializer(it);
                return irVariable2;
            }
        });
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addStatement(expression2);
            return;
        }
        IrVisitorsKt.acceptChildrenVoid(expression2, this);
        this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)new Function1<IrExpression, IrStatement>(expression2){
            final /* synthetic */ IrGetField $expression;
            {
                this.$expression = $expression;
                super(1);
            }

            @NotNull
            public final IrStatement invoke(@NotNull IrExpression it) {
                IrGetField irGetField;
                Intrinsics.checkNotNullParameter(it, "it");
                IrGetField $this$invoke_u24lambda_u240 = irGetField = this.$expression;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setReceiver(it);
                return irGetField;
            }
        });
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addStatement(expression2);
            return;
        }
        IrVisitorsKt.acceptChildrenVoid(expression2, this);
        this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)new Function1<IrExpression, IrStatement>(expression2){
            final /* synthetic */ IrGetClass $expression;
            {
                this.$expression = $expression;
                super(1);
            }

            @NotNull
            public final IrStatement invoke(@NotNull IrExpression it) {
                IrGetClass irGetClass;
                Intrinsics.checkNotNullParameter(it, "it");
                IrGetClass $this$invoke_u24lambda_u240 = irGetClass = this.$expression;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setArgument(it);
                return irGetClass;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitVararg(@NotNull IrVararg expression2) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        void $this$toTypedArray$iv;
        int n;
        Collection collection;
        void $this$mapIndexedTo$iv$iv2;
        Collection $this$mapIndexed$iv2;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addStatement(expression2);
            return;
        }
        Set spreadIndices = new LinkedHashSet();
        Iterable iterable = expression2.getElements();
        boolean $i$f$mapIndexed = false;
        void var6_6 = $this$mapIndexed$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv2, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv2) {
            IrExpression irExpression;
            void item;
            int n2;
            if ((n2 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
            int n3 = n2;
            collection = destination$iv$iv;
            n = 0;
            if (item instanceof IrSpreadElement) {
                void index2;
                spreadIndices.add((int)index2);
                irExpression = ((IrSpreadElement)item).getExpression();
            } else {
                Intrinsics.checkNotNull(item, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                irExpression = (IrExpression)item;
            }
            collection.add(irExpression);
        }
        $this$mapIndexed$iv2 = (List)destination$iv$iv;
        boolean $i$f$toTypedArray22 = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        IrExpression[] arguments2 = thisCollection$iv.toArray(new IrExpression[0]);
        IrExpression[] $i$f$toTypedArray22 = this.transformArguments(arguments2);
        boolean $i$f$mapIndexed2 = false;
        destination$iv$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv2 = new ArrayList(((void)$this$mapIndexed$iv).length);
        boolean $i$f$mapIndexedTo2 = false;
        int index$iv$iv2 = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index3;
            void item;
            int n4 = index$iv$iv2++;
            void index2 = item$iv$iv;
            n = n4;
            collection = destination$iv$iv2;
            boolean bl = false;
            if (item == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            collection.add(spreadIndices.contains((int)index3) ? (IrElement)new IrSpreadElementImpl(item.getStartOffset(), item.getEndOffset(), (IrExpression)item) : (IrElement)item);
        }
        List newArgs2 = CollectionsKt.toList((List)destination$iv$iv2);
        this.addStatement(new IrVarargImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), expression2.getVarargElementType(), newArgs2));
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression[] transformArguments(IrExpression[] arguments2) {
        void $this$fold$iv;
        IrExpression[] irExpressionArray = arguments2;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (String element$iv : $this$fold$iv) {
            void n;
            void var10_12 = element$iv;
            int r = accumulator$iv;
            boolean bl = false;
            accumulator$iv = n != null && this.suspendableNodes.contains(n) ? r + 1 : r;
        }
        int suspendableCount = accumulator$iv;
        IrExpression[] newArguments2 = new IrExpression[arguments2.length];
        int n = arguments2.length;
        for (int i = 0; i < n; ++i) {
            IrExpression irExpression;
            int i2 = i;
            IrExpression arg = arguments2[i];
            IrExpression[] irExpressionArray2 = newArguments2;
            int n2 = i2;
            if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isPure$default(arg, false, false, null, 6, null)) {
                irExpression = arg;
            } else {
                if (!(arg != null)) {
                    String element$iv;
                    element$iv = "Failed requirement.";
                    throw new IllegalArgumentException(element$iv.toString());
                }
                if (suspendableCount > 0) {
                    if (this.suspendableNodes.contains(arg)) {
                        --suspendableCount;
                    }
                    IrVisitorsKt.acceptVoid(arg, this);
                    IrVariable irVar = this.tempVar(arg.getType(), "ARGUMENT");
                    this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)new Function1<IrExpression, IrStatement>(irVar){
                        final /* synthetic */ IrVariable $irVar;
                        {
                            this.$irVar = $irVar;
                            super(1);
                        }

                        @NotNull
                        public final IrStatement invoke(@NotNull IrExpression it) {
                            IrVariable irVariable2;
                            Intrinsics.checkNotNullParameter(it, "it");
                            IrVariable $this$invoke_u24lambda_u240 = irVariable2 = this.$irVar;
                            boolean bl = false;
                            $this$invoke_u24lambda_u240.setInitializer(it);
                            return irVariable2;
                        }
                    });
                    irExpression = JsIrBuilder.INSTANCE.buildGetValue(irVar.getSymbol());
                } else {
                    void p1;
                    DeepCopyTypeRemapper typeRemapper$iv$iv;
                    void $this$deepCopyWithSymbols$iv$iv;
                    void $this$deepCopyWithSymbols_u24default$iv;
                    IrElement irVar = arg;
                    IrDeclarationParent initialParent$iv = this.function.getOwner();
                    boolean $i$f$deepCopyWithSymbols = false;
                    void bl = $this$deepCopyWithSymbols_u24default$iv;
                    DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                    boolean $i$f$deepCopyWithSymbols2 = false;
                    IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv$iv, symbolRemapper$iv$iv);
                    TypeRemapper typeRemapper = typeRemapper$iv$iv = new DeepCopyTypeRemapper(symbolRemapper$iv$iv);
                    DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                    void var21_25 = $this$deepCopyWithSymbols$iv$iv;
                    int n3 = n2;
                    IrExpression[] irExpressionArray3 = irExpressionArray2;
                    boolean bl2 = false;
                    typeRemapper = typeRemapper;
                    SymbolRemapper p0 = deepCopySymbolRemapper;
                    DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols(p0, (TypeRemapper)p1);
                    irExpressionArray2 = irExpressionArray3;
                    n2 = n3;
                    IrElement irElement = PatchDeclarationParentsKt.patchDeclarationParents(var21_25.transform(deepCopyIrTreeWithSymbols, null), initialParent$iv);
                    if (irElement == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                    }
                    irExpression = (IrExpression)((IrElement)((IrExpression)irElement));
                }
            }
            irExpressionArray2[n2] = irExpression;
        }
        return newArguments2;
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addExceptionEdge();
            this.addStatement(expression2);
            return;
        }
        IrExpression[] arguments2 = new IrExpression[expression2.getValueArgumentsCount() + 2];
        arguments2[0] = expression2.getDispatchReceiver();
        arguments2[1] = expression2.getExtensionReceiver();
        int n = expression2.getValueArgumentsCount();
        for (int i = 0; i < n; ++i) {
            arguments2[i + 2] = expression2.getValueArgument(i);
        }
        IrExpression[] newArguments2 = this.transformArguments(arguments2);
        expression2.setDispatchReceiver(newArguments2[0]);
        expression2.setExtensionReceiver(newArguments2[1]);
        int n2 = expression2.getValueArgumentsCount();
        for (int i = 0; i < n2; ++i) {
            expression2.putValueArgument(i, newArguments2[i + 2]);
        }
        this.addExceptionEdge();
        this.addStatement(expression2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitSetField(@NotNull IrSetField expression2) {
        void $this$visitSetField_u24lambda_u2414;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addStatement(expression2);
            return;
        }
        IrExpression[] irExpressionArray = new IrExpression[]{expression2.getReceiver(), expression2.getValue()};
        IrExpression[] newArguments2 = this.transformArguments(irExpressionArray);
        IrExpression receiver = newArguments2[0];
        IrExpression irExpression = newArguments2[1];
        Intrinsics.checkNotNull(irExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
        IrExpression value2 = irExpression;
        IrSetField irSetField = expression2;
        StateMachineBuilder stateMachineBuilder2 = this;
        boolean bl = false;
        stateMachineBuilder2.addStatement(new IrSetFieldImpl($this$visitSetField_u24lambda_u2414.getStartOffset(), $this$visitSetField_u24lambda_u2414.getEndOffset(), $this$visitSetField_u24lambda_u2414.getSymbol(), receiver, value2, this.unit, $this$visitSetField_u24lambda_u2414.getOrigin(), $this$visitSetField_u24lambda_u2414.getSuperQualifierSymbol()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        Collection<void> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$visitStringConcatenation_u24lambda_u2417;
        Object item$iv2;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addStatement(expression2);
            return;
        }
        IrExpression[] arguments2 = new IrExpression[expression2.getArguments().size()];
        Iterable $this$forEachIndexed$iv = expression2.getArguments();
        boolean $i$f$forEachIndexed = false;
        int index$iv22 = 0;
        for (Object item$iv2 : $this$forEachIndexed$iv) {
            void a;
            int n;
            if ((n = index$iv22++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrExpression irExpression = (IrExpression)item$iv2;
            int i = n;
            boolean bl = false;
            arguments2[i] = a;
        }
        IrExpression[] newArguments2 = this.transformArguments(arguments2);
        IrStringConcatenation index$iv22 = expression2;
        StateMachineBuilder stateMachineBuilder2 = this;
        boolean bl = false;
        item$iv2 = newArguments2;
        IrType irType = $this$visitStringConcatenation_u24lambda_u2417.getType();
        int n = $this$visitStringConcatenation_u24lambda_u2417.getEndOffset();
        int n2 = $this$visitStringConcatenation_u24lambda_u2417.getStartOffset();
        boolean $i$f$map = false;
        void var13_18 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n3 = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n3; ++i) {
            void it;
            void item$iv$iv;
            void var19_24 = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl2 = false;
            void v0 = it;
            Intrinsics.checkNotNull(v0);
            collection.add(v0);
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        IrType irType2 = irType;
        int n4 = n;
        int n5 = n2;
        stateMachineBuilder2.addStatement(new IrStringConcatenationImpl(n5, n4, irType2, collection2));
    }

    private final IrGetObjectValueImpl getUnitValue() {
        return JsIrBuilder.INSTANCE.buildGetObjectValue(this.unit, this.context.getIrBuiltIns().getUnitClass());
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrVisitorsKt.acceptChildrenVoid(expression2, this);
        IrReturnTargetSymbol returnTarget = expression2.getReturnTargetSymbol();
        if (returnTarget instanceof IrReturnableBlockSymbol) {
            Pair<SuspendState, IrVariableSymbol> pair = this.returnableBlockMap.get(returnTarget);
            Intrinsics.checkNotNull(pair);
            Pair<SuspendState, IrVariableSymbol> pair2 = pair;
            SuspendState exitState = pair2.component1();
            IrVariableSymbol varSymbol = pair2.component2();
            if (varSymbol != null) {
                this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)new Function1<IrExpression, IrStatement>(varSymbol){
                    final /* synthetic */ IrVariableSymbol $varSymbol;
                    {
                        this.$varSymbol = $varSymbol;
                        super(1);
                    }

                    @NotNull
                    public final IrStatement invoke(@NotNull IrExpression it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return JsIrBuilder.INSTANCE.buildSetVariable(this.$varSymbol, it, it.getType());
                    }
                });
            }
            this.maybeDoDispatch(exitState);
        } else {
            this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)new Function1<IrExpression, IrStatement>(expression2){
                final /* synthetic */ IrReturn $expression;
                {
                    this.$expression = $expression;
                    super(1);
                }

                @NotNull
                public final IrStatement invoke(@NotNull IrExpression it) {
                    IrReturn irReturn;
                    Intrinsics.checkNotNullParameter(it, "it");
                    IrReturn $this$invoke_u24lambda_u240 = irReturn = this.$expression;
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.setValue(it);
                    return irReturn;
                }
            });
        }
    }

    private final void addExceptionEdge() {
        this.hasExceptions = true;
        Collection collection = this.currentState.getSuccessors();
        SuspendState suspendState = UtilsKt.peek(this.catchBlockStack);
        Intrinsics.checkNotNull(suspendState);
        collection.add(suspendState);
    }

    private final boolean hasResultingValue(IrExpression expression2) {
        IrType $this$hasResultingValue_u24lambda_u2418 = expression2.getType();
        boolean bl = false;
        return !(IrTypePredicatesKt.isNothing($this$hasResultingValue_u24lambda_u2418) || IrTypePredicatesKt.isUnit($this$hasResultingValue_u24lambda_u2418));
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrVisitorsKt.acceptChildrenVoid(expression2, this);
        this.addExceptionEdge();
        this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)new Function1<IrExpression, IrStatement>(expression2){
            final /* synthetic */ IrThrow $expression;
            {
                this.$expression = $expression;
                super(1);
            }

            @NotNull
            public final IrStatement invoke(@NotNull IrExpression it) {
                IrThrow irThrow;
                Intrinsics.checkNotNullParameter(it, "it");
                IrThrow $this$invoke_u24lambda_u240 = irThrow = this.$expression;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setValue(it);
                return irThrow;
            }
        });
    }

    @Override
    public void visitTry(@NotNull IrTry aTry) {
        boolean bl;
        IrExpression irExpression;
        IrExpression it;
        IrExpression irExpression2;
        IrVariable varSymbol;
        Intrinsics.checkNotNullParameter(aTry, "aTry");
        if (!(aTry.getFinallyExpression() == null)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        TryState tryState = this.buildTryState();
        SuspendState suspendState = UtilsKt.peek(this.catchBlockStack);
        Intrinsics.checkNotNull(suspendState);
        SuspendState enclosingCatch = suspendState;
        this.tryStateMap.put(aTry, tryState);
        UtilsKt.push(this.catchBlockStack, tryState.getCatchState());
        UtilsKt.push(this.tryLoopStack, aTry);
        SuspendState exitState = new SuspendState(this.unit);
        IrVariable irVariable2 = varSymbol = this.hasResultingValue(aTry) ? this.tempVar(aTry.getType(), "TRY_RESULT") : null;
        if (varSymbol != null) {
            this.addStatement(varSymbol);
        }
        this.setupExceptionState(tryState.getCatchState());
        if (varSymbol != null) {
            it = irExpression2 = JsIrBuilder.INSTANCE.buildSetVariable(varSymbol.getSymbol(), aTry.getTryResult(), this.unit);
            boolean bl2 = false;
            if (this.suspendableNodes.contains(it.getValue())) {
                ((Collection)this.suspendableNodes).add(it);
            }
            irExpression = irExpression2;
        } else {
            irExpression = aTry.getTryResult();
        }
        IrExpression tryResult = irExpression;
        IrVisitorsKt.acceptVoid(tryResult, this);
        if (!this.isBlockEnded()) {
            this.setupExceptionState(enclosingCatch);
            StateMachineBuilder.doDispatch$default(this, exitState, false, 2, null);
        }
        this.addExceptionEdge();
        this.tryStateMap.remove(aTry);
        irExpression2 = UtilsKt.pop(this.tryLoopStack);
        it = irExpression2;
        boolean bl3 = false;
        boolean bl4 = bl = it == aTry;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        UtilsKt.pop(this.catchBlockStack);
        this.updateState(tryState.getCatchState());
        this.setupExceptionState(enclosingCatch);
        boolean rethrowNeeded = true;
        for (IrCatch irCatch : aTry.getCatches()) {
            IrExpression catchResult;
            IrExpression irExpression3;
            IrType type2 = irCatch.getCatchParameter().getType();
            IrExpression initializer2 = !(type2 instanceof IrDynamicType) ? (IrExpression)this.implicitCast(this.pendingException(), type2) : (IrExpression)this.pendingException();
            IrVariable irVariable3 = irCatch.getCatchParameter();
            IrElementBase it2 = irVariable3;
            boolean bl5 = false;
            ((IrVariable)it2).setInitializer(initializer2);
            IrVariable irVar = irVariable3;
            if (varSymbol != null) {
                IrElementBase it3 = it2 = JsIrBuilder.INSTANCE.buildSetVariable(varSymbol.getSymbol(), irCatch.getResult(), this.unit);
                boolean bl6 = false;
                if (this.suspendableNodes.contains(((IrSetValueImpl)it3).getValue())) {
                    ((Collection)this.suspendableNodes).add(it3);
                }
                irExpression3 = (IrExpression)it2;
            } else {
                irExpression3 = catchResult = irCatch.getResult();
            }
            if (type2 instanceof IrDynamicType) {
                rethrowNeeded = false;
                this.addStatement(irVar);
                IrVisitorsKt.acceptVoid(catchResult, this);
                this.maybeDoDispatch(exitState);
                continue;
            }
            IrTypeOperatorCallImpl check2 = this.buildIsCheck(this.pendingException(), type2);
            IrCompositeImpl branchBlock = JsIrBuilder.buildComposite$default(JsIrBuilder.INSTANCE, catchResult.getType(), null, 2, null);
            IrCompositeImpl elseBlock = JsIrBuilder.buildComposite$default(JsIrBuilder.INSTANCE, catchResult.getType(), null, 2, null);
            IrWhen irIf = JsIrBuilder.INSTANCE.buildIfElse(catchResult.getType(), check2, branchBlock, elseBlock);
            IrContainerExpression ifBlock = this.currentBlock;
            this.currentBlock = branchBlock;
            this.addStatement(irVar);
            IrVisitorsKt.acceptVoid(catchResult, this);
            this.maybeDoDispatch(exitState);
            this.currentBlock = ifBlock;
            this.addStatement(irIf);
            this.currentBlock = elseBlock;
        }
        if (rethrowNeeded) {
            this.addExceptionEdge();
            this.addStatement(JsIrBuilder.INSTANCE.buildThrow(this.nothing, this.pendingException()));
        }
        ((Collection)this.currentState.getSuccessors()).add(enclosingCatch);
        this.updateState(exitState);
        this.setupExceptionState(enclosingCatch);
        if (varSymbol != null) {
            this.addStatement(JsIrBuilder.INSTANCE.buildGetValue(varSymbol.getSymbol()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setupExceptionState(SuspendState target) {
        void $this$setupExceptionState_u24lambda_u2423;
        IrCall irCall;
        IrCall irCall2 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.exStateSymbolSetter.getSymbol(), this.unit, null, null, 12, null);
        StateMachineBuilder stateMachineBuilder2 = this;
        boolean bl = false;
        $this$setupExceptionState_u24lambda_u2423.setDispatchReceiver(this.getThisReceiver());
        $this$setupExceptionState_u24lambda_u2423.putValueArgument(0, new IrDispatchPoint(target));
        stateMachineBuilder2.addStatement(irCall);
    }

    private final IrCall exceptionState() {
        IrCall irCall;
        IrCall it = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.exStateSymbolGetter.getSymbol(), null, null, null, 14, null);
        boolean bl = false;
        it.setDispatchReceiver(this.getThisReceiver());
        return irCall;
    }

    private final IrCall pendingException() {
        IrCall irCall;
        IrCall it = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.exceptionSymbolGetter.getSymbol(), null, null, null, 14, null);
        boolean bl = false;
        it.setDispatchReceiver(this.getThisReceiver());
        return irCall;
    }

    private final TryState buildTryState() {
        return new TryState(this.currentState, new SuspendState(this.unit));
    }

    private final IrTypeOperatorCallImpl buildIsCheck(IrExpression value2, IrType toType) {
        return JsIrBuilder.INSTANCE.buildTypeOperator(this.context.getIrBuiltIns().getBooleanType(), IrTypeOperator.INSTANCEOF, value2, toType);
    }

    private final IrVariable tempVar(IrType type2, String name) {
        return JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, type2, this.function.getOwner(), name, false, false, false, null, 120, null);
    }

    @Override
    public void visitElement(@NotNull IrElement element, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
    }

    @Override
    public void visitBody(@NotNull IrBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration) {
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression2, data);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression2, data);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression2, data);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression2, data);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
    }

    @Override
    public void visitField(@NotNull IrField declaration) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
    }

    @Override
    public void visitField(@NotNull IrField declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
    }

    public static final /* synthetic */ void access$transformLastExpression(StateMachineBuilder $this, Function1 transformer2) {
        $this.transformLastExpression(transformer2);
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getBooleanNotSymbol$p(StateMachineBuilder $this) {
        return $this.booleanNotSymbol;
    }

    public static final /* synthetic */ IrCompositeImpl access$buildDispatchBlock(StateMachineBuilder $this, SuspendState target) {
        return $this.buildDispatchBlock(target);
    }

    public static final /* synthetic */ IrType access$getUnit$p(StateMachineBuilder $this) {
        return $this.unit;
    }

    public static final /* synthetic */ IrSimpleFunction access$getStateSymbolSetter$p(StateMachineBuilder $this) {
        return $this.stateSymbolSetter;
    }

    public static final /* synthetic */ IrGetValueImpl access$getThisReceiver(StateMachineBuilder $this) {
        return $this.getThisReceiver();
    }
}

