/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.backend.js.JsStatementOrigins;
import org.jetbrains.kotlin.ir.backend.js.SourceMapsInfo;
import org.jetbrains.kotlin.ir.backend.js.SourceMapsInfoKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.BaseIrElementToJsNodeTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsStatementTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsClassGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContextKt;
import org.jetbrains.kotlin.ir.backend.js.utils.LocalNameGenerator;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithEmbeddedSource;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithSource;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u00ce\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\t\u001a\u00020\n\u001a$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011\u001a,\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0001\u001a\u001a\u0010\u0014\u001a\u00020\u00152\b\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0001\u001a\u0018\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001\u001a\u0018\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u001d2\b\u0010\r\u001a\u0004\u0018\u00010\u0001\u001a \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u001d2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0001\u001a\u001e\u0010%\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'\u001a*\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'\u001a \u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\u0010\u000e\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0004\u001a\u00020\u0005\u001a,\u0010/\u001a\u000200\"\b\b\u0000\u00101*\u000202*\u0002H12\u0006\u00103\u001a\u0002042\u0006\u0010\u0004\u001a\u00020\u0005H\u0082\b\u00a2\u0006\u0002\u00105\u001a\n\u00106\u001a\u000207*\u000208\u001a\u0014\u00109\u001a\u0004\u0018\u00010:*\u0002042\u0006\u0010;\u001a\u00020<\u001a\u0014\u00109\u001a\u0004\u0018\u00010:*\u0002042\u0006\u0010=\u001a\u00020>\u001ae\u0010?\u001a\u0004\u0018\u0001H1\"\b\b\u0000\u00101*\u000202*\u00020@2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u0002H1\u0012\u0004\u0012\u00020\u00050B2\u0006\u0010C\u001a\u00020\u00052 \u00103\u001a\u001c\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H1\u0012\u0006\u0012\u0004\u0018\u0001H1\u0012\u0004\u0012\u0002H10D2\n\b\u0002\u0010E\u001a\u0004\u0018\u0001H1\u00a2\u0006\u0002\u0010F\u001a\u0010\u0010G\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030)H\u0002\u001a\n\u0010\t\u001a\u00020\n*\u00020.\u001a\u0014\u0010H\u001a\u00020I*\u00020:2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a+\u0010J\u001a\u0002H1\"\b\b\u0000\u00101*\u000202*\u0002H12\u0006\u00103\u001a\u0002042\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\u0010K\u00a8\u0006L"}, d2={"argumentsWithVarargAsSingleArray", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "additionalReceiver", "arguments", "", "varargParameterIndex", "", "defineProperty", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "receiver", "name", "", "value", "Lkotlin/Function0;", "getter", "setter", "isFunctionTypeInvoke", "", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "jsAssignment", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "left", "right", "jsElementAccess", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "jsVar", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "initializer", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "prototypeOf", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "classNameRef", "translateCall", "transformer", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsExpressionTransformer;", "translateCallArguments", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "translateFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "addSourceInfoIfNeed", "", "T", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "node", "Lorg/jetbrains/kotlin/ir/IrElement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsNode;Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;)V", "asBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "getSourceInfo", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocation;", "fileEntry", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "toJsNode", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "tr", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;", "data", "Lkotlin/Function3;", "implicitElse", "(Lorg/jetbrains/kotlin/ir/expressions/IrWhen;Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;Lkotlin/jvm/functions/Function3;Lorg/jetbrains/kotlin/js/backend/ast/JsNode;)Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "validWithNullArgs", "withEmbeddedSource", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocationWithEmbeddedSource;", "withSource", "(Lorg/jetbrains/kotlin/js/backend/ast/JsNode;Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;)Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "backend.js"})
public final class JsAstUtilsKt {
    @NotNull
    public static final JsVars jsVar(@NotNull JsName name, @Nullable IrExpression initializer2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(context, "context");
        IrExpression irExpression = initializer2;
        JsExpression jsInitializer = irExpression != null ? (JsExpression)irExpression.accept(new IrElementToJsExpressionTransformer(), context) : null;
        return new JsVars(new JsVars.JsVar(name, jsInitializer));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final <T extends JsNode> T toJsNode(@NotNull IrWhen $this$toJsNode, @NotNull BaseIrElementToJsNodeTransformer<? extends T, ? super JsGenerationContext> tr, @NotNull JsGenerationContext data, @NotNull Function3<? super JsExpression, ? super T, ? super T, ? extends T> node, @Nullable T implicitElse) {
        Intrinsics.checkNotNullParameter($this$toJsNode, "<this>");
        Intrinsics.checkNotNullParameter(tr, "tr");
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(node, "node");
        List<IrBranch> $this$foldRight$iv = $this$toJsNode.getBranches();
        boolean $i$f$foldRight = false;
        Object accumulator$iv = implicitElse;
        if (!$this$foldRight$iv.isEmpty()) {
            ListIterator<IrBranch> iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
            while (iterator$iv.hasPrevious()) {
                JsNode jsNode;
                T t = accumulator$iv;
                IrBranch br = iterator$iv.previous();
                boolean bl = false;
                JsNode body2 = (JsNode)br.getResult().accept((IrElementVisitor)tr, data);
                if (IrUtilsKt.isElseBranch(br)) {
                    jsNode = body2;
                } else {
                    void n;
                    JsExpression condition = (JsExpression)br.getCondition().accept(new IrElementToJsExpressionTransformer(), data);
                    jsNode = (JsNode)node.invoke(condition, body2, n);
                }
                accumulator$iv = jsNode;
            }
        }
        return accumulator$iv;
    }

    public static /* synthetic */ JsNode toJsNode$default(IrWhen irWhen, BaseIrElementToJsNodeTransformer baseIrElementToJsNodeTransformer, JsGenerationContext jsGenerationContext, Function3 function3, JsNode jsNode, int n, Object object) {
        if ((n & 8) != 0) {
            jsNode = null;
        }
        return JsAstUtilsKt.toJsNode(irWhen, baseIrElementToJsNodeTransformer, jsGenerationContext, function3, jsNode);
    }

    @NotNull
    public static final JsExpression jsElementAccess(@NotNull String name, @Nullable JsExpression receiver) {
        Intrinsics.checkNotNullParameter(name, "name");
        return JsAstUtilsKt.jsElementAccess(new JsName(name, false), receiver);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final JsExpression jsElementAccess(@NotNull JsName name, @Nullable JsExpression receiver) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter(name, "name");
        if (receiver != null) {
            String string2 = name.getIdent();
            Intrinsics.checkNotNullExpressionValue(string2, "name.ident");
            if (!IdentifierPolicyKt.isValidES5Identifier(string2)) {
                jsExpression = new JsArrayAccess(receiver, new JsStringLiteral(name.getIdent()));
                return jsExpression;
            }
        }
        jsExpression = new JsNameRef(name, receiver);
        return jsExpression;
    }

    @NotNull
    public static final JsBinaryOperation jsAssignment(@NotNull JsExpression left, @NotNull JsExpression right) {
        Intrinsics.checkNotNullParameter(left, "left");
        Intrinsics.checkNotNullParameter(right, "right");
        return new JsBinaryOperation(JsBinaryOperator.ASG, left, right);
    }

    @NotNull
    public static final JsNameRef prototypeOf(@NotNull JsExpression classNameRef) {
        Intrinsics.checkNotNullParameter(classNameRef, "classNameRef");
        return new JsNameRef(Namer.INSTANCE.getPROTOTYPE_NAME(), classNameRef);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsFunction translateFunction(@NotNull IrFunction declaration, @Nullable JsName name, @NotNull JsGenerationContext context) {
        JsStatement $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        JsFunction jsFunction = context.getStaticContext().getBackendContext().getJsCodeForFunction(declaration.getSymbol());
        if (jsFunction != null) {
            JsFunction function2 = jsFunction;
            boolean bl = false;
            function2.setName(name);
            return function2;
        }
        LocalNameGenerator localNameGenerator = context.getLocalNames();
        if (localNameGenerator == null) {
            LocalNameGenerator function2;
            LocalNameGenerator it = function2 = new LocalNameGenerator(context.getStaticContext().getGlobalNameScope());
            boolean bl = false;
            IrVisitorsKt.acceptChildrenVoid(declaration, it);
            IrDeclarationBase irDeclarationBase = IrUtilsKt.getParentClassOrNull(declaration);
            if (irDeclarationBase != null && (irDeclarationBase = irDeclarationBase.getThisReceiver()) != null) {
                IrVisitorsKt.acceptVoid(irDeclarationBase, it);
            }
            localNameGenerator = function2;
        }
        LocalNameGenerator localNameGenerator2 = localNameGenerator;
        JsGenerationContext functionContext = context.newDeclaration(declaration, localNameGenerator2);
        Iterable $this$map$iv = declaration.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv = iterator2.next();
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(functionContext.getNameForValueDeclaration((IrDeclarationWithName)it));
        }
        List functionParams = (List)destination$iv$iv;
        IrBody irBody = declaration.getBody();
        $this$mapTo$iv$iv = irBody != null ? (JsStatement)irBody.accept(new IrElementToJsStatementTransformer(), functionContext) : null;
        JsBlock jsBlock = $this$mapTo$iv$iv instanceof JsBlock ? (JsBlock)$this$mapTo$iv$iv : null;
        if (jsBlock == null) {
            jsBlock = new JsBlock();
        }
        JsBlock body2 = jsBlock;
        JsScope jsScope = JsGenerationContextKt.getEmptyScope();
        StringBuilder stringBuilder2 = new StringBuilder().append("member function ");
        Object object = name;
        if (object == null) {
            object = "annon";
        }
        JsFunction function3 = new JsFunction(jsScope, body2, stringBuilder2.append(object).toString());
        function3.setName(name);
        IrValueParameter irValueParameter = declaration.getExtensionReceiverParameter();
        if (irValueParameter != null) {
            IrValueParameter it = irValueParameter;
            boolean bl = false;
            JsAstUtilsKt.translateFunction$addParameter(function3, functionContext.getNameForValueDeclaration(it));
        }
        Iterable $this$forEach$iv = functionParams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsName it = (JsName)element$iv;
            boolean bl = false;
            JsAstUtilsKt.translateFunction$addParameter(function3, it);
        }
        if (!(!AdditionalIrUtilsKt.isSuspend(declaration))) {
            boolean bl = false;
            String string2 = "All Suspend functions should be lowered";
            throw new IllegalStateException(string2.toString());
        }
        return function3;
    }

    private static final boolean isFunctionTypeInvoke(JsExpression receiver, IrCall call2) {
        if (receiver == null || receiver instanceof JsThisRef) {
            return false;
        }
        Object b = call2.getSymbol().getOwner();
        IrSimpleFunction irSimpleFunction = b instanceof IrSimpleFunction ? (IrSimpleFunction)b : null;
        if (irSimpleFunction == null) {
            return false;
        }
        IrSimpleFunction simpleFunction = irSimpleFunction;
        IrAnnotationContainer irAnnotationContainer = simpleFunction.getDispatchReceiverParameter();
        if (irAnnotationContainer == null || (irAnnotationContainer = irAnnotationContainer.getType()) == null) {
            return false;
        }
        IrAnnotationContainer receiverType = irAnnotationContainer;
        if (call2.getOrigin() == JsStatementOrigins.EXPLICIT_INVOKE.INSTANCE) {
            return false;
        }
        return Intrinsics.areEqual(simpleFunction.getName(), OperatorNameConventions.INVOKE) && IrTypeUtilsKt.isFunctionTypeOrSubtype((IrType)receiverType) && (!IrTypeUtilsKt.isSuspendFunctionTypeOrSubtype((IrType)receiverType) || IrTypeUtilsKt.isSuspendFunction((IrType)receiverType));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsExpression translateCall(@NotNull IrCall expression2, @NotNull JsGenerationContext context, @NotNull IrElementToJsExpressionTransformer transformer2) {
        JsExpression jsExpression;
        JsExpression ref;
        JsExpression jsExpression2;
        JsName symbolName;
        List<JsExpression> arguments2;
        JsExpression jsExtensionReceiver;
        JsExpression jsDispatchReceiver;
        IrSimpleFunction function2;
        block28: {
            Object object;
            JsExpression jsExpression3;
            block30: {
                block29: {
                    void receiver;
                    JsExpression qPrototype;
                    JsNameRef jsNameRef;
                    Pair<IrSimpleFunction, IrClass> pair;
                    Object property2;
                    Intrinsics.checkNotNullParameter(expression2, "expression");
                    Intrinsics.checkNotNullParameter(context, "context");
                    Intrinsics.checkNotNullParameter(transformer2, "transformer");
                    function2 = IrResolveUtilsKt.getRealOverrideTarget((IrSimpleFunction)expression2.getSymbol().getOwner());
                    Function2<IrCall, JsGenerationContext, JsExpression> function22 = context.getStaticContext().getIntrinsics().get(function2.getSymbol());
                    if (function22 != null) {
                        Function2<IrCall, JsGenerationContext, JsExpression> it = function22;
                        boolean bl = false;
                        return it.invoke(expression2, context);
                    }
                    IrExpression irExpression = expression2.getDispatchReceiver();
                    jsDispatchReceiver = irExpression != null ? (JsExpression)irExpression.accept(transformer2, context) : null;
                    IrExpression irExpression2 = expression2.getExtensionReceiver();
                    jsExtensionReceiver = irExpression2 != null ? (JsExpression)irExpression2.accept(transformer2, context) : null;
                    arguments2 = JsAstUtilsKt.translateCallArguments(expression2, context, transformer2);
                    if (AnnotationUtilsKt.getJsName(function2) == null) {
                        IrPropertySymbol irPropertySymbol = function2.getCorrespondingPropertySymbol();
                        Object object2 = property2 = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
                        if (property2 != null && (IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)property2) || IrJsUtilsKt.isExportedMember((IrDeclaration)property2, context.getStaticContext().getBackendContext())) && (function2.getOverriddenSymbols().isEmpty() || JsClassGeneratorKt.overriddenStableProperty(function2, context.getStaticContext().getBackendContext()))) {
                            JsExpression jsExpression4;
                            JsExpression jsExpression5;
                            JsName propertyName = context.getNameForProperty((IrProperty)property2);
                            if (jsDispatchReceiver == null) {
                                jsExpression5 = new JsNameRef(propertyName);
                            } else {
                                String string2 = propertyName.getIdent();
                                Intrinsics.checkNotNullExpressionValue(string2, "propertyName.ident");
                                jsExpression5 = JsAstUtilsKt.jsElementAccess(string2, jsDispatchReceiver);
                            }
                            JsExpression nameRef = jsExpression5;
                            IrSimpleFunction irSimpleFunction = function2;
                            if (Intrinsics.areEqual(irSimpleFunction, ((IrProperty)property2).getGetter())) {
                                jsExpression4 = nameRef;
                            } else if (Intrinsics.areEqual(irSimpleFunction, ((IrProperty)property2).getSetter())) {
                                jsExpression4 = JsAstUtilsKt.jsAssignment(nameRef, CollectionsKt.single(arguments2));
                            } else {
                                CompilationExceptionKt.compilationException("Function must be an accessor of corresponding property", function2);
                                throw null;
                            }
                            return jsExpression4;
                        }
                    }
                    if (JsAstUtilsKt.isFunctionTypeInvoke(jsDispatchReceiver, expression2) || AnnotationUtilsKt.isJsNativeInvoke((IrAnnotationContainer)expression2.getSymbol().getOwner())) {
                        JsExpression jsExpression6 = jsDispatchReceiver;
                        if (jsExpression6 == null) {
                            JsExpression jsExpression7 = jsExtensionReceiver;
                            jsExpression6 = jsExpression7;
                            Intrinsics.checkNotNull(jsExpression7);
                        }
                        return new JsInvocation(jsExpression6, arguments2);
                    }
                    property2 = expression2.getSuperQualifierSymbol();
                    if (property2 == null) break block28;
                    Object superQualifier = property2;
                    boolean bl = false;
                    if (IrUtilsKt.isInterface((IrClass)superQualifier.getOwner())) {
                        IrOverridableDeclaration irOverridableDeclaration = IrFakeOverrideUtilsKt.resolveFakeOverride$default(function2, false, null, 3, null);
                        Intrinsics.checkNotNull(irOverridableDeclaration);
                        IrSimpleFunction impl = (IrSimpleFunction)irOverridableDeclaration;
                        pair = new Pair<IrSimpleFunction, IrClass>(impl, IrUtilsKt.getParentAsClass(impl));
                    } else {
                        pair = new Pair<IrSimpleFunction, IrClass>(function2, (IrClass)superQualifier.getOwner());
                    }
                    Pair<IrSimpleFunction, IrClass> pair2 = pair;
                    IrSimpleFunction target = pair2.component1();
                    IrClass klass = (IrClass)pair2.component2();
                    if (IrUtilsKt.isInterface(klass) && target.getBody() != null) {
                        jsNameRef = new JsNameRef(Namer.INSTANCE.getCALL_FUNCTION(), (JsExpression)new JsNameRef(context.getNameForStaticDeclaration(target)));
                    } else {
                        JsNameRef jsNameRef2 = context.getNameForClass(klass).makeRef();
                        Intrinsics.checkNotNullExpressionValue(jsNameRef2, "context.getNameForClass(klass).makeRef()");
                        JsNameRef qualifierName = jsNameRef2;
                        JsName targetName = context.getNameForMemberFunction(target);
                        qPrototype = new JsNameRef(targetName, (JsExpression)JsAstUtilsKt.prototypeOf(qualifierName));
                        jsNameRef = new JsNameRef(Namer.INSTANCE.getCALL_FUNCTION(), qPrototype);
                    }
                    JsNameRef callRef = jsNameRef;
                    jsExpression3 = callRef;
                    object = jsDispatchReceiver;
                    if (object == null) break block29;
                    qPrototype = object;
                    JsExpression jsExpression8 = jsExpression3;
                    boolean bl2 = false;
                    List list2 = CollectionsKt.plus((Collection)CollectionsKt.listOf(receiver), (Iterable)arguments2);
                    jsExpression3 = jsExpression8;
                    object = list2;
                    if (list2 != null) break block30;
                }
                object = arguments2;
            }
            List list3 = object;
            JsExpression jsExpression9 = jsExpression3;
            return new JsInvocation(jsExpression9, list3);
        }
        int varargParameterIndex = JsAstUtilsKt.varargParameterIndex(function2);
        boolean isExternalVararg = IrUtilsKt.isEffectivelyExternal(function2) && varargParameterIndex != -1;
        JsName jsName = symbolName = jsDispatchReceiver == null ? context.getNameForStaticFunction(function2) : context.getNameForMemberFunction(function2);
        if (jsDispatchReceiver == null) {
            jsExpression2 = new JsNameRef(symbolName);
        } else {
            String string3 = symbolName.getIdent();
            Intrinsics.checkNotNullExpressionValue(string3, "symbolName.ident");
            jsExpression2 = ref = JsAstUtilsKt.jsElementAccess(string3, jsDispatchReceiver);
        }
        if (isExternalVararg) {
            JsInvocation jsInvocation;
            JsExpression argumentsAsSingleArray = JsAstUtilsKt.argumentsWithVarargAsSingleArray(expression2, context, jsExtensionReceiver, arguments2, varargParameterIndex);
            if (jsDispatchReceiver != null) {
                if (argumentsAsSingleArray instanceof JsArrayLiteral) {
                    String string4 = symbolName.getIdent();
                    Intrinsics.checkNotNullExpressionValue(string4, "symbolName.ident");
                    jsInvocation = new JsInvocation(JsAstUtilsKt.jsElementAccess(string4, jsDispatchReceiver), ((JsArrayLiteral)argumentsAsSingleArray).getExpressions());
                } else {
                    JsName receiverName = new JsName("$externalVarargReceiverTmp", false);
                    JsNameRef jsNameRef = receiverName.makeRef();
                    Intrinsics.checkNotNullExpressionValue(jsNameRef, "receiverName.makeRef()");
                    JsNameRef receiverRef = jsNameRef;
                    JsScope jsScope = JsGenerationContextKt.getEmptyScope();
                    JsNode[] jsNodeArray = new JsStatement[2];
                    jsNodeArray[0] = new JsVars(new JsVars.JsVar(receiverName, jsDispatchReceiver));
                    String string5 = symbolName.getIdent();
                    Intrinsics.checkNotNullExpressionValue(string5, "symbolName.ident");
                    JsExpression[] jsExpressionArray = new JsExpression[]{receiverRef, argumentsAsSingleArray};
                    jsNodeArray[1] = new JsReturn(new JsInvocation((JsExpression)new JsNameRef("apply", JsAstUtilsKt.jsElementAccess(string5, (JsExpression)receiverRef)), CollectionsKt.listOf(jsExpressionArray)));
                    JsFunction iifeFun = new JsFunction(jsScope, new JsBlock((JsStatement[])jsNodeArray), "VarargIIFE");
                    jsNodeArray = new JsExpression[]{new JsThisRef()};
                    JsInvocation jsInvocation2 = new JsInvocation((JsExpression)new JsNameRef("call", (JsExpression)iifeFun), (JsExpression[])jsNodeArray);
                    jsInvocation = jsInvocation2;
                }
            } else if (argumentsAsSingleArray instanceof JsArrayLiteral) {
                jsInvocation = new JsInvocation((JsExpression)new JsNameRef(symbolName), ((JsArrayLiteral)argumentsAsSingleArray).getExpressions());
            } else {
                JsExpression[] jsExpressionArray = new JsExpression[]{new JsNullLiteral(), argumentsAsSingleArray};
                JsInvocation jsInvocation3 = new JsInvocation((JsExpression)new JsNameRef("apply", (JsExpression)new JsNameRef(symbolName)), CollectionsKt.listOf(jsExpressionArray));
                jsInvocation = jsInvocation3;
            }
            jsExpression = jsInvocation;
        } else {
            jsExpression = new JsInvocation(ref, CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(jsExtensionReceiver), (Iterable)arguments2));
        }
        return jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsExpression argumentsWithVarargAsSingleArray(@NotNull IrFunctionAccessExpression expression2, @NotNull JsGenerationContext context, @Nullable JsExpression additionalReceiver, @NotNull List<? extends JsExpression> arguments2, int varargParameterIndex) {
        boolean bl;
        Iterable $this$all$iv;
        JsExpression argument2;
        List concatElements;
        block19: {
            void $this$forEachIndexed$iv;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(arguments2, "arguments");
            List arraysForConcat = null;
            arraysForConcat = new ArrayList();
            org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(arraysForConcat, additionalReceiver);
            concatElements = new ArrayList();
            Iterable iterable = arguments2;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                JsExpression jsExpression = (JsExpression)item$iv;
                int index2 = n;
                boolean bl2 = false;
                if (index2 == varargParameterIndex) {
                    JsExpression jsExpression2;
                    JsArrayLiteral jsArrayLiteral;
                    IrExpression valueArgument = expression2.getValueArgument(varargParameterIndex);
                    if (!((Collection)arraysForConcat).isEmpty()) {
                        concatElements.add(new JsArrayLiteral(arraysForConcat));
                    }
                    arraysForConcat = new ArrayList();
                    Object object = argument2;
                    if (object instanceof JsArrayLiteral) {
                        jsArrayLiteral = (JsArrayLiteral)argument2;
                    } else if (object instanceof JsNew) {
                        List<JsExpression> list2 = ((JsNew)argument2).getArguments();
                        Intrinsics.checkNotNullExpressionValue(list2, "argument.arguments");
                        JsExpression jsExpression3 = CollectionsKt.firstOrNull(list2);
                        jsArrayLiteral = jsExpression3 instanceof JsArrayLiteral ? (JsArrayLiteral)jsExpression3 : null;
                    } else {
                        jsArrayLiteral = null;
                    }
                    if (jsArrayLiteral != null) {
                        jsExpression2 = jsArrayLiteral;
                    } else if (valueArgument instanceof IrCall && Intrinsics.areEqual(((IrCall)valueArgument).getSymbol(), context.getStaticContext().getBackendContext().getIntrinsics().getArrayConcat())) {
                        jsExpression2 = argument2;
                    } else {
                        object = new JsExpression[]{argument2};
                        jsExpression2 = new JsInvocation((JsExpression)new JsNameRef("call", (JsExpression)new JsNameRef("slice", (JsExpression)new JsArrayLiteral())), (JsExpression)object);
                    }
                    JsExpression varargArgument = jsExpression2;
                    concatElements.add(varargArgument);
                    continue;
                }
                arraysForConcat.add(argument2);
            }
            if (!((Collection)arraysForConcat).isEmpty()) {
                concatElements.add(new JsArrayLiteral(arraysForConcat));
            }
            if (concatElements.isEmpty()) {
                return new JsArrayLiteral();
            }
            $this$all$iv = concatElements;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    JsExpression it = (JsExpression)element$iv;
                    boolean bl3 = false;
                    if (it instanceof JsArrayLiteral) continue;
                    bl = false;
                    break block19;
                }
                bl = true;
            }
        }
        if (bl) {
            void $this$fold$iv;
            void initial$iv;
            $this$all$iv = concatElements;
            List $i$f$all = new ArrayList();
            boolean $i$f$fold = false;
            void accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void arrayLiteral;
                argument2 = (JsExpression)element$iv;
                void aggregatedArrayExpressions = accumulator$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNull(arrayLiteral, "null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral");
                JsArrayLiteral cfr_ignored_0 = (JsArrayLiteral)arrayLiteral;
                List<JsExpression> list3 = ((JsArrayLiteral)arrayLiteral).getExpressions();
                Intrinsics.checkNotNullExpressionValue(list3, "arrayLiteral.expressions");
                aggregatedArrayExpressions.addAll((Collection)list3);
                accumulator$iv = aggregatedArrayExpressions;
            }
            void it = accumulator$iv;
            boolean bl5 = false;
            return new JsArrayLiteral((List<JsExpression>)it);
        }
        return concatElements.size() == 1 ? (JsExpression)concatElements.get(0) : (JsExpression)new JsInvocation((JsExpression)new JsNameRef("concat", (JsExpression)CollectionsKt.first(concatElements)), CollectionsKt.drop(concatElements, 1));
    }

    public static final int varargParameterIndex(@NotNull IrFunction $this$varargParameterIndex) {
        int n;
        block2: {
            Intrinsics.checkNotNullParameter($this$varargParameterIndex, "<this>");
            List<IrValueParameter> $this$indexOfFirst$iv = $this$varargParameterIndex.getValueParameters();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<IrValueParameter> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                IrValueParameter item$iv;
                IrValueParameter it = item$iv = iterator2.next();
                boolean bl = false;
                if (it.getVarargElementType() != null) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<JsExpression> translateCallArguments(@NotNull IrMemberAccessExpression<IrFunctionSymbol> expression2, @NotNull JsGenerationContext context, @NotNull IrElementToJsExpressionTransformer transformer2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list2;
        ListIterator iterator$iv;
        Iterable $this$dropLastWhile$iv;
        void $this$mapIndexedTo$iv$iv;
        List $this$mapIndexed$iv;
        int n;
        void $this$onEach$iv;
        Collection collection;
        Iterable $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(transformer2, "transformer");
        int size = expression2.getValueArgumentsCount();
        int varargParameterIndex = JsAstUtilsKt.varargParameterIndex(IrResolveUtilsKt.getRealOverrideTarget(expression2.getSymbol().getOwner()));
        boolean validWithNullArgs = JsAstUtilsKt.validWithNullArgs(expression2);
        Iterable iterable = RangesKt.until(0, size);
        Collection destination$iv = new ArrayList(size);
        boolean $i$f$mapTo22 = false;
        Iterator iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            void index2;
            IrExpression argument2;
            int item$iv;
            int n2 = item$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv;
            boolean bl = false;
            IrExpression irExpression = argument2 = expression2.getValueArgument((int)index2);
            collection.add(irExpression != null ? (JsExpression)irExpression.accept(transformer2, context) : null);
        }
        $this$mapTo$iv = destination$iv;
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2416$iv = $i$f$mapTo22 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            JsExpression result2 = (JsExpression)element$iv;
            n = 0;
            if (result2 != null || !_Assertions.ENABLED || validWithNullArgs) continue;
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        $this$onEach$iv = $i$f$mapTo22;
        boolean $i$f$mapIndexed = false;
        void $i$f$mapTo22 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void result3;
            void index3;
            boolean isEmptyExternalVararg;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JsExpression jsExpression = (JsExpression)item$iv$iv2;
            int n3 = n;
            collection = destination$iv$iv;
            boolean bl2 = false;
            boolean bl3 = isEmptyExternalVararg = validWithNullArgs && varargParameterIndex == index3 && result3 instanceof JsArrayLiteral && ((JsArrayLiteral)result3).getExpressions().isEmpty();
            collection.add(isEmptyExternalVararg && index3 == size - 1 ? (JsExpression)null : result3);
        }
        $this$mapIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                JsExpression it = (JsExpression)iterator$iv.previous();
                boolean bl4 = false;
                if (it == null) continue;
                list2 = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list2;
        boolean $i$f$map = false;
        iterator$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (JsExpression)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            JsExpression jsExpression = it;
            if (jsExpression == null) {
                jsExpression = new JsPrefixOperation(JsUnaryOperator.VOID, new JsIntLiteral(1));
            }
            collection.add(jsExpression);
        }
        List arguments2 = (List)destination$iv$iv;
        if (!(!IrUtilsKt.isSuspend(expression2.getSymbol()))) {
            boolean bl6 = false;
            String string3 = "Suspend functions should be lowered";
            throw new IllegalStateException(string3.toString());
        }
        return arguments2;
    }

    private static final boolean validWithNullArgs(IrMemberAccessExpression<?> $this$validWithNullArgs) {
        return $this$validWithNullArgs instanceof IrFunctionAccessExpression && IrUtilsKt.isExternalOrInheritedFromExternal(((IrFunctionSymbol)((IrFunctionAccessExpression)$this$validWithNullArgs).getSymbol()).getOwner());
    }

    @NotNull
    public static final JsBlock asBlock(@NotNull JsStatement $this$asBlock) {
        Intrinsics.checkNotNullParameter($this$asBlock, "<this>");
        JsBlock jsBlock = $this$asBlock instanceof JsBlock ? (JsBlock)$this$asBlock : null;
        if (jsBlock == null) {
            jsBlock = new JsBlock($this$asBlock);
        }
        return jsBlock;
    }

    @NotNull
    public static final JsInvocation defineProperty(@NotNull JsExpression receiver, @NotNull String name, @NotNull Function0<? extends JsExpression> value2) {
        Intrinsics.checkNotNullParameter(receiver, "receiver");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(value2, "value");
        JsNameRef objectDefineProperty = new JsNameRef("defineProperty", (JsExpression)Namer.INSTANCE.getJS_OBJECT());
        JsExpression[] jsExpressionArray = new JsExpression[]{receiver, new JsStringLiteral(name), value2.invoke()};
        return new JsInvocation((JsExpression)objectDefineProperty, jsExpressionArray);
    }

    @NotNull
    public static final JsInvocation defineProperty(@NotNull JsExpression receiver, @NotNull String name, @Nullable JsExpression getter2, @Nullable JsExpression setter2) {
        Intrinsics.checkNotNullParameter(receiver, "receiver");
        Intrinsics.checkNotNullParameter(name, "name");
        return JsAstUtilsKt.defineProperty(receiver, name, (Function0<? extends JsExpression>)new Function0<JsExpression>(getter2, setter2){
            final /* synthetic */ JsExpression $getter;
            final /* synthetic */ JsExpression $setter;
            {
                this.$getter = $getter;
                this.$setter = $setter;
                super(0);
            }

            @NotNull
            public final JsExpression invoke() {
                JsObjectLiteral jsObjectLiteral = new JsObjectLiteral(true);
                JsExpression jsExpression = this.$getter;
                JsExpression jsExpression2 = this.$setter;
                JsObjectLiteral $this$invoke_u24lambda_u240 = jsObjectLiteral;
                boolean bl = false;
                List<JsPropertyInitializer> list2 = $this$invoke_u24lambda_u240.getPropertyInitializers();
                Intrinsics.checkNotNullExpressionValue(list2, "propertyInitializers");
                Collection collection = list2;
                collection.add(new JsPropertyInitializer(new JsStringLiteral("configurable"), new JsBooleanLiteral(true)));
                if (jsExpression != null) {
                    List<JsPropertyInitializer> list3 = $this$invoke_u24lambda_u240.getPropertyInitializers();
                    Intrinsics.checkNotNullExpressionValue(list3, "propertyInitializers");
                    collection = list3;
                    collection.add(new JsPropertyInitializer(new JsStringLiteral("get"), jsExpression));
                }
                if (jsExpression2 != null) {
                    List<JsPropertyInitializer> list4 = $this$invoke_u24lambda_u240.getPropertyInitializers();
                    Intrinsics.checkNotNullExpressionValue(list4, "propertyInitializers");
                    collection = list4;
                    collection.add(new JsPropertyInitializer(new JsStringLiteral("set"), jsExpression2));
                }
                return jsObjectLiteral;
            }
        });
    }

    public static /* synthetic */ JsInvocation defineProperty$default(JsExpression jsExpression, String string2, JsExpression jsExpression2, JsExpression jsExpression3, int n, Object object) {
        if ((n & 8) != 0) {
            jsExpression3 = null;
        }
        return JsAstUtilsKt.defineProperty(jsExpression, string2, jsExpression2, jsExpression3);
    }

    @NotNull
    public static final <T extends JsNode> T withSource(@NotNull T $this$withSource, @NotNull IrElement node, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter($this$withSource, "<this>");
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(context, "context");
        T $this$addSourceInfoIfNeed$iv = $this$withSource;
        boolean $i$f$addSourceInfoIfNeed = false;
        SourceMapsInfo sourceMapsInfo = SourceMapsInfoKt.getSourceMapsInfo(context.getStaticContext().getBackendContext());
        if (sourceMapsInfo != null) {
            SourceMapsInfo sourceMapsInfo$iv = sourceMapsInfo;
            JsLocation jsLocation = context.getLocationForIrElement(node);
            if (jsLocation != null) {
                JsLocationWithSource jsLocationWithSource;
                Object object;
                JsLocation location$iv = jsLocation;
                boolean isNodeFromCurrentModule$iv = Intrinsics.areEqual(context.getCurrentFile().getModule().getDescriptor(), context.getStaticContext().getBackendContext().getModule());
                if ($this$addSourceInfoIfNeed$iv instanceof JsExpressionStatement) {
                    JsExpression jsExpression = ((JsExpressionStatement)$this$addSourceInfoIfNeed$iv).getExpression();
                    Intrinsics.checkNotNullExpressionValue(jsExpression, "this.expression");
                    object = jsExpression;
                } else {
                    object = $this$addSourceInfoIfNeed$iv;
                }
                T locationTarget$iv = object;
                switch (WhenMappings.$EnumSwitchMapping$0[sourceMapsInfo$iv.getSourceMapContentEmbedding().ordinal()]) {
                    case 1: {
                        jsLocationWithSource = location$iv;
                        break;
                    }
                    case 2: {
                        if (isNodeFromCurrentModule$iv) {
                            jsLocationWithSource = location$iv;
                            break;
                        }
                        jsLocationWithSource = JsAstUtilsKt.withEmbeddedSource(location$iv, context);
                        break;
                    }
                    case 3: {
                        jsLocationWithSource = JsAstUtilsKt.withEmbeddedSource(location$iv, context);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                locationTarget$iv.setSource(jsLocationWithSource);
            }
        }
        return $this$withSource;
    }

    private static final JsLocationWithEmbeddedSource withEmbeddedSource(JsLocation $this$withEmbeddedSource, JsGenerationContext context) {
        return new JsLocationWithEmbeddedSource($this$withEmbeddedSource, null, (Function0<? extends Reader>)new Function0<Reader>($this$withEmbeddedSource){
            final /* synthetic */ JsLocation $this_withEmbeddedSource;
            {
                this.$this_withEmbeddedSource = $receiver;
                super(0);
            }

            @Nullable
            public final Reader invoke() {
                Reader reader;
                try {
                    reader = new InputStreamReader((InputStream)new FileInputStream(this.$this_withEmbeddedSource.getFile()), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    reader = null;
                }
                return reader;
            }
        });
    }

    @Nullable
    public static final JsLocation getSourceInfo(@NotNull IrElement $this$getSourceInfo, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter($this$getSourceInfo, "<this>");
        Intrinsics.checkNotNullParameter(container, "container");
        Object object = IrUtilsKt.getFileOrNull(container);
        if (object == null || (object = ((IrFile)object).getFileEntry()) == null) {
            return null;
        }
        Object fileEntry = object;
        return JsAstUtilsKt.getSourceInfo($this$getSourceInfo, (IrFileEntry)fileEntry);
    }

    @Nullable
    public static final JsLocation getSourceInfo(@NotNull IrElement $this$getSourceInfo, @NotNull IrFileEntry fileEntry) {
        Intrinsics.checkNotNullParameter($this$getSourceInfo, "<this>");
        Intrinsics.checkNotNullParameter(fileEntry, "fileEntry");
        if ($this$getSourceInfo.getStartOffset() == -1 || $this$getSourceInfo.getEndOffset() == -1) {
            return null;
        }
        String path2 = fileEntry.getName();
        int startLine = fileEntry.getLineNumber($this$getSourceInfo.getStartOffset());
        int startColumn = fileEntry.getColumnNumber($this$getSourceInfo.getStartOffset());
        return new JsLocation(path2, startLine, startColumn);
    }

    private static final void translateFunction$addParameter(JsFunction $this$translateFunction_u24addParameter, JsName parameter) {
        $this$translateFunction_u24addParameter.getParameters().add(new JsParameter(parameter));
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SourceMapSourceEmbedding.values().length];
            try {
                nArray[SourceMapSourceEmbedding.NEVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceMapSourceEmbedding.INLINING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceMapSourceEmbedding.ALWAYS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

