/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.facade.TranslationUnit;
import org.jetbrains.kotlin.js.inline.FunctionReader;
import org.jetbrains.kotlin.js.inline.InlineFunctionDefinition;
import org.jetbrains.kotlin.js.inline.InliningScope;
import org.jetbrains.kotlin.js.inline.JsInliner;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0007H\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010\"\u001a\u0004\u0018\u00010\u000e2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010 \u001a\u00020\u0007H\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010\u000e2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u000e2\u0006\u0010(\u001a\u00020\u0017H\u0002J\f\u0010)\u001a\u00020\b*\u00020\u0007H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/js/inline/context/FunctionDefinitionLoader;", "", "inliner", "Lorg/jetbrains/kotlin/js/inline/JsInliner;", "(Lorg/jetbrains/kotlin/js/inline/JsInliner;)V", "fragmentInfo", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgramFragment;", "Lorg/jetbrains/kotlin/js/inline/context/FunctionDefinitionLoader$FragmentInfo;", "functionReader", "Lorg/jetbrains/kotlin/js/inline/FunctionReader;", "functionsByFunctionNodes", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "Lorg/jetbrains/kotlin/js/inline/util/FunctionWithWrapper;", "getFunctionsByFunctionNodes", "()Ljava/util/HashMap;", "fragmentByTag", "tag", "", "getFunctionDefinition", "Lorg/jetbrains/kotlin/js/inline/InlineFunctionDefinition;", "call", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "scope", "Lorg/jetbrains/kotlin/js/inline/InliningScope;", "getFunctionDefinitionImpl", "hasFunctionDefinition", "", "lookUpFunctionDirect", "callsiteScope", "lookUpFunctionExternal", "fragment", "lookUpFunctionIndirect", "lookUpStaticFunction", "functionName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "lookUpStaticFunctionByTag", "functionTag", "tryExtractCallableReference", "invocation", "loadInfo", "FragmentInfo", "js.translator"})
public final class FunctionDefinitionLoader {
    @NotNull
    private final JsInliner inliner;
    @NotNull
    private final HashMap<JsFunction, FunctionWithWrapper> functionsByFunctionNodes;
    @NotNull
    private final FunctionReader functionReader;
    @NotNull
    private final Map<JsProgramFragment, FragmentInfo> fragmentInfo;

    /*
     * WARNING - void declaration
     */
    public FunctionDefinitionLoader(@NotNull JsInliner inliner) {
        void $this$associateTo$iv;
        Intrinsics.checkNotNullParameter(inliner, "inliner");
        this.inliner = inliner;
        this.functionsByFunctionNodes = new HashMap();
        this.functionReader = new FunctionReader(this.inliner.getReporter(), this.inliner.getConfig(), this.inliner.getBindingContext());
        Iterable iterable = this.inliner.getTranslationResult().getNewFragments();
        Map map = new LinkedHashMap();
        FunctionDefinitionLoader functionDefinitionLoader = this;
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            void destination$iv;
            void var7_8 = destination$iv;
            JsProgramFragment it = (JsProgramFragment)element$iv;
            boolean bl = false;
            Pair<JsProgramFragment, FragmentInfo> pair = TuplesKt.to(it, this.loadInfo(it));
            var7_8.put(pair.getFirst(), pair.getSecond());
        }
        functionDefinitionLoader.fragmentInfo = map;
    }

    @NotNull
    public final InlineFunctionDefinition getFunctionDefinition(@NotNull JsInvocation call2, @NotNull InliningScope scope2) {
        Intrinsics.checkNotNullParameter(call2, "call");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        InlineFunctionDefinition inlineFunctionDefinition = this.getFunctionDefinitionImpl(call2, scope2);
        Intrinsics.checkNotNull(inlineFunctionDefinition);
        return inlineFunctionDefinition;
    }

    public final boolean hasFunctionDefinition(@NotNull JsInvocation call2, @NotNull InliningScope scope2) {
        Intrinsics.checkNotNullParameter(call2, "call");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        return this.getFunctionDefinitionImpl(call2, scope2) != null;
    }

    @NotNull
    public final HashMap<JsFunction, FunctionWithWrapper> getFunctionsByFunctionNodes() {
        return this.functionsByFunctionNodes;
    }

    private final InlineFunctionDefinition getFunctionDefinitionImpl(JsInvocation call2, InliningScope scope2) {
        boolean bl = this.fragmentInfo.containsKey(scope2.getFragment());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        InlineFunctionDefinition inlineFunctionDefinition = this.lookUpFunctionDirect(call2, scope2);
        if (inlineFunctionDefinition == null && (inlineFunctionDefinition = this.lookUpFunctionIndirect(call2, scope2)) == null) {
            inlineFunctionDefinition = this.lookUpFunctionExternal(call2, scope2.getFragment());
        }
        return inlineFunctionDefinition;
    }

    private final FragmentInfo loadInfo(JsProgramFragment $this$loadInfo) {
        FragmentInfo fragmentInfo;
        FragmentInfo fragmentInfo2 = fragmentInfo = new FragmentInfo(CollectUtilsKt.collectNamedFunctionsAndWrappers(CollectionsKt.listOf($this$loadInfo)), CollectUtilsKt.collectAccessors((Iterable<JsProgramFragment>)CollectionsKt.listOf($this$loadInfo)), CollectUtilsKt.collectLocalFunctions(CollectionsKt.listOf($this$loadInfo)));
        boolean bl = false;
        Map<JsName, FunctionWithWrapper> functions2 = fragmentInfo2.component1();
        Map<String, FunctionWithWrapper> accessors2 = fragmentInfo2.component2();
        Sequence $this$forEach$iv = SequencesKt.plus(CollectionsKt.asSequence((Iterable)functions2.values()), CollectionsKt.asSequence((Iterable)accessors2.values()));
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            FunctionWithWrapper f = (FunctionWithWrapper)element$iv;
            boolean bl2 = false;
            ((Map)this.functionsByFunctionNodes).put(f.getFunction(), f);
        }
        return fragmentInfo;
    }

    private final FunctionWithWrapper lookUpStaticFunction(JsName functionName, JsProgramFragment fragment) {
        FunctionWithWrapper functionWithWrapper;
        FragmentInfo fragmentInfo = this.fragmentInfo.get(fragment);
        if (fragmentInfo != null) {
            FragmentInfo $this$lookUpStaticFunction_u24lambda_u243 = fragmentInfo;
            boolean bl = false;
            functionWithWrapper = $this$lookUpStaticFunction_u24lambda_u243.getFunctions().get(functionName);
        } else {
            functionWithWrapper = null;
        }
        return functionWithWrapper;
    }

    private final FunctionWithWrapper lookUpStaticFunctionByTag(String functionTag, JsProgramFragment fragment) {
        FunctionWithWrapper functionWithWrapper;
        FragmentInfo fragmentInfo = this.fragmentInfo.get(fragment);
        if (fragmentInfo != null) {
            FragmentInfo $this$lookUpStaticFunctionByTag_u24lambda_u244 = fragmentInfo;
            boolean bl = false;
            functionWithWrapper = $this$lookUpStaticFunctionByTag_u24lambda_u244.getAccessors().get(functionTag);
        } else {
            functionWithWrapper = null;
        }
        return functionWithWrapper;
    }

    private final InlineFunctionDefinition lookUpFunctionIndirect(JsInvocation call2, InliningScope scope2) {
        InlineFunctionDefinition inlineFunctionDefinition;
        FunctionWithWrapper functionWithWrapper;
        FunctionWithWrapper functionWithWrapper2;
        JsExpression qualifier;
        JsExpression jsExpression;
        CallableDescriptor callableDescriptor = MetadataProperties.getDescriptor(call2);
        if (callableDescriptor != null) {
            Void void_;
            CallableDescriptor descriptor2 = callableDescriptor;
            boolean bl = false;
            FragmentInfo fragmentInfo = this.fragmentInfo.get(scope2.getFragment());
            if (fragmentInfo != null) {
                FragmentInfo info = fragmentInfo;
                boolean bl2 = false;
                FunctionWithWrapper functionWithWrapper3 = info.getLocalAccessors().get(descriptor2);
                if (functionWithWrapper3 != null) {
                    InlineFunctionDefinition inlineFunctionDefinition2;
                    FunctionWithWrapper fn = functionWithWrapper3;
                    boolean bl3 = false;
                    InlineFunctionDefinition def = inlineFunctionDefinition2 = new InlineFunctionDefinition(fn, null);
                    boolean bl4 = false;
                    this.inliner.process(def, call2, scope2.getFragment(), scope2);
                    return inlineFunctionDefinition2;
                }
                void_ = null;
            } else {
                void_ = null;
            }
        }
        if (InvocationUtilsKt.isCallInvocation(call2)) {
            JsExpression jsExpression2 = call2.getQualifier();
            Intrinsics.checkNotNull(jsExpression2, "null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsNameRef");
            JsExpression jsExpression3 = ((JsNameRef)jsExpression2).getQualifier();
            Intrinsics.checkNotNull(jsExpression3);
            JsExpression jsExpression4 = jsExpression3;
            Intrinsics.checkNotNullExpressionValue(jsExpression4, "{\n            (call.qual\u2026ef).qualifier!!\n        }");
            jsExpression = jsExpression4;
        } else {
            JsExpression jsExpression5 = call2.getQualifier();
            jsExpression = jsExpression5;
            Intrinsics.checkNotNullExpressionValue(jsExpression5, "{\n            call.qualifier\n        }");
        }
        JsExpression callQualifier = jsExpression;
        JsExpression jsExpression6 = qualifier = InvocationUtilsKt.getTransitiveStaticRef(callQualifier);
        if (jsExpression6 instanceof JsInvocation) {
            functionWithWrapper2 = this.tryExtractCallableReference((JsInvocation)qualifier);
            if (functionWithWrapper2 == null) {
                JsName jsName = InvocationUtilsKt.getSimpleName((JsInvocation)qualifier);
                if (jsName != null) {
                    JsName simpleName = jsName;
                    boolean bl = false;
                    FunctionWithWrapper functionWithWrapper4 = this.lookUpStaticFunction(simpleName, scope2.getFragment());
                    if (functionWithWrapper4 != null) {
                        FunctionWithWrapper it = functionWithWrapper4;
                        boolean bl5 = false;
                        functionWithWrapper2 = FunctionUtilsKt.isFunctionCreator(it.getFunction()) ? it : null;
                    } else {
                        functionWithWrapper2 = null;
                    }
                } else {
                    functionWithWrapper2 = null;
                }
            }
        } else if (jsExpression6 instanceof JsNameRef) {
            functionWithWrapper2 = this.lookUpStaticFunction(((JsNameRef)qualifier).getName(), scope2.getFragment());
        } else if (jsExpression6 instanceof JsFunction) {
            functionWithWrapper2 = this.functionsByFunctionNodes.get(qualifier);
            if (functionWithWrapper2 == null) {
                functionWithWrapper2 = new FunctionWithWrapper((JsFunction)qualifier, null);
            }
        } else {
            functionWithWrapper2 = null;
        }
        if ((functionWithWrapper = functionWithWrapper2) != null) {
            InlineFunctionDefinition inlineFunctionDefinition3;
            FunctionWithWrapper it = functionWithWrapper;
            boolean bl = false;
            InlineFunctionDefinition definition = inlineFunctionDefinition3 = new InlineFunctionDefinition(it, null);
            boolean bl6 = false;
            this.inliner.process(definition, call2, scope2.getFragment(), scope2);
            inlineFunctionDefinition = inlineFunctionDefinition3;
        } else {
            inlineFunctionDefinition = null;
        }
        return inlineFunctionDefinition;
    }

    private final JsProgramFragment fragmentByTag(String tag) {
        JsProgramFragment jsProgramFragment;
        TranslationUnit translationUnit = this.inliner.getTranslationResult().getInlineFunctionTagMap().get(tag);
        if (translationUnit != null) {
            JsProgramFragment jsProgramFragment2;
            TranslationUnit unit2 = translationUnit;
            boolean bl = false;
            JsProgramFragment fragment = jsProgramFragment2 = this.inliner.getTranslationResult().getTranslationResult(unit2).getFragment();
            boolean bl2 = false;
            this.fragmentInfo.computeIfAbsent(fragment, arg_0 -> FunctionDefinitionLoader.fragmentByTag$lambda$15$lambda$14$lambda$13(new Function1<JsProgramFragment, FragmentInfo>(this, fragment){
                final /* synthetic */ FunctionDefinitionLoader this$0;
                final /* synthetic */ JsProgramFragment $fragment;
                {
                    this.this$0 = $receiver;
                    this.$fragment = $fragment;
                    super(1);
                }

                @NotNull
                public final FragmentInfo invoke(@NotNull JsProgramFragment it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return FunctionDefinitionLoader.access$loadInfo(this.this$0, this.$fragment);
                }
            }, arg_0));
            jsProgramFragment = jsProgramFragment2;
        } else {
            jsProgramFragment = null;
        }
        return jsProgramFragment;
    }

    private final InlineFunctionDefinition lookUpFunctionDirect(JsInvocation call2, InliningScope callsiteScope) {
        CallableDescriptor callableDescriptor = MetadataProperties.getDescriptor(call2);
        if (callableDescriptor == null) {
            return null;
        }
        CallableDescriptor descriptor2 = callableDescriptor;
        String string2 = Namer.getFunctionTag(descriptor2, this.inliner.getConfig(), this.inliner.getBindingContext());
        Intrinsics.checkNotNullExpressionValue(string2, "getFunctionTag(descripto\u2026, inliner.bindingContext)");
        String tag = string2;
        JsProgramFragment jsProgramFragment = this.fragmentByTag(tag);
        if (jsProgramFragment == null) {
            return null;
        }
        JsProgramFragment definitionFragment = jsProgramFragment;
        FunctionWithWrapper functionWithWrapper = this.lookUpStaticFunctionByTag(tag, definitionFragment);
        if (functionWithWrapper == null) {
            return null;
        }
        FunctionWithWrapper fn = functionWithWrapper;
        InlineFunctionDefinition definition = new InlineFunctionDefinition(fn, tag);
        this.inliner.process(definition, call2, definitionFragment, callsiteScope);
        return definition;
    }

    private final InlineFunctionDefinition lookUpFunctionExternal(JsInvocation call2, JsProgramFragment fragment) {
        InlineFunctionDefinition inlineFunctionDefinition;
        CallableDescriptor callableDescriptor = MetadataProperties.getDescriptor(call2);
        if (callableDescriptor != null) {
            CallableDescriptor descriptor2 = callableDescriptor;
            boolean bl = false;
            FunctionWithWrapper functionWithWrapper = this.functionReader.get(descriptor2, fragment);
            if (functionWithWrapper != null) {
                FunctionWithWrapper it = functionWithWrapper;
                boolean bl2 = false;
                inlineFunctionDefinition = new InlineFunctionDefinition(it, Namer.getFunctionTag(descriptor2, this.inliner.getConfig(), this.inliner.getBindingContext()));
            } else {
                inlineFunctionDefinition = null;
            }
        } else {
            inlineFunctionDefinition = null;
        }
        return inlineFunctionDefinition;
    }

    private final FunctionWithWrapper tryExtractCallableReference(JsInvocation invocation) {
        JsExpression arg;
        if (MetadataProperties.isCallableReference(invocation) && (arg = invocation.getArguments().get(1)) instanceof JsFunction) {
            return new FunctionWithWrapper((JsFunction)arg, null);
        }
        return null;
    }

    private static final FragmentInfo fragmentByTag$lambda$15$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (FragmentInfo)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ FragmentInfo access$loadInfo(FunctionDefinitionLoader $this, JsProgramFragment $receiver) {
        return $this.loadInfo($receiver);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BA\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003JK\u0010\u0012\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/js/inline/context/FunctionDefinitionLoader$FragmentInfo;", "", "functions", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lorg/jetbrains/kotlin/js/inline/util/FunctionWithWrapper;", "accessors", "", "localAccessors", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "getAccessors", "()Ljava/util/Map;", "getFunctions", "getLocalAccessors", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "js.translator"})
    private static final class FragmentInfo {
        @NotNull
        private final Map<JsName, FunctionWithWrapper> functions;
        @NotNull
        private final Map<String, FunctionWithWrapper> accessors;
        @NotNull
        private final Map<CallableDescriptor, FunctionWithWrapper> localAccessors;

        public FragmentInfo(@NotNull Map<JsName, FunctionWithWrapper> functions2, @NotNull Map<String, FunctionWithWrapper> accessors2, @NotNull Map<CallableDescriptor, FunctionWithWrapper> localAccessors) {
            Intrinsics.checkNotNullParameter(functions2, "functions");
            Intrinsics.checkNotNullParameter(accessors2, "accessors");
            Intrinsics.checkNotNullParameter(localAccessors, "localAccessors");
            this.functions = functions2;
            this.accessors = accessors2;
            this.localAccessors = localAccessors;
        }

        @NotNull
        public final Map<JsName, FunctionWithWrapper> getFunctions() {
            return this.functions;
        }

        @NotNull
        public final Map<String, FunctionWithWrapper> getAccessors() {
            return this.accessors;
        }

        @NotNull
        public final Map<CallableDescriptor, FunctionWithWrapper> getLocalAccessors() {
            return this.localAccessors;
        }

        @NotNull
        public final Map<JsName, FunctionWithWrapper> component1() {
            return this.functions;
        }

        @NotNull
        public final Map<String, FunctionWithWrapper> component2() {
            return this.accessors;
        }

        @NotNull
        public final Map<CallableDescriptor, FunctionWithWrapper> component3() {
            return this.localAccessors;
        }

        @NotNull
        public final FragmentInfo copy(@NotNull Map<JsName, FunctionWithWrapper> functions2, @NotNull Map<String, FunctionWithWrapper> accessors2, @NotNull Map<CallableDescriptor, FunctionWithWrapper> localAccessors) {
            Intrinsics.checkNotNullParameter(functions2, "functions");
            Intrinsics.checkNotNullParameter(accessors2, "accessors");
            Intrinsics.checkNotNullParameter(localAccessors, "localAccessors");
            return new FragmentInfo(functions2, accessors2, localAccessors);
        }

        public static /* synthetic */ FragmentInfo copy$default(FragmentInfo fragmentInfo, Map map, Map map2, Map map3, int n, Object object) {
            if ((n & 1) != 0) {
                map = fragmentInfo.functions;
            }
            if ((n & 2) != 0) {
                map2 = fragmentInfo.accessors;
            }
            if ((n & 4) != 0) {
                map3 = fragmentInfo.localAccessors;
            }
            return fragmentInfo.copy(map, map2, map3);
        }

        @NotNull
        public String toString() {
            return "FragmentInfo(functions=" + this.functions + ", accessors=" + this.accessors + ", localAccessors=" + this.localAccessors + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.functions).hashCode();
            result2 = result2 * 31 + ((Object)this.accessors).hashCode();
            result2 = result2 * 31 + ((Object)this.localAccessors).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FragmentInfo)) {
                return false;
            }
            FragmentInfo fragmentInfo = (FragmentInfo)other;
            if (!Intrinsics.areEqual(this.functions, fragmentInfo.functions)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.accessors, fragmentInfo.accessors)) {
                return false;
            }
            return Intrinsics.areEqual(this.localAccessors, fragmentInfo.localAccessors);
        }
    }
}

