/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatMenuItemRenderer;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class FlatMenuItemUI
extends BasicMenuItemUI
implements FlatStylingSupport.StyleableUI {
    private FlatMenuItemRenderer renderer;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent c) {
        return new FlatMenuItemUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.menuItem, "iconTextGap", FlatUIUtils.getUIInt("MenuItem.iconTextGap", 4));
        this.renderer = this.createRenderer();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        FlatMenuItemRenderer.clearClientProperties(this.menuItem.getParent());
        this.renderer = null;
        this.oldStyleValues = null;
    }

    protected FlatMenuItemRenderer createRenderer() {
        return new FlatMenuItemRenderer(this.menuItem, this.checkIcon, this.arrowIcon, this.acceleratorFont, this.acceleratorDelimiter);
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return FlatStylingSupport.createPropertyChangeListener(c, this::installStyle, super.createPropertyChangeListener(c));
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.menuItem, "MenuItem"));
        }
        catch (RuntimeException ex) {
            LoggingFacade.INSTANCE.logSevere(null, ex);
        }
    }

    protected void applyStyle(Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String key, Object value) {
        try {
            return this.renderer.applyStyleProperty(key, value);
        }
        catch (FlatStylingSupport.UnknownStyleException unknownStyleException) {
            switch (key) {
                case "selectionBackground": {
                    Color oldValue = this.selectionBackground;
                    this.selectionBackground = (Color)value;
                    return oldValue;
                }
                case "selectionForeground": {
                    Color oldValue = this.selectionForeground;
                    this.selectionForeground = (Color)value;
                    return oldValue;
                }
                case "disabledForeground": {
                    Color oldValue = this.disabledForeground;
                    this.disabledForeground = (Color)value;
                    return oldValue;
                }
                case "acceleratorForeground": {
                    Color oldValue = this.acceleratorForeground;
                    this.acceleratorForeground = (Color)value;
                    return oldValue;
                }
                case "acceleratorSelectionForeground": {
                    Color oldValue = this.acceleratorSelectionForeground;
                    this.acceleratorSelectionForeground = (Color)value;
                    return oldValue;
                }
            }
            return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.menuItem, key, value);
        }
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c) {
        return FlatMenuItemUI.getStyleableInfos(this.renderer);
    }

    static Map<String, Class<?>> getStyleableInfos(FlatMenuItemRenderer renderer) {
        FlatStylingSupport.StyleableInfosMap infos = new FlatStylingSupport.StyleableInfosMap();
        infos.put("selectionBackground", Color.class);
        infos.put("selectionForeground", Color.class);
        infos.put("disabledForeground", Color.class);
        infos.put("acceleratorForeground", Color.class);
        infos.put("acceleratorSelectionForeground", Color.class);
        infos.putAll(renderer.getStyleableInfos());
        return infos;
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        return this.renderer.getPreferredMenuItemSize();
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        this.renderer.paintMenuItem(g2, this.selectionBackground, this.selectionForeground, this.disabledForeground, this.acceleratorForeground, this.acceleratorSelectionForeground);
    }
}

