/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.countries.tools;

import eu.hansolo.fx.countries.Country;
import eu.hansolo.fx.countries.tools.CLocation;
import eu.hansolo.fx.countries.tools.ConnectionPartType;
import java.time.Instant;
import java.util.HashMap;
import java.util.Optional;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;

public class CLocationBuilder<B extends CLocationBuilder<B>> {
    private final HashMap<String, Property> properties = new HashMap();

    protected CLocationBuilder() {
    }

    public static final CLocationBuilder create() {
        return new CLocationBuilder();
    }

    public final B name(String name) {
        this.properties.put("name", (Property)new SimpleStringProperty(name));
        return (B)this;
    }

    public final B timestamp(Instant timestamp) {
        this.properties.put("timestamp", (Property)new SimpleObjectProperty((Object)timestamp));
        return (B)this;
    }

    public final B latitude(double latitude) {
        this.properties.put("latitude", (Property)new SimpleDoubleProperty(latitude));
        return (B)this;
    }

    public final B longitude(double longitude) {
        this.properties.put("longitude", (Property)new SimpleDoubleProperty(longitude));
        return (B)this;
    }

    public final B altitude(double altitude) {
        this.properties.put("altitude", (Property)new SimpleDoubleProperty(altitude));
        return (B)this;
    }

    public final B info(String info) {
        this.properties.put("info", (Property)new SimpleStringProperty(info));
        return (B)this;
    }

    public final B fill(Color fill) {
        this.properties.put("fill", (Property)new SimpleObjectProperty((Object)fill));
        return (B)this;
    }

    public final B stroke(Color stroke) {
        this.properties.put("stroke", (Property)new SimpleObjectProperty((Object)stroke));
        return (B)this;
    }

    public final B country(Country country) {
        this.properties.put("country", (Property)new SimpleObjectProperty(Optional.of(country)));
        return (B)this;
    }

    public final B connectionPartType(ConnectionPartType connectionPartType) {
        this.properties.put("connectionPartType", (Property)new SimpleObjectProperty((Object)connectionPartType));
        return (B)this;
    }

    public final CLocation build() {
        CLocation location = new CLocation();
        this.properties.forEach((key, property) -> {
            if ("name".equals(key)) {
                location.setName((String)((StringProperty)this.properties.get(key)).get());
            } else if ("timestamp".equals(key)) {
                location.setTimestamp((Instant)((ObjectProperty)this.properties.get(key)).get());
            } else if ("latitude".equals(key)) {
                location.setLatitude(((DoubleProperty)this.properties.get(key)).get());
            } else if ("longitude".equals(key)) {
                location.setLongitude(((DoubleProperty)this.properties.get(key)).get());
            } else if ("altitude".equals(key)) {
                location.setAltitude(((DoubleProperty)this.properties.get(key)).get());
            } else if ("info".equals(key)) {
                location.setInfo((String)((StringProperty)this.properties.get(key)).get());
            } else if ("fill".equals(key)) {
                location.setFill((Color)((ObjectProperty)this.properties.get(key)).get());
            } else if ("stroke".equals(key)) {
                location.setStroke((Color)((ObjectProperty)this.properties.get(key)).get());
            } else if ("connectionPartType".equals(key)) {
                location.setConnectionPartType((ConnectionPartType)((Object)((Object)((ObjectProperty)this.properties.get(key)).get())));
            } else if ("country".equals(key)) {
                location.setCountry((Optional)((ObjectProperty)this.properties.get(key)).get());
            }
        });
        return location;
    }
}

