/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.addons;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.events.IndicatorEvent;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.StrokeType;

@DefaultProperty(value="children")
public class Indicator
extends Region {
    private static final IndicatorEvent INDICATOR_ON = new IndicatorEvent(IndicatorEvent.INDICATOR_ON);
    private static final IndicatorEvent INDICATOR_OFF = new IndicatorEvent(IndicatorEvent.INDICATOR_OFF);
    private static final double PREFERRED_WIDTH = 64.0;
    private static final double PREFERRED_HEIGHT = 64.0;
    private static final double MINIMUM_WIDTH = 16.0;
    private static final double MINIMUM_HEIGHT = 16.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private double width;
    private double height;
    private Circle ring;
    private Circle dot;
    private Color _ringColor;
    private ObjectProperty<Color> ringColor;
    private Color _dotOnColor;
    private ObjectProperty<Color> dotOnColor;
    private Color _dotOffColor;
    private ObjectProperty<Color> dotOffColor;
    private boolean _on;
    private BooleanProperty on;
    private Pane pane;

    public Indicator() {
        this(Tile.FOREGROUND, Tile.BLUE, Color.TRANSPARENT);
    }

    public Indicator(Color DOT_ON_COLOR) {
        this(Tile.FOREGROUND, DOT_ON_COLOR, Color.TRANSPARENT);
    }

    public Indicator(Color DOT_ON_COLOR, Color DOT_OFF_COLOR) {
        this(Tile.FOREGROUND, DOT_ON_COLOR, DOT_OFF_COLOR);
    }

    public Indicator(Color RING_COLOR, Color DOT_ON_COLOR, Color DOT_OFF_COLOR) {
        this._ringColor = RING_COLOR;
        this._dotOnColor = DOT_ON_COLOR;
        this._dotOffColor = DOT_OFF_COLOR;
        this._on = false;
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(64.0, 64.0);
            }
        }
        this.ring = new Circle(32.0);
        this.ring.setStrokeType(StrokeType.INSIDE);
        this.ring.setStrokeWidth(5.0);
        this.ring.setStroke((Paint)this.getRingColor());
        this.ring.setFill((Paint)Color.TRANSPARENT);
        this.dot = new Circle(20.0);
        this.dot.setFill((Paint)this.getDotOnColor());
        this.pane = new Pane(new Node[]{this.ring, this.dot});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    public Color getRingColor() {
        return null == this.ringColor ? this._ringColor : (Color)this.ringColor.get();
    }

    public void setRingColor(Color COLOR) {
        if (null == this.ringColor) {
            this._ringColor = COLOR;
            this.redraw();
        } else {
            this.ringColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> ringColorProperty() {
        if (null == this.ringColor) {
            this.ringColor = new ObjectPropertyBase<Color>(this._ringColor){

                public Object getBean() {
                    return Indicator.this;
                }

                public String getName() {
                    return "ringColor";
                }
            };
            this._ringColor = null;
        }
        return this.ringColor;
    }

    public Color getDotOnColor() {
        return null == this.dotOnColor ? this._dotOnColor : (Color)this.dotOnColor.get();
    }

    public void setDotOnColor(Color COLOR) {
        if (null == this.dotOnColor) {
            this._dotOnColor = COLOR;
            this.redraw();
        } else {
            this.dotOnColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> dotOnColorProperty() {
        if (null == this.dotOnColor) {
            this.dotOnColor = new ObjectPropertyBase<Color>(this._dotOnColor){

                public Object getBean() {
                    return Indicator.this;
                }

                public String getName() {
                    return "dotOnColor";
                }
            };
            this._dotOnColor = null;
        }
        return this.dotOnColor;
    }

    public Color getDotOffColor() {
        return null == this.dotOffColor ? this._dotOffColor : (Color)this.dotOffColor.get();
    }

    public void setDotOffColor(Color COLOR) {
        if (null == this.dotOffColor) {
            this._dotOffColor = COLOR;
            this.redraw();
        } else {
            this.dotOffColor.set((Object)COLOR);
        }
    }

    public ObjectProperty<Color> dotOffColorProperty() {
        if (null == this.dotOffColor) {
            this.dotOffColor = new ObjectPropertyBase<Color>(this._dotOffColor){

                public Object getBean() {
                    return Indicator.this;
                }

                public String getName() {
                    return "dotOffColor";
                }
            };
            this._dotOffColor = null;
        }
        return this.dotOffColor;
    }

    public boolean isOn() {
        return null == this.on ? this._on : this.on.get();
    }

    public void setOn(boolean ON) {
        if (null == this.on) {
            this._on = ON;
            this.fireEvent(this._on ? INDICATOR_ON : INDICATOR_OFF);
            this.redraw();
        } else {
            this.on.set(ON);
        }
    }

    public BooleanProperty onProperty() {
        if (null == this.on) {
            this.on = new BooleanPropertyBase(this._on){

                protected void invalidated() {
                    Indicator.this.fireEvent(this.get() ? INDICATOR_ON : INDICATOR_OFF);
                }

                public Object getBean() {
                    return Indicator.this;
                }

                public String getName() {
                    return "on";
                }
            };
        }
        return this.on;
    }

    public void layoutChildren() {
        super.layoutChildren();
    }

    protected double computeMinWidth(double HEIGHT) {
        return 16.0;
    }

    protected double computeMinHeight(double WIDTH) {
        return 16.0;
    }

    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    protected double computeMaxWidth(double HEIGHT) {
        return 1024.0;
    }

    protected double computeMaxHeight(double WIDTH) {
        return 1024.0;
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        this.size = this.width < this.height ? this.width : this.height;
        double center = this.size * 0.5;
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.setPrefSize(this.size, this.size);
            this.pane.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.ring.setStrokeWidth(this.size * 0.078125);
            this.ring.setRadius(center);
            this.ring.setCenterX(center);
            this.ring.setCenterY(center);
            this.dot.setRadius(this.size * 0.3125);
            this.dot.setCenterX(center);
            this.dot.setCenterY(center);
            this.redraw();
        }
    }

    private void redraw() {
        this.ring.setStroke((Paint)this.getRingColor());
        this.dot.setFill((Paint)(this.isOn() ? this.getDotOnColor() : this.getDotOffColor()));
    }
}

