/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import java.util.Set;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;

public class PrettyListView<T>
extends ListView<T> {
    private static String userAgentStyleSheet;
    private ScrollBar vBar = new ScrollBar();
    private ScrollBar hBar = new ScrollBar();
    private ParallelTransition parallelFadeIn;
    private ParallelTransition parallelFadeOut;

    public PrettyListView() {
        this.skinProperty().addListener(skin -> {
            this.bindScrollBars();
            this.getChildren().addAll((Object[])new Node[]{this.vBar, this.hBar});
        });
        this.getStyleClass().add((Object)"pretty-list-view");
        this.vBar.setManaged(false);
        this.vBar.setOpacity(0.0);
        this.vBar.setOrientation(Orientation.VERTICAL);
        this.vBar.getStyleClass().add((Object)"pretty-scroll-bar");
        this.vBar.visibleProperty().bind((ObservableValue)this.vBar.visibleAmountProperty().isNotEqualTo(0));
        this.hBar.setManaged(false);
        this.hBar.setOpacity(0.0);
        this.hBar.setOrientation(Orientation.HORIZONTAL);
        this.hBar.getStyleClass().add((Object)"pretty-scroll-bar");
        this.hBar.visibleProperty().bind((ObservableValue)this.hBar.visibleAmountProperty().isNotEqualTo(0));
        FadeTransition fadeInVBar = new FadeTransition(Duration.millis((double)500.0), (Node)this.vBar);
        fadeInVBar.setFromValue(0.0);
        fadeInVBar.setToValue(1.0);
        FadeTransition fadeInHBar = new FadeTransition(Duration.millis((double)500.0), (Node)this.hBar);
        fadeInHBar.setFromValue(0.0);
        fadeInHBar.setToValue(1.0);
        this.parallelFadeIn = new ParallelTransition(new Animation[]{fadeInVBar, fadeInHBar});
        FadeTransition fadeOutVBar = new FadeTransition(Duration.millis((double)500.0), (Node)this.vBar);
        fadeOutVBar.setFromValue(1.0);
        fadeOutVBar.setToValue(0.0);
        FadeTransition fadeOutHBar = new FadeTransition(Duration.millis((double)500.0), (Node)this.hBar);
        fadeOutHBar.setFromValue(1.0);
        fadeOutHBar.setToValue(0.0);
        this.parallelFadeOut = new ParallelTransition(new Animation[]{fadeOutVBar, fadeOutHBar});
        this.setFocusTraversable(false);
        this.registerListeners();
    }

    private void bindScrollBars() {
        Set nodes = this.lookupAll("VirtualScrollBar");
        nodes.stream().filter(ScrollBar.class::isInstance).forEach(node -> {
            ScrollBar bar = (ScrollBar)node;
            switch (bar.getOrientation()) {
                case VERTICAL: {
                    this.bindScrollBars(this.vBar, bar);
                    break;
                }
                case HORIZONTAL: {
                    this.bindScrollBars(this.hBar, bar);
                }
            }
        });
    }

    private void bindScrollBars(ScrollBar scrollBarA, ScrollBar scrollBarB) {
        scrollBarA.valueProperty().bindBidirectional((Property)scrollBarB.valueProperty());
        scrollBarA.minProperty().bindBidirectional((Property)scrollBarB.minProperty());
        scrollBarA.maxProperty().bindBidirectional((Property)scrollBarB.maxProperty());
        scrollBarA.visibleAmountProperty().bindBidirectional((Property)scrollBarB.visibleAmountProperty());
        scrollBarA.unitIncrementProperty().bindBidirectional((Property)scrollBarB.unitIncrementProperty());
        scrollBarA.blockIncrementProperty().bindBidirectional((Property)scrollBarB.blockIncrementProperty());
    }

    private void registerListeners() {
        EventHandler mouseHandler = e -> {
            EventType type = e.getEventType();
            if (MouseEvent.MOUSE_ENTERED.equals(type)) {
                this.parallelFadeIn.play();
            } else if (MouseEvent.MOUSE_EXITED.equals(type)) {
                this.parallelFadeOut.play();
            }
        };
        this.addEventFilter(MouseEvent.MOUSE_ENTERED, mouseHandler);
        this.addEventFilter(MouseEvent.MOUSE_EXITED, mouseHandler);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        Insets insets = this.getInsets();
        double width = this.getWidth();
        double height = this.getHeight();
        double prefWidth = this.vBar.prefWidth(-1.0);
        this.vBar.resizeRelocate(width - prefWidth - insets.getRight(), insets.getTop(), prefWidth, height - insets.getTop() - insets.getBottom());
        double prefHeight = this.hBar.prefHeight(-1.0);
        this.hBar.resizeRelocate(insets.getLeft(), height - prefHeight - insets.getBottom(), width - insets.getLeft() - insets.getRight(), prefHeight);
    }

    public String getUserAgentStylesheet() {
        if (null == userAgentStyleSheet) {
            userAgentStyleSheet = ((Object)((Object)this)).getClass().getResource("pretty-list-view.css").toExternalForm();
        }
        return userAgentStyleSheet;
    }
}

