/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.buttonsPanel;

import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.TilePane;
import javafx.scene.paint.Paint;
import javax.swing.SwingUtilities;
import mediathek.config.Daten;
import mediathek.daten.DatenPset;
import mediathek.daten.ListePset;
import mediathek.gui.messages.ProgramSetChangedEvent;
import mediathek.gui.tabs.tab_film.GuiFilme;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.tool.MessageBus;
import net.engio.mbassy.listener.Handler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ButtonsPanelController
implements Initializable {
    private static final Logger logger = LogManager.getLogger();
    @FXML
    private Tab buttonsTab;
    @FXML
    private TilePane tilePane;
    private GuiFilme guiFilme;

    public void setGuiFilme(GuiFilme guiFilme) {
        this.guiFilme = guiFilme;
    }

    public static ButtonsPanelController install(JFXPanel parent, GuiFilme guiFilme) throws IOException {
        logger.trace("install");
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(ButtonsPanelController.class.getResource("/mediathek/res/programm/fxml/pset_buttons.fxml"));
        TabPane buttonsPane = (TabPane)loader.load();
        ButtonsPanelController buttonsController = (ButtonsPanelController)loader.getController();
        buttonsController.setGuiFilme(guiFilme);
        parent.setScene(new Scene((Parent)buttonsPane));
        return buttonsController;
    }

    public void setOnCloseRequest(EventHandler<Event> e) {
        this.buttonsTab.setOnCloseRequest(e);
    }

    public void setupButtonLayout() {
        logger.trace("setupButtonLayout called");
        this.tilePane.getChildren().clear();
        ListePset listeButton = Daten.listePset.getListeButton();
        ObservableList children = this.tilePane.getChildren();
        for (DatenPset pset : listeButton) {
            String psetName = pset.arr[0];
            Color psetColor = pset.getFarbe();
            if (!pset.isFreeLine()) {
                if (pset.isLabel()) {
                    Label l = new Label(psetName);
                    if (psetColor != null) {
                        l.setTextFill((Paint)JavaFxUtils.toFXColor(psetColor));
                    }
                    children.add((Object)l);
                    continue;
                }
                Button b = new Button(psetName);
                if (psetColor != null) {
                    b.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)JavaFxUtils.toFXColor(psetColor), null, null)}));
                }
                b.setOnAction(e -> {
                    System.out.println("EXECUTING PSET BUTTON");
                    SwingUtilities.invokeLater(() -> this.guiFilme.playerStarten(pset));
                });
                children.add((Object)b);
                continue;
            }
            children.add((Object)new Label(""));
        }
    }

    @Handler
    private void handleProgramSetChangedEvent(ProgramSetChangedEvent e) {
        Platform.runLater(this::setupButtonLayout);
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        MessageBus.getMessageBus().subscribe(this);
    }
}

