/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.table;

import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.RowSorter;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import mediathek.config.MVConfig;
import mediathek.gui.tabs.tab_film.GuiFilme;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.FilmSize;
import mediathek.tool.models.TModelFilm;
import mediathek.tool.table.MVTable;
import org.apache.commons.configuration2.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MVFilmTable
extends MVTable {
    private static final Logger logger = LogManager.getLogger();
    private MyRowSorter<TableModel> sorter;
    private final List<Integer> selectedFilmNumbers = new ArrayList<Integer>();

    public MVFilmTable() {
        super(17, GuiFilme.VISIBLE_COLUMNS, Optional.of(MVConfig.Configs.SYSTEM_TAB_FILME_ICON_ANZEIGEN), Optional.of(MVConfig.Configs.SYSTEM_TAB_FILME_ICON_KLEIN), Optional.of(MVConfig.Configs.SYSTEM_EIGENSCHAFTEN_TABELLE_FILME));
        this.setAutoCreateRowSorter(false);
        this.addPropertyChangeListener("model", evt -> {
            if (this.sorter == null) {
                this.sorter = new MyRowSorter<TableModel>(this.getModel());
            }
            this.setRowSorter(this.sorter);
            this.sorter.setModel(this.getModel());
        });
    }

    @Override
    protected void loadDefaultFontSize() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            float fontSize = config.getFloat("tab.film.font_size");
            Font newFont = this.getDefaultFont().deriveFont(fontSize);
            this.setDefaultFont(newFont);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void saveDefaultFontSize() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        float fontSize = this.getDefaultFont().getSize2D();
        config.setProperty("tab.film.font_size", Float.valueOf(fontSize));
    }

    private void resetFilmeTab(int i) {
        this.reihe[i] = i;
        this.breite[i] = 200;
        switch (i) {
            case 0: {
                this.breite[i] = 75;
                break;
            }
            case 3: {
                this.breite[i] = 300;
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                this.breite[i] = 100;
                break;
            }
            case 14: {
                this.breite[i] = 500;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.breite[i] = 20;
                break;
            }
            case 11: 
            case 12: {
                this.breite[i] = 50;
            }
        }
    }

    @Override
    public void resetTabelle() {
        for (int i = 0; i < this.maxSpalten; ++i) {
            this.resetFilmeTab(i);
        }
        this.getRowSorter().setSortKeys(null);
        this.spaltenAusschalten();
        this.setSpaltenEinAus(this.breite);
        this.setSpalten();
        this.calculateRowHeight();
    }

    @Override
    protected void spaltenAusschalten() {
    }

    @Override
    public void getSpalten() {
        int i;
        this.saveSelectedTableRows();
        for (i = 0; i < this.reihe.length && i < this.getModel().getColumnCount(); ++i) {
            this.reihe[i] = this.convertColumnIndexToModel(i);
        }
        for (i = 0; i < this.breite.length && i < this.getModel().getColumnCount(); ++i) {
            this.breite[i] = this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).getWidth();
        }
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        this.listeSortKeys = rowSorter != null ? rowSorter.getSortKeys() : null;
    }

    private void reorderColumns() {
        TableColumnModel model = this.getColumnModel();
        int numCols = this.getColumnCount();
        for (int i = 0; i < this.reihe.length && i < numCols; ++i) {
            if (this.reihe[i] == i) continue;
            model.moveColumn(this.convertColumnIndexToView(this.reihe[i]), i);
        }
    }

    private void restoreSortKeys() {
        RowSorter<? extends TableModel> rowSorter;
        List<RowSorter.SortKey> tblSortKeys;
        if (this.listeSortKeys != null && this.listeSortKeys != (tblSortKeys = (rowSorter = this.getRowSorter()).getSortKeys()) && !this.listeSortKeys.isEmpty()) {
            rowSorter.setSortKeys(this.listeSortKeys);
        }
    }

    @Override
    public void setSpalten() {
        try {
            this.changeInternalColumnWidths();
            this.changeTableModelColumnWidths();
            this.reorderColumns();
            this.restoreSortKeys();
            this.restoreSelectedTableRows();
            this.validate();
        }
        catch (Exception ex) {
            logger.error("setSpalten", (Throwable)ex);
        }
    }

    private void scrollToSelectionCentered(int rowIndex) {
        Rectangle rect = this.getCellRect(rowIndex, 0, true);
        Rectangle viewRect = this.getVisibleRect();
        rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
        int centerX = (viewRect.width - rect.width) / 2;
        int centerY = (viewRect.height - rect.height) / 2;
        if (rect.x < centerX) {
            centerX = -centerX;
        }
        if (rect.y < centerY) {
            centerY = -centerY;
        }
        rect.translate(centerX, centerY);
        this.scrollRectToVisible(rect);
    }

    @Override
    protected void scrollToIndexDelegate(int index) {
        this.scrollToSelectionCentered(index);
    }

    @Override
    protected void restoreSelectedTableRows() {
        if (!this.selectedFilmNumbers.isEmpty()) {
            boolean found = false;
            this.selectionModel.setValueIsAdjusting(true);
            TModelFilm tModel = (TModelFilm)this.getModel();
            for (Integer i : this.selectedFilmNumbers) {
                int r = tModel.getModelRowForFilmNumber(i);
                if (r < 0) continue;
                r = this.convertRowIndexToView(r);
                this.addRowSelectionInterval(r, r);
                found = true;
            }
            if (!found && this.selRow >= 0 && this.getRowCount() > this.selRow) {
                this.setRowSelectionInterval(this.selRow, this.selRow);
            } else if (!found && this.selRow >= 0 && this.getRowCount() > 0) {
                int rowCount = tModel.getRowCount() - 1;
                this.setRowSelectionInterval(rowCount, rowCount);
            }
            this.selectionModel.setValueIsAdjusting(false);
        }
        this.selectedFilmNumbers.clear();
    }

    @Override
    public void saveSelectedTableRows() {
        super.saveSelectedTableRows();
        int selIndex = -1;
        if (this.selRow >= 0) {
            selIndex = (Integer)this.getModel().getValueAt(this.convertRowIndexToModel(this.selRow), 0);
        }
        this.selectedFilmNumbers.clear();
        if (selIndex >= 0) {
            for (int i : this.selRows) {
                this.selectedFilmNumbers.add((int)((Integer)this.getModel().getValueAt(this.convertRowIndexToModel(i), 0)));
            }
        }
    }

    static class MyRowSorter<M extends TableModel>
    extends TableRowSorter<M> {
        public MyRowSorter(M model) {
            super(model);
        }

        @Override
        public void setModel(M model) {
            super.setModel(model);
            this.setSortable(4, false);
            this.setSortable(5, false);
            this.setComparator(10, FilmSize::compareTo);
            this.setComparator(1, String::compareTo);
            this.setComparator(8, String::compareTo);
            this.setComparator(14, String::compareTo);
        }

        @Override
        public void setSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
            if (sortKeys != null && sortKeys.size() > 1) {
                sortKeys.remove(1);
            }
            super.setSortKeys(sortKeys);
        }
    }
}

