"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = ismPlugin;

var _constants = require("../../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/*
    TODO: migrate to types
 * Types are not available until 7.2
 * https://github.com/opensearch-project/OpenSearch-Dashboards/blob/main/src/core/server/opensearch/client/client_config.ts
 * */
function ismPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.ism = components.clientAction.namespaceFactory();
  const ism = Client.prototype.ism.prototype;
  ism.getPolicy = ca({
    url: {
      fmt: `${_constants.API.POLICY_BASE}/<%=policyId%>`,
      req: {
        policyId: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.getPolicies = ca({
    url: {
      fmt: `${_constants.API.POLICY_BASE}`
    },
    method: "GET"
  });
  ism.createPolicy = ca({
    url: {
      fmt: `${_constants.API.POLICY_BASE}/<%=policyId%>?refresh=wait_for`,
      req: {
        policyId: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "PUT"
  });
  ism.deletePolicy = ca({
    url: {
      fmt: `${_constants.API.POLICY_BASE}/<%=policyId%>?refresh=wait_for`,
      req: {
        policyId: {
          type: "string",
          required: true
        }
      }
    },
    method: "DELETE"
  });
  ism.putPolicy = ca({
    url: {
      fmt: `${_constants.API.POLICY_BASE}/<%=policyId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        policyId: {
          type: "string",
          required: true
        },
        ifSeqNo: {
          type: "string",
          required: true
        },
        ifPrimaryTerm: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "PUT"
  });
  ism.explain = ca({
    url: {
      fmt: `${_constants.API.EXPLAIN_BASE}/<%=index%>`,
      req: {
        index: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.explainAll = ca({
    url: {
      fmt: `${_constants.API.EXPLAIN_BASE}`
    },
    method: "GET"
  });
  ism.retry = ca({
    url: {
      fmt: `${_constants.API.RETRY_BASE}/<%=index%>`,
      req: {
        index: {
          type: "string",
          required: true
        }
      }
    },
    needBody: false,
    method: "POST"
  });
  ism.add = ca({
    url: {
      fmt: `${_constants.API.ADD_POLICY_BASE}/<%=index%>`,
      req: {
        index: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "POST"
  });
  ism.remove = ca({
    url: {
      fmt: `${_constants.API.REMOVE_POLICY_BASE}/<%=index%>`,
      req: {
        index: {
          type: "string",
          required: true
        }
      }
    },
    needBody: false,
    method: "POST"
  });
  ism.change = ca({
    url: {
      fmt: `${_constants.API.CHANGE_POLICY_BASE}/<%=index%>`,
      req: {
        index: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "POST"
  }); // TODO add new APIs as they are being implemented: status, stop, start

  ism.getRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.getRollups = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}`
    },
    method: "GET"
  });
  ism.createRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>?refresh=wait_for`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "PUT"
  });
  ism.deleteRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>?refresh=wait_for`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    method: "DELETE"
  });
  ism.putRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    method: "PUT"
  });
  ism.startRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>/_start`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    method: "POST"
  });
  ism.stopRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>/_stop`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    method: "POST"
  });
  ism.explainRollup = ca({
    url: {
      fmt: `${_constants.API.ROLLUP_JOBS_BASE}/<%=rollupId%>/_explain`,
      req: {
        rollupId: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.getTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.getTransforms = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/`
    },
    method: "GET"
  });
  ism.explainTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>/_explain`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.startTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>/_start`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    method: "POST"
  });
  ism.stopTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>/_stop`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    method: "POST"
  });
  ism.deleteTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    method: "DELETE"
  });
  ism.createTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>?refresh=wait_for`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "PUT"
  });
  ism.putTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/<%=transformId%>`,
      req: {
        transformId: {
          type: "string",
          required: true
        }
      }
    },
    method: "PUT"
  });
  ism.previewTransform = ca({
    url: {
      fmt: `${_constants.API.TRANSFORM_BASE}/_preview`
    },
    needBody: true,
    method: "POST"
  });
  ism.getChannels = ca({
    url: {
      fmt: `${_constants.API.CHANNELS_BASE}`
    },
    method: "GET"
  });
  ism.getChannel = ca({
    url: {
      fmt: `${_constants.API.NOTIFICATION_CONFIGS_BASE}/<%=id%>`,
      req: {
        id: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.getSMPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=id%>`,
      req: {
        id: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.getSMPolicies = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}`
    },
    method: "GET"
  });
  ism.createSMPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=policyId%>?refresh=wait_for`,
      req: {
        policyId: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "POST"
  });
  ism.updateSMPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=policyId%>?if_seq_no=<%=ifSeqNo%>&if_primary_term=<%=ifPrimaryTerm%>&refresh=wait_for`,
      req: {
        policyId: {
          type: "string",
          required: true
        },
        ifSeqNo: {
          type: "string",
          required: true
        },
        ifPrimaryTerm: {
          type: "string",
          required: true
        }
      }
    },
    needBody: true,
    method: "PUT"
  });
  ism.deleteSMPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=policyId%>?refresh=wait_for`,
      req: {
        policyId: {
          type: "string",
          required: true
        }
      }
    },
    method: "DELETE"
  });
  ism.explainSnapshotPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=id%>/_explain`,
      req: {
        id: {
          type: "string",
          required: true
        }
      }
    },
    method: "GET"
  });
  ism.startSnapshotPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=id%>/_start`,
      req: {
        id: {
          type: "string",
          required: true
        }
      }
    },
    method: "POST"
  });
  ism.stopSnapshotPolicy = ca({
    url: {
      fmt: `${_constants.API.SM_POLICY_BASE}/<%=id%>/_stop`,
      req: {
        id: {
          type: "string",
          required: true
        }
      }
    },
    method: "POST"
  });
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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