/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.reportsscheduler.model;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.reportsscheduler.model.ReportDefinitionDetails;
import org.opensearch.reportsscheduler.model.RestTag;
import org.opensearch.reportsscheduler.util.HelpersKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\b\u0018\u0000 ;2\u00020\u0001:\u0002;<Bm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0012J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003J\t\u0010(\u001a\u00020\u0005H\u00c6\u0003J\t\u0010)\u001a\u00020\u0005H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u00c6\u0003J\u000b\u0010,\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\t\u0010-\u001a\u00020\u000fH\u00c6\u0003J\u0083\u0001\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00032\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000102H\u00d6\u0003J\t\u00103\u001a\u000204H\u00d6\u0001J\t\u00105\u001a\u00020\u0003H\u00d6\u0001J\u0012\u00106\u001a\u0004\u0018\u0001072\b\b\u0002\u00108\u001a\u000209J\u001c\u00106\u001a\u0002072\b\u0010:\u001a\u0004\u0018\u0001072\b\u00108\u001a\u0004\u0018\u000109H\u0016R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001aR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0016\u00a8\u0006="}, d2={"Lorg/opensearch/reportsscheduler/model/ReportInstance;", "Lorg/opensearch/common/xcontent/ToXContentObject;", "id", "", "updatedTime", "Ljava/time/Instant;", "createdTime", "beginTime", "endTime", "tenant", "access", "", "reportDefinitionDetails", "Lorg/opensearch/reportsscheduler/model/ReportDefinitionDetails;", "status", "Lorg/opensearch/reportsscheduler/model/ReportInstance$Status;", "statusText", "inContextDownloadUrlPath", "(Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/String;Ljava/util/List;Lorg/opensearch/reportsscheduler/model/ReportDefinitionDetails;Lorg/opensearch/reportsscheduler/model/ReportInstance$Status;Ljava/lang/String;Ljava/lang/String;)V", "getAccess", "()Ljava/util/List;", "getBeginTime", "()Ljava/time/Instant;", "getCreatedTime", "getEndTime", "getId", "()Ljava/lang/String;", "getInContextDownloadUrlPath", "getReportDefinitionDetails", "()Lorg/opensearch/reportsscheduler/model/ReportDefinitionDetails;", "getStatus", "()Lorg/opensearch/reportsscheduler/model/ReportInstance$Status;", "getStatusText", "getTenant", "getUpdatedTime", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/common/xcontent/XContentBuilder;", "params", "Lorg/opensearch/common/xcontent/ToXContent$Params;", "builder", "Companion", "Status", "opensearch-reports-scheduler"})
public final class ReportInstance
implements ToXContentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final Instant updatedTime;
    @NotNull
    private final Instant createdTime;
    @NotNull
    private final Instant beginTime;
    @NotNull
    private final Instant endTime;
    @NotNull
    private final String tenant;
    @NotNull
    private final List<String> access;
    @Nullable
    private final ReportDefinitionDetails reportDefinitionDetails;
    @NotNull
    private final Status status;
    @Nullable
    private final String statusText;
    @Nullable
    private final String inContextDownloadUrlPath;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(ReportInstance.class);

    public ReportInstance(@NotNull String id, @NotNull Instant updatedTime, @NotNull Instant createdTime, @NotNull Instant beginTime, @NotNull Instant endTime, @NotNull String tenant, @NotNull List<String> access, @Nullable ReportDefinitionDetails reportDefinitionDetails, @NotNull Status status, @Nullable String statusText, @Nullable String inContextDownloadUrlPath) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)updatedTime, (String)"updatedTime");
        Intrinsics.checkNotNullParameter((Object)createdTime, (String)"createdTime");
        Intrinsics.checkNotNullParameter((Object)beginTime, (String)"beginTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        this.id = id;
        this.updatedTime = updatedTime;
        this.createdTime = createdTime;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.tenant = tenant;
        this.access = access;
        this.reportDefinitionDetails = reportDefinitionDetails;
        this.status = status;
        this.statusText = statusText;
        this.inContextDownloadUrlPath = inContextDownloadUrlPath;
    }

    public /* synthetic */ ReportInstance(String string, Instant instant, Instant instant2, Instant instant3, Instant instant4, String string2, List list, ReportDefinitionDetails reportDefinitionDetails, Status status, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x200) != 0) {
            string3 = null;
        }
        if ((n & 0x400) != 0) {
            string4 = null;
        }
        this(string, instant, instant2, instant3, instant4, string2, list, reportDefinitionDetails, status, string3, string4);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final Instant getUpdatedTime() {
        return this.updatedTime;
    }

    @NotNull
    public final Instant getCreatedTime() {
        return this.createdTime;
    }

    @NotNull
    public final Instant getBeginTime() {
        return this.beginTime;
    }

    @NotNull
    public final Instant getEndTime() {
        return this.endTime;
    }

    @NotNull
    public final String getTenant() {
        return this.tenant;
    }

    @NotNull
    public final List<String> getAccess() {
        return this.access;
    }

    @Nullable
    public final ReportDefinitionDetails getReportDefinitionDetails() {
        return this.reportDefinitionDetails;
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    @Nullable
    public final String getStatusText() {
        return this.statusText;
    }

    @Nullable
    public final String getInContextDownloadUrlPath() {
        return this.inContextDownloadUrlPath;
    }

    @Nullable
    public final XContentBuilder toXContent(@NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.toXContent(XContentFactory.jsonBuilder(), params);
    }

    public static /* synthetic */ XContentBuilder toXContent$default(ReportInstance reportInstance, ToXContent.Params params, int n, Object object) {
        if ((n & 1) != 0) {
            ToXContent.Params params2 = ToXContent.EMPTY_PARAMS;
            Intrinsics.checkNotNullExpressionValue((Object)params2, (String)"EMPTY_PARAMS");
            params = params2;
        }
        return reportInstance.toXContent(params);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        builder.startObject();
        ToXContent.Params params2 = params;
        if (params2 == null ? false : params2.paramAsBoolean("id", false)) {
            builder.field("id", this.id);
        }
        builder.field("lastUpdatedTimeMs", this.updatedTime.toEpochMilli()).field("createdTimeMs", this.createdTime.toEpochMilli()).field("beginTimeMs", this.beginTime.toEpochMilli()).field("endTimeMs", this.endTime.toEpochMilli()).field("tenant", this.tenant);
        ToXContent.Params params3 = params;
        if ((params3 == null ? false : params3.paramAsBoolean("access", true)) && !((Collection)this.access).isEmpty()) {
            builder.field("access", (Iterable)this.access);
        }
        if (this.reportDefinitionDetails != null) {
            builder.field("reportDefinitionDetails");
            ToXContent.Params params4 = params;
            ToXContent.Params passingParams = (params4 == null ? null : params4.param("id")) == null ? RestTag.INSTANCE.getINSTANCE_INDEX_PARAMS() : params;
            this.reportDefinitionDetails.toXContent(builder, passingParams);
        }
        builder.field("status", this.status.name());
        if (this.statusText != null) {
            builder.field("statusText", this.statusText);
        }
        if (this.inContextDownloadUrlPath != null) {
            builder.field("inContextDownloadUrlPath", this.inContextDownloadUrlPath);
        }
        builder.endObject();
        return builder;
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final Instant component2() {
        return this.updatedTime;
    }

    @NotNull
    public final Instant component3() {
        return this.createdTime;
    }

    @NotNull
    public final Instant component4() {
        return this.beginTime;
    }

    @NotNull
    public final Instant component5() {
        return this.endTime;
    }

    @NotNull
    public final String component6() {
        return this.tenant;
    }

    @NotNull
    public final List<String> component7() {
        return this.access;
    }

    @Nullable
    public final ReportDefinitionDetails component8() {
        return this.reportDefinitionDetails;
    }

    @NotNull
    public final Status component9() {
        return this.status;
    }

    @Nullable
    public final String component10() {
        return this.statusText;
    }

    @Nullable
    public final String component11() {
        return this.inContextDownloadUrlPath;
    }

    @NotNull
    public final ReportInstance copy(@NotNull String id, @NotNull Instant updatedTime, @NotNull Instant createdTime, @NotNull Instant beginTime, @NotNull Instant endTime, @NotNull String tenant, @NotNull List<String> access, @Nullable ReportDefinitionDetails reportDefinitionDetails, @NotNull Status status, @Nullable String statusText, @Nullable String inContextDownloadUrlPath) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)updatedTime, (String)"updatedTime");
        Intrinsics.checkNotNullParameter((Object)createdTime, (String)"createdTime");
        Intrinsics.checkNotNullParameter((Object)beginTime, (String)"beginTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        return new ReportInstance(id, updatedTime, createdTime, beginTime, endTime, tenant, access, reportDefinitionDetails, status, statusText, inContextDownloadUrlPath);
    }

    public static /* synthetic */ ReportInstance copy$default(ReportInstance reportInstance, String string, Instant instant, Instant instant2, Instant instant3, Instant instant4, String string2, List list, ReportDefinitionDetails reportDefinitionDetails, Status status, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = reportInstance.id;
        }
        if ((n & 2) != 0) {
            instant = reportInstance.updatedTime;
        }
        if ((n & 4) != 0) {
            instant2 = reportInstance.createdTime;
        }
        if ((n & 8) != 0) {
            instant3 = reportInstance.beginTime;
        }
        if ((n & 0x10) != 0) {
            instant4 = reportInstance.endTime;
        }
        if ((n & 0x20) != 0) {
            string2 = reportInstance.tenant;
        }
        if ((n & 0x40) != 0) {
            list = reportInstance.access;
        }
        if ((n & 0x80) != 0) {
            reportDefinitionDetails = reportInstance.reportDefinitionDetails;
        }
        if ((n & 0x100) != 0) {
            status = reportInstance.status;
        }
        if ((n & 0x200) != 0) {
            string3 = reportInstance.statusText;
        }
        if ((n & 0x400) != 0) {
            string4 = reportInstance.inContextDownloadUrlPath;
        }
        return reportInstance.copy(string, instant, instant2, instant3, instant4, string2, list, reportDefinitionDetails, status, string3, string4);
    }

    @NotNull
    public String toString() {
        return "ReportInstance(id=" + this.id + ", updatedTime=" + this.updatedTime + ", createdTime=" + this.createdTime + ", beginTime=" + this.beginTime + ", endTime=" + this.endTime + ", tenant=" + this.tenant + ", access=" + this.access + ", reportDefinitionDetails=" + this.reportDefinitionDetails + ", status=" + this.status + ", statusText=" + this.statusText + ", inContextDownloadUrlPath=" + this.inContextDownloadUrlPath + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.updatedTime.hashCode();
        result = result * 31 + this.createdTime.hashCode();
        result = result * 31 + this.beginTime.hashCode();
        result = result * 31 + this.endTime.hashCode();
        result = result * 31 + this.tenant.hashCode();
        result = result * 31 + ((Object)this.access).hashCode();
        result = result * 31 + (this.reportDefinitionDetails == null ? 0 : this.reportDefinitionDetails.hashCode());
        result = result * 31 + this.status.hashCode();
        result = result * 31 + (this.statusText == null ? 0 : this.statusText.hashCode());
        result = result * 31 + (this.inContextDownloadUrlPath == null ? 0 : this.inContextDownloadUrlPath.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReportInstance)) {
            return false;
        }
        ReportInstance reportInstance = (ReportInstance)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)reportInstance.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.updatedTime, (Object)reportInstance.updatedTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.createdTime, (Object)reportInstance.createdTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.beginTime, (Object)reportInstance.beginTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endTime, (Object)reportInstance.endTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tenant, (Object)reportInstance.tenant)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.access, reportInstance.access)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.reportDefinitionDetails, (Object)reportInstance.reportDefinitionDetails)) {
            return false;
        }
        if (this.status != reportInstance.status) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.statusText, (Object)reportInstance.statusText)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.inContextDownloadUrlPath, (Object)reportInstance.inContextDownloadUrlPath);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/reportsscheduler/model/ReportInstance$Status;", "", "(Ljava/lang/String;I)V", "Scheduled", "Executing", "Success", "Failed", "opensearch-reports-scheduler"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status Scheduled = new Status();
        public static final /* enum */ Status Executing = new Status();
        public static final /* enum */ Status Success = new Status();
        public static final /* enum */ Status Failed = new Status();
        private static final /* synthetic */ Status[] $VALUES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        static {
            $VALUES = statusArray = new Status[]{Status.Scheduled, Status.Executing, Status.Success, Status.Failed};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eR\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/opensearch/reportsscheduler/model/ReportInstance$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "parse", "Lorg/opensearch/reportsscheduler/model/ReportInstance;", "parser", "Lorg/opensearch/common/xcontent/XContentParser;", "useId", "", "opensearch-reports-scheduler"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final ReportInstance parse(@NotNull XContentParser parser, @Nullable String useId) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            String id = useId;
            Instant updatedTime = null;
            Instant createdTime = null;
            Instant beginTime = null;
            Instant endTime = null;
            String tenant = null;
            List<String> access = CollectionsKt.emptyList();
            ReportDefinitionDetails reportDefinitionDetails = null;
            Status status = null;
            String statusText = null;
            String inContextDownloadUrlPath = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            block26: while (XContentParser.Token.END_OBJECT != parser.nextToken()) {
                String fieldName;
                block45: {
                    fieldName = parser.currentName();
                    parser.nextToken();
                    String string = fieldName;
                    if (string == null) break block45;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 121872994: {
                            if (string.equals("inContextDownloadUrlPath")) {
                                n = 1;
                            }
                            break;
                        }
                        case -394530056: {
                            if (string.equals("lastUpdatedTimeMs")) {
                                n = 2;
                            }
                            break;
                        }
                        case -1423461020: {
                            if (string.equals("access")) {
                                n = 3;
                            }
                            break;
                        }
                        case 1643084379: {
                            if (string.equals("createdTimeMs")) {
                                n = 4;
                            }
                            break;
                        }
                        case -207003812: {
                            if (string.equals("beginTimeMs")) {
                                n = 5;
                            }
                            break;
                        }
                        case 248004671: {
                            if (string.equals("statusText")) {
                                n = 6;
                            }
                            break;
                        }
                        case -1906132325: {
                            if (string.equals("reportDefinitionDetails")) {
                                n = 7;
                            }
                            break;
                        }
                        case 3355: {
                            if (string.equals("id")) {
                                n = 8;
                            }
                            break;
                        }
                        case 1627521550: {
                            if (string.equals("endTimeMs")) {
                                n = 9;
                            }
                            break;
                        }
                        case -877336406: {
                            if (string.equals("tenant")) {
                                n = 10;
                            }
                            break;
                        }
                        case -892481550: {
                            if (string.equals("status")) {
                                n = 11;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 8: {
                            id = parser.text();
                            continue block26;
                        }
                        case 2: {
                            updatedTime = Instant.ofEpochMilli(parser.longValue());
                            continue block26;
                        }
                        case 4: {
                            createdTime = Instant.ofEpochMilli(parser.longValue());
                            continue block26;
                        }
                        case 5: {
                            beginTime = Instant.ofEpochMilli(parser.longValue());
                            continue block26;
                        }
                        case 9: {
                            endTime = Instant.ofEpochMilli(parser.longValue());
                            continue block26;
                        }
                        case 10: {
                            tenant = parser.text();
                            continue block26;
                        }
                        case 3: {
                            access = HelpersKt.stringList(parser);
                            continue block26;
                        }
                        case 7: {
                            reportDefinitionDetails = ReportDefinitionDetails.Companion.parse$default(ReportDefinitionDetails.Companion, parser, null, 2, null);
                            continue block26;
                        }
                        case 11: {
                            String string2 = parser.text();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parser.text()");
                            status = Status.valueOf(string2);
                            continue block26;
                        }
                        case 6: {
                            statusText = parser.text();
                            continue block26;
                        }
                        case 1: {
                            inContextDownloadUrlPath = parser.text();
                            continue block26;
                        }
                    }
                }
                parser.skipChildren();
                this.getLog().info("reports:ReportInstance Skipping Unknown field " + fieldName);
            }
            if (id == null) {
                throw new IllegalArgumentException("id field absent");
            }
            if (updatedTime == null) {
                throw new IllegalArgumentException("lastUpdatedTimeMs field absent");
            }
            if (createdTime == null) {
                throw new IllegalArgumentException("createdTimeMs field absent");
            }
            if (beginTime == null) {
                throw new IllegalArgumentException("beginTimeMs field absent");
            }
            if (endTime == null) {
                throw new IllegalArgumentException("endTimeMs field absent");
            }
            String string = tenant;
            if (string == null) {
                string = tenant = "";
            }
            if (status == null) {
                throw new IllegalArgumentException("status field absent");
            }
            return new ReportInstance(id, updatedTime, createdTime, beginTime, endTime, tenant, access, reportDefinitionDetails, status, statusText, inContextDownloadUrlPath);
        }

        public static /* synthetic */ ReportInstance parse$default(Companion companion, XContentParser xContentParser, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.parse(xContentParser, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

