/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.expression.Cast;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionImplementation;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.expression.function.FunctionSignature;

public class BuiltinFunctionRepository {
    public static final String DEFAULT_NAMESPACE = "default";
    private final Map<String, Map<FunctionName, FunctionResolver>> namespaceFunctionResolverMap;

    public void register(FunctionResolver resolver) {
        this.register(DEFAULT_NAMESPACE, resolver);
    }

    public void register(String namespace, FunctionResolver resolver) {
        if (!this.namespaceFunctionResolverMap.containsKey(namespace)) {
            HashMap functionResolverMap = new HashMap();
            this.namespaceFunctionResolverMap.put(namespace, functionResolverMap);
        }
        this.namespaceFunctionResolverMap.get(namespace).put(resolver.getFunctionName(), resolver);
    }

    public FunctionImplementation compile(FunctionName functionName, List<Expression> expressions) {
        return this.compile(DEFAULT_NAMESPACE, functionName, expressions);
    }

    public FunctionImplementation compile(String namespace, FunctionName functionName, List<Expression> expressions) {
        ArrayList<String> namespaceList = new ArrayList<String>(List.of(DEFAULT_NAMESPACE));
        if (!namespace.equals(DEFAULT_NAMESPACE)) {
            namespaceList.add(namespace);
        }
        FunctionBuilder resolvedFunctionBuilder = this.resolve(namespaceList, new FunctionSignature(functionName, expressions.stream().map(expression -> expression.type()).collect(Collectors.toList())));
        return resolvedFunctionBuilder.apply(expressions);
    }

    public FunctionBuilder resolve(List<String> namespaces, FunctionSignature functionSignature) {
        FunctionName functionName = functionSignature.getFunctionName();
        FunctionBuilder result = null;
        for (String namespace : namespaces) {
            if (!this.namespaceFunctionResolverMap.containsKey(namespace) || !this.namespaceFunctionResolverMap.get(namespace).containsKey(functionName)) continue;
            result = this.getFunctionBuilder(functionSignature, functionName, this.namespaceFunctionResolverMap.get(namespace));
            break;
        }
        if (result == null) {
            throw new ExpressionEvaluationException(String.format("unsupported function name: %s", functionName.getFunctionName()));
        }
        return result;
    }

    private FunctionBuilder getFunctionBuilder(FunctionSignature functionSignature, FunctionName functionName, Map<FunctionName, FunctionResolver> functionResolverMap) {
        Pair<FunctionSignature, FunctionBuilder> resolvedSignature = functionResolverMap.get(functionName).resolve(functionSignature);
        List<ExprType> sourceTypes = functionSignature.getParamTypeList();
        List<ExprType> targetTypes = ((FunctionSignature)resolvedSignature.getKey()).getParamTypeList();
        FunctionBuilder funcBuilder = (FunctionBuilder)resolvedSignature.getValue();
        if (Cast.isCastFunction(functionName) || sourceTypes.equals(targetTypes)) {
            return funcBuilder;
        }
        return this.castArguments(sourceTypes, targetTypes, funcBuilder);
    }

    private FunctionBuilder castArguments(List<ExprType> sourceTypes, List<ExprType> targetTypes, FunctionBuilder funcBuilder) {
        return arguments -> {
            ArrayList<Expression> argsCasted = new ArrayList<Expression>();
            for (int i = 0; i < arguments.size(); ++i) {
                ExprType targetType;
                Expression arg = (Expression)arguments.get(i);
                ExprType sourceType = (ExprType)sourceTypes.get(i);
                if (this.isCastRequired(sourceType, targetType = (ExprType)targetTypes.get(i))) {
                    argsCasted.add(this.cast(arg, targetType));
                    continue;
                }
                argsCasted.add(arg);
            }
            return funcBuilder.apply(argsCasted);
        };
    }

    private boolean isCastRequired(ExprType sourceType, ExprType targetType) {
        if (ExprCoreType.numberTypes().contains(sourceType) && ExprCoreType.numberTypes().contains(targetType)) {
            return false;
        }
        return sourceType.shouldCast(targetType);
    }

    private Expression cast(Expression arg, ExprType targetType) {
        FunctionName castFunctionName = Cast.getCastFunctionName(targetType);
        if (castFunctionName == null) {
            throw new ExpressionEvaluationException(StringUtils.format((String)"Type conversion to type %s is not supported", (Object[])new Object[]{targetType}));
        }
        return (Expression)((Object)this.compile(castFunctionName, (List<Expression>)ImmutableList.of((Object)arg)));
    }

    @Generated
    public BuiltinFunctionRepository(Map<String, Map<FunctionName, FunctionResolver>> namespaceFunctionResolverMap) {
        this.namespaceFunctionResolverMap = namespaceFunctionResolverMap;
    }
}

