/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.logical;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.tree.RareTopN;
import org.opensearch.sql.ast.tree.Sort;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.LiteralExpression;
import org.opensearch.sql.expression.NamedExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.aggregation.NamedAggregator;
import org.opensearch.sql.expression.window.WindowDefinition;
import org.opensearch.sql.planner.logical.LogicalAggregation;
import org.opensearch.sql.planner.logical.LogicalDedupe;
import org.opensearch.sql.planner.logical.LogicalEval;
import org.opensearch.sql.planner.logical.LogicalFilter;
import org.opensearch.sql.planner.logical.LogicalHighlight;
import org.opensearch.sql.planner.logical.LogicalLimit;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalProject;
import org.opensearch.sql.planner.logical.LogicalRareTopN;
import org.opensearch.sql.planner.logical.LogicalRelation;
import org.opensearch.sql.planner.logical.LogicalRemove;
import org.opensearch.sql.planner.logical.LogicalRename;
import org.opensearch.sql.planner.logical.LogicalSort;
import org.opensearch.sql.planner.logical.LogicalValues;
import org.opensearch.sql.planner.logical.LogicalWindow;
import org.opensearch.sql.storage.Table;

public final class LogicalPlanDSL {
    public static LogicalPlan aggregation(LogicalPlan input, List<NamedAggregator> aggregatorList, List<NamedExpression> groupByList) {
        return new LogicalAggregation(input, aggregatorList, groupByList);
    }

    public static LogicalPlan filter(LogicalPlan input, Expression expression) {
        return new LogicalFilter(input, expression);
    }

    public static LogicalPlan relation(String tableName, Table table) {
        return new LogicalRelation(tableName, table);
    }

    public static LogicalPlan rename(LogicalPlan input, Map<ReferenceExpression, ReferenceExpression> renameMap) {
        return new LogicalRename(input, renameMap);
    }

    public static LogicalPlan project(LogicalPlan input, NamedExpression ... fields) {
        return new LogicalProject(input, Arrays.asList(fields), (List<NamedExpression>)ImmutableList.of());
    }

    public static LogicalPlan project(LogicalPlan input, List<NamedExpression> fields, List<NamedExpression> namedParseExpressions) {
        return new LogicalProject(input, fields, namedParseExpressions);
    }

    public static LogicalPlan window(LogicalPlan input, NamedExpression windowFunction, WindowDefinition windowDefinition) {
        return new LogicalWindow(input, windowFunction, windowDefinition);
    }

    public static LogicalPlan highlight(LogicalPlan input, Expression field, Map<String, Literal> arguments) {
        return new LogicalHighlight(input, field, arguments);
    }

    public static LogicalPlan remove(LogicalPlan input, ReferenceExpression ... fields) {
        return new LogicalRemove(input, (Set<ReferenceExpression>)ImmutableSet.copyOf((Object[])fields));
    }

    public static LogicalPlan eval(LogicalPlan input, Pair<ReferenceExpression, Expression> ... expressions) {
        return new LogicalEval(input, Arrays.asList(expressions));
    }

    public static LogicalPlan sort(LogicalPlan input, Pair<Sort.SortOption, Expression> ... sorts) {
        return new LogicalSort(input, Arrays.asList(sorts));
    }

    public static LogicalPlan dedupe(LogicalPlan input, Expression ... fields) {
        return LogicalPlanDSL.dedupe(input, 1, false, false, fields);
    }

    public static LogicalPlan dedupe(LogicalPlan input, int allowedDuplication, boolean keepEmpty, boolean consecutive, Expression ... fields) {
        return new LogicalDedupe(input, Arrays.asList(fields), allowedDuplication, keepEmpty, consecutive);
    }

    public static LogicalPlan rareTopN(LogicalPlan input, RareTopN.CommandType commandType, List<Expression> groupByList, Expression ... fields) {
        return LogicalPlanDSL.rareTopN(input, commandType, 10, groupByList, fields);
    }

    public static LogicalPlan rareTopN(LogicalPlan input, RareTopN.CommandType commandType, int noOfResults, List<Expression> groupByList, Expression ... fields) {
        return new LogicalRareTopN(input, commandType, noOfResults, Arrays.asList(fields), groupByList);
    }

    @SafeVarargs
    public static LogicalPlan values(List<LiteralExpression> ... values) {
        return new LogicalValues(Arrays.asList(values));
    }

    public static LogicalPlan limit(LogicalPlan input, Integer limit, Integer offset) {
        return new LogicalLimit(input, limit, offset);
    }

    @Generated
    private LogicalPlanDSL() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

