/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.plugin;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.sql.catalog.CatalogService;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.legacy.metrics.MetricName;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.sql.legacy.plugin.OpenSearchSQLPluginConfig;
import org.opensearch.sql.opensearch.security.SecurityAccess;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.protocol.response.QueryResult;
import org.opensearch.sql.protocol.response.format.CsvResponseFormatter;
import org.opensearch.sql.protocol.response.format.Format;
import org.opensearch.sql.protocol.response.format.JdbcResponseFormatter;
import org.opensearch.sql.protocol.response.format.JsonResponseFormatter;
import org.opensearch.sql.protocol.response.format.RawResponseFormatter;
import org.opensearch.sql.protocol.response.format.ResponseFormatter;
import org.opensearch.sql.sql.SQLService;
import org.opensearch.sql.sql.config.SQLServiceConfig;
import org.opensearch.sql.sql.domain.SQLQueryRequest;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class RestSQLQueryAction
extends BaseRestHandler {
    private static final Logger LOG = LogManager.getLogger();
    public static final BaseRestHandler.RestChannelConsumer NOT_SUPPORTED_YET = null;
    private final ClusterService clusterService;
    private final Settings pluginSettings;
    private final CatalogService catalogService;

    public RestSQLQueryAction(ClusterService clusterService, Settings pluginSettings, CatalogService catalogService) {
        this.clusterService = clusterService;
        this.pluginSettings = pluginSettings;
        this.catalogService = catalogService;
    }

    public String getName() {
        return "sql_query_action";
    }

    public List<RestHandler.Route> routes() {
        throw new UnsupportedOperationException("New SQL handler is not ready yet");
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) {
        throw new UnsupportedOperationException("New SQL handler is not ready yet");
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(SQLQueryRequest request, NodeClient nodeClient) {
        PhysicalPlan plan;
        if (!request.isSupported()) {
            return NOT_SUPPORTED_YET;
        }
        SQLService sqlService = this.createSQLService(nodeClient);
        try {
            plan = sqlService.plan(sqlService.analyze(sqlService.parse(request.getQuery())));
        }
        catch (SyntaxCheckException e) {
            if (request.isExplainRequest()) {
                LOG.info("Request is falling back to old SQL engine due to: " + e.getMessage());
            }
            return NOT_SUPPORTED_YET;
        }
        if (request.isExplainRequest()) {
            return channel -> sqlService.explain(plan, this.createExplainResponseListener((RestChannel)channel));
        }
        return channel -> sqlService.execute(plan, this.createQueryResponseListener((RestChannel)channel, request));
    }

    private SQLService createSQLService(NodeClient client) {
        return this.doPrivileged(() -> {
            AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
            context.registerBean(ClusterService.class, () -> this.clusterService, new BeanDefinitionCustomizer[0]);
            context.registerBean(NodeClient.class, () -> client, new BeanDefinitionCustomizer[0]);
            context.registerBean(Settings.class, () -> this.pluginSettings, new BeanDefinitionCustomizer[0]);
            context.registerBean(CatalogService.class, () -> this.catalogService, new BeanDefinitionCustomizer[0]);
            context.register(new Class[]{OpenSearchSQLPluginConfig.class});
            context.register(new Class[]{SQLServiceConfig.class});
            context.refresh();
            return (SQLService)context.getBean(SQLService.class);
        });
    }

    private ResponseListener<ExecutionEngine.ExplainResponse> createExplainResponseListener(final RestChannel channel) {
        return new ResponseListener<ExecutionEngine.ExplainResponse>(){

            public void onResponse(ExecutionEngine.ExplainResponse response) {
                RestSQLQueryAction.this.sendResponse(channel, RestStatus.OK, new JsonResponseFormatter<ExecutionEngine.ExplainResponse>(JsonResponseFormatter.Style.PRETTY){

                    protected Object buildJsonObject(ExecutionEngine.ExplainResponse response) {
                        return response;
                    }
                }.format((Object)response));
            }

            public void onFailure(Exception e) {
                LOG.error("Error happened during explain", (Throwable)e);
                RestSQLQueryAction.logAndPublishMetrics(e);
                RestSQLQueryAction.this.sendResponse(channel, RestStatus.INTERNAL_SERVER_ERROR, "Failed to explain the query due to error: " + e.getMessage());
            }
        };
    }

    private ResponseListener<ExecutionEngine.QueryResponse> createQueryResponseListener(final RestChannel channel, SQLQueryRequest request) {
        Format format = request.format();
        Object formatter = format.equals((Object)Format.CSV) ? new CsvResponseFormatter(request.sanitize()) : (format.equals((Object)Format.RAW) ? new RawResponseFormatter() : new JdbcResponseFormatter(JsonResponseFormatter.Style.PRETTY));
        return new ResponseListener<ExecutionEngine.QueryResponse>((ResponseFormatter)formatter){
            final /* synthetic */ ResponseFormatter val$formatter;
            {
                this.val$formatter = responseFormatter;
            }

            public void onResponse(ExecutionEngine.QueryResponse response) {
                RestSQLQueryAction.this.sendResponse(channel, RestStatus.OK, this.val$formatter.format((Object)new QueryResult(response.getSchema(), (Collection)response.getResults())));
            }

            public void onFailure(Exception e) {
                LOG.error("Error happened during query handling", (Throwable)e);
                RestSQLQueryAction.logAndPublishMetrics(e);
                RestSQLQueryAction.this.sendResponse(channel, RestStatus.INTERNAL_SERVER_ERROR, this.val$formatter.format((Throwable)e));
            }
        };
    }

    private <T> T doPrivileged(PrivilegedExceptionAction<T> action) {
        try {
            return (T)SecurityAccess.doPrivileged(action);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to perform privileged action", e);
        }
    }

    private void sendResponse(RestChannel channel, RestStatus status, String content) {
        channel.sendResponse((RestResponse)new BytesRestResponse(status, "application/json; charset=UTF-8", content));
    }

    private static void logAndPublishMetrics(Exception e) {
        LOG.error("Server side error during query execution", (Throwable)e);
        Metrics.getInstance().getNumericalMetric(MetricName.FAILED_REQ_COUNT_SYS).increment();
    }
}

