/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.factory;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.Dictionary;
import net.sourceforge.plantuml.salt.Positionner2;
import net.sourceforge.plantuml.salt.Terminated;
import net.sourceforge.plantuml.salt.Terminator;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.ElementPyramid;
import net.sourceforge.plantuml.salt.element.ElementText;
import net.sourceforge.plantuml.salt.element.TableStrategy;
import net.sourceforge.plantuml.salt.factory.AbstractElementFactoryComplex;

public class ElementFactoryPyramid
extends AbstractElementFactoryComplex {
    public ElementFactoryPyramid(DataSource dataSource, Dictionary dictionary) {
        super(dataSource, dictionary);
    }

    @Override
    public Terminated<Element> create() {
        Terminated next;
        if (!this.ready()) {
            throw new IllegalStateException();
        }
        Terminated tmp = (Terminated)this.getDataSource().next();
        String header = (String)tmp.getElement();
        assert (header.startsWith("{"));
        String title = null;
        TableStrategy strategy = TableStrategy.DRAW_NONE;
        if (header.length() == 2) {
            strategy = TableStrategy.fromChar(header.charAt(1));
        }
        if (strategy == TableStrategy.DRAW_OUTSIDE_WITH_TITLE && tmp.getTerminator() == Terminator.NEWCOL) {
            title = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote((String)((Terminated)this.getDataSource().next()).getElement(), "\"");
        }
        Positionner2 positionner = new Positionner2();
        while (!this.getDataSource().peek(0).getElement().equals("}")) {
            next = this.getNextElement();
            if (this.isStar((Element)next.getElement())) {
                positionner.mergeLeft(next.getTerminator());
                continue;
            }
            positionner.add(next);
        }
        next = (Terminated)this.getDataSource().next();
        return new Terminated<Element>(new ElementPyramid(positionner, strategy, title, this.getDictionary()), next.getTerminator());
    }

    private boolean isStar(Element element) {
        if (!(element instanceof ElementText)) {
            return false;
        }
        return "*".equals(((ElementText)element).getText());
    }

    @Override
    public boolean ready() {
        String text = this.getDataSource().peek(0).getElement();
        if (text.equals("{") || text.equals("{+") || text.equals("{^") || text.equals("{#") || text.equals("{!") || text.equals("{-")) {
            String text1 = this.getDataSource().peek(1).getElement();
            return !text1.matches("[NSEW]=|T");
        }
        return false;
    }
}

