from typing import Optional

from .. import Provider as AddressProvider


class Provider(AddressProvider):

    # Building numbers don't go higher than a 1000
    building_number_formats = ("%##", "%#", "%")

    street_name_formats = ("{{dk_street_name}}{{street_suffix}}",)

    street_address_formats = ("{{street_name}} {{building_number}}",)

    street_names = (
        "Aberdeen",
        "Dompap",
        "Abildgaards",
        "Skovhare",
        "Svalehale",
        "Abrikos",
        "Absalons",
        "Adel",
        "Admiral",
        "Adrians",
        "Agerlands",
        "Aggersborg",
        "Aggersvold",
        "Agger",
        "Agnete",
        "Ahlefeldts",
        "Ahlmanns",
        "Ahorns",
        "Ahrenkildes",
        "Albaniens",
        "Aldersro",
        "Allers",
        "Alexandria",
        "Alliance",
        "Alperose",
        "Als",
        "Alsted",
        "Amagerbro",
        "Amagerfælled",
        "Amager",
        "Amagermotoren",
        "Amager Strand",
        "Amalie",
        "Amalie Skrams",
        "Amerika",
        "Amsterdam",
        "Angel",
        "Anneberg",
        "Anneke",
        "Annex",
        "Ansgars",
        "Antoinette",
        "Antoni",
        "Apollo",
        "Arabiens",
        "Arendals",
        "Arkona",
        "Armeniens",
        "Arne Jacobsens",
        "Arnes",
        "Arresø",
        "Arsenal",
        "Artilleri",
        "Asger Jorns",
        "Askø",
        "Asminderød",
        "Asnæs",
        "Assens",
        "Asters",
        "Astrup",
        "Asyl",
        "Athens",
        "Augusta",
        "Australiens",
        "Backers",
        "Badens",
        "Badstue",
        "Bager",
        "Baggesens",
        "Bakke",
        "Balders",
        "Ballum",
        "Baltika",
        "Bandholm",
        "Bangerts",
        "Bangsbo",
        "Bardenfleths",
        "Søfly",
        "Bartholins",
        "Basnæs",
        "Bastion",
        "Bavnager",
        "Bavnehøj",
        "Beate",
        "Bechgaards",
        "Bedford",
        "Beethovens",
        "Beldringe",
        "Belfast",
        "Belgiens",
        "Bellahøj",
        "Belle de Boskoop",
        "Bellida",
        "Bellis",
        "Bellmans",
        "Bergens",
        "Berggreens",
        "Bergthoras",
        "Bernstorffs",
        "Bevtoft",
        "Biens",
        "Billed",
        "Billesborg",
        "Birkager",
        "Birkedommer",
        "Birke",
        "Birkholm",
        "Birma",
        "Bisidder",
        "Bispebjerg",
        "Bispe",
        "Bissens",
        "Bjelkes",
        "Bjergmarks",
        "Bjergsted",
        "Bjernede",
        "Bjerregårds Side",
        "Bjerregårds",
        "Bjørneklo",
        "Bjørnsons",
        "Blanka",
        "Blegdams",
        "Blekinge",
        "Blushøj",
        "Blytækker",
        "Blåbær",
        "Blågårds",
        "Blåmejse",
        "Blåmunke",
        "Bodils",
        "Boeslunde",
        "Bogense",
        "Bogenæs",
        "Bogfinke",
        "Bogholder",
        "Bogtrykker",
        "Bohlendach",
        "Bolands",
        "Boldhus",
        "Bolton",
        "Bomhus",
        "Bomslutter",
        "Bomulds",
        "Bordeaux",
        "Borgbjergs",
        "Borger",
        "Borgmester Jensens",
        "Borgskriver",
        "Borneo",
        "Bornholms",
        "Borreby",
        "Borthigs",
        "Borups",
        "Boserup",
        "Botofte",
        "Boyes",
        "Brages",
        "Bramminge",
        "Bramslykke",
        "Bratskov",
        "Bredahls",
        "Bredelands",
        "Bred",
        "Bregnerød",
        "Breidablik",
        "Bremens",
        "Breslau",
        "Brigården",
        "Bri",
        "Bristol",
        "Broager",
        "Brobergs",
        "Brofoged",
        "Brohus",
        "Broksø",
        "Brolægger",
        "Brombær",
        "Brorsons",
        "Brydes",
        "Brygger",
        "Bryggeri",
        "Brynhilde",
        "Bryssel",
        "Brøndkær",
        "Brøndum",
        "Brøndæble",
        "Brønshøjgård",
        "Brønshøjholms",
        "Brønshøj Kirke",
        "Brønshøj",
        "Bulbjerg",
        "Bulgariens",
        "Buntmager",
        "Burmeisters",
        "Bustrup",
        "Byager",
        "Bygholm",
        "Byglands",
        "Bygmester",
        "Bygård",
        "Bykilde",
        "Bymose",
        "Bækkeskov",
        "Bøhmens",
        "Bøllegård",
        "Bøllemosegårds",
        "Børglum",
        "Børs",
        "Børskov",
        "Bådehavns",
        "Bådsmands",
        "Calais",
        "Capri",
        "Carl Nielsens",
        "Carls",
        "Carstens",
        "Castbergs",
        "Ceylon",
        "Christen Bergs",
        "Christian II's",
        "Christiansborg",
        "Christianshavns Vold",
        "Christiansminde",
        "Classens",
        "Clausholm",
        "Clematis",
        "Colbjørnsens",
        "Collins",
        "Container",
        "Cox Orange",
        "Cumberlands",
        "Cyperns",
        "Cæcilia",
        "Dag Hammarskjölds",
        "Dagmars",
        "Dagø",
        "Dahlerups",
        "Dalby",
        "Dalmose",
        "Dalslands",
        "Damager",
        "Dampfærge",
        "Dannebrogs",
        "Danneskiold-Samsøes",
        "Dannevirke",
        "Danshøj",
        "Danstrup",
        "Degnemose",
        "Degneæble",
        "Delfin",
        "Delos",
        "Derby",
        "Dige",
        "Dirchs",
        "Donau",
        "Dorthea",
        "Dovre",
        "Dragsholm",
        "Drechsels",
        "Drejer",
        "Drejø",
        "Drogdens",
        "Dronning Dagmars",
        "Dronning Elisabeths",
        "Dronningens",
        "Dronningens Tvær",
        "Dronninglund",
        "Dublin",
        "Dunhammer",
        "Dunkerque",
        "Dybbøls",
        "Dybendals",
        "Dybens",
        "Dyvekes",
        "Dønnerup",
        "Ebbe Rodes",
        "Eberts",
        "Eckersbergs",
        "Edel Sauntes",
        "Edelsminde",
        "Efterslægts",
        "Egebæks",
        "Ege",
        "Egelykke",
        "Egemarke",
        "Egholm",
        "Egils",
        "Ehlers",
        "Ejdersted",
        "Ejler Billes",
        "Ekvipagemester",
        "Elba",
        "Elias",
        "Ellebjerg",
        "Elme",
        "Elmelunde",
        "Elsdyrs",
        "Elselille",
        "Elstar",
        "Elværks",
        "Emblas",
        "Emdrup Eng",
        "Emdrupgårds",
        "Emdrup Kær",
        "Emdrup Mose",
        "Emdrup",
        "Enebær",
        "Engblomme",
        "Engdals",
        "Engelholm",
        "Engelsteds",
        "Enghave",
        "Englands",
        "Engskifte",
        "Eng",
        "Enigheds",
        "Enveloppe",
        "Erantis",
        "Eriks",
        "Eriksholm",
        "Eschrichts",
        "Eskadre",
        "Eskilds",
        "Eskildstrup",
        "Eskjær",
        "Esrom",
        "Esthers",
        "Estlands",
        "Eton",
        "Ewalds",
        "Fabrikmester",
        "Fafners",
        "Fajance",
        "Fakse",
        "Fakse Tvær",
        "Faksinge",
        "Falke",
        "Fanø",
        "Farum",
        "Farver",
        "Fehmerns",
        "Femkløver",
        "Fengers",
        "Fenris",
        "Fensmark",
        "Ferring",
        "Fersken",
        "Finlands",
        "Fiol",
        "Firkløver",
        "Fiskedams",
        "Fjenneslev",
        "Fladstjerne",
        "Flaske",
        "Flensborg",
        "Flidsager",
        "Flinterup",
        "Floras",
        "Florens",
        "Florida",
        "Flors",
        "Folevads",
        "Folke Bernadottes",
        "Forbindelses",
        "Fordresgård",
        "Formosa",
        "Fortun",
        "Fossgårds",
        "Fragt",
        "Frankrigs",
        "Fredensborg",
        "Fredens",
        "Fredenshøj",
        "Fredericia",
        "Frederiksberg",
        "Frederiksborg",
        "Frederiks",
        "Frederiksgårds",
        "Frederiksstads",
        "Frederikssunds",
        "Luftmarine",
        "Frejas",
        "Fremads",
        "Freunds",
        "Frilands",
        "Frimester",
        "Fruebjerg",
        "Fuglager",
        "Fuglefænger",
        "Fuglsang",
        "Funkia",
        "Fussings",
        "Fyens",
        "Fyrbøder",
        "Fyrtårn",
        "Fælled",
        "Fælledens Passage",
        "Færgehavns",
        "Følfod",
        "Førslev",
        "Fåborg",
        "Gadekær",
        "Gadstrup",
        "Galions",
        "Gamle Vasby",
        "Gammel Jernbane",
        "Gammel Konge",
        "Gammel Køge Lande",
        "Gammeltofts",
        "Gartner",
        "Gartneri",
        "Gasværks",
        "Gaunø",
        "Gavlhus",
        "Gearhals",
        "Gefions",
        "Geislers",
        "Genua",
        "Georgine",
        "Gerbrands",
        "Gerdas",
        "Gerlev",
        "Gerners",
        "Gerts",
        "Geysers",
        "Gilbjerg",
        "Gimles",
        "Gislinge",
        "Gitter",
        "Gjorslev",
        "Gladbo",
        "Gladiolus",
        "Glas",
        "Glente",
        "Glinkas",
        "Glommens",
        "Glucks",
        "Glumsø",
        "Glückstadts",
        "Glænø",
        "Godsbane",
        "Godthåbs",
        "Gorms",
        "Gothers",
        "Gransanger",
        "Greis",
        "Grenå",
        "Grevinge",
        "Gribskov",
        "Griffenfelds",
        "Grysgårds",
        "Grækenlands",
        "Grønager",
        "Grøndals Park",
        "Grøndalsvænge",
        "Grønjords",
        "Grønløkke",
        "Grønne",
        "Grønnehave",
        "Grønnemose",
        "Grønris",
        "Gråbrødre",
        "Gråbynke",
        "Gråspurve",
        "Gråstens",
        "Gudenå",
        "Guldager",
        "Guldbergs",
        "Guldstjerne",
        "Gulkløver",
        "Gullands",
        "Gullfoss",
        "Gunhilds",
        "Gunløgs",
        "Gyldenlak",
        "Gyldenløves",
        "Gyldenris",
        "Gyrite",
        "Gyrstinge",
        "Gyvel",
        "Gørtler",
        "Gårdfæste",
        "Gårdtofte",
        "Gåsebæks",
        "Gåse",
        "Gåseurt",
        "Haderslev",
        "Hagbard",
        "Hagested",
        "Haifa",
        "Haldager",
        "Halfdans",
        "Halgreens",
        "Hallands",
        "Hallins",
        "Halsskov",
        "Hambros",
        "Hamlets",
        "Hammelstrup",
        "Hammerens",
        "Hammerichs",
        "Hammershus",
        "Hannemanns",
        "Hannover",
        "Hans Bogbinders",
        "Hanssted",
        "Hanstholm",
        "Haralds",
        "Haraldsted",
        "Harboøre",
        "Hardanger",
        "Hardenberg",
        "Hare",
        "Hareskov",
        "Harrestrup",
        "J.P.E. Hartmanns",
        "Harwich",
        "Hassel",
        "Hastings",
        "Hauser",
        "Havdrup",
        "Havkajak",
        "Havne",
        "Havre",
        "Havsgårds",
        "Haydns",
        "Hedeby",
        "Hedegaards",
        "Hedemanns",
        "Heibergs",
        "Heils",
        "Heimdals",
        "Heines",
        "Heises",
        "Hejre",
        "Heklas",
        "Heldbo",
        "Helgesens",
        "Helgolands",
        "Helikons",
        "Hellas",
        "Hellebæk",
        "Helleliden",
        "Hellested",
        "Helsingborg",
        "Helsingørmotoren",
        "Hemsedals",
        "Hendon",
        "Henriks",
        "Herbergen",
        "Herfølge",
        "Herholdts",
        "Herjedal",
        "Herlufsholm",
        "Hermods",
        "Herning",
        "Herslev",
        "Hesselø",
        "Hessens",
        "Hestemølle",
        "Hildurs",
        "Hillerød",
        "Hillerødmotoren",
        "Himmerlands",
        "Hindbær",
        "Hinde",
        "Hindustan",
        "Hirse",
        "Hirtshals",
        "Hjelms",
        "Hjertensfryds",
        "Hjerting",
        "Hjortdals",
        "Hjortholms",
        "Hjortø",
        "Hjørring",
        "Hobro",
        "Holbergs",
        "Holbæk",
        "Holbækmotoren",
        "Hollands",
        "Holmblads",
        "Holstebro",
        "Holsteinborg",
        "Holsteins",
        "Holte",
        "Hornbæk",
        "Hornemans",
        "Horsekilde",
        "Horsens",
        "Horserød",
        "Houmanns",
        "Hovedvagts",
        "Hovgaards",
        "Hovmester",
        "Hovmål",
        "Hulgårds",
        "Humlebæk",
        "Hustofte",
        "Husum",
        "Hvalsø",
        "Hvede",
        "Hveens",
        "Hvidbjerg",
        "Hvidkilde",
        "Hvidkløver",
        "Hvidtjørne",
        "Hyacint",
        "Hyldebær",
        "Hyltebjerg",
        "Hysken",
        "Hyttehus",
        "Händels",
        "Høffdings",
        "Høgholt",
        "Højbo",
        "Højdevangs",
        "Højde",
        "Højmose",
        "Højsager",
        "Højstrup",
        "Hørdums",
        "Hørhus",
        "Hørsholms",
        "Hørtofte",
        "Høsterkøb",
        "Høstgilde",
        "Høyens",
        "Håbets",
        "Ib Schønbergs",
        "Ilford",
        "India",
        "Industri",
        "Ingerslevs",
        "Ingolfs",
        "Ingrid Marie",
        "Iran",
        "Iris",
        "Irlands",
        "Irmingers",
        "Isafjords",
        "Islevhus",
        "Istanbul",
        "Isted",
        "Italiens",
        "Jagt",
        "James Grieve",
        "Jans",
        "Japan",
        "Java",
        "Jellinge",
        "Jemtelands",
        "Jena",
        "Jeppes",
        "Jerichaus",
        "Jernbane",
        "Bilbao",
        "Jernæble",
        "Jolle",
        "Jordbær",
        "Joris",
        "Judiths",
        "Jupiter",
        "Jyderup",
        "Jyllinge",
        "Jæger",
        "Jægersborg",
        "Jægerspris",
        "Kabbeleje",
        "Kaktus",
        "Kaldæa",
        "Kaliforniens",
        "Kalkbrænderihavns",
        "Kalø",
        "Kampmanns",
        "Kanada",
        "Kanonbåds",
        "Kansas",
        "Kansler",
        "Kapel",
        "Kapsel",
        "Kaprifolie",
        "Karens",
        "Karlskrona",
        "Karlslunde",
        "Karlstads",
        "Kasemat",
        "Kastanie",
        "Kastels",
        "Kastrup",
        "Katholm",
        "Katrinedals",
        "Kattegat",
        "Kattinge",
        "Kejser",
        "Keldsø",
        "Kentia",
        "Keplers",
        "Kerteminde",
        "Kildebrønde",
        "Kildevælds",
        "Kilholm",
        "Kina",
        "Kingos",
        "Kingston",
        "Kirkebjerg",
        "Kirkegårds",
        "Kirsteins",
        "Kirstinedals",
        "Kjeldsgårds",
        "Kjærstrup",
        "Klaipeda",
        "Klaksvigs",
        "Kleins",
        "Klerke",
        "Klingsey",
        "Klinte",
        "Klintholm",
        "Klitmøller",
        "Klostermarks",
        "Klosterris",
        "Kloster",
        "Klubiens",
        "Kløverblads",
        "Kløvermarks",
        "Knabro",
        "Knabstrup",
        "Knippelsbro",
        "Knivholt",
        "Knuthenborg",
        "Kolding",
        "Kompagni",
        "Kongebro",
        "Kongedybs",
        "Kongelunds",
        "Kongemarks",
        "Kongeæble",
        "Kongo",
        "Kongsdal",
        "Kongshøj",
        "Kongsted",
        "Korea",
        "Korfu",
        "Korinth",
        "Kornblomst",
        "Kornerup",
        "Kornskyld",
        "Korsager",
        "Kors",
        "Korsika",
        "Korsør",
        "Kortstilk",
        "Krabbesholm",
        "Kraftværks",
        "Krauses",
        "Kreta",
        "Krims",
        "Kristiania",
        "Krogager",
        "Krogerup",
        "Kroghs",
        "Krokodille",
        "Kronborg",
        "Kronprinsens",
        "Kronprinsesse",
        "Krudtløbs",
        "Krudtmøllegårds",
        "Krusemynte",
        "Kruså",
        "Krügers",
        "Krystal",
        "Kuglegårds",
        "Kuhlaus",
        "Kulbane",
        "Kurlands",
        "Kvintus",
        "Kvægtorvs",
        "Kvæsthus",
        "Küchlers",
        "Kyringe",
        "Kæmner",
        "Kærager",
        "Kærsanger",
        "Kærskifte",
        "Købmager",
        "Kålager",
        "Kaalunds",
        "Lager",
        "Lakse",
        "Landehjælp",
        "Landfoged",
        "Landgilde",
        "Landlyst",
        "Landsdommer",
        "Landskrona",
        "Landvindings",
        "Langager",
        "Langebro",
        "Langelinie",
        "Langhus",
        "Langkær",
        "Langø",
        "Laplands",
        "Larsbjørns",
        "Larslejs",
        "Laura",
        "Lautrups",
        "Lavendel",
        "Ledager",
        "Leifs",
        "Lejre",
        "Lemberg",
        "Lemnos",
        "Lerchenborg",
        "Lerfos",
        "Lergravs",
        "Letlands",
        "Lidemarks",
        "Liflands",
        "Lille Colbjørnsens",
        "Lille Farimags",
        "Lille Fredens",
        "Lille",
        "Lille Isted",
        "Lille Kannike",
        "Lille Kirke",
        "Lille Kongens",
        "Lille Strand",
        "Lille Søndervold",
        "Lille Thekla",
        "Lilliendals",
        "Limfjords",
        "Linde",
        "Lindenborg",
        "Lindenovs",
        "Lindgreens",
        "Lindholms",
        "Linnés",
        "Lipkes",
        "Liselund",
        "Livjæger",
        "Livorno",
        "Livø",
        "Lobelia",
        "Lodi",
        "Lombardi",
        "Lotus",
        "Lugano",
        "Lukretia",
        "Lundbyes",
        "Lundeborg",
        "Lundedals",
        "Lundehus",
        "Lundevangs",
        "Lundings",
        "Lundsfryd",
        "Lunds",
        "Lundtofte",
        "Lupin",
        "Lybæk",
        "Helsinki",
        "Lykkebo",
        "Lyneborg",
        "Lynette",
        "Lyngby",
        "Lyngholm",
        "Lyngvig",
        "Lynæs",
        "Lyon",
        "Lyrskov",
        "Lysefjords",
        "Lyshøj",
        "Lyshøjgårds",
        "Lystrup",
        "Læder",
        "Lærdals",
        "Lærke",
        "Læssøes",
        "Cork",
        "Løgstør",
        "Løgæble",
        "Løjtegårds",
        "Lønborg",
        "Løngang",
        "Lønstrup",
        "Løvetands",
        "P.D. Løvs",
        "Løv",
        "Magdelone",
        "Magister",
        "Mag",
        "Majrose",
        "Malakka",
        "Malmø",
        "Malta",
        "Mandals",
        "Mandel",
        "Mansas",
        "Mantua",
        "Manø",
        "Marathon",
        "Marbjerg",
        "Marengo",
        "Margretheholms",
        "Maribo",
        "Mariehamn",
        "Markmands",
        "Markskifte",
        "Mark",
        "Marmor",
        "Marsala",
        "Marskens",
        "Marstals",
        "Martha",
        "Masnedø",
        "Masteskurs",
        "Matthæus",
        "Meinungs",
        "Meklenborg",
        "Meldahls",
        "Mellemforts",
        "Mellemtofte",
        "Merløse",
        "Messina",
        "Metro",
        "Middelfart",
        "Middelgrunds",
        "Midgårds",
        "Mikkel Skovs",
        "Milano",
        "Milos",
        "Mimers",
        "Mimosa",
        "Mindstrup",
        "Minør",
        "Mirabelle",
        "Mitchells",
        "Mjøsens",
        "Molbechs",
        "Moldau",
        "Monrads",
        "Montagehals",
        "Montagne",
        "Morbær",
        "Morgendug",
        "Morsø",
        "Mosedal",
        "Mosel",
        "Mozarts",
        "Mullerup",
        "Murcia",
        "Murer",
        "Musholm",
        "Musvåge",
        "Mutzu",
        "Myggenæs",
        "Mysunde",
        "Møgeltønder",
        "Mølle",
        "Møllegårds",
        "C.F. Møllers",
        "Mønter",
        "Møntmester",
        "Mørkhøj",
        "Måge",
        "Mårum",
        "Nakskov",
        "Nannas",
        "Nansens",
        "Nattergale",
        "Neapel",
        "Nebraska",
        "Nelson Mandelas",
        "Nikolaj",
        "Nivå",
        "Njals",
        "Nokken Forn",
        "Nokken Hovedn",
        "Nokken Strand",
        "Nordbane",
        "Nordborg",
        "Nordby",
        "Nordfeld",
        "Skagerrak",
        "Nordhavns",
        "Nordlands",
        "Nordmarks",
        "Nordre",
        "Nordre Dige",
        "Nordre Fasan",
        "Nordre Frihavns",
        "Nordre Kongelunds",
        "Nordrup",
        "Nordsø",
        "Norges",
        "Norgesminde",
        "Normandi",
        "November",
        "Ny Adel",
        "Ny Blegdams",
        "Nyborg",
        "Nybo",
        "Nybro",
        "Ny",
        "Nygårds",
        "Ny Kongens",
        "Nyminde",
        "Nyrnberg",
        "Nyrops",
        "Nysted",
        "Nysø",
        "Ny Vester",
        "Ny Øster",
        "Nærum",
        "Næsbyholm",
        "Næstved",
        "Nøddebo",
        "Nøjsomheds",
        "Nøkkerose",
        "Nørager",
        "Nørre",
        "Nørrebro",
        "Nørre Farimags",
        "Nørre Sø",
        "Nørretofte",
        "Nørre Vold",
        "Obdams",
        "Ocean",
        "Odense",
        "Odins",
        "Odins Tvær",
        "Oehlenschlægers",
        "Offenbachs",
        "Oldermands",
        "Oldfux",
        "Oldenborg",
        "Olieblads",
        "Oliefabriks",
        "Oliemølle",
        "Olufs",
        "Olympos",
        "Omø",
        "Orgelbygger",
        "Orlogsværft",
        "Ottilia",
        "Otto Baches",
        "Ourø",
        "Overbys",
        "Overdrevs",
        "Overn Neden Vandet",
        "Overn Oven Vandet",
        "Overskous",
        "Oxford",
        "Padua",
        "Pakhus",
        "Palermo",
        "Pakkeri",
        "Palles",
        "Palnatokes",
        "Palæ",
        "Panums",
        "Parma",
        "Parnas",
        "Paros",
        "Pasteurs",
        "Peiters",
        "Per Henrik Lings",
        "Perlestikker",
        "Pernille",
        "Persiens",
        "Persille",
        "Peter Ipsens",
        "Petersborg",
        "Philip De Langes",
        "Pile",
        "Pindos",
        "Pistol",
        "Platan",
        "Polens",
        "Pommerns",
        "Pomona",
        "Poppel",
        "Portlands",
        "Portugals",
        "Postholder",
        "Pragtstjerne",
        "Primula",
        "Prinsesse",
        "Prisholm",
        "Provste",
        "Præstegårds",
        "Præstekær",
        "Præstemarks",
        "Præstø",
        "Prøvestens",
        "Puggaards",
        "Thomas Koppels",
        "Pæon",
        "Radise",
        "Rabarber",
        "Raffinaderi",
        "Ragna",
        "Ragnhild",
        "Rahbeks",
        "Ramløse",
        "Ramsings",
        "Ramunds",
        "Randbøl",
        "Randers",
        "Rantzaus",
        "Raunstrup",
        "Ravenna",
        "Ravneholms",
        "Ravnsborg",
        "Ravnsborg Tvær",
        "Rebekka",
        "Reberbane",
        "Rebild",
        "Rebslager",
        "Trelleborg",
        "Gdansk",
        "Reersø",
        "Refshale",
        "Refsnæs",
        "Regitse",
        "Reinette",
        "Rejsby",
        "Remise",
        "Rentemester",
        "Retort",
        "Reventlows",
        "Reverdils",
        "Reykjaviks",
        "Rialto",
        "Ribe",
        "Ridefoged",
        "Riga",
        "Rigens",
        "Rindby",
        "Ringholm",
        "Ringkøbing",
        "Ringsted",
        "Risager",
        "Risbyholm",
        "Rismose",
        "Rodos",
        "Romsdals",
        "Romsø",
        "Rosbæks",
        "Roselille",
        "Rosenborg",
        "Rosendals",
        "Rosen",
        "Rosenholms",
        "Rosenlunds",
        "Rosenvængets",
        "Rosenvængets Hoved",
        "Rosenørns",
        "Roshage",
        "Roskilde",
        "Rosmarin",
        "Rossinis",
        "Rostgaards",
        "Rostock",
        "Rothes",
        "Rovsings",
        "Rubikon",
        "Rubinola",
        "Rubinsteins",
        "Rugager",
        "Rughave",
        "Rug",
        "Rumæniens",
        "Rundholts",
        "Ruths",
        "Ryes",
        "Rygårds",
        "Rymarks",
        "Rysensteens",
        "Ryvangs",
        "Ræve",
        "Rødby",
        "Rødding",
        "Rødelands",
        "Røde Mellem",
        "Rødkilde",
        "Rødkløver",
        "Rødtjørne",
        "Rømers",
        "Rønnebær",
        "Rønne",
        "Rønnings",
        "Rørholms",
        "Rørmose",
        "Rørsanger",
        "Røså",
        "Rådhus",
        "Rådmands",
        "Rådvads",
        "Sadelmager",
        "Sakskøbing",
        "Salling",
        "Saltholms",
        "Saltø",
        "Samos",
        "Samsø",
        "Sandbjerg",
        "Sandbygård",
        "Sandhus",
        "Sankelmarks",
        "Sankt Jørgens",
        "Sassnitz",
        "Saxhøj",
        "Saxo",
        "Saxtorphs",
        "Scandia",
        "Schacks",
        "Scharlings",
        "Scherfigs",
        "Schleppegrells",
        "Schuberts",
        "Sejlklub",
        "Sejrø",
        "Seline",
        "Selsø",
        "Sele",
        "Serbiens",
        "Serridslev",
        "Shetlands",
        "Siam",
        "Sibberns",
        "Sibelius",
        "Siciliens",
        "Sigbrits",
        "Sigersted",
        "Signelil",
        "Sigurds",
        "Sigyns",
        "Siljan",
        "Silkeborg",
        "Silke",
        "Sions",
        "Sixtus",
        "Sjællands",
        "Skaffer",
        "Skanderborg",
        "Skarø",
        "Skelbæk",
        "Skelmose",
        "Skensved",
        "Skibelund",
        "Skinder",
        "Skipper Clements",
        "Skippinge",
        "Skjulhøj",
        "Skodsborg",
        "Skole",
        "Skoleholder",
        "Flyhangar",
        "Skotlands",
        "Skotterup",
        "Skoubo",
        "Skovbogårds",
        "Skovgaards",
        "Skovløber",
        "Skovstjerne",
        "Skudehavns",
        "Skydebane",
        "Skyggelunds",
        "Skytte",
        "Skyttegård",
        "Skåne",
        "Slagelse",
        "Slagtehus",
        "Slangerup",
        "Slejpners",
        "Slesvigs",
        "Slotsfoged",
        "Slots",
        "Slotsherrens",
        "Slotsholms",
        "Sluse",
        "Slutteri",
        "Slåen",
        "Smede",
        "Smyrna",
        "Smørum",
        "Smålands",
        "Snare",
        "H.C. Sneedorffs",
        "Sneppe",
        "Snertinge",
        "Snorres",
        "Sofie Brahes",
        "Sofie",
        "Sofienhøj",
        "Sognefjords",
        "Sokkelunds",
        "Solitude",
        "Solrød",
        "Solsikke",
        "Solskifte",
        "Soltofte",
        "Summerred",
        "Sommersted",
        "Sonnerup",
        "Sorgenfri",
        "Sorrento",
        "Sorø",
        "Southampton",
        "Spanager",
        "Spangbergs",
        "Spaniens",
        "Spanteloft",
        "Sparresholm",
        "Sparta",
        "Speditør",
        "Spinderi",
        "Spiræa",
        "Spontinis",
        "Sporemager",
        "Spøttrup",
        "Stadfeldts",
        "Stadil",
        "Stald",
        "Stampes",
        "Statholder",
        "Stavanger",
        "Stavnstrup",
        "Steenbergs",
        "Stefans",
        "Steins",
        "Stemanns",
        "Stenderup",
        "Sten",
        "Stenhugger",
        "Stenkløver",
        "Stenlands",
        "Stenlille",
        "Stenløse",
        "Stenmagle",
        "Stenos",
        "Stenrose",
        "Sternberg",
        "Stevns",
        "Stjerne",
        "Stockholms",
        "Stokhus",
        "Stokrose",
        "Stoltenbergs",
        "Storegårds",
        "Store Kannike",
        "Store Kirke",
        "Store Kongens",
        "Store Regne",
        "Store Strand",
        "Store Søndervold",
        "Storm",
        "Stradellas",
        "Strandager",
        "Strand",
        "Strandlods",
        "Stranden",
        "Stratford",
        "Strauss",
        "Strickers",
        "Strindbergs",
        "Struensee",
        "Strynø",
        "Strødam",
        "Stubbeløb",
        "Stubmølle",
        "Studie",
        "Studsgaards",
        "Sturlas",
        "Stære",
        "Støberi",
        "Støvnæs",
        "Støvring",
        "Suensons",
        "Suhms",
        "Sumatra",
        "Sundbygårds",
        "Sundby Park",
        "Sundbyvester",
        "Sundeveds",
        "Sundholms",
        "Sundkrogs",
        "Svane",
        "Svanemølle",
        "Svankær",
        "Svendborg",
        "Svends",
        "Svenstrup",
        "Sverrigs",
        "Svogerslev",
        "Sværte",
        "Sydhavns",
        "Sydløbs",
        "Sylvia",
        "Syriens",
        "Syvens",
        "Syvstens",
        "Sæby",
        "Sæbyholms",
        "Sætersdal",
        "Søfort",
        "Søllerød",
        "Sølunds",
        "Sølv",
        "Sønderborg",
        "Søndermarks",
        "Søndervangs",
        "Søndervig",
        "Søndre",
        "Søndre Fasan",
        "Søren Norbys",
        "Sørup",
        "Saabyes",
        "Taffelæble",
        "Tagens",
        "Takkelads",
        "Takkelloft",
        "Tallinn",
        "Tartinis",
        "Teglbrænder",
        "Teglgård",
        "Teglholm",
        "Teglholms",
        "Teglholm Tvær",
        "Teglstrup",
        "Teglværks",
        "Telemarks",
        "Tersløse",
        "Theis",
        "Thekla",
        "Thingvalla",
        "Thora",
        "Thors",
        "Thorshavns",
        "Thorsminde",
        "Thorupgård",
        "Thorups",
        "Thurebyholm",
        "Thyras",
        "Thyregods",
        "Thy",
        "Tibirke",
        "Tietgens",
        "Tiger",
        "Tikøb",
        "Timians",
        "Tingskifte",
        "Tingskriver",
        "Ting",
        "Tipsager",
        "Tirsbæk",
        "Titan",
        "Tjæreby",
        "Tjørne",
        "Tjørnelunds",
        "Todes",
        "Toftager",
        "Toftebakke",
        "Toftegårds",
        "Toftøje",
        "Toldbod",
        "Toldskriver",
        "Tomat",
        "Tomsgårds",
        "Tonemester",
        "Torbenfeldt",
        "Torben Oxes",
        "Tordenskjolds",
        "Torfa",
        "Tornebuske",
        "Tornsanger",
        "Torve",
        "Toskifte",
        "Tovelille",
        "Tovværk",
        "Tranehave",
        "Trane",
        "Trangravs",
        "Traps",
        "Trekløver",
        "Trekroner",
        "Trepkas",
        "Troja",
        "Tromsø",
        "Trondhjems",
        "Tryggevælde",
        "Trøjborg",
        "Tschernings",
        "Tuborg",
        "Tudseminde",
        "Tudskær",
        "Tuelands",
        "Tulipan",
        "Tullins",
        "Turesens",
        "Tustrup",
        "Tuxens",
        "Tværager",
        "Kiel",
        "Tybjerg",
        "Tyborøn",
        "Tycho Brahes",
        "Tyrols",
        "Tyttebær",
        "Tøjhus",
        "Tøjmester",
        "Tølløse",
        "Tømmergravs",
        "Tømrer",
        "Tøndebinder",
        "Tønder",
        "Tønnes",
        "Tårnblæser",
        "Tårnholms",
        "Tårnhus",
        "Tåsinge",
        "Tåstrup",
        "Udby",
        "Uffes",
        "Uggerløse",
        "Ugle",
        "Ullerup",
        "Ulrik Birchs",
        "Ulriksdal",
        "Ulvefod",
        "Ulvsund",
        "Ungarns",
        "Uplands",
        "Upsala",
        "Ural",
        "Urbans",
        "Utterslev",
        "Wagners",
        "Vagtmester",
        "Valborg",
        "Valbygårds",
        "Valby Kirke",
        "Valby Lang",
        "Valby Maskinfabriks",
        "Valby Torve",
        "Valdemars",
        "Valgårds",
        "Valhals",
        "Valhøj",
        "Valkendorfs",
        "Valkyrie",
        "Vallekilde",
        "Vallø",
        "Valmue",
        "Valnødde",
        "Vangehus",
        "Vangs",
        "Vangså",
        "Vanløse",
        "Vanløse By",
        "Varde",
        "Vasby",
        "Vatna",
        "Webers",
        "Vedbæk",
        "Weidekamps",
        "Weimar",
        "Vejlands",
        "Vejle",
        "Vejrø",
        "Veksø",
        "Venders",
        "Vendsyssel",
        "Venedig",
        "Vennely",
        "Venneminde",
        "Venø",
        "Veras",
        "Verdis",
        "Vermlands",
        "Vermunds",
        "Verona",
        "Wessels",
        "Vestager",
        "Vestbane",
        "Vesterbro",
        "Vester Farimags",
        "Vesterfælled",
        "Vester",
        "Vestergårds",
        "Vesterhavs",
        "Vestermarks",
        "Vester Sø",
        "Vestervig",
        "Vester Vold",
        "Vestmanna",
        "Vestre",
        "Vestre Kirkegårds",
        "Vestre Tegl",
        "Weyses",
        "Vibeke",
        "Vibe",
        "Viborg",
        "Wibrandts",
        "Wiedewelts",
        "Vigerslev",
        "Vigerslev Gods",
        "Wiinblads",
        "Viktoria",
        "Vildande",
        "Wilders",
        "Vilhelm Thomsens",
        "Willemoes",
        "Willums",
        "Vindebro",
        "Vindinge",
        "Vindmølle",
        "Vindrue",
        "Windsor",
        "Vingård",
        "Visby",
        "Wittenberg",
        "Vognborg",
        "Vognmager",
        "Vogter",
        "Voldmester",
        "Volos",
        "Wolters",
        "Vordingborg",
        "Vulkan",
        "Væbner",
        "Værksted",
        "Værnedams",
        "Væver",
        "Vølunds",
        "Vånings",
        "Yderlands",
        "Yduns",
        "Ystad",
        "Zinns",
        "Æbelø",
        "Æble",
        "Ægina",
        "Ægirs",
        "Ærtebjerg",
        "Ærtelands",
        "Ærte",
        "Ætna",
        "Ølands",
        "Øresund Park",
        "Øresundsmotoren",
        "Øresunds",
        "Ørevads",
        "Ørhage",
        "Ørholm",
        "Ørne",
        "Øsels",
        "Østbane",
        "Øster",
        "Østerbro",
        "Østerdals",
        "Øster Farimags",
        "Østergårds",
        "Øster Sø",
        "Østersø",
        "Øster Vold",
        "Østre Tegl",
        "Østrigs",
        "Åbakke",
        "Åbjerg",
        "Ådals",
        "Å",
        "Ågerup",
        "Åkande",
        "Ålands",
        "Ålborg",
        "Ålekiste",
        "Ålholm",
        "Ålstrup",
        "Åløkke",
        "Aarestrups",
        "Århus",
        "Mælkeen",
        "Løvstikke",
        "Murmansk",
        "Antwerpen",
        "Travemünde",
        "Bohrs",
        "Cylinder",
        "Støbegods",
        "Pladehals",
        "Kul",
        "Diesel",
        "Gloster",
        "Burgundy",
        "Paradisæble",
    )

    street_suffixes = (
        # gade and vej are the most common so they should be oversampled
        "gade",
        "gade",
        "stræde",
        "vej",
        "vej",
        "vej",
        " Allé",
    )

    address_formats = ("{{street_address}}\n{{postcode}} {{city}}",)

    # Postcode should be formatted as described in http://www.nr.dk/danmark.html
    postcode_formats = ("%###",)

    city_formats = ("{{city_name}}",)

    cities = (
        "Allinge",
        "Allingåbro",
        "Almind",
        "Anholt",
        "Ans by",
        "Ansager",
        "Arden",
        "Askeby",
        "Asnæs",
        "Asperup",
        "Assens",
        "Asaa",
        "Augustenborg",
        "Aulum",
        "Auning",
        "Bagenkop",
        "Bagsværd",
        "Balle",
        "Ballerup",
        "Bandholm",
        "Barrit",
        "Beder",
        "Bedsted Thy",
        "Bevtoft",
        "Billum",
        "Billund",
        "Bindslev",
        "Birkerød",
        "Bjerringbro",
        "Bjert",
        "Bjæverskov",
        "Blokhus",
        "Blommenslyst",
        "Blåvand",
        "Boeslunde",
        "Bogense",
        "Bogø By",
        "Bolderslev",
        "Bording",
        "Borre",
        "Borup",
        "Brabrand",
        "Bramming",
        "Brande",
        "Branderup",
        "Bredebro",
        "Bredsten",
        "Brenderup",
        "Broager",
        "Broby",
        "Brovst",
        "Bryrup",
        "Brædstrup",
        "Brøndby",
        "Brøndby Strand",
        "Brønderslev",
        "Brønshøj",
        "Brørup",
        "Bylderup-Bov",
        "Bække",
        "Bækmarksbro",
        "Bælum",
        "Børkop",
        "Bøvlingbjerg",
        "Charlottenlund",
        "Christiansfeld",
        "Dalby",
        "Dalmose",
        "Dannemare",
        "Daugård",
        "Dianalund",
        "Dragør",
        "Dronninglund",
        "Dronningmølle",
        "Dybvad",
        "Ebberup",
        "Ebeltoft",
        "Egernsund",
        "Egtved",
        "Egå",
        "Ejby",
        "Ejstrupholm",
        "Engesvang",
        "Errindlev",
        "Erslev",
        "Esbjerg",
        "Eskebjerg",
        "Eskilstrup",
        "Espergærde",
        "Fakse",
        "Fakse Ladeplads",
        "Fanø",
        "Farsø",
        "Farum",
        "Fejø",
        "Ferritslev Fyn",
        "Fjenneslev",
        "Fjerritslev",
        "Flemming",
        "Fredensborg",
        "Fredericia",
        "Frederiksberg",
        "Frederikshavn",
        "Frederikssund",
        "Frederiksværk",
        "Frørup",
        "Frøstrup",
        "Fuglebjerg",
        "Fur",
        "Føllenslev",
        "Føvling",
        "Faaborg",
        "Fårevejle",
        "Fårup",
        "Fårvang",
        "Gadbjerg",
        "Gadstrup",
        "Galten",
        "Gandrup",
        "Gedser",
        "Gedsted",
        "Gedved",
        "Gelsted",
        "Gentofte",
        "Gesten",
        "Gilleleje",
        "Gislev",
        "Gislinge",
        "Gistrup",
        "Give",
        "Gjerlev",
        "Gjern",
        "Glamsbjerg",
        "Glejbjerg",
        "Glesborg",
        "Glostrup",
        "Glumsø",
        "Gram",
        "Gredstedbro",
        "Grenaa",
        "Greve",
        "Greve Strand",
        "Grevinge",
        "Grindsted",
        "Græsted",
        "Gråsten",
        "Gudbjerg",
        "Gudhjem",
        "Gudme",
        "Guldborg",
        "Gørding",
        "Gørlev",
        "Gørløse",
        "Haderslev",
        "Haderup",
        "Hadsten",
        "Hadsund",
        "Hagersten",
        "Hals",
        "Hammel",
        "Hampen",
        "Hanstholm",
        "Harboøre",
        "Harlev",
        "Harndrup",
        "Harpelunde",
        "Hasle",
        "Haslev",
        "Hasselager",
        "Havdrup",
        "Havndal",
        "Hedehusene",
        "Hedensted",
        "Hejls",
        "Hejnsvig",
        "Hellebæk",
        "Hellerup",
        "Helsinge",
        "Helsingør",
        "Hemmet",
        "Henne",
        "Herfølge",
        "Herlev",
        "Herlufmagle",
        "Herning",
        "Hesselager",
        "Hillerød",
        "Hinnerup",
        "Hirtshals",
        "Hjallerup",
        "Hjerm",
        "Hjortshøj",
        "Hjørring",
        "Hobro",
        "Holbæk",
        "Holeby",
        "Holme-Olstrup",
        "Holstebro",
        "Holsted",
        "Holte",
        "Horbelev",
        "Hornbæk",
        "Hornslet",
        "Hornsyld",
        "Horsens",
        "Horslunde",
        "Hovborg",
        "Hovedgård",
        "Humble",
        "Humlebæk",
        "Hundested",
        "Hundslund",
        "Hurup Thy",
        "Hvalsø",
        "Hvide Sande",
        "Hvidovre",
        "Højbjerg",
        "Højby",
        "Højer",
        "Højslev",
        "Høng",
        "Hørning",
        "Hørsholm",
        "Hørve",
        "Haarby",
        "Hårlev",
        "Idestrup",
        "Ikast",
        "Ishøj",
        "Janderup",
        "Jelling",
        "Jerslev",
        "Jerslev",
        "Jerup",
        "Jordrup",
        "Juelsminde",
        "Jyderup",
        "Jyllinge",
        "Jystrup",
        "Jægerspris",
        "Kalundborg",
        "Kalvehave",
        "Karby",
        "Karise",
        "Karlslunde",
        "Karrebæksminde",
        "Karup",
        "Kastrup",
        "Kerteminde",
        "Kettinge",
        "Kibæk",
        "Kirke Eskilstrup",
        "Kirke Hyllinge",
        "Kirke Såby",
        "Kjellerup",
        "Klampenborg",
        "Klarup",
        "Klemensker",
        "Klippinge",
        "Klovborg",
        "Knebel",
        "Kokkedal",
        "Kolding",
        "Kolind",
        "Kongens Lyngby",
        "Kongerslev",
        "Korsør",
        "Kruså",
        "Kvistgård",
        "Kværndrup",
        "København",
        "Køge",
        "Langebæk",
        "Langeskov",
        "Langå",
        "Lejre",
        "Lem",
        "Lemming",
        "Lemvig",
        "Lille Skensved",
        "Lintrup",
        "Liseleje",
        "Lundby",
        "Lunderskov",
        "Lynge",
        "Lystrup",
        "Læsø",
        "Løgstrup",
        "Løgstør",
        "Løgumkloster",
        "Løkken",
        "Løsning",
        "Låsby",
        "Malling",
        "Mariager",
        "Maribo",
        "Marslev",
        "Marstal",
        "Martofte",
        "Melby",
        "Mern",
        "Mesinge",
        "Middelfart",
        "Millinge",
        "Morud",
        "Munke Bjergby",
        "Munkebo",
        "Møldrup",
        "Mørke",
        "Mørkøv",
        "Måløv",
        "Mårslet",
        "Nakskov",
        "Nexø",
        "Nibe",
        "Nimtofte",
        "Nivå",
        "Nordborg",
        "Nyborg",
        "Nykøbing F",
        "Nykøbing M",
        "Nykøbing Sj",
        "Nyrup",
        "Nysted",
        "Nærum",
        "Næstved",
        "Nørager",
        "Nørre Alslev",
        "Nørre Asmindrup",
        "Nørre Nebel",
        "Nørre Snede",
        "Nørre Aaby",
        "Nørreballe",
        "Nørresundby",
        "Odder",
        "Odense",
        "Oksbøl",
        "Otterup",
        "Oure",
        "Outrup",
        "Padborg",
        "Pandrup",
        "Præstø",
        "Randbøl",
        "Randers",
        "Ranum",
        "Rask Mølle",
        "Redsted",
        "Regstrup",
        "Ribe",
        "Ringe",
        "Ringkøbing",
        "Ringsted",
        "Risskov",
        "Roskilde",
        "Roslev",
        "Rude",
        "Rudkøbing",
        "Ruds Vedby",
        "Rungsted Kyst",
        "Ry",
        "Rynkeby",
        "Ryomgård",
        "Ryslinge",
        "Rødby",
        "Rødding",
        "Rødekro",
        "Rødkærsbro",
        "Rødovre",
        "Rødvig Stevns",
        "Rømø",
        "Rønde",
        "Rønne",
        "Rønnede",
        "Rørvig",
        "Sabro",
        "Sakskøbing",
        "Saltum",
        "Samsø",
        "Sandved",
        "Sejerø",
        "Silkeborg",
        "Sindal",
        "Sjællands Odde",
        "Sjølund",
        "Skagen",
        "Skals",
        "Skamby",
        "Skanderborg",
        "Skibby",
        "Skive",
        "Skjern",
        "Skodsborg",
        "Skovlunde",
        "Skælskør",
        "Skærbæk",
        "Skævinge",
        "Skødstrup",
        "Skørping",
        "Skårup",
        "Slagelse",
        "Slangerup",
        "Smørum",
        "Snedsted",
        "Snekkersten",
        "Snertinge",
        "Solbjerg",
        "Solrød Strand",
        "Sommersted",
        "Sorring",
        "Sorø",
        "Spenstrup",
        "Spjald",
        "Sporup",
        "Spøttrup",
        "Stakroge",
        "Stege",
        "Stenderup",
        "Stenlille",
        "Stenløse",
        "Stenstrup",
        "Stensved",
        "Stoholm",
        "Stokkemarke",
        "Store Fuglede",
        "Store Heddinge",
        "Store Merløse",
        "Storvorde",
        "Stouby",
        "Strandby",
        "Struer",
        "Strøby",
        "Stubbekøbing",
        "Støvring",
        "Suldrup",
        "Sulsted",
        "Sunds",
        "Svaneke",
        "Svebølle",
        "Svendborg",
        "Svenstrup",
        "Svinninge",
        "Sydals",
        "Sæby",
        "Søborg",
        "Søby Ærø",
        "Søllested",
        "Sønder Felding",
        "Sønder Omme",
        "Sønder Stenderup",
        "Sønderborg",
        "Søndersø",
        "Sørvad",
        "Tappernøje",
        "Tarm",
        "Terndrup",
        "Them",
        "Thisted",
        "Thorsø",
        "Thyborøn",
        "Thyholm",
        "Tikøb",
        "Tilst",
        "Tim",
        "Tinglev",
        "Tistrup",
        "Tisvildeleje",
        "Tjele",
        "Tjæreborg",
        "Toftlund",
        "Tommerup",
        "Toreby",
        "Torrig",
        "Tranbjerg J",
        "Tranekær",
        "Trige",
        "Trustrup",
        "Tureby",
        "Tylstrup",
        "Tølløse",
        "Tønder",
        "Tørring",
        "Tårs",
        "Taastrup",
        "Ugerløse",
        "Uldum",
        "Ulfborg",
        "Ullerslev",
        "Ulstrup",
        "Vadum",
        "Valby",
        "Vallensbæk",
        "Vallensbæk Strand",
        "Vamdrup",
        "Vandel",
        "Vanløse",
        "Varde",
        "Vedbæk",
        "Veflinge",
        "Vejby",
        "Vejen",
        "Vejers Strand",
        "Vejle",
        "Vejle Øst",
        "Vejstrup",
        "Veksø Sjælland",
        "Vemb",
        "Vemmelev",
        "Vesløs",
        "Vestbjerg",
        "Vester Skerninge",
        "Vesterborg",
        "Vestervig",
        "Viborg",
        "Viby J",
        "Viby Sjælland",
        "Videbæk",
        "Vig",
        "Vildbjerg",
        "Vils",
        "Vinderup",
        "Vipperød",
        "Virum",
        "Vissenbjerg",
        "Viuf",
        "Vodskov",
        "Vojens",
        "Vonge",
        "Vorbasse",
        "Vordingborg",
        "Vrå",
        "Væggerløse",
        "Værløse",
        "Ærøskøbing",
        "Ølgod",
        "Ølsted",
        "Ølstykke",
        "Ørbæk",
        "Ørnhøj",
        "Ørsted",
        "Ørum Djurs",
        "Østbirk",
        "Øster Assels",
        "Øster Ulslev",
        "Øster Vrå",
        "Østermarie",
        "Aabenraa",
        "Aabybro",
        "Åbyhøj",
        "Aakirkeby",
        "Aalborg",
        "Ålbæk",
        "Aalestrup",
        "Ålsgårde",
        "Århus",
        "Årre",
        "Aars",
        "Årslev",
        "Aarup",
    )

    countries = (
        "Afghanistan",
        "Albanien",
        "Algeriet",
        "Andorra",
        "Angola",
        "Antigua og Barbuda",
        "Argentina",
        "Armenien",
        "Aserbajdsjan",
        "Australien",
        "Bahamas",
        "Bahrain",
        "Bangladesh",
        "Barbados",
        "Belgien",
        "Belize",
        "Benin",
        "Bermuda",
        "Bhutan",
        "Bolivia",
        "Bosnien og Hercegovina",
        "Botswana",
        "Brasilien",
        "Brunei",
        "Bulgarien",
        "Burkina Faso",
        "Burma",
        "Burundi",
        "Cambodja",
        "Cameroun",
        "Canada",
        "Centralafrikanske Republik",
        "Chile",
        "Colombia",
        "Comorerne",
        "Republikken Congo",
        "Den Demokratiske Republik Congo",
        "Costa Rica",
        "Cuba",
        "Cypern",
        "Danmark",
        "Djibouti",
        "Dominica",
        "Dominikanske Republik",
        "Ecuador",
        "Egypten",
        "El Salvador",
        "Elfenbenskysten",
        "Eritrea",
        "Estland",
        "Etiopien",
        "Fiji",
        "Filippinerne",
        "Finland",
        "Forenede Arabiske Emirater",
        "Frankrig",
        "Færøerne",
        "Gabon",
        "Gambia",
        "Georgien",
        "Ghana",
        "Grenada",
        "Grækenland",
        "Grønland",
        "Guatemala",
        "Guinea",
        "Guinea-Bissau",
        "Guyana",
        "Fransk Guiana",
        "Haiti",
        "Holland",
        "Honduras",
        "Hviderusland",
        "Indien",
        "Indonesien",
        "Irak",
        "Iran",
        "Irland",
        "Island",
        "Israel",
        "Italien",
        "Jamaica",
        "Japan",
        "Jordan",
        "Kap Verde",
        "Kasakhstan",
        "Kenya",
        "Kina",
        "Kirgisistan",
        "Kiribati",
        "Kroatien",
        "Kuwait",
        "Laos",
        "Lesotho",
        "Letland",
        "Libanon",
        "Liberia",
        "Libyen",
        "Liechtenstein",
        "Litauen",
        "Luxembourg",
        "Madagaskar",
        "Makedonien",
        "Malawi",
        "Malaysia",
        "Maldiverne",
        "Mali",
        "Malta",
        "Marokko",
        "Marshall-øerne",
        "Mauretanien",
        "Mauritius",
        "Mexico",
        "Mikronesien",
        "Moldova",
        "Monaco",
        "Mongoliet",
        "Montenegro",
        "Mozambique",
        "Myanmar",
        "Namibia",
        "Nauru",
        "Nederlandske Antiller",
        "Nepal",
        "New Zealand",
        "Nicaragua",
        "Niger",
        "Nigeria",
        "Niue",
        "Nordkorea",
        "Norge",
        "Oman",
        "Pakistan",
        "Palau",
        "Palæstinensisk Selvstyreområde",
        "Panama",
        "Papua Ny Guinea",
        "Paraguay",
        "Peru",
        "Pitcairn",
        "Polen",
        "Portugal",
        "Puerto Rico",
        "Qatar",
        "Rumænien",
        "Rusland",
        "Rwanda",
        "Saint Kitts and Nevis",
        "Saint Lucia",
        "Saint Vincent og Grenadinerne",
        "Salomonøerne",
        "Samoa",
        "San Marino",
        "São Tomé og Príncipe",
        "Saudi-Arabien",
        "Schweiz",
        "Senegal",
        "Serbien",
        "Seychellerne",
        "Sierra Leone",
        "Singapore",
        "Slovakiet",
        "Slovenien",
        "Somalia",
        "Spanien",
        "Sri Lanka",
        "Storbritannien",
        "Sudan",
        "Surinam",
        "Sverige",
        "Swaziland",
        "Sydafrika",
        "Sydkorea",
        "Syrien",
        "Tadsjikistan",
        "Taiwan",
        "Tanzania",
        "Tchad",
        "Thailand",
        "Tjekkiet",
        "Tjetjenien",
        "Togo",
        "Tonga",
        "Trinidad og Tobago",
        "Tunesien",
        "Turkmenistan",
        "Tuvalu",
        "Tyrkiet",
        "Tyskland",
        "Uganda",
        "Ukraine",
        "Ungarn",
        "Uruguay",
        "USA",
        "Usbekistan",
        "Vanuatu",
        "Vatikanstaten",
        "Venezuela",
        "Vestsahara",
        "Vietnam",
        "Yemen",
        "Zambia",
        "Zimbabwe",
        "Ækvatorialguinea",
        "Østrig",
        "Østtimor",
    )

    # Known as regions in Denmark
    states = (
        "Hovedstaden",
        "Midtjylland",
        "Nordjylland",
        "Sjælland",
        "Syddanmark",
    )

    def dk_street_name(self, min_length: Optional[int] = None, max_length: Optional[int] = None) -> str:
        """
        This returns the name of a street, without any suffix.
        """
        return self.random_element(self.street_names, min_length, max_length)

    def city_name(self, min_length: Optional[int] = None, max_length: Optional[int] = None) -> str:
        return self.random_element(self.cities, min_length, max_length)

    def administrative_unit(self, min_length: Optional[int] = None, max_length: Optional[int] = None) -> str:
        return self.random_element(self.states, min_length, max_length)

    state = administrative_unit
