/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.NTFDCNEvent;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NTFJMSEvent;
import oracle.jdbc.driver.NTFJMSRegistration;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIkpdnrmp;
import oracle.jdbc.driver.T4CTTIkpdnrnf;
import oracle.jdbc.driver.T4CTTIkpdnrpay;
import oracle.jdbc.driver.T4CTTIkpdnrreq;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
final class T4CTTIoaqnfy
extends T4CTTIfun {
    byte[] jmsConnectionId;
    boolean isMarshalOver;
    boolean needToBeClosed;
    OracleConnection conn;
    T4CTTIkpdnrnf notificationHeader;
    T4CTTIkpdnrmp messageProperties;
    T4CTTIkpdnrpay payload;
    NTFManager ntfManager;
    T4CMAREngine mar;
    String databaseUniqueIdentifier;
    boolean isDCNConnection;
    CharacterSet charset;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    T4CTTIoaqnfy(T4CConnection connection, String jmsConnectionId, boolean isDCN) throws SQLException {
        this(connection, jmsConnectionId);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$6, null, connection, jmsConnectionId, isDCN);
            }
            this.isDCNConnection = isDCN;
            this.charset = CharacterSet.make(this.conn.getDbCsId());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$6, null);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$6, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    T4CTTIoaqnfy(T4CConnection connection, String jmsConnectionId) throws SQLException {
        super(connection, (byte)3);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$7, null, connection, jmsConnectionId);
            }
            this.jmsConnectionId = null;
            this.isMarshalOver = false;
            this.needToBeClosed = false;
            this.conn = null;
            this.notificationHeader = null;
            this.messageProperties = null;
            this.payload = null;
            this.ntfManager = null;
            this.isDCNConnection = false;
            this.charset = null;
            if (!($assertionsDisabled || connection != null && jmsConnectionId != null)) {
                AssertionError assertionError = new AssertionError((Object)("connection is " + connection + ", jmsConnectionId is " + jmsConnectionId));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$7, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.setFunCode((short)187);
            this.conn = connection;
            this.mar = connection.mare;
            this.jmsConnectionId = this.mar.conv.StringToCharBytes(jmsConnectionId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$7, null);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$7, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void marshal() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$0, this, new Object[0]);
            }
            T4CTTIkpdnrreq req = new T4CTTIkpdnrreq((T4CConnection)this.conn);
            req.send(this.jmsConnectionId, T4CTTIkpdnrreq.OpCode.INIT_KPDNRREQ);
            this.isMarshalOver = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void readOAC() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$1, this, new Object[0]);
            }
            this.notificationHeader = new T4CTTIkpdnrnf((T4CConnection)this.conn);
            this.messageProperties = new T4CTTIkpdnrmp((T4CConnection)this.conn);
            this.payload = new T4CTTIkpdnrpay((T4CConnection)this.conn);
            while (true) {
                this.notificationHeader.receive();
                if (this.notificationHeader.messageType != 4) {
                    this.messageProperties.receive();
                    this.payload.receive();
                    if (this.isDCNConnection) {
                        this.createAndGenerateDCNEvent();
                        continue;
                    }
                    this.createAndGenerateEvent();
                    continue;
                }
                if (this.isDCNConnection) continue;
                this.throwException(this.notificationHeader.errorCode);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void throwException(int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$2, this, n2);
            }
            try {
                void errCode;
                int jdbcRegId = PhysicalConnection.ntfManager.getJDBCRegId(this.notificationHeader.getRegistrationId());
                NTFJMSRegistration registration = (NTFJMSRegistration)PhysicalConnection.ntfManager.getRegistration(jdbcRegId);
                switch (errCode) {
                    case 24035: {
                        registration.raiseException(2);
                        break;
                    }
                    case 24010: {
                        registration.raiseException(3);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    public void createAndGenerateDCNEvent() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$3, this, new Object[0]);
            }
            long regId = this.notificationHeader.getRegistrationId();
            NTFDCNRegistration registration = PhysicalConnection.ntfManager.getDCNRegistration(regId);
            NTFDCNEvent dcnEvent = new NTFDCNEvent(regId, this.payload.getRawPayload(), registration.getDatabaseVersion(), this.charset.getOracleId());
            registration.notify(dcnEvent);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    public void createAndGenerateEvent() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$4, this, new Object[0]);
            }
            try {
                int jdbcRegId = PhysicalConnection.ntfManager.getJDBCRegId(this.notificationHeader.getRegistrationId());
                NTFJMSRegistration registration = (NTFJMSRegistration)PhysicalConnection.ntfManager.getRegistration(jdbcRegId);
                NTFJMSEvent jmsEvent = new NTFJMSEvent(this);
                jmsEvent.setAqMessageProperites(this.messageProperties.getAqMessageProperties());
                jmsEvent.setJmsMessageProperties(this.messageProperties.getJmsMessageProperties());
                jmsEvent.setMessageId(this.messageProperties.getMessageId());
                jmsEvent.setPayload(this.payload.getRawPayload());
                jmsEvent.setConsumerName(this.notificationHeader.getConsumerName());
                jmsEvent.setQueueName(this.notificationHeader.getNotificationQueue());
                jmsEvent.setRegistration(this.notificationHeader.getNotificationQueue());
                registration.notify(jmsEvent);
            }
            catch (NullPointerException ne) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$4, this);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$4, this, null);
                }
                return;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    public void stopListening() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$5, this, new Object[0]);
            }
            while (!this.isMarshalOver) {
            }
            this.needToBeClosed = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CTTIoaqnfy.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$7 = T4CTTIoaqnfy.class.getDeclaredConstructor(T4CConnection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CTTIoaqnfy.class.getDeclaredConstructor(T4CConnection.class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CTTIoaqnfy.class.getDeclaredMethod("stopListening", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CTTIoaqnfy.class.getDeclaredMethod("createAndGenerateEvent", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIoaqnfy.class.getDeclaredMethod("createAndGenerateDCNEvent", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIoaqnfy.class.getDeclaredMethod("throwException", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIoaqnfy.class.getDeclaredMethod("readOAC", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIoaqnfy.class.getDeclaredMethod("marshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

