/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.client.http;

import java.io.IOException;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpHeaders;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpRequest;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpResponse;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpStatusCodes;
import net.snowflake.client.jdbc.internal.google.api.client.util.Preconditions;
import net.snowflake.client.jdbc.internal.google.api.client.util.StringUtils;

public class HttpResponseException
extends IOException {
    private static final long serialVersionUID = -1875819453475890043L;
    private final int statusCode;
    private final String statusMessage;
    private final transient HttpHeaders headers;
    private final String content;
    private final int attemptCount;

    public HttpResponseException(HttpResponse response) {
        this(new Builder(response));
    }

    protected HttpResponseException(Builder builder) {
        super(builder.message);
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.headers = builder.headers;
        this.content = builder.content;
        this.attemptCount = builder.attemptCount;
    }

    public final boolean isSuccessStatusCode() {
        return HttpStatusCodes.isSuccess(this.statusCode);
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final String getStatusMessage() {
        return this.statusMessage;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public final String getContent() {
        return this.content;
    }

    public final int getAttemptCount() {
        return this.attemptCount;
    }

    public static StringBuilder computeMessageBuffer(HttpResponse response) {
        HttpRequest request;
        String statusMessage;
        StringBuilder builder = new StringBuilder();
        int statusCode = response.getStatusCode();
        if (statusCode != 0) {
            builder.append(statusCode);
        }
        if ((statusMessage = response.getStatusMessage()) != null) {
            if (statusCode != 0) {
                builder.append(' ');
            }
            builder.append(statusMessage);
        }
        if ((request = response.getRequest()) != null) {
            String requestMethod;
            if (builder.length() > 0) {
                builder.append('\n');
            }
            if ((requestMethod = request.getRequestMethod()) != null) {
                builder.append(requestMethod).append(' ');
            }
            builder.append(request.getUrl());
        }
        return builder;
    }

    public static class Builder {
        int statusCode;
        String statusMessage;
        HttpHeaders headers;
        String content;
        String message;
        int attemptCount;

        public Builder(int statusCode, String statusMessage, HttpHeaders headers) {
            this.setStatusCode(statusCode);
            this.setStatusMessage(statusMessage);
            this.setHeaders(headers);
        }

        public Builder(HttpResponse response) {
            this(response.getStatusCode(), response.getStatusMessage(), response.getHeaders());
            try {
                this.content = response.parseAsString();
                if (this.content.length() == 0) {
                    this.content = null;
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
            catch (IllegalArgumentException exception) {
                exception.printStackTrace();
            }
            StringBuilder builder = HttpResponseException.computeMessageBuffer(response);
            if (this.content != null) {
                builder.append(StringUtils.LINE_SEPARATOR).append(this.content);
            }
            this.message = builder.toString();
        }

        public final String getMessage() {
            return this.message;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public final int getStatusCode() {
            return this.statusCode;
        }

        public Builder setStatusCode(int statusCode) {
            Preconditions.checkArgument(statusCode >= 0);
            this.statusCode = statusCode;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public Builder setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public Builder setHeaders(HttpHeaders headers) {
            this.headers = Preconditions.checkNotNull(headers);
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public final int getAttemptCount() {
            return this.attemptCount;
        }

        public Builder setAttemptCount(int attemptCount) {
            Preconditions.checkArgument(attemptCount >= 0);
            this.attemptCount = attemptCount;
            return this;
        }

        public HttpResponseException build() {
            return new HttpResponseException(this);
        }
    }
}

