/* set-wallpaper.c generated by valac 0.56.3, the Vala compiler
 * generated from set-wallpaper.vala, do not modify */

/*
* Copyright 2017-2022 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <unistd.h>

#define SET_WALLPAPER_CONTRACTOR_DEFAULT_TRANSITION_DURATION 1
#define SET_WALLPAPER_CONTRACTOR_SLIDESHOW_FILENAME "slideshow.xml"
#define SET_WALLPAPER_CONTRACTOR_SLIDESHOW_TEMPLATE "\n    <background>\n        %s\n    </background>"
#define SET_WALLPAPER_CONTRACTOR_SLIDESHOW_WALLPAPER_TEMPLATE "\n" \
"        <static>\n" \
"            <duration>%i</duration>\n" \
"            <file>%s</file>\n" \
"        </static>\n" \
"        <transition>\n" \
"            <duration>%i</duration>\n" \
"            <from>%s</from>\n" \
"            <to>%s</to>\n" \
"        </transition>\n" \
"    "
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SET_WALLPAPER_CONTRACTOR_TYPE_ACCOUNTS_SERVICE_USER (set_wallpaper_contractor_accounts_service_user_get_type ())
#define SET_WALLPAPER_CONTRACTOR_ACCOUNTS_SERVICE_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SET_WALLPAPER_CONTRACTOR_TYPE_ACCOUNTS_SERVICE_USER, SetWallpaperContractorAccountsServiceUser))
#define SET_WALLPAPER_CONTRACTOR_IS_ACCOUNTS_SERVICE_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SET_WALLPAPER_CONTRACTOR_TYPE_ACCOUNTS_SERVICE_USER))
#define SET_WALLPAPER_CONTRACTOR_ACCOUNTS_SERVICE_USER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SET_WALLPAPER_CONTRACTOR_TYPE_ACCOUNTS_SERVICE_USER, SetWallpaperContractorAccountsServiceUserIface))

typedef struct _SetWallpaperContractorAccountsServiceUser SetWallpaperContractorAccountsServiceUser;
typedef struct _SetWallpaperContractorAccountsServiceUserIface SetWallpaperContractorAccountsServiceUserIface;

#define SET_WALLPAPER_CONTRACTOR_TYPE_ACCOUNTS_SERVICE_USER_PROXY (set_wallpaper_contractor_accounts_service_user_proxy_get_type ())
typedef GDBusProxy SetWallpaperContractorAccountsServiceUserProxy;
typedef GDBusProxyClass SetWallpaperContractorAccountsServiceUserProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _SetWallpaperContractorAccountsServiceUserIface {
	GTypeInterface parent_iface;
	gchar* (*get_background_file) (SetWallpaperContractorAccountsServiceUser* self);
	void (*set_background_file) (SetWallpaperContractorAccountsServiceUser* self, const gchar* value);
};

struct _Block1Data {
	int _ref_count_;
	GtkScale* duration;
	GraniteMessageDialog* dialog;
};

VALA_EXTERN gint set_wallpaper_contractor_delay_value;
gint set_wallpaper_contractor_delay_value = 60;

VALA_EXTERN GType set_wallpaper_contractor_accounts_service_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SetWallpaperContractorAccountsServiceUser, g_object_unref)
VALA_EXTERN GType set_wallpaper_contractor_accounts_service_user_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint set_wallpaper_contractor_accounts_service_user_register_object (void* object,
                                                                      GDBusConnection* connection,
                                                                      const gchar* path,
                                                                      GError** error);
VALA_EXTERN gchar* set_wallpaper_contractor_accounts_service_user_get_background_file (SetWallpaperContractorAccountsServiceUser* self);
VALA_EXTERN void set_wallpaper_contractor_accounts_service_user_set_background_file (SetWallpaperContractorAccountsServiceUser* self,
                                                                         const gchar* value);
static GType set_wallpaper_contractor_accounts_service_user_get_type_once (void);
static void set_wallpaper_contractor_accounts_service_user_proxy_g_signal (GDBusProxy* proxy,
                                                                    const gchar* sender_name,
                                                                    const gchar* signal_name,
                                                                    GVariant* parameters);
static gchar* set_wallpaper_contractor_accounts_service_user_dbus_proxy_get_background_file (SetWallpaperContractorAccountsServiceUser* self);
static void set_wallpaper_contractor_accounts_service_user_dbus_proxy_set_background_file (SetWallpaperContractorAccountsServiceUser* self,
                                                                                    const gchar* value);
static void set_wallpaper_contractor_accounts_service_user_proxy_set_wallpaper_contractor_accounts_service_user_interface_init (SetWallpaperContractorAccountsServiceUserIface* iface);
static void set_wallpaper_contractor_accounts_service_user_dbus_interface_method_call (GDBusConnection* connection,
                                                                                const gchar* sender,
                                                                                const gchar* object_path,
                                                                                const gchar* interface_name,
                                                                                const gchar* method_name,
                                                                                GVariant* parameters,
                                                                                GDBusMethodInvocation* invocation,
                                                                                gpointer user_data);
static GVariant* set_wallpaper_contractor_accounts_service_user_dbus_interface_get_property (GDBusConnection* connection,
                                                                                      const gchar* sender,
                                                                                      const gchar* object_path,
                                                                                      const gchar* interface_name,
                                                                                      const gchar* property_name,
                                                                                      GError** error,
                                                                                      gpointer user_data);
static GVariant* _dbus_set_wallpaper_contractor_accounts_service_user_get_background_file (SetWallpaperContractorAccountsServiceUser* self);
static gboolean set_wallpaper_contractor_accounts_service_user_dbus_interface_set_property (GDBusConnection* connection,
                                                                                     const gchar* sender,
                                                                                     const gchar* object_path,
                                                                                     const gchar* interface_name,
                                                                                     const gchar* property_name,
                                                                                     GVariant* value,
                                                                                     GError** error,
                                                                                     gpointer user_data);
static void _dbus_set_wallpaper_contractor_accounts_service_user_set_background_file (SetWallpaperContractorAccountsServiceUser* self,
                                                                               GVariant* _value);
static void _set_wallpaper_contractor_accounts_service_user_unregister_object (gpointer user_data);
VALA_EXTERN void set_wallpaper_contractor_update_slideshow (const gchar* path,
                                                GList* files,
                                                gint duration);
VALA_EXTERN void set_wallpaper_contractor_set_settings_key (const gchar* uri);
VALA_EXTERN void set_wallpaper_contractor_delay_value_changed (GtkScale* duration_scale,
                                                   GtkLabel* duration_label);
VALA_EXTERN gchar* set_wallpaper_contractor_get_local_bg_directory (void);
VALA_EXTERN GFile* set_wallpaper_contractor_ensure_local_bg_exists (void);
VALA_EXTERN GFile* set_wallpaper_contractor_copy_for_library (GFile* source);
VALA_EXTERN GFile* set_wallpaper_contractor_copy_for_greeter (GFile* source);
static gint set_wallpaper_contractor_main (gchar** args,
                                    gint args_length1);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void __lambda4_ (Block1Data* _data1_);
static void ___lambda4__gtk_range_value_changed (GtkRange* _sender,
                                          gpointer self);

static const GDBusMethodInfo * const _set_wallpaper_contractor_accounts_service_user_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _set_wallpaper_contractor_accounts_service_user_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _set_wallpaper_contractor_accounts_service_user_dbus_property_info_background_file = {-1, "BackgroundFile", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _set_wallpaper_contractor_accounts_service_user_dbus_property_info[] = {&_set_wallpaper_contractor_accounts_service_user_dbus_property_info_background_file, NULL};
static const GDBusInterfaceInfo _set_wallpaper_contractor_accounts_service_user_dbus_interface_info = {-1, "org.freedesktop.DisplayManager.AccountsService", (GDBusMethodInfo **) (&_set_wallpaper_contractor_accounts_service_user_dbus_method_info), (GDBusSignalInfo **) (&_set_wallpaper_contractor_accounts_service_user_dbus_signal_info), (GDBusPropertyInfo **) (&_set_wallpaper_contractor_accounts_service_user_dbus_property_info), NULL};
static const GDBusInterfaceVTable _set_wallpaper_contractor_accounts_service_user_dbus_interface_vtable = {set_wallpaper_contractor_accounts_service_user_dbus_interface_method_call, set_wallpaper_contractor_accounts_service_user_dbus_interface_get_property, set_wallpaper_contractor_accounts_service_user_dbus_interface_set_property};

gchar*
set_wallpaper_contractor_accounts_service_user_get_background_file (SetWallpaperContractorAccountsServiceUser* self)
{
	SetWallpaperContractorAccountsServiceUserIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SET_WALLPAPER_CONTRACTOR_ACCOUNTS_SERVICE_USER_GET_INTERFACE (self);
	if (_iface_->get_background_file) {
		return _iface_->get_background_file (self);
	}
	return NULL;
}

void
set_wallpaper_contractor_accounts_service_user_set_background_file (SetWallpaperContractorAccountsServiceUser* self,
                                                                    const gchar* value)
{
	SetWallpaperContractorAccountsServiceUserIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SET_WALLPAPER_CONTRACTOR_ACCOUNTS_SERVICE_USER_GET_INTERFACE (self);
	if (_iface_->set_background_file) {
		_iface_->set_background_file (self, value);
	}
}

static void
set_wallpaper_contractor_accounts_service_user_default_init (SetWallpaperContractorAccountsServiceUserIface * iface,
                                                             gpointer iface_data)
{
}

static GType
set_wallpaper_contractor_accounts_service_user_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SetWallpaperContractorAccountsServiceUserIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) set_wallpaper_contractor_accounts_service_user_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType set_wallpaper_contractor_accounts_service_user_type_id;
	set_wallpaper_contractor_accounts_service_user_type_id = g_type_register_static (G_TYPE_INTERFACE, "SetWallpaperContractorAccountsServiceUser", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (set_wallpaper_contractor_accounts_service_user_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (set_wallpaper_contractor_accounts_service_user_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) set_wallpaper_contractor_accounts_service_user_proxy_get_type);
	g_type_set_qdata (set_wallpaper_contractor_accounts_service_user_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DisplayManager.AccountsService");
	g_type_set_qdata (set_wallpaper_contractor_accounts_service_user_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_set_wallpaper_contractor_accounts_service_user_dbus_interface_info));
	g_type_set_qdata (set_wallpaper_contractor_accounts_service_user_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) set_wallpaper_contractor_accounts_service_user_register_object);
	return set_wallpaper_contractor_accounts_service_user_type_id;
}

GType
set_wallpaper_contractor_accounts_service_user_get_type (void)
{
	static volatile gsize set_wallpaper_contractor_accounts_service_user_type_id__once = 0;
	if (g_once_init_enter (&set_wallpaper_contractor_accounts_service_user_type_id__once)) {
		GType set_wallpaper_contractor_accounts_service_user_type_id;
		set_wallpaper_contractor_accounts_service_user_type_id = set_wallpaper_contractor_accounts_service_user_get_type_once ();
		g_once_init_leave (&set_wallpaper_contractor_accounts_service_user_type_id__once, set_wallpaper_contractor_accounts_service_user_type_id);
	}
	return set_wallpaper_contractor_accounts_service_user_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (SetWallpaperContractorAccountsServiceUserProxy, set_wallpaper_contractor_accounts_service_user_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (SET_WALLPAPER_CONTRACTOR_TYPE_ACCOUNTS_SERVICE_USER, set_wallpaper_contractor_accounts_service_user_proxy_set_wallpaper_contractor_accounts_service_user_interface_init) )
static void
set_wallpaper_contractor_accounts_service_user_proxy_class_init (SetWallpaperContractorAccountsServiceUserProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = set_wallpaper_contractor_accounts_service_user_proxy_g_signal;
}

static void
set_wallpaper_contractor_accounts_service_user_proxy_g_signal (GDBusProxy* proxy,
                                                               const gchar* sender_name,
                                                               const gchar* signal_name,
                                                               GVariant* parameters)
{
}

static void
set_wallpaper_contractor_accounts_service_user_proxy_init (SetWallpaperContractorAccountsServiceUserProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_set_wallpaper_contractor_accounts_service_user_dbus_interface_info));
}

static gchar*
set_wallpaper_contractor_accounts_service_user_dbus_proxy_get_background_file (SetWallpaperContractorAccountsServiceUser* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "BackgroundFile");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.DisplayManager.AccountsService"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("BackgroundFile"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
set_wallpaper_contractor_accounts_service_user_dbus_proxy_set_background_file (SetWallpaperContractorAccountsServiceUser* self,
                                                                               const gchar* value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.DisplayManager.AccountsService"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("BackgroundFile"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
set_wallpaper_contractor_accounts_service_user_proxy_set_wallpaper_contractor_accounts_service_user_interface_init (SetWallpaperContractorAccountsServiceUserIface* iface)
{
	iface->get_background_file = set_wallpaper_contractor_accounts_service_user_dbus_proxy_get_background_file;
	iface->set_background_file = set_wallpaper_contractor_accounts_service_user_dbus_proxy_set_background_file;
}

static void
set_wallpaper_contractor_accounts_service_user_dbus_interface_method_call (GDBusConnection* connection,
                                                                           const gchar* sender,
                                                                           const gchar* object_path,
                                                                           const gchar* interface_name,
                                                                           const gchar* method_name,
                                                                           GVariant* parameters,
                                                                           GDBusMethodInvocation* invocation,
                                                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_set_wallpaper_contractor_accounts_service_user_get_background_file (SetWallpaperContractorAccountsServiceUser* self)
{
	gchar* result;
	GVariant* _reply;
	result = set_wallpaper_contractor_accounts_service_user_get_background_file (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
set_wallpaper_contractor_accounts_service_user_dbus_interface_get_property (GDBusConnection* connection,
                                                                            const gchar* sender,
                                                                            const gchar* object_path,
                                                                            const gchar* interface_name,
                                                                            const gchar* property_name,
                                                                            GError** error,
                                                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "BackgroundFile") == 0) {
		return _dbus_set_wallpaper_contractor_accounts_service_user_get_background_file (object);
	}
	return NULL;
}

static void
_dbus_set_wallpaper_contractor_accounts_service_user_set_background_file (SetWallpaperContractorAccountsServiceUser* self,
                                                                          GVariant* _value)
{
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	set_wallpaper_contractor_accounts_service_user_set_background_file (self, value);
	_g_free0 (value);
}

static gboolean
set_wallpaper_contractor_accounts_service_user_dbus_interface_set_property (GDBusConnection* connection,
                                                                            const gchar* sender,
                                                                            const gchar* object_path,
                                                                            const gchar* interface_name,
                                                                            const gchar* property_name,
                                                                            GVariant* value,
                                                                            GError** error,
                                                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "BackgroundFile") == 0) {
		_dbus_set_wallpaper_contractor_accounts_service_user_set_background_file (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
set_wallpaper_contractor_accounts_service_user_register_object (gpointer object,
                                                                GDBusConnection* connection,
                                                                const gchar* path,
                                                                GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_set_wallpaper_contractor_accounts_service_user_dbus_interface_info), &_set_wallpaper_contractor_accounts_service_user_dbus_interface_vtable, data, _set_wallpaper_contractor_accounts_service_user_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_set_wallpaper_contractor_accounts_service_user_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
set_wallpaper_contractor_update_slideshow (const gchar* path,
                                           GList* files,
                                           gint duration)
{
	gchar* wallpapers = NULL;
	gchar* _tmp0_;
	guint len = 0U;
	gchar* slideshow = NULL;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (path != NULL);
	_tmp0_ = g_strdup ("");
	wallpapers = _tmp0_;
	len = g_list_length (files);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gchar* slide = NULL;
				gconstpointer _tmp3_;
				gchar* _tmp4_;
				gint _tmp5_ = 0;
				gchar* next_slide = NULL;
				gconstpointer _tmp6_;
				gchar* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(((guint) i) < len)) {
					break;
				}
				_tmp3_ = g_list_nth_data (files, (guint) i);
				_tmp4_ = g_file_get_path ((GFile*) _tmp3_);
				slide = _tmp4_;
				if (((guint) (i - 1)) == len) {
					_tmp5_ = 0;
				} else {
					_tmp5_ = i;
				}
				_tmp6_ = g_list_nth_data (files, (guint) _tmp5_);
				_tmp7_ = g_file_get_path ((GFile*) _tmp6_);
				next_slide = _tmp7_;
				_tmp8_ = wallpapers;
				_tmp9_ = slide;
				_tmp10_ = slide;
				_tmp11_ = next_slide;
				_tmp12_ = g_strdup_printf (SET_WALLPAPER_CONTRACTOR_SLIDESHOW_WALLPAPER_TEMPLATE, duration, _tmp9_, SET_WALLPAPER_CONTRACTOR_DEFAULT_TRANSITION_DURATION, _tmp10_, _tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strconcat (_tmp8_, _tmp13_, NULL);
				_g_free0 (wallpapers);
				wallpapers = _tmp14_;
				_g_free0 (_tmp13_);
				_g_free0 (next_slide);
				_g_free0 (slide);
			}
		}
	}
	_tmp15_ = wallpapers;
	_tmp16_ = g_strdup_printf (SET_WALLPAPER_CONTRACTOR_SLIDESHOW_TEMPLATE, _tmp15_);
	slideshow = _tmp16_;
	{
		g_file_set_contents (path, slideshow, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e->message;
		g_error ("set-wallpaper.vala:65: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (slideshow);
		_g_free0 (wallpapers);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp18_ = g_strconcat ("file://", path, NULL);
	_tmp19_ = _tmp18_;
	set_wallpaper_contractor_set_settings_key (_tmp19_);
	_g_free0 (_tmp19_);
	_g_free0 (slideshow);
	_g_free0 (wallpapers);
}

void
set_wallpaper_contractor_set_settings_key (const gchar* uri)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	GSettings* _tmp8_;
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_settings_new ("org.gnome.desktop.background");
	settings = _tmp0_;
	_tmp1_ = settings;
	g_settings_set_string (_tmp1_, "picture-uri", uri);
	_tmp2_ = settings;
	g_settings_reset (_tmp2_, "color-shading-type");
	_tmp3_ = settings;
	_tmp4_ = g_settings_get_string (_tmp3_, "picture-options");
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strcmp0 (_tmp5_, "none") == 0;
	_g_free0 (_tmp5_);
	if (_tmp6_) {
		GSettings* _tmp7_;
		_tmp7_ = settings;
		g_settings_reset (_tmp7_, "picture-options");
	}
	_tmp8_ = settings;
	g_settings_apply (_tmp8_);
	g_settings_sync ();
	_g_object_unref0 (settings);
}

void
set_wallpaper_contractor_delay_value_changed (GtkScale* duration_scale,
                                              GtkLabel* duration_label)
{
	gdouble value = 0.0;
	GtkAdjustment* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gchar* text = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (duration_scale != NULL);
	g_return_if_fail (duration_label != NULL);
	_tmp0_ = gtk_range_get_adjustment ((GtkRange*) duration_scale);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	value = _tmp3_;
	set_wallpaper_contractor_delay_value = (gint) (((((pow (value, (gdouble) 5) / pow ((gdouble) 90, (gdouble) 5)) * 60) * 60) * 24) + 5);
	if (set_wallpaper_contractor_delay_value < 60) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup_printf (ngettext ("%d second", "%d seconds", (gulong) set_wallpaper_contractor_delay_value), set_wallpaper_contractor_delay_value);
		_g_free0 (text);
		text = _tmp4_;
	} else {
		if (set_wallpaper_contractor_delay_value < (60 * 60)) {
			gint minutes = 0;
			gchar* _tmp5_;
			minutes = set_wallpaper_contractor_delay_value / 60;
			_tmp5_ = g_strdup_printf (ngettext ("%d minute", "%d minutes", (gulong) minutes), minutes);
			_g_free0 (text);
			text = _tmp5_;
			set_wallpaper_contractor_delay_value = minutes * 60;
		} else {
			if (set_wallpaper_contractor_delay_value < ((60 * 60) * 24)) {
				gint hours = 0;
				gchar* _tmp6_;
				hours = set_wallpaper_contractor_delay_value / (60 * 60);
				_tmp6_ = g_strdup_printf (ngettext ("%d hour", "%d hours", (gulong) hours), hours);
				_g_free0 (text);
				text = _tmp6_;
				set_wallpaper_contractor_delay_value = hours * (60 * 60);
			} else {
				gchar* _tmp7_;
				_tmp7_ = g_strdup (_ ("1 day"));
				_g_free0 (text);
				text = _tmp7_;
				set_wallpaper_contractor_delay_value = (60 * 60) * 24;
			}
		}
	}
	_tmp8_ = g_strconcat (_ ("Show each photo for"), " <b>", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = text;
	_tmp11_ = g_strconcat (_tmp9_, _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp12_, "</b>", NULL);
	_tmp14_ = _tmp13_;
	gtk_label_set_markup (duration_label, _tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp9_);
	_g_free0 (text);
}

gchar*
set_wallpaper_contractor_get_local_bg_directory (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "backgrounds", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

GFile*
set_wallpaper_contractor_ensure_local_bg_exists (void)
{
	GFile* folder = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	_tmp0_ = set_wallpaper_contractor_get_local_bg_directory ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	folder = _tmp3_;
	_tmp4_ = folder;
	if (!g_file_query_exists (_tmp4_, NULL)) {
		{
			GFile* _tmp5_;
			_tmp5_ = folder;
			g_file_make_directory_with_parents (_tmp5_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			g_warning ("set-wallpaper.vala:121: %s\n", _tmp7_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (folder);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = folder;
	return result;
}

GFile*
set_wallpaper_contractor_copy_for_library (GFile* source)
{
	GFile* dest = NULL;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (source != NULL, NULL);
	dest = NULL;
	{
		gchar* timestamp = NULL;
		GDateTime* _tmp0_;
		GDateTime* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* filename = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* path = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		_tmp0_ = g_date_time_new_now_local ();
		_tmp1_ = _tmp0_;
		_tmp2_ = g_date_time_format (_tmp1_, "%Y-%m-%d-%H-%M-%S");
		_tmp3_ = _tmp2_;
		_g_date_time_unref0 (_tmp1_);
		timestamp = _tmp3_;
		_tmp4_ = g_file_get_basename (source);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%s-%s", timestamp, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		filename = _tmp7_;
		_tmp8_ = set_wallpaper_contractor_get_local_bg_directory ();
		_tmp9_ = _tmp8_;
		_tmp10_ = g_build_filename (_tmp9_, filename, NULL);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		path = _tmp11_;
		_tmp12_ = g_file_new_for_path (path);
		_g_object_unref0 (dest);
		dest = _tmp12_;
		_tmp13_ = dest;
		g_file_copy (source, _tmp13_, G_FILE_COPY_OVERWRITE | G_FILE_COPY_ALL_METADATA, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (path);
			_g_free0 (filename);
			_g_free0 (timestamp);
			goto __catch0_g_error;
		}
		_g_free0 (path);
		_g_free0 (filename);
		_g_free0 (timestamp);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("set-wallpaper.vala:138: %s\n", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (dest);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = dest;
	return result;
}

GFile*
set_wallpaper_contractor_copy_for_greeter (GFile* source)
{
	GFile* dest = NULL;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (source != NULL, NULL);
	dest = NULL;
	{
		gchar* greeter_data_dir = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		GFile* folder = NULL;
		const gchar* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		GFile* _tmp25_;
		GFile* _tmp26_;
		GFile* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp0_ = g_getenv ("XDG_GREETER_DATA_DIR");
		_tmp1_ = g_build_filename (_tmp0_, "wallpaper", NULL);
		greeter_data_dir = _tmp1_;
		_tmp2_ = greeter_data_dir;
		if (g_strcmp0 (_tmp2_, "") == 0) {
			const gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = g_get_user_name ();
			_tmp4_ = g_build_filename ("/var/lib/lightdm-data/", _tmp3_, "wallpaper", NULL);
			_g_free0 (greeter_data_dir);
			greeter_data_dir = _tmp4_;
		}
		_tmp5_ = greeter_data_dir;
		_tmp6_ = g_file_new_for_path (_tmp5_);
		folder = _tmp6_;
		_tmp7_ = folder;
		if (g_file_query_exists (_tmp7_, NULL)) {
			GFileEnumerator* enumerator = NULL;
			GFile* _tmp8_;
			GFileEnumerator* _tmp9_;
			GFileInfo* info = NULL;
			_tmp8_ = folder;
			_tmp9_ = g_file_enumerate_children (_tmp8_, "standard::*", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
			enumerator = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (folder);
				_g_free0 (greeter_data_dir);
				goto __catch0_g_error;
			}
			info = NULL;
			while (TRUE) {
				GFileInfo* _tmp10_ = NULL;
				GFileEnumerator* _tmp11_;
				GFileInfo* _tmp12_;
				GFileInfo* _tmp13_;
				GFileInfo* _tmp14_;
				GFileEnumerator* _tmp15_;
				GFileInfo* _tmp16_;
				GFile* _tmp17_;
				GFile* _tmp18_;
				_tmp11_ = enumerator;
				_tmp12_ = g_file_enumerator_next_file (_tmp11_, NULL, &_inner_error0_);
				_tmp10_ = _tmp12_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (info);
					_g_object_unref0 (enumerator);
					_g_object_unref0 (folder);
					_g_free0 (greeter_data_dir);
					goto __catch0_g_error;
				}
				_tmp13_ = _tmp10_;
				_tmp10_ = NULL;
				_g_object_unref0 (info);
				info = _tmp13_;
				_tmp14_ = info;
				if (!(_tmp14_ != NULL)) {
					_g_object_unref0 (_tmp10_);
					break;
				}
				_tmp15_ = enumerator;
				_tmp16_ = info;
				_tmp17_ = g_file_enumerator_get_child (_tmp15_, _tmp16_);
				_tmp18_ = _tmp17_;
				g_file_delete (_tmp18_, NULL, &_inner_error0_);
				_g_object_unref0 (_tmp18_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (_tmp10_);
					_g_object_unref0 (info);
					_g_object_unref0 (enumerator);
					_g_object_unref0 (folder);
					_g_free0 (greeter_data_dir);
					goto __catch0_g_error;
				}
				_g_object_unref0 (_tmp10_);
			}
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
		} else {
			GFile* _tmp19_;
			_tmp19_ = folder;
			g_file_make_directory_with_parents (_tmp19_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (folder);
				_g_free0 (greeter_data_dir);
				goto __catch0_g_error;
			}
		}
		_tmp20_ = greeter_data_dir;
		_tmp21_ = g_file_get_basename (source);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_build_filename (_tmp20_, _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_file_new_for_path (_tmp24_);
		_g_object_unref0 (dest);
		dest = _tmp25_;
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_tmp26_ = dest;
		g_file_copy (source, _tmp26_, G_FILE_COPY_OVERWRITE | G_FILE_COPY_ALL_METADATA, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (folder);
			_g_free0 (greeter_data_dir);
			goto __catch0_g_error;
		}
		_tmp27_ = dest;
		_tmp28_ = g_file_get_path (_tmp27_);
		_tmp29_ = _tmp28_;
		g_chmod (_tmp29_, 0604);
		_g_free0 (_tmp29_);
		_g_object_unref0 (folder);
		_g_free0 (greeter_data_dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		g_warning ("set-wallpaper.vala:168: %s\n", _tmp31_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (dest);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (dest);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = dest;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->dialog);
		_g_object_unref0 (_data1_->duration);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
__lambda4_ (Block1Data* _data1_)
{
	GtkScale* _tmp0_;
	GraniteMessageDialog* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	_tmp0_ = _data1_->duration;
	_tmp1_ = _data1_->dialog;
	_tmp2_ = granite_message_dialog_get_secondary_label (_tmp1_);
	_tmp3_ = _tmp2_;
	set_wallpaper_contractor_delay_value_changed (_tmp0_, _tmp3_);
}

static void
___lambda4__gtk_range_value_changed (GtkRange* _sender,
                                     gpointer self)
{
	__lambda4_ (self);
}

static gint
set_wallpaper_contractor_main (gchar** args,
                               gint args_length1)
{
	Block1Data* _data1_;
	SetWallpaperContractorAccountsServiceUser* accounts_service = NULL;
	GFile* folder = NULL;
	GFile* _tmp10_;
	GList* files = NULL;
	GList* _tmp38_;
	GList* _tmp39_;
	GtkScale* _tmp44_ = NULL;
	GtkScale* _tmp45_;
	GThemedIcon* _tmp46_;
	GraniteMessageDialog* _tmp47_ = NULL;
	GraniteMessageDialog* _tmp48_;
	GraniteMessageDialog* _tmp49_;
	GraniteMessageDialog* _tmp50_;
	GtkBin* _tmp51_;
	GtkBin* _tmp52_;
	GtkScale* _tmp53_;
	GraniteMessageDialog* _tmp54_;
	GtkScale* _tmp55_;
	GraniteMessageDialog* _tmp56_;
	GtkLabel* _tmp57_;
	GtkLabel* _tmp58_;
	GtkScale* _tmp59_;
	GraniteMessageDialog* _tmp60_;
	GError* _inner_error0_ = NULL;
	gint result;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	gtk_init ((gint*) (&args_length1), &args);
	accounts_service = NULL;
	{
		gchar* uid = NULL;
		gchar* _tmp0_;
		SetWallpaperContractorAccountsServiceUser* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		SetWallpaperContractorAccountsServiceUser* _tmp4_;
		SetWallpaperContractorAccountsServiceUser* _tmp5_;
		SetWallpaperContractorAccountsServiceUser* _tmp6_;
		_tmp0_ = g_strdup_printf ("%d", (gint) getuid ());
		uid = _tmp0_;
		_tmp2_ = g_strconcat ("/org/freedesktop/Accounts/User", uid, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = (SetWallpaperContractorAccountsServiceUser*) g_initable_new (SET_WALLPAPER_CONTRACTOR_TYPE_ACCOUNTS_SERVICE_USER_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp3_, "g-interface-name", "org.freedesktop.DisplayManager.AccountsService", NULL);
		_tmp5_ = (SetWallpaperContractorAccountsServiceUser*) _tmp4_;
		_g_free0 (_tmp3_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (uid);
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (accounts_service);
		accounts_service = _tmp6_;
		_g_object_unref0 (_tmp1_);
		_g_free0 (uid);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("set-wallpaper.vala:185: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp9_ = -1;
		_g_object_unref0 (accounts_service);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	_tmp10_ = set_wallpaper_contractor_ensure_local_bg_exists ();
	folder = _tmp10_;
	files = NULL;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				GFile* file = NULL;
				const gchar* _tmp13_;
				GFile* _tmp14_;
				GFile* _tmp15_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				if (!(i < args_length1)) {
					break;
				}
				_tmp13_ = args[i];
				_tmp14_ = g_file_new_for_path (_tmp13_);
				file = _tmp14_;
				_tmp15_ = file;
				if (_tmp15_ != NULL) {
					gchar* path = NULL;
					GFile* _tmp16_;
					gchar* _tmp17_;
					GFile* append_file = NULL;
					GFile* _tmp18_;
					GFile* _tmp19_;
					const gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gboolean _tmp23_;
					GFile* _tmp29_;
					GFile* _tmp30_;
					GFile* greeter_file = NULL;
					GFile* _tmp31_;
					GFile* _tmp32_;
					GFile* _tmp33_;
					SetWallpaperContractorAccountsServiceUser* _tmp36_;
					const gchar* _tmp37_;
					_tmp16_ = file;
					_tmp17_ = g_file_get_path (_tmp16_);
					path = _tmp17_;
					_tmp18_ = file;
					_tmp19_ = _g_object_ref0 (_tmp18_);
					append_file = _tmp19_;
					_tmp20_ = path;
					_tmp21_ = set_wallpaper_contractor_get_local_bg_directory ();
					_tmp22_ = _tmp21_;
					_tmp23_ = !g_str_has_prefix (_tmp20_, _tmp22_);
					_g_free0 (_tmp22_);
					if (_tmp23_) {
						GFile* local_file = NULL;
						GFile* _tmp24_;
						GFile* _tmp25_;
						GFile* _tmp26_;
						_tmp24_ = file;
						_tmp25_ = set_wallpaper_contractor_copy_for_library (_tmp24_);
						local_file = _tmp25_;
						_tmp26_ = local_file;
						if (_tmp26_ != NULL) {
							GFile* _tmp27_;
							GFile* _tmp28_;
							_tmp27_ = local_file;
							_tmp28_ = _g_object_ref0 (_tmp27_);
							_g_object_unref0 (append_file);
							append_file = _tmp28_;
						}
						_g_object_unref0 (local_file);
					}
					_tmp29_ = append_file;
					_tmp30_ = _g_object_ref0 (_tmp29_);
					files = g_list_append (files, _tmp30_);
					_tmp31_ = file;
					_tmp32_ = set_wallpaper_contractor_copy_for_greeter (_tmp31_);
					greeter_file = _tmp32_;
					_tmp33_ = greeter_file;
					if (_tmp33_ != NULL) {
						GFile* _tmp34_;
						gchar* _tmp35_;
						_tmp34_ = greeter_file;
						_tmp35_ = g_file_get_path (_tmp34_);
						_g_free0 (path);
						path = _tmp35_;
					}
					_tmp36_ = accounts_service;
					_tmp37_ = path;
					set_wallpaper_contractor_accounts_service_user_set_background_file (_tmp36_, _tmp37_);
					_g_object_unref0 (greeter_file);
					_g_object_unref0 (append_file);
					_g_free0 (path);
				}
				_g_object_unref0 (file);
			}
		}
	}
	_tmp38_ = files;
	if (g_list_length (_tmp38_) < ((guint) 1)) {
		g_warning ("set-wallpaper.vala:216: No images specified, aborting.\n");
		result = 1;
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
		_g_object_unref0 (folder);
		_g_object_unref0 (accounts_service);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	_tmp39_ = files;
	if (g_list_length (_tmp39_) == ((guint) 1)) {
		GList* _tmp40_;
		gconstpointer _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		_tmp40_ = files;
		_tmp41_ = _tmp40_->data;
		_tmp42_ = g_file_get_uri ((GFile*) _tmp41_);
		_tmp43_ = _tmp42_;
		set_wallpaper_contractor_set_settings_key (_tmp43_);
		_g_free0 (_tmp43_);
		result = 0;
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
		_g_object_unref0 (folder);
		_g_object_unref0 (accounts_service);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	_tmp44_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) 0, (gdouble) 100, (gdouble) 10);
	gtk_scale_set_draw_value (_tmp44_, FALSE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp44_, TRUE);
	g_object_ref_sink (_tmp44_);
	_data1_->duration = _tmp44_;
	_tmp45_ = _data1_->duration;
	gtk_range_set_value ((GtkRange*) _tmp45_, (gdouble) 50);
	_tmp46_ = (GThemedIcon*) g_themed_icon_new ("media-playback-start");
	_tmp47_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Set As Desktop Slideshow"), "", "preferences-desktop-wallpaper", GTK_BUTTONS_CANCEL);
	granite_message_dialog_set_badge_icon (_tmp47_, (GIcon*) _tmp46_);
	_g_object_unref0 (_tmp46_);
	g_object_ref_sink (_tmp47_);
	_data1_->dialog = _tmp47_;
	_tmp48_ = _data1_->dialog;
	gtk_dialog_add_button ((GtkDialog*) _tmp48_, _ ("Create Slideshow"), (gint) GTK_RESPONSE_OK);
	_tmp49_ = _data1_->dialog;
	gtk_dialog_set_default_response ((GtkDialog*) _tmp49_, (gint) GTK_RESPONSE_OK);
	_tmp50_ = _data1_->dialog;
	_tmp51_ = granite_message_dialog_get_custom_bin (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = _data1_->duration;
	gtk_container_add ((GtkContainer*) _tmp52_, (GtkWidget*) _tmp53_);
	_tmp54_ = _data1_->dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp54_);
	_tmp55_ = _data1_->duration;
	_tmp56_ = _data1_->dialog;
	_tmp57_ = granite_message_dialog_get_secondary_label (_tmp56_);
	_tmp58_ = _tmp57_;
	set_wallpaper_contractor_delay_value_changed (_tmp55_, _tmp58_);
	_tmp59_ = _data1_->duration;
	g_signal_connect_data ((GtkRange*) _tmp59_, "value-changed", (GCallback) ___lambda4__gtk_range_value_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp60_ = _data1_->dialog;
	if (gtk_dialog_run ((GtkDialog*) _tmp60_) == ((gint) GTK_RESPONSE_OK)) {
		GraniteMessageDialog* _tmp61_;
		gchar* path = NULL;
		GFile* _tmp62_;
		GFile* _tmp63_;
		GFile* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		const gchar* _tmp67_;
		GList* _tmp68_;
		_tmp61_ = _data1_->dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp61_);
		_tmp62_ = folder;
		_tmp63_ = g_file_get_child (_tmp62_, SET_WALLPAPER_CONTRACTOR_SLIDESHOW_FILENAME);
		_tmp64_ = _tmp63_;
		_tmp65_ = g_file_get_path (_tmp64_);
		_tmp66_ = _tmp65_;
		_g_object_unref0 (_tmp64_);
		path = _tmp66_;
		_tmp67_ = path;
		_tmp68_ = files;
		set_wallpaper_contractor_update_slideshow (_tmp67_, _tmp68_, set_wallpaper_contractor_delay_value);
		result = 0;
		_g_free0 (path);
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
		_g_object_unref0 (folder);
		_g_object_unref0 (accounts_service);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	result = 1;
	(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
	_g_object_unref0 (folder);
	_g_object_unref0 (accounts_service);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return set_wallpaper_contractor_main (argv, argc);
}

