/* browser-headerbar.c generated by valac 0.56.3, the Vala compiler
 * generated from browser-headerbar.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

#define BASE_HEADER_BAR_default_mode_id ((guint8) 0)
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_BASE_HEADER_BAR (base_header_bar_get_type ())
#define BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBar))
#define BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))
#define IS_BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_HEADER_BAR))
#define IS_BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_HEADER_BAR))
#define BASE_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))

typedef struct _BaseHeaderBar BaseHeaderBar;
typedef struct _BaseHeaderBarClass BaseHeaderBarClass;
typedef struct _BaseHeaderBarPrivate BaseHeaderBarPrivate;

#define TYPE_BROWSER_HEADER_BAR (browser_header_bar_get_type ())
#define BROWSER_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_HEADER_BAR, BrowserHeaderBar))
#define BROWSER_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_HEADER_BAR, BrowserHeaderBarClass))
#define IS_BROWSER_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_HEADER_BAR))
#define IS_BROWSER_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_HEADER_BAR))
#define BROWSER_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_HEADER_BAR, BrowserHeaderBarClass))

typedef struct _BrowserHeaderBar BrowserHeaderBar;
typedef struct _BrowserHeaderBarClass BrowserHeaderBarClass;
typedef struct _BrowserHeaderBarPrivate BrowserHeaderBarPrivate;
typedef enum  {
	VIEW_TYPE_OBJECT,
	VIEW_TYPE_FOLDER,
	VIEW_TYPE_SEARCH,
	VIEW_TYPE_CONFIG
} ViewType;

#define TYPE_VIEW_TYPE (view_type_get_type ())

#define TYPE_PATH_WIDGET (path_widget_get_type ())
#define PATH_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PATH_WIDGET, PathWidget))
#define PATH_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PATH_WIDGET, PathWidgetClass))
#define IS_PATH_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PATH_WIDGET))
#define IS_PATH_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PATH_WIDGET))
#define PATH_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PATH_WIDGET, PathWidgetClass))

typedef struct _PathWidget PathWidget;
typedef struct _PathWidgetClass PathWidgetClass;
enum  {
	BROWSER_HEADER_BAR_0_PROPERTY,
	BROWSER_HEADER_BAR_SEARCH_MODE_ENABLED_PROPERTY,
	BROWSER_HEADER_BAR_IN_WINDOW_PROPERTIES_PROPERTY,
	BROWSER_HEADER_BAR_NUM_PROPERTIES
};
static GParamSpec* browser_header_bar_properties[BROWSER_HEADER_BAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	PATH_ENTRY_SEARCH_MODE_UNCLEAR,
	PATH_ENTRY_SEARCH_MODE_EDIT_PATH_MOVE_END,
	PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_ALL,
	PATH_ENTRY_SEARCH_MODE_EDIT_PATH_SELECT_LAST_WORD,
	PATH_ENTRY_SEARCH_MODE_SEARCH
} PathEntrySearchMode;

#define PATH_ENTRY_TYPE_SEARCH_MODE (path_entry_search_mode_get_type ())
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _BaseHeaderBar {
	GtkHeaderBar parent_instance;
	BaseHeaderBarPrivate * priv;
	GtkBox* center_box;
	gboolean disable_popovers;
	gboolean disable_action_bar;
};

struct _BaseHeaderBarClass {
	GtkHeaderBarClass parent_class;
	void (*set_window_size) (BaseHeaderBar* self, AdaptativeWidgetWindowSize new_size);
	void (*populate_menu) (BaseHeaderBar* self, GMenu** menu);
	void (*toggle_view_menu) (BaseHeaderBar* self);
	void (*set_default_widgets_default_states) (BaseHeaderBar* self, BaseHeaderBar* _this);
	void (*close_popovers) (BaseHeaderBar* self);
	gboolean (*has_popover) (BaseHeaderBar* self);
};

struct _BrowserHeaderBar {
	BaseHeaderBar parent_instance;
	BrowserHeaderBarPrivate * priv;
};

struct _BrowserHeaderBarClass {
	BaseHeaderBarClass parent_class;
	void (*set_path) (BrowserHeaderBar* self, ViewType type, const gchar* path);
};

struct _BrowserHeaderBarPrivate {
	PathWidget* path_widget;
	gboolean current_type_is_config;
	gboolean is_extra_thin;
	guint8 properties_mode_id;
	gboolean properties_mode_on;
};

static gint BrowserHeaderBar_private_offset;
static gpointer browser_header_bar_parent_class = NULL;
static AdaptativeWidgetIface * browser_header_bar_adaptative_widget_parent_iface = NULL;

VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType base_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseHeaderBar, g_object_unref)
VALA_EXTERN GType browser_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserHeaderBar, g_object_unref)
VALA_EXTERN GType view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType path_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PathWidget, g_object_unref)
VALA_EXTERN void browser_header_bar_set_path (BrowserHeaderBar* self,
                                  ViewType type,
                                  const gchar* path);
VALA_EXTERN void base_header_bar_set_window_size (BaseHeaderBar* self,
                                      AdaptativeWidgetWindowSize new_size);
VALA_EXTERN void base_header_bar_close_popovers (BaseHeaderBar* self);
VALA_EXTERN gboolean base_header_bar_has_popover (BaseHeaderBar* self);
static void browser_header_bar_real_set_path (BrowserHeaderBar* self,
                                       ViewType type,
                                       const gchar* path);
VALA_EXTERN void path_widget_set_path (PathWidget* self,
                           ViewType type,
                           const gchar* path);
static void browser_header_bar_update_properties_view (BrowserHeaderBar* self);
VALA_EXTERN void base_header_bar_update_hamburger_menu (BaseHeaderBar* self);
static void browser_header_bar_real_set_window_size (AdaptativeWidget* base,
                                              AdaptativeWidgetWindowSize new_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_extra_thin (AdaptativeWidgetWindowSize window_size);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
static void browser_header_bar_init_path_widget (BrowserHeaderBar* self);
static void browser_header_bar_add_path_widget (BrowserHeaderBar* self);
static void browser_header_bar_mode_changed_browser (BaseHeaderBar* _this,
                                              guint8 mode_id);
static void _browser_header_bar_mode_changed_browser_base_header_bar_change_mode (BaseHeaderBar* _sender,
                                                                           guint8 mode_id,
                                                                           gpointer self);
VALA_EXTERN PathWidget* path_widget_new (void);
VALA_EXTERN PathWidget* path_widget_construct (GType object_type);
VALA_EXTERN gboolean path_widget_get_search_mode_enabled (PathWidget* self);
VALA_EXTERN void path_widget_entry_grab_focus_without_selecting (PathWidget* self);
VALA_EXTERN void browser_header_bar_get_complete_path (BrowserHeaderBar* self,
                                           gchar** complete_path);
VALA_EXTERN void path_widget_get_complete_path (PathWidget* self,
                                    gchar** complete_path);
VALA_EXTERN void browser_header_bar_get_fallback_path_and_complete_path (BrowserHeaderBar* self,
                                                             gchar** fallback_path,
                                                             gchar** complete_path);
VALA_EXTERN void path_widget_get_fallback_path_and_complete_path (PathWidget* self,
                                                      gchar** fallback_path,
                                                      gchar** complete_path);
VALA_EXTERN void browser_header_bar_toggle_pathbar_menu (BrowserHeaderBar* self);
VALA_EXTERN void path_widget_toggle_pathbar_menu (PathWidget* self);
VALA_EXTERN void browser_header_bar_update_ghosts (BrowserHeaderBar* self,
                                       const gchar* fallback_path);
VALA_EXTERN void path_widget_update_ghosts (PathWidget* self,
                                const gchar* fallback_path);
VALA_EXTERN GType path_entry_search_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void browser_header_bar_prepare_search (BrowserHeaderBar* self,
                                        PathEntrySearchMode mode,
                                        const gchar* search);
VALA_EXTERN void path_widget_prepare_search (PathWidget* self,
                                 PathEntrySearchMode mode,
                                 const gchar* search);
VALA_EXTERN gchar* browser_header_bar_get_selected_child (BrowserHeaderBar* self,
                                              const gchar* fallback_path);
VALA_EXTERN gchar* path_widget_get_selected_child (PathWidget* self,
                                       const gchar* fallback_path);
VALA_EXTERN void browser_header_bar_entry_grab_focus (BrowserHeaderBar* self,
                                          gboolean select);
VALA_EXTERN void path_widget_entry_grab_focus (PathWidget* self);
VALA_EXTERN gboolean browser_header_bar_handle_event (BrowserHeaderBar* self,
                                          GdkEventKey* event);
VALA_EXTERN gboolean path_widget_handle_event (PathWidget* self,
                                   GdkEventKey* event);
static void browser_header_bar_show_properties_view (BrowserHeaderBar* self);
static void browser_header_bar_hide_properties_view (BrowserHeaderBar* self);
static void browser_header_bar_register_properties_mode (BrowserHeaderBar* self);
VALA_EXTERN guint8 base_header_bar_register_new_mode (BaseHeaderBar* self);
static void browser_header_bar_mode_changed_properties (BaseHeaderBar* _this,
                                                 guint8 requested_mode_id);
static void _browser_header_bar_mode_changed_properties_base_header_bar_change_mode (BaseHeaderBar* _sender,
                                                                              guint8 mode_id,
                                                                              gpointer self);
VALA_EXTERN gboolean base_header_bar_is_not_requested_mode (guint8 mode_id,
                                                guint8 requested_mode_id,
                                                gboolean* mode_is_active);
VALA_EXTERN void base_header_bar_set_default_widgets_states (BaseHeaderBar* self,
                                                 const gchar* title_label_text_or_null,
                                                 gboolean show_go_back_button,
                                                 gboolean show_ltr_left_separator,
                                                 gboolean show_info_button,
                                                 gboolean show_ltr_right_separator,
                                                 gboolean show_quit_button_stack);
static void browser_header_bar_real_close_popovers (BaseHeaderBar* base);
VALA_EXTERN void path_widget_close_popovers (PathWidget* self);
static gboolean browser_header_bar_real_has_popover (BaseHeaderBar* base);
VALA_EXTERN gboolean path_widget_has_popover (PathWidget* self);
VALA_EXTERN BrowserHeaderBar* browser_header_bar_construct (GType object_type);
VALA_EXTERN BaseHeaderBar* base_header_bar_new (void);
VALA_EXTERN BaseHeaderBar* base_header_bar_construct (GType object_type);
VALA_EXTERN gboolean browser_header_bar_get_search_mode_enabled (BrowserHeaderBar* self);
VALA_EXTERN gboolean browser_header_bar_get_in_window_properties (BrowserHeaderBar* self);
static GObject * browser_header_bar_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void browser_header_bar_finalize (GObject * obj);
static GType browser_header_bar_get_type_once (void);
static void _vala_browser_header_bar_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
browser_header_bar_get_instance_private (BrowserHeaderBar* self)
{
	return G_STRUCT_MEMBER_P (self, BrowserHeaderBar_private_offset);
}

static void
browser_header_bar_real_set_path (BrowserHeaderBar* self,
                                  ViewType type,
                                  const gchar* path)
{
	PathWidget* _tmp0_;
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->path_widget;
	path_widget_set_path (_tmp0_, type, path);
	if (self->priv->current_type_is_config != (type == VIEW_TYPE_CONFIG)) {
		self->priv->current_type_is_config = !self->priv->current_type_is_config;
		browser_header_bar_update_properties_view (self);
	}
	base_header_bar_update_hamburger_menu ((BaseHeaderBar*) self);
}

void
browser_header_bar_set_path (BrowserHeaderBar* self,
                             ViewType type,
                             const gchar* path)
{
	BrowserHeaderBarClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BROWSER_HEADER_BAR_GET_CLASS (self);
	if (_klass_->set_path) {
		_klass_->set_path (self, type, path);
	}
}

static void
browser_header_bar_real_set_window_size (AdaptativeWidget* base,
                                         AdaptativeWidgetWindowSize new_size)
{
	BrowserHeaderBar * self;
	PathWidget* _tmp0_;
	self = (BrowserHeaderBar*) base;
	if (self->priv->is_extra_thin != adaptative_widget_window_size_is_extra_thin (new_size)) {
		self->priv->is_extra_thin = !self->priv->is_extra_thin;
		browser_header_bar_update_properties_view (self);
	}
	BASE_HEADER_BAR_CLASS (browser_header_bar_parent_class)->set_window_size (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BASE_HEADER_BAR, BaseHeaderBar), new_size);
	_tmp0_ = self->priv->path_widget;
	adaptative_widget_set_window_size ((AdaptativeWidget*) _tmp0_, new_size);
}

static void
_browser_header_bar_mode_changed_browser_base_header_bar_change_mode (BaseHeaderBar* _sender,
                                                                      guint8 mode_id,
                                                                      gpointer self)
{
	browser_header_bar_mode_changed_browser (_sender, mode_id);
}

static void
browser_header_bar_init_path_widget (BrowserHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	browser_header_bar_add_path_widget (self);
	g_signal_connect ((BaseHeaderBar*) self, "change-mode", (GCallback) _browser_header_bar_mode_changed_browser_base_header_bar_change_mode, NULL);
}

static void
browser_header_bar_add_path_widget (BrowserHeaderBar* self)
{
	PathWidget* _tmp0_;
	PathWidget* _tmp1_;
	PathWidget* _tmp2_;
	GtkBox* _tmp3_;
	PathWidget* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = path_widget_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->path_widget);
	self->priv->path_widget = _tmp0_;
	_tmp1_ = self->priv->path_widget;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, FALSE);
	_tmp2_ = self->priv->path_widget;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = ((BaseHeaderBar*) self)->center_box;
	_tmp4_ = self->priv->path_widget;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
browser_header_bar_mode_changed_browser (BaseHeaderBar* _this,
                                         guint8 mode_id)
{
	g_return_if_fail (_this != NULL);
	if (mode_id == BASE_HEADER_BAR_default_mode_id) {
		PathWidget* path_widget = NULL;
		PathWidget* _tmp0_;
		PathWidget* _tmp1_;
		PathWidget* _tmp2_;
		PathWidget* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_this, TYPE_BROWSER_HEADER_BAR, BrowserHeaderBar)->priv->path_widget;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		path_widget = _tmp1_;
		_tmp2_ = path_widget;
		gtk_widget_show ((GtkWidget*) _tmp2_);
		_tmp3_ = path_widget;
		_tmp4_ = path_widget_get_search_mode_enabled (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			PathWidget* _tmp6_;
			_tmp6_ = path_widget;
			path_widget_entry_grab_focus_without_selecting (_tmp6_);
		}
		_g_object_unref0 (path_widget);
	} else {
		PathWidget* _tmp7_;
		_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST (_this, TYPE_BROWSER_HEADER_BAR, BrowserHeaderBar)->priv->path_widget;
		gtk_widget_hide ((GtkWidget*) _tmp7_);
	}
}

void
browser_header_bar_get_complete_path (BrowserHeaderBar* self,
                                      gchar** complete_path)
{
	gchar* _vala_complete_path = NULL;
	PathWidget* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->path_widget;
	path_widget_get_complete_path (_tmp0_, &_tmp1_);
	_g_free0 (_vala_complete_path);
	_vala_complete_path = _tmp1_;
	if (complete_path) {
		*complete_path = _vala_complete_path;
	} else {
		_g_free0 (_vala_complete_path);
	}
}

void
browser_header_bar_get_fallback_path_and_complete_path (BrowserHeaderBar* self,
                                                        gchar** fallback_path,
                                                        gchar** complete_path)
{
	gchar* _vala_fallback_path = NULL;
	gchar* _vala_complete_path = NULL;
	PathWidget* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->path_widget;
	path_widget_get_fallback_path_and_complete_path (_tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (_vala_fallback_path);
	_vala_fallback_path = _tmp1_;
	_g_free0 (_vala_complete_path);
	_vala_complete_path = _tmp2_;
	if (fallback_path) {
		*fallback_path = _vala_fallback_path;
	} else {
		_g_free0 (_vala_fallback_path);
	}
	if (complete_path) {
		*complete_path = _vala_complete_path;
	} else {
		_g_free0 (_vala_complete_path);
	}
}

void
browser_header_bar_toggle_pathbar_menu (BrowserHeaderBar* self)
{
	PathWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->path_widget;
	path_widget_toggle_pathbar_menu (_tmp0_);
}

void
browser_header_bar_update_ghosts (BrowserHeaderBar* self,
                                  const gchar* fallback_path)
{
	PathWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fallback_path != NULL);
	_tmp0_ = self->priv->path_widget;
	path_widget_update_ghosts (_tmp0_, fallback_path);
}

void
browser_header_bar_prepare_search (BrowserHeaderBar* self,
                                   PathEntrySearchMode mode,
                                   const gchar* search)
{
	PathWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->path_widget;
	path_widget_prepare_search (_tmp0_, mode, search);
}

gchar*
browser_header_bar_get_selected_child (BrowserHeaderBar* self,
                                       const gchar* fallback_path)
{
	PathWidget* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fallback_path != NULL, NULL);
	_tmp0_ = self->priv->path_widget;
	_tmp1_ = path_widget_get_selected_child (_tmp0_, fallback_path);
	result = _tmp1_;
	return result;
}

void
browser_header_bar_entry_grab_focus (BrowserHeaderBar* self,
                                     gboolean select)
{
	g_return_if_fail (self != NULL);
	if (select) {
		PathWidget* _tmp0_;
		_tmp0_ = self->priv->path_widget;
		path_widget_entry_grab_focus (_tmp0_);
	} else {
		PathWidget* _tmp1_;
		_tmp1_ = self->priv->path_widget;
		path_widget_entry_grab_focus_without_selecting (_tmp1_);
	}
}

gboolean
browser_header_bar_handle_event (BrowserHeaderBar* self,
                                 GdkEventKey* event)
{
	PathWidget* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->path_widget;
	result = path_widget_handle_event (_tmp0_, event);
	return result;
}

static void
browser_header_bar_update_properties_view (BrowserHeaderBar* self)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->is_extra_thin) {
		_tmp0_ = self->priv->current_type_is_config;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		browser_header_bar_show_properties_view (self);
	} else {
		browser_header_bar_hide_properties_view (self);
	}
}

static void
browser_header_bar_show_properties_view (BrowserHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (((gint) self->priv->properties_mode_id) > 0, "properties_mode_id > 0");
	if (!self->priv->properties_mode_on) {
		g_signal_emit_by_name ((BaseHeaderBar*) self, "change-mode", self->priv->properties_mode_id);
	}
}

static void
browser_header_bar_hide_properties_view (BrowserHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->properties_mode_on) {
		g_signal_emit_by_name ((BaseHeaderBar*) self, "change-mode", BASE_HEADER_BAR_default_mode_id);
	}
}

static void
_browser_header_bar_mode_changed_properties_base_header_bar_change_mode (BaseHeaderBar* _sender,
                                                                         guint8 mode_id,
                                                                         gpointer self)
{
	browser_header_bar_mode_changed_properties (_sender, mode_id);
}

static void
browser_header_bar_register_properties_mode (BrowserHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	self->priv->properties_mode_id = base_header_bar_register_new_mode ((BaseHeaderBar*) self);
	g_signal_connect ((BaseHeaderBar*) self, "change-mode", (GCallback) _browser_header_bar_mode_changed_properties_base_header_bar_change_mode, NULL);
}

static void
browser_header_bar_mode_changed_properties (BaseHeaderBar* _this,
                                            guint8 requested_mode_id)
{
	BrowserHeaderBar* real_this = NULL;
	BrowserHeaderBar* _tmp0_;
	BrowserHeaderBar* _tmp1_;
	BrowserHeaderBar* _tmp2_;
	gboolean _tmp3_;
	BrowserHeaderBar* _tmp4_;
	g_return_if_fail (_this != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_this, TYPE_BROWSER_HEADER_BAR, BrowserHeaderBar));
	real_this = _tmp0_;
	_tmp1_ = real_this;
	_tmp2_ = real_this;
	_tmp3_ = base_header_bar_is_not_requested_mode (_tmp1_->priv->properties_mode_id, requested_mode_id, &_tmp2_->priv->properties_mode_on);
	if (_tmp3_) {
		_g_object_unref0 (real_this);
		return;
	}
	_tmp4_ = real_this;
	base_header_bar_set_default_widgets_states ((BaseHeaderBar*) _tmp4_, _ ("Properties"), TRUE, FALSE, FALSE, FALSE, TRUE);
	_g_object_unref0 (real_this);
}

static void
browser_header_bar_real_close_popovers (BaseHeaderBar* base)
{
	BrowserHeaderBar * self;
	PathWidget* _tmp0_;
	self = (BrowserHeaderBar*) base;
	BASE_HEADER_BAR_CLASS (browser_header_bar_parent_class)->close_popovers (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BASE_HEADER_BAR, BaseHeaderBar));
	_tmp0_ = self->priv->path_widget;
	path_widget_close_popovers (_tmp0_);
}

static gboolean
browser_header_bar_real_has_popover (BaseHeaderBar* base)
{
	BrowserHeaderBar * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = (BrowserHeaderBar*) base;
	if (BASE_HEADER_BAR_CLASS (browser_header_bar_parent_class)->has_popover (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BASE_HEADER_BAR, BaseHeaderBar))) {
		_tmp0_ = TRUE;
	} else {
		PathWidget* _tmp1_;
		_tmp1_ = self->priv->path_widget;
		_tmp0_ = path_widget_has_popover (_tmp1_);
	}
	result = _tmp0_;
	return result;
}

BrowserHeaderBar*
browser_header_bar_construct (GType object_type)
{
	BrowserHeaderBar * self = NULL;
	self = (BrowserHeaderBar*) base_header_bar_construct (object_type);
	return self;
}

gboolean
browser_header_bar_get_search_mode_enabled (BrowserHeaderBar* self)
{
	gboolean result;
	PathWidget* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->path_widget;
	_tmp1_ = path_widget_get_search_mode_enabled (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
browser_header_bar_get_in_window_properties (BrowserHeaderBar* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->properties_mode_on;
	return result;
}

static GObject *
browser_header_bar_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BrowserHeaderBar * self;
	parent_class = G_OBJECT_CLASS (browser_header_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BROWSER_HEADER_BAR, BrowserHeaderBar);
	browser_header_bar_init_path_widget (self);
	browser_header_bar_register_properties_mode (self);
	return obj;
}

static void
browser_header_bar_class_init (BrowserHeaderBarClass * klass,
                               gpointer klass_data)
{
	browser_header_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BrowserHeaderBar_private_offset);
	((BrowserHeaderBarClass *) klass)->set_path = (void (*) (BrowserHeaderBar*, ViewType, const gchar*)) browser_header_bar_real_set_path;
	((BaseHeaderBarClass *) klass)->set_window_size = (void (*) (BaseHeaderBar*, AdaptativeWidgetWindowSize)) browser_header_bar_real_set_window_size;
	((BaseHeaderBarClass *) klass)->close_popovers = (void (*) (BaseHeaderBar*)) browser_header_bar_real_close_popovers;
	((BaseHeaderBarClass *) klass)->has_popover = (gboolean (*) (BaseHeaderBar*)) browser_header_bar_real_has_popover;
	G_OBJECT_CLASS (klass)->get_property = _vala_browser_header_bar_get_property;
	G_OBJECT_CLASS (klass)->constructor = browser_header_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = browser_header_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_HEADER_BAR_SEARCH_MODE_ENABLED_PROPERTY, browser_header_bar_properties[BROWSER_HEADER_BAR_SEARCH_MODE_ENABLED_PROPERTY] = g_param_spec_boolean ("search-mode-enabled", "search-mode-enabled", "search-mode-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_HEADER_BAR_IN_WINDOW_PROPERTIES_PROPERTY, browser_header_bar_properties[BROWSER_HEADER_BAR_IN_WINDOW_PROPERTIES_PROPERTY] = g_param_spec_boolean ("in-window-properties", "in-window-properties", "in-window-properties", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
browser_header_bar_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                                     gpointer iface_data)
{
	browser_header_bar_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) browser_header_bar_real_set_window_size;
}

static void
browser_header_bar_instance_init (BrowserHeaderBar * self,
                                  gpointer klass)
{
	self->priv = browser_header_bar_get_instance_private (self);
	self->priv->current_type_is_config = FALSE;
	self->priv->is_extra_thin = FALSE;
	self->priv->properties_mode_id = (guint8) 0;
	self->priv->properties_mode_on = FALSE;
}

static void
browser_header_bar_finalize (GObject * obj)
{
	BrowserHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BROWSER_HEADER_BAR, BrowserHeaderBar);
	_g_object_unref0 (self->priv->path_widget);
	G_OBJECT_CLASS (browser_header_bar_parent_class)->finalize (obj);
}

static GType
browser_header_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BrowserHeaderBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) browser_header_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BrowserHeaderBar), 0, (GInstanceInitFunc) browser_header_bar_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) browser_header_bar_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType browser_header_bar_type_id;
	browser_header_bar_type_id = g_type_register_static (TYPE_BASE_HEADER_BAR, "BrowserHeaderBar", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (browser_header_bar_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	BrowserHeaderBar_private_offset = g_type_add_instance_private (browser_header_bar_type_id, sizeof (BrowserHeaderBarPrivate));
	return browser_header_bar_type_id;
}

GType
browser_header_bar_get_type (void)
{
	static volatile gsize browser_header_bar_type_id__once = 0;
	if (g_once_init_enter (&browser_header_bar_type_id__once)) {
		GType browser_header_bar_type_id;
		browser_header_bar_type_id = browser_header_bar_get_type_once ();
		g_once_init_leave (&browser_header_bar_type_id__once, browser_header_bar_type_id);
	}
	return browser_header_bar_type_id__once;
}

static void
_vala_browser_header_bar_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	BrowserHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BROWSER_HEADER_BAR, BrowserHeaderBar);
	switch (property_id) {
		case BROWSER_HEADER_BAR_SEARCH_MODE_ENABLED_PROPERTY:
		g_value_set_boolean (value, browser_header_bar_get_search_mode_enabled (self));
		break;
		case BROWSER_HEADER_BAR_IN_WINDOW_PROPERTIES_PROPERTY:
		g_value_set_boolean (value, browser_header_bar_get_in_window_properties (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

