/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.example.java_scripts;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.XActionListener;
import com.sun.star.awt.XButton;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XDialogProvider;
import com.sun.star.awt.XTextComponent;
import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.script.XLibraryContainer;
import com.sun.star.script.provider.XScriptContext;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XMacroExpander;
import com.sun.star.util.XPropertyReplace;
import com.sun.star.util.XReplaceDescriptor;
import com.sun.star.util.XReplaceable;
import com.sun.star.util.XSearchDescriptor;
import java.awt.Color;

public class HighlightText
implements XActionListener {
    XDialog findDialog = null;
    XTextComponent findTextBox;
    XTextDocument theDocument;
    private String searchKey = "";

    public void showForm(XScriptContext context) {
        Object obj;
        System.err.println("Starting showForm");
        XMultiComponentFactory xmcf = context.getComponentContext().getServiceManager();
        Object[] args = new Object[]{context.getDocument()};
        try {
            obj = xmcf.createInstanceWithArgumentsAndContext("com.sun.star.awt.DialogProvider", args, context.getComponentContext());
        }
        catch (com.sun.star.uno.Exception e) {
            System.err.println("Error getting DialogProvider object");
            return;
        }
        XDialogProvider xDialogProvider = (XDialogProvider)UnoRuntime.queryInterface(XDialogProvider.class, (Object)obj);
        System.err.println("Got DialogProvider, now get dialog");
        try {
            this.findDialog = xDialogProvider.createDialog("vnd.sun.star.script:ScriptBindingLibrary.Highlight?location=application");
        }
        catch (Exception e) {
            System.err.println("Got exception on first creating dialog: " + e.getMessage());
        }
        if (this.findDialog == null) {
            if (!this.tryLoadingLibrary(xmcf, context, "Dialog") || !this.tryLoadingLibrary(xmcf, context, "Script")) {
                System.err.println("Error loading ScriptBindingLibrary");
                return;
            }
            try {
                this.findDialog = xDialogProvider.createDialog("vnd.sun.star.script://ScriptBindingLibrary.Highlight?location=application");
            }
            catch (IllegalArgumentException iae) {
                System.err.println("Error loading ScriptBindingLibrary");
                return;
            }
        }
        XControlContainer controls = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)this.findDialog);
        XButton highlightButton = (XButton)UnoRuntime.queryInterface(XButton.class, (Object)controls.getControl("HighlightButton"));
        highlightButton.setActionCommand("Highlight");
        this.findTextBox = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)controls.getControl("HighlightTextField"));
        XButton exitButton = (XButton)UnoRuntime.queryInterface(XButton.class, (Object)controls.getControl("ExitButton"));
        exitButton.setActionCommand("Exit");
        this.theDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)context.getDocument());
        highlightButton.addActionListener((XActionListener)this);
        exitButton.addActionListener((XActionListener)this);
        this.findDialog.execute();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.ActionCommand.equals("Exit")) {
            this.findDialog.endExecute();
            return;
        }
        if (e.ActionCommand.equals("Highlight")) {
            this.searchKey = this.findTextBox.getText();
            Color cRed = new Color(255, 0, 0);
            int red = cRed.getRGB();
            XReplaceable replaceable = (XReplaceable)UnoRuntime.queryInterface(XReplaceable.class, (Object)this.theDocument);
            XReplaceDescriptor descriptor = replaceable.createReplaceDescriptor();
            XPropertyReplace xPropertyReplace = (XPropertyReplace)UnoRuntime.queryInterface(XPropertyReplace.class, (Object)descriptor);
            PropertyValue wv = new PropertyValue("CharWeight", -1, (Object)new Float(150.0f), PropertyState.DIRECT_VALUE);
            PropertyValue cv = new PropertyValue("CharColor", -1, (Object)red, PropertyState.DIRECT_VALUE);
            PropertyValue[] props = new PropertyValue[]{cv, wv};
            try {
                xPropertyReplace.setReplaceAttributes(props);
                descriptor.setPropertyValue("SearchCaseSensitive", (Object)Boolean.TRUE);
                descriptor.setPropertyValue("SearchWords", (Object)Boolean.TRUE);
            }
            catch (UnknownPropertyException upe) {
                System.err.println("Error setting up search properties");
                return;
            }
            catch (PropertyVetoException pve) {
                System.err.println("Error setting up search properties");
                return;
            }
            catch (WrappedTargetException wte) {
                System.err.println("Error setting up search properties");
                return;
            }
            catch (IllegalArgumentException iae) {
                System.err.println("Error setting up search properties");
                return;
            }
            descriptor.setSearchString(this.searchKey);
            descriptor.setReplaceString(this.searchKey);
            replaceable.replaceAll((XSearchDescriptor)descriptor);
        }
    }

    public void disposing(EventObject o) {
    }

    private boolean tryLoadingLibrary(XMultiComponentFactory xmcf, XScriptContext context, String name) {
        System.err.println("Try to load ScriptBindingLibrary");
        try {
            Object obj = xmcf.createInstanceWithContext("com.sun.star.script.Application" + name + "LibraryContainer", context.getComponentContext());
            XLibraryContainer xLibraryContainer = (XLibraryContainer)UnoRuntime.queryInterface(XLibraryContainer.class, (Object)obj);
            System.err.println("Got XLibraryContainer");
            Object serviceObj = context.getComponentContext().getValueByName("/singletons/com.sun.star.util.theMacroExpander");
            XMacroExpander xme = (XMacroExpander)AnyConverter.toObject((Type)new Type(XMacroExpander.class), (Object)serviceObj);
            String bootstrapName = "bootstraprc";
            if (System.getProperty("os.name").startsWith("Windows")) {
                bootstrapName = "bootstrap.ini";
            }
            String libURL = xme.expandMacros("$BRAND_BASE_DIR/$BRAND_SHARE_SUBDIR/basic/ScriptBindingLibrary/" + name.toLowerCase() + ".xlb/");
            System.err.println("libURL is: " + libURL);
            xLibraryContainer.createLibraryLink("ScriptBindingLibrary", libURL, false);
            System.err.println("liblink created");
        }
        catch (com.sun.star.uno.Exception e) {
            System.err.println("Got an exception loading lib: " + e.getMessage());
            return false;
        }
        return true;
    }
}

