/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.cli.ruleset;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.islandoftex.arara.api.configuration.ExecutionOptions;
import org.islandoftex.arara.api.files.Project;
import org.islandoftex.arara.api.files.ProjectFile;
import org.islandoftex.arara.api.rules.Directive;
import org.islandoftex.arara.api.rules.DirectiveConditional;
import org.islandoftex.arara.cli.interpreter.Interpreter;
import org.islandoftex.arara.core.session.LinearExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003JC\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\b\u0010\u001d\u001a\u00020\u000bH\u0016J\t\u0010\u001e\u001a\u00020\u000bH\u00d6\u0001J\b\u0010\u001f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lorg/islandoftex/arara/cli/ruleset/DirectiveImpl;", "Lorg/islandoftex/arara/api/rules/Directive;", "identifier", "", "parameters", "", "", "conditional", "Lorg/islandoftex/arara/api/rules/DirectiveConditional;", "lineNumbers", "", "", "(Ljava/lang/String;Ljava/util/Map;Lorg/islandoftex/arara/api/rules/DirectiveConditional;Ljava/util/List;)V", "getConditional", "()Lorg/islandoftex/arara/api/rules/DirectiveConditional;", "getIdentifier", "()Ljava/lang/String;", "getLineNumbers", "()Ljava/util/List;", "getParameters", "()Ljava/util/Map;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "execute", "hashCode", "toString", "cli"})
public final class DirectiveImpl
implements Directive {
    @NotNull
    private final String identifier;
    @NotNull
    private final Map<String, Object> parameters;
    @NotNull
    private final DirectiveConditional conditional;
    @NotNull
    private final List<Integer> lineNumbers;

    public DirectiveImpl(@NotNull String identifier, @NotNull Map<String, ? extends Object> parameters2, @NotNull DirectiveConditional conditional, @NotNull List<Integer> lineNumbers) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(conditional, "conditional");
        Intrinsics.checkNotNullParameter(lineNumbers, "lineNumbers");
        this.identifier = identifier;
        this.parameters = parameters2;
        this.conditional = conditional;
        this.lineNumbers = lineNumbers;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    @NotNull
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    @NotNull
    public DirectiveConditional getConditional() {
        return this.conditional;
    }

    @Override
    @NotNull
    public List<Integer> getLineNumbers() {
        return this.lineNumbers;
    }

    @Override
    public int execute() {
        ExecutionOptions executionOptions = LinearExecutor.INSTANCE.getExecutionOptions();
        ProjectFile projectFile = LinearExecutor.INSTANCE.getCurrentFile();
        Intrinsics.checkNotNull(projectFile);
        Project project = LinearExecutor.INSTANCE.getCurrentProject();
        Intrinsics.checkNotNull(project);
        return new Interpreter(executionOptions, projectFile, project.getWorkingDirectory()).execute(this).getExitCode();
    }

    @NotNull
    public String toString() {
        return "Directive(identifier='" + this.getIdentifier() + "', parameters=" + this.getParameters() + ",conditional=" + this.getConditional() + ", lineNumbers=" + this.getLineNumbers() + ')';
    }

    @NotNull
    public final String component1() {
        return this.getIdentifier();
    }

    @NotNull
    public final Map<String, Object> component2() {
        return this.getParameters();
    }

    @NotNull
    public final DirectiveConditional component3() {
        return this.getConditional();
    }

    @NotNull
    public final List<Integer> component4() {
        return this.getLineNumbers();
    }

    @NotNull
    public final DirectiveImpl copy(@NotNull String identifier, @NotNull Map<String, ? extends Object> parameters2, @NotNull DirectiveConditional conditional, @NotNull List<Integer> lineNumbers) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(conditional, "conditional");
        Intrinsics.checkNotNullParameter(lineNumbers, "lineNumbers");
        return new DirectiveImpl(identifier, parameters2, conditional, lineNumbers);
    }

    public static /* synthetic */ DirectiveImpl copy$default(DirectiveImpl directiveImpl, String string, Map map, DirectiveConditional directiveConditional, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = directiveImpl.getIdentifier();
        }
        if ((n & 2) != 0) {
            map = directiveImpl.getParameters();
        }
        if ((n & 4) != 0) {
            directiveConditional = directiveImpl.getConditional();
        }
        if ((n & 8) != 0) {
            list = directiveImpl.getLineNumbers();
        }
        return directiveImpl.copy(string, map, directiveConditional, list);
    }

    public int hashCode() {
        int result2 = this.getIdentifier().hashCode();
        result2 = result2 * 31 + ((Object)this.getParameters()).hashCode();
        result2 = result2 * 31 + this.getConditional().hashCode();
        result2 = result2 * 31 + ((Object)this.getLineNumbers()).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DirectiveImpl)) {
            return false;
        }
        DirectiveImpl directiveImpl = (DirectiveImpl)other;
        if (!Intrinsics.areEqual(this.getIdentifier(), directiveImpl.getIdentifier())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getParameters(), directiveImpl.getParameters())) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getConditional(), directiveImpl.getConditional())) {
            return false;
        }
        return Intrinsics.areEqual(this.getLineNumbers(), directiveImpl.getLineNumbers());
    }
}

