/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.util.CollectionUtils;

public class HighScore
extends FreeColObject {
    private static final Logger logger = Logger.getLogger(HighScore.class.getName());
    public static final String TAG = "highScore";
    private static final UUID nullUUID = new UUID(0L, 0L);
    public static final Comparator<? super HighScore> descendingScoreComparator = Comparator.comparingInt(HighScore::getScore).reversed();
    public static final int NUMBER_OF_HIGH_SCORES = 10;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
    private int independenceTurn = -1;
    private String playerName;
    private String nationId;
    private String nationTypeId;
    private UUID gameUUID;
    private int score;
    private ScoreLevel level;
    private String nationName;
    private String difficulty;
    private int nUnits;
    private int nColonies;
    private String newLandName;
    private Date date;
    private int retirementTurn;
    private static final String HIGH_SCORES_TAG = "highScores";
    private static final String COLONIES_TAG = "colonies";
    private static final String DATE_TAG = "date";
    private static final String DIFFICULTY_TAG = "difficulty";
    private static final String GAMEUUID_TAG = "gameUUID";
    private static final String INDEPENDENCE_TURN_TAG = "independenceTurn";
    private static final String LEVEL_TAG = "level";
    private static final String NATION_ID_TAG = "nationId";
    private static final String NATION_NAME_TAG = "nationName";
    private static final String NATION_TYPE_ID_TAG = "nationTypeId";
    private static final String NEW_LAND_NAME_TAG = "newLandName";
    private static final String PLAYER_NAME_TAG = "playerName";
    private static final String RETIREMENT_TURN_TAG = "retirementTurn";
    private static final String SCORE_TAG = "score";
    private static final String UNITS_TAG = "units";

    public HighScore() {
    }

    public HighScore(Player player) {
        Game game = player.getGame();
        this.date = new Date();
        this.retirementTurn = game.getTurn().getNumber();
        this.gameUUID = game.getUUID();
        this.score = player.getScore();
        this.level = CollectionUtils.find(ScoreLevel.values(), sl -> sl.getMinimumScore() <= this.score, ScoreLevel.PARASITIC_WORM);
        this.playerName = player.getName();
        this.nationId = player.getNationId();
        this.nationTypeId = player.getNationType().getId();
        this.nColonies = CollectionUtils.count(player.getColonies());
        this.nUnits = player.getUnitCount();
        this.independenceTurn = player.getPlayerType() == Player.PlayerType.INDEPENDENT ? game.getTurn().getNumber() : -1;
        this.nationName = Messages.message(player.getNationLabel());
        this.difficulty = game.getSpecification().getDifficultyLevel();
        this.newLandName = player.getNewLandName();
    }

    public HighScore(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public final int getIndependenceTurn() {
        return this.independenceTurn;
    }

    public final int getRetirementTurn() {
        return this.retirementTurn;
    }

    public final String getPlayerName() {
        return this.playerName;
    }

    public final String getNationId() {
        return this.nationId;
    }

    public final String getNationTypeId() {
        return this.nationTypeId;
    }

    public final UUID getGameUUID() {
        return this.gameUUID;
    }

    public final int getScore() {
        return this.score;
    }

    public final ScoreLevel getLevel() {
        return this.level;
    }

    public final String getOldNationNameKey() {
        return Messages.nameKey(this.nationId);
    }

    public final String getNationName() {
        return this.nationName;
    }

    public final String getNewLandName() {
        return this.newLandName;
    }

    public final String getDifficulty() {
        return this.difficulty;
    }

    public final int getUnitCount() {
        return this.nUnits;
    }

    public final int getColonyCount() {
        return this.nColonies;
    }

    public final Date getDate() {
        return new Date(this.date.getTime());
    }

    public final String getDateString() {
        DateFormat format = DateFormat.getDateTimeInstance(2, 3);
        return format.format(this.date);
    }

    private static void tidyScores(List<HighScore> scores) {
        if (scores.size() > 10) {
            scores = scores.subList(0, 9);
        }
        scores.sort(descendingScoreComparator);
    }

    public static int checkHighScore(HighScore highScore, List<HighScore> scores) {
        int nScores = scores.size();
        int score = highScore.getScore();
        UUID uuid = highScore.getGameUUID();
        if (uuid.compareTo(nullUUID) != 0) {
            for (int i = nScores - 1; i >= 0; --i) {
                HighScore hs = scores.get(i);
                if (uuid.compareTo(hs.getGameUUID()) != 0 || score <= hs.getScore()) continue;
                return i;
            }
        }
        return score >= 0 && (nScores < 10 || score > scores.get(nScores - 1).getScore()) ? nScores - 1 : -1;
    }

    public static boolean newHighScore(Player player) {
        HighScore hs = new HighScore(player);
        List<HighScore> scores = HighScore.loadHighScores();
        int idx = HighScore.checkHighScore(hs, scores);
        if (idx < 0) {
            return false;
        }
        if (idx < scores.size()) {
            scores.set(idx, hs);
        } else {
            scores.add(hs);
        }
        HighScore.tidyScores(scores);
        return HighScore.saveHighScores(scores);
    }

    public static List<HighScore> loadHighScores() {
        ArrayList<HighScore> scores = new ArrayList<HighScore>();
        File hsf = FreeColDirectories.getHighScoreFile();
        if (!hsf.exists()) {
            try {
                if (hsf.createNewFile()) {
                    logger.info("Created empty high score file: " + hsf.getPath());
                    HighScore.saveHighScores(scores);
                } else {
                    logger.warning("High score file not created");
                }
            }
            catch (IOException ioe) {
                scores = null;
                logger.log(Level.WARNING, "Unable to create high score file: " + hsf.getPath(), ioe);
            }
            return scores;
        }
        try (InputStream fis = Files.newInputStream(hsf.toPath(), new OpenOption[0]);){
            try (FreeColXMLReader xr = new FreeColXMLReader(fis);){
                xr.nextTag();
                while (xr.moreTags()) {
                    String tag = xr.getLocalName();
                    if (!TAG.equals(tag)) continue;
                    scores.add(new HighScore(xr));
                }
            }
            catch (XMLStreamException xse) {
                logger.log(Level.WARNING, "Stream error loading high scores.", xse);
            }
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "I/O error loading high scores.", ioe);
        }
        HighScore.tidyScores(scores);
        return scores;
    }

    public static boolean saveHighScores(List<HighScore> scores) {
        boolean ret = false;
        if (scores == null) {
            return false;
        }
        HighScore.tidyScores(scores);
        File hsf = FreeColDirectories.getHighScoreFile();
        try (OutputStream fos = Files.newOutputStream(hsf.toPath(), new OpenOption[0]);
             FreeColXMLWriter xw = new FreeColXMLWriter(fos, FreeColXMLWriter.WriteScope.toSave(), true);){
            xw.writeStartDocument("UTF-8", "1.0");
            xw.writeStartElement(HIGH_SCORES_TAG);
            for (HighScore score : scores) {
                score.toXML(xw);
            }
            xw.writeEndElement();
            xw.writeEndDocument();
            ret = true;
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Error creating FreeColXMLWriter.", ioe);
        }
        catch (XMLStreamException xse) {
            logger.log(Level.WARNING, "Failed to write high scores file.", xse);
        }
        return ret;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        HighScore o = this.copyInCast(other, HighScore.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.independenceTurn = o.getIndependenceTurn();
        this.playerName = o.getPlayerName();
        this.nationId = o.getNationId();
        this.nationTypeId = o.getNationTypeId();
        this.gameUUID = o.getGameUUID();
        this.score = o.getScore();
        this.level = o.getLevel();
        this.nationName = o.getNationName();
        this.difficulty = o.getDifficulty();
        this.nUnits = o.getUnitCount();
        this.nColonies = o.getColonyCount();
        this.newLandName = o.getNewLandName();
        this.date = o.getDate();
        this.retirementTurn = o.getRetirementTurn();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        long l = this.date.getTime();
        xw.writeAttribute(DATE_TAG, l);
        xw.writeAttribute(RETIREMENT_TURN_TAG, this.retirementTurn);
        xw.writeAttribute(INDEPENDENCE_TURN_TAG, this.independenceTurn);
        xw.writeAttribute(PLAYER_NAME_TAG, this.playerName);
        xw.writeAttribute(NATION_ID_TAG, this.nationId);
        xw.writeAttribute(NATION_TYPE_ID_TAG, this.nationTypeId);
        xw.writeAttribute(GAMEUUID_TAG, this.gameUUID);
        xw.writeAttribute(SCORE_TAG, this.score);
        xw.writeAttribute(LEVEL_TAG, this.level.toString());
        if (this.nationName != null) {
            xw.writeAttribute(NATION_NAME_TAG, this.nationName);
        }
        if (this.newLandName != null) {
            xw.writeAttribute(NEW_LAND_NAME_TAG, this.newLandName);
        }
        xw.writeAttribute(DIFFICULTY_TAG, this.difficulty);
        xw.writeAttribute(UNITS_TAG, this.nUnits);
        xw.writeAttribute(COLONIES_TAG, this.nColonies);
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        this.date = null;
        try {
            long l = xr.getAttribute(DATE_TAG, -1L);
            if (l >= 0L) {
                this.date = new Date(l);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Bad long date", e);
        }
        if (this.date == null) {
            try {
                float f = xr.getAttribute(DATE_TAG, -1.0f);
                if ((double)f >= 0.0 && f < 9.223372E18f) {
                    this.date = new Date((long)f);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Bad float date", e);
            }
        }
        if (this.date == null) {
            this.date = new Date();
        }
        this.retirementTurn = xr.getAttribute(RETIREMENT_TURN_TAG, 0);
        this.independenceTurn = xr.getAttribute(INDEPENDENCE_TURN_TAG, 0);
        this.playerName = xr.getAttribute(PLAYER_NAME_TAG, "anonymous");
        this.nationId = xr.getAttribute(NATION_ID_TAG, null);
        this.nationTypeId = xr.getAttribute(NATION_TYPE_ID_TAG, null);
        String str = xr.getAttribute(GAMEUUID_TAG, null);
        try {
            this.gameUUID = UUID.fromString(str);
        }
        catch (Exception e) {
            this.gameUUID = nullUUID;
        }
        this.score = xr.getAttribute(SCORE_TAG, 0);
        this.level = xr.getAttribute(LEVEL_TAG, ScoreLevel.class, ScoreLevel.PARASITIC_WORM);
        this.nationName = xr.getAttribute(NATION_NAME_TAG, "Freedonia");
        this.newLandName = xr.getAttribute(NEW_LAND_NAME_TAG, "New World");
        this.difficulty = xr.getAttribute(DIFFICULTY_TAG, FreeCol.getDifficulty());
        this.nUnits = xr.getAttribute(UNITS_TAG, 0);
        this.nColonies = xr.getAttribute(COLONIES_TAG, 0);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    public static enum ScoreLevel {
        CONTINENT(40000),
        COUNTRY(35000),
        STATE(30000),
        CITY(25000),
        MOUNTAIN_RANGE(20000),
        RIVER(15000),
        INSTITUTE(12000),
        UNIVERSITY(10000),
        STREET(8000),
        SCHOOL(7000),
        BIRD_OF_PREY(6000),
        TREE(5000),
        FLOWER(4000),
        RODENT(3200),
        FOUL_SMELLING_PLANT(2400),
        POISONOUS_PLANT(1600),
        SLIME_MOLD_BEETLE(800),
        BLOOD_SUCKING_INSECT(400),
        INFECTIOUS_DISEASE(200),
        PARASITIC_WORM(0);

        private final int minimumScore;

        private ScoreLevel(int minimumScore) {
            this.minimumScore = minimumScore;
        }

        public int getMinimumScore() {
            return this.minimumScore;
        }
    }
}

